//
// $Id: cmdline.cc,v 1.3 2002/11/13 03:05:06 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/cmdline.cc,v $
// $Revision: 1.3 $
// $Date: 2002/11/13 03:05:06 $
// $State: Exp $
//
// Cmdline: a class for parsing commandline arguments
// Author:  Niklas Fondberg<nfx3@sourceforge.net>
// Note:    Modified code auto created by 
//          genparse v0.5.1 (http://genparse.sourceforge.net)
//

#include <unistd.h>
#include <stdlib.h>
#ifdef Linux
#include <getopt.h>
#endif
#include "cmdline.h"


// constructor
Cmdline::Cmdline(int argc, char *argv[]) throw (string)
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  int c;

#ifdef Linux
  /* const char *name, int has_arg, int *flag, int val */
  static struct option long_options[] =
  {
    { "seconds",   1, NULL, 's' },
    { "outfile",   1, NULL, 'o' },
    { "test",      0, NULL, 't' },
    { "checkconf", 0, NULL, 'C' },
    { "conffile",  1, NULL, 'c' },
    { "help",      0, NULL, 'h' },
    { "version",   0, NULL, 'v' },
    { NULL,        0, NULL,  0  }
  };
#endif

  _executable += argv[0];
  _argc = argc;

  /* default values */
  _s = 0;
  _t = false;
  _C = false;
  _h = false;
  _v = false;

#ifdef Linux
  while ((c = getopt_long(argc, argv, "s:o:tCc:hv", long_options, &option_index)) != EOF)
#else
  while ((c = getopt(argc, argv, "s:o:tCc:hv")) != EOF)
#endif
    {
      switch(c)
        {
        case 's': 
          _s = atoi(optarg);
          break;

        case 'o': 
          _o = optarg;
          break;

        case 't': 
          _t = true;
          break;

        case 'C': 
          _C = true;
          break;

        case 'c': 
          _c = optarg;
          break;

        case 'h': 
          _h = true;
          this->usage();
          break;

        case 'v': 
          _v = true;
          break;

        default:
          this->usage();
        }
    }

  _optind = optind;
}

// display usage
void Cmdline::usage()
{
#ifdef Linux
  cout << "usage: " << _executable << " [ -sotCchv ] " << endl;
  cout << "  [ -s ]  [ --seconds ]   Number of seconds to run. " << endl;
  cout << "  [ -o ]  [ --outfile ]   Output result file. " << endl;
  cout << "  [ -t ]  [ --test ]      Test the scenarios in the conf file " << endl;
  cout << "  [ -C ]  [ --checkconf ] Check config file " << endl;
  cout << "  [ -c ]  [ --conffile ]  Config file path " << endl;
  cout << "  [ -h ]  [ --help ]      Display help information. " << endl;
  cout << "  [ -v ]  [ --version ]   Output version. " << endl;
#else
  cout << "usage: " << _executable << " [ -sotCchv ] " << endl;
  cout << "  [ -s ]     Number of seconds to run. " << endl;
  cout << "  [ -o ]     Output result file. " << endl;
  cout << "  [ -t ]     Test the scenarios in the conf file " << endl;
  cout << "  [ -C ]     Check config file " << endl;
  cout << "  [ -c ]     Config file path " << endl;
  cout << "  [ -h ]     Display help information. " << endl;
  cout << "  [ -v ]     Output version. " << endl;
#endif
  exit(0);
}

