/*
 * Groach properties header
 * Currently, property is only theme name.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_PROPERTIES_H__
#define __GRO_PROPERTIES_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* gnome-config keys */
#define THEME_NAME_KEY				"theme_name"


/* Data structure definition */
typedef struct _GroachPropPrivate GroachPropPrivate;

struct _GroachProp {
	char *theme_name;	/* Theme name.
						   Theme directory name is also acceptable. */
	GroachPropPrivate *privat;
};

/* Global function declarations */
extern GroachProp* properties_new(void);
extern void properties_delete(GroachProp *groach_prop);
extern void properties_load(GroachProp *groach_prop, const char *path);
extern void properties_save(GroachProp *groach_prop, const char *path);

extern void property_cb(AppletWidget *widget, gpointer data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_PROPERTIES_H__ */
