/*************************************************************************/
/*                                                                       */
/*                  Language Technologies Institute                      */
/*                     Carnegie Mellon University                        */
/*                        Copyright (c) 2001                             */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission is hereby granted, free of charge, to use and distribute  */
/*  this software and its documentation without restriction, including   */
/*  without limitation the rights to use, copy, modify, merge, publish,  */
/*  distribute, sublicense, and/or sell copies of this work, and to      */
/*  permit persons to whom this work is furnished to do so, subject to   */
/*  the following conditions:                                            */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*   4. The authors' names are not used to endorse or promote products   */
/*      derived from this software without specific prior written        */
/*      permission.                                                      */
/*                                                                       */
/*  CARNEGIE MELLON UNIVERSITY AND THE CONTRIBUTORS TO THIS WORK         */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL CARNEGIE MELLON UNIVERSITY NOR THE CONTRIBUTORS BE LIABLE      */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author:  Alan W Black (awb@cs.cmu.edu)                    */
/*                      Kevin A. Lenzo (lenzo@cs.cmu.edu)                */
/*               Date:  January 2001                                     */
/*************************************************************************/
/*                                                                       */
/*  CMU Lexicon phone definitions                                        */
/*                                                                       */
/*************************************************************************/
/*******************************************************/
/**  Autogenerated lexicon phones file from cmu    */
/*******************************************************/

#include "cst_lexicon.h"
const unsigned char cmu_lex_phones[] = 
{
      1,   0,  /* "a" 2 */
      1,   0,  /* "a" 4 */
      3,   4,   5,   6,   1,   7,   2,   0,  /* "aaa" 12 */
      8,   9,  10,  11,   0,  /* "aaberg" 17 */
      8,  12,   1,  13,   0,  /* "aachen" 22 */
      8,  12,  10,   0,  /* "aaker" 26 */
      8,   7,  14,  15,  16,   0,  /* "aalseth" 32 */
      8,  17,   1,   3,   0,  /* "aamodt" 37 */
      8,  13,  12,  18,   4,   0,  /* "aancor" 43 */
     19,   4,  20,  21,  17,   1,   0,  /* "aardema" 50 */
      8,   4,  20,  22,   8,   4,  12,   0,  /* "aardvark" 58 */
     21,   4,   1,  13,  14,   1,  13,   0,  /* "aaronson" 66 */
      8,   4,   3,  23,   0,  /* "aarti" 71 */
      8,  14,   0,  /* "aase" 74 */
      8,  14,   1,  13,   0,  /* "aasen" 79 */
     24,   9,   0,  /* "ab" 82 */
      1,   9,   8,   9,   1,   0,  /* "ababa" 88 */
     24,   9,   1,  12,   1,   0,  /* "abacha" 94 */
     24,   9,   1,  12,  25,   0,  /* "abaco" 100 */
     24,   9,   1,  12,   1,  14,   0,  /* "abacus" 107 */
      1,   9,   8,  20,   0,  /* "abad" 112 */
      1,   9,  24,  20,   1,  12,   1,   0,  /* "abadaka" 120 */
      1,   9,  24,  20,  26,   0,  /* "abadi" 126 */
      1,   9,  24,  20,  26,   0,  /* "abadie" 132 */
      1,   9,   8,   7,  12,   1,  13,   0,  /* "abalkin" 140 */
     24,   9,   1,   7,  25,  13,  26,   0,  /* "abalone" 148 */
      1,   9,   8,   4,  12,   1,   0,  /* "abarca" 155 */
     19,   9,   8,   4,  26,   0,  /* "abare" 161 */
     24,   9,   1,  14,  12,   1,   7,   0,  /* "abascal" 169 */
      1,   9,   2,   3,  17,   1,  13,   3,   0,  /* "abatement" 178 */
      1,   9,   2,   3,  17,   1,  13,   3,  14,   0,  /* "abatements" 188 */
     24,   9,   1,   0,  /* "abba" 192 */
      1,   9,   8,  20,  27,   0,  /* "abbado" 198 */
      1,   9,   8,  14,   0,  /* "abbas" 203 */
     19,   9,   8,  14,  26,   0,  /* "abbasi" 209 */
      8,   9,  28,   3,   0,  /* "abbate" 214 */
     19,   9,  19,   3,  26,  21,   7,  27,   0,  /* "abbatiello" 223 */
     24,   9,  26,   0,  /* "abbe" 227 */
      1,   9,  21,   3,   0,  /* "abbett" 232 */
     24,   9,  26,   0,  /* "abbie" 236 */
     24,   9,   1,   3,   0,  /* "abbitt" 241 */
     24,   9,   1,   3,   0,  /* "abbot" 246 */
      1,   9,  29,  20,   0,  /* "abboud" 251 */
      1,   9,   4,  23,  22,  26,   2,   3,   0,  /* "abbreviate" 260 */
     19,   9,   4,  29,   3,  14,   2,  30,  26,   0,  /* "abbruzzese" 270 */
     24,   9,  30,   0,  /* "abbs" 274 */
     24,   9,  26,   0,  /* "abby" 278 */
     24,   9,  12,  27,   0,  /* "abco" 283 */
     24,   9,  20,  21,   7,   0,  /* "abdel" 289 */
     24,   9,  20,  31,  12,   2,   3,  31,  32,   0,  /* "abdicating" 299 */
     24,   9,  20,  31,  12,   2,  33,   1,  13,   0,  /* "abdication" 309 */
     24,   9,  20,  27,   0,  /* "abdo" 314 */
     34,   9,  20,  25,  17,   1,  13,   0,  /* "abdomen" 322 */
     34,   9,  20,   8,  17,   1,  13,   1,   7,   0,  /* "abdominal" 332 */
     34,   9,  20,  29,   7,   0,  /* "abdul" 338 */
     34,   9,  20,  29,   7,   1,  30,  23,  30,   0,  /* "abdulaziz" 348 */
     19,   9,  20,  29,   7,   1,   0,  /* "abdulla" 355 */
     24,   9,  20,  35,   7,   1,   0,  /* "abdullah" 362 */
      2,   9,   0,  /* "abe" 365 */
      1,   9,  21,  20,   0,  /* "abed" 370 */
      1,   9,  23,   0,  /* "abee" 374 */
      2,   9,   1,   7,   0,  /* "abel" 379 */
     19,   9,  21,   7,   1,   0,  /* "abela" 385 */
     24,   9,   1,   7,  10,  20,   0,  /* "abelard" 392 */
      1,   9,  23,   7,   0,  /* "abele" 397 */
      1,   9,  23,   7,  30,   0,  /* "abeles" 403 */
      2,   9,   1,   7,   0,  /* "abell" 408 */
      1,   9,  21,   7,   1,   0,  /* "abella" 414 */
     24,   9,  15,   7,  13,   0,  /* "abeln" 420 */
      2,   9,   1,   7,  30,   0,  /* "abels" 426 */
     24,   9,  15,  13,  20,   0,  /* "abend" 432 */
     24,   9,   1,  13,  20,   4,  36,  16,   0,  /* "abendroth" 441 */
      2,   9,  10,   0,  /* "aber" 445 */
      2,   9,  10,  37,  10,  20,   0,  /* "aberford" 452 */
     24,   9,  10,   1,   7,   0,  /* "aberle" 458 */
     24,   9,  10,  13,  24,  16,  26,   0,  /* "abernathy" 466 */
     34,   9,  21,   4,   1,  13,   3,   0,  /* "aberrant" 474 */
     24,   9,  10,   2,  33,   1,  13,   0,  /* "aberration" 482 */
     24,   9,  10,   2,  33,   1,  13,   1,   7,   0,  /* "aberrational" 492 */
     24,   9,  10,   2,  33,   1,  13,  30,   0,  /* "aberrations" 501 */
      1,   9,  21,   3,   0,  /* "abet" 506 */
      2,   9,  15,  12,  14,   0,  /* "abex" 512 */
     19,   9,   2,   3,   1,   0,  /* "abeyta" 518 */
     34,   9,  38,  18,   4,   0,  /* "abhor" 524 */
      1,   9,  38,  18,   4,  20,   0,  /* "abhorred" 531 */
      1,   9,  38,  18,   4,   1,  13,  14,   0,  /* "abhorrence" 540 */
     34,   9,  38,  18,   4,   1,  13,   3,   0,  /* "abhorrent" 549 */
      1,   9,  38,  18,   4,  30,   0,  /* "abhors" 556 */
      2,   9,   1,  20,   0,  /* "abid" 561 */
      1,   9,  39,  20,   0,  /* "abide" 566 */
      1,   9,  39,  20,   1,  20,   0,  /* "abided" 573 */
      1,   9,  39,  20,  30,   0,  /* "abides" 579 */
      1,   9,  39,  20,  31,  32,   0,  /* "abiding" 586 */
     24,   9,  26,   0,  /* "abie" 590 */
     19,   9,  23,   7,   1,   0,  /* "abila" 596 */
     24,   9,   1,   7,  23,  13,   0,  /* "abilene" 603 */
     24,   9,  31,  32,   3,   1,  13,   0,  /* "abington" 611 */
      8,   9,  26,  27,   0,  /* "abio" 616 */
     28,   9,  23,   1,  17,  15,  20,   0,  /* "abiomed" 624 */
     24,   9,  40,  15,  12,   3,   0,  /* "abject" 631 */
     34,   9,  40,  21,  12,   3,   0,  /* "abject" 638 */
     34,   9,  12,  38,   8,  30,  41,   1,   0,  /* "abkhazia" 647 */
      1,   9,   7,   2,  30,   0,  /* "ablaze" 653 */
      2,   9,   1,   7,   0,  /* "able" 658 */
      2,   9,   1,   7,  20,   0,  /* "abled" 664 */
      2,   9,   1,   7,  10,   0,  /* "abler" 670 */
      2,   9,   1,   7,  30,   0,  /* "ables" 676 */
      2,   9,   7,   1,  14,   3,   0,  /* "ablest" 683 */
      1,   9,   7,  29,  17,   0,  /* "abloom" 689 */
      2,   9,   7,  26,   0,  /* "ably" 694 */
     34,   9,  13,  18,   4,  17,   1,   7,   0,  /* "abnormal" 703 */
     24,   9,  13,  36,   4,  17,  24,   7,   1,   3,  26,  30,   0,  /* "abnormalities" 716 */
     24,   9,  13,  36,   4,  17,  24,   7,   1,   3,  26,   0,  /* "abnormality" 728 */
     34,   9,  13,  18,   4,  17,   1,   7,  26,   0,  /* "abnormally" 738 */
      8,   9,  27,   0,  /* "abo" 742 */
      1,   9,   8,   7,   5,  33,   0,  /* "abolish" 749 */
      1,   9,   8,   7,   5,  33,   3,   0,  /* "abolished" 757 */
      1,   9,   8,   7,   5,  33,   1,  30,   0,  /* "abolishes" 766 */
      1,   9,   8,   7,   5,  33,  31,  32,   0,  /* "abolishing" 775 */
     24,   9,   1,   7,   5,  33,   1,  13,   5,  30,   1,  17,   0,  /* "abolitionism" 788 */
      1,   9,   8,  17,   1,  13,   1,   9,   1,   7,   0,  /* "abominable" 799 */
      1,   9,  29,  20,   0,  /* "abood" 804 */
      1,   9,  29,  20,  26,   0,  /* "aboodi" 810 */
     24,   9,  10,   5,  40,   1,  13,   1,   7,   0,  /* "aboriginal" 820 */
     24,   9,  10,   5,  40,   1,  13,  26,   0,  /* "aborigine" 829 */
     24,   9,  10,   5,  40,   1,  13,  26,  30,   0,  /* "aborigines" 839 */
      1,   9,  18,   4,  13,   0,  /* "aborn" 845 */
      1,   9,  18,   4,   3,   1,  37,   2,  33,   1,  13,   3,   0,  /* "abortifacient" 858 */
      1,   9,  18,   4,   3,   1,  37,   2,  33,   1,  13,   3,  14,   0,  /* "abortifacients" 872 */
      1,   9,  29,   0,  /* "abou" 876 */
     19,   9,  29,  20,   0,  /* "aboud" 881 */
      8,   9,  29,  38,  19,   7,  23,  17,   1,   0,  /* "abouhalima" 891 */
      1,   9,  35,  22,   0,  /* "above" 896 */
      1,   9,  35,  22,   9,  18,   4,  20,   0,  /* "aboveboard" 905 */
     24,   9,   6,   7,   1,  13,  34,   7,   6,   0,  /* "abplanalp" 915 */
      8,   9,   4,   1,   0,  /* "abra" 920 */
     24,   9,   4,   1,  12,   1,  20,  24,   9,   4,   1,   0,  /* "abracadabra" 932 */
      2,   9,   4,   1,  38,  24,  17,   0,  /* "abraham" 940 */
     24,   9,   4,   1,  38,   2,  17,  26,   1,  13,   0,  /* "abrahamian" 951 */
      2,   9,   4,   1,  38,  24,  17,  30,   0,  /* "abrahams" 960 */
     34,   9,   4,   1,  38,  24,  17,  14,   1,  13,   0,  /* "abrahamsen" 971 */
      1,   9,   4,  24,  38,   1,  17,  14,   1,  13,   0,  /* "abrahamson" 982 */
      8,   9,   4,   1,  17,  42,  31,  12,   0,  /* "abramczyk" 991 */
     19,   9,   4,   8,  17,  27,   0,  /* "abramo" 998 */
      1,   9,   4,   8,  17,   1,  22,   5,  42,   0,  /* "abramowicz" 1008 */
      2,   9,   4,   1,  17,  30,   0,  /* "abrams" 1015 */
      2,   9,   4,   1,  17,  14,   1,  13,   0,  /* "abramson" 1024 */
      1,   9,   4,   2,  43,   1,  13,   0,  /* "abrasion" 1032 */
      1,   9,   4,   2,  43,   1,  13,  30,   0,  /* "abrasions" 1041 */
      1,   9,   4,  21,  14,   3,   0,  /* "abreast" 1048 */
     19,   9,   4,  21,  11,  27,   0,  /* "abrego" 1055 */
      1,   9,   4,  29,   0,  /* "abreu" 1060 */
      1,   9,   4,   5,  40,   0,  /* "abridge" 1066 */
      1,   9,   4,   5,  40,  20,   0,  /* "abridged" 1073 */
      1,   9,   4,   5,   7,   0,  /* "abril" 1079 */
      1,   9,   4,  18,  20,   0,  /* "abroad" 1085 */
      1,   9,   4,   8,  13,   0,  /* "abron" 1091 */
      1,   9,   4,  35,   6,   3,   0,  /* "abrupt" 1098 */
      1,   9,   4,  35,   6,   3,   7,  26,   0,  /* "abruptly" 1107 */
      1,   9,   4,  35,   6,   3,  13,   1,  14,   0,  /* "abruptness" 1117 */
      2,   9,   4,  29,   3,   1,  13,   0,  /* "abrutyn" 1125 */
     19,   9,   4,  29,   3,  14,   2,  30,  26,   0,  /* "abruzzese" 1135 */
     19,   9,   4,  29,  30,  27,   0,  /* "abruzzo" 1142 */
      2,   9,  23,  21,  14,   0,  /* "abs" 1148 */
     24,   9,  14,   1,  13,   3,   0,  /* "absent" 1155 */
      1,   9,  14,  21,  13,   3,   0,  /* "absent" 1162 */
     24,   9,  14,   1,  13,   3,  23,   0,  /* "absentee" 1170 */
     24,   9,  14,   1,  13,   3,  23,   5,  30,   1,  17,   0,  /* "absenteeism" 1182 */
     34,   9,  14,  21,  13,  33,   1,   0,  /* "absentia" 1190 */
     24,   9,  33,  39,   4,   0,  /* "abshire" 1196 */
     24,   9,  14,  27,   0,  /* "abso" 1201 */
     24,   9,  14,   1,   7,   1,  17,   0,  /* "absolom" 1209 */
     24,   9,  14,   1,   7,  29,   3,   0,  /* "absolut" 1217 */
     24,   9,  14,   1,   7,  29,   3,   0,  /* "absolute" 1225 */
     24,   9,  14,   1,   7,  29,   3,   7,  26,   0,  /* "absolutely" 1235 */
     24,   9,  14,   1,   7,  29,   3,  13,   1,  14,   0,  /* "absoluteness" 1246 */
     24,   9,  14,   1,   7,  29,   3,  14,   0,  /* "absolutes" 1255 */
     24,   9,  14,   1,   7,  29,  33,   1,  13,   0,  /* "absolution" 1265 */
     24,   9,  14,   1,   7,  29,   3,   5,  30,   1,  17,   0,  /* "absolutism" 1277 */
     34,   9,  14,   1,   7,  29,   3,   1,  14,   3,   0,  /* "absolutist" 1288 */
      1,   9,  30,   8,   7,  22,   0,  /* "absolve" 1295 */
      1,   9,  30,   8,   7,  22,  20,   0,  /* "absolved" 1303 */
      1,   9,  30,   8,   7,  22,  30,   0,  /* "absolves" 1311 */
      1,   9,  30,   8,   7,  22,  31,  32,   0,  /* "absolving" 1320 */
      1,   9,  30,  18,   4,   9,   1,  13,   3,   0,  /* "absorbent" 1330 */
      1,   9,  30,  18,   4,   6,  33,   1,  13,   0,  /* "absorption" 1340 */
      1,   9,  14,   3,  21,  13,  42,   1,  13,   0,  /* "abstention" 1350 */
      1,   9,  14,   3,  21,  13,  42,   1,  13,  30,   0,  /* "abstentions" 1361 */
     24,   9,  14,   3,   1,  13,   1,  13,  14,   0,  /* "abstinence" 1371 */
     24,   9,  14,   3,   1,  13,   1,  13,   3,   0,  /* "abstinent" 1381 */
     24,   9,  14,   3,   1,  13,   0,  /* "abston" 1388 */
     24,   9,  14,   3,   4,  34,  12,   3,   0,  /* "abstract" 1397 */
     34,   9,  14,   3,   4,  24,  12,   3,   0,  /* "abstract" 1406 */
     24,   9,  14,   3,   4,  24,  12,   3,   1,  20,   0,  /* "abstracted" 1417 */
     34,   9,  14,   3,   4,  24,  12,  33,   1,  13,   0,  /* "abstraction" 1428 */
     34,   9,  14,   3,   4,  24,  12,  33,   1,  13,  30,   0,  /* "abstractions" 1440 */
     24,   9,  14,   3,   4,  34,  12,   3,  14,   0,  /* "abstracts" 1450 */
      1,   9,  14,   3,   4,  24,  12,   3,  14,   0,  /* "abstracts" 1460 */
      1,   9,  14,   3,   4,  29,  14,   0,  /* "abstruse" 1468 */
      1,   9,  14,  44,  20,   0,  /* "absurd" 1474 */
      1,   9,  14,  44,  20,   5,  14,   3,   0,  /* "absurdist" 1483 */
      1,   9,  14,  44,  20,   1,   3,  26,  30,   0,  /* "absurdities" 1493 */
      1,   9,  14,  44,  20,   1,   3,  26,   0,  /* "absurdity" 1502 */
      1,   9,  14,  44,  20,   7,  26,   0,  /* "absurdly" 1510 */
     24,   9,   3,   0,  /* "abt" 1514 */
     24,   9,   3,  14,   0,  /* "abts" 1519 */
     24,   9,  29,   0,  /* "abu" 1523 */
     24,   9,  41,  29,   7,  24,  20,  30,  26,   0,  /* "abuladze" 1533 */
      1,   9,  45,   4,   3,  25,   0,  /* "aburto" 1540 */
      1,   9,  41,  29,  14,   0,  /* "abuse" 1546 */
      1,   9,  41,  29,  30,   0,  /* "abuse" 1552 */
      1,   9,  41,  29,  30,  20,   0,  /* "abused" 1559 */
      1,   9,  41,  29,  30,  10,   0,  /* "abuser" 1566 */
      1,   9,  41,  29,  30,  10,  30,   0,  /* "abusers" 1574 */
      1,   9,  41,  29,  14,   1,  30,   0,  /* "abuses" 1582 */
      1,   9,  41,  29,  30,  31,  30,   0,  /* "abuses" 1590 */
      1,   9,  41,  29,  30,  31,  32,   0,  /* "abusing" 1598 */
      1,   9,  41,  29,  14,  31,  22,   0,  /* "abusive" 1606 */
      1,   9,  35,   3,   0,  /* "abut" 1611 */
      1,   9,   5,  30,  17,   1,   7,   0,  /* "abysmal" 1619 */
      1,   9,   5,  30,  17,   1,   7,  26,   0,  /* "abysmally" 1628 */
      1,   9,   5,  14,   0,  /* "abyss" 1633 */
     24,   9,  30,  35,  11,   0,  /* "abzug" 1639 */
      2,  14,  23,   0,  /* "ac" 1643 */
     24,  12,   1,   0,  /* "aca" 1647 */
      1,  12,   2,  33,   1,   0,  /* "acacia" 1653 */
     24,  12,   1,  20,  21,  17,  31,  12,   7,  26,   0,  /* "academically" 1664 */
     24,  12,   1,  20,   1,  17,   5,  33,   1,  13,   0,  /* "academician" 1675 */
     24,  12,   1,  20,   1,  17,   5,  33,   1,  13,  30,   0,  /* "academicians" 1687 */
      1,  12,  24,  20,   1,  17,  26,  30,   0,  /* "academies" 1696 */
      1,  12,  24,  20,   1,  17,  26,   0,  /* "academy" 1704 */
      1,  12,   2,  20,  26,   1,   0,  /* "acadia" 1711 */
      1,  12,  24,  17,   6,  10,   1,   0,  /* "acampora" 1719 */
     19,  12,   8,  13,  46,   1,   0,  /* "acantha" 1726 */
     24,  12,   1,   6,  45,   7,  12,  27,   0,  /* "acapulco" 1735 */
     19,  12,   8,   4,  20,  26,   0,  /* "accardi" 1742 */
     19,  12,   8,   4,  20,  27,   0,  /* "accardo" 1749 */
      1,  12,  14,  21,   7,   0,  /* "accel" 1755 */
     24,  12,  14,  21,   7,  10,   2,  33,   1,  13,   0,  /* "acceleration" 1766 */
     24,  12,  14,  15,  13,   3,   0,  /* "accent" 1773 */
     34,  12,  14,  21,  13,   3,   0,  /* "accent" 1780 */
     24,  12,  14,  15,  13,   3,   1,  20,   0,  /* "accented" 1789 */
     24,  12,  14,  15,  13,   3,  31,  32,   0,  /* "accenting" 1798 */
     24,  12,  14,  15,  13,   3,  14,   0,  /* "accents" 1806 */
     34,  12,  14,  21,  13,   3,  14,   0,  /* "accents" 1814 */
      1,  12,  14,  21,  13,  42,  29,  28,   3,   0,  /* "accentuate" 1824 */
     34,  12,  14,  21,  13,  42,   1,  47,   2,   3,   1,  20,   0,  /* "accentuated" 1837 */
      1,  12,  14,  21,  13,  42,  29,  28,   3,  14,   0,  /* "accentuates" 1848 */
     34,  12,  14,  21,  13,  42,   1,  47,   2,   3,  31,  32,   0,  /* "accentuating" 1861 */
      1,  12,  14,  21,   6,   3,   1,   9,   5,   7,   1,   3,  26,   0,  /* "acceptability" 1875 */
     34,  12,  14,  21,   6,   3,   1,   9,   1,   7,   0,  /* "acceptable" 1886 */
     24,  12,  14,  21,  14,   0,  /* "access" 1892 */
     24,  12,  14,  21,  14,   3,   0,  /* "accessed" 1899 */
     24,  12,  14,  15,  14,   1,   9,   5,   7,   1,   3,  26,   0,  /* "accessibility" 1912 */
     34,  12,  14,  21,  14,   1,   9,   1,   7,   0,  /* "accessible" 1922 */
     24,  12,  14,  21,  14,  31,  32,   0,  /* "accessing" 1930 */
      1,  12,  14,  21,  33,   1,  13,   0,  /* "accession" 1938 */
     34,  12,  14,  21,  14,  10,  26,  30,   0,  /* "accessories" 1947 */
     34,  12,  14,  21,  14,  10,  39,  30,   0,  /* "accessorize" 1956 */
     34,  12,  14,  21,  14,  10,  39,  30,  20,   0,  /* "accessorized" 1966 */
     34,  12,  14,  21,  14,  10,  26,   0,  /* "accessory" 1974 */
     19,  42,  21,   3,   1,   0,  /* "accetta" 1980 */
     24,  42,  26,   1,  13,   0,  /* "accion" 1986 */
     24,  14,  31,  22,   8,   7,   0,  /* "accival" 1993 */
      1,  12,   7,   2,  17,   0,  /* "acclaim" 1999 */
      1,  12,   7,   2,  17,  20,   0,  /* "acclaimed" 2006 */
      1,  12,   7,   2,  17,  31,  32,   0,  /* "acclaiming" 2014 */
     24,  12,   7,   1,  17,   2,   3,   0,  /* "acclimate" 2022 */
     24,  12,   7,   1,  17,   2,   3,   1,  20,   0,  /* "acclimated" 2032 */
     24,  12,   7,   1,  17,   2,  33,   1,  13,   0,  /* "acclimation" 2042 */
     24,  12,  27,   0,  /* "acco" 2046 */
     19,  12,  25,   7,   1,   0,  /* "accola" 2052 */
     24,  12,   1,   7,   2,  20,   0,  /* "accolade" 2059 */
     24,  12,   1,   7,   2,  20,  30,   0,  /* "accolades" 2067 */
     19,  12,  27,  17,   8,  13,  20,  27,   0,  /* "accomando" 2076 */
      1,  12,   8,  17,   1,  20,   2,   3,  31,  22,   0,  /* "accommodative" 2087 */
      1,  12,  35,  17,   6,   1,  13,   1,  14,   3,   0,  /* "accompanist" 2098 */
      8,  12,   8,  17,   6,   7,  26,   0,  /* "accompli" 2106 */
      1,  12,   8,  17,   6,   7,   1,  14,   1,  30,   0,  /* "accomplices" 2117 */
     24,  12,  18,   4,   0,  /* "accor" 2122 */
      1,  12,  48,  13,   3,   1,   9,   1,   7,   0,  /* "accountable" 2132 */
      1,  12,  48,  13,   3,  21,  17,   6,   0,  /* "accountemp" 2141 */
      1,  12,  29,   3,  10,  17,   1,  13,   3,   0,  /* "accouterment" 2151 */
      1,  12,  29,   3,  10,  17,   1,  13,   3,  14,   0,  /* "accouterments" 2162 */
      1,  12,   4,  21,  20,   1,  20,   2,  33,   1,  13,  30,   0,  /* "accreditations" 2175 */
      1,  12,   4,  29,   0,  /* "accrue" 2180 */
      1,  12,   4,  29,  20,   0,  /* "accrued" 2186 */
      1,  12,   4,  29,  30,   0,  /* "accrues" 2192 */
      1,  12,   4,  29,  31,  32,   0,  /* "accruing" 2199 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,   0,  /* "accumulate" 2210 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,   1,  20,   0,  /* "accumulated" 2223 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,  14,   0,  /* "accumulates" 2235 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,  31,  32,   0,  /* "accumulating" 2248 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,  33,   1,  13,   0,  /* "accumulation" 2261 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,  33,   1,  13,  30,   0,  /* "accumulations" 2275 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,  31,  22,   0,  /* "accumulative" 2288 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,  31,  22,   7,  26,   0,  /* "accumulatively" 2303 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,  10,   0,  /* "accumulator" 2315 */
      1,  12,  41,  29,  17,  41,   1,   7,   2,   3,  10,  30,   0,  /* "accumulators" 2328 */
     24,  12,  41,  10,   1,  14,  26,  30,   0,  /* "accuracies" 2337 */
     24,  12,  41,  10,   1,  14,  26,   0,  /* "accuracy" 2345 */
     24,  12,  41,  10,   1,   3,   0,  /* "accurate" 2352 */
     24,  12,  41,  10,   1,   3,   7,  26,   0,  /* "accurately" 2361 */
     24,  12,  41,  10,   2,   0,  /* "accuray" 2367 */
     24,  12,  41,  10,  39,  20,   0,  /* "accuride" 2374 */
     19,  12,  45,   4,  14,  27,   0,  /* "accurso" 2381 */
     24,  12,  41,   1,  30,   2,  33,   1,  13,   0,  /* "accusation" 2391 */
     24,  12,  41,   1,  30,   2,  33,   1,  13,  30,   0,  /* "accusations" 2402 */
      1,  12,  41,  29,  30,   1,   3,  31,  22,   0,  /* "accusative" 2412 */
      1,  12,  41,  29,  30,   1,   3,  18,   4,  26,   0,  /* "accusatory" 2423 */
      1,  12,  41,  29,  30,   0,  /* "accuse" 2429 */
      1,  12,  41,  29,  30,  20,   0,  /* "accused" 2436 */
      1,  12,  41,  29,  30,  10,   0,  /* "accuser" 2443 */
      1,  12,  41,  29,  30,  10,  30,   0,  /* "accusers" 2451 */
      1,  12,  41,  29,  30,   1,  30,   0,  /* "accuses" 2459 */
      1,  12,  41,  29,  30,  31,  32,   0,  /* "accusing" 2467 */
      1,  12,  41,  29,  30,  31,  32,   7,  26,   0,  /* "accusingly" 2477 */
     24,  12,  41,  29,   3,   2,  13,   0,  /* "accutane" 2485 */
      2,  14,   0,  /* "ace" 2488 */
      2,  14,   3,   0,  /* "aced" 2492 */
      2,  14,  10,   0,  /* "acer" 2496 */
      1,  14,  21,   4,   9,  31,  12,   0,  /* "acerbic" 2504 */
      1,  14,  21,   4,   1,   0,  /* "acerra" 2510 */
      2,  14,   1,  30,   0,  /* "aces" 2515 */
      1,  14,  23,   3,   1,  17,   5,  13,   1,  37,   1,  13,   0,  /* "acetaminophen" 2528 */
     24,  14,   1,   3,   2,   3,   0,  /* "acetate" 2535 */
      1,  14,  21,   3,  31,  12,   0,  /* "acetic" 2542 */
     19,  14,  21,   3,  27,   0,  /* "aceto" 2548 */
     24,  14,   1,   3,  25,  13,   0,  /* "acetone" 2555 */
      1,  14,  21,   3,   1,   7,  12,  25,   7,  26,  13,   0,  /* "acetylcholine" 2567 */
      1,  14,  21,   3,   1,   7,  23,  13,   0,  /* "acetylene" 2576 */
     34,  14,   1,  22,   2,  20,  27,   0,  /* "acevedo" 2584 */
     19,  14,   2,  22,  15,  14,   0,  /* "aceves" 2591 */
      2,  14,  26,   0,  /* "acey" 2595 */
      2,  12,   0,  /* "ache" 2598 */
     19,  42,   2,   9,  26,   0,  /* "achebe" 2604 */
      1,  42,  23,   0,  /* "achee" 2608 */
      2,  12,  14,   0,  /* "aches" 2612 */
      1,  42,  23,  22,   1,   9,   1,   7,   0,  /* "achievable" 2621 */
      1,  42,  23,  22,  17,   1,  13,   3,   0,  /* "achievement" 2630 */
      1,  42,  23,  22,  17,   1,  13,   3,  14,   0,  /* "achievements" 2640 */
      1,  12,   5,   7,  26,   0,  /* "achille" 2646 */
      1,  12,   5,   7,  26,  30,   0,  /* "achilles" 2653 */
      2,  12,  31,  32,   0,  /* "aching" 2658 */
      8,  38,  17,  15,  20,   0,  /* "achmed" 2664 */
      1,  42,  25,   1,   0,  /* "achoa" 2669 */
      2,  12,  10,   0,  /* "achor" 2673 */
     24,  12,  36,   4,  20,   0,  /* "achord" 2679 */
     24,  12,   3,  15,  13,   9,  10,  11,   0,  /* "achtenberg" 2688 */
      2,  12,  26,   0,  /* "achy" 2692 */
     24,  14,   1,  20,   0,  /* "acid" 2697 */
      1,  14,   5,  20,   1,  37,  39,  20,   0,  /* "acidified" 2706 */
      1,  14,   5,  20,   1,  37,  39,  30,   0,  /* "acidifies" 2715 */
      1,  14,   5,  20,   1,  37,  39,   0,  /* "acidify" 2723 */
     24,  14,   1,  20,   7,  26,   0,  /* "acidly" 2730 */
     24,  14,   1,  20,  25,  14,   1,  14,   0,  /* "acidosis" 2739 */
     24,  14,   1,  20,  30,   0,  /* "acids" 2745 */
     24,  14,   1,  20,  45,   4,  26,   1,   0,  /* "aciduria" 2754 */
     19,  14,   5,   4,  13,  27,   0,  /* "acierno" 2761 */
     24,  12,   0,  /* "ack" 2764 */
     24,  12,   1,   7,  30,   0,  /* "ackles" 2770 */
     34,  12,  13,   8,   7,  31,  40,   1,   9,   1,   7,   0,  /* "acknowledgeable" 2782 */
     24,  12,  17,  26,   0,  /* "acme" 2787 */
     24,  12,  13,  26,   0,  /* "acne" 2792 */
     19,  12,  27,  42,  21,   7,   1,   0,  /* "acocella" 2800 */
     24,  12,  36,  37,   0,  /* "acoff" 2805 */
      1,  12,  18,  11,   0,  /* "acog" 2810 */
     24,  12,   1,   7,  39,   3,   0,  /* "acolyte" 2817 */
     24,  12,   1,   7,  39,   3,  14,   0,  /* "acolytes" 2825 */
      2,  12,  36,   4,  13,   0,  /* "acorn" 2831 */
      2,  12,  36,   4,  13,  30,   0,  /* "acorns" 2838 */
      1,  12,  18,  14,   3,   1,   0,  /* "acosta" 2845 */
      1,  12,  29,  14,   3,  31,  12,   0,  /* "acoustic" 2853 */
      1,  12,  29,  14,   3,  31,  12,   1,   7,   0,  /* "acoustical" 2863 */
      1,  12,  29,  14,   3,  31,  12,   7,  26,   0,  /* "acoustically" 2873 */
      1,  12,  29,  14,   3,  31,  12,  14,   0,  /* "acoustics" 2882 */
      1,  12,  47,   2,  13,   3,   1,  13,  14,  33,   1,   6,   0,  /* "acquaintanceship" 2895 */
     19,  12,  47,  19,  22,  23,  22,   1,   0,  /* "acquaviva" 2904 */
     24,  12,  47,  26,  21,  14,   0,  /* "acquiesce" 2911 */
     24,  12,  47,  26,  21,  14,   3,   0,  /* "acquiesced" 2919 */
     24,  12,  47,  26,  21,  14,   1,  13,  14,   0,  /* "acquiescence" 2929 */
     24,  12,  47,  26,  21,  14,  31,  32,   0,  /* "acquiescing" 2938 */
      1,  12,  47,  39,  10,   0,  /* "acquire" 2944 */
      1,  12,  47,  39,  10,  20,   0,  /* "acquired" 2951 */
      1,  12,  47,  39,  10,  10,   0,  /* "acquirer" 2958 */
      1,  12,  47,  39,  10,  10,  30,   0,  /* "acquirers" 2966 */
      1,  12,  47,  39,  10,  30,   0,  /* "acquires" 2973 */
      1,  12,  47,  39,   4,  31,  32,   0,  /* "acquiring" 2981 */
     24,  12,  47,   1,  30,   5,  33,   1,  13,   0,  /* "acquisition" 2991 */
     24,  12,  47,   1,  30,   5,  33,   1,  13,  30,   0,  /* "acquisitions" 3002 */
      1,  12,  47,   5,  30,   1,   3,  31,  22,   0,  /* "acquisitive" 3012 */
     24,  12,  47,   1,   3,   2,  13,   0,  /* "acquitaine" 3020 */
      1,  12,  47,   5,   3,  14,   0,  /* "acquits" 3027 */
      1,  12,  47,   5,   3,   1,   7,   0,  /* "acquittal" 3035 */
      2,  12,  10,   0,  /* "acre" 3039 */
      2,  12,   4,   1,  40,   0,  /* "acreage" 3045 */
      1,  12,   4,  23,   0,  /* "acree" 3050 */
      2,  12,  10,  30,   0,  /* "acres" 3055 */
     24,  12,   4,  26,   0,  /* "acrey" 3060 */
      8,  12,   4,  26,   0,  /* "acri" 3065 */
     24,  12,   4,   1,  13,   1,  17,   0,  /* "acronym" 3073 */
     24,  12,   4,   1,  13,   1,  17,  30,   0,  /* "acronyms" 3082 */
      1,  12,   4,   8,   6,   1,   7,   1,  14,   0,  /* "acropolis" 3092 */
      1,  12,   4,  18,  14,   0,  /* "across" 3098 */
      1,  12,   4,   5,   7,  31,  12,   0,  /* "acrylic" 3106 */
      1,  12,   4,   5,   7,  31,  12,  14,   0,  /* "acrylics" 3115 */
     24,  12,   3,   0,  /* "act" 3119 */
     24,  12,   3,  31,  11,  36,   7,   0,  /* "actigall" 3127 */
     24,  12,   3,   1,  13,  39,  20,   0,  /* "actinide" 3135 */
     24,  12,  33,   1,  13,   1,   9,   1,   7,   0,  /* "actionable" 3145 */
     24,  12,   3,  31,  22,   2,  30,   0,  /* "activase" 3153 */
     24,  12,   3,  31,  22,   2,   3,   1,  20,   0,  /* "activated" 3163 */
     24,  12,   3,   1,  22,   2,   3,  10,   0,  /* "activator" 3172 */
     24,  12,   3,  31,  22,   5,  30,   1,  17,   0,  /* "activism" 3182 */
     24,  12,   3,  31,  22,   1,  14,   3,   0,  /* "activist" 3191 */
     24,  12,   3,   1,  22,   1,  14,   3,  14,   0,  /* "activists" 3201 */
     34,  12,   3,   5,  22,   1,   3,  26,  30,   0,  /* "activities" 3211 */
     34,  12,   3,   5,  22,   1,   3,  26,   0,  /* "activity" 3220 */
     34,  12,   3,  17,  23,  20,  26,   1,   0,  /* "actmedia" 3229 */
     24,  12,   3,  27,  20,  39,  13,   0,  /* "actodine" 3237 */
     24,  12,   3,  14,   0,  /* "acts" 3242 */
     24,  12,  42,   1,  47,   1,   7,   0,  /* "actual" 3250 */
     24,  12,  42,   1,  47,  24,   7,   1,   3,  26,   0,  /* "actuality" 3261 */
     24,  12,  42,   1,  47,   1,   7,  39,  30,   0,  /* "actualize" 3271 */
     24,  12,  42,   1,  47,   1,   7,  26,   0,  /* "actually" 3280 */
     24,  12,  42,   1,  47,  21,   4,  26,   1,   7,   0,  /* "actuarial" 3291 */
     24,  12,  42,   1,  47,  21,   4,  26,  30,   0,  /* "actuaries" 3301 */
     24,  12,  42,   1,  47,  21,   4,  26,   0,  /* "actuary" 3310 */
     24,  12,  42,   1,  47,   2,   3,   0,  /* "actuate" 3318 */
     24,  12,   3,  41,  29,   2,   3,  10,   0,  /* "actuator" 3327 */
     24,  12,   3,  41,  29,   2,   3,  10,  30,   0,  /* "actuators" 3337 */
      1,  12,  41,  29,   1,   3,  26,   0,  /* "acuity" 3345 */
      1,  12,  41,  29,  17,   1,  13,   0,  /* "acumen" 3353 */
     19,  12,  29,  13,   1,   0,  /* "acuna" 3359 */
     24,  12,  41,  29,   6,  35,  32,  12,  42,  10,   0,  /* "acupuncture" 3370 */
     24,  12,  41,  10,   1,   0,  /* "acura" 3376 */
     24,  12,  41,  10,   1,  30,   0,  /* "acuras" 3383 */
     24,  12,  41,  29,  14,   1,  13,   0,  /* "acuson" 3391 */
     24,  12,  41,  29,  14,   3,   8,   4,   0,  /* "acustar" 3400 */
     24,  12,  41,  29,  14,   5,  14,   3,   0,  /* "acusyst" 3409 */
      1,  12,  41,  29,   3,   0,  /* "acute" 3415 */
      1,  12,  41,  29,   3,   7,  26,   0,  /* "acutely" 3423 */
      1,  12,  41,  29,   3,  13,   1,  14,   0,  /* "acuteness" 3432 */
      1,  14,   5,  12,   7,  27,  22,   5,   4,   0,  /* "acyclovir" 3442 */
     24,  20,   0,  /* "ad" 3445 */
      2,  20,   1,   0,  /* "ada" 3449 */
     24,  20,   1,   9,  15,   7,   0,  /* "adabel" 3456 */
     19,  20,   8,  12,  26,   0,  /* "adachi" 3462 */
      1,  20,   8,  43,  26,  25,   0,  /* "adagio" 3469 */
     24,  20,  19,   0,  /* "adah" 3473 */
     19,  20,  21,   4,   0,  /* "adaire" 3478 */
      1,  20,  24,  12,   0,  /* "adak" 3483 */
     19,  20,   8,   7,   1,   0,  /* "adalah" 3489 */
     24,  20,   1,  17,   0,  /* "adam" 3494 */
      8,  20,   1,  17,  42,  31,  12,   0,  /* "adamcik" 3502 */
      8,  20,   1,  17,  42,  34,  12,   0,  /* "adamczak" 3510 */
      8,  20,   1,  17,  42,  31,  12,   0,  /* "adamczyk" 3518 */
     19,  20,   8,  17,  26,   0,  /* "adame" 3524 */
      1,  20,   8,  17,  31,  12,   0,  /* "adamec" 3531 */
      1,  20,   8,  17,  15,  12,   0,  /* "adamek" 3538 */
      1,  20,   2,  17,  30,   0,  /* "adames" 3544 */
     19,  20,   8,  17,  26,   0,  /* "adami" 3550 */
      1,  20,   8,  17,  31,  12,   0,  /* "adamik" 3557 */
     19,  20,  19,  17,  23,  13,   1,   0,  /* "adamina" 3565 */
     19,  20,   8,  17,  27,   0,  /* "adamo" 3571 */
      1,  20,   8,  17,   1,  22,  31,  42,   0,  /* "adamowicz" 3580 */
      1,  20,  24,  17,  14,  12,  23,   0,  /* "adamski" 3588 */
     24,  20,   1,  17,  14,   1,  13,   0,  /* "adamson" 3596 */
     24,  20,   1,  17,  14,   3,  48,  13,   0,  /* "adamstown" 3605 */
      2,  20,   1,  13,   0,  /* "adan" 3610 */
      1,  20,  24,   6,   3,   1,   9,   1,   7,   0,  /* "adaptable" 3620 */
      1,  20,  24,   6,   3,   1,   6,   7,  21,  12,  14,   0,  /* "adaptaplex" 3632 */
     24,  20,   1,   6,   3,   2,  33,   1,  13,   0,  /* "adaptation" 3642 */
     24,  20,  34,   6,   3,   2,  33,   1,  13,  30,   0,  /* "adaptations" 3653 */
      1,  20,   8,   4,   0,  /* "adar" 3658 */
     24,  20,   1,   4,  24,  13,  20,   0,  /* "adarand" 3666 */
      1,  20,   2,   0,  /* "aday" 3670 */
      1,  20,   8,  30,   1,   0,  /* "adaza" 3676 */
      1,  20,  12,   8,  12,  14,   0,  /* "adcox" 3683 */
     24,  20,   0,  /* "add" 3686 */
      1,  20,  21,   4,   0,  /* "addair" 3691 */
     24,  20,   1,  20,   0,  /* "added" 3696 */
      1,  20,  21,  20,   1,  17,   0,  /* "addendum" 3703 */
      1,  20,  21,  20,   1,  17,  30,   0,  /* "addendums" 3711 */
      8,  20,  26,  27,   0,  /* "addeo" 3716 */
     24,  20,  10,   0,  /* "adder" 3720 */
      1,  20,  44,   7,  26,   0,  /* "adderley" 3726 */
     24,  20,  31,  12,  14,   0,  /* "addicks" 3732 */
     35,  20,  31,  12,   3,   0,  /* "addict" 3738 */
      1,  20,   5,  12,   3,   0,  /* "addict" 3744 */
     35,  20,  31,  12,   3,  14,   0,  /* "addicts" 3751 */
      1,  20,   5,  12,   3,  14,   0,  /* "addicts" 3758 */
      1,  20,  23,  20,   1,  14,   0,  /* "addidas" 3765 */
     24,  20,  26,   0,  /* "addie" 3769 */
     24,  20,  31,  32,   0,  /* "adding" 3774 */
     24,  20,  31,  32,   3,   1,  13,   0,  /* "addington" 3782 */
      8,  20,   5,  14,   0,  /* "addis" 3787 */
     24,  20,   1,  14,   1,  13,   0,  /* "addison" 3794 */
     24,  20,   1,   3,  31,  22,   0,  /* "additive" 3801 */
     24,  20,   1,   3,  31,  22,  30,   0,  /* "additives" 3809 */
     24,  20,   1,   7,   0,  /* "addle" 3814 */
     24,  20,   1,   7,  20,   0,  /* "addled" 3820 */
     24,  20,   1,   7,  17,   1,  13,   0,  /* "addleman" 3828 */
     24,  20,   4,  21,  14,   0,  /* "address" 3834 */
      1,  20,   4,  21,  14,   1,   9,   1,   7,   0,  /* "addressable" 3844 */
      1,  20,   4,  21,  14,   3,   0,  /* "addressed" 3851 */
     24,  20,   4,  15,  14,  23,   0,  /* "addressee" 3858 */
     24,  20,   4,   1,  14,   1,  30,   0,  /* "addresses" 3866 */
     24,  20,  30,   0,  /* "adds" 3870 */
     19,  20,  29,  42,  26,   0,  /* "adduci" 3876 */
     24,  20,  26,   0,  /* "addy" 3880 */
      2,  20,   0,  /* "ade" 3883 */
      1,  20,  23,   0,  /* "adee" 3887 */
      1,  20,  21,   7,   0,  /* "adel" 3892 */
      1,  20,  21,   7,   1,   0,  /* "adela" 3898 */
     24,  20,   1,   7,   2,  20,   0,  /* "adelaide" 3905 */
      1,  20,  21,   7,   9,  10,   3,   0,  /* "adelbert" 3913 */
      1,  20,  21,   7,   0,  /* "adele" 3918 */
     24,  20,   1,   7,  39,  13,   0,  /* "adeline" 3925 */
     24,  20,   1,   7,  23,  30,  26,   0,  /* "adelizzi" 3933 */
      1,  20,  21,   7,   0,  /* "adell" 3938 */
      1,  20,  21,   7,   0,  /* "adelle" 3943 */
      1,  20,  21,   7,  37,   1,   0,  /* "adelpha" 3950 */
      1,  20,  21,   7,  37,  26,   1,   0,  /* "adelphia" 3958 */
      2,  20,   1,  13,   0,  /* "aden" 3963 */
     24,  20,   1,  13,   1,   0,  /* "adena" 3969 */
      2,  20,   1,  13,  48,   4,   0,  /* "adenauer" 3976 */
      1,  20,  21,   6,   3,   0,  /* "adept" 3982 */
      2,  20,  10,   0,  /* "ader" 3986 */
     24,  20,  10,  38,  27,   7,  20,   0,  /* "aderhold" 3994 */
      2,  20,  30,   0,  /* "ades" 3998 */
      2,  20,  26,   0,  /* "adey" 4002 */
     24,  20,  38,  34,  17,   0,  /* "adham" 4008 */
     34,  20,  38,   5,   4,  20,   0,  /* "adhered" 4015 */
     34,  20,  38,   5,   4,   1,  13,   3,  14,   0,  /* "adherents" 4025 */
      1,  20,  38,   5,   4,  31,  32,   0,  /* "adhering" 4033 */
     34,  20,  38,  23,  14,  31,  22,   0,  /* "adhesive" 4041 */
     34,  20,  38,  23,  14,  31,  22,  30,   0,  /* "adhesives" 4050 */
      8,  20,  26,   1,   0,  /* "adia" 4055 */
      1,  20,   5,  20,   0,  /* "adid" 4060 */
      1,  20,  23,  20,   1,  14,   0,  /* "adidas" 4067 */
      1,  20,  29,   0,  /* "adieu" 4071 */
      1,  20,   5,  13,   0,  /* "adin" 4076 */
     19,  20,  23,  13,   1,   0,  /* "adina" 4082 */
     19,  20,  23,  13,  26,   0,  /* "adine" 4088 */
     19,  20,  26,  13,  25,   7,  37,  26,   0,  /* "adinolfi" 4097 */
      8,  20,  26,  25,  14,   0,  /* "adios" 4103 */
     24,  20,  10,   8,  13,  20,  34,  12,   0,  /* "adirondack" 4112 */
      1,  40,   2,  14,   1,  13,   3,   0,  /* "adjacent" 4120 */
     34,  20,  40,   8,  13,  26,   0,  /* "adjani" 4127 */
     24,  40,  31,  12,   3,  31,  22,   0,  /* "adjective" 4135 */
     24,  40,  31,  12,   3,  31,  22,  30,   0,  /* "adjectives" 4144 */
      1,  40,  29,  20,  31,  12,   2,   3,   0,  /* "adjudicate" 4153 */
      1,  40,  29,  20,   1,  12,   2,   3,   1,  20,   0,  /* "adjudicated" 4164 */
      1,  40,  29,  20,  31,  12,   2,   3,  31,  32,   0,  /* "adjudicating" 4175 */
      1,  40,  29,  20,   1,  12,   2,  33,   1,  13,   0,  /* "adjudication" 4186 */
     24,  40,  35,  32,  12,   3,   0,  /* "adjunct" 4193 */
     24,  40,  35,  32,  12,   3,  14,   0,  /* "adjuncts" 4201 */
      1,  40,  35,  14,   3,   1,   9,   1,   7,   0,  /* "adjustable" 4211 */
      1,  40,  35,  14,   3,   1,   9,   1,   7,  30,   0,  /* "adjustables" 4222 */
     24,  40,   1,   3,   1,  13,   3,   0,  /* "adjutant" 4230 */
     24,  20,  12,   5,  13,  30,   0,  /* "adkins" 4237 */
     24,  20,  12,   1,  13,  14,   1,  13,   0,  /* "adkinson" 4246 */
     24,  20,  12,   1,  14,   1,  13,   0,  /* "adkison" 4254 */
     24,  20,  12,   1,  14,   1,  13,   0,  /* "adkisson" 4262 */
     19,  20,   7,   8,  26,   0,  /* "adlai" 4268 */
     24,  20,   7,  10,   0,  /* "adler" 4273 */
     24,  20,   7,  19,  13,   0,  /* "adlon" 4279 */
      1,  20,  17,   5,  13,   1,  14,   3,  10,   0,  /* "administer" 4289 */
      1,  20,  17,   5,  13,   1,  14,   3,  10,  20,   0,  /* "administered" 4300 */
      1,  20,  17,   5,  13,   1,  14,   3,   4,   2,   3,  31,  32,   0,  /* "administrating" 4314 */
      1,  20,  17,   5,  13,   1,  14,   3,   4,   2,   3,  31,  22,   0,  /* "administrative" 4328 */
     34,  20,  17,   5,  13,   1,  14,   3,   4,   2,   3,  31,  22,   7,  26,   0,  /* "administratively" 4344 */
      1,  20,  17,   5,  13,   1,  14,   3,   4,   2,   3,  10,   0,  /* "administrator" 4357 */
     34,  20,  17,  39,   4,   1,   0,  /* "admira" 4364 */
     24,  20,  17,  10,   1,   9,   1,   7,   0,  /* "admirable" 4373 */
     24,  20,  17,  10,   1,   9,   7,  26,   0,  /* "admirably" 4382 */
     24,  20,  17,  10,   1,   7,   0,  /* "admiral" 4389 */
     24,  20,  17,  10,   1,   7,  30,   0,  /* "admirals" 4397 */
     24,  20,  17,  10,   1,   7,   3,  26,   0,  /* "admiralty" 4406 */
     24,  20,  17,  10,   2,  33,   1,  13,   0,  /* "admiration" 4415 */
     24,  20,  17,  10,   2,  33,   1,  13,  14,   0,  /* "admirations" 4425 */
     34,  20,  17,  39,   4,   0,  /* "admire" 4431 */
      1,  20,  17,  39,  10,  20,   0,  /* "admired" 4438 */
     34,  20,  17,  39,   4,  10,   0,  /* "admirer" 4445 */
      1,  20,  17,  39,   4,  10,  30,   0,  /* "admirers" 4453 */
     34,  20,  17,  39,   4,  30,   0,  /* "admires" 4460 */
     34,  20,  17,  39,   4,  31,  32,   0,  /* "admiring" 4468 */
     34,  20,  17,  39,   4,  31,  32,   7,  26,   0,  /* "admiringly" 4478 */
      1,  20,  17,   5,  14,   1,   9,   5,   7,   1,   3,  26,   0,  /* "admissibility" 4491 */
      1,  20,  17,   5,  14,   1,   9,   1,   7,   0,  /* "admissible" 4501 */
      1,  20,  17,   5,   3,   0,  /* "admit" 4507 */
      1,  20,  17,   5,   3,  14,   0,  /* "admits" 4514 */
      1,  20,  17,   5,   3,   1,  13,  14,   0,  /* "admittance" 4523 */
      1,  20,  17,   5,   3,   1,  20,   0,  /* "admitted" 4531 */
      1,  20,  17,   8,  13,  31,  33,   3,   0,  /* "admonished" 4540 */
     34,  20,  17,   8,  13,  31,  33,  17,  15,  13,   3,   0,  /* "admonishment" 4552 */
     24,  20,  17,   1,  13,   5,  33,   1,  13,   0,  /* "admonition" 4562 */
     24,  20,  17,   1,  13,   5,  33,   1,  13,  30,   0,  /* "admonitions" 4573 */
      1,  20,  29,   0,  /* "ado" 4577 */
      1,  20,  25,   9,  26,   0,  /* "adobe" 4583 */
      2,  20,  19,   7,  37,   0,  /* "adolf" 4589 */
      1,  20,   8,   7,  37,  25,   0,  /* "adolfo" 4596 */
      2,  20,  36,   7,  37,   0,  /* "adolph" 4602 */
     19,  20,  25,   7,  37,   1,   0,  /* "adolpha" 4609 */
     24,  20,  27,   7,  37,  14,   1,  13,   0,  /* "adolphson" 4618 */
     19,  20,  18,  13,   0,  /* "adon" 4623 */
     19,  20,  25,  13,  26,   1,   0,  /* "adonia" 4630 */
      1,  20,   8,   6,   3,   1,   9,   1,   7,   0,  /* "adoptable" 4640 */
     19,  20,  18,   4,   0,  /* "ador" 4645 */
     19,  20,  18,   4,   1,   0,  /* "adora" 4651 */
     24,  20,  10,   1,   9,   1,   7,   0,  /* "adorabelle" 4659 */
      1,  20,  18,   4,   1,   9,   1,   7,   0,  /* "adorable" 4668 */
     24,  20,  10,   2,  33,   1,  13,   0,  /* "adoration" 4676 */
      1,  20,  18,   4,  20,   0,  /* "adored" 4682 */
     34,  20,  10,  23,   0,  /* "adoree" 4687 */
      1,  20,  18,   4,  31,  32,   0,  /* "adoring" 4694 */
     19,  20,  18,   4,  13,   1,   0,  /* "adorna" 4701 */
     19,  20,  18,   4,  13,  27,   0,  /* "adorno" 4708 */
      2,  20,   4,   1,   0,  /* "adra" 4713 */
     19,  20,   4,   8,  11,  13,   1,   0,  /* "adragna" 4721 */
      2,  20,  10,  20,   1,   0,  /* "adrda" 4727 */
      1,  20,   4,  23,  13,   1,   7,   0,  /* "adrenal" 4735 */
      1,  20,   4,  21,  13,   1,   7,   1,  13,   0,  /* "adrenalin" 4745 */
      1,  20,   4,  21,  13,   1,   7,   1,  13,   0,  /* "adrenaline" 4755 */
      8,  20,   4,  26,   1,   0,  /* "adria" 4761 */
      2,  20,   4,  26,   1,  13,   0,  /* "adrian" 4768 */
      2,  20,   4,  26,  24,  13,   1,   0,  /* "adriana" 4776 */
     19,  20,   4,  23,   1,  13,  14,   0,  /* "adriance" 4784 */
      2,  20,   4,  26,  24,   3,  31,  12,   0,  /* "adriatic" 4793 */
      1,  20,   4,  23,   7,   0,  /* "adriel" 4799 */
      1,  20,   4,   5,  37,   3,   0,  /* "adrift" 4806 */
      1,  20,   4,  49,   3,   0,  /* "adroit" 4812 */
      1,  20,   4,  49,   3,   7,  26,   0,  /* "adroitly" 4820 */
     24,  20,  30,   0,  /* "ads" 4824 */
     24,  20,  14,   5,   3,   0,  /* "adsit" 4830 */
     24,  20,  14,   0,  /* "adss" 4834 */
     24,  20,   3,  21,  12,   0,  /* "adtec" 4840 */
     24,  40,   1,   7,   2,   3,   0,  /* "adulate" 4847 */
     24,  40,   1,   7,   2,  33,   1,  13,   0,  /* "adulation" 4856 */
      1,  20,  29,   7,  26,   8,  20,  28,   0,  /* "aduliadae" 4865 */
      1,  20,  35,   7,   3,  10,   2,   3,   0,  /* "adulterate" 4874 */
      1,  20,  35,   7,   3,  38,  45,  20,   0,  /* "adulthood" 4883 */
     24,  20,   1,  14,  20,  10,   0,  /* "adusdur" 4890 */
      1,  20,  22,  24,  13,  14,  31,  32,   0,  /* "advancing" 4899 */
     34,  20,  22,  24,  13,   3,   1,   0,  /* "advanta" 4907 */
     34,  20,  22,  24,  13,   3,  31,  40,   0,  /* "advantage" 4916 */
     34,  20,  22,  24,  13,   3,  31,  40,  20,   0,  /* "advantaged" 4926 */
     24,  20,  22,   1,  13,   3,   2,  40,   1,  14,   0,  /* "advantageous" 4937 */
     34,  20,  22,  24,  13,   3,  31,  40,   1,  30,   0,  /* "advantages" 4948 */
     34,  20,  22,  24,  13,   3,   1,  14,   3,   0,  /* "advantest" 4958 */
     34,  20,  22,  21,  12,  33,   1,  13,   0,  /* "advection" 4967 */
     34,  20,  22,  21,  13,  42,  10,   0,  /* "adventure" 4975 */
     34,  20,  22,  21,  13,  42,  10,  10,   0,  /* "adventurer" 4984 */
     34,  20,  22,  21,  13,  42,  10,  10,  30,   0,  /* "adventurers" 4994 */
     34,  20,  22,  21,  13,  42,  10,  30,   0,  /* "adventures" 5003 */
     34,  20,  22,  21,  13,  42,  10,  14,   1,  17,   0,  /* "adventuresome" 5014 */
     34,  20,  22,  21,  13,  42,  10,   5,  30,   1,  17,   0,  /* "adventurism" 5026 */
     34,  20,  22,  21,  13,  42,  10,   1,  14,   0,  /* "adventurous" 5036 */
     34,  20,  22,  44,   9,  26,   1,   7,   0,  /* "adverbial" 5045 */
     24,  20,  22,  10,  14,  21,   4,  26,  30,   0,  /* "adversaries" 5055 */
     24,  20,  22,  10,  14,  21,   4,  26,   0,  /* "adversary" 5064 */
     34,  20,  22,  44,  14,   0,  /* "adverse" 5070 */
     34,  20,  22,  44,  14,   7,  26,   0,  /* "adversely" 5078 */
     34,  20,  22,  44,  14,   1,   3,  26,   0,  /* "adversity" 5087 */
     24,  20,  22,  10,   3,  39,  30,   0,  /* "advertise" 5095 */
     24,  20,  22,  10,   3,  39,  30,  20,   0,  /* "advertised" 5104 */
      1,  20,  22,  44,   3,   1,  30,  17,   1,  13,   3,   0,  /* "advertisement" 5116 */
     24,  20,  22,  10,   3,  39,  30,  17,   1,  13,   3,  14,   0,  /* "advertisements" 5129 */
     24,  20,  22,  10,   3,  39,  30,  10,   0,  /* "advertiser" 5138 */
     24,  20,  22,  10,   3,  39,  30,  10,  30,   0,  /* "advertisers" 5148 */
     24,  20,  22,  10,   3,  39,  30,   1,  30,   0,  /* "advertises" 5158 */
     24,  20,  22,  10,   3,  39,  30,  31,  32,   0,  /* "advertising" 5168 */
     24,  20,  22,  15,  14,   3,   0,  /* "advest" 5175 */
     34,  20,  22,  39,  14,   0,  /* "advice" 5181 */
     24,  20,  22,   5,   7,   0,  /* "advil" 5187 */
     24,  20,  22,  39,  30,   1,   9,   5,   7,   1,   3,  26,   0,  /* "advisability" 5200 */
      1,  20,  22,  39,  30,   1,   9,   1,   7,   0,  /* "advisable" 5210 */
     34,  20,  22,  39,  30,   0,  /* "advise" 5216 */
     34,  20,  22,  39,  30,  20,   0,  /* "advised" 5223 */
     34,  20,  22,  39,  30,   1,  20,   7,  26,   0,  /* "advisedly" 5233 */
      1,  20,  22,  39,  30,  17,   1,  13,   3,   0,  /* "advisement" 5243 */
     34,  20,  22,  39,  30,  10,   0,  /* "adviser" 5250 */
     34,  20,  22,  39,  30,  10,  30,   0,  /* "advisers" 5258 */
     34,  20,  22,  39,  30,   1,  30,   0,  /* "advises" 5266 */
     34,  20,  22,  39,  30,  31,  32,   0,  /* "advising" 5274 */
     34,  20,  22,  39,  30,  10,   0,  /* "advisor" 5281 */
      1,  20,  22,  39,  30,  10,  26,  30,   0,  /* "advisories" 5290 */
     34,  20,  22,  39,  30,  10,  30,   0,  /* "advisors" 5298 */
     34,  20,  22,  39,  30,  10,  26,   0,  /* "advisory" 5306 */
     24,  20,  22,  27,   0,  /* "advo" 5311 */
     24,  20,  22,   1,  12,   1,  14,  26,   0,  /* "advocacy" 5320 */
     24,  20,  22,   1,  12,   1,   3,   0,  /* "advocate" 5328 */
     24,  20,  22,   1,  12,   2,   3,   0,  /* "advocate" 5336 */
     24,  20,  22,   1,  12,   1,   3,  14,   0,  /* "advocates" 5345 */
     24,  20,  22,   1,  12,   2,   3,  14,   0,  /* "advocates" 5354 */
     24,  20,  47,  26,  12,   0,  /* "adweek" 5360 */
      1,  20,  47,  21,   7,   0,  /* "adwell" 5366 */
      2,  20,  26,   0,  /* "ady" 5370 */
     24,  20,  30,   0,  /* "adz" 5374 */
      2,   0,  /* "ae" 5376 */
     31,  40,  23,   1,  13,   0,  /* "aegean" 5382 */
     23,  40,   1,  14,   0,  /* "aegis" 5387 */
      2,  11,  19,  13,   0,  /* "aegon" 5392 */
     24,   7,   3,   1,  14,   0,  /* "aeltus" 5398 */
     24,  13,  26,   1,  14,   0,  /* "aeneas" 5404 */
      2,  12,  47,   1,   3,   4,  19,  13,   0,  /* "aequitron" 5413 */
     21,   4,   0,  /* "aer" 5416 */
     21,   4,  26,   1,  13,  30,   0,  /* "aeriens" 5423 */
     21,   4,   1,   3,  24,   7,  41,   1,   0,  /* "aeritalia" 5432 */
     21,   4,  27,   0,  /* "aero" 5436 */
     15,   4,  25,   9,  31,  12,   0,  /* "aerobic" 5443 */
     15,   4,  25,   9,  31,  12,   7,  26,   0,  /* "aerobically" 5452 */
     10,  25,   9,  31,  12,  14,   0,  /* "aerobics" 5459 */
     21,   4,   1,  20,  39,  13,   0,  /* "aerodyne" 5466 */
     21,   4,  27,  40,  21,   3,   0,  /* "aerojet" 5473 */
     21,   4,  27,   7,   5,  37,   3,   0,  /* "aerolift" 5481 */
     21,   4,  27,   7,   5,  13,  26,   1,  14,   0,  /* "aerolineas" 5491 */
     21,   4,  27,  17,  21,  12,  14,  31,  12,  25,   0,  /* "aeromexico" 5502 */
     21,   4,  27,  13,   8,   3,   1,  12,   0,  /* "aeronautic" 5511 */
     21,   4,  27,  13,   8,   3,   1,  12,   1,   7,   0,  /* "aeronautical" 5522 */
     21,   4,  27,  13,  18,   3,  31,  12,   1,  14,   0,  /* "aeronauticas" 5533 */
     21,   4,   1,  13,  18,   3,  31,  12,  14,   0,  /* "aeronautics" 5543 */
     21,   4,   1,  12,  47,   5,   6,   0,  /* "aeroquip" 5551 */
     21,   4,   1,  14,   8,   7,   0,  /* "aerosol" 5558 */
     21,   4,   1,  14,   8,   7,  30,   0,  /* "aerosols" 5566 */
     21,   4,  27,  14,   6,   8,  14,  26,   8,   7,   0,  /* "aerospatiale" 5577 */
     21,   4,  27,  14,   3,   8,   4,  30,   0,  /* "aerostars" 5586 */
     21,   4,   3,  14,   0,  /* "aerts" 5591 */
     21,  33,   7,  26,  17,   1,  13,   0,  /* "aeschliman" 5599 */
     23,  14,   8,   6,   0,  /* "aesop" 5604 */
     21,  14,  16,  26,   3,   0,  /* "aesthete" 5610 */
     15,  14,  16,  21,   3,  31,  12,   0,  /* "aesthetic" 5618 */
     15,  14,  16,  21,   3,  31,  12,   7,  26,   0,  /* "aesthetically" 5628 */
     15,  14,  16,  21,   3,  31,  12,  14,   0,  /* "aesthetics" 5637 */
     24,  37,   1,  13,   2,  14,  26,  15,  22,   0,  /* "afanasyev" 5647 */
      1,  37,   8,   4,   0,  /* "afar" 5652 */
     24,  37,   1,   9,   1,   7,   0,  /* "affable" 5659 */
      1,  37,  21,   4,   0,  /* "affair" 5664 */
      1,  37,  21,   4,  30,   0,  /* "affairs" 5670 */
     24,  37,  15,  12,   3,   2,  33,   1,  13,   0,  /* "affectation" 5680 */
     24,  37,  15,   7,   3,   0,  /* "affeldt" 5686 */
     24,  37,  10,   1,  13,   3,   0,  /* "afferent" 5693 */
     24,  37,  26,   1,  13,   3,   0,  /* "affiant" 5700 */
     24,  37,   1,  20,   2,  22,   1,   3,   0,  /* "affidavit" 5709 */
     24,  37,   1,  20,   2,  22,   1,   3,  14,   0,  /* "affidavits" 5719 */
      1,  37,   5,   7,  26,   1,   3,  14,   0,  /* "affiliates" 5728 */
     24,  37,  10,  17,   2,  33,   1,  13,   0,  /* "affirmation" 5737 */
     24,  37,  10,  17,   2,  33,   1,  13,  30,   0,  /* "affirmations" 5747 */
      1,  37,  44,  17,   1,   3,  31,  22,   0,  /* "affirmative" 5756 */
      1,  37,  44,  17,   1,   3,  31,  22,   7,  26,   0,  /* "affirmatively" 5767 */
     24,  37,  31,  12,  14,   0,  /* "affix" 5773 */
     34,  37,   5,  12,  14,   0,  /* "affix" 5779 */
      1,  37,   5,  12,  14,   3,   0,  /* "affixed" 5786 */
     35,  37,  31,  12,  14,  31,  30,   0,  /* "affixes" 5794 */
      1,  37,   5,  12,  14,  31,  30,   0,  /* "affixes" 5802 */
      1,  37,   5,  12,  14,  31,  32,   0,  /* "affixing" 5810 */
     24,  37,   7,  31,  12,   0,  /* "affleck" 5816 */
     24,  37,   7,  10,   9,   8,  12,   0,  /* "afflerbach" 5824 */
     24,  37,   7,   5,  12,   0,  /* "afflik" 5830 */
     24,  37,   7,  29,   1,  13,  14,   0,  /* "affluence" 5838 */
     24,  37,   7,  29,   1,  13,   3,   0,  /* "affluent" 5846 */
     24,  37,  27,   7,   3,  10,   0,  /* "affolter" 5853 */
      1,  37,  18,   4,  20,   0,  /* "afford" 5859 */
      1,  37,  18,   4,  20,   1,   9,   1,   7,   0,  /* "affordable" 5869 */
      1,  37,  18,   4,  20,  30,   0,  /* "affords" 5876 */
     24,  37,   4,  31,  12,   1,   3,   0,  /* "affricate" 5884 */
     24,  37,   4,  31,  12,   1,   3,  14,   0,  /* "affricates" 5893 */
      1,  37,   4,  35,  13,   3,   0,  /* "affront" 5900 */
      1,  37,   4,  35,  13,   3,   1,  20,   0,  /* "affronted" 5909 */
      1,  37,   4,  35,  13,   3,  14,   0,  /* "affronts" 5917 */
     24,  37,  26,  17,  24,  12,  14,   0,  /* "affymax" 5925 */
     24,  37,  11,  24,  13,   0,  /* "afghan" 5931 */
     34,  37,  11,   8,  13,  26,   0,  /* "afghani" 5938 */
     34,  37,  11,  24,  13,  26,  30,   0,  /* "afghanis" 5946 */
     34,  37,  11,  24,  13,   1,  14,   3,  24,  13,   0,  /* "afghanistan" 5957 */
     24,  37,  11,  24,  13,  30,   0,  /* "afghans" 5964 */
     24,  37,  21,   7,   3,   0,  /* "afheldt" 5970 */
      1,  37,  23,  33,  41,   1,  13,   8,  20,  25,   0,  /* "aficionado" 5981 */
      1,  37,   5,  33,   1,  13,   8,  20,  27,  30,   0,  /* "aficionados" 5992 */
      1,  37,  23,   7,  20,   0,  /* "afield" 5998 */
      1,  37,  39,   4,   0,  /* "afire" 6003 */
     24,  37,   7,   1,   3,   8,  12,  14,   1,  13,   0,  /* "aflatoxin" 6014 */
     24,  37,  17,  15,  20,   0,  /* "afmed" 6020 */
      1,  37,   8,  13,  14,  27,   0,  /* "afonso" 6027 */
      1,  37,  45,   3,   0,  /* "afoot" 6032 */
      1,  37,  18,   4,  14,  21,  20,   0,  /* "aforesaid" 6040 */
      1,  37,  18,   4,  16,   8,   3,   0,  /* "aforethought" 6048 */
      1,  37,  48,   7,   0,  /* "afoul" 6053 */
      1,  37,   4,  21,  33,   0,  /* "afresh" 6059 */
     24,  37,   4,  31,  12,   1,  13,   5,  14,   3,   0,  /* "africanist" 6070 */
     24,  37,   4,  31,  12,   1,  13,  39,  30,   0,  /* "africanize" 6080 */
     24,  37,   4,  31,  12,   1,  13,  39,  30,  20,   0,  /* "africanized" 6091 */
     24,  37,   4,   1,  12,   8,  13,  30,   0,  /* "afrikaans" 6100 */
     24,  37,   4,  31,  12,   8,  13,  10,  30,   0,  /* "afrikaners" 6110 */
     24,  37,   4,  27,   0,  /* "afro" 6115 */
     19,  37,  14,   8,  13,   2,   0,  /* "afsane" 6122 */
     24,  37,  33,  10,   0,  /* "afshar" 6127 */
     24,  37,   3,   0,  /* "aft" 6131 */
     24,  37,   3,  10,   8,   7,   0,  /* "afterall" 6138 */
     24,  37,   3,  10,   5,  17,  31,  40,   0,  /* "afterimage" 6147 */
     24,  37,   3,  10,   7,  39,  37,   0,  /* "afterlife" 6155 */
     24,  37,   3,  10,  17,  24,  16,   0,  /* "aftermath" 6163 */
     24,  37,   3,  10,  13,  29,  13,   0,  /* "afternoon" 6171 */
     24,  37,   3,  10,  13,  29,  13,  30,   0,  /* "afternoons" 6180 */
     24,  37,   3,  10,   3,   2,  14,   3,   0,  /* "aftertaste" 6189 */
     24,  37,   3,  10,   3,  24,  12,  14,   0,  /* "aftertax" 6198 */
     24,  37,   3,  10,  16,   8,   3,   0,  /* "afterthought" 6206 */
      1,  37,  29,   7,   1,   0,  /* "afula" 6212 */
     24,  11,   0,  /* "ag" 6215 */
      8,  11,   1,   0,  /* "aga" 6219 */
     24,  11,  34,  42,   0,  /* "agache" 6224 */
      1,  11,  21,  13,   0,  /* "again" 6229 */
      1,  11,  21,  13,  14,   3,   0,  /* "against" 6236 */
      2,  11,   1,  13,   0,  /* "agan" 6241 */
     24,  11,   1,  13,   9,  21,  11,  41,   1,  13,   0,  /* "aganbegyan" 6252 */
      8,  11,  19,  13,  30,   0,  /* "agans" 6258 */
      1,  11,   2,   6,   0,  /* "agape" 6263 */
      2,  11,  10,   0,  /* "agar" 6267 */
      8,  11,  19,   4,  47,  19,   7,   0,  /* "agarwal" 6275 */
     24,  11,   1,  14,  26,   0,  /* "agassi" 6281 */
      1,  11,  24,  14,   5,  30,   0,  /* "agassiz" 6288 */
     24,  11,   1,   3,   0,  /* "agate" 6293 */
     24,  11,   1,   3,  14,   0,  /* "agates" 6299 */
     24,  11,  12,  25,   0,  /* "agco" 6304 */
      2,  40,   0,  /* "age" 6307 */
      2,  40,  31,  20,   0,  /* "aged" 6312 */
      2,  40,  20,   0,  /* "aged" 6316 */
      2,  40,  26,   0,  /* "agee" 6320 */
      2,  40,   7,   1,  14,   0,  /* "ageless" 6326 */
     24,  40,   1,  13,  14,   0,  /* "agence" 6332 */
      2,  40,   1,  13,  14,  26,  30,   0,  /* "agencies" 6340 */
      2,  40,   1,  13,  14,  26,   0,  /* "agency" 6347 */
      2,  40,   1,  13,   3,   0,  /* "agent" 6353 */
      2,  40,   1,  13,   3,  14,   0,  /* "agents" 6360 */
      2,  40,  10,   0,  /* "ager" 6364 */
      1,  40,  21,   4,   1,   3,   1,  17,   0,  /* "ageratum" 6373 */
      1,  40,  21,   4,   1,   3,   1,  17,  30,   0,  /* "ageratums" 6383 */
      2,  40,   1,  30,   0,  /* "ages" 6388 */
     24,  11,  37,   1,   0,  /* "agfa" 6393 */
      1,  11,   8,   4,  47,   1,   7,   0,  /* "aggarwal" 6401 */
     24,  11,  26,   0,  /* "aggie" 6405 */
     24,  11,  26,  30,   0,  /* "aggies" 6410 */
      1,  11,   7,  29,   3,   1,  13,   2,   3,   0,  /* "agglutinate" 6420 */
      1,  11,   4,  24,  13,  20,  39,  30,   0,  /* "aggrandize" 6429 */
     24,  11,   4,   1,  13,  20,  39,  30,  17,   1,  13,   3,   0,  /* "aggrandizement" 6442 */
     24,  11,   4,   1,  13,  20,  39,  30,  31,  32,   0,  /* "aggrandizing" 6453 */
     24,  11,   4,   1,  22,   2,   3,   0,  /* "aggravate" 6461 */
     24,  11,   4,   1,  22,   2,   3,   1,  20,   0,  /* "aggravated" 6471 */
     24,  11,   4,   1,  22,   2,   3,  14,   0,  /* "aggravates" 6480 */
     24,  11,   4,   1,  22,   2,   3,  31,  32,   0,  /* "aggravating" 6490 */
     24,  11,   4,   1,  22,   2,  33,   1,  13,   0,  /* "aggravation" 6500 */
     24,  11,   4,   1,  11,  31,   3,   0,  /* "aggregate" 6508 */
     24,  11,   4,   1,  11,   1,   3,   0,  /* "aggregate" 6516 */
     24,  11,   4,   1,  11,   2,   3,   1,  20,   0,  /* "aggregated" 6526 */
     24,  11,   4,   1,  11,  31,   3,  14,   0,  /* "aggregates" 6535 */
     24,  11,   4,   1,  11,   1,   3,  14,   0,  /* "aggregates" 6544 */
      1,  11,   4,  15,  14,   5,  22,   1,   3,  26,   0,  /* "aggressivity" 6555 */
     34,  11,   4,   2,   0,  /* "aggrey" 6560 */
     24,  11,  26,   0,  /* "aggy" 6564 */
     24,  11,   1,  30,   8,  20,  21,   0,  /* "aghazadeh" 6572 */
     24,  11,  26,   0,  /* "agie" 6576 */
      1,  11,   5,   7,  20,  27,   0,  /* "agildo" 6583 */
     24,  40,   1,   7,   0,  /* "agile" 6588 */
      1,  40,   5,   7,   1,  14,   0,  /* "agilis" 6595 */
     19,  40,  23,  13,   0,  /* "agin" 6600 */
      2,  40,  31,  32,   0,  /* "aging" 6605 */
      2,  11,   5,  13,  30,   0,  /* "agins" 6611 */
      2,  11,   1,   6,   0,  /* "agip" 6616 */
      2,  40,  26,   1,  14,   0,  /* "agius" 6622 */
      1,  11,   7,  23,  17,   0,  /* "agleam" 6628 */
     24,  11,   7,  10,   0,  /* "agler" 6633 */
      1,  11,   7,   5,   3,  10,   0,  /* "aglitter" 6640 */
     24,  11,   7,  27,   0,  /* "aglo" 6645 */
     24,  11,  13,   1,   0,  /* "agna" 6650 */
      2,  13,  41,   0,  /* "agne" 6654 */
     24,  11,  13,   1,  14,   0,  /* "agnes" 6660 */
     19,  11,  13,  21,   3,   1,   0,  /* "agneta" 6667 */
     24,  11,  13,  31,  12,  25,   0,  /* "agnico" 6674 */
     34,  11,  13,  25,  14,  26,  27,   0,  /* "agnosio" 6682 */
     34,  11,  13,   8,  14,   3,  31,  12,   0,  /* "agnostic" 6691 */
      1,  11,  25,   0,  /* "ago" 6695 */
      1,  11,   8,  11,   0,  /* "agog" 6700 */
     24,  11,   1,  13,  39,  30,   0,  /* "agonize" 6707 */
     24,  11,   1,  13,  39,  30,  20,   0,  /* "agonized" 6715 */
     24,  11,   1,  13,  39,  30,   1,  30,   0,  /* "agonizes" 6724 */
     24,  11,   1,  13,  39,  30,  31,  32,   0,  /* "agonizing" 6733 */
     24,  11,   1,  13,  39,  30,  31,  32,   7,  26,   0,  /* "agonizingly" 6744 */
     24,  11,   1,  13,  26,   0,  /* "agony" 6750 */
     24,  11,  10,   1,   0,  /* "agora" 6755 */
     19,  11,  25,  14,   3,   1,   0,  /* "agosta" 6762 */
     19,  11,  27,  14,   3,  26,  13,  21,   7,  26,   0,  /* "agostinelli" 6773 */
     19,  11,  27,  14,   3,  23,  13,  26,   0,  /* "agostini" 6782 */
     19,  11,  36,  14,   3,  23,  13,  27,   0,  /* "agostino" 6791 */
     19,  11,  25,  14,   3,  27,   0,  /* "agosto" 6798 */
      1,  11,  29,   4,   1,   0,  /* "agoura" 6804 */
      1,  11,  29,   4,  19,  13,   0,  /* "agouron" 6811 */
     24,  11,   4,   1,   0,  /* "agra" 6816 */
      1,  11,   4,  21,   4,  26,   1,  13,   5,  30,   1,  17,   0,  /* "agrarianism" 6829 */
      1,  11,   4,  24,  47,   1,   7,   0,  /* "agrawal" 6837 */
      1,  11,   4,  23,   1,   9,   1,   7,   0,  /* "agreeable" 6846 */
      8,  11,   4,  15,  14,  18,   4,  14,   0,  /* "agresource" 6855 */
     19,  11,   4,  21,  14,   3,   1,   0,  /* "agresta" 6863 */
     19,  11,   4,  21,  14,   3,  26,   0,  /* "agresti" 6871 */
     19,  11,   4,  21,  12,  14,  12,  27,   0,  /* "agrexco" 6880 */
     24,  11,   4,  26,   0,  /* "agri" 6885 */
      1,  11,   4,  23,  12,  27,   0,  /* "agrico" 6892 */
     24,  11,   4,   1,  37,  41,  29,   7,   0,  /* "agrifuel" 6901 */
     24,  11,   4,   1,  37,  41,  29,   7,  30,   0,  /* "agrifuels" 6911 */
      1,  11,   4,   5,   6,   1,   0,  /* "agrippa" 6918 */
     24,  11,   4,   1,  22,  39,  30,  10,   0,  /* "agrivisor" 6927 */
     24,  11,   4,  27,   0,  /* "agro" 6932 */
     24,  11,   4,  27,  12,  21,  17,  31,  12,   1,   7,  30,   0,  /* "agrochemicals" 6945 */
      1,  11,   4,   8,  13,   1,  17,   1,  14,   3,   0,  /* "agronomist" 6956 */
      1,  11,   4,   8,  13,   1,  17,   1,  14,   3,  14,   0,  /* "agronomists" 6968 */
      1,  11,   4,  25,  14,  26,   1,  13,  20,   0,  /* "agrosiand" 6978 */
      1,  11,   4,  48,  13,  20,   0,  /* "aground" 6985 */
     19,  11,   4,  29,  14,   1,   0,  /* "agrusa" 6992 */
      8,  11,  47,   1,   0,  /* "agua" 6997 */
     24,  11,  47,   1,  12,   2,   3,   0,  /* "aguacate" 7005 */
     19,  11,  47,   8,  20,  27,   0,  /* "aguado" 7012 */
     19,  11,  47,   2,  27,   0,  /* "aguayo" 7018 */
     19,  11,  29,  20,   2,   7,  27,   0,  /* "agudelo" 7026 */
      8,  11,  47,  26,  10,   0,  /* "aguiar" 7032 */
     19,  11,  47,  23,   7,   1,   0,  /* "aguila" 7039 */
     24,  11,   1,   7,  19,   4,   0,  /* "aguilar" 7046 */
     19,  11,  47,  26,   7,  21,   4,   1,   0,  /* "aguilera" 7055 */
     24,  11,   1,   7,  19,   4,   0,  /* "aguillar" 7062 */
     19,  11,  47,  26,   7,  18,  13,   0,  /* "aguillon" 7070 */
     19,  11,  29,  26,  13,   8,  11,   1,   0,  /* "aguinaga" 7079 */
      1,  11,  47,   5,   4,   1,   0,  /* "aguirra" 7086 */
     19,  11,  47,   5,   4,  28,   0,  /* "aguirre" 7093 */
      1,  11,  18,  14,   3,   1,  13,   0,  /* "agustin" 7101 */
      8,   0,  /* "ah" 7103 */
      8,  38,   8,   0,  /* "aha" 7107 */
      2,  38,  24,   9,   0,  /* "ahab" 7112 */
      8,  38,  19,   0,  /* "ahah" 7116 */
     24,  38,  10,  19,  13,   0,  /* "aharon" 7122 */
      1,  38,   8,   7,  14,  26,   0,  /* "ahaulsie" 7129 */
      1,  38,  21,  20,   0,  /* "ahead" 7134 */
      1,  38,  44,  13,   0,  /* "ahearn" 7139 */
      1,  38,  44,  13,   0,  /* "ahern" 7144 */
      1,  38,  44,  13,   0,  /* "aherne" 7149 */
      8,   0,  /* "ahh" 7151 */
      8,   7,   0,  /* "ahl" 7154 */
      1,   7,   2,  13,   0,  /* "ahlen" 7159 */
      2,   1,   7,  30,   0,  /* "ahles" 7164 */
      8,   7,  37,   0,  /* "ahlf" 7168 */
      8,   7,   1,  13,   0,  /* "ahlin" 7173 */
      8,  17,  19,  20,   0,  /* "ahmad" 7178 */
     19,  17,   8,  20,  26,   0,  /* "ahmadi" 7184 */
      8,  17,   1,  20,   0,  /* "ahmed" 7189 */
     19,  17,  29,  20,  26,   0,  /* "ahmoudi" 7195 */
     24,  13,   0,  /* "ahn" 7198 */
      8,  38,  27,   0,  /* "aho" 7202 */
     24,  38,   1,   7,   1,   0,  /* "ahola" 7208 */
      1,  38,  25,   7,  20,   0,  /* "ahold" 7214 */
      1,  38,  25,  13,   1,  13,   0,  /* "ahonen" 7221 */
      8,   4,   0,  /* "ahr" 7224 */
      1,   4,   8,  13,   1,   3,   0,  /* "ahranat" 7231 */
      8,   4,  15,  13,  30,   0,  /* "ahrens" 7237 */
      8,  30,   0,  /* "ahs" 7240 */
     19,  38,  29,  41,   1,   0,  /* "ahuja" 7246 */
     19,  41,  29,  17,   8,  20,   1,   0,  /* "ahumada" 7254 */
     39,   0,  /* "ai" 7256 */
     39,  12,   1,   7,   0,  /* "aichele" 7261 */
     39,  12,  10,   0,  /* "aicher" 7265 */
     19,  23,  42,  26,   0,  /* "aichi" 7270 */
      2,  12,  31,  13,   0,  /* "aickin" 7275 */
      2,  20,   0,  /* "aid" 7278 */
     39,  23,  20,   1,   0,  /* "aida" 7283 */
     19,  23,  20,  19,  13,   0,  /* "aidan" 7289 */
      2,  20,   0,  /* "aide" 7292 */
     39,  20,  23,  20,   0,  /* "aidid" 7297 */
      2,  20,  31,  32,   0,  /* "aiding" 7302 */
      2,  20,  30,   0,  /* "aids" 7306 */
     39,  21,   7,  27,   0,  /* "aiello" 7311 */
     15,  13,  41,   2,   0,  /* "aigner" 7316 */
     39,  11,   1,   9,  21,   7,   0,  /* "aiguebelle" 7323 */
      2,  12,   1,  13,   0,  /* "aikin" 7328 */
     39,  12,   1,  13,  30,   0,  /* "aikins" 7334 */
      2,   7,   0,  /* "ail" 7337 */
     39,   7,  23,  13,   0,  /* "aileen" 7342 */
      2,   7,  10,   8,  13,   0,  /* "aileron" 7348 */
      2,   7,  10,   8,  13,  30,   0,  /* "ailerons" 7355 */
     39,   7,  30,   0,  /* "ailes" 7359 */
      2,   7,  30,   0,  /* "ails" 7363 */
      2,  17,   0,  /* "aim" 7366 */
      2,  17,   0,  /* "aime" 7369 */
      2,  17,  31,  32,   0,  /* "aiming" 7374 */
      2,  17,  30,   0,  /* "aims" 7378 */
      2,  13,   0,  /* "aine" 7381 */
      2,  32,   0,  /* "ainge" 7384 */
      2,  13,  30,   7,  26,   0,  /* "ainslie" 7390 */
      2,  13,  14,  47,  10,  16,   0,  /* "ainsworth" 7397 */
     39,   6,  24,  12,   0,  /* "aipac" 7402 */
     21,   4,   0,  /* "air" 7405 */
     21,   4,   9,  24,  11,   0,  /* "airbag" 7411 */
     21,   4,   9,   2,  14,   0,  /* "airbase" 7417 */
     21,   4,   9,   2,  14,   1,  30,   0,  /* "airbases" 7425 */
     21,   4,   9,  27,   3,   0,  /* "airboat" 7431 */
     21,   4,   9,  27,   3,  14,   0,  /* "airboats" 7438 */
     21,   4,   9,  18,   4,  13,   0,  /* "airborne" 7445 */
     21,   4,  12,  19,   7,   0,  /* "aircal" 7451 */
     21,   4,  12,   4,  29,   0,  /* "aircrew" 7457 */
     21,   4,  20,   0,  /* "aird" 7461 */
     21,   4,  20,   4,  19,   6,   0,  /* "airdrop" 7468 */
     21,   4,  20,   4,  19,   6,  14,   0,  /* "airdrops" 7476 */
     21,   4,  20,   2,   7,   0,  /* "airedale" 7482 */
     21,   4,  26,  30,   0,  /* "aires" 7487 */
     21,   4,  37,  21,   4,  30,   0,  /* "airfares" 7494 */
     21,   4,  37,   7,  27,   0,  /* "airflow" 7500 */
     21,   4,  37,  36,   4,  14,   0,  /* "airforce" 7507 */
     21,   4,  11,  24,  14,   0,  /* "airgas" 7513 */
     21,   4,   7,  39,  13,   0,  /* "airline" 7519 */
     21,   4,   7,  39,  13,  10,   0,  /* "airliner" 7526 */
     21,   4,   7,  39,  13,  10,  30,   0,  /* "airliners" 7534 */
     21,   4,   7,  39,  13,  30,   0,  /* "airlines" 7541 */
     21,   4,   7,  18,  12,   0,  /* "airlock" 7547 */
     21,   4,  17,  21,  13,   0,  /* "airmen" 7553 */
     21,   4,   6,   7,  28,  13,  30,   0,  /* "airplanes" 7561 */
     21,   4,  30,   0,  /* "airs" 7565 */
     21,   4,  14,   3,   4,  39,  12,   0,  /* "airstrike" 7573 */
     21,   4,  14,   3,   4,  39,  12,  14,   0,  /* "airstrikes" 7582 */
     21,   4,   3,  39,   3,   0,  /* "airtight" 7588 */
     21,   4,   3,  39,  17,   0,  /* "airtime" 7594 */
     21,   4,   3,  35,  42,   0,  /* "airtouch" 7600 */
     21,   4,  47,  31,  32,   0,  /* "airwing" 7606 */
     21,   4,  26,   0,  /* "airy" 7610 */
     39,  30,   0,  /* "ais" 7613 */
     39,  23,  14,   1,   0,  /* "aisa" 7618 */
     39,   7,   0,  /* "aisle" 7621 */
     39,   7,  30,   0,  /* "aisles" 7625 */
      2,  42,  31,  14,   1,  13,   0,  /* "aitchison" 7632 */
      2,  16,  13,   0,  /* "aithne" 7636 */
     39,   3,  12,   1,  13,   0,  /* "aitken" 7642 */
     19,  23,   3,  27,  13,   0,  /* "aiton" 7648 */
     39,  47,   1,   0,  /* "aiwa" 7652 */
     39,   1,   0,  /* "aja" 7655 */
      1,  40,   8,  40,   0,  /* "ajaj" 7660 */
      2,  40,   8,  17,  26,   0,  /* "ajami" 7666 */
      1,  40,   8,   4,   0,  /* "ajar" 7671 */
      2,  40,  24,  12,  14,   0,  /* "ajax" 7677 */
      1,  40,   5,  13,   1,  17,  25,   3,  27,   0,  /* "ajinomoto" 7687 */
      1,  40,  23,   3,  27,   0,  /* "ajito" 7693 */
      8,  12,   1,   0,  /* "aka" 7697 */
      1,  12,  39,   0,  /* "akai" 7701 */
      1,  12,   8,  12,   1,   0,  /* "akaka" 7707 */
      1,  12,   8,   7,  26,   0,  /* "akali" 7713 */
     24,  12,   1,  17,  39,  13,   0,  /* "akamine" 7720 */
      1,  12,   8,  33,  26,   0,  /* "akashi" 7726 */
     24,  12,   9,  10,   0,  /* "akbar" 7731 */
     24,  12,   0,  /* "akc" 7734 */
      2,  12,   0,  /* "ake" 7737 */
     24,  12,  26,   9,  25,  13,  27,   0,  /* "akebono" 7745 */
      1,  12,  21,   7,   0,  /* "akel" 7750 */
      2,  12,   1,  13,   0,  /* "aken" 7755 */
     24,  12,  10,   0,  /* "aker" 7759 */
      1,  12,  44,   7,  26,   0,  /* "akerley" 7765 */
     24,  12,  10,  17,   1,  13,   0,  /* "akerman" 7772 */
      2,  12,  10,  30,   0,  /* "akers" 7777 */
     24,  12,  10,  14,   1,  13,   0,  /* "akerson" 7784 */
      1,  12,  23,   0,  /* "akey" 7788 */
      8,  12,  26,   0,  /* "aki" 7792 */
      8,  12,  26,  38,  23,   3,  25,   0,  /* "akihito" 7800 */
      1,  12,   5,  17,   9,  25,   0,  /* "akimbo" 7807 */
      1,  12,   5,  13,   0,  /* "akin" 7812 */
      1,  12,   5,  13,  30,   0,  /* "akins" 7818 */
      8,  12,  26,  27,   0,  /* "akio" 7823 */
      1,  12,  23,   4,   1,   0,  /* "akira" 7829 */
      1,  12,  23,   3,   1,   0,  /* "akita" 7835 */
      1,  12,  23,  22,   1,   0,  /* "akiva" 7841 */
     19,  12,  26,  41,   8,  17,   1,   0,  /* "akiyama" 7849 */
      1,  12,   2,  20,  26,   1,  13,   0,  /* "akkadian" 7857 */
     24,  12,  10,   0,  /* "akre" 7861 */
      1,  12,   4,   5,  40,   0,  /* "akridge" 7867 */
     24,  12,  14,   7,  10,   0,  /* "aksler" 7873 */
     24,  12,  14,   3,   0,  /* "akst" 7878 */
     24,  12,   1,  41,   8,  13,   1,  17,   1,   0,  /* "akyanama" 7888 */
     24,  12,  30,  27,   0,  /* "akzo" 7893 */
     24,   7,   0,  /* "al" 7896 */
      2,   7,   1,   0,  /* "ala" 7900 */
     24,   7,   1,   9,  24,  17,   1,   0,  /* "alabama" 7908 */
     24,   7,   1,   9,  24,  17,   1,  13,   0,  /* "alabaman" 7917 */
     24,   7,   1,   9,  24,  17,   1,  13,  30,   0,  /* "alabamans" 7927 */
     24,   7,   1,   9,  24,  14,   3,  10,   0,  /* "alabaster" 7936 */
      1,   7,  24,  42,  29,   1,   0,  /* "alachua" 7943 */
      1,   7,  24,  20,   1,  13,   0,  /* "aladdin" 7950 */
     24,   7,   1,  40,  15,  17,   0,  /* "alagem" 7957 */
     19,   7,   8,  11,  13,   1,   0,  /* "alagna" 7964 */
     24,   7,   1,  11,  25,  30,   0,  /* "alagoas" 7971 */
      1,   7,  39,   0,  /* "alai" 7975 */
      1,   7,   2,  13,   0,  /* "alain" 7980 */
      1,   7,   2,  13,   0,  /* "alaine" 7985 */
      1,   7,  24,  17,   0,  /* "alam" 7990 */
      1,   7,  24,  17,  12,  27,   0,  /* "alamco" 7997 */
     24,   7,   1,  17,  23,  20,   1,   0,  /* "alameda" 8005 */
     24,   7,   1,  17,  39,  13,   0,  /* "alamein" 8012 */
     24,   7,   1,  17,  27,   0,  /* "alamo" 8018 */
     24,   7,   1,  17,  27,  30,   0,  /* "alamos" 8025 */
      8,   7,  19,  17,  29,  20,  26,   0,  /* "alamoudi" 8033 */
     24,   7,   1,  13,   0,  /* "alan" 8038 */
     19,   7,  24,  13,   1,   0,  /* "alana" 8044 */
     24,   7,   1,  13,  20,   0,  /* "aland" 8050 */
      1,   7,   2,  13,   0,  /* "alane" 8055 */
     19,   7,   8,  13,   5,  14,   0,  /* "alanis" 8062 */
     24,   7,   1,  13,   1,  30,   0,  /* "alaniz" 8069 */
     24,   7,  34,  13,   0,  /* "alann" 8074 */
      2,   7,   8,   4,   0,  /* "alar" 8079 */
      1,   7,   8,   4,  12,   8,  13,   0,  /* "alarcon" 8087 */
      1,   7,   8,   4,  20,   0,  /* "alard" 8093 */
     24,   7,  10,  31,  12,   0,  /* "alaric" 8099 */
     19,   7,  19,   4,  23,  12,   1,   0,  /* "alarica" 8107 */
     19,   7,   8,   4,   5,  14,   0,  /* "alarice" 8114 */
      1,   7,  24,  14,   0,  /* "alas" 8119 */
     24,   7,   1,  14,   3,  21,   4,   0,  /* "alastair" 8127 */
     24,   7,   1,  14,   3,  10,   0,  /* "alaster" 8134 */
     19,   7,  19,   3,  18,   4,  26,   0,  /* "alatorre" 8142 */
     24,   7,   9,   1,   0,  /* "alba" 8147 */
      8,   7,   9,   1,  13,   0,  /* "alban" 8153 */
     19,   7,   9,  19,  13,   2,  30,  26,   0,  /* "albanese" 8162 */
     34,   7,   9,   8,  13,  26,   0,  /* "albani" 8169 */
     34,   7,   9,   2,  13,  26,   1,   0,  /* "albania" 8177 */
     34,   7,   9,   2,  13,  26,   1,  13,   0,  /* "albanian" 8186 */
     34,   7,   9,   2,  13,  26,   1,  13,  30,   0,  /* "albanians" 8196 */
     19,   7,   9,   8,  13,  27,   0,  /* "albano" 8203 */
     24,   7,   9,  34,  13,  30,   0,  /* "albans" 8210 */
     18,   7,   9,   1,  13,  26,   0,  /* "albany" 8217 */
     19,   7,   9,  19,   4,   8,  20,  27,   0,  /* "albarado" 8226 */
     24,   7,   9,  24,   4,   1,  13,   0,  /* "albarran" 8234 */
     24,   7,   9,   1,   3,   4,   8,  14,   0,  /* "albatross" 8243 */
     24,   7,   9,   1,   3,   4,   8,  14,   1,  30,   0,  /* "albatrosses" 8254 */
      1,   7,   9,  18,   0,  /* "albaugh" 8259 */
      1,   7,   9,  23,   0,  /* "albee" 8264 */
     36,   7,   9,  23,   1,   3,   0,  /* "albeit" 8271 */
     18,   7,   9,   1,  13,   0,  /* "alben" 8277 */
     19,   7,   9,  21,   4,  11,  27,   0,  /* "albergo" 8285 */
     19,   7,   9,  10,  23,  12,  27,   0,  /* "alberico" 8293 */
     18,   7,   9,  10,  30,   0,  /* "albers" 8299 */
     34,   7,   9,  44,   3,   1,   0,  /* "alberta" 8306 */
     24,   7,   9,  10,  16,  18,   7,   0,  /* "alberthal" 8314 */
     19,   7,   9,  21,   4,   3,  26,   0,  /* "alberti" 8322 */
     19,   7,   9,  10,   3,  23,  13,   1,   0,  /* "albertina" 8331 */
     19,   7,   9,  10,   3,  23,  13,  26,   0,  /* "albertini" 8340 */
     34,   7,   9,  44,   3,  27,   0,  /* "alberto" 8347 */
     34,   7,   9,  44,   3,   1,  14,   0,  /* "albertus" 8355 */
     24,   7,   9,  10,   3,  22,   5,   7,   0,  /* "albertville" 8364 */
      1,   7,   9,  44,   3,  26,   0,  /* "alberty" 8371 */
     18,   7,   9,  26,   0,  /* "albie" 8376 */
     24,   7,   9,   5,  13,   0,  /* "albin" 8382 */
     34,   7,   9,  39,  13,  25,   0,  /* "albino" 8389 */
     24,   7,   9,  26,   1,  13,   0,  /* "albion" 8396 */
     19,   7,   9,  39,   4,  31,  12,   0,  /* "albiric" 8404 */
     24,   7,   9,  27,   0,  /* "albo" 8409 */
     18,   7,   9,   4,  21,  12,   3,   0,  /* "albrecht" 8417 */
     18,   7,   9,   4,  39,   3,   0,  /* "albright" 8424 */
     24,   7,   9,   4,   5,   3,  19,  13,   0,  /* "albritton" 8433 */
     34,   7,   9,  41,  29,  17,   1,  13,   0,  /* "albumin" 8442 */
     24,   7,   9,  41,  29,  13,  15,  12,  14,   0,  /* "albunex" 8452 */
     24,   7,   9,   1,  12,  10,  12,  26,   0,  /* "albuquerque" 8461 */
     24,   7,   9,  15,   4,  26,   0,  /* "albury" 8468 */
     24,   7,   9,  41,  29,   3,  10,  36,   7,   0,  /* "albuterol" 8478 */
     19,   7,  12,   8,   7,   1,   0,  /* "alcala" 8485 */
     24,   7,  12,  24,  13,   0,  /* "alcan" 8491 */
     19,   7,  12,  19,  13,   3,   8,   4,   1,   0,  /* "alcantara" 8501 */
     19,   7,  12,   8,   4,  19,  30,   0,  /* "alcaraz" 8509 */
     34,   7,  12,   8,  14,   1,   0,  /* "alcasa" 8516 */
     24,   7,  12,   1,   3,   4,  24,  30,   0,  /* "alcatraz" 8525 */
     24,   7,  14,  26,   0,  /* "alcee" 8530 */
     34,   7,  12,  21,  17,   1,  12,   7,  26,   0,  /* "alchemically" 8540 */
     24,   7,  42,   1,  17,   1,  14,   3,   0,  /* "alchemist" 8549 */
     24,   7,  12,   1,  17,  26,   0,  /* "alchemy" 8556 */
     24,   7,  14,  39,  20,   0,  /* "alcide" 8562 */
     19,   7,  42,  23,  13,   1,   0,  /* "alcina" 8569 */
     24,   7,  12,  27,   0,  /* "alco" 8574 */
     24,   7,  12,  27,   1,   0,  /* "alcoa" 8580 */
      1,   7,  12,  25,  14,  10,   0,  /* "alcocer" 8587 */
      1,   7,  12,   8,  12,   0,  /* "alcock" 8593 */
     24,   7,  12,   1,  38,   8,   7,   0,  /* "alcohol" 8601 */
     24,   7,  12,   1,  38,  18,   7,   5,  30,   1,  17,   0,  /* "alcoholism" 8613 */
      1,   7,  12,   8,  13,   0,  /* "alcon" 8619 */
     19,   7,  12,  18,   4,   3,   1,   0,  /* "alcorta" 8627 */
      8,   7,  20,   1,   0,  /* "alda" 8632 */
     19,   7,  20,   8,  12,  27,   0,  /* "aldaco" 8639 */
     19,   7,  20,   8,  17,   1,   0,  /* "aldama" 8646 */
     19,   7,  20,  24,  13,   1,   0,  /* "aldana" 8653 */
     19,   7,  20,   8,   6,  28,   0,  /* "aldape" 8660 */
     24,   7,  20,  28,   0,  /* "alday" 8665 */
     34,   7,  20,  21,   9,  10,   1,  13,   0,  /* "aldebaran" 8674 */
      8,   7,  20,   1,  13,   0,  /* "alden" 8680 */
      1,   7,  20,  44,  12,  26,   0,  /* "aldercy" 8687 */
     24,   7,  20,  10,  26,   3,   0,  /* "alderete" 8694 */
     24,   7,  20,  10,  37,  10,   0,  /* "alderfer" 8701 */
      8,   7,  20,  10,  31,  40,   0,  /* "alderidge" 8708 */
      8,   7,  20,  26,   0,  /* "aldi" 8713 */
     18,   7,  20,  31,  12,   8,   4,   9,   0,  /* "aldicarb" 8722 */
     24,   7,  20,   5,   7,   1,   0,  /* "aldila" 8729 */
     19,   7,  20,  23,  13,   0,  /* "aldin" 8735 */
     18,   7,  20,  31,  32,  10,   0,  /* "aldinger" 8742 */
      8,   7,  20,  27,   0,  /* "aldo" 8747 */
     19,   7,  20,  18,   4,   1,   0,  /* "aldora" 8754 */
     24,   7,  20,  10,  20,   0,  /* "aldred" 8760 */
     18,   7,  20,   4,  15,  40,   0,  /* "aldredge" 8767 */
     24,   7,  20,   4,  31,  12,   0,  /* "aldric" 8774 */
     18,   7,  20,   4,  31,  42,   0,  /* "aldrich" 8781 */
     18,   7,  20,  47,   5,  13,   0,  /* "aldwin" 8788 */
     18,   7,  20,  47,   5,  13,   0,  /* "aldwyn" 8795 */
      8,   7,  20,  26,  14,   0,  /* "aldys" 8801 */
      2,   7,   0,  /* "ale" 8804 */
      2,   7,  26,   1,   3,  18,   4,  26,   0,  /* "aleatory" 8813 */
     24,   7,  31,  12,   0,  /* "alec" 8818 */
     19,   7,   2,  20,   1,   0,  /* "aleda" 8824 */
     19,   7,  21,  11,   4,  26,   0,  /* "alegre" 8831 */
     24,   7,   1,  11,   4,   1,   3,   0,  /* "alegrett" 8839 */
      1,   7,  21,  11,   4,  26,   1,   0,  /* "alegria" 8847 */
      2,   7,  38,  48,  14,   0,  /* "alehouse" 8853 */
      1,   7,  21,  38,  15,  17,   0,  /* "aleichem" 8860 */
     19,   7,  28,  41,   8,  13,  20,   4,  28,   0,  /* "alejandre" 8870 */
     19,   7,  28,  41,   8,  13,  20,   4,  27,   0,  /* "alejandro" 8880 */
     19,   7,   2,  41,  27,   0,  /* "alejo" 8886 */
     19,   7,   2,  41,  27,  30,   0,  /* "alejos" 8893 */
     24,   7,   1,  11,  30,  24,  13,  20,  10,   0,  /* "aleksander" 8903 */
     24,   7,   1,  11,  30,  24,  13,  20,  10,   0,  /* "aleksandr" 8913 */
      2,   7,  17,   1,  13,   0,  /* "aleman" 8919 */
     19,   7,   2,  13,   1,   0,  /* "alena" 8925 */
      1,   7,  21,  13,  20,   4,   1,  13,   0,  /* "alendrin" 8934 */
      1,   7,  23,  13,  26,   1,   0,  /* "alenia" 8941 */
      8,   7,  26,  27,   0,  /* "aleo" 8946 */
      8,   7,   1,  37,   0,  /* "aleph" 8951 */
      1,   7,  23,   4,  26,   1,   0,  /* "aleria" 8958 */
     19,   7,  15,   4,  18,  13,   0,  /* "aleron" 8965 */
      1,   7,  44,   3,   0,  /* "alert" 8970 */
      1,   7,  44,   3,  31,  32,   0,  /* "alerting" 8977 */
      1,   7,  44,   3,  13,   1,  14,   0,  /* "alertness" 8985 */
      1,   7,  44,   3,  14,   0,  /* "alerts" 8991 */
      2,   7,  30,   0,  /* "ales" 8995 */
     19,   7,  28,  33,   5,   4,  28,   0,  /* "aleshire" 9003 */
     24,   7,  15,  14,  24,  13,  20,   4,   1,   0,  /* "alessandra" 9013 */
     19,   7,  15,  14,  19,  13,  20,   4,  23,  13,  26,   0,  /* "alessandrini" 9025 */
     19,   7,  28,  30,   8,  13,  20,   4,  27,   0,  /* "alessandro" 9035 */
      1,   7,  21,  14,  26,   0,  /* "alessi" 9041 */
      1,   7,  21,  14,  26,  27,   0,  /* "alessio" 9048 */
     19,   7,  21,   3,   1,   0,  /* "aleta" 9054 */
     24,   7,   1,  16,  23,   1,   0,  /* "alethea" 9061 */
      1,   7,  29,  33,   1,  13,   0,  /* "aleutian" 9068 */
      1,   7,  29,  33,   1,  13,  30,   0,  /* "aleutians" 9076 */
      2,   7,  47,  39,  37,   0,  /* "alewife" 9082 */
      2,   7,  47,  39,  13,   0,  /* "alewine" 9088 */
      2,   7,  47,  39,  22,  30,   0,  /* "alewives" 9095 */
     24,   7,   1,  12,  14,   0,  /* "alex" 9101 */
      1,   7,  21,  12,  14,   1,   0,  /* "alexa" 9108 */
     24,   7,   1,  11,  30,  24,  13,  20,  10,   0,  /* "alexander" 9118 */
     24,   7,  31,  11,  30,  24,  13,  20,  10,  30,   0,  /* "alexanders" 9129 */
     24,   7,  15,  11,  30,  24,  13,  20,   4,   1,   0,  /* "alexandra" 9140 */
     34,   7,  31,  12,  14,   8,  13,  20,  10,   0,  /* "alexandre" 9150 */
     24,   7,   1,  11,  30,  24,  13,  20,   4,  26,   1,   0,  /* "alexandria" 9162 */
     24,   7,   1,  11,  30,  24,  13,  20,   4,  26,  13,   0,  /* "alexandrine" 9174 */
     24,   7,   1,  11,  30,  24,  13,  20,   4,  26,  13,  30,   0,  /* "alexandrines" 9187 */
      1,   7,  21,  12,  14,   2,   0,  /* "alexei" 9194 */
      1,   7,  21,  12,  14,  26,   0,  /* "alexi" 9201 */
      1,   7,  21,  12,  14,  26,   1,   0,  /* "alexia" 9209 */
      1,   7,  21,  12,  14,  39,  13,   0,  /* "alexine" 9217 */
      1,   7,  21,  12,  14,   5,  14,   0,  /* "alexis" 9225 */
     34,   7,  31,  11,  30,   8,   6,   1,   7,   5,  14,   0,  /* "alexopoulos" 9237 */
      1,   7,  23,  12,  14,  26,   0,  /* "alexy" 9244 */
      2,   7,  26,   0,  /* "aley" 9248 */
     24,   7,  37,   0,  /* "alf" 9252 */
     24,   7,  37,   1,   0,  /* "alfa" 9257 */
     24,   7,  37,  24,   7,  37,   1,   0,  /* "alfalfa" 9265 */
     19,   7,  37,   8,  13,  27,   0,  /* "alfano" 9272 */
     24,   7,  37,   1,   4,  21,  20,   1,   0,  /* "alfareda" 9281 */
     19,   7,  37,   8,   4,  27,   0,  /* "alfaro" 9288 */
     24,   7,  37,   1,  22,   5,   7,  26,   0,  /* "alfavilli" 9297 */
     19,   7,  37,   5,   4,  26,   0,  /* "alfieri" 9304 */
     24,   7,  37,  26,  21,   4,  27,   0,  /* "alfiero" 9312 */
     34,   7,  37,  25,  13,  27,   0,  /* "alfono" 9319 */
      8,   7,  37,  27,  13,  30,   0,  /* "alfons" 9326 */
     24,   7,  37,  19,  13,  14,   0,  /* "alfonse" 9333 */
     24,   7,  37,   8,  13,  14,   5,  13,   0,  /* "alfonsin" 9342 */
     19,   7,  37,  27,  13,  14,  23,  13,  26,   0,  /* "alfonsine" 9352 */
     24,   7,  40,  26,   0,  /* "algae" 9357 */
     24,   7,  11,   1,   7,   0,  /* "algal" 9363 */
     19,   7,  11,   8,   4,   0,  /* "algar" 9369 */
     24,   7,  11,  10,   1,  13,   0,  /* "algarin" 9376 */
     24,   7,  40,   1,   9,   4,   2,  31,  12,   7,  26,   0,  /* "algebraically" 9388 */
     24,   7,  11,   1,  17,  23,  13,   0,  /* "algemene" 9396 */
     24,   7,  40,  10,   0,  /* "alger" 9401 */
     34,   7,  40,   5,   4,  26,   1,   0,  /* "algeria" 9409 */
     34,   7,  40,   5,   4,  26,   1,  13,   0,  /* "algerian" 9418 */
     34,   7,  40,  23,   4,  26,   1,  13,  30,   0,  /* "algerians" 9428 */
     24,   7,  40,  10,  13,  19,  13,   0,  /* "algernon" 9436 */
     18,   7,  11,  26,   0,  /* "algie" 9441 */
     34,   7,  40,   5,   4,  30,   0,  /* "algiers" 9448 */
     24,   7,  11,  19,   7,   0,  /* "algol" 9454 */
     24,   7,  11,   1,  17,   0,  /* "algom" 9460 */
     34,   7,  11,   8,  32,  12,  26,   1,  13,   0,  /* "algonquian" 9470 */
     34,   7,  11,   8,  32,  12,  47,   1,  13,   0,  /* "algonquin" 9480 */
     24,   7,  11,  10,   5,  46,   1,  17,   0,  /* "algorithm" 9489 */
     24,   7,  11,  10,   5,  46,   1,  17,  30,   0,  /* "algorithms" 9499 */
     19,   7,  11,  47,   5,   4,  28,   0,  /* "alguire" 9507 */
     24,   7,  40,  26,   0,  /* "algy" 9512 */
     24,   7,   1,  20,  15,  37,   0,  /* "alhadeff" 9519 */
      8,   7,  26,   0,  /* "ali" 9523 */
     19,   7,  26,   8,  13,  27,   0,  /* "aliano" 9530 */
     24,   7,  26,  24,  13,  30,   1,   0,  /* "alianza" 9538 */
      2,   7,  26,   1,  14,   0,  /* "alias" 9544 */
     19,   7,  26,   9,  21,   4,   3,  26,   0,  /* "aliberti" 9553 */
     24,   7,   1,   9,  39,   0,  /* "alibi" 9559 */
     24,   7,   1,   9,  39,  30,   0,  /* "alibis" 9566 */
     24,   7,   1,  14,   0,  /* "alice" 9571 */
      1,   7,   5,  14,  26,   1,   0,  /* "alicea" 9578 */
     24,   7,  26,   0,  /* "alie" 9582 */
      2,   7,  26,   1,  13,   0,  /* "alien" 9588 */
      2,   7,  41,   1,  13,   2,   3,   0,  /* "alienate" 9596 */
      2,   7,  26,   1,  13,  30,   0,  /* "aliens" 9603 */
     24,   7,  31,  11,   0,  /* "alig" 9608 */
      1,   7,  39,   3,   0,  /* "alight" 9613 */
      1,   7,  39,  13,   0,  /* "align" 9618 */
      1,   7,  39,  13,  20,   0,  /* "aligned" 9624 */
      1,   7,  39,  13,  31,  32,   0,  /* "aligning" 9631 */
      1,   7,  39,  13,  17,   1,  13,   3,   0,  /* "alignment" 9640 */
      1,   7,  39,  13,  17,   1,  13,   3,  14,   0,  /* "alignments" 9650 */
      1,   7,  39,  13,  30,   0,  /* "aligns" 9656 */
      1,   7,  39,  40,   1,   0,  /* "alija" 9662 */
      1,   7,  39,  12,   0,  /* "alike" 9667 */
      1,   7,  39,  12,  14,   0,  /* "alikes" 9673 */
     19,   7,  23,  17,   1,   0,  /* "alima" 9679 */
     24,   7,   1,  17,  21,  13,  26,  30,   0,  /* "alimenies" 9688 */
      1,   7,  39,  13,   0,  /* "aline" 9693 */
      1,   7,  39,  13,  30,   0,  /* "alines" 9699 */
     19,   7,  26,  25,   3,  27,   0,  /* "alioto" 9706 */
     24,   7,   1,  12,  47,   5,   6,   1,   0,  /* "aliquippa" 9715 */
     24,   7,   1,  12,  47,   5,   6,   1,  30,   0,  /* "aliquippas" 9725 */
     19,   7,   5,   4,  28,   0,  /* "alire" 9731 */
      1,   7,   5,  14,  12,  26,   0,  /* "alisky" 9738 */
      1,   7,   5,  14,   1,   0,  /* "alissa" 9744 */
     19,   7,  23,   3,   1,   0,  /* "alita" 9750 */
     24,   7,   1,   3,   2,   7,  26,   1,   0,  /* "alitalia" 9759 */
      1,   7,  39,  22,   0,  /* "alive" 9764 */
     24,   7,  31,  12,  14,   0,  /* "alix" 9770 */
     24,   7,  12,   1,   0,  /* "alka" 9775 */
     24,   7,  12,   1,  38,  21,  14,   3,   0,  /* "alkahest" 9784 */
     24,   7,  12,   1,   7,  39,   0,  /* "alkali" 9791 */
     24,   7,  12,   1,   7,  39,  30,   0,  /* "alkalies" 9799 */
     24,   7,  12,   1,   7,  39,  13,   0,  /* "alkaline" 9807 */
     34,   7,  12,   1,   7,  49,  20,   1,   7,   0,  /* "alkaloidal" 9817 */
     24,   7,  12,   1,  17,   1,   0,  /* "alkema" 9824 */
     24,   7,  12,  23,  13,  30,   0,  /* "alkenes" 9831 */
      1,   7,  12,  39,   4,   0,  /* "alkire" 9837 */
     18,   7,   0,  /* "all" 9840 */
      8,   7,   1,   0,  /* "alla" 9844 */
      8,   7,   1,   0,  /* "allah" 9848 */
     19,   7,  21,   4,   0,  /* "allaire" 9853 */
     24,   7,   1,  13,   0,  /* "allan" 9858 */
     24,   7,   8,  13,   3,  28,   0,  /* "allante" 9865 */
      1,   7,   8,   4,   0,  /* "allar" 9870 */
     24,   7,  10,  20,   0,  /* "allard" 9875 */
      1,   7,   2,   0,  /* "allay" 9879 */
      1,   7,   9,  18,   0,  /* "allbaugh" 9884 */
     18,   7,   9,   4,  39,   3,   0,  /* "allbright" 9891 */
     24,   7,   9,   4,   5,   3,   1,  13,   0,  /* "allbritten" 9900 */
     24,   7,   9,   4,   5,   3,  19,  13,   0,  /* "allbritton" 9909 */
      1,   7,  12,  18,   4,  13,   0,  /* "allcorn" 9916 */
      8,   7,  20,  10,  20,  39,  14,   0,  /* "allderdice" 9924 */
      1,   7,  20,   4,  21,  40,   0,  /* "alldredge" 9931 */
      1,   7,  23,   0,  /* "allee" 9935 */
      1,   7,  21,  40,   0,  /* "allege" 9940 */
      1,   7,  21,  40,  20,   0,  /* "alleged" 9946 */
      1,   7,  21,  40,   1,  20,   7,  26,   0,  /* "allegedly" 9955 */
      1,   7,  21,  40,   1,  30,   0,  /* "alleges" 9962 */
     24,   7,   1,  11,   2,  13,  26,   0,  /* "alleghany" 9970 */
     24,   7,   1,  11,   2,  13,  26,   0,  /* "allegheny" 9978 */
      1,   7,  23,  40,   1,  13,  14,   0,  /* "allegiance" 9986 */
     24,   7,  23,  40,  26,  24,  13,  14,   1,  30,   0,  /* "allegiances" 9997 */
      1,   7,  21,  40,  31,  32,   0,  /* "alleging" 10004 */
     24,   7,   2,  40,   1,  14,   0,  /* "allegis" 10011 */
     24,   7,   1,  11,  18,   4,   1,  12,   1,   7,   0,  /* "allegorical" 10022 */
     24,   7,   1,  11,  18,   4,  26,  30,   0,  /* "allegories" 10031 */
     24,   7,   1,  11,  18,   4,  26,   0,  /* "allegory" 10039 */
     19,   7,  21,  11,   4,   1,   0,  /* "allegra" 10046 */
     19,   7,  15,  11,   4,  21,   3,  26,   0,  /* "allegretti" 10055 */
      1,   7,  21,  11,   4,  25,   0,  /* "allegro" 10062 */
      1,   7,  21,   7,  26,   0,  /* "allele" 10068 */
      1,   7,  21,   7,  26,  30,   0,  /* "alleles" 10075 */
      1,   7,  21,   7,  31,  12,   0,  /* "allelic" 10082 */
      2,   7,  17,   1,  13,   0,  /* "alleman" 10088 */
     24,   7,   1,  17,   1,  13,  20,   0,  /* "allemand" 10096 */
      1,   7,  21,  13,   9,  36,   0,  /* "allenbaugh" 10103 */
     24,   7,   1,  13,  20,   2,   7,   0,  /* "allendale" 10111 */
      8,  41,  21,  13,  20,  28,   0,  /* "allende" 10118 */
     19,   7,  41,  21,  13,  20,  28,  10,   0,  /* "allender" 10127 */
     24,   7,   1,  13,  20,  36,   4,  37,   0,  /* "allendorf" 10136 */
     24,   7,   1,  13,  38,  44,  14,   3,   0,  /* "allenhurst" 10145 */
     24,   7,   1,  13,  30,   9,   8,  12,   0,  /* "allensbach" 10154 */
     24,   7,   1,  13,   3,  48,  13,   0,  /* "allentown" 10162 */
     18,   7,  10,   0,  /* "aller" 10166 */
     24,   7,  10,  40,   1,  13,   0,  /* "allergan" 10173 */
     24,   7,  10,  40,   1,  13,   0,  /* "allergen" 10180 */
     24,   7,  10,  40,   1,  13,  30,   0,  /* "allergens" 10188 */
      1,   7,  44,  40,  31,  12,   0,  /* "allergic" 10195 */
     18,   7,  10,  30,   0,  /* "allers" 10200 */
      2,   7,  30,   0,  /* "alles" 10204 */
     19,   7,   2,  22,   1,   0,  /* "alleva" 10210 */
      1,   7,  23,  22,  26,   2,   3,   0,  /* "alleviate" 10218 */
      1,   7,  23,  22,  26,   2,   3,   1,  20,   0,  /* "alleviated" 10228 */
      1,   7,  23,  22,  26,  28,   3,  14,   0,  /* "alleviates" 10237 */
      1,   7,  23,  22,  26,   2,   3,  31,  32,   0,  /* "alleviating" 10247 */
      1,   7,  23,  22,  26,   2,  33,   1,  13,   0,  /* "alleviation" 10257 */
     24,   7,   2,  13,   0,  /* "alleyne" 10262 */
     24,   7,  11,  39,  10,   0,  /* "allgeier" 10268 */
     18,   7,  11,   1,  17,  39,  13,   0,  /* "allgemeine" 10276 */
     24,   7,  11,  26,  10,   0,  /* "allgeyer" 10282 */
     18,   7,  11,  45,  20,   0,  /* "allgood" 10288 */
     24,   7,  26,   0,  /* "alli" 10292 */
      1,   7,  39,   1,  13,  14,   0,  /* "alliance" 10299 */
      1,   7,  39,   1,  13,  14,   1,  30,   0,  /* "alliances" 10308 */
      1,   7,  39,   1,  13,   3,   0,  /* "alliant" 10315 */
      1,   7,  39,  20,   0,  /* "allied" 10320 */
     24,   7,  39,  20,  14,   5,  11,  13,   1,   7,   0,  /* "alliedsignal" 10331 */
     24,   7,  39,  30,   0,  /* "allies" 10336 */
      1,   7,  39,  30,   0,  /* "allies" 10341 */
      1,   7,   5,  13,   0,  /* "allin" 10346 */
     24,   7,   1,  13,  20,  10,   0,  /* "allinder" 10353 */
     18,   7,  31,  32,   0,  /* "alling" 10358 */
     18,   7,  31,  32,  10,   0,  /* "allinger" 10364 */
     18,   7,  31,  32,  38,  24,  17,   0,  /* "allingham" 10372 */
     18,   7,  31,  32,   3,   1,  13,   0,  /* "allington" 10380 */
     24,   7,   1,  13,  14,   1,  13,   0,  /* "allinson" 10388 */
     18,   7,   1,  14,   3,  10,   0,  /* "allister" 10395 */
     24,   7,   1,  14,   3,  19,  13,   0,  /* "alliston" 10403 */
      1,   7,   5,   3,  10,   2,  33,   1,  13,   0,  /* "alliteration" 10413 */
      1,   7,   5,   3,  10,   1,   3,  31,  22,   0,  /* "alliterative" 10423 */
     24,   7,  17,  15,  13,  20,  31,  32,  10,   0,  /* "allmendinger" 10433 */
      1,   7,  17,   8,  13,  20,   0,  /* "allmond" 10440 */
      1,   7,  13,  35,   3,   0,  /* "allnutt" 10446 */
     24,   7,   1,  12,   2,   3,   0,  /* "allocate" 10453 */
     24,   7,   8,  12,  27,   0,  /* "allocco" 10459 */
     24,   7,   1,  17,  36,   4,  37,   0,  /* "allomorph" 10467 */
     24,   7,   1,  17,  36,   4,  37,  14,   0,  /* "allomorphs" 10476 */
     18,   7,  10,   0,  /* "allor" 10480 */
      1,   7,   8,   3,   0,  /* "allot" 10485 */
      1,   7,   8,   3,   1,  20,   0,  /* "alloted" 10492 */
      1,   7,   8,   3,  17,   1,  13,   3,   0,  /* "allotment" 10501 */
      1,   7,   8,   3,  17,   1,  13,   3,  14,   0,  /* "allotments" 10511 */
      1,   7,   8,   3,  14,   0,  /* "allots" 10517 */
      1,   7,   8,   3,   1,  20,   0,  /* "allotted" 10524 */
      1,   7,   8,   3,  31,  32,   0,  /* "allotting" 10531 */
      1,   7,  48,   0,  /* "allow" 10535 */
      1,   7,  48,   1,   9,   1,   7,   0,  /* "allowable" 10543 */
      1,   7,  48,   1,  13,  14,   0,  /* "allowance" 10550 */
      1,   7,  48,   1,  13,  14,   1,  30,   0,  /* "allowances" 10559 */
      1,   7,  48,  20,   0,  /* "allowed" 10564 */
      1,   7,  48,  31,  32,   0,  /* "allowing" 10570 */
      1,   7,  48,  30,   0,  /* "allows" 10575 */
     24,   7,  49,   0,  /* "alloy" 10579 */
      1,   7,  37,   5,  13,   0,  /* "allphin" 10585 */
     24,   7,   4,   1,  20,   0,  /* "allred" 10591 */
     19,   7,   4,  39,   3,   0,  /* "allright" 10597 */
     18,   7,  30,   0,  /* "alls" 10601 */
     18,   7,  30,  38,  48,  14,   0,  /* "allshouse" 10608 */
     18,   7,  14,   6,  39,  14,   0,  /* "allspice" 10615 */
     24,   7,  14,   1,   6,   0,  /* "allsup" 10621 */
     18,   7,   3,  39,  17,   0,  /* "alltime" 10627 */
      1,   7,  29,  20,   0,  /* "allude" 10632 */
      1,   7,  29,  20,   1,  20,   0,  /* "alluded" 10639 */
      1,   7,  29,  20,  30,   0,  /* "alludes" 10645 */
      1,   7,  29,  20,  31,  32,   0,  /* "alluding" 10652 */
     24,   7,   1,  17,   0,  /* "allum" 10657 */
     24,   7,   1,  17,  30,   0,  /* "allums" 10663 */
      1,   7,  45,   4,  31,  32,   0,  /* "alluring" 10670 */
      1,   7,  29,  43,   1,  13,   0,  /* "allusion" 10677 */
      1,   7,  29,  43,   1,  13,  30,   0,  /* "allusions" 10685 */
      1,   7,  29,  14,  31,  22,   0,  /* "allusive" 10692 */
     24,   7,  29,  22,  26,   1,   7,   0,  /* "alluvial" 10700 */
      1,   7,  29,  22,  26,   1,  17,   0,  /* "alluvium" 10708 */
     18,   7,  47,   2,  14,   3,   0,  /* "allwaste" 10715 */
      8,   7,  47,  23,  14,   0,  /* "allweiss" 10721 */
     24,   7,  39,   0,  /* "ally" 10725 */
      1,   7,  39,   0,  /* "ally" 10729 */
     24,   7,  39,  31,  32,   0,  /* "allying" 10735 */
     24,   7,   5,  13,   0,  /* "allyn" 10740 */
     24,   7,  39,  30,   0,  /* "allys" 10745 */
     24,   7,   1,  14,   1,  13,   0,  /* "allyson" 10752 */
      8,  17,   0,  /* "alm" 10755 */
     24,   7,  17,   1,   0,  /* "alma" 10760 */
     18,   7,  17,   1,  20,   8,  13,  26,   0,  /* "almadani" 10769 */
     24,   7,  17,   1,  20,   1,  13,   0,  /* "almaden" 10777 */
     19,   7,  17,  19,  11,  47,  21,   4,   0,  /* "almaguer" 10786 */
     24,   7,  17,   1,  13,   0,  /* "alman" 10792 */
     18,   7,  17,   1,  13,  24,  12,   0,  /* "almanac" 10800 */
     24,   7,  17,   1,  13,  20,   0,  /* "almand" 10807 */
     19,   7,  17,  19,  13,  30,   8,   4,   0,  /* "almanzar" 10816 */
     19,   7,  17,   8,   4,  19,  30,   0,  /* "almaraz" 10824 */
     24,   7,  17,   1,  30,   0,  /* "almas" 10830 */
     24,   7,  17,   1,  14,  26,   0,  /* "almasy" 10837 */
     19,   7,  17,  19,  30,   8,  13,   0,  /* "almazan" 10845 */
     19,   7,  17,  28,  13,  20,   8,   4,  15,  30,   0,  /* "almendarez" 10856 */
     18,   7,  17,  10,   0,  /* "almer" 10861 */
     24,   7,  17,  11,   4,  15,  13,   0,  /* "almgren" 10869 */
     36,   7,  17,  39,   3,  26,   0,  /* "almighty" 10876 */
      8,   7,  17,  27,   0,  /* "almo" 10881 */
     19,   7,  17,  27,  20,  27,  22,   8,   4,   0,  /* "almodovar" 10891 */
      8,  17,   1,  13,  20,   0,  /* "almond" 10897 */
     19,   7,  17,  25,  13,   3,  28,   0,  /* "almonte" 10905 */
      8,   7,  17,  27,  14,   0,  /* "almos" 10911 */
     18,   7,  17,  25,  14,   3,   0,  /* "almost" 10918 */
     24,   7,  17,  12,  47,   5,  14,   3,   0,  /* "almquist" 10927 */
      8,   7,  17,  30,   0,  /* "alms" 10932 */
     18,  17,  26,   0,  /* "almy" 10936 */
     24,   7,  17,  26,  30,   0,  /* "almys" 10942 */
     24,   7,  25,   0,  /* "aloe" 10946 */
      1,   7,  18,  37,   3,   0,  /* "aloft" 10952 */
      1,   7,  25,  38,  19,   0,  /* "aloha" 10958 */
      8,   7,  50,   0,  /* "aloi" 10962 */
     19,   7,  49,  14,   0,  /* "alois" 10967 */
     19,   7,  49,  14,  26,   1,   0,  /* "aloisia" 10974 */
     19,   7,  49,  14,  26,  27,   0,  /* "aloisio" 10981 */
      1,   7,   8,  13,   0,  /* "alon" 10986 */
     24,   7,   1,  13,  40,   0,  /* "alonge" 10992 */
     19,   7,  25,  32,  11,  26,   0,  /* "alongi" 10999 */
      1,   7,  18,  32,  14,  39,  20,   0,  /* "alongside" 11007 */
      1,   7,  29,  37,   0,  /* "aloof" 11012 */
      1,   7,  29,  37,  13,   1,  14,   0,  /* "aloofness" 11020 */
      1,   7,   8,   3,   0,  /* "alot" 11025 */
     19,   7,  49,  14,  26,   1,   0,  /* "aloysia" 11032 */
     24,   7,  27,   5,  33,   1,  14,   0,  /* "aloysius" 11040 */
     24,   7,   6,   1,   0,  /* "alpa" 11045 */
     34,   7,   6,  24,  12,   1,   0,  /* "alpaca" 11052 */
      1,   7,   6,  18,   0,  /* "alpaugh" 11057 */
      1,   7,   6,  44,  13,   0,  /* "alpern" 11063 */
     24,   7,   6,  15,  12,  14,   0,  /* "alpex" 11070 */
     24,   7,  37,   1,   9,  21,   3,   1,  30,   2,  33,   1,  13,   0,  /* "alphabetization" 11084 */
     24,   7,  37,   1,   9,   1,   3,  39,  30,   0,  /* "alphabetize" 11094 */
     24,   7,  37,  24,  20,  10,  26,   0,  /* "alphandery" 11102 */
     24,   7,  37,   1,  13,  29,  17,  21,   4,  31,  12,   0,  /* "alphanumeric" 11114 */
     24,   7,  37,  10,  21,   7,   0,  /* "alpharel" 11121 */
     34,   7,  37,   8,  13,  30,   0,  /* "alphonse" 11128 */
      1,   7,  37,   8,  13,  14,  26,  13,   0,  /* "alphonsine" 11137 */
     34,   7,  37,   8,  13,  14,  27,   0,  /* "alphonso" 11145 */
      1,   7,   6,   5,  13,   0,  /* "alpin" 11151 */
     24,   7,   6,  39,  13,   0,  /* "alpine" 11157 */
     24,   7,   6,  27,   0,  /* "alpo" 11162 */
     24,   7,   6,  14,   0,  /* "alps" 11167 */
     36,   7,   4,  21,  20,  26,   0,  /* "already" 11174 */
     18,   7,   4,   1,  20,   0,  /* "alred" 11180 */
     18,   7,   4,  39,   3,   0,  /* "alright" 11186 */
      1,   7,   4,  49,   0,  /* "alroy" 11191 */
     24,   7,  30,   0,  /* "als" 11195 */
     24,   7,  30,   9,   4,  51,  12,   0,  /* "alsbrook" 11203 */
     18,   7,  30,   9,  15,   4,  26,   0,  /* "alsbury" 11211 */
     18,   7,  30,  20,  36,   4,  37,   0,  /* "alsdorf" 11219 */
     18,   7,  14,  27,   0,  /* "also" 11224 */
     24,   7,  14,   1,   9,   4,  51,  12,   0,  /* "alsobrook" 11233 */
     24,   7,  14,  19,   6,   0,  /* "alsop" 11239 */
      1,   7,  14,   6,  18,   0,  /* "alspaugh" 11245 */
     24,   7,  14,  16,   1,  17,   0,  /* "alsthom" 11252 */
     18,   7,  14,   3,   1,  13,   0,  /* "alston" 11259 */
      8,   7,   3,   0,  /* "alt" 11263 */
      8,   7,   3,   1,   0,  /* "alta" 11268 */
      8,   7,   3,   1,  20,  23,  13,   1,   0,  /* "altadena" 11277 */
     34,   7,   3,  39,   0,  /* "altai" 11282 */
     34,   7,   3,   2,  31,  12,   0,  /* "altaic" 11289 */
     19,   7,   3,  19,  17,  31,   4,   8,  13,  27,   0,  /* "altamirano" 11300 */
     18,   7,   3,  10,   0,  /* "altar" 11305 */
     18,   7,   3,  10,   6,  23,  14,   0,  /* "altarpiece" 11313 */
     18,   7,   3,   1,  22,   5,  14,   3,   1,   0,  /* "altavista" 11323 */
     18,   7,   3,  39,   0,  /* "altay" 11328 */
     24,   7,   3,   1,  17,  27,  14,   0,  /* "altemose" 11336 */
     24,   7,   3,   1,  17,   1,  14,   0,  /* "altemus" 11344 */
     24,   7,   3,   1,  13,  38,   1,  37,   1,  13,   0,  /* "altenhofen" 11355 */
      8,   7,   3,  10,  12,   2,  33,   1,  13,   0,  /* "altercation" 11365 */
      8,   7,   3,  10,  12,   2,  33,   1,  13,  30,   0,  /* "altercations" 11376 */
     24,   7,   3,  10,  11,   1,   3,   0,  /* "altergott" 11384 */
     36,   7,   3,  44,  13,   1,  12,  21,   4,   0,  /* "alternacare" 11394 */
     18,   7,   3,  10,  13,   1,   3,   0,  /* "alternate" 11402 */
     18,   7,   3,  10,  13,   2,   3,   0,  /* "alternate" 11410 */
     18,   7,   3,  10,  13,   2,  33,   1,  13,   0,  /* "alternation" 11420 */
     36,   7,   3,  44,  13,   1,   3,  31,  22,   0,  /* "alternative" 11430 */
     36,   7,   3,  44,  13,   1,   3,  31,  22,   7,  26,   0,  /* "alternatively" 11442 */
     36,   7,   3,  44,  13,   1,   3,  31,  22,  30,   0,  /* "alternatives" 11453 */
     18,   7,   3,  10,  13,   2,   3,  10,   0,  /* "alternator" 11462 */
      8,   7,   3,  37,  21,  14,   3,   0,  /* "altfest" 11470 */
     24,   7,   3,  38,  52,  14,   0,  /* "althaus" 11477 */
     24,   7,  16,   2,  22,  10,   0,  /* "althaver" 11484 */
     34,   7,  16,  23,   1,   0,  /* "althea" 11490 */
     24,   7,   3,  38,  36,  37,   0,  /* "althoff" 11497 */
     18,   7,  46,  25,   0,  /* "although" 11502 */
     18,   7,   3,  38,  48,  14,   0,  /* "althouse" 11509 */
      8,   7,   3,   5,  14,   0,  /* "altice" 11515 */
     18,   7,   3,  26,  10,   0,  /* "altier" 11521 */
     19,   7,   3,   5,   4,  26,   0,  /* "altieri" 11528 */
      8,   7,   3,   5,  17,   1,   0,  /* "altima" 11535 */
     34,   7,   3,   5,  17,   1,   3,  10,   0,  /* "altimeter" 11544 */
      8,   7,   3,  23,  17,  18,   4,   8,  13,  27,   0,  /* "altimorano" 11555 */
     24,   7,   3,   1,   6,   7,   8,  13,  25,   0,  /* "altiplano" 11565 */
     24,   7,   3,   1,   3,  29,  20,   0,  /* "altitude" 11573 */
     24,   7,   3,   1,   3,  29,  20,  30,   0,  /* "altitudes" 11582 */
     24,   7,   3,  39,  30,  10,   0,  /* "altizer" 11589 */
     18,   7,   3,  17,   1,  13,   0,  /* "altman" 11596 */
     18,   7,   3,  17,   1,  13,   0,  /* "altmann" 11603 */
     24,   7,   3,  27,   0,  /* "alto" 11608 */
     19,   7,   3,  27,   9,  21,   7,  26,   0,  /* "altobelli" 11617 */
     18,   7,   3,   1,  11,  21,  46,  10,   0,  /* "altogether" 11626 */
      1,   7,   3,   8,  17,   0,  /* "altom" 11632 */
     19,   7,   3,  27,  17,   8,   4,  26,   0,  /* "altomare" 11641 */
     18,   7,   3,   1,  13,   0,  /* "alton" 11647 */
     24,   7,   3,  29,  13,   1,   0,  /* "altoona" 11654 */
      8,   7,   3,   4,   1,   0,  /* "altra" 11660 */
     18,   7,   3,   4,  19,  13,   0,  /* "altron" 11667 */
     24,   7,   3,   4,  29,   5,  30,   1,  17,   0,  /* "altruism" 11677 */
     18,   7,   3,   4,  29,   5,  14,   3,  31,  12,   0,  /* "altruistic" 11688 */
     18,   7,  42,   5,   7,  10,   0,  /* "altschiller" 11695 */
     24,   7,  42,  41,  29,   7,  10,   0,  /* "altschuler" 11703 */
     24,   7,  42,  41,  29,   7,  10,   0,  /* "altshuler" 11711 */
     34,   7,   3,  35,  12,  10,   0,  /* "altucher" 11718 */
     19,   7,   3,  45,   4,   1,  14,   0,  /* "alturas" 11726 */
      8,   7,   3,  14,  38,  39,  17,  10,   0,  /* "altzheimer" 11735 */
      8,   7,  29,   0,  /* "alu" 11739 */
     24,   7,   1,  17,   0,  /* "alum" 11744 */
     24,   7,  29,  17,  34,  12,  14,   0,  /* "alumax" 11752 */
      1,   7,  35,  17,   9,  36,   0,  /* "alumbaugh" 11759 */
      1,   7,  29,  17,   1,  13,   1,   0,  /* "alumina" 11767 */
     24,   7,  29,  17,  23,  13,  26,  27,   0,  /* "aluminio" 11776 */
      1,   7,  29,  17,   1,  13,   1,  17,   0,  /* "aluminium" 11785 */
      1,   7,  29,  17,   1,  13,  39,  30,   0,  /* "aluminize" 11794 */
      1,   7,  29,  17,   1,  13,  39,  30,  20,   0,  /* "aluminized" 11804 */
      1,   7,  29,  17,   1,  13,  27,  14,   5,   7,   1,  12,   2,   3,   0,  /* "aluminosilicate" 11819 */
      1,   7,  29,  17,   1,  13,   1,  17,   0,  /* "aluminum" 11828 */
      1,   7,  35,  17,  13,  39,   0,  /* "alumni" 11835 */
      1,   7,  35,  17,  13,   1,  14,   0,  /* "alumnus" 11843 */
     24,   7,   1,  17,  30,   0,  /* "alums" 11849 */
      2,   7,   1,  13,   0,  /* "alun" 11854 */
     19,   7,  45,   4,   1,   0,  /* "alura" 11860 */
     24,   7,  41,  29,  14,  47,   5,  14,   0,  /* "alusuisse" 11869 */
     24,   7,  22,   1,   0,  /* "alva" 11874 */
     34,   7,  22,   8,   0,  /* "alvah" 11879 */
     24,   7,  22,  10,   8,  20,  27,   0,  /* "alvarado" 11887 */
     19,   7,  22,   8,   4,  20,  27,   0,  /* "alvardo" 11895 */
     24,   7,  22,   2,   4,   0,  /* "alvare" 11901 */
     19,   7,  22,  19,   4,  21,  32,  11,   1,   0,  /* "alvarenga" 11911 */
     19,   7,  22,   8,   4,  15,  14,   0,  /* "alvares" 11919 */
     24,   7,  22,  10,  21,  30,   0,  /* "alvarez" 11926 */
      1,   7,  22,   8,   4,  27,   0,  /* "alvaro" 11933 */
     34,   7,  22,  23,   1,   7,  10,   0,  /* "alveolar" 11941 */
     34,   7,  22,  23,   1,   7,  39,   0,  /* "alveoli" 11949 */
     19,   7,  22,  21,   4,  15,  30,   0,  /* "alverez" 11957 */
     34,   7,  22,  21,   4,  27,   0,  /* "alvero" 11964 */
     19,   7,  22,  21,   4,  14,   1,  13,   0,  /* "alverson" 11973 */
      8,   7,  22,  15,  14,   0,  /* "alves" 11979 */
     24,   7,  22,  26,   0,  /* "alvey" 11984 */
     19,   7,  22,  23,  20,   4,  15,  30,   0,  /* "alvidrez" 11993 */
     24,   7,  22,   5,  13,   0,  /* "alvin" 11999 */
     34,   7,  22,  39,  13,   1,   0,  /* "alvina" 12006 */
      8,   7,  22,   5,  14,   0,  /* "alvis" 12012 */
     24,   7,  22,  39,   3,   0,  /* "alvite" 12018 */
     34,   7,  22,  18,   4,  20,   0,  /* "alvord" 12025 */
     24,   7,  47,   1,   7,  23,  20,   0,  /* "alwaleed" 12033 */
     34,   7,  47,  44,  20,   0,  /* "alward" 12039 */
     18,   7,  47,   2,  30,   0,  /* "always" 12045 */
     24,   7,  47,  39,  13,   0,  /* "alwine" 12051 */
     24,   7,  47,  51,  20,   0,  /* "alwood" 12057 */
      2,   7,  26,   0,  /* "aly" 12061 */
     34,   7,  23,   1,   0,  /* "alyea" 12066 */
     34,   7,  26,  21,  14,  12,   1,   0,  /* "alyeska" 12074 */
     24,   7,  26,  30,   0,  /* "alys" 12079 */
      1,   7,   5,  14,  26,   1,   0,  /* "alysia" 12086 */
      1,   7,   5,  14,   1,   0,  /* "alyssa" 12092 */
     24,   7,  30,   1,   0,  /* "alza" 12097 */
     19,   7,  30,  24,  20,  27,   0,  /* "alzado" 12104 */
     19,   7,  30,  21,  13,   1,   0,  /* "alzena" 12111 */
     24,   7,  30,  38,  39,  17,  10,   0,  /* "alzheimer" 12119 */
     24,  17,   0,  /* "am" 12122 */
     24,  17,   1,   9,  21,   7,   0,  /* "amabel" 12129 */
     19,  17,   8,   9,   1,   7,   0,  /* "amabile" 12136 */
     24,  17,   1,  12,  10,   0,  /* "amacher" 12142 */
     24,  17,   1,  12,  10,   0,  /* "amacker" 12148 */
     24,  17,   1,  20,   2,   1,  14,   0,  /* "amadeus" 12156 */
     19,  17,  19,  20,  18,  13,   0,  /* "amadon" 12163 */
     24,  17,   1,  20,  18,   4,   0,  /* "amador" 12170 */
     24,  17,   1,  20,  29,   0,  /* "amadou" 12176 */
     24,  17,  28,  12,  10,   0,  /* "amaker" 12182 */
     24,  17,   1,  12,  41,  29,  20,   8,   4,  26,   0,  /* "amakudari" 12193 */
      1,  17,   8,   7,   0,  /* "amal" 12198 */
     24,  17,   1,   7,  23,   1,   0,  /* "amalea" 12205 */
     19,  17,  19,   7,  37,  26,   3,   8,  13,  27,   0,  /* "amalfitano" 12216 */
      1,  17,   8,   7,  41,   1,   0,  /* "amalia" 12223 */
     24,  17,   1,   7,  26,   0,  /* "amalie" 12229 */
      8,  17,   1,  13,   0,  /* "aman" 12234 */
      1,  17,  24,  13,   1,   0,  /* "amana" 12240 */
      1,  17,  24,  13,  20,   1,   0,  /* "amanda" 12247 */
     24,  17,   1,  13,  20,  39,  17,   0,  /* "amandime" 12255 */
     24,  17,   1,  13,   0,  /* "amann" 12260 */
      8,  17,   8,  13,   6,  45,   4,   0,  /* "amanpour" 12268 */
     19,  17,   8,  13,   3,  26,   0,  /* "amante" 12275 */
      1,  17,   8,   4,   0,  /* "amar" 12280 */
     19,  17,   8,   4,   1,   0,  /* "amara" 12286 */
     19,  17,  19,   4,  24,   7,   0,  /* "amaral" 12293 */
     19,  17,  19,   4,   8,  13,   3,  26,   0,  /* "amarante" 12302 */
     19,  17,   8,   4,  26,   0,  /* "amari" 12308 */
     24,  17,  10,   5,   7,  27,   0,  /* "amarillo" 12315 */
     24,  17,  10,   1,  14,   0,  /* "amaris" 12321 */
     19,  17,   8,   4,  27,   0,  /* "amaro" 12327 */
     24,  17,  10,   5,   7,   1,  14,   0,  /* "amaryllis" 12335 */
     24,  17,  10,   5,   7,   1,  14,   1,  30,   0,  /* "amaryllises" 12345 */
     24,  17,   1,  14,   1,   0,  /* "amasa" 12351 */
     24,  17,   1,  14,   1,  13,   0,  /* "amason" 12358 */
     24,  17,   1,   3,  44,   0,  /* "amateur" 12364 */
     24,  17,   1,  42,  10,  31,  33,   0,  /* "amateurish" 12372 */
     24,  17,   1,  42,  10,   5,  30,   1,  17,   0,  /* "amateurism" 12382 */
     24,  17,   1,   3,   5,   7,   0,  /* "amatil" 12389 */
     19,  17,   8,   3,  27,   0,  /* "amato" 12395 */
      1,  17,  48,   7,  31,  11,  34,  12,   0,  /* "amauligak" 12404 */
      2,  17,  34,  12,  14,   0,  /* "amax" 12410 */
     19,  17,   8,  41,   1,   0,  /* "amaya" 12416 */
      1,  17,   2,  30,   0,  /* "amaze" 12421 */
      1,  17,   2,  30,  20,   0,  /* "amazed" 12427 */
      1,  17,   2,  30,  17,   1,  13,   3,   0,  /* "amazement" 12436 */
      1,  17,   2,  30,   1,  30,   0,  /* "amazes" 12443 */
      1,  17,   2,  30,  31,  32,   0,  /* "amazing" 12450 */
      1,  17,   2,  30,  31,  32,   7,  26,   0,  /* "amazingly" 12459 */
     24,  17,   1,  30,   8,  13,   0,  /* "amazon" 12466 */
     24,  17,   1,  30,   8,  13,  30,   0,  /* "amazons" 12474 */
     24,  17,   9,  34,  12,   0,  /* "ambac" 12480 */
     24,  17,   9,   2,  14,   0,  /* "ambase" 12486 */
     34,  17,   9,  24,  14,   1,  20,  10,   0,  /* "ambassador" 12495 */
     34,  17,   9,  24,  14,   1,  20,   4,   1,  14,   0,  /* "ambassadress" 12506 */
     24,  17,   9,  26,   1,  13,  14,   0,  /* "ambiance" 12514 */
     24,  17,   9,   1,  20,  21,  12,  14,   3,   4,   1,  14,   0,  /* "ambidextrous" 12527 */
     24,  17,   9,  26,   1,  13,  14,   0,  /* "ambience" 12535 */
     24,  17,   9,  26,   1,  13,   3,   0,  /* "ambient" 12543 */
     34,  17,   9,   1,  11,  41,  29,   1,   3,  26,  30,   0,  /* "ambiguities" 12555 */
     24,  17,   9,  31,  11,  41,  29,   1,   3,  26,   0,  /* "ambiguity" 12566 */
     34,  17,   9,   5,  11,  41,  29,   1,  14,   0,  /* "ambiguous" 12576 */
     24,  17,   9,   1,   7,   0,  /* "amble" 12582 */
     24,  17,   9,   1,   7,  20,   0,  /* "ambled" 12589 */
     24,  17,   9,   1,   7,  30,   0,  /* "ambles" 12596 */
     24,  17,   9,   1,   7,  31,  32,   0,  /* "ambling" 12604 */
      1,  17,   9,  18,   4,  13,   0,  /* "amborn" 12611 */
     24,  17,   9,   4,  25,  40,  26,  27,   0,  /* "ambrogio" 12620 */
     34,  17,   9,   4,  25,  43,   1,   0,  /* "ambrosia" 12628 */
     34,  17,   9,   4,  25,  43,   1,   7,   0,  /* "ambrosial" 12637 */
     34,  17,   9,   4,  25,  30,   1,  13,   0,  /* "ambrosian" 12646 */
     34,  17,   9,   4,  25,  14,  26,   8,  13,  27,   0,  /* "ambrosiano" 12657 */
     19,  17,   9,   4,  27,  14,  23,  13,  26,   0,  /* "ambrosine" 12667 */
     19,  17,   9,   4,  27,  14,  23,  13,  26,   0,  /* "ambrosini" 12677 */
     19,  17,   9,   4,  27,  14,  23,  13,  27,   0,  /* "ambrosino" 12687 */
     24,  17,   9,   4,  25,  14,  26,  27,   0,  /* "ambrosio" 12696 */
     24,  17,   9,   4,   1,  14,  26,   1,  14,   0,  /* "ambrosius" 12706 */
     24,  17,  30,   0,  /* "ambs" 12710 */
     24,  17,   9,  51,   7,   0,  /* "ambuehl" 12716 */
     24,  17,   9,  41,   1,   7,   1,  13,  14,   0,  /* "ambulance" 12726 */
     24,  17,   9,  41,   1,   7,   1,  13,  14,   1,  30,   0,  /* "ambulances" 12738 */
     24,  17,   9,  41,   1,   7,   1,   3,  18,   4,  26,   0,  /* "ambulatory" 12750 */
      1,  17,   9,  44,  13,   0,  /* "amburn" 12756 */
     24,  17,   9,  51,  33,   1,  30,   0,  /* "ambushes" 12764 */
     24,  17,  12,   0,  /* "amc" 12768 */
     24,  17,  12,   1,   0,  /* "amca" 12773 */
     24,  17,  20,  21,  12,   0,  /* "amdec" 12779 */
     34,  17,  20,  45,   4,   1,   0,  /* "amdura" 12786 */
      2,  17,   0,  /* "ame" 12789 */
      1,  17,  23,  42,  26,   0,  /* "ameche" 12795 */
     24,  17,   1,  20,  26,   0,  /* "amedee" 12801 */
      1,  17,  23,  13,   0,  /* "ameen" 12806 */
      1,  17,  23,   7,  41,   1,   0,  /* "amelia" 12813 */
     19,  17,  15,   7,  23,  13,  20,   1,   0,  /* "amelinda" 12822 */
     19,  17,  15,   7,  23,  13,  26,   0,  /* "ameline" 12830 */
      1,  17,  23,   7,  41,  10,   2,   3,   0,  /* "ameliorate" 12839 */
      1,  17,  23,   7,  41,  10,   2,   3,   1,  20,   0,  /* "ameliorated" 12850 */
      1,  17,  23,   7,  41,  10,   2,  33,   1,  13,   0,  /* "amelioration" 12861 */
     19,  17,  15,   7,  23,   3,   1,   0,  /* "amelita" 12869 */
     19,  17,   2,   7,   0,  /* "amell" 12874 */
     28,  17,  21,  13,   0,  /* "amen" 12879 */
      1,  17,  21,  13,   1,   9,   1,   7,   0,  /* "amenable" 12888 */
      1,  17,  21,  13,  20,   1,   9,   1,   7,   0,  /* "amendable" 12898 */
     19,  17,  15,  13,  20,  25,   7,   1,   0,  /* "amendola" 12907 */
      1,  17,  21,  13,   1,   3,  26,  30,   0,  /* "amenities" 12916 */
      1,  17,  21,  13,   1,   3,  26,   0,  /* "amenity" 12924 */
     24,  17,  15,  13,   3,   0,  /* "ament" 12930 */
      2,  17,  10,   0,  /* "amer" 12934 */
     24,  17,  15,   4,   8,  20,   1,   0,  /* "amerada" 12942 */
      1,  17,  21,   4,  12,  27,   0,  /* "amerco" 12949 */
      2,  17,  10,  37,  10,  20,   0,  /* "amerford" 12956 */
      1,  17,  21,   4,   1,  12,   1,   0,  /* "america" 12964 */
      1,  17,  21,   4,   1,  12,   1,  13,   5,  30,   1,  17,   0,  /* "americanism" 12977 */
      1,  17,  21,   4,   1,  12,   1,  13,  39,  30,   0,  /* "americanize" 12988 */
      1,  17,  21,   4,   1,  12,   1,  13,  39,  30,  20,   0,  /* "americanized" 13000 */
      1,  17,  21,   4,  31,  12,   8,  13,  27,   0,  /* "americano" 13010 */
      1,  17,  21,   4,  31,  12,   8,   4,   0,  /* "americar" 13019 */
      1,  17,  21,   4,  31,  12,  21,   4,   0,  /* "americare" 13028 */
      1,  17,  21,   4,  31,  12,  21,   4,  30,   0,  /* "americares" 13038 */
      1,  17,  21,   4,   1,  12,   1,  30,   0,  /* "americas" 13047 */
      1,  17,  44,   1,  12,  27,   0,  /* "americo" 13054 */
      1,  17,  21,   4,  31,  12,  18,   4,   0,  /* "americorp" 13063 */
      1,  17,  21,   4,  31,  12,  18,   4,   0,  /* "americorps" 13072 */
      1,  17,  21,   4,   1,  37,  10,  14,   3,   0,  /* "amerifirst" 13082 */
      1,  17,  21,   4,  31,  11,  24,  14,   0,  /* "amerigas" 13091 */
     19,  17,  10,  23,  11,  27,   0,  /* "amerigo" 13098 */
     24,  17,  10,   5,  13,  20,  26,   1,  13,   0,  /* "amerindian" 13108 */
     19,  17,  10,  23,  13,  26,   0,  /* "amerine" 13115 */
     24,  17,  10,  17,   1,  13,   0,  /* "amerman" 13122 */
     19,  17,  21,   4,  27,   0,  /* "amero" 13128 */
     24,  17,  10,  19,  13,   0,  /* "ameron" 13134 */
     24,  17,  10,  18,  13,  40,   1,  13,   0,  /* "amerongen" 13143 */
     24,  17,  10,  33,  24,  17,   0,  /* "amersham" 13150 */
     24,  17,  10,  14,   1,  13,   0,  /* "amerson" 13157 */
     24,  17,  10,  26,   0,  /* "amery" 13162 */
      2,  17,  30,   0,  /* "ames" 13166 */
     24,  17,   1,   3,  21,  12,   0,  /* "ametek" 13173 */
     24,  17,   1,  16,   1,  14,   3,   0,  /* "amethyst" 13181 */
     24,  17,  15,  22,   0,  /* "amev" 13186 */
     24,  17,  21,  12,  14,   0,  /* "amex" 13192 */
      1,  17,  21,  12,  14,  12,  27,   0,  /* "amexco" 13200 */
      2,  17,  26,   0,  /* "amey" 13204 */
      1,  17,  21,  30,  12,  41,  29,   1,   0,  /* "amezcua" 13213 */
     19,  17,  15,  30,  12,  47,  23,   3,   1,   0,  /* "amezquita" 13223 */
     34,  17,  37,  21,  14,  12,  27,   0,  /* "amfesco" 13231 */
     24,  17,  40,  15,  13,   0,  /* "amgen" 13237 */
     24,  17,  10,  14,   3,   0,  /* "amherst" 13243 */
     34,  17,  38,  49,  14,   3,   0,  /* "amhoist" 13250 */
      8,  17,  26,   0,  /* "ami" 13254 */
      2,  17,  26,   1,   9,   1,   7,   0,  /* "amiable" 13262 */
     24,  17,  31,  12,   1,   9,   1,   7,   0,  /* "amicable" 13271 */
     19,  17,  23,  12,  27,   0,  /* "amico" 13277 */
     24,  17,  31,  12,  25,  13,   0,  /* "amicone" 13284 */
      1,  17,  23,  12,   1,  14,   0,  /* "amicus" 13291 */
      1,  17,   5,  20,   0,  /* "amid" 13296 */
     19,  17,  23,  20,  26,   0,  /* "amidi" 13302 */
     24,  17,   1,  20,  19,  13,   0,  /* "amidon" 13309 */
      1,  17,   5,  20,  33,   1,   6,  14,   0,  /* "amidships" 13318 */
      1,  17,   5,  20,  14,   3,   0,  /* "amidst" 13325 */
     24,  17,  26,   0,  /* "amie" 13329 */
      1,  17,  23,  11,  25,   0,  /* "amigo" 13335 */
      1,  17,  23,  11,  25,  30,   0,  /* "amigos" 13342 */
     19,  17,  23,   7,  26,   1,   0,  /* "amilia" 13349 */
     19,  17,  23,  13,   0,  /* "amin" 13354 */
      2,  17,  26,   1,   3,   0,  /* "amiot" 13360 */
      1,  17,   5,   4,   0,  /* "amir" 13365 */
     24,  17,  10,  34,  17,   0,  /* "amiram" 13371 */
     24,  17,  31,   4,   1,  13,   0,  /* "amiran" 13378 */
     24,  17,  39,   4,  52,   7,   3,   0,  /* "amirault" 13386 */
     24,  17,  31,   4,  24,  22,   0,  /* "amirav" 13393 */
     19,  17,   5,   4,  26,   0,  /* "amiri" 13399 */
     24,  17,   5,  14,   0,  /* "amis" 13404 */
      8,  17,  31,  33,   0,  /* "amish" 13409 */
     24,  17,   5,  14,   1,  13,   0,  /* "amison" 13416 */
      1,  17,   5,  14,   0,  /* "amiss" 13421 */
      8,  17,  23,   3,   0,  /* "amit" 13426 */
     24,  17,   1,   3,  39,   0,  /* "amitai" 13432 */
      1,  17,  23,  13,   0,  /* "ammeen" 13437 */
     24,  17,  23,   3,  10,   0,  /* "ammeter" 13443 */
     24,  17,  23,   3,  10,  30,   0,  /* "ammeters" 13450 */
     19,  17,  31,   4,   8,   3,  26,   0,  /* "ammirati" 13458 */
     24,  17,  25,   0,  /* "ammo" 13462 */
      1,  17,  25,  13,  41,   1,   0,  /* "ammonia" 13469 */
     24,  17,   1,  13,  39,   3,   0,  /* "ammonite" 13476 */
     24,  17,   1,  13,  39,   3,  14,   0,  /* "ammonites" 13484 */
      1,  17,  25,  13,  26,   1,  17,   0,  /* "ammonium" 13492 */
     24,  17,  41,   1,  13,   5,  33,   1,  13,   0,  /* "ammunition" 13502 */
     24,  17,  41,   1,  13,   5,  33,   1,  13,  30,   0,  /* "ammunitions" 13513 */
     34,  17,  13,  23,  43,   1,   0,  /* "amnesia" 13520 */
     34,  17,  13,  23,  30,  26,  24,  12,   0,  /* "amnesiac" 13529 */
     24,  17,  13,  26,  27,  14,  21,  13,   3,  23,  14,   1,  14,   0,  /* "amniocentesis" 13543 */
     24,  17,  13,  26,  36,   3,  31,  12,   0,  /* "amniotic" 13552 */
      8,  17,  27,   0,  /* "amo" 13556 */
     24,  17,   1,  12,  27,   0,  /* "amoco" 13562 */
      1,  17,  23,   9,   1,   0,  /* "amoeba" 13568 */
      1,  17,  23,   9,   1,  30,   0,  /* "amoebas" 13575 */
      1,  17,  23,   9,  31,  12,   0,  /* "amoebic" 13582 */
      1,  17,  35,  12,   0,  /* "amok" 13587 */
     19,  17,  18,  13,   0,  /* "amon" 13592 */
      1,  17,  35,  32,   0,  /* "among" 13597 */
      1,  17,  35,  32,  14,   3,   0,  /* "amongst" 13604 */
      1,  17,  29,   7,  41,   1,   0,  /* "amoolya" 13611 */
     24,  17,  10,   0,  /* "amor" 13615 */
     28,  17,  18,   4,   1,   7,   0,  /* "amoral" 13622 */
      8,  17,  36,   4,   0,  /* "amore" 13627 */
     19,  17,  36,   4,  23,   3,   1,   0,  /* "amorita" 13635 */
     19,  17,  36,   4,  25,  14,  26,   0,  /* "amorosi" 13643 */
     19,  17,  36,   4,  25,  14,  27,   0,  /* "amoroso" 13651 */
      1,  17,  18,   4,  37,   1,  14,   0,  /* "amorphous" 13659 */
     24,  17,  10,   3,  39,  30,   0,  /* "amortize" 13666 */
     24,  17,  10,   3,  39,  30,  20,   0,  /* "amortized" 13674 */
     24,  17,  10,   3,  39,  30,  31,  32,   0,  /* "amortizing" 13683 */
     24,  17,  10,  29,  14,  27,   0,  /* "amoruso" 13690 */
      2,  17,  10,  26,   0,  /* "amory" 13695 */
      2,  17,   1,  14,   0,  /* "amos" 13700 */
     24,  17,   1,  14,  12,   2,  11,   0,  /* "amoskeag" 13708 */
     24,  17,   6,   0,  /* "amp" 13712 */
     24,  17,   6,  34,  20,   0,  /* "ampad" 13718 */
     24,  17,   6,  10,   1,  13,   0,  /* "amparan" 13725 */
      8,  17,   6,   8,   3,  27,   0,  /* "ampato" 13732 */
     24,  17,   6,  10,  31,  40,   0,  /* "amperage" 13739 */
     24,  17,   6,  10,  14,  24,  13,  20,   0,  /* "ampersand" 13748 */
     24,  17,   6,  21,  12,  14,   0,  /* "ampex" 13755 */
     34,  17,  37,  21,   3,   1,  17,  23,  13,   0,  /* "amphetamine" 13765 */
     34,  17,  37,  21,   3,   1,  17,  23,  13,  30,   0,  /* "amphetamines" 13776 */
     34,  17,  37,   5,   9,  26,   1,  13,   0,  /* "amphibian" 13785 */
     34,  17,  37,   5,   9,  26,   1,  13,  30,   0,  /* "amphibians" 13795 */
     34,  17,  37,   5,   9,  26,   1,  14,   0,  /* "amphibious" 13804 */
     24,  17,  37,   1,   9,  25,   7,   0,  /* "amphibole" 13812 */
     24,  17,  37,   1,  16,  23,   1,   3,  10,   0,  /* "amphitheater" 13822 */
     24,  17,  37,   1,  16,  23,   1,   3,  10,  30,   0,  /* "amphitheaters" 13833 */
     24,  17,   6,   1,  16,  23,   1,   3,  10,   0,  /* "amphitheatre" 13843 */
     24,  17,  37,  10,   1,   0,  /* "amphora" 13849 */
     24,  17,  37,  10,  23,   0,  /* "amphorae" 13855 */
     24,  17,   6,   1,   7,   0,  /* "ample" 13861 */
     24,  17,   6,   7,  31,  12,  36,  13,  30,   0,  /* "amplicons" 13871 */
     24,  17,   6,   7,   1,  37,  39,  20,   0,  /* "amplified" 13880 */
     24,  17,   6,   7,   1,  37,  39,  10,   0,  /* "amplifier" 13889 */
     24,  17,   6,   7,   1,  37,  39,  10,  30,   0,  /* "amplifiers" 13899 */
     24,  17,   6,   7,   1,  37,  39,  30,   0,  /* "amplifies" 13908 */
     24,  17,   6,   7,   1,  37,  39,   0,  /* "amplify" 13916 */
     24,  17,   6,   7,   1,  37,  39,  31,  32,   0,  /* "amplifying" 13926 */
     24,  17,   6,   7,  31,  40,  15,  13,   0,  /* "ampligen" 13935 */
     24,  17,   6,   7,   1,   3,  29,  20,   0,  /* "amplitude" 13944 */
     24,  17,   6,  36,   7,   0,  /* "ampol" 13950 */
     24,  17,   6,  41,   1,   3,   2,   3,   0,  /* "amputate" 13959 */
     24,  17,   6,  41,   1,   3,   2,   3,   1,  20,   0,  /* "amputated" 13970 */
     24,  17,   6,  41,   1,   3,   2,  33,   1,  13,   0,  /* "amputation" 13981 */
     24,  17,   6,  41,  29,   3,   2,  33,   1,  13,  30,   0,  /* "amputations" 13993 */
     24,  17,   6,  41,   1,   3,  23,   0,  /* "amputee" 14001 */
     24,  17,   6,  41,   1,   3,  23,  30,   0,  /* "amputees" 14010 */
      8,  17,  10,   0,  /* "amr" 14014 */
     34,  17,   4,   8,  17,   0,  /* "amraam" 14020 */
     24,  17,   4,   1,   0,  /* "amre" 14025 */
     24,  17,   4,  39,  13,   0,  /* "amrein" 14031 */
     24,  17,   4,  15,   6,   0,  /* "amrep" 14037 */
     24,  17,  10,  38,  39,  13,   0,  /* "amrhein" 14044 */
     24,  17,   4,  26,  13,   0,  /* "amrine" 14050 */
     34,  17,   4,   5,   3,  14,  10,   0,  /* "amritsar" 14058 */
     24,  17,   4,  27,   0,  /* "amro" 14063 */
     24,  17,  30,   0,  /* "ams" 14067 */
     24,  17,  30,  20,   1,  13,   0,  /* "amsden" 14074 */
     24,  17,  30,   7,  10,   0,  /* "amsler" 14080 */
     24,  17,  14,   3,  10,  20,  24,  17,   0,  /* "amsterdam" 14089 */
     24,  17,  14,   3,   1,   3,  14,   0,  /* "amstutz" 14097 */
     24,  17,   3,   4,  34,  12,   0,  /* "amtrak" 14104 */
     24,  17,  41,   1,   7,   1,   3,   0,  /* "amulet" 14112 */
     24,  17,  41,   1,   7,   1,   3,  14,   0,  /* "amulets" 14121 */
      2,  17,   1,  13,  20,  14,   1,  13,   0,  /* "amundsen" 14130 */
     24,  17,   1,  13,  20,  14,   1,  13,   0,  /* "amundson" 14139 */
      1,  17,  41,  29,  30,   0,  /* "amuse" 14145 */
      1,  17,  41,  29,  30,  20,   0,  /* "amused" 14152 */
      1,  17,  41,  29,  30,  17,   1,  13,   3,   0,  /* "amusement" 14162 */
      1,  17,  41,  29,  30,  17,   1,  13,   3,  14,   0,  /* "amusements" 14173 */
      1,  17,  41,  29,  30,   1,  30,   0,  /* "amuses" 14181 */
      1,  17,  41,  29,  30,  31,  32,   0,  /* "amusing" 14189 */
      1,  17,  41,  29,  30,  31,  32,   7,  26,   0,  /* "amusingly" 14199 */
     24,  17,  22,  15,  14,   3,   0,  /* "amvest" 14206 */
      2,  17,  26,   0,  /* "amy" 14210 */
     24,  17,   1,   7,   5,  13,   0,  /* "amylin" 14217 */
     24,  17,   1,   7,  49,  20,   0,  /* "amyloid" 14224 */
     24,  17,  39,   1,   3,   4,  25,  37,  31,  12,   0,  /* "amyotrophic" 14235 */
     24,  17,  31,  12,  14,   0,  /* "amyx" 14241 */
     24,  13,   0,  /* "an" 14244 */
      8,  13,   1,   0,  /* "ana" 14248 */
      2,  13,   1,   9,   1,   7,   0,  /* "anable" 14255 */
     24,  13,  34,  12,   0,  /* "anac" 14260 */
      1,  13,  24,  12,   4,   1,  13,   5,  30,   1,  17,   0,  /* "anachronism" 14272 */
      1,  13,  24,  12,   4,   1,  13,   5,  30,   1,  17,  30,   0,  /* "anachronisms" 14285 */
      1,  13,  24,  12,   4,   1,  13,   5,  14,   3,  31,  12,   0,  /* "anachronistic" 14298 */
     24,  13,   1,  14,   5,  13,   0,  /* "anacin" 14305 */
     24,  13,   1,  12,  10,   0,  /* "anacker" 14311 */
     24,  13,   1,  20,   8,   4,  12,  27,   0,  /* "anadarko" 14320 */
     24,  13,   1,  14,  16,  23,  43,   1,   0,  /* "anaesthesia" 14329 */
      1,  13,  24,  37,   4,   1,  13,   5,   7,   0,  /* "anafranil" 14339 */
     19,  13,   8,  11,  13,  27,  30,   0,  /* "anagnos" 14347 */
     24,  13,   1,  38,  39,  17,   0,  /* "anaheim" 14354 */
      2,  13,   1,   7,   0,  /* "anal" 14359 */
     24,  13,   1,   7,  40,  23,  30,  31,  12,  14,   0,  /* "analgesics" 14370 */
     24,  13,   1,   7,  18,  11,   0,  /* "analog" 14377 */
      1,  13,  24,   7,   1,  40,  26,  30,   0,  /* "analogies" 14386 */
      1,  13,  24,   7,   1,  11,   1,  14,   0,  /* "analogous" 14395 */
      1,  13,  24,   7,   1,  40,  26,   0,  /* "analogy" 14403 */
      1,  13,  24,   7,   1,  14,  23,  30,   0,  /* "analyses" 14412 */
     35,  13,  34,   7,  39,  14,  31,  30,   0,  /* "analyses" 14421 */
      1,  13,  24,   7,   1,  14,   1,  14,   0,  /* "analysis" 14430 */
     24,  13,   1,   7,   1,   3,   5,  14,   1,   3,  26,   0,  /* "analyticity" 14442 */
     24,  13,   1,   7,  39,  30,   1,   9,   1,   7,   0,  /* "analyzable" 14453 */
     24,  13,   1,   7,  39,  30,   0,  /* "analyze" 14460 */
     24,  13,   1,   7,  39,  30,  20,   0,  /* "analyzed" 14468 */
     24,  13,   1,   7,  39,  30,  10,   0,  /* "analyzer" 14476 */
     24,  13,   1,   7,  39,  30,  10,  30,   0,  /* "analyzers" 14485 */
     24,  13,   1,   7,  39,  30,   1,  30,   0,  /* "analyzes" 14494 */
     24,  13,   1,   7,  39,  30,  31,  32,   0,  /* "analyzing" 14503 */
     24,  13,   1,  17,   1,   4,  23,   1,   0,  /* "anamaria" 14512 */
      8,  13,  19,  13,  20,  23,   6,   0,  /* "anandeep" 14520 */
     19,  13,   8,  13,  26,   1,   0,  /* "anania" 14527 */
      1,  13,  24,  13,  16,   1,   0,  /* "anantha" 14534 */
      1,  13,  24,  37,  10,   1,   0,  /* "anaphora" 14541 */
     34,  13,   8,   4,  12,  31,  12,   0,  /* "anarchic" 14549 */
     34,  13,   8,   4,  12,   1,  12,   1,   7,   0,  /* "anarchical" 14559 */
     24,  13,  10,  12,   1,  14,   3,   0,  /* "anarchist" 14567 */
     24,  13,  10,  12,   1,  14,   3,  14,   0,  /* "anarchists" 14576 */
     24,  13,  10,  12,  26,   0,  /* "anarchy" 14582 */
     24,  13,  10,   1,  13,   0,  /* "anaren" 14588 */
     24,  13,   1,  14,   0,  /* "anas" 14593 */
     24,  13,   1,  14,  24,  30,  26,   0,  /* "anasazi" 14601 */
     24,  13,   1,  14,  12,  47,  19,  13,   0,  /* "anasquan" 14610 */
      8,  13,  19,  14,   3,   0,  /* "anast" 14616 */
     24,  13,   1,  14,   3,   1,  30,   0,  /* "anastas" 14624 */
     19,  13,  19,  14,   3,   8,  14,  26,   0,  /* "anastasi" 14633 */
     34,  13,   1,  14,   3,   2,  43,   1,   0,  /* "anastasia" 14642 */
     19,  13,  19,  14,   3,   8,  14,  26,  27,   0,  /* "anastasio" 14652 */
     24,  13,   1,  14,   3,  27,  30,   0,  /* "anastos" 14660 */
      1,  13,  24,  16,   1,  17,   1,   0,  /* "anathema" 14668 */
     19,  13,  19,   3,  25,   7,   1,   0,  /* "anatola" 14676 */
     24,  13,   1,   3,   8,  17,   1,  12,   1,   7,   0,  /* "anatomical" 14687 */
     24,  13,   1,   3,   8,  17,   1,  12,   7,  26,   0,  /* "anatomically" 14698 */
      1,  13,  24,   3,   1,  17,   1,  14,   3,   0,  /* "anatomist" 14708 */
      1,  13,  24,   3,   1,  17,  26,   0,  /* "anatomy" 14716 */
     19,  13,   8,  41,   1,   0,  /* "anaya" 14722 */
     34,  13,   9,   8,   4,  26,   0,  /* "anbari" 14729 */
      1,  13,  14,  21,   7,   0,  /* "ancel" 14735 */
     19,  13,  14,   2,   7,   0,  /* "ancell" 14741 */
     34,  13,  14,  21,  14,   3,   4,   1,   7,   0,  /* "ancestral" 14751 */
     24,  13,  14,  15,  14,   3,   4,  26,   0,  /* "ancestry" 14760 */
     19,  13,  12,  21,   3,   1,   0,  /* "ancheta" 14767 */
     19,  13,  12,  25,  13,  20,  27,   0,  /* "anchondo" 14775 */
     24,  32,  12,  10,   0,  /* "anchor" 14780 */
     24,  32,  12,  10,   1,  40,   0,  /* "anchorage" 14787 */
     24,  32,  12,  10,  20,   0,  /* "anchored" 14793 */
     24,  32,  12,  10,  31,  32,   0,  /* "anchoring" 14800 */
     24,  32,  12,  10,  17,  24,  13,   0,  /* "anchorman" 14808 */
     24,  32,  12,  10,  17,  21,  13,   0,  /* "anchormen" 14816 */
     24,  32,  12,  10,  30,   0,  /* "anchors" 14822 */
     34,  13,  42,  25,  22,  26,  30,   0,  /* "anchovies" 14830 */
     34,  13,  42,  25,  22,  26,   0,  /* "anchovy" 14837 */
      2,  13,  42,   1,  13,   3,   0,  /* "ancient" 14844 */
      2,  13,  42,   1,  13,   3,  14,   0,  /* "ancients" 14852 */
     24,  13,  14,   1,   7,  21,   4,  26,   0,  /* "ancillary" 14861 */
     19,  13,  12,  25,  13,   1,   0,  /* "ancona" 14868 */
      1,  13,  12,   4,  35,  17,   0,  /* "ancrum" 14875 */
     24,  32,  12,   3,   5,   7,   0,  /* "anctil" 14882 */
     24,  13,  20,   0,  /* "and" 14886 */
     24,  13,  20,   1,   7,  29,  43,   1,   0,  /* "andalusia" 14895 */
     24,  13,  20,   1,   7,  29,  33,   1,  13,   0,  /* "andalusian" 14905 */
     19,  13,  20,   8,  13,   3,  28,   0,  /* "andante" 14913 */
      8,  13,  20,   8,  13,   3,  23,  13,  27,   0,  /* "andantino" 14923 */
     24,  13,  20,  10,   1,   0,  /* "andera" 14929 */
     24,  13,  20,  10,  31,  11,   0,  /* "anderegg" 14936 */
     24,  13,  20,  10,   1,   7,   0,  /* "anderle" 14943 */
     24,  13,  20,  26,  30,   0,  /* "andes" 14949 */
     24,  13,  20,   1,  14,  39,   3,   0,  /* "andesite" 14957 */
     19,  13,  20,  23,  13,  27,   0,  /* "andino" 14964 */
     24,  13,  20,  39,  10,  13,   0,  /* "andiron" 14971 */
     24,  13,  20,  27,   0,  /* "ando" 14976 */
     19,  13,  20,  27,   7,  23,  13,   1,   0,  /* "andolina" 14985 */
     34,  13,  20,  18,   4,   1,  30,   0,  /* "andoras" 14993 */
     34,  13,  20,  18,   4,   1,   0,  /* "andorra" 15000 */
     24,  13,  20,  27,  22,  10,   0,  /* "andover" 15007 */
     19,  13,  20,   4,   8,  20,   1,   0,  /* "andrada" 15015 */
      8,  13,  20,   4,  39,   0,  /* "andrae" 15021 */
      8,  13,  20,   4,   1,  14,   0,  /* "andras" 15028 */
      8,  13,  20,   4,   2,   0,  /* "andre" 15034 */
     19,  13,  20,   4,   2,  19,   0,  /* "andreae" 15041 */
     24,  13,  20,   4,  23,  13,   1,   0,  /* "andreana" 15049 */
     24,  13,  20,   4,  23,  13,  26,   0,  /* "andreani" 15057 */
     19,  13,  20,   4,   2,   1,  14,   0,  /* "andreas" 15065 */
     24,  13,  20,   4,  26,  14,   1,  13,   0,  /* "andreasen" 15074 */
     24,  13,  20,   4,   1,  14,   1,  13,   0,  /* "andreassen" 15083 */
      1,  13,  20,   4,  23,   0,  /* "andree" 15089 */
      1,  13,  20,   4,  23,  13,   0,  /* "andreen" 15096 */
     19,  13,  20,   4,  28,  23,  13,  26,   0,  /* "andreini" 15105 */
      8,  13,  20,   4,  28,   0,  /* "andrej" 15111 */
     19,  13,  20,   4,  28,  25,   7,  26,   0,  /* "andreoli" 15120 */
     19,  13,  20,   4,  28,  25,  13,  26,   0,  /* "andreoni" 15129 */
     19,  13,  20,   4,  26,   8,   3,  26,   0,  /* "andreotti" 15138 */
     19,  13,  20,   4,  26,   8,   3,  14,  26,   0,  /* "andreozzi" 15148 */
     19,  13,  20,   4,   2,   6,  27,  13,   3,   0,  /* "andrepont" 15158 */
      8,  13,  20,   4,  28,  30,   0,  /* "andres" 15165 */
     34,  13,  20,   4,  23,  14,   1,  13,   0,  /* "andresen" 15174 */
     34,  13,  20,   4,  21,  14,  12,  26,   0,  /* "andreski" 15183 */
      8,  13,  20,   4,  15,  14,   0,  /* "andress" 15190 */
     24,  13,  20,   4,  29,   0,  /* "andreu" 15196 */
     24,  13,  20,   4,  29,   0,  /* "andrew" 15202 */
     24,  13,  20,   4,  29,  30,   0,  /* "andrews" 15209 */
     24,  13,  20,   4,   1,  30,  34,  12,   0,  /* "andrezak" 15218 */
     19,  13,  20,   4,  26,  24,  13,   1,   0,  /* "andriana" 15227 */
     19,  13,  20,   4,  26,   8,  13,  27,   0,  /* "andriano" 15236 */
      1,  13,  20,   4,  23,  30,   0,  /* "andries" 15243 */
     19,  13,  20,   4,  23,  32,  11,   1,   0,  /* "andringa" 15252 */
     19,  13,  20,   4,  26,  25,   7,   1,   0,  /* "andriola" 15261 */
     34,  13,  20,   4,  18,  40,   1,  13,   1,  14,   0,  /* "androgynous" 15272 */
     24,  13,  20,   4,  49,  20,   0,  /* "android" 15279 */
     34,  13,  20,   4,   8,  17,   1,  20,   1,   0,  /* "andromeda" 15289 */
     34,  13,  20,   4,   8,   6,   8,  22,   0,  /* "andropov" 15298 */
     24,  13,  20,   4,  19,  14,   0,  /* "andros" 15305 */
     24,  13,  20,   4,   1,  14,  21,  22,  31,  42,   0,  /* "andruskevich" 15316 */
      8,  13,  20,   4,   2,   0,  /* "andrzej" 15322 */
      1,  13,  40,  28,  21,  37,  14,  12,  26,   0,  /* "andrzejewski" 15332 */
     24,  13,  20,  30,   0,  /* "ands" 15337 */
     19,  13,  20,  29,  41,   8,   4,   0,  /* "andujar" 15345 */
     24,  13,  20,  26,   0,  /* "andy" 15350 */
      1,  13,  21,   7,  27,   0,  /* "anello" 15356 */
      1,  13,  23,  17,  26,   1,   0,  /* "anemia" 15363 */
      1,  13,  23,  17,  26,   1,  30,   0,  /* "anemias" 15371 */
      1,  13,  23,  17,  31,  12,   0,  /* "anemic" 15378 */
     24,  13,   1,  17,   8,  17,   1,   3,  10,   0,  /* "anemometer" 15388 */
     24,  13,   1,  17,  25,  13,   0,  /* "anemone" 15395 */
     34,  13,  21,  13,  14,   1,  37,  24,   7,  31,  12,   0,  /* "anencephalic" 15407 */
     34,  13,   1,  13,  14,  21,  37,   1,   7,  26,   0,  /* "anencephaly" 15418 */
     24,  13,   1,  14,   3,  24,  42,  26,  27,   0,  /* "anestachio" 15428 */
     24,  13,   1,  14,  16,  23,  43,   1,   0,  /* "anesthesia" 15437 */
     24,  13,   1,  14,  16,  23,  30,  26,   8,   7,   1,  40,   1,  14,   3,   0,  /* "anesthesiologist" 15453 */
     24,  13,   1,  14,  16,  23,  30,  26,   8,   7,   1,  40,   1,  14,   3,  14,   0,  /* "anesthesiologists" 15470 */
     24,  13,   1,  14,  16,  26,  30,  26,   8,   7,   1,  40,  26,   0,  /* "anesthesiology" 15484 */
      1,  13,  21,  14,  16,   1,   3,   1,  14,   3,   0,  /* "anesthetist" 15495 */
      1,  13,  21,   3,   0,  /* "anette" 15500 */
     24,  13,  41,  51,   4,   5,  30,   1,  17,   0,  /* "aneurism" 15510 */
      1,  13,  29,   0,  /* "anew" 15514 */
      2,  21,  13,  21,  37,   2,  21,   7,   0,  /* "anfal" 15523 */
     24,  32,   0,  /* "ang" 15526 */
      2,  13,  40,   0,  /* "ange" 15530 */
      2,  13,  40,   1,   7,   0,  /* "angel" 15536 */
     24,  13,  40,   1,   7,   1,   0,  /* "angela" 15543 */
     24,  13,  40,   1,   7,  23,  13,  27,   0,  /* "angeleno" 15552 */
     24,  13,  40,   1,   7,  23,  13,  27,  30,   0,  /* "angelenos" 15562 */
     24,  13,  40,   1,   7,   1,  14,   0,  /* "angeles" 15570 */
     19,  32,  11,  15,   7,  21,   3,  26,   0,  /* "angeletti" 15579 */
      2,  13,  40,   1,   7,  37,   5,  33,   0,  /* "angelfish" 15588 */
     19,  32,  11,  21,   7,  26,   0,  /* "angeli" 15595 */
     24,  13,  40,  21,   7,  31,  12,   0,  /* "angelic" 15603 */
     34,  13,  40,  21,   7,  31,  12,   1,   0,  /* "angelica" 15612 */
     34,  13,  40,  21,   7,  31,  12,   7,  26,   0,  /* "angelically" 15622 */
     34,  13,  40,  21,   7,  31,  12,   1,  30,   0,  /* "angelicas" 15632 */
     19,  32,  11,  15,   7,  23,  12,  27,   0,  /* "angelico" 15641 */
     34,  13,  40,  21,   7,   5,  12,   1,   0,  /* "angelika" 15650 */
     19,  32,  11,  15,   7,   5,   7,  27,   0,  /* "angelillo" 15659 */
     34,  13,  40,  15,   7,  23,  13,   1,   0,  /* "angelina" 15668 */
      2,  32,  11,  15,   7,  39,  13,   0,  /* "angeline" 15676 */
     19,  32,  11,  15,   7,  23,  13,  26,   0,  /* "angelini" 15685 */
     24,  13,  40,   1,   7,  23,  13,  27,   0,  /* "angelino" 15694 */
     24,  13,  40,   1,   7,  23,  13,  27,  30,   0,  /* "angelinos" 15704 */
     19,  32,  11,  15,   7,  23,   3,   1,   0,  /* "angelita" 15713 */
      2,  13,  40,   1,   7,   0,  /* "angell" 15719 */
     28,  32,  11,  21,   7,   0,  /* "angelle" 15725 */
     24,  13,  40,  21,   7,  27,   0,  /* "angello" 15732 */
     24,  13,  40,   1,   7,  25,   0,  /* "angelo" 15739 */
      2,  32,  11,  15,   7,  36,  37,   0,  /* "angeloff" 15747 */
     19,  32,  11,  15,   7,  25,  13,  26,   0,  /* "angelone" 15756 */
     19,  32,  11,  15,   7,  25,  13,  26,   0,  /* "angeloni" 15765 */
     24,  13,  40,   1,   7,  25,  30,   0,  /* "angelos" 15773 */
     24,  13,  40,   1,   7,  29,   0,  /* "angelou" 15780 */
     24,  13,  40,   1,   7,  25,  30,   0,  /* "angeloz" 15788 */
      2,  13,  40,   1,   7,  30,   0,  /* "angels" 15795 */
     19,  32,  11,  15,   7,  29,  42,  26,   0,  /* "angelucci" 15804 */
     24,  32,  11,  10,   0,  /* "anger" 15809 */
     24,  32,  10,  17,   1,  13,   0,  /* "angerman" 15816 */
      2,  32,  11,  10,  17,  39,  10,   0,  /* "angermeier" 15824 */
     24,  32,  11,  10,  30,   0,  /* "angers" 15830 */
      2,  32,  11,  10,   3,   0,  /* "angert" 15836 */
      2,  32,  11,  31,  22,  39,  13,   0,  /* "angevine" 15844 */
     24,  13,  40,  26,   0,  /* "angi" 15849 */
     34,  13,  40,  39,  13,   1,   0,  /* "angina" 15856 */
     24,  13,  40,  26,  27,  11,   4,  34,  17,   0,  /* "angiogram" 15866 */
     24,  13,  40,  26,  27,  17,  21,  20,  31,  12,   0,  /* "angiomedic" 15877 */
     24,  13,  40,  26,  27,  17,  21,  20,  31,  12,  14,   0,  /* "angiomedics" 15889 */
     24,  13,  40,  26,  27,   3,  21,  13,  14,   1,  13,   0,  /* "angiotensin" 15901 */
     24,  32,  11,   1,   7,   0,  /* "angle" 15907 */
     24,  32,  11,   1,   7,  20,   0,  /* "angled" 15914 */
     24,  32,  11,   1,   7,  17,  26,  10,   0,  /* "anglemyer" 15923 */
     24,  32,  11,   1,   7,   1,  13,   0,  /* "anglen" 15931 */
     24,  32,  11,   7,  10,   0,  /* "angler" 15937 */
     24,  32,  11,   1,   7,  30,   0,  /* "angles" 15944 */
     24,  32,  11,   1,   7,   3,   1,  13,   0,  /* "angleton" 15953 */
     24,  32,  11,   7,  26,   1,   0,  /* "anglia" 15960 */
     24,  32,  11,   7,   1,  12,   1,  13,   0,  /* "anglican" 15969 */
     24,  32,   7,   1,  14,  39,  30,   0,  /* "anglicize" 15977 */
     24,  32,   7,   1,  14,  39,  30,  20,   0,  /* "anglicized" 15986 */
     24,  32,  11,   7,  31,  32,   0,  /* "angling" 15993 */
     34,  32,  11,  25,   7,   1,   0,  /* "angola" 16000 */
     24,  32,  11,  27,   7,   1,  13,   0,  /* "angolan" 16008 */
     24,  32,  11,  27,   7,   1,  13,  30,   0,  /* "angolans" 16017 */
     34,  32,  11,  18,   4,   1,  30,   0,  /* "angoras" 16025 */
     19,  32,  11,  25,   3,  26,   0,  /* "angotti" 16032 */
     19,  32,  11,  25,  22,  26,   0,  /* "angove" 16039 */
     24,  32,  11,   4,  26,   1,  14,   3,   0,  /* "angriest" 16048 */
      8,  32,  12,  14,   3,   0,  /* "angst" 16054 */
     24,  32,  33,   3,  34,   3,   0,  /* "angstadt" 16061 */
     19,  32,  11,  26,   8,  13,  27,   0,  /* "anguiano" 16069 */
     24,  32,  47,   5,   7,   1,   0,  /* "anguilla" 16076 */
     24,  32,  11,  41,   1,   7,  10,   0,  /* "angular" 16084 */
     24,  32,  11,  41,  29,   7,   2,   3,   0,  /* "angulate" 16093 */
     24,  32,  11,  41,  29,   7,   2,   3,   1,  20,   0,  /* "angulated" 16104 */
     19,  32,  11,  29,   7,  27,   0,  /* "angulo" 16111 */
     24,  13,  40,  26,   0,  /* "angy" 16116 */
     24,  13,  38,   1,   7,   3,   0,  /* "anhalt" 16123 */
     24,  13,  38,  39,  30,  10,   0,  /* "anheuser" 16130 */
     34,  13,  38,  39,  20,   4,   1,  20,   0,  /* "anhydride" 16139 */
     24,  13,   1,   7,  23,  13,   0,  /* "aniline" 16146 */
     24,  13,   1,  17,   1,   3,   0,  /* "animate" 16153 */
     24,  13,   1,  17,   2,   3,   0,  /* "animate" 16160 */
     24,  13,   1,  17,   5,  30,   1,  17,   0,  /* "animism" 16169 */
      1,  13,  23,   3,   1,   0,  /* "anita" 16175 */
     24,  13,   1,   3,  27,   7,   0,  /* "anitole" 16182 */
     24,  13,  31,  12,  14,   3,  10,   0,  /* "anixter" 16190 */
      8,  13,  40,   1,   0,  /* "anja" 16195 */
     34,  13,  40,  21,   7,   1,  12,   1,   0,  /* "anjelica" 16204 */
     24,  32,  12,  10,   1,   0,  /* "ankara" 16210 */
      1,  32,  12,  21,  13,  26,   0,  /* "ankeney" 16217 */
      1,  32,  12,  23,  13,  26,   0,  /* "ankeny" 16224 */
     34,  32,  12,  44,  26,   1,  17,   0,  /* "ankerium" 16232 */
     24,  32,  12,   1,   7,   0,  /* "ankle" 16238 */
     24,  32,  12,   1,   7,   9,  25,  13,   0,  /* "anklebone" 16247 */
     24,  32,  12,   1,   7,  30,   0,  /* "ankles" 16254 */
     24,  32,  12,  13,  26,   0,  /* "ankney" 16260 */
     24,  13,   0,  /* "ann" 16263 */
     24,  13,   1,   0,  /* "anna" 16267 */
     24,  13,   1,   9,  21,   7,   0,  /* "annabel" 16274 */
     24,  13,   1,   9,   1,   7,   0,  /* "annable" 16281 */
     24,  13,   1,  17,  23,  30,   0,  /* "annamese" 16288 */
     24,  13,   1,  13,  20,   2,   7,   0,  /* "annandale" 16296 */
      1,  13,  24,   6,   1,   7,   5,  14,   0,  /* "annapolis" 16305 */
     24,  13,   0,  /* "anne" 16308 */
      1,  13,  23,   7,   0,  /* "anneal" 16313 */
      1,  13,  23,   7,  31,  32,   0,  /* "annealing" 16320 */
     24,  13,   1,   7,   1,  20,   0,  /* "annelid" 16327 */
     24,  13,   1,   7,   1,  20,  30,   0,  /* "annelids" 16335 */
     19,  13,   2,  30,  26,   0,  /* "annese" 16341 */
      1,  13,  21,   3,   0,  /* "annett" 16346 */
      1,  13,  21,   3,   0,  /* "annette" 16351 */
     24,  13,  21,  12,  14,   0,  /* "annex" 16357 */
      1,  13,  21,  12,  14,   0,  /* "annex" 16363 */
     24,  13,  15,  12,  14,   2,  33,   1,  13,   0,  /* "annexation" 16373 */
     24,  13,  15,  12,  14,   3,   0,  /* "annexed" 16380 */
     24,  13,  21,  12,  14,  31,  30,   0,  /* "annexes" 16388 */
      1,  13,  21,  12,  14,  31,  30,   0,  /* "annexes" 16396 */
      1,  13,  21,  12,  14,  31,  32,   0,  /* "annexing" 16404 */
      1,  13,  39,   1,   7,   2,   3,   0,  /* "annihilate" 16412 */
      1,  13,  39,   1,   7,   2,   3,   1,  20,   0,  /* "annihilated" 16422 */
      1,  13,  39,   1,   7,   2,  33,   1,  13,   0,  /* "annihilation" 16432 */
     24,  13,  26,  30,   0,  /* "annis" 16437 */
     24,  13,   1,  22,  44,  14,  10,  26,  30,   0,  /* "anniversaries" 16447 */
     24,  13,   1,  22,  44,  14,  10,  26,   0,  /* "anniversary" 16456 */
     24,  13,  27,   0,  /* "anno" 16460 */
     24,  13,   1,   3,   2,   3,   0,  /* "annotate" 16467 */
     24,  13,   1,   3,   2,   3,   1,  20,   0,  /* "annotated" 16476 */
     24,  13,   1,   3,   2,   3,  14,   0,  /* "annotates" 16484 */
     24,  13,   1,   3,   2,   3,  31,  32,   0,  /* "annotating" 16493 */
     24,  13,   1,   3,   2,  33,   1,  13,   0,  /* "annotation" 16502 */
     24,  13,   1,   3,   2,  33,   1,  13,  30,   0,  /* "annotations" 16512 */
      1,  13,  48,  13,  14,  17,   1,  13,   3,   0,  /* "announcment" 16522 */
      1,  13,  49,   0,  /* "annoy" 16526 */
     24,  13,  41,  29,   1,   7,   0,  /* "annual" 16533 */
     24,  13,  41,  29,  47,   1,   7,  39,  30,   0,  /* "annualize" 16543 */
     24,  13,  41,  29,  47,   1,   7,  39,  30,  20,   0,  /* "annualized" 16554 */
     24,  13,  41,  29,   1,   7,  26,   0,  /* "annually" 16562 */
     24,  13,  29,   1,   7,  30,   0,  /* "annuals" 16569 */
      1,  13,  29,   1,   3,  26,  30,   0,  /* "annuities" 16577 */
      1,  13,  29,   1,   3,  26,   0,  /* "annuity" 16584 */
     24,  13,  41,   1,   7,  10,   0,  /* "annular" 16591 */
     24,  13,   1,   7,  20,   0,  /* "annulled" 16597 */
     19,  13,  29,  13,  42,   8,   3,   1,   0,  /* "annunciata" 16606 */
     19,  13,  29,  13,  30,  26,   8,   3,   1,   0,  /* "annunziata" 16616 */
     19,  13,  29,  13,  30,  26,   8,   3,  27,   0,  /* "annunziato" 16626 */
      1,  13,  35,  13,  30,  26,  27,   0,  /* "annunzio" 16634 */
     24,  13,  26,   0,  /* "anny" 16638 */
     24,  13,  25,  20,   0,  /* "anode" 16643 */
     24,  13,  25,  20,  30,   0,  /* "anodes" 16649 */
      1,  13,  49,  13,   1,  20,   0,  /* "anointed" 16656 */
      1,  13,   8,  17,   1,   7,  26,  30,   0,  /* "anomalies" 16665 */
      1,  13,   8,  17,   1,   7,  26,   0,  /* "anomaly" 16673 */
     24,  13,   1,  17,  26,   0,  /* "anomie" 16679 */
     19,  13,  25,  13,   1,   0,  /* "anona" 16685 */
     24,  13,   1,  13,   5,  17,   1,   3,  26,   0,  /* "anonymity" 16695 */
      1,  13,   8,  13,   1,  17,   1,  14,   0,  /* "anonymous" 16704 */
      1,  13,   8,  13,   1,  17,   1,  14,   7,  26,   0,  /* "anonymously" 16715 */
     19,  13,  18,   4,   1,   0,  /* "anora" 16721 */
     24,  13,  10,  24,  12,   0,  /* "anorak" 16727 */
     24,  13,  10,  21,  12,  14,  26,   1,   0,  /* "anorexia" 16736 */
     24,  13,  10,  21,  12,  14,  31,  12,   0,  /* "anorexic" 16745 */
     24,  13,  10,  21,  12,  14,  31,  12,  14,   0,  /* "anorexics" 16755 */
     34,  13,  18,   4,  16,  39,   3,   0,  /* "anorthite" 16763 */
      1,  13,  35,  46,  10,   0,  /* "another" 16769 */
     24,  13,  14,   1,   0,  /* "ansa" 16774 */
     34,  13,  14,   8,   7,  20,  27,   0,  /* "ansaldo" 16782 */
     24,  13,  14,  34,  32,   0,  /* "ansang" 16788 */
     19,  13,  14,   8,   4,  26,   0,  /* "ansari" 16795 */
     24,  13,  33,   7,   1,  14,   0,  /* "anschluss" 16802 */
      1,  13,  14,  12,   8,  17,   0,  /* "anscom" 16809 */
      1,  13,  14,  12,   8,  17,   0,  /* "anscomb" 16816 */
     24,  13,  14,   0,  /* "anse" 16820 */
      1,  13,  14,  21,   7,   0,  /* "ansel" 16826 */
     24,  13,  14,  21,   7,   0,  /* "ansell" 16832 */
     24,  13,  14,  15,   7,  17,   0,  /* "anselm" 16839 */
     19,  13,  14,  21,   7,  17,   1,   0,  /* "anselma" 16847 */
     19,  13,  14,  21,   7,  17,  26,   0,  /* "anselmi" 16855 */
     19,  13,  14,  21,   7,  17,  27,   0,  /* "anselmo" 16863 */
     24,  13,  14,  21,   3,   0,  /* "ansett" 16869 */
     24,  13,  14,  11,  19,   4,   0,  /* "ansgar" 16876 */
     24,  13,  33,   1,  13,   0,  /* "anshan" 16882 */
     24,  13,  14,   5,  13,   0,  /* "ansin" 16888 */
     34,  13,  14,  25,  13,  26,   1,   0,  /* "ansonia" 16896 */
     24,  13,  14,   6,   8,  12,   0,  /* "anspach" 16903 */
      1,  13,  14,   6,  18,   0,  /* "anspaugh" 16909 */
      1,  13,  14,   3,  21,   3,   0,  /* "anstett" 16916 */
      8,  13,  14,   3,   5,  14,   0,  /* "anstice" 16923 */
     19,  13,  14,   3,  23,  13,  26,   0,  /* "anstine" 16931 */
     24,  13,  14,   3,   5,  14,   0,  /* "anstiss" 16938 */
     24,  13,  14,  10,   1,   9,   1,   7,   0,  /* "answerable" 16947 */
     24,  13,   3,   0,  /* "ant" 16951 */
     34,  13,   3,  24,  11,   1,  13,   5,  30,   1,  17,   0,  /* "antagonism" 16963 */
     34,  13,   3,  24,  11,   1,  13,   5,  30,   1,  17,  30,   0,  /* "antagonisms" 16976 */
     34,  13,   3,  24,  11,   1,  13,  39,  30,   0,  /* "antagonize" 16986 */
     34,  13,   3,  24,  11,   1,  13,  39,  30,  20,   0,  /* "antagonized" 16997 */
     34,  13,   3,  24,  11,   1,  13,  39,  30,  31,  32,   0,  /* "antagonizing" 17009 */
     24,  13,   3,   1,   7,   0,  /* "antal" 17015 */
     24,  13,   3,  10,   0,  /* "antar" 17020 */
     24,  13,   3,   8,   4,  12,   3,  31,  12,   1,   0,  /* "antarctica" 17031 */
     34,  13,   3,  21,   4,  26,  30,   0,  /* "antares" 17039 */
     19,  13,   3,   2,   1,   0,  /* "antaya" 17045 */
     24,  13,   3,  26,   0,  /* "ante" 17050 */
     24,  13,   3,   1,  14,  23,  20,   1,  13,   3,   0,  /* "antecedent" 17061 */
     24,  13,   3,   1,  14,  23,  20,   1,  13,   3,  14,   0,  /* "antecedents" 17073 */
     34,  13,   3,  21,   7,   0,  /* "antell" 17079 */
     24,  13,   3,   1,  17,  15,   4,   5,  20,  26,   1,  13,   0,  /* "antemeridian" 17092 */
     34,  13,   3,   1,  17,  18,   4,   3,   1,  17,   0,  /* "antemortem" 17103 */
     34,  13,   3,  21,  13,   1,   0,  /* "antenna" 17110 */
     34,  13,   3,  21,  13,  26,   0,  /* "antennae" 17117 */
     34,  13,   3,  21,  13,   1,  30,   0,  /* "antennas" 17125 */
     34,  13,   3,  21,  13,   0,  /* "antenne" 17131 */
     34,  13,   3,   1,  13,  29,  42,  26,   0,  /* "antenucci" 17140 */
     34,  13,   3,   5,   4,  26,  10,   0,  /* "anterior" 17148 */
     34,  13,   3,   5,   4,  26,  10,  17,  25,  14,   3,   0,  /* "anteriormost" 17160 */
     24,  13,   3,  26,  30,   0,  /* "antes" 17166 */
     24,  13,  16,  26,   1,   0,  /* "anthea" 17172 */
     24,  13,  46,   1,  30,   0,  /* "anthes" 17178 */
     24,  13,  16,  26,   1,   7,   0,  /* "anthiel" 17185 */
     24,  13,   3,  38,   5,   7,   0,  /* "anthill" 17192 */
     24,  13,   3,  38,   5,   7,  30,   0,  /* "anthills" 17200 */
     34,  13,  16,   8,   7,   1,  40,  26,  30,   0,  /* "anthologies" 17210 */
     34,  13,  16,   8,   7,   1,  40,  26,   0,  /* "anthology" 17219 */
     24,  13,  16,   4,   1,  14,  39,   3,   0,  /* "anthracite" 17228 */
     24,  13,  16,   4,  34,  12,  14,   0,  /* "anthrax" 17236 */
     24,  13,  16,   4,  27,   9,  35,   3,   0,  /* "anthrobot" 17245 */
     24,  13,  16,   4,   1,   6,   1,  14,  21,  13,   3,   4,  31,  12,   0,  /* "anthropocentric" 17260 */
     24,  13,  16,   4,   1,   6,   1,   7,   8,  40,   1,  12,   1,   7,   0,  /* "anthropological" 17275 */
     24,  13,   3,  26,   0,  /* "anti" 17280 */
     24,  13,   3,  26,   1,   9,  18,   4,  33,   1,  13,   0,  /* "antiabortion" 17292 */
     24,  13,   3,  39,  21,   4,  12,   4,  24,  37,   3,   0,  /* "antiaircraft" 17304 */
     24,  13,   3,  26,   9,  34,  12,   3,   5,   4,  26,   1,   7,   0,  /* "antibacterial" 17318 */
     24,  13,   3,  26,   9,   1,   7,   5,  14,   3,  31,  12,   0,  /* "antiballistic" 17331 */
     24,  13,   3,  26,   9,  26,   8,   3,  31,  12,  27,  14,   0,  /* "antibioticos" 17344 */
     24,  13,   3,  39,  12,  24,  13,  14,  10,   0,  /* "anticancer" 17354 */
     34,  13,   3,   5,  14,   1,   6,   2,   3,   0,  /* "anticipate" 17364 */
     34,  13,   3,   5,  14,   1,   6,   2,   3,   1,  20,   0,  /* "anticipated" 17376 */
     34,  13,   3,   5,  14,   1,   6,   2,   3,  14,   0,  /* "anticipates" 17387 */
     34,  13,   3,   5,  14,   1,   6,   2,   3,  31,  32,   0,  /* "anticipating" 17399 */
     34,  13,   3,   5,  14,   1,   6,   2,  33,   1,  13,   0,  /* "anticipation" 17411 */
     34,  13,   3,   5,  14,   1,   6,   2,  33,   1,  13,  30,   0,  /* "anticipations" 17424 */
     34,  13,   3,   5,  14,   1,   6,   1,   3,  18,   4,  26,   0,  /* "anticipatory" 17437 */
     24,  13,   3,  26,  12,   7,  39,  17,  24,  12,   3,  31,  12,   0,  /* "anticlimactic" 17451 */
     24,  13,   3,  31,  12,   7,  39,  13,   0,  /* "anticline" 17460 */
     19,  13,   3,  23,  12,  27,   0,  /* "antico" 17467 */
     24,  13,   3,  26,  12,   8,  17,  41,   1,  13,   1,  14,   3,   0,  /* "anticommunist" 17481 */
     24,  13,   3,  31,  12,   1,  17,   6,  21,   3,   1,   3,  31,  22,   0,  /* "anticompetitive" 17496 */
     24,  13,   3,  39,  12,  10,  35,   6,  33,   1,  13,   0,  /* "anticorruption" 17508 */
     24,  13,   3,  26,  12,   4,  39,  17,   0,  /* "anticrime" 17517 */
     24,  13,   3,  26,  20,   1,   6,   4,  21,  14,   1,  13,   3,   0,  /* "antidepressant" 17531 */
     24,  13,   3,  39,  20,   1,   6,   4,  21,  14,   1,  13,   3,  14,   0,  /* "antidepressants" 17546 */
     24,  13,   3,  26,  20,   1,  14,  12,   4,   5,  17,   1,  13,   2,  33,   1,  13,   0,  /* "antidiscrimination" 17564 */
     24,  13,   3,   1,  20,  25,   3,   0,  /* "antidote" 17572 */
     24,  13,   3,  26,  20,  35,  17,   6,  31,  32,   0,  /* "antidumping" 17583 */
     24,  13,   3,  26,  37,   4,   8,  20,   0,  /* "antifraud" 17592 */
     24,  13,   3,  39,  37,  35,  32,  11,   1,   7,   0,  /* "antifungal" 17603 */
     24,  13,   3,  39,  11,   2,   0,  /* "antigay" 17610 */
     24,  13,   3,  31,  40,   1,  13,  30,   0,  /* "antigens" 17619 */
     34,   3,   5,  11,   1,  13,  26,   0,  /* "antigone" 17627 */
     34,  13,   3,   5,  11,   1,  13,  23,  30,   0,  /* "antigones" 17637 */
     24,  13,   3,  26,  11,  35,  22,  10,  17,   1,  13,   3,   0,  /* "antigovernment" 17650 */
     34,  13,   3,  23,  11,  47,   1,   0,  /* "antigua" 17658 */
     24,  13,   3,  26,  38,   5,  14,   3,   1,  17,   1,  13,   0,  /* "antihistamine" 17671 */
     24,  13,   3,  26,  38,   5,  14,   3,   1,  17,   1,  13,  30,   0,  /* "antihistamines" 17685 */
     24,  13,   3,  26,  13,   8,  12,   0,  /* "antiknock" 17693 */
     34,  13,   3,   5,   7,   0,  /* "antill" 17699 */
     19,  13,   3,   5,   7,   1,   0,  /* "antilla" 17706 */
     34,  13,   3,   5,   7,  26,  30,   0,  /* "antilles" 17714 */
     24,  13,   3,  39,  17,   5,  14,   1,   7,   0,  /* "antimissile" 17724 */
     24,  13,   3,  26,   8,  12,   0,  /* "antioch" 17731 */
     24,  13,   3,  26,   8,  12,  14,   1,  20,   1,  13,   3,   0,  /* "antioxidant" 17744 */
     24,  13,   3,  26,   8,  12,  14,   1,  20,   1,  13,   3,  14,   0,  /* "antioxidants" 17758 */
     34,  13,   3,   5,   6,   1,  16,  26,  30,   0,  /* "antipathies" 17768 */
     34,  13,   3,   5,   6,   1,  16,  26,   0,  /* "antipathy" 17777 */
     34,  13,   3,  39,   6,  10,  14,   1,  13,  21,   7,   0,  /* "antipersonell" 17789 */
     24,  13,   3,   1,  37,   8,  13,   0,  /* "antiphon" 17797 */
     34,  13,   3,   5,   6,   1,  20,   1,   7,   0,  /* "antipodal" 17807 */
     24,  13,   3,  39,   6,   8,  22,  10,   3,  26,   0,  /* "antipoverty" 17818 */
     24,  13,   3,   1,  12,  47,   2,   3,   0,  /* "antiquate" 17827 */
     24,  13,   3,   1,  12,  47,   2,   3,   1,  20,   0,  /* "antiquated" 17838 */
     34,  13,   3,  23,  12,   0,  /* "antique" 17844 */
     34,  13,   3,  23,  12,  14,   0,  /* "antiques" 17851 */
     34,  13,   3,   5,  12,  47,   1,   3,  26,  30,   0,  /* "antiquities" 17862 */
     34,  13,   3,   5,  12,  47,   1,   3,  26,   0,  /* "antiquity" 17872 */
     24,  13,   3,  26,   4,   1,  37,  18,   4,  17,  10,   0,  /* "antireformer" 17884 */
     24,  13,   3,  26,   4,   1,  37,  18,   4,  17,  10,  30,   0,  /* "antireformers" 17897 */
     24,  13,   3,  39,  30,   0,  /* "antis" 17903 */
     24,  13,   3,  26,  14,  21,  13,  14,   0,  /* "antisense" 17912 */
     24,  13,   3,  26,  14,  17,  25,  12,  31,  32,   0,  /* "antismoking" 17923 */
     24,  13,   3,  39,  14,  25,  33,   1,   7,   0,  /* "antisocial" 17933 */
     24,  13,   3,  39,  14,  35,   9,  17,  10,  23,  13,   0,  /* "antisubmarine" 17945 */
     24,  13,   3,  26,   3,   2,  12,  25,  22,  10,   0,  /* "antitakeover" 17956 */
     24,  13,   3,  26,   3,  24,  32,  12,   0,  /* "antitank" 17965 */
     24,  13,   3,  39,   3,  24,  12,  14,   0,  /* "antitax" 17974 */
     24,  13,   3,  39,  16,  21,  37,   3,   0,  /* "antitheft" 17983 */
     34,  13,   3,   5,  16,   1,  14,   1,  14,   0,  /* "antithesis" 17993 */
     24,  13,   3,  26,   3,   8,  12,  14,   1,  13,   0,  /* "antitoxin" 18004 */
     24,  13,   3,  26,   3,   8,  12,  14,   1,  13,  30,   0,  /* "antitoxins" 18016 */
     24,  13,   3,  39,   3,   4,  35,  14,   3,   0,  /* "antitrust" 18026 */
     24,  13,   3,  26,  22,  39,   4,   1,   7,   0,  /* "antiviral" 18036 */
     24,  13,   3,  39,  47,  18,   4,   0,  /* "antiwar" 18044 */
      1,  13,   3,  12,  48,  26,  34,  12,   0,  /* "antkowiak" 18053 */
     24,  13,   3,   1,   7,   0,  /* "antle" 18059 */
     19,  13,   3,  47,   8,  13,   0,  /* "antoine" 18066 */
     24,  13,   3,  47,   1,  13,  21,   3,   0,  /* "antoinette" 18075 */
     19,  13,   3,  18,   7,   0,  /* "antol" 18081 */
     24,  13,   3,   1,   7,  31,  12,   0,  /* "antolik" 18089 */
     24,  13,   3,  18,  13,   0,  /* "anton" 18095 */
     19,  13,   3,  27,  13,   8,  42,  26,   0,  /* "antonacci" 18104 */
     19,  13,   3,  25,  13,  26,   0,  /* "antone" 18111 */
     19,  13,   3,  27,  13,  21,   7,  26,   0,  /* "antonelli" 18120 */
     34,  13,   3,   1,  13,  21,   7,   1,  14,   0,  /* "antonellis" 18130 */
     19,  13,   3,  27,  13,  21,   3,  26,   0,  /* "antonetti" 18139 */
     19,  13,   3,  25,  13,  26,   0,  /* "antoni" 18146 */
     34,  13,   3,  25,  13,  26,   1,   0,  /* "antonia" 18154 */
     24,  13,   3,   1,  13,   5,  13,   0,  /* "antonin" 18162 */
     19,  13,   3,  27,  13,  23,  13,  26,   0,  /* "antonini" 18171 */
     34,  13,   3,  25,  13,  26,  27,   0,  /* "antonio" 18179 */
     19,  13,   3,  27,  13,  23,  29,   0,  /* "antoniou" 18187 */
     34,  13,   3,  25,  13,  26,   1,  14,   0,  /* "antonius" 18196 */
     34,  13,   3,   1,  13,   8,   6,   1,   7,   1,  14,   0,  /* "antonopoulos" 18208 */
     24,  13,   3,   8,  13,   1,  22,  31,  42,   0,  /* "antonovich" 18218 */
      1,  13,   3,   8,  13,  14,   1,  13,   0,  /* "antonsen" 18227 */
     24,  13,   3,   1,  13,  14,   1,  13,   0,  /* "antonson" 18236 */
     19,  13,   3,  27,  13,  29,  42,  26,   0,  /* "antonucci" 18245 */
     24,  13,   3,  29,  13,   0,  /* "antoon" 18251 */
      8,  13,   3,  27,  30,   0,  /* "antos" 18257 */
      1,  13,   3,   8,  33,   0,  /* "antosh" 18263 */
     24,  13,   3,   4,   1,   9,   1,  14,   0,  /* "antrobus" 18272 */
     24,  13,   3,  14,   0,  /* "ants" 18277 */
     19,  13,   3,  23,   7,   1,   0,  /* "anttila" 18284 */
     19,  13,   3,  29,  13,   1,   0,  /* "antuna" 18291 */
     19,  13,   3,  29,  13,  15,  14,   0,  /* "antunes" 18299 */
     19,  13,   3,  29,  13,  15,  30,   0,  /* "antunez" 18307 */
     24,  13,   3,  47,  10,   6,   0,  /* "antwerp" 18314 */
     24,  13,   3,  47,  39,  13,   0,  /* "antwine" 18321 */
     24,  13,  22,   1,   7,   0,  /* "anvil" 18327 */
     24,  13,  47,  19,   4,   0,  /* "anwar" 18333 */
      1,  13,  47,   2,   0,  /* "anway" 18338 */
      1,  13,  47,  21,   7,   0,  /* "anwell" 18344 */
     24,  13,  47,   5,   7,   0,  /* "anwyl" 18350 */
     24,  13,  47,   5,   7,   0,  /* "anwyll" 18356 */
     34,  32,  30,  39,   1,   3,  26,  30,   0,  /* "anxieties" 18365 */
     34,  32,  30,  39,   1,   3,  26,   0,  /* "anxiety" 18373 */
     24,  32,  12,  33,   1,  14,   0,  /* "anxious" 18380 */
     24,  32,  12,  33,   1,  14,   7,  26,   0,  /* "anxiously" 18389 */
     21,  13,  26,   0,  /* "any" 18393 */
     21,  13,  26,   9,   1,  20,  26,   0,  /* "anybody" 18401 */
     21,  13,  26,  38,  48,   0,  /* "anyhow" 18407 */
     21,  13,  26,  17,  18,   4,   0,  /* "anymore" 18414 */
     21,  13,  26,  19,  13,   0,  /* "anyon" 18420 */
     21,  13,  26,  47,   1,  13,   0,  /* "anyone" 18427 */
     21,  13,  26,  16,   5,  32,   0,  /* "anything" 18434 */
     21,  13,  26,   3,  39,  17,   0,  /* "anytime" 18441 */
     21,  13,  26,  47,  21,   4,   0,  /* "anywhere" 18448 */
     24,  13,  30,   1,   0,  /* "anza" 18453 */
     19,  13,  30,  19,   7,  20,  29,   1,   0,  /* "anzaldua" 18462 */
     19,  13,  30,  21,   7,  17,  27,   0,  /* "anzelmo" 18470 */
     24,  13,  30,  23,  27,   0,  /* "anzio" 18476 */
     48,  26,   0,  /* "aoi" 18479 */
     28,  25,  12,  26,   0,  /* "aoki" 18484 */
      2,  25,  21,   7,   0,  /* "aol" 18489 */
      2,  27,  13,   0,  /* "aon" 18493 */
     28,  18,   4,   3,   1,   0,  /* "aorta" 18499 */
     28,  18,   4,   3,  31,  12,   0,  /* "aortic" 18506 */
     48,  33,  23,  17,   1,   0,  /* "aoshima" 18512 */
     48,   1,  13,   0,  /* "aoun" 18516 */
     48,  41,  29,  30,  29,   0,  /* "aouzou" 18522 */
     48,  41,   8,  17,   1,   0,  /* "aoyama" 18528 */
      1,   6,   2,  14,   0,  /* "apace" 18533 */
      1,   6,  24,  42,  26,   0,  /* "apache" 18539 */
      1,   6,  24,  42,  26,  30,   0,  /* "apaches" 18546 */
     24,   6,   1,   7,  24,  42,   1,  12,  25,   7,   1,   0,  /* "apalachicola" 18558 */
     24,   6,  10,   5,  14,  26,  27,   0,  /* "aparicio" 18566 */
      1,   6,   8,   4,   3,  39,   3,   0,  /* "apartheid" 18574 */
     24,   6,   1,   3,  39,   3,   0,  /* "apatite" 18581 */
     24,   6,   1,   3,  39,   3,  14,   0,  /* "apatites" 18589 */
      2,   6,  23,  14,  23,   0,  /* "apc" 18595 */
     24,   6,  12,  19,   4,   0,  /* "apcar" 18601 */
      2,   6,   0,  /* "ape" 18604 */
      2,   6,  21,  12,   0,  /* "apec" 18609 */
     19,   6,  21,   7,   0,  /* "apel" 18614 */
      2,   6,   7,  39,  12,   0,  /* "apelike" 18620 */
     24,   6,   1,  13,  23,  13,   0,  /* "apennine" 18627 */
     24,   6,  10,  42,  10,   0,  /* "aperture" 18633 */
      2,   6,  14,   0,  /* "apes" 18637 */
      2,   6,  21,  12,  14,   0,  /* "apex" 18643 */
     24,  37,   1,  20,   0,  /* "aphid" 18648 */
     24,  37,   1,  20,  30,   0,  /* "aphids" 18654 */
     24,  37,  10,   5,  30,   1,  17,   0,  /* "aphorism" 18662 */
     24,  37,  10,   5,  30,   1,  17,  30,   0,  /* "aphorisms" 18671 */
     24,  37,   4,  27,  20,  23,  30,  26,  34,  12,   0,  /* "aphrodisiac" 18682 */
     24,  37,   4,   1,  20,  39,   3,  26,   0,  /* "aphrodite" 18691 */
     24,  37,   4,   1,  20,  39,   3,  26,  30,   0,  /* "aphrodites" 18701 */
      1,   6,  23,  14,   0,  /* "apiece" 18706 */
     24,   6,   7,   5,  13,   0,  /* "aplin" 18712 */
      1,   6,   7,   8,  17,   0,  /* "aplomb" 18718 */
      1,   6,   8,  12,   1,   7,   5,   6,   3,  31,  12,   0,  /* "apocalyptic" 18730 */
      1,   6,   8,  12,   4,   1,  37,   1,   7,   0,  /* "apocryphal" 18740 */
     19,   6,  27,  20,   8,  12,   1,   0,  /* "apodaca" 18748 */
     24,   6,   1,  40,  23,   0,  /* "apogee" 18754 */
      2,   6,   1,   7,   5,   3,  31,  12,   1,   7,   0,  /* "apolitical" 18765 */
     24,   6,   1,   7,  39,  13,   0,  /* "apolline" 18772 */
     24,   6,   1,   7,   5,  13,  26,   1,  13,   0,  /* "apollinian" 18782 */
      1,   6,   8,   7,  27,   0,  /* "apollo" 18788 */
     24,   6,   1,   7,  25,  13,  26,   1,  13,   0,  /* "apollonian" 18798 */
      1,   6,   8,   7,   1,  40,  21,   3,  31,  12,   0,  /* "apologetic" 18809 */
      1,   6,   8,   7,   1,  40,  21,   3,  31,  12,   7,  26,   0,  /* "apologetically" 18822 */
      1,   6,   8,   7,   1,  40,  39,  30,   0,  /* "apologize" 18831 */
      1,   6,   8,   7,   1,  40,  39,  30,  20,   0,  /* "apologized" 18841 */
      1,   6,   8,   7,   1,  40,  39,  30,   1,  30,   0,  /* "apologizes" 18852 */
      1,   6,   8,   7,   1,  40,  39,  30,  31,  32,   0,  /* "apologizing" 18863 */
      1,   6,  18,   6,  12,   1,   0,  /* "apopka" 18870 */
     24,   6,   1,   6,   7,  21,  12,   3,  31,  12,   0,  /* "apoplectic" 18881 */
     24,   6,   1,   6,   7,  21,  12,  14,  26,   0,  /* "apoplexy" 18891 */
      1,   6,   8,  14,   1,   7,   0,  /* "apostle" 18898 */
      1,   6,   8,  14,   1,   7,  30,   0,  /* "apostles" 18906 */
     24,   6,   1,  14,   3,   1,   7,   0,  /* "apostol" 18914 */
      1,   6,   8,  14,   3,  27,   7,  27,   6,  29,   7,   0,  /* "apostolopoul" 18926 */
      1,   6,   8,  14,   3,   4,   1,  37,  26,   0,  /* "apostrophe" 18936 */
      1,   6,   8,  16,  26,  25,  14,   1,  14,   0,  /* "apotheosis" 18946 */
     24,   6,   0,  /* "app" 18949 */
     24,   6,   1,   7,  24,  42,  26,   1,   0,  /* "appalachia" 18958 */
     24,   6,   1,   7,   2,  42,   1,  13,   0,  /* "appalachian" 18967 */
     24,   6,   1,   7,   2,  42,   1,  13,  30,   0,  /* "appalachians" 18977 */
      1,   6,  18,   7,   0,  /* "appall" 18982 */
      1,   6,  18,   7,  20,   0,  /* "appalled" 18988 */
      1,   6,  18,   7,  31,  32,   0,  /* "appalling" 18995 */
      1,   6,  18,   7,  31,  32,   7,  26,   0,  /* "appallingly" 19004 */
      1,   6,  18,   7,  30,   0,  /* "appalls" 19010 */
     24,   6,  10,  24,  42,  31,  12,   0,  /* "apparatchik" 19018 */
     24,   6,  10,  24,  42,  31,  12,  14,   0,  /* "apparatchiks" 19027 */
     24,   6,  10,  24,   3,   1,  14,   0,  /* "apparatus" 19035 */
     24,   6,  10,  24,   3,   1,  14,   1,  30,   0,  /* "apparatuses" 19045 */
      1,   6,  21,   4,   1,   7,   0,  /* "apparel" 19052 */
      1,   6,  21,   4,   1,  13,   3,   0,  /* "apparent" 19060 */
      1,   6,  21,   4,   1,  13,   3,   7,  26,   0,  /* "apparently" 19070 */
     24,   6,  10,   5,  33,   1,  13,   0,  /* "apparition" 19078 */
     24,   6,  10,   5,  33,   1,  13,  30,   0,  /* "apparitions" 19087 */
      1,   6,  23,   7,   0,  /* "appeal" 19092 */
      1,   6,  23,   7,   1,   9,   1,   7,   0,  /* "appealable" 19101 */
      1,   6,  23,  30,  20,   0,  /* "appeased" 19107 */
      1,   6,  23,  30,  17,   1,  13,   3,   0,  /* "appeasement" 19116 */
      1,   6,  23,  30,  31,  32,   0,  /* "appeasing" 19123 */
     24,   6,   1,   7,   0,  /* "appel" 19128 */
     24,   6,   1,   7,   9,  48,  17,   0,  /* "appelbaum" 19136 */
     24,   6,   1,   7,  38,   1,  13,  30,   0,  /* "appelhans" 19145 */
     24,   6,   1,   7,   0,  /* "appell" 19150 */
      1,   6,  21,   7,   1,   3,   0,  /* "appellate" 19157 */
     24,   6,   1,   7,   2,  33,   1,  13,   0,  /* "appellation" 19166 */
     24,   6,   1,   7,   2,  33,   1,  13,  30,   0,  /* "appellations" 19176 */
     24,   6,   1,   7,  17,   1,  13,   0,  /* "appelman" 19184 */
     24,   6,  15,   7,   3,   0,  /* "appelt" 19190 */
     24,   6,   1,  13,  20,  21,  12,   3,   1,  17,  26,  30,   0,  /* "appendectomies" 19203 */
     24,   6,   1,  13,  20,  21,  12,   3,   1,  17,  26,   0,  /* "appendectomy" 19215 */
      1,   6,  21,  13,  20,  31,  12,  14,   0,  /* "appendix" 19224 */
      1,   6,  21,  13,  20,  31,  12,  14,   1,  30,   0,  /* "appendixes" 19235 */
     24,   6,   1,  13,  30,   1,   7,  10,   0,  /* "appenzeller" 19244 */
     24,   6,  10,  14,   1,  13,   0,  /* "apperson" 19251 */
     24,   6,  10,   3,   0,  /* "appert" 19256 */
     24,   6,   1,   3,  39,   3,   0,  /* "appetite" 19263 */
     24,   6,   1,   3,  39,   3,  14,   0,  /* "appetites" 19271 */
     24,   6,   1,   3,  23,   3,  25,   0,  /* "appetito" 19279 */
     24,   6,   1,   3,  39,  30,  10,   0,  /* "appetizer" 19287 */
     24,   6,   1,   3,  39,  30,  10,  30,   0,  /* "appetizers" 19296 */
     24,   6,   1,   3,  39,  30,  31,  32,   0,  /* "appetizing" 19305 */
      1,   6,   7,  18,  20,   0,  /* "applaud" 19311 */
      1,   6,   7,  18,  20,   1,  20,   0,  /* "applauded" 19319 */
      1,   6,   7,  18,  20,  31,  32,   0,  /* "applauding" 19327 */
      1,   6,   7,  18,  20,  30,   0,  /* "applauds" 19334 */
      1,   6,   7,  18,  30,   0,  /* "applause" 19340 */
     24,   6,   1,   7,   0,  /* "apple" 19345 */
     24,   6,   1,   7,   9,  48,  17,   0,  /* "applebaum" 19353 */
     24,   6,   1,   7,   9,  23,   0,  /* "applebee" 19360 */
     24,   6,   1,   7,   9,  21,   4,  26,   0,  /* "appleberry" 19369 */
     24,   6,   1,   7,   9,  26,   0,  /* "appleby" 19376 */
     24,   6,   7,  31,  11,  19,   4,  16,   0,  /* "applegarth" 19385 */
     24,   6,   1,   7,  11,   2,   3,   0,  /* "applegate" 19393 */
     24,   6,   1,   7,  17,   1,  13,   0,  /* "appleman" 19401 */
     24,   6,   7,  31,  12,  47,   5,  14,   3,   0,  /* "applequist" 19411 */
     24,   6,   1,   7,  30,   0,  /* "apples" 19417 */
     24,   6,   1,   7,  14,  18,  14,   0,  /* "applesauce" 19425 */
     24,   6,   1,   7,  14,  23,  20,   0,  /* "appleseed" 19433 */
     24,   6,   1,   7,  33,  21,   4,   0,  /* "appleshare" 19441 */
     24,   6,   1,   7,   3,   1,  13,   0,  /* "appleton" 19449 */
     24,   6,   1,   7,  47,  39,   3,   0,  /* "applewhite" 19457 */
     24,   6,   1,   7,  41,   8,   4,  20,   0,  /* "appleyard" 19466 */
      1,   6,   7,  39,   1,  13,  14,   0,  /* "appliance" 19474 */
      1,   6,   7,  39,   1,  13,  14,   1,  30,   0,  /* "appliances" 19484 */
     24,   6,   7,   1,  12,   1,   9,   5,   7,   1,   3,  26,   0,  /* "applicability" 19497 */
     24,   6,   7,   1,  12,   1,   9,   1,   7,   0,  /* "applicable" 19507 */
      1,   6,   7,  39,  20,   0,  /* "applied" 19513 */
      1,   6,   7,  39,  30,   0,  /* "applies" 19519 */
     24,   6,   1,   7,  31,  32,   0,  /* "appling" 19526 */
      1,   6,   7,  39,   0,  /* "apply" 19531 */
      1,   6,   7,  39,  31,  32,   0,  /* "applying" 19538 */
      1,   6,  50,  13,   3,  23,   0,  /* "appointee" 19545 */
      1,   6,  50,  13,   3,  23,  30,   0,  /* "appointees" 19553 */
      1,   6,   4,  23,  33,   1,   9,   1,   7,   0,  /* "appreciable" 19563 */
      1,   6,   4,  23,  33,  26,   2,   3,  31,  22,   0,  /* "appreciative" 19574 */
      1,   6,   4,  23,  33,  26,   2,   3,  31,  22,   7,  26,   0,  /* "appreciatively" 19587 */
     24,   6,   4,   1,  38,  21,  13,  20,   0,  /* "apprehend" 19596 */
     24,   6,   4,   1,  38,  21,  13,  20,   1,  20,   0,  /* "apprehended" 19607 */
     24,   6,   4,   1,  38,  21,  13,  20,  31,  32,   0,  /* "apprehending" 19618 */
     24,   6,   4,   1,  38,  21,  13,  33,   1,  13,   0,  /* "apprehension" 19629 */
     24,   6,   4,   1,  38,  21,  13,  33,   1,  13,  30,   0,  /* "apprehensions" 19641 */
     24,   6,   4,   1,  38,  21,  13,  14,  31,  22,   0,  /* "apprehensive" 19652 */
      1,   6,   4,  39,  30,   0,  /* "apprise" 19658 */
      1,   6,   4,  39,  30,  20,   0,  /* "apprised" 19665 */
      1,   6,   4,  25,  42,   1,   9,   1,   7,   0,  /* "approachable" 19675 */
     24,   6,   4,   1,   9,   2,  33,   1,  13,   0,  /* "approbation" 19685 */
      1,   6,   4,  25,   6,   4,  26,   1,   3,   0,  /* "appropriate" 19695 */
      1,   6,   4,  25,   6,   4,  26,  28,   3,   0,  /* "appropriate" 19705 */
      1,   6,   4,  25,   6,   4,  26,   1,   3,  13,   1,  14,   0,  /* "appropriateness" 19718 */
      1,   6,   4,  29,  22,   1,   9,   1,   7,   0,  /* "approvable" 19728 */
      1,   6,   4,  29,  22,   1,   7,   0,  /* "approval" 19736 */
      1,   6,   4,  29,  22,   1,   7,  30,   0,  /* "approvals" 19745 */
      1,   6,   4,  29,  22,   0,  /* "approve" 19751 */
      1,   6,   4,  29,  22,  20,   0,  /* "approved" 19758 */
      1,   6,   4,  29,  22,  30,   0,  /* "approves" 19765 */
      1,   6,   4,  29,  22,  31,  32,   0,  /* "approving" 19773 */
      1,   6,   4,  29,  22,  31,  32,   7,  26,   0,  /* "approvingly" 19783 */
      1,   6,   4,   8,  12,  14,   1,  17,   1,   3,   0,  /* "approximate" 19794 */
      1,   6,   4,   8,  12,  14,   1,  17,  28,   3,   0,  /* "approximate" 19805 */
      1,   6,   4,   8,  12,  14,   1,  17,   2,   3,   1,  20,   0,  /* "approximated" 19818 */
      1,   6,   4,   8,  12,  14,   1,  17,   1,   3,   7,  26,   0,  /* "approximately" 19831 */
      1,   6,   4,   8,  12,  14,   1,  17,   1,   3,  14,   0,  /* "approximates" 19843 */
      1,   6,   4,   8,  12,  14,   1,  17,   2,   3,  31,  32,   0,  /* "approximating" 19856 */
      1,   6,   4,   8,  12,  14,   1,  17,   2,  33,   1,  13,   0,  /* "approximation" 19869 */
      1,   6,   4,   8,  12,  14,   1,  17,   2,  33,   1,  13,  30,   0,  /* "approximations" 19883 */
     24,   6,  14,   0,  /* "apps" 19887 */
      2,   6,   4,   1,   0,  /* "apra" 19892 */
      2,   6,   4,   1,  12,   8,   3,   0,  /* "apricot" 19900 */
     24,   6,   4,   1,  12,   8,   3,  14,   0,  /* "apricots" 19909 */
      2,   6,   4,   1,   7,   0,  /* "april" 19915 */
      8,   6,   4,   1,   7,   0,  /* "aprile" 19921 */
     24,   6,   4,  36,  20,  23,  22,   1,   0,  /* "aprodiva" 19930 */
      2,   6,   4,   1,  13,   0,  /* "apron" 19936 */
      2,   6,   4,   1,  13,  30,   0,  /* "aprons" 19943 */
     24,   6,   4,   1,   6,  25,   0,  /* "apropos" 19950 */
     24,   6,  14,  27,   0,  /* "apso" 19955 */
     24,   6,   3,   0,  /* "apt" 19959 */
     24,   6,   3,   1,   3,  29,  20,   0,  /* "aptitude" 19967 */
     24,   6,   3,   1,   3,  29,  20,  30,   0,  /* "aptitudes" 19976 */
     19,   6,  29,  30,  27,   0,  /* "apuzzo" 19982 */
      1,  12,   8,   9,   1,   0,  /* "aqaba" 19988 */
     24,  12,   1,  30,   8,  20,  21,   0,  /* "aqazadeh" 19996 */
     24,  12,  47,   1,   0,  /* "aqua" 20001 */
     24,  12,  47,   1,  12,  35,   7,  42,  10,   0,  /* "aquaculture" 20011 */
     24,  12,  47,   1,   7,   1,  32,   0,  /* "aqualung" 20019 */
      8,  12,  47,   1,  13,   8,   3,   0,  /* "aquanaut" 20027 */
      1,  12,  47,  21,   4,   1,  14,   3,   0,  /* "aquarist" 20036 */
      1,  12,  47,  21,   4,   1,  14,   3,  14,   0,  /* "aquarists" 20046 */
      1,  12,  47,  21,   4,  26,   1,  17,   0,  /* "aquarium" 20055 */
      1,  12,  47,  21,   4,  26,   1,  17,  30,   0,  /* "aquariums" 20065 */
      1,  12,  47,  21,   4,  26,   1,  14,   0,  /* "aquarius" 20074 */
      1,  12,  47,   8,   3,  31,  12,   0,  /* "aquatic" 20082 */
      2,  12,  47,  26,   1,  14,   0,  /* "aqueous" 20089 */
     24,  12,  47,   1,  37,  10,   0,  /* "aquifer" 20096 */
     24,  12,  47,   1,  37,  10,  30,   0,  /* "aquifers" 20104 */
     24,  12,  47,   1,   7,   1,   0,  /* "aquila" 20111 */
     19,  12,  47,  26,   7,   8,   4,   0,  /* "aquilar" 20119 */
     19,  12,  47,  26,   7,  23,  13,   1,   0,  /* "aquilina" 20128 */
     19,  12,  47,  26,   7,  23,  13,  27,   0,  /* "aquilino" 20137 */
      1,  12,  47,  39,  13,   1,  14,   0,  /* "aquinas" 20145 */
      1,  12,  23,  13,  27,   0,  /* "aquino" 20151 */
     24,  12,  47,  10,   0,  /* "aquirre" 20156 */
      8,   4,   0,  /* "ar" 20159 */
     24,   4,   1,   0,  /* "ara" 20163 */
     24,   4,   1,   9,   0,  /* "arab" 20168 */
     19,   4,   8,   9,  28,   0,  /* "arabe" 20174 */
     24,   4,   1,   9,  21,   7,   1,   0,  /* "arabella" 20182 */
     10,   2,   9,  26,   1,   0,  /* "arabia" 20188 */
     10,   2,   9,  26,   1,  13,   0,  /* "arabian" 20195 */
     10,   2,   9,  26,   1,  13,  30,   0,  /* "arabians" 20203 */
     24,   4,   1,   9,  31,  12,   0,  /* "arabic" 20210 */
     10,  24,   9,  31,  12,   1,   0,  /* "arabica" 20217 */
      1,   4,  24,   9,  31,  33,  18,  13,   0,  /* "arabichon" 20226 */
      1,   4,  24,   9,   1,  12,  18,  13,   0,  /* "arabicon" 20235 */
     10,  24,   9,  26,   0,  /* "arabie" 20240 */
     21,   4,   1,   9,   1,   7,   0,  /* "arable" 20247 */
     10,  24,  12,  13,   1,  20,   0,  /* "arachnid" 20254 */
     10,  24,  12,  13,   1,  20,  30,   0,  /* "arachnids" 20262 */
     21,   4,   1,  37,  34,   3,   0,  /* "arafat" 20269 */
     21,   4,   1,  11,   8,  13,   0,  /* "aragon" 20276 */
     19,   4,  19,  11,  25,  13,   1,   0,  /* "aragona" 20284 */
     19,   4,   8,  26,   0,  /* "arai" 20289 */
     10,   2,  30,   1,   0,  /* "araiza" 20294 */
     19,   4,  19,  12,   8,  12,  26,   0,  /* "arakaki" 20302 */
      8,   4,  19,  12,   8,  47,   1,   0,  /* "arakawa" 20310 */
     34,   4,   1,  12,  21,   7,  41,   1,  13,   0,  /* "arakelian" 20320 */
     19,   4,   8,  12,  26,   0,  /* "araki" 20326 */
      8,   4,   1,   7,   0,  /* "aral" 20331 */
     19,   4,  19,  17,   9,  29,   7,   1,   0,  /* "arambula" 20340 */
     10,  24,  17,  12,  27,   0,  /* "aramco" 20346 */
     21,   4,   1,  17,   1,  20,   0,  /* "aramid" 20353 */
     24,   4,   1,  17,   5,  13,   3,   1,   0,  /* "araminta" 20362 */
     21,   4,   1,  17,   5,  14,   0,  /* "aramis" 20369 */
      8,   4,   1,  17,  25,  13,  26,   0,  /* "aramony" 20377 */
     21,   4,   1,  13,   0,  /* "aran" 20382 */
     19,   4,  24,  13,   1,   0,  /* "arana" 20388 */
     10,  24,  13,  20,   1,   0,  /* "aranda" 20394 */
     19,   4,   8,  32,  11,  27,   0,  /* "arango" 20401 */
     10,  24,  13,  14,   1,  14,   0,  /* "aransas" 20408 */
      8,   4,   1,  13,   3,   0,  /* "arant" 20414 */
      1,   4,   8,  13,   3,  30,   1,   0,  /* "arantza" 20422 */
     10,   8,  13,  41,  25,  14,   0,  /* "aranyos" 20429 */
     10,  24,   6,   1,  38,  25,   0,  /* "arapaho" 20436 */
     10,  24,  14,  19,  11,   0,  /* "araskog" 20442 */
     19,   4,   8,   3,   1,   0,  /* "arata" 20448 */
      1,   4,  48,   0,  /* "arau" 20452 */
     19,   4,  48,  41,  27,   0,  /* "araujo" 20458 */
      8,   4,  22,   1,  13,  20,   0,  /* "aravind" 20465 */
     10,  39,   1,   0,  /* "araya" 20469 */
      8,   4,   9,   0,  /* "arb" 20473 */
      8,   4,   9,   1,   0,  /* "arba" 20478 */
      8,   4,   9,  18,   0,  /* "arbaugh" 20483 */
      8,   4,   9,   1,  20,   0,  /* "arbed" 20489 */
      8,   4,   9,  39,   3,  10,   0,  /* "arbeiter" 20496 */
      8,   4,   9,   1,   3,  10,   0,  /* "arbiter" 20503 */
      8,   4,   9,   1,   3,  10,  30,   0,  /* "arbiters" 20511 */
      8,   4,   9,   1,   3,   4,   8,  43,   0,  /* "arbitrage" 20520 */
      8,   4,   9,   1,   3,   4,   8,  43,  10,   0,  /* "arbitrager" 20530 */
      8,   4,   9,   1,   3,   4,   8,  43,  10,  30,   0,  /* "arbitragers" 20541 */
      8,   4,   9,   1,   3,   4,   8,  43,  10,   0,  /* "arbitrageur" 20551 */
      8,   4,   9,   1,   3,   4,   8,  43,  10,  30,   0,  /* "arbitrageurs" 20562 */
      8,   4,   9,   1,   3,   4,   8,  40,  31,  32,   0,  /* "arbitraging" 20573 */
      8,   4,   9,   1,   3,   4,   8,  13,   0,  /* "arbitron" 20582 */
      8,   4,   9,  27,   0,  /* "arbo" 20587 */
     19,   4,   9,  25,  11,  19,  14,   3,   0,  /* "arbogast" 20596 */
     19,   4,   9,  27,   7,  21,  20,   1,   0,  /* "arboleda" 20605 */
     19,   4,   9,  18,   4,  26,   1,   7,   0,  /* "arboreal" 20614 */
      8,   4,   9,  10,  23,   3,   1,  17,   0,  /* "arboretum" 20623 */
      8,   4,   9,  10,  22,   1,   7,   0,  /* "arborville" 20631 */
      8,   4,   9,  10,   0,  /* "arbour" 20636 */
      8,   4,   9,  30,   0,  /* "arbs" 20641 */
      8,   4,   9,   1,  12,   1,   7,   0,  /* "arbuckle" 20649 */
      8,   4,   9,   1,  12,   1,   7,  30,   0,  /* "arbuckles" 20658 */
     19,   4,   9,  35,  16,  13,   1,   3,   0,  /* "arbuthnot" 20667 */
      8,   4,   9,  26,   0,  /* "arby" 20672 */
      8,   4,  12,   0,  /* "arc" 20676 */
     19,   4,  12,   2,  20,   0,  /* "arcade" 20682 */
     19,   4,  12,   2,  20,  30,   0,  /* "arcades" 20689 */
     19,   4,  12,   2,  20,  26,   1,   0,  /* "arcadia" 20697 */
     19,   4,  12,  24,  13,   1,   0,  /* "arcana" 20704 */
      8,   4,  12,   1,  13,  20,   0,  /* "arcand" 20711 */
     19,   4,  12,   8,   4,  27,   0,  /* "arcaro" 20718 */
     19,   4,  12,   8,   3,   1,   0,  /* "arcata" 20725 */
      8,   4,  14,   0,  /* "arce" 20729 */
     19,   4,  14,   2,  17,   1,  13,   3,   0,  /* "arcement" 20738 */
      8,   4,  14,  26,  27,   0,  /* "arceo" 20744 */
      8,   4,  42,   0,  /* "arch" 20748 */
      8,   4,  12,  26,   1,   7,   8,  40,  31,  12,   1,   7,   0,  /* "archaeological" 20761 */
     19,   4,  12,   2,  31,  12,   0,  /* "archaic" 20768 */
      8,   4,  33,   1,  17,   9,  27,   0,  /* "archambault" 20776 */
      8,   4,  33,   1,  17,   9,  27,   0,  /* "archambeault" 20784 */
      8,   4,  12,   2,  13,  40,   1,   7,   0,  /* "archangel" 20793 */
      8,   4,  12,   2,  13,  40,   1,   7,  30,   0,  /* "archangels" 20803 */
     19,   4,  33,   8,   4,  20,   0,  /* "archard" 20810 */
      8,   4,  42,   9,   5,  33,   1,   6,   0,  /* "archbishop" 20819 */
      8,   4,  42,   9,  25,   7,  20,   0,  /* "archbold" 20827 */
      8,   4,  42,  20,  39,   1,  14,   1,  14,   0,  /* "archdiocese" 20837 */
      8,   4,  42,  20,  29,  12,   0,  /* "archduke" 20844 */
     19,   4,  42,  21,  13,   1,  17,  26,   0,  /* "archenemy" 20853 */
      8,   4,  12,  26,   1,   7,   8,  40,  31,  12,   1,   7,   0,  /* "archeological" 20866 */
      8,   4,  12,  26,   8,   7,   1,  40,  26,   0,  /* "archeology" 20876 */
      8,   4,  12,  10,  20,   0,  /* "archerd" 20882 */
     19,   4,  12,   3,  39,   6,   1,   7,   0,  /* "archetypal" 20891 */
      8,   4,  12,   1,   3,  39,   6,   0,  /* "archetype" 20899 */
      8,   4,  12,   1,   3,  39,   6,  14,   0,  /* "archetypes" 20908 */
      8,   4,  12,  26,   0,  /* "archey" 20913 */
      8,   4,  42,   1,   9,  18,   7,  20,   0,  /* "archibald" 20922 */
      8,   4,  33,   1,   9,  26,  12,   0,  /* "archibeque" 20930 */
      8,   4,  42,  26,   0,  /* "archie" 20935 */
      8,   4,  12,   1,  17,  23,  20,  26,  30,   0,  /* "archimedes" 20945 */
      8,   4,  42,  31,  32,   0,  /* "arching" 20951 */
      8,   4,  12,   1,   6,  21,   7,   1,  11,  25,   0,  /* "archipelago" 20962 */
      8,   4,  12,   1,   3,   4,   2,  22,   0,  /* "architrave" 20971 */
      8,   4,  12,   1,   3,   4,   2,  22,  30,   0,  /* "architraves" 20981 */
     19,   4,  12,  39,  22,   1,   7,   0,  /* "archival" 20989 */
      8,   4,  12,  39,  22,   0,  /* "archive" 20995 */
      8,   4,  12,  39,  22,  30,   0,  /* "archives" 21002 */
      8,   4,  12,   1,  22,   1,  14,   3,   0,  /* "archivist" 21011 */
      8,   4,  12,   1,  22,   1,  14,   3,  14,   0,  /* "archivists" 21021 */
      8,   4,  42,   7,  26,   0,  /* "archly" 21027 */
      8,   4,  42,   4,  39,  22,   1,   7,   0,  /* "archrival" 21036 */
      8,   4,  42,   4,  39,  22,   1,   7,  30,   0,  /* "archrivals" 21046 */
     19,   4,  12,  29,   7,  21,   3,   1,   0,  /* "archuleta" 21055 */
     19,   4,  12,  29,   7,  21,   3,   1,   0,  /* "archuletta" 21064 */
     19,   4,  42,  26,  20,  26,  19,  12,  25,  13,  27,   0,  /* "arcidiacono" 21076 */
     19,   4,  42,   5,   4,  26,   0,  /* "arcieri" 21083 */
     19,   4,  42,  26,  13,  23,  11,   1,   0,  /* "arciniega" 21092 */
      8,   4,  12,  27,   0,  /* "arco" 21097 */
     19,   4,  12,  25,   7,   1,   0,  /* "arcola" 21104 */
      8,   4,  12,   1,  14,  24,  13,   3,  26,   0,  /* "arcosanti" 21114 */
      8,   4,  12,  14,   0,  /* "arcs" 21119 */
     19,   4,  12,  45,   4,  26,   0,  /* "arcuri" 21126 */
      8,   4,  20,   0,  /* "ard" 21130 */
      8,   4,  20,   1,   0,  /* "arda" 21135 */
     19,   4,  20,  23,  13,   0,  /* "ardeen" 21141 */
     19,   4,  20,  21,   7,  26,   1,   0,  /* "ardelia" 21149 */
     19,   4,  20,  21,   7,   0,  /* "ardelle" 21155 */
      8,   4,  20,   1,  13,   3,   0,  /* "ardent" 21162 */
     19,   4,  20,  23,  13,  26,   0,  /* "ardine" 21169 */
      8,   4,  20,   1,  16,   0,  /* "ardith" 21175 */
     19,   4,  20,  23,   3,  27,   0,  /* "ardito" 21182 */
      8,   4,  20,  17,  18,   4,   0,  /* "ardmore" 21189 */
     19,   4,  20,  49,  13,   0,  /* "ardoin" 21195 */
     19,   4,  20,  27,   7,  23,  13,  27,   0,  /* "ardolino" 21204 */
      8,   4,  20,  30,   7,  26,   0,  /* "ardsley" 21211 */
     19,   4,  20,  29,  23,  13,  26,   0,  /* "arduini" 21219 */
      8,   4,  40,  29,   1,  14,   0,  /* "arduous" 21226 */
      8,   4,   0,  /* "are" 21229 */
     21,   4,  26,   1,   0,  /* "area" 21234 */
     21,   4,  26,   1,  30,   0,  /* "areas" 21240 */
     24,   4,   5,  38,  19,   4,   3,   0,  /* "arehart" 21248 */
     19,   4,  21,   7,   0,  /* "arel" 21253 */
     24,   4,   1,   7,   2,  13,  30,   0,  /* "arellanes" 21261 */
     19,   4,  15,   7,   8,  13,  27,   0,  /* "arellano" 21269 */
      8,   4,   1,  13,   0,  /* "aren" 21274 */
     10,  23,  13,   1,   0,  /* "arena" 21279 */
     10,  23,  13,   1,   9,  18,   7,   0,  /* "arenaball" 21287 */
     10,  23,  13,   1,  30,   0,  /* "arenas" 21293 */
     19,   4,  15,  13,  42,  23,   9,  26,   1,   0,  /* "arencibia" 21303 */
     10,  21,  13,  20,   0,  /* "arend" 21308 */
     10,  21,  13,  20,  30,   0,  /* "arends" 21314 */
     10,  21,  13,  20,  14,  23,   0,  /* "arendsee" 21321 */
     21,   4,  15,  13,   3,   0,  /* "arendt" 21327 */
      8,   4,   1,  13,  21,   7,   1,   0,  /* "arenella" 21335 */
     21,   4,   1,  13,  30,   0,  /* "arens" 21341 */
     24,   4,   1,  13,  14,   1,  13,   0,  /* "arenson" 21349 */
      8,   4,   1,  13,   3,   0,  /* "arent" 21355 */
     24,   4,   1,  13,   3,  14,   0,  /* "arentz" 21362 */
      8,   4,  28,  13,  30,   0,  /* "arenz" 21368 */
      8,   4,  30,   0,  /* "ares" 21372 */
     19,   4,  21,   3,   1,   0,  /* "areta" 21378 */
     10,  23,  16,   1,   0,  /* "aretha" 21383 */
     15,   4,  21,   3,  14,  12,  26,   0,  /* "aretsky" 21391 */
     19,   4,  28,  22,   8,   7,  27,   0,  /* "arevalo" 21399 */
     24,   4,  26,   0,  /* "arey" 21403 */
      8,   4,  11,   1,   9,   4,  39,   3,   0,  /* "argabright" 21412 */
     19,   4,  11,  24,  13,   9,   4,  39,   3,   0,  /* "arganbright" 21422 */
      8,   4,  11,   1,  13,   9,   4,  39,   3,   0,  /* "argenbright" 21432 */
     19,   4,  40,  15,  13,   3,   5,   4,  26,   0,  /* "argentieri" 21442 */
      8,   4,  40,   1,  13,   3,  23,  13,  30,   0,  /* "argentines" 21452 */
     19,   4,  40,   5,   4,  27,   0,  /* "argiro" 21459 */
      8,   4,  11,  27,   0,  /* "argo" 21464 */
      8,   4,  11,   8,  13,   0,  /* "argon" 21470 */
      8,   4,  11,   8,  13,   0,  /* "argonne" 21476 */
      8,   4,  11,   1,  14,  26,   0,  /* "argosy" 21483 */
      8,   4,  11,  41,  29,   1,   9,   1,   7,   0,  /* "arguable" 21493 */
      8,   4,  11,  41,  29,   1,   9,   7,  26,   0,  /* "arguably" 21503 */
      8,   4,  11,  41,  29,   0,  /* "argue" 21509 */
      8,   4,  11,  41,  29,  20,   0,  /* "argued" 21516 */
     19,   4,  11,   2,   7,  15,  14,   0,  /* "arguelles" 21524 */
     19,   4,  11,  21,   7,  27,   0,  /* "arguello" 21531 */
      8,   4,  11,  41,  29,  30,   0,  /* "argues" 21538 */
     19,   4,  11,   2,   3,   1,   0,  /* "argueta" 21545 */
     19,   4,  11,  47,  23,  41,  27,   0,  /* "arguijo" 21553 */
      8,   4,  11,  41,  29,  31,  32,   0,  /* "arguing" 21561 */
      8,   4,  11,  41,   1,  17,   1,  13,   3,   0,  /* "argument" 21571 */
      8,   4,  11,  41,   1,  17,  15,  13,   3,   2,  33,   1,  13,   0,  /* "argumentation" 21585 */
      8,   4,  11,  41,   1,  17,  21,  13,   3,   1,   3,  31,  22,   0,  /* "argumentative" 21599 */
      8,   4,  11,  41,   1,  17,   1,  13,   3,  14,   0,  /* "arguments" 21610 */
      8,   4,  11,  39,   7,   0,  /* "argyle" 21616 */
     19,   4,  11,  39,   7,   0,  /* "argyll" 21622 */
      8,   4,  40,  31,   4,   8,   6,  27,   7,   1,  14,   0,  /* "argyropoulos" 21634 */
      8,   4,  26,   0,  /* "ari" 21638 */
      8,   4,  26,   1,   0,  /* "aria" 21643 */
     21,   4,  26,  24,  20,  13,  26,   0,  /* "ariadne" 21651 */
     19,   4,  26,  24,  13,   1,   0,  /* "ariana" 21658 */
     21,   4,  26,  24,  13,   0,  /* "ariane" 21664 */
     21,   4,  26,  24,  13,  14,   6,   2,  14,   0,  /* "arianespace" 21674 */
     24,   4,  26,   1,  13,   5,  30,   1,  17,   0,  /* "arianism" 21684 */
     19,   4,  26,  24,  13,   1,   0,  /* "arianna" 21691 */
      8,   4,  26,   1,  30,   0,  /* "arias" 21697 */
     24,   4,  31,  12,   0,  /* "aric" 21702 */
     19,   4,  23,  12,  27,   0,  /* "arico" 21708 */
     24,   4,   1,  20,   0,  /* "arid" 21713 */
      1,   4,  23,  20,   1,   0,  /* "arida" 21719 */
     21,   4,  26,   0,  /* "arie" 21723 */
     21,   4,  26,   1,   7,   0,  /* "ariel" 21729 */
     19,   4,  26,  21,   7,   1,   0,  /* "ariella" 21736 */
      8,   4,  31,  32,   3,   1,  13,   0,  /* "arington" 21744 */
     19,   4,  26,  25,   7,   1,   0,  /* "ariola" 21751 */
     10,  23,  14,   0,  /* "aris" 21755 */
     10,  39,  30,   0,  /* "arise" 21759 */
     10,   5,  30,   1,  13,   0,  /* "arisen" 21765 */
     10,  39,  30,   1,  30,   0,  /* "arises" 21771 */
     10,  39,  30,  31,  32,   0,  /* "arising" 21777 */
     21,   4,   1,  14,   1,  13,   0,  /* "arison" 21784 */
     19,   4,  23,  14,   6,  26,   0,  /* "arispe" 21791 */
     10,   5,  14,   3,   1,   0,  /* "arista" 21797 */
     21,   4,   1,  14,   3,  21,  12,   0,  /* "aristech" 21805 */
      8,   4,   1,  14,   3,  23,  20,   0,  /* "aristede" 21813 */
      8,   4,   1,  14,   3,  23,  20,   0,  /* "aristide" 21821 */
     21,   4,   1,  14,   3,   8,  12,   4,   1,  14,  26,   0,  /* "aristocracy" 21833 */
     10,   5,  14,   3,   1,   3,  23,   7,  26,   1,  13,   0,  /* "aristotelian" 21845 */
     21,   4,   1,  14,   3,   8,   3,   1,   7,   0,  /* "aristotle" 21855 */
     19,   4,  23,  30,   1,   0,  /* "ariza" 21861 */
     19,   4,  26,  30,  17,  21,  13,  20,  26,   0,  /* "arizmendi" 21871 */
     21,   4,   1,  30,  25,  13,   1,   0,  /* "arizona" 21879 */
     10,   5,  30,  27,  13,   1,  13,   0,  /* "arizonan" 21887 */
     10,   5,  30,  27,  13,   1,  13,  30,   0,  /* "arizonans" 21896 */
      8,   4,  40,  27,   0,  /* "arjo" 21901 */
      8,   4,  12,   0,  /* "ark" 21905 */
      8,   4,  12,   1,  20,  26,   0,  /* "arkadi" 21912 */
      8,   4,  12,  24,  13,  30,   1,  13,   0,  /* "arkansan" 21921 */
      8,   4,  12,  24,  13,  30,   1,  13,  30,   0,  /* "arkansans" 21931 */
      8,   4,  12,   1,  13,  14,   8,   0,  /* "arkansas" 21939 */
      8,   4,  12,  27,   0,  /* "arko" 21944 */
     19,   4,  12,  25,  14,   0,  /* "arkose" 21950 */
      8,   4,  12,   4,  39,   3,   0,  /* "arkwright" 21957 */
     19,   4,   7,  24,  13,   1,   0,  /* "arlana" 21964 */
     19,   4,   7,  18,  14,  12,   1,  14,   0,  /* "arlauskas" 21973 */
      8,   4,   7,  31,  40,   0,  /* "arledge" 21979 */
     19,   4,   7,  23,  13,   0,  /* "arleen" 21985 */
      8,   4,   7,  15,  13,   1,   0,  /* "arlena" 21992 */
      8,   4,   7,  15,   3,   1,   0,  /* "arleta" 21999 */
      8,   4,   7,   5,  13,  20,   1,   0,  /* "arlinda" 22007 */
      8,   4,   7,  39,  13,   0,  /* "arline" 22013 */
      8,   4,   7,   3,   0,  /* "arlt" 22018 */
      8,   4,   7,  39,  13,   0,  /* "arlyne" 22024 */
      8,   4,  17,   0,  /* "arm" 22028 */
     19,   4,  17,   8,  20,   1,   0,  /* "armada" 22035 */
      8,   4,  17,   1,  11,  21,  20,   1,  13,   0,  /* "armageddon" 22045 */
     19,   4,  17,   8,  11,  27,  14,   3,   0,  /* "armagost" 22054 */
      8,   4,  17,   1,  13,  20,   0,  /* "armand" 22061 */
     19,   4,  17,   8,  13,  20,  27,   0,  /* "armando" 22069 */
      8,   4,  17,  34,  13,   3,   0,  /* "armandt" 22076 */
     19,   4,  17,   8,   3,  27,   0,  /* "armato" 22083 */
      8,   4,  17,   9,  10,   5,  14,   3,  10,   0,  /* "armbrister" 22093 */
      8,   4,  17,   9,   4,   1,  14,   3,   0,  /* "armbrust" 22102 */
      8,   4,  17,   9,   4,   1,  14,   3,  10,   0,  /* "armbruster" 22112 */
      8,   4,  17,  12,  25,   0,  /* "armco" 22118 */
      8,   4,  17,  20,   0,  /* "armed" 22123 */
     19,   4,  17,  21,   7,   0,  /* "armel" 22129 */
      8,   4,  17,  15,   7,  23,  13,  27,   0,  /* "armellino" 22138 */
      8,   4,  17,   1,  13,   0,  /* "armen" 22144 */
     19,   4,  17,  28,  13,  20,   8,   4,  15,  30,   0,  /* "armendarez" 22155 */
     19,   4,  17,  28,  13,  20,   8,   4,  26,  30,   0,  /* "armendariz" 22166 */
      8,   4,  17,   1,  13,   3,   0,  /* "arment" 22173 */
     19,   4,  17,   1,  13,   3,  18,   4,   0,  /* "armentor" 22182 */
      8,   4,  17,   1,  13,   3,   4,  48,   3,   0,  /* "armentrout" 22192 */
      8,   4,  17,  10,   0,  /* "armer" 22197 */
      8,   4,  17,  30,   0,  /* "armes" 22202 */
      8,   4,  17,   1,  14,   3,  21,  20,   0,  /* "armested" 22211 */
      8,   4,  17,  26,   0,  /* "armey" 22216 */
     19,   4,  17,  23,  20,   1,   0,  /* "armida" 22223 */
      8,   4,  17,   1,  11,  10,   0,  /* "armiger" 22230 */
     19,   4,  17,  23,  41,  27,   0,  /* "armijo" 22237 */
     19,   4,  17,   5,   7,   1,   0,  /* "armilla" 22244 */
      8,   4,  17,   1,  13,   0,  /* "armin" 22250 */
     19,   4,  17,  23,  13,   1,   0,  /* "armina" 22257 */
     19,   4,  17,  23,  13,  26,   0,  /* "armine" 22264 */
      8,   4,  17,   1,  13,  26,   0,  /* "arminie" 22271 */
      8,   4,  17,   1,  14,   3,  21,  20,   0,  /* "armistead" 22280 */
      8,   4,  17,   1,  14,   3,   1,  14,   0,  /* "armistice" 22289 */
      8,   4,  17,  10,  26,   0,  /* "armory" 22295 */
      8,   4,  17,  10,   0,  /* "armour" 22300 */
      8,   4,  17,  30,   0,  /* "arms" 22305 */
      8,   4,  17,  14,   3,   4,   8,  32,   0,  /* "armstrong" 22314 */
      8,   4,  17,  26,   0,  /* "army" 22319 */
      8,   4,  13,   0,  /* "arn" 22323 */
      8,   4,  13,   1,   7,   0,  /* "arnall" 22329 */
     19,   4,  13,  24,   3,   0,  /* "arnatt" 22335 */
     19,   4,  13,  25,   0,  /* "arnaud" 22340 */
      8,   4,  13,  25,   0,  /* "arnault" 22345 */
      8,   4,  13,  21,  30,   0,  /* "arnaz" 22351 */
      8,   4,  13,   0,  /* "arne" 22355 */
     19,   4,  13,  23,  30,   1,  13,   0,  /* "arnesen" 22363 */
     19,   4,  13,  21,   3,   0,  /* "arnett" 22369 */
     19,   4,  13,  21,   3,   0,  /* "arnette" 22375 */
      8,   4,  13,   0,  /* "arnn" 22379 */
      8,   4,  13,  27,   0,  /* "arno" 22384 */
      8,   4,  13,   1,   7,  20,   0,  /* "arnold" 22391 */
     19,   4,  13,  25,   7,  20,  26,   0,  /* "arnoldi" 22399 */
      8,   4,  13,  27,   7,  20,  26,   0,  /* "arnoldy" 22407 */
     19,   4,  13,   8,   7,  37,  26,   0,  /* "arnolphe" 22415 */
     19,   4,  13,  25,  13,  26,   0,  /* "arnone" 22422 */
      8,   4,  13,  19,   3,   0,  /* "arnott" 22428 */
      8,   4,  13,  19,   3,  14,   0,  /* "arnotts" 22435 */
      8,   4,  13,  19,  12,  14,   0,  /* "arnox" 22442 */
      8,   4,  13,  30,   0,  /* "arns" 22447 */
     19,   4,  13,  35,   7,  37,  27,   0,  /* "arnulfo" 22455 */
      8,   4,  13,  47,  39,  13,   0,  /* "arnwine" 22462 */
      8,   4,  27,   0,  /* "aro" 22466 */
     19,   4,  25,  12,   1,   0,  /* "arocha" 22472 */
     19,   4,  25,  12,  27,   0,  /* "arocho" 22478 */
     10,  25,  17,   1,   0,  /* "aroma" 22483 */
     10,  25,  17,   1,  30,   0,  /* "aromas" 22489 */
     21,   4,   1,  17,  24,   3,  31,  12,   0,  /* "aromatic" 22498 */
     21,   4,   1,  13,   0,  /* "aron" 22503 */
     10,  25,  13,   0,  /* "arone" 22507 */
     24,   4,   1,  13,  38,   1,   7,   3,   0,  /* "aronhalt" 22516 */
     21,   4,   1,  13,  36,  37,   0,  /* "aronoff" 22523 */
     10,  25,  13,  27,   0,  /* "aronow" 22528 */
     10,   8,  13,   1,  47,   5,   3,  14,   0,  /* "aronowitz" 22537 */
      8,   4,  27,  13,  30,   0,  /* "arons" 22543 */
     21,   4,   1,  13,  14,   1,  13,   0,  /* "aronson" 22551 */
     21,   4,   1,  13,  14,   3,  23,  13,   0,  /* "aronstein" 22560 */
     19,   4,  18,   4,   1,   0,  /* "arora" 22566 */
      8,   4,  27,  30,   0,  /* "aros" 22571 */
     10,  25,  30,   0,  /* "arose" 22575 */
     10,  48,  30,   1,   7,   0,  /* "arousal" 22581 */
     10,  48,  30,   0,  /* "arouse" 22585 */
     10,  48,  30,   1,  30,   0,  /* "arouses" 22591 */
     10,  48,  30,  31,  32,   0,  /* "arousing" 22597 */
      8,   4,   6,   0,  /* "arp" 22601 */
      8,   4,   6,   1,   0,  /* "arpa" 22606 */
      8,   4,   6,   5,  13,   0,  /* "arpin" 22612 */
      8,   4,   6,  14,   0,  /* "arps" 22617 */
      8,   4,  12,  47,   5,   7,   1,   0,  /* "arquilla" 22625 */
     10,   2,  13,  40,  10,   0,  /* "arranger" 22631 */
     10,   2,  13,  40,  31,  32,   0,  /* "arranging" 22638 */
     24,   4,   1,  13,   3,   0,  /* "arrant" 22644 */
     24,   4,   1,  13,   3,  14,   0,  /* "arrants" 22651 */
     21,   4,   1,  14,  17,   5,  16,   0,  /* "arrasmith" 22659 */
     10,  23,   4,  31,  40,   0,  /* "arrearage" 22665 */
     19,   4,  15,  20,  25,  13,  20,  27,   0,  /* "arredondo" 22674 */
     19,   4,  28,  11,  47,  23,  13,   0,  /* "arreguin" 22682 */
     19,   4,  15,  13,  20,  25,  13,  20,  27,   0,  /* "arrendondo" 22692 */
     19,   4,  26,   8,   7,   1,   0,  /* "arreola" 22699 */
      8,   4,  26,   8,  11,   1,   0,  /* "arriaga" 22706 */
     24,   4,  31,  12,   0,  /* "arrick" 22711 */
     19,   4,  23,   3,   1,   0,  /* "arrieta" 22717 */
      8,   4,  23,  11,  27,   0,  /* "arrigo" 22723 */
     19,   4,  26,  11,  25,  13,  26,   0,  /* "arrigoni" 22731 */
     21,   4,  31,  32,   3,   1,  13,   0,  /* "arrington" 22739 */
      8,   4,  26,  25,   7,   1,   0,  /* "arriola" 22746 */
      8,   4,  26,  36,   4,   3,  29,   1,   0,  /* "arriortua" 22755 */
     24,   4,   1,  14,   0,  /* "arris" 22760 */
     10,  39,  22,   1,   7,   0,  /* "arrival" 22766 */
     10,  39,  22,   1,   7,  30,   0,  /* "arrivals" 22773 */
     10,  39,  22,   0,  /* "arrive" 22777 */
     10,  39,  22,  20,   0,  /* "arrived" 22782 */
     10,  39,  22,  30,   0,  /* "arrives" 22787 */
     10,  39,  22,  31,  32,   0,  /* "arriving" 22793 */
     21,   4,   1,  11,   1,  13,  14,   0,  /* "arrogance" 22801 */
     21,   4,   1,  11,   1,  13,   3,   0,  /* "arrogant" 22809 */
     21,   4,   1,  11,   1,  13,   3,   7,  26,   0,  /* "arrogantly" 22819 */
     24,   4,  27,  11,   2,   3,   0,  /* "arrogate" 22826 */
     24,   4,  27,  38,  21,  20,   0,  /* "arrowhead" 22833 */
     24,   4,  27,  38,  21,  20,  30,   0,  /* "arrowheads" 22841 */
     24,   4,  27,   4,  29,   3,   0,  /* "arrowroot" 22848 */
     10,  49,  27,   0,  /* "arroyo" 22852 */
     19,   4,  29,  20,   1,   0,  /* "arruda" 22858 */
     24,   4,  29,   6,   0,  /* "arrupe" 22863 */
      8,   4,  30,  20,   2,   7,   0,  /* "arsdale" 22870 */
      8,   4,  14,   1,  13,  27,   0,  /* "arsenault" 22877 */
      8,   4,  14,   1,  13,  27,   0,  /* "arseneau" 22884 */
      8,   4,  14,   1,  13,  27,   0,  /* "arseneault" 22891 */
      8,   4,  14,   1,  13,  31,  12,   0,  /* "arsenic" 22899 */
      8,   4,  14,   1,  13,  39,  20,   0,  /* "arsenide" 22907 */
      8,   4,  14,  23,  13,  26,  27,   0,  /* "arsenio" 22915 */
      8,   4,  14,   7,   2,  13,  26,   1,  13,   0,  /* "arslanian" 22925 */
      8,   4,  14,   1,  13,   1,  14,   3,   0,  /* "arsonist" 22934 */
      8,   4,  14,   1,  13,   1,  14,   3,  14,   0,  /* "arsonists" 22944 */
      8,   4,   3,   0,  /* "art" 22948 */
     19,   4,   3,   8,   7,  26,   0,  /* "artale" 22955 */
      8,   4,   3,  23,  11,   1,   0,  /* "arteaga" 22962 */
      8,   4,   3,  10,   9,  44,  13,   0,  /* "arterburn" 22970 */
     19,   4,   3,   5,   4,  26,   1,   7,   0,  /* "arterial" 22979 */
     19,   4,   3,   5,   4,  26,  27,  14,  12,   7,  10,  25,  14,   1,  14,   0,  /* "arteriosclerosis" 22995 */
      8,   4,  16,   0,  /* "arth" 22999 */
     19,   4,  16,   4,   5,   3,  31,  12,   0,  /* "arthritic" 23008 */
     19,   4,  16,   4,  39,   3,   1,  14,   0,  /* "arthritis" 23017 */
     19,   4,  16,  45,   4,  26,   1,  13,   0,  /* "arthurian" 23026 */
      8,   4,  16,  10,  30,   0,  /* "arthurs" 23032 */
      8,   4,   3,  31,  42,  25,  12,  14,   0,  /* "artichokes" 23041 */
      8,   4,   3,   1,  12,   1,   7,   0,  /* "article" 23049 */
      8,   4,   3,   1,  12,   1,   7,  30,   0,  /* "articles" 23058 */
     19,   4,   3,   5,  12,  41,   1,   7,   1,   3,   0,  /* "articulate" 23069 */
     19,   4,   3,   5,  12,  41,   1,   7,   2,   3,   0,  /* "articulate" 23080 */
     19,   4,   3,   5,  12,  41,   1,   7,   2,   3,   0,  /* "articulate" 23091 */
     19,   4,   3,   5,  12,  41,   1,   7,   2,   3,   1,  20,   0,  /* "articulated" 23104 */
     19,   4,   3,   5,  12,  41,   1,   7,   1,   3,  14,   0,  /* "articulates" 23116 */
     19,   4,   3,   5,  12,  41,   1,   7,   2,   3,  31,  32,   0,  /* "articulating" 23129 */
      8,   4,   3,  31,  12,  41,   1,   7,   2,  33,   1,  13,   0,  /* "articulation" 23142 */
     19,   4,   3,   5,  12,  41,   1,   7,   1,   3,  18,   4,  26,   0,  /* "articulatory" 23156 */
     19,   4,   3,   5,   7,  10,  26,   0,  /* "artillery" 23164 */
     19,   4,   3,  23,  13,  27,   0,  /* "artino" 23171 */
     19,   4,   3,   5,  14,   3,  31,  12,   0,  /* "artistic" 23180 */
     19,   4,   3,   5,  14,   3,  31,  12,   7,  26,   0,  /* "artistically" 23191 */
      8,   4,   3,   1,  14,   3,   4,  26,   0,  /* "artistry" 23200 */
     19,   4,   3,  47,   8,   0,  /* "artois" 23206 */
      8,   4,   3,   8,  13,   0,  /* "arton" 23212 */
      8,   4,   3,  14,   0,  /* "arts" 23217 */
      8,   4,   3,  51,   4,   0,  /* "artur" 23223 */
     19,   4,   3,  45,   4,  27,   0,  /* "arturo" 23230 */
      8,   4,   3,  26,   0,  /* "arty" 23235 */
      8,   4,   3,  14,   0,  /* "artz" 23240 */
     10,  29,   9,   1,   0,  /* "aruba" 23245 */
     21,   4,   1,  17,   0,  /* "arum" 23250 */
     19,   4,  29,  13,   1,  42,   8,   7,   1,  17,   0,  /* "arunachalam" 23261 */
     21,   4,   1,  13,  20,   1,   7,   0,  /* "arundel" 23269 */
     10,  29,   6,   0,  /* "arup" 23273 */
      8,   4,  22,   1,   0,  /* "arva" 23278 */
     19,   4,  22,  24,  20,   0,  /* "arvad" 23284 */
     19,   4,  22,   1,  13,  39,   3,   5,  14,   0,  /* "arvanitis" 23294 */
      8,   4,  22,  28,   0,  /* "arvay" 23299 */
      8,   4,  22,   0,  /* "arve" 23303 */
     19,   4,  22,  21,   7,   0,  /* "arvel" 23309 */
      8,   4,  22,  26,   0,  /* "arvey" 23314 */
     19,   4,  22,  23,  20,   1,   0,  /* "arvida" 23321 */
      8,   4,  22,   5,  13,  20,   0,  /* "arvind" 23328 */
     19,   4,  22,  23,  30,  29,   0,  /* "arvizu" 23335 */
      8,   4,  12,  14,   0,  /* "arx" 23340 */
     21,   4,  26,   0,  /* "ary" 23344 */
      8,   4,  26,   1,  13,   0,  /* "aryan" 23350 */
     19,   4,  30,   8,  17,   1,   0,  /* "arzama" 23357 */
     19,   4,  30,   8,  17,   1,  30,   0,  /* "arzamas" 23365 */
     19,   4,  30,  25,   7,   1,   0,  /* "arzola" 23372 */
      8,   4,  30,   3,   0,  /* "arzt" 23377 */
     24,  30,   0,  /* "as" 23380 */
      8,  14,   1,   0,  /* "asa" 23384 */
     19,  14,   8,  37,   0,  /* "asaf" 23389 */
     24,  14,   1,  38,  34,  13,   0,  /* "asahan" 23396 */
     34,  14,   1,  38,  24,   4,   1,   0,  /* "asahara" 23404 */
      1,  14,   8,  38,  26,   0,  /* "asahi" 23410 */
     24,  14,   1,  17,  21,   4,   1,   0,  /* "asamera" 23418 */
      1,  14,   8,   4,  12,  27,   0,  /* "asarco" 23425 */
     19,  14,   8,   4,  27,   0,  /* "asaro" 23431 */
     24,  30,  34,   3,   0,  /* "asat" 23436 */
     19,  14,   8,   3,  27,   0,  /* "asato" 23442 */
      1,  14,   2,   0,  /* "asay" 23446 */
     24,  14,   9,  15,   4,  26,   0,  /* "asberry" 23453 */
     34,  14,   9,  21,  14,   3,   1,  14,   0,  /* "asbestos" 23462 */
     24,  14,   9,  21,  14,   3,  25,  14,   5,  14,   0,  /* "asbestosis" 23473 */
      1,  14,   9,   4,   5,  40,   0,  /* "asbridge" 23480 */
     24,  30,   9,  21,   4,  26,   0,  /* "asbury" 23487 */
     24,  14,   9,  26,   0,  /* "asby" 23492 */
     19,  14,  42,  21,  13,  42,  26,  27,   0,  /* "ascencio" 23501 */
      1,  14,  21,  13,   3,   0,  /* "ascent" 23507 */
     24,  14,  10,   3,   2,  13,   0,  /* "ascertain" 23514 */
     24,  14,  10,   3,   2,  13,  20,   0,  /* "ascertained" 23522 */
     24,  14,  10,   3,   2,  13,  31,  32,   0,  /* "ascertaining" 23531 */
     24,  33,   0,  /* "asch" 23534 */
     24,  33,   1,  13,   9,   4,   5,  13,  10,   0,  /* "aschenbrenner" 23544 */
     24,  14,  12,  38,  36,  37,   0,  /* "aschoff" 23551 */
     24,  14,  12,  26,   0,  /* "ascii" 23556 */
     24,  14,  12,   7,  34,  20,   0,  /* "asclad" 23563 */
     24,  14,  12,   8,   3,   0,  /* "ascot" 23569 */
      1,  14,  12,   4,  39,   9,   0,  /* "ascribe" 23576 */
      1,  14,  12,   4,  39,   9,  20,   0,  /* "ascribed" 23584 */
      1,  14,  12,   4,  39,   9,  30,   0,  /* "ascribes" 23592 */
     24,  14,  20,   1,   0,  /* "asda" 23597 */
      1,  30,  23,   1,   0,  /* "asea" 23602 */
      1,  30,  23,   1,  13,   0,  /* "asean" 23608 */
      1,  14,  21,   7,  17,   1,   0,  /* "aselma" 23615 */
     19,  14,  15,   7,   3,  23,  13,  26,   0,  /* "aseltine" 23624 */
      1,  14,  21,   4,   1,   3,   5,  14,   0,  /* "aseritis" 23633 */
     24,  33,   0,  /* "ash" 23636 */
      1,  33,   2,  17,   0,  /* "ashame" 23641 */
      1,  33,   2,  17,  20,   0,  /* "ashamed" 23647 */
     24,  33,   9,  10,  13,   0,  /* "ashburn" 23653 */
     24,  33,   9,  15,   4,  26,   0,  /* "ashbury" 23660 */
     24,  33,   0,  /* "ashe" 23663 */
     24,  33,   1,  13,  37,  21,   7,   3,  10,   0,  /* "ashenfelter" 23673 */
      1,  33,  23,  30,   0,  /* "ashis" 23678 */
      1,  33,  23,  33,   0,  /* "ashish" 23683 */
     24,  33,   7,   1,  13,  20,   0,  /* "ashland" 23690 */
     24,  33,   7,  39,  13,   0,  /* "ashline" 23696 */
     24,  33,  19,  12,   0,  /* "ashok" 23701 */
      1,  33,  18,   4,   0,  /* "ashore" 23706 */
     34,  33,   4,   8,  47,  26,   0,  /* "ashrawi" 23713 */
     24,  33,   3,  15,  12,   0,  /* "ashtec" 23719 */
     24,  33,  10,   0,  /* "ashur" 23723 */
     24,  33,  26,   0,  /* "ashy" 23727 */
      2,  43,   1,   0,  /* "asia" 23731 */
      2,  30,  26,   2,  13,   0,  /* "asiain" 23737 */
      2,  43,  26,  24,   3,  31,  12,   0,  /* "asiatic" 23745 */
      2,  43,   1,  47,  23,  12,   0,  /* "asiaweek" 23752 */
     24,  30,  31,  12,   0,  /* "asic" 23757 */
     24,  30,  31,  12,  14,   0,  /* "asics" 23763 */
      1,  14,  39,  20,   0,  /* "aside" 23768 */
      1,  14,  39,  20,  30,   0,  /* "asides" 23774 */
     24,  30,  26,   1,   7,   0,  /* "asiel" 23780 */
     24,  14,   1,  13,  39,  13,   0,  /* "asinine" 23787 */
     24,  14,  12,   0,  /* "ask" 23791 */
     24,  14,  12,   1,   0,  /* "aska" 23796 */
      1,  14,  12,  24,  13,  14,   0,  /* "askance" 23803 */
      1,  14,  12,  41,  29,   0,  /* "askew" 23809 */
      1,  14,  12,  23,   0,  /* "askey" 23814 */
     24,  14,  12,  31,  32,   0,  /* "asking" 23820 */
     24,  14,  12,  31,  32,   3,   1,  13,   0,  /* "askington" 23829 */
     24,  14,  12,  27,   0,  /* "asko" 23834 */
     24,  14,  12,  10,   1,  13,   0,  /* "askren" 23841 */
     24,  14,  12,  14,   0,  /* "asks" 23846 */
      1,  14,   7,   2,  13,  26,   1,  13,   0,  /* "aslanian" 23855 */
     24,  14,   7,   1,  14,   1,  13,   0,  /* "asleson" 23863 */
     24,  14,  17,   1,  13,   0,  /* "asman" 23869 */
     24,  30,  17,   8,   4,   1,   0,  /* "asmara" 23876 */
     24,  30,  17,   8,   4,   1,  30,   0,  /* "asmaras" 23884 */
      1,  30,  17,  29,  14,   0,  /* "asmus" 23890 */
     24,  14,   6,   0,  /* "asp" 23894 */
      1,  14,   6,  21,   4,   1,  11,   1,  14,   0,  /* "asparagus" 23904 */
     24,  14,   6,  10,   3,   2,  17,   0,  /* "aspartame" 23912 */
      1,  14,   6,  44,  43,   1,  13,   0,  /* "aspersion" 23920 */
      1,  14,   6,  44,  43,   1,  13,  30,   0,  /* "aspersions" 23929 */
     24,  14,   6,   1,  13,  36,   7,   0,  /* "aspinall" 23937 */
     24,  14,   6,   1,  13,  47,  36,   7,   0,  /* "aspinwall" 23946 */
     24,  14,   6,  10,   1,  13,   3,   0,  /* "aspirant" 23954 */
     24,  14,   6,  10,   1,  13,   3,  14,   0,  /* "aspirants" 23963 */
     24,  14,   6,  10,   1,   3,   0,  /* "aspirate" 23970 */
     24,  14,   6,  10,   2,   3,   0,  /* "aspirate" 23977 */
     24,  14,   6,   1,   4,   2,   3,   1,  20,   0,  /* "aspirated" 23987 */
     24,  14,   6,   1,   4,   2,   3,  14,   0,  /* "aspirates" 23996 */
      1,  14,   6,  39,   4,   0,  /* "aspire" 24002 */
      1,  14,   6,  39,   4,  20,   0,  /* "aspired" 24009 */
      1,  14,   6,  39,  10,  30,   0,  /* "aspires" 24016 */
     24,  14,   6,   4,   1,  13,   0,  /* "aspirin" 24023 */
      1,  14,   6,  39,   4,  31,  32,   0,  /* "aspiring" 24031 */
     24,  14,   6,  13,  15,  30,   0,  /* "aspnes" 24038 */
     24,  14,  12,  47,   5,  16,   0,  /* "asquith" 24045 */
     24,  14,   0,  /* "ass" 24048 */
     19,  14,   8,  13,   3,  26,   0,  /* "assante" 24055 */
      1,  14,  24,  14,   1,  13,   0,  /* "assassin" 24062 */
      1,  14,  24,  14,   1,  13,  30,   0,  /* "assassins" 24070 */
      1,  14,  18,   7,   3,   0,  /* "assault" 24076 */
     24,  14,  26,   0,  /* "assay" 24080 */
     34,  14,   2,  10,   0,  /* "assayer" 24085 */
     24,  14,   3,   0,  /* "assed" 24089 */
     24,  14,   1,   7,   1,  13,   0,  /* "asselin" 24096 */
     24,  14,   1,   7,  14,   3,  39,  13,   0,  /* "asselstine" 24105 */
      1,  14,  21,  17,   9,   7,   1,  40,   0,  /* "assemblage" 24114 */
      1,  14,  21,  17,   9,   1,   7,   0,  /* "assemble" 24122 */
      1,  14,  21,  17,   9,   1,   7,  20,   0,  /* "assembled" 24131 */
      1,  14,  21,  17,   9,   1,   7,  30,   0,  /* "assembles" 24140 */
      1,  14,  21,  17,   9,   7,  26,  30,   0,  /* "assemblies" 24149 */
      1,  14,  21,  17,   9,   1,   7,  31,  32,   0,  /* "assembling" 24159 */
      1,  14,  21,  17,   9,   7,  26,  17,  24,  13,   0,  /* "assemblyman" 24170 */
      1,  14,  21,  17,   9,   7,  26,  17,  15,  13,   0,  /* "assemblymen" 24181 */
      1,  14,  21,  17,   9,   7,  26,  47,  45,  17,   1,  13,   0,  /* "assemblywoman" 24194 */
      1,  14,  21,  13,   3,   0,  /* "assent" 24200 */
      1,  14,  44,   3,   0,  /* "assert" 24205 */
     24,  14,   1,  30,   0,  /* "asses" 24210 */
      1,  14,  21,  14,  10,   0,  /* "assessor" 24216 */
      1,  14,  21,  14,  10,  30,   0,  /* "assessors" 24223 */
     24,  14,  21,   3,   0,  /* "asset" 24228 */
     24,  14,  21,   3,  14,   0,  /* "assets" 24234 */
      1,  14,  23,  12,  10,  24,  30,  26,  25,  13,  26,   0,  /* "assicurazioni" 24246 */
      1,  14,   5,  20,  47,   1,  14,   0,  /* "assiduous" 24254 */
      1,  14,   5,  20,  47,   1,  14,   7,  26,   0,  /* "assiduously" 24264 */
      1,  14,  39,  13,   0,  /* "assign" 24269 */
      1,  14,  39,  13,  20,   0,  /* "assigned" 24275 */
      1,  14,  39,  13,  31,  32,   0,  /* "assigning" 24282 */
      1,  14,  39,  13,  17,   1,  13,   3,   0,  /* "assignment" 24291 */
      1,  14,  39,  13,  17,   1,  13,   3,  14,   0,  /* "assignments" 24301 */
      1,  14,  39,  13,  30,   0,  /* "assigns" 24307 */
      1,  14,   5,  17,   1,   7,   2,   3,   0,  /* "assimilate" 24316 */
     24,  14,   1,  12,   2,  33,   1,  13,   0,  /* "assocation" 24325 */
      1,  14,  25,  14,  26,  31,   3,   0,  /* "associate" 24333 */
      1,  14,  25,  14,  26,   2,   3,   0,  /* "associate" 24341 */
      1,  14,  25,  14,  26,  31,   3,  14,   0,  /* "associates" 24350 */
      1,  14,  25,  14,  26,   2,   3,  14,   0,  /* "associates" 24359 */
     24,  14,   1,  14,  26,  30,   0,  /* "associes" 24366 */
     24,  14,   1,   9,  21,   7,   0,  /* "assubel" 24373 */
      1,  14,  29,  17,   0,  /* "assume" 24378 */
      1,  14,  29,  17,  20,   0,  /* "assumed" 24384 */
      1,  14,  29,  17,  30,   0,  /* "assumes" 24390 */
      1,  14,  29,  17,  31,  32,   0,  /* "assuming" 24397 */
      1,  33,  45,   4,   1,  14,   0,  /* "assuras" 24404 */
      1,  33,  45,   4,   0,  /* "assure" 24409 */
      1,  33,  45,   4,  30,   0,  /* "assures" 24415 */
      1,  14,   5,   4,  26,   1,   0,  /* "assyria" 24422 */
      1,  14,   5,   4,  26,   1,  13,   0,  /* "assyrian" 24430 */
      1,  14,   5,   4,  26,   1,  13,  30,   0,  /* "assyrians" 24439 */
     24,  14,   3,   0,  /* "ast" 24443 */
      8,  14,   3,   1,   0,  /* "asta" 24448 */
      1,  14,   3,  21,   4,   0,  /* "astaire" 24454 */
     24,  14,   3,  10,   5,  14,  12,   0,  /* "asterisk" 24462 */
     24,  30,  17,   1,   0,  /* "asthma" 24467 */
     34,  30,  17,  24,   3,  31,  12,   0,  /* "asthmatic" 24475 */
     15,  14,  16,  17,  21,   3,  31,  12,  14,   0,  /* "asthmatics" 24485 */
      1,  14,   3,   5,  11,  17,   1,   3,   5,  30,   1,  17,   0,  /* "astigmatism" 24498 */
     24,  14,   1,   7,   0,  /* "astle" 24503 */
     24,  14,   3,   7,  26,   0,  /* "astley" 24509 */
     24,  14,   3,   1,  13,   0,  /* "aston" 24515 */
      1,  14,   3,   8,  13,  31,  33,  31,  32,   7,  26,   0,  /* "astonishingly" 24527 */
     24,  14,   3,  10,   0,  /* "astor" 24532 */
     19,  14,   3,  18,   4,  11,   1,   0,  /* "astorga" 24540 */
     24,  14,   3,  18,   4,  26,   1,   0,  /* "astoria" 24548 */
     19,  14,   3,  36,   4,  23,  13,  27,   0,  /* "astorino" 24557 */
      1,  14,   3,   4,  24,  20,   1,   7,   0,  /* "astraddle" 24566 */
     24,  14,   3,   4,   1,  12,  19,  13,   0,  /* "astrakhan" 24575 */
      1,  14,   3,   4,   2,   0,  /* "astray" 24581 */
     24,  14,   3,  10,  20,   0,  /* "astred" 24587 */
      1,  14,   3,   4,  39,  20,   0,  /* "astride" 24594 */
      1,  14,   3,   4,   5,  13,  40,   1,  13,   3,   0,  /* "astringent" 24605 */
      1,  14,   3,   4,   5,  13,  40,   1,  13,   3,  14,   0,  /* "astringents" 24617 */
     24,  14,   3,   4,   1,  20,  25,  17,   0,  /* "astrodome" 24626 */
     24,  14,   3,   4,   1,  40,  23,   8,   7,   1,  40,  26,   0,  /* "astrogeology" 24639 */
      1,  14,   3,   4,   8,   7,   1,  40,  10,   0,  /* "astrologer" 24649 */
      1,  14,   3,   4,   8,   7,   1,  40,  10,  30,   0,  /* "astrologers" 24660 */
     24,  14,   3,   4,   1,   7,   8,  40,  31,  12,   1,   7,   0,  /* "astrological" 24673 */
      1,  14,   3,   4,   8,   7,   1,  40,  26,   0,  /* "astrology" 24683 */
     24,  14,   3,   4,   1,  13,   8,   3,   0,  /* "astronaut" 24692 */
     24,  14,   3,   4,   1,  13,  18,   3,  14,   0,  /* "astronauts" 24702 */
      1,  14,   3,   4,   8,  13,   1,  17,  10,   0,  /* "astronomer" 24712 */
      1,  14,   3,   4,   8,  13,   1,  17,  10,  30,   0,  /* "astronomers" 24723 */
     24,  14,   3,   4,   1,  13,   8,  17,  31,  12,   1,   7,   0,  /* "astronomical" 24736 */
     24,  14,   3,   4,   1,  13,   8,  17,  31,  12,   7,  26,   0,  /* "astronomically" 24749 */
      1,  14,   3,   4,   8,  13,   1,  17,  26,   0,  /* "astronomy" 24759 */
     24,  14,   3,   4,  27,  37,   1,   3,   8,  11,   4,   1,  37,  26,   0,  /* "astrophotography" 24774 */
     24,  14,   3,   4,  27,  37,   5,  30,   1,  14,   5,  14,   3,   0,  /* "astrophysicist" 24788 */
     24,  14,   3,   4,  27,  37,   5,  30,  31,  12,  14,   0,  /* "astrophysics" 24800 */
     24,  14,   3,   4,  27,  14,   0,  /* "astros" 24807 */
     24,  14,   3,   4,  27,   3,  21,  12,   0,  /* "astrotech" 24816 */
      1,  14,   3,  29,   3,   0,  /* "astute" 24822 */
      1,  14,   3,  29,   3,   7,  26,   0,  /* "astutely" 24830 */
      1,  14,   3,  29,   3,  13,   1,  14,   0,  /* "astuteness" 24839 */
      1,  14,  35,  13,  33,   1,  13,   0,  /* "asuncion" 24847 */
      1,  14,  39,   7,   1,  17,   0,  /* "asylum" 24854 */
      2,  14,   1,  17,  21,   3,   4,  31,  12,   1,   7,   0,  /* "asymmetrical" 24866 */
      2,  14,   5,  17,   1,   3,   4,  26,  30,   0,  /* "asymmetries" 24876 */
     24,  14,   1,  17,   3,  25,   3,   0,  /* "asymptote" 24884 */
     24,  14,   1,  17,   3,  25,   3,  14,   0,  /* "asymptotes" 24893 */
     24,   3,   0,  /* "at" 24896 */
      8,   3,   1,   0,  /* "ata" 24900 */
     24,   3,   1,   7,  24,  13,   3,   1,   0,  /* "atalanta" 24909 */
     19,   3,  19,   7,   2,   1,   0,  /* "atalaya" 24916 */
     24,   3,   1,   7,  26,   0,  /* "atalie" 24922 */
      1,   3,   8,   4,  26,   0,  /* "atari" 24928 */
     24,   3,   1,  22,   5,  30,   1,  17,   0,  /* "atavism" 24937 */
     24,   3,   1,  22,   5,  14,   3,  31,  12,   0,  /* "atavistic" 24947 */
      2,   3,  24,  12,  14,  26,   1,   0,  /* "ataxia" 24955 */
     24,   3,  12,  27,   0,  /* "atco" 24960 */
     24,   3,  12,  36,   4,   0,  /* "atcor" 24966 */
      2,   3,   0,  /* "ate" 24969 */
      2,   3,  21,  12,   0,  /* "atek" 24974 */
      2,   3,   1,  13,   0,  /* "aten" 24979 */
      2,   3,  10,   0,  /* "ater" 24983 */
      2,   3,  14,   0,  /* "ates" 24987 */
     24,  16,   1,   0,  /* "atha" 24991 */
     28,  16,  24,   7,  26,   1,   0,  /* "athalia" 24998 */
     28,  16,  24,  13,   1,  30,   0,  /* "athanas" 25005 */
      8,  16,   1,  13,   1,  14,  23,  29,   0,  /* "athanassiou" 25014 */
      2,  46,   1,  30,   0,  /* "athas" 25019 */
      2,  16,  10,  13,   0,  /* "athearn" 25024 */
      2,  16,  26,   5,  30,   1,  17,   0,  /* "atheism" 25032 */
      2,  16,  26,   1,  14,   3,   0,  /* "atheist" 25039 */
      2,  16,  26,   5,  14,   3,  31,  12,   0,  /* "atheistic" 25048 */
      2,  16,  26,   1,  14,   3,  14,   0,  /* "atheists" 25056 */
      1,  16,  23,  13,   1,   0,  /* "athena" 25062 */
     24,  16,   1,  13,  39,  27,  14,   0,  /* "athenaios" 25070 */
     24,  16,   1,  13,  29,  17,   0,  /* "atheneum" 25077 */
      1,  16,  23,  13,  26,   1,  13,   0,  /* "athenian" 25085 */
      1,  16,  23,  13,  26,   1,  13,  30,   0,  /* "athenians" 25094 */
     24,  16,  10,  27,  14,  12,   7,  10,  25,  14,   1,  14,   0,  /* "atherosclerosis" 25107 */
     24,  16,  10,   3,   1,  13,   0,  /* "atherton" 25114 */
     24,  16,  26,   0,  /* "athey" 25118 */
      2,  16,  26,   0,  /* "athie" 25122 */
     24,  16,   7,  23,   3,   0,  /* "athlete" 25128 */
     24,  16,   7,  23,   3,  14,   0,  /* "athletes" 25135 */
     34,  16,   7,  21,   3,   1,  12,   7,  26,   0,  /* "athletically" 25145 */
     34,  16,   7,  21,   3,   1,  14,   5,  30,  17,   0,  /* "athleticism" 25156 */
      1,  16,  47,  18,   4,   3,   0,  /* "athwart" 25163 */
     24,   3,  31,  12,  25,   0,  /* "atico" 25169 */
     19,   3,  23,  13,  30,   1,   0,  /* "atienza" 25176 */
     19,   3,  26,   7,   8,  13,  27,   0,  /* "atilano" 25184 */
      1,   3,  12,   5,  13,   0,  /* "atkin" 25190 */
     24,   3,   7,   1,   0,  /* "atla" 25195 */
     34,   3,   7,  24,  13,   3,   1,   0,  /* "atlanta" 25203 */
      1,   3,   7,  24,  13,   3,  31,  12,   0,  /* "atlantic" 25212 */
     34,   3,   7,  24,  13,   3,   1,  14,   0,  /* "atlantis" 25221 */
     34,   3,   7,   2,  14,   1,  30,   0,  /* "atlases" 25229 */
     24,   3,  13,   1,   6,   0,  /* "atnip" 25235 */
      1,   3,   8,  42,   1,   0,  /* "atocha" 25241 */
     24,   3,  19,   7,   0,  /* "atoll" 25246 */
     24,   3,   1,  17,   0,  /* "atom" 25251 */
      1,   3,   8,  17,  31,  12,   0,  /* "atomic" 25258 */
     24,   3,   1,  17,  39,  30,  10,   0,  /* "atomizer" 25266 */
     24,   3,   1,  17,  30,   0,  /* "atoms" 25272 */
      1,   3,   8,  13,   0,  /* "aton" 25277 */
     28,   3,  25,  13,   1,   7,   0,  /* "atonal" 25284 */
      1,   3,   8,   6,   0,  /* "atop" 25289 */
     21,   3,  10,   0,  /* "ator" 25293 */
     24,   3,  10,  23,  13,  27,   0,  /* "atorino" 25300 */
      2,   3,  23,   6,  23,   0,  /* "atp" 25306 */
      2,   3,   4,   1,   0,  /* "atra" 25311 */
      2,   3,   4,  26,   1,   0,  /* "atria" 25317 */
      2,   3,   4,  26,   1,  17,   0,  /* "atrium" 25324 */
      1,   3,   4,  25,  33,   1,  14,   0,  /* "atrocious" 25332 */
      1,   3,   4,   8,  14,   1,   3,  26,  30,   0,  /* "atrocities" 25342 */
      1,   3,   4,   8,  14,   1,   3,  26,   0,  /* "atrocity" 25351 */
     24,   3,   4,   1,  37,  26,  20,   0,  /* "atrophied" 25359 */
     19,  14,  14,  29,  33,  26,   0,  /* "atsushi" 25366 */
     24,   3,   1,   0,  /* "atta" 25370 */
     24,   3,   1,   9,  49,   0,  /* "attaboy" 25376 */
     24,   3,   1,   9,  49,  30,   0,  /* "attaboys" 25383 */
     24,   3,   1,  33,   2,   0,  /* "attache" 25389 */
      1,   3,  24,  42,  31,  32,   0,  /* "attaching" 25396 */
      1,   3,   2,  13,   1,   9,   1,   7,   0,  /* "attainable" 25405 */
     19,   3,  19,  13,   8,  14,  26,  27,   0,  /* "attanasio" 25414 */
     24,   3,  10,   0,  /* "attar" 25418 */
     24,   3,  10,  20,   0,  /* "attard" 25423 */
     19,   3,   8,   4,  20,  27,   0,  /* "attardo" 25430 */
     24,   3,   1,  47,  28,   0,  /* "attaway" 25436 */
     24,   3,   9,  15,   4,  26,   0,  /* "atteberry" 25443 */
      1,   3,  21,   9,  10,  26,   0,  /* "attebery" 25450 */
     24,   3,   9,  15,   4,  26,   0,  /* "attebury" 25457 */
     24,   3,  35,  13,   9,  10,  27,   0,  /* "attenborough" 25465 */
      1,   3,  21,  13,  41,  29,   2,   3,   0,  /* "attenuate" 25474 */
      1,   3,  21,  13,  41,  29,   2,   3,   1,  20,   0,  /* "attenuated" 25485 */
      1,   3,  21,  13,  41,  29,   2,   3,  14,   0,  /* "attenuates" 25495 */
     24,   3,  10,   9,  15,   4,  26,   0,  /* "atterberry" 25503 */
     24,   3,  10,   9,  21,   4,  26,   0,  /* "atterbury" 25511 */
     24,   3,  10,  17,   1,  13,   0,  /* "attermann" 25518 */
      1,   3,  21,  14,   3,   0,  /* "attest" 25524 */
     24,   3,  31,  12,  14,   0,  /* "attics" 25530 */
      1,   3,   5,   7,   1,   0,  /* "attila" 25536 */
      1,   3,  39,  10,   0,  /* "attire" 25541 */
      1,   3,  39,   4,  20,   0,  /* "attired" 25547 */
     24,   3,   1,   3,  29,  20,   0,  /* "attitude" 25554 */
     24,   3,   1,   3,  29,  20,  30,   0,  /* "attitudes" 25562 */
     24,   3,   1,   3,  29,  20,   1,  13,   1,   7,   0,  /* "attitudinal" 25573 */
     24,   3,  12,   1,  14,   1,  13,   0,  /* "attkisson" 25581 */
     24,   3,   1,   7,   9,  10,  27,   0,  /* "attleboro" 25589 */
     24,   3,   7,  26,   0,  /* "attlee" 25594 */
      1,   3,  44,  13,  26,   0,  /* "attorney" 25600 */
      1,   3,  44,  13,  26,  30,   0,  /* "attorneys" 25607 */
      1,   3,   4,   5,   9,  41,   1,   3,   1,   9,   1,   7,   0,  /* "attributable" 25620 */
     24,   3,   4,   1,   9,  41,  29,   3,   0,  /* "attribute" 25629 */
      1,   3,   4,   5,   9,  41,  29,   3,   0,  /* "attribute" 25638 */
      1,   3,   4,   5,   9,  41,   1,   3,   1,  20,   0,  /* "attributed" 25649 */
     24,   3,   4,   1,   9,  41,  29,   3,  14,   0,  /* "attributes" 25659 */
      1,   3,   4,   5,   9,  41,  29,   3,  14,   0,  /* "attributes" 25669 */
      1,   3,   4,   5,   9,  41,   1,   3,  31,  32,   0,  /* "attributing" 25680 */
     24,   3,   4,   1,   9,  41,  29,  33,   1,  13,   0,  /* "attribution" 25691 */
      1,   3,  29,  13,   0,  /* "attune" 25696 */
      1,   3,  29,  13,  20,   0,  /* "attuned" 25702 */
     24,   3,  47,  45,  20,   0,  /* "attwood" 25708 */
     24,   3,  47,  45,  20,  30,   0,  /* "attwoods" 25715 */
     24,   3,  47,  36,   3,  10,   0,  /* "atwater" 25722 */
      1,   3,  47,  21,   7,   0,  /* "atwell" 25728 */
     24,   3,  47,  10,  16,   0,  /* "atworth" 25734 */
      2,   3,  23,  21,  12,  14,   0,  /* "atx" 25741 */
     28,   3,   5,   6,  31,  12,   1,   7,   0,  /* "atypical" 25750 */
     24,   3,  14,   0,  /* "atz" 25754 */
     25,   0,  /* "au" 25756 */
     18,   9,   0,  /* "aube" 25759 */
     48,   9,   1,   7,   0,  /* "aubel" 25764 */
     18,   9,   1,   7,   0,  /* "auble" 25769 */
     25,   9,   1,  33,  19,  13,   0,  /* "aubuchon" 25776 */
      8,   9,  10,  13,   0,  /* "auburn" 25781 */
     18,  42,   0,  /* "auch" 25784 */
     48,  12,   3,  10,   0,  /* "auchter" 25789 */
      8,  12,   7,   1,  13,  20,   0,  /* "auckland" 25796 */
     27,  12,   7,  21,   4,   0,  /* "auclair" 25802 */
     27,  12,  49,  13,   0,  /* "aucoin" 25807 */
     18,  12,  33,   1,  13,  20,   0,  /* "auctioned" 25814 */
     18,  12,  33,   1,  13,   5,   4,  31,  32,   0,  /* "auctioneering" 25824 */
     18,  12,  33,   1,  13,   5,   4,  30,   0,  /* "auctioneers" 25833 */
     18,  12,  33,   1,  13,  31,  32,   0,  /* "auctioning" 25841 */
     18,  20,   0,  /* "aud" 25844 */
     19,  20,   2,  33,   1,  14,   0,  /* "audacious" 25851 */
     19,  20,  24,  14,   1,   3,  26,   0,  /* "audacity" 25859 */
     27,  20,   8,  30,   0,  /* "audas" 25864 */
     27,  20,  21,   3,   0,  /* "audet" 25869 */
     27,  20,  21,   3,   0,  /* "audette" 25874 */
     18,  20,  26,   0,  /* "audi" 25878 */
      8,  20,   1,   9,   1,   7,   0,  /* "audible" 25885 */
      8,  20,   1,   9,   7,  26,   0,  /* "audibly" 25892 */
      8,  20,  26,   1,  13,  14,   0,  /* "audience" 25899 */
      8,  20,  26,   1,  13,  14,   1,  30,   0,  /* "audiences" 25908 */
      8,  20,  26,  25,   0,  /* "audio" 25913 */
     18,  20,  23,  27,  37,  23,   7,   0,  /* "audiophile" 25921 */
     18,  20,  23,  27,  37,  23,   7,  30,   0,  /* "audiophiles" 25930 */
     18,  20,  26,  27,   3,   2,   6,   0,  /* "audiotape" 25938 */
     18,  20,  26,  27,   3,   2,   6,  14,   0,  /* "audiotapes" 25947 */
     18,  20,  26,  27,   3,  21,  12,  14,   0,  /* "audiotex" 25956 */
     18,  20,  26,  27,  22,   5,  43,  29,   1,   7,   0,  /* "audiovisual" 25967 */
     18,  20,  26,  27,  22,   8,  12,  14,   0,  /* "audiovox" 25976 */
     18,  20,   1,   3,   0,  /* "audit" 25981 */
     18,  20,   1,   3,   1,  20,   0,  /* "audited" 25988 */
      8,  20,   1,   3,  31,  32,   0,  /* "auditing" 25995 */
     19,  20,   5,  33,   1,  13,   0,  /* "audition" 26002 */
     19,  20,   5,  33,   1,  13,  31,  32,   0,  /* "auditioning" 26011 */
      8,  20,   1,   3,  10,  30,   0,  /* "auditors" 26018 */
      8,  20,   1,   3,  14,   0,  /* "audits" 26024 */
     18,  20,  10,  26,   0,  /* "audrie" 26029 */
     27,  20,   4,  23,  14,   0,  /* "audris" 26035 */
     18,  20,   1,   9,  19,  13,   0,  /* "audubon" 26042 */
     48,   0,  /* "aue" 26044 */
     48,   1,   7,   0,  /* "auel" 26048 */
     48,   1,  13,   0,  /* "auen" 26052 */
     48,  10,   0,  /* "auer" 26055 */
     48,  10,   9,  19,  12,   0,  /* "auerbach" 26061 */
     48,   4,   9,  24,  12,   0,  /* "auerback" 26067 */
     48,  37,  20,  10,  38,  39,  20,   0,  /* "aufderheide" 26075 */
     27,  37,   5,   4,  27,   0,  /* "aufiero" 26081 */
     18,  11,   1,  14,   3,   0,  /* "aug" 26087 */
     18,  40,   0,  /* "auge" 26090 */
     36,  40,  21,   7,  27,   0,  /* "augello" 26096 */
     48,  11,   1,  13,  14,   3,  39,  13,   0,  /* "augenstein" 26105 */
     36,  21,  13,   9,  36,   0,  /* "aughenbaugh" 26111 */
     36,  11,  17,  21,  13,   3,   0,  /* "augment" 26118 */
     19,  11,  17,  21,  13,   3,   1,   9,   1,   7,   0,  /* "augmentable" 26129 */
      8,  11,  17,  15,  13,   3,   2,  33,   1,  13,   0,  /* "augmentation" 26140 */
     18,  11,  17,  21,  13,   3,  31,  32,   0,  /* "augmenting" 26149 */
     48,  11,  30,   9,  10,  11,  10,   0,  /* "augsburger" 26157 */
     48,  11,  14,   6,  10,  11,  10,   0,  /* "augspurger" 26165 */
     18,  11,  10,  31,  32,   0,  /* "auguring" 26171 */
     18,  11,  10,  30,   0,  /* "augurs" 26176 */
      8,  11,   1,  14,   3,   0,  /* "august" 26182 */
      1,  11,  35,  14,   3,   1,   0,  /* "augusta" 26189 */
     18,  11,   1,  14,   3,   0,  /* "auguste" 26195 */
     52,  11,  29,  14,   3,  23,  13,   0,  /* "augustin" 26203 */
      8,  11,   1,  14,   3,  23,  13,   0,  /* "augustine" 26211 */
      8,  11,   1,  14,   3,   5,  13,  26,   1,  13,   0,  /* "augustinian" 26222 */
      8,  11,   1,  14,   3,   5,  13,  26,   1,  13,  30,   0,  /* "augustinians" 26234 */
     18,  11,   1,  14,   3,  14,   1,  13,   0,  /* "augustson" 26243 */
     19,  11,  35,  14,   3,   1,  14,   0,  /* "augustus" 26251 */
     52,  11,  35,  14,   3,   1,  13,   0,  /* "augustyn" 26259 */
     52,  11,   1,  14,   3,   5,  13,  26,  34,  12,   0,  /* "augustyniak" 26270 */
     18,  12,  10,   0,  /* "auker" 26274 */
     18,   7,   0,  /* "aul" 26277 */
     48,   7,   8,  13,   1,   0,  /* "aulana" 26283 */
     18,   7,  20,   0,  /* "auld" 26287 */
     36,   7,  21,   3,   1,   0,  /* "auletta" 26293 */
     18,   7,   0,  /* "aull" 26296 */
     18,   7,   3,   0,  /* "ault" 26300 */
     48,  17,   1,   7,  10,   0,  /* "aumiller" 26306 */
     18,  13,   0,  /* "aune" 26309 */
     18,  32,   0,  /* "aung" 26312 */
     48,  32,  11,  14,   3,   0,  /* "aungst" 26318 */
     24,  13,   3,   0,  /* "aunt" 26322 */
     24,  13,   3,  26,   0,  /* "auntie" 26327 */
     24,  13,   3,  14,   0,  /* "aunts" 26332 */
     48,   6,  10,   7,  26,   0,  /* "aupperle" 26338 */
     18,   4,   1,   0,  /* "aura" 26342 */
     52,   4,   2,  19,   0,  /* "aurea" 26347 */
     52,   4,   2,   7,  26,  27,   0,  /* "aurelio" 26354 */
     48,   4,  31,  12,   0,  /* "aurich" 26359 */
     36,   4,  23,  17,   1,   0,  /* "auriemma" 26365 */
     10,  18,   4,   1,   0,  /* "aurora" 26370 */
     10,  18,   4,   1,   7,   0,  /* "auroral" 26376 */
     48,  30,   0,  /* "aus" 26379 */
     18,  33,  47,   5,   3,  14,   0,  /* "auschwitz" 26386 */
     48,  33,  10,  17,   1,  13,   0,  /* "ausherman" 26393 */
     48,  14,   7,   1,  13,  20,  10,   0,  /* "auslander" 26401 */
     18,  14,   7,  26,   0,  /* "ausley" 26406 */
     48,  14,  17,   1,  14,   0,  /* "ausmus" 26412 */
     18,  14,   6,   5,  14,   0,  /* "auspice" 26418 */
     18,  14,   6,   5,  14,   1,  30,   0,  /* "auspices" 26426 */
     19,  14,   6,   5,  33,   1,  14,   0,  /* "auspicious" 26434 */
     18,  14,  26,   0,  /* "aussie" 26438 */
     18,  14,   3,   0,  /* "aust" 26442 */
     48,  14,   3,   1,  20,   0,  /* "austad" 26448 */
     48,  14,   3,   1,   7,   0,  /* "austell" 26454 */
     36,  14,   3,   5,   4,   0,  /* "austere" 26460 */
     18,  14,   3,   5,   4,   7,  26,   0,  /* "austerely" 26468 */
     48,  14,   3,   1,   7,   0,  /* "austill" 26474 */
     18,  14,   3,   1,  13,   0,  /* "austin" 26480 */
     18,  14,   3,  26,  13,   0,  /* "austine" 26486 */
     18,  14,   3,   4,   1,   7,   2,  43,   1,   0,  /* "australasia" 26496 */
     36,  14,   3,   4,   2,   7,  41,   1,   0,  /* "australia" 26505 */
     36,  14,   3,   4,   2,   7,  41,   1,  13,   0,  /* "australian" 26515 */
     36,  14,   3,   4,   2,   7,  41,   1,  13,  30,   0,  /* "australians" 26526 */
     36,  14,   3,   4,   2,   7,  27,   6,   5,  16,   1,  14,  39,  13,   0,  /* "australopithecine" 26541 */
     36,  14,   3,   4,   2,   7,  27,   6,   5,  16,   1,  12,   1,  14,   0,  /* "australopithecus" 26556 */
     36,  14,   3,   4,   2,  43,   1,   0,  /* "austrasia" 26564 */
     18,  14,   3,   4,  25,   2,  43,  26,  24,   3,  31,  12,   0,  /* "austroasiatic" 26577 */
     18,  14,   3,   4,   1,  13,   0,  /* "austron" 26584 */
     48,   3,   1,  13,   0,  /* "auten" 26589 */
     48,   3,   1,  13,   4,  26,   1,  16,   0,  /* "autenrieth" 26598 */
     25,   3,  10,  26,   0,  /* "autery" 26603 */
     18,  16,   0,  /* "auth" 26606 */
     48,  16,  17,   1,  13,   3,   0,  /* "authement" 26613 */
      1,  16,  21,  13,   3,  31,  12,   0,  /* "authentic" 26621 */
     36,  16,  21,  13,   3,   1,  12,   2,   3,   0,  /* "authenticate" 26631 */
     36,  16,  21,  13,   3,   1,  12,   2,   3,   1,  20,   0,  /* "authenticated" 26643 */
     36,  16,  21,  13,   3,   1,  12,   2,   3,  31,  32,   0,  /* "authenticating" 26655 */
     36,  16,  21,  13,   3,   1,  12,   2,  33,   1,  13,   0,  /* "authentication" 26667 */
     36,  16,  21,  13,   3,   1,  12,   2,  33,   1,  13,  30,   0,  /* "authentications" 26680 */
     18,  16,   1,  13,   3,   5,  14,   1,   3,  26,   0,  /* "authenticity" 26691 */
     18,  16,  10,   0,  /* "auther" 26695 */
     48,  16,  26,  10,   0,  /* "authier" 26700 */
      1,  16,  18,   4,   1,   3,  21,   4,  26,   1,  13,   0,  /* "authoritarian" 26712 */
      1,  16,  18,   4,   1,   3,  21,   4,  26,   1,  13,   5,  30,   1,  17,   0,  /* "authoritarianism" 26728 */
      1,  16,  18,   4,   1,   3,   2,   3,  31,  22,   0,  /* "authoritative" 26739 */
      1,  16,  18,   4,   1,   3,   2,   3,  31,  22,   7,  26,   0,  /* "authoritatively" 26752 */
      1,  16,  18,   4,   1,   3,  26,  30,   0,  /* "authorities" 26761 */
      1,  16,  18,   4,   1,   3,  26,   0,  /* "authority" 26769 */
     18,  16,  10,  39,  30,   0,  /* "authorize" 26775 */
     18,  16,  10,  39,  30,  20,   0,  /* "authorized" 26782 */
     18,  16,  10,  39,  30,   1,  30,   0,  /* "authorizes" 26790 */
     18,  16,  10,  39,  30,  31,  32,   0,  /* "authorizing" 26798 */
     18,   3,   5,  30,   1,  17,   0,  /* "autism" 26805 */
     36,   3,   5,  14,   3,  31,  12,   0,  /* "autistic" 26813 */
     18,   3,  27,   0,  /* "auto" 26817 */
     18,   3,  27,   9,   8,  13,   0,  /* "autobahn" 26824 */
     18,   3,   1,   9,  39,   1,  11,   4,  24,  37,  31,  12,   1,   7,   0,  /* "autobiographical" 26839 */
     18,   3,   1,   9,  39,   8,  11,   4,   1,  37,  26,  30,   0,  /* "autobiographies" 26852 */
      8,   3,   1,   9,   8,  13,   0,  /* "autobon" 26859 */
     18,   3,  27,  12,   7,   2,  22,   0,  /* "autoclave" 26867 */
     36,   3,   8,  12,   4,   1,  14,  26,   0,  /* "autocracy" 26876 */
     18,   3,   1,  12,   4,  24,   3,   0,  /* "autocrat" 26884 */
     18,   3,   1,  12,   4,  24,   3,  31,  12,   0,  /* "autocratic" 26894 */
     18,   3,  27,  20,  21,  14,  12,   0,  /* "autodesk" 26902 */
     18,   3,  27,  20,  39,   0,  /* "autodie" 26908 */
     18,   3,   1,  11,   4,  24,  37,   0,  /* "autograph" 26916 */
     18,   3,   1,  11,   4,  24,  37,   3,   0,  /* "autographed" 26925 */
     18,   3,   1,  11,   4,  24,  37,  14,   0,  /* "autographs" 26934 */
     18,   3,  49,  17,  41,  29,  13,   0,  /* "autoimmune" 26942 */
     18,   3,  25,   7,   1,   3,  23,  13,   1,   0,  /* "autolatina" 26952 */
     36,   3,   8,  17,   1,   3,   1,   0,  /* "automata" 26960 */
     18,   3,   1,  17,   2,   3,  14,   0,  /* "automates" 26968 */
     36,   3,   1,  17,   2,  33,   1,  13,   0,  /* "automation" 26977 */
     18,   3,  27,  17,   2,   3,  31,  12,  14,   0,  /* "automatix" 26987 */
     36,   3,   8,  17,   1,   3,   8,  13,   0,  /* "automaton" 26996 */
     18,   3,   1,  17,  27,   9,  23,   7,   0,  /* "automobile" 27005 */
     18,   3,  27,  17,  27,   9,  23,   7,  26,   0,  /* "automobili" 27015 */
     18,   3,  27,  17,  27,  22,  23,   7,  15,  30,   0,  /* "automoviles" 27026 */
     18,   3,   1,  13,   8,  17,  31,  12,   0,  /* "autonomic" 27035 */
     36,   3,   8,  13,   1,  17,   1,  14,   0,  /* "autonomous" 27044 */
     18,   3,   8,  13,  27,  17,   1,  14,   7,  26,   0,  /* "autonomously" 27055 */
     36,   3,   8,  13,   1,  17,  26,   0,  /* "autonomy" 27063 */
     18,   3,  27,   6,  39,   7,   1,   3,   0,  /* "autopilot" 27072 */
     18,   3,   8,   6,  14,  26,  20,   0,  /* "autopsied" 27080 */
     18,   3,   8,   6,  14,  26,  30,   0,  /* "autopsies" 27088 */
     18,   3,  27,   4,  24,  20,   0,  /* "autorad" 27095 */
     19,   3,  27,   4,   2,  20,  26,  27,  11,   4,  34,  37,   0,  /* "autoradiograph" 27108 */
     18,   3,  27,  14,   6,   1,   0,  /* "autospa" 27115 */
     18,   3,   1,   3,   4,  25,  37,  31,  12,   0,  /* "autotrophic" 27125 */
     18,   3,  27,  47,  10,  12,  10,   0,  /* "autoworker" 27133 */
     18,   3,  27,  47,  10,  12,  10,  30,   0,  /* "autoworkers" 27142 */
     18,   3,   1,  17,   0,  /* "autumn" 27147 */
     36,   3,  35,  17,  13,   1,   7,   0,  /* "autumnal" 27155 */
     27,  22,   5,   7,   0,  /* "auvil" 27160 */
     25,   0,  /* "aux" 27162 */
     18,  12,  14,  26,  10,   0,  /* "auxier" 27168 */
     19,  11,  30,   5,   7,  41,  10,  26,   0,  /* "auxiliary" 27177 */
     18,  12,  14,   3,   1,  13,   0,  /* "auxton" 27184 */
     48,  41,  29,  32,   0,  /* "auyeung" 27189 */
     18,  30,   1,  13,   0,  /* "auzenne" 27194 */
      2,  22,   1,   0,  /* "ava" 27198 */
      1,  22,   2,   7,   1,   9,   1,   7,   0,  /* "available" 27207 */
     24,  22,   1,   7,  24,  13,  42,   0,  /* "avalanche" 27215 */
     24,  22,   1,   7,  24,  13,  42,   1,  30,   0,  /* "avalanches" 27225 */
     24,  22,   1,   7,  25,  13,   0,  /* "avallone" 27232 */
     24,  22,   1,   7,   8,  13,   0,  /* "avalon" 27239 */
      1,  22,  24,  13,   1,   0,  /* "avana" 27245 */
      8,  22,   1,  13,  15,  12,  14,   0,  /* "avanex" 27253 */
      1,  22,   8,  13,   3,   0,  /* "avant" 27259 */
      1,  22,   8,  13,   3,  15,  12,   0,  /* "avantek" 27267 */
      1,  22,   8,  13,   3,  26,   0,  /* "avanti" 27274 */
     19,  22,  18,  13,   3,  14,   0,  /* "avants" 27281 */
     24,  22,  10,   1,  14,   0,  /* "avarice" 27287 */
      1,  22,   8,  14,  25,   0,  /* "avasso" 27293 */
     24,  22,  12,  27,   0,  /* "avco" 27298 */
     24,  22,  20,  21,   7,   0,  /* "avdel" 27304 */
     24,  22,   1,  13,  29,   0,  /* "ave" 27310 */
     34,  22,   1,  20,   5,  43,   1,  13,   0,  /* "avedisian" 27319 */
     24,  22,  15,  20,  19,  13,   0,  /* "avedon" 27326 */
     19,  22,  28,   7,   8,   4,   0,  /* "avelar" 27333 */
     19,  22,  15,   7,  23,  13,  26,   0,  /* "aveline" 27341 */
      1,  22,  21,   7,   1,   0,  /* "avella" 27347 */
     24,  22,   1,   7,  23,  13,  27,   0,  /* "avellino" 27355 */
      1,  22,  21,  17,  12,  27,   0,  /* "avemco" 27362 */
     19,  22,   2,   1,  13,   0,  /* "aven" 27368 */
     19,  22,   2,  13,   1,   0,  /* "avena" 27374 */
     19,  22,  28,  13,   8,   7,   0,  /* "avenall" 27381 */
     19,  22,  15,  13,  20,   8,  13,  27,   0,  /* "avendano" 27390 */
     19,  22,  28,  13,  21,   7,   0,  /* "avenel" 27397 */
     19,  22,  28,  13,   2,   7,   0,  /* "avenell" 27404 */
      1,  22,  21,  13,  40,   0,  /* "avenge" 27410 */
      1,  22,  21,  13,  40,  20,   0,  /* "avenged" 27417 */
      1,  22,  21,  13,  40,  10,   0,  /* "avenger" 27424 */
      1,  22,  21,  13,  40,  31,  32,   0,  /* "avenging" 27432 */
      8,  22,   1,  13,   3,   0,  /* "avent" 27438 */
     24,  22,   1,  13,  29,   0,  /* "avenue" 27444 */
     24,  22,   1,  13,  29,  30,   0,  /* "avenues" 27451 */
      2,  22,  10,   0,  /* "aver" 27455 */
     19,  22,  21,   4,   1,   0,  /* "avera" 27461 */
     24,  22,  10,  31,  40,   0,  /* "average" 27467 */
      2,  22,  10,   9,  21,  12,   0,  /* "averbeck" 27474 */
     19,  22,  15,   4,   2,   7,   0,  /* "averell" 27481 */
      2,  22,  10,   1,   7,   0,  /* "averil" 27487 */
     19,  22,  15,   4,  23,   7,   0,  /* "averill" 27494 */
     24,  22,  10,   5,   3,   0,  /* "averitt" 27500 */
     24,  22,  10,   8,  37,   0,  /* "averof" 27506 */
      2,  22,  10,  30,   0,  /* "avers" 27511 */
     19,  22,  21,   4,  14,   1,   0,  /* "aversa" 27518 */
     19,  22,  10,  14,   8,  13,  27,   0,  /* "aversano" 27526 */
      1,  22,  44,  14,   0,  /* "averse" 27531 */
      1,  22,  44,  43,   1,  13,   0,  /* "aversion" 27538 */
      1,  22,  44,  14,  31,  22,   0,  /* "aversive" 27545 */
      1,  22,  44,   3,   0,  /* "avert" 27550 */
      1,  22,  44,   3,   1,  20,   0,  /* "averted" 27557 */
      1,  22,  44,   3,  31,  32,   0,  /* "averting" 27564 */
      1,  22,  44,   3,  14,   0,  /* "averts" 27570 */
      2,  22,  10,  26,   0,  /* "avery" 27575 */
     24,  22,  10,   1,   7,   0,  /* "averyl" 27581 */
      2,  22,  26,   0,  /* "avey" 27585 */
      8,  22,  26,   0,  /* "avi" 27589 */
      8,  22,  26,   1,   0,  /* "avia" 27594 */
      2,  22,  26,   2,  33,   1,  13,   0,  /* "aviacion" 27602 */
      8,  22,  26,   8,  13,  27,   0,  /* "aviano" 27609 */
      2,  22,  26,  21,   4,  26,   0,  /* "aviary" 27616 */
      2,  22,  26,  28,   3,  10,  30,   0,  /* "aviators" 27624 */
     24,  22,  26,  24,  30,  26,  25,  13,  26,   0,  /* "aviazione" 27634 */
      8,  22,  39,  14,   0,  /* "avice" 27639 */
     24,  22,   1,  20,   0,  /* "avid" 27644 */
     24,  22,   1,  20,   7,  26,   0,  /* "avidly" 27651 */
      1,  22,   5,   7,   1,   0,  /* "avila" 27657 */
     19,  22,  23,   7,  15,  14,   0,  /* "aviles" 27664 */
      1,  22,   5,   7,   1,   0,  /* "avilla" 27670 */
     19,  22,  23,  13,   1,   0,  /* "avina" 27676 */
      2,  22,   5,  14,   0,  /* "avis" 27681 */
     19,  22,  26,   3,   8,   9,   1,   7,   0,  /* "avitabile" 27690 */
      1,  22,  23,   3,   1,   7,   0,  /* "avital" 27697 */
     19,  22,  23,  33,   1,   0,  /* "avitia" 27703 */
     19,  22,  23,  22,   0,  /* "aviv" 27708 */
     24,  22,  13,  21,   3,   0,  /* "avnet" 27714 */
     24,  22,   1,  12,   8,  20,  27,   0,  /* "avocado" 27722 */
     24,  22,   1,  12,   8,  20,  27,  30,   0,  /* "avocados" 27731 */
     24,  22,   1,  12,   2,  33,   1,  13,   0,  /* "avocation" 27740 */
     24,  22,   1,  14,  21,   3,   0,  /* "avocet" 27747 */
     24,  22,   1,  20,  19,  13,   0,  /* "avodon" 27754 */
      1,  22,  49,  20,   1,   9,   1,   7,   0,  /* "avoidable" 27763 */
      1,  22,  25,   7,  26,  27,   0,  /* "avolio" 27770 */
      2,  22,  19,  13,   0,  /* "avon" 27775 */
      1,  22,  48,   0,  /* "avow" 27779 */
      1,  22,  48,  20,   0,  /* "avowed" 27784 */
      1,  22,  48,   1,  20,   7,  26,   0,  /* "avowedly" 27792 */
      2,  22,   4,   1,  38,  34,  17,   0,  /* "avraham" 27800 */
      2,  22,   4,   1,  17,   0,  /* "avram" 27806 */
     24,  22,   4,  15,   3,   0,  /* "avrett" 27812 */
     19,  22,   4,  23,  17,   0,  /* "avrim" 27818 */
     24,  22,   3,  21,  12,  14,   0,  /* "avtex" 27825 */
     24,  22,   3,  25,  22,  24,  30,   0,  /* "avtovaz" 27833 */
      1,  22,  35,  32,  12,  41,   1,   7,  10,   0,  /* "avuncular" 27843 */
     18,   0,  /* "aw" 27845 */
      2,  47,  24,  12,  14,   0,  /* "awacs" 27851 */
      1,  47,   8,  20,   0,  /* "awad" 27856 */
      1,  47,   2,  12,   0,  /* "awake" 27861 */
      8,  22,   1,   7,   3,   0,  /* "awalt" 27867 */
      2,  47,   1,  13,   0,  /* "awan" 27872 */
      1,  47,  18,   4,  20,   0,  /* "award" 27878 */
      1,  47,  18,   4,  20,   1,  20,   0,  /* "awarded" 27886 */
      1,  47,  18,   4,  20,  30,   0,  /* "awards" 27893 */
      1,  47,   2,   0,  /* "away" 27897 */
      2,  47,   2,  30,   0,  /* "aways" 27902 */
      2,  20,  35,   9,   1,   7,  41,  29,   9,  23,   0,  /* "awb" 27913 */
     18,   9,   4,  26,   0,  /* "awbrey" 27918 */
      8,   0,  /* "awe" 27920 */
     18,  20,   0,  /* "awed" 27923 */
      1,  47,   2,  20,   1,   0,  /* "aweida" 27929 */
      8,  14,   1,  17,   0,  /* "awesome" 27934 */
      8,  14,   1,  17,   7,  26,   0,  /* "awesomely" 27941 */
      8,  14,   3,   4,  35,  12,   0,  /* "awestruck" 27948 */
      8,  37,   7,  26,   0,  /* "awfully" 27953 */
     18,  37,   1,   7,  13,   1,  14,   0,  /* "awfulness" 27961 */
      1,  47,  39,   7,   0,  /* "awhile" 27966 */
      1,  47,  25,  12,   0,  /* "awoke" 27971 */
     10,  39,   0,  /* "awry" 27974 */
     18,   3,   4,  26,   0,  /* "awtrey" 27979 */
     24,  12,  14,   0,  /* "ax" 27983 */
     24,  12,  14,   1,   0,  /* "axa" 27988 */
     24,  12,  14,   0,  /* "axe" 27992 */
     24,  12,  14,   3,   0,  /* "axed" 27997 */
     24,  12,  14,   1,   7,   0,  /* "axel" 28003 */
     34,  12,  14,  21,   7,   4,   1,  20,   0,  /* "axelrad" 28012 */
     24,  12,  14,   1,   7,   4,   8,  20,   0,  /* "axelrod" 28021 */
     34,  12,  14,  21,   7,  14,   1,  13,   0,  /* "axelsen" 28030 */
     24,  12,  14,   1,   7,  14,   1,  13,   0,  /* "axelson" 28039 */
     24,  12,  14,   1,  30,   0,  /* "axes" 28045 */
     34,  12,  14,  37,  18,   4,  20,   0,  /* "axford" 28053 */
     24,  12,  14,   1,  20,   0,  /* "axid" 28059 */
     24,  12,  14,   1,   7,   4,   8,  20,   0,  /* "axilrod" 28068 */
     24,  12,  14,  26,   1,  17,   0,  /* "axiom" 28075 */
     24,  12,  14,  26,   1,  17,  24,   3,  31,  12,   0,  /* "axiomatic" 28086 */
     24,  12,  14,  26,   1,  17,  30,   0,  /* "axioms" 28094 */
     24,  12,  14,   1,  14,   0,  /* "axis" 28100 */
     24,  12,  14,   1,   7,   0,  /* "axle" 28106 */
     24,  12,  14,   1,   7,  30,   0,  /* "axles" 28113 */
     24,  12,  14,   7,  26,   0,  /* "axley" 28119 */
     24,  12,  14,   7,  39,  13,   0,  /* "axline" 28126 */
     24,  12,  14,   7,  19,  13,   0,  /* "axlon" 28133 */
     24,  12,  14,   8,  13,   0,  /* "axon" 28139 */
     24,  12,  14,   8,  13,  30,   0,  /* "axons" 28146 */
     24,  12,  14,   1,  17,   0,  /* "axsom" 28152 */
     24,  12,  14,   3,   0,  /* "axt" 28157 */
     34,  12,  14,   3,  21,   7,   0,  /* "axtell" 28164 */
     24,  12,  14,   3,  17,   1,  13,   0,  /* "axtman" 28172 */
     24,  12,  14,   3,   1,  13,   0,  /* "axton" 28179 */
      2,   0,  /* "ay" 28181 */
     39,   1,  12,  35,  42,  27,   0,  /* "ayacucho" 28188 */
      1,  41,   8,  12,  27,   0,  /* "ayako" 28194 */
      1,  41,   8,   7,   1,   0,  /* "ayala" 28200 */
      2,  10,  30,   0,  /* "ayars" 28204 */
     39,   1,   3,  25,   7,   1,   0,  /* "ayatollah" 28211 */
     39,   1,   3,   8,   7,  19,  30,   0,  /* "ayatollahs" 28219 */
      2,   9,  10,   0,  /* "aybar" 28223 */
      2,  12,   1,  12,   0,  /* "aycock" 28228 */
     39,  20,   8,   4,   0,  /* "aydar" 28233 */
      2,  20,   1,   7,  19,   3,   0,  /* "aydelott" 28240 */
      2,   3,   0,  /* "aydt" 28243 */
     39,   0,  /* "aye" 28245 */
     39,  10,   0,  /* "ayer" 28248 */
     39,  10,  30,   0,  /* "ayers" 28252 */
      2,  10,  14,   3,   0,  /* "ayerst" 28257 */
     39,  30,   0,  /* "ayes" 28260 */
     39,  11,   1,  13,   0,  /* "aygen" 28265 */
      2,   1,   7,  30,  47,  10,  16,   0,  /* "aylesworth" 28273 */
      2,   7,  14,  47,  10,  16,   0,  /* "aylsworth" 28280 */
      2,  13,   0,  /* "ayn" 28283 */
      2,  27,   0,  /* "ayo" 28286 */
     39,   8,  20,  41,   1,   0,  /* "ayodhya" 28292 */
     28,  18,  13,   0,  /* "ayon" 28296 */
     28,  18,   3,   0,  /* "ayotte" 28300 */
      2,  52,   9,   0,  /* "ayoub" 28304 */
      2,   4,   0,  /* "ayr" 28307 */
     21,   4,   0,  /* "ayre" 28310 */
      2,  14,  12,  41,  29,   0,  /* "ayscue" 28316 */
     39,  29,  14,  27,   0,  /* "ayuso" 28321 */
     39,   8,  20,   0,  /* "ayyad" 28325 */
     39,  41,  24,  33,   0,  /* "ayyash" 28330 */
      1,  30,   2,   7,  41,   1,   0,  /* "azalea" 28337 */
      1,  30,   2,   7,  41,   1,  30,   0,  /* "azaleas" 28345 */
     19,  30,   8,   4,   0,  /* "azar" 28350 */
     24,  30,  10,  27,   0,  /* "azarow" 28355 */
     19,  30,   9,  23,   7,   0,  /* "azbill" 28361 */
     34,  30,  12,   8,   4,   8,  11,   1,   0,  /* "azcarraga" 28370 */
     34,  30,  12,  25,  13,   1,   0,  /* "azcona" 28377 */
     34,  30,  12,  47,   2,  13,   8,  11,   1,   0,  /* "azcuenaga" 28387 */
     19,  30,  21,   7,  26,   1,   0,  /* "azelia" 28394 */
      8,  30,  10,   9,  39,  40,   8,  13,   0,  /* "azerbaijan" 28403 */
      8,  30,  10,   9,  39,  40,   8,  13,  26,   0,  /* "azerbaijani" 28413 */
      8,  30,  10,   9,  39,  40,   8,  13,  26,  30,   0,  /* "azerbaijanis" 28424 */
      1,  30,  21,   4,  26,   0,  /* "azeri" 28430 */
     19,  30,  28,  22,   2,  20,  27,   0,  /* "azevedo" 28438 */
      1,  30,   8,   4,   0,  /* "azhar" 28443 */
     24,  30,  39,  20,  30,   0,  /* "azides" 28449 */
      1,  30,   5,  20,   1,  16,  39,  17,   1,  20,  23,  13,   0,  /* "azidothymidine" 28462 */
      1,  30,  23,  30,   0,  /* "aziz" 28467 */
     24,  30,  36,  37,   0,  /* "azoff" 28472 */
     34,  30,   6,  41,  45,   4,  29,   1,   0,  /* "azpurua" 28481 */
     24,  30,   3,  21,  12,  14,   0,  /* "aztecs" 28488 */
      1,  30,  45,   4,   1,   0,  /* "azura" 28494 */
     24,  43,  10,   0,  /* "azure" 28498 */
     19,   3,  14,   8,   4,   1,   0,  /* "azzara" 28505 */
     19,   3,  14,  19,   4,  21,   7,  27,   0,  /* "azzarello" 28514 */
     19,   3,  14,   8,   4,  27,   0,  /* "azzaro" 28521 */
      1,  30,   8,   3,  27,   0,  /* "azzato" 28527 */
     19,   3,  14,  27,   6,   8,   4,  20,  26,   0,  /* "azzopardi" 28537 */
      9,  23,   0,  /* "b" 28540 */
      9,   8,   9,   0,  /* "baab" 28544 */
      9,   8,   7,   9,  15,  12,   0,  /* "baalbek" 28551 */
      9,   8,   7,   9,  15,  12,   0,  /* "baalbeq" 28558 */
      9,   8,   4,   0,  /* "baar" 28562 */
      9,   8,   4,  30,   0,  /* "baars" 28567 */
      9,   8,  30,   0,  /* "baas" 28571 */
      9,  24,   9,   0,  /* "bab" 28575 */
      9,   8,   9,   1,   0,  /* "baba" 28580 */
      9,   1,   9,   8,  32,  11,   1,  20,   1,   0,  /* "babangida" 28590 */
      9,  24,   9,   0,  /* "babb" 28594 */
      9,  24,   9,   1,   3,  14,   0,  /* "babbitts" 28601 */
      9,  24,   9,   1,   7,   0,  /* "babble" 28607 */
      9,  24,   9,   1,   7,  20,   0,  /* "babbled" 28614 */
      9,  24,   9,   1,   7,  31,  32,   0,  /* "babbling" 28622 */
      9,  24,   9,  12,  36,  12,   0,  /* "babcock" 28629 */
      9,   2,   9,   0,  /* "babe" 28633 */
      9,   8,   9,  26,  34,  12,   0,  /* "babiak" 28640 */
      9,   1,   9,  23,  10,  30,   0,  /* "babiarz" 28647 */
      9,   8,   9,  31,  12,   0,  /* "babic" 28653 */
      9,  24,   9,  31,  42,   0,  /* "babich" 28659 */
      9,   2,   9,  26,  30,   0,  /* "babies" 28665 */
      9,  19,   9,  23,  13,  27,   0,  /* "babino" 28672 */
      9,   1,   9,   5,  13,  14,  12,  26,   0,  /* "babinski" 28681 */
      9,  19,   9,  23,   3,   1,   0,  /* "babita" 28688 */
      9,  24,   9,  12,   1,   0,  /* "babka" 28694 */
      9,   2,   9,   1,   7,  10,   0,  /* "babler" 28701 */
      9,   1,   9,  29,  13,   0,  /* "baboon" 28707 */
      9,  34,   9,  29,  13,  30,   0,  /* "baboons" 28714 */
      9,  24,   9,  30,   0,  /* "babs" 28719 */
      9,  24,   9,  14,   1,  13,   0,  /* "babson" 28726 */
      9,  19,   9,  29,   0,  /* "babu" 28731 */
      9,  19,   9,  29,   7,   1,   0,  /* "babula" 28738 */
      9,   2,   9,  26,   0,  /* "baby" 28743 */
      9,  24,   9,  26,  34,  12,   0,  /* "babyak" 28750 */
      9,  24,   9,   1,   7,   8,  13,   0,  /* "babylon" 28758 */
      9,  24,   9,   1,   7,  25,  13,  26,   1,  13,   0,  /* "babylonian" 28769 */
      9,  24,   9,   1,   7,  25,  13,  26,   1,  13,  30,   0,  /* "babylonians" 28781 */
      9,   2,   9,  26,  14,   5,   3,   0,  /* "babysit" 28789 */
      9,  24,  12,   1,   0,  /* "baca" 28794 */
      9,   1,  12,  18,   7,   0,  /* "bacall" 28800 */
      9,   1,  12,   8,   4,  20,  26,   0,  /* "bacardi" 28808 */
      9,   8,  12,  10,   8,   0,  /* "baccarat" 28814 */
      9,  19,  12,   8,   4,  26,   0,  /* "baccari" 28821 */
      9,  24,  12,   1,  13,   2,   7,  41,   1,   0,  /* "bacchanalia" 28831 */
      9,   8,  42,  26,   0,  /* "bacci" 28836 */
      9,   8,  12,   0,  /* "bach" 28840 */
      9,  24,  42,   1,  13,  20,   0,  /* "bachand" 28847 */
      9,   8,  12,  10,   0,  /* "bachar" 28852 */
      9,  24,  12,  10,  34,  12,   0,  /* "bacharach" 28859 */
      9,  24,  42,   0,  /* "bache" 28863 */
      9,   8,  12,   1,   7,  20,  10,   0,  /* "bachelder" 28871 */
      9,   8,  12,   1,   7,  10,   0,  /* "bacheller" 28878 */
      9,  24,  42,   1,   7,  10,   0,  /* "bachelor" 28885 */
      9,  24,  42,   7,  10,  30,   0,  /* "bachelors" 28892 */
      9,  24,  42,  10,   3,   0,  /* "bachert" 28898 */
      9,  24,  12,   7,  10,   0,  /* "bachler" 28904 */
      9,   8,  12,   4,   1,  12,   0,  /* "bachrach" 28911 */
      9,  24,  12,   3,   1,   7,   0,  /* "bachtel" 28918 */
      9,  24,  12,   3,   1,   7,   0,  /* "bachtell" 28925 */
      9,  19,  42,  26,  11,  19,   7,  29,   6,  26,   0,  /* "bacigalupi" 28936 */
      9,  19,  42,  26,  11,  19,   7,  29,   6,  27,   0,  /* "bacigalupo" 28947 */
      9,   1,  14,   5,   7,   1,  14,   0,  /* "bacillus" 28955 */
      9,  19,  42,  23,  13,  27,   0,  /* "bacino" 28962 */
      9,  24,  12,   0,  /* "back" 28966 */
      9,  24,  12,   2,  12,   0,  /* "backache" 28972 */
      9,  24,  12,   2,  12,  14,   0,  /* "backaches" 28979 */
      9,  24,  12,   9,  39,   3,   0,  /* "backbite" 28986 */
      9,  24,  12,   9,  39,   3,  31,  32,   0,  /* "backbiting" 28995 */
      9,  24,  12,   9,  18,  20,   0,  /* "backboard" 29002 */
      9,  24,  12,  20,  18,   4,   0,  /* "backdoor" 29009 */
      9,  24,  12,  37,  39,   4,   0,  /* "backfire" 29016 */
      9,  24,  12,  37,  39,  10,  20,   0,  /* "backfired" 29024 */
      9,  24,  12,  37,  39,  10,  30,   0,  /* "backfires" 29032 */
      9,  24,  12,  37,  39,  10,  31,  32,   0,  /* "backfiring" 29041 */
      9,  24,  12,   7,  39,   3,   0,  /* "backlight" 29048 */
      9,  24,  12,   7,  39,   3,  14,   0,  /* "backlights" 29056 */
      9,  24,  12,   7,  18,  11,  30,   0,  /* "backlogs" 29064 */
      9,  24,  12,   6,  21,  20,   1,   7,   0,  /* "backpedal" 29073 */
      9,  24,  12,   6,  21,  20,   1,   7,  20,   0,  /* "backpedaled" 29083 */
      9,  24,  12,   6,  21,  20,   1,   7,  31,  32,   0,  /* "backpedaling" 29094 */
      9,  24,  12,   4,  29,  17,   0,  /* "backroom" 29101 */
      9,  24,  12,  14,   8,   0,  /* "backsaw" 29107 */
      9,  34,  12,  14,  23,   3,   0,  /* "backseat" 29114 */
      9,  24,  12,  14,  39,  20,   0,  /* "backside" 29121 */
      9,  24,  12,  14,   7,  39,  20,   0,  /* "backslide" 29129 */
      9,  24,  12,  14,   7,  39,  20,  31,  32,   0,  /* "backsliding" 29139 */
      9,  24,  12,  14,   3,  31,  42,   0,  /* "backstitch" 29147 */
      9,  24,  12,   3,   4,  24,  12,  31,  32,   0,  /* "backtracking" 29157 */
      9,   2,  12,   1,  13,   0,  /* "bacon" 29163 */
      9,  24,  12,  10,  13,   0,  /* "bacorn" 29169 */
      9,   1,  12,  25,   3,   0,  /* "bacote" 29175 */
      9,  34,  12,   3,   5,   4,  26,   1,   0,  /* "bacteria" 29184 */
      9,  34,  12,   3,   5,   4,  26,   1,   7,   0,  /* "bacterial" 29194 */
      9,  24,  12,   3,  31,   4,  23,   8,   7,   1,  40,  26,   0,  /* "bacteriology" 29207 */
      9,  34,  12,   3,   5,   4,  26,   1,  17,   0,  /* "bacterium" 29217 */
      9,  24,  20,   0,  /* "bad" 29221 */
      9,   8,  20,   1,   0,  /* "bada" 29226 */
      9,   2,  20,   1,   7,   0,  /* "badal" 29232 */
      9,  19,  20,  19,   7,  19,  17,  21,  13,   3,  26,   0,  /* "badalamenti" 29244 */
      9,  24,  20,   1,  22,  24,   3,  14,   0,  /* "badavatz" 29253 */
      9,   2,  20,   0,  /* "bade" 29257 */
      9,   1,  20,  23,   1,   0,  /* "badeah" 29263 */
      9,   1,  20,  25,   0,  /* "badeau" 29268 */
      9,   1,  20,  25,   0,  /* "badeaux" 29273 */
      9,  24,  40,   5,   3,   0,  /* "badgett" 29279 */
      9,   8,  20,  26,   1,   0,  /* "badia" 29285 */
      9,   1,  20,   5,   7,  27,   0,  /* "badillo" 29292 */
      9,  24,  20,   7,  24,  13,  20,   0,  /* "badland" 29300 */
      9,  24,  20,   7,  24,  13,  20,  30,   0,  /* "badlands" 29309 */
      9,  19,  20,  27,   7,   8,   3,  27,   0,  /* "badolato" 29318 */
      9,   1,  20,  45,   4,   0,  /* "badour" 29324 */
      9,   2,  20,  26,   0,  /* "bady" 29329 */
      9,  39,   0,  /* "bae" 29332 */
      9,  21,  12,   1,   7,   0,  /* "baechle" 29338 */
      9,   2,  20,   1,  12,  10,   0,  /* "baedeker" 29345 */
      9,  23,   4,   0,  /* "baehr" 29349 */
      9,  23,  12,   0,  /* "baek" 29353 */
      9,  21,   4,   0,  /* "baer" 29357 */
      9,  21,   4,  47,  36,   7,  20,   0,  /* "baerwald" 29365 */
      9,  23,   3,  14,   0,  /* "baetz" 29370 */
      9,  39,  21,  30,   0,  /* "baez" 29375 */
      9,  24,  37,   1,   7,   0,  /* "baffle" 29381 */
      9,  24,  37,   1,   7,  20,   0,  /* "baffled" 29388 */
      9,  24,  37,   1,   7,  30,   0,  /* "baffles" 29395 */
      9,  24,  37,   1,   7,  31,  32,   0,  /* "baffling" 29403 */
      9,  24,  37,  27,  12,  21,  32,   0,  /* "bafokeng" 29411 */
      9,  24,  11,   0,  /* "bag" 29415 */
      9,  24,  11,  20,  34,  20,   0,  /* "bagdad" 29422 */
      9,  24,  11,  20,   5,  12,  26,   1,  13,   0,  /* "bagdikian" 29432 */
      9,   2,  11,   1,   7,  34,  13,  20,   0,  /* "bageland" 29441 */
      9,   2,  40,   1,  13,   3,   0,  /* "bagent" 29448 */
      9,  24,  11,  37,  45,   7,   0,  /* "bagful" 29455 */
      9,  24,  11,   0,  /* "bagg" 29459 */
      9,  24,  11,   1,  40,   0,  /* "baggage" 29465 */
      9,  24,  11,   5,   3,   0,  /* "baggett" 29471 */
      9,  24,  11,  26,  13,   1,  14,   0,  /* "bagginess" 29479 */
      9,   8,  40,  26,  27,   0,  /* "baggio" 29485 */
      9,   1,  11,   5,  13,  14,  12,  26,   0,  /* "baginski" 29494 */
      9,  19,  11,  13,   8,   3,  27,   0,  /* "bagnato" 29502 */
      9,  24,  11,   6,  39,   6,   0,  /* "bagpipe" 29509 */
      9,  24,  11,   6,  39,   6,  10,   0,  /* "bagpiper" 29517 */
      9,  24,  11,   6,  39,   6,  14,   0,  /* "bagpipes" 29525 */
      9,  24,  11,  30,   0,  /* "bags" 29530 */
      9,   8,   0,  /* "bah" 29533 */
      9,   8,   1,  17,   0,  /* "baham" 29538 */
      9,  24,  38,   1,  13,   0,  /* "bahan" 29544 */
      9,   2,  38,   0,  /* "bahe" 29548 */
      9,  24,  38,  15,  13,   1,   0,  /* "bahena" 29555 */
      9,   8,  38,  26,   1,   0,  /* "bahia" 29561 */
      9,   8,   7,   0,  /* "bahl" 29565 */
      9,  24,  17,   0,  /* "bahm" 29569 */
      9,  24,  13,   0,  /* "bahn" 29573 */
      9,  21,   4,   0,  /* "bahr" 29577 */
      9,  19,   4,   2,  13,   0,  /* "bahrain" 29583 */
      9,   8,   4,   0,  /* "bahre" 29587 */
      9,   8,   3,   0,  /* "baht" 29591 */
      9,  39,  20,  25,   1,   0,  /* "baidoa" 29597 */
      9,  39,  20,  25,   1,  13,   0,  /* "baidoan" 29604 */
      9,  39,  20,  25,   1,  13,  30,   0,  /* "baidoans" 29612 */
      9,  39,  20,  25,   1,  30,   0,  /* "baidoas" 29619 */
      9,  39,  26,   0,  /* "baie" 29623 */
      9,   2,  10,   0,  /* "baier" 29627 */
      9,   2,  11,   0,  /* "baig" 29631 */
      9,   2,   7,   0,  /* "bail" 29635 */
      9,   2,   7,  10,  20,   0,  /* "bailard" 29641 */
      9,   2,   7,   1,  37,   0,  /* "bailiff" 29647 */
      9,   2,   7,   1,  47,   5,  12,   0,  /* "bailiwick" 29655 */
      9,   1,   7,   8,   4,  40,   1,  13,   0,  /* "baillargeon" 29664 */
      9,   2,  17,   0,  /* "baim" 29668 */
      9,   2,  13,   0,  /* "bain" 29672 */
      9,   2,  13,   9,   4,  31,  40,   0,  /* "bainbridge" 29680 */
      9,   8,  26,  27,   0,  /* "baio" 29685 */
      9,  21,   4,   0,  /* "bair" 29689 */
      9,  39,  33,   0,  /* "baisch" 29693 */
      9,   2,  30,   0,  /* "baise" 29697 */
      9,   2,   3,   0,  /* "bait" 29701 */
      9,   2,   3,   1,  20,   0,  /* "baited" 29707 */
      9,   2,   3,  31,  32,   0,  /* "baiting" 29713 */
      9,   2,   3,  26,   0,  /* "baity" 29718 */
      9,  39,  29,   7,   0,  /* "baiul" 29723 */
      9,   2,  30,   0,  /* "baize" 29727 */
      9,   8,  38,   8,   0,  /* "baja" 29732 */
      9,  24,  40,  10,   5,  13,   0,  /* "bajarin" 29739 */
      9,  19,  41,   2,  17,   1,   0,  /* "bajema" 29746 */
      9,  24,  40,  10,  15,  12,   0,  /* "bajorek" 29753 */
      9,  24,  12,   0,  /* "bak" 29757 */
      9,   8,  12,   1,   0,  /* "baka" 29762 */
      9,  24,  12,   1,   7,  10,   0,  /* "bakalar" 29769 */
      9,   2,  12,   0,  /* "bake" 29773 */
      9,   2,  12,  10,  30,  37,  23,   7,  20,   0,  /* "bakersfield" 29783 */
      9,   2,  12,  47,  21,   7,   0,  /* "bakewell" 29790 */
      9,  24,  12,   4,  39,   0,  /* "bakrie" 29796 */
      9,  19,  12,  29,   0,  /* "baku" 29801 */
      9,   1,  12,  29,   7,   1,   0,  /* "bakula" 29808 */
      9,  24,   7,   0,  /* "bal" 29812 */
      9,   8,   7,   1,   0,  /* "bala" 29817 */
      9,  19,   7,  19,   9,   8,  13,   0,  /* "balaban" 29825 */
      9,   8,   7,   1,  12,  29,  17,   8,   4,   0,  /* "balakumar" 29835 */
      9,   2,   7,   1,  13,   0,  /* "balan" 29841 */
      9,  24,   7,   1,  14,   0,  /* "balas" 29847 */
      9,  24,   7,   1,   3,   1,   0,  /* "balata" 29854 */
      9,  18,   7,  31,  33,   0,  /* "balazs" 29860 */
      9,  19,   7,   9,  23,  13,   1,   0,  /* "balbina" 29868 */
      9,  19,   7,   9,  25,   1,   0,  /* "balboa" 29875 */
      9,  19,   7,   9,  25,  13,  26,   0,  /* "balboni" 29883 */
      9,  34,   7,   9,   4,   5,  11,   1,  13,   0,  /* "balbriggan" 29893 */
      9,  34,   7,   9,   4,   5,  11,   1,  13,  30,   0,  /* "balbriggans" 29904 */
      9,  34,   7,  14,  21,   4,   1,  47,   5,   3,  14,   0,  /* "balcerowicz" 29916 */
      9,   1,   7,  42,  44,  30,   1,  12,   0,  /* "balcerzak" 29925 */
      9,  24,   7,  12,  29,  13,   1,  30,   0,  /* "balchunas" 29934 */
      9,  24,   7,  12,   1,  13,  26,  30,   0,  /* "balconies" 29943 */
      9,  24,   7,  12,   1,  13,  26,   0,  /* "balcony" 29951 */
      9,  24,   7,  12,  36,   4,   0,  /* "balcor" 29958 */
      9,  18,   7,  20,   0,  /* "bald" 29963 */
      9,  19,   7,  20,  19,  14,   8,   4,  26,   0,  /* "baldassare" 29973 */
      9,  36,   7,  20,   1,  14,   8,   4,  26,   0,  /* "baldassarre" 29983 */
      9,  24,   7,  20,  52,  37,   0,  /* "baldauf" 29990 */
      9,  19,   7,  20,  28,  17,   8,   4,   0,  /* "baldemar" 29999 */
      9,  18,   7,  20,  10,   0,  /* "balder" 30005 */
      9,  24,   7,  20,  10,   1,  30,   0,  /* "balderas" 30013 */
      9,  18,   7,  20,  10,  20,  24,  33,   0,  /* "balderdash" 30022 */
      9,  19,   7,  20,  15,   4,   8,  17,   1,   0,  /* "balderrama" 30032 */
      9,  24,   7,  20,  10,  14,   1,  13,   0,  /* "balderson" 30041 */
      9,  24,   7,  20,  10,  14,   3,   1,  13,   0,  /* "balderston" 30051 */
      9,   8,   7,  20,  21,  30,   0,  /* "baldez" 30058 */
      9,   8,   7,  20,  26,   0,  /* "baldi" 30064 */
      9,  19,   7,  20,  23,  13,  26,   0,  /* "baldini" 30072 */
      9,  19,   7,  20,  23,  13,  27,   0,  /* "baldino" 30080 */
      9,  24,   7,  20,  13,  10,   0,  /* "baldner" 30087 */
      9,   8,   7,  20,  27,   0,  /* "baldo" 30093 */
      9,  24,   7,  20,   1,  12,   0,  /* "baldock" 30100 */
      9,  19,   7,  20,  27,  13,   8,  20,  27,   0,  /* "baldonado" 30110 */
      9,  18,   7,  20,  10,   0,  /* "baldor" 30116 */
      9,   1,   7,  20,   4,  23,   0,  /* "baldree" 30123 */
      9,  24,   7,  20,   4,  31,  12,   0,  /* "baldric" 30131 */
      9,  24,   7,  20,   4,  31,  40,   0,  /* "baldridge" 30139 */
      9,  19,   7,  20,  29,  42,  26,   0,  /* "balducci" 30147 */
      9,  19,   7,  20,  45,   4,   0,  /* "baldur" 30154 */
      9,   8,   7,  20,   1,  14,   0,  /* "baldus" 30161 */
      9,  18,   7,  20,  47,   1,  13,   0,  /* "baldwin" 30169 */
      9,   8,   7,  20,  26,  11,   1,   0,  /* "baldyga" 30177 */
      9,   2,   7,   0,  /* "bale" 30181 */
      9,   1,   7,  23,  13,   0,  /* "baleen" 30187 */
      9,   2,   7,  37,   1,   7,   0,  /* "baleful" 30194 */
      9,  19,   7,  15,  13,   3,  23,  13,  26,   0,  /* "balentine" 30204 */
      9,   1,   7,  21,  14,   3,   4,   1,   0,  /* "balestra" 30213 */
      9,  19,   7,  15,  14,   3,   4,   5,   4,  26,   0,  /* "balestrieri" 30224 */
      9,   8,   7,  37,  19,  13,  30,   0,  /* "balfanz" 30232 */
      9,  24,   7,  37,  36,   4,   0,  /* "balfour" 30239 */
      9,   8,   7,  26,   0,  /* "bali" 30244 */
      9,   2,   7,  26,   1,  13,   0,  /* "balian" 30251 */
      9,   1,   7,   5,   7,   1,  13,   0,  /* "balilan" 30259 */
      9,   1,   7,  23,   7,  15,  30,   0,  /* "baliles" 30267 */
      9,  24,   7,   1,  13,  23,  30,   0,  /* "balinese" 30275 */
      9,   2,   7,  31,  32,   0,  /* "baling" 30281 */
      9,   1,   7,   5,  13,  14,  12,  26,   0,  /* "balinski" 30290 */
      9,   8,   7,  26,  13,   3,   0,  /* "balint" 30297 */
      9,   8,   7,  26,  30,   0,  /* "balis" 30303 */
      9,  19,   7,  26,  14,   3,   4,  21,   4,  26,   0,  /* "balistreri" 30314 */
      9,  18,  12,   0,  /* "balk" 30318 */
      9,  18,   7,  12,   1,  13,  39,  30,   0,  /* "balkanize" 30327 */
      9,  18,   7,  12,   1,  13,  39,  30,  20,   0,  /* "balkanized" 30337 */
      9,  24,   7,  12,   1,  17,   0,  /* "balkcom" 30344 */
      9,   2,   7,  12,   0,  /* "balke" 30349 */
      9,  24,   7,  12,   5,  13,   0,  /* "balkin" 30356 */
      9,  18,   7,   0,  /* "ball" 30360 */
      9,  24,   7,   1,  20,   0,  /* "ballad" 30366 */
      9,   1,   7,   8,  20,   0,  /* "ballade" 30372 */
      9,  24,   7,   1,  20,  30,   0,  /* "ballads" 30379 */
      9,   8,   7,   1,  13,  14,   0,  /* "ballance" 30386 */
      9,  24,   7,   1,  13,   3,  39,  13,   0,  /* "ballantine" 30395 */
      9,   1,   7,  24,  13,   3,  39,  13,   0,  /* "ballantyne" 30404 */
      9,  24,   7,   1,  14,   3,   0,  /* "ballast" 30411 */
      9,  18,   7,  12,   7,   1,   9,   0,  /* "ballclub" 30419 */
      9,  18,   7,  12,  19,  12,   0,  /* "ballcock" 30426 */
      9,  18,   7,  12,  19,  12,  14,   0,  /* "ballcocks" 30434 */
      9,   2,   7,   0,  /* "balle" 30438 */
      9,  18,   7,  20,   0,  /* "balled" 30443 */
      9,   1,   7,  21,  32,  11,  26,   0,  /* "ballengee" 30451 */
      9,  24,   7,   1,  13,  40,  10,   0,  /* "ballenger" 30459 */
      9,  19,   7,  15,  13,   3,  23,  13,  26,   0,  /* "ballentine" 30469 */
      9,  18,   7,  10,   0,  /* "baller" 30474 */
      9,   2,   7,  30,   0,  /* "balles" 30479 */
      9,  24,   7,   1,  14,   3,  10,   0,  /* "ballester" 30487 */
      9,  24,   7,   1,  14,   3,  10,  27,  30,   0,  /* "ballesteros" 30497 */
      9,  34,   7,   2,   0,  /* "ballet" 30502 */
      9,  34,   7,   2,  30,   0,  /* "ballets" 30508 */
      9,  36,   7,  11,   2,  17,   0,  /* "ballgame" 30515 */
      9,  24,   7,  26,   1,   3,   0,  /* "balliet" 30522 */
      9,  24,   7,  23,   3,   0,  /* "balliett" 30528 */
      9,  18,   7,  31,  32,   0,  /* "balling" 30534 */
      9,  18,   7,   5,  13,  40,  10,   0,  /* "ballinger" 30542 */
      9,   1,   7,   5,  14,   3,  31,  12,   0,  /* "ballistic" 30551 */
      9,   1,   7,   5,  14,   3,  31,  12,  14,   0,  /* "ballistics" 30561 */
      9,  24,   7,  17,  10,   0,  /* "ballmer" 30567 */
      9,  24,   7,  27,   0,  /* "ballo" 30572 */
      9,  24,   7,   1,  13,   0,  /* "ballon" 30578 */
      9,   1,   7,  29,  13,   0,  /* "balloon" 30584 */
      9,   1,   7,  29,  13,  20,   0,  /* "ballooned" 30591 */
      9,   1,   7,  29,  13,  31,  32,   0,  /* "ballooning" 30599 */
      9,   1,   7,  29,  13,   1,  14,   3,   0,  /* "balloonist" 30608 */
      9,   1,   7,  29,  13,   1,  14,   3,  14,   0,  /* "balloonists" 30618 */
      9,   1,   7,  29,  13,  30,   0,  /* "balloons" 30625 */
      9,  18,   7,  10,   0,  /* "ballor" 30630 */
      9,  24,   7,   1,   3,   0,  /* "ballot" 30636 */
      9,  24,   7,   1,   3,  31,  32,   0,  /* "balloting" 30644 */
      9,  24,   7,   1,   3,  14,   0,  /* "ballots" 30651 */
      9,   1,   7,  29,   0,  /* "ballou" 30656 */
      9,  24,   7,  27,   0,  /* "ballow" 30661 */
      9,  24,   7,  52,   0,  /* "ballowe" 30666 */
      9,  18,   7,   6,   8,   4,  12,   0,  /* "ballpark" 30674 */
      9,  36,   7,   6,   7,   2,  10,  30,   0,  /* "ballplayers" 30683 */
      9,  18,   7,   6,  50,  13,   3,   0,  /* "ballpoint" 30691 */
      9,  18,   7,   6,  50,  13,   3,  14,   0,  /* "ballpoints" 30700 */
      9,  18,   7,   4,  29,  17,   0,  /* "ballroom" 30707 */
      9,  18,   7,   4,  29,  17,  30,   0,  /* "ballrooms" 30715 */
      9,  24,   7,  47,  31,  11,   0,  /* "ballweg" 30722 */
      9,  24,   7,  26,   0,  /* "bally" 30727 */
      9,  24,   7,  26,  38,  29,   0,  /* "ballyhoo" 30734 */
      9,  24,   7,  26,  38,  29,  20,   0,  /* "ballyhooed" 30742 */
      9,   8,  17,   0,  /* "balm" 30746 */
      9,   8,   7,  17,  15,  14,   0,  /* "balmes" 30753 */
      9,  34,   7,  17,  18,   4,   1,   7,   0,  /* "balmoral" 30762 */
      9,  34,   7,  17,  18,   4,   1,   7,  30,   0,  /* "balmorals" 30772 */
      9,   1,   7,  25,  20,  26,   1,   0,  /* "balodia" 30780 */
      9,  19,   7,  25,  11,   1,   0,  /* "baloga" 30787 */
      9,  24,   7,  27,   0,  /* "balogh" 30792 */
      9,  19,   7,  18,  13,   0,  /* "balon" 30798 */
      9,   1,   7,  25,  13,  26,   0,  /* "baloney" 30805 */
      9,  19,   7,  14,   8,  17,  27,   0,  /* "balsamo" 30813 */
      9,   2,   7,  14,  10,   0,  /* "balser" 30819 */
      9,  24,   7,  14,  31,  11,  10,   0,  /* "balsiger" 30827 */
      9,  24,   7,  14,   7,  26,   0,  /* "balsley" 30834 */
      9,  24,   7,  14,   3,  10,   0,  /* "balster" 30841 */
      9,  19,   7,   3,  19,  30,   8,   4,   0,  /* "baltazar" 30850 */
      9,   2,   7,   3,  14,   0,  /* "baltes" 30856 */
      9,  24,   7,  16,   1,  14,  10,   0,  /* "balthasar" 30864 */
      9,  24,   7,  16,   1,  30,  10,   0,  /* "balthazar" 30872 */
      9,  19,   7,  16,  19,  30,  18,   4,   0,  /* "balthazor" 30881 */
      9,  18,   7,   3,  31,  12,   0,  /* "baltic" 30888 */
      9,  18,   7,   3,  31,  12,  14,   0,  /* "baltics" 30896 */
      9,  19,   7,   3,   5,   4,   1,   0,  /* "baltierra" 30904 */
      9,  18,   7,   3,   1,  17,  18,   4,   0,  /* "baltimore" 30913 */
      9,  18,   7,   3,  27,  20,   8,  13,  27,   0,  /* "baltodano" 30923 */
      9,  18,   7,   3,  14,   1,   0,  /* "baltsa" 30930 */
      9,   1,   7,  29,  42,  26,   0,  /* "baluchi" 30937 */
      9,   1,   7,  29,  40,   1,   0,  /* "baluja" 30944 */
      9,   1,   7,  29,  12,   1,  30,   0,  /* "balukas" 30952 */
      9,  24,   7,  26,  24,   3,   0,  /* "balyeat" 30959 */
      9,  18,   7,  30,   0,  /* "balz" 30964 */
      9,  19,   7,  30,  19,   4,  23,  13,  26,   0,  /* "balzarini" 30974 */
      9,  24,  17,   0,  /* "bam" 30978 */
      9,  34,  17,   9,  21,  13,  15,  12,   0,  /* "bambenek" 30987 */
      9,  34,  17,   9,  29,   0,  /* "bamboo" 30993 */
      9,   2,  17,   0,  /* "bame" 30997 */
      9,  24,  13,   0,  /* "ban" 31001 */
      9,   1,  13,   8,  42,  26,   0,  /* "banacci" 31008 */
      9,  24,  13,   1,  12,   0,  /* "banach" 31014 */
      9,   1,  13,   8,   7,   0,  /* "banal" 31020 */
      9,  24,  13,   1,  17,  21,  12,  14,   0,  /* "banamex" 31029 */
      9,   1,  13,  24,  13,   1,   0,  /* "banana" 31036 */
      9,   1,  13,  24,  13,   1,  30,   0,  /* "bananas" 31044 */
      9,   1,  13,   8,  14,  26,  34,  12,   0,  /* "banasiak" 31053 */
      9,   1,  13,   8,  33,   1,  12,   0,  /* "banaszak" 31061 */
      9,  24,  32,  12,   0,  /* "banc" 31066 */
      9,  34,  13,  12,  21,   4,   0,  /* "bancaire" 31073 */
      9,  34,  13,  12,  21,   4,  26,  27,   0,  /* "bancario" 31082 */
      9,  34,  32,  12,   8,  12,   7,   1,  38,  25,  17,   1,   0,  /* "bancoklahoma" 31095 */
      9,  24,  32,  12,   1,  17,  10,   0,  /* "bancomer" 31103 */
      9,  24,  32,  12,  36,   4,   6,   0,  /* "bancorp" 31111 */
      9,  24,  13,  12,  18,   4,   6,  10,  28,  33,   1,  13,   0,  /* "bancorporation" 31124 */
      9,  24,  32,  12,   4,  36,  37,   3,   0,  /* "bancroft" 31133 */
      9,  24,  13,  12,  14,  10,  22,   0,  /* "bancserve" 31141 */
      9,  24,  32,  12,  33,  15,   4,  30,   0,  /* "bancshares" 31150 */
      9,  34,  32,  12,   3,  21,  12,  14,   1,  14,   0,  /* "banctexas" 31161 */
      9,  24,  13,  20,   0,  /* "band" 31166 */
      9,  24,  13,  20,  39,   0,  /* "bandai" 31172 */
      9,  24,  13,  20,  28,  20,   0,  /* "bandaid" 31179 */
      9,  24,  13,  20,  19,   4,   0,  /* "bandar" 31186 */
      9,  24,  13,  20,  26,  17,  10,   0,  /* "bandemer" 31194 */
      9,  34,  13,  20,  44,   1,  14,   0,  /* "banderas" 31202 */
      9,  24,  13,  20,  31,  12,  29,   3,  14,   0,  /* "bandicoots" 31212 */
      9,  24,  13,  20,   1,   3,   0,  /* "bandit" 31219 */
      9,  24,  13,  20,   1,   3,  14,   0,  /* "bandits" 31227 */
      9,  24,  13,  20,   7,  26,  20,  10,   0,  /* "bandleader" 31236 */
      9,  24,  13,  20,   7,  26,  20,  10,  30,   0,  /* "bandleaders" 31246 */
      9,  24,  13,  20,   1,   7,   5,   4,   0,  /* "bandolier" 31255 */
      9,  24,  13,  20,   1,   7,   5,   4,  30,   0,  /* "bandoliers" 31265 */
      9,  24,  13,  20,  48,   0,  /* "bandow" 31271 */
      9,  34,  13,  20,  33,  21,   7,   0,  /* "bandshell" 31279 */
      9,  19,  13,  20,  29,  42,  26,   0,  /* "banducci" 31287 */
      9,   2,  13,   0,  /* "bane" 31291 */
      9,   1,  13,  44,  40,  26,   0,  /* "banerjee" 31298 */
      9,   1,  13,  21,  14,   3,  27,   0,  /* "banesto" 31306 */
      9,  24,  13,   5,   3,   0,  /* "banet" 31312 */
      9,  24,  32,   0,  /* "bang" 31316 */
      9,  24,  32,  20,   0,  /* "banged" 31321 */
      9,  24,  32,  11,   1,  17,   1,  13,   0,  /* "bangemann" 31330 */
      9,   2,  32,  11,  10,   3,   0,  /* "bangert" 31337 */
      9,   2,  32,  11,  10,   3,  10,   0,  /* "bangerter" 31345 */
      9,  24,  32,  38,   8,   4,   3,   0,  /* "banghart" 31353 */
      9,  24,  32,  31,  32,   0,  /* "banging" 31359 */
      9,  24,  32,  31,  33,   0,  /* "bangish" 31365 */
      9,  34,  32,  12,   8,  12,   0,  /* "bangkok" 31372 */
      9,  24,  32,   7,   1,  20,  21,  33,   0,  /* "bangladesh" 31381 */
      9,  24,  32,   7,   1,  20,  21,  33,  26,   0,  /* "bangladeshi" 31391 */
      9,  24,  32,   7,   1,  20,  21,  33,  26,  30,   0,  /* "bangladeshis" 31402 */
      9,  24,  32,  11,   1,   7,   0,  /* "bangle" 31409 */
      9,   8,  32,  11,  27,   0,  /* "bango" 31415 */
      9,  24,  13,   0,  /* "banh" 31419 */
      9,   8,  13,  41,   1,   0,  /* "banja" 31425 */
      9,  24,  13,  40,  25,   0,  /* "banjo" 31431 */
      9,  24,  32,  12,   0,  /* "bank" 31436 */
      9,  24,  32,  12,   1,   9,   1,   7,   0,  /* "bankable" 31445 */
      9,  24,  32,  12,   1,  17,  21,   4,  31,  12,   1,   0,  /* "bankamerica" 31457 */
      9,  24,  32,  12,   1,   3,   7,  24,  13,   3,  31,  12,   0,  /* "bankatlantic" 31470 */
      9,  24,  13,  12,  23,   0,  /* "bankey" 31476 */
      9,   1,  32,  12,  18,  37,  14,  12,  26,   0,  /* "bankowski" 31486 */
      9,  24,  32,  12,   4,   1,   6,   3,  14,  26,   0,  /* "bankrupcty" 31497 */
      9,  24,  32,  12,   4,   1,   6,   3,  14,  26,  30,   0,  /* "bankruptcies" 31509 */
      9,  24,  32,  12,   4,   1,   6,  14,  26,   0,  /* "bankruptcy" 31519 */
      9,  24,  32,  12,   4,   1,   6,   3,   1,  20,   0,  /* "bankrupted" 31530 */
      9,  24,  32,  12,   4,   1,   6,  14,  26,   0,  /* "bankrutpcy" 31540 */
      9,  24,  32,  12,  33,  21,   4,  30,   0,  /* "bankshares" 31549 */
      9,  24,  32,  12,  22,  10,  39,  13,   0,  /* "bankverein" 31558 */
      9,  24,  32,  12,  47,  44,  42,  21,  14,   3,  10,   0,  /* "bankworcester" 31570 */
      9,  24,  13,   0,  /* "bann" 31574 */
      9,   8,  13,  27,  30,   0,  /* "banos" 31580 */
      9,   1,  13,  29,  13,   0,  /* "banoun" 31586 */
      9,  24,  13,   6,  19,  13,  14,   0,  /* "banponce" 31594 */
      9,  24,  32,  12,  47,   1,   3,   0,  /* "banquet" 31602 */
      9,  24,  32,  12,  47,   1,   3,  14,   0,  /* "banquets" 31611 */
      9,  24,  13,  30,   0,  /* "bans" 31616 */
      9,  19,  13,  14,  24,   7,   0,  /* "bansal" 31623 */
      9,  34,  13,  33,  23,   0,  /* "banshee" 31629 */
      9,  24,  13,   3,   1,  17,   0,  /* "bantam" 31636 */
      9,  24,  13,   3,   1,   7,   0,  /* "bantle" 31643 */
      9,  19,  13,  47,  21,   7,  27,  30,   0,  /* "banuelos" 31652 */
      9,   8,  13,  22,   5,   7,   0,  /* "banville" 31659 */
      9,  24,  13,  47,  18,   4,   3,   0,  /* "banwart" 31667 */
      9,  34,  32,  12,  14,  12,  47,  25,   3,   0,  /* "banxquote" 31677 */
      9,   8,  13,  41,   1,   0,  /* "banya" 31683 */
      9,  24,  13,  41,   1,   7,  29,  12,   1,   0,  /* "banyaluca" 31693 */
      9,   8,  13,  41,   1,  30,   0,  /* "banyas" 31700 */
      9,   8,  13,  29,   0,  /* "banyu" 31705 */
      9,  48,   0,  /* "bao" 31708 */
      9,   2,  27,  11,  47,  24,  32,   0,  /* "baoguang" 31716 */
      9,  24,   6,   7,  26,   0,  /* "bapley" 31722 */
      9,   8,   6,  13,   1,   0,  /* "bapna" 31728 */
      9,  24,   6,   3,   5,  30,   1,  17,   0,  /* "baptism" 31737 */
      9,  34,   6,   3,   5,  30,  17,   1,   7,   0,  /* "baptismal" 31747 */
      9,  24,   6,   3,   5,  30,   1,  17,  30,   0,  /* "baptisms" 31757 */
      9,  24,   6,   3,   5,  14,   3,   0,  /* "baptist" 31765 */
      9,  24,   6,   3,   5,  14,   3,   1,   0,  /* "baptista" 31774 */
      9,   1,   6,   3,   5,  14,   3,   0,  /* "baptiste" 31782 */
      9,  24,   6,   3,   1,  14,   3,   4,  26,   0,  /* "baptistery" 31792 */
      9,  34,   6,   3,  39,  30,   0,  /* "baptize" 31799 */
      9,  34,   6,   3,  39,  30,  20,   0,  /* "baptized" 31807 */
      9,   8,   4,   0,  /* "bar" 31811 */
      9,   8,   4,   1,   0,  /* "bara" 31816 */
      9,  21,   4,   1,   9,  19,   4,   0,  /* "barabar" 31824 */
      9,   1,   4,   8,  12,   0,  /* "barach" 31830 */
      9,  19,   4,   8,  37,   0,  /* "baraff" 31836 */
      9,  19,   4,   8,  41,  19,  30,   0,  /* "barajas" 31844 */
      9,   8,   4,   1,  12,   0,  /* "barak" 31850 */
      9,   8,   4,   1,  12,   8,   3,   0,  /* "barakat" 31858 */
      9,  21,   4,  34,  17,   0,  /* "baram" 31864 */
      9,  19,   4,   8,  13,   0,  /* "baran" 31870 */
      9,  24,   4,   1,  13,  31,  12,   0,  /* "baranek" 31878 */
      9,  10,   1,  13,  48,  14,  12,  26,   0,  /* "baranoski" 31887 */
      9,  10,  18,  13,  26,   0,  /* "barany" 31893 */
      9,  24,   4,  31,  33,   0,  /* "barasch" 31899 */
      9,  24,   4,  31,  33,   0,  /* "barash" 31905 */
      9,  24,   4,   1,  16,   0,  /* "barath" 31911 */
      9,   8,   4,   9,   0,  /* "barb" 31916 */
      9,  19,   4,   9,   2,  20,  27,  14,   0,  /* "barbados" 31925 */
      9,   8,   4,   9,   1,  12,  48,   0,  /* "barbakow" 31933 */
      9,   8,   4,   9,   1,  13,   1,   7,   0,  /* "barbanel" 31942 */
      9,  19,   4,   9,   8,  13,  27,   0,  /* "barbano" 31950 */
      9,   8,   4,   9,  10,   1,   0,  /* "barbara" 31957 */
      9,   8,   4,   9,  10,  26,   0,  /* "barbaree" 31964 */
      9,  19,   4,   9,  21,   4,  26,   1,  13,   0,  /* "barbarian" 31974 */
      9,  19,   4,   9,  21,   4,  26,   1,  13,  30,   0,  /* "barbarians" 31985 */
      9,  19,   4,   9,  24,   4,  31,  12,   0,  /* "barbaric" 31994 */
      9,  19,   4,   9,  19,   4,  23,  13,  27,   0,  /* "barbarino" 32004 */
      9,   8,   4,   9,  10,   5,  30,   1,  17,   0,  /* "barbarism" 32014 */
      9,  19,   4,   9,  24,   4,   1,   3,  26,   0,  /* "barbarity" 32024 */
      9,  19,   4,   9,   8,   4,  27,   0,  /* "barbaro" 32032 */
      9,   8,   4,   9,  24,  33,   0,  /* "barbash" 32039 */
      9,  19,   4,   9,   8,   3,  27,   0,  /* "barbato" 32047 */
      9,  19,   4,   9,  25,   0,  /* "barbeau" 32053 */
      9,   8,   4,   9,  31,  12,  41,  29,   0,  /* "barbecue" 32062 */
      9,   8,   4,   9,  31,  12,  41,  29,  20,   0,  /* "barbecued" 32072 */
      9,   8,   4,   9,  31,  12,  41,  29,  31,  32,   0,  /* "barbecueing" 32083 */
      9,   8,   4,   9,  31,  12,  41,  29,  30,   0,  /* "barbecues" 32093 */
      9,   8,   4,   9,  26,   0,  /* "barbee" 32099 */
      9,   8,   4,   9,  21,   7,   0,  /* "barbell" 32106 */
      9,   8,   4,   9,  31,  12,  41,  29,   0,  /* "barbeque" 32115 */
      9,   8,   4,   9,  31,  12,  41,  29,  20,   0,  /* "barbequed" 32125 */
      9,   8,   4,   9,  31,  12,  41,  29,  31,  32,   0,  /* "barbequeing" 32136 */
      9,   8,   4,   9,  31,  12,  41,  29,  30,   0,  /* "barbeques" 32146 */
      9,  19,   4,   9,  21,   4,   1,   0,  /* "barbera" 32154 */
      9,  19,   4,   9,  21,   4,  26,   0,  /* "barberi" 32162 */
      9,   8,   4,   9,  23,   4,  26,  27,   0,  /* "barberio" 32171 */
      9,   8,   4,   9,  10,   5,  14,   0,  /* "barberis" 32179 */
      9,  19,   4,   9,  21,   4,  27,   0,  /* "barbero" 32187 */
      9,  19,   4,   9,  21,   3,   0,  /* "barbette" 32194 */
      9,   8,   4,   9,  26,   1,  13,   0,  /* "barbian" 32202 */
      9,   8,   4,   9,  26,   0,  /* "barbie" 32208 */
      9,   8,   4,   9,  26,  10,   0,  /* "barbier" 32215 */
      9,   8,   4,   9,  26,  30,   0,  /* "barbies" 32222 */
      9,   8,   4,   9,   5,  13,   0,  /* "barbin" 32229 */
      9,  19,   4,   9,   5,  42,  10,   1,   3,   0,  /* "barbiturate" 32239 */
      9,  19,   4,   9,   5,  42,  10,   1,   3,  14,   0,  /* "barbiturates" 32250 */
      9,  19,   4,   9,  25,  14,   1,   0,  /* "barbosa" 32258 */
      9,   8,   4,   9,  10,   0,  /* "barbour" 32264 */
      9,  19,   4,   9,  25,  30,   1,   0,  /* "barboza" 32272 */
      9,  19,   4,  14,  21,   7,  27,  30,   0,  /* "barcellos" 32281 */
      9,  19,   4,  42,  21,   7,  27,   0,  /* "barcelo" 32289 */
      9,   8,   4,  12,   0,  /* "barch" 32294 */
      9,  19,  42,  21,  37,  14,  12,  26,   0,  /* "barchefsky" 32303 */
      9,   8,   4,  42,   1,   0,  /* "barcia" 32309 */
      9,   8,   4,  12,   7,  26,  30,   0,  /* "barclays" 32317 */
      9,   8,   4,  20,   0,  /* "bard" 32322 */
      9,  19,   4,  20,  21,   7,   0,  /* "bardell" 32329 */
      9,   8,   4,  20,  25,   7,  37,   0,  /* "bardolf" 32337 */
      9,   8,   4,  20,  19,   7,  37,   0,  /* "bardolph" 32345 */
      9,  19,   4,  20,  18,  13,   0,  /* "bardon" 32352 */
      9,  21,   4,   0,  /* "bare" 32356 */
      9,  24,   4,   1,  37,  26,   7,  20,   0,  /* "barefield" 32365 */
      9,  24,   4,  39,  30,   0,  /* "bareis" 32371 */
      9,  21,   4,   7,  26,   0,  /* "barely" 32377 */
      9,  19,   4,  15,  13,   3,  23,  13,  26,   0,  /* "barentine" 32387 */
      9,  21,   4,   1,  14,   3,   0,  /* "barest" 32394 */
      9,   8,   4,  37,  12,   1,  13,  15,  12,   3,   0,  /* "barfknecht" 32405 */
      9,   8,   4,  11,   0,  /* "barg" 32410 */
      9,  19,   4,  11,   8,   4,   0,  /* "bargar" 32417 */
      9,   8,   4,  11,   1,  30,   0,  /* "bargas" 32424 */
      9,   8,   4,  40,  20,   0,  /* "barged" 32430 */
      9,   8,   4,  40,  10,   0,  /* "barger" 32436 */
      9,   8,   4,  11,  10,   1,  13,   0,  /* "bargeron" 32444 */
      9,   8,   4,  40,   1,  30,   0,  /* "barges" 32451 */
      9,   8,   4,  11,  25,   0,  /* "bargo" 32457 */
      9,   8,   4,  26,   0,  /* "bari" 32462 */
      9,  24,   4,   1,   9,  27,   0,  /* "baribeau" 32469 */
      9,   8,   4,   1,   7,   0,  /* "barile" 32475 */
      9,  21,   4,   1,   7,  21,   4,  26,   0,  /* "barillari" 32484 */
      9,  10,   5,   7,  27,   0,  /* "barillo" 32490 */
      9,  10,   5,  32,  12,  25,   0,  /* "barinco" 32497 */
      9,   8,   4,  26,  30,   0,  /* "baris" 32503 */
      9,  21,   4,  39,   3,   0,  /* "barite" 32509 */
      9,  21,   4,  39,   3,  14,   0,  /* "barites" 32516 */
      9,   8,   4,  12,   0,  /* "bark" 32521 */
      9,  19,   4,  12,  39,   0,  /* "barkai" 32527 */
      9,   8,   4,  12,   1,   7,  25,   0,  /* "barkalow" 32535 */
      9,   8,   4,  12,  20,   1,   7,   0,  /* "barkdull" 32543 */
      9,   8,   4,  12,   7,  26,   0,  /* "barkeley" 32550 */
      9,   8,   4,  12,   5,   3,   0,  /* "barkett" 32557 */
      9,   8,   4,  12,  23,   0,  /* "barkey" 32563 */
      9,   8,   4,  12,   7,  25,   0,  /* "barklow" 32570 */
      9,   8,   4,  12,   1,  14,  26,   0,  /* "barkocy" 32578 */
      9,   8,   4,  12,  33,  39,   4,   0,  /* "barkshire" 32586 */
      9,   8,   4,   7,  31,  40,   0,  /* "barlage" 32593 */
      9,   8,   4,   7,   5,   3,   0,  /* "barlett" 32600 */
      9,  19,   4,   7,  21,   3,   1,   0,  /* "barletta" 32608 */
      9,   8,   4,   7,   1,   3,  14,  22,   5,   7,   0,  /* "barlettesville" 32619 */
      9,  19,   4,   7,  29,  13,   0,  /* "barloon" 32626 */
      9,   8,   4,   7,  25,   0,  /* "barlow" 32632 */
      9,   8,   4,  17,  36,   4,   0,  /* "barmore" 32639 */
      9,   8,   4,  13,   0,  /* "barn" 32644 */
      9,   8,   4,  13,   1,   9,   1,  14,   0,  /* "barnabas" 32653 */
      9,   8,   4,  13,   1,  12,   1,   7,   0,  /* "barnacle" 32662 */
      9,   8,   4,  13,   1,  12,   1,   7,  30,   0,  /* "barnacles" 32672 */
      9,   8,   4,  13,  10,   4,  20,   0,  /* "barnard" 32680 */
      9,   8,   4,  13,  15,   3,   0,  /* "barnet" 32687 */
      9,  19,   4,  13,  21,   3,   0,  /* "barnett" 32694 */
      9,  19,   4,  13,  21,  22,  31,  12,   0,  /* "barnevik" 32703 */
      9,   8,   4,  13,  38,   8,   4,  20,   0,  /* "barnhard" 32712 */
      9,   8,   4,  13,  38,   8,   4,   3,   0,  /* "barnhardt" 32721 */
      9,   8,   4,  13,  31,  12,   1,   7,   0,  /* "barnicle" 32730 */
      9,   8,   4,  13,  31,  33,   0,  /* "barnish" 32737 */
      9,  19,   4,  13,  48,  14,  12,  26,   0,  /* "barnowski" 32746 */
      9,   8,   4,  27,   0,  /* "baro" 32751 */
      9,  24,   4,   1,  17,  21,   3,   4,  31,  12,   0,  /* "barometric" 32762 */
      9,  10,  25,  13,   0,  /* "barone" 32767 */
      9,  21,   4,   1,  13,  15,  14,   0,  /* "baroness" 32775 */
      9,  21,   4,   1,  13,   1,   3,   0,  /* "baronet" 32783 */
      9,  21,   4,   1,  13,   1,   3,  14,   0,  /* "baronets" 32792 */
      9,  19,   4,  25,  13,  26,   0,  /* "baroni" 32799 */
      9,  10,  29,  20,  26,   0,  /* "baroody" 32805 */
      9,  10,  25,  12,   0,  /* "baroque" 32810 */
      9,   8,   4,  27,  30,   0,  /* "baros" 32816 */
      9,  21,   4,   1,  22,  31,  12,   0,  /* "barovic" 32824 */
      9,   8,   4,   0,  /* "barr" 32828 */
      9,   8,   4,   1,   0,  /* "barra" 32833 */
      9,  24,   4,   1,  12,  14,   0,  /* "barracks" 32840 */
      9,  19,   4,   8,  12,  27,   0,  /* "barraco" 32847 */
      9,  21,   4,   1,  12,  29,  20,   1,   0,  /* "barracuda" 32856 */
      9,  21,   4,   1,  20,  23,  13,  27,   0,  /* "barradino" 32865 */
      9,  21,   4,   1,  11,   1,  13,   0,  /* "barragan" 32873 */
      9,  10,   8,  43,   0,  /* "barrage" 32878 */
      9,  10,   8,  43,  20,   0,  /* "barraged" 32884 */
      9,  10,   8,  43,   1,  30,   0,  /* "barrages" 32891 */
      9,  19,   4,   8,  13,  12,  27,   0,  /* "barranco" 32899 */
      9,   8,   4,   8,  14,  27,   0,  /* "barrasso" 32906 */
      9,   8,   4,   8,  30,   1,   0,  /* "barraza" 32913 */
      9,  21,   4,  26,   0,  /* "barre" 32918 */
      9,   8,   4,  21,  12,   1,   0,  /* "barreca" 32925 */
      9,   8,   4,  20,   0,  /* "barred" 32930 */
      9,  19,   4,   2,  20,   1,   0,  /* "barreda" 32937 */
      9,  19,   4,  21,   4,  27,   0,  /* "barreiro" 32944 */
      9,  19,   4,   2,   7,   0,  /* "barrell" 32950 */
      9,  24,   4,   1,  13,   3,  39,  13,   0,  /* "barrentine" 32959 */
      9,   8,   4,  21,   4,   1,   0,  /* "barrera" 32966 */
      9,  19,   4,  21,   4,  19,  30,   0,  /* "barreras" 32974 */
      9,   8,   4,  30,   0,  /* "barres" 32979 */
      9,   8,   4,  21,  14,  26,   0,  /* "barresi" 32986 */
      9,  24,   4,   5,   3,   0,  /* "barret" 32992 */
      9,  19,   4,  21,   3,  27,   0,  /* "barreto" 32999 */
      9,  24,   4,   5,   3,   0,  /* "barrett" 33005 */
      9,  19,   4,  21,   3,   1,   0,  /* "barretta" 33012 */
      9,  10,  21,   3,   0,  /* "barrette" 33017 */
      9,  19,   4,  21,   3,  27,   0,  /* "barretto" 33024 */
      9,   8,   4,  31,  12,   8,  20,   1,   0,  /* "barricada" 33033 */
      9,  10,  23,  13,   3,  14,   0,  /* "barrientes" 33040 */
      9,  19,   4,  23,  13,   3,  15,  30,   0,  /* "barrientez" 33049 */
      9,  19,   4,  23,  13,   3,  27,  30,   0,  /* "barrientos" 33058 */
      9,  19,   4,   5,   4,  26,   0,  /* "barriere" 33065 */
      9,   8,   4,  23,  11,   1,   0,  /* "barriga" 33072 */
      9,  24,   4,  31,  11,  10,   0,  /* "barriger" 33079 */
      9,  24,   4,   1,   7,  25,   0,  /* "barrilleaux" 33086 */
      9,   8,   4,  31,  32,   0,  /* "barring" 33092 */
      9,   8,   4,  31,  32,  30,   0,  /* "barrings" 33099 */
      9,   8,   4,  26,  27,   0,  /* "barrio" 33105 */
      9,  19,   4,  23,  27,  30,   0,  /* "barrios" 33112 */
      9,  24,   4,  31,  33,   0,  /* "barrish" 33118 */
      9,  10,   5,   3,   0,  /* "barritt" 33123 */
      9,  24,   4,   1,  13,   0,  /* "barron" 33129 */
      9,  10,  25,  13,   0,  /* "barrone" 33134 */
      9,   8,   4,   4,  29,  17,   0,  /* "barroom" 33141 */
      9,  24,   4,  27,   0,  /* "barrow" 33146 */
      9,  24,   4,  27,  17,   1,  13,   0,  /* "barrowman" 33154 */
      9,  24,   4,  27,  30,   0,  /* "barrows" 33160 */
      9,  24,   4,   1,  14,   0,  /* "barrus" 33166 */
      9,  24,   4,  26,   0,  /* "barry" 33171 */
      9,  24,   4,  26,  17,  18,   4,   0,  /* "barrymore" 33179 */
      9,   8,   4,  30,   0,  /* "bars" 33184 */
      9,  19,   4,  14,   8,  13,   3,  26,   0,  /* "barsanti" 33193 */
      9,  19,   4,  14,  25,   3,  26,   0,  /* "barsotti" 33201 */
      9,   8,   4,  14,   3,  25,   0,  /* "barstow" 33208 */
      9,   8,   4,  33,  42,   0,  /* "barszcz" 33214 */
      9,   8,   4,   3,   0,  /* "bart" 33219 */
      9,   8,   4,   3,   1,   0,  /* "barta" 33225 */
      9,   8,   4,   3,   1,  12,   0,  /* "bartak" 33232 */
      9,   8,   4,   3,   1,   7,   0,  /* "bartel" 33239 */
      9,  19,   4,   3,   2,   7,   0,  /* "bartell" 33246 */
      9,   8,   4,  16,  21,   7,   1,  17,  26,   0,  /* "barthelemy" 33256 */
      9,   8,   4,  16,  14,   0,  /* "barthes" 33262 */
      9,  19,   4,  16,   1,   7,   8,  17,  28,   0,  /* "bartholomay" 33272 */
      9,  19,   4,  16,   8,   7,   1,  17,  41,  29,   0,  /* "bartholomew" 33283 */
      9,  10,   3,  12,  48,  26,  34,  12,   0,  /* "bartkowiak" 33292 */
      9,  10,   3,  12,  18,  37,  14,  12,  26,   0,  /* "bartkowski" 33302 */
      9,   8,   4,   3,   1,   7,   0,  /* "bartl" 33309 */
      9,   8,   4,   3,   1,   7,   0,  /* "bartle" 33316 */
      9,   8,   4,   3,   1,   7,   9,  36,   0,  /* "bartlebaugh" 33325 */
      9,   8,   4,   3,   1,   7,  30,   0,  /* "bartles" 33333 */
      9,   8,   4,   3,   1,   7,  14,   1,  13,   0,  /* "bartleson" 33343 */
      9,   8,   4,   3,   1,   7,  30,  22,   5,   7,   0,  /* "bartlesville" 33354 */
      9,   8,   4,   3,  17,  15,  14,   0,  /* "bartmess" 33362 */
      9,  10,   3,  13,   5,   3,  14,  12,  26,   0,  /* "bartnicki" 33372 */
      9,   8,   4,   3,  27,   0,  /* "barto" 33378 */
      9,   8,   4,   3,   1,  12,   0,  /* "bartok" 33385 */
      9,   8,   4,   3,   1,   7,   0,  /* "bartol" 33392 */
      9,  19,   4,   3,  27,   7,  27,  17,   2,  26,   0,  /* "bartolomei" 33403 */
      9,  19,   4,   3,  36,   7,   1,  17,   2,  27,   0,  /* "bartolomeo" 33414 */
      9,  19,   4,   3,  27,   7,  29,  42,  26,   0,  /* "bartolucci" 33424 */
      9,   8,   4,   3,   1,  13,   0,  /* "barton" 33431 */
      9,  19,   4,   3,  25,  13,  26,   0,  /* "bartone" 33439 */
      9,   8,   4,  42,  29,   0,  /* "bartoo" 33445 */
      9,   8,   4,   3,  27,  30,   0,  /* "bartos" 33452 */
      9,   8,   4,   3,  36,  33,   0,  /* "bartosch" 33459 */
      9,   8,   4,   3,  31,  33,   0,  /* "bartosh" 33466 */
      9,  10,   3,   8,  14,   1,  22,  31,  42,   0,  /* "bartosiewicz" 33476 */
      9,  10,   3,  25,  14,  31,  12,   0,  /* "bartosik" 33484 */
      9,  10,   3,   8,  33,  15,  12,   0,  /* "bartoszek" 33492 */
      9,   8,   4,   3,  25,   0,  /* "bartow" 33498 */
      9,   8,   4,   3,   1,  13,  31,  12,   0,  /* "bartunek" 33507 */
      9,   8,   4,  29,  12,   0,  /* "baruch" 33513 */
      9,   8,   4,  47,   5,  12,   0,  /* "barwick" 33520 */
      9,  10,   5,  33,  13,  31,  12,   8,  22,   0,  /* "baryshnikov" 33530 */
      9,   8,   4,  30,   0,  /* "barz" 33535 */
      9,   8,  14,   1,   0,  /* "basa" 33540 */
      9,   2,  14,   1,   7,   0,  /* "basal" 33546 */
      9,  19,  14,  19,   7,  20,  29,   1,   0,  /* "basaldua" 33555 */
      9,   1,  14,  18,   7,   3,  14,   0,  /* "basalts" 33563 */
      9,   1,  14,  21,   4,   1,   0,  /* "basara" 33570 */
      9,  24,  14,  19,  41,  21,  22,   0,  /* "basayev" 33578 */
      9,  24,  14,  12,  28,   0,  /* "bascay" 33584 */
      9,   8,  14,  12,  27,   0,  /* "basco" 33590 */
      9,   2,  14,   0,  /* "base" 33594 */
      9,   2,  14,   9,  36,   7,   0,  /* "baseball" 33601 */
      9,   2,  14,   9,  36,   7,  30,   0,  /* "baseballs" 33609 */
      9,  24,  14,  38,  36,   4,   0,  /* "basehore" 33616 */
      9,   8,  30,   1,   7,   0,  /* "basel" 33622 */
      9,   2,  14,   7,   1,  14,   0,  /* "baseless" 33629 */
      9,   2,  14,   7,  39,  13,   0,  /* "baseline" 33636 */
      9,  24,  33,   0,  /* "bash" 33640 */
      9,   8,  33,   1,   0,  /* "basha" 33645 */
      9,  31,  33,  18,   0,  /* "bashaw" 33650 */
      9,  31,  33,   5,   4,   0,  /* "bashir" 33656 */
      9,  24,  33,  10,   0,  /* "bashore" 33661 */
      9,   8,  14,   5,  38,   0,  /* "basich" 33667 */
      9,   2,  30,  26,   0,  /* "basie" 33672 */
      9,  24,  30,   1,   7,   0,  /* "basil" 33678 */
      9,   8,  14,   1,   7,   0,  /* "basile" 33684 */
      9,  19,  14,  23,   7,  26,   1,   0,  /* "basilia" 33692 */
      9,   1,  30,   5,   7,   1,  12,   1,   0,  /* "basilica" 33701 */
      9,  19,  14,  23,   7,  26,  27,   0,  /* "basilio" 33709 */
      9,   2,  14,   1,  13,   0,  /* "basin" 33715 */
      9,   2,  14,  31,  32,  10,   0,  /* "basinger" 33722 */
      9,   2,  14,   1,  13,  30,   0,  /* "basins" 33729 */
      9,   1,  14,   5,  13,  14,  12,  26,   0,  /* "basinski" 33738 */
      9,   2,  14,   5,  14,   0,  /* "basis" 33744 */
      9,   1,  14,   5,  14,   3,   1,   0,  /* "basista" 33752 */
      9,   2,  14,  31,  12,  14,   0,  /* "basix" 33759 */
      9,  24,  14,  12,   0,  /* "bask" 33764 */
      9,   1,  14,  12,  21,   3,   0,  /* "baskette" 33771 */
      9,  24,  14,   1,   7,   0,  /* "basle" 33777 */
      9,   2,  30,   1,   7,  10,   0,  /* "basler" 33784 */
      9,  24,  30,  13,  39,   3,   0,  /* "basnight" 33791 */
      9,  19,  14,  18,   4,  26,   0,  /* "basore" 33798 */
      9,  24,  14,  12,   0,  /* "basque" 33803 */
      9,  24,  14,  12,  14,   0,  /* "basques" 33809 */
      9,  19,  14,  12,  47,  21,  30,   0,  /* "basquez" 33817 */
      9,   8,  14,   4,  19,   0,  /* "basra" 33823 */
      9,  24,  14,   0,  /* "bass" 33827 */
      9,  24,  14,   1,  17,   0,  /* "bassam" 33833 */
      9,   1,  14,  21,   3,   0,  /* "bassette" 33839 */
      9,  19,  14,  21,   3,  26,   0,  /* "bassetti" 33846 */
      9,  24,  14,  37,  10,  20,   0,  /* "bassford" 33853 */
      9,  24,  33,   1,  17,   0,  /* "bassham" 33859 */
      9,  24,  14,   5,  13,  40,  10,   0,  /* "bassinger" 33867 */
      9,   1,  14,   5,   4,   0,  /* "bassir" 33873 */
      9,   2,  14,   5,  14,   3,   0,  /* "bassist" 33880 */
      9,   2,  14,   5,  14,   3,  14,   0,  /* "bassists" 33888 */
      9,  24,  14,  17,   1,  13,   0,  /* "bassman" 33895 */
      9,  24,  14,  27,   0,  /* "basso" 33900 */
      9,   1,  14,  29,  13,   0,  /* "bassoon" 33906 */
      9,  24,  14,   3,   0,  /* "bast" 33911 */
      9,  19,  14,   3,   8,   4,  28,  12,   0,  /* "bastarache" 33920 */
      9,  19,  14,   3,   2,  20,  27,   0,  /* "bastedo" 33928 */
      9,   2,  14,   3,   1,  13,   0,  /* "basten" 33935 */
      9,  24,  14,   3,  25,  13,   0,  /* "bastogne" 33942 */
      9,   8,  14,   3,  27,  13,   0,  /* "bastone" 33949 */
      9,  24,  14,   3,  27,   0,  /* "bastow" 33955 */
      9,   2,  14,   3,  31,   4,   0,  /* "bastyr" 33962 */
      9,   8,  14,  29,   0,  /* "basu" 33967 */
      9,   1,  14,  35,   7,   3,  27,   0,  /* "basulto" 33975 */
      9,  19,  14,  45,   4,   3,  27,   0,  /* "basurto" 33983 */
      9,  24,  14,  47,  15,   7,   0,  /* "baswell" 33990 */
      9,  24,  14,  39,   0,  /* "basye" 33995 */
      9,  24,   3,   0,  /* "bat" 33999 */
      9,   1,   3,   8,  13,   0,  /* "bataan" 34005 */
      9,   1,   3,   8,   3,   0,  /* "batat" 34011 */
      9,   1,   3,   2,  22,  26,   1,   0,  /* "batavia" 34019 */
      9,  24,  42,   1,   7,  10,   0,  /* "batcheller" 34026 */
      9,   2,   3,   0,  /* "bate" 34030 */
      9,  24,   3,  14,   1,  13,   0,  /* "bateson" 34037 */
      9,  24,  16,   0,  /* "bath" 34041 */
      9,  24,  46,  10,   0,  /* "bather" 34046 */
      9,  24,  46,  10,  30,   0,  /* "bathers" 34052 */
      9,   2,  46,  31,  32,   0,  /* "bathing" 34058 */
      9,  24,  16,   4,  31,  12,   0,  /* "bathrick" 34065 */
      9,  24,  16,   4,  29,  17,   0,  /* "bathroom" 34072 */
      9,  24,  16,   4,  29,  17,  30,   0,  /* "bathrooms" 34080 */
      9,  24,  16,  14,   0,  /* "baths" 34085 */
      9,  24,  16,  30,   0,  /* "baths" 34090 */
      9,  34,  16,  33,  23,   9,   1,   0,  /* "bathsheba" 34098 */
      9,  24,  16,   3,   1,   9,   0,  /* "bathtub" 34105 */
      9,  24,   3,   5,  13,  41,  25,   7,   1,  14,   0,  /* "batignolles" 34116 */
      9,   1,   3,  23,  12,   0,  /* "batik" 34122 */
      9,  24,   3,  31,  12,  14,   0,  /* "batiks" 34129 */
      9,   1,   3,   5,  14,   3,   1,   0,  /* "batista" 34137 */
      9,  24,   3,  17,  24,  13,   0,  /* "batman" 34144 */
      9,  24,   3,  27,  11,  48,  14,  12,  26,   0,  /* "batogowski" 34154 */
      9,   1,   3,   8,  13,   0,  /* "baton" 34160 */
      9,  34,   3,   8,  13,  30,   0,  /* "batons" 34167 */
      9,  19,   3,  18,   4,   0,  /* "bator" 34173 */
      9,   2,   3,  10,  30,   0,  /* "batres" 34179 */
      9,  24,   3,  14,   0,  /* "bats" 34184 */
      9,  24,   3,   0,  /* "batt" 34188 */
      9,  19,   3,   8,  11,   7,  26,   1,   0,  /* "battaglia" 34197 */
      9,  19,   3,  19,  11,   7,  23,  13,  26,   0,  /* "battaglini" 34207 */
      9,   1,   3,  24,   7,  41,   1,  13,   0,  /* "battalion" 34216 */
      9,   1,   3,  24,   7,  41,   1,  13,  30,   0,  /* "battalions" 34226 */
      9,   1,   3,  21,   7,   0,  /* "battelle" 34232 */
      9,  24,   3,   1,  13,   9,  44,  11,   0,  /* "battenberg" 34241 */
      9,  24,   3,  10,  20,   0,  /* "battered" 34247 */
      9,  24,   3,  10,  10,   0,  /* "batterer" 34253 */
      9,  24,   3,  10,  10,  30,   0,  /* "batterers" 34260 */
      9,  24,   3,  10,  26,   0,  /* "battery" 34266 */
      9,   1,   3,  21,   4,  26,  17,  19,   4,  42,   0,  /* "batterymarch" 34277 */
      9,  24,   3,  31,  12,   1,   7,  25,   1,   0,  /* "batticaloa" 34287 */
      9,  24,   3,   5,  13,   0,  /* "battin" 34293 */
      9,  24,   3,  31,  32,   0,  /* "batting" 34299 */
      9,  24,   3,   1,   6,  24,  11,   7,  26,   1,   0,  /* "battipaglia" 34310 */
      9,  24,   3,   5,  14,   0,  /* "battis" 34316 */
      9,  24,   3,   1,  14,   1,  13,   0,  /* "battison" 34324 */
      9,   1,   3,  23,  14,   3,   1,   0,  /* "battista" 34332 */
      9,  19,   3,  23,  14,   3,  26,   0,  /* "battiste" 34340 */
      9,  19,   3,  23,  14,   3,  26,   0,  /* "battisti" 34348 */
      9,  24,   3,   1,   7,   0,  /* "battle" 34354 */
      9,  24,   3,   1,   7,  20,   0,  /* "battled" 34361 */
      9,  24,   3,   1,   7,  37,  23,   7,  20,   0,  /* "battlefield" 34371 */
      9,  24,   3,   1,   7,  37,  23,   7,  20,  30,   0,  /* "battlefields" 34382 */
      9,  24,   3,   1,   7,  37,   4,  35,  13,   3,   0,  /* "battlefront" 34393 */
      9,  24,   3,   1,   7,  11,   4,  48,  13,  20,   0,  /* "battleground" 34404 */
      9,  24,   3,   1,   7,  11,   4,  48,  13,  20,  30,   0,  /* "battlegrounds" 34416 */
      9,  24,   3,   1,   7,  17,   1,  13,   3,   0,  /* "battlement" 34426 */
      9,  24,   3,   1,   7,  17,   1,  13,   3,  14,   0,  /* "battlements" 34437 */
      9,  24,   3,   1,   7,  30,   0,  /* "battles" 34444 */
      9,  24,   3,   1,   7,  33,   5,   6,   0,  /* "battleship" 34453 */
      9,  24,   3,   1,   7,  33,   5,   6,  14,   0,  /* "battleships" 34463 */
      9,  24,   3,   1,   7,  31,  32,   0,  /* "battling" 34471 */
      9,  24,   3,  14,   0,  /* "batts" 34476 */
      9,  24,  42,  29,  23,  11,   1,  14,   0,  /* "batuigas" 34485 */
      9,   2,   3,  26,   0,  /* "baty" 34490 */
      9,  24,   3,  14,   0,  /* "batz" 34495 */
      9,   2,   3,  30,  10,   0,  /* "batzer" 34501 */
      9,  18,   9,   1,   7,   0,  /* "bauble" 34507 */
      9,  18,   9,   1,   7,  30,   0,  /* "baubles" 34514 */
      9,  27,  12,   8,  17,   0,  /* "baucom" 34520 */
      9,  27,  12,  35,  17,   0,  /* "baucum" 34526 */
      9,  18,  20,   0,  /* "baud" 34530 */
      9,  48,  20,   1,  13,  20,   5,  14,   3,   1,   7,   0,  /* "baudendistel" 34542 */
      9,  27,  20,  47,   8,  28,  13,   0,  /* "baudoin" 34550 */
      9,  36,  20,  29,   5,  13,   0,  /* "baudouin" 34557 */
      9,  48,  10,   1,   7,   0,  /* "bauerle" 34563 */
      9,  48,  10,   7,  39,  13,   0,  /* "bauerlein" 34570 */
      9,  48,  10,  13,  37,  39,  13,  20,   0,  /* "bauernfeind" 34579 */
      9,  48,  11,  15,  14,   0,  /* "bauguess" 34585 */
      9,  18,  12,  13,  39,   3,   0,  /* "bauknight" 34592 */
      9,  18,  17,   0,  /* "baum" 34596 */
      9,  48,  17,  11,   8,   4,   3,   0,  /* "baumgart" 34604 */
      9,  48,  17,  11,  19,   4,   3,   1,  13,   0,  /* "baumgarten" 34614 */
      9,  48,  17,  11,   8,   4,   3,  13,  10,   0,  /* "baumgartner" 34624 */
      9,   8,  17,  38,  18,   7,  20,  10,   0,  /* "baumholder" 34633 */
      9,  48,  17,   1,   7,  10,   0,  /* "baumler" 34640 */
      9,  48,  17,  14,   3,   8,   4,  12,   0,  /* "baumstark" 34649 */
      9,  18,  13,   0,  /* "baun" 34653 */
      9,  18,   4,   0,  /* "baur" 34657 */
      9,  18,  30,   0,  /* "baus" 34661 */
      9,  36,   3,  23,  14,   3,   1,   0,  /* "bautista" 34669 */
      9,  48,   3,  14,  10,   0,  /* "bautzer" 34675 */
      9,  18,  12,  14,  39,   3,   0,  /* "bauxite" 34682 */
      9,   8,  22,   1,   0,  /* "bava" 34687 */
      9,   1,  22,  24,  20,   4,   1,   0,  /* "bavadra" 34695 */
      9,  19,  22,   8,   4,  27,   0,  /* "bavaro" 34702 */
      9,  18,  20,   0,  /* "bawd" 34706 */
      9,  18,  10,   0,  /* "bawer" 34710 */
      9,  18,   7,   0,  /* "bawl" 34714 */
      9,  24,  12,  14,   0,  /* "bax" 34719 */
      9,  24,  12,  14,   1,   0,  /* "baxa" 34725 */
      9,  24,  12,  14,   1,  13,  20,  28,   7,   0,  /* "baxendale" 34735 */
      9,  24,  12,  14,   7,  26,   0,  /* "baxley" 34742 */
      9,  24,  12,  14,   3,   0,  /* "baxt" 34748 */
      9,  24,  12,  14,   3,  10,   0,  /* "baxter" 34755 */
      9,   2,   0,  /* "bay" 34758 */
      9,  39,  24,  13,  40,  29,   0,  /* "bayanjou" 34765 */
      9,   2,  10,   0,  /* "bayar" 34769 */
      9,   2,  10,  20,   0,  /* "bayard" 34774 */
      9,  28,  20,   8,   9,  27,   0,  /* "baydhabo" 34781 */
      9,   2,   0,  /* "baye" 34784 */
      9,   2,  10,  23,  33,   0,  /* "bayerische" 34790 */
      9,   2,   0,  /* "bayh" 34793 */
      9,   2,   7,   5,  14,   0,  /* "bayless" 34799 */
      9,   2,   7,  39,  13,  10,   0,  /* "bayliner" 34806 */
      9,   2,   7,   5,  14,   0,  /* "baylis" 34812 */
      9,   2,   8,  11,   0,  /* "bayog" 34817 */
      9,   2,   1,  13,  21,   3,   0,  /* "bayonet" 34824 */
      9,   2,   1,  13,  21,   3,  14,   0,  /* "bayonets" 34832 */
      9,   2,  41,  25,  13,   0,  /* "bayonne" 34838 */
      9,  39,  29,   0,  /* "bayou" 34842 */
      9,  39,  29,  30,   0,  /* "bayous" 34847 */
      9,  39,  29,  16,   0,  /* "bayouth" 34852 */
      9,   2,   4,  49,  16,   0,  /* "bayreuth" 34858 */
      9,   2,  30,   0,  /* "bays" 34862 */
      9,   2,  14,  39,  20,   0,  /* "bayside" 34868 */
      9,   2,  47,  19,  42,   0,  /* "baywatch" 34874 */
      9,  24,  30,   0,  /* "baz" 34878 */
      9,   1,  30,   8,   4,  30,   0,  /* "bazaars" 34885 */
      9,   2,  30,   0,  /* "baze" 34889 */
      9,   8,  30,  17,  36,   4,   0,  /* "bazemore" 34896 */
      9,   8,  30,  39,   7,   0,  /* "bazile" 34902 */
      9,  24,  30,   1,  13,  15,   3,   0,  /* "bazinet" 34910 */
      9,   1,  30,  29,  12,   1,   0,  /* "bazooka" 34917 */
      9,   1,  30,  29,  12,   1,  30,   0,  /* "bazookas" 34925 */
      9,  19,   3,  14,   8,  13,  27,   0,  /* "bazzano" 34933 */
      9,  24,  30,   1,   7,   0,  /* "bazzle" 34939 */
      9,  23,   9,  26,  14,  23,   0,  /* "bbc" 34946 */
      9,  23,   9,  26,  12,  41,  29,   0,  /* "bbq" 34954 */
      9,  23,   0,  /* "be" 34957 */
      9,  23,   0,  /* "bea" 34960 */
      9,   1,   9,  29,   3,   0,  /* "beabout" 34966 */
      9,  23,  42,  12,  25,  17,  10,   0,  /* "beachcomber" 34974 */
      9,  23,  12,   1,  17,   0,  /* "beachem" 34980 */
      9,  23,  42,  37,   4,  19,  13,   3,   0,  /* "beachfront" 34989 */
      9,  23,  12,   1,   7,  10,   0,  /* "beachler" 34996 */
      9,  23,  12,   1,  17,   0,  /* "beacom" 35002 */
      9,  23,  12,   1,  13,  30,   0,  /* "beacons" 35009 */
      9,  23,  20,   0,  /* "bead" 35013 */
      9,  23,  20,   1,   7,   0,  /* "beadle" 35019 */
      9,  23,  20,   1,   7,  30,   0,  /* "beadles" 35026 */
      9,   1,  11,  24,  13,   0,  /* "beagan" 35032 */
      9,  23,  11,   1,  13,   0,  /* "beagen" 35038 */
      9,  23,  11,   1,   7,   0,  /* "beagle" 35044 */
      9,  23,  11,   1,   7,  30,   0,  /* "beagles" 35051 */
      9,   5,   4,  20,   0,  /* "beaird" 35056 */
      9,  23,  12,   0,  /* "beak" 35060 */
      9,  23,  12,   7,  39,  12,   0,  /* "beaklike" 35067 */
      9,  23,   7,   0,  /* "beal" 35071 */
      9,  23,  17,   0,  /* "beam" 35075 */
      9,  23,  13,   0,  /* "bean" 35079 */
      9,  23,  13,   9,   7,   1,  14,   1,  17,   0,  /* "beanblossom" 35089 */
      9,  21,   4,   0,  /* "bear" 35093 */
      9,  21,   4,   1,   9,   1,   7,   0,  /* "bearable" 35101 */
      9,  44,  14,   0,  /* "bearce" 35105 */
      9,   5,   4,  20,  17,  18,   4,   0,  /* "beardmore" 35113 */
      9,   5,   4,  20,  30,   7,  26,   0,  /* "beardslee" 35121 */
      9,   5,   4,  20,  30,   7,  26,   0,  /* "beardsley" 35129 */
      9,   5,   4,   0,  /* "beare" 35133 */
      9,  44,  37,  26,   7,  20,   0,  /* "bearfield" 35140 */
      9,  44,  14,   0,  /* "bearse" 35144 */
      9,  44,  14,   0,  /* "bearss" 35148 */
      9,  21,   4,   1,   6,   0,  /* "bearup" 35154 */
      9,   5,   4,  26,   0,  /* "beary" 35159 */
      9,  23,  30,   0,  /* "beas" 35163 */
      9,  23,   3,   0,  /* "beat" 35167 */
      9,  26,  24,   3,   1,   0,  /* "beata" 35173 */
      9,  23,   3,   1,   7,   0,  /* "beatle" 35179 */
      9,  23,   3,   1,   7,  30,   0,  /* "beatles" 35186 */
      9,  26,  24,   3,  27,   0,  /* "beato" 35192 */
      9,  23,   1,   3,   4,   1,  14,   0,  /* "beatrice" 35200 */
      9,  23,   3,   4,  31,  12,  14,   0,  /* "beatrix" 35208 */
      9,  25,   0,  /* "beau" 35211 */
      9,  27,   9,  23,  13,   0,  /* "beaubien" 35217 */
      9,  25,  12,   2,  40,   0,  /* "beaucage" 35223 */
      9,  25,  14,  23,   0,  /* "beauce" 35228 */
      9,  25,  33,   2,  13,   0,  /* "beauchaine" 35234 */
      9,  25,  33,   8,  17,   6,   0,  /* "beauchamp" 35241 */
      9,  25,  33,   1,  17,  34,  13,   0,  /* "beauchemin" 35249 */
      9,  25,  33,  23,  13,   0,  /* "beauchene" 35255 */
      9,  27,  33,  21,  13,   0,  /* "beauchesne" 35261 */
      9,  27,  20,  21,   3,   0,  /* "beaudet" 35267 */
      9,  27,  20,  24,  13,   0,  /* "beaudin" 35273 */
      9,  27,  20,  49,  13,   0,  /* "beaudoin" 35279 */
      9,  25,  20,   4,  25,   0,  /* "beaudreau" 35285 */
      9,  27,  20,   4,  23,   0,  /* "beaudry" 35291 */
      9,  27,  37,  18,   4,  20,   0,  /* "beauford" 35298 */
      9,  25,  37,   4,  21,   4,   0,  /* "beaufrere" 35305 */
      9,  27,   7,  24,  12,   0,  /* "beaulac" 35311 */
      9,  41,  29,  17,  26,  10,   0,  /* "beaumier" 35318 */
      9,  25,  17,  36,  13,   3,   0,  /* "beaumont" 35325 */
      9,  25,   6,  10,   0,  /* "beaupre" 35330 */
      9,  25,  14,   1,   7,  28,   0,  /* "beausoleil" 35337 */
      9,  25,   3,   5,  33,   1,  13,   0,  /* "beautician" 35345 */
      9,  41,  29,   3,  26,  30,   0,  /* "beauties" 35352 */
      9,  41,  29,   3,   1,  37,   1,   7,   0,  /* "beautiful" 35361 */
      9,  41,  29,   3,   1,  37,   1,   7,   1,  14,   3,   0,  /* "beautifullest" 35373 */
      9,  41,  29,   3,   1,  37,   7,  26,   0,  /* "beautifully" 35382 */
      9,  41,  29,   3,   1,  37,  39,   0,  /* "beautify" 35390 */
      9,  41,  29,   3,  26,   0,  /* "beauty" 35396 */
      9,  25,   0,  /* "beaux" 35399 */
      9,   1,  22,  24,  13,   0,  /* "beavan" 35405 */
      9,  23,  22,   1,  14,   0,  /* "beavis" 35411 */
      9,  21,   9,   0,  /* "bebb" 35415 */
      9,  21,   9,   1,   3,  14,   0,  /* "bebbits" 35422 */
      9,  23,   9,  26,   0,  /* "bebe" 35427 */
      9,   1,   9,   5,   4,   0,  /* "bebear" 35433 */
      9,   5,   9,  25,   0,  /* "bebeau" 35438 */
      9,  23,   9,  10,   0,  /* "beber" 35443 */
      9,  21,   9,  31,  42,   0,  /* "bebitch" 35449 */
      9,  23,   9,   8,   6,   0,  /* "bebop" 35455 */
      9,   5,   9,  29,   3,   0,  /* "bebout" 35461 */
      9,  21,  12,   0,  /* "bec" 35465 */
      9,  31,  12,   8,  17,   0,  /* "becalm" 35471 */
      9,  15,  42,  21,   4,   1,   0,  /* "becerra" 35478 */
      9,  28,  14,  15,   4,  23,   7,   0,  /* "becerril" 35486 */
      9,  21,  12,  10,  20,   0,  /* "bechard" 35492 */
      9,  21,  12,  10,  10,   0,  /* "becherer" 35498 */
      9,  21,  12,   7,  10,   0,  /* "bechler" 35504 */
      9,  21,  12,   3,  21,   7,   0,  /* "bechtel" 35511 */
      9,  21,  12,  16,  27,   7,  20,   0,  /* "bechthold" 35519 */
      9,  21,  42,   3,   1,   7,   0,  /* "bechtle" 35526 */
      9,  21,  12,   0,  /* "beck" 35530 */
      9,  21,  14,  12,   1,   0,  /* "becka" 35536 */
      9,  21,  12,  15,   7,   0,  /* "beckel" 35542 */
      9,  21,  12,  37,  36,   4,  20,   0,  /* "beckford" 35550 */
      9,  21,  12,  38,  24,  17,   0,  /* "beckham" 35557 */
      9,  21,  12,   1,   7,  30,   0,  /* "beckles" 35564 */
      9,  21,  12,  19,  17,   0,  /* "beckom" 35570 */
      9,  21,  12,  14,   3,   4,  24,  13,  20,   0,  /* "beckstrand" 35580 */
      9,  21,  12,  14,   3,   4,  19,  17,   0,  /* "beckstrom" 35589 */
      9,  23,  12,  27,   0,  /* "beco" 35594 */
      9,  23,  12,   4,  34,  37,   3,   0,  /* "becraft" 35602 */
      9,  21,  12,  22,  10,   0,  /* "becvar" 35608 */
      9,  21,  20,   0,  /* "bed" 35612 */
      9,   2,  20,   1,   0,  /* "beda" 35617 */
      9,   1,  20,   8,   4,  20,   0,  /* "bedard" 35624 */
      9,  21,  20,   9,   1,  11,   0,  /* "bedbug" 35631 */
      9,  21,  20,   9,   1,  11,  30,   0,  /* "bedbugs" 35639 */
      9,  21,  20,  42,   2,  17,   9,  10,   0,  /* "bedchamber" 35648 */
      9,  23,  20,   0,  /* "bede" 35652 */
      9,   1,  20,  21,  12,   0,  /* "bedeck" 35658 */
      9,   1,  20,  21,  12,   3,   0,  /* "bedecked" 35665 */
      9,   1,  20,  21,   7,   0,  /* "bedel" 35671 */
      9,  21,  20,   1,   7,   0,  /* "bedell" 35677 */
      9,  21,  20,   1,  13,   9,  52,   0,  /* "bedenbaugh" 35685 */
      9,   1,  20,  21,  22,   1,   7,  20,   0,  /* "bedeviled" 35694 */
      9,  23,  20,  41,   1,  13,   3,   0,  /* "bedient" 35702 */
      9,  21,  20,  17,   1,  13,  14,   3,  10,   0,  /* "bedminster" 35712 */
      9,  21,  20,  13,  19,   4,  15,  12,   0,  /* "bednarek" 35721 */
      9,  21,  20,  13,  19,   4,  31,  12,   0,  /* "bednarik" 35730 */
      9,  21,  20,  13,  36,   4,  30,   0,  /* "bednorz" 35738 */
      9,  15,  20,  25,   7,   1,   0,  /* "bedolla" 35745 */
      9,  21,  20,  18,   4,   0,  /* "bedore" 35751 */
      9,  21,  20,  27,   1,  13,   0,  /* "bedouin" 35758 */
      9,  21,  20,  27,   1,  13,  30,   0,  /* "bedouins" 35766 */
      9,  28,  20,  49,   1,   0,  /* "bedoya" 35772 */
      9,  21,  20,   6,  24,  13,  30,   0,  /* "bedpans" 35780 */
      9,   1,  20,   4,  24,  11,   1,   7,   0,  /* "bedraggle" 35789 */
      9,   1,  20,   4,  24,  11,   1,   7,  20,   0,  /* "bedraggled" 35799 */
      9,  21,  20,   4,   5,  20,   1,  13,   0,  /* "bedridden" 35808 */
      9,  21,  20,   4,   8,  12,   0,  /* "bedrock" 35815 */
      9,  21,  20,   4,  29,  17,   0,  /* "bedroom" 35822 */
      9,  21,  20,   4,  29,  17,  30,   0,  /* "bedrooms" 35830 */
      9,  15,  20,   4,   8,  43,   1,  13,   0,  /* "bedrosian" 35839 */
      9,  21,  20,  30,   0,  /* "beds" 35844 */
      9,  21,  20,  14,  36,   7,   0,  /* "bedsaul" 35851 */
      9,  21,  20,  14,  39,  20,   0,  /* "bedside" 35858 */
      9,  21,  20,   3,  39,  17,   0,  /* "bedtime" 35865 */
      9,  23,   0,  /* "bee" 35868 */
      9,  23,   9,  23,   0,  /* "beebe" 35873 */
      9,  23,   9,  23,  30,   0,  /* "beebes" 35879 */
      9,  23,   9,  25,  10,   0,  /* "beebower" 35885 */
      9,  23,  42,   7,  10,   0,  /* "beechler" 35891 */
      9,  23,  20,   1,   7,   0,  /* "beedle" 35897 */
      9,  23,  37,   0,  /* "beef" 35901 */
      9,  23,  37,  14,   3,   2,  12,   0,  /* "beefsteak" 35909 */
      9,  23,  37,  26,   0,  /* "beefy" 35914 */
      9,  23,  11,   1,   7,   0,  /* "beegle" 35920 */
      9,  23,  38,  39,  22,   0,  /* "beehive" 35926 */
      9,  23,  12,   0,  /* "beek" 35930 */
      9,  23,   7,   0,  /* "beel" 35934 */
      9,  23,  17,   0,  /* "beem" 35938 */
      9,   5,  13,   0,  /* "been" 35942 */
      9,   5,  13,  30,   0,  /* "beens" 35947 */
      9,  23,   6,   0,  /* "beep" 35951 */
      9,   5,   4,   0,  /* "beer" 35955 */
      9,   5,   4,   9,  27,  10,   0,  /* "beerbower" 35962 */
      9,  23,  30,   0,  /* "bees" 35966 */
      9,  23,  30,   1,  13,   0,  /* "beeson" 35972 */
      9,  23,   3,   0,  /* "beet" 35976 */
      9,   2,   3,  27,  22,   1,  13,   0,  /* "beethoven" 35984 */
      9,   2,   3,  27,  22,  23,  13,  26,   1,  13,   0,  /* "beethovenian" 35995 */
      9,  23,   3,   1,   7,   0,  /* "beetle" 36001 */
      9,  23,   3,   1,   7,  40,  29,  14,   0,  /* "beetlejuice" 36010 */
      9,  23,   3,   1,   7,  30,   0,  /* "beetles" 36017 */
      9,   1,  37,  24,   7,   1,  13,   0,  /* "befallen" 36025 */
      9,   1,  37,   8,   7,   3,  27,   0,  /* "befalto" 36033 */
      9,   1,  37,  21,   7,   0,  /* "befell" 36039 */
      9,   5,  37,   8,   0,  /* "beffa" 36044 */
      9,   1,  37,   5,   3,   0,  /* "befit" 36050 */
      9,  21,  37,  10,   3,   0,  /* "befort" 36056 */
      9,   1,  37,  35,  20,   1,   7,   0,  /* "befuddle" 36064 */
      9,   1,  37,  35,  20,   1,   7,  20,   0,  /* "befuddled" 36073 */
      9,   1,  37,  35,  20,   1,   7,  30,   0,  /* "befuddles" 36082 */
      9,  21,  11,   0,  /* "beg" 36086 */
      9,  15,  11,   8,  40,   1,   0,  /* "begajah" 36093 */
      9,  15,  11,   8,   7,   1,   0,  /* "begala" 36100 */
      9,  31,  11,  24,  13,   0,  /* "began" 36106 */
      9,  31,  11,  24,   3,   0,  /* "begat" 36112 */
      9,   2,  11,   1,   7,   0,  /* "begel" 36118 */
      9,   2,  11,   1,   7,  17,   1,  13,   0,  /* "begelman" 36127 */
      9,  23,  11,  17,   1,  13,   0,  /* "begeman" 36134 */
      9,  31,  11,  21,   3,   0,  /* "beget" 36140 */
      9,  31,  11,  21,   3,  14,   0,  /* "begets" 36147 */
      9,  31,  11,  21,   3,  31,  32,   0,  /* "begetting" 36155 */
      9,  21,  11,   0,  /* "begg" 36159 */
      9,  31,  11,   5,  13,   0,  /* "begin" 36165 */
      9,  31,  11,   5,  13,  10,   0,  /* "beginner" 36172 */
      9,  31,  11,   5,  13,  10,  30,   0,  /* "beginners" 36180 */
      9,  31,  11,   5,  13,  31,  32,   0,  /* "beginning" 36188 */
      9,  31,  11,   5,  13,  31,  32,  30,   0,  /* "beginnings" 36197 */
      9,  31,  11,   5,  13,  30,   0,  /* "begins" 36204 */
      9,  21,  11,   7,  39,   3,  10,   0,  /* "begleiter" 36212 */
      9,  31,  11,  13,  25,   0,  /* "begnaud" 36218 */
      9,  15,  11,  13,  25,  12,  26,   0,  /* "begnoche" 36226 */
      9,  31,  11,  25,  13,  41,   1,   0,  /* "begonia" 36234 */
      9,  31,  11,  25,  13,  41,   1,  30,   0,  /* "begonias" 36243 */
      9,  26,  11,  18,   3,   0,  /* "begot" 36249 */
      9,  26,  11,  18,   3,   1,  13,   0,  /* "begotten" 36257 */
      9,  31,  11,   4,  35,  40,   0,  /* "begrudge" 36264 */
      9,  21,  11,  30,   0,  /* "begs" 36269 */
      9,   2,  11,   0,  /* "begue" 36273 */
      9,   2,  11,   1,   7,   1,  13,   0,  /* "beguelin" 36281 */
      9,  31,  11,  39,   7,   0,  /* "beguile" 36287 */
      9,  31,  11,  39,   7,  20,   0,  /* "beguiled" 36294 */
      9,  31,  11,  39,   7,  31,  32,   0,  /* "beguiling" 36302 */
      9,   1,  38,   2,  22,  31,  32,   0,  /* "behaving" 36310 */
      9,   1,  38,   2,  22,  41,  10,   1,   7,   0,  /* "behavioral" 36320 */
      9,   1,  38,  23,  17,   1,  16,   0,  /* "behemoth" 36328 */
      9,   1,  38,  23,  17,   1,  16,  14,   0,  /* "behemoths" 36337 */
      9,   5,  38,  21,  14,   3,   0,  /* "behest" 36344 */
      9,   1,  38,  39,  13,  20,   0,  /* "behind" 36351 */
      9,   1,  38,  39,  13,  20,  30,   0,  /* "behinds" 36359 */
      9,  21,   7,   0,  /* "behl" 36363 */
      9,  21,  38,   1,   7,   0,  /* "behle" 36369 */
      9,  21,  17,   0,  /* "behm" 36373 */
      9,  21,  13,   0,  /* "behn" 36377 */
      9,  23,  38,  19,  37,   0,  /* "behof" 36383 */
      9,  23,  38,  19,  37,   0,  /* "behoff" 36389 */
      9,   1,  38,  25,   7,  20,   0,  /* "behold" 36396 */
      9,   1,  38,  25,   7,  20,   1,  13,   0,  /* "beholden" 36405 */
      9,  26,  38,  25,   7,  20,  10,   0,  /* "beholder" 36413 */
      9,   1,  38,  25,   7,  20,  31,  32,   0,  /* "beholding" 36422 */
      9,   1,  38,  29,  22,   0,  /* "behoove" 36428 */
      9,   1,  38,  29,  22,  30,   0,  /* "behooves" 36435 */
      9,  21,   4,   0,  /* "behr" 36439 */
      9,  21,   4,   1,  13,   3,   0,  /* "behrendt" 36446 */
      9,  21,   4,   5,  32,  47,  10,  12,   0,  /* "behringwerke" 36455 */
      9,  21,   4,   1,   7,   0,  /* "behrle" 36461 */
      9,  21,  38,   1,  13,   1,  13,   0,  /* "behunin" 36469 */
      9,  21,  38,  39,  17,  10,   0,  /* "behymer" 36476 */
      9,  39,  20,   2,  38,  26,   0,  /* "beidaihe" 36483 */
      9,  39,  20,   1,   7,  17,   1,  13,   0,  /* "beidleman" 36492 */
      9,  39,  20,   1,   7,  10,   0,  /* "beidler" 36499 */
      9,  39,  10,   0,  /* "beier" 36503 */
      9,  39,  10,   1,   7,   0,  /* "beierle" 36509 */
      9,  39,   4,  30,  20,  18,   4,  37,   0,  /* "beiersdorf" 36518 */
      9,   2,  43,   0,  /* "beige" 36522 */
      9,  39,  11,   1,   7,   0,  /* "beigel" 36528 */
      9,   2,  43,   1,  30,   0,  /* "beiges" 36534 */
      9,   2,  11,   7,  26,   0,  /* "beighley" 36540 */
      9,  39,   4,   0,  /* "beijer" 36544 */
      9,   2,  43,   5,  32,   0,  /* "beijing" 36550 */
      9,  23,   7,   0,  /* "beil" 36554 */
      9,  39,   7,   1,  13,  14,   1,  13,   0,  /* "beilenson" 36563 */
      9,  39,   7,  10,   0,  /* "beiler" 36568 */
      9,  39,   7,  37,   1,  14,   0,  /* "beilfuss" 36575 */
      9,  21,   7,   5,  13,   0,  /* "beilin" 36581 */
      9,  23,   7,  12,   0,  /* "beilke" 36586 */
      9,  39,   7,  17,   1,  13,   0,  /* "beilman" 36593 */
      9,  39,  17,   0,  /* "beim" 36597 */
      9,  23,  13,   0,  /* "bein" 36601 */
      9,  23,  31,  32,   0,  /* "being" 36606 */
      9,  23,  31,  32,  30,   0,  /* "beings" 36612 */
      9,  39,  13,  26,   0,  /* "beiny" 36617 */
      9,   2,   4,   1,   0,  /* "beira" 36622 */
      9,   5,   4,  13,   0,  /* "beirne" 36627 */
      9,  28,   4,  29,   3,   0,  /* "beirut" 36633 */
      9,  39,  14,   1,   7,   0,  /* "beisel" 36639 */
      9,  39,  14,  10,   0,  /* "beiser" 36644 */
      9,  39,  14,  13,  10,   0,  /* "beisner" 36650 */
      9,  39,  14,   1,   7,   0,  /* "beissel" 36656 */
      9,  39,  14,  47,  15,  13,  40,  10,   0,  /* "beiswenger" 36665 */
      9,   2,   3,   0,  /* "beit" 36669 */
      9,  39,   3,   1,   7,   0,  /* "beitel" 36675 */
      9,  39,   3,  10,   0,  /* "beiter" 36680 */
      9,  39,   3,   1,   7,  10,   0,  /* "beitler" 36687 */
      9,  39,   3,  30,   1,   7,   0,  /* "beitzel" 36694 */
      9,  28,  41,   8,   4,   0,  /* "bejar" 36700 */
      9,  28,  41,  19,   4,   8,  13,  27,   0,  /* "bejarano" 36709 */
      9,  15,  12,   8,   0,  /* "bekaa" 36714 */
      9,   1,  12,  21,   4,   3,   0,  /* "bekaert" 36721 */
      9,  23,  12,   1,  13,  30,   0,  /* "bekins" 36728 */
      9,  21,   7,   0,  /* "bel" 36732 */
      9,  21,   7,   1,   0,  /* "bela" 36737 */
      9,  21,   7,   1,  20,  45,   4,   0,  /* "beladur" 36745 */
      9,  21,   7,   1,  37,   8,  13,   3,  26,   0,  /* "belafonte" 36755 */
      9,  15,   7,  21,   4,   0,  /* "belair" 36761 */
      9,  21,   7,   1,  12,   0,  /* "belak" 36767 */
      9,  21,   7,   1,  32,  10,   0,  /* "belanger" 36774 */
      9,  15,   7,   8,   4,   1,  14,   0,  /* "belarus" 36782 */
      9,  15,   7,   8,  14,  12,  27,   0,  /* "belasco" 36790 */
      9,  15,   7,  12,  24,  14,   3,   4,  27,   0,  /* "belcastro" 36800 */
      9,  21,   7,  20,   8,  12,   0,  /* "beldock" 36807 */
      9,  15,   7,  37,  26,  18,   4,  26,   0,  /* "belfiore" 36816 */
      9,  15,   7,  11,   8,   4,  20,   0,  /* "belgard" 36824 */
      9,  15,   7,  11,   8,   4,  20,  26,   0,  /* "belgarde" 36833 */
      9,  21,   7,  40,  26,   0,  /* "belge" 36839 */
      9,  21,   7,  40,   1,  13,   0,  /* "belgian" 36846 */
      9,  21,   7,  40,   1,  13,  30,   0,  /* "belgians" 36854 */
      9,  15,   7,  43,  23,  12,   0,  /* "belgique" 36861 */
      9,  21,   7,  40,   1,  17,   0,  /* "belgium" 36868 */
      9,  21,   7,  11,  25,   0,  /* "belgo" 36874 */
      9,  21,   7,  11,   4,  28,  20,   0,  /* "belgrade" 36882 */
      9,   1,   7,  39,   0,  /* "belie" 36887 */
      9,   1,   7,  39,  20,   0,  /* "belied" 36893 */
      9,  21,   7,  41,  10,   0,  /* "belier" 36899 */
      9,   1,   7,  39,  30,   0,  /* "belies" 36905 */
      9,   1,   7,  23,  22,   1,   9,   1,   7,   0,  /* "believable" 36915 */
      9,   1,   7,   5,  13,  20,   1,   0,  /* "belinda" 36923 */
      9,  15,   7,   5,  13,  14,  12,  26,   0,  /* "belinsky" 36932 */
      9,  21,   7,  39,   1,   7,   0,  /* "belisle" 36939 */
      9,   1,   7,   5,   3,   1,   7,   0,  /* "belittle" 36947 */
      9,   1,   7,   5,   3,   1,   7,  20,   0,  /* "belittled" 36956 */
      9,   1,   7,   5,   3,   1,   7,  30,   0,  /* "belittles" 36965 */
      9,   1,   7,   5,   3,   1,   7,  31,  32,   0,  /* "belittling" 36975 */
      9,  21,   7,   5,   3,  14,   0,  /* "belitz" 36982 */
      9,  15,   7,  23,  30,   0,  /* "belize" 36988 */
      9,  21,   7,  12,   0,  /* "belk" 36993 */
      9,  21,   7,  12,   1,  14,   1,  17,   0,  /* "belkacem" 37002 */
      9,  21,   7,  13,  34,   6,   0,  /* "belknap" 37009 */
      9,  21,   7,   0,  /* "bell" 37013 */
      9,  15,   7,   8,  13,  12,   1,   0,  /* "bellanca" 37021 */
      9,  21,   7,  24,  32,  11,  10,   0,  /* "bellanger" 37029 */
      9,  15,   7,   8,  13,   3,  26,   0,  /* "bellante" 37037 */
      9,  15,   7,  19,  13,   3,  25,  13,  26,   0,  /* "bellantoni" 37047 */
      9,  15,   7,   8,   4,  20,   0,  /* "bellard" 37054 */
      9,  15,   7,   8,  22,   1,  13,  14,   0,  /* "bellavance" 37063 */
      9,  15,   7,   8,  22,  26,   1,   0,  /* "bellavia" 37071 */
      9,  15,   7,  25,   0,  /* "belleau" 37076 */
      9,  21,   7,   1,  37,  26,  29,   7,   0,  /* "bellefeuille" 37085 */
      9,  21,   7,  10,   1,  30,   0,  /* "bellerose" 37092 */
      9,   1,   7,  22,   5,   7,   0,  /* "belleville" 37099 */
      9,  21,   7,  22,  41,  29,   0,  /* "bellevue" 37106 */
      9,  15,   7,  29,   0,  /* "bellew" 37111 */
      9,  21,   7,  38,   8,   6,   0,  /* "bellhop" 37118 */
      9,  21,   7,   1,  12,  25,  14,   0,  /* "bellicose" 37126 */
      9,   1,   7,   5,  40,  10,   1,  13,  14,   0,  /* "belligerence" 37136 */
      9,   1,   7,   5,  40,  10,   1,  13,   3,   0,  /* "belligerent" 37146 */
      9,   1,   7,   5,  40,  10,   1,  13,   3,  14,   0,  /* "belligerents" 37157 */
      9,  15,   7,  23,  13,   1,   0,  /* "bellina" 37164 */
      9,  15,   7,  23,  13,  26,   0,  /* "bellini" 37171 */
      9,  15,   7,  23,  13,  27,   0,  /* "bellino" 37178 */
      9,  15,   7,  26,  14,  23,  17,  27,   0,  /* "bellissimo" 37187 */
      9,  15,   7,  23,   3,  14,  26,   0,  /* "bellizzi" 37195 */
      9,  15,   7,  25,  17,  27,   0,  /* "bellomo" 37202 */
      9,  15,   7,  25,  13,  26,   0,  /* "bellone" 37209 */
      9,  15,   7,  25,   3,  26,   0,  /* "bellotti" 37216 */
      9,  15,   7,  29,  42,  26,   0,  /* "bellucci" 37223 */
      9,  21,   7,  26,   2,  12,   0,  /* "bellyache" 37230 */
      9,  15,   7,  17,   8,  13,   3,  26,   0,  /* "belmonte" 37239 */
      9,  21,   7,  27,   0,  /* "belo" 37244 */
      9,  21,   7,  18,  37,   0,  /* "beloff" 37250 */
      9,   1,   7,  18,  32,  20,   0,  /* "belonged" 37257 */
      9,  15,   7,  25,  13,  40,   1,   0,  /* "belongia" 37265 */
      9,  15,   7,  25,   3,  26,   0,  /* "belote" 37272 */
      9,  21,   7,   1,  14,   0,  /* "belous" 37278 */
      9,  21,   7,  19,  22,   0,  /* "belov" 37284 */
      9,   1,   7,  25,   0,  /* "below" 37289 */
      9,  21,   7,  30,   0,  /* "bels" 37294 */
      9,  15,   7,  14,  23,   3,  27,   0,  /* "belsito" 37302 */
      9,  21,   7,   3,   0,  /* "belt" 37307 */
      9,  21,   7,   3,   4,   1,  13,   0,  /* "beltran" 37315 */
      9,  21,   7,  41,  29,   0,  /* "belue" 37321 */
      9,   1,   7,  29,  11,   1,   0,  /* "beluga" 37328 */
      9,  15,   7,  29,  33,  26,   0,  /* "belushi" 37335 */
      9,   2,   7,  22,   1,   0,  /* "belva" 37341 */
      9,  21,   7,  22,   1,   7,   0,  /* "belveal" 37348 */
      9,  21,   7,  22,   1,  20,   5,   4,   0,  /* "belvedere" 37357 */
      9,   1,   7,  39,   0,  /* "bely" 37362 */
      9,  15,   7,  23,   1,   0,  /* "belyea" 37368 */
      9,  21,   7,  26,  29,   0,  /* "belyeu" 37374 */
      9,   1,   7,  39,  31,  32,   0,  /* "belying" 37381 */
      9,  21,   7,  30,   0,  /* "belz" 37386 */
      9,  21,   7,   3,  14,   9,  10,  11,   0,  /* "belzberg" 37395 */
      9,  21,   7,   3,  14,   9,  10,  11,  30,   0,  /* "belzbergs" 37405 */
      9,  21,  17,   0,  /* "bem" 37409 */
      9,  21,  17,   9,   1,  13,   1,  12,   0,  /* "bembenek" 37418 */
      9,  23,  17,   1,  13,   3,   0,  /* "bement" 37425 */
      9,  23,  17,   1,  14,   0,  /* "bemis" 37431 */
      9,   1,  17,  25,  13,  20,   0,  /* "bemoaned" 37438 */
      9,   1,  17,  25,  13,  31,  32,   0,  /* "bemoaning" 37446 */
      9,   1,  17,  25,  13,  30,   0,  /* "bemoans" 37453 */
      9,   1,  17,  41,  29,  30,   0,  /* "bemuse" 37460 */
      9,   1,  17,  41,  29,  30,  20,   0,  /* "bemused" 37468 */
      9,  21,  17,  41,  29,  14,  17,   1,  13,   3,   0,  /* "bemusement" 37479 */
      9,  21,  13,   0,  /* "ben" 37483 */
      9,  21,  13,   1,   0,  /* "bena" 37488 */
      9,  21,  13,   1,  12,  25,  22,   1,   0,  /* "benackova" 37497 */
      9,  21,  13,   1,  17,  23,   0,  /* "benami" 37504 */
      9,  15,  13,   8,  13,   3,  26,   0,  /* "benanty" 37512 */
      9,   1,  13,   8,   4,  20,   0,  /* "benard" 37519 */
      9,  15,  13,   8,  14,  26,   0,  /* "benassi" 37526 */
      9,  21,  13,   1,  14,  29,   7,  26,   0,  /* "benasuli" 37535 */
      9,  15,  13,  19,  22,  21,  13,   3,  26,   0,  /* "benavente" 37545 */
      9,  28,  13,  19,  22,  23,  20,  15,  14,   0,  /* "benavides" 37555 */
      9,  21,  13,   1,  30,   5,   4,   0,  /* "benazir" 37563 */
      9,  15,  13,  42,  26,  22,  21,  32,  11,   1,   0,  /* "bencivenga" 37574 */
      9,  15,  13,  12,  25,  17,  27,   0,  /* "bencomo" 37582 */
      9,  21,  32,  12,  14,  31,  12,   0,  /* "bencsik" 37590 */
      9,  21,  13,  20,   0,  /* "bend" 37595 */
      9,  15,  13,  20,  21,  12,   3,   1,  13,   0,  /* "bendectin" 37605 */
      9,  21,  13,  20,  31,  12,  14,   0,  /* "bendix" 37613 */
      9,  15,  13,  20,   5,  12,  14,   1,  13,   0,  /* "bendixen" 37623 */
      9,  28,  13,  20,  45,   4,  28,   0,  /* "bendure" 37631 */
      9,  21,  13,   1,   0,  /* "bene" 37636 */
      9,   1,  13,  23,  16,   0,  /* "beneath" 37642 */
      9,  21,  13,   1,  12,   0,  /* "benecke" 37648 */
      9,  21,  13,   1,  20,  31,  12,   0,  /* "benedek" 37656 */
      9,  15,  13,   1,  20,  21,   3,  27,   0,  /* "benedetto" 37665 */
      9,  21,  13,   1,  20,  26,  12,   3,   1,   0,  /* "benedicta" 37675 */
      9,  21,  13,   1,  20,   5,  12,   3,  26,  13,   0,  /* "benedictine" 37686 */
      9,  21,  13,   1,  20,   5,  12,   3,  26,  13,  30,   0,  /* "benedictines" 37698 */
      9,  21,  13,   1,  20,  31,  12,  14,   0,  /* "benedix" 37707 */
      9,   1,  13,  21,  37,   1,  14,   1,  13,  14,   0,  /* "beneficence" 37718 */
      9,  21,  13,   1,  37,   5,  33,   1,  13,   3,   0,  /* "beneficent" 37729 */
      9,  21,  13,   1,  37,   5,  33,  26,  21,   4,  26,  30,   0,  /* "beneficiaries" 37742 */
      9,  21,  13,   1,  37,   5,  33,  26,  21,   4,  26,   0,  /* "beneficiary" 37754 */
      9,  21,  13,   1,  37,  26,   7,  20,   0,  /* "benefield" 37763 */
      9,  21,  13,   1,  37,   5,   3,   0,  /* "benefit" 37771 */
      9,  21,  13,   1,  37,   5,   3,   1,  20,   0,  /* "benefited" 37781 */
      9,  21,  13,   1,  37,   5,   3,  31,  32,   0,  /* "benefiting" 37791 */
      9,  21,  13,   1,  12,   0,  /* "beneke" 37797 */
      9,  21,  13,   1,   7,   1,  12,  14,   0,  /* "benelux" 37806 */
      9,   1,  13,   1,  13,   8,   3,  26,   0,  /* "benenati" 37815 */
      9,  21,  13,  26,  14,   0,  /* "benes" 37821 */
      9,  21,  13,  31,  33,   0,  /* "benesch" 37827 */
      9,  21,  13,  31,  33,   0,  /* "benesh" 37833 */
      9,  15,  13,  21,   3,  26,   0,  /* "benetti" 37840 */
      9,  21,  13,   1,   3,   1,  13,   0,  /* "benetton" 37848 */
      9,  21,  13,   1,  22,  28,  13,   3,  27,   0,  /* "benevento" 37858 */
      9,  21,  13,   1,  22,  26,  20,  15,  14,   0,  /* "benevides" 37868 */
      9,   1,  13,  21,  22,   1,   7,   1,  13,  14,   0,  /* "benevolence" 37879 */
      9,   1,  13,  21,  22,   1,   7,   1,  13,   3,   0,  /* "benevolent" 37890 */
      9,  21,  13,  37,  26,   7,  20,   0,  /* "benfield" 37898 */
      9,  15,  32,  11,   8,   7,  26,   0,  /* "bengali" 37906 */
      9,  15,  32,  11,   8,   7,  26,  30,   0,  /* "bengalis" 37915 */
      9,  21,  32,  11,  27,  15,  42,  23,   1,   0,  /* "bengoechea" 37925 */
      9,  21,  32,  11,  14,   3,   1,  13,   0,  /* "bengston" 37934 */
      9,  21,  32,   3,  14,   1,  13,   0,  /* "bengtson" 37942 */
      9,  21,  32,  11,   1,   3,   0,  /* "benguet" 37949 */
      9,  21,  13,  38,   1,  17,  29,   0,  /* "benhamou" 37957 */
      9,  21,  13,  26,   0,  /* "beni" 37962 */
      9,   1,  13,  39,   3,   1,  20,   0,  /* "benighted" 37970 */
      9,   1,  13,  39,  13,   0,  /* "benign" 37976 */
      9,  15,  13,  23,  11,  13,   1,   0,  /* "benigna" 37984 */
      9,   1,  13,  39,  13,   7,  26,   0,  /* "benignly" 37992 */
      9,  21,  13,  23,  13,  41,  27,   0,  /* "benigno" 38000 */
      9,  21,  13,  26,  38,   8,  13,   1,   0,  /* "benihana" 38009 */
      9,  23,  13,   5,  13,   0,  /* "benin" 38015 */
      9,  15,  13,  26,  13,   8,   3,  26,   0,  /* "beninati" 38024 */
      9,  15,  13,  26,  13,  12,   8,  14,   1,   0,  /* "benincasa" 38034 */
      9,  21,  13,  31,  33,   0,  /* "benish" 38040 */
      9,  21,  13,  39,   3,  14,   0,  /* "benites" 38047 */
      9,  28,  13,  23,   3,  15,  30,   0,  /* "benitez" 38055 */
      9,  15,  13,  23,   3,  27,   0,  /* "benito" 38062 */
      9,  21,  13,  40,   1,  17,   1,  13,   0,  /* "benjamin" 38071 */
      9,  21,  13,  40,   1,  17,  15,  13,   0,  /* "benjimen" 38080 */
      9,  21,  13,   7,  19,  12,  14,   0,  /* "benlox" 38088 */
      9,  21,  13,   0,  /* "benn" 38092 */
      9,   1,  13,   8,   4,  20,  27,   0,  /* "bennardo" 38100 */
      9,  21,  13,   0,  /* "benne" 38104 */
      9,  21,  13,   1,  37,  26,   7,  20,   0,  /* "bennefield" 38113 */
      9,  21,  13,   1,   3,   0,  /* "bennett" 38119 */
      9,  15,  13,  21,   3,   0,  /* "bennette" 38125 */
      9,  21,  13,   1,   3,  14,   0,  /* "bennetts" 38132 */
      9,  21,  13,  31,  32,  37,  26,   7,  20,   0,  /* "benningfield" 38142 */
      9,  21,  13,  31,  32,  38,  18,  37,   0,  /* "benninghoff" 38151 */
      9,  21,  13,  31,  32,  12,   0,  /* "bennink" 38158 */
      9,   2,  13,  27,   0,  /* "beno" 38163 */
      9,  23,  13,  27,   1,  14,   3,   0,  /* "benoist" 38171 */
      9,  15,  13,  25,  13,  26,   0,  /* "benoni" 38178 */
      9,  21,  13,   1,  47,   5,   3,  14,   0,  /* "benowitz" 38187 */
      9,  21,  13,  50,   0,  /* "benoy" 38192 */
      9,  21,  13,  30,   0,  /* "bens" 38197 */
      9,  21,  13,  33,  51,  37,   0,  /* "benshoof" 38204 */
      9,  21,  13,  14,   7,  26,   0,  /* "bensley" 38211 */
      9,  21,  13,   3,   0,  /* "bent" 38216 */
      9,  21,  13,   3,   0,  /* "bente" 38221 */
      9,  21,   3,   1,  13,   0,  /* "benten" 38227 */
      9,  21,  13,  16,   1,   7,   0,  /* "benthall" 38234 */
      9,  15,  13,   3,  26,  22,  21,  11,  13,   1,   0,  /* "bentivegna" 38245 */
      9,  21,  13,   3,   1,  13,  39,   3,   0,  /* "bentonite" 38254 */
      9,  15,  13,  22,  15,  13,  23,  14,   3,  26,   0,  /* "benveniste" 38265 */
      9,  15,  13,  22,  15,  13,  29,   3,  26,   0,  /* "benvenuti" 38275 */
      9,  15,  13,  22,  15,  13,  29,   3,  27,   0,  /* "benvenuto" 38285 */
      9,  21,  13,  47,  15,   4,   0,  /* "benware" 38292 */
      9,  21,  13,  41,   1,  17,  23,  13,   0,  /* "benyamin" 38301 */
      9,   2,  13,  41,  27,   0,  /* "benyo" 38307 */
      9,  21,  13,  30,   0,  /* "benz" 38312 */
      9,  15,  13,  30,  23,  13,   0,  /* "benzene" 38319 */
      9,  21,  13,  30,  26,  13,   0,  /* "benzine" 38326 */
      9,  21,  13,  30,  31,  32,  10,   0,  /* "benzinger" 38334 */
      9,  48,  37,  10,   0,  /* "beougher" 38339 */
      9,   2,   1,  47,  45,   7,  37,   0,  /* "beowulf" 38347 */
      9,  31,  12,  47,  23,  16,   0,  /* "bequeath" 38354 */
      9,   1,  12,  47,  23,  16,   3,   0,  /* "bequeathed" 38362 */
      9,  21,   4,   1,   0,  /* "bera" 38367 */
      9,  21,   4,   1,  13,   0,  /* "beran" 38373 */
      9,  21,   4,   1,  13,  31,  12,   0,  /* "beranek" 38381 */
      9,  10,   8,   4,  20,  26,   0,  /* "berardi" 38388 */
      9,  10,   8,   4,  20,  27,   0,  /* "berardo" 38395 */
      9,  10,  19,   4,  20,  29,  42,  26,   0,  /* "berarducci" 38404 */
      9,  31,   4,   2,   3,   0,  /* "berate" 38410 */
      9,  31,   4,   2,   3,   1,  20,   0,  /* "berated" 38418 */
      9,  31,   4,   2,   3,  31,  32,   0,  /* "berating" 38426 */
      9,  10,   9,   5,   4,  26,   1,  13,   0,  /* "berberian" 38435 */
      9,  44,  12,   1,  13,   8,   7,   0,  /* "berchenall" 38443 */
      9,  44,  12,   3,  27,   7,  20,   0,  /* "berchtold" 38451 */
      9,  44,  20,  19,   7,   0,  /* "berdahl" 38457 */
      9,  44,  20,   1,  13,   0,  /* "berdan" 38463 */
      9,  10,  20,  23,  13,  26,   0,  /* "berdine" 38470 */
      9,   5,   4,   0,  /* "bere" 38474 */
      9,  10,  23,   1,   0,  /* "berea" 38479 */
      9,  10,  21,  37,   3,   0,  /* "bereft" 38485 */
      9,  10,  21,  11,   1,  22,  49,   0,  /* "beregovoy" 38493 */
      9,  21,   4,   1,  13,  20,  30,   1,  13,   0,  /* "berendzen" 38503 */
      9,   5,   4,   1,  13,  30,   0,  /* "berens" 38510 */
      9,  23,   4,  30,   0,  /* "beres" 38515 */
      9,   5,   4,  30,  37,  10,  20,   0,  /* "beresford" 38523 */
      9,  21,   4,   1,   3,   0,  /* "beret" 38529 */
      9,  21,   4,   1,   3,  14,   0,  /* "berets" 38536 */
      9,  10,  21,   3,   1,   0,  /* "beretta" 38542 */
      9,  10,  21,   3,   1,  14,   0,  /* "berettas" 38549 */
      9,   5,   4,   1,  30,  26,  13,   0,  /* "berezine" 38557 */
      9,  44,  11,   0,  /* "berg" 38561 */
      9,  10,  11,  19,  17,  23,  13,  26,   0,  /* "bergamini" 38570 */
      9,  10,  11,   8,  17,  27,   0,  /* "bergamo" 38577 */
      9,  44,  11,  20,  19,   7,   0,  /* "bergdahl" 38584 */
      9,  44,  11,  20,   8,   7,   0,  /* "bergdoll" 38591 */
      9,  44,  11,  20,  18,   4,  37,   0,  /* "bergdorf" 38599 */
      9,  44,  11,  15,  13,  20,  19,   7,   0,  /* "bergendahl" 38608 */
      9,  44,  11,  10,  36,  13,   0,  /* "bergeron" 38615 */
      9,  44,  40,   1,  30,   0,  /* "berges" 38621 */
      9,  44,  11,  15,   3,   0,  /* "berget" 38627 */
      9,  44,  11,  15,  22,   5,  13,   0,  /* "bergevin" 38635 */
      9,  44,  40,  26,   0,  /* "bergey" 38640 */
      9,  44,  11,   7,  24,  13,  20,   0,  /* "bergland" 38648 */
      9,  44,  11,   7,  31,  32,   0,  /* "bergling" 38655 */
      9,  44,  11,  33,  13,  39,  20,  10,   0,  /* "bergschneider" 38664 */
      9,  21,   4,  11,  30,  17,   1,   0,  /* "bergsma" 38672 */
      9,  44,  11,  14,   1,  13,   0,  /* "bergsten" 38679 */
      9,  44,  11,  14,   3,   4,  24,  13,  20,   0,  /* "bergstrand" 38689 */
      9,  44,  11,  14,   3,   4,  19,  17,   0,  /* "bergstrom" 38698 */
      9,  44,  11,  16,  25,   7,  20,   0,  /* "bergthold" 38706 */
      9,  44,  38,  27,   0,  /* "berhow" 38711 */
      9,  21,   4,  31,  32,   0,  /* "bering" 38717 */
      9,  21,   4,  31,  32,  10,   0,  /* "beringer" 38724 */
      9,  44,  31,  33,   0,  /* "berish" 38729 */
      9,  10,  40,  39,   1,   0,  /* "berjaya" 38735 */
      9,  44,  12,   0,  /* "berk" 38739 */
      9,  44,  12,   1,   9,  39,   7,   0,  /* "berkebile" 38747 */
      9,  44,  12,   7,  26,   0,  /* "berkeley" 38753 */
      9,  44,  12,  38,  39,  17,  10,   0,  /* "berkheimer" 38761 */
      9,  44,  12,   7,  26,   0,  /* "berklee" 38767 */
      9,  44,  12,   7,  39,  13,   0,  /* "berkline" 38774 */
      9,  44,  12,  33,  10,   0,  /* "berkshire" 38780 */
      9,  44,  12,  33,   5,   4,  30,   0,  /* "berkshires" 38788 */
      9,  44,  12,  14,   3,   4,  15,  14,  10,   0,  /* "berkstresser" 38798 */
      9,  44,   7,  34,  12,   0,  /* "berlack" 38804 */
      9,  10,   7,   8,  32,  11,   1,   0,  /* "berlanga" 38812 */
      9,  21,   4,   7,   1,  14,  12,  25,  13,  26,   0,  /* "berlascone" 38823 */
      9,  44,   7,   0,  /* "berle" 38827 */
      9,  44,   7,  21,   3,   0,  /* "berlet" 38833 */
      9,  44,   7,  21,  12,  14,   0,  /* "berlex" 38840 */
      9,  10,   7,   5,  13,  10,   0,  /* "berliner" 38847 */
      9,  10,   7,   5,  13,  10,  30,   0,  /* "berliners" 38855 */
      9,  44,   7,  31,  32,   0,  /* "berling" 38861 */
      9,  44,   7,  31,  32,  10,   0,  /* "berlinger" 38868 */
      9,  10,   7,   8,   3,  14,   0,  /* "berlottes" 38875 */
      9,  44,   7,   1,  14,  12,  25,  13,  26,   0,  /* "berlusconi" 38885 */
      9,  44,  17,   0,  /* "berm" 38889 */
      9,  21,   4,  17,  26,   1,   0,  /* "bermea" 38896 */
      9,  10,  17,  41,  29,  20,   1,   0,  /* "bermuda" 38904 */
      9,  10,  17,  41,  29,  20,   1,  30,   0,  /* "bermudas" 38913 */
      9,  10,  17,  41,  29,  20,  30,   0,  /* "bermudes" 38921 */
      9,  10,  17,  41,  29,  20,  21,  30,   0,  /* "bermudez" 38930 */
      9,  44,  13,   0,  /* "bern" 38934 */
      9,  21,   4,  13,   1,   0,  /* "berna" 38940 */
      9,  44,  13,   1,   9,  39,   0,  /* "bernabei" 38947 */
      9,  10,  13,   8,   3,  14,  12,  26,   0,  /* "bernacki" 38956 */
      9,  44,  13,   1,  20,  26,  13,   0,  /* "bernadene" 38964 */
      9,  10,  13,   1,  20,  21,   3,   0,  /* "bernadette" 38972 */
      9,  44,  13,   1,  20,   5,  13,   0,  /* "bernadin" 38980 */
      9,  10,  13,   1,  20,  23,  13,   0,  /* "bernadine" 38988 */
      9,  44,  13,   1,  20,  23,  13,  27,   0,  /* "bernadino" 38997 */
      9,  10,  13,   8,  17,   1,   0,  /* "bernama" 39004 */
      9,  10,  13,   8,   4,  20,   0,  /* "bernard" 39011 */
      9,  10,  13,   8,   4,  20,  26,   0,  /* "bernardi" 39019 */
      9,  44,  13,  19,   4,  20,  26,  13,   0,  /* "bernardin" 39028 */
      9,  10,  13,  19,   4,  20,  23,  13,  26,   0,  /* "bernardini" 39038 */
      9,  10,  13,   1,  20,  23,  13,  27,   0,  /* "bernardino" 39047 */
      9,  10,  13,   8,   4,  20,  27,   0,  /* "bernardo" 39055 */
      9,  10,  13,   8,   4,  20,  30,   0,  /* "bernards" 39063 */
      9,  10,  13,   8,   4,  20,  26,   0,  /* "bernardy" 39071 */
      9,  10,  13,  19,  14,  12,  25,  13,  26,   0,  /* "bernasconi" 39081 */
      9,  44,  13,   1,   3,   0,  /* "bernat" 39087 */
      9,  10,  13,   2,   0,  /* "bernay" 39092 */
      9,  44,  13,   9,   8,  12,   0,  /* "bernbach" 39099 */
      9,  44,  13,   3,   0,  /* "bernd" 39104 */
      9,  10,  13,  39,  14,   0,  /* "berneice" 39110 */
      9,  10,  13,  21,   3,   0,  /* "bernet" 39116 */
      9,  44,  13,  38,  19,   4,  20,   0,  /* "bernhard" 39124 */
      9,  44,  13,  38,  19,   4,   3,   0,  /* "bernhart" 39132 */
      9,  44,  13,  38,  39,  17,   0,  /* "bernheim" 39139 */
      9,  44,  13,  38,  39,  17,  10,   0,  /* "bernheimer" 39147 */
      9,  21,   4,  13,  26,   0,  /* "berni" 39153 */
      9,  21,   4,  13,  26,   1,   0,  /* "bernia" 39160 */
      9,  10,  13,  23,  14,   0,  /* "bernice" 39166 */
      9,  10,  13,  23,   3,   1,   0,  /* "bernita" 39173 */
      9,  10,  13,  29,   7,  26,   0,  /* "bernoulli" 39180 */
      9,  44,  13,  14,   1,  13,   0,  /* "bernsen" 39187 */
      9,  44,  13,  14,   3,  39,  13,  30,   0,  /* "bernsteins" 39196 */
      9,  21,   4,  27,   0,  /* "bero" 39201 */
      9,  21,   4,   1,  16,   0,  /* "berreth" 39207 */
      9,  21,   4,   1,   3,   0,  /* "berrett" 39213 */
      9,  15,   4,  23,  27,  30,   0,  /* "berrios" 39220 */
      9,  21,   4,  26,  30,   0,  /* "berris" 39226 */
      9,  21,   4,  36,  32,   0,  /* "berrong" 39232 */
      9,  21,   4,  26,  38,   5,   7,   0,  /* "berryhill" 39240 */
      9,  21,   4,  26,   7,  39,  12,   0,  /* "berrylike" 39248 */
      9,  21,   4,  26,  17,   1,  13,   0,  /* "berryman" 39256 */
      9,  10,  14,  44,  12,   0,  /* "berserk" 39262 */
      9,  10,  33,   8,  20,   0,  /* "bershad" 39268 */
      9,  44,  14,   3,  26,  13,   0,  /* "berstein" 39275 */
      9,  44,   3,   0,  /* "bert" 39279 */
      9,  10,   3,  21,   7,  26,   0,  /* "bertelli" 39286 */
      9,  44,   3,   1,   7,  30,  17,   1,  13,   0,  /* "bertelsmann" 39296 */
      9,  44,  16,   1,   7,  19,   3,   0,  /* "berthelot" 39304 */
      9,  44,  16,  26,  29,  17,  26,   0,  /* "berthiaume" 39312 */
      9,  21,   4,   3,  26,   0,  /* "berti" 39318 */
      9,  44,   3,   5,   7,   0,  /* "bertil" 39324 */
      9,  10,   3,  23,  13,  26,   0,  /* "bertini" 39331 */
      9,  10,   3,  23,  13,  27,   0,  /* "bertino" 39338 */
      9,  44,   3,   1,   7,  31,  32,   0,  /* "bertling" 39346 */
      9,  44,   3,  27,   7,  20,   0,  /* "bertold" 39353 */
      9,  10,   3,  27,   7,  25,   3,  26,   0,  /* "bertolotti" 39362 */
      9,  44,   3,  27,   7,  29,  42,  26,   0,  /* "bertolucci" 39371 */
      9,  44,   3,   1,  13,   0,  /* "berton" 39377 */
      9,  10,   3,  25,  13,  26,   0,  /* "bertone" 39384 */
      9,  44,   3,   4,   1,  20,   0,  /* "bertrade" 39391 */
      9,  44,   3,   4,   1,  17,   0,  /* "bertram" 39398 */
      9,  44,   3,   4,   1,  13,   0,  /* "bertran" 39405 */
      9,  10,   3,  29,  42,  26,   0,  /* "bertucci" 39412 */
      9,  21,   4,  29,   9,   0,  /* "berube" 39418 */
      9,   5,   4,  29,  17,  15,  13,   0,  /* "berumen" 39426 */
      9,  44,  47,  36,  32,  10,   0,  /* "berwanger" 39433 */
      9,  10,   5,   7,  26,   1,  17,   0,  /* "beryllium" 39441 */
      9,  23,  30,   0,  /* "bes" 39445 */
      9,   1,  14,  24,  13,  12,   1,  13,   0,  /* "besancon" 39454 */
      9,  21,  30,   1,  13,   3,   0,  /* "besant" 39461 */
      9,  23,  14,  36,   0,  /* "besaw" 39466 */
      9,  21,  14,  31,  12,  10,   0,  /* "besecker" 39473 */
      9,   1,  14,  21,   3,   0,  /* "beset" 39479 */
      9,   1,  14,  21,   3,  31,  32,   0,  /* "besetting" 39487 */
      9,   5,  33,   8,   4,   1,   0,  /* "beshara" 39494 */
      9,  21,  33,   7,  36,  14,   0,  /* "beshloss" 39501 */
      9,  21,  33,  10,   0,  /* "beshore" 39506 */
      9,   1,  14,  39,  20,   0,  /* "beside" 39512 */
      9,   1,  14,  39,  20,  30,   0,  /* "besides" 39519 */
      9,  21,  14,   1,   7,  10,   0,  /* "besler" 39526 */
      9,   4,  21,  14,  13,  10,   0,  /* "besner" 39533 */
      9,   1,  14,   6,  23,  12,   0,  /* "bespeak" 39540 */
      9,   1,  14,   6,  23,  12,  14,   0,  /* "bespeaks" 39548 */
      9,   1,  14,   6,  21,  12,   3,   1,  12,   1,   7,   0,  /* "bespectacle" 39560 */
      9,   1,  14,   6,  21,  12,   3,   1,  12,   1,   7,  20,   0,  /* "bespectacled" 39573 */
      9,  21,  14,   0,  /* "bess" 39577 */
      9,  21,  14,   1,  17,  10,   0,  /* "bessemer" 39584 */
      9,  15,  14,  21,   3,   0,  /* "bessette" 39590 */
      9,  15,  14,   5,   4,  26,   0,  /* "bessire" 39597 */
      9,  21,  14,   3,   0,  /* "best" 39602 */
      9,  15,  14,  42,  24,   7,   1,   3,  26,   0,  /* "bestiality" 39612 */
      9,   1,  14,   3,  25,   0,  /* "bestow" 39618 */
      9,   1,  14,   3,  25,  20,   0,  /* "bestowed" 39625 */
      9,   1,  14,   3,  25,  31,  32,   0,  /* "bestowing" 39633 */
      9,   1,  14,   3,  25,  30,   0,  /* "bestows" 39640 */
      9,   1,  14,   3,   4,  25,  20,   0,  /* "bestrode" 39648 */
      9,  21,   3,   0,  /* "bet" 39652 */
      9,   2,   3,   1,   0,  /* "beta" 39657 */
      9,   2,   3,   1,  17,  34,  12,  14,   0,  /* "betamax" 39666 */
      9,  21,   3,   1,  13,  12,  36,   4,   3,   0,  /* "betancourt" 39676 */
      9,   1,   3,  24,  32,  12,  10,   0,  /* "betancur" 39684 */
      9,  21,   3,  19,   4,   0,  /* "betar" 39690 */
      9,   2,   3,   1,  30,   0,  /* "betas" 39696 */
      9,   2,   3,   1,  14,  21,   4,   8,  13,   0,  /* "betaseron" 39706 */
      9,  21,   3,   1,  22,  19,  13,   0,  /* "betavon" 39714 */
      9,  21,   3,   1,   7,   0,  /* "betel" 39720 */
      9,  15,   3,   2,   3,   1,   0,  /* "beteta" 39727 */
      9,  21,  16,   0,  /* "beth" 39731 */
      9,  21,  46,  26,   1,   0,  /* "bethea" 39737 */
      9,   1,  16,  21,  30,  20,   1,   0,  /* "bethesda" 39745 */
      9,  21,  16,   7,   1,  38,  21,  17,   0,  /* "bethlehem" 39754 */
      9,   1,  16,  41,  29,  13,   0,  /* "bethune" 39761 */
      9,   5,   3,  39,  20,   0,  /* "betide" 39767 */
      9,  21,   3,  14,   0,  /* "bets" 39772 */
      9,  21,   3,  14,  38,   8,   4,   3,   0,  /* "betschart" 39781 */
      9,  21,   3,   0,  /* "bett" 39785 */
      9,  21,   3,  42,  10,   0,  /* "bettcher" 39791 */
      9,  21,   3,  26,   0,  /* "bette" 39796 */
      9,  21,   3,   1,  13,  12,  36,   4,   3,   0,  /* "bettencourt" 39806 */
      9,  21,   3,   1,  13,  38,  52,  30,   1,  13,   0,  /* "bettenhausen" 39817 */
      9,  21,   3,  10,  20,   0,  /* "bettered" 39823 */
      9,  21,   3,  10,  31,  40,   0,  /* "betteridge" 39830 */
      9,  21,   3,  26,  30,   0,  /* "bettes" 39836 */
      9,   1,   3,  23,  13,   1,   0,  /* "bettina" 39843 */
      9,  15,   3,  23,  13,  26,   0,  /* "bettini" 39850 */
      9,  15,   3,  23,  13,  27,   0,  /* "bettino" 39857 */
      9,  21,   3,   1,  13,   0,  /* "betton" 39863 */
      9,  21,   3,  10,   0,  /* "bettor" 39868 */
      9,  21,   3,  10,  30,   0,  /* "bettors" 39874 */
      9,  21,   3,  14,   0,  /* "betts" 39879 */
      9,   1,   3,  47,  23,  13,   0,  /* "between" 39886 */
      9,   1,   3,  47,  23,  13,  30,   0,  /* "betweens" 39894 */
      9,  21,   3,  14,   0,  /* "betz" 39899 */
      9,  21,   3,  30,  27,   7,  20,   0,  /* "betzold" 39907 */
      9,  29,   0,  /* "beu" 39910 */
      9,  49,  12,   1,   7,  10,   0,  /* "beucler" 39917 */
      9,  29,  12,  23,  17,   1,   0,  /* "beukema" 39924 */
      9,  29,   7,   1,   0,  /* "beula" 39929 */
      9,  41,  29,   7,   1,   0,  /* "beulah" 39935 */
      9,  23,   1,  17,  10,   0,  /* "beumer" 39941 */
      9,  35,   4,  26,   0,  /* "beury" 39946 */
      9,  41,  29,   3,  21,   7,   0,  /* "beutel" 39953 */
      9,  41,  29,  16,   5,  13,   0,  /* "beuthin" 39960 */
      9,  49,   3,   1,   7,  10,   0,  /* "beutler" 39967 */
      9,  41,  29,  26,  30,   0,  /* "beuys" 39973 */
      9,  21,  22,   0,  /* "bev" 39977 */
      9,  15,  22,   8,  12,  47,   1,   0,  /* "bevacqua" 39985 */
      9,  15,  22,   1,   7,   8,  12,   1,   0,  /* "bevalaqua" 39994 */
      9,  15,  22,   8,  12,   1,   0,  /* "bevaqua" 40001 */
      9,  31,  22,   8,   4,  20,   0,  /* "bevard" 40008 */
      9,  21,  22,   1,   7,  20,   0,  /* "bevelled" 40015 */
      9,  23,  22,   1,  13,  30,   0,  /* "bevens" 40022 */
      9,  21,  22,  10,  31,  40,   0,  /* "beverage" 40029 */
      9,  21,  22,  10,  31,  40,   0,  /* "beveridge" 40036 */
      9,  21,  22,  26,  10,   0,  /* "bevier" 40042 */
      9,  15,  22,  26,   7,   8,  12,  47,   1,   0,  /* "bevilacqua" 40052 */
      9,  23,  22,   5,   7,   0,  /* "beville" 40058 */
      9,  21,  22,  26,   0,  /* "bevy" 40063 */
      9,   1,  47,  21,   4,   0,  /* "beware" 40069 */
      9,  41,  29,   7,  26,   0,  /* "bewley" 40075 */
      9,  21,  12,  14,   7,  26,   0,  /* "bexley" 40082 */
      9,   2,   0,  /* "bey" 40085 */
      9,   2,  10,   0,  /* "beyer" 40089 */
      9,  39,   4,   1,   7,   0,  /* "beyerle" 40095 */
      9,  39,   4,   7,  39,  13,   0,  /* "beyerlein" 40102 */
      9,   2,  10,  30,   0,  /* "beyers" 40107 */
      9,  39,   4,  14,  20,  36,   4,  37,   0,  /* "beyersdorf" 40116 */
      9,   2,   7,   0,  /* "beyl" 40120 */
      9,   2,  13,   1,  13,   0,  /* "beynon" 40126 */
      9,  31,   8,  13,  20,   0,  /* "beyond" 40132 */
      9,   1,  30,  21,   4,   0,  /* "bezaire" 40138 */
      9,  21,  30,  20,  31,  12,   0,  /* "bezdek" 40145 */
      9,  21,  30,  27,   7,  20,   0,  /* "bezold" 40152 */
      9,   8,  32,  11,   4,   1,   0,  /* "bhangra" 40159 */
      9,   8,   4,   8,   3,   1,   0,  /* "bharata" 40166 */
      9,   8,  33,   1,   0,  /* "bhatia" 40171 */
      9,  24,   3,   0,  /* "bhatt" 40175 */
      9,   8,   3,   1,  42,   8,   4,  40,  26,   0,  /* "bhattacharjy" 40185 */
      9,   5,  12,  33,   8,   0,  /* "bhiksha" 40191 */
      9,   5,   4,   1,  20,   0,  /* "bhirud" 40197 */
      9,  27,   6,   8,   7,   0,  /* "bhopal" 40203 */
      9,  29,   3,  24,  13,   0,  /* "bhutan" 40209 */
      9,  29,   3,  27,   0,  /* "bhutto" 40214 */
      9,  39,   0,  /* "bi" 40217 */
      9,  26,  24,  40,  26,   0,  /* "biaggi" 40223 */
      9,  23,   1,  11,  23,  13,  26,   0,  /* "biaggini" 40231 */
      9,  26,   1,  40,  23,  13,  26,   0,  /* "biagini" 40239 */
      9,  26,   8,  40,  26,  25,  13,  26,   0,  /* "biagioni" 40248 */
      9,  26,   8,   7,   1,  14,   0,  /* "bialas" 40255 */
      9,  26,   8,   7,  15,  12,   0,  /* "bialek" 40262 */
      9,  26,   8,   7,  12,   1,  13,   0,  /* "bialkin" 40270 */
      9,  26,   1,   7,  12,  48,  14,  12,  26,   0,  /* "bialkowski" 40280 */
      9,  26,   8,   7,  26,   0,  /* "bialy" 40286 */
      9,  26,   1,  17,  18,  13,   3,  26,   0,  /* "biamonte" 40295 */
      9,  26,   8,  32,  12,   1,   0,  /* "bianca" 40302 */
      9,  26,   8,  13,  42,  26,   0,  /* "bianchi" 40309 */
      9,  26,   8,  32,  12,  27,   0,  /* "bianco" 40316 */
      9,  26,  19,  32,  12,  25,  13,  26,   0,  /* "bianconi" 40325 */
      9,  26,  19,  32,  12,  29,   7,  26,   0,  /* "bianculli" 40334 */
      9,  39,  24,  13,  29,   1,   7,   0,  /* "biannual" 40342 */
      9,  39,   1,  14,   0,  /* "bias" 40347 */
      9,  39,   1,  14,   3,   0,  /* "biased" 40353 */
      9,  39,   1,  14,   1,  30,   0,  /* "biases" 40360 */
      9,  39,  24,  12,  14,  26,   1,   7,   0,  /* "biaxial" 40369 */
      9,   5,   9,   0,  /* "bib" 40373 */
      9,  23,   9,   1,   0,  /* "biba" 40378 */
      9,   5,   9,   0,  /* "bibb" 40382 */
      9,   5,   9,  26,   0,  /* "bibbee" 40387 */
      9,  23,   9,  27,   0,  /* "bibbo" 40392 */
      9,   5,   9,  25,   0,  /* "bibeault" 40397 */
      9,  39,   9,  10,   0,  /* "biber" 40402 */
      9,   5,   9,  23,   0,  /* "bibi" 40407 */
      9,  39,   9,   1,   7,   0,  /* "bible" 40413 */
      9,  39,   9,   1,   7,  10,   0,  /* "bibler" 40420 */
      9,  39,   9,   1,   7,  30,   0,  /* "bibles" 40427 */
      9,   5,   9,   7,   1,  12,   1,   7,   0,  /* "biblical" 40436 */
      9,   5,   9,   7,  26,   8,  11,   4,   1,  37,  26,  30,   0,  /* "bibliographies" 40449 */
      9,   5,   9,   7,  26,   8,  11,   4,   1,  37,  26,   0,  /* "bibliography" 40461 */
      9,   5,   9,  30,   0,  /* "bibs" 40466 */
      9,  39,   9,  26,   0,  /* "biby" 40471 */
      9,   5,  12,   0,  /* "bic" 40475 */
      9,  39,  12,   8,   4,   9,   1,  13,   1,   3,   0,  /* "bicarbonate" 40486 */
      9,  39,  14,   0,  /* "bice" 40490 */
      9,  39,  14,  21,  13,   3,   1,  13,  21,   4,  26,   0,  /* "bicentenary" 40502 */
      9,  39,  14,  15,  13,   3,  21,  13,  26,   1,   7,   0,  /* "bicentennial" 40514 */
      9,  39,  14,  21,   6,  14,   0,  /* "biceps" 40521 */
      9,   5,  12,   1,   7,  10,   0,  /* "bichler" 40528 */
      9,   5,  12,   0,  /* "bick" 40532 */
      9,   5,  12,   1,   3,   0,  /* "bickett" 40538 */
      9,   5,  12,   1,   7,   0,  /* "bickle" 40544 */
      9,   5,  12,  13,   1,   7,   0,  /* "bicknell" 40551 */
      9,   5,  12,  14,   7,  10,   0,  /* "bicksler" 40558 */
      9,  31,  12,  25,  14,   3,   1,   7,   0,  /* "bicoastal" 40567 */
      9,  39,  12,  35,  14,   6,   1,  20,   0,  /* "bicuspid" 40576 */
      9,  39,  12,  35,  14,   6,   1,  20,  30,   0,  /* "bicuspids" 40586 */
      9,  39,  14,  31,  12,   1,   7,   0,  /* "bicycle" 40594 */
      9,  39,  14,  31,  12,   1,   7,  20,   0,  /* "bicycled" 40603 */
      9,  39,  14,  31,  12,   1,   7,  30,   0,  /* "bicycles" 40612 */
      9,  39,  14,   5,  12,   1,   7,  31,  32,   0,  /* "bicycling" 40622 */
      9,  39,  14,   5,  12,   7,   1,  14,   3,   0,  /* "bicyclist" 40632 */
      9,  39,  14,   5,  12,   7,   1,  14,   3,  14,   0,  /* "bicyclists" 40643 */
      9,   5,  20,   0,  /* "bid" 40647 */
      9,   5,  20,  12,  27,  14,   0,  /* "bidcos" 40654 */
      9,   5,  20,  31,  12,  14,   0,  /* "biddix" 40661 */
      9,   5,  20,   1,   7,   0,  /* "biddle" 40667 */
      9,  39,  20,   0,  /* "bide" 40671 */
      9,  39,  20,   1,  13,   0,  /* "biden" 40677 */
      9,  39,  20,  10,  17,   1,  13,   0,  /* "biderman" 40685 */
      9,  39,  20,  31,  32,   0,  /* "biding" 40691 */
      9,  39,  20,  31,  32,  10,   0,  /* "bidinger" 40698 */
      9,   5,  20,  30,   0,  /* "bids" 40703 */
      9,  39,  20,  10,  17,   1,  13,   0,  /* "biedermann" 40711 */
      9,  23,  20,  10,  17,  39,   4,   0,  /* "biedermeier" 40719 */
      9,  31,  40,   5,   3,  14,  12,  26,   0,  /* "biedrzycki" 40728 */
      9,  23,  11,   1,   7,  10,   0,  /* "biegler" 40735 */
      9,  23,  38,   1,   7,   0,  /* "biehle" 40741 */
      9,  23,   7,   0,  /* "biel" 40745 */
      9,  26,   7,  24,  13,  14,  12,  26,   0,  /* "bielanski" 40754 */
      9,  23,   7,   1,   3,   0,  /* "bielat" 40760 */
      9,  26,   7,   8,  37,  14,  12,  26,   0,  /* "bielawski" 40769 */
      9,  26,   7,  21,   3,  14,  12,  26,   0,  /* "bielecki" 40778 */
      9,  23,   7,   1,  37,  15,   7,  20,   0,  /* "bielefeld" 40787 */
      9,  23,   7,   1,  37,   5,   7,   3,   0,  /* "bielefeldt" 40796 */
      9,   1,   7,   5,   3,  14,  12,  26,   0,  /* "bielicki" 40805 */
      9,   1,   7,   5,  13,  14,  12,  26,   0,  /* "bielinski" 40814 */
      9,  23,  13,   0,  /* "bien" 40818 */
      9,   5,  13,  26,  15,  12,   0,  /* "bieniek" 40825 */
      9,  31,  32,  12,  18,  37,  14,  12,  26,   0,  /* "bienkowski" 40835 */
      9,  26,  21,  13,   2,   7,   0,  /* "biennale" 40842 */
      9,  39,  21,  13,  26,   1,   7,   0,  /* "biennial" 40850 */
      9,  23,  13,  14,   3,   8,  12,   0,  /* "bienstock" 40858 */
      9,   1,  13,  22,   2,  13,  47,  15,   0,  /* "bienvenue" 40867 */
      9,  23,   4,   0,  /* "bier" 40871 */
      9,   5,   4,   9,   8,   4,  10,   0,  /* "bierbarror" 40879 */
      9,   5,   4,   9,  52,  17,   0,  /* "bierbaum" 40886 */
      9,   5,   4,   9,   1,  14,   0,  /* "bierbusse" 40893 */
      9,   5,   4,   7,  39,  13,   0,  /* "bierlein" 40900 */
      9,  31,   4,  13,   8,   3,  14,  12,  26,   0,  /* "biernacki" 40910 */
      9,  31,   4,  13,  24,   3,   0,  /* "biernat" 40917 */
      9,  23,   4,  30,   0,  /* "biers" 40922 */
      9,   5,   4,  47,  10,  16,   0,  /* "bierwirth" 40929 */
      9,  39,  30,   0,  /* "bies" 40933 */
      9,  23,  14,  31,  12,  10,   0,  /* "biesecker" 40940 */
      9,  23,  22,   0,  /* "biev" 40944 */
      9,   5,  37,   0,  /* "biff" 40948 */
      9,   5,  37,   1,   7,   0,  /* "biffle" 40954 */
      9,   5,  37,   1,  20,   1,   0,  /* "bifida" 40961 */
      9,  39,  37,  27,  12,   1,   7,   0,  /* "bifocal" 40969 */
      9,  39,  37,  27,  12,   1,   7,  30,   0,  /* "bifocals" 40978 */
      9,   1,  37,  29,   7,  12,  27,   0,  /* "bifulco" 40986 */
      9,   5,  37,  10,  12,   2,   3,   0,  /* "bifurcate" 40994 */
      9,   5,  37,  10,  12,   2,   3,   1,  20,   0,  /* "bifurcated" 41004 */
      9,   5,  37,  10,  12,   2,  33,   1,  13,   0,  /* "bifurcation" 41014 */
      9,   5,  11,   0,  /* "big" 41018 */
      9,   5,  11,   1,   7,  25,   0,  /* "bigelow" 41025 */
      9,   5,  11,  39,  30,   0,  /* "bigeyes" 41031 */
      9,  23,  40,  26,  27,   0,  /* "biggio" 41037 */
      9,  39,  11,  38,   1,  17,   0,  /* "bigham" 41044 */
      9,   5,  11,  38,  18,   4,  13,   0,  /* "bighorn" 41052 */
      9,   5,  11,  38,  18,   4,  13,  30,   0,  /* "bighorns" 41061 */
      9,  39,  11,   1,   7,  10,   0,  /* "bigler" 41068 */
      9,   5,  11,   7,   5,  13,   0,  /* "biglin" 41075 */
      9,   5,  11,   7,  27,   0,  /* "biglow" 41081 */
      9,  31,  11,  13,  21,   7,   0,  /* "bignell" 41088 */
      9,  23,  11,  27,  30,   0,  /* "bigos" 41094 */
      9,   5,  11,   1,   3,   0,  /* "bigot" 41100 */
      9,   5,  11,  30,   0,  /* "bigs" 41105 */
      9,   5,  11,   3,  39,  17,   0,  /* "bigtime" 41112 */
      9,  23,  38,   8,  42,   0,  /* "bihac" 41118 */
      9,   5,  38,   8,   4,  26,   0,  /* "bihari" 41125 */
      9,   5,   7,   0,  /* "bihl" 41129 */
      9,   5,  17,   0,  /* "bihm" 41133 */
      9,   5,  13,   0,  /* "bihn" 41137 */
      9,  39,  40,  34,  12,   0,  /* "bijac" 41143 */
      9,   5,  40,   1,  13,   0,  /* "bijan" 41149 */
      9,  31,  40,  21,   7,  40,  26,  13,   1,   0,  /* "bijeljina" 41159 */
      9,  26,  43,  45,   4,   0,  /* "bijur" 41165 */
      9,  39,  12,   0,  /* "bike" 41169 */
      9,  39,  12,   3,   0,  /* "biked" 41174 */
      9,  39,  12,  10,   0,  /* "biker" 41179 */
      9,  39,  12,  10,  30,   0,  /* "bikers" 41185 */
      9,  39,  12,  14,   0,  /* "bikes" 41190 */
      9,   5,  12,   5,  13,   0,  /* "bikin" 41196 */
      9,  39,  12,  31,  32,   0,  /* "biking" 41202 */
      9,  31,  12,  23,  13,  26,   0,  /* "bikini" 41209 */
      9,   1,  12,  23,  13,  26,  30,   0,  /* "bikinis" 41217 */
      9,  23,  12,  27,   0,  /* "biko" 41222 */
      9,   5,   7,   0,  /* "bil" 41226 */
      9,  23,   7,   1,   0,  /* "bila" 41231 */
      9,   5,   7,   9,  48,   0,  /* "bilbao" 41237 */
      9,   5,   7,   9,  25,   0,  /* "bilbo" 41243 */
      9,  23,   7,   9,   4,  27,   0,  /* "bilbro" 41250 */
      9,   5,   7,  20,   0,  /* "bild" 41255 */
      9,  39,   7,  20,  10,   9,  34,  12,   0,  /* "bilderback" 41264 */
      9,  39,   7,   0,  /* "bile" 41268 */
      9,   5,   7,  15,  12,   0,  /* "bilek" 41274 */
      9,   1,   7,  21,   7,  27,   0,  /* "bilello" 41281 */
      9,  39,   7,  30,   0,  /* "biles" 41286 */
      9,   1,   7,   5,   3,  14,  12,  26,   0,  /* "bilicki" 41295 */
      9,  39,   7,  31,  32,  30,   0,  /* "bilings" 41302 */
      9,  39,   7,   5,  32,  11,  47,   1,   7,   0,  /* "bilingual" 41312 */
      9,  39,   7,   5,  32,  11,  47,   1,   7,   5,  30,   1,  17,   0,  /* "bilingualism" 41326 */
      9,   1,   7,   5,  13,  14,  12,  26,   0,  /* "bilinski" 41335 */
      9,   1,   7,   5,   4,   1,  12,   1,  14,   0,  /* "bilirakis" 41345 */
      9,   5,   7,  12,   0,  /* "bilk" 41350 */
      9,   5,   7,   0,  /* "bill" 41354 */
      9,   5,   7,   1,   9,   1,   7,   0,  /* "billable" 41362 */
      9,   5,   7,   1,  13,  12,  18,   4,   3,   0,  /* "billancourt" 41372 */
      9,   1,   7,   8,   4,  20,   0,  /* "billard" 41379 */
      9,  39,   7,   0,  /* "bille" 41383 */
      9,   5,   7,  10,  23,  12,   1,   0,  /* "billerica" 41391 */
      9,   5,   7,  26,   3,  10,   0,  /* "billeter" 41398 */
      9,   5,   7,   1,   3,   0,  /* "billett" 41404 */
      9,   5,   7,  41,  10,  20,   0,  /* "billiard" 41411 */
      9,   5,   7,  31,  32,  30,   7,  26,   0,  /* "billingslea" 41420 */
      9,   5,   7,  26,  19,   3,   0,  /* "billiot" 41427 */
      9,   5,   7,  26,   3,  10,   0,  /* "billiter" 41434 */
      9,   5,   7,   1,   6,   0,  /* "billup" 41440 */
      9,   5,   7,   1,   6,  14,   0,  /* "billups" 41447 */
      9,   5,   7,   1,  20,  27,   0,  /* "bilodeau" 41454 */
      9,   5,   7,  25,   3,   1,   0,  /* "bilotta" 41461 */
      9,   5,   7,   8,   3,  26,   0,  /* "bilotti" 41468 */
      9,   5,   7,  27,   0,  /* "bilow" 41473 */
      9,   1,   7,  35,  12,  14,  26,   0,  /* "biloxi" 41481 */
      9,   5,   7,   3,  17,  18,   4,   0,  /* "biltmore" 41489 */
      9,   5,   7,  26,   0,  /* "bily" 41494 */
      9,   5,   7,  26,  29,   0,  /* "bilyeu" 41500 */
      9,   5,   7,  30,  21,   4,  26,   1,  13,   0,  /* "bilzerian" 41510 */
      9,  23,  17,   1,   0,  /* "bima" 41515 */
      9,   5,  17,   9,  27,  14,   0,  /* "bimbos" 41522 */
      9,   5,  17,   1,  13,  26,   0,  /* "bimini" 41529 */
      9,  39,  17,  25,  20,   1,   7,   0,  /* "bimiodal" 41537 */
      9,  39,  17,  35,  13,  16,   7,  26,   0,  /* "bimonthly" 41546 */
      9,   5,  13,   0,  /* "bin" 41550 */
      9,  23,  13,   1,   0,  /* "bina" 41555 */
      9,  39,  13,  10,  26,   0,  /* "binary" 41561 */
      9,  39,  13,  24,  33,   1,  13,   1,   7,   0,  /* "binational" 41571 */
      9,  39,  13,  20,   0,  /* "bind" 41576 */
      9,  39,  13,  20,  10,   0,  /* "binder" 41582 */
      9,  39,  13,  20,  10,  30,   0,  /* "binders" 41589 */
      9,  39,  13,  20,  31,  32,   0,  /* "binding" 41596 */
      9,   5,  13,  20,   1,   7,   0,  /* "bindle" 41603 */
      9,   5,  13,  20,   1,   7,  30,   0,  /* "bindles" 41611 */
      9,  39,  13,  20,  30,   0,  /* "binds" 41617 */
      9,  39,  13,  30,   0,  /* "bines" 41622 */
      9,   5,  32,   0,  /* "bing" 41626 */
      9,  23,  32,  11,   1,   0,  /* "binga" 41632 */
      9,   5,  32,   1,  17,   1,  13,   0,  /* "bingaman" 41640 */
      9,   5,  32,  11,   1,  13,  38,  39,  17,  10,   0,  /* "bingenheimer" 41651 */
      9,   5,  32,   1,  17,   0,  /* "bingham" 41657 */
      9,   5,  32,   1,  17,   3,   1,  13,   0,  /* "binghamton" 41666 */
      9,   5,  32,  11,  31,  32,   0,  /* "binging" 41673 */
      9,   5,  32,  11,   1,   7,   0,  /* "bingle" 41680 */
      9,   5,  32,   7,  26,   0,  /* "bingley" 41686 */
      9,   5,  32,  12,   0,  /* "bink" 41691 */
      9,   5,  13,   0,  /* "binn" 41695 */
      9,   1,  13,   8,  12,  41,   1,   7,  10,   0,  /* "binocular" 41705 */
      9,   1,  13,   8,  12,  41,   1,   7,  10,  30,   0,  /* "binoculars" 41716 */
      9,  39,  13,  25,  17,  26,   1,   7,   0,  /* "binomial" 41725 */
      9,   5,  13,  30,   0,  /* "bins" 41730 */
      9,   5,  13,  30,   0,  /* "binz" 41735 */
      9,  39,  25,   0,  /* "bio" 41739 */
      9,  39,   1,  42,   1,  17,   0,  /* "biochem" 41746 */
      9,  39,  27,  12,  21,  17,   1,  12,   1,   7,   0,  /* "biochemical" 41757 */
      9,  39,  27,  12,  21,  17,   1,  14,   3,   0,  /* "biochemist" 41767 */
      9,  39,  27,  12,  21,  17,   1,  14,   3,   4,  26,   0,  /* "biochemistry" 41779 */
      9,  39,   1,  14,  23,  13,   0,  /* "biocine" 41786 */
      9,  39,   1,  12,   8,  13,   3,   4,  19,   7,   0,  /* "biocontrol" 41797 */
      9,  39,  27,  12,   4,  24,  37,   3,   0,  /* "biocraft" 41806 */
      9,  39,  27,  20,   1,  11,   4,   2,  20,   1,   9,   1,   7,   0,  /* "biodegradable" 41820 */
      9,  39,  27,  20,  39,  22,  44,  14,   0,  /* "biodiverse" 41829 */
      9,  39,  27,  20,  39,  22,  44,  14,   1,   3,  26,   0,  /* "biodiversity" 41841 */
      9,  39,  27,  21,  13,  40,   1,  13,   5,   4,   0,  /* "bioengineer" 41852 */
      9,  39,  27,  21,  13,  40,   1,  13,   5,   4,  20,   0,  /* "bioengineered" 41864 */
      9,  39,  27,  21,  13,  40,   1,  13,   5,   4,  31,  32,   0,  /* "bioengineering" 41877 */
      9,  39,  27,  21,  16,  31,  12,  14,   0,  /* "bioethics" 41886 */
      9,  39,  27,  37,  23,  20,   9,  24,  12,   0,  /* "biofeedback" 41896 */
      9,  39,  27,  40,  21,  13,   0,  /* "biogen" 41903 */
      9,  39,   1,  11,   4,  24,  37,  31,  12,   1,   7,   0,  /* "biographical" 41915 */
      9,  39,   8,  11,   4,   1,  37,  26,  30,   0,  /* "biographies" 41925 */
      9,  39,  27,  38,  24,  30,  10,  20,   0,  /* "biohazard" 41934 */
      9,  39,  27,  38,  24,  30,  10,  20,  30,   0,  /* "biohazards" 41944 */
      9,  39,   8,   7,   1,  40,   1,  14,   3,   0,  /* "biologist" 41954 */
      9,  39,   8,   7,   1,  40,   1,  14,   3,  14,   0,  /* "biologists" 41965 */
      9,  39,   8,   7,   1,  40,  26,   0,  /* "biology" 41973 */
      9,  39,   1,  17,  34,  14,   0,  /* "biomass" 41980 */
      9,  39,  27,  17,   1,   3,   5,   4,  26,   1,   7,   0,  /* "biomaterial" 41992 */
      9,  39,  27,  17,   1,   3,   5,   4,  26,   1,   7,  30,   0,  /* "biomaterials" 42005 */
      9,  39,  25,  17,   0,  /* "biome" 42010 */
      9,  39,  27,  17,  21,  20,   0,  /* "biomed" 42017 */
      9,  39,  27,  17,  21,  20,  31,  12,   1,   7,   0,  /* "biomedical" 42028 */
      9,  39,  27,  17,  21,  20,  31,  12,   1,   7,  30,   0,  /* "biomedicals" 42040 */
      9,  39,  25,  17,  30,   0,  /* "biomes" 42046 */
      9,  39,  27,  17,  15,   3,   0,  /* "biomet" 42053 */
      9,  26,   8,  13,  20,  26,   0,  /* "biondi" 42060 */
      9,  26,  25,  13,  20,  27,   0,  /* "biondo" 42067 */
      9,  26,  27,  13,  20,  27,   7,   5,   7,  27,   0,  /* "biondolillo" 42078 */
      9,  39,  27,  13,  21,   3,  31,  12,   0,  /* "bionetic" 42087 */
      9,  39,  27,  13,  21,   3,  31,  12,  14,   0,  /* "bionetics" 42097 */
      9,  39,   1,  37,  19,   4,  17,   0,  /* "biopharm" 42105 */
      9,  39,  27,  37,   8,   4,  17,   1,  14,  29,   3,  31,  12,   1,   7,   0,  /* "biopharmaceutical" 42121 */
      9,  39,  27,  37,   8,   4,  17,   1,  14,  26,   0,  /* "biopharmacy" 42132 */
      9,  39,  27,  37,   5,  14,  31,  12,  14,   0,  /* "biophysics" 42142 */
      9,  39,  19,   6,  14,  26,  30,   0,  /* "biopsies" 42150 */
      9,  39,  19,   6,  14,  26,   0,  /* "biopsy" 42157 */
      9,  39,  27,  14,   0,  /* "bios" 42162 */
      9,  39,  27,  14,   2,  37,   3,  26,   0,  /* "biosafety" 42171 */
      9,  39,  27,  14,  23,   1,  13,  14,   0,  /* "bioscience" 42180 */
      9,  39,  18,  14,  26,  21,  13,  14,   1,  30,   0,  /* "biosciences" 42191 */
      9,  39,  27,  14,  21,  13,  14,  10,   0,  /* "biosensor" 42200 */
      9,  39,  27,  14,  21,  13,  14,  10,  30,   0,  /* "biosensors" 42210 */
      9,  26,  25,  30,   5,  14,   0,  /* "biosis" 42217 */
      9,  39,  27,  14,  37,   5,   4,   0,  /* "biosphere" 42225 */
      9,  39,  27,  14,  37,   5,   4,  30,   0,  /* "biospheres" 42234 */
      9,  39,  27,  14,  37,   5,   4,  26,   1,  13,   0,  /* "biospherian" 42245 */
      9,  39,  27,  14,  37,   5,   4,  26,   1,  13,  30,   0,  /* "biospherians" 42257 */
      9,  39,  27,  14,  31,  14,   0,  /* "biosys" 42264 */
      9,  39,  27,  14,   5,  14,   3,   1,  17,   0,  /* "biosystem" 42274 */
      9,  39,  27,  14,   5,  14,   3,   1,  17,  30,   0,  /* "biosystems" 42285 */
      9,  39,  27,   3,  21,  12,   0,  /* "biotech" 42292 */
      9,  39,  27,   3,  21,  12,  13,  31,  12,   1,   0,  /* "biotechnica" 42303 */
      9,  39,  27,   3,  21,  12,  13,   1,   7,   8,  40,  31,  12,   1,   7,   0,  /* "biotechnological" 42319 */
      9,  39,  27,   3,  21,  12,  13,   8,   7,   1,  40,  26,  30,   0,  /* "biotechnologies" 42333 */
      9,  39,  27,   3,  21,  12,  13,   8,   7,   1,  40,  26,   0,  /* "biotechnology" 42346 */
      9,  39,  27,   3,  21,  12,  14,   0,  /* "biotechs" 42354 */
      9,  39,  27,  16,  21,   4,   1,   6,  41,  29,   3,  31,  12,   0,  /* "biotherapeutic" 42368 */
      9,  39,  27,  16,  21,   4,   1,   6,  41,  29,   3,  31,  12,  14,   0,  /* "biotherapeutics" 42383 */
      9,  39,   1,   3,   1,  13,   0,  /* "biotin" 42390 */
      9,  39,   1,   3,  39,   3,   0,  /* "biotite" 42397 */
      9,  39,  27,  22,   1,  14,   3,   0,  /* "biovest" 42405 */
      9,  39,   6,   7,   2,  13,   0,  /* "biplane" 42412 */
      9,  39,   6,  25,   7,  10,   0,  /* "bipolar" 42419 */
      9,  44,   0,  /* "bir" 42422 */
      9,  39,   4,   2,  33,   1,   7,   0,  /* "biracial" 42430 */
      9,  44,  42,  10,   0,  /* "bircher" 42435 */
      9,  44,  42,   1,   3,   0,  /* "birchett" 42441 */
      9,  44,  12,   1,   7,  10,   0,  /* "birchler" 42448 */
      9,  44,  12,  17,  39,  10,   0,  /* "birchmeier" 42455 */
      9,  44,  12,  38,  15,  20,   0,  /* "birckhead" 42462 */
      9,  44,  20,   0,  /* "bird" 42466 */
      9,  44,  20,  12,  28,  40,   0,  /* "birdcage" 42473 */
      9,  44,  20,  37,  39,  13,  20,  10,   0,  /* "birdfinder" 42482 */
      9,  44,  20,   7,  39,  37,   0,  /* "birdlife" 42489 */
      9,  44,  20,  17,  34,  13,   0,  /* "birdman" 42496 */
      9,  39,   4,  23,  17,   0,  /* "bireme" 42502 */
      9,  39,   4,  23,  17,  30,   0,  /* "biremes" 42509 */
      9,  39,   4,   1,  13,   9,  52,  17,   0,  /* "birenbaum" 42518 */
      9,  39,   4,  30,   0,  /* "bires" 42523 */
      9,  31,   4,  23,  13,  41,  26,   0,  /* "birinyi" 42531 */
      9,  44,  12,   0,  /* "birk" 42535 */
      9,  44,  12,   1,  20,   8,   7,   0,  /* "birkedal" 42543 */
      9,  44,  12,   7,   1,  13,  20,   0,  /* "birkeland" 42551 */
      9,  44,  12,   1,   3,   0,  /* "birkett" 42557 */
      9,  44,  12,  38,  15,  20,   0,  /* "birkhead" 42564 */
      9,  44,  12,  38,  27,   7,  30,   0,  /* "birkholz" 42572 */
      9,  44,   7,   0,  /* "birle" 42576 */
      9,  44,  13,   9,  52,  17,   0,  /* "birnbaum" 42583 */
      9,   5,   4,  27,   0,  /* "biro" 42588 */
      9,  39,   4,   1,  13,   0,  /* "biron" 42594 */
      9,  39,   4,  27,  30,   0,  /* "biros" 42600 */
      9,  44,   0,  /* "birr" 42603 */
      9,  44,   1,  13,   0,  /* "birren" 42608 */
      9,  44,   3,   0,  /* "birt" 42612 */
      9,  44,  16,  31,  32,   0,  /* "birthing" 42618 */
      9,  44,  16,   4,   2,   3,   0,  /* "birthrate" 42625 */
      9,  44,  16,   4,  39,   3,   0,  /* "birthright" 42632 */
      9,  44,   3,   1,   7,   0,  /* "birtle" 42638 */
      9,   5,  14,   0,  /* "bis" 42642 */
      9,  39,  14,   1,   7,  19,  13,   0,  /* "bisaillon" 42650 */
      9,   5,  14,  42,  21,  11,   7,  26,   1,   0,  /* "bisceglia" 42660 */
      9,   5,  33,   1,  37,   0,  /* "bischof" 42666 */
      9,   5,  33,  36,  37,   9,  10,  11,  10,   0,  /* "bischofberger" 42676 */
      9,   5,  14,  12,  38,  36,  37,   0,  /* "bischoff" 42684 */
      9,  39,  30,   0,  /* "bise" 42688 */
      9,   5,  14,  31,  12,   0,  /* "bisek" 42694 */
      9,  39,  30,  10,   0,  /* "biser" 42699 */
      9,   5,  14,  21,  14,  26,   0,  /* "bisesi" 42706 */
      9,  39,  14,  21,  12,  33,  29,   1,   7,   0,  /* "bisexual" 42716 */
      9,  39,  14,  15,  12,  33,  29,  24,   7,   1,   3,  26,   0,  /* "bisexuality" 42729 */
      9,  39,  14,  21,  12,  33,  29,   1,   7,  30,   0,  /* "bisexuals" 42740 */
      9,   5,  33,   0,  /* "bish" 42744 */
      9,   5,  14,  38,  36,  37,   0,  /* "bishoff" 42751 */
      9,   5,  33,   1,   6,   0,  /* "bishop" 42757 */
      9,   5,  33,   1,   6,  14,   0,  /* "bishops" 42764 */
      9,   5,  33,   1,   6,  14,  11,   2,   3,   0,  /* "bishopsgate" 42774 */
      9,   5,  14,  26,   8,  13,  26,   0,  /* "bisiani" 42782 */
      9,   5,  14,  26,  11,  13,   8,  13,  27,   0,  /* "bisignano" 42792 */
      9,   5,  14,  12,   1,   6,   0,  /* "biskup" 42799 */
      9,   5,  30,  17,   1,  16,   0,  /* "bismuth" 42806 */
      9,  39,  14,   1,  13,   0,  /* "bison" 42812 */
      9,   5,  14,   0,  /* "biss" 42816 */
      9,   5,  14,   5,   3,   0,  /* "bisset" 42822 */
      9,   5,  14,   5,   3,   0,  /* "bissett" 42828 */
      9,  23,  14,  27,   0,  /* "bisso" 42833 */
      9,   5,  14,   1,  13,  15,   3,   0,  /* "bissonette" 42841 */
      9,   5,  14,   3,   7,  39,  13,   0,  /* "bistline" 42849 */
      9,  23,  14,  29,   3,   2,  12,  26,   0,  /* "bisuteki" 42858 */
      9,   5,   3,   0,  /* "bit" 42862 */
      9,   5,   3,  10,   0,  /* "bitar" 42867 */
      9,  39,   3,   0,  /* "bite" 42871 */
      9,  39,   3,  10,   0,  /* "biter" 42876 */
      9,  39,   3,  14,   0,  /* "bites" 42881 */
      9,   5,   3,  14,  39,  30,   0,  /* "bitesize" 42888 */
      9,  39,   3,  31,  32,   0,  /* "biting" 42894 */
      9,  39,   3,   1,   7,  10,   0,  /* "bitler" 42901 */
      9,   5,   3,  14,   0,  /* "bits" 42906 */
      9,   5,   3,   1,   7,   0,  /* "bittel" 42912 */
      9,   5,   3,  10,   1,  14,   3,   0,  /* "bitterest" 42920 */
      9,   5,   3,  10,   7,  26,   0,  /* "bitterly" 42927 */
      9,   5,   3,  10,   4,  29,   3,   0,  /* "bitterroot" 42935 */
      9,   5,   3,  10,  14,  47,  23,   3,   0,  /* "bittersweet" 42944 */
      9,   5,   3,  31,  12,   0,  /* "bittick" 42950 */
      9,   5,   3,   1,   7,   0,  /* "bittle" 42956 */
      9,   5,   3,  29,  17,   1,  13,   0,  /* "bitumen" 42964 */
      9,   1,   3,  29,  17,   1,  13,   1,  14,   0,  /* "bituminous" 42974 */
      9,   5,   3,  14,   0,  /* "bitz" 42979 */
      9,  39,  22,  24,   7,  22,   0,  /* "bivalve" 42986 */
      9,  39,  22,  24,   7,  22,  30,   0,  /* "bivalves" 42994 */
      9,  39,  22,   1,  13,   0,  /* "biven" 43000 */
      9,  39,  22,   1,  13,  30,   0,  /* "bivens" 43007 */
      9,  23,  22,  26,   8,  13,  27,   0,  /* "biviano" 43015 */
      9,   5,  22,   5,  13,   0,  /* "bivin" 43021 */
      9,   5,  22,  47,  34,  12,   0,  /* "bivouac" 43028 */
      9,  39,  47,  23,  12,   7,  26,   0,  /* "biweekly" 43036 */
      9,   5,  12,  14,   0,  /* "bix" 43041 */
      9,   5,  12,  14,   9,  26,   0,  /* "bixby" 43048 */
      9,   5,  12,  14,   1,   7,   0,  /* "bixel" 43055 */
      9,   5,  12,  14,   7,  10,   0,  /* "bixler" 43062 */
      9,   5,  30,   0,  /* "biz" 43066 */
      9,   5,  30,  24,  32,  11,  27,   0,  /* "bizango" 43074 */
      9,   1,  30,   8,   4,   0,  /* "bizarre" 43080 */
      9,   5,  30,  17,   8,   4,   3,   0,  /* "bizmart" 43088 */
      9,  41,  15,   7,  24,  14,  13,  31,  12,   1,   0,  /* "bjelasnica" 43099 */
      9,  41,  21,   7,   1,  13,  20,   0,  /* "bjelland" 43107 */
      9,  41,  44,  12,   0,  /* "bjerke" 43112 */
      9,  41,  18,   4,  13,   0,  /* "bjoern" 43118 */
      9,  41,  18,   4,  11,   0,  /* "bjorge" 43124 */
      9,  41,  18,   4,  12,   7,   1,  13,  20,   0,  /* "bjorklund" 43134 */
      9,  41,  18,   4,  12,  17,   1,  13,   0,  /* "bjorkman" 43143 */
      9,   7,   8,  42,   7,  26,   0,  /* "blachly" 43150 */
      9,   7,  24,  12,   9,  10,  20,   0,  /* "blackbird" 43158 */
      9,   7,  24,  12,   9,  10,  20,  30,   0,  /* "blackbirds" 43167 */
      9,   7,  24,  12,   9,  10,  13,   0,  /* "blackburn" 43175 */
      9,   7,  24,  12,  26,   3,  10,   0,  /* "blacketer" 43183 */
      9,   7,  24,  12,   5,   3,   0,  /* "blackett" 43190 */
      9,   7,  24,  12,   6,  29,   7,   0,  /* "blackpool" 43198 */
      9,   7,  24,  12,   4,   8,  12,   0,  /* "blackrock" 43206 */
      9,   7,  24,  12,  33,  31,   4,   0,  /* "blackshear" 43214 */
      9,   7,  24,  12,  33,  39,   4,   0,  /* "blackshire" 43222 */
      9,   7,   2,  30,   0,  /* "blaese" 43227 */
      9,   7,  21,  14,  31,  32,   0,  /* "blaesing" 43234 */
      9,   7,   8,   0,  /* "blah" 43238 */
      9,   7,   8,  13,  31,  12,   0,  /* "blahnik" 43245 */
      9,   7,  24,  38,   1,   3,   0,  /* "blahut" 43252 */
      9,   7,   2,  13,   0,  /* "blain" 43257 */
      9,   7,  21,  30,   0,  /* "blais" 43262 */
      9,   7,   2,  12,   7,  26,   0,  /* "blakeley" 43269 */
      9,   7,   2,  12,   1,  13,  38,  24,  17,   0,  /* "blakenham" 43279 */
      9,   7,   2,  12,  14,   7,  26,   0,  /* "blakeslee" 43287 */
      9,   7,  24,   7,   1,  12,   0,  /* "blalack" 43294 */
      9,   7,  24,   7,  19,  12,   0,  /* "blalock" 43301 */
      9,   7,   2,  17,   7,   1,  14,   0,  /* "blameless" 43309 */
      9,   7,  24,  13,   0,  /* "blan" 43314 */
      9,   7,   8,  32,  12,   1,   0,  /* "blanca" 43321 */
      9,   7,  24,  13,  14,   5,   3,   0,  /* "blancett" 43329 */
      9,   7,  24,  13,  12,   1,   3,   0,  /* "blanchet" 43337 */
      9,   7,  24,  13,  42,   1,   3,   0,  /* "blanchett" 43345 */
      9,   7,   1,  13,  33,  21,   3,   0,  /* "blanchette" 43353 */
      9,   7,  24,  13,  20,  37,  36,   4,  20,   0,  /* "blandford" 43363 */
      9,   7,  19,  13,  20,  23,  13,  27,   0,  /* "blandino" 43372 */
      9,   7,   2,  13,  26,   0,  /* "blaney" 43378 */
      9,   7,  24,  32,  12,   1,   3,   1,  20,   0,  /* "blanketed" 43388 */
      9,   7,  24,  32,  12,   1,  13,  33,   5,   6,   0,  /* "blankinship" 43399 */
      9,   7,  19,  13,  12,  23,   3,   1,   0,  /* "blanquita" 43408 */
      9,   7,  24,  13,  14,   5,   3,   0,  /* "blansett" 43416 */
      9,   7,   8,  14,   0,  /* "blas" 43421 */
      9,   7,   8,  14,  12,  27,   0,  /* "blasco" 43428 */
      9,   7,  24,  14,  20,   1,   7,   0,  /* "blasdell" 43436 */
      9,   7,   2,  30,  10,   0,  /* "blaser" 43442 */
      9,   7,   2,  30,  26,   0,  /* "blasi" 43448 */
      9,   7,   8,  14,  26,   1,   0,  /* "blasia" 43455 */
      9,   7,   2,  30,  26,  10,   0,  /* "blasier" 43462 */
      9,   7,   2,  30,  31,  32,   0,  /* "blasing" 43469 */
      9,   7,  19,  14,  31,  32,  11,   8,  17,  26,   0,  /* "blasingame" 43480 */
      9,   7,   1,  14,  23,  13,  26,   0,  /* "blasini" 43488 */
      9,   7,   2,  14,  12,   0,  /* "blaske" 43494 */
      9,   7,   8,  14,  12,  27,   0,  /* "blasko" 43501 */
      9,   7,  24,  14,  37,   1,  17,   1,  14,   0,  /* "blasphemous" 43511 */
      9,   7,  24,  14,  37,   1,  17,  26,   0,  /* "blasphemy" 43520 */
      9,   7,  19,  14,  31,  32,  11,   8,  17,  26,   0,  /* "blassingame" 43531 */
      9,   7,  24,  14,   3,  18,  37,   0,  /* "blastoff" 43539 */
      9,   7,   8,  33,   1,  12,   0,  /* "blaszak" 43546 */
      9,   7,   8,  33,  42,  31,  12,   0,  /* "blaszczyk" 43554 */
      9,   7,  24,   3,  13,  10,   0,  /* "blattner" 43561 */
      9,   7,  48,   0,  /* "blau" 43565 */
      9,   7,  48,   4,   0,  /* "blauer" 43570 */
      9,   7,  48,  14,   3,  39,  13,   0,  /* "blaustein" 43578 */
      9,   7,   2,   0,  /* "blay" 43582 */
      9,   7,   2,   7,   1,  12,   0,  /* "blaylock" 43589 */
      9,   7,   1,  30,  28,  21,  37,  14,  12,  26,   0,  /* "blazejewski" 43600 */
      9,   7,   8,  30,  15,  12,   0,  /* "blazek" 43607 */
      9,   7,  19,  30,  23,  13,   1,   0,  /* "blazina" 43615 */
      9,   7,  23,   0,  /* "blea" 43619 */
      9,   7,   5,   4,  26,   0,  /* "bleary" 43625 */
      9,   7,  21,  20,   0,  /* "bled" 43630 */
      9,   7,  21,  11,   1,  13,   0,  /* "blegen" 43637 */
      9,   7,  39,  12,   0,  /* "bleich" 43642 */
      9,   7,  39,  12,  10,   0,  /* "bleicher" 43648 */
      9,   7,  39,  10,   0,  /* "bleier" 43653 */
      9,   7,  39,   7,  10,   0,  /* "bleiler" 43659 */
      9,   7,  21,   7,  19,  12,   0,  /* "blelloch" 43666 */
      9,   7,  21,  17,  31,  33,   0,  /* "blemish" 43673 */
      9,   7,  21,  13,  20,  24,  12,  14,   0,  /* "blendax" 43682 */
      9,   7,  21,  13,  38,  39,  17,   0,  /* "blenheim" 43690 */
      9,   7,  21,  37,  10,   5,  30,  17,   1,   0,  /* "blepharisma" 43700 */
      9,   7,  23,  30,  10,   0,  /* "bleser" 43706 */
      9,   7,  21,  14,  31,  20,   0,  /* "blessed" 43713 */
      9,   7,  21,  14,   3,   0,  /* "blessed" 43719 */
      9,   7,  21,  14,  31,  32,  10,   0,  /* "blessinger" 43727 */
      9,   7,  29,   0,  /* "bleu" 43731 */
      9,   7,  23,  22,   1,  13,  30,   0,  /* "blevens" 43739 */
      9,   7,  29,   0,  /* "blew" 43743 */
      9,   7,  29,   5,   3,   0,  /* "blewett" 43749 */
      9,   7,  29,   5,   3,   0,  /* "blewitt" 43755 */
      9,   7,   2,   0,  /* "bley" 43759 */
      9,   7,   5,  12,   0,  /* "blick" 43764 */
      9,   7,   5,  12,   1,  13,  14,   3,   1,  37,   0,  /* "blickenstaff" 43775 */
      9,   7,  39,   0,  /* "bligh" 43779 */
      9,   7,  39,   3,   0,  /* "blight" 43784 */
      9,   7,  39,   3,   1,  20,   0,  /* "blighted" 43791 */
      9,   7,  39,   7,  26,   0,  /* "bliley" 43797 */
      9,   7,   5,  13,  12,  25,   0,  /* "blincoe" 43804 */
      9,   7,  39,  13,  20,   0,  /* "blind" 43810 */
      9,   7,  39,  13,  20,   1,  20,   0,  /* "blinded" 43818 */
      9,   7,  39,  13,  20,  10,   0,  /* "blinder" 43825 */
      9,   7,  39,  13,  20,  10,  30,   0,  /* "blinders" 43833 */
      9,   7,  39,  13,  20,  37,  25,   7,  20,   0,  /* "blindfold" 43843 */
      9,   7,  39,  13,  20,  37,  25,   7,  20,   1,  20,   0,  /* "blindfolded" 43855 */
      9,   7,  39,  13,  20,  31,  32,   0,  /* "blinding" 43863 */
      9,   7,  39,  13,  20,   7,  26,   0,  /* "blindly" 43871 */
      9,   7,  39,  13,  20,  13,   1,  14,   0,  /* "blindness" 43880 */
      9,   7,  39,  13,  20,  30,   0,  /* "blinds" 43887 */
      9,   7,  39,  13,  20,  14,  39,  20,   0,  /* "blindside" 43896 */
      9,   7,  39,  13,  20,  14,  39,  20,   1,  20,   0,  /* "blindsided" 43907 */
      9,   7,   5,   6,   0,  /* "blip" 43912 */
      9,   7,   5,  14,  12,  36,   7,   0,  /* "bliscoll" 43920 */
      9,   7,   5,  33,   0,  /* "blish" 43925 */
      9,   7,   5,  14,   5,   3,   0,  /* "blissett" 43932 */
      9,   7,  39,  46,   0,  /* "blithe" 43937 */
      9,   7,  39,  16,   7,  26,   0,  /* "blithely" 43944 */
      9,   7,   5,   3,  14,   3,  26,  13,   0,  /* "blitstein" 43953 */
      9,   7,   5,   3,  14,   3,   0,  /* "blitzed" 43960 */
      9,   7,   5,   3,  14,   1,  30,   0,  /* "blitzes" 43968 */
      9,   7,  39,  22,   1,  13,   0,  /* "bliven" 43975 */
      9,   7,   5,  12,  14,   3,   0,  /* "blixt" 43982 */
      9,   7,   5,  30,  10,  20,   0,  /* "blizard" 43989 */
      9,   7,   5,  30,  10,  20,   0,  /* "blizzard" 43996 */
      9,   7,   5,  30,  10,  20,  30,   0,  /* "blizzards" 44004 */
      9,   7,  25,   3,  31,  32,   0,  /* "bloating" 44011 */
      9,   7,   8,   9,   0,  /* "blob" 44016 */
      9,   7,   8,  12,   0,  /* "bloc" 44021 */
      9,   7,   8,  12,  31,  40,   0,  /* "blockage" 44028 */
      9,   7,   8,  12,  31,  40,   1,  30,   0,  /* "blockages" 44037 */
      9,   7,  25,  20,   1,   7,   0,  /* "bloedel" 44044 */
      9,   7,  25,  20,  10,  13,   0,  /* "bloedorn" 44051 */
      9,   7,  25,  17,   0,  /* "bloem" 44056 */
      9,   7,  25,  17,  12,  10,   0,  /* "bloemker" 44063 */
      9,   7,   8,  12,   0,  /* "blok" 44068 */
      9,   7,   8,  17,   0,  /* "blom" 44073 */
      9,   7,  35,  20,   9,  24,  16,   0,  /* "bloodbath" 44081 */
      9,   7,  35,  20,   7,  39,  13,   0,  /* "bloodline" 44089 */
      9,   7,  35,  20,   7,  39,  13,  30,   0,  /* "bloodlines" 44098 */
      9,   7,  35,  20,  33,  21,  20,   0,  /* "bloodshed" 44106 */
      9,   7,  35,  20,  30,  47,  44,  16,   0,  /* "bloodsworth" 44115 */
      9,   7,  29,  17,   0,  /* "bloom" 44120 */
      9,   7,  29,  17,   9,  10,  11,   0,  /* "bloomberg" 44128 */
      9,   7,  29,  17,  20,   0,  /* "bloomed" 44134 */
      9,   7,  29,  17,  10,   0,  /* "bloomer" 44140 */
      9,   7,  29,  17,  10,  30,   0,  /* "bloomers" 44147 */
      9,   7,  29,  17,  37,  23,   7,  20,   0,  /* "bloomfield" 44156 */
      9,   7,  29,  17,  31,  32,   0,  /* "blooming" 44163 */
      9,   7,  29,  17,  31,  32,  20,   2,   7,   0,  /* "bloomingdale" 44173 */
      9,   7,  29,  17,  31,  32,  20,   2,   7,  30,   0,  /* "bloomingdales" 44184 */
      9,   7,  29,  17,  31,  32,   3,   1,  13,   0,  /* "bloomington" 44194 */
      9,   7,  29,  17,  12,  47,   5,  14,   3,   0,  /* "bloomquist" 44204 */
      9,   7,  29,  17,  30,   0,  /* "blooms" 44210 */
      9,   7,  29,   6,  10,   0,  /* "blooper" 44216 */
      9,   7,  29,   6,  10,  30,   0,  /* "bloopers" 44223 */
      9,   7,  18,  14,  10,   0,  /* "blosser" 44229 */
      9,   7,   8,  14,   1,  17,  31,  32,   0,  /* "blossoming" 44238 */
      9,   7,   8,  14,   1,  17,  30,   0,  /* "blossoms" 44246 */
      9,   7,   8,   3,   0,  /* "blot" 44251 */
      9,   7,  47,  23,  13,   0,  /* "blouin" 44257 */
      9,   7,  25,   0,  /* "blow" 44261 */
      9,   7,  25,  10,   0,  /* "blower" 44266 */
      9,   7,  25,  10,  30,   0,  /* "blowers" 44272 */
      9,   7,  25,  37,  31,  33,   0,  /* "blowfish" 44279 */
      9,   7,  25,  48,   3,   0,  /* "blowout" 44285 */
      9,   7,  25,  48,   3,  14,   0,  /* "blowouts" 44292 */
      9,   7,   8,  12,  14,   1,  17,   0,  /* "bloxham" 44300 */
      9,   7,   8,  12,  14,   1,  17,   0,  /* "bloxom" 44308 */
      9,   7,   8,  12,  14,   1,  17,   0,  /* "bloxsom" 44316 */
      9,   7,  35,   9,  36,   0,  /* "blubaugh" 44322 */
      9,   7,  29,   0,  /* "blue" 44326 */
      9,   7,  29,   9,  21,   4,  26,  30,   0,  /* "blueberries" 44335 */
      9,   7,  29,   9,  21,   4,  26,   0,  /* "blueberry" 44343 */
      9,   7,  29,   9,  44,  20,   0,  /* "bluebird" 44350 */
      9,   7,  29,   9,   8,  13,   1,   3,   0,  /* "bluebonnet" 44359 */
      9,   7,  29,   9,   8,  13,   1,   3,  14,   0,  /* "bluebonnets" 44369 */
      9,   7,  29,  42,   5,   6,   0,  /* "bluechip" 44376 */
      9,   7,  29,  37,  23,   7,  20,   0,  /* "bluefield" 44384 */
      9,   7,  29,  11,   4,  24,  14,   0,  /* "bluegrass" 44392 */
      9,   7,  29,  40,   2,   0,  /* "bluejay" 44398 */
      9,   7,  45,  17,   1,   7,   0,  /* "bluemel" 44405 */
      9,   7,  29,   6,   4,   5,  13,   3,   0,  /* "blueprint" 44414 */
      9,   7,  29,   6,   4,   5,  13,   3,  14,   0,  /* "blueprints" 44424 */
      9,   7,  29,  10,   0,  /* "bluer" 44429 */
      9,   7,  29,  30,   0,  /* "blues" 44434 */
      9,   7,  29,   1,  14,   3,   0,  /* "bluest" 44441 */
      9,   7,  45,  14,   3,  39,  13,   0,  /* "bluestein" 44449 */
      9,   7,  29,  14,   3,  39,  13,   0,  /* "bluestine" 44457 */
      9,   7,  29,  14,   3,  25,  13,   0,  /* "bluestone" 44465 */
      9,   7,  29,   3,   0,  /* "bluett" 44470 */
      9,   7,  29,  26,   0,  /* "bluey" 44475 */
      9,   7,  29,  37,  10,  20,   0,  /* "bluford" 44482 */
      9,   7,  35,  20,  18,   4,  13,   0,  /* "bluhdorn" 44490 */
      9,   7,  29,  31,  32,   0,  /* "bluing" 44496 */
      9,   7,  29,  31,  33,   0,  /* "bluish" 44502 */
      9,   7,  29,   3,   0,  /* "bluitt" 44507 */
      9,   7,  29,  17,   0,  /* "blum" 44512 */
      9,   7,  29,  17,   0,  /* "blume" 44517 */
      9,   7,  29,  17,  15,  13,   9,  10,  11,   0,  /* "blumenberg" 44527 */
      9,   7,  35,  17,   1,  13,  37,  15,   7,  20,   0,  /* "blumenfeld" 44538 */
      9,   7,  35,  17,   1,  13,  33,  39,  13,   0,  /* "blumenschein" 44548 */
      9,   7,  35,  17,   1,  13,  33,  39,  13,   0,  /* "blumenshine" 44558 */
      9,   7,  29,  17,  15,  13,  14,   3,  39,  13,   0,  /* "blumenstein" 44569 */
      9,   7,  29,  17,  15,  13,  14,   3,  19,  12,   0,  /* "blumenstock" 44580 */
      9,   7,  29,  17,   1,  13,  16,  18,   7,   0,  /* "blumenthal" 44590 */
      9,   7,  29,  17,  10,   0,  /* "blumer" 44596 */
      9,   7,  35,  13,  20,   1,   7,   0,  /* "blundall" 44604 */
      9,   7,  35,  13,   3,   1,  20,   0,  /* "blunted" 44612 */
      9,   7,  35,  13,   3,  10,   0,  /* "blunter" 44619 */
      9,   7,  35,  13,   3,   1,  14,   3,   0,  /* "bluntest" 44628 */
      9,   7,  44,   0,  /* "blur" 44632 */
      9,   7,  29,  16,   0,  /* "bluth" 44637 */
      9,  45,   7,   1,  22,   8,   4,  20,   0,  /* "blvd" 44646 */
      9,   7,  39,   0,  /* "bly" 44650 */
      9,   7,  39,   0,  /* "blye" 44654 */
      9,   7,  39,   7,  10,   0,  /* "blyler" 44660 */
      9,   7,  39,  14,   3,  25,  13,   0,  /* "blystone" 44668 */
      9,   7,  39,  46,   0,  /* "blythe" 44673 */
      9,  25,   0,  /* "bo" 44676 */
      9,  25,   1,   0,  /* "boa" 44680 */
      9,  25,  12,   0,  /* "boak" 44684 */
      9,  25,   7,   0,  /* "boal" 44688 */
      9,  25,  13,   0,  /* "boan" 44692 */
      9,  18,   4,   0,  /* "boar" 44696 */
      9,  18,   4,  20,   4,  29,  17,   0,  /* "boardroom" 44704 */
      9,  18,   4,  20,   4,  29,  17,  30,   0,  /* "boardrooms" 44713 */
      9,  18,   4,  20,  47,  18,  12,   0,  /* "boardwalk" 44721 */
      9,  18,   4,   3,   0,  /* "boart" 44726 */
      9,  25,   1,  30,   0,  /* "boas" 44731 */
      9,  25,  30,   0,  /* "boase" 44735 */
      9,  25,   3,   0,  /* "boat" 44739 */
      9,  25,   3,  38,  48,  14,   0,  /* "boathouse" 44746 */
      9,  25,   3,  31,  32,   0,  /* "boating" 44752 */
      9,  25,   3,   4,  39,   3,   0,  /* "boatright" 44759 */
      9,  25,   3,   4,  39,   3,   0,  /* "boatwright" 44766 */
      9,  25,  34,  30,   0,  /* "boaz" 44771 */
      9,   8,   9,   0,  /* "bob" 44775 */
      9,  27,   9,  19,  20,   5,   7,   1,   0,  /* "bobadilla" 44784 */
      9,   8,   9,   0,  /* "bobb" 44788 */
      9,   8,   9,   1,   3,   0,  /* "bobbett" 44794 */
      9,   8,   9,   1,   3,   0,  /* "bobbette" 44800 */
      9,   8,   9,  12,  24,   3,  30,   0,  /* "bobcats" 44808 */
      9,  25,   9,   0,  /* "bobe" 44812 */
      9,  25,   9,  31,  12,   0,  /* "bobek" 44818 */
      9,   8,   9,  10,   0,  /* "bober" 44823 */
      9,  25,   9,  26,  10,   0,  /* "bobier" 44829 */
      9,   1,   9,   5,  13,  14,  12,  26,   0,  /* "bobinski" 44838 */
      9,   1,   9,   7,   5,   3,   0,  /* "boblitt" 44845 */
      9,  25,   9,  27,   0,  /* "bobo" 44850 */
      9,  25,   9,  27,   7,   1,  14,   0,  /* "bobolas" 44858 */
      9,   8,   9,   4,  25,   0,  /* "bobrow" 44864 */
      9,   8,   9,  14,   7,  21,  20,   0,  /* "bobsled" 44872 */
      9,   8,   9,  30,  26,  13,   0,  /* "bobzien" 44879 */
      9,  25,  12,   1,   0,  /* "boca" 44884 */
      9,  25,  12,   1,  13,  21,  11,   4,   1,   0,  /* "bocanegra" 44894 */
      9,  25,  42,  26,   0,  /* "bocce" 44899 */
      9,  27,  12,  29,   3,  14,  26,   0,  /* "boccuzzi" 44907 */
      9,  25,  42,  21,  12,   0,  /* "bocek" 44913 */
      9,   8,  12,   0,  /* "boch" 44917 */
      9,   8,  42,  10,  19,  22,   0,  /* "bocharov" 44924 */
      9,  27,  12,  23,  12,  26,  27,   0,  /* "bochicchio" 44932 */
      9,   8,  12,   4,   1,  17,   0,  /* "bochram" 44939 */
      9,   8,  12,   0,  /* "bock" 44943 */
      9,   8,  12,   1,  12,   0,  /* "bocock" 44949 */
      9,   8,  12,  51,  12,   0,  /* "bocook" 44955 */
      9,  25,  20,   1,   0,  /* "boda" 44960 */
      9,   8,  20,   1,  17,  10,   0,  /* "bodamer" 44967 */
      9,  27,  20,   8,  13,   1,  14,   0,  /* "bodanis" 44975 */
      9,  25,  20,   0,  /* "bode" 44979 */
      9,  27,  20,   2,  11,   1,  14,   0,  /* "bodegas" 44987 */
      9,   1,  20,  21,   7,   0,  /* "bodell" 44993 */
      9,  25,  20,   1,  13,   0,  /* "boden" 44999 */
      9,   8,  20,   1,  13,  38,  39,  17,  10,   0,  /* "bodenheimer" 45009 */
      9,  25,  20,   1,  13,  14,   3,  39,  13,   0,  /* "bodenstein" 45019 */
      9,  25,  20,   1,  13,  14,   3,  39,  13,  10,   0,  /* "bodensteiner" 45030 */
      9,  25,  20,  26,   0,  /* "bodey" 45035 */
      9,  25,  20,  26,   0,  /* "bodi" 45040 */
      9,  25,  20,  26,   0,  /* "bodie" 45045 */
      9,   8,  20,  31,  12,  25,  22,   1,   0,  /* "bodikova" 45054 */
      9,  25,  20,   5,  13,   0,  /* "bodin" 45060 */
      9,  27,  20,  23,  13,  26,   0,  /* "bodine" 45067 */
      9,  25,  20,   1,   7,   0,  /* "bodle" 45073 */
      9,   1,  20,  13,   8,   4,   0,  /* "bodnar" 45080 */
      9,  25,  20,  27,   0,  /* "bodo" 45085 */
      9,   8,  20,  26,   0,  /* "body" 45090 */
      9,   8,  20,  26,  11,   8,   4,  20,   0,  /* "bodyguard" 45099 */
      9,   8,  20,  26,  11,   8,   4,  20,  30,   0,  /* "bodyguards" 45109 */
      9,  18,  20,  30,  26,  34,  12,   0,  /* "bodziak" 45117 */
      9,  25,   0,  /* "boe" 45120 */
      9,  25,  12,   0,  /* "boeck" 45124 */
      9,  25,  20,  31,  12,  10,   0,  /* "boedeker" 45131 */
      9,  25,   0,  /* "boeh" 45134 */
      9,  25,  38,   1,   7,   0,  /* "boehle" 45140 */
      9,  25,  13,   7,  39,  13,   0,  /* "boehnlein" 45147 */
      9,  25,  12,   0,  /* "boeke" 45151 */
      9,  25,   7,   1,  13,  30,   0,  /* "boelens" 45158 */
      9,  25,  13,   0,  /* "boen" 45162 */
      9,   8,   1,  13,  31,  32,   0,  /* "boening" 45169 */
      9,  25,   6,   1,   7,   0,  /* "boepple" 45175 */
      9,  18,   4,   0,  /* "boer" 45179 */
      9,  18,   4,  30,   0,  /* "boers" 45184 */
      9,  25,  30,   0,  /* "boes" 45188 */
      9,  25,  30,  34,  12,   0,  /* "boesak" 45194 */
      9,  25,  33,   1,  13,  14,   3,  23,  13,   0,  /* "boeschenstein" 45204 */
      9,  25,   3,  11,  10,   0,  /* "boettger" 45210 */
      9,  18,  37,   0,  /* "boff" 45214 */
      9,   8,  37,   1,   0,  /* "boffa" 45219 */
      9,   8,  11,   0,  /* "bog" 45223 */
      9,   1,  11,   8,   3,  14,  12,  26,   0,  /* "bogacki" 45232 */
      9,   8,  11,   1,  42,   0,  /* "bogacz" 45238 */
      9,  25,  11,   1,  13,   0,  /* "bogan" 45244 */
      9,   1,  11,   8,   4,   0,  /* "bogar" 45250 */
      9,   8,  11,  10,  20,   0,  /* "bogard" 45256 */
      9,  25,  11,   8,   4,   3,   0,  /* "bogart" 45263 */
      9,   1,  11,  20,  24,  13,   1,  47,   5,   3,  30,   0,  /* "bogdanowicz" 45275 */
      9,   1,  11,  20,  24,  13,  14,  12,  26,   0,  /* "bogdanski" 45285 */
      9,  25,  40,   0,  /* "boge" 45289 */
      9,   8,  11,   1,   7,  14,  36,  32,   0,  /* "bogelsong" 45298 */
      9,   8,  11,  10,   3,   0,  /* "bogert" 45304 */
      9,  25,  11,  26,  20,   0,  /* "bogeyed" 45310 */
      9,  25,  11,  26,  17,  24,  13,   0,  /* "bogeyman" 45318 */
      9,  25,  11,  26,  17,   5,  13,   0,  /* "bogeymen" 45326 */
      9,   8,  11,  15,  14,   0,  /* "boggess" 45332 */
      9,  18,  11,  31,  32,   0,  /* "bogging" 45338 */
      9,  25,  40,  26,  27,   0,  /* "boggio" 45344 */
      9,   8,  11,   1,   7,   0,  /* "boggle" 45350 */
      9,   8,  11,   1,   7,  20,   0,  /* "boggled" 45357 */
      9,   8,  11,   1,   7,  30,   0,  /* "boggles" 45364 */
      9,   8,  11,   1,   7,  31,  32,   0,  /* "boggling" 45372 */
      9,  18,  11,  30,   0,  /* "boggs" 45377 */
      9,   1,  11,  38,   8,  43,   1,  13,   0,  /* "boghosian" 45386 */
      9,  45,  11,  26,   0,  /* "bogie" 45391 */
      9,  25,  40,   5,  13,   0,  /* "bogin" 45397 */
      9,  25,  11,   1,   7,   0,  /* "bogle" 45403 */
      9,   1,  11,  13,   8,   4,   0,  /* "bognar" 45410 */
      9,  25,  11,  18,   4,   0,  /* "bogor" 45416 */
      9,   1,  11,   8,  43,   1,  13,   0,  /* "bogosian" 45424 */
      9,  25,  11,   1,   3,   8,   0,  /* "bogota" 45431 */
      9,   8,  11,  30,   0,  /* "bogs" 45436 */
      9,   1,  11,  35,   3,  14,  12,  26,   0,  /* "bogucki" 45445 */
      9,  27,  11,  35,  14,   7,   1,  22,  14,  12,  39,   1,   0,  /* "boguslavskaya" 45458 */
      9,   8,  11,  31,  33,   0,  /* "bogusz" 45464 */
      9,  25,  38,   1,  12,   0,  /* "bohac" 45470 */
      9,  25,  38,   1,  13,   0,  /* "bohan" 45476 */
      9,   8,  38,   1,  13,  34,  13,   0,  /* "bohanan" 45484 */
      9,   1,  38,  24,  13,   1,  13,   0,  /* "bohannan" 45492 */
      9,   8,  38,   1,  13,  19,  13,   0,  /* "bohannon" 45500 */
      9,   8,  38,   1,  13,  19,  13,   0,  /* "bohanon" 45508 */
      9,   8,  38,  19,   4,   3,   0,  /* "bohart" 45515 */
      9,  27,  38,   2,  17,  28,   0,  /* "boheme" 45522 */
      9,  25,   1,  13,   0,  /* "bohen" 45527 */
      9,  25,   7,   0,  /* "bohl" 45531 */
      9,  25,  38,   1,   7,   0,  /* "bohle" 45537 */
      9,   8,  12,   0,  /* "bohlke" 45541 */
      9,   8,  17,   0,  /* "bohm" 45545 */
      9,  25,  13,   0,  /* "bohn" 45549 */
      9,   8,  13,   5,   3,   0,  /* "bohnet" 45555 */
      9,  25,  13,  38,  18,  37,   0,  /* "bohnhoff" 45562 */
      9,   8,  13,  31,  32,   0,  /* "bohning" 45568 */
      9,  18,   4,   0,  /* "bohr" 45572 */
      9,  49,  30,   0,  /* "boies" 45576 */
      9,  49,  12,   0,  /* "boik" 45580 */
      9,  49,   7,   0,  /* "boil" 45584 */
      9,  50,   7,   8,   4,  20,   0,  /* "boilard" 45591 */
      9,  47,   8,   0,  /* "bois" 45595 */
      9,  47,  19,  12,   7,  21,   4,   0,  /* "boisclair" 45603 */
      9,  49,  30,  26,   0,  /* "boise" 45608 */
      9,  49,  14,   1,  13,   0,  /* "boisen" 45614 */
      9,  49,  14,  40,   1,   7,  26,   0,  /* "boisjoly" 45622 */
      9,  47,   8,  14,  25,   0,  /* "boisseau" 45628 */
      9,  47,   8,  14,   1,  13,  27,   0,  /* "boissonneault" 45636 */
      9,  47,  19,  22,  44,   3,   0,  /* "boisvert" 45643 */
      9,  50,   3,  13,   8,   3,   0,  /* "boitnott" 45650 */
      9,  50,  22,  24,  13,   0,  /* "boivin" 45656 */
      9,   1,  41,   1,  13,  18,  37,  14,  12,  26,   0,  /* "bojanowski" 45667 */
      9,   1,  41,   8,   4,  14,  12,  26,   0,  /* "bojarski" 45676 */
      9,   1,  40,  21,  32,  12,   1,   0,  /* "bojenka" 45684 */
      9,  27,  41,  18,   4,  12,  47,  15,  30,   0,  /* "bojorquez" 45694 */
      9,   8,  12,   0,  /* "bok" 45698 */
      9,   1,  12,   8,  14,   1,   0,  /* "bokassa" 45705 */
      9,   8,   7,   0,  /* "bol" 45709 */
      9,  25,   7,   1,   0,  /* "bola" 45714 */
      9,   8,   7,   1,  13,  20,  10,   0,  /* "bolander" 45722 */
      9,  25,   7,   1,  13,  40,  10,   0,  /* "bolanger" 45730 */
      9,  27,   7,   8,  13,  27,  30,   0,  /* "bolanos" 45738 */
      9,  25,   7,  12,   1,  17,   0,  /* "bolcom" 45745 */
      9,  25,   7,  20,   0,  /* "bold" 45750 */
      9,  25,   7,   0,  /* "bole" 45754 */
      9,  25,   7,  31,  12,   0,  /* "bolek" 45760 */
      9,   1,   7,  21,  13,   9,  36,   0,  /* "bolenbaugh" 45768 */
      9,   8,   7,  15,  13,  20,  10,   0,  /* "bolender" 45776 */
      9,   8,   7,  10,  40,   1,  12,   0,  /* "bolerjack" 45784 */
      9,  27,   7,  21,   4,  27,   0,  /* "bolero" 45791 */
      9,  25,   7,  47,  15,   4,   0,  /* "boleware" 45798 */
      9,  25,   7,  37,   0,  /* "bolf" 45803 */
      9,  25,   7,  40,  10,   0,  /* "bolger" 45809 */
      9,  25,   7,   1,  20,   1,  13,   0,  /* "boliden" 45817 */
      9,   8,   7,  39,  13,   0,  /* "boline" 45823 */
      9,  27,   7,   5,  16,   1,   0,  /* "bolitho" 45830 */
      9,   8,   7,   1,  22,  10,   0,  /* "bolivar" 45837 */
      9,   8,   7,   1,  22,  10,  30,   0,  /* "bolivars" 45845 */
      9,   1,   7,   5,  22,  26,   1,   0,  /* "bolivia" 45853 */
      9,  27,   7,   5,  22,  26,   1,  13,   0,  /* "bolivian" 45862 */
      9,  25,   7,   0,  /* "boll" 45866 */
      9,  27,   7,   8,   6,   4,   1,  11,   8,  20,   1,   0,  /* "bollapragada" 45878 */
      9,  25,   7,  30,   0,  /* "bolles" 45883 */
      9,   1,   7,  21,   3,  26,  21,   4,  26,   0,  /* "bollettieri" 45893 */
      9,  25,   7,  31,  32,   0,  /* "bolling" 45899 */
      9,   8,   7,  36,   4,   0,  /* "bollore" 45905 */
      9,   1,   7,  25,  13,  26,   0,  /* "bologna" 45912 */
      9,  27,   7,  27,  11,  13,   2,  30,  26,   0,  /* "bolognese" 45922 */
      9,   8,   7,  19,  11,  13,  21,  14,  26,   0,  /* "bolognesi" 45932 */
      9,   8,   7,   1,   3,   5,  13,   0,  /* "bolotin" 45940 */
      9,  25,   7,  14,  10,   0,  /* "bolser" 45946 */
      9,  25,   7,  33,   1,  22,   5,  12,   0,  /* "bolshevik" 45955 */
      9,  25,   7,  33,   1,  22,   5,  12,  14,   0,  /* "bolsheviks" 45965 */
      9,  25,   7,  33,   1,  22,   5,  30,   1,  17,   0,  /* "bolshevism" 45976 */
      9,  25,   7,  33,  31,  22,   5,  14,   3,   0,  /* "bolshevist" 45986 */
      9,  27,   7,  33,  49,   0,  /* "bolshoi" 45992 */
      9,  25,   7,   3,   0,  /* "bolt" 45997 */
      9,  25,   7,   3,  38,  48,  14,   0,  /* "bolthouse" 46005 */
      9,  25,   7,   1,  14,   0,  /* "bolus" 46011 */
      9,   1,   7,  41,   8,   4,  20,   0,  /* "bolyard" 46019 */
      9,  25,   7,  30,   0,  /* "bolz" 46024 */
      9,   8,  17,   0,  /* "bom" 46028 */
      9,   1,  17,   8,   4,   0,  /* "bomar" 46034 */
      9,   8,  17,   0,  /* "bomb" 46038 */
      9,   8,  17,   9,   1,   0,  /* "bomba" 46044 */
      9,  19,  17,   9,   8,   4,  20,   0,  /* "bombard" 46052 */
      9,   8,  17,   9,  10,  20,   5,   4,   0,  /* "bombardier" 46061 */
      9,  19,  17,   9,   8,   4,  20,  31,  32,   0,  /* "bombarding" 46071 */
      9,   8,  17,   9,  34,  14,   3,   0,  /* "bombast" 46079 */
      9,  19,  17,   9,   2,   0,  /* "bombay" 46085 */
      9,   8,  17,   9,  21,  12,   0,  /* "bombeck" 46092 */
      9,   8,  17,   9,  10,  11,   0,  /* "bomberg" 46099 */
      9,   8,  17,   9,  10,  11,  10,   0,  /* "bomberger" 46107 */
      9,   8,  17,  17,  28,  12,  10,   0,  /* "bombmaker" 46115 */
      9,   8,  17,  17,  28,  12,  31,  32,   0,  /* "bombmaking" 46124 */
      9,   8,  17,  33,  21,   7,   0,  /* "bombshell" 46131 */
      9,   8,  17,  10,  23,   3,  27,   0,  /* "bommarito" 46139 */
      9,   8,  13,   0,  /* "bon" 46143 */
      9,  25,  13,   1,   0,  /* "bona" 46148 */
      9,  27,  13,   8,  42,  26,   0,  /* "bonacci" 46155 */
      9,  27,  13,   8,  20,  26,  27,   0,  /* "bonadio" 46163 */
      9,   8,  13,   1,  20,  29,  42,  26,   0,  /* "bonaduce" 46172 */
      9,   8,  13,   1,  37,  39,  20,   0,  /* "bonafide" 46180 */
      9,  27,  13,   8,  13,  26,   0,  /* "bonanni" 46187 */
      9,  27,  13,   8,  13,  27,   0,  /* "bonanno" 46194 */
      9,   1,  13,  24,  13,  30,   1,   0,  /* "bonanza" 46202 */
      9,  25,  13,   1,   6,   8,   4,   3,   0,  /* "bonaparte" 46211 */
      9,  25,  13,  10,   0,  /* "bonar" 46216 */
      9,  27,  13,  19,  14,  21,   4,   1,   0,  /* "bonasera" 46225 */
      9,  27,  13,  19,  22,  15,  13,   3,  45,   4,   1,   0,  /* "bonaventura" 46237 */
      9,   8,  13,   2,  22,  26,   1,   0,  /* "bonavia" 46245 */
      9,  27,  13,  19,  22,  23,   3,   1,   0,  /* "bonavita" 46254 */
      9,   8,  13,   1,  47,   5,   3,  14,   0,  /* "bonawitz" 46263 */
      9,   8,  13,  20,   0,  /* "bond" 46268 */
      9,   1,  13,  20,   8,   4,   0,  /* "bondar" 46275 */
      9,  27,  13,  20,  45,   4,   1,  13,   3,   0,  /* "bondurant" 46285 */
      9,  25,  13,   0,  /* "bone" 46289 */
      9,  27,  13,  21,   7,  26,   0,  /* "bonelli" 46296 */
      9,  27,  13,  21,   7,  27,   0,  /* "bonello" 46303 */
      9,  25,  13,  37,   1,  13,   3,   0,  /* "bonenfant" 46311 */
      9,  25,  13,  14,   3,  23,   7,   0,  /* "bonesteel" 46319 */
      9,  25,  13,   3,   0,  /* "bonet" 46324 */
      9,  27,  13,  21,   3,  26,   0,  /* "bonetti" 46331 */
      9,  27,  13,  37,   8,  13,   3,  26,   0,  /* "bonfanti" 46340 */
      9,   8,  13,  37,  39,  10,   0,  /* "bonfire" 46347 */
      9,   8,  13,  37,  39,  10,  30,   0,  /* "bonfires" 46355 */
      9,   8,  32,   0,  /* "bong" 46359 */
      9,   1,  32,  11,   8,   4,  20,   0,  /* "bongard" 46367 */
      9,  27,  13,  40,  18,   4,  13,  27,   0,  /* "bongiorno" 46376 */
      9,  27,  13,  40,  27,  22,   8,  13,  26,   0,  /* "bongiovanni" 46386 */
      9,   8,  32,  11,  25,   0,  /* "bongo" 46392 */
      9,   8,  32,  11,  25,  30,   0,  /* "bongos" 46399 */
      9,  25,  13,  26,   0,  /* "boni" 46404 */
      9,   8,  13,  41,  10,   0,  /* "bonier" 46410 */
      9,   8,  13,   1,  37,   2,   0,  /* "bonifay" 46417 */
      9,   1,  13,   5,   7,   1,   0,  /* "bonilla" 46424 */
      9,  25,  13,   5,  13,   0,  /* "bonin" 46430 */
      9,  27,  13,  23,  13,  26,   0,  /* "bonine" 46437 */
      9,  25,  13,  31,  32,   0,  /* "boning" 46443 */
      9,  25,  13,  26,  10,   0,  /* "bonior" 46449 */
      9,  27,  13,  23,   3,   1,   0,  /* "bonita" 46456 */
      9,   1,  13,  23,   3,  27,   0,  /* "bonito" 46463 */
      9,   1,  13,  43,  45,   4,   0,  /* "bonjour" 46470 */
      9,   8,  32,  12,   0,  /* "bonk" 46475 */
      9,  18,  32,  12,  10,   0,  /* "bonker" 46481 */
      9,   1,  32,  12,  18,  37,  14,  12,  26,   0,  /* "bonkowski" 46491 */
      9,   8,  13,   0,  /* "bonn" 46495 */
      9,   8,  13,   0,  /* "bonne" 46499 */
      9,   1,  13,  25,   0,  /* "bonneau" 46504 */
      9,  18,  13,  10,   0,  /* "bonner" 46509 */
      9,  18,  13,  30,   0,  /* "bonnes" 46514 */
      9,   8,  13,   1,   3,   0,  /* "bonnet" 46520 */
      9,   1,  13,  21,   3,   0,  /* "bonnette" 46526 */
      9,   8,  13,   1,   9,  15,   7,   0,  /* "bonnibelle" 46534 */
      9,  25,  13,  27,   0,  /* "bono" 46539 */
      9,  19,  13,   8,   9,  27,  30,   0,  /* "bonobos" 46547 */
      9,   8,  13,   1,  17,  27,   0,  /* "bonomo" 46554 */
      9,  19,  13,  14,  39,   0,  /* "bonsai" 46560 */
      9,  27,  13,  14,   8,   7,   0,  /* "bonsall" 46567 */
      9,  27,  13,  14,  26,  11,  13,  18,   4,  26,   0,  /* "bonsignore" 46578 */
      9,   8,  13,   3,   0,  /* "bonte" 46583 */
      9,   8,  13,   3,   4,   2,  11,  10,   0,  /* "bontrager" 46592 */
      9,  27,  13,  45,   4,   1,   0,  /* "bonura" 46599 */
      9,  25,  13,   1,  14,   0,  /* "bonus" 46605 */
      9,  25,  13,   1,  14,   1,  30,   0,  /* "bonuses" 46613 */
      9,   8,  13,  22,   1,   7,   2,  13,   0,  /* "bonvillain" 46622 */
      9,  25,  13,  22,   5,   7,   0,  /* "bonville" 46629 */
      9,  25,  13,  26,   0,  /* "bony" 46634 */
      9,  29,   0,  /* "boo" 46637 */
      9,  29,   9,   0,  /* "boob" 46641 */
      9,  29,   9,  30,   0,  /* "boobs" 46646 */
      9,  29,   9,  26,   0,  /* "booby" 46651 */
      9,  29,  12,   0,  /* "boock" 46655 */
      9,  29,  20,   1,   7,   0,  /* "boodle" 46661 */
      9,  29,  20,   1,   7,  30,   0,  /* "boodles" 46668 */
      9,  29,  20,  26,   0,  /* "boody" 46673 */
      9,   8,  27,   0,  /* "booe" 46677 */
      9,  29,  20,   0,  /* "booed" 46681 */
      9,  29,  26,   0,  /* "booee" 46685 */
      9,  29,  11,  26,   0,  /* "boogie" 46690 */
      9,  29,  10,   0,  /* "booher" 46694 */
      9,  29,  31,  32,   0,  /* "booing" 46699 */
      9,  45,  12,   0,  /* "book" 46703 */
      9,  45,  12,   9,  39,  13,  20,  10,   0,  /* "bookbinder" 46712 */
      9,  45,  12,  12,   2,  14,   0,  /* "bookcase" 46719 */
      9,  45,  12,  12,   2,  14,   1,  30,   0,  /* "bookcases" 46728 */
      9,  45,  12,  14,  21,   7,  10,   0,  /* "bookcellar" 46736 */
      9,  45,  12,  12,  23,   6,  10,   0,  /* "bookkeeper" 46744 */
      9,  45,  12,  12,  23,   6,  10,  30,   0,  /* "bookkeepers" 46753 */
      9,  45,  12,  12,  23,   6,  31,  32,   0,  /* "bookkeeping" 46762 */
      9,  45,  12,  17,  27,   9,  23,   7,   0,  /* "bookmobile" 46771 */
      9,  45,  12,  33,  21,   7,  22,  30,   0,  /* "bookshelves" 46780 */
      9,  45,  12,  47,  44,  17,   0,  /* "bookworm" 46787 */
      9,  29,   7,   0,  /* "boole" 46791 */
      9,  29,  17,   0,  /* "boom" 46795 */
      9,  45,  17,   9,   8,  12,  14,   0,  /* "boombox" 46803 */
      9,  29,  17,  20,   0,  /* "boomed" 46808 */
      9,  29,  17,  10,   0,  /* "boomer" 46813 */
      9,  29,  17,  10,  24,  32,   0,  /* "boomerang" 46820 */
      9,  29,  17,  10,  24,  32,  20,   0,  /* "boomeranged" 46828 */
      9,  29,  17,  10,  30,   0,  /* "boomers" 46834 */
      9,  29,  17,  10,  33,  39,  13,   0,  /* "boomershine" 46842 */
      9,  29,  17,  38,  27,  10,   0,  /* "boomhower" 46849 */
      9,  29,  17,  31,  32,   0,  /* "booming" 46855 */
      9,  29,  17,   7,   1,   3,   0,  /* "boomlet" 46862 */
      9,  29,  17,  30,   0,  /* "booms" 46867 */
      9,  29,  17,  30,  17,   1,   0,  /* "boomsma" 46874 */
      9,  29,  17,   3,  48,  13,   0,  /* "boomtown" 46881 */
      9,  29,  13,   0,  /* "boon" 46885 */
      9,  29,  13,  20,   8,  12,  14,   0,  /* "boondocks" 46893 */
      9,  29,  13,  20,   8,  11,   1,   7,   0,  /* "boondoggle" 46902 */
      9,  29,  13,  20,   8,  11,   1,   7,  30,   0,  /* "boondoggles" 46912 */
      9,  29,  13,   0,  /* "boone" 46916 */
      9,  29,  13,  14,   3,   4,   1,   0,  /* "boonstra" 46924 */
      9,  29,  13,   3,   1,  13,   0,  /* "boonton" 46931 */
      9,  29,  13,  22,   5,   7,   0,  /* "boonville" 46938 */
      9,  29,   6,   0,  /* "boop" 46942 */
      9,  45,   4,   0,  /* "boor" 46946 */
      9,  45,   4,   1,  30,   0,  /* "booras" 46952 */
      9,  45,   4,  31,  33,   0,  /* "boorish" 46958 */
      9,  45,   4,  31,  33,  13,   1,  14,   0,  /* "boorishness" 46967 */
      9,  29,   4,  14,   3,   5,  13,   0,  /* "boorstin" 46975 */
      9,  18,   4,   3,  14,   0,  /* "boortz" 46981 */
      9,  29,  30,   0,  /* "boos" 46985 */
      9,  29,  14,   0,  /* "boose" 46989 */
      9,  29,  14,   3,   0,  /* "boost" 46994 */
      9,  29,  14,   3,   1,  20,   0,  /* "boosted" 47001 */
      9,  29,  14,   3,  10,   0,  /* "booster" 47007 */
      9,  29,  14,   3,  10,   5,  30,   1,  17,   0,  /* "boosterism" 47017 */
      9,  29,  14,   3,  10,  30,   0,  /* "boosters" 47024 */
      9,  29,  14,   3,  31,  32,   0,  /* "boosting" 47031 */
      9,  29,  14,   3,  14,   0,  /* "boosts" 47037 */
      9,  29,   3,   0,  /* "boot" 47041 */
      9,  29,   3,   0,  /* "boote" 47045 */
      9,  29,   3,   1,  20,   0,  /* "booted" 47051 */
      9,  29,   3,   1,  13,   0,  /* "booten" 47057 */
      9,  29,  16,   0,  /* "booth" 47061 */
      9,  29,  16,   9,  26,   0,  /* "boothby" 47067 */
      9,  29,  46,   0,  /* "boothe" 47071 */
      9,  29,  16,  17,   1,  13,   0,  /* "boothman" 47078 */
      9,  29,  16,   4,  49,  20,   0,  /* "boothroyd" 47085 */
      9,  29,  16,  14,   0,  /* "booths" 47090 */
      9,  29,   3,  26,   0,  /* "bootie" 47095 */
      9,  29,   3,  26,  30,   0,  /* "booties" 47101 */
      9,  29,   3,  31,  32,   0,  /* "booting" 47107 */
      9,  29,   3,   7,  21,  11,   0,  /* "bootleg" 47114 */
      9,  29,   3,   7,  21,  11,  10,   0,  /* "bootlegger" 47122 */
      9,  29,   3,   7,  21,  11,  10,  30,   0,  /* "bootleggers" 47131 */
      9,  29,   3,   7,  21,  11,  31,  32,   0,  /* "bootlegging" 47140 */
      9,  29,   3,   7,  21,  11,  30,   0,  /* "bootlegs" 47148 */
      9,  29,   3,   1,  13,   0,  /* "booton" 47154 */
      9,  29,   3,  14,   0,  /* "boots" 47159 */
      9,  29,   3,  14,   3,   4,  24,   6,   0,  /* "bootstrap" 47168 */
      9,  29,   3,  14,   3,   4,  24,   6,  14,   0,  /* "bootstraps" 47178 */
      9,  29,   3,  26,   0,  /* "booty" 47183 */
      9,  29,   3,  14,   0,  /* "bootz" 47188 */
      9,  29,  30,   0,  /* "booz" 47192 */
      9,  29,  30,   0,  /* "booze" 47196 */
      9,  29,  30,  10,   0,  /* "boozer" 47201 */
      9,  29,  30,  26,  10,   0,  /* "boozier" 47207 */
      9,  29,  30,  31,  32,   0,  /* "boozing" 47213 */
      9,  29,  30,  26,   0,  /* "boozy" 47218 */
      9,   8,   6,   0,  /* "bop" 47222 */
      9,  27,   6,  23,   6,   0,  /* "bopeep" 47228 */
      9,  27,   6,  21,   4,   1,   0,  /* "bopera" 47235 */
      9,  25,  37,  29,  16,  19,   3,  14,  47,   8,  13,   1,   0,  /* "bophuthatswana" 47248 */
      9,   8,   6,   0,  /* "bopp" 47252 */
      9,   8,  12,  47,   5,  14,   3,   0,  /* "boquist" 47260 */
      9,  18,   4,   1,   0,  /* "bora" 47265 */
      9,  10,   8,  37,  14,  12,  26,   0,  /* "borawski" 47273 */
      9,  18,   4,  24,  12,  14,   0,  /* "borax" 47280 */
      9,  10,  33,   8,   4,  20,   0,  /* "borchard" 47287 */
      9,  10,  33,   8,   4,  20,   3,   0,  /* "borchardt" 47295 */
      9,  36,   4,  20,  24,   7,  27,   0,  /* "bordallo" 47303 */
      9,  10,  20,  25,   0,  /* "bordeau" 47308 */
      9,  36,   4,  20,  25,   0,  /* "bordeaux" 47314 */
      9,  36,   4,  20,  21,   7,  25,   0,  /* "bordello" 47322 */
      9,  18,   4,  20,   1,   7,  19,  13,   0,  /* "bordelon" 47331 */
      9,  36,   4,  20,  15,  13,   8,  22,   0,  /* "bordenave" 47340 */
      9,  18,   4,  20,  10,   7,  39,  13,   0,  /* "borderline" 47349 */
      9,  36,   4,  20,  27,  13,   8,   4,  27,   0,  /* "bordonaro" 47359 */
      9,  18,   4,  20,  47,  15,   7,   0,  /* "bordwell" 47367 */
      9,  18,   4,   0,  /* "bore" 47371 */
      9,  18,   4,  26,  24,   7,   1,  14,   0,  /* "borealis" 47380 */
      9,  18,   4,  20,   1,  17,   0,  /* "boredom" 47387 */
      9,  18,   4,   1,   7,   0,  /* "borel" 47393 */
      9,  18,   4,   1,   7,   0,  /* "borell" 47399 */
      9,  18,   4,  11,   0,  /* "borg" 47404 */
      9,  18,   4,  11,  28,  14,   0,  /* "borges" 47411 */
      9,  18,   4,  11,  15,  14,   0,  /* "borgess" 47418 */
      9,  18,   4,  41,   1,   0,  /* "borja" 47424 */
      9,  18,   4,  41,   1,  30,   0,  /* "borjas" 47431 */
      9,  18,   4,  12,   0,  /* "bork" 47436 */
      9,  18,   4,  12,   1,  13,  38,   8,  11,   1,  13,   0,  /* "borkenhagen" 47448 */
      9,  10,  12,  18,  37,  14,  12,  26,   0,  /* "borkowski" 47457 */
      9,  18,   4,  13,   0,  /* "born" 47462 */
      9,  18,   4,  13,  26,  25,   0,  /* "borneo" 47469 */
      9,  18,   4,  13,  38,  36,   4,  14,   3,   0,  /* "bornhorst" 47479 */
      9,  18,   4,  13,   3,   4,  28,  11,  10,   0,  /* "borntrager" 47489 */
      9,  44,  27,   0,  /* "boro" 47493 */
      9,  18,   4,  36,  37,   0,  /* "boroff" 47499 */
      9,  36,   4,  49,   1,  13,   0,  /* "boroian" 47506 */
      9,  18,   4,   8,  13,   0,  /* "boron" 47512 */
      9,  18,   4,   1,  14,  31,  40,   0,  /* "borosage" 47520 */
      9,  10,  48,  14,  12,  26,   0,  /* "boroski" 47527 */
      9,  44,  25,   0,  /* "borough" 47531 */
      9,  44,  25,  30,   0,  /* "boroughs" 47536 */
      9,  44,  27,  22,  31,  42,   0,  /* "borowicz" 47543 */
      9,  10,  48,  14,  12,  26,   0,  /* "borowsky" 47550 */
      9,  36,   4,  12,  47,  21,  30,   0,  /* "borquez" 47558 */
      9,  18,   4,   0,  /* "borre" 47562 */
      9,  36,   4,   2,   7,   0,  /* "borrell" 47568 */
      9,  18,   4,  21,   7,  27,   0,  /* "borrello" 47575 */
      9,  18,   4,  36,  37,   0,  /* "borroff" 47581 */
      9,  18,  10,   4,   0,  /* "borror" 47586 */
      9,   8,   4,  25,   0,  /* "borrow" 47591 */
      9,   8,   4,  25,  20,   0,  /* "borrowed" 47597 */
      9,  18,   4,  29,  14,  27,   0,  /* "borruso" 47604 */
      9,  18,   4,  30,   0,  /* "bors" 47609 */
      9,  18,   4,   3,   0,  /* "bort" 47614 */
      9,  18,   4,   3,   1,   7,   0,  /* "bortle" 47621 */
      9,  18,   4,   1,  12,   0,  /* "boruch" 47627 */
      9,  10,  35,   3,  14,  12,  26,   0,  /* "borucki" 47635 */
      9,  18,   4,   1,  37,   0,  /* "boruff" 47641 */
      9,  36,   4,  29,  13,  20,   1,   0,  /* "borunda" 47649 */
      9,  18,   4,  47,   5,  13,   0,  /* "borwn" 47656 */
      9,   8,  14,   0,  /* "bos" 47660 */
      9,   8,  14,  19,   4,  11,   0,  /* "bosarge" 47667 */
      9,  27,  14,  12,  19,   4,  23,  13,  27,   0,  /* "boscarino" 47677 */
      9,  18,  33,  26,   0,  /* "boschee" 47682 */
      9,  18,  33,   1,  13,   0,  /* "boschen" 47688 */
      9,  18,  33,  10,   3,   0,  /* "boschert" 47694 */
      9,  25,  14,  42,   1,   0,  /* "boscia" 47700 */
      9,  18,  14,  12,  27,   0,  /* "bosco" 47706 */
      9,  25,  30,   0,  /* "bose" 47710 */
      9,  25,  30,   1,  13,  20,  18,   4,  37,  10,   0,  /* "bosendorfer" 47721 */
      9,   8,  33,   0,  /* "bosh" 47725 */
      9,  18,  14,  12,   5,  13,   0,  /* "boskin" 47732 */
      9,  25,  14,  12,  27,   0,  /* "bosko" 47738 */
      9,  18,  14,   7,   2,  11,  27,   0,  /* "boslego" 47746 */
      9,   8,  14,   1,   7,  10,   0,  /* "bosler" 47753 */
      9,   8,  30,   7,  26,   0,  /* "bosley" 47759 */
      9,  25,  14,  17,   1,   0,  /* "bosma" 47765 */
      9,   8,  30,  13,  26,   1,   0,  /* "bosnia" 47772 */
      9,   8,  30,  13,  26,   1,  13,   0,  /* "bosnian" 47780 */
      9,   8,  30,  13,  26,   1,  13,  30,   0,  /* "bosnians" 47789 */
      9,   8,  30,  13,  26,   1,  30,   0,  /* "bosnias" 47797 */
      9,  25,  14,  27,   0,  /* "boso" 47802 */
      9,  45,  30,   1,  17,   0,  /* "bosom" 47808 */
      9,  27,  14,  12,  47,  21,  30,   0,  /* "bosquez" 47816 */
      9,  18,  14,   0,  /* "boss" 47820 */
      9,   1,  14,   8,   4,  20,   0,  /* "bossard" 47827 */
      9,   1,  14,   8,   4,   3,   0,  /* "bossart" 47834 */
      9,  18,  14,  10,  17,   1,  13,   0,  /* "bosserman" 47842 */
      9,  18,  14,   1,  30,   0,  /* "bosses" 47848 */
      9,  18,  14,  38,   8,   4,   3,   0,  /* "bosshardt" 47856 */
      9,  18,  14,  38,   8,   4,   3,   0,  /* "bosshart" 47864 */
      9,  25,  14,  26,   0,  /* "bossi" 47869 */
      9,   8,  14,   1,   7,  10,   0,  /* "bossler" 47876 */
      9,  25,  14,  27,   0,  /* "bosso" 47881 */
      9,   8,  14,   3,   0,  /* "bost" 47886 */
      9,   8,  14,  42,   5,  13,   0,  /* "bostian" 47893 */
      9,  25,  14,   3,  31,  12,   0,  /* "bostick" 47900 */
      9,  25,  14,   3,   8,  12,   0,  /* "bostock" 47907 */
      9,   8,  14,   3,  27,  13,  26,   1,  13,  30,   0,  /* "bostonians" 47918 */
      9,   8,  14,   3,  47,  31,  12,   0,  /* "bostwick" 47926 */
      9,   8,  30,  47,  15,   7,   0,  /* "boswell" 47933 */
      9,  18,  30,  47,  10,  16,   0,  /* "bosworth" 47940 */
      9,   1,   3,  24,  13,  31,  12,   0,  /* "botanic" 47948 */
      9,   1,   3,  24,  13,  31,  12,   1,   7,   0,  /* "botanical" 47958 */
      9,   1,   3,  24,  13,   1,  12,   1,   7,  26,   0,  /* "botanically" 47969 */
      9,   8,   3,   1,   7,  10,   0,  /* "boteler" 47976 */
      9,  27,   3,  21,   7,  27,   0,  /* "botelho" 47983 */
      9,  27,   3,  21,   4,  27,   0,  /* "botero" 47990 */
      9,   8,   3,  37,   7,  39,   0,  /* "botfly" 47997 */
      9,  25,  16,   0,  /* "both" 48001 */
      9,  25,  46,   0,  /* "bothe" 48005 */
      9,   8,  16,   1,  13,   0,  /* "bothun" 48011 */
      9,   8,   3,   5,  13,   0,  /* "botin" 48017 */
      9,   8,   3,  27,   7,  37,   0,  /* "botolf" 48024 */
      9,   1,   3,   4,   5,   3,   5,  14,   0,  /* "botrytis" 48033 */
      9,   8,  42,   1,   9,  21,   7,  27,   0,  /* "botshabelo" 48042 */
      9,  19,   3,  14,  47,   8,  13,   1,   0,  /* "botswana" 48051 */
      9,   8,   3,   0,  /* "bott" 48055 */
      9,  27,   3,   8,   4,  26,   0,  /* "bottari" 48062 */
      9,   8,   3,  42,  10,   0,  /* "bottcher" 48068 */
      9,   8,   3,   1,   7,   0,  /* "bottel" 48074 */
      9,   1,   3,  21,  13,  37,  26,   7,  20,   0,  /* "bottenfield" 48084 */
      9,   8,   3,  11,  10,   0,  /* "bottger" 48090 */
      9,  27,   3,  23,  13,  26,   0,  /* "bottini" 48097 */
      9,  27,   3,  23,  13,  27,   0,  /* "bottino" 48104 */
      9,   8,   3,   1,   7,   0,  /* "bottle" 48110 */
      9,   8,   3,   1,   7,  20,   0,  /* "bottled" 48117 */
      9,   8,   3,   1,   7,  13,  21,  12,   0,  /* "bottleneck" 48126 */
      9,   8,   3,   1,   7,  13,  21,  12,  14,   0,  /* "bottlenecks" 48136 */
      9,   8,   3,   7,  10,   0,  /* "bottler" 48142 */
      9,   8,   3,   7,  10,  30,   0,  /* "bottlers" 48149 */
      9,   8,   3,   1,   7,  30,   0,  /* "bottles" 48156 */
      9,   8,   3,   1,   7,  31,  32,   0,  /* "bottling" 48164 */
      9,   8,   3,   1,  17,  37,   5,  33,   0,  /* "bottomfish" 48173 */
      9,  27,   3,  25,  13,  26,   0,  /* "bottone" 48180 */
      9,   8,   3,  10,  37,   0,  /* "bottorf" 48186 */
      9,   8,  42,  29,   7,   5,  30,   1,  17,   0,  /* "botulism" 48196 */
      9,   8,   3,  14,   0,  /* "botz" 48201 */
      9,  29,  33,   8,   4,  20,   0,  /* "bouchard" 48208 */
      9,  48,  42,   0,  /* "bouche" 48212 */
      9,  29,  33,   1,   0,  /* "boucher" 48217 */
      9,  29,  33,  23,   0,  /* "bouchey" 48222 */
      9,  48,  42,   1,   7,  19,  13,   0,  /* "bouchillon" 48230 */
      9,  29,  20,   5,  13,   0,  /* "boudin" 48236 */
      9,  29,  20,  49,  13,   0,  /* "boudoin" 48242 */
      9,  29,  20,  49,   4,   0,  /* "boudoir" 48248 */
      9,  29,  20,   4,  25,   0,  /* "boudreau" 48254 */
      9,  29,  20,   4,  25,   0,  /* "boudreaux" 48260 */
      9,  29,  37,   8,   4,  20,   0,  /* "bouffard" 48267 */
      9,  29,  11,   1,  13,  22,   5,   7,   0,  /* "bougainville" 48276 */
      9,  29,  11,   2,  13,  22,   5,   7,  26,   1,   0,  /* "bougainvillea" 48287 */
      9,   8,   3,   0,  /* "bought" 48291 */
      9,  18,   3,   1,  13,   0,  /* "boughten" 48297 */
      9,  18,   3,  10,   0,  /* "boughter" 48302 */
      9,  29,  43,  23,   0,  /* "bougie" 48307 */
      9,  29,  23,   0,  /* "bouie" 48311 */
      9,  29,  47,   5,   7,   1,  13,   0,  /* "bouillon" 48319 */
      9,  48,  12,  13,  39,   3,   0,  /* "bouknight" 48326 */
      9,  29,   7,   1,   7,   1,  14,   0,  /* "boulalas" 48334 */
      9,  48,   7,   1,  32,  10,   0,  /* "boulanger" 48341 */
      9,  45,  20,   1,  13,   0,  /* "boulden" 48347 */
      9,  29,   7,   0,  /* "boule" 48351 */
      9,  48,   7,  10,   0,  /* "bouler" 48356 */
      9,  29,   7,  21,   3,   0,  /* "boulet" 48362 */
      9,  45,   7,   1,  22,   8,   4,  20,   0,  /* "boulevard" 48371 */
      9,  45,   7,   1,  22,   8,   4,  20,  30,   0,  /* "boulevards" 48381 */
      9,  29,   7,  23,   0,  /* "bouley" 48386 */
      9,  29,   7,  21,  30,   0,  /* "boulez" 48392 */
      9,  29,   7,  26,  10,   0,  /* "boulier" 48398 */
      9,  29,   7,  41,   1,  13,   0,  /* "boullion" 48405 */
      9,  29,   7,  25,  30,   0,  /* "boulos" 48411 */
      9,  48,   7,   3,  31,  32,  38,  48,  14,   0,  /* "boultinghouse" 48421 */
      9,  48,   7,   3,   1,  13,   0,  /* "boulton" 48428 */
      9,  48,   7,  47,  15,   4,   0,  /* "boulware" 48435 */
      9,  25,  17,   1,   0,  /* "bouma" 48440 */
      9,  29,  17,  24,  13,   0,  /* "bouman" 48446 */
      9,  48,  13,  20,  10,  26,  30,   0,  /* "boundaries" 48454 */
      9,  48,  13,  20,  10,  26,   0,  /* "boundary" 48461 */
      9,  29,  12,   2,   0,  /* "bouquet" 48466 */
      9,  27,  12,   2,  30,   0,  /* "bouquets" 48472 */
      9,  48,   4,   0,  /* "bour" 48476 */
      9,  51,   4,   8,  14,   1,   0,  /* "bourassa" 48483 */
      9,  51,   4,   9,  25,   0,  /* "bourbeau" 48489 */
      9,  44,   9,   1,  13,   0,  /* "bourbon" 48495 */
      9,  44,   9,   1,  13,  30,   0,  /* "bourbons" 48502 */
      9,  48,   4,  12,  26,  10,   0,  /* "bourcier" 48509 */
      9,  51,   4,  20,  25,   0,  /* "bourdeau" 48515 */
      9,  18,   4,  11,   0,  /* "bourg" 48520 */
      9,  51,   4,  11,  25,   0,  /* "bourgault" 48526 */
      9,  51,   4,  43,  47,   8,   0,  /* "bourgeois" 48533 */
      9,  45,   4,  43,  47,   8,  30,  23,   0,  /* "bourgeoisie" 48542 */
      9,  51,   4,  43,  21,   3,   0,  /* "bourget" 48549 */
      9,  36,   4,  11,  47,  23,   9,   1,   0,  /* "bourguiba" 48558 */
      9,  45,   4,  11,  26,  13,  41,  25,  13,   0,  /* "bourguignon" 48568 */
      9,  44,  12,   0,  /* "bourke" 48572 */
      9,  51,   4,   7,  24,  13,  20,   0,  /* "bourland" 48580 */
      9,  18,   4,  13,  26,   1,  14,   0,  /* "bournias" 48588 */
      9,  45,   4,  12,   0,  /* "bourque" 48593 */
      9,  51,   4,  12,  47,  24,  13,   0,  /* "bourquin" 48601 */
      9,  51,   4,  21,   3,   0,  /* "bourret" 48607 */
      9,  18,   4,  14,   0,  /* "bourse" 48612 */
      9,  18,   4,  14,   1,  30,   0,  /* "bourses" 48619 */
      9,  29,   4,  14,  31,  12,  18,   3,   0,  /* "boursicot" 48628 */
      9,  29,  14,  12,   1,   0,  /* "bouska" 48634 */
      9,   1,  14,  17,  24,  13,   0,  /* "bousman" 48641 */
      9,  29,  14,  12,  21,   3,   0,  /* "bousquet" 48648 */
      9,  29,  14,  34,  12,   0,  /* "boussac" 48654 */
      9,  29,  14,   3,   1,  13,  26,   0,  /* "boustany" 48662 */
      9,  48,   3,   0,  /* "bout" 48666 */
      9,  29,   3,  21,   7,   0,  /* "boutell" 48672 */
      9,  29,   3,  21,   7,   0,  /* "boutelle" 48678 */
      9,  48,  16,   1,   7,  26,  10,   0,  /* "bouthillier" 48686 */
      9,  48,   3,   1,   7,  26,  10,   0,  /* "boutilier" 48694 */
      9,  29,   3,  24,  13,   0,  /* "boutin" 48700 */
      9,  29,   3,  23,  12,   0,  /* "boutique" 48706 */
      9,  29,   3,  23,  12,  14,   0,  /* "boutiques" 48713 */
      9,  48,   3,   1,  13,   0,  /* "bouton" 48719 */
      9,  29,   3,   4,  25,  14,   0,  /* "boutros" 48726 */
      9,  29,   3,   0,  /* "boutte" 48730 */
      9,  48,   3,  47,  21,   7,   0,  /* "boutwell" 48737 */
      9,  29,  22,  26,   2,   0,  /* "bouvier" 48743 */
      9,  48,   1,  13,  30,   0,  /* "bouwens" 48749 */
      9,  48,  12,  24,  17,   6,   0,  /* "bouwkamp" 48756 */
      9,  48,  17,   1,  13,   0,  /* "bouwman" 48762 */
      9,  29,  30,  17,   1,   0,  /* "bouwsma" 48768 */
      9,  49,  10,   0,  /* "bouyer" 48772 */
      9,  49,  43,  28,   0,  /* "bouygues" 48777 */
      9,  29,  30,   1,   0,  /* "bouza" 48782 */
      9,  25,  22,   1,   0,  /* "bova" 48787 */
      9,   1,  22,   8,   4,  20,   0,  /* "bovard" 48794 */
      9,  25,  22,   0,  /* "bove" 48798 */
      9,  35,  22,  26,   0,  /* "bovee" 48803 */
      9,  35,  22,   1,  13,   0,  /* "boven" 48809 */
      9,  27,  22,  21,  13,  30,  26,   0,  /* "bovenzi" 48817 */
      9,  27,  22,  21,   4,  26,   0,  /* "boveri" 48824 */
      9,  25,  22,  14,   6,  19,   0,  /* "bovespa" 48831 */
      9,  25,  22,   5,  13,   0,  /* "bovin" 48837 */
      9,  25,  22,  39,  13,   0,  /* "bovine" 48843 */
      9,  48,   0,  /* "bow" 48846 */
      9,  48,  35,   3,  10,   0,  /* "bowater" 48852 */
      9,  25,  20,  31,  42,   0,  /* "bowditch" 48858 */
      9,  25,  20,   1,   7,   0,  /* "bowdle" 48864 */
      9,  27,  20,  49,  13,   0,  /* "bowdoin" 48870 */
      9,  25,   0,  /* "bowe" 48873 */
      9,  48,  20,   0,  /* "bowed" 48877 */
      9,  48,   1,   7,   0,  /* "bowel" 48882 */
      9,  48,   1,   7,  30,   0,  /* "bowels" 48888 */
      9,  25,  10,  17,   1,  13,   0,  /* "bowerman" 48895 */
      9,  25,  10,  17,  34,  14,   3,  10,   0,  /* "bowermaster" 48904 */
      9,  27,  44,  14,   1,  12,   0,  /* "bowersock" 48911 */
      9,  27,  44,  14,  19,  12,  14,   0,  /* "bowersox" 48919 */
      9,  25,   7,   0,  /* "bowl" 48923 */
      9,  25,  13,   0,  /* "bown" 48927 */
      9,  25,  13,  20,  30,   0,  /* "bownds" 48933 */
      9,  25,   4,  31,  32,   0,  /* "bowring" 48939 */
      9,  25,   4,   1,  13,   0,  /* "bowron" 48945 */
      9,  48,  30,   0,  /* "bows" 48949 */
      9,  25,  14,   0,  /* "bowse" 48953 */
      9,  48,  30,  20,   0,  /* "bowsed" 48958 */
      9,  25,  30,  10,   0,  /* "bowser" 48963 */
      9,  48,  30,   1,  30,   0,  /* "bowses" 48969 */
      9,  25,  33,  10,   0,  /* "bowsher" 48974 */
      9,  48,  30,  31,  32,   0,  /* "bowsing" 48980 */
      9,   8,  12,  14,   0,  /* "box" 48985 */
      9,   8,  12,  14,   9,  10,  11,  10,   0,  /* "boxberger" 48994 */
      9,   8,  12,  14,  12,   8,   4,   0,  /* "boxcar" 49002 */
      9,   8,  12,  14,  12,   8,   4,  30,   0,  /* "boxcars" 49011 */
      9,   8,  12,  14,   3,   0,  /* "boxed" 49017 */
      9,   8,  12,  14,   1,   7,   0,  /* "boxell" 49024 */
      9,   8,  12,  14,  10,   0,  /* "boxer" 49030 */
      9,   8,  12,  14,  10,  30,   0,  /* "boxers" 49037 */
      9,   8,  12,  14,   1,  30,   0,  /* "boxes" 49044 */
      9,   8,  12,  14,  31,  32,   0,  /* "boxing" 49051 */
      9,   8,  12,  14,   7,  26,   0,  /* "boxley" 49058 */
      9,   8,  12,  14,  47,  21,   7,   0,  /* "boxwell" 49066 */
      9,   8,  12,  14,  47,  45,  20,   0,  /* "boxwood" 49074 */
      9,   8,  12,  14,   0,  /* "boxx" 49079 */
      9,   8,  12,  14,  26,   0,  /* "boxy" 49085 */
      9,  49,   0,  /* "boy" 49088 */
      9,  49,   1,  12,   0,  /* "boyack" 49093 */
      9,  50,  24,  40,  26,   1,  13,   0,  /* "boyajian" 49101 */
      9,  49,  19,  13,   0,  /* "boyan" 49106 */
      9,  27,  41,   8,   4,   0,  /* "boyar" 49112 */
      9,  49,  12,   8,   3,   1,  20,   0,  /* "boycotted" 49120 */
      9,  49,  12,   8,   3,  31,  32,   0,  /* "boycotting" 49128 */
      9,  49,  12,   8,   3,  14,   0,  /* "boycotts" 49135 */
      9,  49,  20,   0,  /* "boyd" 49139 */
      9,  49,  20,  14,   3,   1,  13,   0,  /* "boydstun" 49147 */
      9,  49,   0,  /* "boye" 49150 */
      9,  49,  26,   1,   0,  /* "boyea" 49155 */
      9,  49,   5,   3,   0,  /* "boyett" 49160 */
      9,  49,  30,   0,  /* "boys" 49164 */
      9,  49,  30,   1,  13,   0,  /* "boyson" 49170 */
      9,  49,   3,   0,  /* "boyt" 49174 */
      9,  50,  35,  17,   0,  /* "boyum" 49179 */
      9,  49,  30,   0,  /* "boyz" 49183 */
      9,  25,  30,   1,   0,  /* "boza" 49188 */
      9,   1,  30,   8,   4,  20,   0,  /* "bozard" 49195 */
      9,   8,  30,  10,  16,   0,  /* "bozarth" 49201 */
      9,  25,  30,   0,  /* "boze" 49205 */
      9,  27,  30,  21,   7,   0,  /* "bozell" 49211 */
      9,   8,  30,   5,  38,   0,  /* "bozich" 49217 */
      9,  25,  30,  25,   0,  /* "bozo" 49222 */
      9,  25,  30,  25,  30,   0,  /* "bozos" 49228 */
      9,  19,  30,   3,  21,   6,   0,  /* "boztepe" 49235 */
      9,   8,  30,   1,   0,  /* "bozza" 49240 */
      9,   8,  30,  26,   0,  /* "bozzi" 49245 */
      9,   4,   8,   0,  /* "bra" 49249 */
      9,   4,   8,  33,   0,  /* "braasch" 49254 */
      9,   4,   8,  28,   3,   1,  13,   0,  /* "braaten" 49262 */
      9,   4,   8,   3,  14,   0,  /* "braatz" 49268 */
      9,   4,   8,   9,   1,  13,   3,   0,  /* "brabant" 49276 */
      9,   4,   8,   9,  31,  12,   0,  /* "brabec" 49283 */
      9,   4,  24,   9,  15,  13,  20,  10,   0,  /* "brabender" 49292 */
      9,   4,  24,  12,   0,  /* "brac" 49297 */
      9,   4,  24,  12,   1,  17,   8,  13,   3,  26,   0,  /* "bracamonte" 49308 */
      9,   4,  24,  12,   1,  17,   8,  13,   3,  26,  30,   0,  /* "bracamontes" 49320 */
      9,   4,   8,  42,  26,   0,  /* "bracci" 49326 */
      9,   4,   2,  14,   7,   1,   3,   0,  /* "bracelet" 49334 */
      9,   4,   2,  14,   7,   1,   3,  14,   0,  /* "bracelets" 49343 */
      9,   4,  19,  42,  21,   4,  27,   0,  /* "bracero" 49351 */
      9,   4,   2,  14,  47,  21,   7,   0,  /* "bracewell" 49359 */
      9,   4,   2,  14,  26,   0,  /* "bracey" 49365 */
      9,   4,   8,  12,  37,  21,   7,  20,   0,  /* "brachfeld" 49374 */
      9,   4,   2,  14,  31,  32,  11,   7,  26,   0,  /* "bracingly" 49384 */
      9,   4,  24,  12,   9,   1,   7,   0,  /* "brackbill" 49392 */
      9,   4,   1,  12,  23,  13,   0,  /* "brackeen" 49399 */
      9,   4,  24,  12,   5,   3,   0,  /* "brackett" 49406 */
      9,   4,  24,  12,   1,  13,  30,   0,  /* "brackins" 49414 */
      9,   4,  34,  12,  13,  21,   7,   0,  /* "bracknell" 49422 */
      9,   4,  24,  20,   0,  /* "brad" 49427 */
      9,   4,   1,  20,   2,  17,   1,  14,   0,  /* "brademas" 49436 */
      9,   4,   2,  20,   1,  13,   0,  /* "braden" 49443 */
      9,   4,  24,  20,   1,  13,   3,   1,  13,   0,  /* "bradenton" 49453 */
      9,   4,  24,  20,  10,   0,  /* "brader" 49459 */
      9,   4,  24,  20,  37,  26,   7,  20,   0,  /* "bradfield" 49468 */
      9,   4,  24,  20,  38,   1,  17,   0,  /* "bradham" 49476 */
      9,   4,  24,  20,   3,   0,  /* "bradt" 49482 */
      9,   4,  24,  20,   1,  12,   8,   4,  20,  26,   1,   0,  /* "bradycardia" 49494 */
      9,   4,   1,  20,   5,  12,   1,  13,   5,  13,   0,  /* "bradykinin" 49505 */
      9,   4,   2,  20,  26,  30,   0,  /* "bradys" 49512 */
      9,   4,   2,   0,  /* "brae" 49516 */
      9,   4,  24,  13,  20,  14,   3,   4,  27,  17,   0,  /* "braendstroem" 49527 */
      9,   4,   2,   4,   0,  /* "braer" 49532 */
      9,   4,  24,  11,   0,  /* "brag" 49537 */
      9,   4,  24,  11,   1,  20,  25,  33,  26,  25,   0,  /* "braggadocio" 49548 */
      9,   4,  24,  30,  26,   8,   3,  26,   0,  /* "braggiotti" 49557 */
      9,   4,  24,  38,   1,  17,   0,  /* "braham" 49564 */
      9,   4,   8,  17,   0,  /* "brahm" 49569 */
      9,   4,   8,  17,   5,  13,   0,  /* "brahmin" 49576 */
      9,   4,   8,  17,  30,   0,  /* "brahms" 49582 */
      9,   4,   2,  13,  42,  39,   7,  20,   0,  /* "brainchild" 49591 */
      9,   4,  39,  20,   1,  14,   0,  /* "brajdas" 49598 */
      9,   4,   8,  40,  27,  22,  31,  42,   0,  /* "brajovic" 49607 */
      9,   4,   2,  12,  17,  15,  13,   0,  /* "brakemen" 49615 */
      9,   4,  24,   7,  26,   0,  /* "bralley" 49621 */
      9,   4,  24,   7,  36,   4,  13,   0,  /* "bralorne" 49629 */
      9,   4,   8,   7,  26,   0,  /* "braly" 49635 */
      9,   4,  24,  17,   0,  /* "bram" 49640 */
      9,   4,   8,  17,   1,   0,  /* "bramah" 49646 */
      9,   4,  19,  17,   9,  23,   7,   1,   0,  /* "brambila" 49655 */
      9,   4,  24,  17,   9,   1,   7,   0,  /* "bramble" 49663 */
      9,   4,  24,  17,   9,   1,   7,  30,   0,  /* "brambles" 49672 */
      9,   4,  24,  17,   9,   7,   1,   3,   0,  /* "bramblett" 49681 */
      9,   4,  24,  17,  38,   1,   7,   0,  /* "bramhall" 49689 */
      9,   4,  24,  17,   7,  31,  40,   0,  /* "bramlage" 49697 */
      9,   4,  24,  17,   7,   5,   3,   0,  /* "bramlett" 49705 */
      9,   4,  24,  13,   0,  /* "bran" 49710 */
      9,   4,  24,  13,   1,  11,   0,  /* "branagh" 49717 */
      9,   4,   2,  13,   1,  13,   0,  /* "branan" 49724 */
      9,   4,  24,  32,  12,   1,   0,  /* "branca" 49731 */
      9,   4,   1,  13,  33,  25,   0,  /* "brancheau" 49738 */
      9,   4,  24,  32,  12,  27,   0,  /* "branco" 49745 */
      9,   4,  24,  13,  20,   9,  15,   4,  26,   0,  /* "brandeberry" 49755 */
      9,   4,  24,  13,  20,  39,  14,   0,  /* "brandeis" 49763 */
      9,   4,  24,  13,  20,  15,  13,  14,   3,  39,  13,   0,  /* "brandenstein" 49775 */
      9,   4,  24,  13,  20,   1,   7,   0,  /* "brandl" 49783 */
      9,   4,  24,  13,  20,   1,   7,   0,  /* "brandle" 49791 */
      9,   4,  24,  13,  20,  48,   0,  /* "brandow" 49798 */
      9,   4,  24,  13,  20,  47,  39,  13,   0,  /* "brandwein" 49807 */
      9,   4,  24,  13,  20,  26,  47,  39,  13,   0,  /* "brandywine" 49817 */
      9,   4,  24,  32,  12,  26,   0,  /* "brani" 49824 */
      9,   4,  24,  13,   5,  13,   0,  /* "branin" 49831 */
      9,   4,  24,  13,   1,  14,   7,   8,  22,   0,  /* "branislov" 49841 */
      9,   4,   1,  13,   5,   3,  14,  12,  26,   0,  /* "branitzky" 49851 */
      9,   4,  24,  13,   1,  12,   0,  /* "brannock" 49858 */
      9,   4,  24,  13,   1,  13,   0,  /* "brannon" 49865 */
      9,   4,  24,  13,  14,  12,   1,  17,   0,  /* "branscom" 49874 */
      9,   4,  24,  13,  30,  12,  35,  17,   0,  /* "branscome" 49883 */
      9,   4,  24,  13,  30,  37,  23,   7,  20,   0,  /* "bransfield" 49893 */
      9,   4,  24,  13,  14,   3,  24,  20,   0,  /* "branstad" 49902 */
      9,   4,  24,  14,   0,  /* "bras" 49907 */
      9,   4,   1,  14,  12,   2,  20,   0,  /* "brascade" 49915 */
      9,   4,  24,  14,  12,   1,  13,   0,  /* "brascan" 49923 */
      9,   4,   1,  14,  21,   7,   3,   1,  13,   0,  /* "braselton" 49933 */
      9,   4,  24,  14,  37,  26,   7,  20,   0,  /* "brasfield" 49942 */
      9,   4,  24,  33,  31,   4,   0,  /* "brashear" 49949 */
      9,   4,  24,  33,  26,  10,   0,  /* "brashier" 49956 */
      9,   4,   1,  30,   5,   7,  41,   1,   0,  /* "brasilia" 49965 */
      9,   4,  24,  14,  31,  32,   3,   1,  13,   0,  /* "brasington" 49975 */
      9,   4,  24,  14,  27,   0,  /* "brasow" 49981 */
      9,   4,   1,  14,  25,   0,  /* "brasseaux" 49987 */
      9,   4,  24,  14,  37,  23,   7,  20,   0,  /* "brassfield" 49996 */
      9,   4,  24,  14,  47,  15,   7,   0,  /* "braswell" 50004 */
      9,   4,  24,   3,   0,  /* "brat" 50009 */
      9,   4,   1,   3,   2,  13,   0,  /* "brattain" 50016 */
      9,   4,   8,   3,   1,  14,   7,   8,  22,   1,   0,  /* "brattaslava" 50027 */
      9,   4,  24,   3,   1,   7,   0,  /* "brattle" 50034 */
      9,   4,  48,   0,  /* "brau" 50038 */
      9,   4,  18,  42,   0,  /* "brauch" 50043 */
      9,   4,  18,  42,   7,  26,   0,  /* "brauchli" 50050 */
      9,   4,  18,   7,   3,   0,  /* "brault" 50056 */
      9,   4,  48,  13,  33,  47,  39,  11,   0,  /* "braunschweig" 50065 */
      9,   4,  18,  13,  14,   3,  23,  13,   0,  /* "braunstein" 50074 */
      9,   4,  18,  13,  47,  18,   7,  20,   0,  /* "braunwald" 50083 */
      9,   4,  18,  30,   0,  /* "brause" 50088 */
      9,   4,  25,   3,  31,  11,   1,  17,   0,  /* "brautigam" 50097 */
      9,   4,  18,   3,  31,  11,  34,  17,  30,   0,  /* "brautigams" 50107 */
      9,   4,   2,  22,  38,  19,   4,   3,   0,  /* "braveheart" 50116 */
      9,   4,   2,  22,  10,  17,   1,  13,   0,  /* "braverman" 50125 */
      9,   4,   1,  22,  41,  45,   4,   1,   0,  /* "bravura" 50134 */
      9,   4,  18,  10,   0,  /* "brawer" 50139 */
      9,   4,  24,  12,  14,   3,   1,  13,   0,  /* "braxton" 50148 */
      9,   4,   2,   0,  /* "bray" 50152 */
      9,   4,  24,  30,   0,  /* "braz" 50157 */
      9,   4,   1,  30,  23,   7,   0,  /* "brazeal" 50164 */
      9,   4,   1,  30,  25,   0,  /* "brazeau" 50170 */
      9,   4,  24,  30,   1,   7,   0,  /* "brazell" 50177 */
      9,   4,   1,  30,  21,   7,   3,   1,  13,   0,  /* "brazelton" 50187 */
      9,   4,   2,  30,   1,  13,   0,  /* "brazen" 50194 */
      9,   4,   2,  30,   1,  13,   7,  26,   0,  /* "brazenly" 50203 */
      9,   4,   1,  30,  23,   7,   0,  /* "braziel" 50210 */
      9,   4,   2,  43,  10,  30,   0,  /* "braziers" 50217 */
      9,   4,   1,  30,   5,   7,   0,  /* "brazil" 50224 */
      9,   4,   8,  30,  39,   7,   0,  /* "brazile" 50231 */
      9,   4,   1,  30,   5,   7,  41,   1,  13,   0,  /* "brazilian" 50241 */
      9,   4,  24,  30,   1,   7,   0,  /* "brazill" 50248 */
      9,   4,   8,  30,  27,  14,   0,  /* "brazos" 50255 */
      9,   4,  24,  30,   1,  22,   5,   7,   0,  /* "brazzaville" 50264 */
      9,   4,   5,  12,   1,   0,  /* "brca" 50270 */
      9,  44,  42,  12,  27,   0,  /* "brcko" 50276 */
      9,   4,  23,   0,  /* "brea" 50280 */
      9,   4,  21,  20,   9,   8,  12,  14,   0,  /* "breadbox" 50289 */
      9,   4,  21,  20,  37,   4,  29,   3,   0,  /* "breadfruit" 50298 */
      9,   4,   2,  12,   0,  /* "break" 50303 */
      9,   4,   2,  12,   1,   9,   1,   7,   0,  /* "breakable" 50312 */
      9,   4,   2,  12,  23,  22,   1,  13,   0,  /* "breakeven" 50321 */
      9,   4,  21,  12,  37,   1,  14,   3,   0,  /* "breakfast" 50330 */
      9,   4,  21,  12,  37,   1,  14,   3,  14,   0,  /* "breakfasts" 50340 */
      9,   4,   2,  12,  16,   4,  29,   0,  /* "breakthrough" 50348 */
      9,   4,   2,  12,  16,   4,  29,  30,   0,  /* "breakthroughs" 50357 */
      9,   4,   2,  12,   1,   6,  14,   0,  /* "breakups" 50365 */
      9,   4,  23,  17,   0,  /* "bream" 50370 */
      9,   4,  23,  13,   0,  /* "brean" 50375 */
      9,   4,  21,  14,   3,  37,  21,  20,   0,  /* "breastfed" 50384 */
      9,   4,  21,  14,   3,  37,  26,  20,   0,  /* "breastfeed" 50393 */
      9,   4,  23,  46,   0,  /* "breathe" 50398 */
      9,   4,  23,  46,  20,   0,  /* "breathed" 50404 */
      9,   4,  23,  46,  10,   0,  /* "breather" 50410 */
      9,   4,  23,  46,  30,   0,  /* "breathes" 50416 */
      9,   4,  23,  46,  31,  32,   0,  /* "breathing" 50423 */
      9,   4,  25,   0,  /* "breault" 50427 */
      9,   4,  23,  30,  23,   7,   0,  /* "breazeale" 50434 */
      9,   4,  21,   9,   1,  12,   0,  /* "brebach" 50441 */
      9,   4,  21,  12,   9,   1,   7,   0,  /* "brechbill" 50449 */
      9,   4,  21,  12,  26,  13,   0,  /* "brecheen" 50456 */
      9,   4,  21,  12,  39,  14,   1,  13,   0,  /* "brecheisen" 50465 */
      9,   4,  21,  20,   0,  /* "bred" 50470 */
      9,   4,   2,  20,   1,   0,  /* "breda" 50476 */
      9,   4,  21,  20,   1,  14,   1,  13,   0,  /* "bredeson" 50485 */
      9,   4,  23,   0,  /* "bree" 50489 */
      9,   4,  23,  30,   0,  /* "breese" 50494 */
      9,   4,  23,  11,   1,   3,   0,  /* "breguet" 50501 */
      9,   4,  39,  20,   1,  13,   9,  19,  12,   0,  /* "breidenbach" 50511 */
      9,   4,  39,  20,   1,  13,  14,   3,  39,  13,   0,  /* "breidenstein" 50522 */
      9,   4,  39,  10,   0,  /* "breier" 50527 */
      9,   4,   2,  13,  10,   0,  /* "breighner" 50533 */
      9,   4,  39,   3,   1,  13,   0,  /* "breighton" 50540 */
      9,   4,  39,  13,  10,   0,  /* "breiner" 50546 */
      9,   4,  39,  13,  31,  32,   0,  /* "breining" 50553 */
      9,   4,  39,  13,  31,  32,  10,   0,  /* "breininger" 50561 */
      9,   4,  39,  33,   0,  /* "breisch" 50566 */
      9,   4,  39,   3,   9,   8,  12,   0,  /* "breitbach" 50574 */
      9,   4,  39,   3,   9,   8,   4,  16,   0,  /* "breitbarth" 50583 */
      9,   4,  39,   3,   1,  13,   9,  19,  12,   0,  /* "breitenbach" 50593 */
      9,   4,  39,   3,   1,  13,  14,   3,  39,  13,   0,  /* "breitenstein" 50604 */
      9,   4,  39,  16,  52,   6,   3,   0,  /* "breithaupt" 50612 */
      9,   4,  39,   3,  12,   4,  49,   3,  14,   0,  /* "breitkreutz" 50622 */
      9,   4,  39,   3,   1,   7,  31,  32,   0,  /* "breitling" 50631 */
      9,   4,  39,   3,  17,   1,  13,   0,  /* "breitman" 50639 */
      9,   4,  39,  42,  47,  10,   3,   0,  /* "breitschwerdt" 50647 */
      9,   4,  39,   3,  47,  39,  14,  10,   0,  /* "breitweiser" 50656 */
      9,   4,  39,   3,  14,  17,   1,  13,   0,  /* "breitzman" 50665 */
      9,   4,  21,  17,   0,  /* "brem" 50670 */
      9,   4,  21,  13,   0,  /* "bren" 50675 */
      9,   4,  21,  13,  20,   1,   7,   0,  /* "brendle" 50683 */
      9,   4,  21,  13,  20,   1,   7,  31,  32,  10,   0,  /* "brendlinger" 50694 */
      9,   4,  21,  13,  20,  10,   0,  /* "brendor" 50701 */
      9,   4,  23,  13,  17,   1,  13,   0,  /* "breneman" 50709 */
      9,   4,  23,  13,  30,   0,  /* "brenes" 50715 */
      9,   4,   5,  32,   1,   7,   0,  /* "brengle" 50722 */
      9,   4,  21,  13,  39,  30,  10,   0,  /* "brenizer" 50730 */
      9,   4,  21,  13,   1,  12,  26,   0,  /* "brenneke" 50738 */
      9,   4,  21,  13,  14,  31,  32,  10,   0,  /* "brensinger" 50747 */
      9,   4,  21,  13,   3,   1,   7,  31,  32,  10,   0,  /* "brentlinger" 50758 */
      9,   4,  21,  13,   3,  14,   0,  /* "brents" 50765 */
      9,   4,  23,   1,  13,   0,  /* "breon" 50771 */
      9,   4,   1,  14,  23,   0,  /* "bresee" 50777 */
      9,   4,   1,  14,  21,   3,   0,  /* "bresette" 50784 */
      9,   4,  21,  14,   7,  19,   0,  /* "breslaw" 50791 */
      9,   4,  21,  14,   7,  10,   0,  /* "bresler" 50798 */
      9,   4,  21,  14,  27,   0,  /* "bresseau" 50804 */
      9,   4,  21,  14,  17,   1,  13,   0,  /* "bressman" 50812 */
      9,   4,  21,  14,   1,  13,   0,  /* "bresson" 50819 */
      9,   4,  21,   3,   0,  /* "bret" 50824 */
      9,   4,  21,  16,   0,  /* "breth" 50829 */
      9,   4,  23,  16,   1,  13,   0,  /* "brethen" 50836 */
      9,   4,  21,  46,   4,   1,  13,   0,  /* "brethren" 50844 */
      9,   4,  21,  42,  13,  39,  20,  10,   0,  /* "bretschneider" 50853 */
      9,   4,  21,   3,   1,  13,   0,  /* "bretton" 50860 */
      9,   4,  21,   3,  14,   0,  /* "bretts" 50866 */
      9,   4,  21,  42,  13,  39,  20,  10,   0,  /* "brettschneider" 50875 */
      9,   4,  29,  10,   0,  /* "breuer" 50880 */
      9,   4,  29,  13,  31,  11,   0,  /* "breunig" 50887 */
      9,   4,  29,  13,   1,  32,  10,   0,  /* "breuninger" 50895 */
      9,   4,  21,  22,  10,  20,   0,  /* "brevard" 50902 */
      9,   4,   1,  22,  21,   3,  14,   0,  /* "brevets" 50910 */
      9,   4,  29,   0,  /* "brew" 50914 */
      9,   4,  29,   9,   2,  12,  10,   0,  /* "brewbaker" 50922 */
      9,   4,  29,  20,   0,  /* "brewed" 50927 */
      9,   4,  29,  10,   0,  /* "brewer" 50932 */
      9,   4,  29,  10,  26,  30,   0,  /* "breweries" 50939 */
      9,   4,  29,  10,  30,   0,  /* "brewers" 50945 */
      9,   4,  29,  10,  26,   0,  /* "brewery" 50951 */
      9,   4,  29,  31,  32,   0,  /* "brewing" 50957 */
      9,   4,  29,  31,  32,   3,   1,  13,   0,  /* "brewington" 50966 */
      9,   4,  29,   4,  26,   0,  /* "brewry" 50972 */
      9,   4,  29,  30,   0,  /* "brews" 50977 */
      9,   4,  29,  14,   3,  10,   0,  /* "brewster" 50984 */
      9,   4,  29,   3,   1,  13,   0,  /* "brewton" 50991 */
      9,   4,   2,   0,  /* "brey" 50995 */
      9,   4,   2,  37,  25,  11,   1,   7,   0,  /* "breyfogle" 51004 */
      9,   4,  21,  30,   1,   0,  /* "breza" 51010 */
      9,   4,  15,  30,  23,  13,   1,   0,  /* "brezina" 51018 */
      9,   4,   1,  30,   5,  13,  14,  12,  26,   0,  /* "brezinski" 51028 */
      9,   4,  23,   1,   0,  /* "bria" 51033 */
      9,   4,  39,   1,  13,   0,  /* "brian" 51039 */
      9,   4,  39,   1,  13,  14,   1,  13,   0,  /* "briancon" 51048 */
      9,   4,  39,   1,  13,  20,   0,  /* "briand" 51055 */
      9,   4,  39,   1,  13,   3,   0,  /* "briant" 51062 */
      9,   4,  39,  10,   0,  /* "briar" 51067 */
      9,   4,  39,   4,  12,   7,   5,  37,   0,  /* "briarcliff" 51076 */
      9,   4,  39,   9,   0,  /* "bribe" 51081 */
      9,   4,  39,   9,  20,   0,  /* "bribed" 51087 */
      9,   4,  39,   9,  10,  26,   0,  /* "bribery" 51094 */
      9,   4,  39,   9,  30,   0,  /* "bribes" 51100 */
      9,   4,  39,   9,  31,  32,   0,  /* "bribing" 51107 */
      9,   4,   5,  12,   0,  /* "bric" 51112 */
      9,   4,  31,  42,  21,   3,  26,   0,  /* "briccetti" 51120 */
      9,   4,   5,  12,  27,   0,  /* "bricco" 51126 */
      9,   4,  39,  14,   0,  /* "brice" 51131 */
      9,   4,  26,  42,  21,  13,  27,   0,  /* "briceno" 51139 */
      9,   4,   5,  12,   0,  /* "brick" 51144 */
      9,   4,   5,  12,   1,   7,   0,  /* "brickle" 51151 */
      9,   4,   5,  12,   1,  17,   0,  /* "bricom" 51158 */
      9,   4,  39,  20,   1,   7,   0,  /* "bridal" 51165 */
      9,   4,  39,  20,   0,  /* "bride" 51170 */
      9,   4,  39,  20,  11,   4,  29,  17,   0,  /* "bridegroom" 51179 */
      9,   4,  39,  20,   1,  13,   0,  /* "briden" 51186 */
      9,   4,   5,  20,   1,  13,   9,  52,   0,  /* "bridenbaugh" 51195 */
      9,   4,   5,  20,   1,  13,  14,   3,  26,  13,   0,  /* "bridenstine" 51206 */
      9,   4,  39,  20,  30,   0,  /* "brides" 51212 */
      9,   4,  39,  20,  30,   9,   1,   4,  11,   0,  /* "bridesburg" 51222 */
      9,   4,  39,  20,  30,  17,   2,  20,   0,  /* "bridesmaid" 51231 */
      9,   4,  39,  20,  30,  17,   2,  20,  30,   0,  /* "bridesmaids" 51241 */
      9,   4,   5,  40,  37,  36,   4,  20,   0,  /* "bridgeford" 51250 */
      9,   4,   5,  40,   5,   3,   0,  /* "bridgette" 51257 */
      9,   4,   5,  40,  38,   1,  17,   0,  /* "bridgham" 51265 */
      9,   4,  39,  20,   1,   7,   0,  /* "bridle" 51272 */
      9,   4,  39,  20,   1,   7,  20,   0,  /* "bridled" 51280 */
      9,   4,  23,   0,  /* "brie" 51284 */
      9,   4,  23,  37,  12,   2,  14,   0,  /* "briefcase" 51292 */
      9,   4,  23,  37,  12,   2,  14,   1,  30,   0,  /* "briefcases" 51302 */
      9,   4,  23,  37,   1,  14,   3,   0,  /* "briefest" 51310 */
      9,   4,  23,  37,   7,  26,   0,  /* "briefly" 51317 */
      9,   4,  39,   1,  13,   0,  /* "brien" 51323 */
      9,   4,  23,  13,  30,   1,   0,  /* "brienza" 51330 */
      9,   4,  39,  10,   0,  /* "brier" 51335 */
      9,   4,  39,  10,   7,  26,   0,  /* "brierley" 51342 */
      9,   4,  39,  10,   7,  26,   0,  /* "brierly" 51349 */
      9,   4,  23,   3,  30,  12,  26,   0,  /* "brietzke" 51357 */
      9,   4,   5,  11,   0,  /* "brig" 51362 */
      9,   4,   5,  11,   1,  20,   5,   4,   0,  /* "brigadeer" 51371 */
      9,   4,  31,  11,   2,  20,  30,   0,  /* "brigades" 51379 */
      9,   4,   5,  11,   1,  20,   5,   4,   0,  /* "brigadier" 51388 */
      9,   4,   5,  11,   1,  13,  14,   0,  /* "brigance" 51396 */
      9,   4,  26,  11,   8,  13,   3,  26,   0,  /* "brigante" 51405 */
      9,   4,   5,  11,  14,   3,  27,  13,   0,  /* "briggstone" 51414 */
      9,   4,   5,  11,   1,  17,   0,  /* "brigham" 51421 */
      9,   4,   5,  11,   1,  17,  30,   0,  /* "brighams" 51429 */
      9,   4,  39,   3,   0,  /* "bright" 51434 */
      9,   4,  39,   3,   9,   5,   7,   0,  /* "brightbill" 51442 */
      9,   4,  39,   3,   1,  13,   0,  /* "brighten" 51449 */
      9,   4,  39,   3,   1,  13,  20,   0,  /* "brightened" 51457 */
      9,   4,  39,   3,   1,  13,  31,  32,   0,  /* "brightening" 51466 */
      9,   4,  39,   3,   1,  13,  30,   0,  /* "brightens" 51474 */
      9,   4,  39,   3,  10,   0,  /* "brighter" 51480 */
      9,   4,  39,   3,   1,  14,   3,   0,  /* "brightest" 51488 */
      9,   4,  39,   3,   7,  26,   0,  /* "brightly" 51495 */
      9,   4,  39,   3,  17,   1,  13,   0,  /* "brightman" 51503 */
      9,   4,  39,   3,  13,   1,  14,   0,  /* "brightness" 51511 */
      9,   4,  39,   3,   1,  13,   0,  /* "brighton" 51518 */
      9,   4,  39,   3,  47,  21,   7,   0,  /* "brightwell" 51526 */
      9,   4,   5,  11,  13,   1,  12,   0,  /* "brignac" 51534 */
      9,   4,  39,  11,  13,  10,   0,  /* "brigner" 51541 */
      9,   4,  31,  11,  25,  20,   1,   0,  /* "brigode" 51549 */
      9,   4,  31,  11,  35,  11,   7,  26,  27,   0,  /* "briguglio" 51559 */
      9,   4,  39,   7,  30,   0,  /* "briles" 51565 */
      9,   4,   5,   7,   0,  /* "brill" 51570 */
      9,   4,   5,   7,  38,   8,   4,   3,   0,  /* "brillhart" 51579 */
      9,   4,   5,   7,  41,   1,  13,  14,   0,  /* "brilliance" 51588 */
      9,   4,   5,   7,  14,   3,  23,  13,   0,  /* "brillstein" 51597 */
      9,   4,   5,  17,   0,  /* "brim" 51602 */
      9,   4,  39,  17,  10,   0,  /* "brimer" 51608 */
      9,   4,   5,  17,  14,   3,  27,  13,   0,  /* "brimstone" 51617 */
      9,   4,   5,  13,   0,  /* "brin" 51622 */
      9,   4,   5,  13,  20,  21,   7,   0,  /* "brindel" 51630 */
      9,   4,   5,  13,  20,   1,   7,   0,  /* "brindle" 51638 */
      9,   4,  39,  13,   0,  /* "brine" 51643 */
      9,   4,  39,  13,  10,   0,  /* "briner" 51649 */
      9,   4,  39,  13,  30,   0,  /* "brines" 51655 */
      9,   4,   5,  32,  38,  10,  14,   3,   0,  /* "bringhurst" 51664 */
      9,   4,   5,  32,  11,   1,   7,   0,  /* "bringle" 51672 */
      9,   4,  39,  13,  31,  32,   0,  /* "brining" 51679 */
      9,   4,   5,  32,  12,  14,  17,   1,  13,  33,   5,   6,   0,  /* "brinksmanship" 51692 */
      9,   4,   5,  13,  14,  37,  26,   7,  20,   0,  /* "brinsfield" 51702 */
      9,   4,   5,  13,  14,   1,  13,   0,  /* "brinson" 51710 */
      9,   4,  39,  27,   0,  /* "brio" 51715 */
      9,   4,  23,  25,  33,   0,  /* "brioche" 51721 */
      9,   4,  39,   1,  20,  26,   0,  /* "briody" 51728 */
      9,   4,  39,   1,  13,   0,  /* "brion" 51734 */
      9,   4,  26,  25,  13,  15,  14,   0,  /* "briones" 51742 */
      9,   4,   5,  12,  17,  36,  13,   3,   0,  /* "briquemont" 51751 */
      9,   4,   5,  30,   9,   2,  13,   0,  /* "brisbane" 51759 */
      9,   4,   5,  30,   9,   5,  13,   0,  /* "brisbin" 51767 */
      9,   4,   5,  30,   9,  47,   8,   0,  /* "brisbois" 51775 */
      9,   4,   5,  30,   9,   1,  13,   0,  /* "brisbon" 51783 */
      9,   4,   5,  14,  12,  27,   0,  /* "briscoe" 51790 */
      9,   4,   5,  14,   1,  13,  20,  39,  13,   0,  /* "brisendine" 51800 */
      9,   4,  26,  14,  21,  13,  27,   0,  /* "briseno" 51808 */
      9,   4,   5,  14,   1,  13,   0,  /* "brison" 51815 */
      9,   4,   5,  14,   1,   7,   0,  /* "bristle" 51822 */
      9,   4,   5,  14,   1,   7,  20,   0,  /* "bristled" 51830 */
      9,   4,   5,  14,   1,   7,  30,   0,  /* "bristles" 51838 */
      9,   4,   5,  14,   1,   7,  31,  32,   0,  /* "bristling" 51847 */
      9,   4,   5,  14,   3,  27,   0,  /* "bristow" 51854 */
      9,   4,   5,   3,   0,  /* "brit" 51859 */
      9,   4,   5,   3,   1,  13,   0,  /* "britain" 51866 */
      9,   4,   5,   3,   1,  13,  30,   0,  /* "britains" 51874 */
      9,   4,  39,   3,   0,  /* "brite" 51879 */
      9,   4,   5,   3,  31,  33,   0,  /* "british" 51886 */
      9,   4,   5,   3,  49,   7,   0,  /* "britoil" 51893 */
      9,   4,   5,   3,   1,  13,   0,  /* "briton" 51900 */
      9,   4,   5,   3,   1,  13,  30,   0,  /* "britons" 51908 */
      9,   4,   5,   3,   1,  13,   0,  /* "brittain" 51915 */
      9,   4,   5,   3,  26,   1,  13,   0,  /* "brittian" 51923 */
      9,   4,   5,   3,  31,  32,  38,  34,  17,   0,  /* "brittingham" 51933 */
      9,   4,   5,   3,   1,   7,   0,  /* "brittle" 51940 */
      9,   4,   5,  12,  14,   0,  /* "brix" 51946 */
      9,   4,   5,  12,  14,  26,   0,  /* "brixey" 51953 */
      9,   4,  39,  12,  14,  26,   1,  14,   0,  /* "brixius" 51962 */
      9,   4,  26,  30,  15,  13,  20,  23,  13,  26,   0,  /* "brizendine" 51973 */
      9,   4,   5,  30,  25,   7,   1,   0,  /* "brizola" 51981 */
      9,   4,   5,  30,  26,   0,  /* "brizzi" 51987 */
      9,   4,  26,   3,  14,  27,   7,   8,   4,   1,   0,  /* "brizzolara" 51998 */
      9,   4,  25,   0,  /* "bro" 52002 */
      9,   4,  18,  20,   9,  21,  13,   3,   0,  /* "broadbent" 52011 */
      9,   4,  18,  20,   1,  14,   3,   0,  /* "broadest" 52019 */
      9,   4,  18,  20,  26,   0,  /* "broadie" 52025 */
      9,   4,  18,  20,   7,  26,   0,  /* "broadley" 52032 */
      9,   4,  18,  20,   7,  26,   0,  /* "broadly" 52039 */
      9,   4,  18,  20,  13,  34,  12,  14,   0,  /* "broadnax" 52048 */
      9,   4,  18,  20,  37,  51,   3,   0,  /* "broadpfoot" 52056 */
      9,   4,  18,  20,  14,  39,  20,   0,  /* "broadside" 52064 */
      9,   4,  18,  20,  14,  39,  20,   1,  20,   0,  /* "broadsided" 52074 */
      9,   4,  25,  20,   1,  14,   0,  /* "broadus" 52081 */
      9,   4,  18,  20,  22,  41,  29,   0,  /* "broadview" 52089 */
      9,   4,  18,   9,  20,  31,  11,  13,  24,  11,  26,   1,  13,   0,  /* "brobdingnagian" 52103 */
      9,   4,  18,   9,  20,  31,  11,  13,  24,  11,  26,   1,  13,  30,   0,  /* "brobdingnagians" 52118 */
      9,   4,  25,   9,  21,  12,   0,  /* "brobeck" 52125 */
      9,   4,   8,  12,   0,  /* "broc" 52130 */
      9,   4,  27,  12,   2,  20,   0,  /* "brocade" 52137 */
      9,   4,  27,  12,   2,  20,  30,   0,  /* "brocades" 52145 */
      9,   4,   8,  12,   1,   7,  26,   0,  /* "broccoli" 52153 */
      9,   4,  25,  12,  29,   0,  /* "brochu" 52159 */
      9,   4,  27,  33,  45,   4,   0,  /* "brochure" 52166 */
      9,   4,  27,  33,  45,   4,  30,   0,  /* "brochures" 52174 */
      9,   4,  36,  33,  23,  14,   0,  /* "brocious" 52181 */
      9,   4,   8,  12,   9,   1,  32,  12,   0,  /* "brockbank" 52190 */
      9,   4,   8,  12,  38,  18,  37,   0,  /* "brockhoff" 52198 */
      9,   4,   8,  12,   1,   7,  38,  10,  14,   3,   0,  /* "brocklehurst" 52209 */
      9,   4,   8,  20,   0,  /* "brod" 52214 */
      9,   4,  25,  20,  10,   0,  /* "broder" 52220 */
      9,   4,  25,   3,  10,   9,   1,  13,  20,   0,  /* "broderbund" 52230 */
      9,   4,  25,   3,  10,  14,   1,  13,   0,  /* "brodersohn" 52239 */
      9,   4,   8,  20,  10,   0,  /* "brodeur" 52245 */
      9,   4,  25,   3,  26,   0,  /* "brodie" 52251 */
      9,   4,   8,  20,  13,  34,  12,  14,   0,  /* "brodnax" 52260 */
      9,   4,   1,  20,  18,  37,  14,  12,  26,   0,  /* "brodowski" 52270 */
      9,   4,  25,  20,  26,   0,  /* "brody" 52276 */
      9,   4,   1,  40,   5,  13,  14,  12,  26,   0,  /* "brodzinski" 52286 */
      9,   4,  25,   0,  /* "broe" 52290 */
      9,   4,  25,  12,  10,   0,  /* "broecker" 52296 */
      9,   4,  25,  10,   0,  /* "broer" 52301 */
      9,   4,  25,  10,  17,   1,  13,   0,  /* "broerman" 52309 */
      9,   4,  25,  10,  30,   0,  /* "broers" 52315 */
      9,   4,  25,  11,  13,   1,   0,  /* "brogna" 52322 */
      9,   4,  49,  42,   0,  /* "broich" 52327 */
      9,   4,   8,  12,   0,  /* "brok" 52332 */
      9,   4,  25,  12,  36,   0,  /* "brokaw" 52338 */
      9,   4,   8,   7,  26,   0,  /* "brolly" 52344 */
      9,   4,   8,  17,   0,  /* "brom" 52349 */
      9,   4,  25,  17,  39,  20,   0,  /* "bromide" 52356 */
      9,   4,  25,  17,  39,  20,  30,   0,  /* "bromides" 52364 */
      9,   4,   8,  17,  37,  15,   4,   5,   7,   0,  /* "brompheril" 52374 */
      9,   4,   8,  13,  36,   0,  /* "bronaugh" 52380 */
      9,   4,  19,  32,  12,  39,   3,   1,  14,   0,  /* "bronchitis" 52390 */
      9,   4,   8,  32,  12,  27,   0,  /* "bronco" 52397 */
      9,   4,   8,  32,  12,  27,  30,   0,  /* "broncos" 52405 */
      9,   4,   1,  32,  12,  23,  17,   1,   0,  /* "bronkema" 52414 */
      9,   4,   8,  13,  14,   3,  23,  13,   0,  /* "bronstein" 52423 */
      9,   4,  18,  13,   3,   1,  14,  18,   4,   1,  14,   0,  /* "brontosaurus" 52435 */
      9,   4,  18,  13,  47,  15,  13,   0,  /* "bronwen" 52443 */
      9,   4,   8,  32,  12,  14,   0,  /* "bronx" 52450 */
      9,   4,  25,  42,   0,  /* "brooch" 52455 */
      9,   4,  29,  20,   0,  /* "brood" 52460 */
      9,   4,  29,  20,   1,  20,   0,  /* "brooded" 52467 */
      9,   4,  29,  20,  31,  32,   0,  /* "brooding" 52474 */
      9,   4,  29,  20,  26,   0,  /* "broody" 52480 */
      9,   4,  45,  12,   0,  /* "brooke" 52485 */
      9,   4,  29,  12,  38,  19,   4,   3,   0,  /* "brookhart" 52494 */
      9,   4,  45,  12,  38,   2,  22,   1,  13,   0,  /* "brookhaven" 52504 */
      9,   4,  45,  12,  38,  44,  14,   3,   0,  /* "brookhurst" 52513 */
      9,   4,  29,  12,   5,  13,  30,   0,  /* "brookins" 52521 */
      9,   4,  45,  12,   7,  39,  13,   0,  /* "brookline" 52529 */
      9,   4,  45,  12,   7,   1,  13,   0,  /* "brooklyn" 52537 */
      9,   4,  45,  12,  14,   0,  /* "brooks" 52543 */
      9,   4,  29,  12,  33,  26,  10,   0,  /* "brookshier" 52551 */
      9,   4,  29,  12,  33,  39,   4,   0,  /* "brookshire" 52559 */
      9,   4,  45,  12,  14,  39,  20,   0,  /* "brookside" 52567 */
      9,   4,  29,  17,   0,  /* "broom" 52572 */
      9,   4,  29,  17,   1,   7,   0,  /* "broomall" 52579 */
      9,   4,  29,  17,   0,  /* "broome" 52584 */
      9,   4,  29,  17,  37,  23,   7,  20,   0,  /* "broomfield" 52593 */
      9,   4,  29,  17,  30,   0,  /* "brooms" 52599 */
      9,   4,  29,  17,  14,   3,   5,  12,   0,  /* "broomstick" 52608 */
      9,   4,  29,  17,  14,   3,   5,  12,  14,   0,  /* "broomsticks" 52618 */
      9,   4,  25,  37,  26,   0,  /* "brophy" 52624 */
      9,   4,  18,  33,   0,  /* "brosch" 52629 */
      9,   4,  25,  30,  26,   1,  14,   0,  /* "brosious" 52637 */
      9,   4,   8,  14,  12,  26,   0,  /* "brosky" 52644 */
      9,   4,   1,  14,   8,   4,  20,   0,  /* "brossard" 52652 */
      9,   4,   1,  14,  25,   0,  /* "brosseau" 52658 */
      9,   4,   1,  14,  21,   3,   0,  /* "brossette" 52665 */
      9,   4,  18,  14,  17,   1,  13,   0,  /* "brossman" 52673 */
      9,   4,   8,  16,   1,   7,   0,  /* "brothel" 52680 */
      9,   4,   8,  16,   1,   7,  30,   0,  /* "brothels" 52688 */
      9,   4,  35,  46,  10,   3,   1,  13,   0,  /* "brotherton" 52697 */
      9,   4,  29,  42,  15,  12,   0,  /* "broucek" 52704 */
      9,   4,  29,  11,   1,  17,   0,  /* "brougham" 52711 */
      9,   4,  18,   3,   0,  /* "brought" 52716 */
      9,   4,  18,   3,   1,  13,   0,  /* "broughton" 52723 */
      9,   4,  29,  38,  19,  38,  19,   0,  /* "brouhaha" 52731 */
      9,   4,   8,  29,  10,  20,   0,  /* "brouhard" 52738 */
      9,   4,  47,  26,   7,   8,   4,  20,   0,  /* "brouillard" 52747 */
      9,   4,  47,  26,   7,  21,   3,   0,  /* "brouillet" 52755 */
      9,   4,  29,  13,   0,  /* "broun" 52760 */
      9,   4,  29,  14,   8,   4,  20,   0,  /* "broussard" 52768 */
      9,   4,  29,  14,  25,   0,  /* "brousseau" 52774 */
      9,   4,  29,  14,  15,   3,   0,  /* "brousset" 52781 */
      9,   4,  48,  47,  10,   0,  /* "brouwer" 52787 */
      9,   4,  48,   0,  /* "brow" 52791 */
      9,   4,  48,  10,  20,   0,  /* "broward" 52797 */
      9,   4,  48,   9,  23,   3,   0,  /* "browbeat" 52804 */
      9,   4,  25,   0,  /* "browe" 52808 */
      9,   4,  52,  13,  21,   7,   0,  /* "brownell" 52815 */
      9,   4,  48,  13,  15,  14,   3,   0,  /* "brownest" 52823 */
      9,   4,  48,  13,   7,  25,   0,  /* "brownlow" 52830 */
      9,   4,  48,  13,   4,  31,  11,   0,  /* "brownrigg" 52838 */
      9,   4,  48,  30,   0,  /* "browse" 52843 */
      9,   4,  48,  30,  20,   0,  /* "browsed" 52849 */
      9,   4,  48,  30,  31,  32,   0,  /* "browsing" 52856 */
      9,   4,   8,  12,  14,   0,  /* "brox" 52862 */
      9,   4,   8,  12,  14,   1,  13,   0,  /* "broxson" 52870 */
      9,   4,   8,  12,  14,   3,  10,  17,   1,  13,   0,  /* "broxterman" 52881 */
      9,   4,   8,  12,  14,   3,   1,  13,   0,  /* "broxton" 52890 */
      9,   4,  49,   0,  /* "broy" 52894 */
      9,   4,  49,  10,  20,   0,  /* "broyard" 52900 */
      9,   4,   8,  30,   0,  /* "broz" 52905 */
      9,   4,   8,  30,   1,  22,  31,  42,   0,  /* "brozovich" 52914 */
      9,   4,   1,  30,  18,  37,  14,  12,  26,   0,  /* "brozowski" 52924 */
      9,   4,  35,   9,   1,  12,  10,   0,  /* "brubaker" 52932 */
      9,   4,  29,   9,  21,  12,   0,  /* "brubeck" 52939 */
      9,   4,  29,  12,   8,   3,  27,   0,  /* "brucato" 52947 */
      9,   4,  29,  14,   0,  /* "bruce" 52952 */
      9,   4,  35,  42,   0,  /* "bruch" 52957 */
      9,   4,  29,  12,  38,  48,  30,   1,  13,   0,  /* "bruchhausen" 52967 */
      9,   4,  35,  12,  26,   0,  /* "brucie" 52973 */
      9,   4,  29,  14,  39,   3,   0,  /* "brucite" 52980 */
      9,   4,  35,  12,  38,  39,  17,  10,   0,  /* "bruckheimer" 52989 */
      9,   4,  29,  20,  10,   0,  /* "bruder" 52995 */
      9,   4,  29,   0,  /* "brue" 52999 */
      9,   4,  29,  42,  10,   0,  /* "bruecher" 53005 */
      9,   4,  29,  12,   0,  /* "brueck" 53010 */
      9,   4,  45,  12,  13,  10,   0,  /* "brueckner" 53017 */
      9,   4,  29,  11,   1,   0,  /* "bruegge" 53023 */
      9,   4,  29,  11,  17,   1,  13,   0,  /* "brueggeman" 53031 */
      9,   4,  29,  11,  17,   1,  13,   0,  /* "brueggemann" 53039 */
      9,   4,  29,  11,   1,  13,   0,  /* "brueggen" 53046 */
      9,   4,  29,  11,  10,   0,  /* "bruegger" 53052 */
      9,   4,  29,   7,   0,  /* "bruehl" 53057 */
      9,   4,  29,  21,   7,   1,   0,  /* "bruella" 53064 */
      9,   4,  29,  17,  10,   0,  /* "bruemmer" 53070 */
      9,   4,  29,  13,   0,  /* "bruen" 53075 */
      9,   4,  29,  13,  31,  32,   0,  /* "bruening" 53082 */
      9,   4,  29,  10,   0,  /* "bruer" 53087 */
      9,   4,  29,  37,  10,  20,   0,  /* "bruford" 53094 */
      9,   4,  29,  40,   1,  30,   0,  /* "bruges" 53101 */
      9,   4,  29,  38,   1,   0,  /* "bruha" 53107 */
      9,   4,  29,   1,  13,   0,  /* "bruin" 53113 */
      9,   4,  29,  31,  32,   3,   1,  13,   0,  /* "bruington" 53122 */
      9,   4,  29,   1,  13,  30,   0,  /* "bruins" 53129 */
      9,   4,  29,   5,  13,  14,  17,   1,   0,  /* "bruinsma" 53138 */
      9,   4,  29,  30,   0,  /* "bruise" 53143 */
      9,   4,  29,  30,  20,   0,  /* "bruised" 53149 */
      9,   4,  29,  30,   1,  30,   0,  /* "bruises" 53156 */
      9,   4,  29,  30,  31,  32,   0,  /* "bruising" 53163 */
      9,   4,  29,   7,   0,  /* "brule" 53168 */
      9,   4,  29,   7,  26,   0,  /* "bruley" 53174 */
      9,   4,  35,  17,   0,  /* "brum" 53179 */
      9,   4,  29,  17,  10,   0,  /* "brumer" 53185 */
      9,   4,  35,  17,   5,   3,   0,  /* "brumett" 53192 */
      9,   4,  29,  17,   5,   3,   0,  /* "brumitt" 53199 */
      9,   4,  35,  17,   5,   3,   0,  /* "brummet" 53206 */
      9,   4,  35,  13,   0,  /* "brun" 53211 */
      9,   4,  29,  13,   1,   0,  /* "bruna" 53217 */
      9,   4,  35,  13,  12,  18,   4,   0,  /* "bruncor" 53225 */
      9,   4,  35,  13,  20,  31,  11,   0,  /* "brundige" 53233 */
      9,   4,  29,  13,   0,  /* "brune" 53238 */
      9,   4,   1,  13,  25,   0,  /* "bruneau" 53244 */
      9,   4,  29,  13,  39,   0,  /* "brunei" 53250 */
      9,   4,  35,  13,   1,   7,   0,  /* "brunell" 53257 */
      9,   4,  29,  13,  21,   7,   1,   0,  /* "brunella" 53265 */
      9,   4,   1,  13,  21,   7,   0,  /* "brunelle" 53272 */
      9,   4,  29,  13,  21,   7,  26,   0,  /* "brunelli" 53280 */
      9,   4,  29,  13,  10,   0,  /* "bruner" 53286 */
      9,   4,  35,  13,   1,   3,   0,  /* "brunett" 53293 */
      9,   4,  29,  13,  26,   0,  /* "bruney" 53299 */
      9,   4,  35,  32,  11,  19,   4,   3,   0,  /* "brungardt" 53308 */
      9,   4,  35,  32,  10,   0,  /* "brunger" 53314 */
      9,   4,  29,  13,  38,  23,   7,  20,   1,   0,  /* "brunhilda" 53324 */
      9,   4,  29,  13,  26,   0,  /* "bruni" 53330 */
      9,   4,  29,  13,  31,  12,   0,  /* "brunick" 53337 */
      9,   4,  29,  13,  31,  32,   0,  /* "bruning" 53344 */
      9,   4,   1,  13,  43,  23,  30,   0,  /* "brunjes" 53352 */
      9,   4,  35,  32,  12,  27,   0,  /* "brunkow" 53359 */
      9,   4,  29,  13,  27,   0,  /* "bruno" 53365 */
      9,   4,  35,  13,  14,  47,  31,  11,   0,  /* "brunswig" 53374 */
      9,   4,  35,  13,   3,  40,  21,  13,   0,  /* "bruntjen" 53383 */
      9,   4,  35,  14,   0,  /* "brus" 53388 */
      9,   4,  29,  14,  12,  26,   0,  /* "bruschi" 53395 */
      9,   4,  29,  14,  12,  27,   0,  /* "brusco" 53402 */
      9,   4,  29,  30,   0,  /* "bruse" 53407 */
      9,   4,  51,  14,  21,   3,   0,  /* "brusett" 53414 */
      9,   4,  29,  14,  21,   3,   0,  /* "brusette" 53421 */
      9,   4,  35,  33,  37,  39,   4,   0,  /* "brushfire" 53429 */
      9,   4,  35,  33,  37,  39,   4,  30,   0,  /* "brushfires" 53438 */
      9,   4,  29,  14,  27,   0,  /* "bruso" 53444 */
      9,   4,   1,  14,  25,   0,  /* "brusseau" 53450 */
      9,   4,  29,  14,   3,  27,   7,  25,  13,  26,   0,  /* "brustoloni" 53461 */
      9,   4,  29,   3,   0,  /* "brut" 53466 */
      9,   4,  29,   3,   1,   7,   0,  /* "brutal" 53473 */
      9,   4,  29,   3,  24,   7,   1,   3,  26,  30,   0,  /* "brutalities" 53484 */
      9,   4,  29,   3,  24,   7,   1,   3,  26,   0,  /* "brutality" 53494 */
      9,   4,  29,   3,   1,   7,   1,  30,   2,  33,   1,  13,   0,  /* "brutalization" 53507 */
      9,   4,  29,   3,   1,   7,  39,  30,   0,  /* "brutalize" 53516 */
      9,   4,  29,   3,   1,   7,  39,  30,  20,   0,  /* "brutalized" 53526 */
      9,   4,  29,   3,   1,   7,  39,  30,   1,  30,   0,  /* "brutalizes" 53537 */
      9,   4,  29,   3,   1,   7,  39,  30,  31,  32,   0,  /* "brutalizing" 53548 */
      9,   4,  29,   3,   1,   7,  26,   0,  /* "brutally" 53556 */
      9,   4,  29,   3,   0,  /* "brute" 53561 */
      9,   4,  29,   3,   5,  33,   0,  /* "brutish" 53568 */
      9,   4,  29,   3,   1,  13,   0,  /* "bruton" 53575 */
      9,   4,  35,  42,  26,   0,  /* "brutsche" 53581 */
      9,   4,  29,   3,   1,  14,   0,  /* "brutus" 53588 */
      9,   4,  29,  13,   0,  /* "bruun" 53593 */
      9,   4,   1,  12,  14,  21,   7,   1,  14,   0,  /* "bruxelles" 53603 */
      9,   4,  29,   5,  13,  30,   0,  /* "bruynes" 53610 */
      9,   4,  29,   3,  14,   2,  30,  26,   0,  /* "bruzzese" 53619 */
      9,   4,  39,   1,  13,   0,  /* "bryan" 53625 */
      9,   4,  39,   1,  13,  30,   0,  /* "bryans" 53632 */
      9,   4,  39,   1,  13,   3,   0,  /* "bryant" 53639 */
      9,   4,  39,  10,  30,   0,  /* "bryars" 53645 */
      9,   4,  39,  14,   0,  /* "bryce" 53650 */
      9,   4,  39,  20,   1,  13,   0,  /* "bryden" 53657 */
      9,   4,   5,  20,   1,  13,   0,  /* "brydon" 53664 */
      9,   4,  39,   0,  /* "brye" 53668 */
      9,   4,  39,   1,  13,   0,  /* "bryen" 53674 */
      9,   4,  39,  10,   0,  /* "bryer" 53679 */
      9,   4,   5,  12,   0,  /* "bryk" 53684 */
      9,   4,  39,  17,  10,   0,  /* "brymer" 53690 */
      9,   4,   5,  13,   0,  /* "bryn" 53695 */
      9,   4,  39,  13,   0,  /* "bryne" 53700 */
      9,   4,  39,  13,  10,   0,  /* "bryner" 53706 */
      9,   4,  39,   1,  13,   0,  /* "bryon" 53712 */
      9,   4,   5,  14,   0,  /* "brys" 53717 */
      9,   4,  39,  14,   1,  13,   0,  /* "bryson" 53724 */
      9,   4,   1,  30,   5,  13,  14,  12,  26,   0,  /* "brzezinski" 53734 */
      9,   4,  25,  14,  12,   1,   0,  /* "brzoska" 53741 */
      9,   4,   1,  30,  18,  37,  14,  12,  26,   0,  /* "brzozowski" 53751 */
      9,   4,   5,   3,  14,  12,  26,   0,  /* "brzycki" 53759 */
      9,  23,   3,  23,   0,  /* "bt" 53764 */
      9,  23,   3,  23,   2,   0,  /* "bta" 53770 */
      9,  41,  29,   1,   0,  /* "bua" 53775 */
      9,  35,   9,   0,  /* "bub" 53779 */
      9,  29,   9,  10,   0,  /* "bubar" 53784 */
      9,  35,   9,   0,  /* "bubb" 53788 */
      9,  35,   9,   1,   7,   0,  /* "bubble" 53794 */
      9,  35,   9,   1,   7,  20,   0,  /* "bubbled" 53801 */
      9,  35,   9,   1,   7,  30,   0,  /* "bubbles" 53808 */
      9,  35,   9,   1,   7,  31,  32,   0,  /* "bubbling" 53816 */
      9,  29,   9,  15,  12,   0,  /* "bubeck" 53822 */
      9,  29,   9,   1,   7,   0,  /* "bubel" 53828 */
      9,  41,  29,   9,  26,  10,   0,  /* "bubier" 53835 */
      9,  41,  29,   9,  25,   7,   3,  14,   0,  /* "buboltz" 53844 */
      9,  41,  29,   9,  25,   7,  30,   0,  /* "bubolz" 53852 */
      9,  41,  29,   9,   8,  13,  31,  12,   0,  /* "bubonic" 53861 */
      9,  35,  12,   0,  /* "buc" 53865 */
      9,  41,  29,  12,   2,  14,   0,  /* "bucase" 53872 */
      9,  35,  12,   1,  13,  23,   4,   0,  /* "buccaneer" 53880 */
      9,  35,  12,   1,  13,  23,   4,  30,   0,  /* "buccaneers" 53889 */
      9,  29,  42,  15,   7,   8,   3,  27,   0,  /* "buccellato" 53898 */
      9,  29,  12,  25,   7,   1,   0,  /* "buccola" 53905 */
      9,  29,  42,  15,  12,   0,  /* "bucek" 53911 */
      9,  41,  29,  14,  26,   0,  /* "bucey" 53917 */
      9,  35,  42,   0,  /* "buch" 53921 */
      9,  35,  12,   1,   7,   3,  10,   0,  /* "buchalter" 53929 */
      9,  35,  12,   1,  13,   0,  /* "buchan" 53935 */
      9,  41,  29,  12,  24,  13,   1,  13,   0,  /* "buchanan" 53944 */
      9,  41,  29,  12,  24,  13,   1,  13,   5,  30,   1,  17,   0,  /* "buchananism" 53957 */
      9,  41,  29,  12,  24,  13,   1,  13,  30,   0,  /* "buchanans" 53967 */
      9,  41,  29,  12,  24,  13,   1,  13,   0,  /* "buchannan" 53976 */
      9,  41,  29,  12,  24,  13,   1,  13,   0,  /* "buchanon" 53985 */
      9,  41,  29,  12,  10,  21,  14,   3,   0,  /* "bucharest" 53994 */
      9,  35,  42,   0,  /* "buche" 53998 */
      9,  41,  29,  12,  15,  13,  47,   8,   7,  20,   0,  /* "buchenwald" 54009 */
      9,  35,  12,  10,   0,  /* "bucher" 54014 */
      9,  35,  12,  38,  27,   7,   3,  14,   0,  /* "buchholtz" 54023 */
      9,  35,  42,  26,   0,  /* "buchi" 54028 */
      9,  35,  12,   1,  13,  40,  10,   0,  /* "buchinger" 54036 */
      9,  35,  42,  12,  27,   0,  /* "buchko" 54042 */
      9,  35,  12,   1,   7,  10,   0,  /* "buchler" 54049 */
      9,  35,  12,  17,   1,   7,  10,   0,  /* "buchmiller" 54057 */
      9,  35,  12,  27,   7,   3,  14,   0,  /* "bucholtz" 54065 */
      9,  35,  12,  27,   7,  30,   0,  /* "bucholz" 54072 */
      9,  35,  12,  14,   9,  52,  17,   0,  /* "buchsbaum" 54080 */
      9,  35,  42,   3,   1,   0,  /* "buchta" 54086 */
      9,  35,  12,  47,  36,   7,  20,   0,  /* "buchwald" 54094 */
      9,  35,  12,   0,  /* "buck" 54098 */
      9,  35,  12,   1,   7,  29,   0,  /* "buckalew" 54105 */
      9,  35,  12,  39,   0,  /* "buckeye" 54110 */
      9,  35,  12,  38,  24,  13,   3,  14,   0,  /* "buckhantz" 54119 */
      9,  35,  12,  38,  18,   4,  13,   0,  /* "buckhorn" 54127 */
      9,  35,  12,   1,   7,   0,  /* "buckle" 54133 */
      9,  35,  12,   1,   7,  20,   0,  /* "buckled" 54140 */
      9,  35,  12,   1,   7,  10,   0,  /* "buckler" 54147 */
      9,  35,  12,   1,   7,  30,   0,  /* "buckles" 54154 */
      9,  35,  12,  14,   3,  23,  13,   0,  /* "buckstein" 54162 */
      9,  35,  12,  16,  18,   4,  13,   0,  /* "buckthorn" 54170 */
      9,  41,  29,  12,  25,   9,   1,   0,  /* "bucoba" 54178 */
      9,  41,  29,  12,   8,   7,  31,  12,   0,  /* "bucolic" 54187 */
      9,  41,  29,  14,  26,   0,  /* "bucy" 54193 */
      9,   1,  42,  12,  18,  37,  14,  12,  26,   0,  /* "buczkowski" 54203 */
      9,   1,  42,   5,  13,  14,  12,  26,   0,  /* "buczynski" 54212 */
      9,  35,  20,   0,  /* "bud" 54216 */
      9,  29,  20,   8,  26,   0,  /* "budai" 54222 */
      9,  29,  20,   1,   6,  21,  14,   3,   0,  /* "budapest" 54231 */
      9,  29,  20,  28,   0,  /* "buday" 54236 */
      9,  35,  20,   0,  /* "budd" 54240 */
      9,  35,  20,   1,  13,   9,   4,  45,  12,  14,   0,  /* "buddenbrooks" 54251 */
      9,  29,  20,   1,   0,  /* "buddha" 54256 */
      9,  29,  20,   5,  30,   1,  17,   0,  /* "buddhism" 54264 */
      9,  29,  20,   1,  14,   3,   0,  /* "buddhist" 54271 */
      9,  29,  20,   1,  14,   3,  14,   0,  /* "buddhists" 54279 */
      9,  35,  20,  26,  10,  30,   0,  /* "buddiers" 54286 */
      9,  41,  29,  20,  10,   0,  /* "buder" 54292 */
      9,  35,  40,   1,   3,   5,   4,   0,  /* "budgeteer" 54300 */
      9,  35,  40,   1,   3,   5,   4,  30,   0,  /* "budgeteers" 54309 */
      9,  35,  40,   1,  32,   0,  /* "budging" 54315 */
      9,  35,  20,   1,  12,   0,  /* "budick" 54321 */
      9,  41,  29,   3,   1,  17,   1,  13,   0,  /* "budiman" 54330 */
      9,  29,  20,   5,  13,   0,  /* "budin" 54336 */
      9,  41,  29,  20,  31,  32,  10,   0,  /* "budinger" 54344 */
      9,  35,  20,   7,  18,  32,   0,  /* "budlong" 54351 */
      9,   1,  20,   4,  25,   0,  /* "budreau" 54357 */
      9,  35,  20,   4,  25,   0,  /* "budrow" 54363 */
      9,  35,  20,  30,   0,  /* "buds" 54368 */
      9,  35,  20,  47,  39,  30,  10,   0,  /* "budweiser" 54376 */
      9,  29,  20,  41,   1,  13,   8,  22,  14,  12,   0,  /* "budyonnovsk" 54387 */
      9,  35,  20,  30,   0,  /* "budz" 54392 */
      9,   1,  40,   5,  13,  14,  12,  26,   0,  /* "budzinski" 54401 */
      9,  35,  20,  30,   5,  13,   0,  /* "budzyn" 54408 */
      9,   1,  40,   5,  13,  14,  12,  26,   0,  /* "budzynski" 54417 */
      9,  47,  21,   0,  /* "bue" 54421 */
      9,  29,  42,   0,  /* "bueche" 54425 */
      9,  41,  29,  12,   1,   7,   0,  /* "buechel" 54432 */
      9,  41,  29,  12,   1,   7,   0,  /* "buechele" 54439 */
      9,  41,  29,  12,   1,   7,  10,   0,  /* "buechler" 54447 */
      9,  41,  29,  12,  13,  10,   0,  /* "buechner" 54454 */
      9,  29,  40,   0,  /* "buege" 54458 */
      9,  41,  29,  11,   7,  10,   0,  /* "buegler" 54465 */
      9,  41,  29,   7,   0,  /* "buehl" 54470 */
      9,  41,  29,   7,  10,   0,  /* "buehler" 54476 */
      9,  41,  29,  13,  10,   0,  /* "buehner" 54482 */
      9,  41,  29,  38,  10,   0,  /* "buehrer" 54488 */
      9,  41,  29,   4,  31,  32,   0,  /* "buehring" 54495 */
      9,  41,  29,   4,   1,   7,   0,  /* "buehrle" 54502 */
      9,  41,  29,  12,  10,   0,  /* "bueker" 54508 */
      9,  41,  29,   7,   0,  /* "buel" 54513 */
      9,  41,  29,   1,   7,   0,  /* "buell" 54519 */
      9,  29,   7,  27,   0,  /* "buelow" 54524 */
      9,  29,  13,   1,   0,  /* "buena" 54529 */
      9,  29,  13,  20,  26,   1,   0,  /* "buendia" 54536 */
      9,  41,  29,  13,  40,  10,   0,  /* "buenger" 54543 */
      9,  47,  21,  13,  31,  32,   0,  /* "buening" 54550 */
      9,  47,   2,  13,  27,   0,  /* "bueno" 54556 */
      9,  47,   2,  13,  27,  14,   0,  /* "buenos" 54563 */
      9,  47,  15,  13,   4,  25,  14,   3,   4,  27,   0,  /* "buenrostro" 54574 */
      9,  29,  13,   3,  21,   7,  27,   0,  /* "buentello" 54582 */
      9,  29,  10,   0,  /* "buer" 54586 */
      9,  41,  29,   4,  40,   0,  /* "buerge" 54592 */
      9,  41,  29,   4,  11,  10,   0,  /* "buerger" 54599 */
      9,  41,  29,   4,  12,   1,   7,   0,  /* "buerkle" 54607 */
      9,  21,   4,  26,   0,  /* "buerry" 54612 */
      9,  41,  29,  33,  10,   0,  /* "buescher" 54618 */
      9,  41,  29,  14,  31,  32,   0,  /* "buesing" 54625 */
      9,  41,  29,   3,  10,   0,  /* "bueter" 54631 */
      9,  29,   3,  27,   0,  /* "buetow" 54636 */
      9,  41,  29,   3,  13,  10,   0,  /* "buettner" 54643 */
      9,  41,  29,  37,   0,  /* "bufe" 54648 */
      9,  41,  29,  37,  23,   3,   0,  /* "bufete" 54655 */
      9,  35,  37,   0,  /* "buff" 54659 */
      9,  35,  37,   1,   7,  25,   0,  /* "buffalo" 54666 */
      9,  35,  37,   1,   7,  25,  30,   0,  /* "buffalos" 54674 */
      9,   1,  37,   2,   0,  /* "buffet" 54679 */
      9,   1,  37,   2,  20,   0,  /* "buffeted" 54685 */
      9,   1,  37,   2,  31,  32,   0,  /* "buffeting" 54692 */
      9,  29,  37,  27,   0,  /* "buffo" 54697 */
      9,  29,  37,  25,  13,  26,   0,  /* "buffone" 54704 */
      9,   1,  37,  29,  13,   0,  /* "buffoon" 54710 */
      9,  41,  29,  37,  10,  20,   0,  /* "buford" 54717 */
      9,  35,  11,   0,  /* "bug" 54721 */
      9,  41,  29,  11,   1,   0,  /* "buga" 54727 */
      9,  35,  11,   1,   9,  29,   0,  /* "bugaboo" 54734 */
      9,  29,  11,   1,  40,   0,  /* "bugaj" 54740 */
      9,  41,  29,  11,  10,   5,  13,   0,  /* "bugarin" 54748 */
      9,  41,  29,  11,  28,   0,  /* "bugay" 54754 */
      9,  35,  11,  39,   0,  /* "bugeye" 54759 */
      9,  35,  11,  39,  20,   0,  /* "bugeyed" 54765 */
      9,  35,  11,   0,  /* "bugg" 54769 */
      9,  41,  29,  11,   0,  /* "bugh" 54774 */
      9,  41,  29,  11,  10,   0,  /* "bugher" 54780 */
      9,  41,  29,  11,   1,   7,   0,  /* "bugle" 54787 */
      9,  41,  29,  11,   1,   7,  30,   0,  /* "bugles" 54795 */
      9,  41,  29,  11,   1,   7,  31,  32,   0,  /* "bugling" 54804 */
      9,  29,  11,   7,  26,  25,  14,  26,   0,  /* "bugliosi" 54813 */
      9,  29,  11,  25,  43,  13,  27,   0,  /* "bugojno" 54821 */
      9,  35,  11,  30,   0,  /* "bugs" 54826 */
      9,  35,  11,  30,  26,   0,  /* "bugsy" 54832 */
      9,  41,  29,   7,   0,  /* "buhl" 54837 */
      9,  29,   7,  10,   0,  /* "buhler" 54842 */
      9,  41,  45,   4,   0,  /* "buhr" 54847 */
      9,   5,   0,  /* "bui" 54850 */
      9,   5,  14,   0,  /* "buice" 54854 */
      9,  41,  29,  31,  12,   0,  /* "buick" 54860 */
      9,  41,  29,  31,  12,  14,   0,  /* "buicks" 54867 */
      9,  29,  23,   0,  /* "buie" 54871 */
      9,  31,  12,   2,  17,   1,   0,  /* "buikema" 54878 */
      9,   5,   7,  20,   1,   9,   1,   7,   0,  /* "buildable" 54887 */
      9,   5,  30,   0,  /* "buis" 54891 */
      9,  47,  23,  14,   8,  13,   0,  /* "buisson" 54898 */
      9,  29,   5,  14,   3,   0,  /* "buist" 54904 */
      9,  41,  29,   3,  25,  13,  26,   0,  /* "buitoni" 54912 */
      9,   1,   3,   4,   8,  11,  27,   0,  /* "buitrago" 54920 */
      9,   5,   3,   4,   1,  13,   0,  /* "buitron" 54927 */
      9,  29,  40,   1,  17,   9,  45,   4,   1,   0,  /* "bujumbura" 54937 */
      9,  41,  29,  12,  10,   0,  /* "buker" 54943 */
      9,  35,  12,  38,  10,   1,  13,   0,  /* "bukharin" 54951 */
      9,  29,  12,   8,  22,  14,  12,  26,   0,  /* "bukovsky" 54960 */
      9,  41,  29,  12,  18,  37,  14,  12,  26,   0,  /* "bukowski" 54970 */
      9,  41,  29,   7,   1,   0,  /* "bula" 54976 */
      9,  29,   7,   1,   3,   0,  /* "bulat" 54982 */
      9,  35,   7,   9,   0,  /* "bulb" 54987 */
      9,  35,   7,   1,  13,   0,  /* "bulen" 54993 */
      9,  41,  29,   7,   1,  13,   3,   0,  /* "bulent" 55001 */
      9,  41,  29,   7,  26,   0,  /* "buley" 55007 */
      9,  45,   7,  37,   5,  13,  42,   0,  /* "bulfinch" 55015 */
      9,  45,   7,  11,   4,   5,  13,   0,  /* "bulgrin" 55023 */
      9,  41,  29,   7,   5,  17,  26,   1,   0,  /* "bulimia" 55032 */
      9,  41,  29,   7,   5,  17,  31,  12,   0,  /* "bulimic" 55041 */
      9,  41,  29,   7,   5,  13,   0,  /* "bulin" 55048 */
      9,  35,   7,  12,   0,  /* "bulk" 55053 */
      9,  45,   7,  12,   1,   7,  26,   0,  /* "bulkeley" 55061 */
      9,  45,   7,   0,  /* "bull" 55065 */
      9,  45,   7,  20,  18,  11,  30,   0,  /* "bulldogs" 55073 */
      9,  45,   7,  20,  25,  30,  31,  32,   0,  /* "bulldozing" 55082 */
      9,  45,   7,   1,   3,   1,  13,   0,  /* "bulletin" 55090 */
      9,  45,   7,   1,   3,   1,  13,  30,   0,  /* "bulletins" 55099 */
      9,  45,   7,   1,   3,   6,   4,  29,  37,   0,  /* "bulletproof" 55109 */
      9,  45,   7,  37,  39,   3,   0,  /* "bullfight" 55116 */
      9,  45,   7,  37,  39,   3,  10,   0,  /* "bullfighter" 55124 */
      9,  45,   7,  37,  39,   3,  31,  32,   0,  /* "bullfighting" 55133 */
      9,  45,   7,  37,  39,   3,  30,   0,  /* "bullfights" 55141 */
      9,  45,   7,  37,   4,  18,  11,   0,  /* "bullfrog" 55149 */
      9,  45,   7,  37,   4,  18,  11,  30,   0,  /* "bullfrogs" 55158 */
      9,  45,   7,  38,  18,   4,  13,   0,  /* "bullhorn" 55166 */
      9,  45,   7,   5,  33,   0,  /* "bullish" 55172 */
      9,  29,   7,   1,   3,   0,  /* "bullitt" 55178 */
      9,  45,   7,   1,  12,  14,   0,  /* "bullocks" 55185 */
      9,  45,   7,   6,  21,  13,   0,  /* "bullpen" 55192 */
      9,  29,   7,  30,  39,   0,  /* "bullseye" 55198 */
      9,  45,   7,   1,  12,   0,  /* "bulluck" 55204 */
      9,  45,   7,  47,   5,  32,  12,   1,   7,   0,  /* "bullwinkle" 55214 */
      9,  35,   7,  17,   1,  13,   0,  /* "bulman" 55221 */
      9,  41,  29,   7,  25,  22,   1,   0,  /* "bulova" 55229 */
      9,  41,  29,   7,  27,   0,  /* "bulow" 55235 */
      9,  45,   7,   4,  35,  33,   0,  /* "bulrush" 55242 */
      9,  45,   7,  14,   1,  13,   0,  /* "bulson" 55249 */
      9,  35,   7,   3,   0,  /* "bult" 55254 */
      9,  29,   7,   3,  21,  17,   1,   0,  /* "bultema" 55262 */
      9,  35,   7,  46,  29,   1,  30,   0,  /* "bulthuis" 55270 */
      9,  45,   7,   3,  17,   1,  13,   0,  /* "bultman" 55278 */
      9,  45,   7,  47,  10,  12,   0,  /* "bulwark" 55285 */
      9,  45,   7,  47,   5,  32,  12,   1,   7,   0,  /* "bulwinkle" 55295 */
      9,  35,  17,   0,  /* "bum" 55299 */
      9,  41,  29,  17,   1,  13,   0,  /* "bumann" 55306 */
      9,  35,  17,   9,   1,   7,   0,  /* "bumble" 55313 */
      9,  35,  17,   9,   1,   7,  31,  32,   0,  /* "bumbling" 55322 */
      9,  29,  17,  26,   6,  41,  29,   3,   4,   1,   0,  /* "bumiputra" 55333 */
      9,  35,  17,   6,   0,  /* "bump" 55338 */
      9,  35,  17,  30,   0,  /* "bums" 55343 */
      9,  35,  13,   0,  /* "bun" 55347 */
      9,  35,  13,  20,   0,  /* "bund" 55352 */
      9,  45,  13,  20,   1,  14,   9,  24,  32,  12,   0,  /* "bundesbank" 55363 */
      9,  45,  13,  20,   1,  14,   6,  25,  14,   3,   0,  /* "bundespost" 55374 */
      9,  45,  13,  20,   1,  14,   4,  24,   3,   0,  /* "bundesrat" 55384 */
      9,  35,  13,  20,   1,  14,   3,  24,  11,   0,  /* "bundestag" 55394 */
      9,  35,  13,  20,   1,   7,   0,  /* "bundle" 55401 */
      9,  35,  13,  20,   1,   7,  20,   0,  /* "bundled" 55409 */
      9,  35,  13,  20,   1,   7,  30,   0,  /* "bundles" 55417 */
      9,  35,  13,  20,   1,   7,  31,  32,   0,  /* "bundling" 55426 */
      9,  35,  32,   0,  /* "bung" 55430 */
      9,  35,  32,  11,   1,   7,  25,   0,  /* "bungalow" 55438 */
      9,  35,  32,  10,   0,  /* "bunger" 55443 */
      9,  35,  32,  11,   1,   7,  20,   0,  /* "bungled" 55451 */
      9,  35,  32,  11,   7,  10,   0,  /* "bungler" 55458 */
      9,  35,  32,  11,   1,   7,  31,  32,   0,  /* "bungling" 55467 */
      9,  35,  32,  12,   0,  /* "bunk" 55472 */
      9,  35,  13,   0,  /* "bunn" 55476 */
      9,  29,  13,  26,   0,  /* "bunni" 55481 */
      9,  29,  13,  48,  14,  12,  26,   0,  /* "bunowski" 55489 */
      9,  35,  13,  30,   0,  /* "buns" 55494 */
      9,  35,  13,   0,  /* "bunt" 55498 */
      9,   1,  13,   3,   2,  13,   0,  /* "buntain" 55505 */
      9,   1,  13,  41,   8,   4,  20,   0,  /* "bunyard" 55513 */
      9,  35,  13,  30,   1,   7,   0,  /* "bunzl" 55520 */
      9,  25,   7,   0,  /* "buol" 55524 */
      9,  47,  27,  13,   8,  13,  27,   0,  /* "buonanno" 55532 */
      9,  47,   8,  13,  31,  12,   8,  13,   3,  26,  30,   0,  /* "buonicontis" 55544 */
      9,  47,  25,  13,  27,   0,  /* "buono" 55550 */
      9,  47,  27,  13,  27,  12,  18,   4,  26,   0,  /* "buonocore" 55560 */
      9,  47,  27,  13,  25,  17,  27,   0,  /* "buonomo" 55568 */
      9,  29,  26,   0,  /* "buoy" 55572 */
      9,  29,  26,  20,   0,  /* "buoyed" 55577 */
      9,  29,  26,  30,   0,  /* "buoys" 55582 */
      9,  35,   6,   0,  /* "bupp" 55586 */
      9,  41,  29,   6,   4,   1,  13,  10,  37,  23,  13,   0,  /* "buprenorphine" 55598 */
      9,  44,   0,  /* "bur" 55601 */
      9,  41,  29,   4,   1,  12,   0,  /* "burack" 55608 */
      9,  41,  29,   4,   1,  12,   0,  /* "burak" 55615 */
      9,  41,  29,   4,   1,  13,   0,  /* "buran" 55622 */
      9,  41,  29,   4,   1,  13,   3,   0,  /* "burandt" 55630 */
      9,  41,  29,   4,   1,  30,   0,  /* "buras" 55637 */
      9,  44,   9,  34,  12,   0,  /* "burback" 55643 */
      9,  44,   9,  31,  40,   0,  /* "burbage" 55649 */
      9,  44,   9,   4,  31,  40,   0,  /* "burbridge" 55656 */
      9,  10,  33,  24,  17,   0,  /* "burcham" 55662 */
      9,  10,  33,   8,   4,  20,   0,  /* "burchard" 55669 */
      9,  44,  42,  10,   0,  /* "burcher" 55674 */
      9,  10,  33,  21,   3,   0,  /* "burchette" 55680 */
      9,  44,  42,  37,  26,   7,  20,   0,  /* "burchfield" 55688 */
      9,  44,  12,  38,   5,   7,   0,  /* "burchill" 55695 */
      9,  51,   4,  14,  26,   8,  11,   1,   0,  /* "burciaga" 55704 */
      9,  44,  12,  38,  19,   4,   3,   0,  /* "burckhardt" 55712 */
      9,  44,  20,   0,  /* "burd" 55716 */
      9,  45,   4,  20,   1,   0,  /* "burda" 55722 */
      9,  10,  20,  21,   7,   0,  /* "burdell" 55728 */
      9,  44,  20,   5,   3,   0,  /* "burdett" 55734 */
      9,  10,  20,  21,   3,   0,  /* "burdette" 55740 */
      9,  45,   4,  20,  26,   0,  /* "burdi" 55746 */
      9,  10,  20,  23,  13,   0,  /* "burdine" 55752 */
      9,  10,  20,  23,  13,  30,   0,  /* "burdines" 55759 */
      9,  10,  20,   5,   3,   0,  /* "burditt" 55765 */
      9,  45,   4,  20,  27,   0,  /* "burdo" 55771 */
      9,  44,  20,  14,   1,   7,   0,  /* "burdsall" 55778 */
      9,  41,  45,   4,  27,   0,  /* "bureau" 55784 */
      9,  41,  51,   4,   8,  12,   4,   1,  14,  26,  30,   0,  /* "bureaucracies" 55796 */
      9,  41,  51,   4,   8,  12,   4,   1,  14,  26,   0,  /* "bureaucracy" 55807 */
      9,  41,  45,   4,   1,  12,   4,  24,   3,   0,  /* "bureaucrat" 55817 */
      9,  41,  45,   4,   1,  12,   4,  24,   3,  23,  30,   0,  /* "bureaucratese" 55829 */
      9,  41,  45,   4,   1,  12,   4,  24,   3,  31,  12,   0,  /* "bureaucratic" 55841 */
      9,  41,  45,   4,   1,  12,   4,  24,   3,  14,   0,  /* "bureaucrats" 55852 */
      9,  41,  45,   4,  27,  30,   0,  /* "bureaus" 55859 */
      9,  21,   4,  31,  12,   0,  /* "burek" 55865 */
      9,  21,   4,   1,   7,   0,  /* "burel" 55871 */
      9,  41,  45,   4,   1,  13,   0,  /* "buren" 55878 */
      9,  21,   4,  15,  33,   0,  /* "buresh" 55884 */
      9,  44,  37,  39,  13,  20,   0,  /* "burfeind" 55891 */
      9,  44,  37,  26,   7,  20,   0,  /* "burfield" 55898 */
      9,  44,  11,   0,  /* "burg" 55902 */
      9,  44,  11,  34,  13,   0,  /* "burgan" 55908 */
      9,  44,  11,   0,  /* "burge" 55912 */
      9,  44,  11,  26,  13,  10,   0,  /* "burgener" 55919 */
      9,  44,  40,   1,  13,   0,  /* "burgeon" 55925 */
      9,  44,  40,   1,  13,  20,   0,  /* "burgeoned" 55932 */
      9,  44,  40,   1,  13,  31,  32,   0,  /* "burgeoning" 55940 */
      9,  44,  11,  30,   0,  /* "burges" 55945 */
      9,  44,  40,   1,  14,   0,  /* "burgess" 55951 */
      9,  44,  11,  15,   3,   0,  /* "burget" 55957 */
      9,  44,  40,   5,   3,   0,  /* "burgett" 55963 */
      9,  44,  11,  38,  19,   4,   3,   0,  /* "burghart" 55971 */
      9,  44,  11,   5,  13,   0,  /* "burgin" 55977 */
      9,  44,  11,  26,  27,   0,  /* "burgio" 55983 */
      9,  44,  11,   7,  10,  26,  30,   0,  /* "burglaries" 55991 */
      9,  44,  11,   7,  10,  39,  30,   0,  /* "burglarize" 55999 */
      9,  44,  11,   7,  10,  39,  30,  20,   0,  /* "burglarized" 56008 */
      9,  44,  11,   7,  10,  30,   0,  /* "burglars" 56015 */
      9,  44,  11,   7,  31,  32,   0,  /* "burgling" 56022 */
      9,  44,  11,   1,  17,  24,  14,   3,  10,   0,  /* "burgomaster" 56032 */
      9,  44,  11,   1,  17,  24,  14,   3,  10,  30,   0,  /* "burgomasters" 56043 */
      9,  44,  11,  29,  13,   0,  /* "burgoon" 56049 */
      9,  10,  11,  49,  13,   0,  /* "burgoyne" 56055 */
      9,  10,  11,  35,  13,  20,  26,   1,  13,   0,  /* "burgundian" 56065 */
      9,  10,  11,  35,  13,  20,  26,   1,  13,  30,   0,  /* "burgundians" 56076 */
      9,  44,  11,   1,  13,  20,  26,  30,   0,  /* "burgundies" 56085 */
      9,  44,  11,   1,  13,  20,  26,   0,  /* "burgundy" 56093 */
      9,  45,   4,  26,   0,  /* "buri" 56098 */
      9,  41,  45,   4,  26,   1,  13,   0,  /* "burian" 56106 */
      9,  21,   4,  26,  20,   0,  /* "buried" 56112 */
      9,  44,  12,   0,  /* "burk" 56116 */
      9,  10,  12,  23,  13,   0,  /* "burkeen" 56122 */
      9,  44,  12,  15,  17,   6,  10,   0,  /* "burkemper" 56130 */
      9,  44,  12,  38,   1,  17,  10,   0,  /* "burkhammer" 56138 */
      9,  44,  12,  38,  19,   4,   3,   0,  /* "burkhart" 56146 */
      9,  44,  12,  38,  15,  20,   0,  /* "burkhead" 56153 */
      9,  44,  12,  38,  27,   7,  20,  10,   0,  /* "burkholder" 56162 */
      9,  10,  12,  23,  13,   1,   0,  /* "burkina" 56169 */
      9,  44,  12,   1,   7,   0,  /* "burkle" 56175 */
      9,  44,   7,   0,  /* "burl" 56179 */
      9,  44,   7,  24,   6,   0,  /* "burlap" 56185 */
      9,  10,   7,  24,   3,  14,  12,  26,   0,  /* "burlatsky" 56194 */
      9,  44,   7,   1,   0,  /* "burleigh" 56199 */
      9,  44,   7,   1,  14,   1,  13,   0,  /* "burleson" 56207 */
      9,  10,   7,  21,  14,  12,   0,  /* "burlesque" 56214 */
      9,  44,  17,   1,   0,  /* "burmah" 56219 */
      9,  44,  17,  34,  14,   3,  10,   0,  /* "burmaster" 56227 */
      9,  10,  17,  23,  30,   0,  /* "burmese" 56233 */
      9,  44,  17,  15,  14,   3,  10,   0,  /* "burmester" 56241 */
      9,  44,  13,   0,  /* "burn" 56245 */
      9,  44,  13,   1,   9,   1,   7,   0,  /* "burnable" 56253 */
      9,  10,  13,   8,   4,  20,   0,  /* "burnard" 56260 */
      9,  44,  13,  15,   3,   0,  /* "burnet" 56266 */
      9,  10,  13,  21,   3,   0,  /* "burnett" 56272 */
      9,  10,  13,  21,   3,   0,  /* "burnette" 56278 */
      9,  44,  13,   1,  17,   0,  /* "burnham" 56284 */
      9,  44,  13,   5,  33,   3,   0,  /* "burnished" 56291 */
      9,  44,  13,  30,  20,   0,  /* "burnsed" 56297 */
      9,  44,  13,  14,  39,  20,   0,  /* "burnside" 56304 */
      9,  44,  13,  30,  47,  44,  16,   0,  /* "burnsworth" 56312 */
      9,  41,  29,   4,   1,  12,  10,   0,  /* "buroker" 56320 */
      9,  41,  45,   4,  27,   0,  /* "burow" 56326 */
      9,  44,   6,   0,  /* "burp" 56330 */
      9,  44,   6,  26,   0,  /* "burpee" 56335 */
      9,  45,   4,   6,  27,   0,  /* "burpo" 56341 */
      9,  44,   0,  /* "burr" 56344 */
      9,  44,  31,  40,   0,  /* "burrage" 56349 */
      9,  10,  21,   7,   0,  /* "burrell" 56354 */
      9,  44,   1,  14,   0,  /* "burress" 56359 */
      9,  45,   4,  26,   0,  /* "burri" 56364 */
      9,  18,   4,  31,  40,   0,  /* "burridge" 56370 */
      9,  18,   4,  39,   3,   0,  /* "burright" 56376 */
      9,  18,   4,   1,   7,   0,  /* "burrill" 56382 */
      9,  44,   1,  14,   0,  /* "burris" 56387 */
      9,  44,   1,  14,   1,  30,   0,  /* "burriss" 56394 */
      9,  10,  23,   3,  27,   0,  /* "burrito" 56400 */
      9,  10,  23,   3,  27,  14,   0,  /* "burritos" 56407 */
      9,  44,  27,   0,  /* "burro" 56411 */
      9,  51,   4,  25,   7,   1,   0,  /* "burrola" 56418 */
      9,  44,  27,  30,   0,  /* "burros" 56423 */
      9,  44,  27,   0,  /* "burrough" 56427 */
      9,  35,   4,  27,  30,   0,  /* "burroughs" 56433 */
      9,  44,   1,  14,   0,  /* "burrous" 56438 */
      9,  44,  25,  30,   0,  /* "burrowes" 56443 */
      9,  45,   4,   1,  14,   0,  /* "burrus" 56449 */
      9,  45,   4,   1,  14,   0,  /* "burruss" 56455 */
      9,  44,   3,   0,  /* "burt" 56459 */
      9,  44,   3,  13,  15,   3,   0,  /* "burtnett" 56466 */
      9,  10,  35,  13,  20,  26,   0,  /* "burundi" 56473 */
      9,  44,  47,  15,   7,   0,  /* "burwell" 56479 */
      9,  21,   4,  26,   0,  /* "bury" 56484 */
      9,  21,   4,  26,  31,  32,   0,  /* "burying" 56491 */
      9,  10,  30,   5,  13,  14,  12,  26,   0,  /* "burzynski" 56500 */
      9,  35,  14,   0,  /* "bus" 56504 */
      9,  41,  29,  14,   1,   0,  /* "busa" 56510 */
      9,  29,  14,  19,   7,   8,  12,  26,   0,  /* "busalacchi" 56519 */
      9,   5,  14,   1,  17,   0,  /* "busam" 56525 */
      9,  35,  14,   9,  23,   0,  /* "busbee" 56531 */
      9,  35,  14,   9,   5,  13,   0,  /* "busbin" 56538 */
      9,  35,  14,   9,  29,  17,   0,  /* "busboom" 56545 */
      9,  35,  30,   9,  26,   0,  /* "busby" 56551 */
      9,  29,  14,  12,   8,  11,   7,  26,   1,   0,  /* "buscaglia" 56561 */
      9,  29,  14,  42,  21,  17,  26,   0,  /* "buscemi" 56569 */
      9,  45,  33,   0,  /* "busch" 56573 */
      9,  45,  33,   9,  48,  17,   0,  /* "buschbaum" 56580 */
      9,  29,  33,  10,   0,  /* "buscher" 56585 */
      9,  41,  29,  30,   0,  /* "buse" 56590 */
      9,  35,  14,   3,   0,  /* "bused" 56595 */
      9,   5,  14,  17,   1,  13,   0,  /* "buseman" 56602 */
      9,   5,  14,   1,  13,   9,  19,   4,  12,   0,  /* "busenbark" 56612 */
      9,   5,  14,  10,   0,  /* "buser" 56617 */
      9,  41,  29,  30,  26,   0,  /* "busey" 56623 */
      9,  45,  33,   0,  /* "bush" 56627 */
      9,  35,  33,   1,   0,  /* "busha" 56632 */
      9,  45,  33,  19,   4,   3,   0,  /* "bushart" 56639 */
      9,  45,  33,  36,   0,  /* "bushaw" 56644 */
      9,  35,  14,  31,  12,   0,  /* "busic" 56650 */
      9,   5,  14,  31,  12,   0,  /* "busick" 56656 */
      9,   5,  30,  26,  20,   0,  /* "busied" 56662 */
      9,   5,  30,  26,  10,   0,  /* "busier" 56668 */
      9,   5,  30,  26,   1,  14,   3,   0,  /* "busiest" 56676 */
      9,   5,  30,   1,   7,  26,   0,  /* "busily" 56683 */
      9,   5,  30,  13,   1,  14,   7,  24,  13,  20,   0,  /* "businessland" 56694 */
      9,   5,  30,  13,   1,  14,   7,  39,  12,   0,  /* "businesslike" 56704 */
      9,   5,  30,  13,   1,  14,  17,  24,  13,   0,  /* "businessman" 56714 */
      9,   5,  30,  13,   1,  14,  17,  21,  13,   0,  /* "businessmen" 56724 */
      9,   5,  30,  13,   1,  14,   6,  23,   6,   1,   7,   0,  /* "businesspeople" 56736 */
      9,   5,  30,  13,   1,  14,   6,  44,  14,   1,  13,   0,  /* "businessperson" 56748 */
      9,   5,  30,  13,   1,  14,  47,  31,  17,  15,  13,   0,  /* "businesswomen" 56760 */
      9,  35,  14,  31,  32,   0,  /* "busing" 56766 */
      9,  35,  14,  12,   0,  /* "busk" 56771 */
      9,  35,  14,  12,  23,   0,  /* "buskey" 56777 */
      9,  35,  14,   1,   7,  10,   0,  /* "busler" 56784 */
      9,   1,  14,   7,  25,  20,   0,  /* "busload" 56791 */
      9,   1,  14,   7,  25,  20,  30,   0,  /* "busloads" 56799 */
      9,  35,  14,   0,  /* "buss" 56803 */
      9,  29,  14,   1,   0,  /* "bussa" 56808 */
      9,  35,  14,  26,  15,   4,   0,  /* "bussiere" 56815 */
      9,  35,  14,   3,   0,  /* "bust" 56820 */
      9,  29,  14,   3,   1,  17,   8,  13,   3,  26,   0,  /* "bustamante" 56831 */
      9,  35,  14,   3,  41,  10,   0,  /* "bustier" 56838 */
      9,  29,  14,   3,   5,   7,  27,   0,  /* "bustillo" 56846 */
      9,  35,  14,   3,  39,   7,  27,  30,   0,  /* "bustillos" 56855 */
      9,  35,  14,   1,   7,   0,  /* "bustle" 56861 */
      9,  35,  14,   1,   7,  31,  32,   0,  /* "bustling" 56869 */
      9,  41,  29,  14,   1,   7,  24,  12,  26,   0,  /* "busulaki" 56879 */
      9,   5,  30,  26,   0,  /* "busy" 56884 */
      9,  35,   3,   0,  /* "but" 56888 */
      9,  29,   3,   8,   7,   1,   0,  /* "butala" 56895 */
      9,  41,  29,   3,   2,  13,   0,  /* "butane" 56902 */
      9,  29,   3,   8,   4,  26,   0,  /* "butare" 56909 */
      9,  45,  42,  10,   3,   0,  /* "butchart" 56915 */
      9,  45,  42,  10,  20,   0,  /* "butchered" 56921 */
      9,  35,  42,  12,  27,   0,  /* "butchko" 56927 */
      9,  41,  29,   3,   0,  /* "bute" 56932 */
      9,  41,  29,   3,  25,   0,  /* "buteau" 56938 */
      9,  29,   3,  21,  12,  27,   0,  /* "buteco" 56945 */
      9,  41,  29,   3,   1,  13,  38,  36,  37,   0,  /* "butenhoff" 56955 */
      9,  29,   3,  21,   4,   1,   0,  /* "butera" 56962 */
      9,  41,  29,   3,  10,   9,  52,   0,  /* "buterbaugh" 56970 */
      9,  29,  16,   0,  /* "buth" 56974 */
      9,  29,   3,   1,   7,   2,  30,  26,   0,  /* "buthelezi" 56983 */
      9,  35,   3,   7,  10,   0,  /* "butler" 56989 */
      9,  41,  29,   3,  18,   4,   1,  12,   0,  /* "butorac" 56998 */
      9,  29,   3,   4,  25,  14,   0,  /* "butros" 57005 */
      9,  35,   3,  14,   0,  /* "buts" 57010 */
      9,  35,   3,   0,  /* "butt" 57014 */
      9,  29,   3,  19,  12,  19,  22,  25,   7,  26,   0,  /* "buttacavoli" 57025 */
      9,  29,   3,   1,  37,  47,  25,  12,  27,   0,  /* "buttafuoco" 57035 */
      9,  41,  29,   3,   0,  /* "butte" 57040 */
      9,  35,   3,  10,   9,  18,   7,   0,  /* "butterball" 57048 */
      9,  35,   3,  10,   9,  52,   0,  /* "butterbaugh" 57055 */
      9,  35,   3,  10,  20,   0,  /* "buttered" 57061 */
      9,  35,   3,  10,  37,  26,   7,  20,   0,  /* "butterfield" 57070 */
      9,  35,   3,  10,  37,   7,  39,  30,   0,  /* "butterflies" 57079 */
      9,  35,   3,  10,  37,   7,  39,   0,  /* "butterfly" 57087 */
      9,  35,   3,  10,  17,  36,   4,   0,  /* "buttermore" 57095 */
      9,  35,   3,  10,  26,   0,  /* "buttery" 57101 */
      9,  35,   3,  38,  21,  20,   0,  /* "butthead" 57108 */
      9,  29,   3,  23,   3,   1,   0,  /* "buttitta" 57115 */
      9,  35,   3,   1,  12,  14,   0,  /* "buttocks" 57122 */
      9,  35,   3,   1,  13,  20,   0,  /* "buttoned" 57129 */
      9,  35,   3,   1,  13,  38,  25,   7,   0,  /* "buttonhole" 57138 */
      9,  35,   3,   1,  13,  38,  25,   7,  20,   0,  /* "buttonholed" 57148 */
      9,  35,   3,   1,  13,  38,  25,   7,  30,   0,  /* "buttonholes" 57158 */
      9,  35,   3,   1,  13,  30,   0,  /* "buttons" 57165 */
      9,  35,   3,   1,  13,  22,   5,   7,   0,  /* "buttonville" 57174 */
      9,  35,   3,   4,   1,  14,   3,   0,  /* "buttressed" 57182 */
      9,  35,   3,   4,   1,  14,  31,  32,   0,  /* "buttressing" 57191 */
      9,  29,   3,   1,   7,   2,  30,  26,   0,  /* "butulesi" 57200 */
      9,  41,  29,   3,   1,   7,   0,  /* "butyl" 57207 */
      9,  35,   3,  14,   0,  /* "butz" 57212 */
      9,  35,   3,  14,   1,  13,   0,  /* "butzen" 57219 */
      9,  35,   3,  14,  10,   0,  /* "butzer" 57225 */
      9,  35,   3,  14,   1,  13,   0,  /* "butzin" 57232 */
      9,  29,  30,   0,  /* "buus" 57236 */
      9,  35,  12,  14,   9,  52,  17,   0,  /* "buxbaum" 57244 */
      9,  35,  12,  14,   1,  17,   0,  /* "buxom" 57251 */
      9,  35,  12,  14,   3,   1,  13,   0,  /* "buxton" 57259 */
      9,  39,   0,  /* "buy" 57262 */
      9,  39,   9,  24,  12,   0,  /* "buyback" 57268 */
      9,  39,   9,  24,  12,  14,   0,  /* "buybacks" 57275 */
      9,  39,  10,   0,  /* "buyer" 57279 */
      9,  39,  10,  30,   0,  /* "buyers" 57284 */
      9,  39,  31,  32,   0,  /* "buying" 57289 */
      9,  39,  48,   3,   0,  /* "buyout" 57294 */
      9,  39,  48,   3,  14,   0,  /* "buyouts" 57300 */
      9,  39,  30,   0,  /* "buys" 57304 */
      9,  39,  14,   0,  /* "buysse" 57308 */
      9,  41,  29,  30,   1,   0,  /* "buza" 57314 */
      9,  41,  29,  30,   1,  13,   0,  /* "buzan" 57321 */
      9,  41,  29,  30,   8,   4,  20,   0,  /* "buzard" 57329 */
      9,  29,  30,  15,  12,   0,  /* "buzek" 57335 */
      9,  35,  30,   0,  /* "buzz" 57339 */
      9,  35,  30,  10,  20,   0,  /* "buzzard" 57345 */
      9,  35,  30,  10,  20,  30,   0,  /* "buzzards" 57352 */
      9,   1,  30,  21,   7,   0,  /* "buzzell" 57358 */
      9,  29,   3,  14,  21,   7,  26,   0,  /* "buzzelli" 57366 */
      9,  41,  29,  30,  21,   3,   1,   0,  /* "buzzetta" 57374 */
      9,  35,  30,  31,  32,   0,  /* "buzzing" 57380 */
      9,  35,  30,  47,  10,  20,   0,  /* "buzzword" 57387 */
      9,  35,  30,  47,  10,  20,  30,   0,  /* "buzzwords" 57395 */
      9,  39,   0,  /* "by" 57398 */
      9,  39,   1,  17,   0,  /* "byam" 57403 */
      9,  41,   8,   4,  20,   0,  /* "byard" 57409 */
      9,  39,  10,  30,   0,  /* "byars" 57414 */
      9,  39,   1,  14,   0,  /* "byas" 57419 */
      9,  26,   8,  14,  26,   0,  /* "byassee" 57425 */
      9,  39,   9,  23,   0,  /* "bybee" 57430 */
      9,  39,   0,  /* "bye" 57433 */
      9,  39,   1,   7,  27,   4,  35,  33,   1,   0,  /* "byelorussia" 57443 */
      9,  39,  10,   0,  /* "byer" 57447 */
      9,  39,   4,   7,  39,  13,   0,  /* "byerlein" 57454 */
      9,  39,  10,   7,  26,   0,  /* "byerley" 57460 */
      9,  39,  10,   7,  26,   0,  /* "byerly" 57466 */
      9,  39,  10,  30,   0,  /* "byers" 57471 */
      9,  39,  37,  23,   7,  20,   0,  /* "byfield" 57478 */
      9,   5,  37,  10,  20,   0,  /* "byford" 57484 */
      9,  39,  11,  18,  13,   0,  /* "bygone" 57490 */
      9,  39,  11,  18,  13,  30,   0,  /* "bygones" 57497 */
      9,  39,  31,  32,   3,   1,  13,   0,  /* "byington" 57505 */
      9,  39,  12,  10,   0,  /* "byker" 57510 */
      9,  31,  12,  18,  37,  14,  12,  26,   0,  /* "bykowski" 57519 */
      9,  39,   7,   1,  13,  20,   0,  /* "byland" 57526 */
      9,  39,   7,  18,   0,  /* "bylaw" 57531 */
      9,  39,   7,  18,  30,   0,  /* "bylaws" 57537 */
      9,  39,   7,  10,   0,  /* "byler" 57542 */
      9,  39,   7,  30,   0,  /* "byles" 57547 */
      9,  39,   7,  39,  13,   0,  /* "byline" 57553 */
      9,  39,   7,  23,  13,  30,   0,  /* "bylines" 57560 */
      9,   5,   7,  14,  17,   1,   0,  /* "bylsma" 57567 */
      9,  39,  13,  10,   0,  /* "byner" 57572 */
      9,  39,  13,  30,   0,  /* "bynes" 57577 */
      9,  39,   6,  24,  14,   0,  /* "bypass" 57583 */
      9,  39,   6,  24,  14,   3,   0,  /* "bypassed" 57590 */
      9,  39,   6,  24,  14,   1,  30,   0,  /* "bypasses" 57598 */
      9,  39,   6,  24,  14,  31,  32,   0,  /* "bypassing" 57606 */
      9,  39,   6,   4,  19,  20,   1,  12,   3,   0,  /* "byproduct" 57616 */
      9,  39,   6,   4,  18,  20,   1,  12,   3,  14,   0,  /* "byproducts" 57627 */
      9,   5,   4,   1,  17,   0,  /* "byram" 57633 */
      9,  44,  20,   0,  /* "byrd" 57637 */
      9,  39,   4,  10,   0,  /* "byrer" 57642 */
      9,  39,   4,  40,   0,  /* "byrge" 57647 */
      9,  39,   4,   1,   7,   0,  /* "byrle" 57653 */
      9,   5,   4,  13,   0,  /* "byrn" 57658 */
      9,  44,  13,   0,  /* "byrne" 57662 */
      9,  44,  13,  30,   0,  /* "byrnes" 57667 */
      9,   5,   4,  13,  30,   0,  /* "byrns" 57673 */
      9,  39,   4,   1,  17,   0,  /* "byrom" 57679 */
      9,  39,   4,   1,  13,   0,  /* "byron" 57685 */
      9,  39,  14,   3,  24,  13,  20,  10,   0,  /* "bystander" 57694 */
      9,  39,  14,   3,  24,  13,  20,  10,  30,   0,  /* "bystanders" 57704 */
      9,   5,  14,   3,   4,   1,  17,   0,  /* "bystrom" 57712 */
      9,  39,   3,   0,  /* "byte" 57716 */
      9,  39,   3,  14,   0,  /* "bytes" 57721 */
      9,  23,  47,  39,  41,  29,   0,  /* "byu" 57728 */
      9,  41,  35,  13,   0,  /* "byun" 57733 */
      9,  39,   1,  14,   0,  /* "byus" 57738 */
      9,  39,  47,  18,   3,  10,   0,  /* "bywater" 57745 */
      9,  39,  47,   2,   0,  /* "byway" 57750 */
      9,  39,  47,   2,  30,   0,  /* "byways" 57756 */
      9,  39,  47,  44,  20,   0,  /* "byword" 57762 */
      9,   5,  30,   1,  13,   3,  39,  13,   0,  /* "byzantine" 57771 */
      9,   1,  30,  24,  13,   3,  26,   1,  17,   0,  /* "byzantium" 57781 */
     14,  23,   0,  /* "c" 57784 */
     12,  35,   0,  /* "ca" 57787 */
     12,   8,  13,   0,  /* "caan" 57791 */
     12,  24,   9,   0,  /* "cab" 57795 */
     12,   8,   9,   1,   0,  /* "caba" 57800 */
     12,   1,   9,   8,   7,   0,  /* "cabal" 57806 */
     12,  24,   9,   1,  41,  21,   4,  27,   0,  /* "caballero" 57815 */
     12,   1,   9,  24,  13,   1,   0,  /* "cabana" 57822 */
     12,   1,   9,  24,  13,   1,  30,   0,  /* "cabanas" 57830 */
     12,  24,   9,   1,  13,   5,  14,   0,  /* "cabaniss" 57838 */
     12,  24,   9,  10,   2,   0,  /* "cabaret" 57844 */
     12,  24,   9,   1,  40,   0,  /* "cabbage" 57850 */
     12,  24,   9,  20,   4,  39,  22,  10,   0,  /* "cabdriver" 57859 */
     12,  24,   9,  20,   4,  39,  22,  10,  30,   0,  /* "cabdrivers" 57869 */
     12,   2,   9,   0,  /* "cabe" 57873 */
     12,  19,   9,  21,   7,   0,  /* "cabell" 57879 */
     12,  24,   9,  10,  13,   2,   0,  /* "cabernet" 57886 */
     12,  24,   9,  10,  13,  21,   3,  14,   0,  /* "cabernets" 57895 */
     12,   1,   9,   2,  30,   1,  30,   0,  /* "cabezas" 57903 */
     12,  24,   9,   1,  13,   0,  /* "cabin" 57909 */
     12,   1,   9,   5,  13,  20,   1,   0,  /* "cabinda" 57917 */
     12,   2,   9,  26,  13,   1,  14,   0,  /* "cabiness" 57925 */
     12,  24,   9,  13,   1,   3,   4,  26,   0,  /* "cabinetry" 57934 */
     12,  24,   9,   1,  13,  30,   0,  /* "cabins" 57941 */
     12,   2,   9,   1,   7,   0,  /* "cable" 57947 */
     12,  24,   9,   7,   1,  12,   0,  /* "cablec" 57954 */
     12,   2,   9,   1,   7,  12,   8,  17,   0,  /* "cablecomm" 57963 */
     12,   2,   9,   1,   7,  12,   8,  17,  30,   0,  /* "cablecomms" 57973 */
     12,   2,   9,   1,   7,  20,   0,  /* "cabled" 57980 */
     12,   2,   9,   1,   7,  11,   4,  24,  17,   0,  /* "cablegram" 57990 */
     12,   2,   9,   1,   7,  47,  35,  13,   0,  /* "cableone" 57999 */
     12,   2,   9,   1,   7,  10,   0,  /* "cabler" 58006 */
     12,   2,   9,   1,   7,  30,   0,  /* "cables" 58013 */
     12,   2,   9,   1,   7,  14,   5,  14,   3,   1,  17,   0,  /* "cablesystem" 58025 */
     12,   2,   9,   1,   7,  14,   5,  14,   3,   1,  17,  30,   0,  /* "cablesystems" 58038 */
     12,   2,   9,   1,   7,   3,   4,  18,  13,   0,  /* "cabletron" 58048 */
     12,   2,   9,   1,   7,  22,   5,  43,   1,  13,   0,  /* "cablevision" 58059 */
     12,  34,   9,  25,   0,  /* "cabo" 58064 */
     24,   9,  27,   0,  /* "cabok" 58068 */
     12,   1,   9,  29,  20,   1,   7,   0,  /* "caboodle" 58076 */
     12,   1,   9,  29,  14,   0,  /* "caboose" 58082 */
     12,   1,   9,  29,  14,   1,  30,   0,  /* "cabooses" 58090 */
     12,  24,   9,   1,   3,  31,  40,   0,  /* "cabotage" 58098 */
     12,  24,   9,   4,   1,   7,   0,  /* "cabral" 58105 */
     12,  19,   9,   4,   8,   7,  15,  14,   0,  /* "cabrales" 58114 */
     12,   1,   9,   4,   8,   7,   0,  /* "cabrall" 58121 */
     12,   1,   9,   4,   2,  13,  30,   0,  /* "cabranes" 58129 */
     12,  19,   9,   4,  21,   4,   1,   0,  /* "cabrera" 58137 */
     12,   1,   9,   4,  23,  13,  26,   0,  /* "cabrini" 58145 */
     12,  24,   9,   4,  26,  27,   7,   2,   0,  /* "cabriolet" 58154 */
     12,  24,   9,  30,   0,  /* "cabs" 58159 */
     12,  24,  12,   0,  /* "cac" 58163 */
     12,  24,  12,   1,  14,   0,  /* "cacace" 58169 */
     12,   1,  12,   8,  14,  26,   0,  /* "cacaci" 58176 */
     12,   1,  12,   2,  27,   0,  /* "cacao" 58182 */
     12,  19,  12,   8,  17,   1,  14,   0,  /* "caccamise" 58190 */
     12,  19,  12,   8,  17,  27,   0,  /* "caccamo" 58197 */
     12,  19,  12,   1,  22,   8,   7,  26,   0,  /* "caccavale" 58206 */
     12,   8,  42,   1,   0,  /* "caccia" 58211 */
     12,  19,  42,   1,   3,  18,   4,  26,   0,  /* "cacciatore" 58220 */
     12,  19,  14,  21,   4,  15,  14,   0,  /* "caceres" 58228 */
     12,  24,  33,   0,  /* "cache" 58232 */
     12,  24,  33,   1,  30,   0,  /* "caches" 58238 */
     12,  24,  33,  28,   0,  /* "cachet" 58243 */
     12,  19,  42,  25,   6,  27,   0,  /* "cacioppo" 58250 */
     12,  24,  12,   1,   7,   0,  /* "cackle" 58256 */
     12,  24,  12,   1,   7,  31,  32,   0,  /* "cackling" 58264 */
     12,  24,  12,   1,   7,  20,   0,  /* "cacld" 58271 */
     12,  34,  12,   8,  37,   1,  13,  26,   0,  /* "cacophony" 58280 */
     12,  24,  12,   3,  39,   0,  /* "cacti" 58286 */
     12,  24,  20,   0,  /* "cad" 58290 */
     12,   8,  20,   1,   0,  /* "cada" 58295 */
     12,  24,  20,   1,  17,   0,  /* "cadam" 58301 */
     12,   1,  20,  24,  22,  10,   0,  /* "cadaver" 58308 */
     12,   1,  20,  24,  22,  10,  30,   0,  /* "cadavers" 58316 */
     12,  24,  20,   1,   7,   0,  /* "caddell" 58322 */
     12,   2,  20,   0,  /* "cade" 58326 */
     12,  19,  20,   2,   7,   0,  /* "cadell" 58332 */
     12,   1,  20,  23,  13,   1,   0,  /* "cadena" 58339 */
     12,   2,  20,   1,  13,  14,   0,  /* "cadence" 58346 */
     12,   2,  20,   1,  13,  14,   1,  30,   0,  /* "cadences" 58355 */
     12,   2,  20,   1,  13,  38,  21,  20,   0,  /* "cadenhead" 58364 */
     12,   1,  20,  21,   3,  14,   0,  /* "cadets" 58371 */
     12,  24,  20,  26,  27,   0,  /* "cadieux" 58377 */
     12,  24,  20,   1,   7,  24,  12,   0,  /* "cadillac" 58385 */
     12,  24,  20,   1,   7,  24,  12,  14,   0,  /* "cadillacs" 58394 */
     12,   1,  20,  23,  30,   0,  /* "cadiz" 58400 */
     12,   2,  20,   1,   7,   0,  /* "cadle" 58406 */
     12,  24,  20,  13,  21,   3,  31,  12,  14,   0,  /* "cadnetix" 58416 */
     12,  19,  20,  27,  11,   8,  13,   0,  /* "cadogan" 58424 */
     12,  24,  20,  10,  15,   3,   0,  /* "cadorette" 58431 */
     12,   1,  20,  18,   3,   0,  /* "cadotte" 58437 */
     12,  24,  20,   4,  26,   0,  /* "cadre" 58443 */
     12,  24,  20,   4,  26,  30,   0,  /* "cadres" 58450 */
     12,  24,  20,  14,   0,  /* "cads" 58455 */
     12,   2,  20,  26,   0,  /* "cady" 58460 */
     12,  24,  13,   0,  /* "caen" 58464 */
     14,  23,  30,  10,   0,  /* "caesar" 58469 */
     12,   2,  14,  10,  23,  13,   0,  /* "caesarean" 58476 */
     12,   2,  14,  10,  23,  13,  30,   0,  /* "caesareans" 58484 */
     14,  23,  30,  10,  30,   0,  /* "caesars" 58490 */
     12,   1,   3,   8,  13,  27,   0,  /* "caetano" 58497 */
     12,   1,  37,   2,   0,  /* "cafe" 58502 */
     12,  24,  37,   2,  30,   0,  /* "cafes" 58508 */
     12,  24,  37,   1,   3,   5,   4,  26,   1,   0,  /* "cafeteria" 58518 */
     12,  24,  37,   1,   3,   5,   4,  26,   1,  30,   0,  /* "cafeterias" 58529 */
     12,  24,  37,   1,   3,  39,  30,  10,   0,  /* "cafetizer" 58538 */
     12,  34,  37,  23,  13,   0,  /* "caffeine" 58544 */
     12,  24,  37,  26,  21,   4,  27,   0,  /* "cafiero" 58552 */
     12,   2,  40,   0,  /* "cage" 58556 */
     12,  19,  40,  26,   8,  13,  27,   0,  /* "caggiano" 58564 */
     12,   2,  11,   1,   7,   0,  /* "cagle" 58570 */
     12,   8,  11,  47,   8,  14,   0,  /* "caguas" 58577 */
     12,  24,  38,   1,   7,   1,  13,   0,  /* "cahalan" 58585 */
     12,  24,  38,   1,   7,   0,  /* "cahall" 58591 */
     12,  24,  38,   1,  13,   0,  /* "cahan" 58597 */
     12,   1,  38,   8,  14,   1,   0,  /* "cahasa" 58604 */
     12,   2,  38,   5,   7,   0,  /* "cahill" 58610 */
     12,  24,  13,   0,  /* "cahn" 58614 */
     12,   1,  38,  29,  13,   0,  /* "cahoon" 58620 */
     12,   1,  38,  29,   3,   0,  /* "cahoot" 58626 */
     12,   1,  38,  29,   3,  14,   0,  /* "cahoots" 58633 */
     12,   1,  38,  18,   4,   1,   0,  /* "cahora" 58640 */
     12,   1,  38,  29,   3,   0,  /* "cahouet" 58646 */
     12,  39,   0,  /* "cai" 58649 */
     12,  19,  41,   8,  30,  27,   0,  /* "caiazzo" 58656 */
     12,   1,  42,   2,  20,  27,   0,  /* "caicedo" 58663 */
     12,   2,   7,   0,  /* "cail" 58667 */
     12,   2,   7,  29,   3,   0,  /* "caillouet" 58673 */
     12,   2,  13,   0,  /* "cain" 58677 */
     12,  39,  27,   7,   1,   0,  /* "caiola" 58683 */
     12,  39,   4,  27,   0,  /* "cairo" 58688 */
     12,   2,  30,   1,  13,   0,  /* "caison" 58694 */
     12,   1,  40,  25,   7,   0,  /* "cajole" 58700 */
     12,   1,  40,  25,   7,  20,   0,  /* "cajoled" 58707 */
     12,   1,  40,  25,   7,  31,  32,   0,  /* "cajoling" 58715 */
     12,   2,  40,   1,  13,   0,  /* "cajun" 58721 */
     12,   2,  40,   1,  13,  30,   0,  /* "cajuns" 58728 */
     12,   2,  12,   0,  /* "cake" 58732 */
     12,  24,   7,   0,  /* "cal" 58736 */
     12,   8,   7,   1,   0,  /* "cala" 58741 */
     12,  24,   7,   1,   9,   8,  14,   1,  14,   0,  /* "calabasas" 58751 */
     12,  19,   7,  19,   9,   4,   2,  30,  26,   0,  /* "calabrese" 58761 */
     12,   1,   7,  24,   9,   4,  27,   0,  /* "calabro" 58769 */
     12,  24,   7,   1,  37,   0,  /* "calaf" 58775 */
     12,  24,   7,   1,  38,  34,  13,   0,  /* "calahan" 58783 */
     12,  24,   7,   1,  17,  24,  13,  20,  10,   0,  /* "calamander" 58793 */
     12,  19,   7,  19,  17,   8,   4,  26,   0,  /* "calamari" 58802 */
     12,  19,   7,   8,  17,  26,   0,  /* "calame" 58809 */
     12,  24,   7,   1,  17,  39,  13,   0,  /* "calamine" 58817 */
     12,   1,   7,  24,  17,   1,   3,  26,  30,   0,  /* "calamities" 58827 */
     12,   1,   7,  24,  17,   1,   3,   1,  14,   0,  /* "calamitous" 58837 */
     12,   1,   7,  24,  17,   1,   3,  26,   0,  /* "calamity" 58846 */
     12,   2,   7,   1,  13,   0,  /* "calan" 58852 */
     12,   1,   7,  24,  13,  20,   4,   1,   0,  /* "calandra" 58861 */
     12,   1,   7,  24,  13,  20,   4,  27,   0,  /* "calandro" 58870 */
     12,  34,   7,   1,  22,  21,   4,   1,  30,   0,  /* "calaveras" 58880 */
     12,   8,   7,   1,  47,  28,   0,  /* "calaway" 58887 */
     12,   8,   7,   9,  27,  14,   0,  /* "calbos" 58894 */
     12,  19,   7,  12,   8,  11,  13,  26,   0,  /* "calcagni" 58903 */
     12,  19,   7,  12,   8,  11,  13,  27,   0,  /* "calcagno" 58912 */
     12,  24,   7,  14,   1,  37,  39,  20,   0,  /* "calcified" 58921 */
     12,  24,   7,  14,   1,  37,  39,   0,  /* "calcify" 58929 */
     12,  24,   7,  14,  39,   3,   0,  /* "calcite" 58936 */
     12,  18,   7,  12,   8,  17,   6,   0,  /* "calcomp" 58944 */
     12,  19,   7,  12,  25,   3,  26,   0,  /* "calcote" 58952 */
     12,  24,   7,  12,  41,   1,   7,   2,   3,   0,  /* "calculate" 58962 */
     12,  24,   7,  12,  41,   1,   7,   2,   3,   1,  20,   0,  /* "calculated" 58974 */
     12,  24,   7,  12,  41,   1,   7,   2,   3,  14,   0,  /* "calculates" 58985 */
     12,  24,   7,  12,  41,   1,   7,   2,   3,  31,  32,   0,  /* "calculating" 58997 */
     12,  24,   7,  12,  41,   1,   7,   2,  33,   1,  13,   0,  /* "calculation" 59009 */
     12,  24,   7,  12,  41,   1,   7,   2,  33,   1,  13,  30,   0,  /* "calculations" 59022 */
     12,  24,   7,  12,  41,   1,   7,   2,   3,  10,   0,  /* "calculator" 59033 */
     12,  24,   7,  12,  41,   1,   7,   2,   3,  10,  30,   0,  /* "calculators" 59045 */
     12,  24,   7,  12,  41,   1,   7,   1,  14,   0,  /* "calculus" 59055 */
     12,  19,   7,  20,  21,   4,   1,   0,  /* "caldeira" 59063 */
     12,  24,   7,  20,  21,   4,   1,   0,  /* "caldera" 59071 */
     12,  19,   7,  20,  10,   8,   4,  27,   0,  /* "calderaro" 59080 */
     12,  18,   7,  20,  10,  19,  13,   0,  /* "calderon" 59088 */
     12,  19,   7,  20,  10,  25,  13,  26,   0,  /* "calderone" 59097 */
     12,  18,   7,  20,  10,  47,  51,  20,   0,  /* "calderwood" 59106 */
     12,  24,   7,  20,  36,   4,   0,  /* "caldor" 59113 */
     12,   8,   7,  20,   4,  21,   7,  27,   0,  /* "caldrello" 59122 */
     12,  18,   7,  20,  47,  15,   7,   0,  /* "caldwell" 59130 */
     12,   2,   7,   0,  /* "cale" 59134 */
     12,  24,   7,   5,  37,   0,  /* "calef" 59140 */
     12,  24,   7,   1,  17,   9,  10,  11,   0,  /* "calemburg" 59149 */
     12,  24,   7,   1,  13,  20,  10,   0,  /* "calendar" 59157 */
     12,   1,   7,  21,   4,  27,   0,  /* "calero" 59164 */
     12,  24,  37,   0,  /* "calf" 59168 */
     12,  24,  37,   3,   0,  /* "calfed" 59173 */
     12,  24,   7,  11,  10,  26,   0,  /* "calgary" 59180 */
     12,  24,   7,  11,  36,  13,   0,  /* "calgon" 59187 */
     12,  24,   7,  11,   4,  29,   6,   0,  /* "calgroup" 59195 */
     12,  34,   7,  38,  29,  13,   0,  /* "calhoon" 59202 */
     12,  34,   7,  38,  29,  13,   0,  /* "calhoun" 59209 */
     12,   8,   7,  26,   0,  /* "cali" 59214 */
     12,   8,   7,  26,   1,   0,  /* "calia" 59220 */
     12,  24,   7,   1,  12,  25,   0,  /* "calico" 59227 */
     12,  19,   7,  26,  21,  13,  20,  27,   0,  /* "caliendo" 59236 */
     12,  24,   7,   1,  37,  18,   4,  13,  41,   1,   0,  /* "calif" 59247 */
     12,  19,   7,  26,  37,   8,  13,  27,   0,  /* "califano" 59256 */
     12,  24,   7,   1,  37,  18,   4,  13,  41,   1,   0,  /* "california" 59267 */
     12,  24,   7,   1,  37,  18,   4,  13,  41,   1,  13,   0,  /* "californian" 59279 */
     12,  24,   7,   1,  37,  18,   4,  13,  41,   1,  13,  30,   0,  /* "californians" 59292 */
     12,  24,   7,   1,  40,   5,   4,  26,   0,  /* "caligiuri" 59301 */
     12,   1,   7,   5,   7,   0,  /* "calill" 59307 */
     12,  24,   7,   1,  37,   0,  /* "caliph" 59313 */
     12,   8,   7,  39,  30,   0,  /* "calise" 59319 */
     12,   1,   7,   5,  14,   3,   1,   0,  /* "calista" 59327 */
     12,  24,   7,  39,   3,   0,  /* "calite" 59333 */
     12,  24,   7,  31,  12,  14,   0,  /* "calix" 59340 */
     12,  18,  12,   0,  /* "calk" 59344 */
     12,  18,   7,   0,  /* "call" 59348 */
     12,  18,   7,   1,   9,   1,   7,   0,  /* "callable" 59356 */
     12,  24,   7,   1,  38,  34,  13,   0,  /* "callaghan" 59364 */
     12,  24,   7,   1,  38,  24,  13,   0,  /* "callahan" 59372 */
     12,   1,   7,   2,   0,  /* "callais" 59377 */
     12,  24,   7,   1,  13,   1,  13,   0,  /* "callanan" 59385 */
     12,  19,   7,   8,   4,  26,   0,  /* "callari" 59392 */
     12,   2,   7,   0,  /* "calle" 59396 */
     12,   2,   7,  21,   9,  30,   0,  /* "callebs" 59403 */
     12,  19,   7,  15,  11,   8,   4,  26,   0,  /* "callegari" 59412 */
     12,  19,   7,   2,  41,   1,   0,  /* "calleja" 59419 */
     12,  19,   7,   2,  41,  19,  30,   0,  /* "callejas" 59427 */
     12,  24,   7,   1,  13,   0,  /* "callen" 59433 */
     12,   1,   7,  21,  13,  20,  10,   0,  /* "callender" 59441 */
     12,  24,   7,  10,  26,   0,  /* "callery" 59447 */
     12,   2,   7,  30,   0,  /* "calles" 59452 */
     12,  24,   7,  26,   0,  /* "calley" 59457 */
     12,  18,   7,  26,   0,  /* "callie" 59462 */
     12,   1,   7,   5,  11,   4,   1,  37,  26,   0,  /* "calligraphy" 59472 */
     12,  18,   7,  31,  32,   0,  /* "calling" 59478 */
     12,   1,   7,  39,   1,   6,  23,   0,  /* "calliope" 59486 */
     12,   1,   7,  39,   1,   6,  23,  30,   0,  /* "calliopes" 59495 */
     12,  18,   7,   1,  14,   3,  10,   0,  /* "callister" 59503 */
     12,  24,   7,   1,  14,   3,   0,  /* "calloused" 59510 */
     12,  24,   7,  29,   7,   1,   0,  /* "callula" 59517 */
     12,   8,  17,   0,  /* "calm" 59521 */
     12,   8,   7,  17,   1,   0,  /* "calma" 59527 */
     12,  24,   7,  17,  19,   4,   0,  /* "calmar" 59534 */
     12,   8,   7,  17,   8,   4,  12,   0,  /* "calmark" 59542 */
     12,   8,   7,  17,   8,   4,   3,   0,  /* "calmart" 59550 */
     12,   8,   7,  17,  15,  14,   0,  /* "calmes" 59557 */
     12,  24,   7,  13,   1,  13,   0,  /* "calnan" 59564 */
     12,  24,   7,  13,  26,   0,  /* "calny" 59570 */
     12,   8,   7,  27,   0,  /* "calo" 59575 */
     12,  19,   7,  27,  40,  21,   4,  27,   0,  /* "calogero" 59584 */
     12,   1,   7,  18,   4,  31,  12,   0,  /* "caloric" 59592 */
     12,  24,   7,  10,  26,   0,  /* "calorie" 59598 */
     12,  24,   7,  10,  26,  30,   0,  /* "calories" 59605 */
     12,  19,   7,   3,  19,   9,  26,   8,  13,  27,   0,  /* "caltabiano" 59616 */
     12,  19,   7,   3,  19,  40,  31,   4,  25,  13,  26,   0,  /* "caltagirone" 59628 */
     12,  24,   7,   3,  21,  12,  14,   0,  /* "caltex" 59636 */
     12,  24,   7,  46,   1,   0,  /* "caltha" 59642 */
     12,  24,   7,   3,   1,  13,   0,  /* "calton" 59649 */
     12,  24,   7,   3,   4,  24,  13,  30,   0,  /* "caltrans" 59658 */
     12,  24,   7,  41,   1,  17,  21,   3,   0,  /* "calumet" 59667 */
     12,   1,   7,  29,   3,  30,  26,   0,  /* "calutzi" 59675 */
     12,   1,   7,  29,  30,  26,   0,  /* "caluzzi" 59682 */
     12,  18,   7,  22,   8,  13,  26,   0,  /* "calvani" 59690 */
     12,  24,   7,  22,  10,  26,  30,   0,  /* "calvaries" 59698 */
     12,  24,   7,  22,  10,  26,   0,  /* "calvary" 59705 */
     12,  34,   7,  22,  21,   4,   1,  14,   0,  /* "calveras" 59714 */
     12,  24,  22,  30,   0,  /* "calves" 59719 */
     12,  34,   7,  22,   2,   0,  /* "calvey" 59725 */
     12,   8,   7,  22,  26,   0,  /* "calvi" 59731 */
     12,  19,   7,  22,   5,   7,  27,   0,  /* "calvillo" 59739 */
     12,  24,   7,  22,   1,  13,   0,  /* "calvin" 59746 */
     12,  19,   7,  22,  23,  13,   1,   0,  /* "calvina" 59754 */
     12,  24,  22,  31,  32,   0,  /* "calving" 59760 */
     12,  18,   7,  22,  23,  13,  27,   0,  /* "calvino" 59768 */
     12,   1,   7,   5,   6,  14,  25,   0,  /* "calypso" 59776 */
     12,   1,   7,   5,   6,  14,  25,  30,   0,  /* "calypsos" 59785 */
     12,  24,   7,  31,  12,  14,   0,  /* "calyx" 59792 */
     12,  24,  17,   0,  /* "cam" 59796 */
     12,   1,  17,   8,  42,  27,   0,  /* "camacho" 59803 */
     12,   8,  17,  10,   8,  20,  10,  26,   0,  /* "camaraderie" 59812 */
     12,  19,  17,  19,   4,   8,   3,   1,   0,  /* "camarata" 59821 */
     12,  19,  17,  19,   4,  21,  13,   1,   0,  /* "camarena" 59830 */
     12,  19,  17,  19,   4,   5,   7,  27,   0,  /* "camarillo" 59839 */
     12,   1,  17,  21,   4,  27,   0,  /* "camaro" 59846 */
     12,   1,  17,   8,   4,  27,  14,   0,  /* "camaros" 59854 */
     12,  24,  17,   9,   1,   7,   0,  /* "cambell" 59861 */
     12,  24,  17,   9,   1,  12,  14,   0,  /* "cambex" 59869 */
     12,   2,  17,   9,   4,  31,  40,   0,  /* "cambridge" 59877 */
     12,   2,  17,   9,   4,   5,  40,   6,  18,   4,   3,   0,  /* "cambridgeport" 59889 */
     12,   2,  17,   9,   4,   5,  40,  14,  39,  20,   0,  /* "cambridgeside" 59900 */
     12,  34,  17,  20,  21,  14,   1,  14,   0,  /* "camdessus" 59909 */
     12,   2,  17,   0,  /* "came" 59913 */
     12,  24,  17,  31,  12,  27,   0,  /* "cameco" 59920 */
     12,  19,  17,   2,  41,  27,   0,  /* "camejo" 59927 */
     12,  24,  17,   1,   7,   0,  /* "camel" 59933 */
     12,  24,  17,   1,   7,   8,   3,   0,  /* "camelot" 59941 */
     12,  24,  17,   1,   7,  30,   0,  /* "camels" 59948 */
     12,  24,  17,  26,  25,   0,  /* "cameo" 59954 */
     12,  24,  17,  10,   1,   0,  /* "camera" 59960 */
     12,  24,  17,  10,   1,  17,  15,  13,   0,  /* "cameramen" 59969 */
     12,  24,  17,  10,   1,  30,   0,  /* "cameras" 59976 */
     12,   1,  17,  21,   4,  27,   0,  /* "camero" 59983 */
     12,  24,  17,  10,   1,  13,   0,  /* "cameron" 59990 */
     12,  24,  17,  10,  29,  13,   0,  /* "cameroon" 59997 */
     12,   1,  17,  23,   7,   0,  /* "camille" 60003 */
     12,  19,  17,  26,   7,  21,   4,  26,   0,  /* "camilleri" 60012 */
     12,  19,  17,  26,  13,  23,   3,  26,   0,  /* "caminiti" 60021 */
     12,   1,  17,  23,  13,  27,   0,  /* "camino" 60028 */
     12,  19,  17,   5,   4,  26,   0,  /* "camire" 60035 */
     12,  24,  17,   0,  /* "camm" 60039 */
     12,  24,  17,   1,  12,   0,  /* "cammack" 60045 */
     12,  19,  17,  19,   4,   8,  13,  27,   0,  /* "cammarano" 60054 */
     12,  19,  17,  19,   4,  25,   3,   1,   0,  /* "cammarota" 60063 */
     12,   1,  17,  23,  14,   1,   0,  /* "cammisa" 60070 */
     12,  24,  17,   1,  37,   7,   8,  43,   0,  /* "camouflage" 60079 */
     12,  24,  17,   1,  37,   7,   8,  43,  20,   0,  /* "camouflaged" 60089 */
     12,  24,  17,   1,  37,   7,   8,  43,  31,  32,   0,  /* "camouflaging" 60100 */
     12,  24,  17,   6,   0,  /* "camp" 60105 */
     12,  24,  17,   6,   1,   0,  /* "campa" 60111 */
     12,  34,  17,   6,   2,  13,   0,  /* "campaign" 60118 */
     12,  34,  17,   6,   2,  13,  20,   0,  /* "campaigned" 60126 */
     12,  34,  17,   6,   2,  13,  10,   0,  /* "campaigner" 60134 */
     12,  34,  17,   6,   2,  13,  10,  30,   0,  /* "campaigners" 60143 */
     12,  34,  17,   6,   2,  13,  31,  32,   0,  /* "campaigning" 60152 */
     12,  34,  17,   6,   2,  13,  30,   0,  /* "campaigns" 60160 */
     12,  19,  17,   6,  19,  13,   8,   7,  26,   0,  /* "campanale" 60170 */
     12,  24,  17,   6,   1,  13,  21,   7,   1,   0,  /* "campanella" 60180 */
     12,  19,  17,   6,  19,  13,  21,   7,  26,   0,  /* "campanelli" 60190 */
     12,  24,  17,   6,   8,  13,   1,  14,   0,  /* "campanis" 60199 */
     12,   8,  17,   6,  52,   0,  /* "campau" 60205 */
     12,  24,  17,   9,   1,   7,   0,  /* "campbell" 60212 */
     12,  24,  17,   9,   1,   7,  30,   0,  /* "campbells" 60220 */
     12,  34,  17,   6,  25,   0,  /* "campeau" 60226 */
     12,  24,  17,   6,  15,  14,  23,  13,  27,  14,   0,  /* "campesinos" 60237 */
     12,  24,  17,   6,  37,  39,  10,   0,  /* "campfire" 60245 */
     12,  24,  17,   6,  37,  39,  10,  30,   0,  /* "campfires" 60254 */
     12,  19,  17,   6,  26,  25,  13,  26,   0,  /* "campione" 60263 */
     12,   8,  17,   6,  39,  30,   0,  /* "campise" 60270 */
     12,  19,  17,   6,  23,  14,  26,   0,  /* "campisi" 60278 */
     12,  19,  17,   6,  27,   9,   8,  14,  27,   0,  /* "campobasso" 60288 */
     12,  24,  17,   6,  18,  37,   4,  26,  27,   0,  /* "campofrio" 60298 */
     12,  19,  17,   6,  25,   7,  26,   0,  /* "campoli" 60306 */
     12,  19,  17,   6,  27,   6,  26,   8,  13,  27,   0,  /* "campopiano" 60317 */
     12,  24,  17,   6,  27,  30,   0,  /* "campos" 60324 */
     12,  24,  17,   6,  14,  39,   3,  14,   0,  /* "campsite" 60333 */
     12,  24,  17,   6,  14,  39,   3,  14,   0,  /* "campsites" 60342 */
     12,  19,  17,   6,  29,  30,   8,  13,  27,   0,  /* "campuzano" 60352 */
     12,  24,  17,   4,  26,  30,   0,  /* "camrys" 60359 */
     12,  19,  17,  29,  14,  27,   0,  /* "camuso" 60366 */
     12,  24,  13,   0,  /* "can" 60370 */
     12,  24,  13,   1,   0,  /* "cana" 60375 */
     12,   2,  13,   1,  13,   0,  /* "canaan" 60381 */
     12,   2,  13,   1,  13,  39,   3,   0,  /* "canaanite" 60389 */
     12,  19,  13,   8,  42,  26,   0,  /* "canace" 60396 */
     12,  24,  13,   1,  20,   1,   0,  /* "canada" 60403 */
     12,  24,  13,   1,  20,  21,   4,   0,  /* "canadair" 60411 */
     12,  24,  13,   1,  20,   2,   0,  /* "canaday" 60418 */
     12,   1,  13,  24,  20,  26,  21,  13,   0,  /* "canadienne" 60427 */
     12,   1,  13,  24,   7,   0,  /* "canal" 60433 */
     12,  19,  13,   8,   7,  26,   0,  /* "canale" 60440 */
     12,  24,  13,   1,   7,  30,   0,  /* "canales" 60447 */
     12,   1,  13,  24,   7,  30,   0,  /* "canals" 60454 */
     12,  24,  13,   1,  17,   0,  /* "canam" 60460 */
     12,  24,  13,   1,  13,  20,   2,  11,  47,   1,   0,  /* "canandaigua" 60471 */
     12,  24,  13,   1,  13,  23,   1,   0,  /* "cananea" 60479 */
     12,   1,  13,   8,   4,  20,   0,  /* "canard" 60486 */
     12,   1,  13,  24,  14,   3,   1,   0,  /* "canasta" 60494 */
     12,  24,  13,   1,  22,  24,  13,   0,  /* "canavan" 60502 */
     12,   1,  13,  24,  22,  10,   1,   7,   0,  /* "canaveral" 60511 */
     12,  24,  13,  12,  24,  13,   0,  /* "cancan" 60518 */
     12,  24,  13,  14,   1,   7,   0,  /* "cancel" 60525 */
     12,  19,  13,  42,  23,  15,  13,   0,  /* "cancienne" 60533 */
     12,  19,  13,  42,   5,   7,   1,   0,  /* "cancilla" 60541 */
     12,  24,  13,  14,  26,  27,   0,  /* "cancio" 60548 */
     12,  24,  32,  12,   1,  17,   0,  /* "cancom" 60555 */
     12,   8,  13,  12,   4,  27,   0,  /* "cancro" 60562 */
     12,  24,  32,  12,   1,  13,   0,  /* "cancun" 60569 */
     12,  24,  13,  20,   1,  14,   0,  /* "candace" 60576 */
     12,  19,  13,  20,  15,   7,   8,   4,  26,   1,   0,  /* "candelaria" 60587 */
     12,  19,  13,  20,  15,   7,   8,   4,  26,  27,   0,  /* "candelario" 60598 */
     12,  19,  13,  20,  21,   7,   1,   0,  /* "candella" 60606 */
     12,  24,  13,  20,   1,   7,   1,  13,   0,  /* "candellin" 60615 */
     12,  24,  13,  20,   1,  20,   1,   0,  /* "candida" 60623 */
     12,  24,  13,  20,   1,  20,  28,   3,   0,  /* "candidate" 60632 */
     12,  24,  13,  20,   1,  20,  28,   3,  14,   0,  /* "candidates" 60642 */
     12,  34,  13,  20,  23,  20,  27,   0,  /* "candido" 60650 */
     12,  24,  13,  20,   1,   7,   1,  13,   0,  /* "candilin" 60659 */
     12,  24,  13,  20,  26,   8,   3,  26,   0,  /* "candiotti" 60668 */
     12,  24,  13,  20,   1,   7,   0,  /* "candle" 60675 */
     12,  24,  13,  20,   1,   7,   7,  39,   3,   0,  /* "candlelight" 60685 */
     12,  24,  13,  20,   1,   7,  17,   2,  12,  10,   0,  /* "candlemaker" 60696 */
     12,  24,  13,  20,   1,   7,  10,   0,  /* "candler" 60704 */
     12,  24,  13,  20,   1,   7,  30,   0,  /* "candles" 60712 */
     12,  24,  13,  20,   1,   7,  14,   3,   5,  12,   0,  /* "candlestick" 60723 */
     12,  24,  13,  20,   1,   7,  14,   3,   5,  12,  14,   0,  /* "candlesticks" 60735 */
     12,  24,  13,  20,   7,   5,  33,   0,  /* "candlish" 60743 */
     12,  24,  13,  20,  26,  17,  34,  13,   0,  /* "candyman" 60752 */
     12,   2,  13,   0,  /* "cane" 60756 */
     12,  19,  13,   2,  20,  27,   0,  /* "canedo" 60763 */
     12,   1,  13,  23,  20,  26,   0,  /* "canedy" 60770 */
     12,  19,  13,  15,  22,   8,   4,  26,   0,  /* "canevari" 60779 */
     12,  19,  13,  21,  30,   0,  /* "canez" 60785 */
     12,  19,  32,  11,  15,   7,  25,  14,  26,   0,  /* "cangelosi" 60795 */
     12,  19,  32,  11,  21,  17,  26,   0,  /* "cangemi" 60803 */
     12,  19,  13,  40,   1,   7,  25,  14,  26,   0,  /* "cangialosi" 60813 */
     12,  19,  32,  11,  26,   8,  13,  27,   0,  /* "cangiano" 60822 */
     12,   1,  13,   5,  11,   7,  26,   1,   0,  /* "caniglia" 60831 */
     12,   1,  13,   5,   7,  26,  30,   0,  /* "canilles" 60839 */
     12,   2,  13,  39,  13,   0,  /* "canine" 60845 */
     12,   2,  13,  39,  13,  30,   0,  /* "canines" 60852 */
     12,  19,  13,  23,  13,  27,   0,  /* "canino" 60859 */
     12,  19,  13,  23,   6,  26,   0,  /* "canipe" 60866 */
     12,  24,  13,   0,  /* "cann" 60870 */
     12,  24,  13,   1,   9,   1,  14,   0,  /* "cannabis" 60878 */
     12,  24,  13,   1,  20,  26,   0,  /* "cannady" 60885 */
     12,  19,  13,   8,   3,   1,   0,  /* "cannata" 60892 */
     12,  19,  13,   8,  22,  27,   0,  /* "cannavo" 60899 */
     12,  19,  13,  21,   7,   1,   0,  /* "cannella" 60906 */
     12,  24,  13,   1,   7,   3,   1,  13,   0,  /* "cannelton" 60915 */
     12,  24,  13,   1,   9,   1,   7,   5,  30,   1,  17,   0,  /* "cannibalism" 60927 */
     12,  24,  13,   1,   9,   1,   7,  39,  30,   0,  /* "cannibalize" 60937 */
     12,  24,  13,   1,   9,   1,   7,  39,  30,  31,  32,   0,  /* "cannibalizing" 60949 */
     12,  19,  13,  26,   3,  14,   8,   4,  27,   0,  /* "cannizzaro" 60959 */
     12,  19,  13,  23,  30,  27,   0,  /* "cannizzo" 60966 */
     12,  19,  13,  25,  13,  26,   0,  /* "cannone" 60973 */
     12,  24,  13,   1,  13,  30,   9,  10,  11,   0,  /* "cannonsburg" 60983 */
     12,   8,  13,  27,   0,  /* "cano" 60988 */
     12,   1,  13,  29,   0,  /* "canoe" 60993 */
     12,   1,  13,  29,  20,   0,  /* "canoed" 60999 */
     12,   1,  13,  29,  31,  32,   0,  /* "canoeing" 61006 */
     12,   1,  13,  29,   1,  14,   3,   0,  /* "canoeist" 61014 */
     12,   1,  13,  29,  30,   0,  /* "canoes" 61020 */
     12,  19,  13,  27,  13,  23,  12,  27,   0,  /* "canonico" 61029 */
     12,  24,  13,   1,   6,  26,   0,  /* "canopy" 61036 */
     12,   1,  13,  25,  14,   1,   0,  /* "canosa" 61043 */
     12,  19,  13,  25,  22,   1,   0,  /* "canova" 61050 */
     12,  24,  13,  50,   0,  /* "canoy" 61055 */
     12,  24,  13,   4,  34,  20,   0,  /* "canrad" 61062 */
     12,  24,  13,  30,   0,  /* "cans" 61067 */
     12,  24,  13,  14,   1,   7,  10,   0,  /* "cansler" 61075 */
     12,  24,  13,   3,   0,  /* "cant" 61080 */
     12,  24,  13,   3,   1,   7,  25,   6,   0,  /* "cantaloupe" 61089 */
     12,  24,  13,   3,   1,   7,  25,   6,  14,   0,  /* "cantaloupes" 61099 */
     12,  24,  13,   3,   1,   7,  29,   6,  27,   0,  /* "cantalupo" 61109 */
     12,  34,  13,   3,  24,  32,  12,  10,   1,  14,   0,  /* "cantankerous" 61120 */
     12,  19,  13,   3,   8,   4,   1,   0,  /* "cantara" 61128 */
     12,  34,  13,   3,  23,  13,   0,  /* "canteen" 61135 */
     12,  34,  13,   3,  23,  13,  30,   0,  /* "canteens" 61143 */
     12,  19,  13,   3,  21,   4,  27,   0,  /* "cantero" 61151 */
     12,   8,  13,   3,  21,   4,   1,   0,  /* "canterra" 61159 */
     12,  19,  13,   3,  23,  13,   0,  /* "cantin" 61166 */
     12,  24,  13,   3,   1,   7,   0,  /* "cantle" 61173 */
     12,  24,  13,   3,   7,   1,  13,   0,  /* "cantlin" 61181 */
     12,  19,  13,   3,  25,  13,  26,   0,  /* "cantone" 61189 */
     12,  24,  13,   3,   1,  13,  23,  30,   0,  /* "cantonese" 61198 */
     12,  24,  13,   3,  18,   4,   0,  /* "cantore" 61205 */
     12,  24,  13,   3,   4,   1,   7,   0,  /* "cantrall" 61213 */
     12,  34,  13,   3,   4,  21,   7,   0,  /* "cantrell" 61221 */
     12,   1,  13,   3,   4,  21,   7,   0,  /* "cantrelle" 61229 */
     12,  24,  13,   3,  23,  22,  23,   0,  /* "cantv" 61237 */
     12,  24,  13,   1,   6,   0,  /* "canupp" 61243 */
     12,  24,  13,  22,   1,  14,   0,  /* "canvas" 61250 */
     12,  24,  13,  22,   1,  14,  10,  30,   0,  /* "canvassers" 61259 */
     12,  24,  13,  22,   1,  14,  31,  32,   0,  /* "canvassing" 61268 */
     12,  19,  13,  30,   8,  13,  27,   0,  /* "canzano" 61276 */
     12,  19,  13,  30,  27,  13,  21,   4,  26,   0,  /* "canzoneri" 61286 */
     12,  48,   0,  /* "cao" 61289 */
     12,   2,  29,   3,   0,  /* "caouette" 61294 */
     12,  24,   6,   0,  /* "cap" 61298 */
     12,   2,   6,   1,   9,   5,   7,   1,   3,  26,  30,   0,  /* "capabilities" 61310 */
     12,   2,   6,   1,   9,   5,   7,   1,   3,  26,   0,  /* "capability" 61321 */
     12,   2,   6,   1,   9,   1,   7,   0,  /* "capable" 61329 */
     12,   1,   6,  24,   7,   9,  27,   0,  /* "capalbo" 61337 */
     12,  19,   6,   8,  13,  27,   0,  /* "capano" 61344 */
     12,  19,   6,   8,  14,  27,   0,  /* "capasso" 61351 */
     12,   2,   6,   0,  /* "cape" 61355 */
     12,   1,   6,  23,  14,   0,  /* "capece" 61361 */
     12,   1,   6,  21,  42,  26,   0,  /* "capeci" 61368 */
     12,   2,   6,  38,   8,   4,   3,   0,  /* "capehart" 61376 */
     12,   2,   6,   1,   7,   0,  /* "capel" 61382 */
     12,  19,   6,   2,   7,   0,  /* "capell" 61388 */
     12,  19,   6,  15,   3,   5,   7,  27,   0,  /* "capetillo" 61397 */
     12,   2,   6,   3,  48,  13,   0,  /* "capetown" 61404 */
     12,  24,   6,   1,   7,  21,   4,  26,  30,   0,  /* "capillaries" 61414 */
     12,  24,   6,   1,   7,  21,   4,  26,   0,  /* "capillary" 61423 */
     12,  24,   6,   1,   3,   1,   0,  /* "capita" 61430 */
     12,  24,   6,   1,   3,   1,   7,   5,  30,   1,  17,   0,  /* "capitalism" 61442 */
     12,  24,   6,   1,   3,   1,   7,  39,  30,   0,  /* "capitalize" 61452 */
     12,  24,   6,   1,   3,   1,   7,  39,  30,  20,   0,  /* "capitalized" 61463 */
     12,  24,   6,   1,   3,   1,   7,  39,  30,   1,  30,   0,  /* "capitalizes" 61475 */
     12,  24,   6,   1,   3,   1,   7,  39,  30,  31,  32,   0,  /* "capitalizing" 61487 */
     12,  24,   6,   5,   3,   1,  13,   0,  /* "capitan" 61495 */
     12,  19,   6,  26,   3,   8,  13,  27,   0,  /* "capitano" 61504 */
     12,  19,   6,  23,   3,  27,   0,  /* "capito" 61511 */
     12,  24,   6,   1,   3,  25,   7,  39,  13,   0,  /* "capitoline" 61521 */
     12,   1,   6,   5,  42,  29,   7,   2,   3,   0,  /* "capitulate" 61531 */
     12,   1,   6,   5,  42,   1,   7,   2,   3,   1,  20,   0,  /* "capitulated" 61543 */
     12,   1,   6,   5,  42,   1,   7,   2,  33,   1,  13,   0,  /* "capitulation" 61555 */
     12,  19,   6,  23,   3,  14,  26,   0,  /* "capizzi" 61563 */
     12,   2,   6,   1,   7,   0,  /* "caple" 61569 */
     12,   2,   6,   1,   7,  30,   0,  /* "caples" 61576 */
     12,  24,   6,   7,  26,   0,  /* "capley" 61582 */
     12,   2,   6,   1,   7,  31,  32,  10,   0,  /* "caplinger" 61591 */
     12,   8,   6,  27,   0,  /* "capo" 61596 */
     12,  19,   6,  27,   9,  26,   8,  13,  12,  27,   0,  /* "capobianco" 61607 */
     12,   2,   6,   8,  13,   0,  /* "capon" 61613 */
     12,   1,   6,  25,  13,   0,  /* "capone" 61619 */
     12,  19,   6,  27,  13,  23,  11,   4,  27,   0,  /* "caponigro" 61629 */
     12,  19,   6,  36,   4,   8,   7,  26,   0,  /* "caporale" 61638 */
     12,  19,   6,  36,   4,   8,  14,  27,   0,  /* "caporaso" 61647 */
     12,   1,   6,  25,   3,   1,  13,   0,  /* "capoten" 61655 */
     12,   1,   6,   8,  30,  26,   0,  /* "capozzi" 61662 */
     12,  19,   6,  27,   3,  14,  25,   7,  26,   0,  /* "capozzoli" 61672 */
     12,  24,   6,   0,  /* "capp" 61676 */
     12,  19,   6,  19,  20,  25,  13,   1,   0,  /* "cappadona" 61685 */
     12,  19,   6,  19,   4,  21,   7,  26,   0,  /* "capparelli" 61694 */
     12,  24,   6,   3,   0,  /* "capped" 61699 */
     12,  24,   6,   1,   7,   0,  /* "cappel" 61705 */
     12,  19,   6,  15,   7,  21,   3,  26,   0,  /* "cappelletti" 61714 */
     12,  24,   6,  10,   0,  /* "capper" 61719 */
     12,  19,   6,  26,  21,   7,  27,   0,  /* "cappiello" 61727 */
     12,  24,   6,  29,  42,  23,  13,  27,   0,  /* "cappuccino" 61736 */
     12,  19,   6,  29,  42,  26,  27,   0,  /* "cappuccio" 61744 */
     12,  24,   6,   4,   1,   0,  /* "capra" 61750 */
     12,   1,   6,   4,  23,  14,   0,  /* "caprice" 61757 */
     12,   1,   6,   4,   5,  33,   1,  14,   0,  /* "capricious" 61766 */
     12,   1,   6,   4,   5,  33,   1,  14,   7,  26,   0,  /* "capriciously" 61777 */
     12,  24,   6,   4,   1,  12,  36,   4,  13,   0,  /* "capricorn" 61787 */
     12,  19,   6,   4,  26,  25,   3,  26,   0,  /* "capriotti" 61796 */
     12,  24,   6,  14,   0,  /* "caps" 61801 */
     12,  24,   6,  14,  39,  30,   0,  /* "capsize" 61808 */
     12,  24,   6,  14,  39,  30,  20,   0,  /* "capsized" 61816 */
     12,  24,   6,  14,   3,   1,  13,   0,  /* "capstan" 61824 */
     12,  34,   6,   3,   5,  22,   1,   3,  26,   0,  /* "captivity" 61834 */
     12,  24,   6,  41,  29,   1,   0,  /* "capua" 61841 */
     12,  19,   6,  29,   8,  13,  27,   0,  /* "capuano" 61849 */
     12,  19,   6,  29,   3,  26,   0,  /* "caputi" 61856 */
     12,  19,   6,  29,   3,  27,   0,  /* "caputo" 61863 */
     12,  24,   6,  47,  21,   7,   0,  /* "capwell" 61870 */
     12,  24,  12,   0,  /* "caq" 61874 */
     12,   8,   4,   0,  /* "car" 61878 */
     12,  21,   4,   1,   0,  /* "cara" 61883 */
     12,  10,  24,   9,   1,  40,   1,   7,   0,  /* "carabajal" 61892 */
     12,   8,   4,   1,  12,   8,   4,   1,   0,  /* "caracara" 61901 */
     12,  10,   8,  12,   1,  14,   0,  /* "caracas" 61908 */
     12,  19,   4,  19,  12,  42,  25,   7,  27,   0,  /* "caracciolo" 61918 */
     12,  19,   4,  19,  20,  23,  13,  26,   0,  /* "caradine" 61927 */
     12,  19,   4,  19,  20,  25,  13,   1,   0,  /* "caradonna" 61936 */
     12,  21,   4,   1,  37,   2,   3,   0,  /* "carafate" 61944 */
     12,  24,   4,   1,  17,   8,  13,  20,  26,   0,  /* "caramandi" 61954 */
     12,  21,   4,   1,  17,   1,   7,   0,  /* "caramel" 61962 */
     12,  21,   4,   1,  17,   1,   7,  39,  30,   0,  /* "caramelize" 61972 */
     12,  21,   4,   1,  17,   1,   7,  39,  30,  20,   0,  /* "caramelized" 61983 */
     12,  19,   4,  19,  32,  11,  21,   7,  27,   0,  /* "carangelo" 61993 */
     12,  19,   4,   8,  13,  27,   0,  /* "carano" 62000 */
     12,  21,   4,   1,   3,   0,  /* "carat" 62006 */
     12,  21,   4,   1,   3,  14,   0,  /* "carats" 62013 */
     12,  24,   4,   1,  22,   1,   0,  /* "carava" 62020 */
     12,  24,   4,   1,  22,  24,  13,   0,  /* "caravan" 62028 */
     12,  24,   4,   1,  22,  24,  13,  30,   0,  /* "caravans" 62037 */
     12,  21,   4,   1,  22,  21,   7,   0,  /* "caravel" 62045 */
     12,  21,   4,   1,  22,  21,   7,   0,  /* "caravelle" 62053 */
     12,  19,   4,   8,  22,  26,  27,   0,  /* "caraveo" 62061 */
     12,  24,   4,   1,  47,  34,  13,   0,  /* "carawan" 62069 */
     12,  19,   4,   9,  19,  41,  24,   7,   0,  /* "carbajal" 62078 */
     12,  19,   4,   9,   8,   7,  27,   0,  /* "carballo" 62086 */
     12,   8,   4,   9,  15,   4,  26,   0,  /* "carbary" 62094 */
     12,   8,   4,   9,  18,   0,  /* "carbaugh" 62100 */
     12,   8,   4,   9,  39,  20,   0,  /* "carbide" 62107 */
     12,   8,   4,   9,  39,  13,   0,  /* "carbine" 62114 */
     12,   8,   4,   9,  27,  38,  39,  20,   4,   2,   3,   0,  /* "carbohydrate" 62126 */
     12,   8,   4,   9,  27,  38,  39,  20,   4,  28,   3,  14,   0,  /* "carbohydrates" 62139 */
     12,  19,   4,   9,  27,  13,   8,   4,   1,   0,  /* "carbonara" 62149 */
     12,  19,   4,   9,  27,  13,   8,   4,  27,   0,  /* "carbonaro" 62159 */
     12,  19,   4,   9,  25,  13,  26,   0,  /* "carboni" 62167 */
     12,   8,   4,   9,   1,  13,   5,  37,  10,   1,  14,   0,  /* "carboniferous" 62179 */
     12,   8,   4,   9,   1,  13,  39,  30,   0,  /* "carbonize" 62188 */
     12,   8,   4,   9,   1,  13,  39,  30,  20,   0,  /* "carbonized" 62198 */
     12,   8,   4,   9,  41,  10,  21,   3,   0,  /* "carburete" 62207 */
     12,   8,   4,   9,  41,  10,  21,   3,   1,  20,   0,  /* "carbureted" 62218 */
     12,   8,   4,   9,  41,  10,  23,  33,   1,  13,   0,  /* "carburetion" 62229 */
     12,   8,   4,   9,  10,   2,   3,  10,   0,  /* "carburetor" 62238 */
     12,   8,   4,   9,  10,   2,   3,  10,  30,   0,  /* "carburetors" 62248 */
     12,  19,   4,  14,   5,  13,   1,  40,   1,  13,   0,  /* "carcinogen" 62259 */
     12,   8,   4,  14,   1,  13,  27,  40,  21,  13,  31,  12,   0,  /* "carcinogenic" 62272 */
     12,  19,   4,  14,   5,  13,   1,  40,   1,  13,  30,   0,  /* "carcinogens" 62284 */
     12,   8,   4,  14,   1,  13,  25,  17,   1,   0,  /* "carcinoma" 62294 */
     12,  19,   4,  42,  25,  13,  26,   0,  /* "carcione" 62302 */
     12,   8,   4,  20,   0,  /* "card" 62307 */
     12,  19,   4,  20,  19,   4,  21,   7,  26,   0,  /* "cardarelli" 62317 */
     12,  19,   4,  20,   2,   7,   0,  /* "cardell" 62324 */
     12,  19,   4,  20,  23,  13,   1,  14,   0,  /* "cardenas" 62333 */
     12,   8,   4,  20,  23,   7,   0,  /* "cardiel" 62340 */
     12,  19,   4,  20,  26,  13,   8,   7,  26,   0,  /* "cardinale" 62350 */
     12,  19,   4,  20,  26,  13,   8,   7,  26,   0,  /* "cardinali" 62360 */
     12,   8,   4,  20,  26,  27,   6,  45,   7,  17,   1,  13,  21,   4,  26,   0,  /* "cardiopulmonary" 62376 */
     12,   8,   4,  20,  26,  27,  22,  24,  14,  12,  41,   1,   7,  10,   0,  /* "cardiovascular" 62391 */
     12,   8,   4,  20,   1,  30,  21,  17,   0,  /* "cardizem" 62400 */
     12,   8,   4,  20,  25,   1,  13,   0,  /* "cardoen" 62408 */
     12,  19,   4,  20,  25,  13,  26,   0,  /* "cardone" 62416 */
     12,  19,   4,  20,  29,  13,   0,  /* "cardoon" 62423 */
     12,  19,   4,  20,  29,  42,  26,   0,  /* "carducci" 62431 */
     12,  21,   4,   0,  /* "care" 62435 */
     12,   1,   4,  23,   4,   1,  30,   1,  17,   0,  /* "careerism" 62445 */
     12,  10,   5,   4,   5,  14,   3,   0,  /* "careerist" 62453 */
     12,  10,   5,   4,   5,  14,   3,  14,   0,  /* "careerists" 62462 */
     12,  19,   4,  21,   7,   0,  /* "carel" 62468 */
     12,  21,   4,   7,   1,  14,   0,  /* "careless" 62475 */
     12,  21,   4,   7,   1,  14,   7,  26,   0,  /* "carelessly" 62484 */
     12,  21,   4,   7,   1,  14,  13,   1,  14,   0,  /* "carelessness" 62494 */
     12,  21,   4,  21,   7,  27,   0,  /* "carello" 62501 */
     12,  24,   4,   1,   7,  19,  12,   0,  /* "carelock" 62509 */
     12,  21,   4,  23,  13,   1,   0,  /* "carena" 62516 */
     12,  21,   4,   6,   7,  35,  14,   0,  /* "careplus" 62524 */
     12,  10,  21,  14,   0,  /* "caress" 62529 */
     12,   8,   4,  15,  14,   0,  /* "caresse" 62535 */
     12,  10,  21,  14,  31,  32,   0,  /* "caressing" 62542 */
     12,  21,   4,   3,   2,  12,  10,   0,  /* "caretaker" 62550 */
     12,  21,   4,   3,   2,  12,  10,  30,   0,  /* "caretakers" 62559 */
     12,  21,   4,  41,  29,  13,   1,   3,   0,  /* "careunit" 62568 */
     12,  24,   4,  29,   0,  /* "carew" 62573 */
     12,  19,   4,  37,   8,  11,  13,  27,   0,  /* "carfagno" 62582 */
     12,  19,   4,  37,  18,   4,   1,   0,  /* "carfora" 62590 */
     12,  19,   4,  11,  24,   7,   0,  /* "cargal" 62597 */
     12,   8,   4,  40,   1,   7,   0,  /* "cargile" 62604 */
     12,   8,   4,  11,  25,   0,  /* "cargo" 62610 */
     12,   8,   4,  11,  25,  30,   0,  /* "cargoes" 62617 */
     12,   8,   4,  11,   1,  13,  18,  37,   0,  /* "cargonoff" 62626 */
     12,   8,   4,  11,  25,  30,   0,  /* "cargos" 62633 */
     12,   8,   4,  38,   8,   4,   3,   0,  /* "carhart" 62641 */
     12,  10,   5,   9,  26,   1,  13,   0,  /* "caribbean" 62649 */
     12,  21,   4,  23,   9,   0,  /* "caribe" 62655 */
     12,  21,   4,   1,   9,  29,   0,  /* "caribou" 62662 */
     12,  21,   4,   1,  12,   1,  42,  10,   0,  /* "caricature" 62671 */
     12,  10,   5,  12,   1,  42,  10,  20,   0,  /* "caricatured" 62680 */
     12,  10,   5,  12,   1,  42,  10,  30,   0,  /* "caricatures" 62689 */
     12,  21,   4,   1,  12,   1,  42,  10,   1,  14,   3,   0,  /* "caricaturist" 62701 */
     12,  19,   4,  23,  12,  27,   0,  /* "carico" 62708 */
     12,  21,   4,  31,  12,   8,  17,   0,  /* "caricom" 62716 */
     12,  19,   4,  26,  21,   7,  27,   0,  /* "cariello" 62724 */
     12,  24,   4,  31,  11,  13,   1,  13,   0,  /* "carignan" 62733 */
     12,  24,   4,  31,  12,  10,   0,  /* "cariker" 62740 */
     12,  21,   4,   1,   7,   8,  13,   0,  /* "carillon" 62748 */
     12,  24,   4,   5,  13,   0,  /* "carin" 62754 */
     12,  19,   4,  23,  13,  26,   0,  /* "carine" 62761 */
     12,  21,   4,  31,  32,   0,  /* "caring" 62767 */
     12,  21,   4,  23,  13,  26,   0,  /* "carinii" 62774 */
     12,  21,   4,  26,  25,  12,   1,   0,  /* "carioca" 62782 */
     12,  24,   4,   5,  14,   0,  /* "caris" 62788 */
     12,  19,   4,  23,  14,   1,   0,  /* "carissa" 62795 */
     12,  19,   4,  23,   3,   1,   0,  /* "carita" 62802 */
     12,  24,   4,   1,  46,  10,  30,   0,  /* "carithers" 62810 */
     12,   8,   4,  40,  24,  12,   0,  /* "carjack" 62817 */
     12,   8,   4,  12,  38,   1,  37,   0,  /* "carkhuff" 62825 */
     12,   8,   4,   7,   0,  /* "carl" 62830 */
     12,   8,   4,   1,   7,   0,  /* "carle" 62836 */
     12,  19,   4,   7,  23,  13,   0,  /* "carleen" 62843 */
     12,   8,   4,   7,  39,  13,  10,   0,  /* "carliner" 62851 */
     12,  19,   4,   7,  23,  13,  26,   0,  /* "carlini" 62859 */
     12,  19,   4,   7,  23,  13,  27,   0,  /* "carlino" 62867 */
     12,  19,   4,   7,  23,  14,  26,   0,  /* "carlisi" 62875 */
     12,  19,   4,   7,  23,   3,   1,   0,  /* "carlita" 62883 */
     12,  19,   4,   7,  23,   3,  27,   0,  /* "carlito" 62891 */
     12,   8,   4,   7,   8,  12,   0,  /* "carlock" 62898 */
     12,  19,   4,   7,  25,  13,  26,   0,  /* "carlone" 62906 */
     12,  19,   4,   7,  25,  13,  26,   0,  /* "carloni" 62914 */
     12,   8,   4,   7,  27,  14,   0,  /* "carlos" 62921 */
     12,  19,   4,   7,  18,   3,   1,   0,  /* "carlotta" 62929 */
     12,   8,   4,   7,  27,   0,  /* "carlough" 62935 */
     12,   8,   4,   7,  25,   0,  /* "carlow" 62941 */
     12,   8,   4,   7,  14,   9,  34,  20,   0,  /* "carlsbad" 62950 */
     12,   8,   4,   7,  30,   9,  10,  11,   0,  /* "carlsberg" 62959 */
     12,   8,   4,   7,  14,   3,  24,   3,   0,  /* "carlstadt" 62968 */
     12,  19,   4,   7,  29,  42,  26,   0,  /* "carlucci" 62976 */
     12,   8,   4,   7,  39,   7,   0,  /* "carlyle" 62983 */
     12,   8,   4,   7,  26,  19,  13,   0,  /* "carlyon" 62991 */
     12,   8,   4,   7,  30,  19,  13,   0,  /* "carlzon" 62999 */
     12,   8,   4,  17,  26,   1,  13,   0,  /* "carmean" 63007 */
     12,  19,   4,  17,  21,   7,   0,  /* "carmel" 63014 */
     12,   8,   4,  17,   1,   7,  39,   3,   0,  /* "carmelite" 63023 */
     12,   8,   4,  17,   1,  13,   0,  /* "carmen" 63030 */
     12,   8,   4,  17,  10,   0,  /* "carmer" 63036 */
     12,   8,   4,  17,  39,  12,   1,   7,   0,  /* "carmichael" 63045 */
     12,   8,   4,  17,  31,  12,   1,   7,   0,  /* "carmickle" 63054 */
     12,   8,   4,  17,  39,  12,   0,  /* "carmike" 63061 */
     12,  19,   4,  17,  23,   3,   1,   0,  /* "carmita" 63069 */
     12,  19,   4,  17,  25,  13,   1,   0,  /* "carmona" 63077 */
     12,   8,   4,  17,  27,  13,  26,   0,  /* "carmony" 63085 */
     12,  19,   4,  17,  29,  33,   0,  /* "carmouche" 63092 */
     12,   8,   4,  17,  50,   0,  /* "carmoy" 63098 */
     12,   8,   4,  13,   0,  /* "carn" 63103 */
     12,   8,   4,  13,   1,  16,  34,  13,   0,  /* "carnathan" 63112 */
     12,  19,   4,  13,   2,  33,   1,  13,   0,  /* "carnation" 63121 */
     12,  19,   4,  13,   2,  33,   1,  13,  30,   0,  /* "carnations" 63131 */
     12,  19,   4,  13,  18,   9,   1,   0,  /* "carnauba" 63139 */
     12,  19,   4,  13,  18,   9,   0,  /* "carnaud" 63146 */
     12,   8,   4,  13,   1,   7,   0,  /* "carneal" 63153 */
     12,   8,   4,  13,   1,  11,  26,   0,  /* "carnegie" 63161 */
     12,   8,   4,  13,   1,  11,  26,  30,   0,  /* "carnegies" 63170 */
     12,  19,   4,  13,  21,   4,  27,   0,  /* "carneiro" 63178 */
     12,   8,   4,  13,   1,   3,   0,  /* "carnett" 63185 */
     12,  19,   4,  13,  28,  22,   8,   7,  28,   0,  /* "carnevale" 63195 */
     12,  19,   4,  13,  23,  13,  26,   0,  /* "carnine" 63203 */
     12,   8,   4,  13,   1,  22,   1,   7,   0,  /* "carnival" 63212 */
     12,   8,   4,  13,   1,  22,   1,   7,  30,   0,  /* "carnivals" 63222 */
     12,   8,   4,  13,  31,  22,  18,   4,   0,  /* "carnivore" 63231 */
     12,   8,   4,  13,   1,  22,  18,   4,  30,   0,  /* "carnivores" 63241 */
     12,  19,   4,  13,   5,  22,  10,   1,  14,   0,  /* "carnivorous" 63251 */
     12,   8,   4,  27,   0,  /* "caro" 63256 */
     12,  21,   4,   1,   9,   0,  /* "carob" 63262 */
     12,  10,  25,  42,   0,  /* "caroche" 63267 */
     12,  24,   4,   1,   7,   0,  /* "carol" 63273 */
     12,  21,   4,   1,   7,  34,  13,   0,  /* "carolan" 63281 */
     12,  10,   8,   7,  12,  27,   0,  /* "carolco" 63288 */
     12,  24,   4,   1,   7,   0,  /* "carole" 63294 */
     12,  21,   4,   1,   7,  39,  13,   1,   0,  /* "carolina" 63303 */
     12,  21,   4,   1,   7,  39,  13,   1,  30,   0,  /* "carolinas" 63313 */
     12,  21,   4,   1,   7,  39,  13,   0,  /* "caroline" 63321 */
     12,  21,   4,   1,   7,   5,  13,  40,  26,   1,  13,   0,  /* "carolingian" 63333 */
     12,  21,   4,  27,   7,   5,  13,  26,   1,  13,   0,  /* "carolinian" 63344 */
     12,  10,   8,   7,   1,  13,   0,  /* "carollan" 63351 */
     12,  10,   8,   7,  27,   0,  /* "carollo" 63357 */
     12,  21,   4,   1,   7,  39,  13,   0,  /* "carolyne" 63365 */
     12,  19,   4,  18,  13,   0,  /* "caron" 63371 */
     12,  10,  25,  13,   0,  /* "carone" 63376 */
     12,  10,   8,  13,   1,   0,  /* "caronna" 63382 */
     12,  10,  25,  14,  26,   0,  /* "carosi" 63388 */
     12,  10,  25,   3,   1,   0,  /* "carota" 63394 */
     12,  21,   4,   1,   3,  23,  13,   0,  /* "carotene" 63402 */
     12,  19,   4,  27,   3,  15,  13,  29,   3,  27,   0,  /* "carotenuto" 63413 */
     12,  10,   8,   3,   1,  20,   0,  /* "carotid" 63420 */
     12,  10,  48,  30,   0,  /* "carouse" 63425 */
     12,  21,   4,   1,  14,  21,   7,   0,  /* "carousel" 63433 */
     12,  10,  48,  30,  31,  32,   0,  /* "carousing" 63440 */
     12,  24,   4,  27,   0,  /* "carow" 63445 */
     12,  10,   8,  30,   1,   0,  /* "carozza" 63451 */
     12,   8,   4,   6,   0,  /* "carp" 63456 */
     12,  19,   4,   6,  21,  13,  42,  31,  12,   0,  /* "carpencic" 63466 */
     12,  19,   4,   6,  15,  13,  23,   3,  27,   0,  /* "carpenito" 63476 */
     12,  19,   4,   6,  15,  13,   3,   5,   4,  26,   0,  /* "carpentieri" 63487 */
     12,   8,   4,   6,   1,   3,   9,  24,  11,  10,   0,  /* "carpetbagger" 63498 */
     12,   8,   4,   6,   1,   3,   9,  24,  11,  10,  30,   0,  /* "carpetbaggers" 63510 */
     12,   8,   4,   6,  31,  32,   0,  /* "carping" 63517 */
     12,   8,   4,   6,  26,  27,   0,  /* "carpio" 63524 */
     12,   8,   4,   6,  29,   7,   0,  /* "carpool" 63531 */
     12,   8,   4,   0,  /* "carr" 63535 */
     12,   8,   4,   1,   0,  /* "carra" 63540 */
     12,  24,   4,   1,  11,  38,  10,   0,  /* "carragher" 63548 */
     12,  24,   4,   1,  38,  10,   0,  /* "carraher" 63555 */
     12,   8,   4,   8,  13,  27,   0,  /* "carrano" 63562 */
     12,   8,   4,   8,   4,   1,   0,  /* "carrara" 63569 */
     12,  24,   4,   1,  30,   0,  /* "carras" 63575 */
     12,  21,   4,   1,  14,  12,  21,   7,   0,  /* "carrasquel" 63584 */
     12,  21,   4,   1,  14,  12,   5,   7,  27,   0,  /* "carrasquillo" 63594 */
     12,  24,   4,   1,  47,   2,   0,  /* "carraway" 63601 */
     12,   8,   4,   0,  /* "carre" 63605 */
     12,  21,   4,  31,  12,  10,   0,  /* "carreker" 63612 */
     12,  24,   4,   1,   7,   0,  /* "carrel" 63618 */
     12,  19,   4,  28,  18,  13,   0,  /* "carreon" 63625 */
     12,  19,   4,  21,   4,  19,  30,   0,  /* "carreras" 63633 */
     12,  19,   4,  21,   4,  28,   0,  /* "carrere" 63640 */
     12,   8,   4,  21,   4,  27,   0,  /* "carrero" 63647 */
     12,  21,   4,  26,   0,  /* "carrey" 63652 */
     12,  21,   4,  26,   1,  13,   0,  /* "carrian" 63659 */
     12,  21,   4,  31,  12,   0,  /* "carrick" 63665 */
     12,  19,   4,  23,  12,  27,   0,  /* "carrico" 63672 */
     12,  21,   4,  26,   0,  /* "carrie" 63677 */
     12,  19,   4,   5,   4,  26,   0,  /* "carriere" 63684 */
     12,  19,   4,   5,   4,  27,   0,  /* "carriero" 63691 */
     12,  24,   4,  31,  40,  10,   0,  /* "carriger" 63698 */
     12,  24,   4,  31,  11,   0,  /* "carrigg" 63704 */
     12,  10,   5,   7,  27,   0,  /* "carrillo" 63710 */
     12,  21,   4,  31,  32,   3,   1,  13,   0,  /* "carrington" 63719 */
     12,   8,   4,  23,  13,  27,   0,  /* "carrino" 63726 */
     12,  21,   4,  26,   1,  13,   0,  /* "carrion" 63733 */
     12,  24,   4,   1,  14,   5,  13,   0,  /* "carrisyn" 63741 */
     12,  24,   4,   1,  46,  10,  30,   0,  /* "carrithers" 63749 */
     12,  19,   4,  26,  30,   8,   7,  15,  14,   0,  /* "carrizales" 63759 */
     12,   8,   4,  27,   0,  /* "carro" 63764 */
     12,  24,   4,   1,   7,   0,  /* "carroll" 63770 */
     12,  21,   4,   1,   7,   3,   1,  13,   0,  /* "carrollton" 63779 */
     12,  21,   4,   1,  14,  21,   7,   0,  /* "carrousel" 63787 */
     12,  19,   4,  25,  30,   1,   0,  /* "carrozza" 63794 */
     12,   8,   4,  29,   9,   1,   0,  /* "carrubba" 63801 */
     12,  24,   4,  29,  16,   0,  /* "carruth" 63807 */
     12,  10,  35,  46,  10,  30,   0,  /* "carruthers" 63814 */
     12,  24,   4,  26,   0,  /* "carry" 63819 */
     12,  24,   4,  26,  24,  13,   0,  /* "carryanne" 63826 */
     12,  24,   4,  26,  31,  32,   0,  /* "carrying" 63833 */
     12,  21,   4,  41,  25,  22,  10,   0,  /* "carryover" 63841 */
     12,   8,   4,  30,   0,  /* "cars" 63846 */
     12,  19,   4,  14,   3,   8,   4,  37,   1,  13,   0,  /* "carstarphen" 63857 */
     12,  19,   4,  14,   3,  21,  13,  14,   1,  13,   0,  /* "carstensen" 63868 */
     12,   8,   4,   3,   0,  /* "cart" 63873 */
     12,   8,   4,   3,   1,   0,  /* "carta" 63879 */
     12,   8,   4,   3,   1,  40,  23,  13,   1,   0,  /* "cartagena" 63889 */
     12,   8,   4,   3,  39,   1,   0,  /* "cartaya" 63896 */
     12,   8,   4,   3,  26,   0,  /* "cartee" 63902 */
     12,  19,   4,   3,  21,   7,   0,  /* "cartel" 63909 */
     12,  19,   4,   3,  21,   7,  30,   0,  /* "cartels" 63917 */
     12,   8,   4,   3,  10,  15,   3,   0,  /* "carteret" 63925 */
     12,   8,   4,   3,  10,  30,  22,   5,   7,   0,  /* "cartersville" 63935 */
     12,   8,   4,  16,   1,  40,   0,  /* "carthage" 63942 */
     12,   8,   4,  16,   1,  40,   5,  13,  26,   1,  13,   0,  /* "carthaginian" 63954 */
     12,   8,   4,   3,   1,   7,   1,  40,   0,  /* "cartilage" 63963 */
     12,  19,   4,   3,  17,   2,   7,   0,  /* "cartmell" 63971 */
     12,   8,   4,   3,   1,  13,   0,  /* "carton" 63978 */
     12,   8,   4,   3,  25,  13,  21,   4,  27,  14,   0,  /* "cartoneros" 63989 */
     12,   8,   4,   3,   1,  13,  30,   0,  /* "cartons" 63997 */
     12,  19,   4,   3,  29,  13,   0,  /* "cartoon" 64004 */
     12,  19,   4,   3,  29,  13,  31,  32,   0,  /* "cartooning" 64013 */
     12,  19,   4,   3,  29,  13,   1,  14,   3,   0,  /* "cartoonist" 64023 */
     12,  19,   4,   3,  29,  13,   1,  14,   3,  14,   0,  /* "cartoonists" 64034 */
     12,  19,   4,   3,  29,  13,  30,   0,  /* "cartoons" 64042 */
     12,   8,   4,   3,   4,   1,  40,   0,  /* "cartridge" 64050 */
     12,   8,   4,   3,   4,   1,  40,   1,  30,   0,  /* "cartridges" 64060 */
     12,  19,   4,   3,  29,  14,  26,  21,   7,  27,   0,  /* "cartusciello" 64071 */
     12,   8,   4,   3,   4,  39,   3,   0,  /* "cartwright" 64079 */
     12,  19,   4,  29,  24,  13,   1,   0,  /* "caruana" 64087 */
     12,  19,   4,  29,  42,  26,   0,  /* "carucci" 64094 */
     12,  10,  29,  14,  27,   0,  /* "caruso" 64100 */
     12,  19,   4,  29,  14,  25,  13,  26,   0,  /* "carusone" 64109 */
     12,  24,   4,  29,  16,   0,  /* "caruth" 64115 */
     12,  10,  35,  46,  10,  30,   0,  /* "caruthers" 64122 */
     12,  19,   4,  22,  19,  41,  24,   7,   0,  /* "carvajal" 64131 */
     12,  19,   4,  22,   8,   7,  38,  27,   0,  /* "carvalho" 64140 */
     12,  19,   4,  22,  21,   7,   0,  /* "carvel" 64147 */
     12,  19,   4,  22,   2,   7,   0,  /* "carvell" 64154 */
     12,   8,   4,  22,  26,   0,  /* "carvey" 64160 */
     12,  21,   4,  26,   0,  /* "cary" 64165 */
     12,   8,   4,   5,  13,   0,  /* "caryn" 64171 */
     12,  24,  14,   0,  /* "cas" 64175 */
     12,   8,  14,   1,   0,  /* "casa" 64180 */
     12,  24,  14,   1,   9,   7,  24,  32,  12,   1,   0,  /* "casablanca" 64191 */
     12,  24,  14,   1,  20,   0,  /* "casad" 64197 */
     12,   1,  14,   8,  20,  26,   0,  /* "casady" 64204 */
     12,  19,  14,   8,  11,   4,  34,  13,  20,  26,   0,  /* "casagrande" 64215 */
     12,  19,  14,   8,   7,   0,  /* "casal" 64221 */
     12,  19,  14,   8,   7,  26,   0,  /* "casale" 64228 */
     12,  19,  14,  19,   7,  23,  13,  27,   0,  /* "casalino" 64237 */
     12,  19,  14,   8,   7,  30,   0,  /* "casals" 64244 */
     12,  24,  14,   1,  17,  21,  13,   3,  27,   0,  /* "casamento" 64254 */
     12,  24,  14,   1,  13,  25,  22,   1,   0,  /* "casanova" 64263 */
     12,  19,  14,   8,   4,  15,  14,   0,  /* "casares" 64271 */
     12,  19,  14,   8,  14,   1,   0,  /* "casassa" 64278 */
     12,  24,  14,  36,  30,   0,  /* "casaus" 64284 */
     12,  19,  14,   8,   3,  14,   1,   0,  /* "casazza" 64292 */
     12,  19,  14,  42,   8,   3,  27,   0,  /* "casciato" 64300 */
     12,  24,  14,  26,  27,   0,  /* "cascio" 64306 */
     12,  19,  14,  12,  25,  13,  26,   0,  /* "cascone" 64314 */
     12,   2,  14,   0,  /* "case" 64318 */
     12,  34,  14,   1,   9,   5,   4,   0,  /* "casebeer" 64326 */
     12,  24,  14,   1,   9,  26,  10,   0,  /* "casebier" 64334 */
     12,  28,  14,  23,  13,   0,  /* "casein" 64340 */
     12,   2,  14,   7,  25,  20,   0,  /* "caseload" 64347 */
     12,  24,  14,   1,   7,  25,  20,  30,   0,  /* "caseloads" 64356 */
     12,   1,  14,  21,   4,   1,   0,  /* "casera" 64363 */
     12,  19,  14,  21,   4,   3,   1,   0,  /* "caserta" 64371 */
     12,   1,  14,  21,  14,   1,   0,  /* "casesa" 64378 */
     12,   1,  14,  23,  30,  26,   0,  /* "caseze" 64385 */
     12,  24,  14,  11,   4,   2,  13,   0,  /* "casgrain" 64393 */
     12,  24,  33,   0,  /* "cash" 64397 */
     12,  24,  33,  29,   0,  /* "cashew" 64402 */
     12,  24,  33,  29,  30,   0,  /* "cashews" 64408 */
     12,  34,  33,   5,   4,   0,  /* "cashier" 64414 */
     12,  34,  33,   5,   4,  20,   0,  /* "cashiered" 64421 */
     12,  24,  33,   5,   4,  30,   0,  /* "cashiers" 64428 */
     12,  19,  33,  23,  13,   0,  /* "cashion" 64434 */
     12,  24,  43,  17,  31,   4,   0,  /* "cashmere" 64441 */
     12,  19,  14,  26,   8,  13,  27,   0,  /* "casiano" 64449 */
     12,  19,  14,  23,   1,  30,   0,  /* "casias" 64456 */
     12,   1,  14,   5,   7,  27,   0,  /* "casillo" 64463 */
     12,  24,  14,   1,  17,  23,   4,   0,  /* "casimir" 64471 */
     12,  19,  14,  26,  17,   5,   4,  27,   0,  /* "casimiro" 64480 */
     12,   1,  14,  23,  13,  27,   0,  /* "casino" 64487 */
     12,   1,  14,  23,  13,  27,  30,   0,  /* "casinos" 64495 */
     12,  24,  14,  26,  27,   0,  /* "casio" 64501 */
     12,  24,  14,  12,   0,  /* "cask" 64506 */
     12,  24,  14,   1,   7,  10,   0,  /* "casler" 64513 */
     12,   8,  14,  27,   0,  /* "caso" 64518 */
     12,  19,  14,  25,   7,   1,   0,  /* "casola" 64525 */
     12,  24,  14,   6,  10,  14,   1,  13,   0,  /* "caspersen" 64534 */
     12,  24,  14,   0,  /* "cass" 64538 */
     12,  19,  14,   8,  20,   1,   0,  /* "cassada" 64545 */
     12,  24,  14,   1,  20,  26,   0,  /* "cassady" 64552 */
     12,   1,  14,  24,  13,  20,   4,   1,   0,  /* "cassandra" 64561 */
     12,   1,  14,  24,  13,  20,   4,   1,  14,   0,  /* "cassandras" 64571 */
     12,  19,  14,   8,  13,  26,   0,  /* "cassani" 64578 */
     12,  19,  14,   8,  13,  27,   0,  /* "cassano" 64585 */
     12,  19,  14,   8,   4,   1,   0,  /* "cassara" 64592 */
     12,  19,  14,  19,   4,  23,  13,  27,   0,  /* "cassarino" 64601 */
     12,  19,  14,   8,   4,  27,   0,  /* "cassaro" 64608 */
     12,  19,  14,   8,   3,   1,   0,  /* "cassata" 64615 */
     12,  24,  14,   1,  22,  23,   3,  26,  30,   0,  /* "cassavetes" 64625 */
     12,  24,  14,   1,   9,   0,  /* "casseb" 64631 */
     12,  19,  14,  21,   7,   1,   0,  /* "cassella" 64638 */
     12,  19,  14,   2,  30,  26,   0,  /* "cassese" 64645 */
     12,  19,  14,  21,   3,   1,   0,  /* "cassetta" 64652 */
     12,   1,  14,  21,   3,   0,  /* "cassette" 64658 */
     12,   1,  14,  21,   3,  14,   0,  /* "cassettes" 64665 */
     12,  24,  14,   1,   3,  26,   0,  /* "cassetty" 64672 */
     12,  24,  33,  26,   1,   0,  /* "cassia" 64678 */
     12,  24,  14,  26,  20,  28,   0,  /* "cassiday" 64685 */
     12,  19,  14,  26,  13,  21,   7,  26,   0,  /* "cassinelli" 64694 */
     12,   1,  14,  23,  13,  26,   0,  /* "cassini" 64701 */
     12,   1,  14,  23,  13,  27,   0,  /* "cassino" 64708 */
     12,  24,  14,   1,  12,   0,  /* "cassock" 64714 */
     12,  19,  14,  25,  13,  26,   0,  /* "cassone" 64721 */
     12,   1,  14,  25,  13,  26,   0,  /* "cassoni" 64728 */
     12,  24,  14,   1,  47,  21,   4,  26,   0,  /* "cassowary" 64737 */
     12,  19,  14,   3,  28,  22,   2,   1,  13,  30,   0,  /* "casstevens" 64748 */
     12,  24,  14,   3,   0,  /* "cast" 64753 */
     12,  24,  14,   3,   1,   0,  /* "casta" 64759 */
     12,  19,  14,   3,   8,  11,  13,   1,   0,  /* "castagna" 64768 */
     12,  19,  14,   3,   8,  11,  13,  27,   0,  /* "castagno" 64777 */
     12,  19,  14,   3,  19,  13,  21,  20,   1,   0,  /* "castaneda" 64787 */
     12,  24,  14,   3,   1,  13,  19,  13,   0,  /* "castanon" 64796 */
     12,  24,  14,   3,   1,  47,   2,   0,  /* "castaway" 64804 */
     12,  24,  14,   3,   1,  47,   2,  30,   0,  /* "castaways" 64813 */
     12,  24,  14,   3,   0,  /* "caste" 64818 */
     12,   2,  14,   3,  26,   7,   0,  /* "casteel" 64825 */
     12,   1,  14,   3,  23,  13,   0,  /* "casteen" 64832 */
     12,   2,  14,   3,   1,   7,   0,  /* "castel" 64839 */
     12,   2,  14,   3,   1,   7,   0,  /* "castell" 64846 */
     12,  19,  14,   3,  15,   7,  24,  13,   1,   0,  /* "castellana" 64856 */
     12,  19,  14,   3,  15,   7,   8,  13,  26,   0,  /* "castellani" 64866 */
     12,  19,  14,   3,  15,   7,   8,  13,  27,   0,  /* "castellano" 64876 */
     12,  19,  14,   3,  28,   7,   8,  13,  27,  30,   0,  /* "castellanos" 64887 */
     12,   2,  14,   3,   1,   7,  36,   0,  /* "castellaw" 64895 */
     12,   1,  14,   3,  21,   7,  27,   0,  /* "castello" 64903 */
     12,   2,  14,   3,   1,   7,  19,  13,   0,  /* "castellon" 64912 */
     12,  19,  14,   3,  15,   7,  29,  42,  26,   0,  /* "castellucci" 64922 */
     12,  19,  14,   3,  15,   7,  29,  42,  26,  27,   0,  /* "castelluccio" 64933 */
     12,   1,  14,   3,  21,   7,  22,  26,   0,  /* "castellvi" 64942 */
     12,  24,  14,   3,   1,  13,   0,  /* "casten" 64949 */
     12,  24,  14,   3,  10,   0,  /* "caster" 64955 */
     12,  24,  14,   3,  10,   7,  39,  13,   0,  /* "casterline" 64964 */
     12,  24,  14,   3,  10,  30,   0,  /* "casters" 64971 */
     12,  24,  14,   3,  14,   0,  /* "castes" 64977 */
     12,  19,  14,   3,  23,  11,   7,  26,   1,   0,  /* "castiglia" 64987 */
     12,  19,  14,   3,  26,  11,   7,  26,  25,  13,  26,   0,  /* "castiglione" 64999 */
     12,  19,  14,   3,   5,   7,   1,   0,  /* "castilla" 65007 */
     12,  19,  14,   3,  26,   7,   2,  41,   1,   0,  /* "castilleja" 65017 */
     12,  24,  14,   3,  23,  27,   0,  /* "castillo" 65024 */
     12,  24,  14,   3,   1,   7,  19,  13,   0,  /* "castillon" 65033 */
     12,  19,  14,   3,  23,  13,  26,   0,  /* "castine" 65041 */
     12,  24,  14,   1,   7,   0,  /* "castle" 65047 */
     12,  24,  14,   1,   7,   9,  21,   4,  26,   0,  /* "castleberry" 65057 */
     12,  24,  14,   1,   7,  17,   1,  13,   0,  /* "castleman" 65066 */
     12,  24,  14,   1,   7,  30,   0,  /* "castles" 65073 */
     12,  24,  14,   3,  18,  37,   0,  /* "castoff" 65080 */
     12,   1,  14,   3,   8,  32,  11,  28,   0,  /* "castonguay" 65089 */
     12,   8,  14,   3,  36,   4,  13,   1,   0,  /* "castorena" 65098 */
     12,  19,  14,   3,  18,   4,  27,   0,  /* "castoro" 65106 */
     12,  24,  14,   3,   4,  31,  40,  19,  13,   0,  /* "castrejon" 65116 */
     12,   1,  14,   3,   4,   5,   7,  41,   1,  13,   0,  /* "castrillon" 65127 */
     12,  34,  14,   3,   4,  27,  13,  25,  22,   1,   0,  /* "castronova" 65138 */
     12,  34,  14,   3,   4,  27,  13,  25,  22,  27,   0,  /* "castronovo" 65149 */
     12,   1,  14,   3,   4,  29,  42,  26,   0,  /* "castrucci" 65158 */
     12,  19,  14,   3,   4,  29,   3,   1,   0,  /* "castruita" 65167 */
     12,  24,  43,   1,  47,   1,   7,   0,  /* "casual" 65175 */
     12,  24,  43,   1,  47,   1,   7,  26,   0,  /* "casually" 65184 */
     12,  24,  43,   1,  47,   1,   7,  13,   1,  14,   0,  /* "casualness" 65195 */
     12,  24,  43,   1,  47,   1,   7,  30,   0,  /* "casuals" 65204 */
     12,  24,  43,   1,  47,   1,   7,   3,  26,  30,   0,  /* "casualties" 65215 */
     12,  24,  43,   1,  47,   1,   7,   3,  26,   0,  /* "casualty" 65225 */
     12,  24,  30,  47,  21,   7,   0,  /* "caswell" 65232 */
     12,  24,   3,   0,  /* "cat" 65236 */
     12,  24,   3,   1,  12,   7,   5,  14,   1,  17,   0,  /* "cataclysm" 65247 */
     12,  24,   3,   1,  12,  25,  17,   0,  /* "catacomb" 65255 */
     12,  24,   3,   1,  12,  25,  17,  30,   0,  /* "catacombs" 65264 */
     12,   1,   3,  24,  12,   1,  14,  23,  13,  27,  14,   0,  /* "catacosinos" 65276 */
     12,  24,   3,  28,  13,   0,  /* "catain" 65282 */
     12,  24,   3,   1,   7,   1,  13,   0,  /* "catalan" 65290 */
     12,  19,   3,  19,   7,   8,  13,  27,   0,  /* "catalano" 65299 */
     12,  19,   3,  19,   7,  19,  13,  25,   3,  27,   0,  /* "catalanotto" 65310 */
     12,  19,   3,   8,   7,  20,  26,   0,  /* "cataldi" 65318 */
     12,  19,   3,   8,   7,  20,  27,   0,  /* "cataldo" 65326 */
     12,  19,   3,  19,   7,  37,   8,  17,  27,   0,  /* "catalfamo" 65336 */
     12,  24,   3,   1,   7,  36,  11,  20,   0,  /* "cataloged" 65345 */
     12,  24,   3,   1,   7,  19,  11,  31,  32,   0,  /* "cataloging" 65355 */
     12,  24,   3,   1,   7,  25,  13,  41,   1,   0,  /* "catalonia" 65365 */
     12,  24,   3,   1,   7,  39,  30,   0,  /* "catalyze" 65373 */
     12,  24,   3,   1,   7,  39,  30,  20,   0,  /* "catalyzed" 65382 */
     12,   1,   3,  24,  17,  10,   1,  13,  30,   0,  /* "catamarans" 65392 */
     12,  19,   3,  19,  13,   2,  30,  26,   0,  /* "catanese" 65401 */
     12,   1,   3,   2,  13,  41,   1,   0,  /* "catania" 65409 */
     12,  19,   3,   8,  13,  27,   0,  /* "catano" 65416 */
     12,   1,   3,  24,  13,  30,  10,  39,   3,   0,  /* "catanzarite" 65426 */
     12,  19,   3,  19,  13,  30,   8,   4,  27,   0,  /* "catanzaro" 65436 */
     12,  19,   3,  19,   6,   8,  13,  27,   0,  /* "catapano" 65445 */
     12,  24,   3,   1,   6,  35,   7,   3,   0,  /* "catapult" 65454 */
     12,  24,   3,   1,   6,  35,   7,   3,   1,  20,   0,  /* "catapulted" 65465 */
     12,  24,   3,  10,  34,  12,   3,  14,   0,  /* "cataract" 65474 */
     12,  24,   3,  10,  24,  12,   3,  14,   0,  /* "cataracts" 65483 */
     12,   1,   3,  24,  14,   3,   4,   1,  37,  26,   0,  /* "catastrophe" 65494 */
     12,   1,   3,  24,  14,   3,   4,   1,  37,  26,  30,   0,  /* "catastrophes" 65506 */
     12,  24,   3,   1,  14,   3,   4,   8,  37,  31,  12,   0,  /* "catastrophic" 65518 */
     12,   1,   3,  18,   9,   1,   0,  /* "catawba" 65525 */
     12,  24,   3,  12,  18,   7,   0,  /* "catcall" 65532 */
     12,  24,   3,  12,  18,   7,  30,   0,  /* "catcalls" 65540 */
     12,  24,  42,   1,  12,   8,  13,   0,  /* "catchacan" 65548 */
     12,  24,  42,  18,   7,   0,  /* "catchall" 65554 */
     12,   2,   3,   0,  /* "cate" 65558 */
     12,  24,   3,   1,  12,   5,  30,   1,  17,   0,  /* "catechism" 65568 */
     12,  24,   3,   1,  11,   8,   4,  31,  12,   1,   7,   0,  /* "categorical" 65580 */
     12,  24,   3,   1,  11,   8,   4,  31,  12,   7,  26,   0,  /* "categorically" 65592 */
     12,  24,   3,   1,  11,  18,   4,  26,  30,   0,  /* "categories" 65602 */
     12,  24,   3,   1,  11,  10,  39,  30,   0,  /* "categorize" 65611 */
     12,  24,   3,   1,  11,  10,  39,  30,  20,   0,  /* "categorized" 65621 */
     12,  24,   3,   1,  11,  10,  39,  30,   1,  30,   0,  /* "categorizes" 65632 */
     12,  24,   3,   1,  11,  10,  39,  30,  31,  32,   0,  /* "categorizing" 65643 */
     12,  24,   3,   1,  11,  18,   4,  26,   0,  /* "category" 65652 */
     12,   1,   3,  23,  13,   1,   0,  /* "catena" 65659 */
     12,  19,   3,  10,  23,  13,  27,   0,  /* "caterino" 65667 */
     12,  24,   3,   1,   6,   5,   7,  10,   0,  /* "caterpillar" 65676 */
     12,  24,   3,   1,   6,   5,   7,  10,  30,   0,  /* "caterpillars" 65686 */
     12,  24,   3,   1,   6,   5,   7,  10,   0,  /* "caterpiller" 65695 */
     12,  24,  16,   4,   5,  13,   0,  /* "catharine" 65702 */
     12,  24,  16,   4,   5,  13,  30,   0,  /* "catharines" 65710 */
     12,   1,  16,   8,   4,  14,   1,  14,   0,  /* "catharsis" 65719 */
     12,   1,  16,   8,   4,   3,  31,  12,   0,  /* "cathartic" 65728 */
     12,  34,  16,   2,   0,  /* "cathay" 65733 */
     12,  24,  16,  12,  19,   4,   3,   0,  /* "cathcart" 65741 */
     12,   1,  16,  23,  20,   4,   1,   7,   0,  /* "cathedral" 65750 */
     12,   1,  16,  23,  20,   4,   1,   7,  30,   0,  /* "cathedrals" 65760 */
     12,  19,  16,  10,  23,  13,   1,   0,  /* "catherina" 65768 */
     12,  24,  16,  10,   1,  13,   0,  /* "catherine" 65775 */
     12,  24,  46,  10,  17,   1,  13,   0,  /* "catherman" 65783 */
     12,  24,  16,   1,   3,  10,   0,  /* "catheter" 65790 */
     12,  24,  16,   1,   3,  10,  30,   0,  /* "catheters" 65798 */
     12,  24,  16,   1,  17,  10,   0,  /* "cathmor" 65805 */
     12,  24,  16,   7,  31,  12,   0,  /* "catholic" 65812 */
     12,   1,  16,  18,   7,   1,  14,   5,  30,   1,  17,   0,  /* "catholicism" 65824 */
     12,  24,  16,   7,  31,  12,  14,   0,  /* "catholics" 65832 */
     12,   1,   3,  23,  40,   1,   0,  /* "catija" 65839 */
     12,  19,   3,  23,  13,  27,   0,  /* "catino" 65846 */
     12,  24,   3,  12,   1,  13,  30,   0,  /* "catkins" 65854 */
     12,  24,   3,   7,  31,  40,   0,  /* "catledge" 65861 */
     12,  24,   3,   7,  21,   3,   0,  /* "catlett" 65868 */
     12,  24,   3,   7,  39,  12,   0,  /* "catlike" 65875 */
     12,  24,   3,  13,   1,   6,   0,  /* "catnip" 65882 */
     12,   2,   3,  27,   0,  /* "cato" 65887 */
     12,   1,   3,  25,   7,  31,  12,   1,   0,  /* "catolica" 65896 */
     12,  24,   3,   1,  13,   0,  /* "caton" 65902 */
     12,  24,   3,   4,  24,  17,   9,  25,  13,   0,  /* "catrambone" 65912 */
     12,  24,   3,   4,   1,   3,   0,  /* "catrett" 65919 */
     12,  24,   3,  14,   0,  /* "cats" 65924 */
     12,  21,  42,   1,   6,   0,  /* "catsup" 65930 */
     12,  24,   3,   0,  /* "catt" 65934 */
     12,  24,   3,   1,  13,  34,  42,   0,  /* "cattanach" 65942 */
     12,  19,   3,   8,  13,  26,  27,   0,  /* "cattaneo" 65950 */
     12,  19,   3,   8,  13,  26,   0,  /* "cattani" 65957 */
     12,   1,   3,  21,   7,   0,  /* "cattell" 65963 */
     12,  24,   3,  10,  18,   7,   0,  /* "catterall" 65970 */
     12,  24,   3,  10,  14,   1,  13,   0,  /* "catterson" 65978 */
     12,  24,   3,  10,   3,   1,  13,   0,  /* "catterton" 65986 */
     12,  24,   3,   1,   7,   0,  /* "cattle" 65992 */
     12,  24,   3,   1,   7,  17,   1,  13,   0,  /* "cattlemen" 66001 */
     12,   1,   3,  25,   7,  31,  12,   1,   0,  /* "cattolica" 66010 */
     12,  18,   9,   1,   7,   0,  /* "cauble" 66016 */
     12,  36,  12,   2,  43,   1,  13,   0,  /* "caucasian" 66024 */
     12,  36,  12,   2,  43,   1,  13,  30,   0,  /* "caucasians" 66033 */
     12,   8,  12,   1,  14,   0,  /* "caucus" 66039 */
     12,   8,  20,   1,   7,   0,  /* "caudal" 66045 */
     12,  27,  20,  21,   7,   0,  /* "caudell" 66051 */
     12,  18,  20,   1,   7,   0,  /* "caudle" 66057 */
     12,  25,  37,  26,   7,  20,   0,  /* "caufield" 66064 */
     12,   8,   3,   0,  /* "caught" 66068 */
     12,   8,   7,   0,  /* "caul" 66072 */
     12,  18,   7,  20,  10,   0,  /* "caulder" 66078 */
     12,  18,   7,  26,   0,  /* "cauley" 66083 */
     12,  18,   7,  37,  23,   7,  20,   0,  /* "caulfield" 66091 */
     12,   8,   7,   1,  37,   7,  48,  10,   0,  /* "cauliflower" 66100 */
     12,   8,  12,   0,  /* "caulk" 66104 */
     12,  18,  12,  31,  32,   0,  /* "caulking" 66110 */
     12,  18,   7,  12,   5,  13,  30,   0,  /* "caulkins" 66118 */
     12,   8,  30,   1,   3,  31,  22,   0,  /* "causative" 66126 */
     12,  18,  30,   9,  26,   0,  /* "causby" 66132 */
     12,  18,  30,  10,   0,  /* "causer" 66137 */
     12,  18,  30,  47,   2,  30,   0,  /* "causeways" 66144 */
     12,  18,  30,  26,   0,  /* "causey" 66149 */
     12,   8,  33,   1,  13,   0,  /* "caution" 66155 */
     12,   8,  33,   1,  13,  20,   0,  /* "cautioned" 66162 */
     12,   8,  22,   1,   0,  /* "cava" 66167 */
     12,  24,  22,   1,  12,  27,   0,  /* "cavaco" 66174 */
     12,  19,  22,  19,  11,  13,   8,   4,  27,   0,  /* "cavagnaro" 66184 */
     12,  24,  22,   1,   7,  12,   2,  20,   0,  /* "cavalcade" 66193 */
     12,  24,  22,   1,   7,   5,   4,   0,  /* "cavalier" 66201 */
     12,  19,  22,  19,   7,   5,   4,  26,   0,  /* "cavaliere" 66210 */
     12,  19,  22,  19,   7,   5,   4,  26,   0,  /* "cavalieri" 66219 */
     12,  24,  22,   1,   7,   5,   4,   7,  26,   0,  /* "cavalierly" 66229 */
     12,  24,  22,   1,   7,   5,   4,  30,   0,  /* "cavaliers" 66238 */
     12,  19,  22,  19,   7,   8,   4,  27,   0,  /* "cavallaro" 66247 */
     12,  19,  22,  19,   7,  21,   4,  27,   0,  /* "cavallero" 66256 */
     12,   1,  22,  24,   7,  26,   0,  /* "cavalli" 66263 */
     12,   1,  22,  24,   7,  27,   0,  /* "cavallo" 66270 */
     12,   2,  22,   1,  13,   0,  /* "cavan" 66276 */
     12,  24,  22,   1,  13,  34,  11,   0,  /* "cavanagh" 66284 */
     12,  24,  22,   1,  13,   1,   0,  /* "cavanah" 66291 */
     12,  24,  22,   1,  13,  36,   0,  /* "cavanaugh" 66298 */
     12,   8,  22,   1,  13,   1,  14,   0,  /* "cavaness" 66306 */
     12,  19,  22,  19,   3,   8,  26,  27,   0,  /* "cavataio" 66315 */
     12,  19,  22,   8,  30,  27,  30,   0,  /* "cavazos" 66323 */
     12,   2,  22,   0,  /* "cave" 66327 */
     12,   2,  22,  26,  24,   3,   0,  /* "caveat" 66334 */
     12,   2,  22,  26,  24,   3,  14,   0,  /* "caveats" 66342 */
     12,   1,  22,  21,   7,   0,  /* "cavell" 66348 */
     12,   2,  22,  17,  24,  13,   0,  /* "caveman" 66355 */
     12,  24,  22,   1,  13,  36,   0,  /* "cavenaugh" 66362 */
     12,   1,  22,  21,  13,  20,  10,   0,  /* "cavender" 66370 */
     12,  24,  22,   1,  13,  20,   5,  33,   0,  /* "cavendish" 66379 */
     12,  24,  22,  10,  13,   0,  /* "cavern" 66385 */
     12,  24,  22,  10,  13,   1,  14,   0,  /* "cavernous" 66393 */
     12,  24,  22,  10,  13,  30,   0,  /* "caverns" 66400 */
     12,  24,  22,   1,   3,   0,  /* "cavett" 66406 */
     12,  24,  22,  26,   8,   4,   0,  /* "caviar" 66413 */
     12,   2,  22,  26,  13,   1,  14,   0,  /* "caviness" 66421 */
     12,   2,  22,  31,  32,   0,  /* "caving" 66427 */
     12,  24,  22,   1,  13,  30,   0,  /* "cavins" 66434 */
     12,  24,  22,   1,   3,   0,  /* "cavitt" 66440 */
     12,   1,  22,  18,   4,   3,  31,  32,   0,  /* "cavorting" 66449 */
     12,  18,   0,  /* "caw" 66452 */
     12,   8,  47,  51,  20,   0,  /* "cawood" 66458 */
     12,  18,  14,   1,   7,   0,  /* "cawsl" 66464 */
     12,  18,  16,  10,  13,   0,  /* "cawthorne" 66470 */
     12,  24,  12,  14,   3,   1,  13,   0,  /* "caxton" 66478 */
     12,   2,   0,  /* "cay" 66481 */
     12,   2,   1,   0,  /* "caya" 66485 */
     12,  39,  21,  13,   0,  /* "cayenne" 66490 */
     12,   2,  14,   1,  13,   0,  /* "cayson" 66496 */
     12,  39,  29,  14,   1,  30,   0,  /* "cayuses" 66503 */
     12,  19,  30,   8,   4,  15,  14,   0,  /* "cazares" 66511 */
     12,  24,  30,   1,  13,  25,  22,   0,  /* "cazenove" 66519 */
     12,   2,  30,  26,  10,   0,  /* "cazier" 66525 */
     14,  23,  14,  23,   0,  /* "cc" 66530 */
     14,  23,  14,  23,  21,  14,   0,  /* "ccs" 66537 */
     14,  23,  20,  23,   0,  /* "cd" 66542 */
     14,  26,  20,   1,   9,   8,  12,   1,   0,  /* "cdebaca" 66551 */
     14,  23,  20,  23,   4,   8,  17,   0,  /* "cdrom" 66559 */
     14,  23,  20,  23,   4,   8,  17,  30,   0,  /* "cdroms" 66568 */
     14,  23,  20,  23,  30,   0,  /* "cds" 66574 */
     14,  23,  23,   2,   0,  /* "cea" 66579 */
     14,  23,   4,   1,   0,  /* "ceara" 66584 */
     14,   1,  14,   8,   4,   0,  /* "ceasar" 66590 */
     14,  23,  14,  37,  39,  10,   0,  /* "ceasefire" 66597 */
     14,  23,  14,  37,  39,  10,  30,   0,  /* "ceasefires" 66605 */
     14,  23,  14,   7,   1,  14,   0,  /* "ceaseless" 66612 */
     42,  52,  42,  21,  14,  12,  41,  29,   0,  /* "ceaucescu" 66621 */
     42,  52,  42,  21,  14,  12,  41,  29,   0,  /* "ceausescu" 66630 */
     14,  28,   9,   8,   7,  27,  30,   0,  /* "ceballos" 66638 */
     14,  26,   9,  29,   0,  /* "cebu" 66643 */
     42,  15,   9,  29,   7,   1,   0,  /* "cebula" 66650 */
     42,   1,   9,  35,   7,  14,  12,  26,   0,  /* "cebulski" 66659 */
     42,  15,  12,   8,   7,   1,   0,  /* "cecala" 66666 */
     42,  15,  12,  10,  21,   7,  26,   0,  /* "ceccarelli" 66674 */
     42,  15,  12,  23,  13,  26,   0,  /* "cecchini" 66681 */
     42,  15,  12,  25,  13,  26,   0,  /* "cecconi" 66688 */
     14,  23,  14,   0,  /* "cece" 66692 */
     14,   1,  14,  23,   7,  41,   1,   0,  /* "cecelia" 66700 */
     42,  15,  42,  21,   4,  26,   0,  /* "cecere" 66707 */
     14,  21,  12,   0,  /* "cech" 66711 */
     14,  21,  14,  26,   0,  /* "ceci" 66716 */
     14,  23,  14,   1,   7,   0,  /* "cecil" 66722 */
     14,   1,  14,  23,   7,   0,  /* "cecile" 66728 */
     14,   1,  14,  23,   7,  41,   1,   0,  /* "cecilia" 66736 */
     14,  21,  14,   5,  13,   0,  /* "cecin" 66742 */
     14,  23,  12,  27,   0,  /* "ceco" 66747 */
     14,  15,  12,  25,   7,   1,   0,  /* "cecola" 66754 */
     14,  23,  12,  27,  14,   0,  /* "cecos" 66760 */
     14,  23,  20,   0,  /* "cede" 66764 */
     14,  23,  20,   1,  20,   0,  /* "ceded" 66770 */
     42,  15,  20,  21,  13,  27,   0,  /* "cedeno" 66777 */
     14,  23,  20,  10,   0,  /* "ceder" 66782 */
     14,  23,  20,  10,   9,  10,  11,   0,  /* "cederberg" 66790 */
     14,  23,  20,  10,  11,   4,  15,  13,   0,  /* "cedergren" 66799 */
     14,  23,  20,  10,  38,  27,  17,   0,  /* "cederholm" 66807 */
     14,  23,  20,  30,   0,  /* "cedes" 66812 */
     42,  15,  20,   5,   7,  27,   0,  /* "cedillo" 66819 */
     14,  23,  20,  31,  32,   0,  /* "ceding" 66825 */
     14,   2,  20,   4,   8,  14,   0,  /* "cedras" 66832 */
     14,  28,  20,   4,  25,  13,  28,   0,  /* "cedrone" 66840 */
     14,  23,  30,   0,  /* "cees" 66844 */
     42,  15,  37,   8,   7,  27,   0,  /* "cefalo" 66851 */
     42,  15,  37,   8,   7,  29,   0,  /* "cefalu" 66858 */
     42,  31,  11,  23,   7,  14,  12,  26,   0,  /* "cegielski" 66867 */
     14,   2,  41,   1,   0,  /* "ceja" 66872 */
     42,   2,  12,   1,   0,  /* "cejka" 66877 */
     14,  21,   7,   0,  /* "cel" 66881 */
     14,  21,   7,   1,   0,  /* "cela" 66886 */
     14,  21,   7,   1,  20,   8,  13,   0,  /* "celadon" 66894 */
     14,  21,   7,   1,  13,  20,  39,  13,   0,  /* "celandine" 66903 */
     14,  21,   7,   1,  13,  23,  30,   0,  /* "celanese" 66911 */
     42,  15,   7,   8,  13,  26,   0,  /* "celani" 66918 */
     42,  15,   7,   8,  13,  27,   0,  /* "celano" 66925 */
     14,  28,   7,   2,   1,   0,  /* "celaya" 66931 */
     14,  23,   7,   0,  /* "cele" 66935 */
     14,   1,   7,  21,   9,   4,   1,   3,  18,   4,  26,   0,  /* "celebratory" 66947 */
     14,  21,   7,   1,   9,   4,   1,   0,  /* "celebre" 66955 */
     14,   1,   7,  21,   9,   4,   1,   3,  26,  30,   0,  /* "celebrities" 66966 */
     14,   1,   7,  21,   9,   4,   1,   3,  26,   0,  /* "celebrity" 66976 */
     42,  15,   7,  21,  13,   1,   0,  /* "celena" 66983 */
     42,  21,   7,  26,  13,   0,  /* "celene" 66989 */
     42,  15,   7,  15,  13,   3,   8,  13,  27,   0,  /* "celentano" 66999 */
     14,  21,   7,  10,  19,  13,   0,  /* "celeron" 67006 */
     14,   1,   7,  21,  14,   3,   1,   0,  /* "celesta" 67014 */
     14,   1,   7,  21,  14,   3,   0,  /* "celeste" 67021 */
     14,   1,   7,  21,  14,  42,   1,   7,   0,  /* "celestial" 67030 */
     14,  21,   7,  15,  14,   3,   5,  13,   0,  /* "celestin" 67039 */
     42,  15,   7,  15,  14,   3,  23,  13,   1,   0,  /* "celestina" 67049 */
     42,  15,   7,  15,  14,   3,  23,  13,  26,   0,  /* "celestine" 67059 */
     42,  15,   7,  15,  14,   3,  23,  13,  27,   0,  /* "celestino" 67069 */
     14,  23,   7,  41,   1,   0,  /* "celia" 67075 */
     14,  21,   7,   1,   9,   1,  14,  26,   0,  /* "celibacy" 67084 */
     42,  15,   7,  23,  13,  20,   1,   0,  /* "celinda" 67092 */
     14,   1,   7,  23,  13,   0,  /* "celine" 67098 */
     14,  21,   7,   0,  /* "cell" 67102 */
     42,  21,   7,  26,   0,  /* "celli" 67107 */
     42,  15,   7,  23,  13,  26,   0,  /* "cellini" 67114 */
     42,  21,   7,  26,  27,   0,  /* "cellio" 67120 */
     42,  21,   7,   1,  14,   3,   0,  /* "cellist" 67127 */
     42,  21,   7,  27,   0,  /* "cello" 67132 */
     14,  21,   7,  37,  27,  13,   0,  /* "cellphone" 67139 */
     42,  15,   7,  29,  42,  26,   0,  /* "cellucci" 67146 */
     14,  21,   7,   1,   7,  49,  20,   0,  /* "celluloid" 67154 */
     14,  21,   7,  29,   7,  25,  14,   1,   0,  /* "cellulosa" 67163 */
     14,  21,   7,  41,   1,   7,  25,  14,   0,  /* "cellulose" 67172 */
     14,  21,   7,  13,  31,  12,   0,  /* "celnik" 67179 */
     14,  21,   7,  27,   0,  /* "celo" 67184 */
     42,  15,   7,  25,  13,   1,   0,  /* "celona" 67191 */
     42,  15,   7,  25,  14,  26,   1,   0,  /* "celosia" 67199 */
     14,  21,   7,  30,   0,  /* "cels" 67204 */
     14,  21,   7,   3,   0,  /* "celt" 67209 */
     14,   1,  17,  21,  13,   3,   0,  /* "cement" 67216 */
     14,  15,  17,  21,  13,   3,  27,  14,   0,  /* "cementos" 67225 */
     14,  21,  17,   1,   3,  21,   4,  26,  30,   0,  /* "cemeteries" 67235 */
     14,  21,  17,   1,   3,  21,   4,  26,   0,  /* "cemetery" 67244 */
     12,  21,  17,  21,  12,  14,   0,  /* "cemex" 67251 */
     14,  21,  17,   6,   0,  /* "cemp" 67256 */
     14,  21,  13,  14,  21,   7,   0,  /* "cencall" 67263 */
     42,  21,  13,  42,  26,   0,  /* "cenci" 67269 */
     14,  28,  13,  20,   2,  41,  19,  30,   0,  /* "cendejas" 67278 */
     14,  28,  13,  26,  14,  21,   4,  27,  30,   0,  /* "ceniceros" 67288 */
     14,  23,  13,   1,  30,  25,  31,  12,   0,  /* "cenozoic" 67297 */
     14,  21,  13,  14,  10,  31,  32,   0,  /* "censoring" 67305 */
     14,  21,  13,  33,  10,   0,  /* "censure" 67311 */
     14,  21,  13,  33,  10,  20,   0,  /* "censured" 67318 */
     14,  21,  13,   3,   0,  /* "cent" 67323 */
     42,  15,  13,   3,   8,  13,  26,   0,  /* "centanni" 67331 */
     14,  21,  13,   3,  18,   4,   0,  /* "centaur" 67338 */
     14,  21,  13,   3,  18,   4,  30,   0,  /* "centaurs" 67346 */
     14,  15,  13,   3,   8,  22,  25,  14,   0,  /* "centavos" 67355 */
     14,  15,  13,   3,  21,  13,  26,   1,   7,   0,  /* "centennial" 67365 */
     42,  15,  13,   3,  21,  13,  27,   0,  /* "centeno" 67373 */
     14,  21,  13,   3,  10,   9,  34,  32,  12,   0,  /* "centerbanc" 67383 */
     14,  21,  13,   3,  10,   0,  /* "centerre" 67389 */
     14,  21,  13,   3,  21,  12,  14,   0,  /* "centex" 67397 */
     14,  21,  13,   3,  39,  17,   0,  /* "centime" 67404 */
     14,  21,  13,   3,  39,  17,  30,   0,  /* "centimes" 67412 */
     14,  21,  13,   3,   1,  17,  23,   3,  10,   0,  /* "centimeter" 67422 */
     14,  21,  13,   3,   1,  17,  23,   3,  10,  30,   0,  /* "centimeters" 67433 */
     14,  21,  13,   3,   1,  12,  18,   4,   0,  /* "centocor" 67442 */
     42,  15,  13,   3,  27,  37,   8,  13,   3,  26,   0,  /* "centofanti" 67453 */
     42,  15,  13,   3,  25,   7,   1,   0,  /* "centola" 67461 */
     14,  21,  13,   3,   8,  12,  14,   1,  13,   0,  /* "centoxin" 67471 */
     14,  15,  13,   3,   4,   8,   7,   0,  /* "centrale" 67479 */
     14,  15,  13,   3,   4,   2,   7,  26,   1,   0,  /* "centralia" 67489 */
     14,  21,  13,   3,   4,   1,   7,   5,  30,   1,  17,   0,  /* "centralism" 67501 */
     14,  15,  13,   3,  24,   7,   1,   3,  26,   0,  /* "centrality" 67511 */
     14,  21,  13,   3,   4,   1,   7,  39,  30,   0,  /* "centralize" 67521 */
     14,  21,  13,   3,   4,   1,   7,  39,  30,  20,   0,  /* "centralized" 67532 */
     14,  21,  13,   3,   4,   1,   7,  39,  30,  31,  32,   0,  /* "centralizing" 67544 */
     14,  21,  13,   3,  10,  30,   0,  /* "centres" 67551 */
     14,  21,  13,   3,   4,   1,  12,  14,   0,  /* "centrex" 67560 */
     14,  15,  13,   3,   4,   5,  37,  41,  31,  11,   1,   7,   0,  /* "centrifugal" 67573 */
     14,  21,  13,   3,   4,   1,  37,  41,  29,  40,   0,  /* "centrifuge" 67584 */
     14,  21,  13,   3,   4,   1,  37,  41,  29,  40,   1,  30,   0,  /* "centrifuges" 67597 */
     14,  21,  13,   3,   4,   1,  17,   5,  13,   0,  /* "centromin" 67607 */
     12,  21,  13,   3,   1,  17,   0,  /* "centum" 67614 */
     14,  15,  13,   3,  45,   4,  26,   0,  /* "centuri" 67622 */
     14,  21,  13,  42,  10,  26,  30,   0,  /* "centuries" 67630 */
     14,  15,  13,   3,  45,   4,  26,   1,  13,   0,  /* "centurion" 67640 */
     14,  21,  13,  42,  10,  26,   0,  /* "century" 67647 */
     14,  21,   6,   0,  /* "cep" 67651 */
     14,  28,   6,  21,   4,  27,   0,  /* "cepero" 67658 */
     14,  21,  37,   1,   7,  18,  14,   6,  10,   1,  13,   0,  /* "cephalosporin" 67670 */
     14,  21,  37,   1,  30,   0,  /* "cephas" 67676 */
     14,  21,   4,   1,   0,  /* "cera" 67681 */
     14,  21,   4,   1,  20,  39,  13,   0,  /* "ceradyne" 67689 */
     42,  10,   8,  17,  26,   0,  /* "cerami" 67695 */
     14,  21,   4,   1,  32,  12,  18,  14,  12,  26,   0,  /* "cerankosky" 67706 */
     42,  10,  19,  14,  25,   7,  26,   0,  /* "cerasoli" 67714 */
     42,  10,  19,  22,  25,   7,  27,   0,  /* "ceravolo" 67722 */
     42,  44,   9,  27,  13,   0,  /* "cerbone" 67728 */
     42,  10,  12,  25,  13,  26,   0,  /* "cercone" 67735 */
     14,   5,   4,  26,   1,   7,   0,  /* "cereal" 67742 */
     14,   5,   4,  26,   1,   7,  30,   0,  /* "cereals" 67750 */
     14,  10,  23,   9,   4,   1,   7,  26,   0,  /* "cerebrally" 67759 */
     14,  21,   4,   1,  20,   2,  30,   0,  /* "ceredase" 67767 */
     42,  10,  15,  11,  23,  13,  27,   0,  /* "cereghino" 67775 */
     42,  10,  21,   7,  26,   1,   0,  /* "cerelia" 67782 */
     14,  21,   4,   1,  17,  25,  13,  26,  30,   0,  /* "ceremonies" 67792 */
     14,  21,   4,   1,  17,  25,  13,  26,   0,  /* "ceremony" 67801 */
     14,  10,   2,  13,  27,   0,  /* "cereno" 67807 */
     14,   5,   4,  26,  30,   0,  /* "ceres" 67813 */
     14,  21,   4,   2,  30,  27,   0,  /* "cerezo" 67820 */
     14,  44,  37,   0,  /* "cerf" 67824 */
     14,  10,   5,  20,  26,   1,  13,   0,  /* "ceridian" 67832 */
     42,  10,  23,  13,  27,   0,  /* "cerino" 67838 */
     14,  10,  23,  14,   0,  /* "cerise" 67843 */
     14,  44,  13,   0,  /* "cern" 67847 */
     42,  21,   4,  13,   1,   0,  /* "cerna" 67853 */
     42,  10,  13,  23,  11,   7,  26,   1,   0,  /* "cerniglia" 67862 */
     14,  10,  13,  29,  20,   1,   0,  /* "cernuda" 67869 */
     42,  10,  25,  13,  26,   0,  /* "cerone" 67875 */
     14,  21,   4,   1,   0,  /* "cerra" 67880 */
     42,  10,   8,   3,  27,   0,  /* "cerrato" 67886 */
     42,  10,  21,   3,   1,   0,  /* "cerreta" 67892 */
     42,  10,  23,   3,  27,   0,  /* "cerrito" 67898 */
     14,  15,   4,  23,   3,  27,  14,   0,  /* "cerritos" 67906 */
     14,  21,   4,  27,   0,  /* "cerro" 67911 */
     42,  10,  25,  13,  26,   0,  /* "cerrone" 67917 */
     42,  10,  29,   3,  26,   0,  /* "cerruti" 67923 */
     12,  44,  14,  12,   1,   0,  /* "cerska" 67929 */
     14,  44,   3,   1,  13,   0,  /* "certain" 67935 */
     14,  44,   3,   1,  13,   7,  26,   0,  /* "certainly" 67943 */
     14,  10,   3,   5,  37,  31,  12,   1,   3,   0,  /* "certificate" 67953 */
     14,  10,   3,   5,  37,  31,  12,  28,   3,   0,  /* "certificate" 67963 */
     14,  10,   3,   5,  37,  31,  12,   1,   3,  14,   0,  /* "certificates" 67974 */
     14,  44,   3,   1,  37,  39,  20,   0,  /* "certified" 67982 */
     14,  44,   3,   1,  37,  39,  30,   0,  /* "certifies" 67990 */
     14,  44,   3,   1,  37,  39,   0,  /* "certify" 67997 */
     14,  44,   3,   1,  37,  39,  31,  32,   0,  /* "certifying" 68006 */
     14,  44,   3,   1,   3,  29,  20,   0,  /* "certitude" 68014 */
     42,  21,   4,   3,  27,   0,  /* "certo" 68020 */
     42,  10,  29,   7,  26,   0,  /* "cerulli" 68026 */
     42,  10,  29,   7,  27,   0,  /* "cerullo" 68032 */
     14,  21,   4,   1,  14,   0,  /* "cerus" 68038 */
     42,  10,  29,   3,  26,   0,  /* "cerutti" 68044 */
     14,  15,   4,  22,   8,  13,   3,  15,  30,   0,  /* "cervantez" 68054 */
     14,  15,   4,  22,   2,  32,  12,   1,   0,  /* "cervenka" 68063 */
     42,  10,  22,  23,  13,  26,   0,  /* "cerveny" 68070 */
     42,  10,  22,  21,   4,   1,   0,  /* "cervera" 68077 */
     14,  21,   4,  22,  15,  14,   8,   3,  25,   0,  /* "cervesato" 68087 */
     14,  44,  22,   2,  30,   1,   0,  /* "cerveza" 68094 */
     42,  21,   4,  22,  26,   0,  /* "cervi" 68100 */
     14,  44,  22,  31,  12,   1,   7,   0,  /* "cervical" 68108 */
     42,  10,  22,  23,  13,  26,   0,  /* "cervini" 68115 */
     14,  44,  22,  31,  12,  14,   0,  /* "cervix" 68122 */
     42,  10,  22,  25,  13,  26,   0,  /* "cervone" 68129 */
     14,  21,   4,   1,   7,   0,  /* "ceryl" 68135 */
     14,  23,  30,  10,   0,  /* "cesar" 68140 */
     42,  28,  30,   8,   4,  28,   0,  /* "cesare" 68147 */
     42,  15,  14,   8,   4,  26,  27,   0,  /* "cesario" 68155 */
     42,  15,  14,   8,   4,  27,   0,  /* "cesaro" 68162 */
     14,   2,  14,  19,   4,  30,   0,  /* "cesarz" 68169 */
     42,  15,  14,  21,  13,   1,   0,  /* "cesena" 68176 */
     14,  23,  30,  26,   1,  17,   0,  /* "cesium" 68183 */
     14,  28,  14,   6,   2,  20,  15,  14,   0,  /* "cespedes" 68192 */
     14,  21,  14,   6,  29,   7,   0,  /* "cesspool" 68199 */
     42,  15,  14,   3,   8,   4,  27,   0,  /* "cestaro" 68207 */
     14,  21,   3,   1,   0,  /* "ceta" 68212 */
     14,   1,   3,   2,  33,   1,  13,   0,  /* "cetacean" 68220 */
     14,  23,   3,  21,  12,   0,  /* "cetec" 68226 */
     14,  21,   3,  10,   1,   0,  /* "cetera" 68232 */
     14,  23,   3,   1,  14,   0,  /* "cetus" 68238 */
     14,  21,  22,  34,  12,  14,   1,  30,   0,  /* "cevaxs" 68247 */
     14,   1,   7,   8,  13,   0,  /* "ceylon" 68253 */
     14,  21,  30,  24,  13,   0,  /* "cezanne" 68259 */
     42,   8,   0,  /* "cha" 68262 */
     33,   1,   9,   7,  23,   0,  /* "chablis" 68268 */
     42,   2,   9,   1,  13,   0,  /* "chabon" 68274 */
     33,   1,   9,  25,   0,  /* "chabot" 68279 */
     42,  24,  12,   1,   9,  41,  29,  12,  27,   0,  /* "chacabuco" 68289 */
     33,   1,  33,   5,   4,   0,  /* "chachere" 68295 */
     42,   8,  42,  26,   0,  /* "chachi" 68300 */
     33,   2,  14,   5,  13,   0,  /* "chacin" 68306 */
     42,  24,  20,   0,  /* "chad" 68310 */
     33,   1,  20,   9,  45,   4,  13,   0,  /* "chadbourne" 68318 */
     42,   1,  20,  44,  20,   1,  13,   0,  /* "chadderdon" 68326 */
     42,  24,  20,   1,  12,   0,  /* "chaddock" 68332 */
     42,  24,  20,   1,   7,   0,  /* "chadel" 68338 */
     42,  24,  20,  31,  12,   0,  /* "chadick" 68344 */
     42,  39,   0,  /* "chae" 68347 */
     42,   2,   9,   1,   7,   0,  /* "chaebol" 68353 */
     42,  24,  37,  26,   0,  /* "chafee" 68358 */
     42,   2,  37,  31,  32,   0,  /* "chafing" 68364 */
     42,   1,  11,   8,   7,   0,  /* "chagall" 68370 */
     33,   1,  11,   4,   5,  13,   0,  /* "chagrin" 68377 */
     33,   1,  11,   4,   5,  13,  20,   0,  /* "chagrined" 68385 */
     42,  39,   0,  /* "chai" 68388 */
     42,  19,  23,  20,  15,  30,   0,  /* "chaidez" 68395 */
     38,  39,   5,  17,   0,  /* "chaim" 68400 */
     33,  21,   4,  30,   0,  /* "chaires" 68405 */
     42,  19,   5,   4,  15,  30,   0,  /* "chairez" 68412 */
     42,  21,   4,   6,  23,   6,   1,   7,   0,  /* "chairpeople" 68421 */
     42,  21,   4,   6,  44,  14,   1,  13,   0,  /* "chairperson" 68430 */
     33,   2,  30,   0,  /* "chaise" 68434 */
     42,  24,  40,   1,   3,   0,  /* "chajet" 68440 */
     42,   1,   7,   8,   9,  26,   0,  /* "chalabi" 68447 */
     42,  24,   7,   1,  14,  24,  13,  26,   0,  /* "chalasani" 68456 */
     33,  24,   7,   2,   0,  /* "chalet" 68461 */
     33,   1,   7,   2,  30,   0,  /* "chalets" 68467 */
     42,  24,   7,  37,   5,  13,   0,  /* "chalfin" 68474 */
     33,  24,   7,   1,  37,  29,   0,  /* "chalifoux" 68481 */
     42,   8,  12,   0,  /* "chalk" 68485 */
     42,  18,  12,   3,   0,  /* "chalked" 68490 */
     42,  18,  12,  10,   0,  /* "chalker" 68495 */
     42,  18,  12,  31,  32,   0,  /* "chalking" 68501 */
     42,  24,   7,  12,   7,  26,   0,  /* "chalkley" 68508 */
     42,  18,  12,  14,   0,  /* "chalks" 68513 */
     42,   1,   7,  21,  13,  20,  10,   0,  /* "challender" 68521 */
     42,  24,   7,   1,  40,  20,   0,  /* "challenged" 68528 */
     42,  24,   7,   1,  13,  40,  10,   0,  /* "challenger" 68536 */
     42,  24,   7,   1,  13,  40,  10,  30,   0,  /* "challengers" 68545 */
     42,  24,   7,   1,  13,  40,  10,  26,   0,  /* "challengery" 68554 */
     42,  24,   7,   1,  13,  40,  31,  32,   0,  /* "challenging" 68563 */
     42,   8,  17,  10,  30,   0,  /* "chalmers" 68569 */
     33,  34,   7,  17,  21,   3,   0,  /* "chalmette" 68576 */
     42,   1,   7,  29,   6,  12,   1,   0,  /* "chaloupka" 68584 */
     33,   1,   7,  29,   0,  /* "chaloux" 68589 */
     42,   1,   7,  29,   6,   1,   0,  /* "chalupa" 68596 */
     42,  24,  17,   0,  /* "cham" 68600 */
     42,  24,  17,   9,  10,   7,   1,  13,  20,   0,  /* "chamberland" 68610 */
     42,  24,  17,   9,   7,  26,   0,  /* "chamblee" 68617 */
     33,   1,  17,   9,   7,  23,  14,   0,  /* "chambless" 68625 */
     42,   1,  17,  21,   7,  26,   1,  13,   0,  /* "chameleon" 68634 */
     42,  24,  17,   7,  26,   0,  /* "chamlee" 68640 */
     42,   1,  17,  18,   4,  27,   0,  /* "chamorro" 68647 */
     12,   8,  17,   6,   1,   0,  /* "champa" 68653 */
     33,  34,  17,   6,   2,  13,   0,  /* "champagne" 68660 */
     33,  34,  17,   6,   2,  13,  30,   0,  /* "champagnes" 68668 */
     42,  34,  17,   6,   2,  13,   0,  /* "champaign" 68675 */
     33,  34,  17,   6,  25,   0,  /* "champeau" 68681 */
     42,  24,  17,   6,  39,  13,   0,  /* "champine" 68688 */
     33,  34,  17,   6,   7,   2,  13,   0,  /* "champlain" 68696 */
     33,  34,  17,   6,  29,   0,  /* "champoux" 68702 */
     42,  24,  13,   0,  /* "chan" 68706 */
     33,  34,  13,  20,   1,   7,   5,   4,   0,  /* "chandelier" 68715 */
     33,  24,  13,  20,   1,   7,   5,  30,   0,  /* "chandeliers" 68724 */
     42,  34,  13,  20,   4,  18,  14,   0,  /* "chandross" 68732 */
     33,   1,  13,  21,   7,   0,  /* "chanel" 68738 */
     42,   2,  13,  26,   0,  /* "chaney" 68743 */
     42,   8,  32,  42,  45,  13,   0,  /* "changchun" 68750 */
     42,   2,  13,  40,   1,   9,   1,   7,   0,  /* "changeable" 68759 */
     42,   2,  13,  40,  10,   0,  /* "changer" 68765 */
     42,   2,  13,  40,  10,  30,   0,  /* "changers" 68772 */
     42,   2,  13,  40,  31,  32,   0,  /* "changing" 68779 */
     42,  24,  32,  33,  25,   0,  /* "changsho" 68785 */
     42,   8,  13,  27,  14,   0,  /* "chanos" 68791 */
     33,  24,  13,   3,   5,   7,  26,   0,  /* "chantilly" 68799 */
     38,   8,  13,   1,  12,   1,   0,  /* "chanukah" 68806 */
     42,  48,   0,  /* "chao" 68809 */
     12,   2,  19,  14,   0,  /* "chaos" 68814 */
     12,  28,   8,   3,  31,  12,   0,  /* "chaotic" 68821 */
     42,  24,   6,   0,  /* "chap" 68825 */
     33,  24,   6,  10,  24,   7,   0,  /* "chaparral" 68832 */
     12,  19,   6,   8,   4,  27,   0,  /* "chaparro" 68839 */
     42,   8,   6,   1,  14,   0,  /* "chapas" 68845 */
     33,  24,   6,  20,   1,   7,  28,  13,   0,  /* "chapdelaine" 68854 */
     42,  24,   6,  31,  12,   0,  /* "chapek" 68860 */
     42,  24,   6,   1,   7,   0,  /* "chapel" 68866 */
     33,   1,   6,  21,   7,   0,  /* "chapell" 68872 */
     33,   1,   6,  21,   7,   0,  /* "chapelle" 68878 */
     33,  24,   6,  10,  25,  13,   0,  /* "chaperone" 68885 */
     33,  24,   6,  10,  25,  13,  31,  32,   0,  /* "chaperoning" 68894 */
     33,   1,   6,  24,  13,   0,  /* "chapin" 68900 */
     42,  24,   6,   7,   1,  13,   0,  /* "chaplain" 68907 */
     42,  24,   6,   7,   1,  13,  30,   0,  /* "chaplains" 68915 */
     42,  24,   6,   7,   1,  13,   0,  /* "chaplin" 68922 */
     42,  24,   6,  27,   8,  13,   0,  /* "chapoton" 68929 */
     33,  24,   6,   1,   7,  10,   0,  /* "chappelear" 68936 */
     33,   1,   6,  21,   7,   0,  /* "chappelle" 68942 */
     42,  24,   6,   1,   7,   0,  /* "chapple" 68948 */
     33,  24,   6,  29,   1,  30,   0,  /* "chappuis" 68955 */
     42,  24,   6,   1,   3,   0,  /* "chaput" 68961 */
     42,   8,   4,   0,  /* "char" 68965 */
     12,  21,   4,  31,  12,   3,  10,   0,  /* "character" 68973 */
     12,  21,   4,   1,  12,   3,  10,   5,  14,   3,  31,  12,   0,  /* "characteristic" 68986 */
     12,  21,   4,   1,  12,   3,  10,   5,  14,   3,  31,  12,   7,  26,   0,  /* "characteristically" 69001 */
     12,  21,   4,   1,  12,   3,  10,   5,  14,   3,  31,  12,  14,   0,  /* "characteristics" 69015 */
     12,  21,   4,   1,  12,   3,  10,   1,  30,   2,  33,   1,  13,   0,  /* "characterization" 69029 */
     12,  21,   4,   1,  12,   3,  10,  39,  30,   0,  /* "characterize" 69039 */
     12,  21,   4,   1,  12,   3,  10,  39,  30,  20,   0,  /* "characterized" 69050 */
     12,  21,   4,   1,  12,   3,  10,  39,  30,   1,  30,   0,  /* "characterizes" 69062 */
     12,  21,   4,  31,  12,   3,  10,  39,  30,  31,  32,   0,  /* "characterizing" 69074 */
     12,  24,   4,  31,  12,   3,  10,  30,   0,  /* "characters" 69083 */
     33,  10,   2,  20,   0,  /* "charade" 69088 */
     33,  10,   2,  20,  30,   0,  /* "charades" 69094 */
     42,   8,   4,   1,   7,   8,  17,   9,  27,  14,   0,  /* "charalambos" 69105 */
     42,  21,   4,  34,  14,   0,  /* "charasse" 69111 */
     33,   8,   4,   9,   1,  13,  27,   0,  /* "charboneau" 69119 */
     33,   8,   4,   9,   1,  13,  25,   0,  /* "charbonneau" 69127 */
     33,   8,   4,   9,   1,  13,  21,   3,   0,  /* "charbonnet" 69136 */
     42,   8,   4,  20,   0,  /* "chard" 69141 */
     42,  19,   4,  20,   8,  13,  28,   0,  /* "chardonnay" 69149 */
     42,  19,   4,  20,   8,  13,  28,  30,   0,  /* "chardonnays" 69158 */
     42,   8,   4,   1,  13,   0,  /* "charen" 69164 */
     42,  19,   4,   2,  15,  14,   3,   0,  /* "charest" 69172 */
     33,  10,  21,   3,   0,  /* "charette" 69177 */
     42,   8,   4,  40,   1,   9,   1,   7,   0,  /* "chargeable" 69186 */
     42,   8,   4,  40,  10,   0,  /* "charger" 69192 */
     42,   8,   4,  40,  10,  30,   0,  /* "chargers" 69199 */
     42,  19,   4,  11,  41,  29,   4,  30,   0,  /* "chargeurs" 69208 */
     42,   8,   4,  40,   5,   3,   0,  /* "chargit" 69215 */
     33,  19,   4,  11,  47,   8,   0,  /* "chargois" 69222 */
     42,  21,   4,  26,   1,   3,   0,  /* "chariot" 69229 */
     42,  21,   4,  26,   1,   3,  14,   0,  /* "chariots" 69237 */
     12,  10,   5,  30,  17,   1,   0,  /* "charisma" 69244 */
     12,  15,   4,   1,  30,  17,  24,   3,  31,  12,   0,  /* "charismatic" 69255 */
     12,  21,   4,   1,  30,  17,  24,   3,  31,  12,  14,   0,  /* "charismatics" 69267 */
     12,  19,   4,  23,  14,   1,   0,  /* "charissa" 69274 */
     12,  19,   4,  23,   3,   1,   0,  /* "charita" 69281 */
     42,  21,   4,   1,   3,   1,   9,   1,   7,   0,  /* "charitable" 69291 */
     33,   8,   4,   7,   1,   3,   1,  13,   0,  /* "charlatan" 69300 */
     33,   8,   4,   7,   1,   3,   1,  13,  30,   0,  /* "charlatans" 69310 */
     33,  19,   4,   7,   2,  13,   0,  /* "charlayne" 69317 */
     33,   8,   4,   7,   1,   9,  47,  19,   0,  /* "charlebois" 69326 */
     42,  19,   4,   7,  23,  13,   0,  /* "charleen" 69333 */
     33,   8,   4,   7,   1,  17,   2,  13,   0,  /* "charlemagne" 69342 */
     33,  19,   4,   7,  23,  13,   0,  /* "charlene" 69349 */
     42,   8,   4,   1,   7,  14,  47,  10,  16,   0,  /* "charlesworth" 69359 */
     33,  19,   4,   7,  23,  13,   0,  /* "charline" 69366 */
     33,   8,   4,   7,   1,   3,   0,  /* "charlotte" 69373 */
     33,   8,   4,   7,   1,   3,  14,  22,   5,   7,   0,  /* "charlottesville" 69384 */
     33,   8,   4,   7,   1,   3,   3,  48,  13,   0,  /* "charlottetown" 69394 */
     33,   8,   4,   7,   1,   3,  22,   5,   7,   0,  /* "charlotteville" 69404 */
     42,   8,   4,   7,   3,   1,  13,   0,  /* "charlton" 69412 */
     33,  19,   4,  17,   2,  13,   0,  /* "charmain" 69419 */
     33,  19,   4,  17,   2,  13,   0,  /* "charmaine" 69426 */
     12,  21,   4,   1,  13,   0,  /* "charon" 69432 */
     33,   8,   4,   6,   1,  13,   3,   5,   4,   0,  /* "charpentier" 69442 */
     42,   8,   4,  20,   0,  /* "charred" 69447 */
     42,   8,   4,  31,  32,   0,  /* "charring" 69453 */
     42,  21,   4,   1,  13,   0,  /* "charron" 69459 */
     42,   8,   4,   3,   5,  14,   3,   0,  /* "chartist" 69467 */
     42,   8,   4,   3,   5,  14,   3,  14,   0,  /* "chartists" 69476 */
     42,   8,   4,   3,   4,  26,  30,   0,  /* "chartres" 69484 */
     42,   8,   4,  22,   1,   3,   0,  /* "charvat" 69491 */
     42,   8,   4,  26,   0,  /* "chary" 69496 */
     42,  24,   4,   1,   7,   0,  /* "charyl" 69502 */
     42,   8,   4,   7,  30,   0,  /* "chas" 69508 */
     42,   2,  14,  31,  32,   0,  /* "chasing" 69514 */
     12,  24,  30,   1,  17,   0,  /* "chasm" 69520 */
     42,  24,  14,   0,  /* "chasse" 69524 */
     42,  24,  14,  26,   0,  /* "chassis" 69529 */
     33,   1,  14,   3,   2,  13,   0,  /* "chastain" 69536 */
     42,   2,  14,   3,   0,  /* "chaste" 69541 */
     42,   2,  14,   1,  13,   0,  /* "chasten" 69547 */
     42,   2,  14,   1,  13,  20,   0,  /* "chastened" 69554 */
     42,  34,  14,   3,  39,  30,   0,  /* "chastise" 69561 */
     42,  34,  14,   3,  39,  30,  20,   0,  /* "chastised" 69569 */
     42,  34,  14,   3,  39,  30,   1,  30,   0,  /* "chastises" 69578 */
     42,  34,  14,   3,  39,  30,  31,  32,   0,  /* "chastising" 69587 */
     42,  24,  14,   3,   1,   3,  26,   0,  /* "chastity" 69595 */
     42,  24,   3,   0,  /* "chat" 69599 */
     33,  34,   3,  25,   0,  /* "chateau" 69604 */
     33,   1,   3,  25,   0,  /* "chateaux" 69609 */
     42,  24,   3,   1,  17,   0,  /* "chatham" 69615 */
     42,  24,   3,  31,  42,  39,   0,  /* "chatichai" 69622 */
     42,  24,   3,  14,  47,  44,  16,   0,  /* "chatsworth" 69630 */
     42,  24,   3,   1,  38,  29,  42,  26,   0,  /* "chattahoochee" 69639 */
     42,  24,   3,   1,  13,  29,  11,   1,   0,  /* "chattanooga" 69648 */
     42,  24,   3,   1,  13,  29,  11,   1,   0,  /* "chattanuga" 69657 */
     42,  24,   3,   1,   7,   0,  /* "chattel" 69663 */
     42,   1,   3,  44,  40,  26,   0,  /* "chatterjee" 69670 */
     42,  24,   3,  47,  18,   7,   0,  /* "chatwal" 69677 */
     33,  25,   0,  /* "chau" 69680 */
     42,  18,  14,  10,   0,  /* "chaucer" 69685 */
     42,  18,  20,   4,  26,   0,  /* "chaudhry" 69691 */
     33,  27,  20,  49,  13,   0,  /* "chaudoin" 69697 */
     33,  27,  37,  44,   0,  /* "chauffeur" 69702 */
     33,  27,  37,  44,  20,   0,  /* "chauffeured" 69708 */
     33,  27,  37,  44,  30,   0,  /* "chauffeurs" 69714 */
     42,  18,  17,  15,   3,   0,  /* "chaumet" 69720 */
     42,  18,  13,  14,   0,  /* "chaunce" 69725 */
     42,  18,  13,  14,  26,   0,  /* "chauncey" 69731 */
     42,  18,  13,  14,  26,   0,  /* "chauncy" 69737 */
     42,  48,  14,   0,  /* "chaus" 69741 */
     42,  48,  14,   0,  /* "chausse" 69745 */
     42,  48,  14,  26,   0,  /* "chaussee" 69750 */
     33,   1,   3,  18,  12,  47,   1,   0,  /* "chautauqua" 69758 */
     33,   1,   3,  18,  12,  47,   1,  13,   0,  /* "chautauquan" 69767 */
     33,   1,   3,  18,  12,  47,   1,  13,  30,   0,  /* "chautauquans" 69777 */
     33,  27,  22,  24,  13,   0,  /* "chauvin" 69783 */
     33,  25,  22,   1,  13,   5,  30,   1,  17,   0,  /* "chauvinism" 69793 */
     33,  25,  22,   1,  13,   1,  14,   3,   0,  /* "chauvinist" 69802 */
     42,  25,  22,   1,  13,   5,  14,   3,  31,  12,   0,  /* "chauvinistic" 69813 */
     42,   1,  22,  24,   4,  26,   1,   0,  /* "chavarria" 69821 */
     33,   8,  22,  15,  30,   0,  /* "chavez" 69827 */
     12,  19,  22,   5,   4,   1,   0,  /* "chavira" 69834 */
     42,  24,  22,   1,   3,  14,   0,  /* "chavitz" 69841 */
     33,   1,  22,  18,  14,   0,  /* "chavous" 69847 */
     42,  18,   0,  /* "chaw" 69850 */
     42,  24,  30,   0,  /* "chaz" 69854 */
     42,  24,  30,   1,  13,  36,  37,   0,  /* "chazanoff" 69862 */
     42,   2,   0,  /* "che" 69865 */
     42,  23,   0,  /* "chea" 69868 */
     42,  23,  20,   1,   7,   0,  /* "cheadle" 69874 */
     42,  23,   6,  25,   0,  /* "cheapo" 69879 */
     42,  23,   3,   1,  17,   0,  /* "cheatham" 69885 */
     42,  23,   3,  31,  32,   0,  /* "cheating" 69891 */
     42,  21,   9,   4,  31,  12,   8,  22,   0,  /* "chebrikov" 69900 */
     42,  21,  42,   1,  13,   0,  /* "chechen" 69906 */
     42,  21,  42,   1,  13,  30,   0,  /* "chechens" 69913 */
     42,  21,  42,  13,  26,   1,   0,  /* "chechnya" 69920 */
     42,  21,  42,  13,  26,   1,  13,   0,  /* "chechnyan" 69928 */
     42,  21,  42,  13,  26,   1,  13,  30,   0,  /* "chechnyans" 69937 */
     42,  21,  12,   1,   3,  14,   0,  /* "checketts" 69944 */
     42,  21,  20,   1,  14,   3,  10,   0,  /* "chedester" 69952 */
     42,  23,   0,  /* "chee" 69955 */
     42,  23,  12,   3,   1,  47,   8,  11,   1,   0,  /* "cheektowaga" 69965 */
     42,   5,   4,  26,  27,   0,  /* "cheerio" 69971 */
     42,   5,   4,  26,  27,  14,   0,  /* "cheerios" 69978 */
     42,  23,  30,   9,  10,  11,  10,   0,  /* "cheeseburger" 69986 */
     42,  23,  30,   9,  10,  11,  10,  30,   0,  /* "cheeseburgers" 69995 */
     42,  23,  30,  12,   2,  12,   0,  /* "cheesecake" 70002 */
     42,  23,  30,  26,  10,   0,  /* "cheesier" 70008 */
     42,  23,  30,  26,   5,  14,   3,   0,  /* "cheesiest" 70016 */
     42,  23,  30,  17,   1,  13,   0,  /* "cheesman" 70023 */
     42,  23,  30,  26,   0,  /* "cheesy" 70028 */
     33,  21,  37,   0,  /* "chef" 70032 */
     42,  21,  37,   5,   3,  14,   0,  /* "chefitz" 70039 */
     33,  21,  37,  14,   0,  /* "chefs" 70044 */
     42,  39,   7,   0,  /* "cheil" 70048 */
     42,   2,  17,  26,   0,  /* "cheimi" 70053 */
     42,  21,  12,   0,  /* "chek" 70057 */
     42,  21,  12,  19,  22,   0,  /* "chekhov" 70063 */
     33,  15,   7,  21,   3,   0,  /* "chelette" 70069 */
     42,  21,   7,  14,  26,   0,  /* "chelsea" 70075 */
     42,  15,   7,  41,   1,   9,   5,  13,  14,  12,   0,  /* "chelyabinsk" 70086 */
     12,  21,  17,   0,  /* "chem" 70090 */
     42,  21,  17,  19,   0,  /* "chema" 70095 */
     42,  21,  17,  12,   7,   5,   4,   0,  /* "chemclear" 70103 */
     42,  21,  17,  20,   1,  30,  39,  13,   0,  /* "chemdesign" 70112 */
     12,  21,  17,  15,  20,   0,  /* "chemed" 70118 */
     12,  21,  17,  15,   7,   0,  /* "chemel" 70124 */
     42,  21,  17,  10,   5,  13,  14,  12,  26,   0,  /* "chemerinsky" 70134 */
     42,  21,  17,   1,   3,   4,  19,  13,   0,  /* "chemetron" 70143 */
     42,  21,  17,  37,  31,  12,  14,   0,  /* "chemfix" 70151 */
     12,  21,  17,  31,  12,   1,   7,  30,   0,  /* "chemicals" 70160 */
     42,  21,  17,  26,   0,  /* "chemie" 70165 */
     42,  21,  17,   5,  13,  30,   0,  /* "chemins" 70172 */
     33,   1,  17,  23,  30,   0,  /* "chemise" 70178 */
     12,  21,  17,   5,  14,   3,   0,  /* "chemist" 70185 */
     12,  21,  17,   5,  14,   3,  14,   0,  /* "chemists" 70193 */
     12,  23,  17,  27,  16,  21,   4,   1,   6,  26,   0,  /* "chemotherapy" 70204 */
     12,  21,  17,  31,   4,   0,  /* "chemyr" 70210 */
     42,  21,  13,   0,  /* "chen" 70214 */
     42,  21,  13,  10,  20,   0,  /* "chenard" 70220 */
     33,   5,  13,  25,   0,  /* "chenault" 70225 */
     33,   5,  13,  21,   3,   0,  /* "chenette" 70231 */
     42,  21,  13,  31,  22,  10,   3,   0,  /* "chenevert" 70239 */
     42,   2,  13,  26,   0,  /* "cheney" 70244 */
     42,  21,  32,  33,   8,  32,   0,  /* "chengxiang" 70251 */
     42,  23,  13,  26,  10,   0,  /* "chenier" 70257 */
     42,  21,  13,  36,   7,   3,   0,  /* "chennault" 70264 */
     42,  21,  13,   1,  47,  15,  16,   0,  /* "chenoweth" 70272 */
     42,  21,  13,   1,  47,   5,   3,  14,   0,  /* "chenowitz" 70281 */
     42,  21,  13,  33,   8,  32,   0,  /* "chenxiang" 70288 */
     42,  23,  19,  32,   0,  /* "cheong" 70293 */
     33,  21,   4,   0,  /* "cher" 70297 */
     42,  21,   4,   1,  17,  26,   0,  /* "cheramie" 70304 */
     33,  21,   4,   9,   1,   4,  11,   0,  /* "cherbourg" 70312 */
     33,  21,   4,  26,   0,  /* "cheri" 70317 */
     12,  10,  23,  12,  27,   0,  /* "cherico" 70323 */
     42,   5,   4,  26,   0,  /* "cherie" 70328 */
     42,  21,   4,   5,  33,   0,  /* "cherish" 70334 */
     42,  21,   4,   5,  33,   3,   0,  /* "cherished" 70341 */
     42,  21,   4,  31,  33,   1,  30,   0,  /* "cherishes" 70349 */
     42,  44,  13,   0,  /* "chern" 70353 */
     42,  10,  13,  21,  32,  12,  27,   0,  /* "chernenko" 70361 */
     42,  10,  13,  25,   9,   1,   7,   0,  /* "chernobyl" 70369 */
     12,  44,  13,  36,  37,   0,  /* "chernoff" 70375 */
     42,  21,   4,  13,  27,  17,   5,   4,  20,   1,  13,   0,  /* "chernomyrdin" 70387 */
     42,  44,  13,  26,   0,  /* "cherny" 70392 */
     42,  21,   4,   1,  12,  23,   0,  /* "cherokee" 70399 */
     42,  21,   4,   1,  12,  23,  30,   0,  /* "cherokees" 70407 */
     42,  21,   4,  26,  14,   3,  25,  13,   0,  /* "cherrystone" 70416 */
     42,  21,   4,  26,  14,   3,  25,  13,  30,   0,  /* "cherrystones" 70426 */
     42,  44,   3,   0,  /* "chert" 70430 */
     42,  44,   3,  19,  37,   0,  /* "chertoff" 70436 */
     42,  21,   4,   1,   9,   0,  /* "cherub" 70442 */
     42,  10,  29,   9,  31,  12,   0,  /* "cherubic" 70449 */
     12,  10,  29,   9,  23,  13,  26,   0,  /* "cherubini" 70457 */
     42,  21,   4,   1,   9,  30,   0,  /* "cherubs" 70464 */
     42,  21,   4,   1,  17,   5,   4,  20,   1,  13,   0,  /* "cherumirdan" 70475 */
     42,  44,  22,   1,  13,  34,  12,   0,  /* "chervenak" 70483 */
     42,  21,   4,  26,   0,  /* "chery" 70488 */
     33,  21,   4,   1,   7,   0,  /* "cheryl" 70494 */
     42,  21,  14,   0,  /* "ches" 70498 */
     12,  21,  14,   9,   4,  27,   0,  /* "chesbro" 70505 */
     12,  15,  14,  21,   9,   4,  27,   0,  /* "chesebro" 70513 */
     42,  21,  14,   1,   9,   4,  29,   0,  /* "chesebrough" 70521 */
     42,  21,  33,  10,   0,  /* "cheshire" 70526 */
     42,  21,  14,   1,   7,  10,   0,  /* "chesler" 70533 */
     42,  21,  14,   7,   1,  12,   0,  /* "cheslock" 70540 */
     42,  15,  14,  13,  35,   3,   0,  /* "chesnutt" 70547 */
     42,  21,  14,  10,   0,  /* "chesser" 70552 */
     33,  15,  33,  44,   0,  /* "chesshir" 70557 */
     42,  21,  14,  17,   1,  13,   0,  /* "chessman" 70564 */
     42,  21,  14,   1,  13,   0,  /* "chesson" 70570 */
     42,  21,  14,   3,   1,  32,   0,  /* "chestang" 70577 */
     42,  21,  14,  13,  35,   3,   0,  /* "chestnut" 70584 */
     42,  21,  14,  13,   1,   3,  14,   0,  /* "chestnuts" 70592 */
     42,  21,  14,   3,  13,   1,   3,   0,  /* "chestnutt" 70600 */
     42,  21,  14,   3,   1,  13,   0,  /* "cheston" 70607 */
     42,  21,   3,   0,  /* "chet" 70611 */
     42,  41,  29,  32,   0,  /* "cheung" 70616 */
     42,  29,  14,   0,  /* "cheuse" 70620 */
     33,  29,  22,   4,   8,  13,   3,   0,  /* "cheuvront" 70628 */
     33,  21,  22,   1,   7,   5,   4,   0,  /* "chevalier" 70636 */
     33,   1,  22,  21,   3,   0,  /* "chevette" 70642 */
     33,  21,  22,  26,   1,   3,   0,  /* "cheviot" 70649 */
     42,  21,  22,   5,  14,   0,  /* "chevis" 70655 */
     33,  31,  22,   4,  21,   3,   0,  /* "chevrette" 70662 */
     42,  21,  22,  10,  26,  10,   0,  /* "chevrier" 70669 */
     33,  21,  22,   4,   1,   7,   2,   0,  /* "chevrolet" 70677 */
     33,  21,  22,   4,   1,   7,   2,  30,   0,  /* "chevrolets" 70686 */
     33,  21,  22,   4,   1,  13,   0,  /* "chevron" 70693 */
     42,  21,  22,  26,   0,  /* "chevy" 70698 */
     42,  29,   0,  /* "chew" 70701 */
     42,  29,  20,   0,  /* "chewed" 70705 */
     42,  29,  10,   0,  /* "chewer" 70709 */
     42,  29,  10,  30,   0,  /* "chewers" 70714 */
     42,  29,  31,  32,   0,  /* "chewing" 70719 */
     42,  29,  13,  31,  32,   0,  /* "chewning" 70725 */
     42,  29,  30,   0,  /* "chews" 70729 */
     42,  29,  26,   0,  /* "chewy" 70733 */
     33,  39,  24,  13,   0,  /* "cheyenne" 70738 */
     33,  39,  24,  13,  30,   0,  /* "cheyennes" 70744 */
     42,  21,  30,   0,  /* "chez" 70748 */
     12,  39,   0,  /* "chi" 70751 */
     42,  23,   1,   0,  /* "chia" 70755 */
     12,  26,  19,  13,   2,  30,  26,   0,  /* "chianese" 70763 */
     42,  24,  32,   0,  /* "chiang" 70767 */
     42,  26,  24,  13,   3,  26,   0,  /* "chianti" 70774 */
     42,  26,   8,   6,   1,  14,   0,  /* "chiapas" 70781 */
     42,  26,  24,   6,  10,  25,  13,   0,  /* "chiapparone" 70789 */
     12,  26,  19,   6,  21,   3,   1,   0,  /* "chiappetta" 70797 */
     12,  26,  19,   6,  25,  13,  26,   0,  /* "chiappone" 70805 */
     12,  41,   8,   4,   1,   0,  /* "chiara" 70811 */
     12,  26,  19,   4,  19,  17,  25,  13,   3,  26,   0,  /* "chiaramonte" 70822 */
     12,  26,   8,   4,  13,   5,  17,   0,  /* "chiarnim" 70830 */
     42,  26,   8,  14,   1,  13,   0,  /* "chiasson" 70837 */
     42,  23,  34,   3,   0,  /* "chiat" 70842 */
     12,  26,  19,  22,  21,   3,   1,   0,  /* "chiavetta" 70850 */
     33,  23,  12,   0,  /* "chic" 70854 */
     33,   1,  12,   8,  11,  25,   0,  /* "chicago" 70861 */
     42,   5,  12,   1,  11,  25,  13,   0,  /* "chicagoan" 70869 */
     33,   1,  12,   8,  11,  25,   1,  13,  30,   0,  /* "chicagoans" 70879 */
     33,  31,  12,   2,  13,  10,  26,   0,  /* "chicanery" 70887 */
     42,  23,  42,  48,   1,   0,  /* "chichauha" 70893 */
     42,   5,  42,  15,  14,   3,  10,   0,  /* "chichester" 70901 */
     42,   5,  12,   0,  /* "chick" 70905 */
     42,  31,  12,   3,   0,  /* "chicked" 70910 */
     42,  23,  12,  25,   0,  /* "chico" 70915 */
     42,  31,  12,  49,  13,   0,  /* "chicoine" 70921 */
     42,   5,  12,   1,   3,  14,   0,  /* "chicots" 70928 */
     42,  39,  20,   0,  /* "chide" 70932 */
     42,  39,  20,   1,  20,   0,  /* "chided" 70938 */
     42,  39,  20,  30,   0,  /* "chides" 70943 */
     42,   5,  20,   1,  14,   3,  10,   0,  /* "chidester" 70951 */
     42,   1,  20,  23,  41,   1,   0,  /* "chideya" 70958 */
     42,  39,  20,  31,  32,   0,  /* "chiding" 70964 */
     42,   5,  20,  30,  26,   0,  /* "chidsey" 70970 */
     42,  23,  37,   0,  /* "chief" 70974 */
     12,  23,  37,  27,   0,  /* "chieffo" 70979 */
     42,  23,  37,   7,  26,   0,  /* "chiefly" 70985 */
     42,  21,  13,   0,  /* "chien" 70989 */
     42,  21,  32,  17,  39,   0,  /* "chiengmai" 70995 */
     12,  23,  14,   1,   0,  /* "chiesa" 71000 */
     33,   5,  37,   8,  13,   0,  /* "chiffon" 71006 */
     42,   1,  47,   8,  47,   8,   0,  /* "chihuahua" 71013 */
     42,  31,  12,   8,  13,  28,   0,  /* "chikane" 71020 */
     42,  31,  12,   1,   3,   5,   7,  27,   0,  /* "chikatilo" 71029 */
     42,  23,  12,  27,  14,   0,  /* "chikos" 71035 */
     42,   5,   7,  12,   1,   3,   0,  /* "chilcott" 71042 */
     42,  39,   7,  20,   0,  /* "child" 71047 */
     42,  39,   7,  20,   9,  21,   4,  31,  32,   0,  /* "childbearing" 71057 */
     42,  39,   7,  20,   9,  44,  16,   0,  /* "childbirth" 71065 */
     42,  39,   7,  20,  12,  21,   4,   0,  /* "childcare" 71073 */
     42,  39,   7,  20,  12,   4,  24,  37,   3,   0,  /* "childcraft" 71083 */
     42,   5,   7,  20,  13,  10,   0,  /* "childener" 71090 */
     42,  39,   7,  20,  38,  45,  20,   0,  /* "childhood" 71098 */
     42,  39,   7,  20,  38,  45,  20,  30,   0,  /* "childhoods" 71107 */
     42,  39,   7,  20,   5,  33,   0,  /* "childish" 71114 */
     42,  39,   7,  20,   7,   1,  14,   0,  /* "childless" 71122 */
     42,  39,   7,  20,   7,  39,  12,   0,  /* "childlike" 71130 */
     42,  39,   7,  20,   4,   2,  30,  31,  32,   0,  /* "childraising" 71140 */
     42,  39,   7,  20,   4,  23,   0,  /* "childree" 71147 */
     42,  39,   7,  20,  10,  30,   0,  /* "childres" 71154 */
     42,   5,   7,  20,   4,   1,  14,   0,  /* "childress" 71162 */
     42,  39,   7,  20,  30,   0,  /* "childs" 71168 */
     42,   5,   7,  26,   0,  /* "chile" 71173 */
     42,   5,   7,  26,   1,  13,   0,  /* "chilean" 71180 */
     42,   5,   7,  26,   1,  13,  30,   0,  /* "chileans" 71188 */
     42,  39,   7,  30,   0,  /* "chiles" 71193 */
     42,   5,   7,  26,   0,  /* "chili" 71198 */
     42,   5,   7,  26,  30,   0,  /* "chilies" 71204 */
     42,   5,   7,  26,  30,   0,  /* "chilis" 71210 */
     12,  26,   7,  21,  17,  26,   0,  /* "chillemi" 71217 */
     42,   5,   7,  31,  12,  36,  16,   0,  /* "chillicothe" 71225 */
     42,   5,  17,  39,  27,   0,  /* "chimayo" 71231 */
     42,  39,  17,   0,  /* "chime" 71235 */
     42,  39,  17,  20,   0,  /* "chimed" 71240 */
     42,   5,  17,  21,  13,   3,  26,   0,  /* "chimenti" 71248 */
     42,   5,  17,  21,  13,   3,  27,   0,  /* "chimento" 71256 */
     42,  39,  17,  30,   0,  /* "chimes" 71261 */
     42,   5,  17,  31,  12,   1,   7,  30,   0,  /* "chimicles" 71270 */
     42,   5,  13,   0,  /* "chin" 71274 */
     42,  39,  13,   1,   0,  /* "china" 71279 */
     42,  39,  13,   1,   3,  48,  13,   0,  /* "chinatown" 71287 */
     42,   5,  13,   1,  13,   0,  /* "chinen" 71293 */
     42,  39,  13,  23,  30,   0,  /* "chinese" 71299 */
     42,   5,  32,   0,  /* "ching" 71303 */
     12,  26,  13,  23,  42,  26,   0,  /* "chinnici" 71310 */
     33,   5,  13,  45,  12,   0,  /* "chinook" 71316 */
     12,  26,  25,  20,  27,   0,  /* "chiodo" 71322 */
     42,   5,   6,   0,  /* "chip" 71326 */
     42,   5,   6,  12,   8,  17,   0,  /* "chipcom" 71333 */
     42,   1,   6,  23,   3,   1,  30,   0,  /* "chipetas" 71341 */
     42,   1,   6,  25,   3,   0,  /* "chipote" 71347 */
     42,   5,   6,   1,  47,   8,   0,  /* "chippewa" 71354 */
     42,   5,   6,  14,  18,  37,   3,   0,  /* "chipsoft" 71362 */
     12,  31,  12,  47,  23,   3,   1,   0,  /* "chiquita" 71370 */
     33,  31,   4,  24,  12,   0,  /* "chirac" 71376 */
     12,   5,   4,  12,  27,   0,  /* "chirco" 71382 */
     12,  31,   4,  23,  12,  27,   0,  /* "chirico" 71389 */
     42,  39,   4,   1,  13,   0,  /* "chiron" 71395 */
     12,  39,   4,  27,   6,   4,  24,  12,   3,  31,  12,   0,  /* "chiropractic" 71407 */
     12,  39,   4,   1,   6,   4,  24,  12,   3,  10,   0,  /* "chiropractor" 71418 */
     12,  39,   4,   1,   6,   4,  24,  12,   3,  10,  30,   0,  /* "chiropractors" 71430 */
     42,   5,  14,   1,  17,   0,  /* "chisam" 71436 */
     42,   5,  14,  21,  13,  38,   1,   7,   0,  /* "chisenhall" 71445 */
     42,   5,  30,   1,  17,   0,  /* "chisholm" 71451 */
     42,   5,  14,   1,   7,  10,   0,  /* "chisler" 71458 */
     42,   5,  30,   1,  17,   0,  /* "chism" 71464 */
     42,   5,  30,  17,  10,   0,  /* "chismar" 71470 */
     42,   5,  14,  27,  17,   0,  /* "chisolm" 71476 */
     42,   5,  14,   1,  17,   0,  /* "chisom" 71482 */
     42,   1,  14,   8,  13,  27,   0,  /* "chissano" 71489 */
     42,   5,  30,   1,  17,   0,  /* "chisum" 71495 */
     42,   5,   3,   0,  /* "chit" 71499 */
     42,   5,   3,  42,  24,   3,   0,  /* "chitchat" 71506 */
     12,  39,   3,   1,  13,   1,  14,   0,  /* "chitinous" 71514 */
     42,   5,   3,   4,  52,   0,  /* "chitrao" 71520 */
     42,   5,   3,   1,  13,  20,   1,  13,   0,  /* "chittenden" 71529 */
     42,   5,   3,  31,  12,   0,  /* "chittick" 71535 */
     42,  29,   0,  /* "chiu" 71538 */
     12,  26,  29,  14,   8,  13,  27,   0,  /* "chiusano" 71546 */
     33,   5,  22,   1,   7,   4,  26,   0,  /* "chivalry" 71554 */
     42,  23,  22,   1,  14,   0,  /* "chivas" 71560 */
     42,  39,  22,  10,  30,   0,  /* "chivers" 71566 */
     42,  39,  22,  30,   0,  /* "chives" 71571 */
     42,   1,  41,  25,  20,   1,   0,  /* "chiyoda" 71578 */
     42,   5,  30,  17,  10,   0,  /* "chizmar" 71584 */
     12,   7,  34,  17,  39,  20,  26,   1,   0,  /* "chlamydia" 71593 */
     42,   7,   1,   9,  18,  37,  14,  12,  26,   0,  /* "chlebowski" 71603 */
     12,   7,  25,  26,   0,  /* "chloe" 71608 */
     12,   7,  18,   4,  28,   3,   0,  /* "chlorate" 71615 */
     12,   7,  18,   4,  39,  20,   0,  /* "chloride" 71622 */
     12,   7,  18,   4,  26,  13,   0,  /* "chlorine" 71629 */
     12,   7,  18,   4,   5,  14,   0,  /* "chloris" 71636 */
     12,   7,  36,   4,  27,  37,   7,  18,   4,  27,  12,   8,   4,   9,  19,  13,   0,  /* "chlorofluorocarbon" 71653 */
     12,   7,  36,   4,  27,  37,   7,  18,   4,  27,  12,   8,   4,   9,  19,  13,  30,   0,  /* "chlorofluorocarbons" 71671 */
     12,   7,  18,   4,   1,  37,  18,   4,  17,   0,  /* "chloroform" 71681 */
     12,   7,  18,   4,   1,  37,   5,   7,   0,  /* "chlorophyll" 71690 */
     42,   1,  17,  23,   7,   0,  /* "chmiel" 71696 */
     42,   1,  17,   1,   7,  21,  37,  14,  12,  26,   0,  /* "chmielewski" 71707 */
     42,   1,  17,  45,   4,   1,   0,  /* "chmura" 71714 */
     42,  25,   0,  /* "cho" 71717 */
     42,  25,   3,   0,  /* "choate" 71721 */
     42,   8,  12,   7,   1,   3,   0,  /* "chocolat" 71728 */
     42,  18,  12,   7,   1,   3,   0,  /* "chocolate" 71735 */
     42,  18,  12,   7,   1,   3,  14,   0,  /* "chocolates" 71743 */
     42,  25,   0,  /* "choe" 71746 */
     42,  49,   0,  /* "choi" 71749 */
     42,  49,  14,   1,  14,   3,   0,  /* "choicest" 71756 */
     33,  49,  13,  26,  15,   4,   0,  /* "choiniere" 71763 */
     12,  47,  39,  10,   0,  /* "choir" 71768 */
     12,  47,  39,   4,  30,   0,  /* "choirs" 71774 */
     42,   1,  41,  13,   8,   3,  14,  12,  26,   0,  /* "chojnacki" 71784 */
     42,   1,  41,  13,  18,  37,  14,  12,  26,   0,  /* "chojnowski" 71794 */
     42,   8,  12,   0,  /* "chok" 71798 */
     12,   8,   7,  10,   1,   0,  /* "cholera" 71804 */
     12,   8,   7,  10,  31,  12,   0,  /* "choleric" 71811 */
     12,   1,   7,  21,  14,   3,  10,  18,   7,   0,  /* "cholesterol" 71821 */
     42,  27,   7,  21,  14,   3,  31,   4,   1,  17,  39,  13,   0,  /* "cholestyramine" 71834 */
     42,   1,   7,  29,   1,   0,  /* "cholewa" 71840 */
     42,   8,  13,   0,  /* "chon" 71844 */
     42,  18,  32,  12,   5,  32,   0,  /* "chongqing" 71851 */
     33,   8,  13,   3,   2,   7,  30,   0,  /* "chontales" 71859 */
     42,  29,   0,  /* "choo" 71862 */
     42,  29,  13,   0,  /* "choon" 71866 */
     42,  29,  32,   0,  /* "choong" 71870 */
     42,  29,  30,   0,  /* "choose" 71874 */
     42,  29,  30,   1,  30,   0,  /* "chooses" 71880 */
     42,  29,  30,  31,  32,   0,  /* "choosing" 71886 */
     42,  29,  30,  26,   0,  /* "choosy" 71891 */
     42,   8,   6,   0,  /* "chop" 71895 */
     33,  25,   6,  34,  13,   0,  /* "chopin" 71901 */
     42,   8,   6,   4,   1,   0,  /* "chopra" 71907 */
     42,   8,   6,  14,  29,  26,   0,  /* "chopsuey" 71914 */
     33,   1,  12,  21,   3,   0,  /* "choquette" 71920 */
     42,  18,   4,   0,  /* "chore" 71924 */
     12,  18,   4,  26,   1,  11,   4,  24,  37,   0,  /* "choreograph" 71934 */
     12,  18,   4,  26,   1,  11,   4,  24,  37,   3,   0,  /* "choreographed" 71945 */
     12,  18,   4,  26,   1,  11,   4,  24,  37,  31,  12,   0,  /* "choreographic" 71957 */
     12,  18,   4,  26,   8,  11,   4,   1,  37,  31,  32,   0,  /* "choreographing" 71969 */
     42,  18,   4,  30,   0,  /* "chores" 71974 */
     12,  18,   4,  31,  12,   0,  /* "choric" 71980 */
     42,  18,   4,   3,   1,   7,   0,  /* "chortle" 71987 */
     42,  18,   4,   3,   1,   7,  20,   0,  /* "chortled" 71995 */
     42,  18,   4,   3,   1,   7,  30,   0,  /* "chortles" 72003 */
     42,  18,   4,   3,   1,   7,  31,  32,   0,  /* "chortling" 72012 */
     42,  25,  30,   1,  13,   0,  /* "chosen" 72018 */
     42,  25,  30,   1,  13,   0,  /* "chosun" 72024 */
     42,   1,   3,   5,   7,   1,   0,  /* "chotilla" 72031 */
     42,  29,   0,  /* "chou" 72034 */
     33,  47,  26,  13,   8,   4,  20,   0,  /* "chouinard" 72042 */
     42,   1,  22,  24,  13,  31,  12,   0,  /* "chovanec" 72050 */
     42,  48,   0,  /* "chow" 72053 */
     42,  48,  20,  38,  41,  29,   4,  26,   0,  /* "chowdhury" 72062 */
     42,  48,  13,  31,  32,   0,  /* "chowning" 72068 */
     42,  49,   0,  /* "choy" 72071 */
     12,   4,  21,  14,   3,  17,   1,  13,   0,  /* "chrestman" 72080 */
     33,   4,   5,   3,  23,  13,   0,  /* "chretien" 72087 */
     42,   4,  23,   9,  27,  13,  23,  12,  27,   0,  /* "chriboniko" 72097 */
     12,   4,   5,   6,   3,  27,  14,   6,  36,   4,   5,  20,  26,   1,  17,   0,  /* "chriptosporidium" 72113 */
     12,   4,  23,  14,  12,  27,   0,  /* "chrisco" 72120 */
     12,   4,   5,  14,  12,  27,   0,  /* "chriscoe" 72127 */
     12,  44,   5,  30,   1,  17,  10,   0,  /* "chrismer" 72135 */
     12,   4,   5,  30,  17,   1,  13,   0,  /* "chrismon" 72143 */
     12,   4,  39,  14,   3,   0,  /* "christ" 72149 */
     33,   4,   5,  14,   3,   1,   9,   1,   7,   0,  /* "christabelle" 72159 */
     12,   4,  39,  14,   3,  42,  10,  42,   0,  /* "christchurch" 72168 */
     12,   4,   5,  14,   1,  13,   0,  /* "christen" 72175 */
     12,   4,   5,  14,   1,  13,   9,  21,   4,  26,   0,  /* "christenberry" 72186 */
     12,   4,   5,  14,   1,  13,   9,  21,   4,  26,   0,  /* "christenbury" 72197 */
     12,   4,   5,  14,   1,  13,  20,   1,  17,   0,  /* "christendom" 72207 */
     12,   4,   5,  14,   3,   1,  13,  14,   1,  13,   0,  /* "christenson" 72218 */
     12,   4,   5,  14,   3,  26,   8,  13,   0,  /* "christiaan" 72227 */
     12,   4,   5,  14,   3,  26,  24,  13,   1,   0,  /* "christiana" 72237 */
     12,   4,   5,  14,   3,  26,   8,  13,   0,  /* "christiane" 72246 */
     12,   4,   5,  14,  42,  26,  24,  13,   1,   3,  26,   0,  /* "christianity" 72258 */
     12,   4,   5,  14,  42,   1,  13,  39,  30,   0,  /* "christianize" 72268 */
     12,   4,   5,  14,  42,   1,  13,  39,  30,  20,   0,  /* "christianized" 72279 */
     12,   4,   5,  14,   3,  26,  24,  13,   1,   0,  /* "christianna" 72289 */
     12,   4,   5,  14,   3,  26,   8,  13,   0,  /* "christianne" 72298 */
     12,   4,  26,  14,   3,  26,   8,  13,  27,   0,  /* "christiano" 72308 */
     12,   4,   5,  14,  42,   1,  13,  30,   0,  /* "christians" 72317 */
     12,   4,   5,  14,  42,   1,  13,  14,   1,  13,   0,  /* "christiansen" 72328 */
     12,   4,   5,  14,  42,   1,  13,  14,   1,  13,   0,  /* "christianson" 72339 */
     12,   4,   5,  14,  17,   1,  14,   0,  /* "christmas" 72347 */
     12,   4,   5,  14,  17,   1,  14,   1,  30,   0,  /* "christmases" 72357 */
     12,   4,   5,  14,   3,  17,   1,  14,   3,  39,  17,   0,  /* "christmastime" 72369 */
     12,   4,   5,  14,   3,   1,  37,  15,   7,   0,  /* "christoffel" 72379 */
     12,   4,   5,  14,   3,   1,  37,  44,  14,   1,  13,   0,  /* "christoffersen" 72391 */
     12,   4,  31,  14,   3,   8,  37,  10,  14,   1,  13,   0,  /* "christofferson" 72403 */
     12,   4,   5,  14,   3,  36,  37,   0,  /* "christoph" 72411 */
     12,   4,  31,  14,   3,   4,  18,  37,   0,  /* "christophe" 72420 */
     12,   4,   5,  14,   3,   1,  37,  15,   7,   0,  /* "christophel" 72430 */
     12,   4,   5,  14,   3,   1,  37,  10,   0,  /* "christopher" 72439 */
     12,   4,  31,  14,   3,   8,  37,  10,  14,   1,  13,   0,  /* "christopherson" 72451 */
     42,   4,  25,  17,   1,  12,   8,   7,  23,  17,   0,  /* "chromakalim" 72462 */
     12,   4,  27,  17,  24,   7,  50,   0,  /* "chromalloy" 72470 */
     12,   4,  27,  17,  24,   3,   1,  11,   4,  34,  17,   0,  /* "chromatogram" 72482 */
     12,   4,  27,  17,  24,   3,   1,  11,   4,  34,  17,  30,   0,  /* "chromatograms" 72495 */
     12,   4,  25,  17,   1,  13,   1,  13,  14,   0,  /* "chrominance" 72505 */
     12,   4,  25,  17,  26,   1,  17,   0,  /* "chromium" 72513 */
     12,   4,  25,  17,   1,  14,  25,  17,   0,  /* "chromosome" 72522 */
     12,   4,  25,  17,   1,  30,  25,  17,  30,   0,  /* "chromosomes" 72532 */
     12,   4,   8,  13,  10,   0,  /* "chronar" 72538 */
     12,   4,   8,  13,  31,  12,   1,   7,  26,   0,  /* "chronically" 72548 */
     12,   4,   8,  13,   1,  12,   1,   7,   0,  /* "chronicle" 72557 */
     12,   4,   8,  13,  31,  12,   1,   7,  20,   0,  /* "chronicled" 72567 */
     12,   4,   8,  13,  31,  12,   7,  10,   0,  /* "chronicler" 72576 */
     12,   4,   8,  13,   1,  12,   1,   7,  30,   0,  /* "chronicles" 72586 */
     12,   4,   8,  13,  31,  12,   7,  31,  32,   0,  /* "chronicling" 72596 */
     12,   4,  25,  13,   5,  14,   0,  /* "chronis" 72603 */
     12,   4,   8,  13,   1,  14,   3,  10,   0,  /* "chronister" 72612 */
     12,   4,   8,  13,   1,   7,   8,  40,  31,  12,   1,   7,   0,  /* "chronological" 72625 */
     12,   4,   8,  13,   1,   7,   8,  40,  31,  12,   7,  26,   0,  /* "chronologically" 72638 */
     12,   4,   8,  13,   1,  47,   5,   3,  14,   0,  /* "chronowitz" 72648 */
     12,   4,   1,  14,   3,  18,  37,  14,  12,  26,   0,  /* "chrostowski" 72659 */
     12,   4,   1,  14,  24,  13,  16,   1,  17,   1,  17,   0,  /* "chrysanthemum" 72671 */
     12,   4,   1,  14,  24,  13,  16,   1,  17,   1,  17,  30,   0,  /* "chrysanthemums" 72684 */
     12,   4,   5,  14,   1,  30,   0,  /* "chryseis" 72691 */
     12,   4,  39,  14,   7,  10,   0,  /* "chrysler" 72698 */
     12,   4,  39,  14,   7,  10,  30,   0,  /* "chryslers" 72706 */
     42,   4,   5,  14,   3,   0,  /* "chryst" 72712 */
     12,  44,  30,  24,  13,   0,  /* "chrzan" 72718 */
     12,  44,  30,   1,  13,  18,  37,  14,  12,  26,   0,  /* "chrzanowski" 72729 */
     42,   2,  32,   0,  /* "chseing" 72733 */
     42,  29,   0,  /* "chu" 72736 */
     12,  29,   1,   0,  /* "chua" 72740 */
     42,  29,  19,   0,  /* "chuah" 72744 */
     42,  29,   8,  13,   0,  /* "chuan" 72749 */
     42,  24,  32,   0,  /* "chuang" 72753 */
     42,  29,   9,   1,   0,  /* "chuba" 72758 */
     42,  29,   9,  39,   0,  /* "chubais" 72763 */
     42,  35,   9,   1,  12,   0,  /* "chubbuck" 72769 */
     42,  29,   9,  29,   0,  /* "chubu" 72774 */
     42,  35,  12,   1,   7,   0,  /* "chuckle" 72780 */
     42,  35,  12,   1,   7,  20,   0,  /* "chuckled" 72787 */
     42,  35,  12,   1,   7,  30,   0,  /* "chuckles" 72794 */
     42,  35,  20,   7,  10,   0,  /* "chudler" 72800 */
     42,  29,  20,  26,   0,  /* "chudy" 72805 */
     42,  35,  20,  30,  31,  12,   0,  /* "chudzik" 72812 */
     42,   1,  40,   5,  13,  14,  12,  26,   0,  /* "chudzinski" 72821 */
     42,  35,  11,   0,  /* "chug" 72825 */
     42,  29,  11,  39,   0,  /* "chugai" 72830 */
     42,  29,  11,  25,  12,  29,   0,  /* "chugoku" 72837 */
     12,  29,  31,   0,  /* "chui" 72841 */
     42,  29,  40,  26,   3,  14,  29,  41,   1,   0,  /* "chujitsuya" 72851 */
     42,  29,  12,  42,  26,   0,  /* "chukchi" 72857 */
     42,  35,   7,   0,  /* "chul" 72861 */
     42,  29,   7,   1,   0,  /* "chula" 72866 */
     42,  35,  17,   0,  /* "chum" 72870 */
     42,  35,  17,  30,   0,  /* "chums" 72875 */
     42,  35,  13,   0,  /* "chun" 72879 */
     42,  44,  42,  17,   1,  13,   0,  /* "churchmen" 72886 */
     42,  10,   5,   7,   1,   0,  /* "churilla" 72892 */
     42,  44,  12,   1,  13,   0,  /* "churkin" 72898 */
     42,  44,   7,   5,  33,   0,  /* "churlish" 72904 */
     42,  41,  29,  30,   0,  /* "chuse" 72909 */
     42,  51,  14,  17,   5,   4,   0,  /* "chusmir" 72916 */
     33,  29,   3,   0,  /* "chute" 72920 */
     33,  29,   3,  14,   0,  /* "chutes" 72925 */
     42,  35,   3,  14,   6,   8,   0,  /* "chutzpah" 72932 */
     42,  26,  12,   8,   3,  12,   1,   0,  /* "chykatka" 72940 */
     42,   5,  13,  52,  15,  16,   0,  /* "chynoweth" 72947 */
     42,  39,   4,   1,  13,   0,  /* "chyron" 72953 */
     14,  23,   1,   0,  /* "cia" 72957 */
     42,  26,   1,  42,  23,   1,   0,  /* "ciaccia" 72964 */
     33,  23,  13,   0,  /* "cian" 72968 */
     42,  18,  13,  42,  26,   0,  /* "cianci" 72974 */
     42,  18,  13,  42,  26,  27,   0,  /* "ciancio" 72981 */
     42,  18,  13,  42,  27,   7,   1,   0,  /* "cianciola" 72989 */
     42,  18,  13,  42,  27,   7,  27,   0,  /* "cianciolo" 72997 */
     42,  18,  13,  42,  29,   7,  26,   0,  /* "cianciulli" 73005 */
     42,  18,  13,  26,   0,  /* "ciani" 73010 */
     42,  26,   8,  13,  27,   0,  /* "ciano" 73016 */
     42,  48,   9,  21,   7,   1,   0,  /* "ciaobella" 73023 */
     42,  10,  19,  17,  21,   7,   1,   0,  /* "ciaramella" 73031 */
     42,  44,  19,  17,  26,   3,  19,   4,  27,   0,  /* "ciaramitaro" 73041 */
     42,  44,  20,  26,   0,  /* "ciardi" 73046 */
     42,  44,   7,  27,   0,  /* "ciarlo" 73051 */
     42,   1,  22,  19,   4,  21,   7,   1,   0,  /* "ciavarella" 73060 */
     14,  23,   9,   1,   0,  /* "ciba" 73065 */
     42,   1,   9,  10,  18,  37,  14,  12,  26,   0,  /* "ciborowski" 73075 */
     42,  26,   9,  29,   7,   1,   0,  /* "cibula" 73082 */
     14,   1,  12,   2,  20,   1,   0,  /* "cicada" 73089 */
     14,  31,  12,   2,  20,   1,  30,   0,  /* "cicadas" 73097 */
     14,  31,  12,   8,   7,   1,   0,  /* "cicala" 73104 */
     42,  26,  12,  19,   7,   2,  30,  26,   0,  /* "cicalese" 73113 */
     42,  26,  12,  10,  21,   7,  26,   0,  /* "ciccarelli" 73121 */
     42,  26,  12,  10,  21,   7,  27,   0,  /* "ciccarello" 73129 */
     42,  26,  12,  25,  13,  26,   0,  /* "ciccone" 73136 */
     14,   5,  14,   1,   7,  26,   0,  /* "cicely" 73143 */
     14,   5,  14,  10,  25,   0,  /* "cicero" 73149 */
     14,   5,  14,  10,  25,  13,   0,  /* "cicerone" 73156 */
     14,  31,  42,   8,  12,  26,   0,  /* "cichocki" 73163 */
     42,   5,  38,  18,  37,  14,  12,  26,   0,  /* "cichowski" 73172 */
     42,   5,  42,   1,   7,  26,   0,  /* "cicily" 73179 */
     14,   1,  14,   5,   6,  26,  27,   0,  /* "cicippio" 73187 */
     14,   5,  20,   0,  /* "cid" 73191 */
     14,  39,  20,  10,   0,  /* "cider" 73196 */
     14,  23,   0,  /* "cie" 73199 */
     14,  23,   7,   0,  /* "ciel" 73203 */
     14,  23,   4,   1,   0,  /* "ciera" 73208 */
     14,  23,   4,  26,   0,  /* "cieri" 73213 */
     42,  15,  14,  23,   7,  14,  12,  26,   0,  /* "ciesielski" 73222 */
     42,  21,  14,   7,   1,   0,  /* "ciesla" 73228 */
     42,  21,  14,   7,   1,  12,   0,  /* "cieslak" 73235 */
     42,  21,  14,   7,  31,  22,  31,  42,   0,  /* "cieslewicz" 73244 */
     42,  21,  14,   7,  31,  12,   0,  /* "cieslik" 73251 */
     42,  15,  14,   7,   5,  13,  14,  12,  26,   0,  /* "cieslinski" 73261 */
     14,   1,  37,  21,   7,  26,   0,  /* "cifelli" 73268 */
     14,  26,  37,  47,  21,  13,   3,  15,  14,   0,  /* "cifuentes" 73278 */
     14,  23,  11,   1,   0,  /* "ciga" 73283 */
     14,  31,  11,   8,   4,   0,  /* "cigar" 73289 */
     14,   5,  11,  10,  21,   3,   0,  /* "cigarette" 73296 */
     14,   5,  11,  10,  21,   3,  14,   0,  /* "cigarettes" 73304 */
     14,  31,  11,   8,   4,  30,   0,  /* "cigars" 73311 */
     14,   5,  11,  13,   1,   0,  /* "cigna" 73317 */
     14,   1,   7,  24,  13,   3,   4,  27,   0,  /* "cilantro" 73326 */
     14,   5,   7,  12,  36,   4,   6,   0,  /* "cilcorp" 73334 */
     14,   1,   7,  21,  13,   3,  27,   0,  /* "cilento" 73342 */
     14,   5,   7,  26,   1,   3,  14,   0,  /* "ciliates" 73350 */
     42,  26,   7,  26,   9,  21,   4,   3,  27,   0,  /* "ciliberto" 73360 */
     14,   1,   7,   5,  33,   1,   0,  /* "cilicia" 73367 */
     14,   1,   7,  29,  37,  27,   0,  /* "cilluffo" 73374 */
     42,  23,  17,   1,   0,  /* "cima" 73379 */
     14,   5,  17,  24,  11,   7,  26,   1,   0,  /* "cimaglia" 73388 */
     14,   5,  17,  10,   8,  13,   0,  /* "cimarron" 73395 */
     14,   5,  17,  21,  13,   3,  14,   0,  /* "ciments" 73403 */
     14,  23,  17,   1,  13,  21,   4,  27,   0,  /* "ciminero" 73412 */
     42,  26,  17,  23,  13,  26,   0,  /* "cimini" 73419 */
     42,  26,  17,  23,  13,  27,   0,  /* "cimino" 73426 */
     42,  26,  17,  23,  13,  27,   0,  /* "cimmino" 73433 */
     42,  23,  17,  27,   0,  /* "cimo" 73438 */
     42,  26,  17,  36,   4,  21,   7,  26,   0,  /* "cimorelli" 73447 */
     42,  23,  13,   1,   0,  /* "cina" 73452 */
     14,   5,  13,  14,   1,  13,  24,   3,  26,   0,  /* "cincinnati" 73462 */
     42,  26,  13,  12,  25,   3,   1,   0,  /* "cincotta" 73470 */
     14,  39,  13,  20,  26,   0,  /* "cindie" 73476 */
     14,   1,  13,  21,   7,  26,   0,  /* "cinelli" 73483 */
     14,   5,  13,   1,  17,   8,  12,   0,  /* "cinemark" 73491 */
     14,   5,  13,   1,  17,  34,  12,  14,   0,  /* "cinemax" 73500 */
     14,   5,  13,   1,   6,   7,  21,  12,  14,   0,  /* "cineplex" 73510 */
     14,   5,  13,  10,  40,  26,   0,  /* "cinergy" 73517 */
     42,  23,  13,  26,   0,  /* "cini" 73522 */
     14,   5,  13,   1,   9,  18,  13,   0,  /* "cinnabon" 73530 */
     42,  23,  13,  27,   0,  /* "cino" 73535 */
     14,   5,  32,  12,   0,  /* "cinq" 73540 */
     42,  26,  13,  12,  47,  15,  17,   8,  13,  26,   0,  /* "cinquemani" 73551 */
     14,   5,  13,   4,  34,  17,   0,  /* "cinram" 73558 */
     14,   5,  13,   3,   4,   1,  13,   0,  /* "cintron" 73566 */
     42,  25,  12,   1,   0,  /* "ciocca" 73571 */
     42,  26,  25,  37,  26,   0,  /* "cioffi" 73577 */
     42,  26,  25,   7,  15,  12,   0,  /* "ciolek" 73584 */
     42,  27,   7,  23,  13,  27,   0,  /* "ciolino" 73591 */
     42,  25,   3,  26,   0,  /* "ciotti" 73596 */
     14,  39,  37,  10,   0,  /* "cipher" 73601 */
     14,   5,   6,   1,   7,  25,  13,   0,  /* "cipollone" 73609 */
     42,  26,   6,   4,  26,   8,  13,  26,   0,  /* "cipriani" 73618 */
     42,  26,   6,   4,  26,   8,  13,  27,   0,  /* "cipriano" 73627 */
     14,  44,   1,   0,  /* "cira" 73631 */
     14,  10,  18,   7,  27,   0,  /* "ciraulo" 73637 */
     14,  10,  12,   2,  20,  26,   1,  13,   0,  /* "circadian" 73646 */
     14,  44,  12,   1,   7,   0,  /* "circle" 73652 */
     14,  44,  12,   1,   7,  20,   0,  /* "circled" 73659 */
     14,  44,  12,   1,   7,  30,   0,  /* "circles" 73666 */
     14,  44,  12,   1,   7,  31,  32,   0,  /* "circling" 73674 */
     14,  44,  12,  19,  13,   0,  /* "circon" 73680 */
     14,  44,  12,   1,   3,   1,  20,   0,  /* "circuited" 73688 */
     14,  10,  12,  41,  29,   1,   3,   1,  14,   0,  /* "circuitous" 73698 */
     14,  44,  12,  41,   1,   7,  10,   0,  /* "circular" 73706 */
     14,  44,  12,  41,   1,   7,  10,   7,  26,   0,  /* "circularly" 73716 */
     14,  44,  12,  41,   1,   7,  10,  30,   0,  /* "circulars" 73725 */
     14,  44,  12,  41,   1,   7,   2,   3,   0,  /* "circulate" 73734 */
     14,  44,  12,  41,   1,   7,   2,   3,   1,  20,   0,  /* "circulated" 73745 */
     14,  44,  12,  41,   1,   7,   2,   3,  14,   0,  /* "circulates" 73755 */
     14,  44,  12,  41,   1,   7,   2,   3,  31,  32,   0,  /* "circulating" 73766 */
     14,  44,  12,  41,   1,   7,   2,  33,   1,  13,   0,  /* "circulation" 73777 */
     14,  44,  12,  41,   1,   7,   2,  33,   1,  13,  30,   0,  /* "circulations" 73789 */
     14,  44,  12,  41,   1,   7,   1,   3,  18,   4,  26,   0,  /* "circulatory" 73801 */
     14,  44,  12,   1,  17,  14,  39,  30,   0,  /* "circumcise" 73810 */
     14,  44,  12,   1,  17,  14,  39,  30,  20,   0,  /* "circumcised" 73820 */
     14,  44,  12,   1,  17,  14,   5,  43,   1,  13,   0,  /* "circumcision" 73831 */
     14,  10,  12,  35,  17,  37,   4,   1,  13,  14,   0,  /* "circumference" 73842 */
     14,  44,  12,   1,  17,  14,  12,   4,  39,   9,   0,  /* "circumscribe" 73853 */
     14,  44,  12,   1,  17,  14,  12,   4,  39,   9,  20,   0,  /* "circumscribed" 73865 */
     14,  44,  12,   1,  17,  22,  23,  13,   0,  /* "circumvene" 73874 */
     14,  44,  12,   1,  17,  22,  21,  13,  42,   1,  13,   0,  /* "circumvention" 73886 */
     14,  44,  12,   1,  17,  22,  21,  13,   3,  14,   0,  /* "circumvents" 73897 */
     14,  10,  21,  14,  26,   0,  /* "ciresi" 73903 */
     14,   5,   4,  26,   8,  12,  27,   0,  /* "ciriaco" 73911 */
     14,  10,  26,  21,   7,  27,   0,  /* "ciriello" 73918 */
     14,  10,  26,  11,   7,  26,   8,  13,  27,   0,  /* "cirigliano" 73928 */
     14,  31,   4,   5,   7,  27,   0,  /* "cirillo" 73935 */
     14,  10,  26,  13,  42,  25,  13,  26,   0,  /* "cirincione" 73944 */
     14,  44,  12,   1,  13,   0,  /* "cirkin" 73950 */
     14,   5,   4,  25,  30,   0,  /* "ciros" 73956 */
     14,  10,  25,  14,   1,  14,   0,  /* "cirrhosis" 73963 */
     14,  10,   4,  26,  13,  42,  25,  13,  26,   0,  /* "cirrincione" 73973 */
     14,   5,   4,   1,  14,   0,  /* "cirrus" 73979 */
     42,   5,  14,  15,  12,   0,  /* "cisek" 73985 */
     42,   5,  14,  21,  37,  14,  12,  26,   0,  /* "cisewski" 73994 */
     14,   5,  14,   1,   7,  10,   0,  /* "cisler" 74001 */
     42,  23,  14,   7,  27,   0,  /* "cislo" 74007 */
     14,   5,  14,  13,  21,   4,  27,  14,   0,  /* "cisneros" 74016 */
     14,   5,  14,   3,   0,  /* "cist" 74021 */
     14,   5,  14,   3,  10,  13,  30,   0,  /* "cisterns" 74029 */
     42,   5,  33,  15,  12,   0,  /* "ciszek" 74035 */
     42,   5,  33,  21,  37,  14,  12,  26,   0,  /* "ciszewski" 74044 */
     14,   5,   3,   1,  20,  21,   7,   0,  /* "citadel" 74052 */
     14,  39,   3,   2,  33,   1,  13,   0,  /* "citation" 74060 */
     14,  39,   3,   2,  33,   1,  13,  30,   0,  /* "citations" 74069 */
     14,  39,   3,   0,  /* "cite" 74073 */
     14,  39,   3,   1,  20,   0,  /* "cited" 74079 */
     14,  39,   3,  14,   0,  /* "cites" 74084 */
     14,   5,   3,  26,   0,  /* "citi" 74089 */
     14,   5,   3,  26,   9,  24,  32,  12,   0,  /* "citibank" 74098 */
     14,   5,   3,  26,  12,  18,   4,   6,  14,   0,  /* "citicorps" 74108 */
     14,  39,   3,  31,  32,   0,  /* "citing" 74114 */
     14,   5,   3,  26,  14,   3,  23,   7,   0,  /* "citisteel" 74123 */
     42,  26,   3,   4,   8,  13,  27,   0,  /* "citrano" 74131 */
     14,   5,   3,   4,  23,  13,   0,  /* "citrine" 74138 */
     14,   5,   3,   4,  27,  13,   0,  /* "citroen" 74145 */
     14,   5,   3,   4,   1,  13,   0,  /* "citron" 74152 */
     14,   5,   3,   4,  19,  13,  21,   7,   1,   0,  /* "citronella" 74162 */
     14,   5,   3,   4,   1,  14,  29,  12,  27,   0,  /* "citrosuco" 74172 */
     14,   5,   3,   4,   1,  14,  21,   7,   0,  /* "citrucel" 74181 */
     42,  26,   3,  19,  20,  23,  13,  27,   0,  /* "cittadino" 74190 */
     14,   5,   3,  26,   0,  /* "city" 74195 */
     14,   5,   3,  26,  37,  21,  20,   0,  /* "cityfed" 74203 */
     14,   5,   3,  26,   6,   7,   2,  14,   0,  /* "cityplace" 74212 */
     14,   5,   3,  26,  14,  39,  20,   0,  /* "cityside" 74220 */
     14,   5,   3,  26,  47,  39,  20,   0,  /* "citywide" 74228 */
     42,  29,  42,  26,   0,  /* "ciucci" 74233 */
     14,  23,  29,  20,  24,  20,   0,  /* "ciudad" 74240 */
     42,  29,   7,   1,   0,  /* "ciulla" 74245 */
     42,  29,   7,  27,   0,  /* "ciullo" 74250 */
     14,  23,  22,   1,   7,  21,   3,  26,   0,  /* "civiletti" 74259 */
     14,   1,  22,   5,   7,  41,   1,  13,   0,  /* "civilian" 74268 */
     14,   1,  22,   5,   7,  41,   1,  13,  30,   0,  /* "civilians" 74278 */
     14,   1,  22,   5,   7,   1,   3,  26,   0,  /* "civility" 74287 */
     14,   5,  22,   1,   7,  39,  30,   0,  /* "civilize" 74295 */
     14,   5,  22,   1,   7,  39,  30,  20,   0,  /* "civilized" 74304 */
     42,  26,  22,  26,   3,  21,   7,  27,   0,  /* "civitello" 74313 */
     42,   5,  30,  15,  12,   0,  /* "cizek" 74319 */
     14,  23,  30,  31,  12,   0,  /* "cizik" 74325 */
     14,   5,  30,  13,  21,   4,  27,  14,   0,  /* "cizneros" 74334 */
     12,   7,   8,  14,   1,  13,   0,  /* "claassen" 74341 */
     12,   7,  24,   9,  31,   4,   0,  /* "clabir" 74348 */
     12,   7,  24,   9,  52,   0,  /* "clabough" 74354 */
     12,   7,  24,  12,   1,  17,   1,  14,   0,  /* "clackamas" 74363 */
     12,   7,  24,  20,   0,  /* "clad" 74368 */
     12,   7,  24,  20,  35,   0,  /* "claddagh" 74374 */
     12,   7,   2,  30,   0,  /* "claes" 74379 */
     12,   7,   2,  30,   0,  /* "claeys" 74384 */
     12,   7,  24,  40,   5,   3,   0,  /* "clagett" 74391 */
     12,   7,  24,  11,   5,   3,   0,  /* "claggett" 74398 */
     12,   7,   8,  11,   0,  /* "clague" 74403 */
     12,   7,   2,   9,  10,  13,   0,  /* "claiborne" 74410 */
     12,   7,  21,   4,  17,   1,  13,   3,   0,  /* "clairmont" 74419 */
     12,   7,  21,   4,  19,   7,   0,  /* "clairol" 74426 */
     12,   7,  15,   4,  22,  49,   1,  13,  14,   0,  /* "clairvoyance" 74436 */
     12,   7,  15,   4,  22,  49,   1,  13,   3,   0,  /* "clairvoyant" 74446 */
     12,   7,  24,  17,   0,  /* "clam" 74451 */
     12,   7,   2,  17,   1,  13,   0,  /* "clamen" 74458 */
     12,   7,   1,  17,   6,   5,   3,   0,  /* "clampitt" 74466 */
     12,   7,  24,  17,  33,  21,   7,   0,  /* "clamshell" 74474 */
     12,   7,  24,  13,   0,  /* "clan" 74479 */
     12,   7,  34,  13,  20,  21,  14,   3,   1,  13,   0,  /* "clandestine" 74490 */
     12,   7,  34,  13,  20,  21,  14,   3,   1,  13,   7,  26,   0,  /* "clandestinely" 74503 */
     12,   7,  24,  32,  31,  32,   0,  /* "clanging" 74510 */
     12,   7,  24,   6,   0,  /* "clap" 74515 */
     12,   7,  24,   6,   9,  18,   4,  20,   0,  /* "clapboard" 74524 */
     12,   7,  24,   6,   9,  18,   4,  20,  30,   0,  /* "clapboards" 74534 */
     12,   7,  24,   6,  14,  24,  20,   1,   7,   0,  /* "clapsaddle" 74544 */
     12,   7,   8,   4,   0,  /* "clar" 74549 */
     12,   7,  24,   4,   1,   0,  /* "clara" 74555 */
     12,   7,  24,   4,   1,   9,  21,   7,   0,  /* "clarabelle" 74564 */
     12,   7,  19,   4,   8,  17,  39,   0,  /* "claramae" 74572 */
     12,   7,  21,   4,   1,  13,   0,  /* "claran" 74579 */
     12,   7,  21,   4,  17,   8,  13,   3,   0,  /* "claremont" 74588 */
     12,   7,  24,   4,   1,  13,   0,  /* "claren" 74595 */
     12,   7,  19,   4,  21,  14,   3,   1,   0,  /* "claresta" 74604 */
     12,   7,  24,   4,  26,   0,  /* "clarey" 74610 */
     12,   7,  21,   4,   1,   9,  21,   7,   0,  /* "claribel" 74619 */
     12,   7,  10,  23,  14,   0,  /* "clarice" 74625 */
     12,   7,  19,   4,  23,  20,   1,   0,  /* "clarida" 74633 */
     12,   7,  21,   4,  31,  40,   0,  /* "claridge" 74640 */
     12,   7,  21,   4,  31,  40,   1,  30,   0,  /* "claridges" 74649 */
     12,   7,  21,   4,   1,  37,  31,  12,   2,  33,   1,  13,   0,  /* "clarification" 74662 */
     12,   7,  21,   4,   1,  37,  31,  12,   2,  33,   1,  13,  30,   0,  /* "clarifications" 74676 */
     12,   7,  21,   4,   1,  37,  39,  20,   0,  /* "clarified" 74685 */
     12,   7,  21,   4,   1,  37,  39,  30,   0,  /* "clarifies" 74694 */
     12,   7,  21,   4,   1,  37,  39,   0,  /* "clarify" 74702 */
     12,   7,  21,   4,   1,  37,  39,  31,  32,   0,  /* "clarifying" 74712 */
     12,   7,  24,   4,   1,  17,   1,  13,  20,   0,  /* "clarimond" 74722 */
     12,   7,  10,   5,  13,  20,   1,   0,  /* "clarinda" 74730 */
     12,   7,  21,   4,  26,  13,   0,  /* "clarine" 74737 */
     12,   7,  21,   4,   1,  13,  21,   3,   0,  /* "clarinet" 74746 */
     12,   7,  21,   4,   1,  13,  21,   3,   1,  14,   3,   0,  /* "clarinetist" 74758 */
     12,   7,  21,   4,   1,  13,  21,   3,   1,  14,   3,  14,   0,  /* "clarinetists" 74771 */
     12,   7,  21,   4,  26,   1,  13,   0,  /* "clarion" 74779 */
     12,   7,  10,   5,  14,   1,   0,  /* "clarissa" 74786 */
     12,   7,  24,   4,  26,  14,   0,  /* "clarisse" 74793 */
     12,   7,  19,   4,  23,   3,   1,   0,  /* "clarita" 74801 */
     12,   7,   8,   4,  12,  15,  13,   0,  /* "clarken" 74809 */
     12,   7,  21,   4,   1,  14,   3,  24,   3,   0,  /* "clarostat" 74819 */
     12,   7,  24,   4,  31,  40,   0,  /* "clarridge" 74826 */
     12,   7,  24,   4,   5,  14,   0,  /* "clarrisse" 74833 */
     12,   7,  24,  14,  24,  12,  33,   1,  13,   0,  /* "classaction" 74843 */
     12,   7,  24,  14,  31,  12,   0,  /* "classic" 74850 */
     12,   7,  24,  14,  31,  12,   1,   7,   0,  /* "classical" 74859 */
     12,   7,  24,  14,  31,  12,   7,  26,   0,  /* "classically" 74868 */
     12,   7,  24,  14,   1,  14,   5,  30,   1,  17,   0,  /* "classicism" 74879 */
     12,   7,  24,  14,   1,  14,   1,  14,   3,   0,  /* "classicist" 74889 */
     12,   7,  24,  14,   1,  37,  39,   1,   9,   1,   7,   0,  /* "classifiable" 74901 */
     12,   7,  24,  14,   1,  37,  39,  20,   0,  /* "classified" 74910 */
     12,   7,  24,  14,   1,  37,  39,  30,   0,  /* "classifies" 74919 */
     12,   7,  24,  14,   1,  37,  39,   0,  /* "classify" 74927 */
     12,   7,  24,  14,   1,  37,  39,  31,  32,   0,  /* "classifying" 74937 */
     12,   7,  24,  14,   4,  29,  17,   0,  /* "classroom" 74945 */
     12,   7,  24,  14,   4,  29,  17,  30,   0,  /* "classrooms" 74954 */
     12,   7,  36,  20,  21,   3,   0,  /* "claudet" 74961 */
     12,   7,  27,  20,  21,   3,   0,  /* "claudette" 74968 */
     12,   7,  18,  20,  26,  13,   1,   0,  /* "claudina" 74976 */
     12,   7,  36,  20,  23,  13,   0,  /* "claudine" 74983 */
     12,   7,  18,  20,  26,  25,   0,  /* "claudio" 74990 */
     12,   7,  48,  14,   1,  13,   0,  /* "clausen" 74997 */
     12,   7,  18,  30,  10,   0,  /* "clauser" 75003 */
     12,   7,  18,  30,   1,  13,   0,  /* "clauson" 75010 */
     12,   7,  18,  30,  14,   1,  13,   0,  /* "claussen" 75018 */
     12,   7,   1,  22,  21,   3,   0,  /* "clavette" 75025 */
     12,   7,  24,  22,   1,  12,  18,   4,  20,   0,  /* "clavichord" 75035 */
     12,   7,  24,  22,   1,  12,   1,   7,   0,  /* "clavicle" 75044 */
     12,   7,  24,  22,   1,  13,   0,  /* "clavin" 75051 */
     12,   7,  18,   0,  /* "claw" 75055 */
     12,   7,  24,  12,  14,   1,  13,   0,  /* "claxon" 75063 */
     12,   7,  24,  12,  14,   3,   1,  13,   0,  /* "claxton" 75072 */
     12,   7,   2,   0,  /* "clay" 75076 */
     12,   7,   2,   9,  10,  13,   0,  /* "clayborne" 75083 */
     12,   7,   2,   9,  10,  13,   0,  /* "claybourne" 75090 */
     12,   7,   2,   9,   4,  45,  12,  14,   0,  /* "claybrooks" 75099 */
     12,   7,   2,   9,  44,  13,   0,  /* "clayburn" 75106 */
     12,   7,   2,  17,  18,   4,   0,  /* "claymore" 75113 */
     12,   7,   2,   6,  29,   7,   0,  /* "claypool" 75120 */
     12,   7,   2,   6,  29,   7,   0,  /* "claypoole" 75127 */
     12,  23,   1,   0,  /* "cleah" 75131 */
     12,   7,  23,  13,  31,  32,   0,  /* "cleaning" 75138 */
     12,   7,  21,  13,   7,  26,  13,   1,  14,   0,  /* "cleanliness" 75148 */
     12,   7,  23,  13,  13,   1,  14,   0,  /* "cleanness" 75156 */
     12,   7,  23,  13,  30,   0,  /* "cleans" 75162 */
     12,   7,  21,  13,  30,  20,   0,  /* "cleansed" 75169 */
     12,   7,  21,  13,  30,  31,  32,   0,  /* "cleansing" 75177 */
     12,   7,  23,  13,  16,   1,   0,  /* "cleantha" 75184 */
     12,   7,   5,   4,   0,  /* "clear" 75189 */
     12,   7,   5,   4,  12,  35,   3,   0,  /* "clearcut" 75197 */
     12,   7,   5,   4,  12,  35,   3,  14,   0,  /* "clearcuts" 75206 */
     12,   7,   5,   4,  12,  35,   3,  31,  32,   0,  /* "clearcutting" 75216 */
     12,   7,   5,   4,  31,  32,   0,  /* "clearing" 75223 */
     12,   7,   5,   4,  31,  32,  38,  48,  14,   0,  /* "clearinghouse" 75233 */
     12,   7,  23,   4,  31,  32,  38,  48,  14,   1,  30,   0,  /* "clearinghouses" 75245 */
     12,   7,   5,   4,   7,  26,   0,  /* "clearly" 75252 */
     12,   7,  23,   3,   0,  /* "cleat" 75257 */
     12,   7,  23,   3,  14,   0,  /* "cleats" 75263 */
     12,   7,  23,  22,   1,  40,   0,  /* "cleavage" 75270 */
     12,   7,  23,  22,   1,  13,  40,  10,   0,  /* "cleavenger" 75279 */
     12,   7,  23,  14,   0,  /* "cleese" 75284 */
     12,   7,  21,  37,   0,  /* "clef" 75289 */
     12,   7,  21,  11,  38,  10,  13,   0,  /* "cleghorn" 75297 */
     12,   7,  21,  17,   0,  /* "clem" 75302 */
     12,   7,   1,  17,  21,  13,   3,  28,   0,  /* "clemente" 75311 */
     12,   7,  28,  17,   2,  13,   3,  26,   0,  /* "clementi" 75320 */
     12,   7,  28,  17,   2,  13,  33,   1,   0,  /* "clementia" 75329 */
     12,   7,  21,  17,   1,  13,   3,  39,  13,   0,  /* "clementine" 75339 */
     12,   7,  21,  17,   1,  13,   3,  14,   0,  /* "clementz" 75348 */
     12,   7,   2,  17,  27,   0,  /* "clemo" 75354 */
     12,   7,  21,  17,   1,  13,  30,   0,  /* "clemons" 75362 */
     12,   7,  21,  13,  20,   1,  13,  23,   7,   0,  /* "clendaniel" 75372 */
     12,   7,  21,  13,  20,  15,  13,   1,  13,   0,  /* "clendenin" 75382 */
     12,   7,  21,  13,  47,  10,   0,  /* "clenwar" 75389 */
     12,   7,  23,  27,   0,  /* "cleo" 75394 */
     12,   7,  23,   1,   6,  24,   3,   4,   1,   0,  /* "cleopatra" 75404 */
     12,   7,  44,  40,  26,  17,  15,  13,   0,  /* "clergymen" 75413 */
     12,   7,  21,   4,  31,  12,   0,  /* "cleric" 75420 */
     12,   7,  21,   4,   1,  12,   1,   7,   0,  /* "clerical" 75429 */
     12,   7,  21,   4,  31,  12,  14,   0,  /* "clerics" 75437 */
     12,   7,  10,  23,  14,   1,   0,  /* "clerissa" 75444 */
     12,   7,  44,  12,   5,  13,   0,  /* "clerkin" 75451 */
     12,   7,  44,  12,  14,   0,  /* "clerks" 75457 */
     12,   7,  21,   4,  17,   8,  13,   3,   0,  /* "clermont" 75466 */
     12,   7,  23,  22,   1,  13,   0,  /* "cleven" 75473 */
     12,   7,  21,  22,   1,  13,  40,  10,   0,  /* "clevenger" 75482 */
     12,   7,  23,  22,   3,   4,  35,  14,   3,   0,  /* "clevetrust" 75492 */
     12,   7,  23,  22,  26,   0,  /* "clevie" 75498 */
     12,   7,  21,  22,   1,  32,  10,   0,  /* "clevinger" 75506 */
     12,   7,   1,  22,  39,   3,   0,  /* "clevite" 75513 */
     12,   7,  21,  47,  15,   7,   0,  /* "clewell" 75520 */
     12,   7,  29,   5,  14,   0,  /* "clewis" 75526 */
     12,   7,  29,  30,   0,  /* "clews" 75531 */
     12,   7,  26,  24,  13,  16,   1,   0,  /* "cliantha" 75539 */
     12,   7,  39,   9,  10,  13,   0,  /* "cliburn" 75546 */
     12,   7,  26,  33,   2,   0,  /* "cliche" 75552 */
     12,   7,  23,  33,   2,  20,   0,  /* "cliched" 75559 */
     12,   7,  26,  33,   2,  30,   0,  /* "cliches" 75566 */
     12,   7,   5,  12,   0,  /* "click" 75571 */
     12,   7,  39,   1,  13,   3,   0,  /* "client" 75578 */
     12,   7,  39,   1,  13,   3,  21,   7,   0,  /* "clientele" 75587 */
     12,   7,  39,   1,  13,   3,  14,   0,  /* "clients" 75595 */
     12,   7,  23,   3,   0,  /* "cliett" 75600 */
     12,   7,   5,  37,   0,  /* "clif" 75605 */
     12,   7,   5,  37,  38,  24,  32,  10,   0,  /* "cliffhanger" 75614 */
     12,   7,   5,  37,  38,  24,  32,  10,  30,   0,  /* "cliffhangers" 75624 */
     12,   7,   5,  17,   0,  /* "clim" 75629 */
     12,   7,   5,  17,   1,  12,  27,   0,  /* "climaco" 75637 */
     12,   7,  39,  17,  24,  12,   3,  31,  12,   0,  /* "climactic" 75647 */
     12,   7,  39,  17,   1,   3,   0,  /* "climate" 75654 */
     12,   7,  39,  17,   1,   3,  14,   0,  /* "climates" 75662 */
     12,   7,  39,  17,  24,   3,  31,  12,   0,  /* "climatic" 75671 */
     12,   7,   5,  17,   1,   3,   8,   7,   1,  40,   5,  14,   3,   0,  /* "climatologist" 75685 */
     12,   7,  39,  17,  24,  12,  14,   0,  /* "climax" 75693 */
     12,   7,  39,  17,  24,  12,  14,   3,   0,  /* "climaxed" 75702 */
     12,   7,   5,  17,  34,  12,  14,   1,  30,   0,  /* "climaxes" 75712 */
     12,   7,  39,  17,   0,  /* "climb" 75717 */
     12,   7,  39,  17,  20,   0,  /* "climbed" 75723 */
     12,   7,  39,  17,  10,   0,  /* "climber" 75729 */
     12,   7,  39,  17,  10,  30,   0,  /* "climbers" 75736 */
     12,   7,  39,  17,  31,  32,   0,  /* "climbing" 75743 */
     12,   7,  39,  17,  30,   0,  /* "climbs" 75749 */
     12,   7,  39,  17,  10,   0,  /* "climer" 75755 */
     12,   7,  39,  17,  30,   0,  /* "climes" 75761 */
     12,   7,  39,  13,   0,  /* "cline" 75766 */
     12,   7,  39,  13,  30,   0,  /* "clines" 75772 */
     12,   7,   5,  32,   0,  /* "cling" 75777 */
     12,   7,   5,  32,  11,   1,  13,   0,  /* "clingan" 75785 */
     12,   7,  31,  32,  11,  21,  13,   6,  26,   7,   0,  /* "clingenpeel" 75796 */
     12,   7,   5,  32,  10,   0,  /* "clinger" 75802 */
     12,   7,   5,  32,  10,  17,   1,  13,   0,  /* "clingerman" 75811 */
     12,   7,   5,  32,  17,   1,  13,   0,  /* "clingman" 75819 */
     12,   7,   5,  32,  30,   0,  /* "clings" 75825 */
     12,   7,   5,  13,   1,  12,   1,   7,   0,  /* "clinical" 75834 */
     12,   7,   5,  13,  31,  12,   1,   7,  26,   0,  /* "clinically" 75844 */
     12,   7,   1,  13,   5,  33,   1,  13,   0,  /* "clinician" 75853 */
     12,   7,   1,  13,   5,  33,   1,  13,  30,   0,  /* "clinicians" 75863 */
     12,   7,  31,  32,  12,  21,  13,   9,  10,  20,   0,  /* "clinkenbeard" 75874 */
     12,   7,   5,  32,  12,  14,  12,   2,   7,  30,   0,  /* "clinkscales" 75885 */
     12,   7,   5,  13,   3,   1,  13,  39,   3,   0,  /* "clintonite" 75895 */
     12,   7,   5,  13,   3,   1,  13,  39,   3,  14,   0,  /* "clintonites" 75906 */
     12,   7,   5,  13,   3,   1,  13,   8,  17,  31,  12,  14,   0,  /* "clintonomics" 75919 */
     12,   7,  23,  27,   0,  /* "clio" 75924 */
     12,   7,   5,   6,   0,  /* "clip" 75929 */
     12,   7,   5,  12,  14,   0,  /* "cliques" 75935 */
     12,   7,  39,   3,  14,   0,  /* "clites" 75941 */
     12,   7,  39,   3,  18,   4,   5,  14,   0,  /* "clitoris" 75950 */
     12,   7,  39,  22,   0,  /* "clive" 75955 */
     12,   7,  39,  22,  10,   0,  /* "cliver" 75961 */
     12,   7,  25,  12,   4,  29,  17,   0,  /* "cloakroom" 75969 */
     12,   7,   8,  12,  47,  39,  30,   0,  /* "clockwise" 75977 */
     12,   7,   8,  20,  37,  21,   7,   3,  10,   0,  /* "clodfelter" 75987 */
     12,   7,  27,  20,  25,  22,  26,  27,   0,  /* "clodoveo" 75996 */
     12,   7,  25,   0,  /* "cloe" 76000 */
     12,   7,  25,  10,   0,  /* "cloer" 76005 */
     12,   7,   8,  11,   0,  /* "clog" 76010 */
     12,   7,  18,  11,  20,   0,  /* "clogged" 76016 */
     12,   7,   8,  38,  10,   3,  26,   0,  /* "cloherty" 76024 */
     12,   7,   8,  38,  15,  14,  26,   0,  /* "clohessy" 76032 */
     12,   7,  25,  17,   1,   6,   4,   1,  17,  39,  13,   0,  /* "clomipramine" 76044 */
     12,   7,  29,  13,   1,  13,   0,  /* "cloonan" 76051 */
     12,   7,  29,  13,  26,   0,  /* "clooney" 76057 */
     12,   7,  29,   3,  26,   0,  /* "clootie" 76063 */
     12,   7,  36,   4,  23,  13,  20,   1,   0,  /* "clorinda" 76072 */
     12,   7,  18,   4,  19,  12,  14,   0,  /* "clorox" 76080 */
     12,   7,   8,  14,   0,  /* "clos" 76085 */
     12,   7,  25,  14,   0,  /* "close" 76090 */
     12,   7,  25,  30,   0,  /* "close" 76095 */
     12,   7,  25,  14,   7,  26,   0,  /* "closely" 76102 */
     12,   7,  25,  14,  13,   1,  14,   0,  /* "closeness" 76110 */
     12,   7,  25,  14,  10,   0,  /* "closer" 76116 */
     12,   7,   8,  30,   1,   3,   1,  20,   0,  /* "closeted" 76125 */
     12,   7,   8,  30,   1,   3,  14,   0,  /* "closets" 76133 */
     12,   7,  25,  14,  35,   6,   0,  /* "closeup" 76140 */
     12,   7,  25,  14,  35,   6,  14,   0,  /* "closeups" 76148 */
     12,   7,   8,  14,   1,  13,   0,  /* "closson" 76155 */
     12,   7,  25,  43,  10,   0,  /* "closure" 76161 */
     12,   7,  25,  43,  10,  30,   0,  /* "closures" 76168 */
     12,   7,   8,   3,   0,  /* "clot" 76173 */
     12,   7,   8,   3,  37,  21,   7,   3,  10,   0,  /* "clotfelter" 76183 */
     12,   7,  18,  16,   0,  /* "cloth" 76188 */
     12,   7,  25,  46,  20,   0,  /* "clothed" 76194 */
     12,   7,  25,  30,  38,  18,   4,  14,   0,  /* "clotheshorse" 76203 */
     12,   7,  25,  46,  30,   3,  39,  17,   0,  /* "clothestime" 76212 */
     12,   7,  25,  46,  41,  10,   0,  /* "clothier" 76219 */
     12,   7,  25,  46,  41,  10,  30,   0,  /* "clothiers" 76227 */
     12,   7,   1,  16,   5,   7,  20,   1,   0,  /* "clothilda" 76236 */
     12,   7,   8,  16,   5,   7,  20,   0,  /* "clothilde" 76244 */
     12,   7,  25,  46,  31,  32,   0,  /* "clothing" 76251 */
     12,   7,  18,  16,  14,   0,  /* "cloths" 76257 */
     12,   7,   1,   3,   5,   7,  20,   1,   0,  /* "clotilda" 76266 */
     12,   7,  25,  42,  10,   0,  /* "cloture" 76272 */
     12,   7,  48,   1,   3,   4,   0,  /* "clouatre" 76279 */
     12,   7,  48,  20,   9,  44,  14,   3,   0,  /* "cloudburst" 76288 */
     12,   7,  25,  22,  10,   0,  /* "clover" 76294 */
     12,   7,  25,  22,  10,   7,  23,  37,   0,  /* "cloverleaf" 76303 */
     12,   7,  25,  22,   5,  14,   0,  /* "clovis" 76310 */
     12,   7,  25,   0,  /* "clow" 76314 */
     12,   7,  25,  47,  10,  20,   0,  /* "cloward" 76321 */
     12,   7,  48,  30,   0,  /* "clowes" 76326 */
     12,   7,  48,  13,   0,  /* "clown" 76331 */
     12,   7,  48,  13,  26,   0,  /* "clowney" 76337 */
     12,   7,  48,  13,  31,  32,   0,  /* "clowning" 76344 */
     12,   7,  48,  13,  30,   0,  /* "clowns" 76350 */
     12,   7,  49,   0,  /* "cloy" 76354 */
     12,   7,  25,  30,   1,   6,  39,  13,   0,  /* "clozapine" 76363 */
     12,   7,  35,   9,   0,  /* "club" 76368 */
     12,   7,  29,  12,   1,  30,   0,  /* "clucas" 76375 */
     12,   7,  29,   0,  /* "clue" 76379 */
     12,   7,  29,  20,   0,  /* "clued" 76384 */
     12,   7,  29,   7,   1,  14,   0,  /* "clueless" 76391 */
     12,   7,  29,  30,   0,  /* "clues" 76396 */
     12,   7,  29,   5,   3,   0,  /* "cluett" 76402 */
     12,   7,  29,  40,   0,  /* "cluj" 76407 */
     12,   7,  29,  12,  26,   0,  /* "clukey" 76413 */
     12,   7,  35,  17,   0,  /* "clum" 76418 */
     12,   7,  35,  17,  30,  26,  13,   1,  14,   0,  /* "clumsiness" 76428 */
     12,   7,  29,  13,   0,  /* "clune" 76433 */
     12,   7,  29,  13,  26,   0,  /* "cluny" 76439 */
     12,   7,  29,   3,   0,  /* "clute" 76444 */
     12,   7,  35,   3,  10,  20,   0,  /* "cluttered" 76451 */
     12,   7,  39,   1,   3,   0,  /* "clyatt" 76457 */
     12,   7,  39,  20,   0,  /* "clyde" 76462 */
     12,   7,  39,  20,  30,  20,   2,   7,   0,  /* "clydesdale" 76471 */
     12,   7,   5,  17,  23,  13,   0,  /* "clymene" 76478 */
     12,   7,  39,  17,  10,   0,  /* "clymer" 76484 */
     12,   7,  39,  13,   0,  /* "clyne" 76489 */
     12,   7,  39,   3,   0,  /* "clyte" 76494 */
     12,   7,  39,  22,   0,  /* "clyve" 76499 */
     14,  23,  17,  27,  14,   0,  /* "cmos" 76505 */
     12,   1,  17,  21,  12,  14,   0,  /* "cmx" 76512 */
     14,  23,  21,  13,  21,  13,   0,  /* "cnn" 76519 */
     14,  23,  21,  13,  21,  13,  21,  37,  21,  13,   0,  /* "cnnfn" 76530 */
     12,  25,   0,  /* "co" 76533 */
     12,  25,  20,   0,  /* "coad" 76537 */
     12,  27,  24,  11,  41,   1,   7,   2,   3,   0,  /* "coagulate" 76547 */
     12,  27,  24,  11,  41,   1,   7,   2,   3,  31,  32,   0,  /* "coagulating" 76559 */
     12,  27,  34,  11,  41,   1,   7,   2,  33,   1,  13,   0,  /* "coagulation" 76571 */
     12,  25,   7,   0,  /* "coal" 76575 */
     12,  25,  13,   0,  /* "coan" 76579 */
     12,  18,   4,   0,  /* "coar" 76583 */
     12,  25,  14,   3,   7,  39,  13,   0,  /* "coastline" 76591 */
     12,  25,  14,   3,   7,  39,  13,  30,   0,  /* "coastlines" 76600 */
     12,  25,   3,   0,  /* "coat" 76604 */
     12,  25,   3,  14,  22,   5,   7,   0,  /* "coatesville" 76612 */
     12,  25,   3,  31,  32,   0,  /* "coating" 76618 */
     12,  25,   3,  31,  32,  30,   0,  /* "coatings" 76625 */
     12,  25,   3,   3,   2,   7,   0,  /* "coattail" 76632 */
     12,  25,   3,   3,   2,   7,  30,   0,  /* "coattails" 76640 */
     12,  25,   8,  16,  10,   0,  /* "coauthor" 76646 */
     12,  25,   8,  16,  10,  30,   0,  /* "coauthors" 76653 */
     12,  25,  12,  14,   0,  /* "coax" 76658 */
     12,  25,  12,  14,   3,   0,  /* "coaxed" 76664 */
     12,  25,  12,  14,   1,  30,   0,  /* "coaxes" 76671 */
     12,  25,  24,  12,  14,  26,   1,   7,   0,  /* "coaxial" 76680 */
     12,  25,  12,  14,  31,  32,   0,  /* "coaxing" 76687 */
     12,  25,  12,  14,   1,  17,   0,  /* "coaxum" 76694 */
     12,   8,   9,   0,  /* "cob" 76698 */
     12,   8,   9,  36,   0,  /* "cobaugh" 76703 */
     12,   8,   9,   0,  /* "cobb" 76707 */
     12,   8,   9,   5,   3,   0,  /* "cobbett" 76713 */
     12,   8,   9,   1,  13,  30,   0,  /* "cobbins" 76720 */
     12,   8,   9,   1,   7,   0,  /* "cobble" 76726 */
     12,   8,   9,   1,   7,  20,   0,  /* "cobbled" 76733 */
     12,   8,   9,   1,   7,  14,   3,  25,  13,   0,  /* "cobblestone" 76743 */
     12,   8,   9,   1,   7,  14,   3,  25,  13,  30,   0,  /* "cobblestones" 76754 */
     12,  25,   9,   0,  /* "cobe" 76758 */
     12,  27,   9,   2,   6,   1,   0,  /* "cobepa" 76765 */
     12,   8,   9,  10,  13,   0,  /* "cobern" 76771 */
     12,   8,   9,  10,   3,   0,  /* "cobert" 76777 */
     12,  25,   9,   5,  13,   0,  /* "cobin" 76783 */
     12,  25,   9,   1,   7,   0,  /* "coble" 76789 */
     12,   8,   9,   7,   1,   0,  /* "cobleigh" 76795 */
     12,   8,   9,   7,  15,  13,   3,  14,   0,  /* "coblentz" 76804 */
     12,  25,   9,   1,   7,  10,   0,  /* "cobler" 76811 */
     12,   8,   9,   7,  39,  13,  10,   0,  /* "cobliner" 76819 */
     12,  25,   9,  27,   0,  /* "cobo" 76824 */
     12,  25,   9,   4,   1,  30,   0,  /* "cobras" 76831 */
     12,   8,   9,   4,   1,   0,  /* "cobre" 76837 */
     12,   8,   9,   4,   5,  13,   0,  /* "cobrin" 76844 */
     12,   8,   9,  30,   0,  /* "cobs" 76849 */
     12,  25,   9,  10,  13,   0,  /* "coburn" 76855 */
     12,   8,   9,  47,  21,   9,  30,   0,  /* "cobwebs" 76863 */
     12,  25,   9,  26,   0,  /* "coby" 76868 */
     12,  25,  12,   1,   0,  /* "coca" 76873 */
     12,  27,  12,   2,  13,   0,  /* "cocaine" 76879 */
     12,   8,  12,   1,  13,  35,  37,  10,   0,  /* "cocanougher" 76888 */
     12,  25,  12,   1,   0,  /* "cocca" 76893 */
     12,  27,  12,   8,   4,  27,   0,  /* "coccaro" 76900 */
     12,   8,  12,   1,  14,   0,  /* "coccus" 76906 */
     12,  25,  42,  21,   4,  17,   1,  13,   0,  /* "cochairman" 76915 */
     12,   8,  33,   1,  13,  51,   4,   0,  /* "cochenour" 76923 */
     12,  25,  42,   5,  13,   0,  /* "cochin" 76929 */
     12,   8,  12,   7,  26,   1,   0,  /* "cochlea" 76936 */
     12,   8,  12,   7,  26,  10,   0,  /* "cochlear" 76943 */
     12,   8,  12,   4,   1,  13,   0,  /* "cochrane" 76950 */
     12,   8,  12,   0,  /* "cock" 76954 */
     12,  18,  12,   1,  17,   2,  17,  26,   0,  /* "cockamamie" 76963 */
     12,   8,  12,   1,   3,  29,   0,  /* "cockatoo" 76970 */
     12,   8,  12,   1,   3,  29,  30,   0,  /* "cockatoos" 76978 */
     12,  25,  12,   0,  /* "cocke" 76982 */
     12,   8,  12,  10,  21,   7,   0,  /* "cockerell" 76989 */
     12,   8,  12,  10,  38,  24,  17,   0,  /* "cockerham" 76997 */
     12,   8,  12,  39,  20,   0,  /* "cockeyed" 77003 */
     12,   8,  12,   4,   1,   7,   0,  /* "cockrill" 77010 */
     12,   8,  12,   4,   1,  37,   3,   0,  /* "cockroft" 77018 */
     12,  25,  12,  25,   0,  /* "coco" 77023 */
     12,  25,  12,  27,   0,  /* "cocoa" 77028 */
     12,  25,  12,  27,  13,  35,   3,  14,   0,  /* "cocoanuts" 77037 */
     12,  25,  12,   8,  17,   0,  /* "cocom" 77043 */
     12,  25,  12,   1,  13,  23,  13,  27,   0,  /* "coconino" 77052 */
     12,   1,  12,  29,  13,   0,  /* "cocoon" 77058 */
     12,   1,  12,  29,  13,  31,  32,   0,  /* "cocooning" 77066 */
     12,   1,  12,  29,  13,  30,   0,  /* "cocoons" 77073 */
     12,  25,  12,  25,  30,   0,  /* "cocos" 77079 */
     12,  27,  12,  25,   3,  14,   1,   0,  /* "cocozza" 77087 */
     12,  27,  12,  29,   3,  14,   1,   0,  /* "cocuzza" 77095 */
     12,   8,  20,   0,  /* "cod" 77099 */
     12,  25,  20,   1,   0,  /* "coda" 77104 */
     12,  25,  20,  24,  11,   0,  /* "codag" 77110 */
     12,   8,  20,   0,  /* "codd" 77114 */
     12,   8,  20,   1,   7,   0,  /* "coddle" 77120 */
     12,   8,  20,   1,   7,  20,   0,  /* "coddled" 77127 */
     12,   8,  20,   1,   7,  31,  32,   0,  /* "coddling" 77135 */
     12,  25,  20,   0,  /* "code" 77139 */
     12,  27,  20,  21,   7,  12,  27,   0,  /* "codelco" 77147 */
     12,   1,  20,  21,   4,   0,  /* "coderre" 77153 */
     12,  27,  20,  21,  14,   1,   0,  /* "codesa" 77160 */
     12,   8,  20,   1,  37,   1,  12,   2,  33,   1,  13,   0,  /* "codification" 77172 */
     12,   8,  20,   1,  37,  39,  20,   0,  /* "codified" 77180 */
     12,  25,  20,   1,  37,  39,  30,   0,  /* "codifies" 77188 */
     12,  25,  20,   1,  37,  39,   0,  /* "codify" 77195 */
     12,  25,  20,   1,  37,  39,  31,  32,   0,  /* "codifying" 77204 */
     12,  25,  20,  31,  32,   0,  /* "coding" 77210 */
     12,  27,  20,  26,  14,   6,  25,   3,  26,   0,  /* "codispoti" 77220 */
     12,   1,  20,   4,  21,  14,  12,  41,  29,   0,  /* "codrescu" 77230 */
     12,  25,  20,  26,   0,  /* "cody" 77235 */
     12,  25,   0,  /* "coe" 77238 */
     12,  25,   9,  10,  13,   0,  /* "coeburn" 77244 */
     12,  25,  21,  20,   0,  /* "coed" 77249 */
     12,  25,  21,  20,  30,   0,  /* "coeds" 77255 */
     12,  25,  15,  40,   1,  12,   2,  33,   1,  13,   1,   7,   0,  /* "coeducational" 77268 */
     12,  25,   1,  37,   5,  33,   1,  13,   3,   0,  /* "coefficient" 77278 */
     12,  25,   1,  37,   5,  33,   1,  13,   3,  14,   0,  /* "coefficients" 77289 */
     14,  23,   7,   1,  12,  24,  13,  16,   0,  /* "coelacanth" 77298 */
     12,  25,  21,   7,  27,   0,  /* "coelho" 77304 */
     12,  25,  21,   7,  27,   0,  /* "coello" 77310 */
     12,  25,   1,  13,   0,  /* "coen" 77315 */
     12,  27,  23,  13,   1,  13,   0,  /* "coenen" 77322 */
     12,  27,  21,  13,  30,  39,  17,   0,  /* "coenzyme" 77330 */
     12,  27,  23,  12,  47,   1,   7,   0,  /* "coequal" 77338 */
     12,  27,  44,  14,   0,  /* "coerce" 77343 */
     12,  27,  44,  14,   3,   0,  /* "coerced" 77349 */
     12,  27,  44,  14,  31,  32,   0,  /* "coercing" 77356 */
     12,  27,  44,  33,   1,  13,   0,  /* "coercion" 77363 */
     12,  27,  44,  14,  31,  22,   0,  /* "coercive" 77370 */
     12,  29,   4,   0,  /* "coeur" 77374 */
     12,  25,   1,  11,  30,   5,  14,   3,   0,  /* "coexist" 77383 */
     12,  25,   1,  11,  30,   5,  14,   3,   1,  20,   0,  /* "coexisted" 77394 */
     12,  25,  31,  11,  30,   5,  14,   3,   1,  13,  14,   0,  /* "coexistence" 77406 */
     12,  25,  31,  11,  30,   5,  14,   3,  31,  32,   0,  /* "coexisting" 77417 */
     12,  25,  26,   0,  /* "coey" 77421 */
     12,  25,  37,  44,   0,  /* "cofer" 77426 */
     12,  27,  37,   8,   4,  27,   0,  /* "coffaro" 77433 */
     12,  18,  37,  26,  38,  48,  14,   0,  /* "coffeehouse" 77441 */
     12,  18,  37,  26,  38,  48,  14,   1,  30,   0,  /* "coffeehouses" 77451 */
     12,   1,  37,  23,  13,   0,  /* "coffeen" 77457 */
     12,  18,  37,  26,  30,   0,  /* "coffees" 77463 */
     12,  18,  37,  10,   0,  /* "coffer" 77468 */
     12,   8,  37,  26,   7,  20,   0,  /* "coffield" 77475 */
     12,  25,  37,  39,  20,   0,  /* "cofide" 77481 */
     12,  18,  11,   0,  /* "cog" 77485 */
     12,   8,  11,  20,   1,   7,   0,  /* "cogdill" 77492 */
     12,  25,  40,  21,  12,  27,   0,  /* "cogeco" 77499 */
     12,  25,  11,  17,  19,   0,  /* "cogema" 77505 */
     12,  27,  40,  21,  13,  10,   2,  33,   1,  13,   0,  /* "cogeneration" 77516 */
     12,  27,  40,  21,  13,  10,   2,   3,  10,   0,  /* "cogenerator" 77526 */
     12,  27,  40,  21,  13,  10,   2,   3,  10,  30,   0,  /* "cogenerators" 77537 */
     12,  25,  40,  10,   0,  /* "coger" 77542 */
     12,   8,  11,  31,  33,  36,   7,   0,  /* "coggeshall" 77550 */
     12,   8,  11,  38,   5,   7,   0,  /* "coghill" 77557 */
     12,   8,  40,   1,   3,   2,   3,   0,  /* "cogitate" 77565 */
     12,   8,  40,   1,   3,   2,  33,   1,  13,   0,  /* "cogitation" 77575 */
     12,   8,  11,   7,  26,   0,  /* "cogley" 77581 */
     12,  27,  11,   7,  26,   1,  13,   2,  30,  26,   0,  /* "coglianese" 77592 */
     12,  27,  11,   7,  26,   8,  13,  27,   0,  /* "cogliano" 77601 */
     12,  25,  13,  41,  24,  12,   0,  /* "cognac" 77608 */
     12,   8,  11,  13,  15,  12,  14,   0,  /* "cognex" 77616 */
     12,  19,  11,  13,   5,  33,   1,  13,   0,  /* "cognition" 77625 */
     12,   8,  11,  13,  18,  33,  21,  13,   3,  26,   0,  /* "cognoscenti" 77636 */
     12,  25,  38,   1,  13,   0,  /* "cohan" 77642 */
     12,  27,  38,  24,  14,   1,   3,   0,  /* "cohasset" 77650 */
     12,   8,  38,  26,   1,   0,  /* "cohea" 77656 */
     12,   8,  38,  26,   0,  /* "cohee" 77661 */
     12,  25,   1,  13,   0,  /* "cohen" 77666 */
     12,   1,  38,  21,  13,  10,   0,  /* "cohenour" 77673 */
     12,  27,  38,   5,   4,   1,  13,  14,   0,  /* "coherence" 77682 */
     12,  27,  38,   5,   4,   1,  13,   3,   0,  /* "coherent" 77691 */
     12,  27,  38,  23,   4,   1,  13,   3,   7,  26,   0,  /* "coherently" 77702 */
     12,  27,  38,  23,  14,  31,  22,   0,  /* "cohesive" 77710 */
     12,  27,  38,  23,  14,  31,  22,   7,  26,   0,  /* "cohesively" 77720 */
     12,  27,  38,  23,  14,  31,  22,  13,   1,  14,   0,  /* "cohesiveness" 77731 */
     12,  25,  38,  31,   7,   0,  /* "cohill" 77737 */
     12,  25,  13,   0,  /* "cohn" 77741 */
     12,  25,  38,  27,   0,  /* "coho" 77746 */
     12,   1,  38,  29,  13,   0,  /* "cohoon" 77752 */
     12,  25,  38,  36,   4,   3,   0,  /* "cohort" 77759 */
     12,  25,  38,  36,   4,   3,  14,   0,  /* "cohorts" 77767 */
     12,  25,  38,  25,  14,   3,   0,  /* "cohost" 77774 */
     12,  18,   4,   0,  /* "cohr" 77778 */
     12,   8,   4,   1,  13,   0,  /* "cohron" 77784 */
     12,  25,  41,   1,   0,  /* "coia" 77789 */
     12,  49,   7,   0,  /* "coil" 77793 */
     12,  49,  13,   0,  /* "coin" 77797 */
     12,  25,   1,  13,  14,  39,  20,   0,  /* "coincide" 77805 */
     12,  25,   1,  13,  14,  39,  20,   1,  20,   0,  /* "coincided" 77815 */
     12,  27,   5,  13,  14,   1,  20,   1,  13,  14,   0,  /* "coincidence" 77826 */
     12,  27,   5,  13,  14,   1,  20,  21,  13,  14,   1,  30,   0,  /* "coincidences" 77839 */
     12,  27,   5,  13,  14,   1,  20,   1,  13,   3,   0,  /* "coincident" 77850 */
     12,  27,   5,  13,  14,   1,  20,  21,  13,   3,   1,   7,   0,  /* "coincidental" 77863 */
     12,  27,   5,  13,  14,   1,  20,  21,  13,   3,   1,   7,  26,   0,  /* "coincidentally" 77877 */
     12,  25,   1,  13,  14,  39,  20,  30,   0,  /* "coincides" 77886 */
     12,  25,   1,  13,  14,  39,  20,  31,  32,   0,  /* "coinciding" 77896 */
     12,  25,   5,  13,  33,  44,   1,  13,  14,   0,  /* "coinsurance" 77906 */
     12,  18,  13,   3,   4,  25,   0,  /* "cointreau" 77913 */
     12,  49,   3,   0,  /* "coit" 77917 */
     12,  25,  40,   1,  17,   8,   4,   0,  /* "cojimar" 77925 */
     12,  27,  47,   8,  32,  12,  27,   0,  /* "cojuangco" 77933 */
     12,  25,  12,   0,  /* "coke" 77937 */
     12,  25,   7,   1,   0,  /* "cola" 77942 */
     12,  25,   7,  24,   9,   0,  /* "colab" 77948 */
     12,  25,   7,   1,   9,  21,   7,   1,   0,  /* "colabella" 77957 */
     12,  27,   7,  19,  41,   8,  13,  26,   0,  /* "colaianni" 77966 */
     12,  25,   7,   2,  30,  26,   0,  /* "colaizzi" 77973 */
     12,  25,   7,   1,   7,  29,  12,   1,   0,  /* "colaluca" 77982 */
     12,  27,   7,  19,  32,  11,  21,   7,  27,   0,  /* "colangelo" 77992 */
     12,  27,   7,  19,  13,   3,  25,  13,  26,  27,   0,  /* "colantonio" 78003 */
     12,  27,   7,  19,  13,   3,  47,  25,  13,  27,   0,  /* "colantuono" 78014 */
     12,  25,   7,  52,   0,  /* "colao" 78019 */
     12,  27,   7,  19,   4,  29,  14,  27,   0,  /* "colarusso" 78028 */
     12,  25,   7,   1,  14,  24,  13,   3,  26,   0,  /* "colasanti" 78038 */
     12,  27,   7,  19,  14,  45,   4,  20,  27,   0,  /* "colasurdo" 78048 */
     12,  27,   7,  19,  22,  23,   3,  27,   0,  /* "colavito" 78057 */
     12,  25,   7,   9,  18,   0,  /* "colbaugh" 78063 */
     12,   8,   7,   9,  15,  12,   0,  /* "colbeck" 78070 */
     12,   8,   7,   9,  10,  11,   0,  /* "colberg" 78077 */
     12,  25,   7,   9,  36,   4,  13,   0,  /* "colborn" 78085 */
     12,  25,   7,   9,  36,   4,  13,   0,  /* "colborne" 78093 */
     12,  25,   7,   9,  26,  30,   0,  /* "colbys" 78100 */
     12,  27,   7,  12,   7,   8,  43,  10,   0,  /* "colclasure" 78109 */
     12,  25,   7,  12,  10,  20,   0,  /* "colcord" 78116 */
     12,  25,   7,  20,   0,  /* "cold" 78121 */
     12,  25,   7,  20,  10,  19,  13,   0,  /* "coldiron" 78129 */
     12,  25,   7,  20,  10,   1,  13,   0,  /* "coldren" 78137 */
     12,  25,   7,   0,  /* "cole" 78141 */
     12,  25,   7,  23,   0,  /* "colee" 78146 */
     12,  36,   7,  23,  13,   0,  /* "coleen" 78152 */
     12,  25,   7,  11,   4,  25,  22,   0,  /* "colegrove" 78160 */
     12,  25,   7,  17,   1,  13,   0,  /* "coleman" 78167 */
     12,  25,   7,   4,  31,  40,   0,  /* "coleridge" 78174 */
     12,  25,   7,  14,   7,   8,   0,  /* "coleslaw" 78181 */
     12,   8,   7,   1,  14,   1,  13,   0,  /* "coleson" 78189 */
     12,  25,   7,  14,   3,   5,   6,   8,   7,   0,  /* "colestipol" 78199 */
     12,  25,   7,  26,   1,  14,   0,  /* "coleus" 78206 */
     12,  25,   7,  11,  28,   3,   0,  /* "colgate" 78213 */
     12,  25,   7,  11,   4,   1,  22,   0,  /* "colgrove" 78221 */
     12,  25,   7,  26,   0,  /* "coli" 78226 */
     12,  25,   7,   5,  12,  26,  27,   0,  /* "colicchio" 78234 */
     12,  27,   7,  23,  13,   1,   0,  /* "colina" 78241 */
     12,  27,   7,  23,  13,   1,  14,   0,  /* "colinas" 78249 */
     12,  27,   7,  23,  13,  26,   0,  /* "coline" 78256 */
     12,  27,   7,  23,  13,  27,   0,  /* "colino" 78263 */
     12,  25,   7,   5,  14,   0,  /* "colis" 78269 */
     12,   8,   7,   1,  14,  23,   1,  17,   0,  /* "coliseum" 78278 */
     12,   8,   7,   0,  /* "coll" 78282 */
     12,  25,   7,   1,   0,  /* "colla" 78287 */
     12,   8,   7,   1,   9,  10,   2,  33,   1,  13,  30,   0,  /* "collaborations" 78299 */
     12,   1,   7,  24,   9,  10,   2,   3,  31,  22,   0,  /* "collaborative" 78310 */
     12,   1,   7,  24,   9,  10,   2,   3,  10,   0,  /* "collaborator" 78320 */
     12,   1,   7,  24,   9,  10,   2,   3,  10,  30,   0,  /* "collaborators" 78331 */
     12,  27,   7,   8,  20,  27,   0,  /* "collado" 78338 */
     12,   1,   7,   8,  43,   0,  /* "collage" 78344 */
     12,   8,   7,   1,  11,   1,  13,   0,  /* "collagen" 78352 */
     12,   1,   7,   8,  43,   1,  30,   0,  /* "collages" 78360 */
     12,  27,   7,   8,  17,  36,   4,   0,  /* "collamore" 78368 */
     12,   1,   7,  24,   6,  14,   1,   9,   1,   7,   0,  /* "collapsible" 78379 */
     12,   8,   7,  10,   0,  /* "collar" 78384 */
     12,   8,   7,  10,   9,  25,  13,   0,  /* "collarbone" 78392 */
     12,   8,   7,  10,  20,   0,  /* "collard" 78398 */
     12,   8,   7,  10,  20,  30,   0,  /* "collards" 78405 */
     12,   8,   7,  10,  20,   0,  /* "collared" 78411 */
     12,   8,   7,  10,  30,   0,  /* "collars" 78417 */
     12,   1,   7,  24,   3,  10,   1,   7,  39,  30,   0,  /* "collateralize" 78428 */
     12,   1,   7,  24,   3,  10,   1,   7,  39,  30,  20,   0,  /* "collateralized" 78440 */
     12,  27,   7,   8,  30,  27,   0,  /* "collazo" 78447 */
     12,  25,   7,   0,  /* "colle" 78451 */
     12,   8,   7,  26,  11,   0,  /* "colleague" 78457 */
     12,   8,   7,  26,  11,  30,   0,  /* "colleagues" 78464 */
     12,  35,   7,  15,  12,   3,   0,  /* "collect" 78471 */
     12,   1,   7,  21,  12,   3,   0,  /* "collect" 78478 */
     12,   1,   7,  21,  12,   3,   1,   9,   1,   7,   0,  /* "collectible" 78489 */
     12,   1,   7,  21,  12,   3,   1,   9,   1,   7,  30,   0,  /* "collectibles" 78501 */
     12,   1,   7,  21,  12,   3,  31,  22,   5,  30,   1,  17,   0,  /* "collectivism" 78514 */
     12,   1,   7,  21,  12,   3,  31,  22,   1,  30,   2,  33,   1,  13,   0,  /* "collectivization" 78529 */
     12,   1,   7,  21,  12,   3,  31,  22,  39,  30,   0,  /* "collectivize" 78540 */
     12,   1,   7,  21,  12,   3,  31,  22,  39,  30,  20,   0,  /* "collectivized" 78552 */
     12,   8,   7,  31,  40,   0,  /* "colledge" 78558 */
     12,   8,   7,  23,  13,   0,  /* "colleen" 78564 */
     12,   8,   7,  31,  40,   0,  /* "college" 78570 */
     12,   8,   7,  31,  40,   1,  30,   0,  /* "colleges" 78578 */
     12,   8,   7,   1,  40,  22,   5,   7,   0,  /* "collegeville" 78587 */
     12,   1,   7,  23,  40,   1,  13,   0,  /* "collegian" 78595 */
     12,   1,   7,  23,  40,   1,  13,  30,   0,  /* "collegians" 78604 */
     12,   1,   7,  23,  40,   1,   3,   0,  /* "collegiate" 78612 */
     12,   8,   7,   1,  13,   0,  /* "collen" 78618 */
     12,   8,   7,   1,  13,  20,  10,   0,  /* "collender" 78626 */
     12,   8,   7,  10,   0,  /* "coller" 78631 */
     12,   8,   7,  10,  34,  13,   0,  /* "colleran" 78638 */
     12,   8,   7,   1,   3,   0,  /* "collet" 78644 */
     12,   8,   7,  15,   3,   0,  /* "collett" 78650 */
     12,  27,   7,  21,   3,   1,   0,  /* "colletta" 78657 */
     12,  27,   7,  21,   3,  26,   0,  /* "colletti" 78664 */
     12,  25,   7,  22,   5,   7,   0,  /* "colleville" 78671 */
     12,   8,   7,  26,   0,  /* "colley" 78676 */
     12,  25,   7,  26,   0,  /* "colli" 78681 */
     12,   1,   7,  39,  20,   0,  /* "collide" 78687 */
     12,   1,   7,  39,  20,   1,  20,   0,  /* "collided" 78695 */
     12,   1,   7,  39,  20,  10,   0,  /* "collider" 78702 */
     12,   1,   7,  39,  20,  30,   0,  /* "collides" 78709 */
     12,   1,   7,  39,  20,  31,  32,   0,  /* "colliding" 78717 */
     12,   8,   7,  41,  10,   0,  /* "collier" 78723 */
     12,   8,   7,  31,  11,  34,  13,   0,  /* "colligan" 78731 */
     12,   1,   7,   5,  11,  13,   1,  13,   0,  /* "collignon" 78740 */
     12,   8,   7,   5,  13,  40,   0,  /* "collinge" 78747 */
     12,   1,   7,   5,  32,  30,  47,  10,  16,   0,  /* "collingsworth" 78757 */
     12,   1,   7,   5,  13,  14,  47,  10,  16,   0,  /* "collinsworth" 78767 */
     12,   1,   7,   5,  43,   1,  13,   0,  /* "collision" 78775 */
     12,   1,   7,   5,  43,   1,  13,   1,   7,   0,  /* "collisional" 78785 */
     12,   1,   7,   5,  43,   1,  13,  30,   0,  /* "collisions" 78794 */
     12,   8,   7,  50,  20,   0,  /* "colloid" 78800 */
     12,   8,   7,   1,  17,   0,  /* "collom" 78806 */
     12,   8,   7,  19,  17,   0,  /* "collomb" 78812 */
     12,   1,   7,  25,   6,  26,   0,  /* "collopy" 78819 */
     12,   1,   7,  25,  12,  47,  26,   1,   7,   0,  /* "colloquial" 78829 */
     12,   1,   7,  25,  12,  47,  26,   1,  17,   0,  /* "colloquium" 78839 */
     12,   8,   7,   1,  12,  47,  26,   0,  /* "colloquy" 78847 */
     12,   8,   7,  10,   0,  /* "collor" 78852 */
     12,   1,   7,  29,  20,   0,  /* "collude" 78858 */
     12,   1,   7,  29,  20,   1,  20,   0,  /* "colluded" 78866 */
     12,   1,   7,  29,  20,  31,  32,   0,  /* "colluding" 78874 */
     12,   8,   7,   1,  17,   0,  /* "collum" 78880 */
     12,   8,   7,   1,  17,  30,   0,  /* "collums" 78887 */
     12,   8,   7,  51,   4,   1,   0,  /* "collura" 78894 */
     12,   1,   7,  29,  43,   1,  13,   0,  /* "collusion" 78902 */
     12,   1,   7,  29,  14,  31,  22,   0,  /* "collusive" 78910 */
     12,  25,   7,  17,   1,  13,   0,  /* "colman" 78917 */
     12,  27,   7,  17,  28,  13,  21,   4,  27,   0,  /* "colmenero" 78927 */
     12,  25,   7,  27,   0,  /* "colo" 78932 */
     12,   1,   7,   8,  20,  13,  26,   0,  /* "colodny" 78940 */
     12,  25,   7,  25,  17,   1,   0,  /* "coloma" 78947 */
     12,   8,   7,   1,  17,   0,  /* "colomb" 78953 */
     12,   8,   7,  19,  17,   9,   8,   4,  26,   0,  /* "colombari" 78963 */
     12,  27,   7,  25,  17,   9,  26,   0,  /* "colombe" 78971 */
     12,  25,   7,   1,  13,   0,  /* "colon" 78977 */
     12,  44,  13,   1,   7,   0,  /* "colonel" 78983 */
     12,  44,  13,   1,   7,  30,   0,  /* "colonels" 78990 */
     12,   1,   7,  25,  13,  26,   1,   0,  /* "colonia" 78998 */
     12,   1,   7,  25,  13,  26,   1,   7,   0,  /* "colonial" 79007 */
     12,   1,   7,  25,  13,  26,   1,   7,   5,  30,   1,  17,   0,  /* "colonialism" 79020 */
     12,   1,   7,  25,  13,  26,   1,   7,   1,  14,   3,   0,  /* "colonialist" 79032 */
     12,   1,   7,  25,  13,  26,   1,   7,   1,  14,   3,  14,   0,  /* "colonialists" 79045 */
     12,   1,   7,  25,  13,  26,   1,   7,  30,   0,  /* "colonials" 79055 */
     12,   8,   7,   1,  13,  39,  30,   0,  /* "colonize" 79063 */
     12,   8,   7,   1,  13,  39,  30,  20,   0,  /* "colonized" 79072 */
     12,   8,   7,   1,  13,  39,  30,  10,   0,  /* "colonizer" 79081 */
     12,   8,   7,   1,  13,  39,  30,  10,  30,   0,  /* "colonizers" 79091 */
     12,  27,   7,  25,  13,   1,   0,  /* "colonna" 79098 */
     12,   1,   7,  25,  13,   1,  14,   0,  /* "colonus" 79106 */
     12,   1,   7,  25,   6,  26,   0,  /* "colopy" 79113 */
     12,   8,   7,  10,   8,  20,   1,  13,   0,  /* "coloradan" 79122 */
     12,   8,   7,  10,   8,  20,   1,  13,  30,   0,  /* "coloradans" 79132 */
     12,   8,   7,  10,   8,  20,  27,   0,  /* "colorado" 79140 */
     12,   1,   7,  10,   1,   3,  45,   4,   1,   0,  /* "coloratura" 79150 */
     12,  35,   7,  10,   9,   7,  39,  13,  20,   0,  /* "colorblind" 79160 */
     12,   8,   7,  10,   1,  20,  30,   0,  /* "coloreds" 79168 */
     12,  35,   7,  10,  37,   7,  26,   0,  /* "colorfully" 79176 */
     12,  35,   7,  10,  31,  32,   0,  /* "coloring" 79183 */
     12,  35,   7,  10,  39,  30,   0,  /* "colorize" 79190 */
     12,  35,   7,  10,  39,  30,  20,   0,  /* "colorized" 79198 */
     12,  35,   7,  10,  39,  30,  31,  32,   0,  /* "colorizing" 79207 */
     12,  35,   7,  10,   8,  12,  14,   0,  /* "colorocs" 79215 */
     12,  27,   7,  27,  14,  23,  17,  27,   0,  /* "colosimo" 79224 */
     12,   1,   7,   8,  14,   1,   7,  23,   0,  /* "colossally" 79233 */
     12,   8,   7,   1,  14,  23,   1,  17,   0,  /* "colosseum" 79242 */
     12,  35,   7,  10,  20,   0,  /* "coloured" 79248 */
     12,  35,   7,   6,  21,   6,  10,   0,  /* "colpepper" 79256 */
     12,  25,   7,  14,   3,   4,   1,   6,   0,  /* "colstrip" 79265 */
     12,  25,   7,   3,   0,  /* "colt" 79270 */
     12,  25,   7,  16,  19,   4,   6,   0,  /* "coltharp" 79278 */
     12,  25,   7,   3,   4,   1,  13,   0,  /* "coltrane" 79286 */
     12,  27,   7,  29,  42,  26,   0,  /* "colucci" 79293 */
     12,  27,   7,  29,  42,  26,  27,   0,  /* "coluccio" 79301 */
     12,  25,   7,  35,  17,   9,   1,   0,  /* "columba" 79309 */
     12,   1,   7,  35,  17,   9,  26,   1,   0,  /* "columbia" 79318 */
     12,  25,   7,  35,  17,   9,  26,   1,  13,   0,  /* "columbian" 79328 */
     12,   8,   7,   1,  17,   9,  39,  13,   0,  /* "columbine" 79337 */
     12,   8,   7,   1,  17,   9,  39,  13,  30,   0,  /* "columbines" 79347 */
     12,  25,   7,  35,  17,   9,  27,   0,  /* "columbo" 79355 */
     12,   1,   7,  35,  17,   9,   1,  14,   0,  /* "columbus" 79364 */
     12,   8,   7,   1,  17,   0,  /* "column" 79370 */
     12,   8,   7,   1,  17,  20,   0,  /* "columned" 79377 */
     12,   8,   7,   1,  17,  30,   0,  /* "columns" 79384 */
     12,  27,   7,  29,  32,  11,   1,   0,  /* "colunga" 79392 */
     12,   1,   7,  29,  14,  26,   0,  /* "colussy" 79399 */
     12,  25,   7,  22,  10,   0,  /* "colver" 79405 */
     12,  25,   7,  22,   5,  13,   0,  /* "colvin" 79412 */
     12,   8,  17,   0,  /* "com" 79416 */
     12,  25,  17,   1,   0,  /* "coma" 79421 */
     12,  25,  17,   1,  13,   0,  /* "coman" 79427 */
     12,   1,  17,  24,  13,  42,  26,   0,  /* "comanche" 79435 */
     12,   1,  17,  24,  13,  42,  26,  30,   0,  /* "comanches" 79444 */
     12,  25,  17,   1,  13,  20,   8,  13,   3,  28,   0,  /* "comandante" 79455 */
     12,  25,  17,   1,  13,  20,   8,  13,   3,  15,  30,   0,  /* "comandantes" 79467 */
     12,  27,  17,   8,   4,  12,  27,   0,  /* "comarco" 79475 */
     12,  25,  17,   1,  30,   0,  /* "comas" 79481 */
     12,  25,  17,   0,  /* "comb" 79485 */
     12,   8,  17,   9,  34,   3,   0,  /* "combat" 79492 */
     12,   1,  17,   9,  24,   3,  31,  32,   0,  /* "combating" 79501 */
     12,   1,  17,   9,  24,   3,  31,  22,   0,  /* "combative" 79510 */
     12,   1,  17,   9,  24,   3,  31,  22,  13,   1,  14,   0,  /* "combativeness" 79522 */
     12,   8,  17,   9,  23,   0,  /* "combee" 79528 */
     12,   1,  17,   9,  39,  13,   1,   9,   5,   7,   1,   3,  26,   0,  /* "combinability" 79542 */
     12,   1,  17,   9,  39,  13,   1,   9,   1,   7,   0,  /* "combinable" 79553 */
     12,   8,  17,   9,   1,  13,   2,  33,   1,  13,   0,  /* "combination" 79564 */
     12,   8,  17,   9,   1,  13,   2,  33,   1,  13,  30,   0,  /* "combinations" 79576 */
     12,   8,  17,   9,  39,  13,   0,  /* "combine" 79583 */
     12,   1,  17,   9,  39,  13,   0,  /* "combine" 79590 */
     12,   1,  17,   9,  39,  13,  20,   0,  /* "combined" 79598 */
     12,  35,  17,   9,  39,  13,  30,   0,  /* "combines" 79606 */
     12,   1,  17,   9,  39,  13,  30,   0,  /* "combines" 79614 */
     12,  25,  17,  31,  32,   0,  /* "combing" 79620 */
     12,   1,  17,   9,  39,  13,  31,  32,   0,  /* "combining" 79629 */
     12,   8,  17,   9,  25,   0,  /* "combo" 79635 */
     12,  25,  17,  30,   0,  /* "combs" 79640 */
     12,   1,  17,   9,  35,  14,   3,   1,   9,   1,   7,   0,  /* "combustable" 79652 */
     12,   8,  17,  20,  24,  20,   1,   0,  /* "comdata" 79660 */
     12,   8,  17,  20,   5,  13,   0,  /* "comden" 79667 */
     12,   8,  17,  20,   1,  12,  14,   0,  /* "comdex" 79675 */
     12,  35,  17,   0,  /* "come" 79679 */
     12,   1,  17,  25,   0,  /* "comeau" 79684 */
     12,   1,  17,  25,   0,  /* "comeaux" 79689 */
     12,   8,  17,   1,  12,   8,  13,   0,  /* "comecon" 79697 */
     12,   1,  17,  23,  20,  31,  12,   0,  /* "comedic" 79705 */
     12,   1,  17,  23,  20,  26,  21,  13,   0,  /* "comedienne" 79714 */
     12,   8,  17,   1,  20,  26,  30,   0,  /* "comedies" 79722 */
     12,  35,  17,  20,  48,  13,   0,  /* "comedown" 79729 */
     12,   8,  17,   1,  20,  26,   0,  /* "comedy" 79736 */
     12,   8,  17,  31,  40,  26,  30,   0,  /* "comegys" 79744 */
     12,  27,  17,  21,   7,   1,   0,  /* "comella" 79751 */
     12,   1,  17,  44,  37,  10,  20,   0,  /* "comerford" 79759 */
     12,   1,  17,  21,   4,  31,  12,   1,   0,  /* "comerica" 79768 */
     12,   8,  17,   1,   3,   0,  /* "comet" 79774 */
     12,   8,  17,   1,   3,  21,   4,  26,   0,  /* "cometary" 79783 */
     12,  35,  17,   5,  16,   0,  /* "cometh" 79789 */
     12,  27,  17,  21,   3,   4,   1,   0,  /* "cometra" 79797 */
     12,   8,  17,   1,   3,  14,   0,  /* "comets" 79804 */
     12,   8,  17,  21,  12,  14,   0,  /* "comex" 79811 */
     12,   8,  17,  37,  21,  20,   0,  /* "comfed" 79818 */
     12,   8,  17,  37,   1,  13,   1,  13,  14,   0,  /* "comfinance" 79828 */
     12,  35,  17,  37,  10,   3,   1,   9,   1,   7,   0,  /* "comfortable" 79839 */
     12,  35,  17,  37,  26,   0,  /* "comfy" 79845 */
     12,   8,  17,  31,  12,   1,   7,  26,   0,  /* "comically" 79854 */
     12,  27,  17,   5,  32,  12,  27,   0,  /* "cominco" 79862 */
     12,  35,  17,  31,  32,   0,  /* "coming" 79868 */
     12,  35,  17,  31,  32,  30,   0,  /* "comings" 79875 */
     12,  25,  17,   1,  13,  30,   0,  /* "comins" 79882 */
     12,  25,  17,   5,  14,  12,  23,   0,  /* "comiskey" 79890 */
     12,  36,  17,   1,   3,   2,   3,   1,  14,   0,  /* "comitatus" 79900 */
     12,  27,  17,  23,   3,  27,   0,  /* "comito" 79907 */
     12,  25,  17,   5,   3,  26,   0,  /* "comity" 79914 */
     12,   8,  17,   1,   0,  /* "comma" 79919 */
     12,   8,  17,   1,  12,   0,  /* "commack" 79925 */
     12,   1,  17,  24,  13,  20,   0,  /* "command" 79932 */
     12,   8,  17,   1,  13,  20,   8,  13,   3,   0,  /* "commandant" 79942 */
     12,   8,  17,   1,  13,  20,   5,   4,   0,  /* "commandeer" 79951 */
     12,   8,  17,   1,  13,  20,   5,   4,  20,   0,  /* "commandeered" 79961 */
     12,   1,  17,  24,  13,  20,  17,   1,  13,   3,   0,  /* "commandment" 79972 */
     12,   1,  17,  24,  13,  20,  17,   1,  13,   3,  14,   0,  /* "commandments" 79984 */
     12,   1,  17,  24,  13,  20,  25,   0,  /* "commando" 79992 */
     12,   1,  17,  24,  13,  20,  25,  30,   0,  /* "commandos" 80001 */
     12,   8,  17,   1,  30,   0,  /* "commas" 80007 */
     12,   1,  17,  21,  17,   4,   1,   3,  31,  22,   0,  /* "commemorative" 80018 */
     12,   1,  17,  21,  13,  20,   1,   9,   1,   7,   0,  /* "commendable" 80029 */
     12,   8,  17,   1,  13,  20,   2,  33,   1,  13,   0,  /* "commendation" 80040 */
     12,   1,  17,  21,  13,  14,  10,   1,   3,   0,  /* "commensurate" 80050 */
     12,   1,  17,  21,  13,  14,  10,   1,   3,   7,  26,   0,  /* "commensurately" 80062 */
     12,   8,  17,  15,  13,   3,   0,  /* "comment" 80069 */
     12,   8,  17,   1,  13,   3,  21,   4,  26,  30,   0,  /* "commentaries" 80080 */
     12,   8,  17,   1,  13,   3,  21,   4,  26,   0,  /* "commentary" 80090 */
     12,   8,  17,   1,  13,   3,   2,   3,  10,   0,  /* "commentator" 80100 */
     12,   8,  17,   1,  13,   3,   2,   3,  10,  30,   0,  /* "commentators" 80111 */
     12,   8,  17,  15,  13,   3,   1,  20,   0,  /* "commented" 80120 */
     12,   8,  17,  15,  13,   3,  10,   0,  /* "commenter" 80128 */
     12,   8,  17,  15,  13,   3,  10,  30,   0,  /* "commenters" 80137 */
     12,   8,  17,  15,  13,   3,  31,  32,   0,  /* "commenting" 80146 */
     12,   8,  17,  15,  13,   3,  14,   0,  /* "comments" 80154 */
     12,   8,  17,  10,  14,   0,  /* "commerce" 80160 */
     12,   8,  17,  10,  14,   9,  24,  13,  12,  18,   4,   6,   0,  /* "commercebancorp" 80173 */
     12,   1,  17,  44,  14,  26,  24,   7,   0,  /* "commerciale" 80182 */
     12,   1,  17,  44,  33,   1,   7,   5,  30,   1,  17,   0,  /* "commercialism" 80194 */
     12,   1,  17,  44,  33,   1,   7,  39,  30,   0,  /* "commercialize" 80204 */
     12,   1,  17,  44,  33,   1,   7,  39,  30,  20,   0,  /* "commercialized" 80215 */
     12,   1,  17,  44,  33,   1,   7,  39,  30,  31,  32,   0,  /* "commercializing" 80227 */
     12,   8,  17,  10,  37,  10,  20,   0,  /* "commerford" 80235 */
     12,   1,  17,  44,  33,   1,   7,   0,  /* "commerical" 80243 */
     12,   8,  17,  10,  30,   9,  24,  32,  12,   0,  /* "commerzbank" 80253 */
     12,   8,  17,  26,   0,  /* "commie" 80258 */
     12,   8,  17,  26,  30,   0,  /* "commies" 80264 */
     12,   1,  17,   5,  32,  11,   1,   7,   0,  /* "commingle" 80273 */
     12,  19,  17,   5,  32,  11,   1,   7,  20,   0,  /* "commingled" 80283 */
     12,  19,  17,   5,  32,  11,   1,   7,  31,  32,   0,  /* "commingling" 80294 */
     12,   8,  17,   5,  13,  30,   0,  /* "commins" 80301 */
     12,   1,  17,   5,  14,  10,   2,   3,   0,  /* "commiserate" 80310 */
     12,   1,  17,   5,  33,   0,  /* "commish" 80316 */
     12,   1,  17,   5,  30,   1,  13,   0,  /* "commision" 80324 */
     12,   8,  17,   1,  14,   8,   4,   0,  /* "commissar" 80332 */
     12,   8,  17,   1,  14,  21,   4,  26,  30,   0,  /* "commissaries" 80342 */
     12,   8,  17,   1,  14,  19,  30,   0,  /* "commissars" 80350 */
     12,   8,  17,   1,  14,  21,   4,  26,   0,  /* "commissary" 80359 */
     12,  27,  17,  23,  14,  27,   0,  /* "commisso" 80366 */
     12,   8,  17,   5,   3,  26,   0,  /* "commitee" 80373 */
     12,   1,  17,   5,   3,   1,   7,   0,  /* "committal" 80381 */
     12,   1,  17,   5,   3,  26,   0,  /* "committee" 80388 */
     12,   1,  17,   5,   3,  26,  17,   1,  13,   0,  /* "committeeman" 80398 */
     12,   1,  17,   5,   3,  26,  30,   0,  /* "committees" 80406 */
     12,   1,  17,  25,  20,   0,  /* "commode" 80412 */
     12,   1,  17,  25,  20,  26,   1,  14,   0,  /* "commodious" 80421 */
     12,   1,  17,   8,  20,   1,   3,  26,  30,   0,  /* "commodities" 80431 */
     12,   1,  17,   8,  20,   1,   3,  26,   0,  /* "commodity" 80440 */
     12,   8,  17,   1,  20,  18,   4,   0,  /* "commodore" 80448 */
     12,   8,  17,   1,  13,  14,  21,  13,  14,   1,  12,   1,   7,   0,  /* "commonsensical" 80462 */
     12,   8,  17,   1,  13,  47,  21,   7,  16,   0,  /* "commonwealth" 80472 */
     12,   1,  17,  25,  33,   1,  13,   0,  /* "commotion" 80480 */
     12,   1,  17,  41,  29,  13,   1,   7,   0,  /* "communal" 80489 */
     12,   8,  17,  41,  29,  13,   0,  /* "commune" 80496 */
     12,   8,  17,  41,  29,  13,  30,   0,  /* "communes" 80504 */
     12,   1,  17,  41,  29,  13,   1,  12,   1,   9,   1,   7,   0,  /* "communicable" 80517 */
     12,   1,  17,  41,  29,  13,   1,  12,   2,   3,   0,  /* "communicate" 80528 */
     12,   1,  17,  41,  29,  13,   1,  12,   2,   3,   1,  20,   0,  /* "communicated" 80541 */
     12,   1,  17,  41,  29,  13,  31,  12,   2,   3,  14,   0,  /* "communicates" 80553 */
     12,   1,  17,  41,  29,  13,   1,  12,   2,   3,  31,  32,   0,  /* "communicating" 80566 */
     12,   1,  17,  41,  29,  13,   1,  12,   2,  33,   1,  13,   0,  /* "communication" 80579 */
     12,   1,  17,  41,  29,  13,   1,  12,   2,  33,   1,  13,  30,   0,  /* "communications" 80593 */
     12,   1,  17,  41,  29,  13,   1,  12,   1,   3,  31,  22,   0,  /* "communicative" 80606 */
     12,   1,  17,  41,  29,  13,   1,  12,   2,   3,  10,   0,  /* "communicator" 80618 */
     12,   1,  17,  41,  29,  13,   1,  12,  28,   3,  10,  30,   0,  /* "communicators" 80631 */
     12,   1,  17,  41,  29,  13,  41,   1,  13,   0,  /* "communion" 80641 */
     12,   1,  17,  41,  29,  13,   1,  12,   2,   0,  /* "communique" 80651 */
     12,   1,  17,  41,  29,  13,  31,  12,   2,  30,   0,  /* "communiques" 80662 */
     12,   8,  17,  41,   1,  13,   5,  30,   1,  17,   0,  /* "communism" 80673 */
     12,   8,  17,  41,   1,  13,   1,  14,   3,   0,  /* "communist" 80683 */
     12,   8,  17,  41,   1,  13,   1,  14,   3,  14,   0,  /* "communists" 80694 */
     12,   1,  17,  41,  29,  13,   1,   3,  26,  30,   0,  /* "communities" 80705 */
     12,   1,  17,  41,  29,  13,   1,   3,  26,   0,  /* "community" 80715 */
     12,   1,  17,  41,  29,  13,   1,   3,  26,  47,  39,  20,   0,  /* "communitywide" 80728 */
     12,   8,  17,  41,   1,  13,   1,  30,   2,  33,   1,  13,   0,  /* "communization" 80741 */
     12,   8,  17,  41,   1,  13,  39,  30,   0,  /* "communize" 80750 */
     12,   1,  17,  41,  29,   3,   0,  /* "commute" 80757 */
     12,   1,  17,  41,  29,   3,   1,  20,   0,  /* "commuted" 80766 */
     12,   1,  17,  41,  29,   3,  10,   0,  /* "commuter" 80774 */
     12,   1,  17,  41,  29,   3,  10,  30,   0,  /* "commuters" 80783 */
     12,   1,  17,  41,  29,   3,  14,   0,  /* "commutes" 80791 */
     12,   1,  17,  41,  29,   3,  31,  32,   0,  /* "commuting" 80800 */
     12,  25,  17,  27,   0,  /* "como" 80805 */
     12,   8,  17,   6,   0,  /* "comp" 80810 */
     12,   8,  17,   6,  34,  12,   3,   0,  /* "compact" 80818 */
     12,   1,  17,   6,  24,  12,   3,   0,  /* "compact" 80826 */
     12,  35,  17,   6,  34,  12,   3,  14,   0,  /* "compacts" 80835 */
     12,   1,  17,   6,  24,  12,   3,  14,   0,  /* "compacts" 80844 */
     12,  35,  17,   6,   1,  13,  26,   0,  /* "compagnie" 80852 */
     12,   1,  17,   6,  24,  13,  38,  26,   1,   0,  /* "companhia" 80862 */
     12,  35,  17,   6,   1,  13,  26,  30,   0,  /* "companies" 80871 */
     12,  35,  17,   6,   1,  13,  26,   0,  /* "company" 80879 */
     12,  35,  17,   6,   1,  13,  26,  47,  39,  20,   0,  /* "companywide" 80890 */
     12,   8,  17,   6,  24,  12,   0,  /* "compaq" 80897 */
     12,   8,  17,   6,  10,   1,   9,   5,   7,   1,   3,  26,   0,  /* "comparability" 80910 */
     12,   8,  17,   6,  10,   1,   9,   1,   7,   0,  /* "comparable" 80920 */
     12,   8,  17,   6,  10,   1,   9,   7,  26,   0,  /* "comparably" 80930 */
     12,   1,  17,   6,  21,   4,   1,   3,  31,  22,   0,  /* "comparative" 80941 */
     12,   1,  17,   6,  21,   4,   1,   3,  31,  22,   7,  26,   0,  /* "comparatively" 80954 */
     12,   1,  17,   6,  44,   1,   3,  10,   0,  /* "comparator" 80963 */
     12,   1,  17,   6,  21,   4,   0,  /* "compare" 80970 */
     12,   1,  17,   6,  21,   4,   1,  14,   1,  13,   0,  /* "comparison" 80981 */
     12,   1,  17,   6,  21,   4,   1,  14,   1,  13,  30,   0,  /* "comparisons" 80993 */
     12,   1,  17,   6,   8,   4,   3,  17,  21,  13,   3,   1,   7,  39,  30,   0,  /* "compartmentalize" 81009 */
     12,   8,  17,   6,  19,   4,   3,  17,  21,  13,   3,   1,   7,  39,  30,  20,   0,  /* "compartmentalized" 81026 */
     12,   8,  17,   6,   1,  14,   0,  /* "compas" 81033 */
     12,  35,  17,   6,   1,  14,   0,  /* "compass" 81040 */
     12,   1,  17,   6,  24,   3,   1,   9,   1,   7,   0,  /* "compatible" 81051 */
     12,   1,  17,   6,  24,   3,   1,   9,   1,   7,  30,   0,  /* "compatibles" 81063 */
     12,   8,  17,   6,   1,  13,   0,  /* "compean" 81070 */
     12,   1,  17,   6,  21,  13,  14,   1,   9,   1,   7,   0,  /* "compensable" 81082 */
     12,   8,  17,   6,   1,  13,  14,   2,   3,   0,  /* "compensate" 81092 */
     12,   8,  17,   6,   1,  13,  14,   2,   3,   1,  20,   0,  /* "compensated" 81104 */
     12,   8,  17,   6,   1,  13,  14,   2,   3,  14,   0,  /* "compensates" 81115 */
     12,   8,  17,   6,   1,  13,  14,   2,   3,  31,  32,   0,  /* "compensating" 81127 */
     12,   8,  17,   6,   1,  13,  14,   2,  33,   1,  13,   0,  /* "compensation" 81139 */
     12,   8,  17,   6,   1,  13,  14,   2,  33,   1,  13,  30,   0,  /* "compensations" 81152 */
     12,   1,  17,   6,  21,  13,  14,   1,   3,  18,   4,  26,   0,  /* "compensatory" 81165 */
     12,   1,  17,   6,  23,   3,   1,  20,   0,  /* "competed" 81174 */
     12,   8,  17,   6,   1,   3,   1,  13,  14,   0,  /* "competence" 81184 */
     12,   8,  17,   6,   1,   3,   1,  13,  14,  26,  30,   0,  /* "competencies" 81196 */
     12,   8,  17,   6,   1,   3,   1,  13,  14,  26,   0,  /* "competency" 81207 */
     12,   8,  17,   6,   1,   3,   1,  13,   3,   0,  /* "competent" 81217 */
     12,   8,  17,   6,   1,   3,   1,  13,   3,   7,  26,   0,  /* "competently" 81229 */
     12,   1,  17,   6,  23,   3,  14,   0,  /* "competes" 81237 */
     12,   1,  17,   6,  23,   3,  31,  32,   0,  /* "competing" 81246 */
     12,   8,  17,   6,   1,   3,   5,  33,   1,  13,   0,  /* "competition" 81257 */
     12,   8,  17,   6,   1,   3,   5,  33,   1,  13,  30,   0,  /* "competitions" 81269 */
     12,   8,  17,   6,   1,   7,   2,  33,   1,  13,   0,  /* "compilation" 81280 */
     12,   8,  17,   6,   1,   7,   2,  33,   1,  13,  30,   0,  /* "compilations" 81292 */
     12,   1,  17,   6,  39,   7,   0,  /* "compile" 81299 */
     12,   1,  17,   6,  39,   7,  20,   0,  /* "compiled" 81307 */
     12,   1,  17,   6,  39,   7,  10,   0,  /* "compiler" 81315 */
     12,   1,  17,   6,  39,   7,  10,  30,   0,  /* "compilers" 81324 */
     12,   1,  17,   6,  39,   7,  30,   0,  /* "compiles" 81332 */
     12,   1,  17,   6,  39,   7,  31,  32,   0,  /* "compiling" 81341 */
     12,   8,  17,   6,   7,   2,  13,  10,  30,   0,  /* "complainers" 81351 */
     12,   1,  17,   6,   7,   2,  14,   1,  13,   3,   0,  /* "complaisant" 81362 */
     12,   8,  17,   6,   7,   1,  17,   1,  13,   3,   0,  /* "complement" 81373 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,   4,  26,   0,  /* "complementary" 81386 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,   1,  20,   0,  /* "complemented" 81399 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,  31,  32,   0,  /* "complementing" 81412 */
     12,   8,  17,   6,   7,   1,  17,   1,  13,   3,  14,   0,  /* "complements" 81424 */
     12,   1,  17,   6,   7,  23,   3,  13,   1,  14,   0,  /* "completeness" 81435 */
     12,   1,  17,   6,   7,  23,   3,  31,  32,   0,  /* "completing" 81445 */
     12,   8,  17,   6,   7,  15,  12,  14,   0,  /* "complex" 81454 */
     12,   8,  17,   6,   7,  15,  12,  14,   1,  30,   0,  /* "complexes" 81465 */
     12,   1,  17,   6,  21,  12,  33,   1,  13,   0,  /* "complexion" 81475 */
     12,   1,  17,   6,  21,  12,  33,   1,  13,  30,   0,  /* "complexions" 81486 */
     12,   1,  17,   6,   7,  21,  12,  14,   1,   3,  26,  30,   0,  /* "complexities" 81499 */
     12,   1,  17,   6,   7,  21,  12,  14,   1,   3,  26,   0,  /* "complexity" 81511 */
     12,   1,  17,   6,   7,  39,   1,  13,  14,   0,  /* "compliance" 81521 */
     12,   1,  17,   6,   7,  39,   1,  13,   3,   0,  /* "compliant" 81531 */
     12,   8,  17,   6,   7,   1,  12,   2,   3,   0,  /* "complicate" 81541 */
     12,   8,  17,   6,   7,   1,  12,   2,   3,   1,  20,   0,  /* "complicated" 81553 */
     12,   8,  17,   6,   7,  31,  12,   2,   3,  14,   0,  /* "complicates" 81564 */
     12,   8,  17,   6,   7,   1,  12,   2,   3,  31,  32,   0,  /* "complicating" 81576 */
     12,   8,  17,   6,   7,   1,  12,   2,  33,   1,  13,   0,  /* "complication" 81588 */
     12,   8,  17,   6,   7,   1,  12,   2,  33,   1,  13,  30,   0,  /* "complications" 81601 */
     12,   1,  17,   6,   7,  39,  20,   0,  /* "complied" 81609 */
     12,   1,  17,   6,   7,  39,  30,   0,  /* "complies" 81617 */
     12,   8,  17,   6,   7,   1,  17,   1,  13,   3,   0,  /* "compliment" 81628 */
     12,   8,  17,   6,   7,   1,  17,  15,  13,   3,   0,  /* "compliment" 81639 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,   0,  /* "compliment" 81650 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,  10,  26,   0,  /* "complimentary" 81663 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,   1,  20,   0,  /* "complimented" 81676 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,  31,  32,   0,  /* "complimenting" 81689 */
     12,   8,  17,   6,   7,   1,  17,  15,  13,   3,  14,   0,  /* "compliments" 81701 */
     12,   8,  17,   6,   7,   1,  17,  15,  13,   3,  14,   0,  /* "compliments" 81713 */
     12,   8,  17,   6,   7,   1,  17,  21,  13,   3,  14,   0,  /* "compliments" 81725 */
     12,   1,  17,   6,   7,  39,   0,  /* "comply" 81732 */
     12,   1,  17,   6,   7,  39,  31,  32,   0,  /* "complying" 81741 */
     12,   8,  17,   6,  25,   0,  /* "compo" 81747 */
     12,   1,  17,   6,  25,  30,  10,   0,  /* "composer" 81755 */
     12,   1,  17,   6,   8,  30,   1,   3,   0,  /* "composite" 81764 */
     12,   1,  17,   6,   8,  30,   1,   3,  14,   0,  /* "composites" 81774 */
     12,   8,  17,   6,   1,  30,   5,  33,   1,  13,   0,  /* "composition" 81785 */
     12,   8,  17,   6,   1,  30,   5,  33,   1,  13,   1,   7,   0,  /* "compositional" 81798 */
     12,   8,  17,   6,   1,  30,   5,  33,   1,  13,  30,   0,  /* "compositions" 81810 */
     12,   8,  17,   6,  27,  14,   3,   0,  /* "compost" 81818 */
     12,   8,  17,   6,  25,  14,   3,  31,  32,   0,  /* "composting" 81828 */
     12,   8,  17,   6,  27,   3,   0,  /* "compote" 81835 */
     12,   8,  17,   6,  52,  13,  20,   0,  /* "compound" 81843 */
     12,   1,  17,   6,  48,  13,  20,   0,  /* "compound" 81851 */
     12,   8,  17,   6,  52,  13,  20,  30,   0,  /* "compounds" 81860 */
     12,   1,  17,   6,  48,  13,  20,  30,   0,  /* "compounds" 81869 */
     12,   8,  17,   6,   4,  26,  38,  21,  13,  20,   0,  /* "comprehend" 81880 */
     12,   8,  17,   6,   4,  26,  38,  21,  13,  14,   1,   9,   5,   7,   1,   3,  26,   0,  /* "comprehensibility" 81898 */
     12,   8,  17,   6,   4,  26,  38,  21,  13,  14,   1,   9,   1,   7,   0,  /* "comprehensible" 81913 */
     12,   8,  17,   6,   4,  26,  38,  21,  13,  33,   1,  13,   0,  /* "comprehension" 81926 */
     12,   8,  17,   6,   4,  26,  38,  21,  13,  14,  31,  22,   0,  /* "comprehensive" 81939 */
     12,   8,  17,   6,   4,  15,  14,   0,  /* "compress" 81947 */
     12,   1,  17,   6,   4,  21,  14,   0,  /* "compress" 81955 */
     12,   1,  17,   6,   4,  21,  14,   3,   0,  /* "compressed" 81964 */
     12,   8,  17,   6,   4,  15,  14,   1,  30,   0,  /* "compresses" 81974 */
     12,   1,  17,   6,   4,  21,  14,   1,  30,   0,  /* "compresses" 81984 */
     12,   1,  17,   6,   4,  21,  14,  31,  32,   0,  /* "compressing" 81994 */
     12,   1,  17,   6,   4,  21,  33,   1,  13,   0,  /* "compression" 82004 */
     12,   1,  17,   6,   4,  21,  14,  10,   0,  /* "compressor" 82013 */
     12,   1,  17,   6,   4,  21,  14,  10,  30,   0,  /* "compressors" 82023 */
     12,   1,  17,   6,   4,  39,  30,   0,  /* "comprise" 82031 */
     12,   1,  17,   6,   4,  39,  30,  20,   0,  /* "comprised" 82040 */
     12,   1,  17,   6,   4,  39,  30,   1,  30,   0,  /* "comprises" 82050 */
     12,   1,  17,   6,   4,  39,  30,  31,  32,   0,  /* "comprising" 82060 */
     12,   8,  17,   6,   4,   1,  17,  39,  30,   0,  /* "compromise" 82070 */
     12,   8,  17,   6,   4,   1,  17,  39,  30,  20,   0,  /* "compromised" 82081 */
     12,   8,  17,   6,   4,   1,  17,  39,  30,  10,   0,  /* "compromiser" 82092 */
     12,   8,  17,   6,   4,   1,  17,  39,  30,   1,  30,   0,  /* "compromises" 82104 */
     12,   8,  17,   6,   4,   1,  17,  39,  30,  31,  32,   0,  /* "compromising" 82116 */
     12,   1,  13,   3,   4,  25,   7,  10,   0,  /* "comptroller" 82125 */
     12,   8,  17,   6,   3,   4,   8,  13,   5,  12,  14,   0,  /* "comptronix" 82137 */
     12,   8,  17,   6,  41,  29,  24,  20,   0,  /* "compuadd" 82146 */
     12,   8,  17,   6,  41,  29,  12,  21,  17,   0,  /* "compuchem" 82156 */
     12,   8,  17,   6,  41,  29,  20,  39,  13,   0,  /* "compudyne" 82166 */
     12,   8,  17,   6,  41,  29,  37,  35,  13,  20,   0,  /* "compufund" 82177 */
     12,   8,  17,   6,  41,  29,  11,   4,  24,  37,  31,  12,   0,  /* "compugraphic" 82190 */
     12,   1,  17,   6,  45,   7,  33,   1,  13,  30,   0,  /* "compulsions" 82201 */
     12,   1,  17,   6,  35,   7,  14,  10,  26,   0,  /* "compulsory" 82211 */
     12,   8,  17,   6,  41,  29,  17,  24,   3,   0,  /* "compumat" 82221 */
     12,   8,  17,   6,  41,  29,  21,  14,   2,   0,  /* "compusa" 82231 */
     12,   8,  17,   6,  41,  29,  14,  10,  22,   0,  /* "compuserve" 82241 */
     12,   8,  17,   6,  41,  29,   3,  24,   7,  36,  11,   0,  /* "computalog" 82253 */
     12,   8,  17,   6,  41,   1,   3,   2,  33,   1,  13,   0,  /* "computation" 82265 */
     12,   8,  17,   6,  41,  29,   3,   2,  33,   1,  13,   1,   7,   0,  /* "computational" 82279 */
     12,   8,  17,   6,  41,  29,   3,   2,  33,   1,  13,  30,   0,  /* "computations" 82292 */
     12,   1,  17,   6,  41,  29,   3,   0,  /* "compute" 82300 */
     12,   1,  17,   6,  41,  29,   3,   1,  20,   0,  /* "computed" 82310 */
     12,   1,  17,   6,  41,  29,   3,  10,   0,  /* "computer" 82319 */
     12,   1,  17,   6,  41,  29,   3,  10,  12,   4,  24,  37,   3,   0,  /* "computercraft" 82333 */
     12,   1,  17,   6,  41,  29,   3,  10,   1,  30,   2,  33,   1,  13,   0,  /* "computerization" 82348 */
     12,   1,  17,   6,  41,  29,   3,  10,  39,  30,   0,  /* "computerize" 82359 */
     12,   1,  17,   6,  41,  29,   3,  10,  39,  30,  20,   0,  /* "computerized" 82371 */
     12,   1,  17,   6,  41,  29,   3,  10,  39,  30,  31,  32,   0,  /* "computerizing" 82384 */
     12,   1,  17,   6,  41,  29,   3,  10,   7,  24,  13,  20,   0,  /* "computerland" 82397 */
     12,   1,  17,   6,  41,  29,   3,  10,   7,  39,  12,   0,  /* "computerlike" 82409 */
     12,   1,  17,   6,  41,  29,   3,  10,  30,   0,  /* "computers" 82419 */
     12,   1,  17,   6,  41,  29,   3,  10,  22,   5,  43,   1,  13,   0,  /* "computervision" 82433 */
     12,   1,  17,   6,  41,  29,   3,  10,  47,  44,   7,  20,   0,  /* "computerworld" 82446 */
     12,   1,  17,   6,  41,  29,   3,  14,   0,  /* "computes" 82455 */
     12,   1,  17,   6,  41,  29,   3,  31,  32,   0,  /* "computing" 82465 */
     12,   8,  17,   6,  41,  29,   3,   4,  24,  12,   0,  /* "computrac" 82476 */
     12,   8,  17,   6,  41,  29,  47,  21,   4,   0,  /* "compuware" 82486 */
     12,   8,  17,   4,  24,  20,   0,  /* "comrade" 82493 */
     12,   8,  17,   4,  24,  20,  30,   0,  /* "comrades" 82501 */
     12,   8,  17,  10,  26,   0,  /* "comrie" 82507 */
     12,   8,  17,  30,   0,  /* "coms" 82512 */
     12,   8,  17,  14,  34,   3,   0,  /* "comsat" 82519 */
     12,   8,  17,  14,   3,   8,  12,   0,  /* "comstock" 82527 */
     12,   1,  17,   3,  47,   8,   0,  /* "comtois" 82534 */
     12,   8,  17,   3,   4,  21,  12,  14,   0,  /* "comtrex" 82543 */
     12,  27,  17,  29,  13,   8,   7,  26,   0,  /* "comunale" 82552 */
     12,   8,  13,   0,  /* "con" 82556 */
     12,  25,  13,   1,   0,  /* "cona" 82561 */
     12,  25,  13,   1,   9,   1,   7,   0,  /* "conable" 82569 */
     12,   8,  13,  24,  11,   4,   1,   0,  /* "conagra" 82577 */
     12,  25,  13,   1,   7,   0,  /* "conal" 82583 */
     12,  25,  13,   1,  13,   0,  /* "conan" 82589 */
     12,  25,  13,   1,  13,   3,   0,  /* "conant" 82596 */
     12,   8,  13,  10,  20,   0,  /* "conard" 82602 */
     12,   8,  13,   1,  14,  29,   6,  27,   0,  /* "conasupo" 82611 */
     12,   8,  13,   1,   3,  14,  10,   0,  /* "conatser" 82619 */
     12,   8,  13,   1,  47,  28,   0,  /* "conaway" 82626 */
     12,   8,  32,  12,   1,   0,  /* "conca" 82632 */
     12,   1,  13,  12,  24,  13,   1,  13,   0,  /* "concannon" 82641 */
     12,   1,  13,  12,  24,   3,   1,  13,   2,   3,   0,  /* "concatenate" 82652 */
     12,   1,  13,  12,  24,   3,   1,  13,   2,  33,   1,  13,   0,  /* "concatenation" 82665 */
     12,   1,  13,  14,  23,  20,   1,  20,   0,  /* "conceded" 82674 */
     12,   1,  13,  14,  23,  20,  30,   0,  /* "concedes" 82682 */
     12,   1,  13,  14,  23,   3,   1,  20,   0,  /* "conceited" 82691 */
     12,   1,  13,  14,  23,  22,   1,   9,   1,   7,   0,  /* "conceivable" 82702 */
     12,   8,  13,  14,   1,  13,   3,   4,   2,   3,   0,  /* "concentrate" 82713 */
     12,  18,  13,  14,   1,  13,   3,   4,   2,   3,   1,  20,   0,  /* "concentrated" 82726 */
     12,   8,  13,  14,   1,  13,   3,   4,   2,   3,  14,   0,  /* "concentrates" 82738 */
     12,   8,  13,  14,   1,  13,   3,   4,   2,   3,  31,  32,   0,  /* "concentrating" 82751 */
     12,   8,  13,  14,   1,  13,   3,   4,   2,  33,   1,  13,   0,  /* "concentration" 82764 */
     12,   8,  13,  14,   1,  13,   3,   4,   2,  33,   1,  13,  30,   0,  /* "concentrations" 82778 */
     12,   1,  13,  14,  21,  13,   3,   4,  31,  12,   0,  /* "concentric" 82789 */
     12,   1,  13,  14,  21,   6,  14,  26,  25,  13,   0,  /* "concepcion" 82800 */
     12,   8,  13,  14,  15,   6,   3,   0,  /* "concept" 82808 */
     12,   8,  13,  14,  15,   6,   3,  14,   0,  /* "concepts" 82817 */
     12,   1,  13,  14,  21,   6,  42,  47,   1,   7,   1,  30,   2,  33,   1,  13,   0,  /* "conceptualization" 82834 */
     12,   1,  13,  14,  44,  13,   0,  /* "concern" 82841 */
     12,   8,  13,  14,  10,   3,   0,  /* "concert" 82848 */
     12,  19,  13,  14,  44,   3,   0,  /* "concert" 82855 */
     12,   1,  13,  42,  21,   4,   3,  26,   0,  /* "concerti" 82864 */
     12,  19,  13,  14,  10,   3,  23,  13,   1,   0,  /* "concertina" 82874 */
     12,   8,  13,  14,  10,   3,  17,  24,  14,   3,  10,   0,  /* "concertmaster" 82886 */
     12,   1,  13,  42,  21,   4,   3,  27,   0,  /* "concerto" 82895 */
     12,   1,  13,  42,  21,   4,   3,  27,  30,   0,  /* "concertos" 82905 */
     12,   8,  13,  14,  10,   3,  14,   0,  /* "concerts" 82913 */
     12,   1,  13,  14,  44,   3,  14,   0,  /* "concerts" 82921 */
     12,   8,  13,  42,   1,   0,  /* "concha" 82927 */
     12,   1,  13,  42,  23,   3,   1,   0,  /* "conchita" 82935 */
     12,   8,  13,  14,  26,  21,   4,  43,   0,  /* "concierge" 82944 */
     12,   1,  13,  14,  23,   7,  26,   2,   3,  10,   0,  /* "conciliator" 82955 */
     12,   1,  13,  14,   5,   7,  23,   1,   3,  18,   4,  26,   0,  /* "conciliatory" 82968 */
     12,   1,  13,  14,  39,  14,   0,  /* "concise" 82975 */
     12,   1,  13,  14,  39,  14,   7,  26,   0,  /* "concisely" 82984 */
     12,   8,  13,  12,   7,   2,  22,   0,  /* "conclave" 82992 */
     12,   1,  13,  12,   7,  29,  20,   0,  /* "conclude" 83000 */
     12,   1,  13,  12,   7,  29,  20,   1,  20,   0,  /* "concluded" 83010 */
     12,   1,  13,  12,   7,  29,  20,  30,   0,  /* "concludes" 83019 */
     12,   1,  13,  12,   7,  29,  20,  31,  32,   0,  /* "concluding" 83029 */
     12,   1,  13,  12,   7,  29,  43,   1,  13,   0,  /* "conclusion" 83039 */
     12,   1,  13,  12,   7,  29,  43,   1,  13,  30,   0,  /* "conclusions" 83050 */
     12,   1,  13,  12,   7,  29,  14,  31,  22,   0,  /* "conclusive" 83060 */
     12,   1,  13,  12,   7,  29,  14,  31,  22,   7,  26,   0,  /* "conclusively" 83072 */
     12,   1,  13,  12,   8,  12,   3,   0,  /* "concoct" 83080 */
     12,   1,  13,  12,   8,  12,   3,   1,  20,   0,  /* "concocted" 83090 */
     12,   1,  13,  12,   8,  12,   3,  31,  32,   0,  /* "concocting" 83100 */
     12,   1,  13,  12,   8,  12,  33,   1,  13,   0,  /* "concoction" 83110 */
     12,   1,  13,  12,   8,  12,  33,   1,  13,  30,   0,  /* "concoctions" 83121 */
     12,   8,  13,  12,   8,  17,   1,   3,   1,  13,   3,   0,  /* "concomitant" 83133 */
     12,   8,  13,  12,   8,  17,   1,   3,   1,  13,   3,   7,  26,   0,  /* "concomitantly" 83147 */
     12,   8,  13,  12,  18,   4,  20,   0,  /* "concord" 83155 */
     12,   8,  13,  12,   4,  23,   3,   7,  26,   0,  /* "concretely" 83165 */
     12,  19,  13,  12,  41,  29,   9,   1,  13,   1,  40,   0,  /* "concubinage" 83177 */
     12,   8,  13,  12,  41,   1,   9,  39,  13,   0,  /* "concubine" 83187 */
     12,   8,  13,  12,  41,   1,   9,  39,  13,  30,   0,  /* "concubines" 83198 */
     12,   1,  13,  20,  21,   7,  27,   0,  /* "condello" 83206 */
     12,   1,  13,  20,  21,  17,   0,  /* "condemn" 83213 */
     12,   8,  13,  20,   1,  17,  13,   2,  33,   1,  13,   0,  /* "condemnation" 83225 */
     12,   8,  13,  20,   1,  17,  13,   2,  33,   1,  13,  30,   0,  /* "condemnations" 83238 */
     12,   1,  13,  20,  21,  17,  20,   0,  /* "condemned" 83246 */
     12,   1,  13,  20,  21,  17,  31,  32,   0,  /* "condemning" 83255 */
     12,   1,  13,  20,  21,  17,  30,   0,  /* "condemns" 83263 */
     12,   1,  13,  20,  21,  13,  14,   0,  /* "condense" 83271 */
     12,   1,  13,  20,  21,  13,  14,   3,   0,  /* "condensed" 83280 */
     12,   1,  13,  20,  21,  13,  14,  10,   0,  /* "condenser" 83289 */
     12,   1,  13,  20,  21,  13,  14,  31,  32,   0,  /* "condensing" 83299 */
     12,   8,  13,  20,  26,   0,  /* "condie" 83305 */
     12,   8,  13,  20,   1,  17,   1,  13,   3,   0,  /* "condiment" 83315 */
     12,   8,  13,  20,   1,  17,   1,  13,   3,  14,   0,  /* "condiments" 83326 */
     12,   8,  13,  20,   5,   3,   0,  /* "condit" 83333 */
     12,   8,  13,  20,   5,   3,   0,  /* "conditt" 83340 */
     12,   1,  13,  20,  25,   7,   1,  13,  14,   0,  /* "condolence" 83350 */
     12,   1,  13,  20,  25,   7,   1,  13,  14,   1,  30,   0,  /* "condolences" 83362 */
     12,   1,  13,  20,  25,  13,   0,  /* "condone" 83369 */
     12,   1,  13,  20,  25,  13,  20,   0,  /* "condoned" 83377 */
     12,   1,  13,  20,  25,  13,  30,   0,  /* "condones" 83385 */
     12,   1,  13,  20,  25,  13,  31,  32,   0,  /* "condoning" 83394 */
     12,   8,  13,  20,   4,  24,  12,  26,   0,  /* "condracky" 83403 */
     12,   8,  13,  20,  10,  26,   0,  /* "condry" 83410 */
     12,   1,  13,  20,  29,  14,  31,  22,   0,  /* "conducive" 83419 */
     12,  35,  13,  20,   1,  12,   3,   0,  /* "conduct" 83427 */
     12,   1,  13,  20,  35,  12,   3,   0,  /* "conduct" 83435 */
     12,   8,  13,  20,  35,  12,   3,   5,  22,   1,   3,  26,   0,  /* "conductivity" 83448 */
     12,  35,  13,  20,   1,  12,   3,  14,   0,  /* "conducts" 83457 */
     12,   1,  13,  20,  35,  12,   3,  14,   0,  /* "conducts" 83466 */
     12,   8,  13,  20,  29,   5,   3,   0,  /* "conduit" 83474 */
     12,   8,  13,  20,  29,   1,   3,  14,   0,  /* "conduits" 83483 */
     12,  25,  13,   0,  /* "cone" 83487 */
     12,  25,  13,  38,  15,  20,   0,  /* "conehead" 83494 */
     12,  25,  13,  38,  15,  20,  30,   0,  /* "coneheads" 83502 */
     12,   8,  13,   1,  14,   3,  25,  11,   1,   0,  /* "conestoga" 83512 */
     12,   1,  13,  37,  24,   9,  41,   1,   7,   2,  33,   1,  13,   0,  /* "confabulation" 83526 */
     12,   8,  13,  37,  21,   4,   0,  /* "confair" 83533 */
     12,   1,  13,  37,  21,  12,  33,   1,  13,  21,   4,  26,   0,  /* "confectionery" 83546 */
     12,   1,  13,  37,  44,   0,  /* "confer" 83552 */
     12,   8,  13,  37,  10,  23,   0,  /* "conferee" 83559 */
     12,   8,  13,  37,  10,  23,  30,   0,  /* "conferees" 83567 */
     12,   8,  13,  37,  10,   1,  13,  14,   0,  /* "conference" 83576 */
     12,   8,  13,  37,  10,   1,  13,  14,   1,  30,   0,  /* "conferences" 83587 */
     12,   8,  13,  37,   4,   1,  13,  14,  31,  32,   0,  /* "conferencing" 83598 */
     12,   1,  13,  37,  44,  20,   0,  /* "conferred" 83605 */
     12,   1,  13,  37,  44,  30,   0,  /* "confers" 83612 */
     12,   1,  13,  37,  21,  14,   0,  /* "confess" 83619 */
     12,   8,  13,  37,   1,  20,   8,  13,   3,   0,  /* "confidant" 83629 */
     12,   8,  13,  37,   1,  20,  24,  13,   3,   0,  /* "confidante" 83639 */
     12,   8,  13,  37,   1,  20,  24,  13,   3,  14,   0,  /* "confidants" 83650 */
     12,   1,  13,  37,  39,  20,   0,  /* "confide" 83657 */
     12,   1,  13,  37,  39,  20,   1,  20,   0,  /* "confided" 83666 */
     12,   8,  13,  37,   1,  20,   1,  13,  14,   0,  /* "confidence" 83676 */
     12,   8,  13,  37,   1,  20,   1,  13,  14,   1,  30,   0,  /* "confidences" 83688 */
     12,   8,  13,  37,   1,  20,   1,  13,   3,   0,  /* "confident" 83698 */
     12,   8,  13,  37,   1,  20,  21,  13,  33,   1,   7,   0,  /* "confidential" 83710 */
     12,   8,  13,  37,   1,  20,  21,  13,  33,  26,  24,   7,   1,   3,  26,   0,  /* "confidentiality" 83726 */
     12,   8,  13,  37,   1,  20,  21,  13,  33,   1,   7,  26,   0,  /* "confidentially" 83739 */
     12,   8,  13,  37,   1,  20,   1,  13,   3,   7,  26,   0,  /* "confidently" 83751 */
     12,   1,  13,  37,  39,  20,  30,   0,  /* "confides" 83759 */
     12,   1,  13,  37,  39,  20,  31,  32,   0,  /* "confiding" 83768 */
     12,   1,  13,  37,   5,  11,  41,  10,   2,  33,   1,  13,   0,  /* "configuration" 83781 */
     12,   1,  13,  37,   5,  11,  41,  10,   2,  33,   1,  13,  30,   0,  /* "configurations" 83795 */
     12,   1,  13,  37,   5,  11,  41,  10,   0,  /* "configure" 83804 */
     12,   1,  13,  37,   5,  11,  41,  10,  20,   0,  /* "configured" 83814 */
     12,   1,  13,  37,   5,  11,  41,  10,  31,  32,   0,  /* "configuring" 83825 */
     12,   8,  13,  37,   5,  13,  20,  35,  14,   3,   4,  26,   1,   0,  /* "confindustria" 83839 */
     12,   8,  13,  37,  39,  13,   0,  /* "confine" 83846 */
     12,   1,  13,  37,  39,  13,   0,  /* "confine" 83853 */
     12,   1,  13,  37,  39,  13,  20,   0,  /* "confined" 83861 */
     12,   1,  13,  37,  39,  13,  17,   1,  13,   3,   0,  /* "confinement" 83872 */
     12,   8,  13,  37,  39,  13,  30,   0,  /* "confines" 83880 */
     12,   1,  13,  37,  39,  13,  30,   0,  /* "confines" 83888 */
     12,   1,  13,  37,  39,  13,  31,  32,   0,  /* "confining" 83897 */
     12,   1,  13,  37,  44,  17,   1,   9,   1,   7,   0,  /* "confirmable" 83908 */
     12,   8,  13,  37,  10,  17,   2,  33,   1,  13,   0,  /* "confirmation" 83919 */
     12,   8,  13,  37,  10,  17,   2,  33,   1,  13,  30,   0,  /* "confirmations" 83931 */
     12,   1,  13,  37,  44,  17,   1,   3,  18,   4,  26,   0,  /* "confirmatory" 83943 */
     12,   8,  13,  37,   1,  14,  12,   2,   3,   0,  /* "confiscate" 83953 */
     12,   8,  13,  37,   1,  14,  12,   2,   3,   1,  20,   0,  /* "confiscated" 83965 */
     12,   8,  13,  37,   1,  14,  12,   2,   3,  31,  32,   0,  /* "confiscating" 83977 */
     12,   8,  13,  37,   1,  14,  12,   2,  33,   1,  13,   0,  /* "confiscation" 83989 */
     12,   1,  13,  37,   5,  14,  12,   1,   3,  18,   4,  26,   0,  /* "confiscatory" 84002 */
     12,   8,  13,  37,   1,   3,   5,   4,  26,   1,  30,   0,  /* "confiterias" 84014 */
     12,   8,  13,  37,   7,   1,  11,   4,   2,  33,   1,  13,   0,  /* "conflagration" 84027 */
     12,   8,  13,  37,   7,  31,  12,   3,   0,  /* "conflict" 84036 */
     12,   1,  13,  37,   7,   5,  12,   3,   0,  /* "conflict" 84045 */
     12,   8,  13,  37,   7,  31,  12,   3,  14,   0,  /* "conflicts" 84055 */
     12,   1,  13,  37,   7,   5,  12,   3,  14,   0,  /* "conflicts" 84065 */
     12,   8,  13,  37,   7,  29,   1,  13,  14,   0,  /* "confluence" 84075 */
     12,  19,  13,  37,   7,  29,   1,  13,   3,   0,  /* "confluent" 84085 */
     12,   1,  13,  37,  18,   4,  17,   1,  13,  14,   0,  /* "conformance" 84096 */
     12,   8,  13,  37,  10,  17,   2,  33,   1,  13,   1,   7,   0,  /* "conformational" 84109 */
     12,   1,  13,  37,  18,   4,  17,   5,  14,   3,   0,  /* "conformist" 84120 */
     12,  19,  13,  37,  18,   4,   3,  26,   0,  /* "conforti" 84129 */
     12,  19,  13,  37,  48,  13,  20,   0,  /* "confound" 84137 */
     12,   8,  13,  37,   4,   1,  13,   3,   2,  33,   1,  13,   0,  /* "confrontation" 84150 */
     12,   8,  13,  37,   4,   1,  13,   3,   2,  33,   1,  13,   1,   7,   0,  /* "confrontational" 84165 */
     12,   8,  13,  37,   4,   1,  13,   3,   2,  33,   1,  13,  30,   0,  /* "confrontations" 84179 */
     12,   1,  13,  37,  41,  29,  33,   1,  13,   0,  /* "confucian" 84189 */
     12,   1,  13,  37,  41,  29,  33,   1,  13,   5,  30,   1,  17,   0,  /* "confucianism" 84203 */
     12,   1,  13,  37,  41,  29,  33,   1,  14,   0,  /* "confucius" 84213 */
     12,   1,  13,  37,  41,  29,  30,   0,  /* "confuse" 84221 */
     12,   1,  13,  37,  41,  29,  30,  20,   0,  /* "confused" 84230 */
     12,   1,  13,  37,  41,  29,  30,   1,  30,   0,  /* "confuses" 84240 */
     12,   1,  13,  37,  41,  29,  30,  31,  32,   0,  /* "confusing" 84250 */
     12,   1,  13,  37,  41,  29,  30,  31,  32,   7,  26,   0,  /* "confusingly" 84262 */
     12,   1,  13,  37,  41,  29,  43,   1,  13,   0,  /* "confusion" 84272 */
     12,   1,  13,  37,  41,  29,  43,   1,  13,  30,   0,  /* "confusions" 84283 */
     12,  18,  32,   0,  /* "cong" 84287 */
     12,  18,  32,  11,   1,   0,  /* "conga" 84293 */
     12,   8,  32,  20,   1,  13,   0,  /* "congdon" 84300 */
     12,   1,  13,  40,  23,   7,   0,  /* "congeal" 84307 */
     12,   1,  13,  40,  23,   7,  20,   0,  /* "congealed" 84315 */
     12,   1,  13,  40,  23,  13,  41,   1,   7,   0,  /* "congenial" 84325 */
     12,   1,  13,  40,  23,  13,  26,  24,   7,   1,   3,  26,   0,  /* "congeniality" 84338 */
     12,   1,  13,  40,  21,  13,   1,   3,   1,   7,   0,  /* "congenital" 84349 */
     12,  18,  32,  10,   0,  /* "conger" 84354 */
     12,   1,  13,  40,  21,  14,   3,   0,  /* "congest" 84362 */
     12,   8,  32,  11,   1,   7,   3,  19,  13,   0,  /* "congleton" 84372 */
     12,   1,  13,  11,   7,   8,  17,  10,   1,   3,   0,  /* "conglomerate" 84383 */
     12,   1,  13,  11,   7,   8,  17,  10,   1,   3,  14,   0,  /* "conglomerates" 84395 */
     12,   1,  13,  11,   7,   8,  17,  10,   2,  33,   1,  13,   0,  /* "conglomeration" 84408 */
     12,   8,  32,  11,  27,   0,  /* "congo" 84414 */
     12,   1,  13,  11,   4,  24,  42,   1,   7,   2,   3,   0,  /* "congratulate" 84426 */
     12,   1,  13,  11,   4,  24,  42,   1,   7,   2,   3,   1,  20,   0,  /* "congratulated" 84440 */
     12,   1,  13,  11,   4,  24,  42,   1,   7,   2,   3,  31,  32,   0,  /* "congratulating" 84454 */
     12,   1,  13,  11,   4,  24,  42,   1,   7,   2,  33,   1,  13,   0,  /* "congratulation" 84468 */
     12,   1,  13,  11,   4,  24,  42,   1,   7,   2,  33,   1,  13,  30,   0,  /* "congratulations" 84483 */
     12,   1,  13,  11,   4,  24,  42,   1,   7,   1,   3,  18,   4,  26,   0,  /* "congratulatory" 84498 */
     12,   1,  13,  11,   4,  21,  33,   1,  13,   1,   7,   0,  /* "congressional" 84510 */
     12,   1,  13,  11,   4,  21,  33,   1,  13,   1,   7,  26,   0,  /* "congressionally" 84523 */
     12,   8,  32,  11,   4,   1,  14,   6,  23,   6,   1,   7,   0,  /* "congresspeople" 84536 */
     12,   8,  32,  11,   4,   1,  14,   6,  44,  14,   1,  13,   0,  /* "congressperson" 84549 */
     12,   8,  32,  11,   4,   1,  14,   6,  44,  14,   1,  13,  30,   0,  /* "congresspersons" 84563 */
     12,   8,  32,  11,   4,   1,  22,   0,  /* "congrove" 84571 */
     12,  18,  13,  11,   4,  29,   1,  13,  14,   0,  /* "congruence" 84581 */
     12,   1,  13,  11,   4,  29,   1,   3,  26,   0,  /* "congruity" 84591 */
     12,   8,  13,   1,  37,  10,   0,  /* "conifer" 84598 */
     12,   8,  13,   1,  37,  10,  30,   0,  /* "conifers" 84606 */
     12,   8,  13,   1,  14,   3,   1,  13,   0,  /* "coniston" 84615 */
     12,   1,  13,  40,  21,  12,  42,  10,   0,  /* "conjecture" 84624 */
     12,   1,  13,  40,  21,  12,  42,  10,  30,   0,  /* "conjectures" 84634 */
     12,   8,  13,  40,   1,  11,   1,   7,   0,  /* "conjugal" 84643 */
     12,   1,  13,  40,  35,  32,  12,  33,   1,  13,   0,  /* "conjunction" 84654 */
     12,   1,  13,  40,  35,  32,  12,  33,   1,  13,  30,   0,  /* "conjunctions" 84666 */
     12,   8,  13,  40,   1,  32,  12,   3,  39,  22,   1,   0,  /* "conjunctiva" 84678 */
     12,   8,  32,  12,   0,  /* "conk" 84683 */
     12,   8,  13,  12,  26,   0,  /* "conkey" 84689 */
     12,   8,  32,  12,   5,  13,   0,  /* "conkin" 84696 */
     12,   8,  32,  12,   1,   7,   0,  /* "conkle" 84703 */
     12,   8,  32,  12,   4,  39,   3,   0,  /* "conkright" 84711 */
     12,   8,  13,   0,  /* "conn" 84715 */
     12,   8,  13,  36,   3,  19,  13,   0,  /* "connaughton" 84723 */
     12,   1,  13,  21,   3,   1,  12,   1,   3,   0,  /* "connecticut" 84733 */
     12,   1,  13,  15,  12,   3,   5,  22,   1,   3,  26,   0,  /* "connectivity" 84745 */
     12,   8,  13,  20,   0,  /* "conned" 84750 */
     12,   8,  13,   1,   7,   0,  /* "connell" 84756 */
     12,   8,  13,   1,   7,  26,   0,  /* "connelley" 84763 */
     12,   8,  13,   1,   7,  26,   0,  /* "connelly" 84770 */
     12,   8,  13,   7,  26,   0,  /* "connely" 84776 */
     12,   8,  13,  10,   0,  /* "conner" 84781 */
     12,   8,  13,  10,   7,  26,   0,  /* "connerly" 84788 */
     12,   8,  13,  10,  30,   0,  /* "conners" 84794 */
     12,   8,  13,  10,  26,   0,  /* "connery" 84800 */
     12,   8,  13,  15,   3,   0,  /* "connett" 84806 */
     12,   8,  13,  31,  12,   0,  /* "connick" 84812 */
     12,  18,  13,  26,   0,  /* "connie" 84817 */
     12,   8,  13,   5,  37,   0,  /* "conniff" 84823 */
     12,   8,  13,  31,  32,   0,  /* "conning" 84829 */
     12,   1,  13,  39,  22,   1,  13,  14,   0,  /* "connivance" 84838 */
     12,   1,  13,  39,  22,   0,  /* "connive" 84844 */
     12,   1,  13,  39,  22,  31,  32,   0,  /* "conniving" 84852 */
     12,   8,  13,   1,  14,  44,   0,  /* "connoisseur" 84859 */
     12,   8,  13,   1,   7,   0,  /* "connole" 84865 */
     12,  18,  13,   1,   7,  26,   0,  /* "connolly" 84872 */
     12,   1,  13,  25,   3,   0,  /* "connote" 84878 */
     12,   1,  13,  25,   3,  14,   0,  /* "connotes" 84885 */
     12,   8,  13,   1,  12,  27,   0,  /* "conoco" 84892 */
     12,   8,  13,  27,   7,  26,   0,  /* "conolly" 84899 */
     12,   8,  13,  27,   7,  26,   0,  /* "conoly" 84906 */
     12,   8,  13,   1,  22,  10,   0,  /* "conover" 84913 */
     12,   8,  32,  12,  47,  15,  14,   3,   0,  /* "conquest" 84922 */
     12,   8,  13,  12,  47,  21,  14,   3,  14,   0,  /* "conquests" 84932 */
     12,   8,  13,   4,  34,  12,   0,  /* "conrac" 84939 */
     12,   8,  13,   4,  34,  20,   0,  /* "conrad" 84946 */
     12,   1,  13,   4,   2,  20,  30,   0,  /* "conrades" 84954 */
     12,  19,  13,   4,   8,  20,  26,   0,  /* "conradi" 84962 */
     12,   8,  13,   4,   1,  20,  39,  13,   0,  /* "conradine" 84971 */
     12,   8,  13,   4,  34,  20,  30,   0,  /* "conrads" 84979 */
     12,   8,  13,   4,  34,   3,   0,  /* "conradt" 84986 */
     12,   1,  13,   4,   8,  20,  26,   0,  /* "conrady" 84994 */
     12,  18,  13,   4,  50,   0,  /* "conroy" 85000 */
     12,   8,  13,  30,   0,  /* "cons" 85005 */
     12,   8,  13,  33,   1,  13,  14,   0,  /* "conscience" 85013 */
     12,   8,  13,  33,   1,  13,  14,   1,  30,   0,  /* "consciences" 85023 */
     12,   8,  13,  33,  26,  21,  13,  33,   1,  14,   0,  /* "conscientious" 85034 */
     12,   8,  13,  42,  26,  21,  13,  42,   1,  14,   7,  26,   0,  /* "conscientiously" 85047 */
     12,   8,  13,  14,  12,   4,   5,   6,   3,   0,  /* "conscript" 85057 */
     12,   1,  13,  14,  12,   4,   5,   6,   3,   0,  /* "conscript" 85067 */
     12,   1,  13,  14,  12,   4,   5,   6,   3,   1,  20,   0,  /* "conscripted" 85079 */
     12,   1,  13,  14,  12,   4,   5,   6,  33,   1,  13,   0,  /* "conscription" 85091 */
     12,   8,  13,  14,  12,   4,   5,   6,   3,  14,   0,  /* "conscripts" 85102 */
     12,   1,  13,  14,  12,   4,   5,   6,   3,  14,   0,  /* "conscripts" 85113 */
     12,  19,  13,  14,   2,  12,  27,   0,  /* "conseco" 85121 */
     12,   8,  13,  14,   1,  12,   4,   2,   3,   0,  /* "consecrate" 85131 */
     12,   8,  13,  14,   1,  12,   4,   2,   3,   1,  20,   0,  /* "consecrated" 85143 */
     12,   8,  13,  14,   1,  12,   4,   2,  33,   1,  13,   0,  /* "consecration" 85155 */
     12,   8,  13,  14,   1,  12,   4,   2,  33,   1,  13,  30,   0,  /* "consecrations" 85168 */
     12,   1,  13,  14,  21,  12,  41,   1,   3,  31,  22,   0,  /* "consecutive" 85180 */
     12,   1,  13,  14,  21,  12,  41,   1,   3,  31,  22,   7,  26,   0,  /* "consecutively" 85194 */
     12,   1,  13,  14,  21,  13,  14,  29,   1,   7,   0,  /* "consensual" 85205 */
     12,   1,  13,  14,  21,  13,   3,   0,  /* "consent" 85213 */
     12,  19,  13,  14,  15,  13,   3,  23,  13,  27,   0,  /* "consentino" 85224 */
     12,   1,  13,  14,  21,  13,   3,  14,   0,  /* "consents" 85233 */
     12,   8,  13,  14,   1,  12,  47,   1,  13,  14,   0,  /* "consequence" 85244 */
     12,   8,  13,  14,   1,  12,  47,  21,  13,  14,   1,  30,   0,  /* "consequences" 85257 */
     12,   8,  13,  14,   1,  12,  47,   1,  13,   3,   0,  /* "consequent" 85268 */
     12,   8,  13,  14,   1,  12,  47,  21,  13,  42,   1,   7,   0,  /* "consequential" 85281 */
     12,   8,  13,  14,   1,  12,  47,   1,  13,   3,   7,  26,   0,  /* "consequently" 85294 */
     12,   8,  13,  14,  10,   0,  /* "conser" 85300 */
     12,   8,  13,  14,  10,  22,   2,  33,   1,  13,   0,  /* "conservation" 85311 */
     12,   8,  13,  14,  10,  22,   2,  33,   1,  13,   1,  14,   3,   0,  /* "conservationist" 85325 */
     12,   8,  13,  14,  10,  22,   2,  33,   1,  13,   1,  14,   3,  14,   0,  /* "conservationists" 85340 */
     12,   1,  13,  14,  44,  22,   1,   3,   5,  30,   1,  17,   0,  /* "conservatism" 85353 */
     12,   1,  13,  14,  44,  22,   1,   3,  31,  22,   5,  30,   1,  17,   0,  /* "conservativism" 85368 */
     12,   1,  13,  14,  44,  22,   1,   3,  36,   4,  26,   0,  /* "conservatory" 85380 */
     12,   1,  13,  14,   5,  20,  10,   1,   9,   1,   7,   0,  /* "considerable" 85392 */
     12,   8,  13,  14,   1,  20,  39,  13,   0,  /* "considine" 85401 */
     12,  19,  13,  14,  23,  11,   7,  26,  27,   0,  /* "consiglio" 85411 */
     12,   1,  13,  14,  39,  13,   0,  /* "consign" 85418 */
     12,   1,  13,  14,  39,  13,  20,   0,  /* "consigned" 85426 */
     12,   1,  13,  14,  39,  13,  17,   1,  13,   3,   0,  /* "consignment" 85437 */
     12,   8,  13,  14,  19,   9,   0,  /* "consob" 85444 */
     12,   8,  13,  14,  19,   7,   0,  /* "consol" 85451 */
     12,  19,  13,  14,  27,   7,   8,   3,   1,   0,  /* "consolata" 85461 */
     12,   8,  13,  14,   1,   7,   2,  33,   1,  13,   0,  /* "consolation" 85472 */
     12,   8,  13,  14,   1,   7,   2,  33,   1,  13,  30,   0,  /* "consolations" 85484 */
     12,   8,  13,  14,  27,   7,   0,  /* "console" 85491 */
     12,   1,  13,  14,  25,   7,   0,  /* "console" 85498 */
     12,   8,  13,  14,  27,   7,  30,   0,  /* "consoles" 85506 */
     12,   1,  13,  14,  25,   7,  30,   0,  /* "consoles" 85514 */
     12,  19,  13,  14,  25,   7,  26,   0,  /* "consoli" 85522 */
     12,   1,  13,  14,  25,   7,  31,  32,   0,  /* "consoling" 85531 */
     12,  19,  13,  14,  25,   7,  27,   0,  /* "consolo" 85539 */
     12,   8,  13,  14,   1,  13,   1,  13,   3,   0,  /* "consonant" 85549 */
     12,   8,  13,  14,   1,  13,   8,  13,   3,   1,   7,   0,  /* "consonantal" 85561 */
     12,   8,  13,  14,   1,  13,   1,  13,   3,  14,   0,  /* "consonants" 85572 */
     12,   8,  13,  14,  36,   4,   3,   0,  /* "consort" 85580 */
     12,   1,  13,  14,  18,   4,   3,   0,  /* "consort" 85588 */
     12,   1,  13,  14,  18,   4,  33,  26,   1,  17,   0,  /* "consortium" 85599 */
     12,   1,  13,  14,  18,   4,  33,  26,   1,  17,  30,   0,  /* "consortiums" 85611 */
     12,   8,  13,  14,  36,   4,   3,  14,   0,  /* "consorts" 85620 */
     12,   1,  13,  14,  18,   4,   3,  14,   0,  /* "consorts" 85629 */
     12,   1,  13,  14,   6,   5,  12,  41,  29,   1,  14,   0,  /* "conspicuous" 85641 */
     12,   1,  13,  14,   6,   5,  12,  41,  29,   1,  14,   7,  26,   0,  /* "conspicuously" 85655 */
     12,   1,  13,  14,   6,   5,   4,   1,  14,  26,  30,   0,  /* "conspiracies" 85667 */
     12,   1,  13,  14,   6,   5,   4,   1,  14,  26,   0,  /* "conspiracy" 85678 */
     12,   1,  13,  14,   6,   5,   4,   1,   3,  10,   0,  /* "conspirator" 85689 */
     12,   1,  13,  14,   6,   5,   4,   1,   3,  18,   4,  26,   1,   7,   0,  /* "conspiratorial" 85704 */
     12,   1,  13,  14,   6,   5,   4,   1,   3,  18,   4,  26,   1,   7,  26,   0,  /* "conspiratorially" 85720 */
     12,   1,  13,  14,   6,   5,   4,   1,   3,  10,  30,   0,  /* "conspirators" 85732 */
     12,   1,  13,  14,   6,  39,  10,   0,  /* "conspire" 85740 */
     12,   1,  13,  14,   6,  39,  10,  20,   0,  /* "conspired" 85749 */
     12,   1,  13,  14,   6,  39,   4,  31,  32,   0,  /* "conspiring" 85759 */
     12,   8,  13,  14,   3,   1,   9,   1,   7,   0,  /* "constable" 85769 */
     12,   8,  13,  14,   3,   1,   9,   1,   7,  30,   0,  /* "constables" 85780 */
     12,   1,  13,  14,   3,  24,   9,  41,   1,   7,  21,   4,  26,   0,  /* "constabulary" 85794 */
     12,  19,  13,  14,   3,   8,  13,   3,   1,   0,  /* "constanta" 85804 */
     12,   1,  13,  14,   3,  24,  13,   3,   5,  13,   0,  /* "constantin" 85815 */
     12,  19,  13,  14,   3,  19,  13,   3,  23,  13,   1,   0,  /* "constantina" 85827 */
     12,   8,  13,  14,   3,  34,  13,   3,   1,  13,  25,   6,   1,   7,   0,  /* "constantinople" 85842 */
     12,   8,  13,  14,   3,   1,  13,   3,  23,  13,  27,  14,   0,  /* "constantinos" 85855 */
     12,   8,  13,  14,   3,   1,   7,   2,  33,   1,  13,   0,  /* "constellation" 85867 */
     12,   8,  13,  14,   3,   1,   7,   2,  33,   1,  13,  30,   0,  /* "constellations" 85880 */
     12,   8,  13,  14,   3,  10,  13,   2,  33,   1,  13,   0,  /* "consternation" 85892 */
     12,   1,  13,  14,   3,   5,  42,  29,   1,  13,  14,  26,  30,   0,  /* "constituencies" 85906 */
     12,   1,  13,  14,   3,   5,  42,  29,   1,  13,  14,  26,   0,  /* "constituency" 85919 */
     12,   1,  13,  14,   3,   5,  42,  29,   1,  13,   3,   0,  /* "constituent" 85931 */
     12,   1,  13,  14,   3,   5,  42,  29,   1,  13,   3,  14,   0,  /* "constituents" 85944 */
     12,   8,  13,  14,   3,   1,   3,  29,   3,   0,  /* "constitute" 85954 */
     12,   8,  13,  14,   3,   1,   3,  29,   3,   1,  20,   0,  /* "constituted" 85966 */
     12,   8,  13,  14,   3,   1,   3,  29,   3,  14,   0,  /* "constitutes" 85977 */
     12,   8,  13,  14,   3,   1,   3,  29,   3,  31,  32,   0,  /* "constituting" 85989 */
     12,   8,  13,  14,   3,   1,   3,  29,  33,   1,  13,   0,  /* "constitution" 86001 */
     12,   8,  13,  14,   3,   1,   3,  29,  33,   1,  13,   1,   7,   0,  /* "constitutional" 86015 */
     12,   8,  13,  14,   3,   1,   3,  29,  33,   1,  13,  24,   7,   1,   3,  26,   0,  /* "constitutionality" 86032 */
     12,   8,  13,  14,   3,   1,   3,  29,  33,   1,  13,   1,   7,  26,   0,  /* "constitutionally" 86047 */
     12,   8,  13,  14,   3,   1,   3,  29,  33,   1,  13,   1,  14,   3,   0,  /* "constitutionist" 86062 */
     12,   8,  13,  14,   3,   1,   3,  29,  33,   1,  13,   1,  14,   3,  14,   0,  /* "constitutionists" 86078 */
     12,   8,  13,  14,   3,   1,   3,  29,  33,   1,  13,  30,   0,  /* "constitutions" 86091 */
     12,   1,  13,  14,   3,   4,   2,  13,   0,  /* "constrain" 86100 */
     12,   1,  13,  14,   3,   4,   2,  13,  20,   0,  /* "constrained" 86110 */
     12,   1,  13,  14,   3,   4,   2,  13,  31,  32,   0,  /* "constraining" 86121 */
     12,   1,  13,  14,   3,   4,   2,  13,  30,   0,  /* "constrains" 86131 */
     12,   1,  13,  14,   3,   4,   2,  13,   3,   0,  /* "constraint" 86141 */
     12,   1,  13,  14,   3,   4,   2,  13,   3,  14,   0,  /* "constraints" 86152 */
     12,   1,  13,  14,   3,   4,   5,  12,   3,   0,  /* "constrict" 86162 */
     12,   1,  13,  14,   3,   4,   5,  12,   3,   1,  20,   0,  /* "constricted" 86174 */
     12,   1,  13,  14,   3,   4,   5,  12,   3,  31,  32,   0,  /* "constricting" 86186 */
     12,   1,  13,  14,   3,   4,   5,  12,  33,   1,  13,   0,  /* "constriction" 86198 */
     12,   1,  13,  14,   3,   4,   5,  12,  33,   1,  13,  30,   0,  /* "constrictions" 86211 */
     12,   1,  13,  14,   3,   4,   5,  12,   3,  10,   0,  /* "constrictor" 86222 */
     12,   1,  13,  14,   3,   4,   5,  12,   3,  10,  30,   0,  /* "constrictors" 86234 */
     12,   1,  13,  14,   3,   4,  29,  42,  26,  25,  13,  28,  30,   0,  /* "construcciones" 86248 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,   0,  /* "construct" 86258 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,   1,  20,   0,  /* "constructed" 86270 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,  31,  32,   0,  /* "constructing" 86282 */
     12,   1,  13,  14,   3,   4,  35,  12,  33,   1,  13,   0,  /* "construction" 86294 */
     12,   1,  13,  14,   3,   4,  35,  12,  33,   1,  13,   5,  14,   3,   0,  /* "constructionist" 86309 */
     12,   1,  13,  14,   3,   4,  35,  12,  33,   1,  13,  30,   0,  /* "constructions" 86322 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,  31,  22,   0,  /* "constructive" 86334 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,  31,  22,   7,  26,   0,  /* "constructively" 86348 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,  10,   0,  /* "constructor" 86359 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,  10,  30,   0,  /* "constructors" 86371 */
     12,   1,  13,  14,   3,   4,  35,  12,   3,  14,   0,  /* "constructs" 86382 */
     12,   1,  13,  14,   3,   4,  29,   0,  /* "construe" 86390 */
     12,   1,  13,  14,   3,   4,  29,  20,   0,  /* "construed" 86399 */
     12,   1,  13,  14,  47,   2,   7,   1,   0,  /* "consuela" 86408 */
     12,   8,  13,  14,   1,   7,   0,  /* "consul" 86415 */
     12,   8,  13,  14,   1,   7,  10,   0,  /* "consular" 86423 */
     12,   8,  13,  14,   1,   7,   1,   3,   0,  /* "consulate" 86432 */
     12,   8,  13,  14,   1,   7,   1,   3,  14,   0,  /* "consulates" 86442 */
     12,   8,  13,  14,   1,   7,  33,   5,   6,   0,  /* "consulship" 86452 */
     12,   8,  13,  14,   1,   7,   3,   2,  33,   1,  13,   0,  /* "consultation" 86464 */
     12,   8,  13,  14,   1,   7,   3,   2,  33,   1,  13,  30,   0,  /* "consultations" 86477 */
     12,   1,  13,  14,  29,  17,   1,   9,   1,   7,   0,  /* "consumable" 86488 */
     12,   1,  13,  14,  29,  17,   0,  /* "consume" 86495 */
     12,   1,  13,  14,  29,  17,  20,   0,  /* "consumed" 86503 */
     12,   1,  13,  14,  29,  17,  10,   0,  /* "consumer" 86511 */
     12,   1,  13,  14,  29,  17,  10,   5,  30,   1,  17,   0,  /* "consumerism" 86523 */
     12,   1,  13,  14,  29,  17,  10,   5,  14,   3,   0,  /* "consumerist" 86534 */
     12,   1,  13,  14,  29,  17,  10,   5,  14,   3,  14,   0,  /* "consumerists" 86546 */
     12,   1,  13,  14,  29,  17,  10,  30,   0,  /* "consumers" 86555 */
     12,   1,  13,  14,  29,  17,  30,   0,  /* "consumes" 86563 */
     12,   1,  13,  14,  29,  17,  31,  32,   0,  /* "consuming" 86572 */
     12,   8,  13,  14,   1,  17,   1,   3,   0,  /* "consummate" 86581 */
     12,   8,  13,  14,   1,  17,   2,   3,   1,  20,   0,  /* "consummated" 86592 */
     12,   8,  13,  14,   1,  17,   2,   3,  31,  32,   0,  /* "consummating" 86603 */
     12,   8,  13,  14,   1,  17,   2,  33,   1,  13,   0,  /* "consummation" 86614 */
     12,   8,  13,   3,  34,  12,   0,  /* "contac" 86621 */
     12,   8,  13,   3,  24,  12,   3,   0,  /* "contact" 86629 */
     12,   8,  13,   3,  24,  12,   3,   1,  20,   0,  /* "contacted" 86639 */
     12,   8,  13,   3,  24,  12,   3,  31,  32,   0,  /* "contacting" 86649 */
     12,   8,  13,   3,  24,  12,   3,  14,   0,  /* "contacts" 86658 */
     12,   8,  13,   3,   1,  20,  18,   4,   1,   0,  /* "contadora" 86668 */
     12,   1,  13,   3,   2,  13,  10,  39,  30,   0,  /* "containerize" 86678 */
     12,   1,  13,   3,   2,  13,  10,  39,  30,  20,   0,  /* "containerized" 86689 */
     12,   1,  13,   3,  24,  17,   1,  13,   1,  13,   3,   0,  /* "contaminant" 86701 */
     12,   1,  13,   3,  24,  17,   1,  13,   1,  13,   3,  14,   0,  /* "contaminants" 86714 */
     12,   8,  13,   3,   1,  13,   3,   0,  /* "contant" 86722 */
     12,  18,  13,   3,   0,  /* "conte" 86727 */
     12,   8,  13,   3,  21,   7,   0,  /* "contel" 86734 */
     12,   8,  13,   3,   1,  17,   6,   7,   2,   3,   0,  /* "contemplate" 86745 */
     12,   8,  13,   3,   1,  17,   6,   7,   2,   3,   1,  20,   0,  /* "contemplated" 86758 */
     12,   8,  13,   3,   1,  17,   6,   7,   2,   3,  14,   0,  /* "contemplates" 86770 */
     12,   8,  13,   3,   1,  17,   6,   7,   2,   3,  31,  32,   0,  /* "contemplating" 86783 */
     12,   8,  13,   3,   1,  17,   6,   7,   2,  33,   1,  13,   0,  /* "contemplation" 86796 */
     12,   1,  13,   3,  21,  17,   6,   7,   1,   3,  31,  22,   0,  /* "contemplative" 86809 */
     12,   8,  13,   3,  21,  17,   6,  27,   0,  /* "contempo" 86818 */
     12,   1,  13,   3,  21,  17,   6,  10,  21,   4,  26,  30,   0,  /* "contemporaries" 86831 */
     12,   1,  13,   3,  21,  17,   6,   3,   1,   9,   1,   7,   0,  /* "contemptible" 86844 */
     12,   1,  13,   3,  21,  17,   6,  42,  29,   1,  14,   0,  /* "contemptuous" 86856 */
     12,   1,  13,   3,  21,  17,   6,  42,  47,   1,  14,   7,  26,   0,  /* "contemptuously" 86870 */
     12,   8,  13,   3,  15,  13,   3,   0,  /* "content" 86878 */
     12,   1,  13,   3,  21,  13,   3,   0,  /* "content" 86886 */
     12,   1,  13,   3,  21,  13,   3,  27,   0,  /* "contento" 86895 */
     12,   8,  13,   3,  15,  13,   3,  14,   0,  /* "contents" 86904 */
     12,   1,  13,   3,  21,  13,   3,  14,   0,  /* "contents" 86913 */
     12,   8,  13,   3,  15,  14,   3,   0,  /* "contest" 86921 */
     12,   1,  13,   3,  21,  14,   3,   0,  /* "contest" 86929 */
     12,   1,  13,   3,  21,  14,   3,   1,   9,   1,   7,   0,  /* "contestable" 86941 */
     12,   8,  13,   3,  15,  14,   3,  14,   0,  /* "contests" 86950 */
     12,   1,  13,   3,  21,  14,   3,  14,   0,  /* "contests" 86959 */
     12,   8,  13,   3,  15,  12,  14,   3,   0,  /* "context" 86968 */
     12,   8,  13,   3,  21,  12,  14,   3,  14,   0,  /* "contexts" 86978 */
     12,   8,  13,   3,  26,   0,  /* "conti" 86984 */
     12,   8,  13,   3,   1,   9,   1,   7,   0,  /* "contibel" 86993 */
     12,   8,  13,   3,  31,  12,   1,  17,   8,  20,   1,   3,  26,   0,  /* "conticommodity" 87007 */
     12,   1,  13,   3,   5,  11,  41,  29,   1,  14,   0,  /* "contiguous" 87018 */
     12,   8,  13,   3,   1,  13,   1,  13,   3,   0,  /* "continent" 87028 */
     12,   8,  13,   3,   1,  13,  21,  13,   3,   1,   7,   0,  /* "continental" 87040 */
     12,   8,  13,   3,   1,  13,  21,  13,   3,   1,   7,  26,   0,  /* "continentally" 87053 */
     12,   8,  13,   3,   1,  13,  21,  13,   3,   1,   7,  30,   0,  /* "continentals" 87066 */
     12,   8,  13,   3,   1,  13,   1,  13,   3,  14,   0,  /* "continents" 87077 */
     12,   1,  13,   3,   5,  13,  40,   1,  13,  14,  26,  30,   0,  /* "contingencies" 87090 */
     12,   1,  13,   3,   5,  13,  40,   1,  13,  14,  26,   0,  /* "contingency" 87102 */
     12,   1,  13,   3,   5,  13,  40,   1,  13,   3,  14,   0,  /* "contingents" 87114 */
     12,  19,  13,   3,  23,  13,  27,   0,  /* "contino" 87122 */
     12,   1,  13,   3,   5,  13,  41,  29,   1,   7,   0,  /* "continual" 87133 */
     12,   1,  13,   3,   5,  13,  41,  29,   1,   7,  26,   0,  /* "continually" 87145 */
     12,   1,  13,   3,   5,  13,  41,  29,   1,  13,  14,   0,  /* "continuance" 87157 */
     12,   1,  13,   3,   5,  13,  41,  29,   1,  13,  14,   1,  30,   0,  /* "continuances" 87171 */
     12,   1,  13,   3,   5,  13,  41,  29,   2,  33,   1,  13,   0,  /* "continuation" 87184 */
     12,   1,  13,   3,   5,  13,  41,  29,   0,  /* "continue" 87193 */
     12,   1,  13,   3,   5,  13,  41,  29,  20,   0,  /* "continued" 87203 */
     12,   1,  13,   3,   5,  13,  41,  29,  30,   0,  /* "continues" 87213 */
     12,   1,  13,   3,   5,  13,  41,  29,  31,  32,   0,  /* "continuing" 87224 */
     12,   8,  13,   3,   1,  13,  29,   1,   3,  26,   0,  /* "continuity" 87235 */
     12,   1,  13,   3,   5,  13,  41,  29,   1,  14,   0,  /* "continuous" 87246 */
     12,   1,  13,   3,   5,  13,  41,  29,   1,  14,   7,  26,   0,  /* "continuously" 87259 */
     12,   1,  13,   3,   5,  13,  41,  29,   1,  17,   0,  /* "continuum" 87270 */
     12,   8,  13,   3,  27,  30,   0,  /* "contos" 87277 */
     12,   8,  13,   3,  45,   4,   0,  /* "contour" 87284 */
     12,   8,  13,   3,  45,   4,  20,   0,  /* "contoured" 87292 */
     12,   8,  13,   3,  45,   4,  30,   0,  /* "contours" 87300 */
     12,   8,  13,   3,   4,   1,   9,  34,  14,  29,  13,   0,  /* "contrabassoon" 87312 */
     12,   8,  13,   3,   4,  24,  12,   3,   0,  /* "contract" 87321 */
     12,   1,  13,   3,   4,  24,  12,   3,   0,  /* "contract" 87330 */
     12,   8,  13,   3,   4,  34,  12,   3,   1,  20,   0,  /* "contracted" 87341 */
     12,   8,  13,   3,   4,  34,  12,   3,  31,  32,   0,  /* "contracting" 87352 */
     12,   1,  13,   3,   4,  24,  12,  33,   1,  13,   0,  /* "contraction" 87363 */
     12,   1,  13,   3,   4,  24,  12,  33,   1,  13,  15,   4,  26,   0,  /* "contractionary" 87377 */
     12,   1,  13,   3,   4,  24,  12,  33,   1,  13,  30,   0,  /* "contractions" 87389 */
     12,   8,  13,   3,   4,  24,  12,   3,  14,   0,  /* "contracts" 87399 */
     12,   1,  13,   3,   4,  24,  12,   3,  14,   0,  /* "contracts" 87409 */
     12,   1,  13,   3,   4,  24,  12,  42,  29,   1,   7,   0,  /* "contractual" 87421 */
     12,   1,  13,   3,   4,  24,  12,  42,  29,   1,   7,  26,   0,  /* "contractually" 87434 */
     12,   8,  13,   3,   4,   1,  20,   5,  12,   3,  14,   0,  /* "contradicts" 87446 */
     12,   8,  13,   3,   4,  24,  13,   0,  /* "contran" 87454 */
     12,   1,  13,   3,   4,  24,   6,  33,   1,  13,   0,  /* "contraption" 87465 */
     12,   1,  13,   3,   4,  24,   6,  33,   1,  13,  30,   0,  /* "contraptions" 87477 */
     12,   1,  13,   3,   4,  21,   4,  26,   1,  13,  30,   0,  /* "contrarians" 87489 */
     12,   8,  13,   3,   4,  15,   4,  26,  13,   1,  14,   0,  /* "contrariness" 87501 */
     12,   8,  13,   3,   4,  21,   4,  26,   0,  /* "contrary" 87510 */
     12,   8,  13,   3,   4,  15,   4,  26,   0,  /* "contrary" 87519 */
     12,   8,  13,   3,   4,  34,  14,   3,   0,  /* "contrast" 87528 */
     12,   1,  13,   3,   4,  24,  14,   3,   0,  /* "contrast" 87537 */
     12,   1,  13,   3,   4,  24,  14,   3,   1,  20,   0,  /* "contrasted" 87548 */
     12,   1,  13,   3,   4,  24,  14,   3,  31,  32,   0,  /* "contrasting" 87559 */
     12,   8,  13,   3,   4,  34,  14,   3,  14,   0,  /* "contrasts" 87569 */
     12,   1,  13,   3,   4,  24,  14,   3,  14,   0,  /* "contrasts" 87579 */
     12,   8,  13,   3,   4,   1,  22,  21,  13,  42,   1,  13,   0,  /* "contravention" 87592 */
     12,  19,  13,   3,   4,  21,   4,  19,  30,   0,  /* "contreras" 87602 */
     12,   8,  13,   3,   4,   1,   3,  21,  17,   6,  14,   0,  /* "contretemps" 87614 */
     12,   1,  13,   3,   4,   5,   9,  41,  29,   3,   0,  /* "contribute" 87625 */
     12,   1,  13,   3,   4,   5,   9,  41,  29,   3,   1,  20,   0,  /* "contributed" 87638 */
     12,   1,  13,   3,   4,   5,   9,  41,  29,   3,  14,   0,  /* "contributes" 87650 */
     12,   1,  13,   3,   4,   5,   9,  41,  29,   3,  31,  32,   0,  /* "contributing" 87663 */
     12,   8,  13,   3,   4,   1,   9,  41,  29,  33,   1,  13,   0,  /* "contribution" 87676 */
     12,   8,  13,   3,   4,   1,   9,  41,  29,  33,   1,  13,  30,   0,  /* "contributions" 87690 */
     12,   1,  13,   3,   4,   5,   9,  41,   1,   3,  10,   0,  /* "contributor" 87702 */
     12,   1,  13,   3,   4,   5,   9,  41,   1,   3,  10,  30,   0,  /* "contributors" 87715 */
     12,   1,  13,   3,   4,   5,   9,  41,   1,   3,  18,   4,  26,   0,  /* "contributory" 87729 */
     12,   1,  13,   3,   4,  39,   3,   0,  /* "contrite" 87737 */
     12,   1,  13,   3,   4,   5,  33,   1,  13,   0,  /* "contrition" 87747 */
     12,   1,  13,   3,   4,  39,  22,   1,  13,  14,   0,  /* "contrivance" 87758 */
     12,   1,  13,   3,   4,  39,  22,   1,  13,  14,   1,  30,   0,  /* "contrivances" 87771 */
     12,   1,  13,   3,   4,  39,  22,   0,  /* "contrive" 87779 */
     12,   1,  13,   3,   4,  39,  22,  20,   0,  /* "contrived" 87788 */
     12,   1,  13,   3,   4,  25,   7,   0,  /* "control" 87796 */
     12,   1,  13,   3,   4,  25,   7,   1,  20,  18,   4,   1,   0,  /* "controladora" 87809 */
     12,   1,  13,   3,   4,  25,   7,   1,   9,   1,   7,   0,  /* "controllable" 87821 */
     12,   1,  13,   3,   4,  25,   7,  20,   0,  /* "controlled" 87830 */
     12,   1,  13,   3,   4,  25,   7,  10,   0,  /* "controller" 87839 */
     12,   1,  13,   3,   4,  25,   7,  10,  30,   0,  /* "controllers" 87849 */
     12,   1,  13,   3,   4,  25,   7,  31,  32,   0,  /* "controlling" 87859 */
     12,   1,  13,   3,   4,  25,   7,  30,   0,  /* "controls" 87868 */
     12,   8,  13,   3,   4,   1,  22,  44,  33,   1,   7,   0,  /* "controversial" 87880 */
     12,   8,  13,   3,   4,   1,  22,  44,  14,  26,  30,   0,  /* "controversies" 87892 */
     12,   8,  13,   3,   4,   1,  22,  44,  14,  26,   0,  /* "controversy" 87903 */
     12,   8,  13,   3,  45,   4,   1,   0,  /* "contura" 87911 */
     12,   1,  13,   3,  29,  43,   1,  13,   0,  /* "contusion" 87920 */
     12,   1,  13,   3,  29,  43,   1,  13,  30,   0,  /* "contusions" 87930 */
     12,  25,  13,   1,  14,   0,  /* "conus" 87936 */
     12,   8,  13,  22,   1,   7,  21,  14,   0,  /* "convalesce" 87945 */
     12,   8,  13,  22,   1,   7,  21,  14,   1,  13,  14,   0,  /* "convalescence" 87957 */
     12,   8,  13,  22,   1,   7,  21,  14,   1,  13,   3,   0,  /* "convalescent" 87969 */
     12,   1,  13,  22,  23,  13,  20,   0,  /* "convened" 87977 */
     12,   1,  13,  22,  23,  13,  30,   0,  /* "convenes" 87985 */
     12,   1,  13,  22,  23,  13,  31,  32,   0,  /* "convening" 87994 */
     12,   8,  13,  22,   1,  13,   3,   0,  /* "convent" 88002 */
     12,   1,  13,  22,  44,  40,  31,  32,   0,  /* "converging" 88011 */
     12,   1,  13,  22,  44,  14,   1,  13,   3,   0,  /* "conversant" 88021 */
     12,   8,  13,  22,  10,  14,   2,  33,   1,  13,   0,  /* "conversation" 88032 */
     12,   8,  13,  22,  10,  14,   2,  33,   1,  13,   1,   7,   0,  /* "conversational" 88045 */
     12,   8,  13,  22,  10,  14,   2,  33,   1,  13,   1,   7,   1,  14,   3,   0,  /* "conversationalist" 88061 */
     12,   8,  13,  22,  10,  14,   2,  33,   1,  13,  30,   0,  /* "conversations" 88073 */
     12,   8,  13,  22,  10,  14,   0,  /* "converse" 88080 */
     12,   1,  13,  22,  44,  14,   0,  /* "converse" 88087 */
     12,   1,  13,  22,  44,  14,   3,   0,  /* "conversed" 88095 */
     12,   8,  13,  22,  10,  14,   7,  26,   0,  /* "conversely" 88104 */
     12,   8,  13,  22,  10,  14,   1,  30,   0,  /* "converses" 88113 */
     12,   8,  13,  22,  10,   3,   0,  /* "convert" 88120 */
     12,   8,  13,  22,  10,   3,   0,  /* "convert" 88127 */
     12,   1,  13,  22,  44,   3,   0,  /* "convert" 88134 */
     12,   8,  13,  22,  10,   3,   1,   9,   5,   7,   1,   3,  26,   0,  /* "convertibility" 88148 */
     12,   1,  13,  22,  44,   3,   1,   9,   1,   7,   0,  /* "convertible" 88159 */
     12,   1,  13,  22,  44,   3,   1,   9,   1,   7,  30,   0,  /* "convertibles" 88171 */
     12,   8,  13,  22,  10,   3,  14,   0,  /* "converts" 88179 */
     12,   1,  13,  22,  44,   3,  14,   0,  /* "converts" 88187 */
     12,   8,  13,  22,  10,  26,   0,  /* "convery" 88194 */
     12,   1,  13,  22,  21,  12,  14,   0,  /* "convex" 88202 */
     12,   1,  13,  22,   2,   0,  /* "convey" 88208 */
     12,   1,  13,  22,   2,   1,  13,  14,   0,  /* "conveyance" 88217 */
     12,   1,  13,  22,   2,  20,   0,  /* "conveyed" 88224 */
     12,   1,  13,  22,   2,  31,  32,   0,  /* "conveying" 88232 */
     12,   1,  13,  22,   2,  10,   0,  /* "conveyor" 88239 */
     12,   1,  13,  22,   2,  30,   0,  /* "conveys" 88246 */
     12,   8,  13,  22,  31,  12,   3,   0,  /* "convict" 88254 */
     12,   1,  13,  22,   5,  12,   3,   0,  /* "convict" 88262 */
     12,   8,  13,  22,  31,  12,   3,  14,   0,  /* "convicts" 88271 */
     12,   1,  13,  22,   5,  12,   3,  14,   0,  /* "convicts" 88280 */
     12,   8,  13,  22,   5,   7,   0,  /* "conville" 88287 */
     12,   8,  13,  22,   1,   7,  29,   3,   0,  /* "convolute" 88296 */
     12,   8,  13,  22,   1,   7,  29,   3,   1,  20,   0,  /* "convoluted" 88307 */
     12,   8,  13,  22,   1,   7,  29,  33,   1,  13,   0,  /* "convolution" 88318 */
     12,   8,  13,  22,  49,   0,  /* "convoy" 88324 */
     12,   8,  13,  47,   2,   0,  /* "conway" 88330 */
     12,  29,   0,  /* "coo" 88333 */
     12,  29,  42,  26,   0,  /* "coochie" 88338 */
     12,  29,  20,  26,   0,  /* "coody" 88343 */
     12,  29,  11,   1,  13,   0,  /* "coogan" 88349 */
     12,  29,  11,   1,   7,   0,  /* "coogle" 88355 */
     12,  29,  11,   1,   7,  10,   0,  /* "coogler" 88362 */
     12,  29,  31,  32,   0,  /* "cooing" 88367 */
     12,  45,  12,   0,  /* "cook" 88371 */
     12,  45,  12,   5,  32,  38,  34,  17,   0,  /* "cookingham" 88380 */
     12,  29,   7,   0,  /* "cool" 88384 */
     12,  29,   7,   1,  13,   3,   0,  /* "coolant" 88391 */
     12,  29,   7,   1,  13,   3,  14,   0,  /* "coolants" 88399 */
     12,  29,   7,   9,  18,   0,  /* "coolbaugh" 88405 */
     12,  29,   7,   0,  /* "coole" 88409 */
     12,  29,   7,  20,   0,  /* "cooled" 88414 */
     12,  29,   7,  10,   0,  /* "cooler" 88419 */
     12,  29,   7,  10,  30,   0,  /* "coolers" 88425 */
     12,  29,   7,   1,  14,   3,   0,  /* "coolest" 88432 */
     12,  29,   7,  26,   0,  /* "cooley" 88437 */
     12,  29,   7,  31,  40,   0,  /* "coolidge" 88443 */
     12,  29,   7,  31,  32,   0,  /* "cooling" 88449 */
     12,  29,   7,  23,  27,   0,  /* "coolio" 88455 */
     12,  29,   7,  26,   0,  /* "coolly" 88460 */
     12,  29,   7,  17,   1,  13,   0,  /* "coolman" 88467 */
     12,  29,   7,  13,   1,  14,   0,  /* "coolness" 88474 */
     12,  29,   7,  30,   0,  /* "cools" 88479 */
     12,  29,  17,   9,   0,  /* "coombe" 88484 */
     12,  29,  17,   9,  30,   0,  /* "coombes" 88490 */
     12,  29,  17,  30,   0,  /* "coombs" 88495 */
     12,  29,  17,  10,   0,  /* "coomer" 88500 */
     12,  29,  17,  30,   0,  /* "coomes" 88505 */
     12,  29,  13,   0,  /* "coon" 88509 */
     12,  29,  13,   1,  13,   0,  /* "coonan" 88515 */
     12,  29,  13,  14,   0,  /* "coonce" 88520 */
     12,  29,  13,   0,  /* "coone" 88524 */
     12,  29,  13,  10,   0,  /* "cooner" 88529 */
     12,  29,  13,  30,   0,  /* "coones" 88534 */
     12,  29,  13,  26,   0,  /* "cooney" 88539 */
     12,  29,  13,   4,  34,   3,   0,  /* "coonradt" 88546 */
     12,  29,  13,   4,   8,  20,   0,  /* "coonrod" 88553 */
     12,  29,  13,  30,   0,  /* "coons" 88558 */
     12,  29,  13,   3,  14,   0,  /* "coontz" 88564 */
     12,  29,   6,   0,  /* "coop" 88568 */
     12,  29,   6,   3,   0,  /* "cooped" 88573 */
     12,  29,   6,  10,   0,  /* "cooper" 88578 */
     12,  29,   6,  10,   1,  40,   0,  /* "cooperage" 88585 */
     12,  27,   8,   6,  10,   2,   3,   0,  /* "cooperate" 88593 */
     12,  27,   8,   6,  10,   2,   3,   1,  20,   0,  /* "cooperated" 88603 */
     12,  27,   8,   6,  10,   2,   3,  14,   0,  /* "cooperates" 88612 */
     12,  27,   8,   6,  10,   2,   3,  31,  32,   0,  /* "cooperating" 88622 */
     12,  27,   8,   6,  10,   2,  33,   1,  13,   0,  /* "cooperation" 88632 */
     12,  27,   8,   6,  10,   2,  33,   1,  13,  30,   0,  /* "cooperations" 88643 */
     12,  27,   8,   6,  10,   2,   3,  31,  22,   0,  /* "cooperative" 88653 */
     12,  27,   8,   6,   4,   1,   3,  31,  22,   7,  26,   0,  /* "cooperatively" 88665 */
     12,  27,   8,   6,   4,   1,   3,  31,  22,  30,   0,  /* "cooperatives" 88676 */
     12,  29,   6,  10,  39,  20,  10,   0,  /* "cooperider" 88684 */
     12,  29,   6,  10,  17,  24,  13,   0,  /* "cooperman" 88692 */
     12,  29,   6,  10,  39,  20,  10,   0,  /* "cooperrider" 88700 */
     12,  29,   6,  10,  30,   0,  /* "coopers" 88706 */
     12,  29,   6,  10,  14,  17,   5,  16,   0,  /* "coopersmith" 88715 */
     12,  29,   6,  10,  14,   3,  39,  13,   0,  /* "cooperstein" 88724 */
     12,  29,   6,  10,  30,   3,  48,  13,   0,  /* "cooperstown" 88733 */
     12,  29,   6,  10,  22,   5,  43,   1,  13,   0,  /* "coopervision" 88743 */
     12,  29,   6,  17,   1,  13,   0,  /* "coopman" 88750 */
     12,  29,   6,   4,  39,  20,  10,   0,  /* "cooprider" 88758 */
     12,  27,  18,   4,  20,  31,  13,   1,   3,   0,  /* "coordinate" 88768 */
     12,  27,  18,   4,  20,  31,  13,   2,   3,   0,  /* "coordinate" 88778 */
     12,  27,  18,   4,  20,   1,  13,  28,   3,   1,  20,   0,  /* "coordinated" 88790 */
     12,  27,  18,   4,  20,   1,  13,   1,   3,  14,   0,  /* "coordinates" 88801 */
     12,  27,  18,   4,  20,   1,  13,   2,   3,  14,   0,  /* "coordinates" 88812 */
     12,  29,   4,  30,   0,  /* "coors" 88817 */
     12,  29,  14,   0,  /* "coos" 88821 */
     12,  29,  14,   1,   0,  /* "coosa" 88826 */
     12,  29,   3,   0,  /* "coot" 88830 */
     12,  29,   3,   0,  /* "coote" 88834 */
     12,  29,   3,  10,   0,  /* "cooter" 88839 */
     12,  29,   3,  14,   0,  /* "coots" 88844 */
     12,  29,  22,  10,   0,  /* "coover" 88849 */
     12,  29,  22,  31,  12,   0,  /* "coovick" 88855 */
     12,   8,   6,   0,  /* "cop" 88859 */
     12,  25,   6,   1,   0,  /* "copa" 88864 */
     12,  25,   6,   1,  12,   1,   9,  24,  13,   1,   0,  /* "copacabana" 88875 */
     12,  25,   6,   0,  /* "cope" 88879 */
     12,   8,   6,   1,   7,  34,  13,   0,  /* "copelan" 88887 */
     12,   8,   6,   1,   7,   5,  13,   0,  /* "copelin" 88895 */
     12,  25,   6,   1,  13,  38,   2,  11,   1,  13,   0,  /* "copenhagen" 88906 */
     12,   1,   6,  21,  13,  38,   1,  22,  10,   0,  /* "copenhaver" 88916 */
     12,   1,   6,  44,  13,   1,  12,   1,  13,   0,  /* "copernican" 88926 */
     12,   1,   6,  44,  13,   1,  12,   1,  14,   0,  /* "copernicus" 88936 */
     12,   1,   6,   2,   3,   1,  14,   0,  /* "copetas" 88944 */
     12,   8,  37,  10,   0,  /* "copher" 88949 */
     12,  25,   6,  26,  34,  11,   0,  /* "copiague" 88956 */
     12,   8,   6,  26,  20,   0,  /* "copied" 88962 */
     12,   8,   6,  26,  10,   0,  /* "copier" 88968 */
     12,   8,   6,  26,  10,  30,   0,  /* "copiers" 88975 */
     12,   8,   6,  26,  30,   0,  /* "copies" 88981 */
     12,  25,   6,  39,   7,   1,   3,   0,  /* "copilot" 88989 */
     12,   8,   6,   1,   7,   1,  13,   0,  /* "coplen" 88997 */
     12,  27,   6,  25,   7,   1,   0,  /* "copolla" 89004 */
     12,   8,   6,   0,  /* "copp" 89008 */
     12,  25,   6,   1,   0,  /* "coppa" 89013 */
     12,   8,   6,  31,  40,   0,  /* "coppage" 89019 */
     12,   1,   6,  44,  13,  27,   7,   0,  /* "coppernoll" 89027 */
     12,   8,   6,  10,  14,  17,   5,  16,   0,  /* "coppersmith" 89036 */
     12,   8,   6,  10,  47,  21,   7,  20,   0,  /* "copperweld" 89045 */
     12,   8,   6,   1,  14,   0,  /* "coppess" 89051 */
     12,   8,   6,   1,   7,   0,  /* "copple" 89057 */
     12,  27,   6,  25,   7,   1,   0,  /* "coppola" 89064 */
     12,  27,   6,  27,   7,  23,  13,  27,   0,  /* "coppolino" 89073 */
     12,   8,   6,  14,   0,  /* "cops" 89078 */
     12,   8,   6,  41,   1,   7,   2,   3,   0,  /* "copulate" 89087 */
     12,   8,   6,  26,   0,  /* "copy" 89092 */
     12,   8,   6,  26,   4,  39,   3,   0,  /* "copyright" 89100 */
     12,   8,   6,  26,   4,  39,   3,   1,   9,   1,   7,   0,  /* "copyrightable" 89112 */
     12,   8,   6,  26,   4,  39,   3,   1,  20,   0,  /* "copyrighted" 89122 */
     12,   8,   6,  26,   4,  39,   3,  14,   0,  /* "copyrights" 89131 */
     12,   8,   6,  26,   3,  21,   7,   1,   0,  /* "copytele" 89140 */
     12,   8,   6,  26,   4,  39,   3,   0,  /* "copywrite" 89148 */
     12,   8,   6,  26,   4,  39,   3,   1,  20,   0,  /* "copywrited" 89158 */
     12,   8,   6,  26,   4,  39,   3,  10,   0,  /* "copywriter" 89167 */
     12,   8,   6,  26,   4,  39,   3,  10,  30,   0,  /* "copywriters" 89177 */
     12,  18,   4,   0,  /* "cor" 89181 */
     12,  18,   4,   1,   0,  /* "cora" 89186 */
     12,  18,   4,   1,  12,   1,   7,   0,  /* "coracle" 89194 */
     12,  18,   4,   1,   7,  39,  13,   0,  /* "coraline" 89202 */
     12,  18,   4,  24,  16,   0,  /* "corath" 89208 */
     12,  18,   4,   1,  30,  25,  13,   0,  /* "corazon" 89216 */
     12,  18,   4,   9,  15,   7,   0,  /* "corbell" 89223 */
     12,  10,   9,  21,   7,  27,   0,  /* "corbello" 89230 */
     12,  18,   4,   9,   4,  31,  40,   0,  /* "corbridge" 89238 */
     12,  18,   4,   9,  41,  29,  14,  41,  10,   0,  /* "corbusier" 89248 */
     12,  18,   4,  20,   0,  /* "cord" 89253 */
     12,  10,  20,   8,   4,  27,   0,  /* "cordaro" 89260 */
     12,  10,  20,   8,  14,  12,  27,   0,  /* "cordasco" 89268 */
     12,  10,  20,  21,   4,  27,   0,  /* "cordeiro" 89275 */
     12,  10,  20,  21,   4,  27,   0,  /* "cordero" 89282 */
     12,  18,   4,  40,   1,   7,   0,  /* "cordial" 89289 */
     12,  18,   4,  40,   1,   7,  26,   0,  /* "cordially" 89297 */
     12,  18,   4,  20,   1,   7,   0,  /* "cordill" 89304 */
     12,  18,   4,  20,   1,   7,   0,  /* "cordle" 89311 */
     12,  18,   4,  20,   1,  13,   0,  /* "cordone" 89318 */
     12,  18,   4,  20,   4,   2,   0,  /* "cordray" 89325 */
     12,  18,   4,  20,  10,  26,   0,  /* "cordry" 89332 */
     12,  18,   4,  20,   3,  14,   0,  /* "cordts" 89339 */
     12,  18,   4,   0,  /* "core" 89343 */
     12,  36,   4,  23,   1,   0,  /* "corea" 89349 */
     12,  18,   4,  21,   7,   0,  /* "corel" 89355 */
     12,  18,   4,  21,   7,   0,  /* "corell" 89361 */
     12,  10,  21,   7,   1,   0,  /* "corella" 89367 */
     12,  18,   4,   1,  14,   6,   8,  13,  20,   1,  13,   3,   0,  /* "corespondent" 89380 */
     12,  36,   4,  21,   3,   1,   0,  /* "coretta" 89387 */
     12,  36,   4,  21,  12,  14,   5,   3,  14,   0,  /* "corexit" 89397 */
     12,  18,   4,  11,  26,   0,  /* "corgi" 89403 */
     12,  18,   4,  26,   7,   0,  /* "coriell" 89409 */
     12,  10,  26,  11,   7,  26,   8,  13,  27,   0,  /* "corigliano" 89419 */
     12,  18,   4,   1,  13,   0,  /* "corinn" 89425 */
     12,  10,  23,  13,   0,  /* "corinne" 89430 */
     12,  18,   4,   1,  13,  16,   0,  /* "corinth" 89437 */
     12,  10,   5,  13,  16,  26,   1,  13,   0,  /* "corinthian" 89446 */
     12,  10,  23,  14,   1,   0,  /* "corisa" 89452 */
     12,  18,   4,   5,  14,   1,   0,  /* "corissa" 89459 */
     12,  18,   4,  12,   0,  /* "cork" 89464 */
     12,  18,   4,  12,  14,  12,   4,  29,   0,  /* "corkscrew" 89473 */
     12,  18,   4,   7,   0,  /* "corl" 89478 */
     12,  18,   4,   1,   7,   0,  /* "corle" 89484 */
     12,  18,   4,  17,  31,  12,   1,  13,   0,  /* "cormican" 89493 */
     12,  18,   4,  13,   0,  /* "corn" 89498 */
     12,  10,  13,   8,  12,  26,   1,   0,  /* "cornacchia" 89506 */
     12,  18,   4,  13,   9,   7,  29,  17,   0,  /* "cornblume" 89515 */
     12,  18,   4,  13,  12,   8,   9,   0,  /* "corncob" 89523 */
     12,  18,   4,  13,  26,   1,  30,   0,  /* "corneas" 89531 */
     12,  10,  13,   2,  41,  27,   0,  /* "cornejo" 89538 */
     12,  10,  13,  21,   7,   1,   0,  /* "cornela" 89545 */
     12,  36,   4,  13,  23,   7,  41,   1,   0,  /* "cornelia" 89554 */
     12,  10,  13,  21,   7,  26,  27,   0,  /* "cornelio" 89562 */
     12,  18,   4,  13,  15,   7,  26,   1,  14,   0,  /* "cornelious" 89572 */
     12,  10,  13,  21,   7,   1,  14,   1,  13,   0,  /* "cornelison" 89582 */
     12,  36,   4,  13,  23,   7,  41,   1,  14,   0,  /* "cornelius" 89592 */
     12,  18,   4,  13,   1,   7,  41,  29,  14,   1,  13,   0,  /* "corneliuson" 89604 */
     12,  36,   4,  13,  21,   7,   0,  /* "cornell" 89611 */
     12,  10,  13,  21,   7,   0,  /* "cornelle" 89617 */
     12,  36,   4,  13,  21,   3,   0,  /* "cornet" 89624 */
     12,  10,  13,  21,   3,   0,  /* "cornette" 89630 */
     12,  36,   4,  13,  21,   3,   1,  14,   3,   0,  /* "cornettist" 89640 */
     12,  18,   4,  13,  37,  21,   7,  20,   0,  /* "cornfeld" 89649 */
     12,  18,   4,  13,  37,  10,  16,   0,  /* "cornforth" 89657 */
     12,  18,   4,  13,  31,  33,   0,  /* "corniche" 89664 */
     12,  18,   4,  13,  23,   7,   0,  /* "corniel" 89671 */
     12,  18,   4,  13,  31,  33,   0,  /* "cornish" 89678 */
     12,  18,   4,  13,  14,   3,  18,  12,  14,   0,  /* "cornstalks" 89688 */
     12,  18,   4,  13,   1,  12,  25,   6,  26,   1,   0,  /* "cornucopia" 89699 */
     12,  18,   4,  13,  47,  36,   7,   0,  /* "cornwall" 89707 */
     12,  36,   4,  13,  47,  18,   7,   1,  14,   0,  /* "cornwallis" 89717 */
     12,  10,   8,   7,   1,   0,  /* "corolla" 89723 */
     12,  18,   4,   1,   7,  21,   4,  26,  30,   0,  /* "corollaries" 89733 */
     12,  18,   4,   1,   7,  21,   4,  26,   0,  /* "corollary" 89742 */
     12,  10,   4,   8,   7,   1,  40,   5,  14,   0,  /* "corologis" 89752 */
     12,  10,  25,  13,   1,   0,  /* "corona" 89758 */
     12,  10,  27,  13,   8,  20,  27,   0,  /* "coronado" 89766 */
     12,  36,   4,   1,  13,  21,   3,   0,  /* "coronet" 89774 */
     12,  36,   4,   1,  13,  21,   3,  14,   0,  /* "coronets" 89783 */
     12,  18,   4,   6,   0,  /* "corp" 89788 */
     12,  18,   4,   6,  10,   1,   0,  /* "corpora" 89795 */
     12,  18,   4,   6,  10,   8,  14,  26,  25,  13,   0,  /* "corporacion" 89806 */
     12,  18,   4,   6,  10,   1,   3,   0,  /* "corporate" 89814 */
     12,  18,   4,   6,  10,   1,   3,  14,   0,  /* "corporates" 89823 */
     12,  18,   4,   6,   4,   1,   3,  47,   8,  42,   0,  /* "corporatewatch" 89834 */
     12,  18,   4,   6,  10,   1,   3,  47,  39,  20,   0,  /* "corporatewide" 89845 */
     12,  18,   4,   6,  10,   1,   3,   5,  30,   1,  17,   0,  /* "corporatism" 89857 */
     12,  18,   4,   0,  /* "corps" 89861 */
     12,  18,   4,   6,  14,   0,  /* "corpse" 89867 */
     12,  18,   4,   6,  14,   1,  30,   0,  /* "corpses" 89875 */
     12,  18,   4,  17,   1,  13,   0,  /* "corpsman" 89882 */
     12,  18,   4,   6,  41,   1,   7,   1,  13,   3,   0,  /* "corpulant" 89893 */
     12,  18,   4,   0,  /* "corr" 89897 */
     12,  10,  19,  20,  23,  13,  27,   0,  /* "corradino" 89905 */
     12,  10,  24,   7,   0,  /* "corral" 89910 */
     12,  10,   8,   7,  15,  14,   0,  /* "corrales" 89917 */
     12,  10,  24,   7,  20,   0,  /* "corralled" 89923 */
     12,  18,   4,  52,   0,  /* "corrao" 89928 */
     12,  18,   4,  26,   1,   0,  /* "correa" 89934 */
     12,  18,   4,  26,   1,   7,   0,  /* "correale" 89941 */
     12,  10,  21,  12,   3,   0,  /* "correct" 89947 */
     12,  10,  21,  12,   3,   1,  20,   0,  /* "corrected" 89955 */
     12,  10,  21,  12,   3,  31,  32,   0,  /* "correcting" 89963 */
     12,  10,  21,  12,  33,   1,  13,   0,  /* "correction" 89971 */
     12,  10,  21,  12,  33,   1,  13,   1,   7,   0,  /* "correctional" 89981 */
     12,  10,  21,  12,  33,   1,  13,  30,   0,  /* "corrections" 89990 */
     12,  10,  21,  12,   3,  31,  22,   0,  /* "corrective" 89998 */
     12,  10,  21,  12,   3,   7,  26,   0,  /* "correctly" 90006 */
     12,  10,  21,  12,   3,  13,   1,  14,   0,  /* "correctness" 90015 */
     12,  10,  21,  12,   3,  14,   0,  /* "corrects" 90022 */
     12,  10,  21,  11,   1,  20,  36,   4,   0,  /* "corregidor" 90031 */
     12,  10,   2,  26,   1,   0,  /* "correia" 90037 */
     12,  10,  21,   4,   1,   0,  /* "correira" 90043 */
     12,  18,   4,   1,   7,   1,   3,  14,   0,  /* "correlates" 90052 */
     12,  18,   4,   1,   7,  28,   3,  31,  32,   0,  /* "correlating" 90062 */
     12,  10,   2,   7,   0,  /* "correll" 90067 */
     12,  18,   4,  26,  13,   0,  /* "correne" 90073 */
     12,  10,  21,  13,   3,  26,   0,  /* "corrente" 90080 */
     12,  10,  21,  13,   3,  26,   0,  /* "correnti" 90087 */
     12,  18,   4,   1,  14,   6,   8,  13,  20,   1,  13,  14,   0,  /* "correspondence" 90100 */
     12,  18,   4,   5,   9,   0,  /* "corrib" 90106 */
     12,  18,   4,  41,  21,   4,   0,  /* "corriere" 90113 */
     12,  18,   4,   1,  38,  10,   0,  /* "corriher" 90120 */
     12,  10,  23,  13,   1,   0,  /* "corrina" 90126 */
     12,  18,   4,  31,  22,  27,   0,  /* "corriveau" 90133 */
     12,  10,  18,   9,  10,   2,   3,  14,   0,  /* "corroborates" 90142 */
     12,  10,  18,   9,  10,   2,  33,   1,  13,   0,  /* "corroboration" 90152 */
     12,  10,   8,   9,  10,   1,   3,   5,  22,   0,  /* "corroborative" 90162 */
     12,  10,  25,  20,   1,  20,   0,  /* "corroded" 90169 */
     12,  10,  18,  13,   0,  /* "corron" 90174 */
     12,  36,   4,  29,  13,   0,  /* "corroon" 90180 */
     12,  18,   4,  27,   0,  /* "corrow" 90185 */
     12,  18,   4,   1,  11,   2,   3,   0,  /* "corrugate" 90193 */
     12,  18,   4,   1,  11,   2,   3,   1,  20,   0,  /* "corrugated" 90203 */
     12,  10,  35,   6,   3,   0,  /* "corrupt" 90209 */
     12,  18,  14,   1,   0,  /* "corsa" 90214 */
     12,  36,   4,  14,   8,  43,   0,  /* "corsage" 90221 */
     12,  18,   4,  14,  15,   4,   0,  /* "corsair" 90228 */
     12,  10,  14,   8,   4,  27,   0,  /* "corsaro" 90235 */
     12,  18,   4,  14,   0,  /* "corse" 90240 */
     12,  10,  14,  21,   7,  27,   0,  /* "corsello" 90247 */
     12,  10,  14,  15,  13,   3,  23,  13,  27,   0,  /* "corsentino" 90257 */
     12,  18,   4,  14,  10,   0,  /* "corser" 90263 */
     12,  18,   4,  14,   1,   3,   0,  /* "corset" 90270 */
     12,  10,  14,  21,   3,  26,   0,  /* "corsetti" 90277 */
     12,  18,   4,  14,  31,  12,   1,  30,   0,  /* "corsicas" 90286 */
     12,  10,  14,  23,  11,   7,  26,   1,   0,  /* "corsiglia" 90295 */
     12,  10,  14,  23,  13,  26,   0,  /* "corsini" 90302 */
     12,  18,   4,   3,   0,  /* "cort" 90307 */
     12,  18,   4,   3,  15,   7,  41,  29,   0,  /* "cortelyou" 90316 */
     12,  18,   4,   3,  15,  13,  30,   0,  /* "cortens" 90324 */
     12,  10,   3,   2,  30,  26,   0,  /* "cortese" 90331 */
     12,  10,   3,  21,  14,  26,   0,  /* "cortesi" 90338 */
     12,  18,   4,   3,  15,  12,  14,   0,  /* "cortex" 90346 */
     12,  36,   4,   3,  21,  30,   0,  /* "cortez" 90353 */
     12,  18,   4,   3,   1,  12,   1,   7,   0,  /* "cortical" 90362 */
     12,  18,   4,   3,  31,  12,  27,  14,   3,  21,   4,  49,  20,   0,  /* "corticosteroid" 90376 */
     12,  18,   4,   3,  31,  12,  27,  14,   3,  21,   4,  49,  20,  30,   0,  /* "corticosteroids" 90391 */
     12,  18,   4,   3,   5,  13,   0,  /* "cortin" 90398 */
     12,  10,   3,  23,  13,   1,   0,  /* "cortina" 90405 */
     12,  18,   4,   3,  26,  13,   1,  30,   0,  /* "cortinas" 90414 */
     12,  36,   4,   3,  23,  13,   0,  /* "cortine" 90421 */
     12,  36,   4,   3,  23,  13,  30,   0,  /* "cortines" 90429 */
     12,  18,   4,   3,   1,  30,  25,  13,   0,  /* "cortisone" 90438 */
     12,  10,   3,  27,   6,   8,  14,  26,   0,  /* "cortopassi" 90447 */
     12,  18,   4,   3,   4,  39,   3,   0,  /* "cortright" 90455 */
     12,  10,  35,  13,  20,   1,  17,   0,  /* "corundum" 90463 */
     12,  36,   4,  22,  21,   3,   0,  /* "corvette" 90470 */
     12,  10,  22,  23,  13,  27,   0,  /* "corvino" 90477 */
     12,  18,   4,  26,   0,  /* "cory" 90482 */
     12,  10,  30,  23,  13,  26,   0,  /* "corzine" 90489 */
     12,  18,  14,   0,  /* "cos" 90493 */
     12,  25,  14,   1,   0,  /* "cosa" 90498 */
     12,   1,  14,   8,   3,  29,   0,  /* "cosatu" 90505 */
     12,  18,  30,   9,  26,   0,  /* "cosby" 90511 */
     12,  25,  14,  42,   1,   0,  /* "coscia" 90517 */
     12,  25,  30,   0,  /* "cose" 90521 */
     12,  27,  14,  21,   7,   0,  /* "cosell" 90527 */
     12,  25,  30,  10,  24,   3,  14,   0,  /* "coseratz" 90535 */
     12,   8,  14,  11,   4,   1,  22,   0,  /* "cosgrove" 90543 */
     12,  25,  14,  26,   0,  /* "cosi" 90548 */
     12,  25,  14,  31,  12,   0,  /* "cosic" 90554 */
     12,  27,  14,  23,  17,   1,   0,  /* "cosima" 90561 */
     12,  25,  30,  17,   1,   0,  /* "cosma" 90567 */
     12,   8,  14,  17,   1,  13,   0,  /* "cosman" 90574 */
     12,  25,  30,  17,   0,  /* "cosme" 90579 */
     12,  18,  30,  17,  21,   3,  31,  12,   7,  26,   0,  /* "cosmetically" 90590 */
     12,   8,  30,  17,   1,   3,   8,   7,   1,  40,  26,   0,  /* "cosmetology" 90602 */
     12,   8,  30,  17,  31,  12,   0,  /* "cosmic" 90609 */
     12,  36,  30,  17,  18,   7,   1,  40,  26,   0,  /* "cosmology" 90619 */
     12,  18,  30,  17,   1,  13,  18,   3,   0,  /* "cosmonaut" 90628 */
     12,  18,  30,  17,   1,  13,  18,   3,  14,   0,  /* "cosmonauts" 90638 */
     12,   8,  30,  17,   1,   6,   8,   7,   1,   3,   1,  13,   0,  /* "cosmopolitan" 90651 */
     12,  18,  30,  17,   1,   6,  41,  29,   7,  27,  14,   0,  /* "cosmopulos" 90663 */
     12,   8,  30,  17,  27,  14,   0,  /* "cosmos" 90670 */
     12,  25,  14,   6,  18,  13,  14,  10,   0,  /* "cosponsor" 90679 */
     12,  25,  14,   6,  18,  13,  14,  10,  30,   0,  /* "cosponsors" 90689 */
     12,  18,  14,   0,  /* "coss" 90693 */
     12,  18,  14,   1,   0,  /* "cossa" 90698 */
     12,  18,  14,   1,  12,   0,  /* "cossack" 90704 */
     12,   8,  14,  34,  12,  14,   0,  /* "cossacks" 90711 */
     12,   8,  14,  10,   3,   0,  /* "cossairt" 90717 */
     12,   1,  14,  21,   3,   0,  /* "cossette" 90723 */
     12,   8,  14,   5,  13,   0,  /* "cossin" 90729 */
     12,  18,  14,  17,   1,  13,   0,  /* "cossman" 90736 */
     12,   8,  14,   3,   0,  /* "cost" 90741 */
     12,  18,  14,   3,   1,   9,  39,   7,   0,  /* "costabile" 90750 */
     12,  25,  14,   3,   2,  13,   0,  /* "costain" 90757 */
     12,   8,  14,   3,   1,   7,  30,   0,  /* "costales" 90765 */
     12,  27,  14,   3,   8,  13,  27,   0,  /* "costano" 90773 */
     12,  27,  14,   3,  19,  13,   3,  23,  13,  26,   0,  /* "costantini" 90784 */
     12,  27,  14,   3,  19,  13,   3,  23,  13,  27,   0,  /* "costantino" 90795 */
     12,  27,  14,   3,   8,  13,  30,   1,   0,  /* "costanza" 90804 */
     12,  27,  14,   3,   8,  13,  30,  27,   0,  /* "costanzo" 90813 */
     12,  25,  14,   3,  19,   4,   0,  /* "costar" 90820 */
     12,  25,  14,   3,  19,   4,  30,   0,  /* "costars" 90828 */
     12,  18,  14,   3,  12,  27,   0,  /* "costco" 90835 */
     12,  18,  14,   3,  12,  35,   3,  31,  32,   0,  /* "costcutting" 90845 */
     12,  25,  14,   3,   0,  /* "coste" 90850 */
     12,   8,  14,   3,   1,  20,   0,  /* "costed" 90857 */
     12,  25,  14,   3,  26,  21,   4,   1,   0,  /* "costeira" 90866 */
     12,   8,  14,   3,  31,  11,  34,  13,   0,  /* "costigan" 90875 */
     12,  27,  14,   3,   5,   7,   1,   0,  /* "costilla" 90883 */
     12,   8,  14,   3,   1,   7,  27,   0,  /* "costilow" 90891 */
     12,  18,  14,   3,  31,  32,   0,  /* "costing" 90898 */
     12,   8,  14,   3,   7,  26,   0,  /* "costley" 90905 */
     12,  18,  14,   3,   7,  26,   5,  14,   3,   0,  /* "costliest" 90915 */
     12,  18,  14,   3,   7,  25,   0,  /* "costlow" 90922 */
     12,   8,  14,   3,   7,  26,   0,  /* "costly" 90929 */
     12,  19,  14,   3,  29,  17,   0,  /* "costume" 90936 */
     12,  18,  14,   3,  29,  17,  20,   0,  /* "costumed" 90944 */
     12,   8,  14,   3,  29,  17,  10,   0,  /* "costumer" 90952 */
     12,   8,  14,   3,  29,  17,  10,  30,   0,  /* "costumers" 90961 */
     12,  19,  14,   3,  29,  17,  30,   0,  /* "costumes" 90969 */
     12,   1,  14,  44,   3,   1,   0,  /* "cosurtuh" 90976 */
     12,  25,  30,  26,   0,  /* "cosy" 90981 */
     12,   8,   3,   0,  /* "cot" 90985 */
     12,  25,   3,   1,   0,  /* "cota" 90990 */
     12,  25,   3,   0,  /* "cote" 90994 */
     12,  25,   3,  21,   7,   0,  /* "cotelle" 91000 */
     12,   8,  16,  10,   1,  13,   0,  /* "cothren" 91007 */
     12,  27,   3,  23,  40,   1,   0,  /* "cotija" 91014 */
     12,   1,   3,   5,   7,   1,   0,  /* "cotilla" 91021 */
     12,  25,   3,   1,   7,  10,   0,  /* "cotler" 91028 */
     12,   1,   3,  13,  47,   8,   4,   0,  /* "cotnoir" 91036 */
     12,  25,   3,  27,   0,  /* "coto" 91041 */
     12,   8,   3,   4,   1,   3,   0,  /* "cotret" 91048 */
     12,  27,   3,   4,  25,  13,  26,   0,  /* "cotrone" 91056 */
     12,  27,   3,   4,  25,  13,  26,  27,   0,  /* "cotroneo" 91065 */
     12,   8,   3,  14,   0,  /* "cots" 91070 */
     12,   8,   3,   0,  /* "cott" 91074 */
     12,   8,   3,  31,  40,   1,  30,   0,  /* "cottages" 91082 */
     12,  27,   3,  23,   0,  /* "cottee" 91087 */
     12,   8,   3,   1,   7,   0,  /* "cottle" 91093 */
     12,  25,   3,  27,   0,  /* "cotto" 91098 */
     12,   8,   3,   1,  13,   0,  /* "cotton" 91104 */
     12,  27,   3,  25,  13,  26,   0,  /* "cottone" 91111 */
     12,   1,   3,   8,  13,  40,   5,  13,   0,  /* "cottongin" 91120 */
     12,   8,   3,   1,  13,  17,  48,  16,   0,  /* "cottonmouth" 91129 */
     12,   8,   3,   1,  13,  14,  23,  20,   0,  /* "cottonseed" 91138 */
     12,   8,   3,   4,  21,   7,   0,  /* "cottrell" 91145 */
     12,   8,   3,   4,   1,   7,   0,  /* "cottrill" 91152 */
     12,  27,   3,  29,  11,  13,  27,   0,  /* "cotugno" 91160 */
     12,  25,   3,  26,   0,  /* "coty" 91165 */
     12,  29,   0,  /* "cou" 91168 */
     12,  29,  33,  17,  24,  13,   0,  /* "couchman" 91175 */
     12,  48,  20,  10,  30,   6,  18,   4,   3,   0,  /* "coudersport" 91185 */
     12,  29,  20,  10,   3,   0,  /* "coudert" 91191 */
     12,  29,  23,   0,  /* "couey" 91195 */
     12,  29,  37,  24,   7,   0,  /* "coufal" 91201 */
     12,  29,  11,  10,   0,  /* "cougar" 91206 */
     12,  29,  11,  10,  30,   0,  /* "cougars" 91212 */
     12,   8,  37,   0,  /* "cough" 91216 */
     12,   8,  37,   3,   0,  /* "coughed" 91221 */
     12,  36,  37,  21,  13,  10,   0,  /* "coughenour" 91228 */
     12,   8,  37,  31,  32,   0,  /* "coughing" 91234 */
     12,  18,  11,   7,   1,  13,   0,  /* "coughlan" 91241 */
     12,  18,  11,   7,   5,  13,   0,  /* "coughlin" 91248 */
     12,  18,  11,   4,   1,  13,   0,  /* "coughran" 91255 */
     12,  18,  37,  14,   0,  /* "coughs" 91260 */
     12,  47,  26,   7,   8,   4,  20,   0,  /* "couillard" 91268 */
     12,  45,  20,   0,  /* "could" 91272 */
     12,  29,   7,  26,   0,  /* "coulee" 91277 */
     12,  52,   7,  25,  17,   9,  26,   0,  /* "coulombe" 91285 */
     12,  48,   7,  14,   3,   1,  13,   0,  /* "coulston" 91293 */
     12,  29,   7,   3,   8,  30,   0,  /* "coultas" 91300 */
     12,  29,   7,  16,   8,   4,  20,   0,  /* "coulthard" 91308 */
     12,  48,  13,  14,   1,   7,  17,   1,  13,   0,  /* "councilman" 91318 */
     12,  48,  13,  14,   1,   7,  17,  15,  13,   0,  /* "councilmen" 91328 */
     12,  48,  13,  14,   1,   7,  47,   5,  17,   1,  13,   0,  /* "councilwomen" 91340 */
     12,  48,  13,  14,   1,   7,  10,   0,  /* "counsellor" 91348 */
     12,  48,  13,  14,   1,   7,  10,  30,   0,  /* "counsellors" 91357 */
     12,  48,  13,   3,   1,   9,   1,   7,   0,  /* "countable" 91366 */
     12,  48,  13,   3,  10,   1,   3,  24,  12,   0,  /* "counterattack" 91376 */
     12,  48,  13,   3,  10,   1,   3,  24,  12,   3,   0,  /* "counterattacked" 91387 */
     12,  48,  13,   3,  10,   1,   3,  24,  12,  14,   0,  /* "counterattacks" 91398 */
     12,  48,   3,  10,  12,   7,  18,  12,  47,  39,  30,   0,  /* "counterclockwise" 91410 */
     12,  48,  13,   3,  10,  21,  14,   6,  26,   1,  13,  19,  40,   0,  /* "counterespionage" 91424 */
     12,  48,  13,   3,  10,  37,   5,   3,   0,  /* "counterfeit" 91433 */
     12,  48,  13,   3,  10,  37,   5,   3,   1,  20,   0,  /* "counterfeited" 91444 */
     12,  48,  13,   3,  10,  37,   5,   3,  10,   0,  /* "counterfeiter" 91454 */
     12,  48,  13,   3,  10,  37,   5,   3,  10,  30,   0,  /* "counterfeiters" 91465 */
     12,  48,  13,   3,  10,  37,   5,   3,  31,  32,   0,  /* "counterfeiting" 91476 */
     12,  48,  13,   3,  10,  37,   5,   3,  14,   0,  /* "counterfeits" 91486 */
     12,  48,  13,   3,  10,   5,  13,   3,  21,   7,  31,  40,   1,  13,  14,   0,  /* "counterintelligence" 91502 */
     12,  48,  13,   3,  10,   7,  39,  37,   0,  /* "counterlife" 91511 */
     12,  48,  13,   3,  10,  17,  24,  13,   0,  /* "counterman" 91520 */
     12,  48,  13,   3,  10,  17,  21,  43,  10,   0,  /* "countermeasure" 91530 */
     12,  48,  13,   3,  10,  17,  21,  43,  10,  30,   0,  /* "countermeasures" 91541 */
     12,  48,  13,   3,  10,  17,  29,  22,   0,  /* "countermove" 91550 */
     12,  48,  13,   3,  10,  17,  29,  22,  30,   0,  /* "countermoves" 91560 */
     12,  48,  13,   3,  10,  36,  37,  21,  13,  14,  31,  22,   0,  /* "counteroffensive" 91573 */
     12,  48,  13,   3,  10,   6,   4,   1,  20,  35,  12,   3,  31,  22,   0,  /* "counterproductive" 91588 */
     12,  48,  13,   3,  10,   6,   4,   1,   6,  25,  30,   1,   7,   0,  /* "counterproposal" 91602 */
     12,  48,  13,   3,  10,   6,   4,   1,   6,  25,  30,   1,   7,  30,   0,  /* "counterproposals" 91617 */
     12,  48,  13,   3,  10,   4,  26,  22,  25,   7,   3,   0,  /* "counterrevolt" 91629 */
     12,  48,  13,   3,  10,   4,  15,  22,   1,   7,  29,  33,   1,  13,   0,  /* "counterrevolution" 91644 */
     12,  48,  13,   3,  10,   4,  15,  22,   1,   7,  29,  33,   1,  13,  21,   4,  26,   0,  /* "counterrevolutionary" 91662 */
     12,  48,  13,   3,  10,  14,  29,  20,   0,  /* "countersued" 91671 */
     12,  48,  13,   3,  10,  14,  29,   3,   0,  /* "countersuit" 91680 */
     12,  48,  13,   3,  10,   3,  21,  13,  10,   0,  /* "countertenor" 91690 */
     12,  48,  13,   3,  10,   3,  21,   4,  10,   5,  30,   1,  17,   0,  /* "counterterrorism" 91704 */
     12,  48,  13,   3,  10,   3,  21,   4,  10,   5,  14,   3,   0,  /* "counterterrorist" 91717 */
     12,  48,  13,   3,   1,  14,   0,  /* "countess" 91724 */
     12,  35,  13,   3,   4,  26,  30,   0,  /* "countries" 91732 */
     12,  35,  13,   3,   4,  26,   0,  /* "country" 91739 */
     12,  35,  13,   3,   4,  26,  37,  25,  12,   0,  /* "countryfolk" 91749 */
     12,  35,  13,   3,   4,  26,  17,   1,  13,   0,  /* "countryman" 91759 */
     12,  35,  13,   3,   4,  26,  17,  15,  13,   0,  /* "countrymen" 91769 */
     12,  35,  13,   3,   4,  26,  14,  39,  20,   0,  /* "countryside" 91779 */
     12,  35,  13,   3,   4,  26,  47,  39,  20,   0,  /* "countrywide" 91789 */
     12,  29,   0,  /* "coup" 91792 */
     12,  29,   6,   0,  /* "coupe" 91796 */
     12,  29,  10,   0,  /* "couper" 91800 */
     12,  29,   6,  14,   0,  /* "coupes" 91805 */
     12,  29,   6,   7,   1,  13,  20,   0,  /* "coupland" 91813 */
     12,  35,   6,   1,   7,   0,  /* "couple" 91819 */
     12,  35,   6,   1,   7,  20,   0,  /* "coupled" 91826 */
     12,  35,   6,   7,  10,   0,  /* "coupler" 91832 */
     12,  35,   6,   1,   7,  30,   0,  /* "couples" 91839 */
     12,  35,   6,   7,  31,  32,   0,  /* "coupling" 91846 */
     12,  35,   6,   7,  31,  32,  30,   0,  /* "couplings" 91854 */
     12,  29,   6,  18,  13,   0,  /* "coupon" 91860 */
     12,  29,   6,  19,  13,  31,  32,   0,  /* "couponing" 91868 */
     12,  29,   6,  19,  13,  39,   3,   0,  /* "couponite" 91876 */
     12,  29,   6,  19,  13,  39,   3,  14,   0,  /* "couponites" 91885 */
     12,  29,   6,  18,  13,  30,   0,  /* "coupons" 91892 */
     12,  29,  30,   0,  /* "coups" 91896 */
     12,  44,   1,  40,   0,  /* "courage" 91901 */
     12,  10,   2,  40,   1,  14,   0,  /* "courageous" 91908 */
     12,  10,   2,  40,   1,  14,   7,  26,   0,  /* "courageously" 91917 */
     12,  45,   4,   1,  13,   3,   0,  /* "courant" 91924 */
     12,  51,   4,  33,   2,  13,   0,  /* "courchaine" 91931 */
     12,  51,   4,  33,  21,  13,   0,  /* "courchesne" 91938 */
     12,  18,   4,  31,  12,   0,  /* "couric" 91944 */
     12,  18,   4,  31,  32,   3,   1,  13,   0,  /* "courington" 91953 */
     12,  18,   4,  13,  50,  10,   0,  /* "cournoyer" 91960 */
     12,  18,   4,   3,  28,  20,   0,  /* "courtade" 91967 */
     12,  44,   3,  27,   0,  /* "courteau" 91972 */
     12,  18,   4,   3,   1,  20,   0,  /* "courted" 91979 */
     12,  18,   4,   3,  17,  24,  13,  33,   0,  /* "courtemanche" 91988 */
     12,  44,   3,   1,  13,  28,   0,  /* "courtenay" 91995 */
     12,  44,   3,  26,   1,  14,   0,  /* "courteous" 92002 */
     12,  18,   4,   3,  10,   0,  /* "courter" 92008 */
     12,  44,   3,   1,  14,  26,  30,   0,  /* "courtesies" 92016 */
     12,  44,   3,   1,  14,  26,   0,  /* "courtesy" 92023 */
     12,  18,   4,   3,  38,  48,  14,   0,  /* "courthouse" 92031 */
     12,  18,   4,   3,  38,  48,  14,   1,  30,   0,  /* "courthouses" 92041 */
     12,  18,   4,   3,  26,  10,  30,   0,  /* "courtiers" 92049 */
     12,  18,   4,   3,   7,  34,  13,  20,   0,  /* "courtland" 92058 */
     12,  18,   4,   3,  47,  19,   0,  /* "courtois" 92065 */
     12,  18,   4,   3,   4,  39,   3,   0,  /* "courtright" 92073 */
     12,  18,   4,   3,   4,  29,  17,   0,  /* "courtroom" 92081 */
     12,  18,   4,   3,   4,  29,  17,  30,   0,  /* "courtrooms" 92090 */
     12,  18,   4,   3,   4,  39,   3,   0,  /* "courtwright" 92098 */
     12,  51,   4,  22,   5,   7,   0,  /* "courville" 92105 */
     12,  29,  14,   8,   4,   0,  /* "cousar" 92111 */
     12,  29,  14,   1,  13,  30,   0,  /* "cousens" 92118 */
     12,  35,  30,   1,  13,   0,  /* "cousin" 92124 */
     12,  29,  14,   1,  13,  25,   0,  /* "cousineau" 92131 */
     12,  52,  14,  23,  13,  27,   0,  /* "cousino" 92138 */
     12,  35,  30,   1,  13,  30,   0,  /* "cousins" 92145 */
     12,  29,  14,   3,  25,   0,  /* "cousteau" 92151 */
     12,  29,  30,  26,   0,  /* "cousy" 92156 */
     12,  29,   3,  18,  13,   3,   0,  /* "coutant" 92163 */
     12,  29,   3,  23,   0,  /* "coutee" 92168 */
     12,  48,   3,  27,   0,  /* "couto" 92173 */
     12,  48,   3,  14,   0,  /* "coutts" 92178 */
     12,  29,  42,  29,   0,  /* "coutu" 92183 */
     12,  29,   3,  45,   4,   0,  /* "couture" 92189 */
     12,  29,   3,  45,   4,  26,  10,   0,  /* "couturier" 92197 */
     12,  29,  22,  26,   7,  41,  18,  13,   0,  /* "couvillion" 92206 */
     12,  29,  22,  26,   7,  18,  13,   0,  /* "couvillon" 92214 */
     12,  29,  30,   1,  13,  30,   0,  /* "couzens" 92221 */
     12,  27,  22,  28,  24,   7,   0,  /* "coval" 92228 */
     12,  25,  22,  19,   7,   3,   0,  /* "covalt" 92235 */
     12,  27,  22,  19,   4,  29,   9,  23,   1,  30,   0,  /* "covarrubias" 92246 */
     12,  25,  22,   1,  14,   0,  /* "covas" 92252 */
     12,  27,  22,   8,   3,   1,   0,  /* "covatta" 92259 */
     12,  25,  22,  18,   7,   3,   0,  /* "covault" 92266 */
     12,  25,  22,   0,  /* "cove" 92270 */
     12,   8,  22,   1,   7,   0,  /* "covell" 92276 */
     12,  35,  22,   1,  13,   1,  13,   3,  10,   0,  /* "covenanter" 92286 */
     12,  35,  22,   1,  13,   1,  13,   3,  10,  30,   0,  /* "covenanters" 92297 */
     12,   8,  22,   1,  13,  26,   0,  /* "coveney" 92304 */
     12,  35,  22,   1,  13,   3,   0,  /* "covent" 92311 */
     12,  35,  22,  10,   1,  40,   0,  /* "coverage" 92318 */
     12,  35,  22,  10,   2,  40,   1,  30,   0,  /* "coverages" 92327 */
     12,  25,  22,  10,   3,   0,  /* "covert" 92333 */
     12,  35,  22,  10,  35,   6,   0,  /* "coverup" 92340 */
     12,  35,  22,  10,  35,   6,  14,   0,  /* "coverups" 92348 */
     12,  35,  22,   1,   3,   0,  /* "covet" 92354 */
     12,  35,  22,   1,   3,   1,  20,   0,  /* "coveted" 92362 */
     12,  35,  22,   1,   3,  14,   0,  /* "covets" 92369 */
     12,  35,  22,  26,   0,  /* "covey" 92374 */
     12,   8,  22,   1,   7,   0,  /* "covill" 92380 */
     12,  25,  22,   5,  13,   0,  /* "covin" 92386 */
     12,  35,  22,  31,  32,   3,   1,  13,   0,  /* "covington" 92395 */
     12,  25,  22,   5,   3,  14,   0,  /* "covitz" 92402 */
     12,  35,  22,  26,   0,  /* "covy" 92407 */
     12,  48,   0,  /* "cow" 92410 */
     12,  48,  10,  20,   1,  14,   0,  /* "cowardice" 92417 */
     12,  48,  19,   4,   3,   0,  /* "cowart" 92423 */
     12,   1,  47,  23,  20,   1,   0,  /* "coweda" 92430 */
     12,  48,  11,   5,   7,   0,  /* "cowgill" 92436 */
     12,   8,  47,  10,   0,  /* "cowher" 92441 */
     12,  48,  38,  44,  20,   0,  /* "cowherd" 92447 */
     12,  48,   7,   0,  /* "cowl" 92451 */
     12,  48,   1,   7,  30,   0,  /* "cowles" 92457 */
     12,  25,  47,  44,  12,  10,   0,  /* "coworker" 92464 */
     12,  25,  47,  44,  12,  10,  30,   0,  /* "coworkers" 92472 */
     12,  48,  30,   0,  /* "cows" 92476 */
     12,  48,  14,  10,   3,   0,  /* "cowsert" 92482 */
     12,   8,  12,  14,   0,  /* "cox" 92487 */
     12,   8,  12,  14,   0,  /* "coxe" 92492 */
     12,   8,  12,  14,   1,  13,   0,  /* "coxen" 92499 */
     12,   8,  12,  14,   1,  13,   0,  /* "coxon" 92506 */
     12,   8,  12,  14,  47,  21,   7,   0,  /* "coxwell" 92514 */
     12,  49,   0,  /* "coy" 92517 */
     12,  49,   0,  /* "coye" 92520 */
     12,  50,  12,  21,  13,  20,   1,   7,   0,  /* "coykendall" 92529 */
     12,  49,  17,   0,  /* "coym" 92533 */
     12,  39,  25,   3,  26,   0,  /* "coyote" 92539 */
     12,  39,  25,   3,  26,  14,   0,  /* "coyotes" 92546 */
     12,   8,  30,   0,  /* "coz" 92550 */
     12,   8,  30,  19,   4,   3,   0,  /* "cozart" 92557 */
     12,  27,  30,  23,  13,  26,   0,  /* "cozine" 92564 */
     12,  25,  30,  17,   1,  13,   0,  /* "cozman" 92571 */
     12,  25,  30,  26,   0,  /* "cozy" 92576 */
     12,  25,   3,  14,   1,   0,  /* "cozza" 92582 */
     12,  25,   3,  14,  26,   0,  /* "cozzi" 92588 */
     12,  27,   3,  14,  27,   7,  23,  13,  27,   0,  /* "cozzolino" 92598 */
     14,  23,   6,  23,  21,  14,   0,  /* "cps" 92605 */
     12,   4,  24,   9,   0,  /* "crab" 92610 */
     12,   4,  24,   9,  23,   3,  10,   0,  /* "crabeater" 92618 */
     12,   4,   2,   9,   1,   7,   0,  /* "crable" 92625 */
     12,   4,  19,  12,  26,  25,   7,  27,   0,  /* "cracchiolo" 92634 */
     12,   4,  24,  12,   1,   7,   0,  /* "crackle" 92641 */
     12,   4,  24,  12,   1,   7,  20,   0,  /* "crackled" 92649 */
     12,   4,  24,  12,   1,   7,  30,   0,  /* "crackles" 92657 */
     12,   4,   8,  12,   4,  34,  37,   3,   0,  /* "cracraft" 92666 */
     12,   4,   2,  20,   1,   7,   0,  /* "cradle" 92673 */
     12,   4,   2,  20,   1,   7,  30,   0,  /* "cradles" 92681 */
     12,   4,   2,  20,   1,   7,  31,  32,   0,  /* "cradling" 92690 */
     12,   4,  24,  20,   1,  12,   0,  /* "cradock" 92697 */
     12,   4,  24,  37,   3,  14,  17,   1,  13,   0,  /* "craftsmen" 92707 */
     12,   4,  24,  37,   3,  14,   6,  23,   6,   1,   7,   0,  /* "craftspeople" 92719 */
     12,   4,  24,  11,  38,  21,  20,   0,  /* "craghead" 92727 */
     12,   4,  24,  40,   5,  13,   0,  /* "cragin" 92734 */
     12,   4,   2,  11,   1,   7,   0,  /* "cragle" 92741 */
     12,   4,  24,  11,   1,  13,   0,  /* "cragun" 92748 */
     12,   4,   2,  11,  38,  21,  20,   0,  /* "craighead" 92756 */
     12,   4,  24,  17,   0,  /* "cram" 92761 */
     12,   4,  24,  13,  37,   1,   7,   0,  /* "cranfill" 92769 */
     12,   4,  24,  13,   7,  26,   0,  /* "cranley" 92776 */
     12,   4,   8,  13,  17,  36,   4,   0,  /* "cranmore" 92784 */
     12,   4,   2,  13,  10,   0,  /* "cranor" 92790 */
     12,   4,  24,   6,   0,  /* "crap" 92795 */
     12,   4,  24,   6,  14,  10,   0,  /* "crapser" 92802 */
     12,   4,  24,   6,  33,  29,   3,   0,  /* "crapshoot" 92810 */
     12,  44,  15,   4,  26,   0,  /* "crary" 92816 */
     12,   4,  24,  33,  31,  32,   0,  /* "crashing" 92823 */
     12,   4,  24,  30,  13,  10,   0,  /* "crasner" 92830 */
     12,   4,  24,  22,   1,  16,   0,  /* "cravath" 92837 */
     12,   4,  18,   0,  /* "craw" 92841 */
     12,   4,  24,  12,  14,  26,   0,  /* "craxi" 92848 */
     12,   4,   2,   0,  /* "cray" 92852 */
     12,   4,   2,  37,  31,  33,   0,  /* "crayfish" 92859 */
     12,   4,   2,   8,  13,  30,   0,  /* "crayons" 92866 */
     12,   4,   2,  30,   1,   7,  26,   0,  /* "crazily" 92874 */
     12,   4,   2,  30,  26,  13,   1,  14,   0,  /* "craziness" 92883 */
     12,   4,  23,   0,  /* "crea" 92887 */
     12,   4,  23,  31,  40,  10,   0,  /* "creager" 92894 */
     12,   4,  23,  11,   0,  /* "creagh" 92899 */
     12,   4,  23,  12,  31,  32,   0,  /* "creaking" 92906 */
     12,   4,  23,  14,  26,   0,  /* "creasey" 92912 */
     12,   4,  23,  14,  26,   0,  /* "creasy" 92918 */
     12,   4,  21,  16,   0,  /* "creath" 92923 */
     12,   4,  26,   2,  33,   1,  13,   5,  30,   1,  17,   0,  /* "creationism" 92935 */
     12,   4,  23,  28,   3,   5,  22,   1,   3,  26,   0,  /* "creativity" 92946 */
     12,   4,  26,   2,   3,  18,   7,   1,  40,   1,  14,   3,   0,  /* "creatologist" 92959 */
     12,   4,  26,   2,   3,  18,   7,   1,  40,   1,  14,   3,  14,   0,  /* "creatologists" 92973 */
     12,   4,  23,  42,  10,   0,  /* "creature" 92979 */
     12,   4,  23,  42,  10,  30,   0,  /* "creatures" 92986 */
     12,   4,   1,  14,  23,   7,  26,   1,  14,   0,  /* "crecelius" 92996 */
     12,   4,   1,  20,  21,  13,  42,   1,   7,   0,  /* "credential" 93006 */
     12,   4,   1,  20,  21,  13,  42,   1,   7,  20,   0,  /* "credentialed" 93017 */
     12,   4,   1,  20,  21,  13,  33,   1,   7,  30,   0,  /* "credentials" 93028 */
     12,   4,   1,  20,  44,   0,  /* "credeur" 93034 */
     12,   4,  21,  20,   1,   9,   1,   7,   0,  /* "credible" 93043 */
     12,   4,  21,  20,   1,   3,   1,   9,   1,   7,   0,  /* "creditable" 93054 */
     12,   4,  21,  20,   5,   3,   1,  13,  33,   3,  18,   7,   3,   0,  /* "creditanstalt" 93068 */
     12,   4,  15,  20,  23,   3,  27,   0,  /* "credito" 93076 */
     12,   4,  21,  20,   1,   3,  47,  44,  46,  26,  13,   1,  14,   0,  /* "creditworthiness" 93090 */
     12,   4,  21,  20,   1,   3,  47,  44,  46,  26,   0,  /* "creditworthy" 93101 */
     12,   4,  21,  20,   1,   7,   0,  /* "credle" 93108 */
     12,   4,   1,  20,  29,   7,   1,   3,  26,   0,  /* "credulity" 93118 */
     12,   4,  23,   0,  /* "cree" 93122 */
     12,   4,  21,  37,   0,  /* "cref" 93127 */
     12,   4,  21,  38,   1,  13,   0,  /* "crehan" 93134 */
     12,   4,   2,   3,   1,  13,   0,  /* "creighton" 93141 */
     12,   4,  23,  17,  28,   3,   0,  /* "cremate" 93148 */
     12,   4,  23,  17,  28,   3,   1,  20,   0,  /* "cremated" 93157 */
     12,   4,  26,  17,   2,  33,   1,  13,   0,  /* "cremation" 93166 */
     12,   4,  26,  17,   1,   3,  18,   4,  26,   1,   0,  /* "crematoria" 93177 */
     12,   4,  26,  17,   1,   3,  18,   4,  26,   1,  17,   0,  /* "crematorium" 93189 */
     12,   4,  21,  17,   1,  13,  30,   0,  /* "cremeans" 93197 */
     12,   4,   5,  17,  23,  13,  30,   0,  /* "cremeens" 93205 */
     12,   4,  21,  13,  47,  15,   7,  40,   0,  /* "crenwelge" 93214 */
     12,   4,  23,  27,   7,   0,  /* "creole" 93220 */
     12,   4,  26,  25,   7,  30,   0,  /* "creoles" 93227 */
     12,   4,  23,  25,   7,  39,  30,   0,  /* "creolize" 93235 */
     12,   4,  23,  25,   7,  39,  30,  20,   0,  /* "creolized" 93244 */
     12,   4,  23,   1,  14,  25,   3,   0,  /* "creosote" 93252 */
     12,   4,   2,   6,   0,  /* "crepe" 93257 */
     12,   4,   1,   6,  25,   0,  /* "crepeau" 93263 */
     12,   4,   2,   6,  14,   0,  /* "crepes" 93269 */
     12,   4,  21,  12,   0,  /* "creque" 93274 */
     12,   4,  21,  14,   1,   6,   0,  /* "cresap" 93281 */
     12,   4,  31,  33,  21,  13,  20,  27,   0,  /* "crescendo" 93290 */
     12,   4,  21,  14,   1,  13,   3,   0,  /* "crescent" 93298 */
     12,   4,  15,  14,  42,  21,  13,  30,  26,   0,  /* "crescenzi" 93308 */
     12,   4,  15,  14,  42,  21,  13,  30,  27,   0,  /* "crescenzo" 93318 */
     12,   4,  21,  14,  26,   0,  /* "cresci" 93324 */
     12,   4,  21,  14,  12,  19,   3,   0,  /* "crescott" 93332 */
     12,   4,  21,  14,  26,   0,  /* "cressy" 93338 */
     12,   4,   1,   3,   2,  33,   1,  14,   0,  /* "cretaceous" 93347 */
     12,   4,  15,   3,  21,   7,   1,   0,  /* "cretella" 93355 */
     12,   4,  23,  33,  41,   1,  13,   0,  /* "cretien" 93363 */
     12,   4,  21,   3,  14,   5,  13,  40,  10,   0,  /* "cretsinger" 93373 */
     12,   4,  45,   3,  14,  37,  15,   7,  20,   0,  /* "creutzfeldt" 93383 */
     12,   4,  21,  22,   1,   7,  31,  32,   0,  /* "creveling" 93392 */
     12,   4,  21,  22,   1,  14,   1,  30,   0,  /* "crevices" 93401 */
     12,   4,  23,  22,  26,  10,   0,  /* "crevier" 93408 */
     12,   4,  21,  22,   1,  14,   3,  19,  13,   0,  /* "creviston" 93418 */
     12,   4,  29,   0,  /* "crew" 93422 */
     12,   4,  29,   0,  /* "crewe" 93426 */
     12,   4,  29,   1,   7,   0,  /* "crewel" 93432 */
     12,   4,  29,  30,   0,  /* "crewes" 93437 */
     12,   4,  29,  17,   1,  13,   0,  /* "crewman" 93444 */
     12,   4,  29,  17,  15,  13,   0,  /* "crewmen" 93451 */
     12,   4,  29,  30,   0,  /* "crews" 93456 */
     12,   4,   5,   9,   0,  /* "crib" 93461 */
     12,   4,  26,   9,   8,   4,  26,   0,  /* "cribari" 93469 */
     12,   4,   5,   9,   0,  /* "cribb" 93474 */
     12,   4,   5,   9,  31,  40,   0,  /* "cribbage" 93481 */
     12,   4,   5,   9,  30,   0,  /* "cribbs" 93487 */
     12,   4,   5,  12,   7,  27,   0,  /* "crichlow" 93494 */
     12,   4,   5,  42,   3,   1,  13,   0,  /* "crichton" 93502 */
     12,   4,   5,  12,   0,  /* "crick" 93507 */
     12,   4,   5,  20,   1,   7,   0,  /* "criddle" 93514 */
     12,   4,  39,  20,  10,   0,  /* "crider" 93520 */
     12,   4,  39,  20,   0,  /* "cried" 93525 */
     12,   4,  39,  10,   0,  /* "crier" 93530 */
     12,   4,  39,  30,   0,  /* "cries" 93535 */
     12,   4,  39,  40,  10,   0,  /* "criger" 93541 */
     12,   4,   5,  11,   7,  10,   0,  /* "crigler" 93548 */
     12,   4,   5,  37,  26,   7,  20,   0,  /* "crihfield" 93556 */
     12,   4,   5,  17,   0,  /* "crim" 93561 */
     12,   4,  39,  17,   0,  /* "crime" 93566 */
     12,   4,  39,  17,  23,   1,   0,  /* "crimea" 93573 */
     12,   4,   1,  17,  23,  13,   0,  /* "crimean" 93580 */
     12,   4,  39,  17,  30,   0,  /* "crimes" 93586 */
     12,   4,   5,  17,   1,  13,   1,   7,  39,  30,   0,  /* "criminalize" 93597 */
     12,   4,   5,  17,   1,  13,   1,   7,  39,  30,  20,   0,  /* "criminalized" 93609 */
     12,   4,   5,  17,   1,  13,   1,   7,  39,  30,  31,  32,   0,  /* "criminalizing" 93622 */
     12,   4,   5,  17,  30,   1,  13,   0,  /* "crimson" 93630 */
     12,   4,  39,  13,  10,   0,  /* "criner" 93636 */
     12,   4,   5,  13,  40,  20,   0,  /* "cringed" 93643 */
     12,   4,   5,  13,  40,  31,  32,   0,  /* "cringing" 93651 */
     12,   4,   5,   6,   0,  /* "crip" 93656 */
     12,   4,  39,   6,   0,  /* "cripe" 93661 */
     12,   4,   5,   6,   1,   7,   0,  /* "cripple" 93668 */
     12,   4,   5,   6,   1,   7,  20,   0,  /* "crippled" 93676 */
     12,   4,   5,   6,   1,   7,  30,   0,  /* "cripples" 93684 */
     12,   4,   5,   6,   1,   7,  31,  32,   0,  /* "crippling" 93693 */
     12,   4,   5,  14,   0,  /* "cris" 93698 */
     12,   4,  26,  14,   8,  37,  26,   0,  /* "crisafi" 93706 */
     12,   4,  26,  14,  19,  37,  29,   7,  26,   0,  /* "crisafulli" 93716 */
     12,   4,  26,  14,  42,  25,  13,  26,   0,  /* "criscione" 93725 */
     12,   4,  26,  14,  12,  47,  25,   7,  27,   0,  /* "criscuolo" 93735 */
     12,   4,  39,  30,   0,  /* "crise" 93740 */
     12,   4,  39,  14,  26,  30,   0,  /* "crises" 93747 */
     12,   4,  39,  14,   1,  14,   0,  /* "crisis" 93754 */
     12,   4,   5,  14,   1,   7,  10,   0,  /* "crisler" 93762 */
     12,   4,   5,  30,  17,   1,  13,   0,  /* "crismon" 93770 */
     12,   4,  26,  14,  27,  14,   3,  25,  17,  27,   0,  /* "crisostomo" 93781 */
     12,   4,  26,  14,   6,  23,  13,   1,   0,  /* "crispina" 93790 */
     12,   4,  26,  14,   6,  23,  13,  27,   0,  /* "crispino" 93799 */
     12,   4,  23,  14,   6,  27,   0,  /* "crispo" 93806 */
     12,   4,   5,  14,   3,   1,   9,  15,   7,   0,  /* "cristabel" 93816 */
     12,   4,   5,  14,   3,  26,   8,  13,  26,   0,  /* "cristiani" 93826 */
     12,   4,  26,  14,   3,  26,   8,  13,  27,   0,  /* "cristiano" 93836 */
     12,   4,   5,  14,   3,  25,   0,  /* "cristo" 93843 */
     12,   4,   5,  14,   3,   1,   9,  15,   7,   0,  /* "cristobel" 93853 */
     12,   4,   5,  14,  47,  15,   7,   0,  /* "criswell" 93861 */
     12,   4,   5,  42,  37,  26,   7,  20,   0,  /* "critchfield" 93870 */
     12,   4,  39,   3,  14,   0,  /* "crites" 93876 */
     12,   4,   5,   3,   1,  12,  24,   7,   1,   3,  26,   0,  /* "criticality" 93888 */
     12,   4,   5,   3,  31,  12,   1,   7,  26,   0,  /* "critically" 93898 */
     12,   4,   5,   3,   1,  14,   5,  30,   1,  17,   0,  /* "criticism" 93909 */
     12,   4,   5,   3,   1,  14,   5,  30,   1,  17,  30,   0,  /* "criticisms" 93921 */
     12,   4,   5,   3,   1,  14,  39,  30,   0,  /* "criticize" 93930 */
     12,   4,   5,   3,   1,  14,  39,  30,  20,   0,  /* "criticized" 93940 */
     12,   4,   5,   3,   1,  14,  39,  30,   1,  30,   0,  /* "criticizes" 93951 */
     12,   4,   5,   3,   1,  14,  39,  30,  31,  32,   0,  /* "criticizing" 93962 */
     12,   4,   1,   3,  23,  12,   3,   0,  /* "critiqued" 93970 */
     12,   4,   1,   3,  23,  12,  31,  32,   0,  /* "critiquing" 93979 */
     12,   4,  39,   3,   1,  13,   0,  /* "criton" 93986 */
     12,   4,  31,  22,  24,   4,  27,   0,  /* "crivaro" 93994 */
     12,   4,  31,  22,  21,   7,  26,   0,  /* "crivelli" 94002 */
     12,   4,  31,  22,  21,   7,  27,   0,  /* "crivello" 94010 */
     14,  44,  13,   1,  22,   5,  42,   0,  /* "crnkovich" 94018 */
     12,   4,  25,   0,  /* "cro" 94022 */
     12,   4,  25,  12,   0,  /* "croak" 94027 */
     12,   4,  25,  12,  10,   0,  /* "croaker" 94033 */
     12,   4,  25,  12,  31,  32,   0,  /* "croaking" 94040 */
     12,   4,  25,   8,   3,   0,  /* "croat" 94046 */
     12,   4,  25,   8,   3,  14,   0,  /* "croats" 94053 */
     12,   4,   8,  12,   0,  /* "croc" 94058 */
     12,   4,  25,  42,  26,   0,  /* "croce" 94064 */
     12,   4,  27,  33,   2,   0,  /* "crochet" 94070 */
     12,   4,  27,  33,   2,  20,   0,  /* "crocheted" 94077 */
     12,   4,  25,  33,   1,   3,   5,   4,   0,  /* "crochetiere" 94086 */
     12,   4,  27,  33,   2,  31,  32,   0,  /* "crocheting" 94094 */
     12,   4,   8,  12,   1,  20,  39,   7,   0,  /* "crocodile" 94103 */
     12,   4,   8,  12,   1,  20,  39,   7,  30,   0,  /* "crocodiles" 94113 */
     12,   4,  25,  37,  51,   3,   0,  /* "crofoot" 94120 */
     12,   4,  18,  37,   3,   0,  /* "croft" 94126 */
     12,   4,  18,  37,   3,  14,   0,  /* "crofts" 94133 */
     12,   4,   8,  11,  38,   1,  13,   0,  /* "croghan" 94141 */
     12,  47,   8,  14,   8,  13,   3,   0,  /* "croissant" 94149 */
     12,  47,   8,  14,   8,  13,   3,  14,   0,  /* "croissants" 94158 */
     12,   4,  49,   3,  14,  10,   0,  /* "croitzer" 94165 */
     12,   4,  49,   0,  /* "croix" 94169 */
     12,   4,   8,  17,   0,  /* "crom" 94174 */
     12,   4,   8,  17,  19,   4,   3,  26,   0,  /* "cromartie" 94183 */
     12,   4,   8,  17,  26,   0,  /* "cromie" 94189 */
     12,   4,   8,  17,  47,   1,   7,   0,  /* "cromwell" 94197 */
     12,   4,   8,  13,   0,  /* "cron" 94202 */
     12,   4,   8,  13,  52,   4,   0,  /* "cronauer" 94209 */
     12,   4,  25,  13,  26,  30,   0,  /* "cronies" 94216 */
     12,   4,   8,  32,  12,  38,  39,   3,   0,  /* "cronkhite" 94225 */
     12,   4,   8,  32,  12,  39,   3,   0,  /* "cronkite" 94233 */
     12,   4,   8,  32,  12,   4,  39,   3,   0,  /* "cronkright" 94242 */
     12,   4,  25,  13,   1,  14,   0,  /* "cronus" 94249 */
     12,   4,  25,  13,  26,   5,  30,   1,  17,   0,  /* "cronyism" 94259 */
     12,   4,  45,  12,   1,  20,   0,  /* "crooked" 94266 */
     12,   4,  45,  12,  33,  24,  32,  12,  14,   0,  /* "crookshanks" 94276 */
     12,   4,  29,  17,   0,  /* "croom" 94281 */
     12,   4,  29,  17,  30,   0,  /* "crooms" 94287 */
     12,   4,  29,  13,   0,  /* "croon" 94292 */
     12,   4,  29,  13,  10,   0,  /* "crooner" 94298 */
     12,   4,  29,  13,  31,  32,   0,  /* "crooning" 94305 */
     12,   4,  29,  13,  30,   0,  /* "croons" 94311 */
     12,   4,   8,   6,   0,  /* "crop" 94316 */
     12,   4,   8,   6,   7,  24,  13,  20,   0,  /* "cropland" 94325 */
     12,   4,   8,   6,   7,  26,   0,  /* "cropley" 94332 */
     12,   4,  27,  12,   2,   0,  /* "croquet" 94338 */
     12,   4,  18,  14,   0,  /* "cros" 94343 */
     12,   4,  18,  30,   9,  26,   0,  /* "crosbie" 94350 */
     12,   4,  18,  30,   9,  26,   0,  /* "crosby" 94357 */
     12,   4,   8,  33,  36,   0,  /* "croshaw" 94363 */
     12,   4,  25,  14,   1,  13,   0,  /* "croson" 94370 */
     12,   4,   8,  14,   1,  13,   0,  /* "crossan" 94377 */
     12,   4,  18,  14,   9,   5,   7,   0,  /* "crossbill" 94385 */
     12,   4,  18,  14,   9,   5,   7,  30,   0,  /* "crossbills" 94394 */
     12,   4,  18,  14,   9,  25,  13,  30,   0,  /* "crossbones" 94403 */
     12,   4,   8,  14,   0,  /* "crosse" 94408 */
     12,   4,   8,  14,   1,   3,   0,  /* "crossett" 94415 */
     12,   4,  18,  14,  37,  39,   4,   0,  /* "crossfire" 94423 */
     12,   4,  18,  14,  37,  39,   4,   0,  /* "crossfire" 94431 */
     12,   4,   8,  14,   5,  13,   0,  /* "crossin" 94438 */
     12,   4,   8,  14,   7,  26,   0,  /* "crossley" 94445 */
     12,   4,   8,  14,   7,   5,  13,   0,  /* "crosslin" 94453 */
     12,   4,  18,  14,  13,  39,  13,   0,  /* "crossnine" 94461 */
     12,   4,  25,  14,  13,  27,   0,  /* "crossno" 94468 */
     12,   4,   8,  14,   1,  13,   0,  /* "crosson" 94475 */
     12,   4,  18,  14,   6,  23,  14,   0,  /* "crosspiece" 94483 */
     12,   4,  18,  14,   6,  23,  14,   1,  30,   0,  /* "crosspieces" 94493 */
     12,   4,  18,  14,   3,  36,  12,   0,  /* "crosstalk" 94501 */
     12,   4,  18,  14,   3,  48,  13,   0,  /* "crosstown" 94509 */
     12,   4,   8,  14,  22,   5,   7,   0,  /* "crossville" 94517 */
     12,   4,   8,  14,  47,   8,  12,   0,  /* "crosswalk" 94525 */
     12,   4,   8,  14,  47,  39,   3,   0,  /* "crosswhite" 94533 */
     12,   4,  18,  14,  47,  39,  30,   0,  /* "crosswise" 94541 */
     12,   4,  18,  14,  47,  44,  20,   0,  /* "crossword" 94549 */
     12,   4,  18,  14,  47,  44,  20,  30,   0,  /* "crosswords" 94558 */
     12,   4,   8,  14,  16,  47,   1,   3,   0,  /* "crosthwait" 94567 */
     12,   4,   8,  14,  16,  47,   1,   3,   0,  /* "crosthwaite" 94576 */
     12,   4,   8,  14,  47,  15,   7,   0,  /* "croswell" 94584 */
     12,   4,   1,   3,  25,   0,  /* "croteau" 94590 */
     12,   4,   1,   3,  25,   0,  /* "crotteau" 94596 */
     12,   4,  25,   3,  30,  10,   0,  /* "crotzer" 94603 */
     12,   4,  29,   6,   0,  /* "croup" 94608 */
     12,   4,  48,  14,  10,   0,  /* "crouser" 94614 */
     12,   4,  48,  16,   1,  17,  15,   7,   0,  /* "crouthamel" 94623 */
     12,   4,  25,  22,   1,   7,   0,  /* "crovl" 94630 */
     12,   4,  25,  22,   1,   7,  30,   0,  /* "crovls" 94638 */
     12,   4,  25,   0,  /* "crow" 94642 */
     12,   4,  25,   1,   7,   0,  /* "crowell" 94648 */
     12,   4,  48,  13,   7,  39,  12,   0,  /* "crownlike" 94656 */
     12,   4,  48,  13,  21,  12,  14,   0,  /* "crownx" 94664 */
     12,   4,  48,  14,   1,  13,   0,  /* "crowson" 94671 */
     12,   4,  48,  46,  10,   0,  /* "crowther" 94677 */
     12,   4,  25,  16,  10,  30,   0,  /* "crowthers" 94684 */
     12,   4,   8,  12,  14,   3,   1,  13,   0,  /* "croxton" 94693 */
     12,   4,  49,   0,  /* "croy" 94697 */
     12,   4,  25,  43,  10,   0,  /* "crozier" 94703 */
     12,   4,  29,  14,   0,  /* "cruce" 94708 */
     12,   4,  29,  14,  26,  30,   0,  /* "cruces" 94715 */
     12,   4,  29,  33,   1,   7,   0,  /* "crucial" 94722 */
     12,   4,  29,  33,   1,   7,   7,  26,   0,  /* "crucially" 94731 */
     12,   4,  29,  14,   1,   9,   1,   7,   0,  /* "crucible" 94740 */
     12,   4,  29,  14,   1,  37,  39,  20,   0,  /* "crucified" 94749 */
     12,   4,  29,  14,   1,  37,   5,  12,  14,   0,  /* "crucifix" 94759 */
     12,   4,  29,  14,   1,  37,   5,  12,  14,   1,  30,   0,  /* "crucifixes" 94771 */
     12,   4,  29,  14,   1,  37,   5,  12,  33,   1,  13,   0,  /* "crucifixion" 94783 */
     12,   4,  29,  14,   1,  37,  39,   0,  /* "crucify" 94791 */
     12,   4,  35,  20,   0,  /* "crud" 94796 */
     12,   4,  29,  20,   0,  /* "crude" 94801 */
     12,   4,  29,  20,   1,   7,   0,  /* "crudele" 94808 */
     12,   4,  29,  20,   7,  26,   0,  /* "crudely" 94815 */
     12,   4,  29,  20,  30,   0,  /* "crudes" 94821 */
     12,   4,  29,  26,   1,   0,  /* "cruea" 94827 */
     12,   4,  29,   1,   7,   0,  /* "cruel" 94833 */
     12,   4,  29,   7,   1,  14,   3,   0,  /* "cruelest" 94841 */
     12,   4,  29,   7,  26,   0,  /* "cruelly" 94847 */
     12,   4,  29,   7,   3,  26,  30,   0,  /* "cruelties" 94855 */
     12,   4,  29,   7,   3,  26,   0,  /* "cruelty" 94862 */
     12,   4,  35,  26,   0,  /* "cruey" 94867 */
     12,   4,  29,  40,  10,   0,  /* "cruger" 94873 */
     12,   4,  45,  12,  33,  24,  32,  12,   0,  /* "cruickshank" 94882 */
     12,   4,  29,  31,  12,  33,  24,  32,  12,   0,  /* "cruikshank" 94892 */
     12,   4,  29,  30,   0,  /* "cruise" 94897 */
     12,   4,  29,  30,  20,   0,  /* "cruised" 94903 */
     12,   4,  29,  30,  10,   0,  /* "cruiser" 94909 */
     12,   4,  29,  30,  10,  30,   0,  /* "cruisers" 94916 */
     12,   4,  29,  30,   1,  30,   0,  /* "cruises" 94923 */
     12,   4,  29,  30,  31,  32,   0,  /* "cruising" 94930 */
     12,   4,  35,  17,   0,  /* "crum" 94935 */
     12,   4,  35,  17,   9,   1,   7,   0,  /* "crumble" 94943 */
     12,   4,  35,  17,   9,   1,   7,  20,   0,  /* "crumbled" 94952 */
     12,   4,  35,  17,   9,   1,   7,  30,   0,  /* "crumbles" 94961 */
     12,   4,  35,  17,   9,   1,   7,  31,  32,   0,  /* "crumbling" 94971 */
     12,   4,  29,  17,   0,  /* "crume" 94976 */
     12,   4,  29,  17,   1,   3,  39,   0,  /* "crumitie" 94984 */
     12,   4,  35,  17,  15,   3,   0,  /* "crummett" 94991 */
     12,   4,  35,  17,   6,   1,  12,  10,   0,  /* "crumpacker" 95000 */
     12,   4,  35,  17,   6,   1,   7,   0,  /* "crumple" 95008 */
     12,   4,  35,  17,   6,   1,   7,  20,   0,  /* "crumpled" 95017 */
     12,   4,  35,  17,   6,   1,   7,  10,   0,  /* "crumpler" 95026 */
     12,   4,  35,  17,   4,  23,  13,   0,  /* "crumrine" 95034 */
     12,   4,  35,  32,  12,   1,   7,   3,  19,  13,   0,  /* "crunkleton" 95045 */
     12,   4,  29,   6,  26,   0,  /* "crupi" 95051 */
     12,   4,  29,  14,   2,  20,  31,  32,   0,  /* "crusading" 95060 */
     12,   4,  29,  30,   0,  /* "cruse" 95065 */
     12,   4,  29,  30,  10,   0,  /* "cruser" 95071 */
     12,   4,  29,  14,  27,   0,  /* "crusoe" 95077 */
     12,   4,   1,  14,   3,   2,  33,   1,  13,   0,  /* "crustacean" 95087 */
     12,   4,   1,  14,   3,   2,  33,   1,  13,  30,   0,  /* "crustaceans" 95098 */
     12,   4,  35,  14,   3,   1,   7,   0,  /* "crustal" 95106 */
     12,   4,  29,   3,   0,  /* "crute" 95111 */
     12,   4,  35,  16,  10,  20,  30,   0,  /* "cruthirds" 95119 */
     12,   4,  35,  12,  14,   0,  /* "crux" 95125 */
     12,   4,  29,  30,   0,  /* "cruz" 95130 */
     12,   4,  29,  30,   8,  20,  27,   0,  /* "cruzado" 95138 */
     12,   4,  29,  30,   8,  20,  27,  14,   0,  /* "cruzados" 95147 */
     12,   4,  29,  30,   1,  13,   0,  /* "cruzan" 95154 */
     12,   4,  29,  30,   0,  /* "cruze" 95159 */
     12,   4,  29,  30,   1,  13,   0,  /* "cruzen" 95166 */
     12,   4,  39,   0,  /* "cry" 95170 */
     12,   4,  39,   1,  13,   0,  /* "cryan" 95176 */
     12,   4,  39,   9,  28,   9,  26,   0,  /* "crybaby" 95184 */
     12,   4,  39,  20,  10,   0,  /* "cryder" 95190 */
     12,   4,  39,  20,  10,  17,   1,  13,   0,  /* "cryderman" 95199 */
     12,   4,  39,   0,  /* "crye" 95203 */
     12,   4,  39,  10,   0,  /* "cryer" 95208 */
     12,   4,  39,  31,  32,   0,  /* "crying" 95214 */
     12,   4,  39,  17,  30,   0,  /* "crymes" 95220 */
     12,   4,  39,   1,  40,  21,  13,   1,  12,   0,  /* "cryogenic" 95230 */
     12,   4,  39,   1,  40,  21,  13,   1,  12,  14,   0,  /* "cryogenics" 95241 */
     12,   4,  39,   1,   7,  39,   3,   0,  /* "cryolite" 95249 */
     12,   4,   5,   6,   3,  27,   7,   5,   4,   1,  13,  14,   0,  /* "cryptoclearance" 95262 */
     12,   4,   5,   6,   3,  27,  14,   6,  36,   4,   5,  20,  26,   1,  17,   0,  /* "cryptosporidium" 95278 */
     12,   4,   5,  14,   1,   7,  10,   0,  /* "crysler" 95286 */
     12,   4,   5,  14,   3,   1,   7,  39,  13,   0,  /* "crystalline" 95296 */
     12,   4,   5,  14,   3,   1,   7,  39,  30,   0,  /* "crystallize" 95306 */
     12,   4,   5,  14,   3,   1,   7,  39,  30,  20,   0,  /* "crystallized" 95317 */
     12,   4,   5,  14,   3,   1,   7,  39,  30,  31,  32,   0,  /* "crystallizing" 95329 */
     12,   4,  39,  14,   3,  10,   0,  /* "cryster" 95336 */
     12,   4,  39,   3,  30,  10,   0,  /* "crytzer" 95343 */
     30,   8,   4,   0,  /* "csar" 95347 */
     12,   1,  14,   8,  33,  10,   0,  /* "csaszar" 95354 */
     14,  23,  14,   6,  24,  13,   0,  /* "cspan" 95361 */
     14,  23,  21,  14,   6,  23,  39,   0,  /* "cspi" 95369 */
     12,  18,   4,   3,   0,  /* "ct" 95374 */
     12,  29,   8,  20,   4,   1,   0,  /* "cuadra" 95381 */
     12,  29,  19,  20,   4,   8,  20,  27,   0,  /* "cuadrado" 95390 */
     12,  41,  29,   1,  40,  25,  13,   0,  /* "cuajone" 95398 */
     12,  41,  29,  48,   3,   1,  17,  19,  12,   0,  /* "cuauhtemoc" 95408 */
     12,  35,   9,   0,  /* "cub" 95412 */
     12,  41,  29,   9,   1,   0,  /* "cuba" 95418 */
     12,  41,  29,   9,   1,  13,   0,  /* "cuban" 95425 */
     12,  41,  29,   9,   1,  13,  30,   0,  /* "cubans" 95433 */
     12,  35,   9,  31,  40,   0,  /* "cubbage" 95439 */
     12,  41,  29,   9,   0,  /* "cube" 95444 */
     12,  41,  29,   9,  20,   0,  /* "cubed" 95450 */
     12,  41,  29,   9,  30,   0,  /* "cubes" 95456 */
     12,  41,  29,   9,  31,  12,   0,  /* "cubic" 95463 */
     12,  41,  29,   9,  31,  12,   1,   7,   0,  /* "cubicle" 95472 */
     12,  41,  29,   9,  31,  12,   1,   7,  30,   0,  /* "cubicles" 95482 */
     12,  41,  29,   9,   5,  30,   1,  17,   0,  /* "cubism" 95491 */
     12,  41,  29,   9,   5,  14,   3,   0,  /* "cubist" 95499 */
     12,  41,  29,   9,   5,   3,   0,  /* "cubit" 95506 */
     12,  35,   9,  30,   0,  /* "cubs" 95511 */
     12,  29,  42,  26,   0,  /* "cucci" 95516 */
     12,  29,  42,   1,   0,  /* "cuccia" 95521 */
     12,  29,  42,  26,  27,   0,  /* "cuccio" 95527 */
     12,  35,  12,  29,   0,  /* "cuckoo" 95532 */
     12,  29,  12,  29,  30,   0,  /* "cuckoos" 95538 */
     12,  29,  12,  27,   0,  /* "cuco" 95543 */
     12,  41,  29,  12,   1,  17,   9,  10,   0,  /* "cucumber" 95552 */
     12,  41,  29,  12,   1,  17,  10,  30,   0,  /* "cucumbers" 95561 */
     12,  35,  20,   1,  38,  26,   0,  /* "cudahy" 95568 */
     12,  35,  20,   0,  /* "cudd" 95572 */
     12,  35,  20,   9,  34,  12,   0,  /* "cuddeback" 95579 */
     12,  35,  20,   5,  38,  26,   0,  /* "cuddihy" 95586 */
     12,  35,  20,   1,   7,   0,  /* "cuddle" 95592 */
     12,  35,  20,   1,   7,  20,   0,  /* "cuddled" 95599 */
     12,  35,  20,   7,  31,  32,   0,  /* "cuddling" 95606 */
     12,  41,  29,  20,   0,  /* "cude" 95611 */
     12,  41,  29,   0,  /* "cue" 95615 */
     12,  41,  29,  20,   0,  /* "cued" 95620 */
     12,  41,  29,   7,  10,   0,  /* "cuellar" 95626 */
     12,  29,  21,   7,  27,   0,  /* "cuello" 95632 */
     12,  47,  21,  13,  12,   1,   0,  /* "cuenca" 95639 */
     12,  47,  21,   4,  27,   0,  /* "cuero" 95645 */
     12,  45,   4,  22,  27,   0,  /* "cuervo" 95651 */
     12,  41,  29,  30,   0,  /* "cues" 95656 */
     12,  47,  21,   3,  27,   0,  /* "cueto" 95662 */
     12,  47,  21,  22,  19,  30,   0,  /* "cuevas" 95669 */
     12,  35,  37,   0,  /* "cuff" 95673 */
     12,  29,  40,  23,  13,  26,   0,  /* "cugini" 95680 */
     12,  29,  13,  26,   0,  /* "cuhney" 95685 */
     12,  47,  23,  14,   5,  13,  19,   3,   0,  /* "cuisinart" 95694 */
     12,  47,  23,  30,   5,  13,  19,   4,   3,  14,   0,  /* "cuisinarts" 95705 */
     12,  47,   5,  30,  23,  13,   0,  /* "cuisine" 95712 */
     12,  47,   5,  30,  23,  13,  30,   0,  /* "cuisines" 95720 */
     12,  35,   7,   0,  /* "cul" 95724 */
     12,  35,   7,  38,   2,  13,   0,  /* "culhane" 95731 */
     12,  41,  29,   7,   1,  13,  21,   4,  26,   0,  /* "culinary" 95741 */
     12,  41,  29,   7,   1,  13,  25,  22,   1,   0,  /* "culinova" 95751 */
     12,  35,   7,   0,  /* "cull" 95755 */
     12,  29,   7,   1,   3,  19,  13,   0,  /* "culleton" 95763 */
     12,  35,   7,   1,  11,   1,  13,   0,  /* "culligan" 95771 */
     12,  35,   7,  26,  17,  36,   4,   0,  /* "cullimore" 95779 */
     12,  35,   7,   1,  13,  21,   3,   0,  /* "cullinet" 95787 */
     12,  35,   7,   1,  17,   0,  /* "cullom" 95793 */
     12,  35,   7,   1,   6,   0,  /* "cullop" 95799 */
     12,  35,   7,   6,   0,  /* "culp" 95804 */
     12,  35,   7,   6,   1,   9,   1,   7,   0,  /* "culpable" 95813 */
     12,  35,   7,   6,  15,   6,  10,   0,  /* "culpepper" 95821 */
     12,  35,   7,   6,   4,   1,   3,   0,  /* "culprit" 95829 */
     12,  35,   7,   6,   4,   1,   3,  14,   0,  /* "culprits" 95838 */
     12,  35,   7,   3,   0,  /* "cult" 95843 */
     12,  35,   7,   3,   1,  22,   2,   3,   0,  /* "cultivate" 95852 */
     12,  35,   7,  42,  10,   1,   7,   5,  30,   1,  17,   0,  /* "culturalism" 95864 */
     12,  35,  17,   0,  /* "cum" 95868 */
     12,  29,  17,  31,  32,  30,   0,  /* "cumings" 95875 */
     12,  35,  17,   1,  12,   0,  /* "cummick" 95881 */
     12,  41,  29,  17,  41,   1,   7,   1,   3,  31,  22,   0,  /* "cumulative" 95893 */
     12,  41,  29,  17,  41,   1,   7,   1,   3,  31,  22,   7,  26,   0,  /* "cumulatively" 95907 */
     12,  41,  29,  13,  24,  13,   1,  13,   0,  /* "cunanan" 95916 */
     12,  41,  29,  13,  10,  20,   0,  /* "cunard" 95923 */
     12,  29,  13,  20,   8,   4,  26,   0,  /* "cundari" 95931 */
     12,  41,  29,  13,  26,   1,  37,  18,   4,  17,   0,  /* "cuneiform" 95942 */
     12,  41,  29,  13,  26,  27,   0,  /* "cuneo" 95949 */
     12,   1,  13,  23,  13,   0,  /* "cunneen" 95955 */
     12,  41,  29,  13,  26,   0,  /* "cuny" 95961 */
     12,  47,  18,  32,   0,  /* "cuong" 95966 */
     12,  47,  25,  30,  27,   0,  /* "cuozzo" 95972 */
     12,  35,   6,   0,  /* "cup" 95976 */
     12,  35,   9,  10,  20,   0,  /* "cupboard" 95982 */
     12,  35,   9,  10,  20,  30,   0,  /* "cupboards" 95989 */
     12,  29,   6,  10,   3,  23,  13,  27,   0,  /* "cupertino" 95998 */
     12,  41,  29,   6,   1,  20,   0,  /* "cupid" 96005 */
     12,  41,  29,   6,   1,  20,  30,   0,  /* "cupids" 96013 */
     12,  41,  29,   6,   5,   3,   0,  /* "cupit" 96020 */
     12,  41,  29,   6,  27,   0,  /* "cupo" 96026 */
     12,  35,   6,   0,  /* "cupp" 96030 */
     12,  35,   6,   1,   7,  30,   0,  /* "cupples" 96037 */
     12,  35,   6,  14,   0,  /* "cups" 96042 */
     12,  44,   0,  /* "cur" 96045 */
     12,  41,  45,   4,   1,   9,   1,   7,   0,  /* "curable" 96054 */
     12,  41,  45,   4,   1,  14,  48,   0,  /* "curacao" 96062 */
     12,  41,  45,   4,   1,   3,   0,  /* "curate" 96069 */
     12,  41,  45,   4,   1,   3,  31,  22,   0,  /* "curative" 96078 */
     12,  51,   4,  19,   3,  25,   7,  27,   0,  /* "curatolo" 96087 */
     12,  41,  51,   4,   2,   3,  10,   0,  /* "curator" 96095 */
     12,  41,  45,   4,   1,   3,  18,   4,  26,   1,   7,   0,  /* "curatorial" 96107 */
     12,  41,  45,   4,   1,   3,  10,  30,   0,  /* "curators" 96116 */
     12,  44,   9,   0,  /* "curb" 96120 */
     12,  51,   4,   9,  21,   7,  27,   0,  /* "curbelo" 96128 */
     12,  44,   9,  14,  39,  20,   0,  /* "curbside" 96135 */
     12,  45,   4,  42,  26,   0,  /* "curci" 96141 */
     12,  45,   4,  42,  26,  27,   0,  /* "curcio" 96148 */
     12,  51,   4,  12,  45,   4,  29,   0,  /* "curcuru" 96156 */
     12,  44,  20,   0,  /* "curd" 96160 */
     12,  41,  45,   4,   0,  /* "cure" 96165 */
     12,  41,  45,   4,  20,   0,  /* "cured" 96171 */
     12,  41,  45,   4,  30,   0,  /* "cures" 96177 */
     12,  41,  45,   4,   3,   1,  13,   0,  /* "cureton" 96185 */
     12,  44,  37,  41,  29,   0,  /* "curfew" 96191 */
     12,  44,  37,  41,  29,  30,   0,  /* "curfews" 96198 */
     12,  51,   4,  26,   8,   7,  26,   0,  /* "curiale" 96206 */
     12,  41,  51,   4,  23,   0,  /* "curie" 96212 */
     12,  41,  29,   4,  26,   7,   0,  /* "curiel" 96219 */
     12,  41,  45,   4,  31,  32,   0,  /* "curing" 96226 */
     12,  41,  45,   4,  31,  32,   3,   1,  13,   0,  /* "curington" 96236 */
     12,  41,  45,   4,  26,   8,  14,   1,   3,  26,  30,   0,  /* "curiosities" 96248 */
     12,  41,  45,   4,  26,   8,  14,   1,   3,  26,   0,  /* "curiosity" 96259 */
     12,  41,  45,   4,  26,   1,  14,   0,  /* "curious" 96267 */
     12,  41,  45,   4,  26,   1,  14,  10,   0,  /* "curiouser" 96276 */
     12,  41,  45,   4,  26,   1,  14,   7,  26,   0,  /* "curiously" 96286 */
     12,  41,  45,   1,   3,  23,   9,   1,   0,  /* "curitiba" 96295 */
     12,  44,   7,   0,  /* "curl" 96299 */
     12,  18,   4,   1,   7,   0,  /* "curle" 96305 */
     12,  44,   7,  15,   3,   0,  /* "curlett" 96311 */
     12,  10,  17,  35,  40,   1,  13,   0,  /* "curmudgeon" 96319 */
     12,  44,  13,   1,   3,   0,  /* "curnutt" 96325 */
     12,  10,  13,  35,   3,   0,  /* "curnutte" 96331 */
     12,  35,   4,   1,   0,  /* "curragh" 96336 */
     12,  44,   1,  13,   0,  /* "curran" 96341 */
     12,  44,   1,  13,  14,  26,  30,   0,  /* "currencies" 96349 */
     12,  51,   4,  21,   4,  26,   0,  /* "curreri" 96356 */
     12,  10,   5,  12,  41,   1,   7,   1,   0,  /* "curricula" 96365 */
     12,  10,   5,  12,  41,   1,   7,  10,   0,  /* "curricular" 96374 */
     12,  10,   5,  12,  41,   1,   7,   1,  17,   0,  /* "curriculum" 96384 */
     12,  10,   5,  12,  41,   1,   7,   1,  17,  30,   0,  /* "curriculums" 96395 */
     12,  18,   4,   5,  13,   0,  /* "currin" 96401 */
     12,  45,   4,  27,   0,  /* "curro" 96406 */
     12,  35,   4,  26,   0,  /* "curry" 96411 */
     12,  35,   4,  26,  30,   0,  /* "currys" 96417 */
     12,  44,   3,   0,  /* "curt" 96421 */
     12,  44,   3,   1,  13,   0,  /* "curtain" 96427 */
     12,  44,   3,   1,  13,  30,   0,  /* "curtains" 96434 */
     12,  45,   4,   3,  26,   0,  /* "curti" 96440 */
     12,  45,   4,   3,   5,  14,   0,  /* "curtice" 96447 */
     12,  44,   3,   5,  13,   0,  /* "curtin" 96453 */
     12,  44,   3,   1,  14,   0,  /* "curtis" 96459 */
     12,  45,   4,   3,  27,   0,  /* "curto" 96465 */
     12,  44,   3,   4,  39,   3,   0,  /* "curtright" 96472 */
     12,  35,  14,   0,  /* "cus" 96476 */
     12,  41,  29,  30,   1,  12,   0,  /* "cusack" 96483 */
     12,  29,  14,   8,  13,  27,   0,  /* "cusano" 96490 */
     12,  35,  33,   0,  /* "cush" 96494 */
     12,   1,  33,   5,   3,  31,  12,   0,  /* "cushitic" 96502 */
     12,  41,  29,  30,  26,  24,  13,   1,   0,  /* "cusiana" 96511 */
     12,  41,  29,  30,  31,  12,   0,  /* "cusic" 96518 */
     12,  41,  29,  30,  31,  12,   0,  /* "cusick" 96525 */
     12,  29,  14,  26,  17,   8,  13,  27,   0,  /* "cusimano" 96534 */
     12,  35,  14,   1,   6,   0,  /* "cusip" 96540 */
     12,  35,  14,  12,   0,  /* "cusk" 96545 */
     12,  29,  14,  17,   8,  13,  27,   0,  /* "cusmano" 96553 */
     12,  41,  29,  14,  27,   0,  /* "cuso" 96559 */
     12,  35,  14,   6,   0,  /* "cusp" 96564 */
     12,  35,  14,   0,  /* "cuss" 96568 */
     12,  35,  14,   3,  10,  20,   0,  /* "custard" 96575 */
     12,  35,  14,   3,   5,  14,   0,  /* "custis" 96582 */
     12,   1,  14,   3,  25,  20,  26,   1,   7,   0,  /* "custodial" 96592 */
     12,   1,  14,   3,  25,  20,  26,   1,  13,   0,  /* "custodian" 96602 */
     12,   1,  14,   3,  25,  20,  26,   1,  13,  30,   0,  /* "custodians" 96613 */
     12,  29,  14,   3,  25,  20,  26,  27,   0,  /* "custodio" 96622 */
     12,  35,  14,   3,   1,  17,  21,   4,  26,   0,  /* "customary" 96632 */
     12,  35,  14,   3,   1,  17,  39,  30,   0,  /* "customize" 96641 */
     12,  35,  14,   3,   1,  17,  39,  30,  20,   0,  /* "customized" 96651 */
     12,  35,  14,   3,   1,  17,  39,  30,  31,  32,   0,  /* "customizing" 96662 */
     12,  29,  14,  29,  17,   8,  13,  27,   0,  /* "cusumano" 96671 */
     12,  35,   3,   0,  /* "cut" 96675 */
     12,  29,   3,   8,  41,   1,   0,  /* "cutaia" 96682 */
     12,  35,   3,   1,  47,  28,   0,  /* "cutaway" 96689 */
     12,  41,  29,   3,   0,  /* "cute" 96694 */
     12,  41,  29,   3,  13,   1,  14,   0,  /* "cuteness" 96702 */
     12,  41,  29,   3,  10,   0,  /* "cuter" 96708 */
     12,  41,  29,   3,  14,  23,  13,   1,  14,   0,  /* "cutesiness" 96718 */
     12,  41,  29,   3,   5,  14,   3,   0,  /* "cutest" 96726 */
     12,  41,  29,   3,  14,  26,   0,  /* "cutesy" 96733 */
     12,  41,  29,   3,   1,  12,   1,   7,   0,  /* "cuticle" 96742 */
     12,  41,  29,   3,   5,   7,  27,   0,  /* "cutillo" 96750 */
     12,  35,   3,   7,   1,  14,   0,  /* "cutlass" 96757 */
     12,  35,   3,   7,  10,   0,  /* "cutler" 96763 */
     12,  35,   3,   7,  10,  26,   0,  /* "cutlery" 96770 */
     12,  35,   3,  18,  37,   0,  /* "cutoff" 96776 */
     12,  35,   3,  18,  37,  14,   0,  /* "cutoffs" 96783 */
     12,  35,   3,   4,   2,   7,   0,  /* "cutrale" 96790 */
     12,  35,   3,   4,  39,   3,   0,  /* "cutright" 96797 */
     12,  29,   3,   4,  25,  13,   1,   0,  /* "cutrona" 96805 */
     12,  29,   3,   4,  25,  13,  26,   0,  /* "cutrone" 96813 */
     12,  35,   3,  14,   0,  /* "cuts" 96818 */
     12,  29,   3,  23,  13,  27,   0,  /* "cuttino" 96825 */
     12,  35,   3,   1,   7,  37,   5,  33,   0,  /* "cuttlefish" 96834 */
     12,  41,  29,   3,  35,  13,  41,  27,   0,  /* "cutugno" 96843 */
     12,  35,   3,  47,  44,  17,   0,  /* "cutworm" 96850 */
     12,  41,  29,  22,   7,  26,  10,   0,  /* "cuvelier" 96858 */
     12,  39,   1,  38,  25,  11,   1,   0,  /* "cuyahoga" 96866 */
     12,  39,   7,  10,   0,  /* "cuyler" 96871 */
     12,  35,  30,  10,   3,   0,  /* "cuzzort" 96877 */
     12,  47,  23,   4,   3,  13,  26,   1,   0,  /* "cwiertnia" 96886 */
     12,  47,   5,  12,   0,  /* "cwik" 96891 */
     12,  47,   5,  12,   7,   1,   0,  /* "cwikla" 96898 */
     14,  23,  21,  12,  14,  14,  23,   0,  /* "cxc" 96906 */
     14,  39,   0,  /* "cy" 96909 */
     14,  39,  34,  12,   0,  /* "cyacq" 96914 */
     14,  39,  24,  13,   0,  /* "cyan" 96919 */
     14,  39,  24,  13,   1,  17,   1,  20,   0,  /* "cyanamid" 96928 */
     14,  39,   1,  13,  39,  20,   0,  /* "cyanide" 96935 */
     14,  39,  24,  13,  10,  31,  12,   0,  /* "cyanuric" 96943 */
     14,  39,   9,   0,  /* "cyb" 96947 */
     14,  39,   9,  10,   0,  /* "cyber" 96952 */
     14,  39,   9,  10,  12,  24,  33,   0,  /* "cybercash" 96960 */
     14,  39,   9,  10,   6,  18,   4,  13,   0,  /* "cyberporn" 96969 */
     14,  39,   9,  10,  14,  21,  12,  14,   0,  /* "cybersex" 96978 */
     14,  39,   9,  10,  14,   6,   2,  14,   0,  /* "cyberspace" 96987 */
     14,  39,   9,   5,   7,   0,  /* "cybill" 96993 */
     12,   1,   9,  35,   7,  14,  12,  26,   0,  /* "cybulski" 97002 */
     14,  39,  12,  34,  20,  30,   0,  /* "cycads" 97009 */
     14,  39,  12,  21,   4,   0,  /* "cycare" 97015 */
     14,  39,  12,   7,   2,  20,  26,  30,   0,  /* "cyclades" 97024 */
     14,  39,  12,   1,   7,   0,  /* "cycle" 97030 */
     14,  39,  12,   1,   7,  20,   0,  /* "cycled" 97037 */
     14,  39,  12,   1,   7,  30,   0,  /* "cycles" 97044 */
     14,  39,  12,   7,  31,  12,   1,   7,   0,  /* "cyclical" 97053 */
     14,   5,  12,   7,  31,  12,  24,   7,   1,   3,  26,   0,  /* "cyclicality" 97065 */
     14,   5,  12,   7,  31,  12,   1,   7,  30,   0,  /* "cyclicals" 97075 */
     14,  39,  12,   1,   7,  31,  32,   0,  /* "cycling" 97083 */
     14,  39,  12,   1,   7,   1,  14,   3,   0,  /* "cyclist" 97092 */
     14,  39,  12,   1,   7,   1,  14,   3,  14,   0,  /* "cyclists" 97102 */
     14,  39,  12,   7,   1,  38,  21,  12,  14,  28,  13,   0,  /* "cyclohexane" 97114 */
     14,  31,  12,   7,  25,  13,   0,  /* "cyclone" 97121 */
     14,  31,  12,   7,  25,  13,  30,   0,  /* "cyclones" 97129 */
     14,  39,  12,   7,   1,   6,  23,   1,  13,   0,  /* "cyclopean" 97139 */
     14,  39,  12,   7,  18,   6,  14,   0,  /* "cyclops" 97147 */
     14,  31,  12,   7,  18,  14,   6,  10,  23,  13,   0,  /* "cyclosporine" 97158 */
     14,  39,  12,   7,   1,  14,   3,  25,  17,   0,  /* "cyclostome" 97168 */
     14,  39,  12,   7,   1,  14,   3,  25,  17,  30,   0,  /* "cyclostomes" 97179 */
     14,   5,  12,   1,   7,  10,   0,  /* "cycolor" 97186 */
     14,   5,  20,   0,  /* "cyd" 97190 */
     14,   1,  20,  25,  13,  26,   1,   0,  /* "cydonia" 97198 */
     14,   1,  20,   4,  25,  17,   0,  /* "cydrome" 97205 */
     14,  39,  11,   1,  13,   0,  /* "cygan" 97211 */
     14,   5,  11,  13,   1,   0,  /* "cygne" 97217 */
     14,  39,  38,  21,  12,  14,   1,   3,   1,  13,   0,  /* "cyhexatin" 97228 */
     14,   5,   7,   1,  13,  20,  10,   0,  /* "cylinder" 97236 */
     14,   5,   7,   1,  13,  20,  10,  30,   0,  /* "cylinders" 97245 */
     14,   1,   7,   5,  13,  20,   4,  31,  12,   1,   7,   0,  /* "cylindrical" 97257 */
     12,   5,  13,   8,   4,   1,   0,  /* "cynara" 97264 */
     14,   5,  13,  31,  12,   1,   7,  26,   0,  /* "cynically" 97273 */
     14,   5,  13,   1,  14,   5,  30,   1,  17,   0,  /* "cynicism" 97283 */
     14,   5,  13,  47,   1,  20,   0,  /* "cynwyd" 97290 */
     14,  39,   6,  10,   3,   0,  /* "cypert" 97296 */
     14,  39,  37,  10,   0,  /* "cypher" 97301 */
     14,  39,  37,  10,  30,   0,  /* "cyphers" 97307 */
     14,  39,  37,  10,   3,   0,  /* "cyphert" 97313 */
     14,  39,   6,   4,   1,  14,   0,  /* "cypress" 97320 */
     14,   5,   6,   4,  26,   1,  13,   0,  /* "cyprian" 97328 */
     14,   5,   6,   4,  26,   1,   3,   0,  /* "cypriot" 97336 */
     14,   5,   6,   4,  26,   1,   3,  14,   0,  /* "cypriots" 97345 */
     14,  39,   6,   4,   5,  14,   0,  /* "cypris" 97352 */
     14,  39,   6,   4,   1,  14,   0,  /* "cyprus" 97359 */
     14,   5,   4,   0,  /* "cyr" 97363 */
     12,   5,   4,   1,  13,   0,  /* "cyran" 97369 */
     12,  26,   4,   8,  13,  27,   0,  /* "cyrano" 97376 */
     12,  31,   4,  23,  13,   1,   0,  /* "cyrena" 97383 */
     14,   5,   4,   1,   7,   0,  /* "cyril" 97389 */
     14,  31,   4,   5,   7,   1,   0,  /* "cyrilla" 97396 */
     14,  10,   5,   7,  31,  12,   0,  /* "cyrillic" 97403 */
     14,  39,   4,   5,  12,  14,   0,  /* "cyrix" 97410 */
     14,  39,   4,   1,  14,   0,  /* "cyrus" 97416 */
     14,   5,  14,   3,   0,  /* "cyst" 97421 */
     14,   5,  16,  10,  23,   1,   0,  /* "cytherea" 97428 */
     14,  39,   3,  27,  40,  15,  13,   0,  /* "cytogen" 97436 */
     14,  39,   3,   8,   7,   1,  40,  26,   0,  /* "cytology" 97445 */
     14,  39,   3,   1,  17,  21,  11,   1,   7,  27,  22,  39,   4,   1,  14,   0,  /* "cytomegalovirus" 97461 */
     14,  39,   3,   1,   6,   7,  24,  30,   1,  17,   0,  /* "cytoplasm" 97472 */
     14,  39,   3,   1,   6,   7,  24,  30,  17,  31,  12,   0,  /* "cytoplasmic" 97484 */
     14,  39,   3,  27,   3,  21,  12,   0,  /* "cytotech" 97492 */
     14,  39,   3,  27,   3,  21,  12,  14,   0,  /* "cytotechs" 97501 */
     12,  31,  22,   5,  13,  14,  12,  26,   0,  /* "cywinski" 97510 */
     42,  39,   1,   0,  /* "czaja" 97514 */
     42,  39,  12,   1,   0,  /* "czajka" 97519 */
     42,  39,  12,  18,  37,  14,  12,  26,   0,  /* "czajkowski" 97528 */
     42,   1,   6,   7,  21,  37,  14,  12,  26,   0,  /* "czaplewski" 97538 */
     42,   1,   6,   7,   5,   3,  14,  12,  26,   0,  /* "czaplicki" 97548 */
     30,   8,   4,   0,  /* "czar" 97552 */
     30,   8,   4,   5,  14,   3,   0,  /* "czarist" 97559 */
     42,  10,  13,  21,   3,  14,  12,  26,   0,  /* "czarnecki" 97568 */
     42,   8,   4,  13,  26,   0,  /* "czarny" 97574 */
     30,   8,   4,  30,   0,  /* "czars" 97579 */
     42,  21,  12,   1,  14,   7,  25,  22,  19,  12,   0,  /* "czechoslovak" 97590 */
     42,  21,  42,   1,  14,   7,  27,  22,   8,  12,  26,   1,  13,   0,  /* "czechoslovakian" 97604 */
     42,  21,  12,   1,  14,   7,  25,  22,  19,  12,  14,   0,  /* "czechoslovaks" 97616 */
     42,   1,  38,  18,  37,  14,  12,  26,   0,  /* "czechowski" 97625 */
     42,  21,  12,   1,  40,  29,  14,  12,  26,   0,  /* "czekajewski" 97635 */
     42,  10,  22,   5,  13,  14,  12,  26,   0,  /* "czerwinski" 97644 */
     42,  10,  22,   8,  32,  12,   1,   0,  /* "czerwonka" 97652 */
     42,  15,  14,   7,  18,   0,  /* "czeslaw" 97658 */
     42,   5,  30,   0,  /* "czyz" 97662 */
     42,   5,  30,  21,  37,  14,  12,  26,   0,  /* "czyzewski" 97671 */
     20,  23,   0,  /* "d" 97674 */
     20,   8,   0,  /* "da" 97677 */
     20,  24,   9,   0,  /* "dab" 97681 */
     20,  24,   9,   1,   0,  /* "dabah" 97686 */
     20,  24,   9,   1,   7,   0,  /* "dabble" 97692 */
     20,  24,   9,   1,   7,  20,   0,  /* "dabbled" 97699 */
     20,  24,   9,   1,   7,  30,   0,  /* "dabbles" 97706 */
     20,  24,   9,   1,   7,  31,  32,   0,  /* "dabbling" 97714 */
     20,  24,   9,  27,   7,   0,  /* "dabhol" 97720 */
     20,   1,   9,  12,  18,  37,  14,  12,  26,   0,  /* "dabkowski" 97730 */
     20,  24,  12,   0,  /* "dac" 97734 */
     20,   2,  14,   0,  /* "dace" 97738 */
     20,   8,  42,   1,   0,  /* "dacha" 97743 */
     20,  24,  12,  52,   0,  /* "dachau" 97748 */
     20,   8,  12,  14,  38,  45,  13,  20,   0,  /* "dachshund" 97757 */
     20,   8,  12,  14,  38,  45,  13,   3,  14,   0,  /* "dachshunds" 97767 */
     20,   2,  33,  26,   1,   0,  /* "dacia" 97773 */
     20,  24,  12,   0,  /* "dack" 97777 */
     20,  19,  12,  25,  14,   3,   1,   0,  /* "dacosta" 97785 */
     20,  24,  12,   4,   8,  13,   0,  /* "dacron" 97792 */
     20,   8,  12,   4,  29,  30,   0,  /* "dacruz" 97799 */
     20,  24,  12,  14,   0,  /* "dacs" 97804 */
     20,   2,  14,  26,   0,  /* "dacy" 97809 */
     20,  24,  20,   0,  /* "dad" 97813 */
     20,   8,  20,   8,   0,  /* "dada" 97818 */
     20,  19,  20,   8,   4,  26,  27,   0,  /* "daddario" 97826 */
     20,  19,  20,  25,  13,   1,   0,  /* "daddona" 97833 */
     20,   2,  20,   0,  /* "dade" 97837 */
     20,   2,  20,   7,   1,  13,  20,   0,  /* "dadeland" 97845 */
     20,  24,  20,  37,   8,   4,   0,  /* "dadfar" 97852 */
     20,   2,  20,  25,   0,  /* "dado" 97857 */
     20,  24,  20,  30,   0,  /* "dads" 97862 */
     20,   2,  20,  26,   0,  /* "dady" 97867 */
     20,   2,   0,  /* "dae" 97870 */
     20,  21,  20,   1,   7,   1,  14,   0,  /* "daedalus" 97878 */
     20,   2,   7,  23,  17,   0,  /* "daelim" 97884 */
     20,  23,  17,   1,  13,   0,  /* "daemon" 97890 */
     20,   2,  47,  29,   0,  /* "daewoo" 97895 */
     20,  24,  37,  26,  13,   5,  33,   1,  13,   0,  /* "daffynition" 97905 */
     20,  24,  37,  27,   0,  /* "dafoe" 97910 */
     20,  24,  37,   3,   0,  /* "daft" 97915 */
     20,  24,  11,   0,  /* "dag" 97919 */
     20,  24,  43,   1,  13,  28,   0,  /* "dagenais" 97926 */
     20,  24,  11,   1,  13,  38,  24,  17,   0,  /* "dagenham" 97935 */
     20,  24,  11,  15,  14,   3,  24,  13,   0,  /* "dagestan" 97944 */
     20,  24,  11,   0,  /* "dagg" 97948 */
     20,  24,  11,   1,   3,   0,  /* "daggett" 97954 */
     20,   2,  11,   1,   7,   0,  /* "dagle" 97960 */
     20,   2,  11,   1,  13,   0,  /* "dagon" 97966 */
     20,  19,  11,  27,  14,   3,  23,  13,  27,   0,  /* "dagostino" 97976 */
     20,   8,  11,   0,  /* "dague" 97980 */
     20,  35,   0,  /* "dah" 97983 */
     20,   8,  10,   0,  /* "daher" 97987 */
     20,   8,  38,   5,   7,   0,  /* "dahill" 97993 */
     20,   8,   7,   0,  /* "dahl" 97997 */
     20,   8,   1,   7,   0,  /* "dahle" 98002 */
     20,  24,   7,  11,   4,  15,  13,   0,  /* "dahlgren" 98010 */
     20,   8,   7,  38,  39,  17,  10,   0,  /* "dahlheimer" 98018 */
     20,  24,   7,  41,   1,   0,  /* "dahlia" 98024 */
     20,  24,  17,   0,  /* "dahm" 98028 */
     20,   8,  17,  15,  13,   0,  /* "dahmen" 98034 */
     20,  24,  13,   0,  /* "dahn" 98038 */
     20,  24,  32,  12,   0,  /* "dahnke" 98043 */
     20,   1,   4,   2,  13,   0,  /* "dahrain" 98049 */
     20,  39,   0,  /* "dai" 98052 */
     20,   2,  20,  27,   0,  /* "daido" 98057 */
     20,   2,  20,  25,  13,   0,  /* "daidone" 98063 */
     20,  39,   2,   0,  /* "daiei" 98067 */
     20,   2,  11,   1,   7,   0,  /* "daigle" 98073 */
     20,   2,  11,   7,  10,   0,  /* "daigler" 98079 */
     20,  15,  11,  13,  25,   0,  /* "daignault" 98085 */
     20,  15,  11,  13,  25,   0,  /* "daigneault" 98091 */
     20,   2,  11,   4,   1,   6,  19,  13,   3,   0,  /* "daigrepont" 98101 */
     20,  39,  38,  24,   3,  14,  29,   0,  /* "daihatsu" 98109 */
     20,  39,  23,  42,  26,   0,  /* "daiichi" 98115 */
     20,   2,   7,   0,  /* "dail" 98119 */
     20,   2,   7,  26,  30,   0,  /* "dailies" 98125 */
     20,   2,  13,   0,  /* "dain" 98129 */
     20,  21,   4,  26,  31,  32,   0,  /* "dairying" 98136 */
     20,   2,   4,  26,  17,   1,  13,   0,  /* "dairymen" 98144 */
     20,   2,  30,   0,  /* "dais" 98148 */
     20,   2,  33,  48,   1,   0,  /* "daishowa" 98154 */
     20,   2,  30,  26,   0,  /* "daisy" 98159 */
     20,   2,  47,   1,   0,  /* "daiwa" 98164 */
     20,   2,  40,   1,  13,   0,  /* "dajun" 98170 */
     20,  24,  12,   0,  /* "dak" 98174 */
     20,  19,  12,   8,   4,   0,  /* "dakar" 98180 */
     20,   2,  12,   0,  /* "dake" 98184 */
     20,   1,  12,  25,   3,   1,  13,   0,  /* "dakotan" 98192 */
     20,   1,  12,  25,   3,   1,  13,  30,   0,  /* "dakotans" 98201 */
     20,  24,   7,   0,  /* "dal" 98205 */
     20,  24,   7,   2,   0,  /* "dalai" 98210 */
     20,   2,   7,   1,   7,   0,  /* "dalal" 98216 */
     20,  24,   7,   9,  31,  12,   0,  /* "dalbec" 98223 */
     20,  18,   7,   9,  26,   0,  /* "dalby" 98229 */
     20,   2,   7,   0,  /* "dale" 98233 */
     20,  24,   7,  39,  20,   1,  13,   0,  /* "daleiden" 98241 */
     20,  24,   7,   1,  13,   0,  /* "dalen" 98247 */
     20,   8,   7,  26,  27,   0,  /* "daleo" 98253 */
     20,  19,   7,  15,  14,   8,  13,  20,   4,  27,   0,  /* "dalesandro" 98264 */
     20,   1,   7,  23,  14,  26,  27,   0,  /* "dalesio" 98272 */
     20,  19,   7,  15,  14,   8,  13,  20,   4,  27,   0,  /* "dalessandro" 98283 */
     20,   1,   7,  21,  14,  26,  27,   0,  /* "dalessio" 98291 */
     20,   8,   7,  21,  16,   0,  /* "daleth" 98297 */
     20,  18,   7,  37,  10,   3,   0,  /* "dalfort" 98304 */
     20,  24,   7,  11,  21,   3,  26,   0,  /* "dalgety" 98312 */
     20,  24,   7,  11,   1,   7,   5,  33,   0,  /* "dalgleish" 98321 */
     20,  18,   7,  38,  48,  14,   0,  /* "dalhouse" 98328 */
     20,   8,   7,  26,   0,  /* "dali" 98333 */
     20,   8,   7,  41,   1,   0,  /* "dalia" 98339 */
     20,  34,   7,   1,   9,  21,   4,   3,  26,   0,  /* "daliberti" 98349 */
     20,   1,   7,  39,   7,   1,   0,  /* "dalila" 98356 */
     20,   2,   7,  12,   0,  /* "dalke" 98361 */
     20,  18,   7,   0,  /* "dall" 98365 */
     20,   8,   7,  15,   4,   0,  /* "dallaire" 98371 */
     20,  24,   7,   8,   4,   1,   0,  /* "dallara" 98378 */
     20,  24,   7,   1,  14,   0,  /* "dallas" 98384 */
     20,  18,   7,  38,  25,   7,  20,   0,  /* "dallhold" 98392 */
     20,   8,   7,  17,   1,   0,  /* "dalma" 98398 */
     20,  34,   7,  17,   2,  33,   1,  13,   0,  /* "dalmatian" 98407 */
     20,  34,   7,  17,   2,  33,   1,  13,  30,   0,  /* "dalmatians" 98417 */
     20,  18,   7,  17,  27,   0,  /* "dalmo" 98423 */
     20,   8,   7,  27,   0,  /* "dalo" 98428 */
     20,  19,   7,  25,  41,   1,   0,  /* "daloia" 98435 */
     20,  19,   7,  49,  14,  26,  27,   0,  /* "daloisio" 98443 */
     20,   2,   7,   6,   0,  /* "dalpe" 98448 */
     20,  19,   7,   6,  23,  19,  30,   0,  /* "dalpiaz" 98456 */
     20,  19,   7,   6,  18,   4,   3,  27,   0,  /* "dalporto" 98465 */
     20,  24,   7,   4,   5,  17,   6,   1,   7,   0,  /* "dalrymple" 98475 */
     20,  18,   7,   3,   1,  13,   0,  /* "dalton" 98482 */
     20,  18,   7,   3,   1,  13,  30,   0,  /* "daltons" 98490 */
     20,   2,   7,  26,   0,  /* "daly" 98495 */
     20,  24,   7,  30,  23,   7,   0,  /* "dalziel" 98502 */
     20,  24,  17,   0,  /* "dam" 98506 */
     20,   8,  17,   1,   0,  /* "dama" 98511 */
     20,  24,  17,   1,  12,   7,  26,  13,   0,  /* "damaclean" 98520 */
     20,   2,  17,   1,  13,   0,  /* "daman" 98526 */
     20,   1,  17,   8,   4,   1,  14,   0,  /* "damaris" 98534 */
     20,   1,  17,  24,  14,  12,   1,  14,   0,  /* "damascus" 98543 */
     20,  24,  17,   1,  14,  12,   0,  /* "damask" 98550 */
     20,  24,  17,   1,  14,  12,  14,   0,  /* "damasks" 98558 */
     20,  19,  17,   9,   4,  25,  14,  26,   1,   0,  /* "dambrosia" 98568 */
     20,  24,  17,   9,   4,  25,  14,  26,  27,   0,  /* "dambrosio" 98578 */
     20,   2,  17,   0,  /* "dame" 98582 */
     20,   1,  17,  23,   7,  26,  27,   0,  /* "damelio" 98590 */
     20,  19,  17,  15,   4,  18,  13,   0,  /* "dameron" 98598 */
     20,  24,  17,  11,   8,   4,  20,   0,  /* "damgard" 98606 */
     20,  19,  17,  26,   8,  13,  26,   0,  /* "damiani" 98614 */
     20,  19,  17,  26,   8,  13,  27,   0,  /* "damiano" 98622 */
     20,  19,  17,  23,  12,  27,   0,  /* "damico" 98629 */
     20,   2,  17,  26,   1,  13,   0,  /* "damien" 98636 */
     20,  24,  17,  26,  21,   3,   1,   0,  /* "damietta" 98644 */
     20,  24,  17,   5,  13,   1,  30,  39,  20,   0,  /* "daminozide" 98654 */
     20,  19,  17,  23,   3,   1,   0,  /* "damita" 98661 */
     20,  24,  17,   0,  /* "damm" 98665 */
     20,  24,  17,   1,  17,   0,  /* "dammam" 98671 */
     20,  24,  17,   0,  /* "damn" 98675 */
     20,  34,  17,  13,   2,  33,   1,  13,   0,  /* "damnation" 98684 */
     20,  24,  17,  20,   0,  /* "damned" 98689 */
     20,  24,  17,  31,  32,   0,  /* "damning" 98695 */
     20,  24,  17,   1,  12,   7,  23,  30,   0,  /* "damocles" 98704 */
     20,   2,  17,   1,  13,   0,  /* "damon" 98710 */
     20,   2,  17,   1,  13,  30,   0,  /* "damons" 98717 */
     20,   1,  17,  29,  14,   0,  /* "damoose" 98723 */
     20,   2,  17,  18,   4,   0,  /* "damore" 98729 */
     20,   1,  17,  45,   4,   0,  /* "damour" 98735 */
     20,  24,  17,   6,   0,  /* "damp" 98740 */
     20,  24,  17,   4,  25,   0,  /* "damrow" 98746 */
     20,  24,  17,  30,   0,  /* "dams" 98751 */
     20,  24,  17,  30,   1,   7,   0,  /* "damsel" 98758 */
     20,  24,  13,   0,  /* "dan" 98762 */
     20,   2,  13,   1,   0,  /* "dana" 98767 */
     20,  24,  13,   9,  10,  26,   0,  /* "danbury" 98774 */
     20,   8,  32,  12,   1,   0,  /* "danca" 98780 */
     20,  24,  13,  12,  14,  34,  12,   0,  /* "dancsak" 98788 */
     20,  24,  13,  20,   1,   7,  39,   1,  13,   0,  /* "dandelion" 98798 */
     20,  24,  13,  20,   1,   7,  39,   1,  13,  30,   0,  /* "dandelions" 98809 */
     20,  24,  13,  20,   1,  13,  27,   0,  /* "dandeneau" 98817 */
     20,  24,  13,  20,   4,   1,  37,   0,  /* "dandruff" 98825 */
     20,  24,  13,  20,  10,   1,  13,  20,   0,  /* "dandurand" 98834 */
     20,  24,  13,  20,  26,   5,  30,   1,  17,   0,  /* "dandyism" 98844 */
     20,   2,  13,   0,  /* "dane" 98848 */
     20,  19,  13,   2,  30,  26,   0,  /* "danese" 98855 */
     20,  24,  13,  37,  10,  16,   0,  /* "danforth" 98862 */
     20,  24,  32,   0,  /* "dang" 98866 */
     20,  24,  13,  40,   1,   7,  27,   0,  /* "dangelo" 98874 */
     20,   2,  13,  40,  10,   0,  /* "danger" 98880 */
     20,   2,  13,  40,  10,  37,  23,   7,  20,   0,  /* "dangerfield" 98890 */
     20,   2,  13,  40,  10,   1,  14,   0,  /* "dangerous" 98898 */
     20,   2,  13,  40,  10,   1,  14,   7,  26,   0,  /* "dangerously" 98908 */
     20,   2,  13,  40,  10,  30,   0,  /* "dangers" 98915 */
     20,   2,  13,  40,  29,  30,   0,  /* "dangews" 98922 */
     20,  24,  32,  11,   1,   7,   0,  /* "dangle" 98929 */
     20,  24,  32,  11,   1,   7,  20,   0,  /* "dangled" 98937 */
     20,  24,  32,  11,   1,   7,  10,   0,  /* "dangler" 98945 */
     20,  24,  32,  11,   1,   7,  30,   0,  /* "dangles" 98953 */
     20,  24,  32,  11,   1,   7,  31,  32,   0,  /* "dangling" 98962 */
     20,   8,  13,  26,   0,  /* "dani" 98967 */
     20,   2,  13,  41,   1,   0,  /* "dania" 98973 */
     20,  34,  13,  41,  21,   7,   1,   0,  /* "daniela" 98981 */
     20,  34,  13,  41,  21,   7,   0,  /* "daniele" 98988 */
     20,  24,  13,  41,  21,   7,   1,   0,  /* "daniella" 98996 */
     20,  24,  13,  26,  21,   7,   0,  /* "danielle" 99003 */
     20,  19,  13,  26,  21,   7,  27,   0,  /* "daniello" 99011 */
     20,   1,  13,  23,   7,  14,  12,  26,   0,  /* "danielski" 99020 */
     20,  24,  13,   1,   7,  36,  37,   0,  /* "daniloff" 99028 */
     20,   8,  13,  26,  30,   0,  /* "danis" 99034 */
     20,   2,  13,   5,  33,   0,  /* "danish" 99040 */
     20,  24,  13,  40,  29,   9,   0,  /* "danjub" 99047 */
     20,  24,  13,  40,  29,   9,   0,  /* "danjube" 99054 */
     20,  24,  32,  12,   0,  /* "dank" 99059 */
     20,  24,  13,   0,  /* "dann" 99063 */
     20,  24,  13,   1,  17,  39,   4,   0,  /* "dannemeyer" 99071 */
     20,  19,  13,  29,  13,  30,  26,  27,   0,  /* "dannunzio" 99080 */
     20,   8,  13,  27,   0,  /* "dano" 99085 */
     20,   2,  13,  27,  30,   0,  /* "danos" 99091 */
     20,   1,  13,  18,  37,  14,  12,  26,   0,  /* "danowski" 99100 */
     20,  24,  13,  14,   9,  26,   0,  /* "dansby" 99107 */
     20,  24,  13,  14,  10,  25,   0,  /* "dansereau" 99114 */
     20,  24,  13,  14,  37,  10,  16,   0,  /* "dansforth" 99122 */
     20,  24,  13,   3,   0,  /* "dant" 99127 */
     20,   8,  13,   3,  28,   0,  /* "dante" 99133 */
     20,  19,  13,   3,  25,  13,  26,   0,  /* "dantoni" 99141 */
     20,  19,  13,   3,  47,  25,  13,  27,   0,  /* "dantuono" 99150 */
     20,  24,  13,  41,  29,   9,   0,  /* "danube" 99157 */
     20,  24,  13,   1,   7,  23,  30,   1,  13,   0,  /* "danylyszyn" 99167 */
     20,  24,  13,  30,   0,  /* "danz" 99172 */
     20,  48,   0,  /* "dao" 99175 */
     20,  48,  20,   0,  /* "daoud" 99179 */
     20,  48,  14,   3,   0,  /* "daoust" 99184 */
     20,  24,  37,  13,   1,  14,   0,  /* "daphnis" 99191 */
     20,   8,   6,   5,  14,   0,  /* "dapice" 99197 */
     20,  19,   6,  27,   7,  23,   3,  27,   0,  /* "dapolito" 99206 */
     20,  19,   6,  25,  13,   3,  28,   0,  /* "daponte" 99214 */
     20,   1,   6,   8,  30,  25,   0,  /* "dapozzo" 99221 */
     20,  24,   6,   0,  /* "dapp" 99225 */
     20,   1,   6,  35,  30,  27,   0,  /* "dapuzzo" 99232 */
     20,   8,   4,   0,  /* "dar" 99236 */
     20,  24,   4,   1,   0,  /* "dara" 99241 */
     20,  21,   4,  34,  12,   0,  /* "darak" 99247 */
     20,   8,   4,   9,   7,  28,   0,  /* "darblay" 99254 */
     20,   8,   4,   9,   1,  13,   0,  /* "darbonne" 99261 */
     20,   8,   4,   9,  31,  33,  39,   4,   0,  /* "darbyshire" 99270 */
     20,  19,   4,  12,  19,  32,  11,  21,   7,  27,   0,  /* "darcangelo" 99281 */
     20,   8,   4,  12,  26,   0,  /* "darcie" 99287 */
     20,  19,   4,  20,   8,   4,   0,  /* "dardar" 99294 */
     20,  21,   4,   0,  /* "dare" 99298 */
     20,  21,   4,   1,  17,   9,   7,  29,  17,   0,  /* "daremblum" 99308 */
     20,  24,   4,   1,  13,   0,  /* "daren" 99314 */
     20,  24,   4,   1,  13,  14,   9,  10,  11,   0,  /* "darensbourg" 99324 */
     20,  21,   4,  14,  28,   0,  /* "daresay" 99330 */
     20,   8,   4,  11,   5,  14,   0,  /* "dargis" 99337 */
     20,   8,   4,  26,   1,   0,  /* "daria" 99343 */
     20,   8,   4,   5,  14,   0,  /* "darice" 99349 */
     20,  19,   4,  23,  13,  30,  27,   0,  /* "darienzo" 99357 */
     20,  24,   4,   5,  13,   0,  /* "darin" 99363 */
     20,  21,   4,  26,  25,   0,  /* "dario" 99369 */
     20,  24,   4,   1,   3,  26,   0,  /* "darity" 99376 */
     20,  10,  39,   1,  14,   0,  /* "darius" 99382 */
     20,   8,   4,  12,   0,  /* "dark" 99387 */
     20,   8,   4,  12,   4,  29,  17,   0,  /* "darkroom" 99395 */
     20,   8,   4,   7,  39,  13,   0,  /* "darline" 99402 */
     20,   8,   4,  17,  14,   3,  24,   3,   0,  /* "darmstadt" 99411 */
     20,   8,   4,  13,   0,  /* "darn" 99416 */
     20,   8,   4,  13,  20,  15,  14,   3,   0,  /* "darnedest" 99425 */
     20,  19,   4,  13,  21,   7,   0,  /* "darnell" 99432 */
     20,   8,   4,  13,  25,   7,  20,   0,  /* "darnold" 99440 */
     20,  19,   4,  25,  12,   1,   0,  /* "darocha" 99447 */
     20,  21,   4,   0,  /* "darr" 99451 */
     20,  21,   4,   1,   0,  /* "darragh" 99456 */
     20,  21,   4,   1,   7,   0,  /* "darrell" 99462 */
     20,  10,  21,   7,   0,  /* "darrelle" 99467 */
     20,   8,   4,  23,  11,  27,   0,  /* "darrigo" 99474 */
     20,  24,   4,  52,   0,  /* "darrough" 99479 */
     20,  21,   4,  27,   0,  /* "darrow" 99484 */
     20,   8,   4,   3,   0,  /* "dart" 99489 */
     20,  19,   4,   3,  21,  30,   0,  /* "dartez" 99496 */
     20,   8,   4,  47,   1,  13,   5,  30,   1,  17,   0,  /* "darwinism" 99507 */
     20,  24,  14,   0,  /* "das" 99511 */
     20,   8,  14,   1,   0,  /* "dasa" 99516 */
     20,  19,  14,  42,  21,  13,  30,  27,   0,  /* "dascenzo" 99525 */
     20,  24,  33,   7,  26,   0,  /* "daschle" 99531 */
     20,  19,  14,  12,  25,   7,  26,   0,  /* "dascoli" 99539 */
     20,   2,  30,   0,  /* "dase" 99543 */
     20,   2,  14,   1,  12,  26,   0,  /* "daseke" 99550 */
     20,  24,  33,   0,  /* "dash" 99554 */
     20,   1,  33,  23,  12,  26,   0,  /* "dashiki" 99561 */
     20,  24,  33,  13,  36,   0,  /* "dashnaw" 99567 */
     20,  24,  14,   0,  /* "dass" 99571 */
     20,  24,  14,  36,   7,   3,   0,  /* "dassault" 99578 */
     20,  24,  14,   7,  10,   0,  /* "dassler" 99584 */
     20,  24,  14,  27,   0,  /* "dassow" 99589 */
     20,  24,   3,   0,  /* "dat" 99593 */
     20,   2,   3,   1,   0,  /* "data" 99598 */
     20,   2,   3,   1,   9,   2,  14,   0,  /* "database" 99606 */
     20,   2,   3,   1,   9,   2,  14,   1,  30,   0,  /* "databases" 99616 */
     20,   2,   3,   1,  12,   8,   6,  26,   0,  /* "datacopy" 99625 */
     20,   2,   3,   1,  11,   4,  24,  37,  31,  12,  14,   0,  /* "datagraphix" 99637 */
     20,   2,   3,   1,   6,  48,   4,   0,  /* "datapower" 99645 */
     20,   2,   3,   1,   6,   4,   8,  20,   1,  12,   3,  14,   0,  /* "dataproducts" 99658 */
     20,   2,   3,  10,  21,  12,  14,   0,  /* "datarex" 99666 */
     20,   2,   3,   1,  30,   0,  /* "datas" 99672 */
     20,   2,   3,   0,  /* "date" 99676 */
     20,   2,   3,   7,  39,  13,   0,  /* "dateline" 99683 */
     20,   2,   3,   7,  39,  13,  30,   0,  /* "datelines" 99691 */
     20,  24,   3,  21,  12,  14,   3,   0,  /* "datext" 99699 */
     20,   8,   3,  27,   0,  /* "dato" 99704 */
     20,  24,   3,  14,   0,  /* "dats" 99709 */
     20,  19,   3,  23,   7,  26,  27,   0,  /* "dattilio" 99717 */
     20,  19,   3,  23,   7,  27,   0,  /* "dattilo" 99724 */
     20,   8,   3,  29,  12,   0,  /* "datuk" 99730 */
     20,   1,   3,  45,   4,   1,   0,  /* "datura" 99737 */
     20,  24,   3,  14,   0,  /* "datz" 99742 */
     20,  25,   0,  /* "dau" 99745 */
     20,  18,   9,   0,  /* "daub" 99749 */
     20,  18,   9,   0,  /* "daube" 99753 */
     20,  18,   9,  20,   0,  /* "daubed" 99758 */
     20,  48,  42,   0,  /* "dauch" 99762 */
     20,  25,  20,   1,   7,  34,  13,   0,  /* "daudelin" 99770 */
     20,  48,   1,  13,  38,  52,  10,   0,  /* "dauenhauer" 99778 */
     20,  25,  37,  35,  14,  12,  26,   0,  /* "daufuskie" 99786 */
     20,  36,  21,  13,   9,  36,   0,  /* "daughenbaugh" 99793 */
     20,   8,  12,  10,   3,  26,   0,  /* "daugherty" 99800 */
     20,  18,   3,   4,  31,  40,   0,  /* "daughtridge" 99807 */
     20,  18,   7,   0,  /* "daul" 99811 */
     20,  18,   7,   3,   0,  /* "dault" 99816 */
     20,  18,  17,   0,  /* "daum" 99820 */
     20,  18,  13,   0,  /* "daun" 99824 */
     20,  48,  37,   5,  13,   0,  /* "dauphin" 99830 */
     20,  25,  37,   1,  13,  28,   0,  /* "dauphinais" 99837 */
     20,  36,  37,   1,  13,  23,   0,  /* "dauphinee" 99844 */
     20,  18,  30,   0,  /* "daus" 99848 */
     20,  48,  14,   3,  10,   0,  /* "dauster" 99854 */
     20,  25,   3,  10,  31,  22,   0,  /* "dauterive" 99861 */
     20,  48,  30,   1,   3,   0,  /* "dauzat" 99867 */
     20,  19,  22,   8,   7,  27,  30,   0,  /* "davalos" 99875 */
     20,   1,  22,  24,  13,  30,  27,   0,  /* "davanzo" 99883 */
     20,   1,  22,  25,   0,  /* "davao" 99888 */
     20,   1,  22,  25,   0,  /* "davault" 99893 */
     20,   2,  22,   0,  /* "dave" 99897 */
     20,  24,  22,   1,  13,   6,  18,   4,   3,   0,  /* "davenport" 99907 */
     20,  24,  22,  10,  13,   0,  /* "davern" 99913 */
     20,  19,  22,  21,   4,  14,   1,   0,  /* "daversa" 99921 */
     20,   8,  22,  26,   0,  /* "davi" 99926 */
     20,   8,  22,  26,   1,   0,  /* "davia" 99932 */
     20,  19,  22,  23,  20,   1,   0,  /* "davida" 99939 */
     20,  35,  22,  23,  20,   2,   0,  /* "davide" 99946 */
     20,  24,  22,  31,  40,   0,  /* "davidge" 99952 */
     20,   1,  22,   5,  20,  26,   1,  13,   0,  /* "davidian" 99961 */
     20,   1,  22,   5,  20,  26,   1,  13,  30,   0,  /* "davidians" 99971 */
     20,   2,  22,   1,  20,  36,  37,   0,  /* "davidoff" 99979 */
     20,  24,  22,   1,  20,  27,   0,  /* "davidow" 99986 */
     20,  19,  22,  26,  11,  13,  18,  13,   0,  /* "davignon" 99995 */
     20,  19,  22,  23,  13,   1,   0,  /* "davina" 100002 */
     20,  19,  22,  23,  13,  27,   0,  /* "davino" 100009 */
     20,   2,  22,   1,  14,   0,  /* "davis" 100015 */
     20,  24,  22,   1,  14,   1,  13,   0,  /* "davisson" 100023 */
     20,   1,  22,   5,   3,   0,  /* "davitt" 100029 */
     20,  24,  22,  19,  12,  14,   0,  /* "davox" 100036 */
     20,   2,  22,  26,   0,  /* "davy" 100041 */
     20,   2,  22,   1,  20,  18,  22,   0,  /* "davydov" 100049 */
     20,  18,   0,  /* "daw" 100052 */
     20,  18,  20,   1,   7,   0,  /* "dawdle" 100058 */
     20,  18,   0,  /* "dawe" 100061 */
     20,  24,  47,   5,   3,   0,  /* "dawit" 100067 */
     20,  18,  13,   0,  /* "dawn" 100071 */
     20,  18,  30,   0,  /* "daws" 100075 */
     20,  18,  14,  26,   0,  /* "dawsey" 100080 */
     20,  24,  12,  14,   0,  /* "dax" 100085 */
     20,  24,  12,  14,  10,   0,  /* "daxor" 100091 */
     20,   2,   0,  /* "day" 100094 */
     20,  39,   1,   0,  /* "daya" 100098 */
     20,   2,   1,  13,   0,  /* "dayan" 100103 */
     20,   2,   9,   4,   2,  12,   0,  /* "daybreak" 100110 */
     20,   2,   0,  /* "daye" 100113 */
     20,   2,  38,  35,  37,   0,  /* "dayhuff" 100119 */
     20,   2,   7,  39,   3,   0,  /* "daylight" 100125 */
     20,   2,   7,  39,   3,  14,   0,  /* "daylights" 100132 */
     20,   2,  30,   0,  /* "days" 100136 */
     20,   2,   3,  39,  17,   0,  /* "daytime" 100142 */
     20,   2,   3,  39,  17,  30,   0,  /* "daytimes" 100149 */
     20,  28,   3,  25,  13,   1,   0,  /* "daytona" 100156 */
     20,   2,  30,   0,  /* "daze" 100160 */
     20,   8,  14,   0,  /* "dazs" 100164 */
     20,  24,  30,   1,   7,   0,  /* "dazzle" 100170 */
     20,  24,  30,   1,   7,  20,   0,  /* "dazzled" 100177 */
     20,  24,  30,   1,   7,  31,  32,   0,  /* "dazzling" 100185 */
     20,  23,   9,   2,  14,   0,  /* "dbase" 100191 */
     20,  23,  20,  23,   3,  23,   0,  /* "ddt" 100198 */
     20,  23,   0,  /* "de" 100201 */
     20,  23,   0,  /* "dea" 100204 */
     20,  23,  12,   1,  13,   1,  14,   0,  /* "deaconess" 100212 */
     20,  23,  12,   1,  13,  30,   0,  /* "deacons" 100219 */
     20,  23,  24,  12,   3,  31,  22,   2,   3,   0,  /* "deactivate" 100229 */
     20,  23,  24,  12,   3,  31,  22,   2,   3,   1,  20,   0,  /* "deactivated" 100241 */
     20,  21,  20,   0,  /* "dead" 100245 */
     20,  21,  20,   7,  39,  13,   0,  /* "deadline" 100252 */
     20,  21,  20,   7,  39,  13,  30,   0,  /* "deadlines" 100260 */
     20,  21,  20,   7,  26,  13,   1,  14,   0,  /* "deadliness" 100269 */
     20,  21,  20,  47,  39,   7,  10,   0,  /* "deadwyler" 100277 */
     20,  21,  37,   0,  /* "deaf" 100281 */
     20,  23,  12,   0,  /* "deak" 100285 */
     20,  23,   7,   0,  /* "deal" 100289 */
     20,  23,  24,   7,   9,   1,   0,  /* "dealba" 100296 */
     20,  23,   7,  10,   7,  39,  13,   0,  /* "dealerline" 100304 */
     20,   1,   7,  17,  23,  20,   1,   0,  /* "dealmeida" 100312 */
     20,  23,  17,   0,  /* "deam" 100316 */
     20,  23,  13,   0,  /* "dean" 100320 */
     20,  23,  24,  13,  20,   1,   0,  /* "deanda" 100327 */
     20,   1,  13,  20,   4,   8,  20,  26,   0,  /* "deandrade" 100336 */
     20,  24,  20,   4,  26,   1,   0,  /* "deandrea" 100343 */
     20,  23,  13,   0,  /* "deane" 100347 */
     20,  23,  13,  10,   0,  /* "deaner" 100352 */
     20,  26,  24,  13,  40,   1,   7,   1,  14,   0,  /* "deangelis" 100362 */
     20,   1,  32,  11,  21,   7,  27,   0,  /* "deangelo" 100370 */
     20,  23,  13,  30,   0,  /* "deans" 100375 */
     20,   5,   4,   0,  /* "dear" 100379 */
     20,   5,   4,   9,  18,   4,  13,   0,  /* "dearborn" 100387 */
     20,   5,   4,  20,  18,   4,  37,   0,  /* "deardorff" 100395 */
     20,   5,   4,  20,  18,   4,  37,   0,  /* "deardourff" 100403 */
     20,   5,   4,   1,  14,   3,   0,  /* "dearest" 100410 */
     20,   5,   4,   7,  26,   0,  /* "dearly" 100416 */
     20,   5,   4,  17,   1,  13,   0,  /* "dearman" 100423 */
     20,  44,  17,   1,  30,   0,  /* "dearmas" 100429 */
     20,   5,   4,  17,   1,  13,   3,   0,  /* "dearment" 100437 */
     20,  23,  30,   0,  /* "deas" 100441 */
     20,  23,  14,   0,  /* "dease" 100445 */
     20,  23,  14,  26,   0,  /* "deasy" 100450 */
     20,  21,  16,   9,  21,  20,   0,  /* "deathbed" 100457 */
     20,  21,  16,  10,  31,  40,   0,  /* "deatherage" 100464 */
     20,  21,  16,  33,  36,   3,   0,  /* "deathshot" 100471 */
     20,   1,  22,  23,   7,   1,   0,  /* "deavila" 100478 */
     20,  21,   9,   0,  /* "deb" 100482 */
     20,  23,   9,  34,  12,  10,   0,  /* "debacker" 100489 */
     20,   1,   9,   8,  12,   1,   7,   0,  /* "debacle" 100497 */
     20,  28,   9,   8,  12,   1,   7,  30,   0,  /* "debacles" 100506 */
     20,   5,   9,  24,   4,   0,  /* "debarr" 100512 */
     20,  28,   9,   8,   4,  27,  30,   0,  /* "debarros" 100520 */
     20,   1,   9,   8,   4,   3,   1,   7,  27,  30,   0,  /* "debartolos" 100531 */
     20,   1,   9,   2,  14,  31,  32,   0,  /* "debasing" 100539 */
     20,   1,   9,   2,   3,   1,   9,   1,   7,   0,  /* "debatable" 100549 */
     20,   1,   9,   2,   3,  10,   0,  /* "debater" 100556 */
     20,   1,   9,   2,   3,  10,  30,   0,  /* "debaters" 100564 */
     20,  26,   9,   2,   3,  10,   0,  /* "debator" 100571 */
     20,  21,   9,  52,  12,   0,  /* "debauche" 100577 */
     20,   1,   9,  18,  42,  10,  26,   0,  /* "debauchery" 100585 */
     20,  21,   9,  52,  13,   0,  /* "debaun" 100591 */
     20,  21,   9,  31,   4,   0,  /* "debeer" 100597 */
     20,   1,   9,   5,   4,  30,   0,  /* "debeers" 100604 */
     20,  23,   9,  15,   7,   0,  /* "debell" 100610 */
     20,   1,   9,  21,   7,   1,   0,  /* "debella" 100617 */
     20,  21,   9,   1,   7,   1,  14,   0,  /* "debellis" 100625 */
     20,   1,   9,  21,   7,  27,   0,  /* "debello" 100632 */
     20,   5,   9,  15,  13,   1,  20,  21,   3,  27,   0,  /* "debenedetto" 100643 */
     20,  21,   9,  15,  13,   1,  20,  31,  12,   3,   1,  14,   0,  /* "debenedictis" 100656 */
     20,   1,   9,  21,  13,  42,  10,   0,  /* "debenture" 100664 */
     20,   1,   9,  21,  13,  42,  10,  30,   0,  /* "debentures" 100673 */
     20,   5,   9,  10,  13,   8,   4,  20,  26,   0,  /* "debernardi" 100683 */
     20,  23,   9,  15,   4,  26,   0,  /* "deberry" 100690 */
     20,  23,   9,  30,   0,  /* "debes" 100695 */
     20,  21,   9,  15,  22,  47,   8,  30,   0,  /* "debevoise" 100704 */
     20,  21,   9,  26,   0,  /* "debi" 100709 */
     20,   5,   9,  26,   8,  14,  26,   0,  /* "debiase" 100717 */
     20,  21,   9,   5,   3,   0,  /* "debit" 100723 */
     20,   5,   9,   7,  24,  32,  12,   0,  /* "deblanc" 100731 */
     20,  21,   9,   7,  29,   0,  /* "deblois" 100737 */
     20,  21,   9,  13,   1,  17,   0,  /* "debnam" 100744 */
     20,  23,   9,  27,   0,  /* "debo" 100749 */
     20,  23,   9,  36,   4,  20,   0,  /* "deboard" 100756 */
     20,   1,   9,  25,   0,  /* "deboe" 100761 */
     20,  23,   9,  27,  10,   0,  /* "deboer" 100767 */
     20,  23,   9,  27,  10,  30,   0,  /* "deboers" 100774 */
     20,  21,   9,  27,   7,  20,   0,  /* "debold" 100781 */
     20,  21,   9,  27,   7,   3,   0,  /* "debolt" 100788 */
     20,  21,   9,   1,  13,  21,   4,   0,  /* "debonair" 100796 */
     20,  21,   9,   1,  13,   5,  14,   0,  /* "debonis" 100804 */
     20,  21,   9,  36,   4,   0,  /* "debor" 100810 */
     20,  21,   9,   4,   1,   0,  /* "debora" 100816 */
     20,  21,   9,  10,   1,   0,  /* "deborah" 100822 */
     20,   5,   9,  18,   4,  20,   0,  /* "debord" 100829 */
     20,   5,   9,  18,   4,  20,   0,  /* "deborde" 100836 */
     20,  21,   9,   1,  14,   0,  /* "debose" 100842 */
     20,   5,   9,  49,   0,  /* "deboy" 100847 */
     20,  21,   9,   4,   1,   0,  /* "debra" 100853 */
     20,   1,   9,   4,   8,  20,  47,  31,  12,   0,  /* "debraudwick" 100863 */
     20,   1,   9,   4,  23,  37,   0,  /* "debrief" 100870 */
     20,   1,   9,   4,  23,  37,   3,   0,  /* "debriefed" 100878 */
     20,   1,   9,   4,  23,  37,  31,  32,   0,  /* "debriefing" 100887 */
     20,   1,   9,   4,  23,   0,  /* "debris" 100893 */
     20,  21,   9,   4,   1,   7,   0,  /* "debruhl" 100900 */
     20,  21,   9,   4,  29,   1,  13,   0,  /* "debruin" 100908 */
     20,  21,   9,   4,  29,   7,  10,   0,  /* "debruler" 100916 */
     20,  21,   9,   4,  39,  13,   0,  /* "debruyn" 100923 */
     20,  21,   9,   4,  39,  13,   0,  /* "debruyne" 100930 */
     20,  21,   9,  30,   0,  /* "debs" 100935 */
     20,  21,   3,   0,  /* "debt" 100939 */
     20,  21,   3,  38,  25,   7,  20,  10,   0,  /* "debtholder" 100948 */
     20,  21,   3,  38,  25,   7,  20,  10,  30,   0,  /* "debtholders" 100958 */
     20,  26,   9,  35,  11,   0,  /* "debug" 100964 */
     20,  26,   9,  35,  11,  31,  32,   0,  /* "debugging" 100972 */
     20,  21,   9,  51,   4,   0,  /* "debuhr" 100978 */
     20,   1,   9,  35,  32,  12,   0,  /* "debunk" 100985 */
     20,   1,   9,  35,  32,  12,   3,   0,  /* "debunked" 100993 */
     20,   1,   9,  35,  32,  12,  31,  32,   0,  /* "debunking" 101002 */
     20,  21,   9,   1,  14,  12,   0,  /* "debusk" 101009 */
     20,  15,   9,  35,  14,  26,   0,  /* "debussy" 101016 */
     20,  28,   9,  41,  29,   0,  /* "debut" 101022 */
     20,  21,   9,  41,   1,   3,   8,  13,   3,   0,  /* "debutante" 101032 */
     20,  21,   9,  41,   1,   3,   8,  13,   3,  14,   0,  /* "debutantes" 101043 */
     20,  28,   9,  41,  29,  20,   0,  /* "debuted" 101050 */
     20,  28,   9,  41,  29,  31,  32,   0,  /* "debuting" 101058 */
     20,   2,   9,  41,  29,  30,   0,  /* "debuts" 101065 */
     20,  21,  12,   0,  /* "dec" 101069 */
     20,  15,  12,   2,  20,   0,  /* "decade" 101075 */
     20,  21,  12,   1,  20,   1,  13,  14,   0,  /* "decadence" 101084 */
     20,  21,  12,   1,  20,   1,  13,   3,   0,  /* "decadent" 101093 */
     20,  15,  12,   2,  20,  30,   0,  /* "decades" 101100 */
     20,  23,  12,  34,  37,   0,  /* "decaf" 101106 */
     20,  26,  12,  24,  37,   1,  13,   2,   3,   0,  /* "decaffeinate" 101116 */
     20,  26,  12,  24,  37,   1,  13,   2,   3,   1,  20,   0,  /* "decaffeinated" 101128 */
     20,  26,  12,  24,  37,   1,  13,   2,   3,  31,  32,   0,  /* "decaffeinating" 101140 */
     20,  26,  12,  24,  37,   1,  13,   2,  33,   1,  13,   0,  /* "decaffeination" 101152 */
     20,  23,  12,  15,   4,   0,  /* "decaire" 101158 */
     20,  23,  12,  24,   7,  30,   0,  /* "decals" 101165 */
     20,  21,  12,   1,  17,   5,   7,  27,   0,  /* "decamillo" 101174 */
     20,   1,  12,  24,  17,   6,   0,  /* "decamp" 101181 */
     20,  26,  12,  24,  17,   6,   3,   0,  /* "decamped" 101189 */
     20,  31,  12,   8,  13,  20,  26,   1,   0,  /* "decandia" 101198 */
     20,   1,  12,  24,  13,   3,   0,  /* "decant" 101205 */
     20,   1,  12,  24,  13,   3,  31,  32,   0,  /* "decanting" 101214 */
     20,  26,  12,  24,   6,   1,   3,   2,   3,   0,  /* "decapitate" 101224 */
     20,  26,  12,  24,   6,   1,   3,   2,   3,   1,  20,   0,  /* "decapitated" 101236 */
     20,  31,  12,   8,   6,   4,  26,  27,   0,  /* "decaprio" 101245 */
     20,  31,  12,  19,   6,  29,   1,   0,  /* "decapua" 101253 */
     20,  31,  12,  24,   1,  22,   1,   0,  /* "decarava" 101261 */
     20,  21,  12,  10,   1,   7,   5,  14,   0,  /* "decarolis" 101270 */
     20,  26,  12,  24,  16,   7,  26,   3,   0,  /* "decathlete" 101279 */
     20,  26,  12,  24,  16,   7,  36,  13,   0,  /* "decathlon" 101288 */
     20,  31,  12,   2,   3,  10,   0,  /* "decatur" 101295 */
     20,   1,  12,   2,   0,  /* "decay" 101300 */
     20,   1,  12,   2,  20,   0,  /* "decayed" 101306 */
     20,   1,  12,   2,  31,  32,   0,  /* "decaying" 101313 */
     20,   1,  12,   2,  30,   0,  /* "decays" 101319 */
     20,   1,  42,  21,  12,  27,   0,  /* "dececco" 101326 */
     20,  15,  14,  23,  20,   1,  13,   3,   0,  /* "decedent" 101335 */
     20,  15,  14,  23,  20,   1,  13,   3,  14,   0,  /* "decedents" 101345 */
     20,   5,  14,  21,   7,   0,  /* "decelle" 101351 */
     20,  21,  14,   1,   7,  30,   0,  /* "decelles" 101358 */
     20,   1,  14,  21,  17,   9,  10,   0,  /* "december" 101366 */
     20,  23,  14,   1,  13,  14,  26,   0,  /* "decency" 101374 */
     20,  23,  14,   1,  13,   3,   0,  /* "decent" 101381 */
     20,  23,  14,   1,  13,   3,   7,  26,   0,  /* "decently" 101390 */
     20,   1,  14,  21,  13,   3,   4,   1,   7,  39,  30,   0,  /* "decentralize" 101402 */
     20,   1,  14,  21,  13,   3,   4,   1,   7,  39,  30,  20,   0,  /* "decentralized" 101415 */
     20,   1,  14,  21,  13,   3,   4,   1,   7,  39,  30,  31,  32,   0,  /* "decentralizing" 101429 */
     20,  26,  14,  44,   3,   1,  37,   1,  12,   2,  33,   1,  13,   0,  /* "decertification" 101443 */
     20,  26,  14,  44,   3,   1,  37,  39,  20,   0,  /* "decertified" 101453 */
     20,  26,  14,  44,   3,   1,  37,  39,   0,  /* "decertify" 101462 */
     20,   1,  42,  15,  14,   8,   4,  26,   0,  /* "decesare" 101471 */
     20,   1,  14,  21,  14,  10,   1,  14,   0,  /* "decesaris" 101480 */
     20,  21,  12,   0,  /* "dech" 101484 */
     20,   2,  42,   1,  13,   3,   0,  /* "dechant" 101491 */
     20,  21,  12,  15,   7,   1,  14,   0,  /* "dechellis" 101499 */
     20,  21,  12,  26,  13,   0,  /* "dechene" 101505 */
     20,  21,  42,  10,  20,   0,  /* "decherd" 101511 */
     20,  21,  42,   5,  13,   0,  /* "dechine" 101517 */
     20,   1,  12,   4,   5,  14,   3,  19,  37,  10,   0,  /* "dechristopher" 101528 */
     20,  21,  14,   1,   9,  21,   7,   0,  /* "decibel" 101536 */
     20,  21,  14,   1,   9,   1,   7,  30,   0,  /* "decibels" 101545 */
     20,   1,  42,  23,  12,  27,   0,  /* "decicco" 101552 */
     20,   1,  14,  39,  20,   0,  /* "decide" 101558 */
     20,   1,  14,  39,  20,   1,  20,   0,  /* "decided" 101566 */
     20,   1,  14,  39,  20,   1,  20,   7,  26,   0,  /* "decidedly" 101576 */
     20,   1,  14,  39,  20,  30,   0,  /* "decides" 101583 */
     20,   1,  14,  39,  20,  31,  32,   0,  /* "deciding" 101591 */
     20,   1,  14,   5,  40,  29,   1,  14,   0,  /* "deciduous" 101600 */
     20,  21,  14,   1,   7,  23,   3,  10,   0,  /* "deciliter" 101609 */
     20,  31,  42,  23,  17,   1,   0,  /* "decima" 101616 */
     20,   1,  14,  39,  37,  10,   0,  /* "decipher" 101623 */
     20,   1,  14,  39,  37,  10,  20,   0,  /* "deciphered" 101631 */
     20,   1,  14,  39,  37,  10,  31,  32,   0,  /* "deciphering" 101640 */
     20,   1,  14,  39,  14,  31,  22,   0,  /* "decisive" 101648 */
     20,   1,  14,  39,  14,  31,  22,   7,  26,   0,  /* "decisively" 101658 */
     20,   1,  14,  39,  14,  31,  22,  13,   1,  14,   0,  /* "decisiveness" 101669 */
     20,  21,  12,   0,  /* "deck" 101673 */
     20,  31,  12,   8,   4,  20,   0,  /* "deckard" 101680 */
     20,  21,  12,  17,   1,  13,   0,  /* "deckman" 101687 */
     20,  31,  12,   7,  21,   4,   1,  13,   3,   0,  /* "declarant" 101697 */
     20,  21,  12,   7,  10,   2,  33,   1,  13,   0,  /* "declaration" 101707 */
     20,  21,  12,   7,  10,   2,  33,   1,  13,  30,   0,  /* "declarations" 101718 */
     20,  31,  12,   7,  21,   4,   1,   3,  18,   4,  26,   0,  /* "declaratory" 101730 */
     20,  31,  12,   7,  21,   4,   0,  /* "declare" 101737 */
     20,  31,  12,   7,  21,   4,  20,   0,  /* "declared" 101745 */
     20,  31,  12,   7,  21,   4,  31,  32,   0,  /* "declaring" 101754 */
     20,  31,  12,   7,  24,  14,   1,  37,  39,  20,   0,  /* "declassified" 101765 */
     20,  31,  12,   7,  24,  14,   1,  37,  39,   0,  /* "declassify" 101775 */
     20,   1,  12,   7,  44,  12,   0,  /* "declerck" 101782 */
     20,   1,  12,   7,  44,  12,   0,  /* "declercq" 101789 */
     20,   1,  12,   7,  44,  12,   0,  /* "declerk" 101796 */
     20,   1,  12,   7,  44,  12,   0,  /* "declerque" 101803 */
     20,  31,  12,   7,  39,  13,   0,  /* "decline" 101810 */
     20,  31,  12,   7,  39,  13,  20,   0,  /* "declined" 101818 */
     20,  31,  12,   7,  39,  13,  10,   0,  /* "decliner" 101826 */
     20,  31,  12,   7,  39,  13,  10,  30,   0,  /* "decliners" 101835 */
     20,  31,  12,   7,  39,  13,  30,   0,  /* "declines" 101843 */
     20,  31,  12,   7,  39,  13,  31,  32,   0,  /* "declining" 101852 */
     20,  21,  12,   7,  29,   0,  /* "declue" 101858 */
     20,  21,  12,  27,   0,  /* "deco" 101863 */
     20,  31,  12,  25,  20,  10,   0,  /* "decoder" 101870 */
     20,  31,  12,  25,  20,  10,  30,   0,  /* "decoders" 101878 */
     20,  31,  12,  25,   7,   1,   0,  /* "decola" 101885 */
     20,  21,  12,   8,  17,   0,  /* "decom" 101891 */
     20,  26,  12,   1,  17,   5,  33,   1,  13,   0,  /* "decommission" 101901 */
     20,  26,  12,   1,  17,   5,  33,   1,  13,  20,   0,  /* "decommissioned" 101912 */
     20,  26,  12,   1,  17,   5,  33,   1,  13,  31,  32,   0,  /* "decommissioning" 101924 */
     20,  23,  12,   1,  17,   6,  27,  30,   5,  33,   1,  13,   0,  /* "decomposition" 101937 */
     20,  23,  12,   1,  13,  14,  23,  13,  26,   0,  /* "deconcini" 101947 */
     20,  31,  12,   1,  13,  40,  21,  14,   3,   1,  13,   3,   0,  /* "decongestant" 101960 */
     20,  31,  12,   1,  13,  40,  21,  14,   3,   1,  13,   3,  14,   0,  /* "decongestants" 101974 */
     20,  23,  12,   1,  13,  14,   3,   4,  35,  12,   3,   0,  /* "deconstruct" 101986 */
     20,  23,  12,   1,  13,   3,   4,  25,   7,   0,  /* "decontrol" 101996 */
     20,  23,  12,   1,  13,   3,   4,  25,   7,  20,   0,  /* "decontrolled" 102007 */
     20,  15,  12,  45,  12,   0,  /* "decook" 102013 */
     20,  31,  12,  18,   4,   0,  /* "decor" 102019 */
     20,  21,  12,   4,   1,   3,  31,  22,   0,  /* "decorative" 102028 */
     20,  21,  12,  10,   2,   3,  10,   0,  /* "decorator" 102036 */
     20,  21,  12,  10,   2,   3,  10,  30,   0,  /* "decorators" 102045 */
     20,  23,  12,  18,   4,  20,  25,  22,   1,   0,  /* "decordova" 102055 */
     20,  31,  12,  18,   4,   3,  26,   0,  /* "decorte" 102063 */
     20,  31,  12,  18,   4,   1,  17,   0,  /* "decorum" 102071 */
     20,  31,  12,  25,  14,   3,   1,   0,  /* "decosta" 102079 */
     20,  31,  12,  25,  14,   3,  26,   0,  /* "decoste" 102087 */
     20,  21,  12,   1,  14,   3,  10,   0,  /* "decoster" 102095 */
     20,  31,  12,  29,   0,  /* "decou" 102100 */
     20,  26,  12,  35,   6,   1,   7,   0,  /* "decouple" 102108 */
     20,  26,  12,  35,   6,   7,  31,  32,   0,  /* "decoupling" 102117 */
     20,  21,  12,  51,   4,  12,  26,   0,  /* "decourcy" 102125 */
     20,  21,  12,  36,   4,  14,  26,   0,  /* "decoursey" 102133 */
     20,   1,  12,  49,   0,  /* "decoy" 102138 */
     20,  23,  12,  50,  30,   0,  /* "decoys" 102144 */
     20,   1,  12,   4,   2,  13,   0,  /* "decrane" 102151 */
     20,  23,  12,   4,  26,  14,   0,  /* "decrease" 102158 */
     20,  31,  12,   4,  23,  14,   0,  /* "decrease" 102165 */
     20,  23,  12,   4,  26,  14,   1,  30,   0,  /* "decreases" 102174 */
     20,  31,  12,   4,  23,  14,   1,  30,   0,  /* "decreases" 102183 */
     20,   1,  12,   4,  21,   6,   1,   3,   0,  /* "decrepit" 102192 */
     20,  31,  12,   4,  15,  14,  42,  21,  13,  30,  27,   0,  /* "decrescenzo" 102204 */
     20,  31,  12,   4,  39,  20,   0,  /* "decried" 102211 */
     20,  31,  12,   4,  39,  30,   0,  /* "decries" 102218 */
     20,  26,  12,   4,   5,  17,   1,  13,   1,   7,   1,  30,   2,  33,   1,  13,   0,  /* "decriminalization" 102235 */
     20,  26,  12,   4,   5,  17,   1,  13,   1,   7,  39,  30,   0,  /* "decriminalize" 102248 */
     20,  26,  12,   4,   5,  17,   1,  13,   1,   7,  39,  30,  31,  32,   0,  /* "decriminalizing" 102263 */
     20,  31,  12,   4,  26,  14,   3,  27,  37,   8,   4,  27,   0,  /* "decristofaro" 102276 */
     20,  31,  12,   4,  39,   0,  /* "decry" 102282 */
     20,  31,  12,   4,  39,  31,  32,   0,  /* "decrying" 102290 */
     20,  21,  12,  31,   4,   0,  /* "decuir" 102296 */
     20,  26,  12,  44,   3,   1,  14,   0,  /* "decurtis" 102304 */
     20,  21,  12,  47,  10,   7,  20,   0,  /* "decworld" 102312 */
     20,  23,  20,   0,  /* "dede" 102316 */
     20,   1,  20,  25,   0,  /* "dedeaux" 102321 */
     20,  21,  20,  31,  12,  10,   0,  /* "dedecker" 102328 */
     20,  21,  20,   4,  31,  12,  14,   0,  /* "dederichs" 102336 */
     20,   1,  20,  44,  47,   8,   4,  20,  10,   0,  /* "dedeurwaerder" 102346 */
     20,  21,  20,   1,  12,   2,   3,   0,  /* "dedicate" 102354 */
     20,  21,  20,   1,  12,  28,   3,   1,  20,   0,  /* "dedicated" 102364 */
     20,  21,  20,   1,  12,   2,  33,   1,  13,   0,  /* "dedication" 102374 */
     20,  28,  20,  23,  27,  30,   0,  /* "dedios" 102381 */
     20,   2,  20,  27,   0,  /* "dedo" 102386 */
     20,  28,  20,  27,  17,  26,  13,  23,  14,   1,  14,   0,  /* "dedominicis" 102398 */
     20,   1,  20,  29,  14,   0,  /* "deduce" 102404 */
     20,   1,  20,  29,  14,   3,   0,  /* "deduced" 102411 */
     20,   1,  20,  35,  12,   3,   1,   9,   1,   7,   0,  /* "deductible" 102422 */
     20,   1,  20,  35,  12,   3,   1,   9,   1,   7,  30,   0,  /* "deductibles" 102434 */
     20,  23,   0,  /* "dee" 102437 */
     20,  23,   9,   0,  /* "deeb" 102441 */
     20,  23,  20,   0,  /* "deed" 102445 */
     20,  23,  11,   0,  /* "deeg" 102449 */
     20,  23,  38,  24,  13,   0,  /* "deehan" 102455 */
     20,  23,   7,   0,  /* "deel" 102459 */
     20,  23,  17,   0,  /* "deem" 102463 */
     20,  26,  21,  17,  37,   1,  14,  39,  30,   0,  /* "deemphasize" 102473 */
     20,  26,  21,  17,  37,   1,  14,  39,  30,  31,  32,   0,  /* "deemphasizing" 102485 */
     20,  23,  13,   0,  /* "deen" 102489 */
     20,  23,   6,   0,  /* "deep" 102493 */
     20,  23,   6,  24,  12,   0,  /* "deepak" 102499 */
     20,   5,   4,   0,  /* "deer" 102503 */
     20,   5,   4,   9,  36,   4,  13,   0,  /* "deerborne" 102511 */
     20,   5,   4,  37,  26,   7,  20,   0,  /* "deerfield" 102519 */
     20,  23,  30,   0,  /* "dees" 102523 */
     20,   1,  37,   8,   9,  26,  27,   0,  /* "defabio" 102531 */
     20,   1,  37,   2,  14,  31,  32,   0,  /* "defacing" 102539 */
     20,   1,  37,   8,   7,  12,  27,   0,  /* "defalco" 102547 */
     20,  21,  37,   1,  17,   2,  33,   1,  13,   0,  /* "defamation" 102557 */
     20,   1,  37,  24,  17,   1,   3,  18,   4,  26,   0,  /* "defamatory" 102568 */
     20,   1,  37,   2,  17,  20,   0,  /* "defamed" 102575 */
     20,   1,  37,  18,   7,   3,   0,  /* "default" 102582 */
     20,   1,  37,   8,  30,  26,  27,   0,  /* "defazio" 102590 */
     20,   1,  37,  23,  30,   1,  13,  14,   0,  /* "defeasance" 102599 */
     20,   1,  37,  23,   3,  31,  32,   0,  /* "defeating" 102607 */
     20,   1,  37,  23,   3,   5,  30,   1,  17,   0,  /* "defeatism" 102617 */
     20,   1,  37,  23,   3,   5,  14,   3,   0,  /* "defeatist" 102626 */
     20,  23,  37,  15,  12,   3,   0,  /* "defect" 102633 */
     20,   5,  37,  21,  12,   3,   0,  /* "defect" 102640 */
     20,  23,  37,  15,  12,   3,   0,  /* "defects" 102647 */
     20,   5,  37,  21,  12,   3,   0,  /* "defects" 102654 */
     20,  21,  37,  26,   0,  /* "defee" 102659 */
     20,   5,  37,  21,   7,   1,  14,   0,  /* "defelice" 102667 */
     20,  21,  37,   1,  13,   9,  52,   0,  /* "defenbaugh" 102675 */
     20,   1,  37,  21,  13,  14,   0,  /* "defence" 102682 */
     20,   1,  37,  21,  13,  14,   7,   1,  14,   0,  /* "defenseless" 102692 */
     20,   1,  37,  21,  13,  14,   1,   9,   1,   7,   0,  /* "defensible" 102703 */
     20,  23,  37,  26,  27,   0,  /* "defeo" 102709 */
     20,   1,  37,  44,   0,  /* "defer" 102714 */
     20,  21,  37,  10,   1,  13,  14,   0,  /* "deference" 102722 */
     20,  21,  37,  10,  21,  13,  42,   1,   7,   0,  /* "deferential" 102732 */
     20,   1,  37,  44,  17,   1,  13,   3,   0,  /* "deferment" 102741 */
     20,   1,  37,  44,  17,   1,  13,   3,  14,   0,  /* "deferments" 102751 */
     20,   1,  37,  44,  30,   0,  /* "defers" 102757 */
     20,  21,  37,  21,  12,  14,   0,  /* "defex" 102764 */
     20,  21,  37,   1,  13,   9,  52,   0,  /* "deffenbaugh" 102772 */
     20,  15,  37,  39,  30,   0,  /* "deffeyes" 102778 */
     20,   1,  37,  39,   1,  13,  14,   0,  /* "defiance" 102786 */
     20,   1,  37,  39,   1,  13,   3,   0,  /* "defiant" 102794 */
     20,   1,  37,  39,   1,  13,   3,   7,  26,   0,  /* "defiantly" 102804 */
     20,  21,  37,   5,   9,  18,   0,  /* "defibaugh" 102811 */
     20,  26,  37,   5,   9,   4,   1,   7,   2,   3,  10,   0,  /* "defibrillator" 102823 */
     20,  26,  37,   5,   9,   4,   1,   7,   2,   3,  10,  30,   0,  /* "defibrillators" 102836 */
     20,  21,  37,   1,  14,   1,   3,   0,  /* "deficit" 102844 */
     20,  21,  37,   1,  14,   1,   3,  14,   0,  /* "deficits" 102853 */
     20,   1,  37,  39,  20,   0,  /* "defied" 102859 */
     20,   1,  37,  39,  30,   0,  /* "defies" 102865 */
     20,  21,  37,   1,   7,   1,   6,   1,  14,   0,  /* "defilippis" 102875 */
     20,   1,  37,  26,   7,  23,   6,  27,   0,  /* "defilippo" 102884 */
     20,   1,  37,  39,  13,   1,   9,   1,   7,   0,  /* "definable" 102894 */
     20,   1,  37,  39,  13,   0,  /* "define" 102900 */
     20,   1,  37,  39,  13,  20,   0,  /* "defined" 102907 */
     20,   1,  37,  39,  13,  30,   0,  /* "defines" 102914 */
     20,   1,  37,  39,  13,  31,  32,   0,  /* "defining" 102922 */
     20,  21,  37,   1,  13,   1,   3,   0,  /* "definite" 102930 */
     20,  21,  37,   1,  13,   1,   3,   7,  26,   0,  /* "definitely" 102940 */
     20,  21,  37,   1,  13,   5,  33,   1,  13,   0,  /* "definition" 102950 */
     20,  21,  37,   1,  13,   5,  33,   1,  13,  30,   0,  /* "definitions" 102961 */
     20,   1,  37,   5,  13,   1,   3,  31,  22,   0,  /* "definitive" 102971 */
     20,   1,  37,   5,  13,   1,   3,  31,  22,   7,  26,   0,  /* "definitively" 102983 */
     20,   1,  37,  44,   0,  /* "defleur" 102988 */
     20,   1,  37,  25,   0,  /* "defoe" 102993 */
     20,  21,  37,  51,   4,   0,  /* "defoor" 102999 */
     20,  21,  37,  10,  20,   0,  /* "deford" 103005 */
     20,  23,  37,  36,   4,   0,  /* "defore" 103011 */
     20,   1,  37,  18,   4,   1,  14,   3,   2,  33,   1,  13,   0,  /* "deforestation" 103024 */
     20,  21,  37,  10,  11,   0,  /* "deforge" 103030 */
     20,  23,  37,  18,   4,  17,   0,  /* "deform" 103037 */
     20,  23,  37,  36,   4,  17,   2,  33,   1,  13,   0,  /* "deformation" 103048 */
     20,  28,  37,  18,   4,   1,  14,   3,   0,  /* "deforrest" 103057 */
     20,  23,  37,   4,   1,  13,  14,   0,  /* "defrance" 103065 */
     20,   1,  37,   4,  19,  13,  42,  23,  14,  12,  27,   0,  /* "defrancisco" 103077 */
     20,  21,  37,   4,   1,  32,  12,   0,  /* "defrank" 103085 */
     20,  21,  37,  10,  28,   3,  14,   0,  /* "defrates" 103093 */
     20,   1,  37,   4,  18,  20,   0,  /* "defraud" 103100 */
     20,  21,  37,   4,  26,  14,   0,  /* "defreese" 103107 */
     20,  21,  37,   4,  39,   3,   1,  30,   0,  /* "defreitas" 103116 */
     20,   1,  37,   4,  23,  30,   0,  /* "defries" 103123 */
     20,   1,  37,   4,  18,  14,   3,  31,  32,   0,  /* "defrosting" 103133 */
     20,  21,  37,   3,   0,  /* "deft" 103138 */
     20,  21,  37,   3,  21,   4,  26,  27,  30,   0,  /* "defterios" 103148 */
     20,  21,  37,   3,   7,  26,   0,  /* "deftly" 103155 */
     20,  26,  37,  35,  13,  20,   0,  /* "defund" 103162 */
     20,  26,  37,  35,  13,  20,  31,  32,   0,  /* "defunding" 103171 */
     20,   1,  37,  29,  14,  12,  27,   0,  /* "defusco" 103179 */
     20,   1,  37,  41,  29,  30,   0,  /* "defuse" 103186 */
     20,   1,  37,  41,  29,  30,  20,   0,  /* "defused" 103194 */
     20,   1,  37,  41,  29,  30,  31,  32,   0,  /* "defusing" 103203 */
     20,   1,  37,  39,   0,  /* "defy" 103208 */
     20,   1,  37,  39,  31,  32,   0,  /* "defying" 103215 */
     20,   1,  11,  19,  15,   3,   8,  13,  27,   0,  /* "degaetano" 103225 */
     20,  23,  11,   1,  13,   0,  /* "degan" 103231 */
     20,   1,  11,   8,   4,  17,  27,   0,  /* "degarmo" 103239 */
     20,   2,  11,   1,  14,   0,  /* "degas" 103245 */
     20,   1,  11,   8,   7,   0,  /* "degaulle" 103251 */
     20,  21,  11,   1,  13,   0,  /* "degen" 103257 */
     20,  21,  11,  26,  13,  10,   0,  /* "degener" 103264 */
     20,  31,  40,  21,  13,  10,   1,   3,   0,  /* "degenerate" 103273 */
     20,  31,  40,  21,  13,  10,   1,   3,  14,   0,  /* "degenerates" 103283 */
     20,  31,  40,   1,  13,  21,   4,  15,  14,   0,  /* "degeneres" 103293 */
     20,  21,  11,   1,  13,  38,  19,   4,   3,   0,  /* "degenhardt" 103303 */
     20,  21,  11,   1,  13,  38,   8,   4,   3,   0,  /* "degenhart" 103313 */
     20,  31,  40,  15,  13,   8,   4,  27,   0,  /* "degennaro" 103322 */
     20,  21,  11,  26,  10,  11,   0,  /* "degeorge" 103329 */
     20,  23,  11,  10,   0,  /* "deger" 103334 */
     20,  23,  40,   1,  12,  27,  17,  27,   0,  /* "degiacomo" 103343 */
     20,  21,  11,   7,  10,   0,  /* "degler" 103349 */
     20,  21,  11,  13,   1,  13,   0,  /* "degnan" 103356 */
     20,  21,  11,  13,  10,   0,  /* "degner" 103362 */
     20,  21,  11,  51,  20,   0,  /* "degood" 103368 */
     20,  21,  11,   4,  19,  37,   0,  /* "degraaf" 103375 */
     20,  31,  11,   4,   8,  42,  26,   0,  /* "degrace" 103383 */
     20,  31,  11,   4,   2,  20,   1,   9,   1,   7,   0,  /* "degradable" 103394 */
     20,  21,  11,   4,   1,  20,   2,  33,   1,  13,   0,  /* "degradation" 103405 */
     20,  21,  11,   4,   1,  20,   2,  33,   1,  13,  30,   0,  /* "degradations" 103417 */
     20,  21,  11,   4,   1,  37,   0,  /* "degraff" 103424 */
     20,  21,  11,   4,   1,  37,   1,  13,   4,  39,  20,   0,  /* "degraffenreid" 103436 */
     20,  21,  11,   4,  34,  13,  20,   0,  /* "degrand" 103444 */
     20,  21,  11,   4,  28,  13,  40,   0,  /* "degrange" 103452 */
     20,  31,  11,   4,   8,  14,  26,   0,  /* "degrasse" 103460 */
     20,  31,  11,   4,   8,  22,  26,   0,  /* "degrave" 103468 */
     20,  21,  11,   4,  36,   0,  /* "degraw" 103474 */
     20,  21,  11,   4,  28,   0,  /* "degray" 103480 */
     20,  21,  11,   4,  31,  11,  10,  26,   0,  /* "degregory" 103489 */
     20,  21,  11,   4,  29,   3,   0,  /* "degroot" 103496 */
     20,   1,  11,   4,  29,   3,   0,  /* "degroote" 103503 */
     20,  31,  11,  44,   1,  13,   0,  /* "deguerin" 103510 */
     20,  28,  11,  47,   5,   4,  28,   0,  /* "deguire" 103518 */
     20,  31,  11,  41,  29,  14,   1,   0,  /* "degussa" 103526 */
     20,  21,  11,  29,   3,   8,   4,  26,   0,  /* "degutare" 103535 */
     20,  28,  11,  29,  30,  17,  24,  13,   0,  /* "deguzman" 103544 */
     20,  21,  38,  19,  13,   0,  /* "dehaan" 103550 */
     20,   1,  38,   8,   4,   9,  26,   0,  /* "deharbe" 103558 */
     20,  21,  38,  19,   4,   3,   0,  /* "dehart" 103565 */
     20,  15,  38,  21,  12,   0,  /* "dehecq" 103571 */
     20,   1,  38,   5,   4,  26,   0,  /* "dehere" 103578 */
     20,  28,  38,  15,   4,  21,   4,   1,   0,  /* "deherrera" 103587 */
     20,  21,  17,   0,  /* "dehm" 103591 */
     20,  21,  13,   0,  /* "dehn" 103595 */
     20,  21,  38,  50,  27,  30,   0,  /* "dehoyos" 103602 */
     20,  23,  38,  41,  29,  17,   1,  13,   1,  30,   2,  33,   1,  13,   0,  /* "dehumanization" 103617 */
     20,   1,  38,  41,  29,  17,   1,  13,  39,  30,   0,  /* "dehumanize" 103628 */
     20,   1,  38,  41,  29,  17,   1,  13,  39,  30,  20,   0,  /* "dehumanized" 103640 */
     20,  26,  38,  41,  29,  17,   1,  13,  39,  30,  31,  32,   0,  /* "dehumanizing" 103653 */
     20,   1,  38,  39,  20,   4,  28,   3,   0,  /* "dehydrate" 103662 */
     20,   1,  38,  39,  20,   4,  28,   3,   1,  20,   0,  /* "dehydrated" 103673 */
     20,  23,  38,  39,  20,   4,   2,  33,   1,  13,   0,  /* "dehydration" 103684 */
     20,  39,   9,   1,   7,   0,  /* "deibel" 103690 */
     20,  39,   9,  10,   3,   0,  /* "deibert" 103696 */
     20,  39,   9,   1,   7,  10,   0,  /* "deibler" 103703 */
     20,  39,  12,  10,   3,   0,  /* "deichert" 103709 */
     20,  23,  20,   4,   1,   0,  /* "deidre" 103715 */
     20,  23,   1,  37,   1,  12,   2,  33,   1,  13,   0,  /* "deification" 103726 */
     20,  23,   1,  37,  39,   0,  /* "deify" 103732 */
     20,   2,  11,  38,   1,  13,   0,  /* "deighan" 103739 */
     20,   1,  11,  13,  24,  13,   0,  /* "deignan" 103746 */
     20,  39,   7,   0,  /* "deihl" 103750 */
     20,  39,  12,   1,   7,   0,  /* "deikel" 103756 */
     20,  23,   7,  26,   0,  /* "deily" 103761 */
     20,  23,  13,  30,   0,  /* "deines" 103766 */
     20,  39,  13,  31,  32,  10,   0,  /* "deininger" 103773 */
     20,  26,   5,  13,  14,   3,   1,   3,  29,  33,   1,  13,   1,   7,   1,  30,   2,  33,   1,  13,   0,  /* "deinstitutionalization" 103794 */
     20,  26,   5,  13,  14,   3,   1,   3,  29,  33,   1,  13,   1,   7,  39,  30,   0,  /* "deinstitutionalize" 103811 */
     20,  23,  41,  19,  13,   0,  /* "deion" 103817 */
     20,  23,   4,  20,   4,   1,   0,  /* "deirdre" 103824 */
     20,  23,  30,   0,  /* "deis" 103828 */
     20,  23,  31,  33,  10,   0,  /* "deisher" 103834 */
     20,  23,   5,  30,   1,  17,   0,  /* "deism" 103841 */
     20,  39,  14,   0,  /* "deiss" 103845 */
     20,  23,   1,  14,   3,   0,  /* "deist" 103851 */
     20,  39,  42,   0,  /* "deitch" 103855 */
     20,  39,   3,  10,   0,  /* "deiter" 103860 */
     20,  39,   3,  10,  30,   0,  /* "deiters" 103866 */
     20,  23,   1,   3,  26,  30,   0,  /* "deities" 103873 */
     20,  39,   3,   4,  31,  12,   0,  /* "deitrich" 103880 */
     20,  39,   3,   4,  31,  12,   0,  /* "deitrick" 103887 */
     20,  39,  42,   0,  /* "deitsch" 103891 */
     20,  23,   1,   3,  26,   0,  /* "deity" 103897 */
     20,  23,  40,   1,   0,  /* "deja" 103902 */
     20,  21,  40,  28,  11,  10,   0,  /* "dejager" 103909 */
     20,  31,  40,   8,   4,  13,  15,   3,   0,  /* "dejarnett" 103918 */
     20,  21,  43,  19,   4,  13,  15,   3,   0,  /* "dejarnette" 103927 */
     20,  31,  43,  23,  13,   0,  /* "dejean" 103933 */
     20,  31,  40,  21,  12,   3,   0,  /* "deject" 103940 */
     20,  31,  40,  21,  12,   3,   1,  20,   0,  /* "dejected" 103949 */
     20,  31,  40,  23,  30,   1,  14,   0,  /* "dejesus" 103957 */
     20,   1,  40,   8,  13,   0,  /* "dejohn" 103963 */
     20,   1,  40,  18,  32,   0,  /* "dejonge" 103969 */
     20,   1,  40,  18,  32,   0,  /* "dejongh" 103975 */
     20,   1,  40,  25,  14,   1,  37,   0,  /* "dejoseph" 103983 */
     20,   1,  40,  49,   0,  /* "dejoy" 103988 */
     20,   1,  40,  29,   7,  26,  27,   0,  /* "dejulio" 103996 */
     20,  31,  12,  24,   7,   9,   0,  /* "dekalb" 104003 */
     20,   1,  12,   2,   0,  /* "dekay" 104008 */
     20,   1,  12,  39,  30,  10,   0,  /* "dekeyser" 104015 */
     20,  21,  12,   1,   7,   0,  /* "dekle" 104021 */
     20,   1,  12,   7,  44,  12,   0,  /* "deklerk" 104028 */
     20,  21,  12,   1,  13,  31,  32,   0,  /* "dekoning" 104036 */
     20,  21,  12,   4,  29,  13,   0,  /* "dekroon" 104043 */
     20,  31,  12,  39,   6,  10,   0,  /* "dekuyper" 104050 */
     20,  21,   7,   0,  /* "del" 104054 */
     20,  21,   7,   1,   0,  /* "dela" 104059 */
     20,  15,   7,  19,  42,  21,   4,  20,   1,   0,  /* "delacerda" 104069 */
     20,  28,   7,   8,  12,   4,  29,  30,   0,  /* "delacruz" 104078 */
     20,   1,   7,  18,  14,  26,   0,  /* "delacy" 104085 */
     20,  28,   7,  19,  37,  47,  21,  13,   3,  28,   0,  /* "delafuente" 104096 */
     20,  15,   7,  19,  11,   8,   4,  30,   1,   0,  /* "delagarza" 104106 */
     20,  15,   7,   8,  11,   4,  19,  13,  40,   0,  /* "delagrange" 104116 */
     20,  21,   7,   1,  38,   1,  13,   3,  26,   0,  /* "delahanty" 104126 */
     20,  15,   7,   1,  38,  48,  14,  28,   0,  /* "delahoussaye" 104135 */
     20,  21,   7,   1,  38,   1,  13,   3,   0,  /* "delahunt" 104144 */
     20,  21,   7,   1,  38,   1,  13,   3,  26,   0,  /* "delahunty" 104154 */
     20,   1,   7,   2,  13,   0,  /* "delaine" 104160 */
     20,   1,   7,  21,   4,   0,  /* "delair" 104166 */
     20,  28,   7,  19,  17,   8,   4,   0,  /* "delamar" 104174 */
     20,  21,   7,   1,  17,  28,   3,  10,   0,  /* "delamater" 104183 */
     20,   1,   7,  24,  13,  20,   0,  /* "deland" 104190 */
     20,  21,   7,   1,  13,   0,  /* "delane" 104196 */
     20,   1,   7,   2,  13,  26,   0,  /* "delaney" 104203 */
     20,  21,   7,  28,  13,  40,   0,  /* "delange" 104210 */
     20,   1,   7,   8,  13,  27,   0,  /* "delano" 104217 */
     20,  21,   7,   1,  13,  50,   0,  /* "delanoy" 104224 */
     20,  21,   7,  52,   0,  /* "delao" 104229 */
     20,  28,   7,   8,   6,  19,  30,   0,  /* "delapaz" 104237 */
     20,  15,   7,  19,   6,  21,  13,   1,   0,  /* "delapena" 104246 */
     20,  21,   7,   1,   6,   0,  /* "delapp" 104252 */
     20,  15,   7,  19,   4,  23,  22,   1,   0,  /* "delariva" 104261 */
     20,  15,   7,  19,   4,  25,  14,   1,   0,  /* "delarosa" 104270 */
     20,  21,   7,   1,  33,  17,   1,   3,   0,  /* "delashmutt" 104279 */
     20,   1,   7,  24,  14,  12,  26,   0,  /* "delaski" 104287 */
     20,  15,   7,  19,   3,  18,   4,  26,   0,  /* "delatorre" 104296 */
     20,  21,   7,  36,  13,   0,  /* "delaune" 104302 */
     20,  15,   7,  18,   4,   1,   0,  /* "delaura" 104309 */
     20,   1,   7,   8,   4,   1,   7,   0,  /* "delaurel" 104317 */
     20,  26,   7,  36,   4,  21,  13,   3,  23,  30,   0,  /* "delaurentiis" 104328 */
     20,  28,   7,  52,   4,   2,  13,   3,   5,  14,   0,  /* "delaurentis" 104339 */
     20,  21,   7,   1,  22,  34,   7,   0,  /* "delaval" 104347 */
     20,  28,   7,  19,  22,   2,  11,   1,   0,  /* "delavega" 104356 */
     20,  21,   7,  36,  20,  10,   0,  /* "delawder" 104363 */
     20,  15,   7,   9,  21,  13,  26,   0,  /* "delbene" 104371 */
     20,  21,   7,   9,  10,   3,   0,  /* "delbert" 104378 */
     20,  15,   7,   9,  25,  14,  12,   0,  /* "delbosque" 104386 */
     20,  21,   7,   9,   4,  31,  40,   0,  /* "delbridge" 104394 */
     20,  21,   7,   9,  47,  25,  13,  27,   0,  /* "delbuono" 104403 */
     20,  15,   7,  12,   8,  17,   9,   4,  26,   0,  /* "delcambre" 104413 */
     20,  21,   7,  12,  34,  17,   6,   0,  /* "delcamp" 104421 */
     20,  15,   7,  12,   8,  17,   6,  27,   0,  /* "delcampo" 104430 */
     20,  15,   7,  12,  19,  14,   3,   5,   7,  27,   0,  /* "delcastillo" 104441 */
     20,  15,   7,  42,  23,  13,  26,   0,  /* "delcine" 104449 */
     20,  15,   7,  12,  25,  13,   3,  26,   0,  /* "delconte" 104458 */
     20,  21,   7,  20,  29,  12,   1,   0,  /* "delduca" 104466 */
     20,   1,   7,  21,  12,   3,   1,   9,   1,   7,   0,  /* "delectable" 104477 */
     20,  21,   7,  26,  29,   0,  /* "deleeuw" 104483 */
     20,  21,   7,   1,  11,   2,   3,  14,   0,  /* "delegates" 104492 */
     20,  21,   7,   1,  38,   1,  13,   3,  26,   0,  /* "delehanty" 104502 */
     20,  21,   7,  15,   7,   1,  14,   0,  /* "delellis" 104510 */
     20,  21,   7,  26,   1,  13,  19,   4,  20,   1,  14,   0,  /* "deleonardis" 104522 */
     20,   1,   7,  23,   3,   1,  20,   0,  /* "deleted" 104530 */
     20,  21,   7,   1,   3,   5,   4,  26,   1,  14,   0,  /* "deleterious" 104541 */
     20,   1,   7,  23,   3,  31,  32,   0,  /* "deleting" 104549 */
     20,  15,   7,  37,  19,  22,  21,   4,  27,   0,  /* "delfavero" 104559 */
     20,  15,   7,  37,  23,  13,  26,   0,  /* "delfine" 104567 */
     20,  21,   7,  37,   1,  14,   0,  /* "delfosse" 104574 */
     20,  21,   7,  37,   3,   0,  /* "delft" 104580 */
     20,  21,   7,  37,   3,  47,  21,   4,   0,  /* "delftware" 104589 */
     20,  15,   7,  11,  19,  20,   5,   7,  27,   0,  /* "delgadillo" 104599 */
     20,  15,   7,  40,  18,   4,  13,  27,   0,  /* "delgiorno" 104608 */
     20,  15,   7,  40,  29,  20,   1,  14,   0,  /* "delgiudice" 104617 */
     20,  21,   7,  11,   4,  34,  13,  20,  26,   0,  /* "delgrande" 104627 */
     20,  21,   7,  11,   4,  21,  12,  27,   0,  /* "delgreco" 104636 */
     20,  21,   7,  11,   4,  25,  14,  27,   0,  /* "delgrosso" 104645 */
     20,  15,   7,  11,  21,   4,  42,  26,  27,   0,  /* "delguercio" 104655 */
     20,  15,   7,  11,  39,  20,   5,  14,   0,  /* "delguidice" 104664 */
     20,  21,   7,  26,   0,  /* "deli" 104669 */
     20,  23,   7,  41,   1,   0,  /* "delia" 104675 */
     20,   1,   7,  39,  15,   7,   0,  /* "delial" 104682 */
     20,  31,   7,   5,   9,  10,   1,   3,   0,  /* "deliberate" 104691 */
     20,  31,   7,   5,   9,  10,   2,   3,   0,  /* "deliberate" 104700 */
     20,   1,   7,   5,   9,  10,   2,   3,  31,  22,   0,  /* "deliberative" 104711 */
     20,  21,   7,  31,  12,   1,  14,  26,  30,   0,  /* "delicacies" 104721 */
     20,  21,   7,   1,  12,   1,   3,   0,  /* "delicate" 104729 */
     20,  21,   7,   1,  12,   1,   3,   7,  26,   0,  /* "delicately" 104739 */
     20,  21,   7,  31,  12,   1,   3,  21,  14,   1,  13,   0,  /* "delicatessen" 104751 */
     20,  21,   7,  31,  12,   1,   3,  21,  14,   1,  13,  30,   0,  /* "delicatessens" 104764 */
     20,  15,   7,  23,  42,   1,   0,  /* "delicia" 104771 */
     20,   1,   7,   5,  33,   1,  14,   0,  /* "delicious" 104779 */
     20,   1,   7,   5,  33,   1,  14,   7,  26,   0,  /* "deliciously" 104789 */
     20,   1,   7,  39,   3,   0,  /* "delight" 104795 */
     20,   1,   7,  39,   3,   1,  20,   0,  /* "delighted" 104803 */
     20,   1,   7,  39,   3,  37,   1,   7,   0,  /* "delightful" 104812 */
     20,   1,   7,  39,   3,  37,   1,   7,  26,   0,  /* "delightfully" 104822 */
     20,   1,   7,  39,   3,  31,  32,   0,  /* "delighting" 104830 */
     20,   1,   7,  39,   3,  14,   0,  /* "delights" 104837 */
     20,  15,   7,  23,   7,   1,   0,  /* "delila" 104844 */
     20,   1,   7,  39,   7,   1,   0,  /* "delilah" 104851 */
     20,  15,   7,  23,  17,   1,   0,  /* "delima" 104858 */
     20,  15,   7,  23,  13,  26,   0,  /* "deline" 104865 */
     20,   2,   7,  26,  27,   0,  /* "delio" 104871 */
     20,  15,   7,  23,  14,   1,   0,  /* "delisa" 104878 */
     20,  21,   7,  39,  30,   0,  /* "delise" 104884 */
     20,  15,   7,  23,  14,  26,   0,  /* "delisi" 104891 */
     20,  15,   7,  23,  14,  26,  27,   0,  /* "delisio" 104899 */
     20,   1,   7,  39,   7,   0,  /* "delisle" 104905 */
     20,  23,   7,   5,  14,   3,   0,  /* "delist" 104912 */
     20,  26,   7,   5,  14,   3,  31,  32,   0,  /* "delisting" 104921 */
     20,   1,   7,   5,  22,  10,   1,   9,   1,   7,   0,  /* "deliverable" 104932 */
     20,  21,   7,  12,   0,  /* "delk" 104937 */
     20,  21,   7,   0,  /* "dell" 104941 */
     20,  21,   7,  19,   4,   3,   0,  /* "dellaert" 104948 */
     20,  21,   7,   1,   6,  21,  13,   1,   0,  /* "dellapenna" 104957 */
     20,  28,   7,  19,  12,  47,  23,   7,   1,   0,  /* "dellaquila" 104967 */
     20,  21,   7,  10,  27,  12,  27,   0,  /* "dellarocco" 104975 */
     20,  21,   7,   1,  22,  19,   7,  26,   0,  /* "dellavalle" 104984 */
     20,  15,   7,  26,  11,   8,   3,  26,   0,  /* "delligatti" 104993 */
     20,  15,   7,  25,   7,  26,  27,   0,  /* "dellolio" 105001 */
     20,  21,   7,  17,  21,  20,   0,  /* "delmed" 105008 */
     20,  15,   7,  17,  19,  13,  23,  12,  27,   0,  /* "delmonico" 105018 */
     20,   2,   7,  17,  27,  13,   3,   0,  /* "delmont" 105026 */
     20,  21,   7,  17,  36,   4,   0,  /* "delmore" 105033 */
     20,  21,   7,  13,  21,  11,   4,  27,   0,  /* "delnegro" 105042 */
     20,  15,   7,  13,  21,   4,  27,   0,  /* "delnero" 105050 */
     20,  21,   7,  27,   0,  /* "delo" 105055 */
     20,   1,   7,  49,   3,   0,  /* "deloitte" 105061 */
     20,   1,   7,  18,  32,   0,  /* "delong" 105067 */
     20,  15,   7,  18,   4,   1,   0,  /* "delora" 105074 */
     20,   1,   7,  18,   4,  26,   1,  13,   0,  /* "delorean" 105083 */
     20,  15,   7,  36,   4,  21,  13,  30,  27,   0,  /* "delorenzo" 105093 */
     20,   1,   7,  18,   4,   1,  14,   0,  /* "delores" 105101 */
     20,  21,   7,  10,  26,   0,  /* "delorey" 105107 */
     20,  15,   7,  18,   4,  26,   1,   0,  /* "deloria" 105115 */
     20,  21,   7,  10,   5,  14,   0,  /* "deloris" 105122 */
     20,  15,   7,  18,   4,  17,  26,   0,  /* "delorme" 105130 */
     20,   1,   7,  18,   4,  30,   0,  /* "delors" 105137 */
     20,  15,   7,   8,  14,  10,  39,  30,   0,  /* "delosreyes" 105146 */
     20,  28,   7,  27,  14,   8,  13,   3,  27,  30,   0,  /* "delossantos" 105157 */
     20,  21,   7,  29,  23,  30,   0,  /* "delouis" 105164 */
     20,  21,   7,   1,  30,  26,  10,   0,  /* "delozier" 105172 */
     20,  21,   7,   6,   0,  /* "delp" 105177 */
     20,  21,   7,  37,  34,  12,  14,   0,  /* "delphax" 105185 */
     20,  21,   7,  37,  39,   0,  /* "delphi" 105191 */
     20,  15,   7,  37,  23,  13,   1,   0,  /* "delphina" 105199 */
     20,  15,   7,  37,  23,  13,  26,   0,  /* "delphine" 105207 */
     20,  15,   7,   6,  23,  30,  27,   0,  /* "delpizzo" 105215 */
     20,  15,   7,   6,  25,  13,   3,  26,   0,  /* "delponte" 105224 */
     20,  21,   7,   6,   4,  26,   3,   0,  /* "delprete" 105232 */
     20,  15,   7,   6,   4,  26,  18,   4,  26,   0,  /* "delpriore" 105242 */
     20,  21,   7,   4,   1,   7,   0,  /* "delreal" 105249 */
     20,  15,   7,   4,  27,  14,   8,   4,  26,  27,   0,  /* "delrosario" 105260 */
     20,  15,   7,   4,   8,  14,  26,   0,  /* "delrossi" 105268 */
     20,  15,   7,   4,  25,  14,  27,   0,  /* "delrosso" 105276 */
     20,  15,   7,  14,   8,  13,   3,  27,   0,  /* "delsanto" 105285 */
     20,  15,   7,  14,  26,  11,  13,  18,   4,  26,   0,  /* "delsignore" 105296 */
     20,  21,   7,   3,   1,  20,   4,  25,  17,   1,  14,   0,  /* "deltadromeus" 105308 */
     20,  15,   7,   3,   2,  31,  12,   0,  /* "deltaic" 105316 */
     20,  21,   7,   3,  24,  12,   0,  /* "deltak" 105323 */
     20,  15,   7,   3,  18,   4,  27,   0,  /* "deltoro" 105331 */
     20,   1,   7,  29,  12,   1,   0,  /* "deluca" 105338 */
     20,   1,   7,  29,  12,   1,  30,   0,  /* "delucas" 105346 */
     20,  15,   7,  29,  42,   1,   0,  /* "deluccia" 105353 */
     20,  15,   7,  29,  42,   1,   0,  /* "delucia" 105360 */
     20,   1,   7,  29,  20,   0,  /* "delude" 105366 */
     20,   1,   7,  29,  20,   1,  20,   0,  /* "deluded" 105374 */
     20,   1,   7,  29,  20,  31,  32,   0,  /* "deluding" 105382 */
     20,  21,   7,  41,  29,  40,   0,  /* "deluge" 105389 */
     20,  21,   7,  41,  29,  40,  20,   0,  /* "deluged" 105397 */
     20,  15,   7,  29,  14,  26,   0,  /* "deluise" 105404 */
     20,  15,   7,  29,  13,   1,   0,  /* "deluna" 105411 */
     20,   1,   7,  29,  43,   1,  13,   0,  /* "delusion" 105419 */
     20,   1,   7,  29,  43,   1,  13,   1,   7,   0,  /* "delusional" 105429 */
     20,   1,   7,  29,  43,   1,  13,  30,   0,  /* "delusions" 105438 */
     20,   1,   7,  35,  12,  14,   0,  /* "deluxe" 105445 */
     20,  21,   7,  22,  24,   7,  26,   0,  /* "delvalle" 105453 */
     20,  21,   7,  47,   5,  13,   0,  /* "delwyn" 105460 */
     20,   1,  17,   8,  40,  26,  27,   0,  /* "demaggio" 105468 */
     20,  21,  17,   1,  11,   8,  40,  31,  12,   0,  /* "demagogic" 105478 */
     20,  21,  17,   1,  11,   8,  40,  26,   0,  /* "demagogy" 105487 */
     20,   1,  17,   2,  13,   0,  /* "demain" 105493 */
     20,   1,  17,   8,  26,  27,   0,  /* "demaio" 105500 */
     20,  23,  17,   1,  13,   0,  /* "deman" 105506 */
     20,   5,  17,   8,   4,   0,  /* "demar" 105512 */
     20,  21,  17,  10,  28,   0,  /* "demarais" 105518 */
     20,  23,  17,  19,   4,  12,   2,  33,   1,  13,   0,  /* "demarcation" 105529 */
     20,  23,  17,  19,   4,  12,   2,  33,   1,  13,  30,   0,  /* "demarcations" 105541 */
     20,   5,  17,   8,   4,  42,   0,  /* "demarche" 105548 */
     20,   5,  17,   8,   4,  12,  26,   0,  /* "demarchi" 105556 */
     20,   5,  17,   8,   4,  12,  27,   0,  /* "demarco" 105564 */
     20,  15,  17,  10,  23,   0,  /* "demaree" 105570 */
     20,  28,  17,  19,   4,   2,  15,  14,   3,   0,  /* "demarest" 105580 */
     20,   5,  17,   8,   4,  26,   1,   0,  /* "demaria" 105588 */
     20,  21,  17,  10,   5,  13,   1,  14,   0,  /* "demarinis" 105597 */
     20,   5,  17,  19,   4,  23,  13,  27,   0,  /* "demarino" 105606 */
     20,   5,  17,   8,   4,  26,  27,   0,  /* "demario" 105614 */
     20,   1,  17,   8,   4,  12,   0,  /* "demark" 105621 */
     20,  21,  17,  19,   4,  33,   0,  /* "demarsh" 105628 */
     20,   5,  17,   8,   4,   3,   5,  13,   0,  /* "demartin" 105637 */
     20,   5,  17,  19,   4,   3,  23,  13,  26,   0,  /* "demartini" 105647 */
     20,   5,  17,  19,   4,   3,  23,  13,  27,   0,  /* "demartino" 105657 */
     20,  21,  17,  15,   4,  26,   0,  /* "demary" 105664 */
     20,   5,  17,   8,   4,  30,  27,   0,  /* "demarzo" 105672 */
     20,  23,  17,   1,  14,   0,  /* "demas" 105678 */
     20,  23,  17,  34,  14,   3,  10,  30,   0,  /* "demasters" 105687 */
     20,  21,  17,   1,   3,  39,  30,   0,  /* "dematteis" 105695 */
     20,   5,  17,   8,   3,  26,  27,   0,  /* "dematteo" 105703 */
     20,   5,  17,   8,  33,   1,   0,  /* "demattia" 105710 */
     20,  21,  17,  28,   0,  /* "demay" 105715 */
     20,  28,  17,   2,  27,   0,  /* "demayo" 105721 */
     20,  15,  17,   9,   5,  13,  14,  12,  26,   0,  /* "dembinski" 105731 */
     20,  15,  17,   9,  18,  37,  14,  12,  26,   0,  /* "dembowski" 105741 */
     20,   5,  17,  23,  13,  30,   0,  /* "demeans" 105748 */
     20,  21,  17,   1,   7,   0,  /* "demel" 105754 */
     20,   1,  17,  21,  13,   3,   0,  /* "dement" 105761 */
     20,   5,  17,  21,  13,  33,  26,   1,   0,  /* "dementia" 105770 */
     20,  23,  17,  26,  27,   0,  /* "demeo" 105776 */
     20,  21,  17,  10,  26,   0,  /* "demeree" 105782 */
     20,  15,  17,  44,   5,  14,   3,   0,  /* "demerist" 105790 */
     20,  21,  17,  10,   1,   3,   0,  /* "demeritt" 105797 */
     20,  23,  17,  10,  30,   0,  /* "demers" 105803 */
     20,  15,  17,  44,  26,   0,  /* "demery" 105809 */
     20,   5,  17,  23,   3,  10,   0,  /* "demeter" 105816 */
     20,  15,  17,  23,   3,  10,   0,  /* "demetre" 105823 */
     20,   5,  17,  15,   3,   4,  23,  29,   0,  /* "demetriou" 105832 */
     20,   5,  17,  23,   3,   4,  26,   1,  14,   0,  /* "demetrius" 105842 */
     20,  21,  17,  39,  10,   0,  /* "demeyer" 105848 */
     20,  21,  17,  26,   0,  /* "demi" 105853 */
     20,   5,  17,  23,  12,  27,   0,  /* "demicco" 105860 */
     20,  21,  17,  31,  12,  15,   7,   0,  /* "demichael" 105868 */
     20,  21,  17,  31,  12,   1,   7,   0,  /* "demichele" 105876 */
     20,   5,  17,  23,   7,  26,  27,   0,  /* "demilio" 105884 */
     20,  26,  17,   5,   7,   1,   3,  10,  39,  30,   0,  /* "demilitarize" 105895 */
     20,  26,  17,   5,   7,   1,   3,  10,  39,  30,  20,   0,  /* "demilitarized" 105907 */
     20,  26,  17,   5,   7,   1,   3,  10,  39,  30,   1,  30,   0,  /* "demilitarizes" 105920 */
     20,  26,  17,   5,   7,   1,   3,  10,  39,  30,  31,  32,   0,  /* "demilitarizing" 105933 */
     20,   5,  17,  23,   7,  26,   0,  /* "demille" 105940 */
     20,   1,  17,   5,   7,  27,   0,  /* "demilo" 105947 */
     20,   2,  17,  26,  13,   3,   0,  /* "demint" 105954 */
     20,   2,  17,  31,   4,   8,  40,   0,  /* "demirag" 105962 */
     20,   1,  17,   5,   4,   1,   7,   0,  /* "demirel" 105970 */
     20,   5,  17,  44,  40,  26,   1,  13,   0,  /* "demirjian" 105979 */
     20,   1,  17,   5,  33,   0,  /* "demisch" 105985 */
     20,   5,  17,  39,  30,   0,  /* "demise" 105991 */
     20,  15,  17,  41,   8,  13,  41,  29,  12,   0,  /* "demjanjuk" 106001 */
     20,  23,  17,   1,   0,  /* "demma" 106006 */
     20,  21,  17,  27,   0,  /* "demo" 106011 */
     20,  26,  17,  25,   9,   1,   7,  39,  30,   2,  33,   1,  13,   0,  /* "demobilization" 106025 */
     20,   5,  17,  25,   9,   1,   7,  39,  30,   0,  /* "demobilize" 106035 */
     20,   5,  17,  25,   9,   1,   7,  39,  30,  20,   0,  /* "demobilized" 106046 */
     20,   5,  17,   8,  12,   4,   1,  14,  26,  30,   0,  /* "democracies" 106057 */
     20,   5,  17,   8,  12,   4,   1,  14,  26,   0,  /* "democracy" 106067 */
     20,  21,  17,   1,  12,   4,  24,   3,   0,  /* "democrat" 106076 */
     20,  21,  17,   1,  12,   4,  24,   3,  31,  12,   0,  /* "democratic" 106087 */
     20,  21,  17,   1,  12,   4,  24,   3,  31,  12,   1,   0,  /* "democratica" 106099 */
     20,  21,  17,   1,  12,   4,  24,   3,  31,  12,   7,  26,   0,  /* "democratically" 106112 */
     20,  21,  17,   1,  12,   4,  24,   3,  31,  12,  14,   0,  /* "democratics" 106124 */
     20,   5,  17,   8,  12,   4,   1,   3,   1,  30,   2,  33,   1,  13,   0,  /* "democratization" 106139 */
     20,   5,  17,   8,  12,   4,   1,   3,  39,  30,   0,  /* "democratize" 106150 */
     20,   5,  17,   8,  12,   4,   1,   3,  39,  30,  20,   0,  /* "democratized" 106162 */
     20,   5,  17,   8,  12,   4,   1,   3,  39,  30,  31,  32,   0,  /* "democratizing" 106175 */
     20,  21,  17,   1,  12,   4,  24,   3,  14,   0,  /* "democrats" 106185 */
     20,  23,  17,   8,  40,   1,   7,   2,   3,   0,  /* "demodulate" 106195 */
     20,  23,  17,   8,  40,   1,   7,   2,  33,   1,  13,   0,  /* "demodulation" 106207 */
     20,  15,  17,   8,  11,   4,   1,  37,  10,   0,  /* "demographer" 106217 */
     20,  15,  17,   8,  11,   4,   1,  37,  10,  30,   0,  /* "demographers" 106228 */
     20,  21,  17,   1,  11,   4,  24,  37,  31,  12,   0,  /* "demographic" 106239 */
     20,  21,  17,   1,  11,   4,  24,  37,  31,  12,   7,  26,   0,  /* "demographically" 106252 */
     20,  21,  17,   1,  11,   4,  24,  37,  31,  12,  14,   0,  /* "demographics" 106264 */
     20,  15,  17,   8,  11,   4,   1,  37,  26,   0,  /* "demography" 106274 */
     20,   1,  17,   8,   7,  31,  33,   0,  /* "demolish" 106282 */
     20,  21,  17,   1,   7,   5,  33,   1,  13,   0,  /* "demolition" 106292 */
     20,  23,  17,   1,  13,   0,  /* "demon" 106298 */
     20,   1,  17,   8,  13,  20,   0,  /* "demond" 106305 */
     20,   5,  17,   8,  13,  31,  12,   0,  /* "demonic" 106313 */
     20,  23,  17,   1,  13,   1,  30,   2,  33,   1,  13,   0,  /* "demonization" 106325 */
     20,  23,  17,   1,  13,  39,  30,   0,  /* "demonize" 106333 */
     20,  23,  17,   1,  13,  39,  30,  20,   0,  /* "demonized" 106342 */
     20,  23,  17,   1,  13,  39,  30,  10,   0,  /* "demonizer" 106351 */
     20,  23,  17,   1,  13,  39,  30,   1,  30,   0,  /* "demonizez" 106361 */
     20,  23,  17,   1,  13,  39,  30,  31,  32,   0,  /* "demonizing" 106371 */
     20,  23,  17,   1,  13,  30,   0,  /* "demons" 106378 */
     20,  21,  17,   1,  13,  14,   3,   4,   1,   9,   1,   7,   0,  /* "demonstrable" 106391 */
     20,   5,  17,   8,  13,  14,   3,   4,   1,   9,   7,  26,   0,  /* "demonstrably" 106404 */
     20,   5,  17,   8,  13,  14,   3,   4,   1,   3,  31,  22,   0,  /* "demonstrative" 106417 */
     20,  21,  17,   1,  13,   3,   0,  /* "demont" 106424 */
     20,   1,  17,   8,  13,   3,  26,   0,  /* "demonte" 106432 */
     20,   1,  17,   8,   6,   1,   7,   1,  14,   0,  /* "demopoulos" 106442 */
     20,   5,  17,  18,   4,   1,   7,  39,  30,   0,  /* "demoralize" 106452 */
     20,   5,  17,  18,   4,   1,   7,  39,  30,  20,   0,  /* "demoralized" 106463 */
     20,   5,  17,  18,   4,   1,   7,  39,  30,  31,  32,   0,  /* "demoralizing" 106475 */
     20,  21,  17,  36,   4,   0,  /* "demore" 106481 */
     20,  28,  17,  18,   4,  15,  14,   3,   0,  /* "demorest" 106490 */
     20,   5,  17,  44,  26,   0,  /* "demory" 106496 */
     20,  21,  17,  25,  30,   0,  /* "demos" 106502 */
     20,   1,  17,   8,  14,   0,  /* "demoss" 106508 */
     20,   1,  17,   8,   3,   0,  /* "demott" 106514 */
     20,  21,  17,  29,   7,  34,  13,   0,  /* "demoulin" 106522 */
     20,  21,  17,  19,  22,   0,  /* "demov" 106528 */
     20,  21,  17,   6,  41,  29,  51,   7,  37,   0,  /* "dempewolf" 106538 */
     20,  21,  17,   6,  14,  26,   0,  /* "dempsey" 106545 */
     20,   5,  17,  44,   0,  /* "demur" 106550 */
     20,   5,  17,  41,  45,   4,   0,  /* "demure" 106557 */
     20,   5,  17,  41,  45,   4,   7,  26,   0,  /* "demurely" 106566 */
     20,  23,  17,   1,  14,   0,  /* "demus" 106572 */
     20,  23,  17,   1,  16,   0,  /* "demuth" 106578 */
     20,  26,  17,   5,  14,   3,   1,  37,  39,   0,  /* "demystify" 106588 */
     20,  21,  13,   0,  /* "den" 106592 */
     20,  23,  13,   1,   0,  /* "dena" 106597 */
     20,   1,  13,   8,   6,   1,   7,  26,   0,  /* "denapoli" 106606 */
     20,   1,  13,   8,   4,  20,   0,  /* "denard" 106613 */
     20,   1,  13,  24,   4,  26,   0,  /* "denarii" 106620 */
     20,   1,  13,  24,   4,  26,   1,  14,   0,  /* "denarius" 106629 */
     20,   5,  13,  19,   3,   8,   7,  26,   0,  /* "denatale" 106638 */
     20,  23,  13,  24,  33,   1,  13,   1,   7,   1,  30,   2,  33,   1,  13,   0,  /* "denationalization" 106654 */
     20,  26,  13,  24,  33,   1,  13,   1,   7,   1,  30,   2,  33,   1,  13,  30,   0,  /* "denationalizations" 106671 */
     20,   1,  13,  24,  33,   1,  13,   1,   7,  39,  30,   0,  /* "denationalize" 106683 */
     20,   1,  13,  24,  33,   1,  13,   1,   7,  39,  30,  20,   0,  /* "denationalized" 106696 */
     20,   1,  13,  24,  33,   1,  13,   1,   7,  39,  30,  31,  32,   0,  /* "denationalizing" 106710 */
     20,   1,  13,   2,  42,  10,   0,  /* "denature" 106717 */
     20,   1,  13,   2,  42,  10,  20,   0,  /* "denatured" 106725 */
     20,   5,  13,  25,   0,  /* "denault" 106730 */
     20,  23,  13,   9,  27,   0,  /* "denbo" 106736 */
     20,  23,  13,  20,  31,  32,  10,   0,  /* "dendinger" 106744 */
     20,  15,  13,  20,   4,   5,   3,  31,  12,   0,  /* "dendritic" 106754 */
     20,   5,  13,  25,   0,  /* "deneault" 106759 */
     20,  21,  13,  31,  12,   0,  /* "deneke" 106765 */
     20,  21,  13,   1,  13,   9,  10,  11,   0,  /* "denenberg" 106774 */
     20,  23,  13,  30,   0,  /* "denes" 106779 */
     20,  21,  13,  31,  22,   0,  /* "deneve" 106785 */
     20,  21,  32,   0,  /* "deng" 106789 */
     20,   5,  32,   1,   7,  10,   0,  /* "dengler" 106796 */
     20,  21,  13,  11,   0,  /* "dengue" 106801 */
     20,  21,  13,   1,  17,   0,  /* "denham" 106807 */
     20,  21,  13,  38,  19,   4,   3,   1,  11,   0,  /* "denhartog" 106817 */
     20,  21,  13,  38,  44,  20,  10,   0,  /* "denherder" 106825 */
     20,   1,  13,  39,   1,   9,   5,   7,   1,   3,  26,   0,  /* "deniability" 106837 */
     20,   1,  13,  39,   1,   7,   0,  /* "denial" 106844 */
     20,   1,  13,  39,   1,   7,  30,   0,  /* "denials" 106852 */
     20,   5,  13,  23,  14,   0,  /* "denice" 106858 */
     20,  15,  13,  26,  12,  25,   7,   1,   0,  /* "denicola" 106867 */
     20,   1,  13,  39,  20,   0,  /* "denied" 106873 */
     20,   1,  13,  39,  30,   0,  /* "denies" 106879 */
     20,  21,  13,  31,  11,   4,   2,   3,   0,  /* "denigrate" 106888 */
     20,  21,  13,  31,  11,   4,   2,   3,   1,  20,   0,  /* "denigrated" 106899 */
     20,  21,  13,  31,  11,   4,   2,   3,  31,  32,   0,  /* "denigrating" 106910 */
     20,  21,  13,  31,  11,   4,   5,  14,   0,  /* "denigris" 106919 */
     20,  21,  13,  31,  12,   0,  /* "denike" 106925 */
     20,  23,  13,  26,  27,   0,  /* "denio" 106931 */
     20,   1,  13,   5,   4,  27,   0,  /* "deniro" 106938 */
     20,   1,  13,  23,  14,   0,  /* "denise" 106944 */
     20,  21,  13,   1,  14,   3,  19,  13,   0,  /* "deniston" 106953 */
     20,   2,  13,  26,  30,   0,  /* "deniz" 106959 */
     20,  21,  32,  12,   0,  /* "denk" 106964 */
     20,  21,  13,   7,  23,   0,  /* "denlea" 106970 */
     20,  21,  13,   1,   7,  31,  32,  10,   0,  /* "denlinger" 106979 */
     20,  21,  13,  17,   1,  13,   0,  /* "denmon" 106986 */
     20,  21,  13,   0,  /* "denn" 106990 */
     20,   1,  13,   8,   4,  20,   0,  /* "dennard" 106997 */
     20,  21,  13,   1,   3,   0,  /* "dennett" 107003 */
     20,  21,  13,   1,  14,   3,  19,  13,   0,  /* "denniston" 107012 */
     20,  23,  13,  27,   0,  /* "deno" 107017 */
     20,  21,  13,  27,   9,   1,   7,   0,  /* "denoble" 107025 */
     20,   1,  13,  18,  17,   1,  13,   2,  33,   1,  13,   0,  /* "denomination" 107037 */
     20,   1,  13,  18,  17,   1,  13,   2,  33,   1,  13,   1,   7,   0,  /* "denominational" 107051 */
     20,   1,  13,  18,  17,   1,  13,   2,  33,   1,  13,  30,   0,  /* "denominations" 107064 */
     20,  21,  13,   1,  17,   0,  /* "denomme" 107070 */
     20,   1,  13,  25,  14,   0,  /* "denosse" 107076 */
     20,   2,  13,  29,  17,   8,  13,   0,  /* "denouement" 107084 */
     20,  21,  13,  50,  10,   0,  /* "denoyer" 107090 */
     20,  21,  13,  30,   0,  /* "dens" 107095 */
     20,  21,  13,  14,   1,   3,   8,  17,   1,   3,  10,   0,  /* "densitometer" 107107 */
     20,  21,  13,  14,   7,  26,   0,  /* "densley" 107114 */
     20,  21,  13,  14,   7,  25,   0,  /* "denslow" 107121 */
     20,  23,  13,  14,  17,  36,   4,   0,  /* "densmore" 107129 */
     20,  21,  13,   3,   0,  /* "dent" 107134 */
     20,  21,  13,   3,   1,   7,   0,  /* "dental" 107141 */
     20,  21,  13,   3,   1,   7,  30,   0,  /* "dentals" 107149 */
     20,  21,  13,   3,   0,  /* "dente" 107154 */
     20,  21,  13,   3,   1,  13,   0,  /* "dentin" 107161 */
     20,  21,  13,   3,  26,  13,   0,  /* "dentine" 107168 */
     20,  15,  13,   3,  23,  13,  27,   0,  /* "dentino" 107176 */
     20,  21,  13,   3,   1,  14,   3,   4,  26,   0,  /* "dentistry" 107186 */
     20,  15,  13,   3,   5,  33,   1,  13,   0,  /* "dentition" 107195 */
     20,  28,  13,   3,   4,   2,  17,  19,  13,   3,   0,  /* "dentremont" 107206 */
     20,   1,  13,  29,  42,  26,   0,  /* "denucci" 107213 */
     20,  26,  13,  29,  12,   7,  26,  10,   1,  30,   2,  33,   1,  13,   0,  /* "denuclearization" 107228 */
     20,  26,  13,  29,  12,   7,  26,  10,  39,  30,   0,  /* "denuclearize" 107239 */
     20,  26,  13,  29,  12,   7,  26,  10,  39,  30,  20,   0,  /* "denuclearized" 107251 */
     20,   1,  13,  29,  20,   0,  /* "denude" 107257 */
     20,   1,  13,  29,  20,   1,  20,   0,  /* "denuded" 107265 */
     20,   1,  13,  29,  20,  31,  32,   0,  /* "denuding" 107273 */
     20,   1,  13,  35,  13,  30,  26,  27,   0,  /* "denunzio" 107282 */
     20,  21,  13,  47,   8,   0,  /* "denwa" 107288 */
     20,   1,  13,  39,   0,  /* "deny" 107293 */
     20,   1,  13,  39,  31,  32,   0,  /* "denying" 107300 */
     20,  21,  13,   5,  14,   0,  /* "denys" 107306 */
     20,  21,  13,  30,   0,  /* "denz" 107311 */
     20,  21,  13,  30,   1,   7,   0,  /* "denzil" 107318 */
     20,  23,  27,   0,  /* "deo" 107322 */
     20,  23,   8,   7,  31,  22,   2,   4,   1,   0,  /* "deoliveira" 107332 */
     20,  23,  19,  13,   0,  /* "deon" 107337 */
     20,  26,   8,  12,  14,  26,   4,  39,   9,  27,  13,  29,  12,   7,   2,  31,  12,   0,  /* "deoxyribonucleic" 107355 */
     20,   1,   6,   8,   4,   3,  17,   1,  13,   3,   0,  /* "dep" 107366 */
     20,   1,   6,   8,  42,  26,   0,  /* "depace" 107373 */
     20,   1,   6,   8,   7,  17,   1,   0,  /* "depalma" 107381 */
     20,   1,   6,  48,   7,   1,   0,  /* "depaola" 107388 */
     20,  15,   6,  48,   7,   5,  14,   0,  /* "depaolis" 107396 */
     20,  23,   6,  19,   4,  20,  41,  35,   0,  /* "depardieu" 107405 */
     20,   1,   6,   8,   4,   3,  17,  21,  13,   1,   7,   0,  /* "departmental" 107417 */
     20,   1,   6,   8,   4,   3,  17,  21,  13,   3,   1,   7,  39,  30,   0,  /* "departmentalize" 107432 */
     20,   1,   6,   8,   4,   3,  17,  21,  13,   3,   1,   7,  39,  30,  20,   0,  /* "departmentalized" 107448 */
     20,   1,   6,  19,  14,  12,   8,   7,  26,   0,  /* "depascale" 107458 */
     20,   1,   6,  19,  14,  12,  47,   8,   7,  26,   0,  /* "depasquale" 107469 */
     20,   1,   6,  48,   0,  /* "depauw" 107474 */
     20,   1,   6,  21,  13,  20,   1,   9,   1,   7,   0,  /* "dependable" 107485 */
     20,  26,   6,  44,  14,   1,  13,   1,   7,  39,  30,   0,  /* "depersonalize" 107497 */
     20,   1,   6,  41,  29,   0,  /* "depew" 107503 */
     20,  21,  37,   1,   7,   1,   6,  14,   0,  /* "dephillips" 107512 */
     20,   1,   6,   5,   7,   1,   3,  18,   4,  26,   0,  /* "depilatory" 107523 */
     20,   1,   6,  23,  13,   3,  27,   0,  /* "depinto" 107531 */
     20,   1,   6,   7,  23,   3,  31,  32,   0,  /* "depleting" 107540 */
     20,   1,   6,   7,  18,   4,   1,   9,   1,   7,   0,  /* "deplorable" 107551 */
     20,   1,   6,   7,  18,   4,  20,   0,  /* "deplored" 107559 */
     20,   1,   6,   7,  49,   1,   9,   1,   7,   0,  /* "deployable" 107569 */
     20,  21,   6,  13,  10,   0,  /* "depner" 107575 */
     20,  23,   6,  27,   0,  /* "depo" 107580 */
     20,  26,   6,   8,   6,  41,   1,   7,   2,   3,   0,  /* "depopulate" 107591 */
     20,   1,   6,   8,   6,  41,   1,   7,   2,  33,   1,  13,   0,  /* "depopulation" 107604 */
     20,  23,   6,  36,   4,   3,   2,  33,   1,  13,   0,  /* "deportation" 107615 */
     20,  23,   6,  36,   4,   3,   2,  33,   1,  13,  30,   0,  /* "deportations" 107627 */
     20,  23,   6,  36,   4,   3,  23,   0,  /* "deportee" 107635 */
     20,  23,   6,  36,   4,   3,  23,  30,   0,  /* "deportees" 107644 */
     20,   1,   6,  25,  30,   0,  /* "depose" 107650 */
     20,   1,   6,   8,  30,   1,   3,   1,  20,   0,  /* "deposited" 107660 */
     20,  21,   6,   1,  30,   5,  33,   1,  13,   0,  /* "deposition" 107670 */
     20,  21,   6,   1,  30,   5,  33,   1,  13,   1,   7,   0,  /* "depositional" 107682 */
     20,  21,   6,   1,  30,   5,  33,   1,  13,  30,   0,  /* "depositions" 107693 */
     20,  23,   6,  27,   0,  /* "depot" 107698 */
     20,  23,   6,  27,  30,   0,  /* "depots" 107704 */
     20,  21,   6,  50,   0,  /* "depoy" 107709 */
     20,  21,   6,   0,  /* "depp" 107713 */
     20,  21,   6,   4,   1,  22,   2,  33,   1,  13,   0,  /* "depravation" 107724 */
     20,   1,   6,   4,  24,  22,   1,   3,  26,   0,  /* "depravity" 107734 */
     20,  21,   6,   4,   1,  12,   2,   3,   0,  /* "deprecate" 107743 */
     20,  21,   6,   4,   1,  12,   2,   3,  31,  32,   0,  /* "deprecating" 107754 */
     20,   1,   6,   4,   5,  33,   1,   9,   1,   7,   0,  /* "depreciable" 107765 */
     20,  21,   6,   4,   1,  20,   2,  33,   1,  13,   0,  /* "depredation" 107776 */
     20,  21,   6,   4,   1,  20,   2,  33,   1,  13,  30,   0,  /* "depredations" 107788 */
     20,  21,   6,   4,   1,  13,   5,   7,   0,  /* "deprenyl" 107797 */
     20,   1,   6,   4,  21,  14,  31,  22,   0,  /* "depressive" 107806 */
     20,   1,   6,   4,  21,  33,  10,  39,  30,   0,  /* "depressurize" 107816 */
     20,   1,   6,   4,  21,  33,  10,  39,  30,  20,   0,  /* "depressurized" 107827 */
     20,  21,   6,   4,  26,   0,  /* "deprey" 107833 */
     20,  28,   6,   4,  21,  30,   0,  /* "deprez" 107840 */
     20,  21,   6,  10,  26,   1,  14,   3,   0,  /* "depriest" 107849 */
     20,  21,   6,   4,   1,  22,   2,  33,   1,  13,   0,  /* "deprivation" 107860 */
     20,  21,   6,   4,   1,  22,   2,  33,   1,  13,  30,   0,  /* "deprivations" 107872 */
     20,   1,   6,   4,  39,  22,   0,  /* "deprive" 107879 */
     20,   1,   6,   4,  39,  22,  20,   0,  /* "deprived" 107887 */
     20,   1,   6,   4,  39,  22,  30,   0,  /* "deprives" 107895 */
     20,   1,   6,   4,  39,  22,  31,  32,   0,  /* "depriving" 107904 */
     20,  26,   6,   4,  25,  11,   4,  34,  17,   0,  /* "deprogram" 107914 */
     20,  21,   6,  16,   0,  /* "depth" 107919 */
     20,  21,   6,  16,  14,   0,  /* "depths" 107925 */
     20,  15,   6,   3,  29,   7,   1,   0,  /* "deptula" 107933 */
     20,   1,   6,  41,  29,   0,  /* "depue" 107939 */
     20,  21,   6,  41,   1,   3,  26,  30,   0,  /* "deputies" 107948 */
     20,  21,   6,  41,   1,   3,  39,  30,   0,  /* "deputize" 107957 */
     20,  21,   6,  41,   1,   3,  39,  30,  20,   0,  /* "deputized" 107967 */
     20,  21,   6,  41,   1,   3,  26,   0,  /* "deputy" 107975 */
     20,   1,   6,  47,  23,   0,  /* "depuy" 107981 */
     20,   1,  12,  47,  21,  12,  10,   0,  /* "dequeker" 107989 */
     20,  44,   0,  /* "der" 107992 */
     20,  21,   4,   1,  17,   1,  14,   0,  /* "deramus" 108000 */
     20,  31,   4,   2,  13,  40,   0,  /* "derange" 108007 */
     20,  31,   4,   2,  13,  40,  20,   0,  /* "deranged" 108015 */
     20,  44,  42,   1,  13,   0,  /* "derchin" 108021 */
     20,  31,   4,  12,  25,   7,  26,   0,  /* "dercole" 108029 */
     20,  10,  20,   5,   4,  26,   1,  13,   0,  /* "derderian" 108038 */
     20,  10,  21,  12,   3,  10,   0,  /* "derecktor" 108045 */
     20,  10,  21,  12,   3,   0,  /* "deregt" 108051 */
     20,  26,   4,  21,  11,  41,   1,   7,  28,   3,   0,  /* "deregulate" 108062 */
     20,  26,   4,  21,  11,  41,   1,   7,  28,   3,   1,  20,   0,  /* "deregulated" 108075 */
     20,  26,   4,  21,  11,  41,   1,   7,   2,   3,  31,  32,   0,  /* "deregulating" 108088 */
     20,  26,   4,  21,  11,  41,   1,   7,   2,  33,   1,  13,   0,  /* "deregulation" 108101 */
     20,  26,   4,  21,  11,  41,   1,   7,  28,   3,  10,   0,  /* "deregulator" 108113 */
     20,  26,   4,  21,  11,  41,   1,   7,  28,   3,  10,  30,   0,  /* "deregulators" 108126 */
     20,  26,   4,  21,  11,  41,   1,   7,   1,   3,  18,   4,  26,   0,  /* "deregulatory" 108140 */
     20,  21,   4,  31,  12,   0,  /* "derek" 108146 */
     20,   5,   4,   1,  13,   0,  /* "deren" 108152 */
     20,  31,   4,  21,  13,  30,  27,   0,  /* "derenzo" 108160 */
     20,  44,  37,   1,   7,  31,  32,  10,   0,  /* "derflinger" 108169 */
     20,  44,  38,   1,  17,  10,   0,  /* "derhammer" 108176 */
     20,  21,   4,   1,  20,  10,   0,  /* "deridder" 108183 */
     20,  31,   4,  39,  20,   0,  /* "deride" 108189 */
     20,  31,   4,  39,  20,   1,  20,   0,  /* "derided" 108197 */
     20,  31,   4,  39,  20,  30,   0,  /* "derides" 108204 */
     20,  31,   4,  39,  20,  31,  32,   0,  /* "deriding" 108212 */
     20,  31,   4,  23,  13,  30,  27,   0,  /* "derienzo" 108220 */
     20,   5,   4,  31,  32,   0,  /* "dering" 108226 */
     20,  21,   4,   1,  13,  40,  10,   0,  /* "deringer" 108234 */
     20,  44,  31,  32,   3,   1,  13,   0,  /* "derington" 108242 */
     20,  21,   4,  39,  30,   0,  /* "derise" 108248 */
     20,  10,   5,  14,  31,  22,   0,  /* "derisive" 108255 */
     20,  10,   5,  14,  31,  22,   7,  26,   0,  /* "derisively" 108264 */
     20,  31,   4,  23,  14,  27,   0,  /* "deriso" 108271 */
     20,  21,   4,   1,  22,   2,  33,   1,  13,   0,  /* "derivation" 108281 */
     20,  10,   5,  22,   1,   3,  31,  22,   0,  /* "derivative" 108290 */
     20,  10,   5,  22,   1,   3,  31,  22,  30,   0,  /* "derivatives" 108300 */
     20,  10,  39,  22,   0,  /* "derive" 108305 */
     20,  10,  39,  22,  20,   0,  /* "derived" 108311 */
     20,  10,  39,  22,  30,   0,  /* "derives" 108317 */
     20,  10,  39,  22,  31,  32,   0,  /* "deriving" 108324 */
     20,  44,  12,   0,  /* "derk" 108328 */
     20,  44,  17,   1,   3,   1,   7,   8,  40,  31,  12,   1,   7,   0,  /* "dermatological" 108342 */
     20,  44,  17,   1,  14,   0,  /* "dermis" 108348 */
     20,  44,  13,   0,  /* "dern" 108352 */
     20,  31,   4,  25,  12,  27,   0,  /* "derocco" 108359 */
     20,  21,   4,   1,  12,   0,  /* "deroche" 108365 */
     20,  21,   4,   1,  12,  10,   0,  /* "derocher" 108372 */
     20,  10,   8,  11,   1,   3,  18,   4,  26,   0,  /* "derogatory" 108382 */
     20,  21,   4,  29,   0,  /* "deroo" 108387 */
     20,   5,   4,  29,  30,   0,  /* "deroos" 108393 */
     20,  31,   4,  25,  14,   1,   0,  /* "derosa" 108400 */
     20,  21,   4,   1,  14,   0,  /* "derose" 108406 */
     20,  31,   4,  25,  14,  26,   1,   0,  /* "derosia" 108414 */
     20,  21,   4,   1,  14,  26,  10,   0,  /* "derosier" 108422 */
     20,  10,  47,  21,  13,   0,  /* "derouen" 108428 */
     20,  10,  47,  23,  13,   0,  /* "derouin" 108434 */
     20,  10,  29,  14,   0,  /* "derousse" 108439 */
     20,   5,   4,  50,   0,  /* "deroy" 108444 */
     20,  21,   4,   0,  /* "derr" 108448 */
     20,  31,   4,  23,  12,  27,   0,  /* "derrico" 108455 */
     20,  21,   4,   1,  13,  40,  10,   0,  /* "derringer" 108463 */
     20,  21,   4,  27,   0,  /* "derrow" 108468 */
     20,  21,   4,  26,   0,  /* "derry" 108473 */
     20,  44,  14,   3,  26,  13,   0,  /* "derstine" 108480 */
     20,  21,   4,   1,   9,  39,  30,   0,  /* "derubeis" 108488 */
     20,   5,   4,  29,   3,  10,   0,  /* "deruiter" 108495 */
     20,  31,   4,  29,  12,  27,   0,  /* "deruko" 108502 */
     20,   5,   4,  39,   3,  10,   0,  /* "deruyter" 108509 */
     20,  44,  22,   5,  33,   0,  /* "dervish" 108515 */
     20,  10,  47,   5,  13,  14,  12,  26,   0,  /* "derwinski" 108524 */
     20,  21,   4,  26,   0,  /* "dery" 108529 */
     20,  21,   4,  31,  12,   0,  /* "deryck" 108535 */
     20,  21,   4,   1,   7,   0,  /* "deryle" 108541 */
     20,  21,   0,  /* "des" 108544 */
     20,  28,  14,   8,  26,   0,  /* "desai" 108550 */
     20,  26,  14,   2,   7,   1,  13,   2,  33,   1,  13,   0,  /* "desalination" 108562 */
     20,  26,  14,   2,   7,   1,  13,   1,  30,   2,  33,   1,  13,   0,  /* "desalinization" 108576 */
     20,  15,  14,  24,  32,  12,   3,   1,  14,   0,  /* "desanctis" 108586 */
     20,   1,  14,  19,  13,   3,  26,   8,  11,  27,   0,  /* "desantiago" 108597 */
     20,  28,  14,   8,  13,   3,   1,  14,   0,  /* "desantis" 108606 */
     20,  28,  14,   8,  13,   3,  27,  30,   0,  /* "desantos" 108615 */
     20,  21,  14,  27,   7,  13,  26,  10,  30,   0,  /* "desaulniers" 108625 */
     20,  21,  14,  27,   3,   1,   7,   0,  /* "desautel" 108633 */
     20,  21,  14,  27,   3,   1,   7,  30,   0,  /* "desautels" 108642 */
     20,  28,  12,   8,   4,   6,   1,  13,   3,   4,  26,  30,   0,  /* "descarpentries" 108655 */
     20,  28,  12,   8,   4,   3,   0,  /* "descartes" 108662 */
     20,   1,  14,  21,  13,   3,   0,  /* "descent" 108669 */
     20,   1,  14,  21,  13,   3,  14,   0,  /* "descents" 108677 */
     20,  15,  33,  21,  13,  30,   1,   0,  /* "descenza" 108685 */
     20,  15,  14,  12,   2,  13,   0,  /* "deschaine" 108692 */
     20,  21,  33,   1,  17,   6,  14,   0,  /* "deschamps" 108700 */
     20,  21,  33,  26,  13,  30,   0,  /* "deschenes" 108707 */
     20,  21,  33,  15,   6,  10,   0,  /* "deschepper" 108714 */
     20,  21,  33,   1,   7,  10,   0,  /* "deschler" 108721 */
     20,   1,  14,  12,   4,  39,   9,   1,   9,   1,   7,   0,  /* "describable" 108733 */
     20,   1,  14,  12,   4,  39,   9,   0,  /* "describe" 108741 */
     20,   1,  14,  12,   4,  39,   9,  20,   0,  /* "described" 108750 */
     20,   1,  14,  12,   4,  39,   9,  30,   0,  /* "describes" 108759 */
     20,   1,  14,  12,   4,  39,   9,  31,  32,   0,  /* "describing" 108769 */
     20,  15,  30,   1,  12,   4,   2,   3,   0,  /* "desecrate" 108778 */
     20,  15,  30,   1,  12,   4,   2,   3,   1,  20,   0,  /* "desecrated" 108789 */
     20,  26,  14,  21,  11,   4,   1,  11,   2,   3,   0,  /* "desegregate" 108800 */
     20,  26,  14,  21,  11,   4,  31,  11,   2,   3,   1,  20,   0,  /* "desegregated" 108813 */
     20,  26,  14,  21,  11,   4,   1,  11,   2,  33,   1,  13,   0,  /* "desegregation" 108826 */
     20,   5,  14,  21,  13,   1,   0,  /* "desena" 108833 */
     20,   1,  14,  21,  13,  14,   1,   3,  39,  30,   0,  /* "desensitize" 108844 */
     20,   1,  14,  21,  13,  14,   1,   3,  39,  30,  20,   0,  /* "desensitized" 108856 */
     20,   1,  14,  21,  13,  14,   1,   3,  39,  30,  31,  32,   0,  /* "desensitizing" 108869 */
     20,  21,  14,  10,  21,   3,   0,  /* "deseret" 108876 */
     20,  21,  30,  10,   3,   0,  /* "desert" 108882 */
     20,  31,  30,  44,   3,   0,  /* "desert" 108888 */
     20,   1,  30,  44,   3,   1,  20,   0,  /* "deserted" 108896 */
     20,  21,  30,  10,   3,  10,   0,  /* "deserter" 108903 */
     20,  21,  30,  10,   3,  10,  30,   0,  /* "deserters" 108911 */
     20,  21,  30,  10,   3,  31,  32,   0,  /* "deserting" 108919 */
     20,  21,  30,  10,   3,  14,   0,  /* "deserts" 108926 */
     20,  31,  30,  44,   3,  14,   0,  /* "deserts" 108933 */
     20,  15,  33,   2,  30,   0,  /* "deshaies" 108939 */
     20,  21,  33,   1,  13,   0,  /* "deshane" 108945 */
     20,  28,  33,   8,  30,  27,   0,  /* "deshazo" 108952 */
     20,  21,  33,  26,   7,  20,  30,   0,  /* "deshields" 108960 */
     20,  21,  33,   1,   3,   1,   7,   0,  /* "deshotel" 108968 */
     20,  21,  30,  26,   0,  /* "desi" 108973 */
     20,  21,  14,   1,  12,   2,  33,   1,  13,   0,  /* "desiccation" 108983 */
     20,  15,  14,  26,  20,  21,   4,  26,  27,   0,  /* "desiderio" 108993 */
     20,   1,  30,  39,  13,   0,  /* "design" 108999 */
     20,  21,  30,  31,  11,  13,   2,   3,   0,  /* "designate" 109008 */
     20,  21,  30,  31,  11,  13,   2,   3,   1,  20,   0,  /* "designated" 109019 */
     20,  21,  30,  31,  11,  13,   2,   3,  14,   0,  /* "designates" 109029 */
     20,  21,  30,  31,  11,  13,   2,   3,  31,  32,   0,  /* "designating" 109040 */
     20,  21,  30,  31,  11,  13,   2,  33,   1,  13,   0,  /* "designation" 109051 */
     20,  21,  30,  31,  11,  13,   2,  33,   1,  13,  30,   0,  /* "designations" 109063 */
     20,   1,  30,  39,  13,  12,   4,  24,  37,   3,   0,  /* "designcraft" 109074 */
     20,   1,  30,  39,  13,  20,   0,  /* "designed" 109081 */
     20,  21,  30,  31,  11,  13,  23,   0,  /* "designee" 109089 */
     20,  21,  30,  31,  11,  13,  23,  30,   0,  /* "designees" 109098 */
     20,   1,  30,  39,  13,  10,   0,  /* "designer" 109105 */
     20,   1,  30,  39,  13,  10,  30,   0,  /* "designers" 109113 */
     20,   1,  30,  39,  13,  31,  32,   0,  /* "designing" 109121 */
     20,   1,  30,  39,  13,  30,   0,  /* "designs" 109128 */
     20,  21,  14,   1,   7,   5,   3,  14,   0,  /* "desilets" 109137 */
     20,   5,  14,   5,   7,  10,  30,   0,  /* "desillers" 109145 */
     20,   5,  14,  23,   7,  22,   1,   0,  /* "desilva" 109153 */
     20,   1,  14,  26,  17,  25,  13,  26,   0,  /* "desimone" 109162 */
     20,  23,  14,  26,  27,   0,  /* "desio" 109168 */
     20,   5,  14,   5,   4,   0,  /* "desir" 109174 */
     20,   1,  30,  39,   4,   1,   9,   5,   7,   1,   3,  26,   0,  /* "desirability" 109187 */
     20,   1,  30,  39,   4,   1,   9,   1,   7,   0,  /* "desirable" 109197 */
     20,   1,  30,  39,  10,   0,  /* "desire" 109203 */
     20,   1,  30,  39,  10,  20,   0,  /* "desired" 109210 */
     20,  21,  14,  39,   4,  26,   0,  /* "desiree" 109217 */
     20,   1,  30,  39,  10,  30,   0,  /* "desires" 109224 */
     20,   1,  30,  39,  10,  31,  32,   0,  /* "desiring" 109232 */
     20,   1,  30,  39,   4,   1,  14,   0,  /* "desirous" 109240 */
     20,   1,  14,   5,  14,   3,   0,  /* "desist" 109247 */
     20,   5,  14,  23,  14,   3,  27,   0,  /* "desisto" 109255 */
     20,  21,  14,  43,  19,   4,  20,  34,  13,   0,  /* "desjardin" 109265 */
     20,  21,  14,  43,  19,   4,  20,   5,  13,  30,   0,  /* "desjardins" 109276 */
     20,  21,  14,  43,  19,   4,   7,  28,   0,  /* "desjarlais" 109285 */
     20,  21,  14,  12,   0,  /* "desk" 109290 */
     20,  21,  14,  12,   6,   4,  25,   0,  /* "deskpro" 109298 */
     20,   1,  14,   7,  24,   3,   0,  /* "deslatte" 109305 */
     20,  21,  14,   7,  36,   4,  26,  10,  30,   0,  /* "deslauriers" 109315 */
     20,  23,  14,  17,   1,   0,  /* "desma" 109321 */
     20,  21,  30,  17,  10,  28,   0,  /* "desmarais" 109328 */
     20,  21,  14,  17,  15,   3,   0,  /* "desmet" 109335 */
     20,  21,  14,  17,   1,  20,  30,   0,  /* "desmids" 109343 */
     20,  15,  14,  17,  25,  13,   1,   0,  /* "desmona" 109351 */
     20,  21,  30,  17,   1,  13,  20,   0,  /* "desmond" 109359 */
     20,  21,  14,  13,  50,  10,  30,   0,  /* "desnoyers" 109367 */
     20,  21,  14,   1,   7,   1,   3,   0,  /* "desolate" 109375 */
     20,  21,  14,   1,   7,   2,  33,   1,  13,   0,  /* "desolation" 109385 */
     20,  21,  14,  10,  17,  27,   0,  /* "desormeaux" 109392 */
     20,   5,  14,  25,   3,  27,   0,  /* "desoto" 109399 */
     20,   5,  14,  48,  14,   1,   0,  /* "desousa" 109406 */
     20,  28,  14,  29,  30,   1,   0,  /* "desouza" 109413 */
     20,  21,  14,   6,   4,   1,   3,   0,  /* "desperate" 109421 */
     20,   5,  14,   6,   5,  12,   1,   9,   1,   7,   0,  /* "despicable" 109432 */
     20,   5,  14,   6,  39,  30,   0,  /* "despise" 109439 */
     20,   5,  14,   6,  39,  30,  20,   0,  /* "despised" 109447 */
     20,   5,  14,   6,  39,  30,   1,  30,   0,  /* "despises" 109456 */
     20,   5,  14,   6,  39,   3,   0,  /* "despite" 109463 */
     20,   5,  14,   6,  27,  14,  23,   3,  27,   0,  /* "desposito" 109473 */
     20,  21,  14,   6,   1,   3,   0,  /* "despot" 109480 */
     20,  21,  14,   6,   1,   3,   5,  30,   1,  17,   0,  /* "despotism" 109491 */
     20,  21,  14,   6,  10,  30,   0,  /* "despres" 109498 */
     20,  28,   4,  25,  33,  10,  30,   0,  /* "desrochers" 109506 */
     20,  28,   4,  25,  33,   1,  30,   0,  /* "desroches" 109514 */
     20,  28,   4,  25,  33,  26,  10,   0,  /* "desrosier" 109522 */
     20,  28,   4,  25,  33,  26,  10,  30,   0,  /* "desrosiers" 109531 */
     20,   5,  14,  48,   4,   0,  /* "dessauer" 109537 */
     20,   5,  14,  21,   7,   0,  /* "desselle" 109543 */
     20,   5,  14,  21,  13,   3,   0,  /* "dessent" 109550 */
     20,   5,  30,  44,   3,   0,  /* "dessert" 109556 */
     20,   5,  30,  44,   3,  14,   0,  /* "desserts" 109563 */
     20,  21,  14,   3,   0,  /* "dest" 109568 */
     20,  26,  14,   3,   2,   9,   1,   7,  39,  30,   0,  /* "destabilize" 109579 */
     20,  26,  14,   3,   2,   9,   1,   7,  39,  30,  20,   0,  /* "destabilized" 109591 */
     20,  26,  14,   3,   2,   9,   1,   7,  39,  30,  31,  32,   0,  /* "destabilizing" 109604 */
     20,  21,  14,   3,  21,  12,   0,  /* "destec" 109611 */
     20,   1,  14,   3,   1,  37,   8,  13,  31,  14,   0,  /* "destefanis" 109622 */
     20,   1,  14,   3,  15,  37,   8,  13,  27,   0,  /* "destefano" 109632 */
     20,  21,  14,   3,   1,  13,  26,   0,  /* "destiny" 109640 */
     20,  21,  14,   3,   1,   3,  29,   3,   0,  /* "destitute" 109649 */
     20,  21,  14,   3,   1,   3,  29,  33,   1,  13,   0,  /* "destitution" 109660 */
     20,  21,  14,   1,   7,   3,  18,   4,  26,   0,  /* "desultory" 109670 */
     20,   1,   3,  24,  42,   0,  /* "detach" 109676 */
     20,   1,   3,  24,  42,   1,   9,   1,   7,   0,  /* "detachable" 109686 */
     20,   1,   3,   2,   7,  23,   0,  /* "detailee" 109693 */
     20,  23,   3,  28,   7,  10,   0,  /* "detailer" 109700 */
     20,   1,   3,   2,  13,   0,  /* "detain" 109706 */
     20,  23,   3,  28,  13,  23,   0,  /* "detainee" 109713 */
     20,  15,   3,   8,  17,  36,   4,   0,  /* "detamore" 109721 */
     20,  26,   3,   8,   4,   0,  /* "detar" 109727 */
     20,   1,   3,  21,  12,   3,   1,   9,   1,   7,   0,  /* "detectable" 109738 */
     20,  21,   3,  15,  17,   6,   1,   7,   0,  /* "detemple" 109747 */
     20,  28,   3,   8,  13,   3,   0,  /* "detente" 109754 */
     20,   1,   3,  44,   0,  /* "deter" 109759 */
     20,  21,   3,  10,  20,  31,  32,   0,  /* "deterding" 109767 */
     20,  23,   3,  10,  17,   1,  13,   0,  /* "determan" 109775 */
     20,   1,   3,  44,  17,   1,  13,   1,   9,   1,   7,   0,  /* "determinable" 109787 */
     20,   1,   3,  44,  17,   1,  13,   1,   3,   5,  22,   0,  /* "determinative" 109799 */
     20,   1,   3,  44,  17,   1,  13,   5,  30,   1,  17,   0,  /* "determinism" 109811 */
     20,   1,   3,  44,  20,   0,  /* "deterred" 109817 */
     20,   1,   3,  44,   4,   1,  13,   3,   0,  /* "deterrent" 109826 */
     20,   1,   3,  44,  30,   0,  /* "deters" 109832 */
     20,  21,   3,  10,   3,   0,  /* "detert" 109838 */
     20,  21,  16,   7,  15,  37,  14,   0,  /* "dethlefs" 109846 */
     20,  21,  16,   7,  15,  37,  14,   1,  13,   0,  /* "dethlefsen" 109856 */
     20,   5,  16,  25,  17,   1,  30,   0,  /* "dethomas" 109864 */
     20,  26,  16,   4,  25,  13,   0,  /* "dethrone" 109871 */
     20,  26,  16,   4,  25,  13,  20,   0,  /* "dethroned" 109879 */
     20,  21,   3,  26,  15,  13,   0,  /* "detienne" 109886 */
     20,  21,   3,   7,  15,  37,  14,   1,  13,   0,  /* "detlefsen" 109896 */
     20,  21,   3,   1,  13,   2,   3,   0,  /* "detonate" 109904 */
     20,   5,   3,  18,   4,  26,   0,  /* "detore" 109911 */
     20,   5,   3,  45,   4,   0,  /* "detour" 109917 */
     20,  23,   3,  51,   4,  20,   0,  /* "detoured" 109924 */
     20,   5,   3,  45,   4,  30,   0,  /* "detours" 109931 */
     20,  23,   3,   8,  12,  14,   0,  /* "detox" 109938 */
     20,   1,   3,   8,  12,  14,  31,  12,   2,  33,   1,  13,   0,  /* "detoxication" 109951 */
     20,   1,   3,   8,  12,  14,   1,  37,  31,  12,   2,  33,   1,  13,   0,  /* "detoxification" 109966 */
     20,   1,   3,   8,  12,  14,   1,  37,  39,   0,  /* "detoxify" 109976 */
     20,  26,   3,   4,  24,  12,   3,  10,   0,  /* "detractor" 109985 */
     20,  26,   3,   4,  24,  12,   3,  10,  30,   0,  /* "detractors" 109995 */
     20,  21,   3,   4,   1,  17,   1,  13,   3,   0,  /* "detriment" 110005 */
     20,  21,   3,   4,   1,  17,  21,  13,   3,   1,   7,   0,  /* "detrimental" 110017 */
     20,   1,   3,   4,  39,   3,   1,  14,   0,  /* "detritus" 110026 */
     20,  23,   3,   4,  27,   0,  /* "detro" 110032 */
     20,   1,   3,   4,  49,   3,   0,  /* "detroit" 110039 */
     20,   1,   3,   4,  49,   3,  10,  30,   0,  /* "detroiters" 110048 */
     20,  21,   3,   1,  13,  40,  10,   0,  /* "dettinger" 110056 */
     20,  21,   3,   7,  31,  32,   0,  /* "dettling" 110063 */
     20,  21,   3,  17,  10,   0,  /* "dettmer" 110069 */
     20,   1,   3,  18,   4,  26,   0,  /* "dettore" 110076 */
     20,  21,   3,  10,  12,   0,  /* "deturk" 110082 */
     20,  21,   3,  47,  39,   7,  10,   0,  /* "detweiler" 110090 */
     20,  21,   3,  47,  39,   7,  10,   0,  /* "detwiler" 110098 */
     20,  49,   9,   1,   7,   0,  /* "deubel" 110104 */
     20,  49,   9,   1,   7,  10,   0,  /* "deubler" 110111 */
     20,  29,  14,   0,  /* "deuce" 110115 */
     20,  29,  15,   7,   0,  /* "deuel" 110120 */
     20,  29,  12,  17,   2,  40,  26,   1,  13,   0,  /* "deukmejian" 110130 */
     20,  29,   6,   4,  23,   0,  /* "deupree" 110136 */
     20,  49,  33,   1,   7,   0,  /* "deuschle" 110142 */
     20,  49,  14,  10,   0,  /* "deuser" 110147 */
     20,  29,  14,   0,  /* "deuss" 110151 */
     20,  29,   3,  23,   4,  26,   1,  17,   0,  /* "deuterium" 110160 */
     20,  29,   3,  10,   8,  13,  30,   0,  /* "deuterons" 110168 */
     20,  49,  42,  17,   8,   4,  12,   0,  /* "deutschemark" 110176 */
     20,  49,  42,  17,   8,   4,  12,  14,   0,  /* "deutschemarks" 110185 */
     20,  49,  42,   7,  34,  13,  20,   0,  /* "deutschland" 110193 */
     20,  29,   0,  /* "deux" 110196 */
     20,  21,  22,   0,  /* "dev" 110200 */
     20,   2,  22,   1,   0,  /* "deva" 110205 */
     20,  31,  22,   8,   7,   0,  /* "deval" 110211 */
     20,  28,  22,   8,   7,   0,  /* "devall" 110217 */
     20,  31,  22,  24,   7,   0,  /* "devalle" 110223 */
     20,  31,  22,  24,   7,  41,  29,   2,   3,   0,  /* "devaluate" 110233 */
     20,  31,  22,  24,   7,  41,  29,   2,   3,   1,  20,   0,  /* "devaluated" 110245 */
     20,  31,  22,  24,   7,  41,  29,   2,  33,   1,  13,   0,  /* "devaluation" 110257 */
     20,  23,  22,  34,   7,  41,  29,   2,  33,   1,  13,  30,   0,  /* "devaluations" 110270 */
     20,  31,  22,  24,   7,  41,  29,   0,  /* "devalue" 110278 */
     20,  31,  22,  24,   7,  41,  29,  20,   0,  /* "devalued" 110287 */
     20,  31,  22,  24,   7,  41,  29,  31,  32,   0,  /* "devaluing" 110297 */
     20,  31,  22,   2,  13,   0,  /* "devane" 110303 */
     20,  21,  22,   1,  13,  26,   0,  /* "devaney" 110310 */
     20,  31,  22,  25,   7,   0,  /* "devaul" 110316 */
     20,  31,  22,  25,   0,  /* "devault" 110321 */
     20,  31,  22,  25,   0,  /* "devaux" 110326 */
     20,  31,  22,  25,   0,  /* "deveau" 110331 */
     20,  31,  22,  25,   0,  /* "deveaux" 110336 */
     20,   1,  22,  21,   7,  12,   1,  13,   0,  /* "develcon" 110345 */
     20,   1,  22,  21,   7,   0,  /* "develle" 110351 */
     20,  31,  22,  21,   7,   1,   6,   1,   9,   1,   7,   0,  /* "developable" 110363 */
     20,  31,  22,  21,   7,   1,   6,  31,  32,   0,  /* "developing" 110373 */
     20,  31,  22,  21,   7,   1,   6,  17,   1,  13,   3,   0,  /* "development" 110385 */
     20,  31,  22,  21,   7,   1,   6,  17,  21,  13,   3,   1,   7,   0,  /* "developmental" 110399 */
     20,  31,  22,  21,   7,   1,   6,  17,  21,  13,   3,   1,   7,  26,   0,  /* "developmentally" 110414 */
     20,  31,  22,  21,   7,   1,   6,  17,   1,  13,   3,  14,   0,  /* "developments" 110427 */
     20,  21,  22,   1,  13,  26,   0,  /* "devenny" 110434 */
     20,  31,  22,  21,  13,   6,  36,   4,   3,   0,  /* "devenport" 110444 */
     20,  23,  22,   1,  13,  30,   0,  /* "devens" 110451 */
     20,  31,  22,  23,  13,  26,   0,  /* "deveny" 110458 */
     20,  23,  22,  10,   0,  /* "dever" 110463 */
     20,  28,  22,  21,   4,   1,   0,  /* "devera" 110470 */
     20,  21,  22,  10,  27,   0,  /* "deveraux" 110476 */
     20,  28,  22,  21,   4,  28,   0,  /* "devere" 110483 */
     20,  28,  22,  15,   4,   2,   7,   0,  /* "deverell" 110491 */
     20,  21,  22,  10,  29,   0,  /* "devereux" 110497 */
     20,  21,  22,  10,  49,   0,  /* "deveroy" 110503 */
     20,  31,  22,   2,   0,  /* "devey" 110508 */
     20,  23,  22,  26,  21,  13,  14,  26,   0,  /* "deviancy" 110517 */
     20,  23,  22,  26,   2,   3,   0,  /* "deviate" 110524 */
     20,  26,  22,  26,   2,  33,   1,  13,  30,   0,  /* "deviations" 110534 */
     20,  31,  22,  39,  14,   0,  /* "device" 110540 */
     20,  31,  22,  39,  14,   1,  30,   0,  /* "devices" 110548 */
     20,  21,  22,   1,   7,   9,   1,  14,   0,  /* "devilbiss" 110557 */
     20,  21,  22,   7,  31,  33,   0,  /* "devilish" 110564 */
     20,  21,  22,   1,   7,  31,  33,   7,  26,   0,  /* "devilishly" 110574 */
     20,   1,  22,   5,   7,   0,  /* "deville" 110580 */
     20,   1,  22,   5,   7,  41,  10,   0,  /* "devillier" 110588 */
     20,  28,  22,  23,  13,  14,   1,  13,   3,   0,  /* "devincent" 110598 */
     20,  15,  22,   5,  13,  14,  21,  13,   3,   1,  14,   0,  /* "devincentis" 110610 */
     20,  31,  22,  26,  13,  42,  21,  13,  30,  26,   0,  /* "devincenzi" 110621 */
     20,  31,  22,  26,  13,  42,  21,  13,  30,  27,   0,  /* "devincenzo" 110632 */
     20,   1,  22,  39,  13,   0,  /* "devine" 110638 */
     20,  21,  22,   5,  13,  26,   0,  /* "devinney" 110645 */
     20,  31,  22,  23,  13,  27,   0,  /* "devino" 110652 */
     20,  23,  22,  26,   1,  14,   0,  /* "devious" 110659 */
     20,  31,  22,  39,  30,   0,  /* "devise" 110665 */
     20,  31,  22,  39,  30,  20,   0,  /* "devised" 110672 */
     20,  31,  22,  39,  30,   1,  30,   0,  /* "devises" 110680 */
     20,  31,  22,  39,  30,  31,  32,   0,  /* "devising" 110688 */
     20,  21,  22,   7,   5,  13,   0,  /* "devlin" 110695 */
     20,  31,  22,  25,   0,  /* "devoe" 110700 */
     20,  21,  22,  36,   7,   0,  /* "devol" 110706 */
     20,  21,  22,  27,   7,  20,  10,   0,  /* "devolder" 110714 */
     20,  21,  22,   1,   7,  29,  33,   1,  13,   0,  /* "devolution" 110724 */
     20,  31,  22,   8,   7,  22,   0,  /* "devolve" 110731 */
     20,  31,  22,   8,   7,  22,  20,   0,  /* "devolved" 110739 */
     20,  21,  22,   1,  13,   1,   0,  /* "devona" 110746 */
     20,  31,  22,  25,  13,  26,   1,  13,   0,  /* "devonian" 110755 */
     20,  31,  22,   8,  13,  33,  39,   4,   0,  /* "devonshire" 110764 */
     20,  31,  22,  18,   4,   0,  /* "devor" 110770 */
     20,  21,  22,  10,   0,  /* "devore" 110775 */
     20,  23,  22,  27,  30,   0,  /* "devos" 110781 */
     20,  21,  22,   1,   3,  23,   0,  /* "devotee" 110788 */
     20,  21,  22,   1,   3,  23,  30,   0,  /* "devotees" 110796 */
     20,  31,  22,  48,  10,   0,  /* "devour" 110802 */
     20,  31,  22,  48,  10,  20,   0,  /* "devoured" 110809 */
     20,  31,  22,  48,  10,  31,  32,   0,  /* "devouring" 110817 */
     20,  31,  22,  48,  10,  30,   0,  /* "devours" 110824 */
     20,  21,  22,  50,   0,  /* "devoy" 110829 */
     20,  31,  22,   4,  23,  14,   0,  /* "devries" 110836 */
     20,  21,  22,   4,  26,   0,  /* "devry" 110842 */
     20,  29,   0,  /* "dew" 110845 */
     20,  29,   8,   4,  20,   0,  /* "dewaard" 110851 */
     20,  29,  15,   7,   0,  /* "dewaele" 110856 */
     20,  29,   1,   7,  20,   0,  /* "dewald" 110862 */
     20,  29,   1,   7,   0,  /* "dewall" 110867 */
     20,  29,   1,   7,   3,   0,  /* "dewalt" 110873 */
     20,  29,   1,  13,   0,  /* "dewan" 110878 */
     20,  29,  10,   0,  /* "dewar" 110882 */
     20,  29,  15,   4,   0,  /* "deware" 110887 */
     20,  29,  10,   0,  /* "dewarr" 110891 */
     20,  29,  19,   4,   3,   0,  /* "dewart" 110897 */
     20,   5,  47,   2,  13,   0,  /* "dewayne" 110903 */
     20,  29,   9,  21,   4,  26,   0,  /* "dewberry" 110910 */
     20,  29,   9,  10,   0,  /* "dewbre" 110915 */
     20,  29,  12,   7,  18,   0,  /* "dewclaw" 110921 */
     20,  29,  31,   4,  20,   0,  /* "deweerd" 110927 */
     20,  29,  26,  30,   0,  /* "dewees" 110932 */
     20,  29,  26,  30,   0,  /* "deweese" 110937 */
     20,   1,  47,  39,  14,   0,  /* "deweiss" 110943 */
     20,  21,  47,  15,   7,   0,  /* "dewell" 110949 */
     20,  29,  26,   0,  /* "dewey" 110953 */
     20,  21,  47,  10,  14,   3,   0,  /* "dewhirst" 110960 */
     20,  21,  47,  10,  14,   3,   0,  /* "dewhurst" 110967 */
     20,  23,  47,  39,   7,  20,   0,  /* "dewilde" 110974 */
     20,   1,  47,  39,  13,   0,  /* "dewine" 110980 */
     20,  29,  31,  32,   0,  /* "dewing" 110985 */
     20,  29,   5,  13,   3,  10,   0,  /* "dewinter" 110992 */
     20,  29,  39,   4,   0,  /* "dewire" 110997 */
     20,  29,   1,   3,   0,  /* "dewit" 111002 */
     20,   1,  47,   5,   3,   0,  /* "dewitt" 111008 */
     20,  29,   5,   3,   0,  /* "dewitte" 111013 */
     20,  21,  47,   5,   3,  14,   0,  /* "dewitz" 111020 */
     20,  29,  51,   7,  37,   0,  /* "dewolf" 111026 */
     20,  29,  51,   7,  37,   0,  /* "dewolfe" 111032 */
     20,  23,  47,  51,  20,  26,   0,  /* "dewoody" 111039 */
     20,  29,  30,   0,  /* "dews" 111043 */
     20,  29,   1,   7,  37,   0,  /* "dewulf" 111049 */
     20,  29,  26,   0,  /* "dewy" 111053 */
     20,  21,  12,  14,   0,  /* "dex" 111058 */
     20,  21,  12,  14,   1,  13,  37,   7,  18,   4,   1,  17,  26,  13,   0,  /* "dexfenfluramine" 111073 */
     20,  21,  12,  14,  38,  39,  17,  10,   0,  /* "dexheimer" 111082 */
     20,  21,  12,  14,   3,  10,   0,  /* "dexter" 111089 */
     20,  15,  12,  14,   3,  21,   4,   1,   3,  26,   0,  /* "dexterity" 111100 */
     20,  21,  12,  14,   3,   4,   1,   0,  /* "dextra" 111108 */
     20,  21,  12,  14,   3,   4,  24,  13,   0,  /* "dextran" 111117 */
     20,  15,  12,  14,   3,   4,   1,  16,  18,   4,   1,  37,   1,  13,   0,  /* "dextrathoraphan" 111132 */
     20,  21,  12,  14,   3,   4,  27,   0,  /* "dextro" 111140 */
     20,  21,  12,  14,   3,   4,  27,  14,   0,  /* "dextrose" 111149 */
     20,  21,  12,  14,   3,   4,   1,  14,   0,  /* "dextrous" 111158 */
     20,   2,   0,  /* "dey" 111161 */
     20,   2,  27,   0,  /* "deyo" 111165 */
     20,   2,  27,   0,  /* "deyoe" 111169 */
     20,  21,  41,   1,  32,   0,  /* "deyoung" 111175 */
     20,  28,   3,  18,  13,   0,  /* "deyton" 111181 */
     20,  28,  30,   8,   4,  13,   0,  /* "dezarn" 111188 */
     20,   5,  30,  23,  29,   0,  /* "dezeeuw" 111194 */
     20,  28,  30,  21,   4,  13,   0,  /* "dezern" 111201 */
     20,  23,  21,  37,  20,  35,   9,   1,   7,  41,  29,   0,  /* "dfw" 111213 */
     20,   1,   4,   8,  13,   0,  /* "dhaharan" 111219 */
     20,  35,   4,   8,  13,   0,  /* "dhahran" 111225 */
     20,   1,   4,   8,  13,   0,  /* "dhahran" 111231 */
     20,  39,  13,   0,  /* "dhein" 111235 */
     20,  23,   1,   0,  /* "dhia" 111239 */
     20,   5,   4,   8,  43,   0,  /* "dhiraj" 111245 */
     20,   1,   7,   1,  12,   8,  17,   1,   0,  /* "dhlakama" 111254 */
     20,  38,   8,  13,   3,   0,  /* "dhondt" 111260 */
     20,  23,   0,  /* "di" 111263 */
     20,  23,   1,   0,  /* "dia" 111267 */
     20,  39,   1,   9,   0,  /* "diab" 111272 */
     20,  39,   1,   9,   2,  14,   0,  /* "diabase" 111279 */
     20,  39,   1,   9,   2,  14,  31,  12,   0,  /* "diabasic" 111288 */
     20,  39,   1,   9,  23,   3,  26,  30,   0,  /* "diabetes" 111297 */
     20,  39,   1,   9,  21,   3,  31,  12,   0,  /* "diabetic" 111306 */
     20,  39,   1,   9,  21,   3,  31,  12,  14,   0,  /* "diabetics" 111316 */
     20,  39,  24,   9,   7,  27,   0,  /* "diablo" 111323 */
     20,  39,   1,   9,   8,   7,  31,  12,   1,   7,   0,  /* "diabolical" 111334 */
     20,  39,  24,  12,   1,  13,   1,   3,   0,  /* "diaconate" 111343 */
     20,  39,   1,  12,   4,   5,   3,   1,  12,   0,  /* "diacritic" 111353 */
     20,  39,   1,  12,   4,   5,   3,   1,  12,   1,   7,   0,  /* "diacritical" 111365 */
     20,  39,   1,  20,  21,  17,   0,  /* "diadem" 111372 */
     20,  39,   1,  11,  13,  25,  14,   0,  /* "diagnose" 111380 */
     20,  39,   1,  11,  13,  25,  14,   3,   0,  /* "diagnosed" 111389 */
     20,  39,   1,  11,  13,  25,  14,  26,  30,   0,  /* "diagnoses" 111399 */
     20,  39,   1,  11,  13,  25,  14,  31,  32,   0,  /* "diagnosing" 111409 */
     20,  39,   1,  11,  13,  25,  14,   1,  14,   0,  /* "diagnosis" 111419 */
     20,  39,   1,  11,  13,   8,  14,   3,  15,  12,   0,  /* "diagnostek" 111430 */
     20,  39,   1,  11,  13,   8,  14,   3,  31,  12,   0,  /* "diagnostic" 111441 */
     20,  39,   1,  11,  13,   8,  14,   3,  31,  12,  14,   0,  /* "diagnostics" 111453 */
     20,  39,  24,  11,   1,  13,   1,   7,   0,  /* "diagonal" 111462 */
     20,  39,  24,  11,   1,  13,   1,   7,  26,   0,  /* "diagonally" 111472 */
     20,  39,  24,  11,   1,  13,   1,   7,  30,   0,  /* "diagonals" 111482 */
     20,  39,   1,  11,   4,  24,  17,   0,  /* "diagram" 111490 */
     20,  39,   1,  11,   4,  24,  17,  31,  32,   0,  /* "diagraming" 111500 */
     20,  39,   1,  11,   4,   1,  17,  24,   3,  31,  12,   0,  /* "diagrammatic" 111512 */
     20,  39,   1,  11,   4,  24,  17,  20,   0,  /* "diagrammed" 111521 */
     20,  39,   1,  11,   4,  24,  17,  30,   0,  /* "diagrams" 111530 */
     20,  39,  24,  13,   0,  /* "diahann" 111535 */
     20,  39,   1,   7,   0,  /* "dial" 111540 */
     20,  39,   1,   7,  21,  12,   3,   0,  /* "dialect" 111548 */
     20,  39,   1,   7,  21,  12,   3,  31,  12,   0,  /* "dialectic" 111558 */
     20,  39,   1,   7,  21,  12,   3,  31,  12,   1,   7,   0,  /* "dialectical" 111570 */
     20,  39,   1,   7,  21,  12,   3,  14,   0,  /* "dialects" 111579 */
     20,  39,   1,   7,  20,   0,  /* "dialed" 111585 */
     20,  39,   1,   7,  31,  32,   0,  /* "dialing" 111592 */
     20,  39,   1,   7,  36,  11,   0,  /* "dialog" 111599 */
     20,  39,   1,   7,  18,  11,   0,  /* "dialogue" 111606 */
     20,  39,   1,   7,  18,  11,  30,   0,  /* "dialogues" 111614 */
     20,  39,   1,   7,  30,   0,  /* "dials" 111620 */
     20,  39,   1,   7,   3,  25,  13,   0,  /* "dialtone" 111628 */
     20,  39,  24,   7,   1,  14,   1,  14,   0,  /* "dialysis" 111637 */
     20,  39,   1,  17,  34,  11,  13,  21,   3,  31,  12,   0,  /* "diamagnetic" 111649 */
     20,  39,   1,  17,  24,  11,  13,   1,   3,   5,  30,   1,  17,   0,  /* "diamagnetism" 111663 */
     20,  39,   1,  17,  24,  13,  20,   5,  14,   0,  /* "diamandis" 111673 */
     20,  39,   1,  17,   1,  13,   3,   0,  /* "diamant" 111681 */
     20,  39,   1,  17,  24,  13,   3,   1,   0,  /* "diamanta" 111690 */
     20,  39,   1,  17,   8,  13,   3,  26,   0,  /* "diamante" 111699 */
     20,  39,  24,  17,   1,   3,  10,   0,  /* "diameter" 111707 */
     20,  39,   1,  17,  21,   3,   4,  31,  12,   1,   7,  26,   0,  /* "diametrically" 111720 */
     20,  39,  17,   1,  13,  20,   0,  /* "diamond" 111727 */
     20,  39,  17,   1,  13,  20,  30,   0,  /* "diamonds" 111735 */
     20,  39,   1,  13,   0,  /* "dian" 111740 */
     20,  39,  24,  13,   1,   0,  /* "diana" 111746 */
     20,  39,  24,  13,   0,  /* "diane" 111751 */
     20,  39,   1,  13,  21,   3,  31,  12,  14,   0,  /* "dianetics" 111761 */
     20,  39,   1,  32,  11,  21,   7,  27,   0,  /* "diangelo" 111770 */
     20,  39,  24,  13,   1,   0,  /* "dianna" 111776 */
     20,  39,  24,  13,   0,  /* "dianne" 111781 */
     20,  39,  24,  13,  16,   1,   0,  /* "diantha" 111788 */
     20,  39,  24,  13,  46,  26,   0,  /* "dianthe" 111795 */
     20,  39,  24,  13,  16,  26,   1,   0,  /* "dianthia" 111803 */
     20,  39,   1,  13,   3,  25,  13,  26,  27,   0,  /* "diantonio" 111813 */
     20,  39,   6,  10,   0,  /* "diaper" 111818 */
     20,  39,   6,  10,  31,  32,   0,  /* "diapering" 111825 */
     20,  39,   1,   6,  10,  30,   0,  /* "diapers" 111832 */
     20,  39,   1,  37,  25,  13,  26,   1,   0,  /* "diaphonia" 111841 */
     20,  39,   1,  37,   4,  24,  17,   0,  /* "diaphragm" 111849 */
     20,  39,  24,   6,  14,   1,  20,   0,  /* "diapsid" 111857 */
     20,  39,  10,  26,  30,   0,  /* "diaries" 111863 */
     20,  39,  21,   4,  26,  27,   0,  /* "diario" 111870 */
     20,  39,  10,  23,   1,   0,  /* "diarrhea" 111876 */
     20,  39,  10,  23,   1,   0,  /* "diarrhoea" 111882 */
     20,  39,  10,  26,   0,  /* "diary" 111887 */
     20,  39,   1,  30,   0,  /* "dias" 111892 */
     20,  26,   8,  14,   1,   0,  /* "diasa" 111898 */
     20,  39,   1,  14,   8,  13,  31,  12,   0,  /* "diasonic" 111907 */
     20,  39,   1,  14,   8,  13,  31,  12,  14,   0,  /* "diasonics" 111917 */
     20,  39,  24,  14,   6,  10,   1,   0,  /* "diaspora" 111925 */
     20,  39,   1,  14,   3,   2,  14,   0,  /* "diastase" 111933 */
     20,  39,  24,  14,   3,   1,   7,  23,   0,  /* "diastole" 111942 */
     20,  39,   1,  14,   3,   8,   7,  31,  12,   0,  /* "diastolic" 111952 */
     20,  39,  24,  14,   3,   4,   1,  37,   5,  30,   1,  17,   0,  /* "diastrophism" 111965 */
     20,  39,   1,  16,  44,  17,  26,   0,  /* "diathermy" 111973 */
     20,  39,   1,   3,   8,  17,  31,  12,   0,  /* "diatomic" 111982 */
     20,  39,   1,   3,   8,  17,  30,   0,  /* "diatoms" 111990 */
     20,  39,   1,   3,   8,  13,  31,  12,   0,  /* "diatonic" 111999 */
     20,  39,   1,   3,   4,  39,   9,   0,  /* "diatribe" 112007 */
     20,  39,   1,   3,   4,  39,   9,  30,   0,  /* "diatribes" 112016 */
     20,  23,  24,  30,   0,  /* "diaz" 112021 */
     20,  39,  24,  30,  25,   0,  /* "diazo" 112027 */
     20,   1,   9,   8,  12,  27,   0,  /* "dibacco" 112034 */
     20,   1,   9,   8,   4,  26,   0,  /* "dibari" 112041 */
     20,  23,   9,  19,   4,   3,  25,   7,  27,   0,  /* "dibartolo" 112051 */
     20,  26,   9,  19,   4,   3,  27,   7,  25,  17,  26,  27,   0,  /* "dibartolomeo" 112064 */
     20,  26,   9,  19,   3,  23,  14,   3,   1,   0,  /* "dibattista" 112074 */
     20,   5,   9,   0,  /* "dibb" 112078 */
     20,   5,   9,   1,   7,   0,  /* "dibble" 112084 */
     20,   5,   9,   1,   7,  20,   0,  /* "dibbled" 112091 */
     20,   1,   9,  21,   7,   1,   0,  /* "dibella" 112098 */
     20,   1,   9,  21,   7,  27,   0,  /* "dibello" 112105 */
     20,  26,   9,  15,  13,   1,  20,  21,   3,  27,   0,  /* "dibenedetto" 112116 */
     20,  26,   9,  10,  13,   8,   4,  20,  27,   0,  /* "dibernardo" 112126 */
     20,  23,   9,  26,   8,  14,  26,   0,  /* "dibiase" 112134 */
     20,   1,   9,  26,   8,  14,  26,  27,   0,  /* "dibiasio" 112143 */
     20,  39,   9,   1,   7,   0,  /* "dible" 112149 */
     20,   1,   9,  25,  13,   1,   0,  /* "dibona" 112156 */
     20,   5,   9,   4,   1,   7,   0,  /* "dibrell" 112163 */
     20,   5,   9,  30,   0,  /* "dibs" 112168 */
     20,   1,   9,  47,  25,  13,  27,   0,  /* "dibuono" 112176 */
     20,   5,  12,   0,  /* "dic" 112180 */
     20,  31,  12,  24,  17,   9,   1,   0,  /* "dicamba" 112188 */
     20,  31,  12,  19,  17,   5,   7,  27,   0,  /* "dicamillo" 112197 */
     20,  31,  12,  24,   6,   4,  26,  27,   0,  /* "dicaprio" 112206 */
     20,  39,  14,   0,  /* "dice" 112210 */
     20,  39,  14,   3,   0,  /* "diced" 112215 */
     20,   5,  14,  21,  13,  14,  27,   0,  /* "dicenso" 112223 */
     20,   5,  14,  26,   1,  13,   0,  /* "diceon" 112230 */
     20,   5,  42,  15,  14,   8,   4,  26,   0,  /* "dicesare" 112239 */
     20,  39,  14,  26,   0,  /* "dicey" 112244 */
     20,   5,  12,  26,   8,   4,   1,   0,  /* "dichiara" 112252 */
     20,  39,  12,   8,   3,   1,  17,  26,   0,  /* "dichotomy" 112261 */
     20,  39,  12,   4,  25,  31,  12,   0,  /* "dichroic" 112269 */
     20,  39,  12,   4,  25,  17,   2,   3,   0,  /* "dichromate" 112278 */
     20,  39,  14,  26,  10,   0,  /* "dicier" 112284 */
     20,  31,  42,  25,  42,  26,  27,   0,  /* "dicioccio" 112292 */
     20,   5,  12,   0,  /* "dick" 112296 */
     20,  31,  12,  21,  13,  30,  26,   1,  13,   0,  /* "dickensian" 112306 */
     20,   5,  12,  38,  48,   3,   0,  /* "dickhaut" 112313 */
     20,   5,  12,   7,   1,  17,  21,  13,   3,  28,   0,  /* "diclemente" 112324 */
     20,   5,  12,   1,  17,  15,  20,   0,  /* "dicomed" 112332 */
     20,  39,  12,  19,   3,  14,   0,  /* "dicots" 112339 */
     20,   5,  12,   3,   2,   3,   0,  /* "dictate" 112346 */
     20,  31,  12,   3,   2,   3,   0,  /* "dictate" 112353 */
     20,   5,  12,   3,   2,   3,  14,   0,  /* "dictates" 112361 */
     20,  31,  12,   3,   2,   3,  14,   0,  /* "dictates" 112369 */
     20,  31,  12,   3,   2,  33,   1,  13,   0,  /* "dictation" 112378 */
     20,  31,  12,   3,   2,   3,  10,   0,  /* "dictator" 112386 */
     20,   5,  12,   3,   1,   3,  18,   4,  26,   1,   7,   0,  /* "dictatorial" 112398 */
     20,  31,  12,   3,   2,   3,  10,  30,   0,  /* "dictators" 112407 */
     20,  31,  12,   3,   2,   3,  10,  33,   5,   6,   0,  /* "dictatorship" 112418 */
     20,  31,  12,   3,   2,   3,  10,  33,   5,   6,  14,   0,  /* "dictatorships" 112430 */
     20,  39,  12,   1,  14,   0,  /* "dicus" 112436 */
     20,   5,  20,   0,  /* "did" 112440 */
     20,  39,  20,  24,  12,   3,  31,  12,   0,  /* "didactic" 112449 */
     20,  23,  20,   1,  17,  39,  10,   0,  /* "didemeyer" 112457 */
     20,   5,  20,  26,   8,  12,  14,  26,  14,  39,   3,   1,  20,  39,  13,   0,  /* "dideoxycytidine" 112473 */
     20,  23,  20,  26,   0,  /* "didi" 112478 */
     20,   1,  20,   5,  13,  26,   1,  17,   0,  /* "didinium" 112487 */
     20,  39,  20,  27,   0,  /* "dido" 112492 */
     20,   1,  20,  27,  17,  21,  13,  31,  12,  27,   0,  /* "didomenico" 112503 */
     20,   1,  20,  27,  13,   8,   3,  27,   0,  /* "didonato" 112512 */
     20,   1,  20,   8,  13,   1,   0,  /* "didonna" 112519 */
     20,  39,   0,  /* "die" 112522 */
     20,  39,   9,  25,   7,  20,   0,  /* "diebold" 112529 */
     20,  39,  20,   0,  /* "died" 112533 */
     20,  23,  37,   1,  13,  20,  10,  37,  10,   0,  /* "diefenderfer" 112543 */
     20,  26,   2,  11,  27,   0,  /* "diego" 112549 */
     20,  31,  11,  21,  30,   0,  /* "dieguez" 112555 */
     20,  39,  38,   8,   4,  20,   0,  /* "diehard" 112562 */
     20,  39,  38,   8,   4,  20,  30,   0,  /* "diehards" 112570 */
     20,  23,   7,   0,  /* "diel" 112574 */
     20,  23,  17,   0,  /* "diem" 112578 */
     20,  23,  13,  15,  30,   0,  /* "dienes" 112584 */
     20,  23,   6,   0,  /* "diep" 112588 */
     20,  23,  10,   0,  /* "dier" 112592 */
     20,   5,   4,   1,  13,  40,  10,   0,  /* "dieringer" 112600 */
     20,  39,  10,  12,  31,  32,   0,  /* "dierking" 112607 */
     20,   5,   4,  27,   7,  37,   0,  /* "dierolf" 112614 */
     20,   5,   4,  26,   0,  /* "diery" 112619 */
     20,  39,  30,   0,  /* "dies" 112623 */
     20,  39,  30,   1,  30,   0,  /* "dieses" 112629 */
     20,  39,   1,   3,   0,  /* "diet" 112634 */
     20,  39,   1,   3,  21,   4,  26,   0,  /* "dietary" 112642 */
     20,  23,   3,   1,   7,   0,  /* "dietel" 112648 */
     20,  23,   3,  10,   1,   7,   0,  /* "dieterle" 112655 */
     20,  39,   1,   3,  10,  30,   0,  /* "dieters" 112662 */
     20,  39,   1,   3,  21,   3,  31,  12,   0,  /* "dietetic" 112671 */
     20,  39,   1,   3,  31,  32,   0,  /* "dieting" 112678 */
     20,  39,   1,   3,   5,  33,   1,  13,   0,  /* "dietitian" 112687 */
     20,  39,   1,   3,   5,  33,   1,  13,  30,   0,  /* "dietitians" 112697 */
     20,  39,   1,   3,   7,   0,  /* "dietl" 112703 */
     20,  23,   3,   4,  31,  12,   0,  /* "dietrich" 112710 */
     20,  23,   3,   4,  31,  12,   0,  /* "dietrick" 112717 */
     20,  39,   1,   3,  14,   0,  /* "diets" 112723 */
     20,  23,  42,   0,  /* "dietsch" 112727 */
     20,  23,  42,   0,  /* "dietsche" 112731 */
     20,  39,   1,   3,  30,   0,  /* "dietze" 112737 */
     20,  39,   1,  30,   0,  /* "diez" 112742 */
     20,   1,  37,   2,  30,  26,  27,   0,  /* "difazio" 112750 */
     20,   1,  37,  21,   7,   1,  14,   0,  /* "difelice" 112758 */
     20,   5,  37,   0,  /* "diff" 112762 */
     20,   5,  37,   1,  13,  20,  10,  37,  10,   0,  /* "diffenderfer" 112772 */
     20,   5,  37,  10,  21,  13,  42,  26,   2,   3,   1,  20,   0,  /* "differentiated" 112785 */
     20,   5,  37,  10,  21,  13,  42,  26,   2,   3,  31,  32,   0,  /* "differentiating" 112798 */
     20,   5,  37,   4,   1,  13,   3,   7,  26,   0,  /* "differently" 112808 */
     20,   5,  37,   1,  12,   1,   7,   3,   0,  /* "difficult" 112817 */
     20,   5,  37,   1,  12,   1,   7,   3,  26,  30,   0,  /* "difficulties" 112828 */
     20,   5,  37,   1,  12,   1,   7,   3,   7,  26,   0,  /* "difficultly" 112839 */
     20,   5,  37,  31,  12,  35,   7,   3,  26,   0,  /* "difficulty" 112849 */
     20,   1,  37,   4,  24,  12,   3,   0,  /* "diffract" 112857 */
     20,   1,  37,   4,  24,  12,  33,   1,  13,   0,  /* "diffraction" 112867 */
     20,   1,  37,  41,  29,  14,   0,  /* "diffuse" 112874 */
     20,   1,  37,  41,  29,  30,   0,  /* "diffuse" 112881 */
     20,   1,  37,  41,  29,  30,  20,   0,  /* "diffused" 112889 */
     20,   1,  37,  41,  29,  30,   1,  30,   0,  /* "diffuses" 112898 */
     20,   1,  37,  41,  29,  30,  31,  32,   0,  /* "diffusing" 112907 */
     20,   1,  37,  41,  29,  43,   1,  13,   0,  /* "diffusion" 112916 */
     20,   5,  37,  26,   7,  23,   6,  27,   0,  /* "difilippo" 112925 */
     20,   1,  37,  26,  18,   4,  26,   0,  /* "difiore" 112933 */
     20,   5,  37,  17,   0,  /* "difm" 112938 */
     20,   1,  37,   8,  13,  30,  27,   0,  /* "difonzo" 112946 */
     20,   1,  37,   4,  19,  13,  42,  21,  14,  12,  27,   0,  /* "difrancesco" 112958 */
     20,   1,  37,   4,   8,  13,  12,  27,   0,  /* "difranco" 112967 */
     20,   5,  11,   0,  /* "dig" 112971 */
     20,  31,  40,   1,   3,   8,  13,  27,   0,  /* "digaetano" 112980 */
     20,  31,  40,   1,   7,   8,  12,   1,  14,   0,  /* "digalakis" 112990 */
     20,  31,  11,  24,  13,  40,  26,   0,  /* "digangi" 112998 */
     20,  39,  11,   2,   3,   0,  /* "digate" 113004 */
     20,   5,  11,   9,  26,   0,  /* "digby" 113010 */
     20,  31,  40,  15,  13,   8,   4,  27,   0,  /* "digennaro" 113019 */
     20,  23,  40,  15,  13,  25,  22,   1,   0,  /* "digenova" 113028 */
     20,  31,  40,  10,  27,  13,  23,  17,  27,   0,  /* "digeronimo" 113038 */
     20,  39,  40,  15,  14,   3,   0,  /* "digest" 113045 */
     20,  39,  40,  21,  14,   3,   0,  /* "digest" 113052 */
     20,  39,  40,  21,  14,   3,   1,   9,   1,   7,   0,  /* "digestible" 113063 */
     20,  39,  40,  15,  14,   3,  14,   0,  /* "digests" 113071 */
     20,  39,  40,  21,  14,   3,  14,   0,  /* "digests" 113079 */
     20,   5,  11,  30,   0,  /* "digges" 113084 */
     20,   5,  11,   1,   7,   0,  /* "diggle" 113090 */
     20,  23,  40,   1,  12,  27,  17,  27,   0,  /* "digiacomo" 113099 */
     20,   5,  40,  31,  12,   8,  13,   0,  /* "digicon" 113107 */
     20,   5,  40,   1,  20,  39,  13,   0,  /* "digidyne" 113115 */
     20,  31,  40,  23,   7,  26,  27,   0,  /* "digilio" 113123 */
     20,  31,  40,  18,   4,  40,  26,  27,   0,  /* "digiorgio" 113132 */
     20,   5,  40,   1,   3,  24,   7,   1,  14,   0,  /* "digitalis" 113142 */
     20,   5,  40,   1,   3,  39,  30,   0,  /* "digitize" 113150 */
     20,   5,  40,   1,   3,  39,  30,  20,   0,  /* "digitized" 113159 */
     20,   5,  40,   1,   3,  39,  30,  31,  32,   0,  /* "digitizing" 113169 */
     20,  31,  40,  29,   7,  26,  27,   0,  /* "digiulio" 113177 */
     20,  23,  40,  29,  14,  21,   6,  26,   0,  /* "digiuseppe" 113186 */
     20,   5,  11,  17,   1,  13,   0,  /* "digman" 113193 */
     20,   5,  11,  13,   1,  13,   0,  /* "dignan" 113200 */
     20,   5,  11,  13,   1,  37,  39,  20,   0,  /* "dignified" 113209 */
     20,   5,  11,  13,   1,  37,  39,   0,  /* "dignify" 113217 */
     20,  31,  11,   4,   8,  30,  26,   1,   0,  /* "digrazia" 113226 */
     20,  31,  11,   4,  15,  11,  18,   4,  26,  27,   0,  /* "digregorio" 113237 */
     20,  39,  11,   4,  21,  14,   3,   0,  /* "digressed" 113245 */
     20,  39,  11,   4,  21,  14,  31,  32,   0,  /* "digressing" 113254 */
     20,   5,  11,  30,   0,  /* "digs" 113259 */
     20,  31,  11,  29,  11,   7,  26,  21,   7,  17,  27,   0,  /* "diguglielmo" 113271 */
     20,  23,  24,  13,  26,   0,  /* "diianni" 113277 */
     20,   1,  41,  18,   4,  26,  27,   0,  /* "diiorio" 113285 */
     20,  23,  12,  10,   0,  /* "dijker" 113290 */
     20,  23,  43,   8,  13,   0,  /* "dijon" 113296 */
     20,  39,  12,   0,  /* "dike" 113300 */
     20,  39,  12,  17,   1,  13,   0,  /* "dikeman" 113307 */
     20,  39,  12,  14,   0,  /* "dikes" 113312 */
     20,   5,   7,   1,   3,   2,  33,   1,  13,   0,  /* "dilatation" 113322 */
     20,   5,   7,   1,   3,  18,   4,  26,   0,  /* "dilatory" 113331 */
     20,   1,   7,  18,   4,   1,   0,  /* "dilaura" 113338 */
     20,   5,   7,  20,  23,  13,  26,   0,  /* "dildine" 113346 */
     20,  39,   7,   1,  13,  33,  13,  39,  20,  10,   0,  /* "dilenschneider" 113357 */
     20,   5,   7,  26,  27,   0,  /* "dileo" 113363 */
     20,  39,   7,  30,   0,  /* "diles" 113368 */
     20,   5,   7,  11,   0,  /* "dilg" 113373 */
     20,   1,   7,  26,   9,  21,   4,   3,  27,   0,  /* "diliberto" 113383 */
     20,   5,   7,  31,  40,   1,  13,   3,   0,  /* "diligent" 113392 */
     20,   5,   7,   5,   6,   0,  /* "dilip" 113398 */
     20,  39,   7,   5,  16,  26,   1,  17,   0,  /* "dilithium" 113407 */
     20,   5,   7,   0,  /* "dill" 113411 */
     20,   5,   7,  47,  44,  16,   0,  /* "dillworth" 113418 */
     20,  23,   7,  17,  36,   4,   0,  /* "dilmore" 113425 */
     20,   1,   7,  36,   4,  21,  13,  30,  27,   0,  /* "dilorenzo" 113435 */
     20,   1,   7,  36,   4,  21,   3,  27,   0,  /* "diloreto" 113444 */
     20,   5,   7,  30,   0,  /* "dils" 113449 */
     20,   5,   7,  14,   1,  22,  10,   0,  /* "dilsaver" 113457 */
     20,   5,   7,   3,  23,   1,  30,  21,  17,   0,  /* "diltiazem" 113467 */
     20,   1,   7,  29,   7,  27,   0,  /* "dilullo" 113474 */
     20,  39,   7,  29,   3,   0,  /* "dilute" 113480 */
     20,  39,   7,  29,   3,   1,  20,   0,  /* "diluted" 113488 */
     20,  39,   7,  29,   3,  14,   0,  /* "dilutes" 113495 */
     20,  39,   7,  29,   3,  31,  32,   0,  /* "diluting" 113503 */
     20,  39,   7,  29,  33,   1,  13,   0,  /* "dilution" 113511 */
     20,   1,   7,  29,   3,  31,  22,   0,  /* "dilutive" 113519 */
     20,   1,   7,  29,  30,  26,  27,   0,  /* "diluzio" 113527 */
     20,   5,  17,   0,  /* "dim" 113531 */
     20,   1,  17,  24,  40,  26,  27,   0,  /* "dimaggio" 113539 */
     20,   5,  17,   8,  26,  27,   0,  /* "dimaio" 113546 */
     20,   5,  17,   8,   4,  26,   0,  /* "dimare" 113553 */
     20,   5,  17,   8,   4,  26,   1,   0,  /* "dimaria" 113561 */
     20,  26,  17,  19,   4,  23,  13,  27,   0,  /* "dimarino" 113570 */
     20,   5,  17,   8,   4,  26,  27,   0,  /* "dimario" 113578 */
     20,  23,  17,  19,   4,   3,  23,  13,  27,   0,  /* "dimartino" 113588 */
     20,  39,  17,   1,  30,   0,  /* "dimas" 113594 */
     20,   5,  17,   8,   3,  26,  27,   0,  /* "dimatteo" 113602 */
     20,  39,  17,   0,  /* "dime" 113606 */
     20,   5,  17,  21,   1,  42,  26,   0,  /* "dimenaci" 113614 */
     20,   1,  17,  21,  13,  42,   1,  13,  20,   0,  /* "dimensioned" 113624 */
     20,  23,  17,  26,  27,   0,  /* "dimeo" 113630 */
     20,  39,  17,  10,   0,  /* "dimer" 113635 */
     20,   5,  17,  10,  12,  45,   4,  26,  27,   0,  /* "dimercurio" 113645 */
     20,  39,  17,  30,   0,  /* "dimes" 113650 */
     20,  39,  17,   1,   3,  24,   6,   0,  /* "dimetapp" 113658 */
     20,   5,  17,  26,  42,  21,   7,  26,   0,  /* "dimiceli" 113667 */
     20,   5,  17,  26,  12,  21,   7,  26,   0,  /* "dimichele" 113676 */
     20,  39,  17,  31,  32,   0,  /* "diming" 113682 */
     20,   5,  17,   1,  13,  29,  33,   1,  13,   0,  /* "diminution" 113692 */
     20,   1,  17,   5,  13,  41,   1,   3,  31,  22,   0,  /* "diminutive" 113703 */
     20,   5,  17,  23,   3,   4,  26,  27,  14,   0,  /* "dimitrios" 113713 */
     20,   5,  17,  23,   3,   4,  45,  12,   0,  /* "dimitruk" 113722 */
     20,   5,  17,   7,  26,   0,  /* "dimly" 113728 */
     20,  39,  17,   1,  13,  20,   0,  /* "dimond" 113735 */
     20,  39,  17,  18,   4,  37,   5,  30,   1,  17,   0,  /* "dimorphism" 113746 */
     20,   5,  17,   6,   1,   7,   0,  /* "dimple" 113753 */
     20,   5,  17,   6,   1,   7,  20,   0,  /* "dimpled" 113761 */
     20,   5,  17,  30,   0,  /* "dims" 113766 */
     20,   5,  17,  29,  30,  26,  27,   0,  /* "dimuzio" 113774 */
     20,   5,  13,   0,  /* "din" 113778 */
     20,  23,  13,   1,   0,  /* "dina" 113783 */
     20,  39,  13,   1,   0,  /* "dinah" 113788 */
     20,   5,  13,   1,  13,   0,  /* "dinan" 113794 */
     20,   1,  13,  24,   6,   1,   7,  26,   0,  /* "dinapoli" 113803 */
     20,   5,  13,   8,   4,   0,  /* "dinar" 113809 */
     20,  39,  13,  10,  30,   0,  /* "dinars" 113815 */
     20,  26,  13,  19,   3,   8,   7,  26,   0,  /* "dinatale" 113824 */
     20,  39,  13,   0,  /* "dine" 113828 */
     20,  39,  13,  20,   0,  /* "dined" 113833 */
     20,   1,  13,  23,  13,   0,  /* "dineen" 113839 */
     20,  39,  13,  38,   8,   4,   3,   0,  /* "dinehart" 113847 */
     20,  39,  13,  10,   0,  /* "diner" 113852 */
     20,  39,  13,  10,  30,   0,  /* "diners" 113858 */
     20,  39,  13,  30,   0,  /* "dines" 113863 */
     20,   5,  13,  15,  33,   0,  /* "dinesh" 113869 */
     20,   5,  32,   0,  /* "ding" 113873 */
     20,   5,  32,  11,  26,   0,  /* "dingee" 113879 */
     20,   5,  32,  11,   5,  14,   0,  /* "dingess" 113886 */
     20,   5,  32,   1,  17,   0,  /* "dingham" 113892 */
     20,   5,  32,  26,   0,  /* "dinghy" 113897 */
     20,   5,  32,  11,   1,   7,   0,  /* "dingle" 113904 */
     20,   5,  32,  11,   1,   7,  20,  39,  13,   0,  /* "dingledine" 113914 */
     20,   5,  32,  11,   1,   7,  10,   0,  /* "dingler" 113922 */
     20,   5,  32,  11,  47,   1,   7,   0,  /* "dingwall" 113930 */
     20,   5,  13,   0,  /* "dinh" 113934 */
     20,  23,  13,  26,   0,  /* "dini" 113939 */
     20,  39,  13,  31,  32,   0,  /* "dining" 113945 */
     20,   1,  13,  23,  13,  27,   0,  /* "dinino" 113952 */
     20,  39,  13,  26,   5,  14,   0,  /* "dinius" 113959 */
     20,   5,  32,  12,   0,  /* "dink" 113964 */
     20,   5,  32,  12,   1,  13,  30,   0,  /* "dinkins" 113972 */
     20,   5,  13,  17,  29,  12,   8,  17,  15,  20,   0,  /* "dinmukhamed" 113983 */
     20,   1,  13,  23,  13,   0,  /* "dinneen" 113989 */
     20,   5,  13,  10,   3,  39,  17,   0,  /* "dinnertime" 113997 */
     20,  23,  13,  27,   0,  /* "dino" 114002 */
     20,  39,  13,   1,  14,  18,   4,   0,  /* "dinosaur" 114010 */
     20,  39,  13,   1,  14,  18,   4,  30,   0,  /* "dinosaurs" 114019 */
     20,  39,  13,  27,  14,  21,   9,   0,  /* "dinoseb" 114027 */
     20,   1,  13,  25,   3,  27,   0,  /* "dinoto" 114034 */
     20,  39,  13,   1,   3,  25,   6,  26,   1,   0,  /* "dinotopia" 114044 */
     20,   1,  13,  25,  22,  27,   0,  /* "dinovo" 114051 */
     20,  23,  13,  14,  17,  36,   4,   0,  /* "dinsmore" 114059 */
     20,   5,  13,   3,   0,  /* "dint" 114064 */
     20,   1,  13,  35,  13,  30,  26,  27,   0,  /* "dinunzio" 114073 */
     20,   5,  13,  47,   1,  20,  26,   0,  /* "dinwiddie" 114081 */
     20,  39,   8,  14,   1,  14,   1,  13,   0,  /* "diocesan" 114090 */
     20,  39,   1,  14,  23,  30,   0,  /* "diocese" 114097 */
     20,  39,   1,  14,  23,  30,   0,  /* "dioceses" 114104 */
     20,  26,  27,  20,   8,   3,  26,   0,  /* "diodati" 114112 */
     20,  26,  27,  20,   8,   3,  27,   0,  /* "diodato" 114120 */
     20,  39,  25,  20,   0,  /* "diode" 114125 */
     20,  39,  25,  20,  30,   0,  /* "diodes" 114131 */
     20,  26,  27,  11,   8,   4,  20,  26,   0,  /* "dioguardi" 114140 */
     20,  39,   1,  13,   0,  /* "dion" 114145 */
     20,  26,  25,  13,   1,   0,  /* "diona" 114151 */
     20,  23,  19,  13,   0,  /* "dione" 114156 */
     20,  39,   1,  13,   5,  14,  26,  27,   0,  /* "dionisio" 114165 */
     20,  23,  19,  13,   0,  /* "dionne" 114170 */
     20,  39,   1,  13,   5,  14,  26,   1,  14,   0,  /* "dionysius" 114180 */
     20,  23,  18,   4,   0,  /* "dior" 114185 */
     20,  26,  18,   4,  26,  27,   0,  /* "diorio" 114192 */
     20,  39,  10,  39,   3,   0,  /* "diorite" 114198 */
     20,  23,  27,  14,   0,  /* "dios" 114203 */
     20,  39,   8,  12,  14,  39,  20,   0,  /* "dioxide" 114211 */
     20,  39,   8,  12,  14,  39,  20,  30,   0,  /* "dioxides" 114220 */
     20,  39,   8,  12,  14,   1,  13,   0,  /* "dioxin" 114228 */
     20,  39,   8,  12,  14,   1,  13,  30,   0,  /* "dioxins" 114237 */
     20,   5,   6,   0,  /* "dip" 114241 */
     20,   1,   6,   8,   7,  17,   1,   0,  /* "dipalma" 114249 */
     20,   1,   6,  19,  25,   7,   1,   0,  /* "dipaola" 114257 */
     20,   1,   6,  19,  25,   7,  27,   0,  /* "dipaolo" 114265 */
     20,  26,   6,  19,  14,  12,  47,   8,   7,  26,   0,  /* "dipasquale" 114276 */
     20,   5,   6,  21,   4,  13,   1,   0,  /* "diperna" 114284 */
     20,   5,  37,  16,   5,   4,  26,   1,   0,  /* "diphtheria" 114293 */
     20,  26,   6,  26,   8,   3,  14,   1,   0,  /* "dipiazza" 114302 */
     20,  26,   6,   5,  13,   3,  27,   0,  /* "dipinto" 114310 */
     20,  26,   6,   5,   4,  27,   0,  /* "dipirro" 114317 */
     20,   1,   6,   7,  25,  17,   1,  14,  26,   0,  /* "diplomacy" 114327 */
     20,   5,   6,   7,   1,  17,  24,   3,   0,  /* "diplomat" 114336 */
     20,   5,   6,   7,   1,  17,  24,   3,  31,  12,   0,  /* "diplomatic" 114347 */
     20,   5,   6,   7,   1,  17,  24,   3,  31,  12,   7,  26,   0,  /* "diplomatically" 114360 */
     20,   5,   6,   7,   1,  17,  24,   3,  14,   0,  /* "diplomats" 114370 */
     20,  39,   6,  25,   7,   0,  /* "dipole" 114376 */
     20,   5,   6,   1,   7,   0,  /* "dipple" 114382 */
     20,   5,   6,  25,   7,  20,   0,  /* "dippold" 114389 */
     20,  26,   6,  27,   7,  23,   3,  27,   0,  /* "dippolito" 114398 */
     20,   1,   6,   4,  23,  17,   1,   0,  /* "diprima" 114406 */
     20,   5,   6,  14,   0,  /* "dips" 114411 */
     20,  39,   4,   0,  /* "dire" 114415 */
     20,  31,   4,  21,  12,   3,   1,  20,   0,  /* "directed" 114424 */
     20,  39,   4,  21,  12,   3,  31,  22,  30,   0,  /* "directives" 114434 */
     20,  10,  15,  12,   3,  18,   4,  26,   1,   7,   0,  /* "directorial" 114445 */
     20,  39,   4,  21,  12,   3,  10,  26,  30,   0,  /* "directories" 114455 */
     20,  10,  21,  12,   3,  23,  22,  23,   0,  /* "directv" 114464 */
     20,  31,   4,  21,  13,  30,  27,   0,  /* "direnzo" 114472 */
     20,  39,   4,   1,  14,   3,   0,  /* "direst" 114479 */
     20,  44,   1,  17,  30,   0,  /* "dirhams" 114485 */
     20,  18,   4,  31,  12,  14,   1,  13,   0,  /* "dirickson" 114494 */
     20,  31,   4,  23,  13,  30,  27,   0,  /* "dirienzo" 114502 */
     20,  44,  12,   0,  /* "dirk" 114506 */
     20,  10,   7,  24,  17,   0,  /* "dirlam" 114512 */
     20,  31,   4,   8,  12,  27,   0,  /* "dirocco" 114519 */
     20,  44,   0,  /* "dirr" 114522 */
     20,  44,   3,   0,  /* "dirt" 114526 */
     20,  31,   4,  29,  14,  27,   0,  /* "dirusso" 114533 */
     20,   5,  14,   0,  /* "dis" 114537 */
     20,   5,  14,   1,   0,  /* "disa" 114542 */
     20,   5,  14,  19,   9,  19,   3,  23,  13,  27,   0,  /* "disabatino" 114553 */
     20,   5,  14,  19,   9,   8,   3,  27,   0,  /* "disabato" 114562 */
     20,   5,  14,   2,   9,   1,   7,   0,  /* "disable" 114570 */
     20,   5,  14,   2,   9,   1,   7,  20,   0,  /* "disabled" 114579 */
     20,   5,  14,   2,   9,   1,   7,  30,   0,  /* "disables" 114588 */
     20,   5,  14,   2,   9,   1,   7,  31,  32,   0,  /* "disabling" 114598 */
     20,   5,  14,   1,   9,  41,  29,  14,   0,  /* "disabuse" 114607 */
     20,   5,  14,   1,   9,  41,  29,  30,  20,   0,  /* "disabused" 114617 */
     20,   5,  14,   1,   9,  41,  29,  14,   1,  30,   0,  /* "disabuses" 114628 */
     20,   5,  14,   1,  20,  22,  24,  13,   3,  31,  40,   0,  /* "disadvantage" 114640 */
     20,   5,  14,   1,  20,  22,  24,  13,   3,  31,  40,  20,   0,  /* "disadvantaged" 114653 */
     20,   5,  14,   1,  20,  22,  24,  13,   3,  31,  40,   1,  30,   0,  /* "disadvantages" 114667 */
     20,   5,  14,   1,  11,   4,  23,   1,   9,   1,   7,   0,  /* "disagreeable" 114679 */
     20,   5,  14,   1,   7,  48,   0,  /* "disallow" 114686 */
     20,   5,  14,   1,   7,  48,  20,   0,  /* "disallowed" 114694 */
     20,   5,  14,   1,   7,  48,  31,  32,   0,  /* "disallowing" 114703 */
     20,   5,  14,   8,  13,   3,   5,  14,   0,  /* "disantis" 114712 */
     20,   5,  14,   1,   6,   4,  29,  22,   1,   7,   0,  /* "disapproval" 114723 */
     20,   5,  14,   1,   6,   4,  29,  22,   0,  /* "disapprove" 114732 */
     20,   5,  14,   1,   6,   4,  29,  22,  20,   0,  /* "disapproved" 114742 */
     20,   5,  14,   1,   6,   4,  29,  22,  30,   0,  /* "disapproves" 114752 */
     20,   5,  14,   1,   6,   4,  29,  22,  31,  32,   0,  /* "disapproving" 114763 */
     20,   5,  14,  10,   2,   0,  /* "disarray" 114769 */
     20,   5,  14,   1,  14,  21,  17,   9,   1,   7,   0,  /* "disassemble" 114780 */
     20,   5,  14,   1,  14,  21,  17,   9,   1,   7,  20,   0,  /* "disassembled" 114792 */
     20,   5,  14,   1,  14,  25,  33,  26,  28,   3,   0,  /* "disassociate" 114803 */
     20,   5,  14,   1,  14,  25,  33,  26,  28,   3,   1,  20,   0,  /* "disassociated" 114816 */
     20,   5,  30,  24,  14,   3,  10,   0,  /* "disaster" 114824 */
     20,   5,  30,  24,  14,   3,  10,  30,   0,  /* "disasters" 114833 */
     20,   5,  30,  24,  14,   3,   4,   1,  14,   0,  /* "disastrous" 114843 */
     20,   5,  30,  24,  14,   3,   4,   1,  14,   7,  26,   0,  /* "disastrously" 114855 */
     20,   5,  14,   1,  22,  48,   0,  /* "disavow" 114862 */
     20,   5,  14,   1,  22,  48,  20,   0,  /* "disavowed" 114870 */
     20,   5,  14,   1,  22,  48,  31,  32,   0,  /* "disavowing" 114879 */
     20,   5,  14,   9,   1,   7,  23,  37,   0,  /* "disbelief" 114888 */
     20,   5,  14,   9,   1,   7,  23,  22,   0,  /* "disbelieve" 114897 */
     20,   5,  14,   9,   1,   7,  23,  22,  31,  32,   0,  /* "disbelieving" 114908 */
     20,   5,  14,   9,   4,  52,   0,  /* "disbrow" 114915 */
     20,   5,  14,  12,   0,  /* "disc" 114920 */
     20,   5,  14,  12,   8,   4,  20,  30,   0,  /* "discards" 114929 */
     20,   5,  14,  42,  21,  13,  30,   1,   0,  /* "discenza" 114938 */
     20,   5,  14,  44,  13,   0,  /* "discern" 114944 */
     20,   5,  14,  44,  13,   1,   9,   1,   7,   0,  /* "discernible" 114954 */
     20,   5,  14,  42,  19,   4,  40,   0,  /* "discharge" 114962 */
     20,   5,  14,  42,   8,   4,  40,   0,  /* "discharge" 114970 */
     20,   5,  14,  42,  19,   4,  40,   1,  30,   0,  /* "discharges" 114980 */
     20,   5,  14,  42,   8,   4,  40,   1,  30,   0,  /* "discharges" 114990 */
     20,   5,  33,   1,  13,  40,  10,   0,  /* "dischinger" 114998 */
     20,   1,  14,  39,   6,   1,   7,   0,