#ifndef INCLUDED_QEAUDIOTRAP_H
#define INCLUDED_QEAUDIOTRAP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <eca-chainop.h>
#include <eca-version.h>

class QEVUMeter;

/**
 * Audio trap object is inserted to a ecasound
 * engine instance. When engine delivers a new 
 * block of audio to the trap object, it calls
 * the dataUpdated() callback.
 *
 * @author Kai Vehmanen
 */
class QEAudioTrap : public CHAIN_OPERATOR
{

public: 
  QEAudioTrap(QObject *parent=0, const char *name=0, QEVUMeter* target = 0);
  ~QEAudioTrap(void);

  virtual std::string name(void) const { return("Audio trap"); }

  virtual void init(SAMPLE_BUFFER* sbuf);
  virtual void process(void);

  virtual std::string parameter_names(void) const { return(""); }
#if ECA_LIBECASOUND_VERSION > 7  
  virtual CHAIN_OPERATOR::parameter_t get_parameter(int param) const { return(0.0f); }
  virtual void set_parameter(int param, CHAIN_OPERATOR::parameter_t value) { }
#else
  virtual CHAIN_OPERATOR::parameter_type get_parameter(int param) const { return(0.0f); }
  virtual void set_parameter(int param, CHAIN_OPERATOR::parameter_type value) { }
#endif

#if ECA_LIBECASOUND_VERSION > 7  
  OPERATOR* clone(void) const { return new QEAudioTrap(); }
  OPERATOR* new_expr(void) const { return new QEAudioTrap(); }
#else
  OPERATOR* clone(void) { return new QEAudioTrap(); }
  OPERATOR* new_expr(void) { return new QEAudioTrap(); }
#endif
	
private:

  long int sample_processing_step;
  SAMPLE_BUFFER* buffer_repp;
  int channels_rep;
  QEVUMeter* vumeter_target_repp;
};

#endif
