#ifndef INCLUDED_QEINTERFACE_H
#define INCLUDED_QEINTERFACE_H

#include <string>
#include <qapplication.h>
#include <qwidget.h>
#include <eca-audio-time.h>

using std::string;

class QStatusBar;
class QBoxLayout;
class QLineEdit;
class QAccel;
class QGridLayout;
class QEButtonRow;
class QEChainOperatorInput;
class QEVUMeter;
class ECA_SESSION;
class ECA_CONTROL;

class QEInterface : public QWidget
{
  Q_OBJECT
public:
  QEInterface(QWidget *parent=0, const char *name=0);
  ~QEInterface(void);

  void initialize(void);

  const string& input_name(void) const;
  const string& output_name(void) const;

public slots:
  void close_session(void);
  void start_processing(bool engineonly = false);
  void stop_processing(void);
  void update_processing_parameters(void);
  void update_processing_operator(void);
  void button_rewind_begin(void);
  void button_rewind(void);
  void button_forward(void);
  void set_input_name(const QString& q);
  void set_output_name(const QString& q);

private slots:
  void update_statusbar(void);
  void not_implemented(void);
  void button_input_browse(void);
  void button_output_browse(void);
  void position_update(void);

private:
  ECA_SESSION* esession_repp;
  ECA_CONTROL* ectrl_repp;

  string input_rep;
  string output_rep;
  bool io_changed_rep;
  string current_dir_rep;
  double curpos_rep;
  unsigned long srate_rep;
  unsigned long bufsize_rep;
  
  QEChainOperatorInput* copinput_repp;
  QEButtonRow* buttonrow_repp;
  QEVUMeter* vumeter_repp;

  QBoxLayout* toplayout_repp;
  QAccel* accel_repp;
  QStatusBar* statusbar_repp;
  QGridLayout* io_rows_repp;
  QLineEdit* inputrow_name_repp;
  QLineEdit* inputrow_format_repp;
  QLineEdit* outputrow_name_repp;
  QLineEdit* outputrow_format_repp;

  void init_layout(void);
  void init_buttons();
  void init_statusbar(void);
  void init_bottomrow(QBoxLayout* bottomrow);
  void init_io_rows(void);

  void check_size(void);
  void fetch_defaults_from_jack(void);
};

#endif
