#!/usr/local/bin/tclsh8.0
##
## This little script checks to see if subdirectories
## in a specified list of directories have volumes
## mounted on them and then makes links in the user's
## home directory in the .dfmdesk directory to force
## the dfm filemanager to automagically display newly
## mounted volumes on the desktop.
## Developed under tcl 8.0. Other versions >= 4.2 may work.
##
## Ethan Gold, etgold@cs.columbia.edu
## September 10, 1997
## updated for speed, lower overhead, portability
## 12/16/98
##

## loop delay in seconds
set delay 10

## directories to scan
set dirs [list /mnt]
## set directory where links should show up ~ does not work
#set linkdir "$env(HOME)/Desktop"
set linkdir "$env(HOME)/.dfmdesk"

## whereis mtab?
set mtab /etc/mtab

set verbose 0

## handle background errors
proc bgerror {message} {
    catch {exec echo \
	    "dfm-mount-updater background error: $message" > /dev/console}
    
}


## scan the mount directory for folder and
## check mtab to see if they're up.
proc dirscan {} {
    global dirs mtab linkdir verbose
    
    ## load the contents of the mtab
    if {[file readable $mtab]} {
	  set mtabfd [open $mtab r]
    } else {
	  puts "$mtab unreadable. Exiting."
    }
    
    ## save the mount points and their types
    while {[gets $mtabfd line] >= 0} {
	  set mounts([lindex $line 1]) [lindex $line 2]
    }

    #puts "mounted filesystems: [array names mounts]"

    ## assume fs is set - otherwise we're in trouble!
    foreach dir $dirs {
        set mountdirs [glob -nocomplain $dir/*]
	  set linkdirentries [glob -nocomplain $linkdir/*]
	  foreach item $linkdirentries {
		if {[string compare [file type $item] "link"] == 0} {
		    set links([file readlink $item]) $item
		}
	  }

	  #puts "mount points: $mountdirs"
	  #puts "links in $linkdir: [array names links]"

	  ## check all the mount points
        foreach subdir $mountdirs {
		#puts "checking $subdir"
		## see if they are mounted
		if {[info exists mounts($subdir)]} {
		    #puts "found mounted $subdir"
		    ## if it doesn't exist, make it so
		    if {![info exists links($subdir)]} {
			  ## add it
			  if {$verbose} {puts "linking $subdir to $linkdir"}
			  catch {exec ln -s $subdir $linkdir} errors
			  if {[string length $errors]} {bgerror $errors}
		    }
		    ## if not mounted
		} else {
		    ## if it exists anyway
		    #puts "$subdir not mounted"
		    if {[info exists links($subdir)]} {
			  ## remove it
			  if {$verbose} {
				puts "removing $links($subdir) from $linkdir"
			  }
			  catch {file delete $links($subdir)} errors
			  if {[string length $errors]} {bgerror $errors}
		    }
		}
        }
    }
}


set lastcheck [clock seconds]
## check once first
dirscan
while {1} {
    ## only do dirscan if mtab has
    ## changed since last check
    file stat $mtab filestats
    if {$filestats(mtime) > $lastcheck} {dirscan}
    set lastcheck [clock seconds]
    exec sleep $delay
}
