uses crt;

const xxmax = 80;
      yymax = 200;
      maxby = (xxmax * yymax * 2);

const ScreenBase : word = $B800;
      numby : word = maxby;
      xmax : integer = xxmax;
      ymax : integer = yymax;
      x : integer = 1;
      y : integer = 1;
      fg : byte = 7;
      bg : byte = 0;
      blinking : boolean = false;

var buffer : array[1..maxby] of byte;
    filename : string;
    tgd,tgd2,lastchar : char;

procedure Load(filename : string);
var lfile : file;
    readby : integer;
begin
 ClrScr;

 {$I-}
 Assign(lfile, filename);
 Reset(lfile,1);
 if (IOResult <> 0) then
 begin
   writeln('File "',filename,'"not found!');
   exit;
 end;
 BlockRead(lfile,buffer,numby,readby);
 Close(lfile);
 {$I+}

 Move(mem[seg(buffer):ofs(buffer)], mem[ScreenBase:0], readby);
end;

procedure save(filename : string);
var sfile : file;
    writeby : integer;
begin
 Move(mem[ScreenBase:0],mem[seg(buffer):ofs(buffer)],numby);

 {$I-}
 Assign(sfile, filename);
 Rewrite(sfile,1);
 BlockWrite(sfile,buffer,numby,writeby);
 Close(sfile);
 {$I+}
end;

procedure print(ch : char);
begin
  if (blinking) then
    TextColor(fg+blink)
  else
    TextColor(fg);
  TextBackground(bg);
  write(ch);
end;

begin 
 if (ParamCount <> 1) then
 begin
   writeln;
   writeln('Screen Editor 1.0 by Sven Anders');
   writeln('Usage:');
   writeln('   scredit <filename>');
   writeln;
   writeln('Keys:');
   writeln(' Cursor keys: move cursor');
   writeln('       F1-F8: Forground color 0-7');
   writeln(' Shift F1-F8: Forground color 8-15');
   writeln('  Ctrl F1-F8: Background color 0-7');
   writeln('   Alt F1-F8: Background color 8-15 (blink)');
   writeln('          F9: Repeat last char and x++');
   writeln('         F10: Save to file');
   writeln('     Alt F10: Reload from file');
   writeln;
   exit;
 end;

 ymax:=mem[$40:$84]+1; (* Get the number of lines *)
 numby:=xmax*ymax*2;
 filename := ParamStr(1);
 Load(filename);

 repeat
  gotoxy(x,y);
  tgd:=ReadKey;
  Case tgd of
   #0 : begin
         tgd2:=ReadKey;
         Case tgd2 of
          #72 : Dec(y);
          #80 : Inc(y);
          #75 : Dec(x);
          #77 : Inc(x);
          #67 : begin print(lastchar); Inc(x); end; (* F9 *)
          #68 : Save(filename); (* F10 *)
          #113 : Load(filename); (* Alt F10 *)
          #59..#66 : fg := ord(tgd2)-59;     (* F1..F8 *)
          #84..#91 : fg := ord(tgd2)-84+8;   (* Shift F1..F8 *)
          #94..#101 : begin
                        bg := ord(tgd2)-94;    (* Ctrl F1..F8 *)
                        blinking := false;
                      end;
          #104..#111 : begin
                         bg := ord(tgd2)-104;    (* Alt F1..F8 *)
                         blinking := true;
                       end;
         end;
         if x>xmax then x:=1;
         if x<1 then x:=xmax;
         if y>ymax then y:=1;
         if y<1 then y:=ymax;
        end;
    else
     begin
       print(tgd);
       lastchar:=tgd;
     end;
  end;

 until false;

end.