/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File: octdef.h

Copyright (c) 2001 Octasic Inc. All rights reserved.

Description: Common system definitions

This source code is Octasic Confidential. Use of and access to this code
is covered by the Octasic Device Enabling Software License Agreement. 
Acknowledgement of the Octasic Device Enabling Software License was 
required for access to this code. A copy was also provided with the release.


$Octasic_Release: OCT610xAPI-01.00-PR37 $

$Octasic_Revision: 11 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef __OCTDEF_H__
#define __OCTDEF_H__

/*--------------------------------------------------------------------------
	C language
----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/*****************************  INCLUDE FILES  *******************************/

/*--------------------------------------------------------------------------
	Get Platform Dependency headers 
----------------------------------------------------------------------------*/
#include "octosdependant.h"


/*--------------------------------------------------------------------------
	Common Type definitions
----------------------------------------------------------------------------*/
#include "octtype.h"

/*****************************  DEFINES  *************************************/



/*--------------------------------------------------------------------------
	Miscellaneous constants
----------------------------------------------------------------------------*/

#ifndef PROTO
#define PROTO extern
#endif

/*	Generic return codes */
#define cOCTDEF_RC_OK		0		/* Generic Ok */
#define cOCTDEF_RC_ERROR	1		/* Generic Error */

/* Default return values of all OCTAPI functions.*/
#ifndef GENERIC_OK
#define GENERIC_OK			0x00000000
#endif

#ifndef GENERIC_ERROR
#define GENERIC_ERROR		0x00000001
#endif

#ifndef GENERIC_BAD_PARAM
#define GENERIC_BAD_PARAM	0x00000002
#endif

/* Defines of boolean expressions (TRUE/FALSE)*/
#ifndef FALSE
#define FALSE (BOOL)0
#endif

#ifndef TRUE
#define TRUE  (BOOL)1
#endif

/*--------------------------------------------------------------------------
	DLL Import-Export
----------------------------------------------------------------------------*/

#ifdef OCT_WINENV
#define DLLIMP	__declspec( dllimport )
#define DLLEXP	__declspec( dllexport ) 
#else
#define DLLIMP	
#define DLLEXP	
#endif

/*--------------------------------------------------------------------------
	C language
----------------------------------------------------------------------------*/


#ifdef __cplusplus
}
#endif

#endif /* __OCTDEF_H__ */
