/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: vocofmasterpagedescriptor.cxx,v $
 * $Revision: 1.7 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/contact/vocofmasterpagedescriptor.hxx>
#include <svx/sdr/contact/displayinfo.hxx>
#include <vcl/outdev.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		// basic constructor.
		VOCOfMasterPageDescriptor::VOCOfMasterPageDescriptor(ObjectContact& rObjectContact, ViewContactOfMasterPageDescriptor& rViewContact)
		:	VOCBitmapBuffer(rObjectContact, rViewContact),
			rViewContactOfMasterPageDescriptor(rViewContact)
		{
		}

		// The destructor.
		VOCOfMasterPageDescriptor::~VOCOfMasterPageDescriptor()
		{
		}

		// Prepare deletion of this object.
		void VOCOfMasterPageDescriptor::PrepareDelete()
		{
			// allow ViewContactOfMasterPageDescriptor to buffer the last valid painted
			// buffer of this object to re-use it when re-displaying
			if(maBuffer.BufferIsValid())
			{
				rViewContactOfMasterPageDescriptor.OfferBufferedData(
					maBuffer.GetBufferedBitmap(), maBuffer.GetBufferedMapMode());
			}

			// call parent
			VOCBitmapBuffer::PrepareDelete();
		}

		void VOCOfMasterPageDescriptor::PaintObject(DisplayInfo& rDisplayInfo)
		{
			// see if cached data is available
			OutputDevice* pOriginalOutDev = rDisplayInfo.GetOutputDevice();
			if(pOriginalOutDev && !maBuffer.BufferIsValid())
			{
				Bitmap aBitmap(rViewContactOfMasterPageDescriptor.RequestBufferedData(pOriginalOutDev->GetMapMode()));

				if(!aBitmap.IsEmpty())
				{
					maBuffer.SetBufferedData(pOriginalOutDev->GetMapMode(), aBitmap);
				}
			}

			// call parent
			VOCBitmapBuffer::PaintObject(rDisplayInfo);

			// #i37869# Paint evtl. necessary borders and grids. Paint this over the evtl.
			// buffered MasterPage where those outputs are suppresed by purpose.
			rViewContactOfMasterPageDescriptor.PaintBackgroundPageBordersAndGrids(rDisplayInfo, *this);
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
