/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: tkp_uidl.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef ADC_TKP_UIDL_HXX
#define ADC_TKP_UIDL_HXX

// USED SERVICES
	// BASE CLASSES
#include <tokens/tkp2.hxx>
	// COMPONENTS
	// PARAMETRS

class TkpDocuContext;


namespace csi
{
namespace uidl
{



class Token_Receiver;
class Context_UidlCode;


/** This is a TokenParser which is able to parse tokens from
	C++ source code.
*/
class TokenParser_Uidl : public TokenParse2
{
  public:
	// LIFECYCLE
						TokenParser_Uidl(
							Token_Receiver &	o_rUidlReceiver,
							DYN TkpDocuContext &
												let_drDocuContext );
	virtual				~TokenParser_Uidl();

	// OPERATIONS
  private:
	virtual ::TkpContext &
						CurrentContext();

	virtual void		SetStartContext();
	virtual void        SetCurrentContext(
							TkpContext &		io_rContext );
	// DATA
	Dyn<Context_UidlCode>
						pBaseContext;
	::TkpContext *      pCurContext;
};


}   // namespace uidl
}   // namespace csi

#endif


