/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: appendunixshellword.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef INCLUDED_TOOLS_APPENDUNIXSHELLWORD_HXX
#define INCLUDED_TOOLS_APPENDUNIXSHELLWORD_HXX

#include "sal/config.h"

#if defined UNX

#include "tools/toolsdllapi.h"

namespace rtl {
    class OString;
    class OStringBuffer;
}

namespace tools {

// append arbitrary bytes as a properly quoted Unix-style shell word
//
// @param accumulator
// the string buffer to which the word is appended (without any surrounding
// whitespace); must not be null
//
// @param text
// the text to add
TOOLS_DLLPUBLIC void appendUnixShellWord(
    rtl::OStringBuffer * accumulator, rtl::OString const & text);

}

#endif

#endif
