/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: CustomAnimationCreateDialog.hxx,v $
 * $Revision: 1.9 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SD_CUSTOMANIMATIONCREATEDIALOG_HXX
#define _SD_CUSTOMANIMATIONCREATEDIALOG_HXX

#include "CustomAnimationPreset.hxx"
#include <vcl/tabdlg.hxx>

enum PathKind { NONE, CURVE, POLYGON, FREEFORM };

class TabControl;
class OKButton;
class CancelButton;
class HelpButton;

namespace sd {

// --------------------------------------------------------------------

class CustomAnimationCreateTabPage;
class CustomAnimationPane;

class CustomAnimationCreateDialog : public TabDialog
{
	friend class CustomAnimationCreateTabPage;
public:
	CustomAnimationCreateDialog( ::Window* pParent, CustomAnimationPane* pPane, const std::vector< ::com::sun::star::uno::Any >& rTargets, bool bHasText, const ::rtl::OUString& rsPresetId, double fDuration );
	~CustomAnimationCreateDialog();

	PathKind getCreatePathKind() const;
	CustomAnimationPresetPtr getSelectedPreset() const;
	double getSelectedDuration() const;

private:
	CustomAnimationCreateTabPage* getCurrentPage() const;
	void preview( const CustomAnimationPresetPtr& pPreset ) const;
    void setPosition();
    void storePosition();

	DECL_LINK( implActivatePagekHdl, Control* );
	DECL_LINK( implDeactivatePagekHdl, Control* );

private:
	CustomAnimationPane* mpPane;
	const std::vector< ::com::sun::star::uno::Any >& mrTargets;

	double mfDuration;
	bool mbIsPreview;

	TabControl* mpTabControl;
	OKButton* mpOKButton;
	CancelButton* mpCancelButton;
	HelpButton* mpHelpButton;

	CustomAnimationCreateTabPage* mpTabPages[4];
};

}

#endif // _SD_CUSTOMANIMATIONCREATEDIALOG_HXX
