#ifndef KCHART_DATA_EDITOR_H
#define KCHART_DATA_EDITOR_H


#include <qstrlist.h>
#include <qspinbox.h>

#include <kdialogbase.h>

#include "kchart_part.h"

class QLabel;
class QSpinBox;


namespace KChart
{


class KChartParams;


// This class inherits QSpinBox, but fixes a problem with it.
// Consider the following case:
//
// 1. The SpinBox for rows has the value 4.
// 2. The user enters the number 2 into it.
// 3. The user presses the little up arrow in the spinbox.
// 4. valueChanged(2) is emitted and 2 rows are removed.
// 5. valueChanged(3) is emitted and 1 row is added.
// 
// Now (at least) one row is removed that was never meant to be
// removed and data is lost.  This class fixes that by changing the
// semantics.  So instead of the behaviour of above, the
// valueChanged(2) is never emitted and instead of valueChanged(3),
// valueChanged(5) is emitted.
//


class kchartDataSpinBox : public QSpinBox
{
    Q_OBJECT
public:
    kchartDataSpinBox(QWidget *);
    ~kchartDataSpinBox();

public slots:
    // The user pressed the Up-button
    void stepUp();
    // The user pressed the Down-button
    void stepDown();

protected:
    void interpretText(){;};
    bool eventFilter( QObject *obj, QEvent *ev );

signals:
    // the value is changed (stepUp/stepDown was called or the focus is lost)
    void valueChangedSpecial(int);

private:
    // True if we should ignore the next value change (see above).
    bool  m_ignore;
};

// ----------------------------------------------------------------


// The reason for having a special Table class is to implement keyboard navigation in editing mode.
class kchartDataTable : public QTable
{
    Q_OBJECT
public:
    kchartDataTable(QWidget *);
    ~kchartDataTable();

protected:
    // handles keyboard navigation
    bool eventFilter( QObject *obj, QEvent *ev );
};
// ----------------------------------------------------------------


class kchartDataEditor : public KDialogBase
{
    Q_OBJECT
public:
    kchartDataEditor(QWidget* parent = 0);
    void setData(KoChart::Data* dat);
    void getData(KoChart::Data* dat);
    void setRowLabels(const QStringList &rowLabels);
    void getRowLabels(QStringList &rowLabels);
    void setColLabels(const QStringList &colLabels);
    void getColLabels(QStringList &colLabels);

    bool modified() const { return m_modified; }

private:
    void  addDocs();

signals:
    void applyClicked(kchartDataEditor *ed);

private slots:
    void  slotApply();
    void  setRows(int rows);
    void  setCols(int cols);

    // The user clicked on a header item.
    void  column_clicked(int);
    void  row_clicked(int);

    // Called when something changes in the table.
    void  tableChanged(int row, int col);

    void test();

private:
    // Widgets in the editor
    kchartDataTable    *m_table;
    QLabel             *m_rowsLA;
    kchartDataSpinBox  *m_rowsSB;
    QLabel             *m_colsLA;
    kchartDataSpinBox  *m_colsSB;

    // This member is set to true if the user shrinks the data table,
    // and confirms this by clicking OK in a warning dialog.
    bool  m_userWantsToShrink;

    bool  m_modified;
};

}  //KChart namespace

#endif
