/*
 * XTextCompact.java
 *
 * Created on 6. M?rz 2003, 14:56
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

/**
 * Text handling for StarOffice.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public interface XTextCompact {
    /**
     * Insert text. index=-1 means the end of the text, so the following text will be
     * added at the end of the document's paragraph.
     *
     * @param Accessibility object path
     * @param Text insert index
     * @param Insert text
     */
    public void insertText(String[] path, int index, String insertText);

    /**
     * Move mouse to accessibility object and insert text.
     *
     * @param Accessibility object path
     * @param Text insert index
     * @param Insert text
     */
    public void moveMousetoObject_insertText(String[] path, int index, String insertText);

    /**
     * Delete text. To delete the whole text - startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Delete text start index
     * @param Delete text end index
     */
    public void deleteText(String[] path, int startIndex, int endIndex);

    /**
     * Move mouse to accessibility object and delete text. To delete the whole text -
     * startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Delete text start index
     * @param Delete text end index
     */
    public void moveMousetoObject_deleteText(String[] path, int startIndex, int endIndex);

    /**
     * Replace text.
     *
     * @param Accessibility object path
     * @param Search text
     * @param Insert text
     */
    public void replaceText(String[] path, String text, String replacement);

    /**
     * Replace text. To replace the whole text - startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Replace start index
     * @param Replace end index
     */
    public void replaceText(String[] path, String replacement, int startIndex, int endIndex);

    /**
     * Move mouse to object and replace text.
     *
     * @param Accessibility object path
     * @param Search text
     * @param Insert text
     */
    public void moveMousetoObject_replaceText(String[] path, String text, String replacement);

    /**
     * Move mouse to accessibility object and replace text. To replace the whole text -
     * startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Replace start index
     * @param Replace end index
     */
    public void moveMousetoObject_replaceText(String[] path, String replacement, int startIndex, int endIndex);

    /**
     * Set text
     *
     * @param Accessibility object path
     * @param Set text
     */
    public void setText(String[] path, String replacement);

    /**
     * Move mouse to accessibility object and set text
     *
     * @param Accessibility object path
     * @param Insert text
     */
    public void moveMousetoObject_setText(String[] path, String replacement);

    /**
     * Select text
     *
     * @param Accessibility object path
     * @param Select text
     */
    public void selectText(String[] path, String selectText);

    /**
     * Select text. To select the whole text - startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Select start index
     * @param Select end index
     */
    public void selectText(String[] path, int startIndex, int endIndex);

    /**
     * Move mouse to accessibility object and select text
     *
     * @param Accessibility object path
     * @param Select text
     */
    public void moveMousetoObject_selectText(String[] path, String selectText);

    /**
     * Move mouse to accessibility object and select text. To select the whole text -
     * startindex=0, endindex=-1
     *
     * @param Accessibility object path
     * @param Select start index
     * @param Select end index
     */
    public void moveMousetoObject_selectText(String[] path, int startIndex, int endIndex);

    /**
     * This class returns the methods of this interface. This class is very important for
     * the TutorialCreator class.
     *
     * @author $author$
     * @version $Revision: 1.3 $
     */
    public class XTextCompactMethods {
        private static final Hashtable m_xhash;

        static {
            m_xhash = getXTextCompact();
        }

        /**
         * Get this interface methods
         *
         * @return methods
         */
        public static Hashtable getMethods() {
            return m_xhash;
        }

        /**
         * Insert this interface methods in hashtable object.
         *
         * @return methods
         */
        private static Hashtable getXTextCompact() {
            String[][] insertText = new String[][] { { "typ", "" }, {
                    "method", "insertText" }, {
                    "path", "" }, {
                    "index", "" }, {
                    "insertText", "" }
            };

            String[][] moveMousetoObject_insertText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_insertText" }, {
                    "path", "" }, {
                    "index", "" }, {
                    "insertText", "" }
            };

            String[][] deleteText = new String[][] { { "typ", "" }, {
                    "method", "deleteText" }, {
                    "path", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] moveMousetoObject_deleteText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_deleteText" }, {
                    "path", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] replaceText = new String[][] { { "typ", "" }, {
                    "method", "replaceText" }, {
                    "path", "" }, {
                    "text", "" }, {
                    "replacement", "" }
            };

            String[][] replaceText1 = new String[][] { { "typ", "" }, {
                    "method", "replaceText" }, {
                    "path", "" }, {
                    "replaceText", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] moveMousetoObject_replaceText = new String[][] { { "typ", "" }, {
                    "method", "replaceText" }, {
                    "path", "" }, {
                    "text", "" }, {
                    "replacement", "" }
            };

            String[][] moveMousetoObject_replaceText1 = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_replaceText" }, {
                    "path", "" }, {
                    "replaceText", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] setText = new String[][] { { "typ", "" }, {
                    "method", "setText" }, {
                    "path", "" }, {
                    "replacement", "" }
            };

            String[][] moveMousetoObject_setText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_setText" }, {
                    "path", "" }, {
                    "replacement", "" }
            };

            String[][] selectText = new String[][] { { "typ", "" }, {
                    "method", "selectText" }, {
                    "path", "" }, {
                    "selectText", "" }
            };

            String[][] selectText1 = new String[][] { { "typ", "" }, {
                    "method", "selectText" }, {
                    "path", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            String[][] moveMousetoObject_selectText = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_selectText" }, {
                    "path", "" }, {
                    "selectText", "" }
            };

            String[][] moveMousetoObject_selectText1 = new String[][] { { "typ", "" }, {
                    "method", "moveMousetoObject_selectText" }, {
                    "path", "" }, {
                    "startIndex", "" }, {
                    "endIndex", "" }
            };

            Hashtable xtextCompact = new Hashtable();
            xtextCompact.put("insertText", insertText);
            xtextCompact.put("moveMouse insertText", moveMousetoObject_insertText);
            xtextCompact.put("deleteText", deleteText);
            xtextCompact.put("moveMous deleteText", moveMousetoObject_deleteText);
            xtextCompact.put("replaceText with TEXT and REPLACEMENT", replaceText);
            xtextCompact.put("replaceText with STARTINDEX and ENDINDEX", replaceText1);
            xtextCompact.put("moveMouse replaceText with TEXT and REPLACEMENT", moveMousetoObject_replaceText);
            xtextCompact.put("moveMouse replaceText with STARTINDEX and ENDINDEX", moveMousetoObject_replaceText1);
            xtextCompact.put("setText", setText);
            xtextCompact.put("moveMouse setText", moveMousetoObject_setText);
            xtextCompact.put("selectText with SELECTTEXT", selectText);
            xtextCompact.put("selectText with STARTINDEX and ENDINDEX", selectText1);
            xtextCompact.put("moveMouse selectText with SELECTTEXT", moveMousetoObject_selectText);
            xtextCompact.put("moveMouse selectText with STARTINDEX and ENDINDEX", moveMousetoObject_selectText1);

            return xtextCompact;
        }
    }
}
