/*
 * Desktop.java
 *
 * Created on 24. Februar 2003, 14:56
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.Vector;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.accessibility.AccessibleStateType;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XTopWindow;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Control;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.NameProvider;

/**
 * An abstract class, is meant for requesting the Accessibility objects and providing the
 * infos for the other classes. Futher aspect consists in the control of the mouse and
 * keyboard.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public abstract class Desktop implements com.sun.star.wizards.tutorial.executer.officeHelper.XControl, com.sun.star.wizards.tutorial.executer.officeHelper.XMoveMouseCompact, com.sun.star.wizards.tutorial.executer.officeHelper.XWindow, com.sun.star.wizards.tutorial.executer.officeHelper.XProperties, com.sun.star.wizards.tutorial.executer.officeHelper.XAccessibility {
    private static int MOUSE_SLEEP = 1500;
    private static String m_packageName = "com.sun.star.wizards.tutorial.executer.officeHelper";
    private static String m_docMethodName = "setHelper";

    //*******************************************************************
    //                                                                  *
    //                   abstract methods                               *
    //                                                                  *
    //*******************************************************************

    /**
     * Get Helper
     *
     * @return Helper instance
     */
    public abstract Helper getHelper();

    /**
     * Set Helper
     */
    public abstract void setHelper(Helper helper);

    //*******************************************************************
    //                                                                  *
    //                         Control                                  *
    //                                                                  *
    //*******************************************************************
    public static Object createDocumentInstance(String documentClassName, Helper helper) {
        Object classIntance = null;
        String tempClassName = documentClassName;

        try {
            if (!(tempClassName.indexOf(m_packageName) == 0)) {
                tempClassName = m_packageName + "." + tempClassName;
            }

            Class descriptorsStoreClass = Class.forName(tempClassName);
            classIntance = descriptorsStoreClass.newInstance();

            if (classIntance != null) {
                Class[] paramClazz = new Class[] { helper.getClass()};
                Class clazz = classIntance.getClass();
                Method method = clazz.getMethod(m_docMethodName, paramClazz);

                if (method != null) {
                    Object[] obj = new Object[] { helper };
                    method.invoke(classIntance, obj);
                } else {
                    classIntance = null;
                }
            }
        } catch (java.lang.Exception ex) {
        }

        return classIntance;
    }

    /**
     * Sleeps for the specified time. To catch any InterruptedExceptions that occur,
     * Thread.sleep() may be used instead.
     *
     * @param millis to sleep in milliseconds
     */
    public void sleep(int millis) {
        Control.sleep(millis);
    }

    /**
     * Set the delay values for key, mouse and mouse scroll.
     *
     * @param keyMillis time to delay in milliseconds
     * @param mouseMillis animate speed time to delay in milliseconds
     * @param mouseSleepMillis Mouse animate sleep time to delay in milliseconds
     * @param mouseScrollMillis scroll time to delay in milliseconds
     * @param mouseStep DOCUMENT ME!
     */
    public void setDelay(int keyMillis, int mouseMillis, int mouseSleepMillis, int mouseScrollMillis, int mouseStep) {
        MOUSE_SLEEP = mouseSleepMillis;
        Control.setDelay(keyMillis, mouseMillis, mouseScrollMillis, mouseStep);
    }

    /**
     * Print all properties of starOffice window.
     */
    public void printSetDelayValues() {
        Helper.log("KeyMillis :" + getKeyDelay());
        Helper.log("MouseMillis :" + getMoveMouseDelay());
        Helper.log("MousesleepMillis :" + MOUSE_SLEEP);
        Helper.log("MouseScrollMillis :" + getMouseScrollDelay());
    }

    /**
     * Get After Mouse animate sleep delay.
     *
     * @return Delay value in milliseconds
     */
    public int getMouseSleepDelay() {
        return MOUSE_SLEEP;
    }

    /**
     * Get key delay.
     *
     * @return Delay value in milliseconds
     */
    public int getKeyDelay() {
        return Control.getKeyDelay();
    }

    /**
     * Get mouse delay.
     *
     * @return Delay value in milliseconds
     */
    public int getMoveMouseDelay() {
        return Control.getMoveMouseDelay();
    }

    /**
     * Get mouse scroll delay.
     *
     * @return delay value in milliseconds
     */
    public int getMouseScrollDelay() {
        return Control.getMouseScrollDelay();
    }

    /**
     * Reset key mouse scroll dealy. Set all delay values 0
     */
    public void reset_Key_Mouse_Scroll_Delay() {
        Control.reset_Key_Mouse_Scroll_Delay();
    }

    /**
     * Reset mouse position and set the screen midle points for the mouse position. New
     * mouse position is the screen center.
     */
    public void resetMousePosition() {
        Control.resetMousePosition();
    }

    /**
     * Set mouse position.
     *
     * @param x x position
     * @param y y position
     */
    public void setMousePosition(int x, int y) {
        Control.setMousePosition(x, y);
    }

    /**
     * Moves mouse pointer to given screen coordinates with animate. @
     *
     * @param x position
     * @param y position
     */
    public void mouseAnimate(int x, int y) {
        Control.mouseAnimate(new int[] { x, y });
    }

    /**
     * Moves mouse pointer to given screen coordinates.
     *
     * @param points x and y cordinates.
     */
    public void mouseAnimate(int[] points) {
        Control.mouseAnimate(points);
    }

    /**
     * Move mouse to the specified screen coordinates and click.
     *
     * @param x x cordinate
     * @param y y cordinate
     */
    public void moveMouse_Click(int x, int y) {
        Control.mouseClick(new int[] { x, y });
    }

    /**
     * move mouse to the specified screen coordinates and click.
     *
     * @param points mouse points x and y.
     */
    public void moveMouse_Click(int[] points) {
        Control.mouseClick(points);
    }

    /**
     * Move mouse to the specified screen coordinates and click.
     *
     * @param points mouse points x and y.
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     */
    public void moveMouse_Click(int[] points, String mousClickTyp) {
        Control.mouseClick(points, mousClickTyp);
    }

    /**
     * Move mouse to the specified screen coordinates and click.
     *
     * @param points mouse points x and y.
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     * @param mouseClickTime to mouse click in milliseconds
     */
    public void moveMouse_Click(int[] points, String mousClickTyp, int mouseClickTime) {
        Control.mouseClick(points, mousClickTyp, mouseClickTime);
    }

    /**
     * Mouse scroll.
     *
     * @param scrollTyp typs are 'UP' and 'DOWN'.
     * @param scrollTyp number
     */
    public void mouseScroll(String scrollTyp, int scrollNumber) {
        Control.mouseScroll(scrollTyp, scrollNumber);
    }

    /**
     * Click mouse.
     *
     * @param clickNumber number.
     */
    public void mouseClick(int clickNumber) {
        Control.mouseClick(clickNumber);
    }

    /**
     * Click mouse.
     */
    public void mouseClick() {
        Control.mouseClick();
    }

    /**
     * Click mouse.
     *
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     */
    public void mouseClick(String mousClickTyp) {
        Control.mouseClick(mousClickTyp);
    }

    /**
     * Click mouse.
     *
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     * @param mouseClickTime to mouse click in milliseconds
     */
    public void mouseClick(String mousClickTyp, int mouseClickTime) {
        Control.mouseClick(mousClickTyp, mouseClickTime);
    }

    /**
     * Generates a key press with the given char code
     *
     * @param key as char
     */
    public void key_Press_Release(char key) {
        Control.key_Press_Release(key);
    }

    /**
     * Generates a key press with the given keycode
     *
     * @param keycode as integer
     */
    public void key_Press_Release(int keycode) {
        Control.key_Press_Release(keycode);
    }

    /**
     * set mouse animate activity.
     *
     * @param animate true animate active else deactive
     */
    public void setMouseAnimate(boolean animate) {
        Control.setMouseAnimate(animate);
    }

    /**
     * Print mouse animate status.
     */
    public void printMouseAnimateStatus() {
        Helper.log("Mouse animate status :" + Control.getMouseAnimate());
    }

    /**
     * Get mouse animate status
     *
     * @return status
     */
    public boolean getMouseAnimate() {
        return Control.getMouseAnimate();
    }

    //*******************************************************************
    //                                                                  *
    //                            Properties                            *
    //                                                                  *
    //*******************************************************************

    /**
     * Print all properties of starOffice window.
     *
     * @param windowRole role
     * @param windoName name
     * @param printForm is 'TREE' or 'LINE'
     */
    public void printAllProperties(int windowRole, String windoName, String printForm) {
        try {
            AccessibilityTools.printAccessibleTree(AccessibilityTools.getXAccessible(getHelper().getTopWindows(), windoName, (short) windowRole), printForm);
        } catch (com.sun.star.uno.Exception ex) {
        }
    }

    /**
     * Write the XAccessible tree properties in file.
     *
     * @param windowRole role
     * @param windoName name
     * @param filePath file path
     * @param printForm form are 'Line' or 'Tree'
     */
    public void writeAllProperties(int windowRole, String windoName, String filePath, String printForm) {
        try {
            AccessibilityTools.printAccessibleTree(AccessibilityTools.getXAccessible(getHelper().getTopWindows(), windoName, (short) windowRole), filePath, printForm);
        } catch (com.sun.star.uno.Exception ex) {
        }
    }

    //*******************************************************************
    //                                                                  *
    //                            Window                                *
    //                                                                  *
    //*******************************************************************

    /**
     * Places this window index at the top of the stacking order and shows it in front of
     * any other windows.
     *
     * @param windowName index
     */
    public void windowToFront(String windowName) {
        try {
            int windowIndex = getWindowsNamesList().indexOf(windowName);

            if (windowIndex > -1) {
                windowToFront(windowIndex);
            }
        } catch (com.sun.star.uno.Exception ex) {
        }
    }

    /**
     * Print open staroffice windows names.
     */
    public void printWindowsNames() {
        String[] names = getWindowsNames();

        for (int i = 0; i < names.length; i++) {
            Helper.log("Window name :" + names[i]);
        }
    }

    /**
     * Get all windows names
     *
     * @return names
     */
    public String[] getWindowsNames() {
        ArrayList windowsNames = getWindowsNamesList();
        String[] names = new String[windowsNames.size()];
        names = (String[]) windowsNames.toArray(names);

        return names;
    }

    /**
     * Get all windows names
     *
     * @return names
     */
    public ArrayList getWindowsNamesList() {
        ArrayList windowsNames = new ArrayList();

        try {
            XAccessible[] xAcess = AccessibilityTools.getXAccessibles(getHelper().getTopWindows()); //getXAccessibles();

            if (xAcess != null) {
                int leng = xAcess.length;

                for (int i = 0; i < leng; i++) {
                    if (xAcess[i] != null) {
                        XAccessibleContext xcon = xAcess[i].getAccessibleContext();
                        String name = xcon.getAccessibleName().trim();

                        if ((name != null) && !name.equals("")) {
                            windowsNames.add(name);
                        }
                    }
                }
            }
        } catch (com.sun.star.uno.Exception ex) {
        }

        return windowsNames;
    }

    //*******************************************************************
    //                                                                  *
    //                      move mouse to Object                        *
    //                                                                  *
    //*******************************************************************

    /**
     * Check if the accessibility object is showed on the screen.
     *
     * @param xcon object path
     *
     * @return DOCUMENT ME!
     */
    public XAccessibleContext checkShowing(XAccessibleContext xcon) {
        if ((xcon != null) && !AccessibilityTools.checkState(xcon, AccessibleStateType.SHOWING)) {
            xcon = checkShowing(xcon.getAccessibleParent().getAccessibleContext());
        }

        return xcon;
    }

    /**
     * Move mouse to Accessibility object.
     *
     * @param path object path
     */
    public void moveMousetoObject(String[] path) {
        XAccessibleContext child = getXAccessibleContext(path);

        moveMouse(child, MOUSE_SLEEP);
    }

    /**
     * Move mouse to Accessibility object.
     *
     * @param path object path
     * @param mouseSleepTime slepp time after click
     */
    public void moveMousetoObject_Time(String[] path, int mouseSleepTime) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse(child, mouseSleepTime);
    }

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param path object path
     */
    public void moveMousetoObject_Click(String[] path) {
        moveMousetoObject_Click(path, Control.MOUSE_CLICK_LEFT, 0);
    }

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param path object path
     * @param mousClickTyp type are 'LEFT', 'RIGHT' or 'CENTER'
     * @param mouseClickTime to click in milliseconds
     */
    public void moveMousetoObject_Click(String[] path, String mousClickTyp, int mouseClickTime) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child, mousClickTyp, mouseClickTime, MOUSE_SLEEP);
    }

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param path object path
     * @param mouseSleepTime slepp time after click
     */
    public void moveMousetoObject_Click_Time(String[] path, int mouseSleepTime) {
        moveMousetoObject_Click_Time(path, Control.MOUSE_CLICK_LEFT, 0, mouseSleepTime);
    }

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param path object path
     * @param mousClickTyp type are 'LEFT', 'RIGHT' or 'CENTER'
     * @param mouseClickTime to click in milliseconds
     * @param mouseSleepTime slepp time after click
     */
    public void moveMousetoObject_Click_Time(String[] path, String mousClickTyp, int mouseClickTime, int mouseSleepTime) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child, mousClickTyp, mouseClickTime, mouseSleepTime);
    }

    //*******************************************************************
    //                                                                  *
    //                      protected                                   *
    //                                                                  *
    //*******************************************************************

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param xIf object
     */
    protected void moveMouse_Click(XAccessibleContext xIf) {
        moveMouse_Click(xIf, Control.MOUSE_CLICK_LEFT, 0, 0);
    }

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param xIf child
     * @param mouseSleepTime slepp time after click
     */
    protected void moveMouse_Click(XAccessibleContext xIf, int mouseSleepTime) {
        moveMouse_Click(xIf, Control.MOUSE_CLICK_LEFT, 0, mouseSleepTime);
    }

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param xIf child
     * @param mouseSleepTime slepp time after click
     */
    protected void moveMouse(XAccessibleContext xIf, int mouseSleepTime) {
        if (xIf != null) {
            xIf = checkShowing(xIf);

            if (xIf != null) {
                int[] points = AccessibilityTools.getPoints(xIf);

                if (xIf.getAccessibleRole() == AccessibleRole.MENU_ITEM) {
                    Control.setAnimateStyle(Control.MOUSE_ANIMATE_STYLE_MENU);
                }

                String res = Control.mouseAnimate(points);
                Control.setAnimateStyle(Control.MOUSE_ANIMATE_STYLE_LINE);

                if (res.equals("done")) {
                    sleep(mouseSleepTime);
                }
            }
        }
    }

    /**
     * Move mouse to Accessibility object and click.
     *
     * @param xIf child
     * @param mousClickTyp type are 'LEFT', 'RIGHT' or 'CENTER'
     * @param mouseClickTime to click in milliseconds
     * @param mouseSleepTime slepp time after click
     */
    protected void moveMouse_Click(XAccessibleContext xIf, String mousClickTyp, int mouseClickTime, int mouseSleepTime) {
        if (xIf != null) {
            xIf = checkShowing(xIf);

            if (xIf != null) {
                int[] points = AccessibilityTools.getPoints(xIf);

                if (xIf.getAccessibleRole() == AccessibleRole.MENU_ITEM) {
                    Control.setAnimateStyle(Control.MOUSE_ANIMATE_STYLE_MENU);
                }

                String res = Control.mouseClick(points, mousClickTyp, mouseClickTime);
                Control.setAnimateStyle(Control.MOUSE_ANIMATE_STYLE_LINE);

                if (res.equals("done")) {
                    sleep(mouseSleepTime);
                }
            }
        }
    }

    /**
     * Get accessibility child context
     *
     * @param path object path
     *
     * @return accessibility child
     */
    public XAccessibleContext getXAccessibleContext(String[] path) {
        XAccessibleContext xcon = null;

        try {
            xcon = AccessibilityTools.getXAccessibleContext(getHelper().getActiveTopWindow(), getHelper().getTopWindows(), path);
        } catch (com.sun.star.uno.Exception ex) {
        }

        return xcon;
    }

    /**
     * Get accessibility path of accessibility child.
     *
     * @param xcon child
     *
     * @return Get accessibility path
     */
    public String[] getLocalisationPath(XAccessibleContext xcon) {
        String[] path = null;

        try {
            if (xcon != null) {
                Vector temp = findPath(xcon);

                if (temp != null) {
                    path = (String[]) (temp.toArray(new String[temp.size()]));
                }
            }
        } catch (com.sun.star.uno.Exception ex) {
        }

        return path;
    }

    //*******************************************************************
    //                                                                  *
    //                      private                                     *
    //                                                                  *
    //*******************************************************************

    /**
     * Places this window index at the top of the stacking order and shows it in front of
     * any other windows.
     *
     * @param windowIndex index
     *
     * @throws com.sun.star.uno.Exception DOCUMENT ME!
     */
    private void windowToFront(int windowIndex) throws com.sun.star.uno.Exception {
        XTopWindow xtop = getHelper().getTopWindow(windowIndex);
        xtop.toFront();
    }

    /**
     * Get accessibility path of accessibility child.
     *
     * @param xcon child
     *
     * @return Get accessibility path
     *
     * @throws com.sun.star.uno.Exception DOCUMENT ME!
     */
    private Vector findPath(XAccessibleContext xcon) throws com.sun.star.uno.Exception {
        if (xcon == null) {
            return null;
        }

        String path = "";

        if (xcon.getAccessibleRole() == AccessibleRole.PARAGRAPH) {
            path = NameProvider.getRoleName(xcon.getAccessibleRole()) + "#" + "Paragraph:" + xcon.getAccessibleIndexInParent() + "#";
        } else {
            path = NameProvider.getRoleName(xcon.getAccessibleRole()) + "#" + xcon.getAccessibleName() + "#";
        }

        if (xcon.getAccessibleIndexInParent() > -1) {
            Vector temp = findPath(xcon.getAccessibleParent().getAccessibleContext());

            if (temp != null) {
                path = path + xcon.getAccessibleIndexInParent();
                temp.add(path);
            }

            return temp;
        }

        Vector temp = new Vector();
        int index = AccessibilityTools.getXWindowIndex(getHelper().getTopWindows(), xcon.getAccessibleName(), xcon.getAccessibleRole());

        if ((xcon.getAccessibleRole() == AccessibleRole.FRAME) && xcon.getAccessibleName().equals(getHelper().getCurrentDocumentTitle())) {
            path = "{D}" + path + index;
        } else {
            path = path + index;
        }

        temp.add(path);

        return temp;
    }
}
