package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;

import javax.swing.JPanel;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.uno.UnoRuntime;

/**
 * Display the currently focused accessible object graphically.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class GraphicalDisplay extends JPanel implements IAccessibleObjectDisplay {
    private XAccessibleContext mxContext;
    private double mnScale;
    private double mnHOffset;
    private double mnVOffset;

    /**
     * Create a new graphical widget the displays some of the geometrical information
     * availbable from accessible objects.
     */
    public GraphicalDisplay() {
    }

    /**
     * Paint the graphical representation of the found staroffice object.
     *
     * @param g Graphics
     */
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);

        setupTransformation();

        // Draw the screen representation to give a hint of the location of the
        // accessible object on the screen.
        Dimension aScreenSize = Toolkit.getDefaultToolkit().getScreenSize();

        // Fill the screen rectangle.
        g.setColor(new Color(250, 240, 230));
        g.fillRect((int) (mnHOffset + 0.5), (int) (mnVOffset + 0.5), (int) (mnScale * aScreenSize.getWidth()), (int) (mnScale * aScreenSize.getHeight()));

        // Draw a frame arround the screen rectangle to increase its visibility.
        g.setColor(Color.BLACK);
        g.drawRect((int) (mnHOffset + 0.5), (int) (mnVOffset + 0.5), (int) (mnScale * aScreenSize.getWidth()), (int) (mnScale * aScreenSize.getHeight()));

        // Now do the actual display of the accessible object.
        drawAccessibleObject(g, mxContext, Color.GREEN);
    }

    /**
     * Not implemented
     *
     * @param g
     */
    public synchronized void paintChildren(Graphics g) {
    }

    /**
     * Not implemented
     *
     * @param g
     */
    public synchronized void paintBorder(Graphics g) {
    }

    /**
     * Draw a simple representation of the given accessible object in the specified
     * color.
     *
     * @param g
     * @param xContext object context
     * @param aColor
     */
    public void drawAccessibleObject(Graphics g, XAccessibleContext xContext, Color aColor) {
        try {
            if (xContext != null) {
                // First draw our parent.
                XAccessible xParent = xContext.getAccessibleParent();

                if (xParent != null) {
                    drawAccessibleObject(g, xParent.getAccessibleContext(), Color.GRAY);
                }

                // When the context supports the XAccessibleComponent interface
                // then draw its outline.
                XAccessibleComponent xComponent = (XAccessibleComponent) UnoRuntime.queryInterface(XAccessibleComponent.class, xContext);

                if (xComponent != null) {
                    // Get size and location on screen and transform them to fit
                    // everything inside this widget.
                    Point aLocation = xComponent.getLocationOnScreen();
                    Size aSize = xComponent.getSize();
                    g.setColor(aColor);
                    g.drawRect((int) (mnHOffset + (mnScale * aLocation.X) + 0.5), (int) (mnVOffset + (mnScale * aLocation.Y) + 0.5), (int) (mnScale * aSize.Width), (int) (mnScale * aSize.Height));
                }
            }
        } catch (com.sun.star.lang.DisposedException de) {
        }
    }

    /**
     * Set the accessible object to display.  Call this method e.g. when a new object has
     * been focused.
     *
     * @param xContext object context
     */
    public synchronized void setAccessibleObject(XAccessibleContext xContext) {
        mxContext = xContext;
        repaint();
    }

    /**
     * Update GUI
     *
     * @param xContext object context
     */
    public synchronized void updateAccessibleObject(XAccessibleContext xContext) {
        mxContext = xContext;
        repaint();
    }

    /**
     * Set up the transformation so that the graphical display can show a centered
     * representation of the whole screen.
     */
    private void setupTransformation() {
        Dimension aScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension aWidgetSize = getSize();

        if ((aScreenSize.getWidth() > 0) && (aScreenSize.getHeight() > 0)) {
            // Calculate the scales that would map the screen onto the
            // widget in both of the coordinate axes and select the smaller
            // of the two: it maps the screen onto the widget in both axes
            // at the same time.
            double nHScale = (aWidgetSize.getWidth() - 10) / aScreenSize.getWidth();
            double nVScale = (aWidgetSize.getHeight() - 10) / aScreenSize.getHeight();

            if (nHScale < nVScale) {
                mnScale = nHScale;
            } else {
                mnScale = nVScale;
            }

            // Calculate offsets that center the scaled screen inside the widget.
            mnHOffset = (aWidgetSize.getWidth() - (mnScale * aScreenSize.getWidth())) / 2.0;
            mnVOffset = (aWidgetSize.getHeight() - (mnScale * aScreenSize.getHeight())) / 2.0;
        } else {
            // In case of a degenerate (not yet initialized?) screen size
            // use some meaningless default values.
            mnScale = 1;
            mnHOffset = 0;
            mnVOffset = 0;
        }
    }
}
