/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salmain.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:39:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <sys/resource.h>

#ifndef _SAL_MAIN_H_
#include "sal/main.h"
#endif

#ifndef _SV_SALINST_HXX
#include <salinst.hxx>
#endif

// =======================================================================

#ifdef __cplusplus
extern "C" {
#endif

SAL_IMPLEMENT_MAIN()
{
	rlimit aLimit;
	if ( !getrlimit( RLIMIT_NOFILE, &aLimit ) )
	{
		aLimit.rlim_cur = aLimit.rlim_max;
		setrlimit( RLIMIT_NOFILE, &aLimit );
	}

	// Run standard VCL application code
	SVMain();

	return 0;
}

#ifdef __cplusplus
}
#endif
