/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ptr.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:37:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/ptr.hxx>

// NOT FULLY DEFINED SERVICES


namespace udm
{

Data::accessor_type
Ptr::inq_Type() const
{
 	return t_Ptr;
}





//*********************       Ptr_Null      *******************//

class Ptr_Null : public Ptr
{
  public:
    virtual             ~Ptr_Null();
  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    virtual description inq_TypeDescription() const;
    // Interface Ptr:
    virtual Object      op_Ptr() const;
};

Ptr_Null::~Ptr_Null()
{
}

void                Ptr_Null::do_Dispose() { }
void                Ptr_Null::do_BinWrite( csv::bostream & ) const    {}
Data::description   Ptr_Null::inq_TypeDescription() const { return "P{}"; }


Object
Ptr_Null::op_Ptr() const
{
 	return Object();
}



template <>
Ptr &
get_null<Ptr>( csv::Type2Type<Ptr> )
{
    static Ptr * pNull_ = new Ptr_Null;
    return *pNull_;
}



}   // namespace udm


