/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: i_struct.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:26:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_I_STRUCT_HXX
#define UDM_I_STRUCT_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/struct.hxx>
	// COMPONENTS
#include <udm/object.hxx>
	// PARAMETERS
#include <vector>


namespace udm
{

template <class> class struct_traits;

template <class SRC>
class TStruct : public Struct
{
  public:
    typedef SRC     source_type;

    // LIFECYCLE
                        TStruct(
                            member_id           i_nCountMembers );
    virtual             ~TStruct();

    // OPERATIONS
    void                connect_to(
                           const source_type &  i_rObj );

  private:
    typedef std::vector<Object> MemberList;

    // Interface Data:
    virtual void        do_Dispose();

    // Interface Struct:
    virtual Object      inq_Member(
                            member_id           i_m ) const;
    virtual Object      inq_SearchByKey(
                            int                 i_nKey ) const;
    virtual member_id   size() const;

    // Locals
    const struct_traits<SRC> &
                        my_traits() const;

    // DATA
    mutable MemberList  aMembers;
    const source_type * pObj;
};



// Begin IMPLEMENTATION
//   further implementation can be found in udm/impl_struct.hxx

template <class SRC>
TStruct<SRC>::TStruct( member_id    i_nCountMembers )
    :   aMembers( i_nCountMembers ),
        pObj(0)
{
    // Until now we prefer lazy evaluation,
    //   so this commented out:
    //   pScheme->create_members(aMembers);

}

template <class SRC>
TStruct<SRC>::~TStruct()
{
}

template <class SRC>
inline void
TStruct<SRC>::connect_to( const source_type & i_rObj )
{
    pObj = &i_rObj;
}



}   // namespace udm

#endif


