/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: e3dsceneproperties.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:06:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_PROPERTIES_E3DSCENEPROPERTIES_HXX
#define _SDR_PROPERTIES_E3DSCENEPROPERTIES_HXX

#ifndef _SDR_PROPERTIES_E3DPROPERTIES_HXX
#include <svx/sdr/properties/e3dproperties.hxx>
#endif

// predeclarations
class B3dLightGroup;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class E3dSceneProperties : public E3dProperties
		{
		protected:
			// Called after ItemChange() is done for all items.
			virtual void PostItemChange(const sal_uInt16 nWhich);

		public:
			// basic constructor
			E3dSceneProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			E3dSceneProperties(const E3dSceneProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~E3dSceneProperties();

			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;

			// get itemset
			virtual const SfxItemSet& GetObjectItemSet() const;

			// get merged ItemSet. Normappl, this maps directly to GetObjectItemSet(), but may
			// be overloaded e.g for group objects to return a merged ItemSet of the object.
			// When using this method the returned ItemSet may contain items in the state
			// SFX_ITEM_DONTCARE which means there were several such items with different
			// values.
			virtual const SfxItemSet& GetMergedItemSet() const;

			// Set merged ItemSet. Normally, this maps to SetObjectItemSet().
			virtual void SetMergedItemSet(const SfxItemSet& rSet, sal_Bool bClearAllItems = sal_False);

			// Set a single item, iterate over hierarchies if necessary.
			virtual void SetMergedItem(const SfxPoolItem& rItem);

			// Clear a single item, iterate over hierarchies if necessary.
			virtual void ClearMergedItem(const sal_uInt16 nWhich = 0);

			// set a new StyleSheet and broadcast
			virtual void SetStyleSheet(SfxStyleSheet* pNewStyleSheet, sal_Bool bDontRemoveHardAttr);

			// get the installed StyleSheet
			virtual SfxStyleSheet* GetStyleSheet() const;

			// pre/post-process saving
			//BFS01virtual void PreProcessSave();
			//BFS01virtual void PostProcessSave();

			// Move properties to a new ItemPool. Default implementation does nothing.
			virtual void MoveToItemPool(SfxItemPool* pSrcPool, SfxItemPool* pDestPool, SdrModel* pNewModel = 0L);

			// Special for scene:
			void SetLightItemsFromLightGroup(B3dLightGroup& rLightGroup);
			void SetSceneItemsFromCamera();
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif // _SDR_PROPERTIES_E3DSCENEPROPERTIES_HXX

// eof
