/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: testtool.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:07:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef SVTOOLS_TESTTOOL_HXX
#define SVTOOLS_TESTTOOL_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif

class Application;
class SvStream;

class StatementFlow;
class CommunicationManager;
class CommunicationLink;
#if OSL_DEBUG_LEVEL > 1
class EditWindow;
#endif
class ImplRC;

class RemoteControl
{
	friend class StatementFlow;

	BOOL         m_bIdleInserted;
#if OSL_DEBUG_LEVEL > 1
	EditWindow *m_pDbgWin;
#endif
	ImplRC* pImplRC;

public:
	RemoteControl();
	~RemoteControl();
	BOOL QueCommands( ULONG nServiceId, SvStream *pIn );
	SvStream* GetReturnStream();

	DECL_LINK( IdleHdl,   Application* );
	DECL_LINK( CommandHdl, Application* );

	DECL_LINK( QueCommandsEvent, CommunicationLink* );
	ULONG nStoredServiceId;
	SvStream *pStoredStream;

	void ExecuteURL( String &aURL );

protected:
	CommunicationManager *pServiceMgr;
	SvStream *pRetStream;
};

#endif // SVTOOLS_TESTTOOL_HXX
