/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: unolayer.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:50:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif

#include "unolayer.hxx"

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#include <svx/svdpagv.hxx>
#include <svx/unoshape.hxx>
#include <svx/svdobj.hxx>

// folgende fuer InsertSdPage()
#ifndef _SVDLAYER_HXX //autogen
#include <svx/svdlayer.hxx>
#endif

#ifndef SVX_LIGHT
#ifndef SD_DRAW_DOC_SHELL_HXX
#include "DrawDocShell.hxx"
#endif
#endif

#ifndef _DRAWDOC_HXX
#include <drawdoc.hxx>
#endif
#ifndef _UNOMODEL_HXX
#include <unomodel.hxx>
#endif

#ifndef _SD_UNOPRNMS_HXX
#include "unoprnms.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_NOSUPPORTEXCEPTION_HPP_
#include <com/sun/star/lang/NoSupportException.hpp>
#endif

#include "unohelp.hxx"
#ifndef SD_FRAME_VIEW_HXX
#include "FrameView.hxx"
#endif
#ifndef SD_DRAW_VIEW_SHELL_HXX
#include "DrawViewShell.hxx"
#endif
#ifndef SD_VIEW_HXX
#include "View.hxx"
#endif

#ifndef SD_VIEW_SHELL_HXX
#include "ViewShell.hxx"
#endif
#include "app.hrc"
#include "strings.hrc"
#include "sdresid.hxx"
#include "glob.hrc"

#include "unokywds.hxx"
#include "unowcntr.hxx"

using namespace ::rtl;
using namespace ::vos;
using namespace ::com::sun::star;

//=============================================================================
// class SdLayer
//=============================================================================

#define WID_LAYER_LOCKED	1
#define WID_LAYER_PRINTABLE	2
#define WID_LAYER_VISIBLE	3
#define WID_LAYER_NAME		4

const SfxItemPropertyMap* ImplGetSdLayerPropertyMap()
{
	static const SfxItemPropertyMap aSdLayerPropertyMap_Impl[] =
	{
		{ MAP_CHAR_LEN(UNO_NAME_LAYER_LOCKED),		WID_LAYER_LOCKED,	&::getBooleanCppuType(),			0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_LAYER_PRINTABLE),	WID_LAYER_PRINTABLE,&::getBooleanCppuType(),			0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_LAYER_VISIBLE),		WID_LAYER_VISIBLE,	&::getBooleanCppuType(),			0, 0 },
		{ MAP_CHAR_LEN(UNO_NAME_LAYER_NAME),		WID_LAYER_NAME,		&::getCppuType((const OUString*)0),	0, 0 },
		{ 0,0,0,0,0}
	};

	return aSdLayerPropertyMap_Impl;
}

String SdLayer::convertToInternalName( const OUString& rName )
{
	if( rName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(sUNO_LayerName_background) ) )
	{
		return String( SdResId( STR_LAYER_BCKGRND ) );
	}
	else if( rName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(sUNO_LayerName_background_objects) ) )
	{
		return  String( SdResId( STR_LAYER_BCKGRNDOBJ ) );
	}
	else if( rName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(sUNO_LayerName_layout) ) )
	{
		return  String( SdResId( STR_LAYER_LAYOUT ) );
	}
	else if( rName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(sUNO_LayerName_controls) ) )
	{
		return  String( SdResId( STR_LAYER_CONTROLS ) );
	}
	else if( rName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(sUNO_LayerName_measurelines) ) )
	{
		return  String( SdResId( STR_LAYER_MEASURELINES ) );
	}
	else
	{
		return String( rName );
	}
}

OUString SdLayer::convertToExternalName( const String& rName )
{
	const String aCompare( rName );
	if( rName == String( SdResId( STR_LAYER_BCKGRND ) ) ) 
	{
		return OUString( RTL_CONSTASCII_USTRINGPARAM(sUNO_LayerName_background) );
	}
	else if( rName == String( SdResId( STR_LAYER_BCKGRNDOBJ ) ) ) 
	{
		return OUString( RTL_CONSTASCII_USTRINGPARAM(sUNO_LayerName_background_objects) );
	}
	else if( rName == String( SdResId( STR_LAYER_LAYOUT ) ) ) 
	{
		return OUString( RTL_CONSTASCII_USTRINGPARAM(sUNO_LayerName_layout) );
	}
	else if( rName == String( SdResId( STR_LAYER_CONTROLS ) ) ) 
	{
		return OUString( RTL_CONSTASCII_USTRINGPARAM(sUNO_LayerName_controls) );
	}
	else if( rName == String( SdResId( STR_LAYER_MEASURELINES ) ) ) 
	{
		return OUString( RTL_CONSTASCII_USTRINGPARAM(sUNO_LayerName_measurelines) );
	}
	else
	{
		return OUString( rName );
	}
}

/** */
SdLayer::SdLayer( SdLayerManager* pLayerManager_, SdrLayer* pSdrLayer_ ) throw()
: aPropSet(ImplGetSdLayerPropertyMap()),
  pLayerManager(pLayerManager_), pLayer(pSdrLayer_),
  mxLayerManager(pLayerManager_)
{
}

/** */
SdLayer::~SdLayer() throw()
{
}

// uno helper
UNO3_GETIMPLEMENTATION_IMPL( SdLayer );

// XServiceInfo
OUString SAL_CALL SdLayer::getImplementationName()
	throw(uno::RuntimeException)
{
	return OUString( OUString::createFromAscii(sUNO_SdLayer) );
}

sal_Bool SAL_CALL SdLayer::supportsService( const OUString& ServiceName )
	throw(uno::RuntimeException)
{
	return SvxServiceInfoHelper::supportsService( ServiceName, getSupportedServiceNames() );
}

uno::Sequence< OUString > SAL_CALL SdLayer::getSupportedServiceNames()
	throw(uno::RuntimeException)
{
	OUString aServiceName( OUString::createFromAscii(sUNO_Service_DrawingLayer) );
	uno::Sequence< OUString > aSeq( &aServiceName, 1 );
	return aSeq;
}

// beans::XPropertySet
uno::Reference< beans::XPropertySetInfo > SAL_CALL SdLayer::getPropertySetInfo(  )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );
	return aPropSet.getPropertySetInfo();
}

void SAL_CALL SdLayer::setPropertyValue( const OUString& aPropertyName, const uno::Any& aValue )
	throw(beans::UnknownPropertyException, beans::PropertyVetoException, lang::IllegalArgumentException, lang::WrappedTargetException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if(pLayer == NULL || pLayerManager == NULL)
		throw lang::DisposedException();

	const SfxItemPropertyMap* pMap = aPropSet.getPropertyMapEntry(aPropertyName);

	switch( pMap ? pMap->nWID : -1 )
	{
	case WID_LAYER_LOCKED:
	{
		sal_Bool bValue;
		if(!sd::any2bool( aValue, bValue ))
			throw lang::IllegalArgumentException();
		set( LOCKED, bValue );
		break;
	}
	case WID_LAYER_PRINTABLE:
	{
		sal_Bool bValue;
		if(!sd::any2bool( aValue, bValue ))
			throw lang::IllegalArgumentException();
		set( PRINTABLE, bValue );
		break;
	}
	case WID_LAYER_VISIBLE:
	{
		sal_Bool bValue;
		if(!sd::any2bool( aValue, bValue ))
			throw lang::IllegalArgumentException();
		set( VISIBLE, bValue );
		break;
	}
	case WID_LAYER_NAME:
	{
		OUString aName;
		if(!(aValue >>= aName))
			throw lang::IllegalArgumentException();
	
		pLayer->SetName(SdLayer::convertToInternalName( aName ) );
		pLayerManager->UpdateLayerView();
		break;
	}
	default:
		throw beans::UnknownPropertyException();
		break;
	}

#ifndef SVX_LIGHT
	if(	pLayerManager->GetDocShell() )
		pLayerManager->GetDocShell()->SetModified();		
#endif
}

uno::Any SAL_CALL SdLayer::getPropertyValue( const OUString& PropertyName )
	throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if(pLayer == NULL || pLayerManager == NULL)
		throw lang::DisposedException();

	const SfxItemPropertyMap* pMap = aPropSet.getPropertyMapEntry(PropertyName);

	uno::Any aValue;

	switch( pMap ? pMap->nWID : -1 )
	{
	case WID_LAYER_LOCKED:
		sd::bool2any( get( LOCKED ), aValue );
		break;
	case WID_LAYER_PRINTABLE:
		sd::bool2any( get( PRINTABLE ), aValue );
		break;
	case WID_LAYER_VISIBLE:
		sd::bool2any( get( VISIBLE ), aValue );
		break;
	case WID_LAYER_NAME:
	{
		OUString aRet( SdLayer::convertToExternalName( pLayer->GetName() ) );
		aValue <<= aRet;
		break;
	}
	default:
		throw beans::UnknownPropertyException();
		break;
	}

	return aValue;
}

void SAL_CALL SdLayer::addPropertyChangeListener( const OUString& aPropertyName, const uno::Reference< beans::XPropertyChangeListener >& xListener ) throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException) {}
void SAL_CALL SdLayer::removePropertyChangeListener( const OUString& aPropertyName, const uno::Reference< beans::XPropertyChangeListener >& aListener ) throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException) {}
void SAL_CALL SdLayer::addVetoableChangeListener( const OUString& PropertyName, const uno::Reference< beans::XVetoableChangeListener >& aListener ) throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException) {}
void SAL_CALL SdLayer::removeVetoableChangeListener( const OUString& PropertyName, const uno::Reference< beans::XVetoableChangeListener >& aListener ) throw(beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException) {}

/** */
sal_Bool SdLayer::get( LayerAttribute what ) throw()
{
	if(pLayer&&pLayerManager)
	{
		// Versuch 1. ist eine beliebige Seite geoeffnet?
		::sd::View *pView = pLayerManager->GetView();
		SdrPageView* pSdrPageView = NULL;
		if(pView)
			pSdrPageView = pView->GetPageViewPvNum(0);

		if(pSdrPageView)
		{
			String aLayerName = pLayer->GetName();
			switch(what)
			{
			case VISIBLE:	return pSdrPageView->IsLayerVisible(aLayerName);
			case PRINTABLE:	return pSdrPageView->IsLayerPrintable(aLayerName);
			case LOCKED:   	return pSdrPageView->IsLayerLocked(aLayerName);
			}
		}

#ifndef SVX_LIGHT
		// Versuch 2. Info von der FrameView besorgen
		if(pLayerManager->GetDocShell())
		{
			::sd::FrameView *pFrameView = pLayerManager->GetDocShell()->GetFrameView();
			if(pFrameView)
				switch(what)
				{
				case VISIBLE:	return pFrameView->GetVisibleLayers().IsSet(pLayer->GetID());
				case PRINTABLE:	return pFrameView->GetPrintableLayers().IsSet(pLayer->GetID());
				case LOCKED:	return pFrameView->GetLockedLayers().IsSet(pLayer->GetID());
				}
		}
#endif
	}
	return sal_False; //TODO: uno::Exception?
}

void SdLayer::set( LayerAttribute what, sal_Bool flag ) throw()
{
	if(pLayer&&pLayerManager)
	{
		// Versuch 1. ist eine beliebige Seite geoeffnet?
		::sd::View *pView = pLayerManager->GetView();
		SdrPageView* pSdrPageView = NULL;
		if(pView)
			pSdrPageView = pView->GetPageViewPvNum(0);

		if(pSdrPageView)
		{
			String aLayerName(pLayer->GetName());
			switch(what)
			{
			case VISIBLE:	pSdrPageView->SetLayerVisible(aLayerName,flag);
							break;
			case PRINTABLE:	pSdrPageView->SetLayerPrintable(aLayerName,flag);
							break;
			case LOCKED:	pSdrPageView->SetLayerLocked(aLayerName,flag);
							break;
			}
		}

#ifndef SVX_LIGHT
		// Versuch 2. Info von der FrameView besorgen
		if(pLayerManager->GetDocShell())
		{
			::sd::FrameView *pFrameView = pLayerManager->GetDocShell()->GetFrameView();

			if(pFrameView)
			{
				SetOfByte aNewLayers;
				switch(what)
				{
				case VISIBLE:	aNewLayers = pFrameView->GetVisibleLayers();
								break;
				case PRINTABLE:	aNewLayers = pFrameView->GetPrintableLayers();
								break;
				case LOCKED:	aNewLayers = pFrameView->GetLockedLayers();
								break;
				}

				aNewLayers.Set(pLayer->GetID(),flag);

				switch(what)
				{
				case VISIBLE:	pFrameView->SetVisibleLayers(aNewLayers);
								break;
				case PRINTABLE:	pFrameView->SetPrintableLayers(aNewLayers);
								break;
				case LOCKED:	pFrameView->SetLockedLayers(aNewLayers);
								break;
				}
				return;
			}
		}
#endif
	}
	//TODO: uno::Exception?
}




//=====  ::com::sun::star::container::XChild  =================================

uno::Reference<uno::XInterface> SAL_CALL SdLayer::getParent (void) 
    throw (::com::sun::star::uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( pLayerManager == NULL )
		throw lang::DisposedException();

    return uno::Reference<uno::XInterface> (mxLayerManager, uno::UNO_QUERY);
}


void SAL_CALL SdLayer::setParent (const uno::Reference<uno::XInterface >& rxParent) 
    throw (::com::sun::star::lang::NoSupportException, 
        ::com::sun::star::uno::RuntimeException)
{
    throw lang::NoSupportException ();
}

// XComponent
void SAL_CALL SdLayer::dispose(  ) throw (uno::RuntimeException)
{
	pLayerManager = 0;
	mxLayerManager = 0;
	pLayer = 0;
}

void SAL_CALL SdLayer::addEventListener( const uno::Reference< lang::XEventListener >& xListener ) throw (uno::RuntimeException)
{
	DBG_ERROR("not implemented!");
}

void SAL_CALL SdLayer::removeEventListener( const uno::Reference< lang::XEventListener >& aListener ) throw (uno::RuntimeException)
{
	DBG_ERROR("not implemented!");
}


//=============================================================================
// class SdLayerManager
//=============================================================================

/** */
SdLayerManager::SdLayerManager( SdXImpressDocument& rMyModel ) throw()
:mpModel( &rMyModel)
{
	mpLayers = new SvUnoWeakContainer;
}

/** */
SdLayerManager::~SdLayerManager() throw()
{
    dispose();
}

// uno helper
UNO3_GETIMPLEMENTATION_IMPL( SdLayerManager );

// XComponent
void SAL_CALL SdLayerManager::dispose(  ) throw (uno::RuntimeException)
{
	mpModel = 0;
	if( mpLayers )
	{
		mpLayers->dispose();

		delete mpLayers;
		mpLayers = 0;
	}
}

void SAL_CALL SdLayerManager::addEventListener( const uno::Reference< lang::XEventListener >& xListener ) throw (uno::RuntimeException)
{
	DBG_ERROR("not implemented!");
}

void SAL_CALL SdLayerManager::removeEventListener( const uno::Reference< lang::XEventListener >& aListener ) throw (uno::RuntimeException)
{
	DBG_ERROR("not implemented!");
}

// XServiceInfo
OUString SAL_CALL SdLayerManager::getImplementationName()
	throw(uno::RuntimeException)
{
	return OUString( OUString::createFromAscii(sUNO_SdLayerManager) );
}

sal_Bool SAL_CALL SdLayerManager::supportsService( const OUString& ServiceName )
	throw(uno::RuntimeException)
{
	return SvxServiceInfoHelper::supportsService( ServiceName, getSupportedServiceNames() );
}

uno::Sequence< OUString > SAL_CALL SdLayerManager::getSupportedServiceNames()
	throw(uno::RuntimeException)
{
	OUString aServiceName( OUString::createFromAscii(sUNO_Service_DrawingLayerManager) );
	uno::Sequence< OUString > aSeq( &aServiceName, 1 );
	return aSeq;
}

// XLayerManager
uno::Reference< drawing::XLayer > SAL_CALL SdLayerManager::insertNewByIndex( sal_Int32 nIndex )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	uno::Reference< drawing::XLayer > xLayer;

	if( mpModel->pDoc )
	{
		SdrLayerAdmin& rLayerAdmin = mpModel->pDoc->GetLayerAdmin();
		sal_uInt16 nLayerCnt = rLayerAdmin.GetLayerCount();
		sal_uInt16 nLayer = nLayerCnt - 2 + 1;
		String aLayerName;

		// Ueberpruefung auf schon vorhandene Namen
		while( aLayerName.Len()==0 || rLayerAdmin.GetLayer( aLayerName, sal_False) )
		{
			aLayerName = String(SdResId(STR_LAYER));
			aLayerName += String::CreateFromInt32( (sal_Int32)nLayer );
			nLayer++;
		}

		SdrLayerAdmin& rLA=mpModel->pDoc->GetLayerAdmin();
		const sal_Int32 nMax=rLA.GetLayerCount();
		if (nIndex>nMax) nIndex=nMax;
		xLayer = GetLayer (rLA.NewLayer(aLayerName,(USHORT)nIndex));
		mpModel->SetModified();
	}
	return xLayer;
}

void SAL_CALL SdLayerManager::remove( const uno::Reference< drawing::XLayer >& xLayer )
	throw(container::NoSuchElementException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	SdLayer* pSdLayer = SdLayer::getImplementation(xLayer);

	if(pSdLayer && GetView())
	{
		const SdrLayer* pSdrLayer = pSdLayer->GetSdrLayer();
		GetView()->DeleteLayer( pSdrLayer->GetName() );

		UpdateLayerView();
	}

	mpModel->SetModified();
}

void SAL_CALL SdLayerManager::attachShapeToLayer( const uno::Reference< drawing::XShape >& xShape, const uno::Reference< drawing::XLayer >& xLayer )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	SdLayer* pSdLayer = SdLayer::getImplementation(xLayer);
	SdrLayer* pSdrLayer = pSdLayer?pSdLayer->GetSdrLayer():NULL;
	if(pSdrLayer==NULL)
		return;

	SvxShape* pShape = SvxShape::getImplementation( xShape );
	SdrObject* pSdrObject = pShape?pShape->GetSdrObject():NULL;

	if(pSdrObject && pSdrLayer )
		pSdrObject->SetLayer(pSdrLayer->GetID());

	mpModel->SetModified();
}

uno::Reference< drawing::XLayer > SAL_CALL SdLayerManager::getLayerForShape( const uno::Reference< drawing::XShape >& xShape ) throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	uno::Reference< drawing::XLayer >  xLayer;

	if(mpModel->pDoc)
	{
		SvxShape* pShape = SvxShape::getImplementation( xShape );
		SdrObject* pObj = pShape?pShape->GetSdrObject():NULL;
		if(pObj)
		{
			SdrLayerID aId = pObj->GetLayer();
			SdrLayerAdmin& rLayerAdmin = mpModel->pDoc->GetLayerAdmin();
			xLayer = GetLayer (rLayerAdmin.GetLayerPerID(aId));
		}
	}
	return xLayer;
}

// XIndexAccess
sal_Int32 SAL_CALL SdLayerManager::getCount()
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	if( mpModel->pDoc )
	{
		SdrLayerAdmin& rLayerAdmin = mpModel->pDoc->GetLayerAdmin();
		return rLayerAdmin.GetLayerCount();
	}

	return 0;
}

uno::Any SAL_CALL SdLayerManager::getByIndex( sal_Int32 nLayer )
	throw(lang::IndexOutOfBoundsException, lang::WrappedTargetException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	if( nLayer >= getCount() || nLayer < 0 )
		throw lang::IndexOutOfBoundsException();

	uno::Any aAny;

	if( mpModel->pDoc )
	{
		SdrLayerAdmin& rLayerAdmin = mpModel->pDoc->GetLayerAdmin();
		uno::Reference<drawing::XLayer> xLayer (GetLayer (rLayerAdmin.GetLayer((sal_uInt16)nLayer)));
		aAny <<= xLayer;
	}
	return aAny;
}


// XNameAccess
uno::Any SAL_CALL SdLayerManager::getByName( const OUString& aName )
	throw(container::NoSuchElementException, lang::WrappedTargetException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	uno::Reference< drawing::XLayer >  xLayer;

	uno::Any aAny;

	if( mpModel->pDoc )
	{
		SdrLayerAdmin& rLayerAdmin = mpModel->pDoc->GetLayerAdmin();
		SdrLayer* pLayer = rLayerAdmin.GetLayer( SdLayer::convertToInternalName( aName ), FALSE );
		if( pLayer == NULL )
			throw container::NoSuchElementException();

		xLayer = GetLayer (pLayer);
		aAny <<= xLayer;
		return aAny;
	}

	throw container::NoSuchElementException();
	return aAny;
}

uno::Sequence< OUString > SAL_CALL SdLayerManager::getElementNames()
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if( mpModel == 0 )
		throw lang::DisposedException();

	SdrLayerAdmin& rLayerAdmin = mpModel->pDoc->GetLayerAdmin();
	const sal_uInt16 nLayerCount = rLayerAdmin.GetLayerCount();

	uno::Sequence< OUString > aSeq( nLayerCount );

	OUString* pStrings = aSeq.getArray();
	SdrLayer* pLayer;

	for( sal_uInt16 nLayer = 0; nLayer < nLayerCount; nLayer++ )
	{
		pLayer = rLayerAdmin.GetLayer( nLayer );
		if( pLayer )
			*pStrings++ = SdLayer::convertToExternalName( pLayer->GetName() );
	}

	return aSeq;
}

sal_Bool SAL_CALL SdLayerManager::hasByName( const OUString& aName ) throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );
	
	if( mpModel == 0 )
		throw lang::DisposedException();

	SdrLayerAdmin& rLayerAdmin = mpModel->pDoc->GetLayerAdmin();

	return NULL != rLayerAdmin.GetLayer( SdLayer::convertToInternalName( aName ), FALSE );
}

// XElementAccess
uno::Type SAL_CALL SdLayerManager::getElementType()
	throw(uno::RuntimeException)
{
	return ITYPE( drawing::XLayer );
}

sal_Bool SAL_CALL SdLayerManager::hasElements() throw(uno::RuntimeException)
{
	return getCount() > 0;
}

/** Falls an den Layern was geaendert wurde sorgt diese Methode dafuer, das
	die Aenderungen auch in der sdbcx::View sichtbar gemacht werden */
void SdLayerManager::UpdateLayerView( sal_Bool modify ) const throw()
{
	if(mpModel->pDocShell)
	{
		::sd::DrawViewShell* pDrViewSh =
			PTR_CAST(::sd::DrawViewShell, mpModel->pDocShell->GetViewShell());

		if(pDrViewSh)
		{
			sal_Bool bLayerMode = pDrViewSh->IsLayerModeActive();
			pDrViewSh->ChangeEditMode(pDrViewSh->GetEditMode(), !bLayerMode);
			pDrViewSh->ChangeEditMode(pDrViewSh->GetEditMode(), bLayerMode);
		}

		if(modify)
			mpModel->pDoc->SetChanged(sal_True);
	}
}

/** */
::sd::View* SdLayerManager::GetView() const throw()
{
	if( mpModel->pDocShell )
	{
		::sd::ViewShell* pViewSh = mpModel->pDocShell->GetViewShell();
		if(pViewSh)
			return pViewSh->GetView();
	}
	return NULL;
}



namespace
{
/** Compare two pointers to <type>SdrLayer</type> objects.
    @param xRef
        The implementing SdLayer class provides the first pointer by the
        <member>SdLayer::GetSdrLayer</member> method.
    @param pSearchData
        This void pointer is the second pointer to an <type>SdrLayer</type>
        object.
    @return
        Return </True> if both pointers point to the same object.
*/
sal_Bool compare_layers (uno::WeakReference<uno::XInterface> xRef, void* pSearchData)
{
	uno::Reference<uno::XInterface> xLayer (xRef);
	if (xLayer.is())
	{
        SdLayer* pSdLayer = SdLayer::getImplementation (xRef);
        if (pSdLayer != NULL)
        {
            SdrLayer* pSdrLayer = pSdLayer->GetSdrLayer ();
            if (pSdrLayer == static_cast<SdrLayer*>(pSearchData))
                return sal_True;
        }
	}
	return sal_False;
}
}

/** Use the <member>mpLayers</member> container of weak references to either
    retrieve and return a previously created <type>XLayer</type> object for
    the given <type>SdrLayer</type> object or create and remember a new one.
*/
uno::Reference<drawing::XLayer> SdLayerManager::GetLayer (SdrLayer* pLayer)
{
	uno::WeakReference<uno::XInterface> xRef;
	uno::Reference<drawing::XLayer>  xLayer;

    // Search existing xLayer for the given pLayer.
	if (mpLayers->findRef (xRef, (void*)pLayer, compare_layers))
        xLayer = uno::Reference<drawing::XLayer> (xRef, uno::UNO_QUERY);

    // Create the xLayer if necessary.
	if ( ! xLayer.is())
	{
		xLayer = new SdLayer (this, pLayer);

        // Remember the new xLayer for future calls.
		xRef = uno::Reference<uno::XInterface> (xLayer, uno::UNO_QUERY);
		mpLayers->insert (xRef);
	}

    return xLayer;
}
