/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuslid.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/12/14 17:03:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "fuslid.hxx"

#ifndef SD_FU_POOR_HXX
#include "fupoor.hxx"
#endif
#ifndef SD_SLIDE_VIEW_SHELL_HXX
#include "SlideViewShell.hxx"
#endif
#ifndef SD_WINDOW_SHELL_HXX
#include "Window.hxx"
#endif
#ifndef SD_SLIDE_VIEW_HXX
#include "SlideView.hxx"
#endif
#include "drawdoc.hxx"

namespace sd {

TYPEINIT1( FuSlide, FuPoor );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

FuSlide::FuSlide (
    SlideViewShell* pViewSh, 
    ::sd::Window* pWin, 
    SlideView* pView,
    SdDrawDocument* pDoc, 
    SfxRequest& rReq)
    : FuPoor(pViewSh, pWin, pView, pDoc, rReq),
      pSlViewShell(pViewSh),
      pSlView(pView)
{
}

FunctionReference FuSlide::Create( SlideViewShell* pViewSh, ::sd::Window* pWin, SlideView* pView, SdDrawDocument* pDoc, SfxRequest& rReq )
{
	FunctionReference xFunc( new FuSlide( pViewSh, pWin, pView, pDoc, rReq ) );
	return xFunc;
}

void FuSlide::ScrollStart()
{
}

void FuSlide::ScrollEnd()
{
}

BOOL FuSlide::MouseMove(const MouseEvent& rMEvt)
{
	return FALSE;
}

BOOL FuSlide::MouseButtonUp(const MouseEvent& rMEvt)
{
	return FALSE;
}

BOOL FuSlide::MouseButtonDown(const MouseEvent& rMEvt)
{
	return FALSE;
}

} // end of namespace sd
