/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: un3dview.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:56:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_UN3DVIEW_HXX
#define _SCH_UN3DVIEW_HXX

#include "schundo.hxx"

/*************************************************************************
|*
|* Undo fuer 3D-Ansicht
|*
\************************************************************************/

class SchUndo3DView : public SchUndoAction
{
private:
	short nOldXAngle;
	short nOldYAngle;
	short nOldZAngle;
	short nNewXAngle;
	short nNewYAngle;
	short nNewZAngle;

public:
	TYPEINFO();

	SchUndo3DView(ChartModel& rChDoc, short nOldX, short nOldY,
				  short nOldZ, short nNewX, short nNewY, short nNewZ) :
		SchUndoAction(rChDoc),
		nOldXAngle(nOldX),
		nOldYAngle(nOldY),
		nOldZAngle(nOldZ),
		nNewXAngle(nNewX),
		nNewYAngle(nNewY),
		nNewZAngle(nNewZ) {}

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;

private:
	void DoIt(short nX, short nY, short nZ);
};

#endif	// _SCH_UN3DVIEW_HXX

