/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuchrmap.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:20:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#define ITEMID_FONT 			EE_CHAR_FONTINFO
#include <svx/fontitem.hxx>

#include "fuchrmap.hxx"
#include "schview.hxx"
#include "strings.hrc"
#include "schresid.hxx"

#ifndef _OUTLINER_HXX //autogen
#include <svx/svdoutl.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVX_CHARMAP_HXX //autogen
#include <svx/charmap.hxx>
#endif

#ifdef IRIX
#ifndef _SBXCLASS_HXX
#include <basic/sbx.hxx>
#endif
#endif

#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001

TYPEINIT1( SchFuCharMap, SchFuPoor );

/*************************************************************************
|*
|* constructor
|*
|* creates a dialog for insertion of special characters
|* there ist no font support yet.
|* (for info. see sd/source/ui/func/fubullet.cxx)
|*
\************************************************************************/

SchFuCharMap::SchFuCharMap( SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
							ChartModel* pModel, SfxRequest& rReq)
	   : SchFuPoor(pViewSh, pWin, pView, pModel, rReq)
{

	//CHINA001 SvxCharacterMap* pDlg = new SvxCharacterMap( NULL, FALSE );
	SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
	DBG_ASSERT(pFact, "Dialogdiet fail!");//CHINA001
	AbstractSvxCharacterMap* pDlg = pFact->CreateSvxCharacterMap( NULL,  ResId(RID_SVXDLG_CHARMAP), FALSE );
	DBG_ASSERT(pDlg, "Dialogdiet fail!");//CHINA001

	OutlinerView* pOV = NULL;
	SdrOutliner*  pOL = NULL;
	
	pOV = pView->GetTextEditOutlinerView();
	
	if( pOV )
	{
		// set the current font
		pOL = pView->GetTextEditOutliner();
		OutputDevice *pOut = pOL->GetRefDevice();

		pDlg->SetFont( pOut->GetFont() );
	}

	// the font mustn't be changed
	pDlg->DisableFontSelection();
	USHORT nResult = pDlg->Execute();

	String aString;

	if( nResult == RET_OK )
	{
		aString = pDlg->GetCharacters();
	}
	delete( pDlg );

	if( nResult == RET_OK && pOV )
	{
		// insert string

		// prevent flicker
		pOV->HideCursor();
		pOL->SetUpdateMode(FALSE);

		// delete current selection by inserting empty String, so current
		// attributes become unique (sel. has to be erased anyway)
        pOV->InsertText(String());

        SfxUndoManager& rUndoMgr =  pOL->GetUndoManager();
        rUndoMgr.EnterListAction( String( SchResId( STR_UNDO_INSERT_SPECCHAR )), String( SchResId( STR_UNDO_INSERT_SPECCHAR )));
		pOV->InsertText(aString, TRUE);

        ESelection aSel = pOV->GetSelection();
		aSel.nStartPara = aSel.nEndPara;
		aSel.nStartPos = aSel.nEndPos;
		pOV->SetSelection(aSel);

        rUndoMgr.LeaveListAction();

        // show changes
		pOL->SetUpdateMode(TRUE);
		pOV->ShowCursor();
	}
}

