/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: analysisdefs.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:20:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ANALYSISDEFS_HXX
#define ANALYSISDEFS_HXX

#define CSS					::com::sun::star
#define XPROPSET			CSS::beans::XPropertySet
#define REF(c)				CSS::uno::Reference< c >
#define constREFXPS			const REF(XPROPSET)
#define SEQ(c)				CSS::uno::Sequence< c >
#define SEQSEQ(c)			CSS::uno::Sequence< CSS::uno::Sequence< c > >
#define SEQofLocName		SEQ( CSS::sheet::LocalizedName )
#define ANY					CSS::uno::Any
#define	SEQ_ANY				SEQ(ANY)
#define STRING				::rtl::OUString
#define STRFROMASCII(s)		STRING::createFromAscii( s )
#define STRFROMANSI(s)		STRING( s, strlen( s ), RTL_TEXTENCODING_MS_1252 )
#define THROWDEF_RTE		throw(CSS::uno::RuntimeException)
#define THROW_RTE			throw CSS::uno::RuntimeException()
#define THROWDEF_RTE_IAE	throw(CSS::uno::RuntimeException,CSS::lang::IllegalArgumentException)
#define	THROW_IAE			throw CSS::lang::IllegalArgumentException()

#define CHK_Freq            ( nFreq != 1 && nFreq != 2 && nFreq != 4 )
#define CHK_FINITE(d)       if( !::rtl::math::isFinite( d ) ) THROW_IAE
#define RETURN_FINITE(d)    if( ::rtl::math::isFinite( d ) ) return d; else THROW_IAE

#endif

