/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: inmac.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2006/04/07 14:37:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SAL_CONFIG_H_
#include <sal/config.h>
#endif

#include "mac_start.h"

#include <script.h>
#include <IntlResources.h>
#include <TextUtils.h>
#include <Resources.h>

#include "mac_end.h"

#ifndef INCLUDED_I18NPOOL_MSLANGID_HXX
#include "i18npool/mslangid.hxx"
#endif

// =======================================================================

static LanguageType MacRegionToSVLang( short nMacReg )
{
    switch ( nMacReg )
    {
        case verUS:
            return LANGUAGE_ENGLISH_US;
        case verFrance:
            return LANGUAGE_FRENCH;
        case verBritain:
            return LANGUAGE_ENGLISH_UK;
        case verGermany:
            return LANGUAGE_GERMAN;
        case verItaly:
            return LANGUAGE_ITALIAN;
        case verNetherlands:
            return LANGUAGE_DUTCH;
        case verFrBelgiumLux:
            return LANGUAGE_FRENCH_BELGIAN;
        case verSweden:
            return LANGUAGE_SWEDISH;
        case verDenmark:
            return LANGUAGE_DANISH;
        case verPortugal:
            return LANGUAGE_PORTUGUESE;
        case verFrCanada:
            return LANGUAGE_FRENCH_CANADIAN;
        case verIsrael:
            return LANGUAGE_HEBREW;
        case verJapan:
            return LANGUAGE_JAPANESE;
        case verAustralia:
            return LANGUAGE_ENGLISH_AUS;
        case verArabia:
            return LANGUAGE_ARABIC;
        case verFinland:
            return LANGUAGE_FINNISH;
        case verFrSwiss:
            return LANGUAGE_FRENCH_SWISS;
        case verGrSwiss:
            return LANGUAGE_GERMAN_SWISS;
        case verGreece:
            return LANGUAGE_GREEK;
        case verIceland:
            return LANGUAGE_ICELANDIC;
        case verMalta:
            return LANGUAGE_DONTKNOW;
        case verCyprus:
            return LANGUAGE_DONTKNOW;
        case verTurkey:
            return LANGUAGE_TURKISH;
        case verYugoCroatian:
            return LANGUAGE_CROATIAN;
        case verIndiaHindi:
            return LANGUAGE_DONTKNOW;
        case verPakistan:
            return LANGUAGE_DONTKNOW;
        case verLithuania:
            return LANGUAGE_LITHUANIAN;
        case verPoland:
            return LANGUAGE_POLISH;
        case verHungary:
            return LANGUAGE_HUNGARIAN;
        case verEstonia:
            return LANGUAGE_ESTONIAN;
        case verLatvia:
            return LANGUAGE_LATVIAN;
        case verLapland:
            return LANGUAGE_DONTKNOW;
        case verFaeroeIsl:
            return LANGUAGE_FAEROESE;
        case verIran:
            return LANGUAGE_FARSI;
        case verRussia:
            return LANGUAGE_RUSSIAN;
        case verIreland:
            return LANGUAGE_ENGLISH_EIRE;
        case verKorea:
            return LANGUAGE_KOREAN;
        case verChina:
            return LANGUAGE_CHINESE;
        case verTaiwan:
            return LANGUAGE_DONTKNOW;
        case verThailand:
            return LANGUAGE_THAI;
        default:
            return LANGUAGE_DONTKNOW;
    }
}

// -----------------------------------------------------------------------

LanguageType MsLangId::getPlatformSystemLanguage()
{
    ItlcRecord **hItlcResource;
    hItlcResource = (ItlcRecord**) GetResource( 'itlc', 0 );
    short nRetVal = (**hItlcResource).itlcRegionCode;
    ReleaseResource( (Handle) hItlcResource );
    return MacRegionToSVLang( nRetVal );
//    long nRetVal = GetScriptManagerVariable( smRegionCode );
//    return MacRegionToSVLang( (short)nRetVal );
}

// -----------------------------------------------------------------------

LanguageType MsLangId::getPlatformSystemUILanguage( USHORT nIndex )
{
    // TODO: implementation (if it differs)
    return getPlatformSystemLanguage( nIndex );
}

