/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2dmbmp.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:11:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _B2D_MBMP_HXX
#define _B2D_MBMP_HXX

#ifndef _B2D_MBASE_HXX
#include "b2dmbase.hxx"
#endif

//************************************************************
//   InterActionObjectBitmap
//************************************************************

class B2dIAOBitmapObj : public B2dIAObject
{
	// the Bitmap itself
	Bitmap						aBmp;

	// center of the Bitmap
	UINT16						nCenterX;
	UINT16						nCenterY;

	// shall the BaseColor be used to create transparence?
	unsigned					bUseTransCol : 1;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

public:
    TYPEINFO();
	B2dIAOBitmapObj(B2dIAOManager* pMan, Point aPos, const Bitmap& rBmp, 
		UINT16 nCenX = 0, UINT16 nCenY = 0, BOOL bUseTransCol = FALSE, 
		Color aTransCol = Color(COL_WHITE));
	virtual ~B2dIAOBitmapObj();

	const Bitmap& GetBitmap() const { return aBmp; }
	void SetBitmap(const Bitmap& rNew);

	BOOL IsTransparenceUsed() const { return bUseTransCol; }
	void SetTransparenceUsed(BOOL bNew);

	UINT16 GetCenterX() const { return nCenterX; }
	UINT16 GetCenterY() const { return nCenterY; }
	void SetCenterXY(UINT16 nNewX, UINT16 nNewY);
};

//************************************************************
//   InterActionObjectBitmapEx
//************************************************************

class B2dIAOBitmapEx : public B2dIAObject
{
	// the Bitmap itself
	BitmapEx					aBmpEx;

	// center of the Bitmap
	UINT16						nCenterX;
	UINT16						nCenterY;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

public:
    TYPEINFO();
	B2dIAOBitmapEx(B2dIAOManager* pMan, Point aPos, const BitmapEx& rBmpEx,
		UINT16 nCenX = 0, UINT16 nCenY = 0);
	virtual ~B2dIAOBitmapEx();

	const BitmapEx& GetBitmapEx() const { return aBmpEx; }
	void SetBitmapEx(const BitmapEx& rNew);

	UINT16 GetCenterX() const { return nCenterX; }
	UINT16 GetCenterY() const { return nCenterY; }
	void SetCenterXY(UINT16 nNewX, UINT16 nNewY);
};

//************************************************************
//   InterActionObjectBitmapExReference
//************************************************************

//class B2dIAOBitmapExReference : public B2dIAObject
//{
//	// the Bitmap itself
//	BitmapEx*					pBmpEx;
//
//	// center of the Bitmap
//	UINT16						nCenterX;
//	UINT16						nCenterY;
//
//	// Create the Geometry - this is the pixel creator
//	virtual void CreateGeometry();
//
//	// Create the BaseRect
//	virtual void CreateBaseRect();
//
//public:
//    TYPEINFO();
//	B2dIAOBitmapExReference(B2dIAOManager* pMan, Point aPos, BitmapEx* pBEx,
//		UINT16 nCenX = 0, UINT16 nCenY = 0);
//	virtual ~B2dIAOBitmapExReference();
//
//	const BitmapEx* GetBitmapEx() const { return pBmpEx; }
//	void SetBitmapEx(BitmapEx* pNew);
//
//	UINT16 GetCenterX() const { return nCenterX; }
//	UINT16 GetCenterY() const { return nCenterY; }
//	void SetCenterXY(UINT16 nNewX, UINT16 nNewY);
//};

//************************************************************
//   InterActionObjectAnimBitmapExReference
//************************************************************

// #97016# II
class B2dIAOAnimatedBitmapEx : public B2dIAObject
{
	// start step value
	UINT16						nStartCount;
	UINT16						nStartAdd;

	// the Bitmaps themselves
	BitmapEx					aBmpEx1;
	BitmapEx					aBmpEx2;

	// centers of the Bitmaps
	UINT16						nCenterX1;
	UINT16						nCenterY1;
	UINT16						nCenterX2;
	UINT16						nCenterY2;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

	// React on animation (optional)
	virtual void AnimationStep(UINT32 nAnimCounter);

public:
    TYPEINFO();
	B2dIAOAnimatedBitmapEx(
		B2dIAOManager* pMan, Point aPos, 
		const BitmapEx& rBEx1, const BitmapEx& rBEx2,
		UINT16 nCenX1 = 0, UINT16 nCenY1 = 0,
		UINT16 nCenX2 = 0, UINT16 nCenY2 = 0);
	virtual ~B2dIAOAnimatedBitmapEx();

	BitmapEx GetBitmapEx1() const { return aBmpEx1; }
	BitmapEx GetBitmapEx2() const { return aBmpEx2; }
	void SetBitmapEx1(const BitmapEx& rNew);
	void SetBitmapEx2(const BitmapEx& rNew);

	UINT16 GetCenterX1() const { return nCenterX1; }
	UINT16 GetCenterY1() const { return nCenterY1; }
	void SetCenterXY1(UINT16 nNewX, UINT16 nNewY);

	UINT16 GetCenterX2() const { return nCenterX2; }
	UINT16 GetCenterY2() const { return nCenterY2; }
	void SetCenterXY2(UINT16 nNewX, UINT16 nNewY);
};


#endif          // _B2D_MBMP_HXX
