/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: packer.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:48:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "packer.hxx"
#include "packer2.hxx"

using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star;

const ULONG BUFFER_SIZE = 128*1024; // a 128k Buffer

UnoPacker::UnoPacker()
{
}

UnoPacker::~UnoPacker()
{
}

// XServiceInfo
OUString SAL_CALL UnoPacker::getImplementationName() throw()
{
    return getImplementationName_Static();
}

sal_Bool SAL_CALL UnoPacker::supportsService(const OUString& ServiceName) throw()
{
	uno::Sequence< OUString > aSNL( getSupportedServiceNames() );
    const OUString * pArray = aSNL.getConstArray();

    for( INT32 i = 0; i < aSNL.getLength(); i++ )
        if( pArray[i] == ServiceName )
            return sal_True;

    return sal_False;
}

uno::Sequence< OUString > SAL_CALL UnoPacker::getSupportedServiceNames(void) throw()
{
    return getSupportedServiceNames_Static();
}

uno::Sequence< OUString > SAL_CALL UnoPacker::getSupportedServiceNames_Static(void) throw()
{
	uno::Sequence< OUString > aSNS( 1 );
    aSNS.getArray()[0] = OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.util.Archiver"));
    return aSNS;
}

// XPacker
sal_Bool SAL_CALL UnoPacker::pack(const uno::Sequence< OUString >& input, const OUString& destination, const uno::Sequence< beans::PropertyValue >& aArgs) throw(  uno::RuntimeException )
{
	UnoPacker_Impl aPacker( aArgs );
	return aPacker.pack( input, destination );
}

sal_Bool SAL_CALL UnoPacker::unpack(const OUString& destinationpath, const OUString& source, const uno::Sequence< OUString >&files, const uno::Sequence< beans::PropertyValue >& aArgs) throw(  ::com::sun::star::uno::RuntimeException)
{
	UnoPacker_Impl aPacker( aArgs );
	return aPacker.unpack( source, destinationpath, files );
}

uno::Reference< container::XIndexAccess > SAL_CALL UnoPacker::getContent(const OUString& source) throw( uno::RuntimeException)
{
	uno::Sequence< beans::PropertyValue > aArgs( 0 );
	UnoPacker_Impl aPacker( aArgs );
	return aPacker.getContent(source);
}

OUString SAL_CALL UnoPacker::getExtraData(const OUString& source ) throw( uno::RuntimeException )
{
	uno::Sequence< beans::PropertyValue > aArgs( 0 );
	UnoPacker_Impl aPacker( aArgs );
	return aPacker.getExtraData(source);
}

/**
 * Create the FrameControl
 */
uno::Reference< uno::XInterface > SAL_CALL UnoPacker_createInstance(const uno::Reference< lang::XMultiServiceFactory > & rSMgr) throw( uno::Exception )
{
	return *new UnoPacker();
}

//***************************************************************************************
//
// Die vorgeschriebene C-Api muss erfuellt werden!
// Sie besteht aus zwei Funktionen, die von dem Modul exportiert werden muessen.

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#include <cppuhelper/factory.hxx>
#include <uno/lbnames.h>

//
#ifdef __cplusplus
extern "C"
{
#endif

void SAL_CALL component_getImplementationEnvironment( const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

sal_Bool SAL_CALL component_writeInfo( void * pServiceManager, void * pRegistryKey )
{
	if( pRegistryKey )
	{
		try
		{
			uno::Reference< registry::XRegistryKey > xNewKey(
				reinterpret_cast< registry::XRegistryKey * >( pRegistryKey )->createKey( 
					OUString( RTL_CONSTASCII_USTRINGPARAM("/") ) + UnoPacker::getImplementationName_Static() + OUString(RTL_CONSTASCII_USTRINGPARAM( "/UNO/SERVICES") ) ) );

		    uno::Sequence< OUString > aServices = UnoPacker::getSupportedServiceNames_Static();
		    for( INT32 i = 0; i < aServices.getLength(); i++ )
		        xNewKey->createKey( aServices.getConstArray()[i]);
		}
		catch (registry::InvalidRegistryException &)
		{
			OSL_ENSURE( sal_False, "### InvalidRegistryException!" );
		}
	}

    return sal_True;
}

void * SAL_CALL component_getFactory( const sal_Char * pImplName, void * pServiceManager, void * pRegistryKey )
{
	void * pRet = 0;
	if( pServiceManager && rtl_str_compare( pImplName, "com.sun.star.extensions.Archiver" ) == 0 )
	{
		uno::Reference< lang::XSingleServiceFactory > xFactory( ::cppu::createOneInstanceFactory( reinterpret_cast< lang::XMultiServiceFactory * >( pServiceManager ),
			UnoPacker::getImplementationName_Static(),
			UnoPacker_createInstance,
			UnoPacker::getSupportedServiceNames_Static() ) );

		if( xFactory.is())
		{
			xFactory->acquire();
			pRet = xFactory.get();
		}
	}

	return pRet;
}

}


