/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: RelationTableView.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 15:33:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_RELATION_TABLEVIEW_HXX
#define DBAUI_RELATION_TABLEVIEW_HXX
								 
#ifndef DBAUI_JOINTABLEVIEW_HXX
#include "JoinTableView.hxx"
#endif

namespace dbaui
{
	class ORelationDesignView;
	class ORelationTableConnectionData;
	class ORelationTableView : public OJoinTableView
	{
		OTableConnection*				m_pExistingConnection; // is set when a connection was draged on an existing connection
		ORelationTableConnectionData*	m_pCurrentlyTabConnData; // set when we creating a connection with more than one keycolumn
	protected:
		virtual void ConnDoubleClicked( OTableConnection* pConnection );
		virtual void AddTabWin(const ::rtl::OUString& _rComposedName, const ::rtl::OUString& rWinName, BOOL bNewTable = FALSE);

		virtual OTableWindow* createWindow(OTableWindowData* _pData);

	public:
		ORelationTableView( Window* pParent, ORelationDesignView* pView );
		virtual ~ORelationTableView();

		//	virtual void AddTabWin(const ::rtl::OUString& _rComposedName, const ::rtl::OUString& rWinName, BOOL bNewTable = FALSE);
		virtual void RemoveTabWin( OTableWindow* pTabWin );
		virtual void AddConnection(const OJoinExchangeData& jxdSource, const OJoinExchangeData& jxdDest);
		virtual ::std::vector<OTableConnection*>::const_iterator RemoveConnection(OTableConnection* pConn,sal_Bool _bDelete);

		virtual void ReSync();

		void AddNewRelation();
			// reisst den Dialog fuer eine voellig neue Relation hoch
		// wird vom AddTabDlg benutzt, um festzustellen, ob noch Tabellen hinzugefuegt werden duerfen
		virtual BOOL IsAddAllowed();

		virtual void lookForUiActivities();
	};
}
#endif // DBAUI_RELATION_TABLEVIEW_HXX


