/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: segmentheap.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:55:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef CONFIGMGR_SEGMENTHEAP_HXX
#define CONFIGMGR_SEGMENTHEAP_HXX

#ifndef CONFIGMGR_DATAHEAP_HXX
#include "heap.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory
    {
    // -------------------------------------------------------------------------	
        class SegmentHeap : Noncopyable
        {
            friend class Segment;
            typedef Heap::Lock Lock;

            Heap   m_heap;
            void * m_base;
            Lock * m_lock;

            Lock & lock() const { return *m_lock; }
        public:
            typedef Heap::HeapId        HeapId;
            typedef Heap::HeapIdParam   HeapIdParam;
            typedef Heap::Size          Size;
            typedef Heap::Address       Address;
            
            SegmentHeap(HeapManager & _rImpl)
            : m_heap(_rImpl)
            { init(); }

            SegmentHeap(HeapManager & _rImpl, Size _aInitialSize)
            : m_heap(_rImpl,_aInitialSize)
            { init(); }

            SegmentHeap(HeapManager & _rImpl, HeapIdParam _anId)
            : m_heap(_rImpl,_anId)
            { init(); }

            ~SegmentHeap();

            // PRE: lock must be acquired
            void*   base() const { return m_base; }
            HeapId  id() const { return m_heap.id(); }

            Address allocate(Size _sz) 
            {
                Address aResult = m_heap.allocate(_sz);
                if (!aResult)
                    aResult = this->allocateMore(_sz);
                return aResult;
            }

            void deallocate(Address _addr) 
            { 
                m_heap.deallocate(_addr); 
            }

            bool isValidAddress(Address _addr) const
            { 
                return m_heap.didAllocate(_addr); 
            }
        private:
            void init();
            Address allocateMore(Size _sz);
        };
    // -------------------------------------------------------------------------	
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr

#endif // CONFIGMGR_SEGMENT_HXX

