/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tp_SeriesStatistic.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:17:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "tp_SeriesStatistic.hxx"

#include "ResId.hxx"
#include "TabPages.hrc"
#include "Strings.hrc"
#include "Bitmaps.hrc"
#include "Bitmaps_HC.hrc"

// #include <so3/iface.hxx>
// #include "schattr.hxx"

#ifndef _SVX_CHRTITEM_HXX //autogen
#include "SchAllDefinesFor_svx_chrtitem.hxx"
#include <svx/chrtitem.hxx>
#endif

/*
#include "schresid.hxx"
#include "chtmodel.hxx"
#include "attrib.hxx"
#include "attrib.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
// for high contrast images
#include "res_hc_bmp.hrc"
*/
// macro for selecting a normal or high contrast bitmap the stack variable
// bIsHighContrast must exist and reflect the correct state
#define SELECT_BITMAP(name) Bitmap( SchResId( bIsHighContrast ? name ## _HC : name ))

//.............................................................................
namespace chart
{
//.............................................................................

enum StatIndicator
{
	INDICATE_NONE,
	INDICATE_BOTH,
	INDICATE_UP,
	INDICATE_DOWN
};

enum StatRegression
{
	REGRESSION_NONE,
	REGRESSION_LINE,
	REGRESSION_LOG,
	REGRESSION_EXP,
	REGRESSION_POW
};

/*************************************************************************
|*
|* Dialog zur Ausrichtung der Legende
|*
\************************************************************************/

SchStatisticTabPage::SchStatisticTabPage(
    Window* pWindow,
    const SfxItemSet& rInAttrs ) :
        SfxTabPage(pWindow, SchResId(TP_STAT), rInAttrs),
        aCbxAverage (this, ResId (CBX_AVERAGE)),
        aFlDescr (this, ResId (FL_ERROR)),
        aRbtNone (this, ResId (RBT_NONE)),
        aRbtVariant (this, ResId (RBT_VARIANT)),
        aRbtSigma (this, ResId (RBT_SIGMA)),
        aRbtPercent (this, ResId (RBT_PERCENT)),
        aRbtBigError (this, ResId (RBT_BIGERROR)),
        aRbtConst (this, ResId (RBT_CONST)),
        aMtrFldPercent (this, ResId (MTR_FLD_PERCENT)),
        aMtrFldBigError (this, ResId (MTR_FLD_BIGERROR)),
        aFTConstPlus (this, ResId (FT_PERCENT_PLUS)),
        aMtrFldConstPlus (this, ResId (MTR_FLD_PLUS)),
        aFTConstMinus (this, ResId (FT_PERCENT_MINUS)),
        aMtrFldConstMinus (this, ResId (MTR_FLD_MINUS)),
        aFTIndicate (this, ResId (FT_INDICATE)),
        aSet (this, ResId (CT_INDICATE)),
        aFTRegress (this, ResId (FT_REGRESS)),
        aRegression (this, ResId (CT_REGRESS)),
        m_bEnableRegression( false )
{
	FreeResource();

	aRbtNone.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
	aRbtVariant.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
	aRbtSigma.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
	aRbtPercent.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
	aRbtBigError.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
	aRbtConst.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
	aCbxAverage.SetClickHdl(LINK(this, SchStatisticTabPage, CbxClick));
// 	aMtrFldConstPlus.SetLoseFocusHdl(LINK(this, SchStatisticTabPage, EditLoseFocusHdl));
// 	aMtrFldConstMinus.SetLoseFocusHdl(LINK(this, SchStatisticTabPage, EditLoseFocusHdl));

    FillValueSets();

	aSet.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD /*| WB_VSCROLL*/ );
	aSet.SetColCount(5);
	aSet.SetLineCount(1);
	aSet.SetExtraSpacing(2);
	aSet.SetSelectHdl(LINK(this, SchStatisticTabPage, SelectIndicate));

    aRegression.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD /*| WB_VSCROLL*/ );
	aRegression.SetColCount(5);
	aRegression.SetLineCount(1);
	aRegression.SetExtraSpacing(2);
	aRegression.SetSelectHdl(LINK(this, SchStatisticTabPage, SelectRegression));
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SchStatisticTabPage::~SchStatisticTabPage()
{
}

/*************************************************************************
|*
|*	Handler fuer ShowSym-Button enablen/disablen
|*
\*************************************************************************/

IMPL_LINK( SchStatisticTabPage, RBtnClick, Button *, pBtn )
{
	aMtrFldPercent.Enable (pBtn == &aRbtPercent);
	aMtrFldBigError.Enable (pBtn == &aRbtBigError);
	aMtrFldConstPlus.Enable (pBtn == &aRbtConst);
	aMtrFldConstMinus.Enable (pBtn == &aRbtConst);
    aFTConstPlus.Enable (pBtn == &aRbtConst);
    aFTConstMinus.Enable (pBtn == &aRbtConst);
    aSet.Show (pBtn != &aRbtNone);
    aFTIndicate.Show (pBtn != &aRbtNone);

	if (pBtn == &aRbtPercent) eKindError = CHERROR_PERCENT;
    else if (pBtn == &aRbtBigError) eKindError = CHERROR_BIGERROR;
    else if (pBtn == &aRbtConst) eKindError = CHERROR_CONST;
    else if (pBtn == &aRbtNone) eKindError = CHERROR_NONE;
    else if (pBtn == &aRbtVariant) eKindError = CHERROR_VARIANT;
    else if (pBtn == &aRbtSigma) eKindError = CHERROR_SIGMA;

	return 0;
}


/*************************************************************************
|*
|*    Bearbeitet das Werteset der Fehlerbalken
|*
\*************************************************************************/

IMPL_LINK( SchStatisticTabPage, SelectIndicate, void *, EMPTYARG )
{
	StatIndicator eSelection = (StatIndicator) aSet.GetSelectItemId();

	switch (eSelection - 1)
	{
		case INDICATE_NONE :
			eIndicate = CHINDICATE_NONE;
			break;

		case INDICATE_BOTH :
			eIndicate = CHINDICATE_BOTH;
			break;

		case INDICATE_UP :
			eIndicate = CHINDICATE_UP;
			break;

		case INDICATE_DOWN :
			eIndicate = CHINDICATE_DOWN;
			break;
	}

	aSet.SelectItem(eSelection);
	aSet.Show ();
    aFTIndicate.Show();

	return 0;
}

/*************************************************************************
|*
|*	Handler fuer Mittelwert-Button
|*
\*************************************************************************/

IMPL_LINK( SchStatisticTabPage, CbxClick, CheckBox *, pBtn )
{
	return 0;
}

/*************************************************************************
|*
|* Erzeugung
|*
\*************************************************************************/

SfxTabPage* SchStatisticTabPage::Create(Window* pWindow,
										const SfxItemSet& rOutAttrs)
{
	return new SchStatisticTabPage(pWindow, rOutAttrs);
}

/*************************************************************************
|*
|* Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\*************************************************************************/

BOOL SchStatisticTabPage::FillItemSet(SfxItemSet& rOutAttrs)
{
	rOutAttrs.Put( SvxChartKindErrorItem( eKindError ));
	rOutAttrs.Put( SvxChartIndicateItem( eIndicate ));
	rOutAttrs.Put( SfxBoolItem (SCHATTR_STAT_AVERAGE, aCbxAverage.IsChecked ()));

	if( m_bEnableRegression )
        rOutAttrs.Put( SvxChartRegressItem( m_eRegression ));

	switch (eKindError)
	{
		case CHERROR_PERCENT :
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldPercent.GetValue () / 10.0, SCHATTR_STAT_PERCENT));
			break;

		case CHERROR_BIGERROR :
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldBigError.GetValue () / 10.0, SCHATTR_STAT_BIGERROR));
			break;

		case CHERROR_CONST :
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstPlus.GetValue () / 10.0, SCHATTR_STAT_CONSTPLUS));
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstMinus.GetValue () / 10.0, SCHATTR_STAT_CONSTMINUS));
			break;

        case CHERROR_NONE:
        case CHERROR_VARIANT:
        case CHERROR_SIGMA:
            // nothing
            break;
	}

	return TRUE;
}

/*************************************************************************
|*
|* Initialisierung
|*
\*************************************************************************/

void SchStatisticTabPage::Reset(const SfxItemSet& rInAttrs)
{
	const SfxPoolItem *pPoolItem = NULL;

	if (rInAttrs.GetItemState(SCHATTR_STAT_AVERAGE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxAverage.Check(((const SfxBoolItem*) pPoolItem)->GetValue());

	if (rInAttrs.GetItemState(SCHATTR_STAT_KIND_ERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eKindError = ((const SvxChartKindErrorItem*) pPoolItem)->GetValue();
	else eKindError = CHERROR_NONE;

    aSet.Show(eKindError != CHERROR_NONE);
    aFTIndicate.Show(eKindError != CHERROR_NONE);

    sal_Int32 nPlusValue = 0;
	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTPLUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
    {
        nPlusValue = static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
		aMtrFldConstPlus.SetValue( nPlusValue );
    }

    sal_Int32 nMinusValue = 0;
	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTMINUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
    {
        nMinusValue = static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
        aMtrFldConstMinus.SetValue( nMinusValue );
    }

    {
        sal_Int32 nAvg = (nPlusValue + nMinusValue) / 2;
        aMtrFldPercent.SetValue(  nAvg );
        aMtrFldBigError.SetValue( nAvg );
    }

// 	if (rInAttrs.GetItemState(SCHATTR_STAT_PERCENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
// 		aMtrFldPercent.SetValue( static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue()  * 10.0 ));
// 	else aMtrFldPercent.SetValue( 0 );

// 	if (rInAttrs.GetItemState(SCHATTR_STAT_BIGERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
// 		aMtrFldBigError.SetValue( static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue()  * 10.0 ));
// 	else aMtrFldBigError.SetValue( 0 );

    if( m_bEnableRegression )
    {
        aFTRegress.Show ();
        aRegression.Show ();
    }
    else
    {
        aRegression.Hide ();
        aFTRegress.Hide ();
    }

	aRbtNone.Check (eKindError == CHERROR_NONE);
	aRbtVariant.Check (eKindError == CHERROR_VARIANT);
	aRbtSigma.Check (eKindError == CHERROR_SIGMA);
	aRbtPercent.Check (eKindError == CHERROR_PERCENT);
	aRbtBigError.Check (eKindError == CHERROR_BIGERROR);
	aRbtConst.Check (eKindError == CHERROR_CONST);

    aMtrFldPercent.Enable (eKindError == CHERROR_PERCENT);
    aMtrFldBigError.Enable (eKindError == CHERROR_BIGERROR);
    aMtrFldConstPlus.Enable (eKindError == CHERROR_CONST);
    aMtrFldConstMinus.Enable (eKindError == CHERROR_CONST);
    aFTConstPlus.Enable (eKindError == CHERROR_CONST);
    aFTConstMinus.Enable (eKindError == CHERROR_CONST);

	if (rInAttrs.GetItemState(SCHATTR_STAT_INDICATE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eIndicate = ((const SvxChartIndicateItem*) pPoolItem)->GetValue();
	else eIndicate = CHINDICATE_BOTH;

	switch (eIndicate)
	{
		case CHINDICATE_NONE :
			aSet.SelectItem(INDICATE_NONE + 1);
			break;

		case CHINDICATE_BOTH :
			aSet.SelectItem(INDICATE_BOTH + 1);
			break;

		case CHINDICATE_UP :
			aSet.SelectItem(INDICATE_UP + 1);
			break;

		case CHINDICATE_DOWN :
			aSet.SelectItem(INDICATE_DOWN + 1);
			break;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_REGRESSTYPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		m_eRegression = ((const SvxChartRegressItem *) pPoolItem)->GetValue();
	else m_eRegression = CHREGRESS_NONE;

	switch (m_eRegression)
	{
		case CHREGRESS_NONE :
			aRegression.SelectItem(REGRESSION_NONE + 1);
			break;

		case CHREGRESS_LINEAR :
			aRegression.SelectItem(REGRESSION_LINE + 1);
			break;

		case CHREGRESS_LOG :
			aRegression.SelectItem(REGRESSION_LOG + 1);
			break;

		case CHREGRESS_EXP :
			aRegression.SelectItem(REGRESSION_EXP + 1);
			break;

		case CHREGRESS_POWER :
			aRegression.SelectItem(REGRESSION_POW + 1);
			break;
	}
}

/*************************************************************************
|*
|*    Bearbeite das Valueset
|*
\*************************************************************************/

// IMPL_LINK( SchStatisticTabPage, EditLoseFocusHdl, Control *, pControl )
// {
// 	if ((double) aMtrFldConstPlus.GetValue () == 0.0)
// 	{
// 		if ((double) aMtrFldConstMinus.GetValue () == 0.0)
// 		{
// 			eIndicate = CHINDICATE_NONE;
// 			aSet.SelectItem(INDICATE_NONE + 1);
// 		}
// 		else if (eIndicate != CHINDICATE_NONE)
// 			 {
// 				 eIndicate = CHINDICATE_DOWN;
// 				 aSet.SelectItem(INDICATE_DOWN + 1);
// 			 }
// 	}
// 	else if ((double) aMtrFldConstMinus.GetValue () == 0.0)
// 		 {
// 			 if (eIndicate != CHINDICATE_NONE)
// 			 {
// 				 eIndicate = CHINDICATE_UP;
// 				 aSet.SelectItem(INDICATE_UP + 1);
// 			 }
// 		 }
// 		 else
// 		 {
// 			 eIndicate = CHINDICATE_BOTH;
// 			 aSet.SelectItem(INDICATE_BOTH + 1);
// 		 }

// 	return 0;
// }

/*************************************************************************
|*
|*    Bearbeitet das Werteset der Regression
|*
\*************************************************************************/

IMPL_LINK( SchStatisticTabPage, SelectRegression, void *, EMPTYARG )
{
	StatRegression eSelection = (StatRegression) aRegression.GetSelectItemId();

    switch (eSelection - 1)
	{
		case REGRESSION_NONE :
			m_eRegression = CHREGRESS_NONE;
			break;

		case REGRESSION_LINE :
			m_eRegression = CHREGRESS_LINEAR;
			break;

		case REGRESSION_LOG :
			m_eRegression = CHREGRESS_LOG;
			break;

		case REGRESSION_EXP :
			m_eRegression = CHREGRESS_EXP;
			break;

		case REGRESSION_POW :
			m_eRegression = CHREGRESS_POWER;
			break;
	}

	aRegression.SelectItem(eSelection);
	aRegression.Show ();
    aFTRegress.Show ();

    return 0;
}

void SchStatisticTabPage::FillValueSets()
{
    bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );

    if( aSet.GetItemCount() == 0 )
    {
        aSet.InsertItem( INDICATE_NONE + 1, SELECT_BITMAP( BMP_INDICATE_NONE ),
                         String(SchResId(STR_INDICATE_NONE)));
        aSet.InsertItem( INDICATE_BOTH + 1, SELECT_BITMAP( BMP_INDICATE_BOTH ),
                         String(SchResId(STR_INDICATE_BOTH)));
        aSet.InsertItem( INDICATE_DOWN + 1, SELECT_BITMAP( BMP_INDICATE_DOWN ),
                         String(SchResId(STR_INDICATE_DOWN)));
        aSet.InsertItem( INDICATE_UP + 1, SELECT_BITMAP( BMP_INDICATE_UP ),
                         String(SchResId(STR_INDICATE_UP)));
    }
    else
    {
        aSet.SetItemImage( INDICATE_NONE + 1, SELECT_BITMAP( BMP_INDICATE_NONE ));
        aSet.SetItemImage( INDICATE_BOTH + 1, SELECT_BITMAP( BMP_INDICATE_BOTH ));
        aSet.SetItemImage( INDICATE_DOWN + 1, SELECT_BITMAP( BMP_INDICATE_DOWN ));
        aSet.SetItemImage( INDICATE_UP + 1, SELECT_BITMAP( BMP_INDICATE_UP ));
    }

    if( aRegression.GetItemCount() == 0 )
    {
        aRegression.InsertItem( REGRESSION_NONE + 1, SELECT_BITMAP( BMP_REGRESSION_NONE ),
                                String(SchResId(STR_REGRESSION_NONE)));
        aRegression.InsertItem( REGRESSION_LINE + 1, SELECT_BITMAP( BMP_REGRESSION_LINEAR ),
                                String(SchResId(STR_REGRESSION_LINEAR)));
        aRegression.InsertItem( REGRESSION_LOG + 1, SELECT_BITMAP( BMP_REGRESSION_LOG ),
                                String(SchResId(STR_REGRESSION_LOG)));
        aRegression.InsertItem( REGRESSION_EXP + 1, SELECT_BITMAP( BMP_REGRESSION_EXP ),
                                String(SchResId(STR_REGRESSION_EXP)));
        aRegression.InsertItem( REGRESSION_POW + 1, SELECT_BITMAP( BMP_REGRESSION_POWER ),
                                String(SchResId(STR_REGRESSION_POWER)));
    }
    else
    {
        aRegression.SetItemImage( REGRESSION_NONE + 1, SELECT_BITMAP( BMP_REGRESSION_NONE ));
        aRegression.SetItemImage( REGRESSION_LINE + 1, SELECT_BITMAP( BMP_REGRESSION_LINEAR ));
        aRegression.SetItemImage( REGRESSION_LOG + 1, SELECT_BITMAP( BMP_REGRESSION_LOG ));
        aRegression.SetItemImage( REGRESSION_EXP + 1, SELECT_BITMAP( BMP_REGRESSION_EXP ));
        aRegression.SetItemImage( REGRESSION_POW + 1, SELECT_BITMAP( BMP_REGRESSION_POWER ));
    }
}

void SchStatisticTabPage::DataChanged( const DataChangedEvent& rDCEvt )
{
    SfxTabPage::DataChanged( rDCEvt );

    if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
        FillValueSets();
}

void SchStatisticTabPage::EnableRegression( bool bEnable /* = true */ )
{
    m_bEnableRegression = bEnable;
}

//.............................................................................
} //namespace chart
//.............................................................................
