/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: iothreads.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:40:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <stdio.h>
#include <list>

#include <com/sun/star/uno/Sequence.hxx>
#include <com/sun/star/corba/giop/RequestHeader_1_2.hpp>
#include <com/sun/star/corba/giop/ReplyHeader_1_2.hpp>

#include <osl/thread.hxx>

#include <bridges/remote/context.h>
#include <bridges/remote/unmarshal.hxx>



namespace bridges_remote
{

class OWriterThread;

class OReaderThread :
	public ::osl::Thread
{
public:
	OReaderThread( remote_Connection *pConnection ,
				   void ( SAL_CALL * doRequest ) ( void * ),
				   uno_Environment *pEnvRemote,
				   OWriterThread *pWriterThread );
	~OReaderThread();
	
	virtual void SAL_CALL run();
	virtual void SAL_CALL onTerminated();

	void destroyYourself()
		{ m_bDestroyMyself = sal_True; }
	void sendMessageError();
	void abort();
	
private:
	remote_Connection *m_pConnection;
	void ( SAL_CALL * m_doRequest ) ( void * );
	uno_Environment *m_pEnvRemote;
	OWriterThread *m_pWriterThread;
	sal_Int32 m_nMessageErrorCount;
	sal_Bool m_bDestroyMyself;
};

class OWriterThread :
	public ::osl::Thread
{
public:
	OWriterThread( remote_Connection *pConnection );
	~OWriterThread(  );
	
	virtual void SAL_CALL run();

	void enqueue( const ::com::sun::star::uno::Sequence< sal_Int8 > &seq );

	void abort();
private:
	::osl::Mutex m_mutex;
	oslCondition m_oslCondition;

	sal_Bool m_bAbort;
	remote_Connection *m_pConnection;
	::std::list < ::com::sun::star::uno::Sequence< sal_Int8 > > m_lst;
	
};

class RequestInfo
{
public:
	RequestInfo( uno_Environment *pEnvRemote,
				 const ::com::sun::star::uno::Sequence< sal_Int8 > &,
				 sal_Bool bIsLittleEndian );

	~RequestInfo( );
public:
	uno_Environment *m_pEnvRemote; // Weak
	::com::sun::star::corba::giop::RequestHeader_1_2 m_requestHeader;
	::com::sun::star::uno::Sequence< sal_Int8 > m_seqBody;
	Unmarshal m_unmarshal;
	sal_Bool m_bIsLittleEndian;
	
};

class ReplyInfo
{
public:
	ReplyInfo( uno_Environment *pEnvRemote,
			   const ::com::sun::star::uno::Sequence< sal_Int8 > &,
			   sal_Bool bIsLittleEndian );
	~ReplyInfo( );
	
public:
	uno_Environment *m_pEnvRemote; 
	::com::sun::star::corba::giop::ReplyHeader_1_2   m_replyHeader;
	::com::sun::star::uno::Sequence< sal_Int8 > m_seqBody;
	Unmarshal m_unmarshal;
	sal_Bool m_bIsLittleEndian;
};

void SAL_CALL sendCloseConnection( uno_Environment *pEnvUno );


//--------------------------------------------
// the bridge internal per environment data
//--------------------------------------------




}

