/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sto_cpp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:19:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <sto_cpp.hxx>


// NOT FULLY DEFINED SERVICES
#include <ary/ce.hxx>
#include <ary/cpp/c_namesp.hxx>
#include <ary/cpp/usedtype.hxx>
#include <ary/cpp/c_define.hxx>
#include <ary/cpp/c_macro.hxx>
#include <ary/cpp/c_osigna.hxx>
#include "t_storg.hxx"




namespace ary
{
namespace store
{

//************************          Cpp_Impl         *******************//


struct Cpp::Cpp_Impl
{
                        Cpp_Impl();
                        ~Cpp_Impl();

    StdReStorage< ary::CodeEntity > 
                        aCes;

    StdReStorage< ary::cpp::UsedType >
                        aUsedTypes;

    StdReStorage< ary::cpp::Define >
                        aDefines;
    StdReStorage< ary::cpp::Macro >
                        aMacros;

	StdReStorage< ary::cpp::OperationSignature >
						aOSigns;
};

Cpp::
Cpp_Impl::Cpp_Impl()
{
}

Cpp::
Cpp_Impl::~Cpp_Impl()
{
}




//************************          Cpp         *******************//

Cpp::Cpp()
	:   pi( new Cpp_Impl )
{
}

Cpp::~Cpp()
{
}

ReStorage< ary::CodeEntity > &
Cpp::Ces()
{
    return pi->aCes;
}

ReStorage< ary::cpp::UsedType > &
Cpp::UsedTypes()
{
    return pi->aUsedTypes;
}

ReStorage< ary::cpp::Define > &
Cpp::Defines()
{
    return pi->aDefines;
}

ReStorage< ary::cpp::Macro > &
Cpp::Macros()
{
	return pi->aMacros;
}

ReStorage< ary::cpp::OperationSignature > &
Cpp::OSigns()
{
	return pi->aOSigns;
}


}
}


