/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ifcc_df.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:04:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_IFCC_DF_HXX
#define ARY_STORE_IFCC_DF_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>
#include <ary/idlists.hxx>
#include "../nametree.hxx"


namespace ary
{
    namespace cpp
    {
		class Define;
        class Macro;
	}

    class InstanceList;

namespace store
{
	class Cpp;

namespace cpp
{


class Defs_Ifc
{
  public:
	// LIFECYCLE
						Defs_Ifc(
							ary::store::Cpp & 	io_rStorageCpp );
						~Defs_Ifc();

	// OPERATIONS
	void                Add_Define(
							DYN ary::cpp::Define &
												let_drDefine );
	void                Add_Macro(
                            DYN ary::cpp::Macro &
                                                let_drMacro );

	// INQUIRY
	const ary::cpp::Define *
						Find_Define(
							ary::cpp::Did       i_nId ) const;
	const ary::cpp::Macro *
						Find_Macro(
							ary::cpp::Did       i_nId ) const;
	const InstanceList &
						Search_DefineName(
							const udmstri &     i_sName ) const;
	const InstanceList &
                        Search_MacroName(
							const udmstri &     i_sName ) const;
	uintt				Get_AllDefines(
							List_Rid &          o_rResult ) const;
	uintt				Get_AllMacros(
							List_Rid &          o_rResult ) const;

    ary::NameTree::const_iterator
                        LowerBound_Define(
                            const char *        i_sSearch ) const;
    ary::NameTree::const_iterator
                        LowerBound_Macro(
                            const char *        i_sSearch ) const;

	// ACCESS
  private:
	struct CheshireCat;
	// DATA
    Dyn<CheshireCat>	pi;
};



// IMPLEMENTATION



}   // namespace cpp
}   // namespace store
}   // namespace ary



#endif

