/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ServiceFinder.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:03:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// Find and print services that have ServiceInfo 
// attributes.

/*
  adapted from "Core Jini" by Keith Edwards
 */

package com.sun.xmlsearch.xml.qe;

import java.util.StringTokenizer;

import net.jini.discovery.LookupDiscovery;
import com.sun.jini.discovery.LookupLocatorDiscovery;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.lookup.entry.Name;
import net.jini.core.entry.Entry;
import java.util.Hashtable;
import java.util.Vector;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.io.IOException;
import com.sun.jini.lookup.entry.BasicServiceType;

import org.w3c.dom.*;

public final class ServiceFinder implements Runnable {
    protected Hashtable _registrars = new Hashtable();
    protected Hashtable _services = new Hashtable();
    protected ServiceTemplate _serviceTemplate;

    private String[] _groups = { "XmlSearch" };
    private final Vector _result;

    public void configure(Element serviceInfo) throws Exception {
	StringTokenizer groups =
	    new StringTokenizer(serviceInfo.getAttribute("groups"));
	if (groups != null) {
	    int n = groups.countTokens();
	    if (n > 0) {
		_groups = new String[n];
		for (int i = 0; i < n; i++)
		    _groups[i] = groups.nextToken();
	    }
	}
	String lookup = serviceInfo.getAttribute("lookup");

	Entry[] attrs = null;
	if (serviceInfo.getTagName().equals("XmlSearchService")) {
	    attrs = new Entry[] { new BasicServiceType("XmlSearchService") };
	}
	else if (serviceInfo.getTagName().equals("XmlDocumentService")) {
	    attrs = new Entry[] { new BasicServiceType("XmlDocumentService") };
	}
	_serviceTemplate = new ServiceTemplate(null, null, attrs);
	// set up for discovery
	System.out.println("LookupDiscovery in groups:");
	for (int i = 0; i < _groups.length; i++)
	    System.out.println("\tgroup " + _groups[i]);
    
	if (lookup != null && lookup.length() > 0) {
	    LookupLocator loc = new LookupLocator(lookup);
	    LookupLocator[] locArray = new LookupLocator[] { loc };
	    LookupLocatorDiscovery disco =
		new LookupLocatorDiscovery(locArray);
	    disco.addDiscoveryListener(new Discoverer());
	}
	else {
	    LookupDiscovery disco = new LookupDiscovery(_groups);
	    disco.addDiscoveryListener(new Discoverer());
	}
    }

    private final class Discoverer implements DiscoveryListener {
	public void discovered(DiscoveryEvent ev) {
	    ServiceRegistrar[] newregs = ev.getRegistrars();
	    for (int i = 0; i < newregs.length; i++)
		addRegistrar(newregs[i]);
	}
	public void discarded(DiscoveryEvent ev) {
	    ServiceRegistrar[] newregs = ev.getRegistrars();
	    for (int i = 0; i < newregs.length; i++)
		removeRegistrar(newregs[i]);
	}
    }
    
    public ServiceFinder(Vector result, String serviceType) throws IOException {
	_result = result;
	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(new RMISecurityManager());
	}

	// build our template
	Entry[] attrs = new Entry[]
	{ new BasicServiceType(serviceType) };
	_serviceTemplate = new ServiceTemplate(null, null, attrs);
    
	// set up for discovery
	LookupDiscovery disco = new LookupDiscovery(_groups);
	disco.addDiscoveryListener(new Discoverer());
    }
    
    protected synchronized void addRegistrar(ServiceRegistrar reg) {
	if (_registrars.contains(reg.getServiceID()))
	    return;
            
	_registrars.put(reg.getServiceID(), reg);
	findServices(reg);
    }
  
    protected synchronized void removeRegistrar(ServiceRegistrar reg) {
	if (!_registrars.contains(reg.getServiceID()))
	    return;
        
	_registrars.remove(reg.getServiceID());
    }
    
    private synchronized void findServices(ServiceRegistrar reg) {
	try {
	    ServiceMatches matches = reg.lookup(_serviceTemplate,
						Integer.MAX_VALUE);
	    System.out.println(matches.totalMatches + " services found " + reg);
	    if (matches.totalMatches == 0)
		matches = reg.lookup(_serviceTemplate, Integer.MAX_VALUE);
	
	    for (int i = 0; i < matches.totalMatches; i++) {
		if (_services.contains(matches.items[i].serviceID))
		    continue;
		addService(matches.items[i]);
	    }
	}
	catch (RemoteException ex) {
	    System.err.println("Couldn't search for services: " +
			       ex.getMessage());
	}
    }
  
    public synchronized int getNumberOfServices() {
	return _result.size();
    }

    protected void addService(ServiceItem item) {
	_services.put(item.serviceID, item);
	System.out.println("New service found: " + item.serviceID);
	printServiceInfo(item);
	if (_result != null && item.service != null)
	    _result.addElement(item);
    }

    protected void printServiceInfo(ServiceItem item) {
	for (int i = 0; i < item.attributeSets.length; i++) {
	    if (item.attributeSets[i] instanceof ServiceInfo) {
		ServiceInfo info = (ServiceInfo) item.attributeSets[i];
		System.out.println("    ServiceInfo = " + info.name);
	    }
	    else if (item.attributeSets[i] instanceof Name) {
		Name name = (Name) item.attributeSets[i];
		System.out.println("    Name = " + name.name);
	    }
	    else if (item.attributeSets[i] instanceof SearchEngineEntry) {
		System.out.println("    SearchEngineEntry");
		SearchEngineEntry sc =
		    (SearchEngineEntry)item.attributeSets[i];
		try {
		    System.out.println("    Server         = " + sc.getServer());
		    if (sc.getServer() != null)
			System.out.println("    Classification = " +
					   sc.getServer().getClassification());
		}
		catch (Exception e) {
		    e.printStackTrace();
		}
	    }
	}
    }
    
    public void run() {
	while (true) {
	    try {
		Thread.sleep(Long.MAX_VALUE);
	    } catch (InterruptedException ex) {}
	}
    }
    
    /*
      public static void main(String args[]) {
      try {
      ServiceFinder finder = new ServiceFinder(null);
      new Thread(finder).start();
      } catch (Exception ex) {
      System.err.println("Error starting service info finder: " +
      ex.getMessage());
      ex.printStackTrace();
      }
      }
    */
}
