/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: RemoteDocumentServerImpl.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:01:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.*;
import java.util.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import com.sun.jini.lease.LeaseRenewalManager;
import com.sun.jini.lookup.JoinManager;
import com.sun.jini.lookup.ServiceIDListener;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.admin.DestroyAdmin;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.discovery.LookupLocator;
import net.jini.admin.Administrable;
import net.jini.discovery.DiscoveryListener;
import com.sun.jini.discovery.LookupLocatorDiscovery;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.DiscoveryEvent;

public final class RemoteDocumentServerImpl implements RemoteDocumentServer {
    private final DocumentFragmentServer _server;

    private RemoteDocumentServerImpl(String[] args) throws RemoteException {
	super();
	UnicastRemoteObject.exportObject(this);
	try {
	    _server = new DocumentFragmentServerImpl(args);
	}
	catch (Exception e) {
	    throw new RemoteException("in constructor", e);
	}
    }

    public Object getAdmin() throws RemoteException {
	return new DocumentServerAdmin(this);
    }

    public static void main(String[] args) {
	try {
	    if (args.length != 2) {
		System.err.println("usage: docRootDir httpRoot");
		System.exit(1);
	    }
	    RemoteDocumentServerImpl server =
		new RemoteDocumentServerImpl(args);
	    server.setup();
	    (new Thread() {
		    public void run() {
			while (true) {
			    try {
				Thread.sleep(Long.MAX_VALUE);
			    } catch (InterruptedException ex) {}
			}
		    }}).start();
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }
  
    public DocumentFragment getDocumentFragment(DocumentRequest request)
	throws RemoteException {
	try {
	    return _server.getDocumentFragment(request);
	}
	catch (Exception e) {
	    throw new RemoteException("getDocumentFragment ", e);
	}
    }
  
    public CollectionModel getCollectionModel(String classification)
	throws RemoteException {
	try {
	    return _server.getCollectionModel(classification);
	}
	catch (Exception e) {
	    throw new RemoteException("getCollectionModel ", e);
	}
    }

    private static final String PRODUCT      = "XmlSearchService";
    private static final String MANUFACTURER = "Sun Microsystems, Inc.";
    private static final String VENDOR       = MANUFACTURER;
    private static final String VERSION      = "1.0";
  
    private String[]       _groupsToJoin = { "XmlSearch" };
    private JoinManager    _joinMgr;
  
    private Entry[]        _serviceAttrs;
    public static ServiceRegistrar _lookupSrvc = null;
    private LookupLocator[] _lookupLocators;
    private LookupDiscovery _lookupDiscovery;
    public static ArrayList _lookupInfoList = new ArrayList();
  
    private void setup() {
    
	if (_lookupSrvc == null)	// first time
	    System.setSecurityManager(new RMISecurityManager());
	/* Use LookupLocatorDiscovery to find a Lookup Service */
	if (_lookupSrvc == null) { // first time
	    // Use LookupDiscovery to find a Lookup Service
	    try {
		System.out.println("LookupDiscovery for " + _groupsToJoin[0]);
		_lookupDiscovery = new LookupDiscovery(_groupsToJoin);
	    }
	    catch (IOException e) {
		System.out.println("IOException from LookupDiscovery constructor");
	    }
	    _lookupDiscovery
		.addDiscoveryListener(new
		    LookupDiscoveryListener(_groupsToJoin));
	}

	startService();
    }

    public void close() {
	(new Thread() {
		public void run(){
		    try {
			_joinMgr.terminate();
			_joinMgr = null;
			System.exit(0);
		    }
		    catch (Exception e) {
			System.err.println(e);
		    }
		}}).start();
    }
  
    private void startService() {
	_serviceAttrs =
	    new Entry[] { new ServiceInfo(PRODUCT,
					  MANUFACTURER,
					  VENDOR,
					  VERSION,
					  null, null),
			  new BasicServiceType("XmlDocumentService"),
			  new net.jini.lookup.entry.Name("Xml Transformation Service")
			      };
    
	/* Create a LeaseRenewalManager for the JoinManager to use */
	LeaseRenewalManager leaseRenewalMgr = new LeaseRenewalManager();
	try {
	    _joinMgr = new JoinManager(this,
				       _serviceAttrs,
				       _groupsToJoin,
				       _lookupLocators,
				       new ServiceIDListenerImpl(),
				       leaseRenewalMgr);
	} catch (IOException e) {
	    System.out.println("IOException from JoinManager constructor");
	    e.printStackTrace();
	}
    }
  
    private final class ServiceIDListenerImpl implements ServiceIDListener {
    
	public ServiceIDListenerImpl() {
	    super();
	}
    
	public void serviceIDNotify(ServiceID serviceID) {
	    System.out.println("\nRegistered ServiceID:  " +serviceID.toString());
	}
    } // end of ServiceIDListenerImpl

    private final class LookupDiscoveryListener implements DiscoveryListener {
	private String[] groupsWanted;
  
	public LookupDiscoveryListener(String[] groupsWanted) {
	    super();
	    this.groupsWanted = groupsWanted;
	}
    
	public void discovered(DiscoveryEvent evnt) {
	    System.out.println("LookupDiscoveryListener:  discovered...");
	    ServiceRegistrar[] regs = evnt.getRegistrars();
	    Thread storeThread = new StoreLookupInfoThread(regs, groupsWanted);
	    storeThread.start();
	}
    
	public void discarded(DiscoveryEvent evnt) {
	    /* Retrieve the discarded lookup service(s) from the event */
	    ServiceRegistrar[] regs = evnt.getRegistrars();
	    for (int i = 0; i < regs.length; i++) {
		System.out.println("  Discarded Lookup: "+regs[i]);
	    }
	}
    } // end of LookupDiscoveryListener
  
    private final class StoreLookupInfoThread extends Thread {
	private static final String PUBLIC_GROUP = "";
	private ServiceRegistrar[] regs;
	private String[] groupsWanted;
    
	public StoreLookupInfoThread(ServiceRegistrar[] regs,
				     String[] groupsWanted)
	{
	    super("storeLookupInfoThread");
	    //    setDaemon(true);
	    this.regs = regs;
	    this.groupsWanted = groupsWanted;
	}

	public void run() {
	    for (int i=0; i < regs.length; i++) {
		try {
		    try {
			/* Retrieve the groups of all the discovered lookups */
			String[] regGroups = regs[i].getGroups();
			LookupLocator loc = regs[i].getLocator();
			_lookupSrvc = regs[i];
			String loc_str = loc.toString();
			Vector groupsVec = new Vector();
			/* Look for only lookups in groups that were input */
			System.out.println("  Lookup on host "+loc_str+":");
			System.out.println("regGroups.length = " + regGroups.length);
			for(int j=0; j<regGroups.length; j++) {
			    if(regGroups[j].compareTo(PUBLIC_GROUP) == 0) {
				System.out.println
				    ("  belongs to Group: public");
			    } else {
				System.out.println("  belongs to Group: "+regGroups[j]);
			    }
			    if(groupsWanted != null) {
				for(int k=0; k<groupsWanted.length; k++) {
				    if(regGroups[j].compareTo
				       (groupsWanted[k]) == 0)
					{
					    groupsVec.add(regGroups[j]);
					}
				}
			    } else {
				groupsVec.add(regGroups[j]);
			    }
			}
			int nGroups = groupsVec.size();
			if( nGroups > 0 || true) {
			    synchronized (_lookupInfoList) {
				_lookupInfoList.add
				    (new LookupInfo(regs[i],loc_str,
						    (String[])groupsVec.toArray
						    (new String[nGroups])));
			    }
			}
			int nLookups = _lookupInfoList.size();
			System.out.println("nLookups = " + nLookups);
		    } catch (java.security.AccessControlException e) {
			/* Connection Disallowed */
			System.out.println
			    ("    Security Restriction: Policy"
			     +" file of discovered Lookup"
			     +"\n                         "
			     +" does not allow service registrations,"
			     +"\n                         "
			     +" service lookups, or other remote"
			     +"\n                         "
			     +" invocations from the current host");
		    }
		} catch (RemoteException e) {
		    System.out.println
			("RemoteException on call to getLocator() "+e.toString());
		}
	    }
	}
    }
  

    private final class LookupInfo {
	public ServiceRegistrar _lookupSrvc;
	public String           _hostname;
	public String[]         _groups;
  
	public LookupInfo(ServiceRegistrar lookupSrvc,
			  String hostname,
			  String[] groups) {
	    _lookupSrvc = lookupSrvc;
	    _hostname = hostname;
	    _groups = groups;
	}
    }
}
