/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: LineInput.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:48:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
/**
 * An efficient line reader intended to be used with sockets
 *
 */

package com.sun.xmlsearch.util;

import java.io.File;
import java.io.InputStream;
import java.io.IOException;
import java.io.FileInputStream;	// for test in main()
import java.io.FileNotFoundException;

public final class LineInput implements java.io.Serializable {
  private static final int BUFSIZE = 4096;
  private InputStream _input;
  private byte[]      _buffer = new byte[BUFSIZE];
  private byte[]      _buffer1 = new byte[1];
  private int         _readFromInput = 0;
  private int         _prev = 0;
  private int         _current = 0;
  
  public LineInput(InputStream input) {
    _input = input;
  }

  public LineInput(File file) throws java.io.FileNotFoundException {
    _input = new FileInputStream(file);
  }

  public int available() {
    return _readFromInput - _current;
  }
  
  public void flush() throws IOException {
    while (_input.available() > 0 && _input.read(_buffer) > -1)
      ;
    _readFromInput = _current = -1;
  }

  public String readLine() throws IOException {
    if (available() == 0)
      readBuffer();
    if (_readFromInput == -1)
      return null;
    _prev = _current;
    while (_current < _readFromInput)
      switch (_buffer[_current++]) {
      case '\r':
	if (_current == BUFSIZE) {
	  if (_input.read(_buffer1) != 1)
	    throw(new IOException("unexpected end of input"));
	  if (_buffer1[0] == '\n')
	    return new String(_buffer, _prev, BUFSIZE - 1 - _prev);
	  else
	    return new String(_buffer, _prev, _current - _prev)
+ new String(_buffer1)
+ readLine();
	}
	if (_buffer[_current] == '\n')
	  return new String(_buffer, _prev, _current++ - _prev - 1);
	// else fallthrough
      case '\n':
	return new String(_buffer, _prev, _current - _prev - 1);
      }
    return new String(_buffer, _prev, _current - _prev) + readLine();
  }
  
  public void close() throws IOException {
    _input.close();
  }

  private void readBuffer() throws IOException {
    _readFromInput = _input.read(_buffer);
    _current = 0;
  }

  public static void main(String[] args) {
    FileInputStream in = null;
    try {
      in = new FileInputStream("LineInput.java");
    } catch (FileNotFoundException e) { return; }
    LineInput lineInput = new LineInput(in);
    try {
      String line;
      while ((line = lineInput.readLine()) != null)
	System.out.println(line);
    } catch (IOException e) { System.err.println(e); }
    finally {
      if (in != null)
	try {
	  in.close();
	} catch (IOException e) { System.err.println(e); }
    }
  }
}
