/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ExtensibleURLStreamHandlerFactory.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:46:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.util;

import java.util.Hashtable;
import java.net.*;

public final class ExtensibleURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
    private final Hashtable _handlerClasses = new Hashtable();
    
    public void setHandler(String protocol, String className) {
	_handlerClasses.put(protocol, className);
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
	try {
	    final String className = (String)_handlerClasses.get(protocol);
	    Class handlerClass = null;

	    if (className != null)
	    	handlerClass = Class.forName(className);
	    else {
            	try {
                	handlerClass = Class.forName(
                        	"sun.net.www.protocol."+protocol+".Handler");
                } catch (java.lang.ClassNotFoundException ec) {
                	handlerClass = Class.forName(
				"gnu.java.net.protocol."+protocol+".Handler");
		}
	    }
	    return (URLStreamHandler)handlerClass.newInstance();
	}
	catch (Exception e) {
	    System.err.println(e);
	    return null;
	}
    }
}
