/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Cache.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:43:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

import java.util.Hashtable;
import java.util.Enumeration;

public final class Cache {
  private static final int DefaultSleepTime = 10000;
  private final Hashtable _data = new Hashtable();
  private final int _sleepTime;
  private final int _maxAge;

  private final class TimeStamp {
    private final Object _object;
    private long  _lastAccess;

    public TimeStamp(Object object) {
      _object = object;
      _lastAccess = System.currentTimeMillis();
    }
    
    public Object access() {
      _lastAccess = System.currentTimeMillis();
      return _object;
    }

    public boolean expired(long oldest) {
      return _lastAccess < oldest;
    }
  } // end of TimeStamp
  
  public Cache(int maximalAge) {
    _maxAge = maximalAge;
    _sleepTime = Math.min(DefaultSleepTime, maximalAge);
    (new Thread() {
      public void run() {
	while (true) {
	  try {
	    Thread.sleep(_sleepTime);
	    checkExpiration();
	  }
	  catch (InterruptedException e) {}
	}}}).start();
  }

  private synchronized void checkExpiration() {
    final long oldest = System.currentTimeMillis() - _maxAge;
    final Enumeration keys = _data.keys();
    while (keys.hasMoreElements()) {
      final Object key = keys.nextElement();
      if (((TimeStamp)_data.get(key)).expired(oldest)) {
	System.out.println("removing " + key.toString() + " from cache");
	_data.remove(key);
      }
    }
  }

  public synchronized void clear() {
    _data.clear();
  }

  public synchronized void put(Object key, Object value) {
    _data.put(key, new TimeStamp(value));
  }

  public synchronized Object get(Object key) {
    Object timeStamp = _data.get(key);
    return timeStamp != null ? ((TimeStamp)timeStamp).access() : null;
  }
}

