/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sbaitems.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:54:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBAITEMS_HXX
#define _SBAITEMS_HXX

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif

#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _SBA_DBOBJENU_HXX
#include <bf_offmgr/dbobjenu.hxx>
#endif
namespace binfilter {

//==================================================================

class SbaSelectionList: public List , public SvRefBase
{
public:
	SbaSelectionList():
	List(CONTAINER_MAXBLOCKSIZE,100,100){}
};

SV_DECL_IMPL_REF(SbaSelectionList)

DBG_NAMEEX(SbaSelectionItem)//STRIP008
class SbaSelectionItem: public SfxPoolItem
{
private:
	SbaSelectionListRef pSelectionList;

public:
	SbaSelectionItem( USHORT nWhich );
	SbaSelectionItem( USHORT nWhich, const SbaSelectionListRef pNewSelectionList );
	~SbaSelectionItem() { DBG_DTOR(SbaSelectionItem,NULL); }
	virtual int 	operator==( const SfxPoolItem& ) const;
	virtual String	GetValueText() const;
	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
	SbaSelectionListRef	GetSelectionList() const { return pSelectionList; }
	virtual USHORT	GetVersion(USHORT) const;
};

//==================================================================
// SbaNameItem
// nicht streamable!!!, operator == abhaengig von bCase
//==================================================================
DBG_NAMEEX(SbaNameItem)//STRIP008
class SbaNameItem: public SfxStringItem
{
	BOOL bCase;	// Compare oder ICompare verwenden

public:
	TYPEINFO();
	SbaNameItem():bCase(FALSE){DBG_CTOR(SbaNameItem,NULL);};
	SbaNameItem(USHORT nWhich, const String& rVal, BOOL _bCase)
		:SfxStringItem(nWhich, rVal)
		,bCase(_bCase){DBG_CTOR(SbaNameItem,NULL);}
	~SbaNameItem(){ DBG_DTOR(SbaNameItem,NULL); };
	virtual int 			 operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const;
};

//==================================================================
// SbaDataFieldTypeItem
// Enum fuer Datentypen einer Datenbank
//==================================================================
DBG_NAMEEX(SbaDataFieldTypeItem)//STRIP008
class SbaDataFieldTypeItem: public SfxEnumItem
{
public:
	TYPEINFO();

	SbaDataFieldTypeItem(USHORT nWhich, SbaFieldType nValue = dbText):
					  SfxEnumItem( nWhich, (USHORT)nValue ){DBG_CTOR(SbaDataFieldTypeItem,NULL);}
	SbaDataFieldTypeItem(USHORT nWhich, SvStream& rStream ):
					  SfxEnumItem( nWhich, rStream ){DBG_CTOR(SbaDataFieldTypeItem,NULL);}
	~SbaDataFieldTypeItem(){ DBG_DTOR(SbaDataFieldTypeItem,NULL); }

	virtual USHORT			GetValueCount() const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
	virtual String			GetValueTextByPos( USHORT nPos ) const;
	virtual String			GetValueText() const;
	virtual USHORT			GetValueByPos( USHORT nPos ) const;
	virtual int 			operator==( const SfxPoolItem& rItem ) const;
	virtual USHORT			GetVersion(USHORT) const;
	virtual SfxPoolItem*	Create( SvStream &, USHORT nVer ) const;

	SbaFieldType			GetType() const {return	(SbaFieldType)GetValue();}
};

/*--------------------------------------------------------------------------
/ Item zum Speichern von Spaltenbreiten und Zeilenhhen fr Tabellen und
/ Abfragen
/--------------------------------------------------------------------------*/
class SbaColRowSizeItem : public SfxPoolItem
{
	UINT16	nCompVal;	// Abwrtskompatibler Wert (Angabe in Pixel)
	UINT16  nVal;		// Wert in zehntel Millimeter
	UINT16  nVersion;

public:
	TYPEINFO();
	SbaColRowSizeItem( USHORT nWhich, UINT16 nCompValue, UINT16 nValue);
	SbaColRowSizeItem( USHORT nWhich, UINT16 nValue = 0);
	SbaColRowSizeItem( const SbaColRowSizeItem&);
	~SbaColRowSizeItem();

	virtual int				 operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	 Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	 Create(SvStream &, USHORT nVersion) const;
	virtual SvStream&		 Store(SvStream &, USHORT nItemVersion) const;

	virtual USHORT			 GetVersion(USHORT) const;
	UINT16					 GetLogicValue() const {return nVal;}
	UINT16					 GetPixelValue() const {return nCompVal;}

	void					 PutPixelValue(UINT16 nNewVal);
	void					 PutLogicValue(UINT16 nNewVal);
};

//========================================================================
DBG_NAMEEX(SbaDBDatabaseItem)//STRIP008
typedef sal_Int32 SbaDatabase;
class SbaDBDatabaseItem : public SfxPoolItem
{
	SbaDatabase*	xDatabase;

public:
	TYPEINFO();

	SbaDBDatabaseItem( USHORT nWhich ) :
		SfxPoolItem( nWhich )
	{ DBG_CTOR(SbaDBDatabaseItem,NULL); }
	SbaDBDatabaseItem( USHORT nWhich, SbaDatabase* pDatabase = NULL ) :
		 SfxPoolItem( nWhich )
		,xDatabase( pDatabase )
	{ DBG_CTOR(SbaDBDatabaseItem,NULL); }
	~SbaDBDatabaseItem(){ DBG_DTOR(SbaDBDatabaseItem,NULL); }
	SbaDatabase* GetDatabase() const { return xDatabase; }
	virtual int operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
};

//========================================================================
DBG_NAMEEX(SbaPointerItem)//STRIP008 
class SbaPointerItem : public SfxPoolItem
{
	void*	m_pPtr;
public:
	TYPEINFO();
	virtual int				operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
							SbaPointerItem( USHORT nWhich, void* pPtr = NULL );
							SbaPointerItem( const SbaPointerItem& rSource );
	void*					GetValue() const { return m_pPtr; }
};
} //namespace binfilter
#endif

