/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wizpage.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:28:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _WIZPAGE_HXX
#define _WIZPAGE_HXX


#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SV_FONT_HXX //autogen
#include <vcl/font.hxx>
#endif

#ifndef _WIZENUM_HXX
#include <wizenum.hxx>
#endif
class Window; 
class OutputDevice; 
namespace binfilter {



////////////////////////////////////////////////////////////////////////////////
// WizardPage
////////////////////////////////////////////////////////////////////////////////

class WizardPage
{
public:
	long SizeX; // alle Masse in mm
	long SizeY;
	long RandL;
	long RandR;
	long RandO;
	long RandU;
	long MapMul;
	long MapDiv;
public:
	WizardPage();
	~WizardPage();
	virtual void Draw(OutputDevice& rOut);
	void DrawBaseText(OutputDevice& rOut, USHORT nWortAnz=70);
	void SetRandO(USHORT nRand, Window* pWin=NULL);
	void SetRandU(USHORT nRand, Window* pWin=NULL);
	void SetRandL(USHORT nRand, Window* pWin=NULL);
	void SetRandR(USHORT nRand, Window* pWin=NULL);
	void SetWdt(USHORT nWdt, Window* pWin=NULL);
	void SetHgt(USHORT nHgt, Window* pWin=NULL);
	USHORT GetWdt() const { return USHORT(SizeX); }
	USHORT GetHgt() const { return USHORT(SizeY); }
	void SetDinA4(Window* pWin=NULL)  { SetWdt(210*EINHEIT,pWin); SetHgt(297*EINHEIT,pWin); }
	void SetDinA5Q(Window* pWin=NULL) { SetWdt(210*EINHEIT,pWin); SetHgt(297*EINHEIT/2,pWin); }
	BOOL IsDinA4()  const { return SizeX==210*EINHEIT && SizeY==297*EINHEIT; }
	BOOL IsDinA5Q() const { return SizeX==210*EINHEIT && SizeY==297*EINHEIT /2; }

	long GetRandL() const {return RandL;}
	long GetRandR() const {return RandR;}
};

////////////////////////////////////////////////////////////////////////////////
// WizardFrame
////////////////////////////////////////////////////////////////////////////////

class WizardIni;

class WizardFrame
{
friend WizardIni;
	BOOL b2ndHide;
	BOOL bIsDa;
protected:
	WizardPage* pPage;
	long PosX0;
	long PosY0;
	long SizX0;
	long SizY0;
	BOOL bGemerkt;
	long PosX;
	long PosY;
	long SizX;
	long SizY;
	long RandL;
	long RandR;
	long RandO;
	long RandU;
	BOOL bFill;
	BOOL bFram;
	BOOL bText;
	PageAlign eAlign;
public:
	WizardFrame();
	virtual void Draw(OutputDevice& rOut);
	void SetPage(WizardPage* pPg);
	void DrawFrame(OutputDevice& rOut, BOOL bFillIt);
	void Show(Window* pWin=NULL, BOOL bOn=TRUE);
	void Hide(Window* pWin=NULL);
	BOOL IsVisible() { return(bIsDa && !b2ndHide); }
	void SetSiz(USHORT nWdt, USHORT nHgt, Window* pWin=NULL);
	virtual void SetWdt(USHORT nWdt, Window* pWin=NULL);
	virtual void SetHgt(USHORT nHgt, Window* pWin=NULL);
	void SetPosX(long nPosX, Window* pWin=NULL);
	void SetPosY(long nPosY, Window* pWin=NULL);
	void SetAlign(PageAlign eNeuAlign, Window* pWin=NULL);
	void SetHor(USHORT nRand, Window* pWin=NULL); // Abhaengig vom Align
	void SetVer(USHORT nRand, Window* pWin=NULL); // Abhaengig vom Align
	void KorregPos(Window* pWin=NULL);
	void SetRandL(USHORT nRand, Window* pWin=NULL);
	void SetRandR(USHORT nRand, Window* pWin=NULL);
	void SetRandO(USHORT nRand) { RandO = nRand;}
	void SetRandU(USHORT nRand) { RandU = nRand;}

	USHORT GetHor();
	USHORT GetVer();
	virtual USHORT GetWdt();
	virtual USHORT GetHgt();
	long GetPosX() { return PosX; }
	long GetPosY() { return PosY; }
	PageAlign GetAlign() { return eAlign; }
	BOOL IsLks();
	BOOL IsRts();
	BOOL IsObn();
	BOOL IsUnt();
	USHORT GetRandL()const  { return (USHORT)RandL;}
	USHORT GetRandR()const  { return (USHORT)RandR;}
	USHORT GetRandO()const  { return (USHORT)RandO;}
	USHORT GetRandU()const  { return (USHORT)RandU;}

	BOOL GetVerStr(String& rStr);
	BOOL GetHorStr(String& rStr);
	void Set2ndHide(BOOL bHide=TRUE, Window* pWin=NULL);
	BOOL Is2ndHide() { return b2ndHide; }
	BOOL Is1stHide() { return !bIsDa; }
	virtual void Invalidate(Window* pWin); // Redraw
private:
	void MerkePos();
	void CheckInvalidate(Window* pWin); // Redraw inkl. MerkPos
};

////////////////////////////////////////////////////////////////////////////////
// WizardText
////////////////////////////////////////////////////////////////////////////////

#define TEXT_FitSiz 0x0001 /* Fit2Size (f. Logo) */
#define TEXT_FrDscr 0x0002 /* Rahmenbeschreibungen: Center + bis max 12mm */
#define TEXT_JstRgt 0x0004 /* Rechtsbuendig */
#define TEXT_JstCnt 0x0008 /* Zentriert     */

class WizardText: public WizardFrame
{
	String aStr;
	String aDefStr;  // String fuer den Fall das aStr==""
	//BOOL   bFitS : 1;    // Fit2Size ?
	//BOOL   bRgt : 1;     // Rechtsduendig ?
	BOOL   bStrVisi : 1;
	BOOL   bStrGrow : 1;
	long   nFramHgt;  // FrameHoehe wenn nicht bGrow
	USHORT nLineFeed; // benoetigt fuer Grow
	USHORT nLnDazu;   // Soviele Zeilen dazuzaehlen
	USHORT nStyle;
protected:
	Font   aFont;
public:
	WizardText();
	~WizardText();
	virtual void Draw(OutputDevice& rOut);
	void DrawText(OutputDevice& rOut, const String& rStr, short x, short y, short w, short h, USHORT Style=0);
	USHORT GetTextHgt(const Font& rFont, const String& rStr, short w, short h, USHORT Style);
	void SetDefStr(const String& rStr, Window* pWin=NULL) { aDefStr=rStr; }
	const String& GetDefStr() { return aDefStr; }
	void SetFit(BOOL bFit) { nStyle |= TEXT_FitSiz; }
	void SetRgt(BOOL bR) { nStyle |= TEXT_JstRgt; }
	void SetStr(const String& rStr, Window* pWin=NULL);
	const String& GetStr() { return aStr; }
	void SetFont( const Font& rFnt ) { aFont=rFnt; }
	void GetFont(Font& rFnt) { rFnt=aFont; }
	void SetStyle(USHORT nStl, Window* pWin=NULL);
	void SetStrVisi(BOOL bVisi=TRUE, Window* pWin=NULL);
	void SetGrowOnStr(BOOL bGrow=TRUE, Window* pWin=NULL);
	void KorregGrowHgt(Window* pWin=NULL);
	void SetLnDazu(USHORT nNum, Window* pWin=NULL);
	virtual void SetHgt(USHORT nHgt, Window* pWin=NULL);  // Ueberladen von WizardFrame
	virtual USHORT GetHgt();                      // Ueberladen von WizardFrame
};

////////////////////////////////////////////////////////////////////////////////
// WizardAbsn
////////////////////////////////////////////////////////////////////////////////

class WizardAbsn: public WizardText
{
public:
	WizardAbsn();
};

////////////////////////////////////////////////////////////////////////////////
// WizardLogo
////////////////////////////////////////////////////////////////////////////////

class WizardLogo: public WizardText
{
	BOOL bTextLogo : 1;
	BOOL bGrfFlag : 1;    // wurde eine Grafik zugewiesen ?
	BOOL bMemoTitl : 1;
	BOOL bAgenGraf : 1;
    BOOL bAsLink : 1;
	String aGrfFNam;
	String aGrfFilt;
public:
	WizardLogo();
	virtual void Draw(OutputDevice& rOut);
	void SetModeGraf(Window* pWin=NULL, BOOL bJa=TRUE);
	void SetModeText(Window* pWin=NULL, BOOL bJa=TRUE);
	BOOL IsTextLogo() { return bTextLogo; }
	BOOL IsGrafLogo() { return !bTextLogo; }
    void SetGraphic(const String& rFNam, const String& rFilt, BOOL bAsLink);
    BOOL GetGraphic( String& rFNam, String& rFilt, BOOL& rAsLink )
                    { rFNam=aGrfFNam; rFilt=aGrfFilt; rAsLink = bAsLink; return bGrfFlag; }
	BOOL HasGraphic() { return bGrfFlag; }
	USHORT GetLogoTextHgt();
	void   SetMemoTitel() { bMemoTitl=TRUE; }
	void   SetAgenGraf()  { bAgenGraf=TRUE; }
};

////////////////////////////////////////////////////////////////////////////////
// WizardEmpf
////////////////////////////////////////////////////////////////////////////////

class WizardEmpf: public WizardText
{
	BOOL bShowAbsn;
	String aAbsnStr;
	String aAbsnDefStr;
public:
	WizardEmpf();
	virtual void Draw(OutputDevice& rOut);
	BOOL IsAbsnShown() { return bShowAbsn; }
	void ShowAbsn(Window* pWin=NULL,BOOL bOn=TRUE);
	void SetAbsnStr(String& rStr, Window* pWin=NULL);
	String& GetAbsnStr() { return aAbsnStr; }
	virtual void Invalidate(Window* pWin); // Redraw
};

////////////////////////////////////////////////////////////////////////////////
// WizardElem
////////////////////////////////////////////////////////////////////////////////

class WizardElem
{
	WizardPage* pPage;
	WizardFrame aDerText[5];
public:
	WizardText  aBezeich[5]; // Lesen und Schreiben von Text (GetStr/SetStr) ist oeffentlich erlaubt.
public:
	WizardElem();
	void SetPage(WizardPage* pPg);
	void Draw(OutputDevice& rOut);
	void Korreg(Window* pWin=NULL);
	void Show(USHORT Num, Window* pWin=NULL, BOOL bOn=TRUE);
	void Hide(USHORT Num, Window* pWin=NULL);
	BOOL IsVisible(USHORT Num);
	BOOL IsAnyVisible();
	BOOL NurDatum();
	void SetPosY(USHORT nPosY, Window* pWin=NULL);
	long GetPosX();
	long GetPosY() { return aBezeich[0].GetPosY(); }
	USHORT GetWdt();
	USHORT GetHgt();
	void Set2ndHide(BOOL bHide=TRUE, Window* pWin=NULL);
};

////////////////////////////////////////////////////////////////////////////////
// WizardBetr
////////////////////////////////////////////////////////////////////////////////

class WizardBetr: public WizardText
{
public:
	WizardBetr();
	void SetPage(WizardPage* pPg);
	void KorregWdt(Window* pWin=NULL);
};

////////////////////////////////////////////////////////////////////////////////
// WizardFusz
////////////////////////////////////////////////////////////////////////////////

class WizardFusz : public WizardText
{
protected:
	long   TextDst;
	WizardText aTrenn;
	BOOL   bTrenn : 1;
	BOOL   bPgNum : 1;
	BOOL   bPgNumGes : 1;
	String aPgNum;
	String aPgNumGes;
	USHORT nPgNumFmt;
public:
	WizardFusz();
	~WizardFusz();

	virtual void Draw(OutputDevice& rOut);
	void SetHgt(USHORT nHgt, Window* pWin=NULL);
	void SetPage(WizardPage* pPg);
	void SetTextDst(USHORT nDst, Window* pWin=NULL);
	void SetTrennlinie(BOOL bTrn, Window* pWin=NULL);
	void KorregPgRand(Window* pWin=NULL);
	void KorregWdt(Window* pWin=NULL);
	BOOL IsTrennlinie() { return bTrenn; }

	USHORT GetTextDst() { return USHORT(TextDst); }
	virtual void Invalidate(Window* pWin); // Redraw

	void SetPgNum(BOOL bPgNumOn, Window* pWin=NULL);
	BOOL IsPgNum() { return bPgNum; }

	void   SetPgNumStr(const String& rStr )		{ aPgNum=rStr; }
	const String& GetPgNumStr()					{ return aPgNum; }

	void   SetPgNumFmt(USHORT nFormat ) 		{ nPgNumFmt=nFormat; }
	USHORT GetPgNumFmt() 						{ return nPgNumFmt; }

	void   SetPgNumGes( BOOL bGes ) 			{ bPgNumGes = bGes; }
	BOOL   IsPgNumGes() 						{ return bPgNumGes; }

	void   SetPgNumGesStr(const String& rStr )	{ aPgNumGes = rStr; }
	const String& GetPgNumGesStr() 				{ return aPgNumGes; }
};


////////////////////////////////////////////////////////////////////////////////
// WizardKopz
////////////////////////////////////////////////////////////////////////////////

class WizardKopz
{
	long TextDst;
	WizardPage* pPage;
public:
	WizardLogo aLogo;  // Text lesen/schreiben sowie Grafik
	WizardAbsn aAbsn;  // rein/raus ist oeffentlich erlaubt
public:
	WizardKopz();
	virtual void Draw(OutputDevice& rOut);
	void SetPage(WizardPage* pPg);
	void KorregPgRand(Window* pWin=NULL);
	void KorregWdt(Window* pWin=NULL);
	void SetTextDst(USHORT nDst, Window* pWin=NULL);
	void SetVer(USHORT nRand, Window* pWin=NULL);
	USHORT GetVer() { return aLogo.GetVer(); }
	USHORT GetTextDst() { return USHORT(TextDst); }
	void SetLogoAlign(PageAlign eNeuAlign, Window* pWin=NULL) { aLogo.SetAlign(eNeuAlign,pWin); }
	void SetAbsnAlign(PageAlign eNeuAlign, Window* pWin=NULL) { aAbsn.SetAlign(eNeuAlign,pWin); }
	PageAlign GetLogoAlign() { return aLogo.GetAlign(); }
	PageAlign GetAbsnAlign() { return aAbsn.GetAlign(); }
	void ShowLogo(Window* pWin=NULL, BOOL bOn=TRUE);
	void ShowAbsn(Window* pWin=NULL, BOOL bOn=TRUE);
	BOOL LogoIsVisible() { return aLogo.IsVisible(); }
	BOOL AbsnIsVisible() { return aAbsn.IsVisible(); }
	BOOL IsVisible() { return LogoIsVisible() || AbsnIsVisible(); }
	void SetLogoWdt(USHORT nWdt, Window* pWin=NULL) { aLogo.SetWdt(nWdt,pWin); }
	void SetAbsnWdt(USHORT nWdt, Window* pWin=NULL) { aAbsn.SetWdt(nWdt,pWin); }
	void SetLogoHgt(USHORT nHgt, Window* pWin=NULL);
	void SetAbsnHgt(USHORT nHgt, Window* pWin=NULL);
	USHORT GetLogoHgt() { return aLogo.GetHgt(); }
	USHORT GetLogoWdt() { return aLogo.GetWdt(); }
	USHORT GetAbsnHgt() { return aAbsn.GetHgt(); }
	USHORT GetAbsnWdt() { return aAbsn.GetWdt(); }
	USHORT GetHgt();
//    virtual void Invalidate(Window* pWin); // Redraw
};

////////////////////////////////////////////////////////////////////////////////
// WizardLettPage1
////////////////////////////////////////////////////////////////////////////////

class WizardLettPage1: public WizardPage
{
public:
	WizardLogo aLogo;
	WizardAbsn aAbsn;
	WizardEmpf aEmpf;
	WizardElem aElem;
	WizardBetr aBetr;
	WizardFusz aFusz;
public:
	WizardLettPage1();
	~WizardLettPage1();
	virtual void Draw(OutputDevice& rOut);
};

////////////////////////////////////////////////////////////////////////////////
// WizardLettPageF
////////////////////////////////////////////////////////////////////////////////

class WizardLettPageF: public WizardPage
{
public:
	WizardKopz aKopz;
	WizardFusz aFusz;
public:
	WizardLettPageF();
	virtual void Draw(OutputDevice& rOut);
};

////////////////////////////////////////////////////////////////////////////////
// WizardFaxnPage
////////////////////////////////////////////////////////////////////////////////

class WizardFaxnPage: public WizardPage
{
public:
	WizardLogo aLogo;
	WizardLogo aTitl;
	WizardText aDatm;
	WizardText aEmpf;
	WizardAbsn aAbsn;
	WizardBetr aBetr;
	WizardElem aElem;
	WizardFusz aFusz;
public:
	WizardFaxnPage();
	virtual void Draw(OutputDevice& rOut);
};

////////////////////////////////////////////////////////////////////////////////
// WizardMemoPage
////////////////////////////////////////////////////////////////////////////////

class WizardMemoPage: public WizardPage
{
public:
	WizardLogo aTitl;
	WizardText aEleZ; // Elemente Zeilenweise
	WizardElem aEleT; // Elemente in Tabelle
	WizardFusz aFusz;
public:
	WizardMemoPage();
	virtual void Draw(OutputDevice& rOut);
};

////////////////////////////////////////////////////////////////////////////////
// WizardAgenPage
////////////////////////////////////////////////////////////////////////////////

class WizardAgenPage: public WizardPage
{
public:
	WizardLogo aLogo;
	WizardLogo aTitl;
	WizardText aDatm; // Datum, Uhrzeit, Ort
	WizardText aElem; // Elemente Zeilenweise
public:
	WizardAgenPage();
	virtual void Draw(OutputDevice& rOut);
};

} //namespace binfilter
#endif  //_WIZPAGE_HXX


