/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_view1.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:49:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDVIEW_HXX //autogen
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #endif
#ifndef _SVX_RULER_HXX //autogen
#include <bf_svx/ruler.hxx>
#endif
#ifndef _IDXMRK_HXX
#include <idxmrk.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif
#ifndef _GLOBDOC_HXX
#include <globdoc.hxx>
#endif
// auto strip #ifndef _NAVIPI_HXX
// auto strip #include <navipi.hxx>
// auto strip #endif
#ifndef _FLDWRAP_HXX
#include <fldwrap.hxx>
#endif
#ifndef _REDLNDLG_HXX
#include <redlndlg.hxx>
#endif
// auto strip #ifndef _DPAGE_HXX
// auto strip #include <dpage.hxx>
// auto strip #endif
// auto strip #ifndef _EDTWIN_HXX
// auto strip #include <edtwin.hxx>
// auto strip #endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
namespace binfilter {

extern int bDocSzUpdated;


/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


/*N*/ void SwView::Activate(BOOL bMDIActivate)
/*N*/ {
/*N*/ 	// aktuelle View anmelden an der DocShell
/*N*/ 	// die View bleibt solange an der DocShell
/*N*/ 	// aktiv bis Sie zerstoert wird oder durch Activate eine
/*N*/ 	// neue gesetzt wird
/*N*/ 	SwDocShell* pDocSh = GetDocShell();
/*N*/ 	if(pDocSh)
/*N*/ 		pDocSh->SetView(this);
/*N*/ 	SwModule* pSwMod = SW_MOD();
/*N*/ 	pSwMod->SetView(this);
/*N*/ 
/*N*/ 	// Dokumentgroesse hat sich geaendert
/*N*/ 	if(!bDocSzUpdated)
/*N*/ 		DocSzChgd(aDocSz);
/*N*/ 
/*N*/     pHRuler->SetActive( TRUE );
/*N*/     pVRuler->SetActive( TRUE );
/*N*/ 
/*N*/ 	if ( bMDIActivate )
/*N*/ 	{
/*N*/ 		pWrtShell->ShGetFcs(FALSE);		// Selektionen sichtbar
/*N*/ 
/*N*/ 		if( sSwViewData.Len() )
/*N*/ 		{
/*?*/ 			ReadUserData( sSwViewData, FALSE );
/*?*/ 			sSwViewData.Erase();
/*N*/ 		}
/*N*/ 
/*N*/ 		AttrChangedNotify(pWrtShell);
/*N*/ 
/*N*/ 		// Flddlg ggf neu initialisieren (z.B. fuer TYP_SETVAR)
/*N*/ 		USHORT nId = SwFldDlgWrapper::GetChildWindowId();
/*N*/ 		SfxViewFrame* pVFrame = GetViewFrame();
/*N*/ 		SwFldDlgWrapper *pWrp = (SwFldDlgWrapper*)pVFrame->GetChildWindow(nId);
/*N*/ 		if (pWrp)
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pWrp->ReInitDlg(GetDocShell());
/*N*/ 
/*N*/ 		// RedlineDlg ggf neu initialisieren
/*N*/ 		nId = SwRedlineAcceptChild::GetChildWindowId();
/*N*/ 		SwRedlineAcceptChild *pRed = (SwRedlineAcceptChild*)pVFrame->GetChildWindow(nId);
/*N*/ 		if (pRed)
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pRed->ReInitDlg(GetDocShell());
/*N*/ 
/*N*/ 		// reinit IdxMarkDlg
/*N*/ 		nId = SwInsertIdxMarkWrapper::GetChildWindowId();
/*N*/ 		SwInsertIdxMarkWrapper *pIdxMrk = (SwInsertIdxMarkWrapper*)pVFrame->GetChildWindow(nId);
/*N*/ 		if (pIdxMrk)
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pIdxMrk->ReInitDlg(*pWrtShell);
/*N*/ 
/*N*/ 		// reinit AuthMarkDlg
/*N*/ 		nId = SwInsertAuthMarkWrapper::GetChildWindowId();
/*N*/ 		SwInsertAuthMarkWrapper *pAuthMrk = (SwInsertAuthMarkWrapper*)pVFrame->
/*N*/ 																GetChildWindow(nId);
/*N*/ 		if (pAuthMrk)
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pAuthMrk->ReInitDlg(*pWrtShell);
/*N*/ 	}
/*N*/ 	else
/*N*/ 		//Wenigstens das Notify rufen (vorsichtshalber wegen der SlotFilter
/*?*/ 		AttrChangedNotify(pWrtShell);
/*N*/ 
/*N*/ 	SfxViewShell::Activate(bMDIActivate);
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 void SwView::Deactivate(BOOL bMDIActivate)
//STRIP001 {
//STRIP001 	extern BOOL bFlushCharBuffer ;
//STRIP001 		// Befinden sich noch Zeichen im Input Buffer?
//STRIP001 	if( bFlushCharBuffer )
//STRIP001 		GetEditWin().FlushInBuffer( pWrtShell );
//STRIP001 
//STRIP001 	if( bMDIActivate )
//STRIP001 	{
//STRIP001 		pWrtShell->ShLooseFcs();	// Selektionen unsichtbar
//STRIP001 
//STRIP001         pHRuler->SetActive( FALSE );
//STRIP001         pVRuler->SetActive( FALSE );
//STRIP001 	}
//STRIP001 	SfxViewShell::Deactivate(bMDIActivate);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void SwView::MarginChanged()
//STRIP001 {
//STRIP001 	GetWrtShell().SetBrowseBorder( GetMargin() );
//STRIP001 }




}
