/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_view.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:48:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#include <stdlib.h>
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif
// auto strip #ifndef _SV_GRAPH_HXX //autogen
// auto strip #include <vcl/graph.hxx>
// auto strip #endif
// auto strip #ifndef _VCL_INPUTCTX_HXX //autogen
// auto strip #include <vcl/inputctx.hxx>
// auto strip #endif
// auto strip #ifndef _SBX_SBXOBJECT_HXX //autogen
// auto strip #include <svtools/sbxobj.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef INCLUDED_SVTOOLS_UNDOOPT_HXX
#include <svtools/undoopt.hxx>
#endif
#ifndef _SVTOOLS_LINGUCFG_HXX_
#include <svtools/lingucfg.hxx>
#endif
// auto strip #ifndef _SV_PRINTDLG_HXX_
// auto strip #include <svtools/printdlg.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
// auto strip #ifndef _SFX_PRINTER_HXX
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif
#ifndef _SVX_RULER_HXX //autogen
#include <bf_svx/ruler.hxx>
#endif
// auto strip #ifndef _SVX_PROTITEM_HXX //autogen
// auto strip #include <bf_svx/protitem.hxx>
// auto strip #endif
#ifndef _SBASLTID_HRC //autogen
#include <bf_offmgr/sbasltid.hrc>
#endif
// auto strip #ifndef _OFF_APP_HXX //autogen
// auto strip #include <bf_offmgr/app.hxx>
// auto strip #endif
// auto strip #ifndef _OFA_OSPLCFG_HXX
// auto strip #include <bf_offmgr/osplcfg.hxx>
// auto strip #endif
#ifndef _SVX_FMSHELL_HXX //autogen
#include <bf_svx/fmshell.hxx>
#endif

#ifndef _UNOTXVW_HXX
#include <unotxvw.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _SWHINTS_HXX
#include <swhints.hxx>
#endif

#ifndef _SWMODULE_HXX //autogen
#include <swmodule.hxx>
#endif
#ifndef SW_INPUTWIN_HXX //autogen
#include <inputwin.hxx>
#endif
#ifndef _CHARTINS_HXX //autogen
#include <chartins.hxx>
#endif
#ifndef _UIVWIMP_HXX
#include <uivwimp.hxx>
#endif
// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>
// auto strip #endif
// auto strip #ifndef _UITOOL_HXX
// auto strip #include <uitool.hxx>
// auto strip #endif
#ifndef _EDTWIN_HXX
#include <edtwin.hxx>
#endif
#ifndef _TEXTSH_HXX
#include <textsh.hxx>
#endif
#ifndef _LISTSH_HXX
#include <listsh.hxx>
#endif
#ifndef _TABSH_HXX
#include <tabsh.hxx>
#endif
#ifndef _GRFSH_HXX
#include <grfsh.hxx>
#endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif
// auto strip #ifndef _FRMSH_HXX
// auto strip #include <frmsh.hxx>
// auto strip #endif
// auto strip #ifndef _OLESH_HXX
// auto strip #include <olesh.hxx>
// auto strip #endif
#ifndef _DRAWSH_HXX
#include <drawsh.hxx>
#endif
// auto strip #ifndef _DRAWBASE_HXX
// auto strip #include <drawbase.hxx>
// auto strip #endif
#ifndef _DRFORMSH_HXX
#include <drformsh.hxx>
#endif
#ifndef _DRWTXTSH_HXX
#include <drwtxtsh.hxx>
#endif
// auto strip #ifndef _BEZIERSH_HXX
// auto strip #include <beziersh.hxx>
// auto strip #endif
// auto strip #ifndef _GLOBDOC_HXX
// auto strip #include <globdoc.hxx>
// auto strip #endif
#ifndef _SCROLL_HXX
#include <scroll.hxx>
#endif
#ifndef _GLOBDOC_HXX
#include <globdoc.hxx>
#endif
// auto strip #ifndef _NAVIPI_HXX
// auto strip #include <navipi.hxx>
// auto strip #endif
// auto strip #ifndef _GLOSHDL_HXX
// auto strip #include <gloshdl.hxx>
// auto strip #endif
#ifndef _USRPREF_HXX
#include <usrpref.hxx>
#endif
#ifndef _SRCVIEW_HXX
#include <srcview.hxx>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
#ifndef _WDOCSH_HXX
#include <wdocsh.hxx>
#endif
// auto strip #ifndef _WVIEW_HXX
// auto strip #include <wview.hxx>
// auto strip #endif
#ifndef _WORKCTRL_HXX
#include <workctrl.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _BARCFG_HXX
#include <barcfg.hxx>
#endif
#ifndef _DOC_HXX //autogen
#include <doc.hxx>
#endif
#ifndef _PVIEW_HXX
#include <pview.hxx>
#endif
#ifndef _SWDTFLVR_HXX
#include <swdtflvr.hxx>
#endif
#ifndef _VIEW_HRC
#include <view.hrc>
#endif
#ifndef _GLOBDOC_HRC
#include <globdoc.hrc>
#endif
#ifndef _FRMUI_HRC
#include <frmui.hrc>
#endif
// auto strip #ifndef _CFGITEMS_HXX
// auto strip #include <cfgitems.hxx>
// auto strip #endif
// auto strip #ifndef _SW_PRINTDATA_HXX
// auto strip #include <printdata.hxx>
// auto strip #endif
// auto strip #ifndef _PRTOPT_HXX
// auto strip #include <prtopt.hxx>
// auto strip #endif
// auto strip #ifndef _SWPRTOPT_HXX
// auto strip #include <swprtopt.hxx>
// auto strip #endif

// auto strip #ifndef _LINGUISTIC_LNGPROPS_HHX_
// auto strip #include <bf_linguistic/lngprops.hxx>
// auto strip #endif
// auto strip #ifndef _UNO_LINGU_HXX
// auto strip #include <bf_svx/unolingu.hxx>
// auto strip #endif

#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_SCANNER_SCANNERCONTEXT_HPP_
// auto strip #include <com/sun/star/scanner/ScannerContext.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SCANNER_XSCANNERMANAGER_HPP_
// auto strip #include <com/sun/star/scanner/XScannerManager.hpp>
// auto strip #endif
// auto strip #ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
// auto strip #include <toolkit/unohlp.hxx>
// auto strip #endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _XMLOFF_XMLUCONV_HXX
#include <bf_xmloff/xmluconv.hxx>
#endif

// #107253#
#ifndef _SWLINGUCONFIG_HXX
#include <swlinguconfig.hxx>
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::scanner;
using namespace ::rtl;

#define C2U(cChar) OUString::createFromAscii(cChar)
#define C2S(cChar) String::CreateFromAscii(cChar)

extern sal_Bool bNoInterrupt;		// in mainwn.cxx

#define SWVIEWFLAGS ( SFX_VIEW_MAXIMIZE_FIRST|			\
					  SFX_VIEW_OBJECTSIZE_EMBEDDED| 	\
					  SFX_VIEW_CAN_PRINT| 				\
					  SFX_VIEW_HAS_PRINTOPTIONS)

//MA 06. Nov. 95: Each raus in Absprache mit MI wg. Bug 21523
//					  SFX_VIEW_OPTIMIZE_EACH|

/*--------------------------------------------------------------------
	Beschreibung:	Statics
 --------------------------------------------------------------------*/

int bDocSzUpdated = 1;

SvxSearchItem*	SwView::pSrchItem 	= 0;

sal_uInt16 			SwView::nInsertCtrlState 		= FN_INSERT_TABLE;
sal_uInt16 			SwView::nWebInsertCtrlState     = FN_INSERT_TABLE;
sal_uInt16 			SwView::nInsertObjectCtrlState 	= SID_INSERT_DIAGRAM;

sal_Bool			SwView::bExtra		= sal_False;
sal_Bool			SwView::bFound		= sal_False;
sal_Bool			SwView::bJustOpened	= sal_False;


SvxSearchDialog*	SwView::pSrchDlg	= 0;
SearchAttrItemList* SwView::pSrchList	= 0;
SearchAttrItemList* SwView::pReplList	= 0;

/*N*/ DBG_NAME(viewhdl)

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ inline SfxDispatcher &SwView::GetDispatcher()
/*N*/ {
/*N*/ 	return *GetViewFrame()->GetDispatcher();
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ void SwView::ImpSetVerb( int nSelType )
/*N*/ {
/*N*/ 	sal_Bool bResetVerbs = bVerbsActive;
/*N*/ 	if ( !GetDocShell()->GetProtocol().IsInPlaceActive() &&
/*N*/ 		 (SwWrtShell::SEL_OLE|SwWrtShell::SEL_GRF) & nSelType )
/*N*/ 	{
/*?*/ 		if ( !pWrtShell->IsSelObjProtected(FLYPROTECT_CONTENT) )
/*?*/ 		{
/*?*/ 			if ( nSelType & SwWrtShell::SEL_OLE )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SvInPlaceObjectRef xRef = GetWrtShell().GetOLEObj();
//STRIP001 /*?*/ 				SetVerbs( &xRef->GetVerbList() );
//STRIP001 /*?*/ 				bVerbsActive = sal_True;
//STRIP001 /*?*/ 				bResetVerbs = sal_False;
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 	if ( bResetVerbs )
/*N*/ 	{
/*?*/ 		SetVerbs( 0 );
/*?*/ 		bVerbsActive = sal_False;
/*N*/ 	}
/*N*/ }


/*N*/ void SwView::SelectShell()
/*N*/ {
/*N*/ //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
/*N*/ //
/*N*/ //		Achtung: SelectShell fuer die WebView mitpflegen
/*N*/ //
/*N*/ //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
/*N*/ 
/*N*/     if(bInDtor)
/*N*/         return;
/*N*/ 	// Entscheidung, ob UpdateTable gerufen werden muss
/*N*/ 	sal_Bool bUpdateTable = sal_False;
/*N*/ 	const SwFrmFmt* pCurTableFmt = pWrtShell->GetTableFmt();
/*N*/ 	if(pCurTableFmt && pCurTableFmt != pLastTableFormat)
/*N*/ 	{
/*N*/ 		bUpdateTable = sal_True; // kann erst spaeter ausgefuehrt werden
/*N*/ 	}
/*N*/ 	pLastTableFormat = pCurTableFmt;
/*N*/ 
/*N*/ 	//SEL_TBL und SEL_TBL_CELLS koennen verodert sein!
/*N*/ 	int nNewSelectionType = (pWrtShell->GetSelectionType()
/*N*/ 								& ~SwWrtShell::SEL_TBL_CELLS);
/*N*/ 
/*N*/ 	if ( nNewSelectionType == nSelectionType )
/*N*/ 	{
/*N*/ 		GetViewFrame()->GetBindings().InvalidateAll( sal_False );
/*N*/ 		if ( nSelectionType & SwWrtShell::SEL_OLE ||
/*N*/ 			 nSelectionType & SwWrtShell::SEL_GRF )
/*N*/ 			//Fuer Grafiken und OLE kann sich natuerlich das Verb aendern!
/*?*/ 			ImpSetVerb( nNewSelectionType );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 
/*N*/ 		SfxDispatcher &rDispatcher = GetDispatcher();
/*N*/ 		SwToolbarConfigItem *pBarCfg = SW_MOD()->GetToolbarConfig();
/*N*/ 
/*N*/ 	//	DELETEZ(pxSelectionObj); //Selektionsobjekt loeschen
/*N*/ 		if ( pShell )
/*N*/ 		{
/*N*/ 			rDispatcher.Flush();		// alle gecachten Shells wirklich loeschen
/*N*/ 
/*N*/ 			//Zur alten Selektion merken welche Toolbar sichtbar war
/*N*/ 			sal_uInt16 nId = rDispatcher.GetObjectBarId( SFX_OBJECTBAR_OBJECT );
/*N*/ 			if ( nId )
/*N*/ 				pBarCfg->SetTopToolbar( nSelectionType, nId );
/*N*/ 
/*N*/ 			SfxShell *pSfxShell;
/*N*/ 			sal_uInt16 i;
/*N*/ 			for ( i = 0; sal_True; ++i )
/*N*/ 			{
/*N*/ 				pSfxShell = rDispatcher.GetShell( i );
/*N*/ 				if ( !(pSfxShell->ISA( SwBaseShell ) ||
/*N*/ 					pSfxShell->ISA( SwDrawTextShell )) )
/*N*/ 					break;
/*N*/ 			}
/*N*/ 			pSfxShell = rDispatcher.GetShell( --i );
/*N*/ 			ASSERT( pSfxShell, "My Shell ist lost in space" );
/*N*/ 			rDispatcher.Pop( *pSfxShell, SFX_SHELL_POP_UNTIL | SFX_SHELL_POP_DELETE);
/*N*/ 		}
/*N*/ 
/*N*/ 		FASTBOOL bInitFormShell = sal_False;
/*N*/ 		if (!pFormShell)
/*N*/ 		{
/*N*/ 			bInitFormShell = sal_True;
/*N*/ 			pFormShell = new FmFormShell( this );
/*N*/ 			rDispatcher.Push( *pFormShell );
/*N*/ 
/*N*/ 			StartListening(*pFormShell);
/*N*/ 		}
/*N*/ 
/*N*/ 		FASTBOOL bSetExtInpCntxt = sal_False;
/*N*/ 		nSelectionType = nNewSelectionType;
/*N*/ 		ShellModes eShellMode;
/*N*/ 
/*N*/ 		if ( nSelectionType & SwWrtShell::SEL_OLE )
/*N*/ 		{
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			eShellMode = SEL_OBJECT;
//STRIP001 /*?*/ 			pShell = new SwOleShell( *this );
//STRIP001 /*?*/ 			rDispatcher.Push( *pShell );
/*N*/		}
/*N*/ 		else if ( nSelectionType & SwWrtShell::SEL_FRM
/*N*/ 			|| nSelectionType & SwWrtShell::SEL_GRF)
/*N*/ 		{
/*?*/ 			eShellMode = SEL_FRAME;
/*?*/ 			pShell = new SwFrameShell( *this );
/*?*/ 			rDispatcher.Push( *pShell );
/*?*/ 			if(nSelectionType & SwWrtShell::SEL_GRF )
/*?*/ 			{
/*?*/ 				eShellMode = SEL_GRAPHIC;
/*?*/ 				pShell = new SwGrfShell( *this );
/*?*/ 				rDispatcher.Push( *pShell );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else if ( nSelectionType & SwWrtShell::SEL_DRW )
/*N*/ 		{
/*?*/ 			eShellMode = SEL_DRAW;
/*?*/ 			pShell = new SwDrawShell( *this );
/*?*/ 
/*?*/ 			rDispatcher.Push( *pShell );
/*?*/ 			if ( nSelectionType & SwWrtShell::SEL_BEZ )
/*?*/ 			{
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				eShellMode = SEL_BEZIER;
//STRIP001 /*?*/ 				pShell = new SwBezierShell( *this );
//STRIP001 /*?*/ 				rDispatcher.Push( *pShell );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else if ( nSelectionType & SwWrtShell::SEL_DRW_FORM )
/*N*/ 		{
/*?*/ 			eShellMode = SEL_DRAW_FORM;
/*?*/ 			pShell = new SwDrawFormShell( *this );
/*?*/ 
/*?*/ 			rDispatcher.Push( *pShell );
/*N*/ 		}
/*N*/ 		else if ( nSelectionType & SwWrtShell::SEL_DRW_TXT )
/*N*/ 		{
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/             bSetExtInpCntxt = sal_True;
//STRIP001 /*?*/             eShellMode = SEL_DRAWTEXT;
//STRIP001 /*?*/ 			rDispatcher.Push( *(new SwBaseShell( *this )) );
//STRIP001 /*?*/ 			pShell = new SwDrawTextShell( *this );
//STRIP001 /*?*/ 			rDispatcher.Push( *pShell );
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			bSetExtInpCntxt = sal_True;
/*N*/ 			eShellMode = SEL_TEXT;
/*N*/ 			sal_uInt32 nHelpId = 0;
/*N*/ 			if ( nSelectionType & SwWrtShell::SEL_NUM )
/*N*/ 			{
/*N*/ 				eShellMode = SEL_LIST_TEXT;
/*N*/ 				pShell = new SwListShell( *this );
/*N*/ 				nHelpId = pShell->GetHelpId();
/*N*/ 				rDispatcher.Push( *pShell );
/*N*/ 			}
/*N*/ 			pShell = new SwTextShell(*this);
/*N*/ 			if(nHelpId)
/*N*/ 				pShell->SetHelpId(nHelpId);
/*N*/ 			rDispatcher.Push( *pShell );
/*N*/ 			if ( nSelectionType & SwWrtShell::SEL_TBL )
/*N*/ 			{
/*N*/ 				eShellMode = eShellMode == SEL_LIST_TEXT ? SEL_TABLE_LIST_TEXT
/*N*/ 														: SEL_TABLE_TEXT;
/*N*/ 				pShell = new SwTableShell( *this );
/*N*/ 				rDispatcher.Push( *pShell );
/*N*/ 			}
/*N*/ 		}
/*N*/ 		pViewImpl->SetShellMode(eShellMode);
/*N*/ 		ImpSetVerb( nSelectionType );
/*N*/ 
/*N*/ 		if( !GetDocShell()->IsReadOnly() )
/*N*/ 		{
/*N*/ 			if( bSetExtInpCntxt && GetWrtShell().HasReadonlySel() )
/*N*/ 				bSetExtInpCntxt = sal_False;
/*N*/ 
/*N*/ 			InputContext aCntxt( GetEditWin().GetInputContext() );
/*N*/ 			aCntxt.SetOptions( bSetExtInpCntxt
/*N*/ 								? (aCntxt.GetOptions() |
/*N*/ 										( INPUTCONTEXT_TEXT |
/*N*/ 											INPUTCONTEXT_EXTTEXTINPUT ))
/*N*/ 								: (aCntxt.GetOptions() & ~
/*N*/ 										( INPUTCONTEXT_TEXT |
/*N*/ 											INPUTCONTEXT_EXTTEXTINPUT )) );
/*N*/ 			GetEditWin().SetInputContext( aCntxt );
/*N*/ 		}
/*N*/ 
/*N*/ 		//Zur neuen Selektion die Toolbar aktivieren, die auch beim letzten Mal
/*N*/ 		//aktiviert war
/*N*/ 		//Vorher muss ein Flush() sein, betrifft aber lt. MBA nicht das UI und ist
/*N*/ 		//kein Performance-Problem
/*N*/ 		rDispatcher.Flush();
/*N*/ 		sal_uInt16 nId = pBarCfg->GetTopToolbar( nSelectionType );
/*N*/ 		if ( USHRT_MAX != nId )
/*N*/ 			rDispatcher.ShowObjectBar( nId );
/*N*/ 
/*N*/ 		Point aPnt = GetEditWin().OutputToScreenPixel(GetEditWin().GetPointerPosPixel());
/*N*/ 		aPnt = GetEditWin().PixelToLogic(aPnt);
/*N*/ 		GetEditWin().UpdatePointer(aPnt);
/*N*/ 
/*N*/ 		SdrView* pDView = GetWrtShell().GetDrawView();
/*N*/ 		if ( bInitFormShell && pDView )
/*N*/ 			pFormShell->SetView(PTR_CAST(FmFormView, pDView));
/*N*/ 
/*N*/ 	}
/*N*/ 	//Guenstiger Zeitpunkt fuer die Kommunikation mit OLE-Objekten?
/*N*/ 	if ( GetDocShell()->GetDoc()->IsOLEPrtNotifyPending() )
/*N*/ 		GetDocShell()->GetDoc()->PrtOLENotify( sal_False );
/*N*/ 
/*N*/ 	//jetzt das Tabellen-Update
/*N*/ 	if(bUpdateTable)
/*N*/ 		pWrtShell->UpdateTable();
/*N*/ }

//Zusammenspiel: AttrChangedNotify() und TimeoutHdl.
//Falls noch Actions offen sind keine Aktualisierung, da der
//Cursor auf der Core-Seite im Wald stehen kann.
//Da wir aber keine Stati mehr liefern koennen und wollen locken wir
//stattdessen den Dispatcher.



int
#if defined( WNT )
 __cdecl
#endif
#if defined( ICC )
 _Optlink
#endif
/*N*/ 	lcl_CmpIds( const void *pFirst, const void *pSecond)
/*N*/ {
/*N*/ 	return (*(sal_uInt16*)pFirst) - (*(sal_uInt16*)pSecond);
/*N*/ }



/*N*/ IMPL_LINK( SwView, AttrChangedNotify, SwWrtShell *, EMPTYARG )
/*N*/ {
/*N*/ 	if ( GetEditWin().IsChainMode() )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		GetEditWin().SetChainMode( sal_False );
/*N*/ 
/*N*/ 	//Opt: Nicht wenn PaintLocked. Beim Unlock wird dafuer nocheinmal ein
/*N*/ 	//Notify ausgeloest.
/*N*/ 	if( !pWrtShell->IsPaintLocked() && !bNoInterrupt &&
/*N*/ 		GetDocShell()->IsReadOnly() )
/*N*/ 		_CheckReadonlyState();
/*N*/ 
/*N*/ 	// JP 19.01.99: Cursor in Readonly Bereichen
/*N*/ 	if( !pWrtShell->IsPaintLocked() && !bNoInterrupt )
/*N*/ 		_CheckReadonlySelection();
/*N*/ 
/*N*/ 	if( !bAttrChgNotified )
/*N*/ 	{
/*N*/ 		if ( pWrtShell->BasicActionPend() || bNoInterrupt ||
/*N*/ 			 GetDispatcher().IsLocked() ||				 //do not confuse the SFX
/*N*/ 			 GetViewFrame()->GetBindings().IsInUpdate() )//do not confuse the SFX
/*N*/ 		{
/*N*/ 			bAttrChgNotified = sal_True;
/*N*/ 			aTimer.Start();
/*N*/ 
/*N*/ 			const SfxPoolItem *pItem;
/*N*/ 			if ( SFX_ITEM_SET != GetObjectShell()->GetMedium()->GetItemSet()->
/*N*/ 									GetItemState( SID_HIDDEN, sal_False, &pItem ) ||
/*N*/ 				 !((SfxBoolItem*)pItem)->GetValue() )
/*N*/ 			{
/*?*/ 				GetViewFrame()->GetBindings().ENTERREGISTRATIONS();
/*?*/ 				bAttrChgNotifiedWithRegistrations = sal_True;
/*N*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 			SelectShell();
/*N*/ 	}
/*N*/ 	GetViewImpl()->GetUNOObject_Impl()->NotifySelChanged();
/*N*/ 	return 0;
/*N*/ }



/*N*/ IMPL_LINK( SwView, TimeoutHdl, Timer *, EMPTYARG )
/*N*/ {
/*N*/ 	DBG_PROFSTART(viewhdl);
/*N*/ 
/*N*/ 	if( pWrtShell->BasicActionPend() || bNoInterrupt )
/*N*/ 	{
/*N*/ 		aTimer.Start();
/*N*/ 		DBG_PROFSTOP(viewhdl);
/*N*/ 		return 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bAttrChgNotifiedWithRegistrations )
/*N*/ 	{
/*?*/ 		GetViewFrame()->GetBindings().LEAVEREGISTRATIONS();
/*?*/ 		bAttrChgNotifiedWithRegistrations = sal_False;
/*N*/ 	}
/*N*/ 
/*N*/ 	_CheckReadonlyState();
/*N*/ 	_CheckReadonlySelection();
/*N*/ 
/*N*/ 	SelectShell();
/*N*/ 	bAttrChgNotified = sal_False;
/*N*/     GetViewImpl()->GetUNOObject_Impl()->NotifySelChanged();
/*N*/ 
/*N*/ 	DBG_PROFSTOP(viewhdl);
/*N*/ 	return 0;
/*N*/ }

/*N*/ void SwView::_CheckReadonlyState()
/*N*/ {
/*N*/ 	SfxDispatcher &rDis = GetDispatcher();
/*N*/ 	//Um erkennen zu koennen ob bereits disabled ist!
/*N*/ 	SfxItemState eStateRO, eStateProtAll;
/*N*/ 	const SfxPoolItem *pItem;
/*N*/ 	// JP 29.04.97: von einem nur uns bekannten Slot den Status abfragen.
/*N*/ 	//				Ansonsten kennen andere den Slot; wie z.B. die BasidIde
/*N*/ 	eStateRO = rDis.QueryState( FN_INSERT_BOOKMARK, pItem );
/*N*/ 	eStateProtAll = rDis.QueryState( FN_EDIT_REGION, pItem );
/*N*/ 	sal_Bool bChgd = sal_False;
/*N*/ 
/*N*/ 	if ( !pWrtShell->IsCrsrReadonly() )
/*N*/ 	{
/*N*/ 		static sal_uInt16 aROIds[] =
/*N*/ 		{
/*N*/ 			SID_DELETE, 				FN_BACKSPACE,				FN_SHIFT_BACKSPACE,
/*N*/ 			SID_UNDO,
/*N*/ 			SID_REDO,					SID_REPEAT,					SID_PASTE,
/*N*/ 			FN_PASTESPECIAL,			SID_SBA_BRW_INSERT,
/*N*/ 			SID_BACKGROUND_COLOR,       FN_INSERT_BOOKMARK,
/*N*/ 			FN_INSERT_SYMBOL,			FN_INSERT_SOFT_HYPHEN,
/*N*/ 			FN_INSERT_HARDHYPHEN,		FN_INSERT_HARD_SPACE,		FN_INSERT_BREAK,
/*N*/ 			FN_INSERT_LINEBREAK,		FN_INSERT_COLUMN_BREAK,		FN_INSERT_BREAK_DLG,
/*N*/ 			FN_DELETE_SENT,				FN_DELETE_BACK_SENT,		FN_DELETE_WORD,
/*N*/ 			FN_DELETE_BACK_WORD,		FN_DELETE_LINE,				FN_DELETE_BACK_LINE,
/*N*/ 			FN_DELETE_PARA,				FN_DELETE_BACK_PARA,		FN_DELETE_WHOLE_LINE,
/*N*/ 			FN_CALCULATE,				FN_FORMAT_RESET,
/*N*/ 			FN_POSTIT,			   		FN_JAVAEDIT,				SID_ATTR_PARA_ADJUST_LEFT,
/*N*/ 			SID_ATTR_PARA_ADJUST_RIGHT,	SID_ATTR_PARA_ADJUST_CENTER,SID_ATTR_PARA_ADJUST_BLOCK,
/*N*/ 			SID_ATTR_PARA_LINESPACE_10,	SID_ATTR_PARA_LINESPACE_15,	SID_ATTR_PARA_LINESPACE_20,
/*N*/ 			SID_ATTR_CHAR_FONT,			SID_ATTR_CHAR_FONTHEIGHT,	SID_ATTR_CHAR_COLOR_BACKGROUND,
/*N*/ 			SID_ATTR_CHAR_COLOR_BACKGROUND_EXT,						SID_ATTR_CHAR_COLOR_EXT,
/*N*/ 			SID_ATTR_CHAR_COLOR,		SID_ATTR_CHAR_WEIGHT,		SID_ATTR_CHAR_POSTURE,
/*N*/ 			SID_ATTR_CHAR_UNDERLINE,	SID_ATTR_FLASH,				SID_ATTR_CHAR_STRIKEOUT,
/*N*/ 			FN_UNDERLINE_DOUBLE,		SID_ATTR_CHAR_CONTOUR,		SID_ATTR_CHAR_SHADOWED,
/*N*/ 			SID_ATTR_CHAR_AUTOKERN,		SID_ATTR_CHAR_ESCAPEMENT,	FN_SET_SUPER_SCRIPT,
/*N*/ 			FN_SET_SUB_SCRIPT,			SID_ATTR_CHAR_CASEMAP,		SID_ATTR_CHAR_LANGUAGE,
/*N*/ 			SID_ATTR_CHAR_KERNING,		SID_CHAR_DLG,				SID_ATTR_CHAR_WORDLINEMODE,
/*N*/ 			FN_GROW_FONT_SIZE,			FN_SHRINK_FONT_SIZE,		FN_TXTATR_INET,
/*N*/ 			FN_FORMAT_DROPCAPS,			SID_ATTR_PARA_ADJUST,		SID_ATTR_PARA_LINESPACE,
/*N*/ 			SID_ATTR_PARA_SPLIT,		SID_ATTR_PARA_KEEP,			SID_ATTR_PARA_WIDOWS,
/*N*/ 			SID_ATTR_PARA_ORPHANS,
/*N*/ 			SID_ATTR_PARA_MODEL,		SID_PARA_DLG,
/*N*/ 			FN_SELECT_PARA,				SID_DEC_INDENT,
/*N*/ 			SID_INC_INDENT
/*N*/ 		};
/*N*/ 		static sal_Bool bFirst = sal_True;
/*N*/ 		if ( bFirst )
/*N*/ 		{
/*N*/ 			qsort( (void*)aROIds, sizeof(aROIds)/sizeof(sal_uInt16), sizeof(sal_uInt16), lcl_CmpIds );
/*N*/ 			bFirst = sal_False;
/*N*/ 		}
/*N*/ 		if ( SFX_ITEM_DISABLED == eStateRO )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			rDis.SetSlotFilter( sal_Bool(2), sizeof(aROIds)/sizeof(sal_uInt16), aROIds );
//STRIP001 /*?*/ 			bChgd = sal_True;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if( pWrtShell->IsAllProtect() )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		if ( SFX_ITEM_DISABLED == eStateProtAll )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			static sal_uInt16 aAllProtIds[] = { SID_SAVEDOC, FN_EDIT_REGION };
//STRIP001 /*?*/ 			static sal_Bool bAllProtFirst = sal_True;
//STRIP001 /*?*/ 			if ( bAllProtFirst )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				qsort( (void*)aAllProtIds, sizeof(aAllProtIds)/sizeof(sal_uInt16), sizeof(sal_uInt16), lcl_CmpIds );
//STRIP001 /*?*/ 				bAllProtFirst = sal_False;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rDis.SetSlotFilter( sal_Bool(2),
//STRIP001 /*?*/ 								sizeof(aAllProtIds)/sizeof(sal_uInt16),
//STRIP001 /*?*/ 								aAllProtIds );
//STRIP001 /*?*/ 			bChgd = sal_True;
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 	else if ( SFX_ITEM_DISABLED != eStateRO ||
/*N*/ 				SFX_ITEM_DISABLED != eStateProtAll )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		bChgd = sal_True;
//STRIP001 /*?*/ 		rDis.SetSlotFilter();
/*N*/ 	}
/*N*/ 	if ( bChgd )
/*?*/ 		GetViewFrame()->GetBindings().InvalidateAll(sal_True);
/*N*/ }

/*N*/ void SwView::_CheckReadonlySelection()
/*N*/ {
/*N*/ 	sal_uInt32 nDisableFlags = 0;
/*N*/ 	SfxDispatcher &rDis = GetDispatcher();
/*N*/ 
/*N*/ 	if( pWrtShell->HasReadonlySel() &&
/*N*/ 		( !pWrtShell->GetDrawView() ||
/*N*/ 			!pWrtShell->GetDrawView()->GetMarkList().GetMarkCount() ))
/*N*/ 		nDisableFlags |= SW_DISABLE_ON_PROTECTED_CURSOR;
/*N*/ 
/*N*/ 	if( (SW_DISABLE_ON_PROTECTED_CURSOR & nDisableFlags ) !=
/*N*/ 		(SW_DISABLE_ON_PROTECTED_CURSOR & rDis.GetDisableFlags() ) )
/*N*/ 	{
/*N*/ 		// zusaetzlich am Window den InputContext umsetzen, damit in
/*N*/ 		// japanischen / chinesischen Versionen die externe Eingabe
/*N*/ 		// ab-/angeschaltet wird. Das aber nur wenn auch die richtige
/*N*/ 		// Shell auf dem Stack steht.
/*N*/ 		switch( pViewImpl->GetShellMode() )
/*N*/ 		{
/*N*/ 		case SEL_TEXT:
/*N*/ 		case SEL_LIST_TEXT:
/*N*/ 		case SEL_TABLE_TEXT:
/*N*/ 		case SEL_TABLE_LIST_TEXT:
/*N*/ 			{
/*N*/ //JP 22.01.99: temporaere Loesung!!! Sollte bei jeder Cursorbewegung
/*N*/ //			den Font von der akt. Einfuegeposition setzen, also ausserhalb
/*N*/ // 			dieses if's. Aber TH wertet den Font zur Zeit nicht aus und
/*N*/ //			das besorgen erscheint mir hier zu teuer zu sein.
/*N*/ //			Ausserdem haben wir keinen Font, sondern nur Attribute aus denen
/*N*/ //			die Textformatierung dann den richtigen Font zusammen baut.
/*N*/ 
/*N*/ 				InputContext aCntxt( GetEditWin().GetInputContext() );
/*N*/ 				aCntxt.SetOptions( SW_DISABLE_ON_PROTECTED_CURSOR & nDisableFlags
/*N*/ 									? (aCntxt.GetOptions() & ~
/*N*/ 											( INPUTCONTEXT_TEXT |
/*N*/ 												INPUTCONTEXT_EXTTEXTINPUT ))
/*N*/ 									: (aCntxt.GetOptions() |
/*N*/ 											( INPUTCONTEXT_TEXT |
/*N*/ 												INPUTCONTEXT_EXTTEXTINPUT )) );
/*N*/ 				GetEditWin().SetInputContext( aCntxt );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 	}
/*N*/ 
/*N*/ 	if( nDisableFlags != rDis.GetDisableFlags() )
/*N*/ 	{
/*N*/ 		rDis.SetDisableFlags( nDisableFlags );
/*N*/ 		GetViewFrame()->GetBindings().InvalidateAll( sal_True );
/*N*/ 	}
/*N*/ }


/*N*/ SwView::SwView( SfxViewFrame *pFrame, SfxViewShell* pOldSh )
/*N*/ 	: SfxViewShell( pFrame, SWVIEWFLAGS ),
/*N*/ 	aPageStr( SW_RES( STR_PAGE )),
/*N*/ 	pEditWin( new SwEditWin( &pFrame->GetWindow(), *this ) ),
/*N*/ 	pShell(0),
/*N*/ 	pWrtShell(0),
/*N*/ 	pFormShell(0),
/*N*/ 	pHScrollbar(0),
/*N*/ 	pVScrollbar(0),
/*N*/     pScrollFill(new ScrollBarBox( &pFrame->GetWindow(), GetDocShell()->IsInFrame() ? 0 : WB_SIZEABLE )),
/*N*/     pHRuler( new SvxRuler(&GetViewFrame()->GetWindow(), pEditWin,
/*N*/ 					SVXRULER_SUPPORT_TABS |
/*N*/ 					SVXRULER_SUPPORT_PARAGRAPH_MARGINS |
/*N*/ 					SVXRULER_SUPPORT_BORDERS |
/*N*/ 					SVXRULER_SUPPORT_NEGATIVE_MARGINS,
/*N*/ 					GetViewFrame()->GetBindings(),
/*N*/                     WB_STDRULER | WB_EXTRAFIELD | WB_BORDER)),
/*N*/     pVRuler(new SvxRuler(&GetViewFrame()->GetWindow(), pEditWin,
/*N*/                             SVXRULER_SUPPORT_TABS | SVXRULER_SUPPORT_PARAGRAPH_MARGINS_VERTICAL|
/*N*/                                 SVXRULER_SUPPORT_BORDERS,
/*N*/ 							GetViewFrame()->GetBindings(),
/*N*/                             WB_VSCROLL |  WB_EXTRAFIELD | WB_BORDER )),
/*N*/     pTogglePageBtn(0),
/*N*/ 	pPageUpBtn(0),
/*N*/ 	pPageDownBtn(0),
//STRIP001 /*N*/ 	pNaviBtn(0),
//STRIP001 	pGlosHdl(0),
/*N*/ 	pDrawActual(0),
/*N*/ 	pLastTableFormat(0),
/*N*/ 	nDrawSfxId( USHRT_MAX ),
/*N*/ 	nFormSfxId( USHRT_MAX ),
/*N*/ 	nSelectionType( INT_MAX ),
/*N*/     nLastPasteDestination( 0xFFFF ),
/*N*/     nNewPage(USHRT_MAX),
/*N*/     bInMailMerge(FALSE),
/*N*/     bInDtor(FALSE)
/*N*/ {
/*N*/     // OD 18.12.2002 #103492# - According to discussion with MBA and further
/*N*/     // investigations, no old SfxViewShell will be set as parameter <pOldSh>,
/*N*/     // if function "New Window" is performed to open an additional view beside
/*N*/     // an already existing one.
/*N*/     // If the view is switch from one to another, the 'old' view is given by
/*N*/     // parameter <pOldSh>.
/*N*/ 
/*N*/     RTL_LOGFILE_CONTEXT_AUTHOR( aLog, "SW", "JP93722",  "SwView::SwView" );
/*N*/ 
/*N*/     _CreateScrollbar( TRUE );
/*N*/     _CreateScrollbar( FALSE );
/*N*/ 
/*N*/     bCenterCrsr = bTopCrsr = bAllwaysShowSel = bTabColFromDoc =
/*N*/ 	bSetTabColFromDoc = bAttrChgNotified = bAttrChgNotifiedWithRegistrations =
/*N*/     bVerbsActive = bIsApi = bDrawRotate = bInOuterResizePixel = bInInnerResizePixel =
/*N*/     bPasteState = bPasteSpecialState = sal_False;
/*N*/ 
/*N*/ 	bShowAtResize = bDrawSelMode = bDocSzUpdated = sal_True;
/*N*/ 
/*N*/ 	pViewImpl = new SwView_Impl(this);
/*N*/ 	SetName(C2S("View"));
/*N*/ 	SetWindow( pEditWin );
/*N*/ 
/*N*/ 	aTimer.SetTimeout( 120 );
/*N*/ 
/*N*/ 	SwDocShell* pDocSh = PTR_CAST( SwDocShell, pFrame->GetObjectShell() );
/*N*/ 	BOOL bOldModifyFlag = pDocSh->IsEnableSetModified();
/*N*/ 	pDocSh->EnableSetModified( FALSE );
/*N*/ 	ASSERT( pDocSh, "View ohne DocShell." );
/*N*/ 	SwWebDocShell* pWebDShell = PTR_CAST( SwWebDocShell, pDocSh );
/*N*/ 
/*N*/     const SwMasterUsrPref *pUsrPref = SW_MOD()->GetUsrPref(0 != pWebDShell);
/*N*/     SwViewOption aUsrPref( *pUsrPref);
/*N*/ 
/*N*/     //! get lingu options without loading lingu DLL
/*N*/     SvtLinguOptions aLinguOpt;
/*N*/ 
/*N*/ 	// #107253# Replaced SvtLinguConfig with SwLinguConfig wrapper with UsageCount
/*N*/     SwLinguConfig().GetOptions( aLinguOpt );
/*N*/ 
/*N*/     aUsrPref.SetOnlineSpell( aLinguOpt.bIsSpellAuto );
/*N*/     aUsrPref.SetHideSpell( aLinguOpt.bIsSpellHideMarkings );
/*N*/ 
/*N*/ 	sal_Bool bOldShellWasPagePreView = FALSE,
/*N*/ 			 bOldShellWasSrcView = FALSE;
/*N*/ 
/*N*/     // OD 18.12.2002 #103492# - determine, if there is an existing view for
/*N*/     // document
/*N*/     SfxViewShell* pExistingSh = 0;
/*N*/     if ( pOldSh )
/*?*/         pExistingSh = pOldSh;
/*N*/     else
/*N*/     {
/*N*/         SfxViewFrame *pF = SfxViewFrame::GetFirst( pDocSh );
/*N*/         if( pF == pFrame )
/*?*/             pF = SfxViewFrame::GetNext( *pF, pDocSh );
/*N*/         if( pF )
/*?*/             pExistingSh = pF->GetViewShell();
/*N*/     }
/*N*/ 
/*N*/     // determine type of existing view
/*N*/     if( pExistingSh &&
/*N*/         pExistingSh->IsA( TYPE( SwPagePreView ) ) )
/*N*/     {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/         sSwViewData = ((SwPagePreView*)pExistingSh)->GetPrevSwViewData();
//STRIP001 /*?*/         sNewCrsrPos = ((SwPagePreView*)pExistingSh)->GetNewCrsrPos();
//STRIP001 /*?*/         nNewPage = ((SwPagePreView*)pExistingSh)->GetNewPage();
//STRIP001 /*?*/         bOldShellWasPagePreView = TRUE;
/*N*/     }
/*N*/     else if( pExistingSh &&
/*N*/              pExistingSh->IsA( TYPE( SwSrcView ) ) )
/*N*/         bOldShellWasSrcView = TRUE;
/*N*/ 
/*N*/ 	RTL_LOGFILE_CONTEXT_TRACE( aLog, "before create WrtShell" );
/*N*/     if(PTR_CAST( SwView, pExistingSh))
/*N*/ 	{
/*N*/         pWrtShell = new SwWrtShell( *((SwView*)pExistingSh)->pWrtShell,
/*N*/ 									pEditWin, *this);
/*N*/ //MA: Das kann doch nur zu einem GPF fuehren!
/*N*/ //		nSelectionType = ((SwView*)pOldSh)->nSelectionType;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SwDoc& rDoc = *((SwDocShell*)pDocSh)->GetDoc();
/*N*/ 
/*N*/         if( !bOldShellWasSrcView && pWebDShell && !bOldShellWasPagePreView )
/*N*/ 			rDoc.SetBrowseMode( sal_True );
/*N*/ 
/*N*/ 		//Fuer den BrowseMode wollen wir keinen Factor uebernehmen.
/*N*/ 		if( rDoc.IsBrowseMode() && aUsrPref.GetZoomType() != SVX_ZOOM_PERCENT )
/*N*/ 		{
/*N*/ 			aUsrPref.SetZoomType( SVX_ZOOM_PERCENT );
/*N*/ 			aUsrPref.SetZoom( 100 );
/*N*/ 		}
/*N*/         if(pDocSh->IsPreview())
/*N*/             aUsrPref.SetZoomType( SVX_ZOOM_WHOLEPAGE );
/*N*/ 		pWrtShell = new SwWrtShell( rDoc, pEditWin, *this, 0, &aUsrPref );
/*N*/         //#97610# creating an SwView from a SwPagePreView needs to
/*N*/         // add the ViewShell to the ring of the other ViewShell(s)
/*N*/         if(bOldShellWasPagePreView)
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/             ViewShell& rPreviewViewShell = *((SwPagePreView*)pExistingSh)->GetViewShell();
//STRIP001 /*?*/             pWrtShell->MoveTo(&rPreviewViewShell);
//STRIP001 /*?*/             //#95521# to update the field command et.al. if necessary
//STRIP001 /*?*/             const SwViewOption* pPreViewOpt = rPreviewViewShell.GetViewOptions();
//STRIP001 /*?*/             if( pPreViewOpt->IsFldName() != aUsrPref.IsFldName() ||
//STRIP001 /*?*/                     pPreViewOpt->IsHidden() != aUsrPref.IsHidden() ||
//STRIP001 /*?*/                     pPreViewOpt->IsShowHiddenPara() != aUsrPref.IsShowHiddenPara() )
//STRIP001 /*?*/                 rPreviewViewShell.ApplyViewOptions(aUsrPref);
//STRIP001 /*?*/             // OD 09.01.2003 #106334# - reset design mode at draw view for form
//STRIP001 /*?*/             // shell, if needed.
//STRIP001 /*?*/             if ( ((SwPagePreView*)pExistingSh)->ResetFormDesignMode() &&
//STRIP001 /*?*/                  pWrtShell->HasDrawView() )
//STRIP001 /*?*/             {
//STRIP001 /*?*/                 SdrView* pDrawView = pWrtShell->GetDrawView();
//STRIP001 /*?*/                 pDrawView->SetDesignMode( ((SwPagePreView*)pExistingSh)->FormDesignModeToReset() );
//STRIP001 /*?*/             }
/*N*/         }
/*N*/ 	}
/*N*/ 	RTL_LOGFILE_CONTEXT_TRACE( aLog, "after create WrtShell" );
/*N*/ 
/*N*/ 	// JP 05.02.99: Bug 61495 - damit unter anderem das HLineal im
/*N*/ 	//				ReadonlyFall nicht angezeigt wird
/*N*/ 	aUsrPref.SetReadonly( pWrtShell->GetViewOptions()->IsReadonly() );
/*N*/ 
/*N*/ 	//Kein Margin fuer OLE!
/*N*/ 	Size aBrwsBorder;
/*N*/ 	if( SFX_CREATE_MODE_EMBEDDED != pDocSh->GetCreateMode() )
/*N*/ 		aBrwsBorder = GetMargin();
/*N*/ 
/*N*/ 	if( pFrame->GetFrameType() & SFXFRAME_INTERNAL )
/*?*/ 		pWrtShell->SetFrameView( aBrwsBorder );
/*N*/ 	else
/*N*/ 		pWrtShell->SetBrowseBorder( aBrwsBorder );
/*N*/ 
/*N*/ 	// Im CTOR duerfen keine Shell wechsel erfolgen, die muessen ueber
/*N*/ 	// den Timer "zwischen gespeichert" werden. Sonst raeumt der SFX
/*N*/ 	// sie wieder vom Stack!
/*N*/ 	sal_Bool bOld = bNoInterrupt;
/*N*/ 	bNoInterrupt = sal_True;
/*N*/ 
/*N*/     pHRuler->SetActive( sal_True );
/*N*/     pVRuler->SetActive( sal_True );
/*N*/ 
/*N*/ 	SfxViewFrame* pViewFrame = GetViewFrame();
/*N*/ 	if( pViewFrame->GetFrame()->GetParentFrame())
/*N*/ 	{
/*?*/         aUsrPref.SetViewHRuler(sal_False);
/*?*/         aUsrPref.SetViewVRuler(sal_False);
/*N*/ 	}
/*N*/ 
/*N*/ 	StartListening( *pViewFrame );
/*N*/ 	StartListening( *pDocSh );
/*N*/ 
/*N*/ 	// Vom HLineal den ZOOM-Faktor einstellen
/*N*/     Fraction aZoomFract( aUsrPref.GetZoom(), 100 );
/*N*/     pHRuler->SetZoom( aZoomFract );
/*N*/     pVRuler->SetZoom( aZoomFract );
/*N*/     pHRuler->SetDoubleClickHdl(LINK( this, SwView, ExecRulerClick ));
/*N*/     FieldUnit eMetric = pUsrPref->GetHScrollMetric();
/*N*/     pHRuler->SetUnit( eMetric );
/*N*/     eMetric = pUsrPref->GetVScrollMetric();
/*N*/     pVRuler->SetUnit( eMetric );
/*N*/ 
/*N*/ 	// DocShell setzen
/*N*/ 	pDocSh->SetView( this );
/*N*/ 	SW_MOD()->SetView( this );
/*N*/ 
/*N*/ 	// Die DocSize erfragen und verarbeiten. Ueber die Handler konnte
/*N*/ 	// die Shell nicht gefunden werden, weil die Shell innerhalb CTOR-Phase
/*N*/ 	// nicht in der SFX-Verwaltung bekannt ist.
/*N*/ 	DocSzChgd( pWrtShell->GetDocSize() );
/*N*/ 
/*N*/ 		// AttrChangedNotify Link setzen
/*N*/ 	pWrtShell->SetChgLnk(LINK(this, SwView, AttrChangedNotify));
/*N*/ 
/*N*/ 	if( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED &&
/*N*/ 		!((SvEmbeddedObject *)pDocSh)->GetVisArea().IsEmpty() )
/*N*/ 		SetVisArea( ((SvEmbeddedObject *)pDocSh)->GetVisArea(),sal_False);
/*N*/ 
/*N*/ 	{
/*N*/ 		SvtUndoOptions aOpt;
/*N*/ 		SwEditShell::SetUndoActionCount( aOpt.GetUndoCount() );
/*N*/ 	}
/*N*/ 	pWrtShell->DoUndo( 0 != SwEditShell::GetUndoActionCount() );
/*N*/ 
/*N*/ 	const FASTBOOL bBrowse = pWrtShell->GetDoc()->IsBrowseMode();
/*N*/ 	SetNewWindowAllowed(!bBrowse);
/*N*/ 
/*N*/     ShowVScrollbar(aUsrPref.IsViewVScrollBar());
/*N*/     ShowHScrollbar(aUsrPref.IsViewHScrollBar());
/*N*/     pHScrollbar->SetAuto(bBrowse);
/*N*/     if( aUsrPref.IsViewHRuler() )
/*N*/         CreateTab();
/*N*/     if( aUsrPref.IsViewVRuler() )
/*?*/        {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001  CreateVLineal();
/*N*/ 
/*N*/ 	pWrtShell->SetUIOptions( aUsrPref );
/*N*/ 	pWrtShell->SetReadOnlyAvailable( aUsrPref.IsCursorInProtectedArea() );
/*N*/     pWrtShell->ApplyAccessiblityOptions(SW_MOD()->GetAccessibilityOptions());
/*N*/ 
/*N*/ 	if( UseObjectSize() )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		//Damit der Sfx _rechtzeitig weiss_, wie gross die ::com::sun::star::sheet::Border sind.
//STRIP001 /*?*/ 		SvBorder aTmp;
//STRIP001 /*?*/ 		CalcAndSetBorderPixel( aTmp, sal_True );
/*N*/ 	}
/*N*/ 
/*N*/ 	if( pWrtShell->GetDoc()->IsUpdateExpFld() )
/*N*/ 	{
/*?*/ 		SET_CURR_SHELL( pWrtShell );
/*?*/ 		pWrtShell->StartAction();
/*?*/ 		pWrtShell->CalcLayout();
/*?*/ 		pWrtShell->GetDoc()->UpdateFlds();
/*?*/ 		pWrtShell->EndAction();
/*?*/ 		pWrtShell->GetDoc()->SetUpdateExpFldStat( sal_False );
/*N*/ 	}
/*N*/ 
/*N*/ 	// ggfs. alle Verzeichnisse updaten:
/*N*/ 	if( pWrtShell->GetDoc()->IsUpdateTOX() )
/*N*/ 	{
/*?*/ 		SfxRequest aSfxRequest( FN_UPDATE_TOX, SFX_CALLMODE_SLOT, GetPool() );
/*?*/ 		Execute( aSfxRequest );
/*?*/ 		pWrtShell->GetDoc()->SetUpdateTOX( sal_False );		// wieder zurueck setzen
/*?*/ 		pWrtShell->SwCrsrShell::SttDoc();
/*N*/ 	}
/*N*/ 
/*N*/ 	// kein ResetModified, wenn es schone eine View auf dieses Doc gibt
/*N*/ 	SfxViewFrame* pVFrame = GetViewFrame();
/*N*/ 	SfxViewFrame* pFirst = SfxViewFrame::GetFirst(pDocSh);
/*N*/ 	// zur Zeit(360) wird die View erst nach dem Ctor eingetragen
/*N*/ 	// der folgende Ausdruck funktioniert auch, wenn sich das aendert
/*N*/ 	//JP 27.07.98: wenn per Undo nicht mehr die Modifizierung aufhebar ist,
/*N*/ 	//				so setze das Modified NICHT zurueck.
/*N*/ 	if( !pWrtShell->GetDoc()->IsUndoNoResetModified() &&
/*N*/ 		(!pFirst || pFirst == pVFrame ) )
/*N*/ 		pWrtShell->ResetModified();
/*N*/ 
/*N*/ 	bNoInterrupt = bOld;
/*N*/ 
/*N*/ 	// wird ein GlobalDoc neu angelegt, soll auch der Navigator erzeugt werden
/*N*/ 	if( pDocSh->IsA(SwGlobalDocShell::StaticType()) &&
/*N*/ 		!pVFrame->GetChildWindow( SID_NAVIGATOR ))
/*N*/ 	{
/*N*/ 		SfxBoolItem aNavi(SID_NAVIGATOR, sal_True);
/*N*/ 		GetDispatcher().Execute(SID_NAVIGATOR, SFX_CALLMODE_ASYNCHRON, &aNavi, 0L);
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 	uno::Reference< awt::XWindow >  aTmpRef;
/*N*/ 	pFrame->GetFrame()->GetFrameInterface()->setComponent( aTmpRef,
/*N*/ 											pViewImpl->GetUNOObject_Impl());
/*N*/ 
/*N*/    uno::Reference< frame::XFrame >  xFrame = pVFrame->GetFrame()->GetFrameInterface();
/*N*/ 
/*N*/     uno::Reference< frame::XFrame >  xBeamerFrame = xFrame->findFrame(
/*N*/             OUString::createFromAscii("_beamer"), frame::FrameSearchFlag::CHILDREN);
/*N*/     if(xBeamerFrame.is())
/*N*/     {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/         SwDBData aData = pWrtShell->GetDBData();
//STRIP001 /*?*/         SW_MOD()->ShowDBObj( *this, aData );
/*N*/     }
/*N*/ 
/*N*/ 	// has anybody calls the attrchanged handler in the constructor?
/*N*/ 	if( bAttrChgNotifiedWithRegistrations )
/*N*/ 	{
/*?*/ 		GetViewFrame()->GetBindings().LEAVEREGISTRATIONS();
/*?*/ 	    if( aTimer.IsActive() )
/*?*/ 			aTimer.Stop();
/*N*/ 	}
/*N*/ 
/*N*/ 	aTimer.SetTimeoutHdl(LINK(this, SwView, TimeoutHdl));
/*N*/ 	bAttrChgNotified = bAttrChgNotifiedWithRegistrations = sal_False;
/*N*/ 	pDocSh->EnableSetModified( bOldModifyFlag );
/*N*/     InvalidateBorder();
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


/*N*/ SwView::~SwView()
/*N*/ {
/*N*/     bInDtor = TRUE;
/*N*/     pEditWin->Hide(); // damit kein Paint Aerger machen kann!
/*N*/ 	// An der SwDocShell den Pointer auf die View ruecksetzen
/*N*/ 	SwDocShell* pDocSh = GetDocShell();
/*N*/ 	if( pDocSh && pDocSh->GetView() == this )
/*N*/ 		pDocSh->SetView( 0 );
/*N*/ 	if ( SW_MOD()->GetView() == this )
/*N*/ 		SW_MOD()->SetView( 0 );
/*N*/ 
/*N*/ 	if( aTimer.IsActive() && bAttrChgNotifiedWithRegistrations )
/*N*/ 		GetViewFrame()->GetBindings().LEAVEREGISTRATIONS();
/*N*/ 
/*N*/ 	//JP 27.11.00: Bug 80631 - the last view must end the text edit
/*N*/ 	SdrView *pSdrView = pWrtShell ? pWrtShell->GetDrawView() : 0;
/*N*/ 	if( pSdrView && pSdrView->IsTextEdit() )
/*N*/ 		pSdrView->EndTextEdit( sal_True );
/*N*/ 
/*N*/ 	SetWindow( 0 );
/*N*/ 
/*N*/     pViewImpl->Invalidate();
/*N*/ 	EndListening(*GetViewFrame());
/*N*/ 	EndListening(*GetDocShell());
/*N*/ 	delete pScrollFill;
/*N*/ 	delete pWrtShell;
/*N*/ 	pWrtShell = 0;		// Auf 0 setzen, damit folgende DToren nicht drauf zugreifen
/*N*/ 	pShell = 0;
/*N*/ 	delete pHScrollbar;
/*N*/ 	delete pVScrollbar;
/*N*/     delete pHRuler;
/*N*/     delete pVRuler;
/*N*/ 	delete pTogglePageBtn;
/*N*/ 	delete pPageUpBtn;
//STRIP001 /*N*/ 	delete pNaviBtn;
/*N*/ 	delete pPageDownBtn;
//STRIP001 	delete pGlosHdl;
/*N*/ 	delete pViewImpl;
/*N*/ 	delete pEditWin;
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	DocShell rausgrabbeln ueber das FrameWindow
 --------------------------------------------------------------------*/


/*N*/ SwDocShell* SwView::GetDocShell()
/*N*/ {
/*N*/ 	SfxObjectShell* pDocShell = GetViewFrame()->GetObjectShell();
/*N*/ 	return PTR_CAST(SwDocShell, pDocShell);
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	CursorPos merken
 --------------------------------------------------------------------*/


/*N*/ void SwView::WriteUserData( String &rUserData, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	//Das Browse-Flag wird vom Sfx durchgereicht, wenn Dokumente gebrowsed
/*N*/ 	//werden (nicht zu verwechseln mit dem BrowseMode).
/*N*/ 	//Die dann gespeicherten Daten sind nicht persistent!!
/*N*/ 
/*N*/ 	const SwRect& rRect = pWrtShell->GetCharRect();
/*N*/ 	const Rectangle& rVis = GetVisArea();
/*N*/ 
/*N*/ 	rUserData = String::CreateFromInt32( rRect.Left() );
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += String::CreateFromInt32( rRect.Top() );
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += String::CreateFromInt32( pWrtShell->GetViewOptions()->GetZoom() );
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += String::CreateFromInt32( rVis.Left() );
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += String::CreateFromInt32( rVis.Top() );
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += String::CreateFromInt32( bBrowse ? LONG_MIN : rVis.Right());
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += String::CreateFromInt32( bBrowse ? LONG_MIN : rVis.Bottom());
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += String::CreateFromInt32(
/*N*/ 			(sal_uInt16)pWrtShell->GetViewOptions()->GetZoomType());//eZoom;
/*N*/ 	rUserData += ';';
/*N*/ 	rUserData += FRMTYPE_NONE == pWrtShell->GetSelFrmType() ? '0' : '1';
/*N*/ }
/*--------------------------------------------------------------------
	Beschreibung: CursorPos setzen
 --------------------------------------------------------------------*/


//STRIP001 void SwView::ReadUserData( const String &rUserData, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	if ( rUserData.GetTokenCount() > 1 &&
//STRIP001 		//Fuer Dokumente ohne Layout nur im OnlineLayout oder beim
//STRIP001 		//Forward/Backward
//STRIP001 		 (!pWrtShell->IsNewLayout() || pWrtShell->IsBrowseMode() || bBrowse) )
//STRIP001 	{
//STRIP001 		SET_CURR_SHELL(pWrtShell);
//STRIP001 
//STRIP001 		sal_uInt16 nPos = 0;
//STRIP001 
//STRIP001 		// Nein, es ist *keine* gute Idee GetToken gleich im Point-Konstr.
//STRIP001 		// aufzurufen, denn welcher Parameter wird zuerst ausgewertet?
//STRIP001 		long nX = rUserData.GetToken( 0, ';', nPos ).ToInt32(),
//STRIP001 			 nY = rUserData.GetToken( 0, ';', nPos ).ToInt32();
//STRIP001 		Point aCrsrPos( nX, nY );
//STRIP001 
//STRIP001 		sal_uInt16 nZoomFactor	= rUserData.GetToken(0, ';', nPos ).ToInt32();
//STRIP001 
//STRIP001 		long nLeft	= rUserData.GetToken(0, ';', nPos ).ToInt32(),
//STRIP001 			 nTop	= rUserData.GetToken(0, ';', nPos ).ToInt32(),
//STRIP001 			 nRight = rUserData.GetToken(0, ';', nPos ).ToInt32(),
//STRIP001 			 nBottom= rUserData.GetToken(0, ';', nPos ).ToInt32();
//STRIP001 
//STRIP001 		const long nAdd = pWrtShell->IsBrowseMode() ? DOCUMENTBORDER : DOCUMENTBORDER*2;
//STRIP001 		if ( nBottom <= (pWrtShell->GetDocSize().Height()+nAdd) )
//STRIP001 		{
//STRIP001 			pWrtShell->EnableSmooth( sal_False );
//STRIP001 
//STRIP001 			const Rectangle aVis( nLeft, nTop, nRight, nBottom );
//STRIP001 
//STRIP001 			sal_uInt16 nOff = 0;
//STRIP001 			SvxZoomType eZoom;
//STRIP001 			if( !pWrtShell->GetDoc()->IsBrowseMode() )
//STRIP001 				eZoom = (SvxZoomType) (sal_uInt16)rUserData.GetToken(nOff, ';', nPos ).ToInt32();
//STRIP001 			else
//STRIP001 			{
//STRIP001 				eZoom = SVX_ZOOM_PERCENT;
//STRIP001 				++nOff;
//STRIP001 			}
//STRIP001 
//STRIP001 			sal_Bool bSelectObj = (0 != rUserData.GetToken( nOff, ';', nPos ).ToInt32())
//STRIP001 								&& pWrtShell->IsObjSelectable( aCrsrPos );
//STRIP001 
//STRIP001             // OD 11.02.2003 #100556# - set flag value to avoid macro execution.
//STRIP001             bool bSavedFlagValue = pWrtShell->IsMacroExecAllowed();
//STRIP001             pWrtShell->SetMacroExecAllowed( false );
//STRIP001             pWrtShell->SwCrsrShell::SetCrsr( aCrsrPos, !bSelectObj );
//STRIP001 			if( bSelectObj )
//STRIP001 			{
//STRIP001 				pWrtShell->SelectObj( aCrsrPos );
//STRIP001 				pWrtShell->EnterSelFrmMode( &aCrsrPos );
//STRIP001 			}
//STRIP001             // OD 11.02.2003 #100556# - reset flag value
//STRIP001             pWrtShell->SetMacroExecAllowed( bSavedFlagValue );
//STRIP001 
//STRIP001             // OD 08.04.2003 #108693# - set visible area before applying
//STRIP001             // information from print preview. Otherwise, the applied information
//STRIP001             // is lost.
//STRIP001             if ( bBrowse )
//STRIP001                 SetVisArea( aVis.TopLeft() );
//STRIP001             else
//STRIP001                 SetVisArea( aVis );
//STRIP001             //apply information from print preview - if available
//STRIP001 			if( sNewCrsrPos.Len() )
//STRIP001 			{
//STRIP001 				long nX = sNewCrsrPos.GetToken( 0, ';' ).ToInt32(),
//STRIP001 				 	 nY = sNewCrsrPos.GetToken( 1, ';' ).ToInt32();
//STRIP001                 Point aCrsrPos( nX, nY );
//STRIP001                 bSelectObj = pWrtShell->IsObjSelectable( aCrsrPos );
//STRIP001                 pWrtShell->SwCrsrShell::SetCrsr( aCrsrPos, FALSE );
//STRIP001                 if( bSelectObj )
//STRIP001                 {
//STRIP001                     pWrtShell->SelectObj( aCrsrPos );
//STRIP001                     pWrtShell->EnterSelFrmMode( &aCrsrPos );
//STRIP001                 }
//STRIP001                 sNewCrsrPos.Erase();
//STRIP001 			}
//STRIP001             else if(USHRT_MAX != nNewPage)
//STRIP001             {
//STRIP001                 pWrtShell->GotoPage(nNewPage);
//STRIP001                 nNewPage = USHRT_MAX;
//STRIP001             }
//STRIP001 
//STRIP001 			SelectShell();
//STRIP001 
//STRIP001 			pWrtShell->StartAction();
//STRIP001 			const SwViewOption* pVOpt = pWrtShell->GetViewOptions();
//STRIP001 			if( pVOpt->GetZoom() != nZoomFactor || pVOpt->GetZoomType() != eZoom )
//STRIP001 				SetZoom( eZoom, nZoomFactor);
//STRIP001 
//STRIP001 			pWrtShell->LockView( sal_True );
//STRIP001 			pWrtShell->EndAction();
//STRIP001 			pWrtShell->LockView( sal_False );
//STRIP001 			pWrtShell->EnableSmooth( sal_True );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwView::ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
//STRIP001 {
//STRIP001     if(GetDocShell()->IsPreview())
//STRIP001         return;
//STRIP001     sal_Int32 nLength = rSequence.getLength();
//STRIP001     if (nLength && (!pWrtShell->IsNewLayout() || pWrtShell->IsBrowseMode() || bBrowse) )
//STRIP001     {
//STRIP001 		SET_CURR_SHELL(pWrtShell);
//STRIP001         const ::com::sun::star::beans::PropertyValue *pValue = rSequence.getConstArray();
//STRIP001 		const SwRect& rRect = pWrtShell->GetCharRect();
//STRIP001 		const Rectangle &rVis = GetVisArea();
//STRIP001 
//STRIP001         long nX = rRect.Left(), nY = rRect.Top(), nLeft = rVis.Left(), nTop = rVis.Top();
//STRIP001 		long nRight = bBrowse ? LONG_MIN : rVis.Right(), nBottom = bBrowse ? LONG_MIN : rVis.Bottom();
//STRIP001         sal_Int16 nZoomType = pWrtShell->GetViewOptions()->GetZoomType();
//STRIP001 		sal_Int16 nZoomFactor = static_cast < sal_Int16 > (pWrtShell->GetViewOptions()->GetZoom());
//STRIP001         sal_Bool bSelectedFrame = pWrtShell->GetSelFrmType(), bGotViewLeft = sal_False, bGotViewTop = sal_False,
//STRIP001 				 bGotVisibleLeft = sal_False, bGotVisibleTop = sal_False, bGotVisibleRight = sal_False,
//STRIP001 				 bGotVisibleBottom = sal_False, bGotZoomType = sal_False, bGotZoomFactor = sal_False,
//STRIP001 				 bGotIsSelectedFrame = sal_False;
//STRIP001 
//STRIP001         for (sal_Int16 i = 0 ; i < nLength; i++)
//STRIP001         {
//STRIP001             if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "ViewLeft" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nX;
//STRIP001 			   nX = MM100_TO_TWIP( nX );
//STRIP001 			   bGotViewLeft = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "ViewTop" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nY;
//STRIP001 			   nY = MM100_TO_TWIP( nY );
//STRIP001 			   bGotViewTop = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "VisibleLeft" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nLeft;
//STRIP001 			   nLeft = MM100_TO_TWIP( nLeft );
//STRIP001 			   bGotVisibleLeft = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "VisibleTop" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nTop;
//STRIP001 			   nTop = MM100_TO_TWIP( nTop );
//STRIP001 			   bGotVisibleTop = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "VisibleRight" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nRight;
//STRIP001 			   nRight = MM100_TO_TWIP( nRight );
//STRIP001 			   bGotVisibleRight = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "VisibleBottom" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nBottom;
//STRIP001 			   nBottom = MM100_TO_TWIP( nBottom );
//STRIP001 			   bGotVisibleBottom = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "ZoomType" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nZoomType;
//STRIP001 			   bGotZoomType = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "ZoomFactor" ) ) )
//STRIP001             {
//STRIP001                pValue->Value >>= nZoomFactor;
//STRIP001 			   bGotZoomFactor = sal_True;
//STRIP001             }
//STRIP001             else if (pValue->Name.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( "IsSelectedFrame" ) ) )
//STRIP001             {
//STRIP001                bSelectedFrame = * (sal_Bool *) pValue->Value.getValue();
//STRIP001 			   bGotIsSelectedFrame = sal_True;
//STRIP001             }
//STRIP001             pValue++;
//STRIP001         }
//STRIP001 		if (bGotVisibleBottom)
//STRIP001 		{
//STRIP001 			Point aCrsrPos( nX, nY );
//STRIP001 			const long nAdd = pWrtShell->IsBrowseMode() ? DOCUMENTBORDER : DOCUMENTBORDER*2;
//STRIP001 			if (nBottom <= (pWrtShell->GetDocSize().Height()+nAdd) )
//STRIP001 			{
//STRIP001 				pWrtShell->EnableSmooth( sal_False );
//STRIP001 				const Rectangle aVis( nLeft, nTop, nRight, nBottom );
//STRIP001 
//STRIP001 				sal_uInt16 nOff = 0;
//STRIP001 				SvxZoomType eZoom;
//STRIP001 				if( !pWrtShell->GetDoc()->IsBrowseMode() )
//STRIP001 					eZoom = static_cast < SvxZoomType > ( nZoomType );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					eZoom = SVX_ZOOM_PERCENT;
//STRIP001 					++nOff;
//STRIP001 				}
//STRIP001 				if (bGotIsSelectedFrame)
//STRIP001 				{
//STRIP001 					sal_Bool bSelectObj = (sal_False != bSelectedFrame )
//STRIP001 										&& pWrtShell->IsObjSelectable( aCrsrPos );
//STRIP001 
//STRIP001                     // OD 11.02.2003 #100556# - set flag value to avoid macro execution.
//STRIP001                     bool bSavedFlagValue = pWrtShell->IsMacroExecAllowed();
//STRIP001                     pWrtShell->SetMacroExecAllowed( false );
//STRIP001 					pWrtShell->SwCrsrShell::SetCrsr( aCrsrPos, !bSelectObj );
//STRIP001 					if( bSelectObj )
//STRIP001 					{
//STRIP001 						pWrtShell->SelectObj( aCrsrPos );
//STRIP001 						pWrtShell->EnterSelFrmMode( &aCrsrPos );
//STRIP001 					}
//STRIP001                     // OD 11.02.2003 #100556# - reset flag value
//STRIP001                     pWrtShell->SetMacroExecAllowed( bSavedFlagValue );
//STRIP001 				}
//STRIP001 				SelectShell();
//STRIP001 
//STRIP001 				pWrtShell->StartAction();
//STRIP001 				const SwViewOption* pVOpt = pWrtShell->GetViewOptions();
//STRIP001 				if ( bGotZoomType && bGotZoomFactor &&
//STRIP001 				   ( pVOpt->GetZoom() != nZoomFactor || pVOpt->GetZoomType() != eZoom ) )
//STRIP001 					SetZoom( eZoom, nZoomFactor, sal_True );
//STRIP001 				if ( bBrowse && bGotVisibleLeft && bGotVisibleTop )
//STRIP001                 {
//STRIP001                     Point aTopLeft(aVis.TopLeft());
//STRIP001                     //check if the values are possible
//STRIP001                     long nXMax = pHScrollbar->GetRangeMax() - pHScrollbar->GetVisibleSize();
//STRIP001                     if( aTopLeft.X() > nXMax )
//STRIP001                         aTopLeft.X() = nXMax < 0 ? 0 : nXMax;
//STRIP001                     SetVisArea( aTopLeft );
//STRIP001                 }
//STRIP001 				else if (bGotVisibleLeft && bGotVisibleTop && bGotVisibleRight && bGotVisibleBottom )
//STRIP001 					SetVisArea( aVis );
//STRIP001 
//STRIP001 				pWrtShell->LockView( sal_True );
//STRIP001 				pWrtShell->EndAction();
//STRIP001 				pWrtShell->LockView( sal_False );
//STRIP001 				pWrtShell->EnableSmooth( sal_True );
//STRIP001 			}
//STRIP001 		}
//STRIP001     }
//STRIP001 }
#define NUM_VIEW_SETTINGS 10
/*N*/ void SwView::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	const SwRect& rRect = pWrtShell->GetCharRect();
/*N*/ 	const Rectangle& rVis = GetVisArea();
/*N*/     Any aAny;
/*N*/ 
/*N*/     rSequence.realloc ( NUM_VIEW_SETTINGS );
/*N*/     sal_Int16 nIndex = 0;
/*N*/     ::com::sun::star::beans::PropertyValue *pValue = rSequence.getArray();
/*N*/ 
/*N*/     sal_uInt16 nViewID( GetViewFrame()->GetCurViewId());
/*N*/ 	pValue->Name = ::rtl::OUString ( RTL_CONSTASCII_USTRINGPARAM( "ViewId" ) );
/*N*/ 	OUStringBuffer sBuffer ( OUString(RTL_CONSTASCII_USTRINGPARAM( "view" ) ) );
/*N*/ 	SvXMLUnitConverter::convertNumber(sBuffer, static_cast<sal_Int32>(nViewID));
/*N*/ 	pValue->Value <<= sBuffer.makeStringAndClear();
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "ViewLeft" ) );
/*N*/     pValue->Value <<= TWIP_TO_MM100 ( rRect.Left() );
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "ViewTop" ) );
/*N*/     pValue->Value <<= TWIP_TO_MM100 ( rRect.Top() );
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "VisibleLeft" ) );
/*N*/     pValue->Value <<= TWIP_TO_MM100 ( rVis.Left() );
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "VisibleTop" ) );
/*N*/     pValue->Value <<= TWIP_TO_MM100 ( rVis.Top() );
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "VisibleRight" ) );
/*N*/     pValue->Value <<= TWIP_TO_MM100 ( bBrowse ? LONG_MIN : rVis.Right() );
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "VisibleBottom" ) );
/*N*/     pValue->Value <<= TWIP_TO_MM100 ( bBrowse ? LONG_MIN : rVis.Bottom() );
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/ 	sal_Int16 nInt16 = pWrtShell->GetViewOptions()->GetZoomType();
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "ZoomType" ) );
/*N*/     pValue->Value <<= nInt16;
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "ZoomFactor" ) );
/*N*/     pValue->Value <<= static_cast < sal_Int16 > (pWrtShell->GetViewOptions()->GetZoom());
/*N*/     pValue++;nIndex++;
/*N*/ 
/*N*/     pValue->Name = OUString ( RTL_CONSTASCII_USTRINGPARAM ( "IsSelectedFrame" ) );
/*N*/ 	sal_Bool bIsSelected = FRMTYPE_NONE == pWrtShell->GetSelFrmType() ? sal_False : sal_True;
/*N*/     pValue->Value.setValue ( &bIsSelected, ::getBooleanCppuType() );
/*N*/ 	nIndex++;
/*N*/ 
/*N*/     if ( nIndex < NUM_VIEW_SETTINGS )
/*N*/         rSequence.realloc ( nIndex );
/*N*/ }
/*N*/ #undef NUM_VIEW_SETTINGS



/*N*/ void SwView::ShowCursor( FASTBOOL bOn )
/*N*/ {
/*N*/ 	//JP 10.10.2001: Bug 90461 - don't scroll the cursor into the visible area
/*N*/ 	BOOL bUnlockView = !pWrtShell->IsViewLocked();
/*N*/ 	pWrtShell->LockView( TRUE );	//lock visible section
/*N*/ 
/*N*/ 	if( !bOn )
/*N*/ 		pWrtShell->HideCrsr();
/*N*/ 	else if( !pWrtShell->IsFrmSelected() && !pWrtShell->IsObjSelected() )
/*N*/ 		pWrtShell->ShowCrsr();
/*N*/ 
/*N*/ 	if( bUnlockView )
/*N*/ 		pWrtShell->LockView( FALSE );
/*N*/ }



//STRIP001 ErrCode SwView::DoVerb( long nVerb )
//STRIP001 {
//STRIP001 	if ( !GetDocShell()->GetProtocol().IsInPlaceActive() )
//STRIP001 	{
//STRIP001 		SwWrtShell &rSh = GetWrtShell();
//STRIP001 		const int nSel = rSh.GetSelectionType();
//STRIP001 		if ( nSel & SwWrtShell::SEL_OLE )
//STRIP001 			rSh.LaunchOLEObj( nVerb );
//STRIP001 	}
//STRIP001 	return ERRCODE_NONE;
//STRIP001 }

/*-----------------17.02.98 13:33-------------------
	nur sal_True fuer eine Textselektion zurueck geben
--------------------------------------------------*/
//STRIP001 sal_Bool SwView::HasSelection( sal_Bool  bText ) const
//STRIP001 {
//STRIP001 	return bText ? GetWrtShell().SwCrsrShell::HasSelection()
//STRIP001 				 : GetWrtShell().HasSelection();
//STRIP001 }

/*-----------------09/16/97 09:50am-----------------

--------------------------------------------------*/

//STRIP001 String SwView::GetSelectionText( sal_Bool bCompleteWrds )
//STRIP001 {
//STRIP001 	return GetSelectionTextParam( bCompleteWrds, sal_True );
//STRIP001 }

/*-----------------09/16/97 09:50am-----------------

--------------------------------------------------*/
//STRIP001 String	SwView::GetSelectionTextParam( sal_Bool bCompleteWrds,
//STRIP001 									   sal_Bool bEraseTrail )
//STRIP001 {
//STRIP001 	String sReturn;
//STRIP001 	if( bCompleteWrds && !GetWrtShell().HasSelection() )
//STRIP001 		GetWrtShell().SelWrd();
//STRIP001 
//STRIP001 	GetWrtShell().GetSelectedText( sReturn );
//STRIP001 	if( bEraseTrail )
//STRIP001 		sReturn.EraseTrailingChars();
//STRIP001 	return sReturn;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/



//STRIP001 SwGlossaryHdl* SwView::GetGlosHdl()
//STRIP001 {
//STRIP001 	if(!pGlosHdl)
//STRIP001 		pGlosHdl = new SwGlossaryHdl(GetViewFrame(), pWrtShell);
//STRIP001 	return pGlosHdl;
//STRIP001 }

/*-----------------05.09.96 15.50-------------------

--------------------------------------------------*/



/*N*/ void SwView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	FASTBOOL bCallBase = sal_True;
/*N*/ 	if ( rHint.ISA(SfxSimpleHint) )
/*N*/ 	{
/*N*/ 		sal_uInt32 nId = ((SfxSimpleHint&)rHint).GetId();
/*N*/ 		switch ( nId )
/*N*/ 		{
/*N*/ 			case SFX_HINT_MODECHANGED:
/*N*/ 				{
/*N*/ 					// Modalmodus-Umschaltung?
/*N*/ 					sal_Bool bModal = GetDocShell()->IsInModalMode();
/*N*/                     pHRuler->SetActive( !bModal );
/*N*/                     pVRuler->SetActive( !bModal );
/*N*/ 				}
/*N*/ 
/*N*/ 				/* kein break hier */
/*N*/ 
/*N*/ 			case SFX_HINT_TITLECHANGED:
/*N*/ 				if ( GetDocShell()->IsReadOnly() != GetWrtShell().GetViewOptions()->IsReadonly() )
/*N*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 					SwWrtShell &rSh = GetWrtShell();
//STRIP001 /*?*/ 					rSh.SetReadonlyOption( GetDocShell()->IsReadOnly() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/                     if ( rSh.GetViewOptions()->IsViewVRuler() )
//STRIP001 /*?*/                         CreateVLineal();
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/                         KillVLineal();
//STRIP001 /*?*/                     if ( rSh.GetViewOptions()->IsViewHRuler() )
//STRIP001 /*?*/                         CreateTab();
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/                         KillTab();
//STRIP001 /*?*/ 					SfxBoolItem aItem( SID_FM_DESIGN_MODE, !GetDocShell()->IsReadOnly());
//STRIP001 /*?*/ 					GetDispatcher().Execute( SID_FM_DESIGN_MODE, SFX_CALLMODE_ASYNCHRON,
//STRIP001 /*?*/ 												&aItem, 0L );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SW_BROADCAST_DRAWVIEWS_CREATED:
/*N*/ 				{
/*N*/ 					bCallBase = sal_False;
/*N*/ 					if ( GetFormShell() )
/*N*/ 					{
/*?*/ 						GetFormShell()->SetView(
/*?*/ 							PTR_CAST(FmFormView, GetWrtShell().GetDrawView()) );
/*?*/ 						SfxBoolItem aItem( SID_FM_DESIGN_MODE, !GetDocShell()->IsReadOnly());
/*?*/ 						GetDispatcher().Execute( SID_FM_DESIGN_MODE, SFX_CALLMODE_ASYNCHRON,
/*?*/ 												  &aItem, 0L );
/*N*/ 					}
/*N*/ 				}
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if(rHint.ISA(FmDesignModeChangedHint))
/*N*/ 	{
/*N*/ 		sal_Bool bDesignMode = ((FmDesignModeChangedHint&)rHint).GetDesignMode();
/*N*/ 		if (!bDesignMode && GetDrawFuncPtr())
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			GetDrawFuncPtr()->Deactivate();
//STRIP001 /*?*/ 			SetDrawFuncPtr(NULL);
//STRIP001 /*?*/ 			LeaveDrawCreate();
//STRIP001 /*?*/ 			AttrChangedNotify(pWrtShell);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bCallBase )
/*N*/ 		SfxViewShell::Notify(rBC, rHint);
/*N*/ }

/*-----------------02.12.96 12:36-------------------

--------------------------------------------------*/
#if defined WIN || defined WNT || defined UNX

//STRIP001 void SwView::ScannerEventHdl( const EventObject& rEventObject )
//STRIP001 {
//STRIP001 	Reference< XScannerManager > xScanMgr = SW_MOD()->GetScannerManager();
//STRIP001 	if( xScanMgr.is() )
//STRIP001 	{
//STRIP001 		const ScannerContext	aContext( xScanMgr->getAvailableScanners().getConstArray()[ 0 ] );
//STRIP001 		const ScanError			eError = xScanMgr->getError( aContext );
//STRIP001 
//STRIP001 		if( ScanError_ScanErrorNone == eError )
//STRIP001 		{
//STRIP001 			const uno::Reference< awt::XBitmap > xBitmap( xScanMgr->getBitmap( aContext ) );
//STRIP001 
//STRIP001 			if( xBitmap.is() )
//STRIP001 			{
//STRIP001 				const BitmapEx aScanBmp( VCLUnoHelper::GetBitmap( xBitmap ) );
//STRIP001 
//STRIP001 				if( !!aScanBmp )
//STRIP001 				{
//STRIP001 					Graphic aGrf(aScanBmp);
//STRIP001 					pWrtShell->Insert( aEmptyStr, aEmptyStr, aGrf );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SfxBindings& rBind = GetViewFrame()->GetBindings();
//STRIP001 	rBind.Invalidate( SID_TWAIN_SELECT );
//STRIP001 	rBind.Invalidate( SID_TWAIN_TRANSFER );
//STRIP001 //JP 26.06.00: the appwindow doen't exist
//STRIP001 //	Application::GetAppWindow()->EnableInput( TRUE );
//STRIP001 }
#endif

/*-----------------04.03.97 15:07-------------------

--------------------------------------------------*/


/*N*/ void	SwView::StopShellTimer()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if(aTimer.IsActive())
//STRIP001 	{
//STRIP001 		aTimer.Stop();
//STRIP001 		if ( bAttrChgNotifiedWithRegistrations )
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetBindings().LEAVEREGISTRATIONS();
//STRIP001 			bAttrChgNotifiedWithRegistrations = sal_False;
//STRIP001 		}
//STRIP001 		SelectShell();
//STRIP001 		bAttrChgNotified = sal_False;
//STRIP001 	}
/*N*/ }

/*-----------------15.12.97 10:15-------------------

--------------------------------------------------*/
//STRIP001 void SwView::PrepareGetSelection()
//STRIP001 {
//STRIP001 	if(!pShell)
//STRIP001 		SelectShell();
//STRIP001 }

/*-----------------09/03/97 04:12pm-----------------

--------------------------------------------------*/
/*N*/ sal_uInt16  SwView::PrepareClose( sal_Bool bUI, sal_Bool bForBrowsing )
/*N*/ {
/*N*/ 	SfxViewFrame* pVFrame = GetViewFrame();
/*N*/ 	SfxApplication* pSfxApp = SFX_APP();
/*N*/ 	pVFrame->SetChildWindow( SwInputChild::GetChildWindowId(), sal_False );
/*N*/ 	if(pSfxApp->IsDispatcherLocked())
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pSfxApp->LockDispatcher(sal_False);
/*N*/ 	pVFrame->SetChildWindow( SwInsertChartChild::GetChildWindowId(), sal_False );
/*N*/ 
/*N*/ 	sal_uInt16 nRet;
/*N*/ 	if ( pFormShell &&
/*N*/ 		 sal_True != (nRet = pFormShell->PrepareClose( bUI, bForBrowsing )) )
/*N*/ 
/*N*/ 	{
/*N*/ 		return nRet;
/*N*/ 	}
/*N*/ 	return SfxViewShell::PrepareClose( bUI, bForBrowsing );
/*N*/ }



	// status methods for clipboard.
	// Status changes now notified from the clipboard.
/*N*/ BOOL SwView::IsPasteAllowed()
/*N*/ {
/*N*/ 	USHORT nPasteDestination = SwTransferable::GetSotDestination( *pWrtShell );
/*N*/ 	if( nLastPasteDestination != nPasteDestination )
/*N*/ 	{
/*N*/ 		TransferableDataHelper aDataHelper(
/*N*/ 						TransferableDataHelper::CreateFromSystemClipboard(
/*N*/ 														&GetEditWin()) );
/*N*/ 		if( aDataHelper.GetXTransferable().is() )
/*N*/ 		{
/*N*/ 			bPasteState = SwTransferable::IsPaste( *pWrtShell, aDataHelper );
/*N*/ 			bPasteSpecialState = SwTransferable::IsPasteSpecial(
/*N*/ 													*pWrtShell, aDataHelper );
/*N*/ 		}
/*N*/ 		else
/*N*/ 			bPasteState = bPasteSpecialState = FALSE;
/*N*/ 
/*N*/ 		if( 0xFFFF == nLastPasteDestination )  // the init value
/*N*/ 			pViewImpl->AddClipboardListener();
/*N*/ 		nLastPasteDestination = nPasteDestination;
/*N*/ 	}
/*N*/ 	return bPasteState;
/*N*/ }

//STRIP001 BOOL SwView::IsPasteSpecialAllowed()
//STRIP001 {
//STRIP001 	USHORT nPasteDestination = SwTransferable::GetSotDestination( *pWrtShell );
//STRIP001 	if( nLastPasteDestination != nPasteDestination )
//STRIP001 	{
//STRIP001 		TransferableDataHelper aDataHelper(
//STRIP001 						TransferableDataHelper::CreateFromSystemClipboard(
//STRIP001 														&GetEditWin()) );
//STRIP001 		if( aDataHelper.GetXTransferable().is() )
//STRIP001 		{
//STRIP001 			bPasteState = SwTransferable::IsPaste( *pWrtShell, aDataHelper );
//STRIP001 			bPasteSpecialState = SwTransferable::IsPasteSpecial(
//STRIP001 													*pWrtShell, aDataHelper );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bPasteState = bPasteSpecialState = FALSE;
//STRIP001 
//STRIP001 		if( 0xFFFF == nLastPasteDestination )  // the init value
//STRIP001 			pViewImpl->AddClipboardListener();
//STRIP001 	}
//STRIP001 	return bPasteSpecialState;
//STRIP001 }
/* -----------------------------12.07.01 13:25--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwView::NotifyDBChanged()
//STRIP001 {
//STRIP001     GetViewImpl()->GetUNOObject_Impl()->NotifyDBChanged();
//STRIP001 }

/*--------------------------------------------------------------------
    Beschreibung:   Drucken
 --------------------------------------------------------------------*/

/*N*/ void SwView::MakeOptions( PrintDialog* pDlg, SwPrtOptions& rOpts,
/*N*/         BOOL* pPrtProspect, BOOL bWeb, SfxPrinter* pPrt, SwPrintData* pData )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/     SwAddPrinterItem* pAddPrinterAttr;
//STRIP001 /*?*/     if( pPrt && SFX_ITEM_SET == pPrt->GetOptions().GetItemState(
//STRIP001 /*?*/         FN_PARAM_ADDPRINTER, FALSE, (const SfxPoolItem**)&pAddPrinterAttr ))
//STRIP001 /*?*/     {
//STRIP001 /*?*/         pData = pAddPrinterAttr;
//STRIP001 /*?*/     }
//STRIP001 /*?*/     else if(!pData)
//STRIP001 /*?*/     {
//STRIP001 /*?*/         pData = SW_MOD()->GetPrtOptions(bWeb);
//STRIP001 /*?*/     }
//STRIP001 /*?*/     rOpts = *pData;
//STRIP001 /*?*/     if( pPrtProspect )
//STRIP001 /*?*/         *pPrtProspect = pData->bPrintProspect;
//STRIP001 /*?*/     rOpts.aMulti.SetTotalRange( Range( 0, RANGE_MAX ) );
//STRIP001 /*?*/     rOpts.aMulti.SelectAll( FALSE );
//STRIP001 /*?*/     rOpts.nCopyCount = 1;
//STRIP001 /*?*/     rOpts.bCollate = FALSE;
//STRIP001 /*?*/     rOpts.bPrintSelection = FALSE;
//STRIP001 /*?*/     rOpts.bJobStartet = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/     if ( pDlg )
//STRIP001 /*?*/     {
//STRIP001 /*?*/         rOpts.nCopyCount = pDlg->GetCopyCount();
//STRIP001 /*?*/         rOpts.bCollate = pDlg->IsCollateChecked();
//STRIP001 /*?*/         if ( pDlg->GetCheckedRange() == PRINTDIALOG_SELECTION )
//STRIP001 /*?*/         {
//STRIP001 /*?*/             rOpts.aMulti.SelectAll();
//STRIP001 /*?*/             rOpts.bPrintSelection = TRUE;
//STRIP001 /*?*/         }
//STRIP001 /*?*/         else if ( PRINTDIALOG_ALL == pDlg->GetCheckedRange() )
//STRIP001 /*?*/             rOpts.aMulti.SelectAll();
//STRIP001 /*?*/         else
//STRIP001 /*?*/         {
//STRIP001 /*?*/             rOpts.aMulti = MultiSelection( pDlg->GetRangeText() );
//STRIP001 /*?*/             rOpts.aMulti.SetTotalRange( Range( 0, RANGE_MAX ) );
//STRIP001 /*?*/         }
//STRIP001 /*?*/     }
//STRIP001 /*?*/     else
//STRIP001 /*?*/         rOpts.aMulti.SelectAll();
//STRIP001 /*?*/     rOpts.aMulti.Select( 0, FALSE );
/*N*/ }

/* -----------------------------28.10.02 13:25--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ SfxObjectShellRef & SwView::GetTmpSelectionDoc()
/*N*/ {
/*N*/     return GetViewImpl()->GetTmpSelectionDoc();
/*N*/ }
/* -----------------------------31.10.02 13:25--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ SfxObjectShellRef & SwView::GetOrCreateTmpSelectionDoc()
/*N*/ {
/*N*/     SfxObjectShellRef &rxTmpDoc = GetViewImpl()->GetTmpSelectionDoc();
/*N*/     if (!rxTmpDoc.Is())
/*N*/     {
/*N*/         SwXTextView *pImpl = GetViewImpl()->GetUNOObject_Impl();
/*N*/         rxTmpDoc = pImpl->BuildTmpSelectionDoc(
/*N*/                     GetViewImpl()->GetEmbeddedObjRef() );
/*N*/     }
/*N*/     return rxTmpDoc;
/*N*/ }
/* -----------------3/31/2003 12:39PM----------------

 --------------------------------------------------*/
//STRIP001 void SwView::AddTransferable(SwTransferable& rTransferable)
//STRIP001 {
//STRIP001     GetViewImpl()->AddTransferable(rTransferable);
//STRIP001 }            
}
