/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_srcview.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:48:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _UIPARAM_HXX
#include <uiparam.hxx>
#endif

#ifndef _COM_SUN_STAR_UTIL_SEARCHOPTIONS_HPP_
#include <com/sun/star/util/SearchOptions.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_SEARCHFLAGS_HPP_
#include <com/sun/star/util/SearchFlags.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
#include <com/sun/star/i18n/TransliterationModules.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
#include <com/sun/star/lang/Locale.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_TEMPLATEDESCRIPTION_HPP_
#include <com/sun/star/ui/dialogs/TemplateDescription.hpp>
#endif

#ifndef _UNOTOOLS_TEMPFILE_HXX
#include <unotools/tempfile.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_PRINT_HXX //autogen
#include <vcl/print.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_METRIC_HXX //autogen
#include <vcl/metric.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _UNDO_HXX //autogen
#include <svtools/undo.hxx>
#endif
#ifndef _TXTCMP_HXX //autogen
#include <svtools/txtcmp.hxx>
#endif
//STRIP001 #ifndef _EXTATTR_HXX //autogen
//STRIP001 #include <svtools/extattr.hxx>
//STRIP001 #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_SAVEOPT_HXX
#include <svtools/saveopt.hxx>
#endif
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif

#ifndef _OFA_HTMLCFG_HXX //autogen
#include <bf_offmgr/htmlcfg.hxx>
#endif
#ifndef _OFF_APP_HXX //autogen
#include <bf_offmgr/app.hxx>
#endif
#ifndef _SFX_DOCFILT_HACK_HXX //autogen
#include <bf_sfx2/docfilt.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFX_PRNMON_HXX //autogen
#include <bf_sfx2/prnmon.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <bf_sfx2/printer.hxx>
#endif
#ifndef _SFXDOCINF_HXX //autogen
#include <bf_sfx2/docinf.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <bf_svx/fhgtitem.hxx>
#endif
#ifndef _SVX_SRCHDLG_HXX //autogen
#include <bf_svx/srchdlg.hxx>
#endif
#ifndef _SVX_SRCHITEM_HXX //autogen
#include <bf_svx/srchitem.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <bf_svx/fontitem.hxx>
#endif
#ifndef _SVX_FLSTITEM_HXX //autogen
#include <bf_svx/flstitem.hxx>
#endif
#ifndef _RTL_TENCINFO_H
#include <rtl/tencinfo.h>
#endif

#ifndef _SFXHTML_HXX
#include <bf_sfx2/sfxhtml.hxx>
#endif

#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _WDOCSH_HXX
#include <wdocsh.hxx>
#endif
#ifndef _SRCVIEW_HXX
#include <srcview.hxx>
#endif
#ifndef _VIEWFUNC_HXX
#include <viewfunc.hxx>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _ITEMDEF_HXX
#include <itemdef.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>          // FN_       ...
#endif
#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#ifndef _SHELLS_HRC
#include <shells.hrc>
#endif
#ifndef _POPUP_HRC
#include <popup.hrc>
#endif
#ifndef _WEB_HRC
#include <web.hrc>
#endif
#ifndef _VIEW_HRC
#include <view.hrc>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILEPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFilePicker.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILTERMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterManager.hpp>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif

#define SwSrcView
#define SearchSettings
#define _ExecSearch Execute
#define _StateSearch GetState


#include "so3/staticbaseurl.hxx"
namespace binfilter {
#include <bf_svx/svxslots.hxx>
#include "swslots.hxx"
using namespace ::com::sun::star;
using namespace ::com::sun::star::i18n;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::i18n;
using namespace ::com::sun::star::lang;
using namespace ::rtl;
using namespace sfx2;

#define C2S(cChar) UniString::CreateFromAscii(cChar)

#define SWSRCVIEWFLAGS ( SFX_VIEW_MAXIMIZE_FIRST|			\
					  SFX_VIEW_OBJECTSIZE_EMBEDDED| 	\
					  SFX_VIEW_CAN_PRINT|\
					  SFX_VIEW_NO_NEWWINDOW )

#define SRC_SEARCHOPTIONS (0xFFFF & ~(SEARCH_OPTIONS_FORMAT|SEARCH_OPTIONS_FAMILIES|SEARCH_OPTIONS_SEARCH_ALL))

// Druckraender -> wie Basic - Ide
#define LMARGPRN		1700
#define RMARGPRN		 900
#define TMARGPRN    	2000
#define BMARGPRN    	1000
#define BORDERPRN		300



/*N*/ SFX_IMPL_VIEWFACTORY(SwSrcView, SW_RES(STR_NONAME))
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(SwWebDocShell);
/*N*/ }


/*N*/ SFX_IMPL_INTERFACE( SwSrcView, SfxViewShell, SW_RES(0) )
/*N*/ {
/*N*/ 	SFX_POPUPMENU_REGISTRATION(SW_RES(MN_SRCVIEW_POPUPMENU));
/*N*/ 	SFX_OBJECTBAR_REGISTRATION(	SFX_OBJECTBAR_TOOLS|
/*N*/ 								SFX_VISIBILITY_STANDARD|SFX_VISIBILITY_SERVER,
/*N*/ 								SW_RES(RID_WEBTOOLS_TOOLBOX) );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION(SvxSearchDialogWrapper::GetChildWindowId());
/*N*/ }

//STRIP001 TYPEINIT1(SwSrcView, SfxViewShell)

/*-----------------18.11.96 08.05-------------------

--------------------------------------------------*/


//STRIP001 void lcl_PrintHeader( Printer* pPrinter, USHORT nPages, USHORT nCurPage, const String& rTitle )
//STRIP001 {
//STRIP001 	short nLeftMargin 	= LMARGPRN;
//STRIP001 	Size aSz = pPrinter->GetOutputSize();
//STRIP001 	short nBorder = BORDERPRN;
//STRIP001 
//STRIP001 	Color aOldFillColor( pPrinter->GetFillColor() );
//STRIP001 	Font aOldFont( pPrinter->GetFont() );
//STRIP001 
//STRIP001 	pPrinter->SetFillColor( Color(COL_TRANSPARENT) );
//STRIP001 
//STRIP001 	Font aFont( aOldFont );
//STRIP001 	aFont.SetWeight( WEIGHT_BOLD );
//STRIP001 	aFont.SetAlign( ALIGN_BOTTOM );
//STRIP001 	pPrinter->SetFont( aFont );
//STRIP001 
//STRIP001 	long nFontHeight = pPrinter->GetTextHeight();
//STRIP001 
//STRIP001 	// 1.Border => Strich, 2+3 Border = Freiraum.
//STRIP001 	long nYTop = TMARGPRN-3*nBorder-nFontHeight;
//STRIP001 
//STRIP001 	long nXLeft = nLeftMargin-nBorder;
//STRIP001 	long nXRight = aSz.Width()-RMARGPRN+nBorder;
//STRIP001 
//STRIP001 	pPrinter->DrawRect( Rectangle(
//STRIP001 		Point( nXLeft, nYTop ),
//STRIP001 		Size( nXRight-nXLeft, aSz.Height() - nYTop - BMARGPRN + nBorder ) ) );
//STRIP001 
//STRIP001 
//STRIP001 	long nY = TMARGPRN-2*nBorder;
//STRIP001 	Point aPos( nLeftMargin, nY );
//STRIP001 	pPrinter->DrawText( aPos, rTitle );
//STRIP001 	if ( nPages != 1 )
//STRIP001 	{
//STRIP001 		aFont.SetWeight( WEIGHT_NORMAL );
//STRIP001 		pPrinter->SetFont( aFont );
//STRIP001 		String aPageStr( C2S(" [") );
//STRIP001 		aPageStr += String( SW_RES( STR_PAGE ) );
//STRIP001 		aPageStr += ' ';
//STRIP001 		aPageStr += String::CreateFromInt32( nCurPage );
//STRIP001 		aPageStr += ']';
//STRIP001 		aPos.X() += pPrinter->GetTextWidth( rTitle );
//STRIP001 		pPrinter->DrawText( aPos, aPageStr );
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	nY = TMARGPRN-nBorder;
//STRIP001 
//STRIP001 	pPrinter->DrawLine( Point( nXLeft, nY ), Point( nXRight, nY ) );
//STRIP001 
//STRIP001 	pPrinter->SetFont( aOldFont );
//STRIP001 	pPrinter->SetFillColor( aOldFillColor );
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------18.11.96 08.21-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void lcl_ConvertTabsToSpaces( String& rLine )
//STRIP001 {
//STRIP001 	if ( rLine.Len() )
//STRIP001 	{
//STRIP001 		USHORT nPos = 0;
//STRIP001 		USHORT nMax = rLine.Len();
//STRIP001 		while ( nPos < nMax )
//STRIP001 		{
//STRIP001 			if ( rLine.GetChar(nPos) == '\t' )
//STRIP001 			{
//STRIP001 				// Nicht 4 Blanks, sondern an 4er TabPos:
//STRIP001 				String aBlanker;
//STRIP001 				aBlanker.Fill( ( 4 - ( nPos % 4 ) ), ' ' );
//STRIP001 				rLine.Erase( nPos, 1 );
//STRIP001 				rLine.Insert( aBlanker, nPos );
//STRIP001 				nMax = rLine.Len();
//STRIP001 			}
//STRIP001 			nPos++;	// Nicht optimal, falls Tab, aber auch nicht verkehrt...
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------18.11.96 12.12-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void lcl_SetFont(SwSrcView* pView, const String& rStyle)
//STRIP001 {
//STRIP001 	const SvxFontListItem* pFontListItem = (const SvxFontListItem* )pView->GetDocShell()->GetItem( SID_ATTR_CHAR_FONTLIST );
//STRIP001 	const FontList*	 pList = pFontListItem->GetFontList();
//STRIP001 
//STRIP001 	FontInfo aInfo = pList->Get(rStyle,WEIGHT_NORMAL, ITALIC_NONE);
//STRIP001 
//STRIP001 	SwSrcEditWindow& rEditWin = pView->GetEditWin();
//STRIP001 	const Font& rFont = rEditWin.GetTextEngine()->GetFont();
//STRIP001 	Font aFont(aInfo);
//STRIP001 	aFont.SetSize(rFont.GetSize());
//STRIP001 	rEditWin.GetTextEngine()->SetFont( aFont );
//STRIP001 	rEditWin.GetOutWin()->SetFont(aFont);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SwSrcView::SwSrcView(SfxViewFrame* pFrame, const SwSrcView&) :
//STRIP001 	SfxViewShell( pFrame, SWSRCVIEWFLAGS ),
//STRIP001 	aEditWin( &pFrame->GetWindow(), this ),
//STRIP001 	pSearchItem(0),
//STRIP001     bSourceSaved(FALSE),
//STRIP001     eLoadEncoding(RTL_TEXTENCODING_DONTKNOW)
//STRIP001 {
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SwSrcView::SwSrcView(SfxViewFrame* pFrame, SfxViewShell*) :
//STRIP001 	SfxViewShell( pFrame, SWSRCVIEWFLAGS ),
//STRIP001 	aEditWin( &pFrame->GetWindow(), this ),
//STRIP001 	pSearchItem(0),
//STRIP001     bSourceSaved(FALSE),
//STRIP001     eLoadEncoding(RTL_TEXTENCODING_DONTKNOW)
//STRIP001 {
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SwSrcView::~SwSrcView()
//STRIP001 {
//STRIP001 	SwDocShell* pDocShell = GetDocShell();
//STRIP001 	DBG_ASSERT(PTR_CAST(SwWebDocShell, pDocShell), "Wieso keine WebDocShell?")
//STRIP001 	TextEngine* pTextEngine = aEditWin.GetTextEngine();
//STRIP001 	const TextSelection&  rSel = aEditWin.GetTextView()->GetSelection();
//STRIP001 	((SwWebDocShell*)pDocShell)->SetSourcePara(rSel.GetStart().GetPara());
//STRIP001 
//STRIP001 
//STRIP001 	SfxDocumentInfo& rDocInfo = pDocShell->GetDocInfo();
//STRIP001 	pDocShell->SetAutoLoad(rDocInfo.GetReloadURL(),
//STRIP001 								rDocInfo.GetReloadDelay(),
//STRIP001 								rDocInfo.IsReloadEnabled() );
//STRIP001 //	EndListening(*GetViewFrame());
//STRIP001 	EndListening(*pDocShell);
//STRIP001 	delete pSearchItem;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------24.04.97 10:37-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SwSrcView::SaveContentTo(SfxMedium& rMed)
//STRIP001 {
//STRIP001 	aEditWin.Write( *rMed.GetInStream());//, EE_FORMAT_TEXT);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcView::Init()
//STRIP001 {
//STRIP001 	SetHelpId(SW_SRC_VIEWSHELL);
//STRIP001 	SetName(C2S("Source"));
//STRIP001 	SetWindow( &aEditWin );
//STRIP001     SwDocShell* pDocShell = GetDocShell();
//STRIP001 	// wird das Doc noch geladen, dann muss die DocShell das Load
//STRIP001 	// anwerfen, wenn das Laden abgeschlossen ist
//STRIP001 	if(!pDocShell->IsLoading())
//STRIP001 		Load(pDocShell);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aEditWin.SetReadonly(TRUE);
//STRIP001 	}
//STRIP001 
//STRIP001 //	StartListening(*GetViewFrame());
//STRIP001 	StartListening(*pDocShell);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwDocShell*		SwSrcView::GetDocShell()
//STRIP001 {
//STRIP001 	SfxObjectShell* pObjShell = GetViewFrame()->GetObjectShell();
//STRIP001 	return PTR_CAST(SwDocShell, pObjShell);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcView::SaveContent(const String& rTmpFile)
//STRIP001 {
//STRIP001 	SfxMedium aMedium( rTmpFile,	STREAM_WRITE, TRUE);
//STRIP001     rtl_TextEncoding eDestEnc = eLoadEncoding;
//STRIP001 
//STRIP001     if(RTL_TEXTENCODING_DONTKNOW == eDestEnc)
//STRIP001     {
//STRIP001         const sal_Char *pCharSet =
//STRIP001             rtl_getBestMimeCharsetFromTextEncoding( gsl_getSystemTextEncoding() );
//STRIP001         eDestEnc = rtl_getTextEncodingFromMimeCharset( pCharSet );
//STRIP001     }
//STRIP001 
//STRIP001     SvStream* pOutStream = aMedium.GetOutStream();
//STRIP001 	pOutStream->SetStreamCharSet( eDestEnc );
//STRIP001 	aEditWin.Write(*pOutStream);//, EE_FORMAT_TEXT);
//STRIP001 	aMedium.Commit();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcView::Execute(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 	TextView* pTextView = aEditWin.GetTextView();
//STRIP001 	switch( nSlot )
//STRIP001 	{
//STRIP001         case SID_SAVEASDOC:
//STRIP001 		{
//STRIP001 			SvtPathOptions aPathOpt;
//STRIP001 			Window* pParent = &GetViewFrame()->GetWindow();
//STRIP001 
//STRIP001             FileDialogHelper aDlgHelper( TemplateDescription::FILESAVE_SIMPLE, 0 );
//STRIP001             Reference < XFilePicker > xFP = aDlgHelper.GetFilePicker();
//STRIP001 
//STRIP001         //    pFileDlg->SetHelpId(HID_FILEDLG_SRCVIEW);
//STRIP001             Reference<XFilterManager> xFltMgr(xFP, UNO_QUERY);
//STRIP001 
//STRIP001             String sHtml(C2S("HTML"));
//STRIP001             xFltMgr->appendFilter( sHtml, C2S("*.html;*.htm") );
//STRIP001             xFltMgr->setCurrentFilter( sHtml ) ;
//STRIP001             xFP->setDisplayDirectory( aPathOpt.GetWorkPath() );
//STRIP001             if( aDlgHelper.Execute() == ERRCODE_NONE)
//STRIP001 			{
//STRIP001                 SfxMedium aMedium( xFP->getFiles().getConstArray()[0],
//STRIP001 									STREAM_WRITE | STREAM_SHARE_DENYNONE,
//STRIP001 									FALSE );
//STRIP001 #ifdef USED
//STRIP001 				// set the filter for the correct handling of
//STRIP001 				// extended attributes
//STRIP001 				SfxObjectFactory& rFac = GetDocShell()->GetFactory();
//STRIP001 				for( USHORT i = 0; i < rFac.GetFilterCount(); i++ )
//STRIP001 				{
//STRIP001 					const SfxFilter* pFlt = rFac.GetFilter( i );
//STRIP001 					if( pFlt && pFlt->GetFilterName() == sHtml )
//STRIP001 					{
//STRIP001 						aMedium.SetFilter( pFlt );
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 #endif
//STRIP001 				aEditWin.Write( *aMedium.GetOutStream() );
//STRIP001 				aMedium.Commit();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_SAVEDOC:
//STRIP001 		{
//STRIP001 			SwDocShell* pDocShell = GetDocShell();
//STRIP001 			SfxMedium* pMed = 0;
//STRIP001 			if(pDocShell->HasName())
//STRIP001 				pMed = pDocShell->GetMedium();
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SfxBoolItem* pItem = (SfxBoolItem*)pDocShell->ExecuteSlot(rReq, pDocShell->GetInterface());
//STRIP001 				if(pItem && pItem->GetValue())
//STRIP001 					pMed = pDocShell->GetMedium();
//STRIP001 			}
//STRIP001 			if(pMed)
//STRIP001 			{
//STRIP001                 SvStream* pOutStream = pMed->GetOutStream();
//STRIP001                 pOutStream->Seek(0);
//STRIP001                 pOutStream->SetStreamSize(0);
//STRIP001                 aEditWin.Write( *pOutStream );
//STRIP001                 pMed->CloseOutStream();
//STRIP001                 pMed->Commit();
//STRIP001 				pDocShell->GetDoc()->ResetModified();
//STRIP001 				SourceSaved();
//STRIP001 				aEditWin.ClearModifyFlag();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FID_SEARCH_NOW:
//STRIP001 		{
//STRIP001 			const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 			USHORT nWhich = pArgs->GetWhichByPos( 0 );
//STRIP001 			DBG_ASSERT( nWhich, "Wich fuer SearchItem ?" );
//STRIP001 			const SfxPoolItem& rItem = pArgs->Get( nWhich );
//STRIP001 			SetSearchItem( (const SvxSearchItem&)rItem);
//STRIP001 			StartSearchAndReplace( (const SvxSearchItem&)rItem, FALSE, rReq.IsAPI() );
//STRIP001 			if(aEditWin.IsModified())
//STRIP001 				GetDocShell()->GetDoc()->SetModified();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_PRINTDOC:
//STRIP001 		case SID_PRINTDOCDIRECT:
//STRIP001 		{
//STRIP001 			SfxViewShell::ExecuteSlot( rReq, SfxViewShell::GetInterface() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_UNDO:
//STRIP001 			pTextView->Undo();
//STRIP001 		break;
//STRIP001 		case SID_REDO:
//STRIP001 			pTextView->Redo();
//STRIP001 		break;
//STRIP001 		case SID_REPEAT:
//STRIP001 		break;
//STRIP001 		case SID_CUT:
//STRIP001 			pTextView->Cut();
//STRIP001 		break;
//STRIP001 		case SID_COPY:
//STRIP001 			pTextView->Copy();
//STRIP001 		break;
//STRIP001 		case SID_PASTE:
//STRIP001 			pTextView->Paste();
//STRIP001 		break;
//STRIP001 		case SID_SELECTALL:
//STRIP001 			pTextView->SetSelection( TextSelection( TextPaM( 0, 0 ), TextPaM( 0xFFFFFFFF, 0xFFFF ) ) );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	aEditWin.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcView::GetState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SfxWhichIter aIter(rSet);
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	TextView* pTextView = aEditWin.GetTextView();
//STRIP001 
//STRIP001 	while(nWhich)
//STRIP001 	{
//STRIP001 		switch(nWhich)
//STRIP001 		{
//STRIP001 			case SID_SAVEASDOC:
//STRIP001 				rSet.Put(SfxStringItem(nWhich, String(SW_RES(STR_SAVEAS_SRC))));
//STRIP001 			break;
//STRIP001 			case SID_SAVEDOC:
//STRIP001 			{
//STRIP001 				SwDocShell* pDocShell = GetDocShell();
//STRIP001 				if(!pDocShell->IsModified())
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case SID_PRINTDOC:
//STRIP001 			case SID_PRINTDOCDIRECT:
//STRIP001 			break;
//STRIP001 			case SID_TABLE_CELL:
//STRIP001 			{
//STRIP001 				String aPos( SW_RES(STR_SRCVIEW_ROW) );
//STRIP001 				TextSelection aSel = pTextView->GetSelection();
//STRIP001 				aPos += String::CreateFromInt32( aSel.GetEnd().GetPara()+1 );
//STRIP001 				aPos +=C2S(" : ");
//STRIP001 				aPos += String(SW_RES(STR_SRCVIEW_COL));
//STRIP001 				aPos += String::CreateFromInt32( aSel.GetEnd().GetIndex()+1 );
//STRIP001 				SfxStringItem aItem( nWhich, aPos );
//STRIP001 				rSet.Put( aItem );
//STRIP001 			}
//STRIP001 			break;
//STRIP001             case SID_SEARCH_OPTIONS:
//STRIP001 			{
//STRIP001 				USHORT nOpt = SRC_SEARCHOPTIONS;
//STRIP001 				if(GetDocShell()->IsReadOnly())
//STRIP001 					nOpt &= ~(SEARCH_OPTIONS_REPLACE|SEARCH_OPTIONS_REPLACE_ALL);
//STRIP001 
//STRIP001 				rSet.Put( SfxUInt16Item( SID_SEARCH_OPTIONS,  nOpt) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case SID_SEARCH_ITEM:
//STRIP001 			{
//STRIP001 				String sSelected;
//STRIP001 				if ( !pTextView->HasSelection() )
//STRIP001 				{
//STRIP001 					const TextSelection& rSel = pTextView->GetSelection();
//STRIP001 					sSelected = aEditWin.GetTextEngine()->GetWord( rSel.GetStart());
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					sSelected = pTextView->GetSelected();
//STRIP001 				}
//STRIP001 				SvxSearchItem * pSrchItem = GetSearchItem();
//STRIP001 				pSrchItem->SetSearchString( sSelected );
//STRIP001 				rSet.Put( *pSrchItem );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case SID_UNDO:
//STRIP001 			case SID_REDO:
//STRIP001 			{
//STRIP001 				SfxUndoManager& rMgr = pTextView->GetTextEngine()->GetUndoManager();
//STRIP001 				USHORT nCount = 0;
//STRIP001 				if(nWhich == SID_UNDO)
//STRIP001 				{
//STRIP001 					nCount = rMgr.GetUndoActionCount();
//STRIP001 					if(nCount)
//STRIP001 					{
//STRIP001 						String aStr(ResId( STR_UNDO, SFX_APP()->GetSfxResManager() ));;
//STRIP001 						aStr += rMgr.GetUndoActionComment(--nCount);
//STRIP001 						rSet.Put(SfxStringItem(nWhich, aStr));
//STRIP001 					}
//STRIP001 					else
//STRIP001 						rSet.DisableItem(nWhich);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nCount = rMgr.GetRedoActionCount();
//STRIP001 					if(nCount)
//STRIP001 					{
//STRIP001 						String aStr(ResId( STR_REDO, SFX_APP()->GetSfxResManager() ));;
//STRIP001 						aStr += rMgr.GetRedoActionComment(--nCount);
//STRIP001 						rSet.Put(SfxStringItem(nWhich,aStr));
//STRIP001 					}
//STRIP001 					else
//STRIP001 						rSet.DisableItem(nWhich);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001             case SID_MAIL_SENDDOCASPDF:
//STRIP001             case SID_MAIL_SENDDOC :
//STRIP001             case SID_EXPORTDOCASPDF:
//STRIP001             case SID_DIRECTEXPORTDOCASPDF:
//STRIP001             case SID_EXPORTDOC:                
//STRIP001             case SID_REPEAT:
//STRIP001 				rSet.DisableItem(nWhich);
//STRIP001 			break;
//STRIP001 			case SID_CUT:
//STRIP001 			case SID_COPY:
//STRIP001 				if(!pTextView->HasSelection())
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 			break;
//STRIP001 			case SID_PASTE:
//STRIP001 			{
//STRIP001 				BOOL bDisable = 0 == SW_MOD()->pClipboard;
//STRIP001 				if( bDisable  )
//STRIP001 				{
//STRIP001 					TransferableDataHelper aDataHelper(
//STRIP001 						TransferableDataHelper::CreateFromSystemClipboard(
//STRIP001 															&aEditWin) );
//STRIP001 					bDisable = !aDataHelper.GetXTransferable().is() ||
//STRIP001 								0 == aDataHelper.GetFormatCount();
//STRIP001 				}
//STRIP001 				if( bDisable )
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 			}
//STRIP001 			break;
//STRIP001         }
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SvxSearchItem* SwSrcView::GetSearchItem()
//STRIP001 {
//STRIP001 	if(!pSearchItem)
//STRIP001 	{
//STRIP001 		pSearchItem = new SvxSearchItem(SID_SEARCH_ITEM);
//STRIP001 	}
//STRIP001 	return pSearchItem;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcView::SetSearchItem( const SvxSearchItem& rItem )
//STRIP001 {
//STRIP001 	delete pSearchItem;
//STRIP001 	pSearchItem = (SvxSearchItem*)rItem.Clone();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 USHORT SwSrcView::StartSearchAndReplace(const SvxSearchItem& rSearchItem,
//STRIP001 													BOOL bFromStart,
//STRIP001 													BOOL bApi,
//STRIP001 													BOOL bRecursive)
//STRIP001 {
//STRIP001 	ExtTextView* pTextView = aEditWin.GetTextView();
//STRIP001 	TextSelection aSel;
//STRIP001 	TextPaM aPaM;
//STRIP001 
//STRIP001 	BOOL bForward = !rSearchItem.GetBackward();
//STRIP001 	BOOL bAtStart = pTextView->GetSelection() == TextSelection( aPaM, aPaM );
//STRIP001 
//STRIP001 	if( !bForward )
//STRIP001 		aPaM = TextPaM( (ULONG)-1, (USHORT)-1 );
//STRIP001 
//STRIP001 	if( bFromStart )
//STRIP001 	{
//STRIP001 		aSel = pTextView->GetSelection();
//STRIP001 		pTextView->SetSelection( TextSelection( aPaM, aPaM ));
//STRIP001 	}
//STRIP001 
//STRIP001 	SearchOptions aSearchOpt( rSearchItem.GetSearchOptions() );
//STRIP001 	aSearchOpt.Locale = CreateLocale( GetAppLanguage() );
//STRIP001 
//STRIP001 	USHORT nFound;
//STRIP001 	BOOL bAll = FALSE;
//STRIP001 	switch( rSearchItem.GetCommand() )
//STRIP001 	{
//STRIP001 	case SVX_SEARCHCMD_FIND:
//STRIP001 	case SVX_SEARCHCMD_FIND_ALL:
//STRIP001 		nFound = pTextView->Search( aSearchOpt, bForward );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case SVX_SEARCHCMD_REPLACE_ALL: bAll = TRUE;
//STRIP001 	case SVX_SEARCHCMD_REPLACE:
//STRIP001 		nFound = pTextView->Replace( aSearchOpt, bAll, bForward );
//STRIP001 		break;
//STRIP001 
//STRIP001 	default:
//STRIP001 		nFound = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !nFound )
//STRIP001 	{
//STRIP001 		BOOL bNotFoundMessage = FALSE;
//STRIP001 		if(!bRecursive)
//STRIP001 		{
//STRIP001 			if(!bFromStart)
//STRIP001 			{
//STRIP001 				bNotFoundMessage = bAtStart;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bNotFoundMessage = TRUE;
//STRIP001 				pTextView->SetSelection( aSel );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if(bAtStart)
//STRIP001 		{
//STRIP001 			bNotFoundMessage = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		if(!bApi)
//STRIP001 			if(bNotFoundMessage)
//STRIP001 			{
//STRIP001 				InfoBox( 0, SW_RES(MSG_NOT_FOUND)).Execute();
//STRIP001 			}
//STRIP001 			else if(!bRecursive && RET_YES ==
//STRIP001 				QueryBox(0, SW_RES( bForward ? MSG_SEARCH_END
//STRIP001 								             : MSG_SEARCH_START)).Execute())
//STRIP001 			{
//STRIP001 				pTextView->SetSelection( TextSelection( aPaM, aPaM ) );
//STRIP001 				StartSearchAndReplace( rSearchItem, FALSE, FALSE, TRUE );
//STRIP001 			}
//STRIP001 	}
//STRIP001 	return nFound;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------02.07.97 09:29-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 USHORT SwSrcView::SetPrinter(SfxPrinter* pNew, USHORT nDiffFlags )
//STRIP001 {
//STRIP001 	SwDocShell* pDocSh = GetDocShell();
//STRIP001 	if ( (SFX_PRINTER_JOBSETUP | SFX_PRINTER_PRINTER) & nDiffFlags )
//STRIP001 	{
//STRIP001 		pDocSh->GetDoc()->SetPrt( pNew );
//STRIP001 		if ( nDiffFlags & SFX_PRINTER_PRINTER )
//STRIP001 			pDocSh->SetModified();
//STRIP001 	}
//STRIP001 	if ( nDiffFlags & SFX_PRINTER_OPTIONS )
//STRIP001 		::SetPrinter( pNew, TRUE );
//STRIP001 
//STRIP001 	const BOOL bChgOri = nDiffFlags & SFX_PRINTER_CHG_ORIENTATION ? TRUE : FALSE;
//STRIP001 	const BOOL bChgSize= nDiffFlags & SFX_PRINTER_CHG_SIZE ? TRUE : FALSE;
//STRIP001 	if ( bChgOri || bChgSize )
//STRIP001 	{
//STRIP001 		pDocSh->SetModified();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 ErrCode	SwSrcView::DoPrint( SfxPrinter *pPrinter, PrintDialog *pDlg,
//STRIP001 							BOOL bSilent )
//STRIP001 {
//STRIP001 	SfxPrintProgress *pProgress = new SfxPrintProgress( this, !bSilent );
//STRIP001 	SfxPrinter *pDocPrinter = GetPrinter(TRUE);
//STRIP001 	if ( !pPrinter )
//STRIP001 		pPrinter = pDocPrinter;
//STRIP001 	else if ( pDocPrinter != pPrinter )
//STRIP001 	{
//STRIP001 		pProgress->RestoreOnEndPrint( pDocPrinter->Clone() );
//STRIP001 		SetPrinter( pPrinter, SFX_PRINTER_PRINTER );
//STRIP001 	}
//STRIP001 	pProgress->SetWaitMode(FALSE);
//STRIP001 
//STRIP001 	// Drucker starten
//STRIP001 	PreparePrint( pDlg );
//STRIP001 	SfxObjectShell *pObjShell = GetViewFrame()->GetObjectShell();
//STRIP001 
//STRIP001 	SfxViewShell::Print(*pProgress, pDlg); //???
//STRIP001 
//STRIP001 	MapMode eOldMapMode( pPrinter->GetMapMode() );
//STRIP001 	Font aOldFont( pPrinter->Printer::GetFont() );
//STRIP001 
//STRIP001 	TextEngine* pTextEngine = aEditWin.GetTextEngine();
//STRIP001 	pPrinter->SetMapMode(MAP_100TH_MM);
//STRIP001 	Font aFont(aEditWin.GetOutWin()->GetFont());
//STRIP001 	Size aSize(aFont.GetSize());
//STRIP001 	aSize = aEditWin.GetOutWin()->PixelToLogic(aSize, MAP_100TH_MM);
//STRIP001 	aFont.SetSize(aSize);
//STRIP001 	aFont.SetColor(COL_BLACK);
//STRIP001 	pPrinter->SetFont( aFont );
//STRIP001 
//STRIP001 	String aTitle( GetViewFrame()->GetWindow().GetText() );
//STRIP001 
//STRIP001 	USHORT nLineHeight = (USHORT) pPrinter->GetTextHeight(); // etwas mehr.
//STRIP001 	USHORT nParaSpace = 10;
//STRIP001 
//STRIP001 	Size aPaperSz = pPrinter->GetOutputSize();
//STRIP001 	aPaperSz.Width() -= (LMARGPRN+RMARGPRN);
//STRIP001 	aPaperSz.Height() -= (TMARGPRN+BMARGPRN);
//STRIP001 
//STRIP001 	// nLinepPage stimmt nicht, wenn Zeilen umgebrochen werden muessen...
//STRIP001 	USHORT nLinespPage = (USHORT) (aPaperSz.Height()/nLineHeight);
//STRIP001 	USHORT nCharspLine = (USHORT) (aPaperSz.Width() / pPrinter->GetTextWidth( 'X' ));
//STRIP001 	USHORT nParas = pTextEngine->GetParagraphCount();
//STRIP001 
//STRIP001 	USHORT nPages = (USHORT) (nParas/nLinespPage+1 );
//STRIP001 	USHORT nCurPage = 1;
//STRIP001 
//STRIP001 	BOOL bStartJob = pPrinter->StartJob( aTitle );
//STRIP001 	if( bStartJob )
//STRIP001 	{
//STRIP001 		pPrinter->StartPage();
//STRIP001 		// Header drucken...
//STRIP001 		lcl_PrintHeader( pPrinter, nPages, nCurPage, aTitle );
//STRIP001 		Point aPos( LMARGPRN, TMARGPRN );
//STRIP001 		for ( USHORT nPara = 0; nPara < nParas; nPara++ )
//STRIP001 		{
//STRIP001 			String aLine( pTextEngine->GetText( nPara ) );
//STRIP001 			lcl_ConvertTabsToSpaces( aLine );
//STRIP001 			USHORT nLines = aLine.Len()/nCharspLine+1;
//STRIP001 			for ( USHORT nLine = 0; nLine < nLines; nLine++ )
//STRIP001 			{
//STRIP001 				String aTmpLine( aLine, nLine*nCharspLine, nCharspLine );
//STRIP001 				aPos.Y() += nLineHeight;
//STRIP001 				if ( aPos.Y() > ( aPaperSz.Height()+TMARGPRN ) )
//STRIP001 				{
//STRIP001 					nCurPage++;
//STRIP001 					pPrinter->EndPage();
//STRIP001 					pPrinter->StartPage();
//STRIP001 					lcl_PrintHeader( pPrinter, nPages, nCurPage, aTitle );
//STRIP001 					aPos = Point( LMARGPRN, TMARGPRN+nLineHeight );
//STRIP001 				}
//STRIP001 				pPrinter->DrawText( aPos, aTmpLine );
//STRIP001 			}
//STRIP001 			aPos.Y() += nParaSpace;
//STRIP001 		}
//STRIP001 		pPrinter->EndPage();
//STRIP001 	}
//STRIP001 
//STRIP001 	pPrinter->SetFont( aOldFont );
//STRIP001 	pPrinter->SetMapMode( eOldMapMode );
//STRIP001 
//STRIP001 	if ( !bStartJob )
//STRIP001 	{
//STRIP001 		// Printer konnte nicht gestartet werden
//STRIP001 		delete pProgress;
//STRIP001 		return ERRCODE_IO_ABORT;
//STRIP001 	}
//STRIP001 
//STRIP001 	pProgress->Stop();
//STRIP001 	pProgress->DeleteOnEndPrint();
//STRIP001 	pPrinter->EndJob();
//STRIP001 	return pPrinter->GetError();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SfxPrinter* SwSrcView::GetPrinter( BOOL bCreate )
//STRIP001 {
//STRIP001 	return 	GetDocShell()->GetDoc()->GetPrt( bCreate );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001 	if ( rHint.ISA(SfxSimpleHint) &&
//STRIP001 			(((SfxSimpleHint&) rHint).GetId() == SFX_HINT_MODECHANGED) ||
//STRIP001 			(((SfxSimpleHint&) rHint).GetId() == SFX_HINT_TITLECHANGED &&
//STRIP001 			   !GetDocShell()->IsReadOnly() && aEditWin.IsReadonly()))
//STRIP001 	{
//STRIP001 		// Broadcast kommt nur einmal!
//STRIP001 		const SwDocShell* pDocSh = GetDocShell();
//STRIP001 		const BOOL bReadonly = pDocSh->IsReadOnly();
//STRIP001 		aEditWin.SetReadonly(bReadonly);
//STRIP001 	}
//STRIP001 	SfxViewShell::Notify(rBC, rHint);
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------19.04.97 10:19-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SwSrcView::Load(SwDocShell* pDocShell)
//STRIP001 {
//STRIP001     OfaHtmlOptions* pHtmlOptions = OFF_APP()->GetHtmlOptions();
//STRIP001     const sal_Char *pCharSet =
//STRIP001         rtl_getBestMimeCharsetFromTextEncoding( pHtmlOptions->GetTextEncoding() );
//STRIP001 	rtl_TextEncoding eDestEnc = rtl_getTextEncodingFromMimeCharset( pCharSet );
//STRIP001 
//STRIP001     aEditWin.SetReadonly(pDocShell->IsReadOnly());
//STRIP001     aEditWin.SetTextEncoding(eDestEnc);
//STRIP001 	SfxMedium* pMedium = pDocShell->GetMedium();
//STRIP001 
//STRIP001 	const SfxFilter* pFilter = pMedium->GetFilter();
//STRIP001 	BOOL bHtml = pFilter && pFilter->GetUserData().EqualsAscii("HTML");
//STRIP001 	BOOL bDocModified = pDocShell->IsModified();
//STRIP001 	if(bHtml && !bDocModified && pDocShell->HasName())
//STRIP001 	{
//STRIP001 		SvStream* pStream = pMedium->GetInStream();
//STRIP001 		if(pStream && 0 == pStream->GetError() )
//STRIP001 		{
//STRIP001 			rtl_TextEncoding eHeaderEnc = 
//STRIP001 				SfxHTMLParser::GetEncodingByHttpHeader(
//STRIP001                                             pDocShell->GetHeaderAttributes() );
//STRIP001 			if( RTL_TEXTENCODING_DONTKNOW == eHeaderEnc )
//STRIP001 			{
//STRIP001     			const sal_Char *pCharSet =
//STRIP001 					rtl_getBestMimeCharsetFromTextEncoding( RTL_TEXTENCODING_ISO_8859_1 );
//STRIP001 				eHeaderEnc = rtl_getTextEncodingFromMimeCharset( pCharSet );
//STRIP001 			}
//STRIP001 			if( RTL_TEXTENCODING_DONTKNOW != eHeaderEnc &&
//STRIP001 			 	eDestEnc != eHeaderEnc )
//STRIP001 			{
//STRIP001 				eDestEnc = eHeaderEnc;
//STRIP001 				aEditWin.SetTextEncoding(eDestEnc);
//STRIP001 			}
//STRIP001 			pStream->SetStreamCharSet( eDestEnc );
//STRIP001 			pStream->Seek(0);
//STRIP001             TextEngine* pTextEngine = aEditWin.GetTextEngine();
//STRIP001             pTextEngine->EnableUndo(FALSE);
//STRIP001 			aEditWin.Read(*pStream);//, EE_FORMAT_TEXT);
//STRIP001             pTextEngine->EnableUndo(TRUE);
//STRIP001         }
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Window *pWindow = &GetViewFrame()->GetWindow();
//STRIP001 			InfoBox(pWindow, SW_RES(MSG_ERR_SRCSTREAM)).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		utl::TempFile aTempFile;
//STRIP001 		aTempFile.EnableKillingFile();
//STRIP001 		String sFileURL( aTempFile.GetURL() ),
//STRIP001 			   sBaseURL( so3::StaticBaseUrl::GetBaseURL() );
//STRIP001 		BOOL bIsRemote = pMedium->IsRemote();
//STRIP001 		SvtSaveOptions aOpt;
//STRIP001 
//STRIP001 		if( bIsRemote ? aOpt.IsSaveRelINet() : aOpt.IsSaveRelFSys() )
//STRIP001 			so3::StaticBaseUrl::SetBaseURL( pMedium->GetName() );
//STRIP001 		else
//STRIP001 			so3::StaticBaseUrl::SetBaseURL( aEmptyStr );
//STRIP001 
//STRIP001 		{
//STRIP001 			SfxMedium aMedium( sFileURL,STREAM_READWRITE, TRUE );
//STRIP001 			SwWriter aWriter( aMedium, *pDocShell->GetDoc() );
//STRIP001 			WriterRef xWriter;
//STRIP001 			::GetHTMLWriter(aEmptyStr, xWriter);
//STRIP001 			String sWriteName = pDocShell->HasName() ?
//STRIP001 									pMedium->GetName() :
//STRIP001 										(const String&) sFileURL;
//STRIP001 			ULONG nRes = aWriter.Write(xWriter, &sWriteName);
//STRIP001 			if(nRes)
//STRIP001 			{
//STRIP001 				ErrorHandler::HandleError(ErrCode(nRes));
//STRIP001 				aEditWin.SetReadonly(TRUE);
//STRIP001 			}
//STRIP001 			aMedium.Commit();
//STRIP001 			SvStream* pInStream = aMedium.GetInStream();
//STRIP001 			pInStream->Seek(0);
//STRIP001 			pInStream->SetStreamCharSet( eDestEnc );
//STRIP001 
//STRIP001 			so3::StaticBaseUrl::SetBaseURL(sBaseURL);
//STRIP001 
//STRIP001 			aEditWin.Read(*pInStream);//, EE_FORMAT_TEXT);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aEditWin.ClearModifyFlag();
//STRIP001 
//STRIP001     eLoadEncoding = eDestEnc;
//STRIP001 
//STRIP001 	if(bDocModified)
//STRIP001 		pDocShell->SetModified();// das Flag wird zwischendurch zurueckgesetzt
//STRIP001 	// AutoLoad abschalten
//STRIP001 	pDocShell->SetAutoLoad(INetURLObject(), 0, FALSE);
//STRIP001 	DBG_ASSERT(PTR_CAST(SwWebDocShell, pDocShell), "Wieso keine WebDocShell?")
//STRIP001 	USHORT nLine = ((SwWebDocShell*)pDocShell)->GetSourcePara();
//STRIP001 	aEditWin.SetStartLine(nLine);
//STRIP001 	aEditWin.GetTextEngine()->ResetUndo();
//STRIP001 	aEditWin.GetOutWin()->GrabFocus();
//STRIP001 }


}
