/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_txtattr.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:36:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
// auto strip #ifndef _SFXSTRITEM_HXX
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMITER_HXX
// auto strip #include <svtools/itemiter.hxx>
// auto strip #endif
#ifndef _SVTOOLS_CTLOPTIONS_HXX
#include <svtools/ctloptions.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FHGTITEM_HXX //autogen
// auto strip #include <bf_svx/fhgtitem.hxx>
// auto strip #endif
#ifndef _SVX_ADJITEM_HXX //autogen
#include <bf_svx/adjitem.hxx>
#endif
#ifndef _SVX_LSPCITEM_HXX //autogen
#include <bf_svx/lspcitem.hxx>
#endif
#ifndef _SVX_UDLNITEM_HXX //autogen
#include <bf_svx/udlnitem.hxx>
#endif
#ifndef _SVX_ESCPITEM_HXX //autogen
#include <bf_svx/escpitem.hxx>
#endif
#ifndef _SVX_HTMLMODE_HXX //autogen
#include <bf_svx/htmlmode.hxx>
#endif
#ifndef _SVX_SCRIPTTYPEITEM_HXX
#include <bf_svx/scripttypeitem.hxx>
#endif
#ifndef _SVX_FRMDIRITEM_HXX
#include <bf_svx/frmdiritem.hxx>
#endif
// auto strip #ifndef _PARATR_HXX
// auto strip #include "paratr.hxx"
// auto strip #endif


// auto strip #ifndef _FMTINFMT_HXX //autogen
// auto strip #include <fmtinfmt.hxx>
// auto strip #endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif
// auto strip #ifndef _UITOOL_HXX
// auto strip #include <uitool.hxx>
// auto strip #endif
// auto strip #ifndef _UIITEMS_HXX
// auto strip #include <uiitems.hxx>
// auto strip #endif
#ifndef _TEXTSH_HXX
#include <textsh.hxx>
#endif
// auto strip #ifndef _DRPCPS_HXX
// auto strip #include <drpcps.hxx>
// auto strip #endif
// auto strip #ifndef _NUM_HXX
// auto strip #include <num.hxx>
// auto strip #endif
// auto strip #ifndef _SWUNDO_HXX
// auto strip #include <swundo.hxx>
// auto strip #endif
#ifndef _FMTCOL_HXX
#include <fmtcol.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _GLOBALS_H
#include <globals.h>
#endif
#ifndef _SHELLS_HRC
#include <shells.hrc>
#endif
// auto strip #ifndef _SWSTYLENAMEMAPPER_HXX
// auto strip #include <SwStyleNameMapper.hxx>
// auto strip #endif
namespace binfilter {
const SwTwips lFontInc = 2 * 20;		   // ==> PointToTwips(2)
const SwTwips lFontMaxSz = 72 * 20; 	   // ==> PointToTwips(72)




//STRIP001 void SwTextShell::ExecCharAttr(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 	const SfxItemSet  *pArgs   = rReq.GetArgs();
//STRIP001 		  int          eState = STATE_TOGGLE;
//STRIP001 	USHORT nWhich = rReq.GetSlot();
//STRIP001 
//STRIP001 	if(pArgs )
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		pArgs->GetItemState(nWhich, FALSE, &pItem);
//STRIP001 		eState =  ((const SfxBoolItem &) pArgs->
//STRIP001 								Get( nWhich )).GetValue() ? STATE_ON : STATE_OFF;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	SfxItemSet aSet( GetPool(), RES_CHRATR_BEGIN, RES_CHRATR_END-1 );
//STRIP001 	if (STATE_TOGGLE == eState)
//STRIP001 		rSh.GetAttr( aSet );
//STRIP001 
//STRIP001 	switch ( nWhich )
//STRIP001 	{
//STRIP001 		case FN_SET_SUB_SCRIPT:
//STRIP001 		case FN_SET_SUPER_SCRIPT:
//STRIP001 		{
//STRIP001 			SvxEscapement eEscape;
//STRIP001 			switch (eState)
//STRIP001 			{
//STRIP001 			case STATE_TOGGLE:
//STRIP001 			{
//STRIP001 				short nTmpEsc = ((const SvxEscapementItem&)
//STRIP001 							aSet.Get( RES_CHRATR_ESCAPEMENT )).GetEsc();
//STRIP001 				eEscape = nWhich == FN_SET_SUPER_SCRIPT ?
//STRIP001 								SVX_ESCAPEMENT_SUPERSCRIPT:
//STRIP001 								SVX_ESCAPEMENT_SUBSCRIPT;
//STRIP001 				if( nWhich == FN_SET_SUB_SCRIPT && nTmpEsc < 0 ||
//STRIP001 							nWhich == FN_SET_SUPER_SCRIPT && nTmpEsc > 0 )
//STRIP001 					eEscape = SVX_ESCAPEMENT_OFF;
//STRIP001 
//STRIP001 				SfxBindings& rBind = GetView().GetViewFrame()->GetBindings();
//STRIP001 				if( nWhich == FN_SET_SUB_SCRIPT )
//STRIP001 					rBind.SetState( SfxBoolItem( FN_SET_SUPER_SCRIPT,
//STRIP001 																	FALSE ) );
//STRIP001 				else
//STRIP001 					rBind.SetState( SfxBoolItem( FN_SET_SUB_SCRIPT,
//STRIP001 																	FALSE ) );
//STRIP001 
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case STATE_ON:
//STRIP001 				eEscape = nWhich == FN_SET_SUPER_SCRIPT ?
//STRIP001 								SVX_ESCAPEMENT_SUPERSCRIPT:
//STRIP001 								SVX_ESCAPEMENT_SUBSCRIPT;
//STRIP001 				break;
//STRIP001 			case STATE_OFF:
//STRIP001 				eEscape = SVX_ESCAPEMENT_OFF;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			SvxEscapementItem aEscape( eEscape );
//STRIP001 			if(eEscape == SVX_ESCAPEMENT_SUPERSCRIPT)
//STRIP001 				aEscape.GetEsc() = DFLT_ESC_AUTO_SUPER;
//STRIP001 			else if(eEscape == SVX_ESCAPEMENT_SUBSCRIPT)
//STRIP001 				aEscape.GetEsc() = DFLT_ESC_AUTO_SUB;
//STRIP001 			if(eState != STATE_OFF )
//STRIP001 			{
//STRIP001 				if(eEscape == FN_SET_SUPER_SCRIPT)
//STRIP001 					aEscape.GetEsc() *= -1;
//STRIP001 			}
//STRIP001 			rSh.SetAttr( aEscape );
//STRIP001             rReq.AppendItem( aEscape );
//STRIP001             rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_UPDATE_STYLE_BY_EXAMPLE:
//STRIP001 			rSh.QuickUpdateStyle();
//STRIP001             rReq.Done();
//STRIP001 			break;
//STRIP001 		case FN_UNDERLINE_DOUBLE:
//STRIP001 		{
//STRIP001 			FontUnderline eUnderline =  ((const SvxUnderlineItem&)
//STRIP001 							aSet.Get(RES_CHRATR_UNDERLINE)).GetUnderline();
//STRIP001 			switch( eState )
//STRIP001 			{
//STRIP001 				case STATE_TOGGLE:
//STRIP001 					eUnderline = eUnderline == UNDERLINE_DOUBLE ?
//STRIP001 						UNDERLINE_NONE :
//STRIP001 							UNDERLINE_DOUBLE;
//STRIP001 				break;
//STRIP001 				case STATE_ON:
//STRIP001 					eUnderline = UNDERLINE_DOUBLE;
//STRIP001 				break;
//STRIP001 				case STATE_OFF:
//STRIP001 					eUnderline = UNDERLINE_NONE;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			rSh.SetAttr(SvxUnderlineItem(eUnderline));
//STRIP001             rReq.AppendItem(SvxUnderlineItem(eUnderline));
//STRIP001             rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		default:
//STRIP001 			ASSERT(FALSE, falscher Dispatcher);
//STRIP001 			return;
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwTextShell::ExecCharAttrArgs(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	int nSlot = rReq.GetSlot();
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 	BOOL bArgs = pArgs != 0 && pArgs->Count() > 0;
//STRIP001 	int bGrow = FALSE;
//STRIP001 	SwWrtShell& rWrtSh = GetShell();
//STRIP001 	SwTxtFmtColl* pColl = 0;
//STRIP001 
//STRIP001 	// nur gesetzt, wenn gesamter Absatz selektiert ist und AutoUpdateFmt gesetzt ist
//STRIP001 	if( rWrtSh.HasSelection() && rWrtSh.IsSelFullPara() )
//STRIP001 	{
//STRIP001 		pColl = rWrtSh.GetCurTxtFmtColl();
//STRIP001 		if(pColl && !pColl->IsAutoUpdateFmt())
//STRIP001 			pColl = 0;
//STRIP001 	}
//STRIP001 	SfxItemPool& rPool = GetPool();
//STRIP001 	USHORT nWhich = rPool.GetWhich(nSlot);
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case FN_TXTATR_INET:
//STRIP001 		// Sonderbehandlung der PoolId des SwFmtInetFmt
//STRIP001 		if(bArgs)
//STRIP001 		{
//STRIP001 			const SfxPoolItem& rItem = pArgs->Get(nWhich );
//STRIP001 
//STRIP001 			SwFmtINetFmt aINetFmt((const SwFmtINetFmt&)rItem);
//STRIP001 			if( USHRT_MAX == aINetFmt.GetVisitedFmtId() )
//STRIP001 			{
//STRIP001 				aINetFmt.SetVisitedFmtId(
//STRIP001 						SwStyleNameMapper::GetPoolIdFromUIName( aINetFmt.GetVisitedFmt(), GET_POOLID_CHRFMT));
//STRIP001 			}
//STRIP001 			if( USHRT_MAX == aINetFmt.GetINetFmtId() )
//STRIP001 			{
//STRIP001 				aINetFmt.SetINetFmtId(
//STRIP001 						SwStyleNameMapper::GetPoolIdFromUIName( aINetFmt.GetINetFmt(), GET_POOLID_CHRFMT));
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pColl )
//STRIP001 				pColl->SetAttr( aINetFmt );
//STRIP001 			else rWrtSh.SetAttr( aINetFmt );
//STRIP001             rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_GROW_FONT_SIZE:
//STRIP001 			bGrow = TRUE;
//STRIP001 			// kein break !!
//STRIP001 		case FN_SHRINK_FONT_SIZE:
//STRIP001 		{
//STRIP001 			SvxScriptSetItem aSetItem( SID_ATTR_CHAR_FONTHEIGHT, rPool );
//STRIP001 			rWrtSh.GetAttr( aSetItem.GetItemSet() );
//STRIP001 			SfxItemSet aAttrSet( rPool, aSetItem.GetItemSet().GetRanges() );
//STRIP001 
//STRIP001 			const SfxPoolItem* pI;
//STRIP001 			static const USHORT aScrTypes[] = {
//STRIP001 				SCRIPTTYPE_LATIN, SCRIPTTYPE_ASIAN, SCRIPTTYPE_COMPLEX, 0 };
//STRIP001 			USHORT nScriptType = rWrtSh.GetScriptType();
//STRIP001 			for( const USHORT* pScrpTyp = aScrTypes; *pScrpTyp; ++pScrpTyp )
//STRIP001 				if( ( nScriptType & *pScrpTyp ) &&
//STRIP001 					0 != ( pI = aSetItem.GetItemOfScript( *pScrpTyp )))
//STRIP001 				{
//STRIP001 					SvxFontHeightItem aSize( *(const SvxFontHeightItem*)pI );
//STRIP001 					SwTwips lSize = (SwTwips) aSize.GetHeight();
//STRIP001 
//STRIP001 					if (bGrow)
//STRIP001 					{
//STRIP001 						if( lSize == lFontMaxSz )
//STRIP001 							break;		// das wars, hoeher gehts nicht
//STRIP001 						if( ( lSize += lFontInc ) > lFontMaxSz )
//STRIP001 							lSize = lFontMaxSz;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if( 4 == lSize )
//STRIP001 							break;
//STRIP001 						if( ( lSize -= lFontInc ) < 4 )
//STRIP001 							lSize = 4;
//STRIP001 					}
//STRIP001 					aSize.SetHeight( lSize );
//STRIP001 					aAttrSet.Put( aSize );
//STRIP001 				}
//STRIP001 				if( aAttrSet.Count() )
//STRIP001 				{
//STRIP001 					if( pColl )
//STRIP001 						pColl->SetAttr( aAttrSet );
//STRIP001 					else
//STRIP001 						rWrtSh.SetAttr( aAttrSet );
//STRIP001 				}
//STRIP001             rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			ASSERT(FALSE, falscher Dispatcher);
//STRIP001 			return;
//STRIP001 	}
//STRIP001 }



#ifdef CFRONT

//STRIP001 void lcl_SetAdjust(SvxAdjust eAdjst, SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	rSet.Put(SvxAdjustItem(eAdjst,RES_PARATR_ADJUST ));
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void lcl_SetLineSpace(BYTE ePropL,SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SvxLineSpacingItem aLineSpacing(ePropL, RES_PARATR_LINESPACING );
//STRIP001 	aLineSpacing.GetLineSpaceRule() = SVX_LINE_SPACE_AUTO;
//STRIP001 	if( 100 == ePropL )
//STRIP001 		aLineSpacing.GetInterLineSpaceRule() = SVX_INTER_LINE_SPACE_OFF;
//STRIP001 	else
//STRIP001 		aLineSpacing.SetPropLineSpace(ePropL);
//STRIP001 	rSet.Put( aLineSpacing );
//STRIP001 }



//STRIP001 void SwTextShell::ExecParaAttr(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	// gleiche beide Attribute holen, ist nicht teuerer !!
//STRIP001 	SfxItemSet aSet( GetPool(), RES_PARATR_LINESPACING, RES_PARATR_ADJUST );
//STRIP001 
//STRIP001 	switch (rReq.GetSlot())
//STRIP001 	{
//STRIP001 	case FN_SET_LEFT_PARA:			lcl_SetAdjust(ADJLEFT,aSet); 	break;
//STRIP001 	case FN_SET_RIGHT_PARA:			lcl_SetAdjust(ADJRIGHT,aSet); 	break;
//STRIP001 	case FN_SET_CENTER_PARA:        lcl_SetAdjust(ADJCENTER,aSet); 	break;
//STRIP001 	case SID_ATTR_PARA_ADJUST_BLOCK:lcl_SetAdjust(ADJBLOCK,aSet); 	break;
//STRIP001 
//STRIP001 	case FN_SET_LINE_SPACE_1:	lcl_SetLineSpace(100,aSet); 	break;
//STRIP001 	case FN_SET_LINE_SPACE_15:  lcl_SetLineSpace(150,aSet); 	break;
//STRIP001 	case FN_SET_LINE_SPACE_2:	lcl_SetLineSpace(200,aSet); 	break;
//STRIP001 
//STRIP001 	default:
//STRIP001 		DBG_ERROR("SwTextShell::ExecParaAttr falscher Dispatcher");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	SwWrtShell& rWrtSh = GetShell();
//STRIP001 	SwTxtFmtColl* pColl = rWrtSh.GetCurTxtFmtColl();
//STRIP001 	if(pColl && pColl->IsAutoUpdateFmt())
//STRIP001 	{
//STRIP001 		rWrtSh.AutoUpdatePara(pColl, *pSet);
//STRIP001 	}
//STRIP001 	else
//STRIP001     {
//STRIP001 		rWrtSh.SetAttr( aSet );
//STRIP001         rReq.Done( aSet );
//STRIP001     }
//STRIP001 }

#else



//STRIP001 void SwTextShell::ExecParaAttr(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	SvxAdjust eAdjst;
//STRIP001 	BYTE ePropL;
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 	// gleich beide Attribute holen, ist nicht teuerer !!
//STRIP001     SfxItemSet aSet( GetPool(),
//STRIP001         RES_PARATR_LINESPACING, RES_PARATR_ADJUST,
//STRIP001         RES_FRAMEDIR, RES_FRAMEDIR,
//STRIP001         0 );
//STRIP001 
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	switch (nSlot)
//STRIP001 	{
//STRIP001 		case SID_ATTR_PARA_ADJUST:
//STRIP001 		{
//STRIP001 			if( pArgs && SFX_ITEM_SET == pArgs->GetItemState(RES_PARATR_ADJUST) )
//STRIP001 			{
//STRIP001 				const SvxAdjustItem& rAdj = (const SvxAdjustItem&) pArgs->Get(RES_PARATR_ADJUST);
//STRIP001 				SvxAdjustItem aAdj( rAdj.GetAdjust(), RES_PARATR_ADJUST );
//STRIP001 				if ( rAdj.GetAdjust() == SVX_ADJUST_BLOCK )
//STRIP001 				{
//STRIP001 					aAdj.SetLastBlock( rAdj.GetLastBlock() );
//STRIP001 					aAdj.SetOneWord( rAdj.GetOneWord() );
//STRIP001 				}
//STRIP001 
//STRIP001 				aSet.Put(aAdj);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_ATTR_PARA_ADJUST_LEFT:		eAdjst =  SVX_ADJUST_LEFT;		goto SET_ADJUST;
//STRIP001 		case SID_ATTR_PARA_ADJUST_RIGHT:	eAdjst =  SVX_ADJUST_RIGHT;		goto SET_ADJUST;
//STRIP001 		case SID_ATTR_PARA_ADJUST_CENTER:   eAdjst =  SVX_ADJUST_CENTER;	goto SET_ADJUST;
//STRIP001 		case SID_ATTR_PARA_ADJUST_BLOCK:	eAdjst =  SVX_ADJUST_BLOCK;		goto SET_ADJUST;
//STRIP001 SET_ADJUST:
//STRIP001 		{
//STRIP001 			aSet.Put(SvxAdjustItem(eAdjst,RES_PARATR_ADJUST));
//STRIP001             rReq.AppendItem( SfxBoolItem( GetPool().GetWhich(nSlot), TRUE ) );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_PARA_LINESPACE:
//STRIP001 			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState( GetPool().GetWhich(nSlot) ))
//STRIP001 			{
//STRIP001 				SvxLineSpacingItem aLineSpace = (const SvxLineSpacingItem&)pArgs->Get(
//STRIP001 															GetPool().GetWhich(nSlot));
//STRIP001 				aSet.Put( aLineSpace );
//STRIP001 			}
//STRIP001 		break;
//STRIP001 		case SID_ATTR_PARA_LINESPACE_10:	ePropL = 100;	goto SET_LINESPACE;
//STRIP001 		case SID_ATTR_PARA_LINESPACE_15:	ePropL = 150;	goto SET_LINESPACE;
//STRIP001 		case SID_ATTR_PARA_LINESPACE_20:	ePropL = 200;	goto SET_LINESPACE;
//STRIP001 
//STRIP001 SET_LINESPACE:
//STRIP001 		{
//STRIP001 
//STRIP001 			SvxLineSpacingItem aLineSpacing(ePropL, RES_PARATR_LINESPACING );
//STRIP001 			aLineSpacing.GetLineSpaceRule() = SVX_LINE_SPACE_AUTO;
//STRIP001 			if( 100 == ePropL )
//STRIP001 				aLineSpacing.GetInterLineSpaceRule() = SVX_INTER_LINE_SPACE_OFF;
//STRIP001 			else
//STRIP001 				aLineSpacing.SetPropLineSpace(ePropL);
//STRIP001 			aSet.Put( aLineSpacing );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001         case SID_ATTR_PARA_LEFT_TO_RIGHT :
//STRIP001         case SID_ATTR_PARA_RIGHT_TO_LEFT :
//STRIP001         {
//STRIP001             BOOL bSet = TRUE;
//STRIP001             int eState = pArgs ? pArgs->GetItemState(nSlot) : SFX_ITEM_DISABLED;
//STRIP001             if (pArgs && SFX_ITEM_SET == eState)
//STRIP001                 bSet = ((const SfxBoolItem&)pArgs->Get(nSlot)).GetValue();
//STRIP001 /*
//STRIP001 // toggling of the slots not used anymore
//STRIP001 
//STRIP001            if(!bSet)
//STRIP001 				nSlot = SID_ATTR_PARA_LEFT_TO_RIGHT == nSlot ? 
//STRIP001 					SID_ATTR_PARA_RIGHT_TO_LEFT :
//STRIP001 					SID_ATTR_PARA_LEFT_TO_RIGHT;
//STRIP001 */
//STRIP001             SfxItemSet aAdjustSet( GetPool(),
//STRIP001                     RES_PARATR_ADJUST, RES_PARATR_ADJUST );
//STRIP001 			GetShell().GetAttr(aAdjustSet);
//STRIP001             BOOL bChgAdjust = FALSE;
//STRIP001             if (aAdjustSet.GetItemState(RES_PARATR_ADJUST, FALSE)  >= SFX_ITEM_DEFAULT)
//STRIP001             {
//STRIP001                 int eAdjust = (int)(( const SvxAdjustItem& ) 
//STRIP001 						aAdjustSet.Get(RES_PARATR_ADJUST)).GetAdjust();
//STRIP001 //                bChgAdjust = SVX_ADJUST_CENTER  != eAdjust  &&  SVX_ADJUST_BLOCK != eAdjust;
//STRIP001                 bChgAdjust = (SVX_ADJUST_LEFT  == eAdjust  &&  SID_ATTR_PARA_RIGHT_TO_LEFT == nSlot) ||
//STRIP001                              (SVX_ADJUST_RIGHT == eAdjust  &&  SID_ATTR_PARA_LEFT_TO_RIGHT == nSlot);
//STRIP001             }
//STRIP001 
//STRIP001             SvxFrameDirection eFrmDirection =
//STRIP001                     (SID_ATTR_PARA_LEFT_TO_RIGHT == nSlot) ?
//STRIP001                         FRMDIR_HORI_LEFT_TOP : FRMDIR_HORI_RIGHT_TOP;
//STRIP001             aSet.Put( SvxFrameDirectionItem( eFrmDirection, RES_FRAMEDIR ) );
//STRIP001 
//STRIP001             if (bChgAdjust)
//STRIP001             {
//STRIP001                 SvxAdjust eAdjust = (SID_ATTR_PARA_LEFT_TO_RIGHT == nSlot) ?
//STRIP001                         SVX_ADJUST_LEFT : SVX_ADJUST_RIGHT;
//STRIP001                 aSet.Put( SvxAdjustItem( eAdjust, RES_PARATR_ADJUST ) );
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			ASSERT(FALSE, falscher Dispatcher);
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	SwWrtShell& rWrtSh = GetShell();
//STRIP001 	SwTxtFmtColl* pColl = rWrtSh.GetCurTxtFmtColl();
//STRIP001 	if(pColl && pColl->IsAutoUpdateFmt())
//STRIP001 	{
//STRIP001 		rWrtSh.AutoUpdatePara(pColl, aSet);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rWrtSh.SetAttr( aSet );
//STRIP001     rReq.Done();
//STRIP001 }

#endif



//STRIP001 void SwTextShell::ExecParaAttrArgs(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 	const SfxItemSet *pArgs = rReq.GetArgs();
//STRIP001 	const SfxPoolItem *pItem = 0;
//STRIP001 
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	if(pArgs)
//STRIP001 		pArgs->GetItemState(GetPool().GetWhich(nSlot), FALSE, &pItem);
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001         case FN_DROP_CHAR_STYLE_NAME:
//STRIP001             if( pItem )
//STRIP001             {
//STRIP001                 String sCharStyleName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001                 SfxItemSet aSet(GetPool(), RES_PARATR_DROP, RES_PARATR_DROP, 0L);
//STRIP001                 rSh.GetAttr(aSet);
//STRIP001                 SwFmtDrop aDropItem((const SwFmtDrop&)aSet.Get(RES_PARATR_DROP));
//STRIP001                 SwCharFmt* pFmt = 0;
//STRIP001                 if(sCharStyleName.Len())
//STRIP001                     pFmt = rSh.FindCharFmtByName( sCharStyleName );
//STRIP001                 aDropItem.SetCharFmt( pFmt );
//STRIP001                 aSet.Put(aDropItem);
//STRIP001                 rSh.SetAttr(aSet);
//STRIP001             }
//STRIP001         break;
//STRIP001         case FN_FORMAT_DROPCAPS:
//STRIP001         {
//STRIP001 			if(pItem)
//STRIP001             {
//STRIP001 				rSh.SetAttr(*pItem);
//STRIP001                 rReq.Done();
//STRIP001             }
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SfxItemSet aSet(GetPool(), RES_PARATR_DROP, RES_PARATR_DROP,
//STRIP001 										   HINT_END, HINT_END, 0);
//STRIP001 				rSh.GetAttr(aSet);
//STRIP001                 SwDropCapsDlg *pDlg = new SwDropCapsDlg(GetView().GetWindow(), aSet);
//STRIP001 				if (pDlg->Execute() == RET_OK)
//STRIP001 				{
//STRIP001 					rSh.StartAction();
//STRIP001 					rSh.StartUndo( UNDO_START );
//STRIP001 					if ( SFX_ITEM_SET == aSet.GetItemState(HINT_END,FALSE,&pItem) )
//STRIP001 					{
//STRIP001 						if ( ((SfxStringItem*)pItem)->GetValue().Len() )
//STRIP001 							rSh.ReplaceDropTxt(((SfxStringItem*)pItem)->GetValue());
//STRIP001 					}
//STRIP001 					rSh.SetAttr(*pDlg->GetOutputItemSet());
//STRIP001 					rSh.StartUndo( UNDO_END );
//STRIP001 					rSh.EndAction();
//STRIP001                     rReq.Done(*pDlg->GetOutputItemSet());
//STRIP001 				}
//STRIP001 				delete pDlg;
//STRIP001 			}
//STRIP001 		}
//STRIP001  		break;
//STRIP001 		case SID_ATTR_PARA_PAGEBREAK:
//STRIP001 			if(pItem)
//STRIP001 			{
//STRIP001 				rSh.SetAttr( *pItem );
//STRIP001                 rReq.Done();
//STRIP001 			}
//STRIP001 		break;
//STRIP001 		case SID_ATTR_PARA_MODEL:
//STRIP001 		{
//STRIP001 			if(pItem)
//STRIP001 			{
//STRIP001 				SfxItemSet aCoreSet( GetPool(),
//STRIP001 					RES_PAGEDESC,	RES_PAGEDESC,
//STRIP001 					SID_ATTR_PARA_MODEL, SID_ATTR_PARA_MODEL, 0);
//STRIP001 				aCoreSet.Put(*pItem);
//STRIP001 				SfxToSwPageDescAttr( rSh, aCoreSet);
//STRIP001 				rSh.SetAttr(aCoreSet);
//STRIP001                 rReq.Done();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			ASSERT(FALSE, falscher Dispatcher);
//STRIP001 			return;
//STRIP001 	}
//STRIP001 }



/*M*/ void SwTextShell::GetAttrState(SfxItemSet &rSet)
/*M*/ {
/*M*/ 	SwWrtShell &rSh = GetShell();
/*M*/ 	SfxItemPool& rPool = GetPool();
/*M*/ 	SfxItemSet aCoreSet(rPool, aTxtFmtCollSetRange);
/*M*/ 	rSh.GetAttr(aCoreSet);	// *alle* Textattribute von der Core erfragen
/*M*/ 
/*M*/ 	SfxWhichIter aIter(rSet);
/*M*/ 	register USHORT nSlot = aIter.FirstWhich();
/*M*/ 	register int bFlag;
/*M*/ 	SfxBoolItem aFlagItem;
/*M*/ 	const SfxPoolItem* pItem = 0;
/*M*/ 	int eAdjust = -1;	// Illegaler Wert, um DONTCARE zu erkennen
/*M*/ 	SfxItemState eState = aCoreSet.GetItemState(RES_PARATR_ADJUST, FALSE, &pItem);
/*M*/ 
/*M*/ 	if( SFX_ITEM_DEFAULT == eState )
/*M*/ 		pItem = &rPool.GetDefaultItem(RES_PARATR_ADJUST);
/*M*/ 	if( SFX_ITEM_DEFAULT <= eState )
/*M*/ 		eAdjust = (int)(( SvxAdjustItem* ) pItem)->GetAdjust();
/*M*/ 
/*M*/ 	short nEsc = 0;
/*M*/ 	eState =  aCoreSet.GetItemState(RES_CHRATR_ESCAPEMENT, FALSE, &pItem);
/*M*/ 	if( SFX_ITEM_DEFAULT == eState )
/*M*/ 		pItem = &rPool.GetDefaultItem(RES_CHRATR_ESCAPEMENT);
/*M*/ 	if( eState >= SFX_ITEM_DEFAULT )
/*M*/ 		nEsc = ((SvxEscapementItem* )pItem)->GetEsc();
/*M*/ 
/*M*/ 	USHORT nLineSpace = 0;
/*M*/ 	eState =  aCoreSet.GetItemState(RES_PARATR_LINESPACING, FALSE, &pItem);
/*M*/ 	if( SFX_ITEM_DEFAULT == eState )
/*M*/ 		pItem = &rPool.GetDefaultItem(RES_PARATR_LINESPACING);
/*M*/ 	if( SFX_ITEM_DEFAULT <= eState &&
/*M*/ 			((SvxLineSpacingItem* )pItem)->GetLineSpaceRule() == SVX_LINE_SPACE_AUTO )
/*M*/ 	{
/*M*/ 		if(SVX_INTER_LINE_SPACE_OFF ==
/*M*/ 					((SvxLineSpacingItem* )pItem)->GetInterLineSpaceRule())
/*M*/ 			nLineSpace = 100;
/*M*/ 		else
/*M*/ 			nLineSpace = ((SvxLineSpacingItem* )pItem)->GetPropLineSpace();
/*M*/ 	}
/*M*/ 
/*M*/ 	while (nSlot)
/*M*/ 	{
/*M*/ 		switch(nSlot)
/*M*/ 		{
/*M*/ 			case FN_SET_SUPER_SCRIPT:
/*M*/ 					bFlag = 0 < nEsc;
/*M*/ 				break;
/*M*/ 			case FN_SET_SUB_SCRIPT:
/*M*/ 					bFlag = 0 > nEsc;
/*M*/ 				break;
/*M*/ 			case SID_ATTR_PARA_ADJUST_LEFT:
/*M*/ 				if (eAdjust == -1)
/*M*/ 				{
/*M*/ 					rSet.InvalidateItem( nSlot );
/*M*/ 					nSlot = 0;
/*M*/ 				}
/*M*/ 				else
/*M*/ 					bFlag = SVX_ADJUST_LEFT == eAdjust;
/*M*/ 				break;
/*M*/ 			case SID_ATTR_PARA_ADJUST_RIGHT:
/*M*/ 				if (eAdjust == -1)
/*M*/ 				{
/*M*/ 					rSet.InvalidateItem( nSlot );
/*M*/ 					nSlot = 0;
/*M*/ 				}
/*M*/ 				else
/*M*/ 					bFlag = SVX_ADJUST_RIGHT == eAdjust;
/*M*/ 				break;
/*M*/ 			case SID_ATTR_PARA_ADJUST_CENTER:
/*M*/ 				if (eAdjust == -1)
/*M*/ 				{
/*M*/ 					rSet.InvalidateItem( nSlot );
/*M*/ 					nSlot = 0;
/*M*/ 				}
/*M*/ 				else
/*M*/ 					bFlag = SVX_ADJUST_CENTER == eAdjust;
/*M*/ 				break;
/*M*/ 			case SID_ATTR_PARA_ADJUST_BLOCK:
/*M*/ 			{
/*M*/ 				if (eAdjust == -1)
/*M*/ 				{
/*M*/ 					rSet.InvalidateItem( nSlot );
/*M*/ 					nSlot = 0;
/*M*/ 				}
/*M*/ 				else
/*M*/ 				{
/*M*/ 					bFlag = SVX_ADJUST_BLOCK == eAdjust;
/*M*/ 					USHORT nHtmlMode = GetHtmlMode(rSh.GetView().GetDocShell());
/*M*/ 					if((nHtmlMode & HTMLMODE_ON) && !(nHtmlMode & (HTMLMODE_FULL_STYLES|HTMLMODE_FIRSTLINE) ))
/*M*/ 					{
/*M*/ 						rSet.DisableItem( nSlot );
/*M*/ 						nSlot = 0;
/*M*/ 					}
/*M*/ 				}
/*M*/ 			}
/*M*/ 			break;
/*M*/ 			case SID_ATTR_PARA_LINESPACE_10:
/*M*/ 				bFlag = nLineSpace == 100;
/*M*/ 			break;
/*M*/ 			case SID_ATTR_PARA_LINESPACE_15:
/*M*/ 				bFlag = nLineSpace == 150;
/*M*/ 			break;
/*M*/ 			case SID_ATTR_PARA_LINESPACE_20:
/*M*/ 				bFlag = nLineSpace == 200;
/*M*/ 			break;
/*M*/ 			case FN_GROW_FONT_SIZE:
/*M*/ 			case FN_SHRINK_FONT_SIZE:
/*M*/ 			{
/*M*/ 				SvxScriptSetItem aSetItem( SID_ATTR_CHAR_FONTHEIGHT,
/*M*/ 											*rSet.GetPool() );
/*M*/ 				aSetItem.GetItemSet().Put( aCoreSet, FALSE );
/*M*/ 				if( !aSetItem.GetItemOfScript( rSh.GetScriptType() ))
/*M*/ 					rSet.DisableItem( nSlot );
/*M*/ 				nSlot = 0;
/*M*/ 			}
/*M*/ 			break;
/*M*/ 			case FN_UNDERLINE_DOUBLE:
/*M*/ 			{
/*M*/ 				eState = aCoreSet.GetItemState(RES_CHRATR_UNDERLINE);
/*M*/ 				if( eState >= SFX_ITEM_DEFAULT )
/*M*/ 				{
/*M*/ 					FontUnderline eUnderline =  ((const SvxUnderlineItem&)
/*M*/ 							aCoreSet.Get(RES_CHRATR_UNDERLINE)).GetUnderline();
/*M*/ 					rSet.Put(SfxBoolItem(nSlot, eUnderline == UNDERLINE_DOUBLE));
/*M*/ 				}
/*M*/ 				else
/*M*/ 					rSet.InvalidateItem(nSlot);
/*M*/ 				nSlot = 0;
/*M*/ 			}
/*M*/ 			break;
/*M*/ 			case SID_ATTR_PARA_ADJUST:
/*M*/ 				if (eAdjust == -1)
/*M*/ 					rSet.InvalidateItem( nSlot );
/*M*/ 				else
/*M*/ 					rSet.Put(SvxAdjustItem((SvxAdjust)eAdjust, SID_ATTR_PARA_ADJUST ));
/*M*/ 				nSlot = 0;
/*M*/ 			break;
/*M*/ 
/*M*/             case SID_ATTR_PARA_LEFT_TO_RIGHT :
/*N*/             case SID_ATTR_PARA_RIGHT_TO_LEFT :
/*N*/             {
/*N*/               if ( !SW_MOD()->GetCTLOptions().IsCTLFontEnabled() )
/*N*/ 				{
/*N*/ 					rSet.DisableItem( nSlot );
/*N*/ 					nSlot = 0;
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*?*/                     // is the item set?
/*?*/                     USHORT nHtmlMode = GetHtmlMode(rSh.GetView().GetDocShell());
/*?*/                     if((!(nHtmlMode & HTMLMODE_ON) || (0 != (nHtmlMode & HTMLMODE_SOME_STYLES))) &&
/*?*/                     aCoreSet.GetItemState( RES_FRAMEDIR, FALSE ) >= SFX_ITEM_DEFAULT)
/*?*/ 					{
/*?*/ 						SvxFrameDirection eFrmDir = (SvxFrameDirection)
/*?*/ 								((const SvxFrameDirectionItem& )aCoreSet.Get(RES_FRAMEDIR)).GetValue();
/*?*/ 						if (FRMDIR_ENVIRONMENT == eFrmDir)
/*?*/ 						{
/*?*/ 							eFrmDir = rSh.IsInRightToLeftText() ?
/*?*/ 									FRMDIR_HORI_RIGHT_TOP : FRMDIR_HORI_LEFT_TOP;
/*?*/ 						}
/*?*/ 						bFlag = (SID_ATTR_PARA_LEFT_TO_RIGHT == nSlot &&
/*?*/ 											FRMDIR_HORI_LEFT_TOP == eFrmDir) ||
/*?*/ 								(SID_ATTR_PARA_RIGHT_TO_LEFT == nSlot &&
/*?*/ 											FRMDIR_HORI_RIGHT_TOP == eFrmDir);
/*?*/ 					}
/*?*/ 					else
/*?*/ 					{
/*?*/ 						rSet.InvalidateItem(nSlot);
/*?*/ 						nSlot = 0;
/*?*/ 					}
/*N*/ 				}
/*N*/             }
/*N*/             break;
/*N*/ 
/*N*/ 			case SID_ATTR_CHAR_LANGUAGE:
/*N*/ 			case SID_ATTR_CHAR_KERNING:
/*N*/ 			case RES_PARATR_DROP:
/*N*/ 			{
/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ 				const SfxPoolItem& rItem = aCoreSet.Get(GetPool().GetWhich(nSlot), TRUE);
/*N*/ 				rSet.Put(rItem);
/*N*/ #else
/*N*/ 				rSet.Put(aCoreSet.Get( GetPool().GetWhich(nSlot), TRUE));
/*N*/ #endif
/*N*/ 				nSlot = 0;
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_ATTR_PARA_MODEL:
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				SfxItemSet aTemp(GetPool(),
//STRIP001 /*?*/ 						RES_PAGEDESC,RES_PAGEDESC,
//STRIP001 /*?*/ 						SID_ATTR_PARA_MODEL,SID_ATTR_PARA_MODEL,
//STRIP001 /*?*/ 						0L);
//STRIP001 /*?*/ 				aTemp.Put(aCoreSet);
//STRIP001 /*?*/ 				::SwToSfxPageDescAttr(aTemp);
//STRIP001 /*?*/ 				rSet.Put(aTemp.Get(SID_ATTR_PARA_MODEL));
//STRIP001 /*?*/ 				nSlot = 0;
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case RES_TXTATR_INETFMT:
/*N*/ 			{
/*N*/ 				SfxItemSet aSet(GetPool(), RES_TXTATR_INETFMT, RES_TXTATR_INETFMT);
/*N*/ 				rSh.GetAttr(aSet);
/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ 				const SfxPoolItem& rItem = aSet.Get(RES_TXTATR_INETFMT, TRUE);
/*N*/ 				rSet.Put(rItem);
/*N*/ #else
/*N*/ 				rSet.Put(aSet.Get( RES_TXTATR_INETFMT, TRUE));
/*N*/ #endif
/*N*/ 				nSlot = 0;
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 			default:
/*N*/ 			// Nichts tun
/*N*/ 			nSlot = 0;
/*N*/ 			break;
/*N*/ 
/*N*/ 		}
/*N*/ 		if( nSlot )
/*N*/ 		{
/*N*/ 			aFlagItem.SetWhich( nSlot );
/*N*/ 			aFlagItem.SetValue( bFlag );
/*N*/ 			rSet.Put( aFlagItem );
/*N*/ 		}
/*N*/ 		nSlot = aIter.NextWhich();
/*N*/ 	}
/*N*/ 
/*N*/ 	rSet.Put(aCoreSet,FALSE);
/*N*/ }


}
