/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_numberingtypelistbox.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:20:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _NUMBERINGTYPELISTBOX_HXX
//STRIP001 #include <numberingtypelistbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MISC_HRC
//STRIP001 #include <misc.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _CNTTAB_HXX
//STRIP001 #include <cnttab.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_STYLE_NUMBERINGTYPE_HPP_
//STRIP001 #include <com/sun/star/style/NumberingType.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_TEXT_XDEFAULTNUMBERINGPROVIDER_HPP_
//STRIP001 #include <com/sun/star/text/XDefaultNumberingProvider.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
//STRIP001 #include <com/sun/star/lang/XMultiServiceFactory.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
//STRIP001 #include <comphelper/processfactory.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_TEXT_XNUMBERINGTYPEINFO_HPP_
//STRIP001 #include <com/sun/star/text/XNumberingTypeInfo.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX 
//STRIP001 #include <svtools/languageoptions.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _LEGACYBINFILTERMGR_HXX
//STRIP001 #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
//STRIP001 #endif
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::text;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::style;
//STRIP001 using namespace rtl;
//STRIP001 
//STRIP001 #define C2S(cChar) UniString::CreateFromAscii(cChar)
//STRIP001 /* -----------------------------01.03.01 16:04--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 struct SwNumberingTypeListBox_Impl
//STRIP001 {
//STRIP001 	Reference<XNumberingTypeInfo> xInfo;
//STRIP001 };
//STRIP001 /* -----------------------------01.03.01 14:46--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SwNumberingTypeListBox::SwNumberingTypeListBox( Window* pWin, const ResId& rResId,
//STRIP001 		USHORT nTypeFlags ) :
//STRIP001 	ListBox(pWin, rResId),
//STRIP001 	pImpl(new SwNumberingTypeListBox_Impl)
//STRIP001 {
//STRIP001 	Reference< XMultiServiceFactory > xMSF = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 	Reference < XInterface > xI = xMSF->createInstance(
//STRIP001 		::rtl::OUString::createFromAscii( "com.sun.star.text.DefaultNumberingProvider" ) );
//STRIP001 	Reference<XDefaultNumberingProvider> xDefNum(xI, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xDefNum.is(), "service missing: \"com.sun.star.text.DefaultNumberingProvider\"")
//STRIP001 
//STRIP001 	pImpl->xInfo = Reference<XNumberingTypeInfo>(xDefNum, UNO_QUERY);
//STRIP001 	Reload(nTypeFlags);
//STRIP001 }
//STRIP001 /* -----------------------------01.03.01 14:46--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SwNumberingTypeListBox::~SwNumberingTypeListBox()
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 }
//STRIP001 /* -----------------------------01.03.01 16:02--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwNumberingTypeListBox::Reload(USHORT nTypeFlags)
//STRIP001 {
//STRIP001 	Clear();
//STRIP001 	SwOLENames aNames(SW_RES(STRRES_NUMTYPES));
//STRIP001 	ResStringArray& rNames = aNames.GetNames();
//STRIP001 	for(sal_uInt16 i = 0; i < rNames.Count(); i++)
//STRIP001 	{
//STRIP001 		long nValue = rNames.GetValue(i);
//STRIP001 		sal_Bool bInsert = sal_True;
//STRIP001         USHORT nPos = LISTBOX_APPEND;
//STRIP001 		switch(nValue)
//STRIP001 		{
//STRIP001             case  NumberingType::NUMBER_NONE:
//STRIP001                 bInsert = 0 != (nTypeFlags&INSERT_NUM_TYPE_NO_NUMBERING);
//STRIP001                 nPos = 0;
//STRIP001              break;
//STRIP001 			case  NumberingType::CHAR_SPECIAL:	bInsert = 0 != (nTypeFlags&INSERT_NUM_TYPE_BULLET); break;
//STRIP001 			case  NumberingType::PAGE_DESCRIPTOR:bInsert = 0 != (nTypeFlags&INSERT_NUM_TYPE_PAGE_STYLE_NUMBERING); break;
//STRIP001 			case  NumberingType::BITMAP:bInsert = 0 != (nTypeFlags&INSERT_NUM_TYPE_BITMAP ); break;
//STRIP001 		}
//STRIP001 		if(bInsert)
//STRIP001 		{
//STRIP001             USHORT nEntry = InsertEntry(rNames.GetString(i), nPos);
//STRIP001             SetEntryData( nEntry, (void*)nValue );
//STRIP001 		}
//STRIP001 	}
//STRIP001     //#104079# extended numberings are only insert when CJK support is switched on
//STRIP001     SvtLanguageOptions aLangOpt;
//STRIP001     if(0 != (nTypeFlags&INSERT_NUM_EXTENDED_TYPES) && 
//STRIP001             (aLangOpt.IsCJKFontEnabled() || aLangOpt.IsCTLFontEnabled()))
//STRIP001 	{
//STRIP001 		if(pImpl->xInfo.is())
//STRIP001 		{
//STRIP001 			Sequence<sal_Int16> aTypes = pImpl->xInfo->getSupportedNumberingTypes(  );
//STRIP001 			const sal_Int16* pTypes = aTypes.getConstArray();
//STRIP001 			for(sal_Int32 nType = 0; nType < aTypes.getLength(); nType++)
//STRIP001 			{
//STRIP001 				sal_Int16 nCurrent = pTypes[nType];
//STRIP001 				if(nCurrent > NumberingType::CHARS_LOWER_LETTER_N)
//STRIP001 				{
//STRIP001 					if(LISTBOX_ENTRY_NOTFOUND == GetEntryPos((void*)(ULONG)nCurrent))
//STRIP001 					{
//STRIP001     					OUString aIdent = pImpl->xInfo->getNumberingIdentifier( nCurrent );
//STRIP001 						USHORT nPos = InsertEntry(aIdent);
//STRIP001 						SetEntryData(nPos,(void*)(ULONG)nCurrent);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		SelectEntryPos(0);
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------01.03.01 14:46--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 sal_Int16 	SwNumberingTypeListBox::GetSelectedNumberingType()
//STRIP001 {
//STRIP001 	sal_Int16 nRet = 0;
//STRIP001 	USHORT nSelPos = GetSelectEntryPos();
//STRIP001 	if(LISTBOX_ENTRY_NOTFOUND != nSelPos)
//STRIP001 		nRet = (sal_Int16)(ULONG)GetEntryData(nSelPos);
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	else
//STRIP001 		DBG_ERROR("SwNumberingTypeListBox not selected")
//STRIP001 #endif
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 /* -----------------------------01.03.01 14:46--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool 	SwNumberingTypeListBox::SelectNumberingType(sal_Int16 nType)
//STRIP001 {
//STRIP001 	USHORT nPos = GetEntryPos((void*)(ULONG)nType);
//STRIP001 	SelectEntryPos( nPos );
//STRIP001 	return LISTBOX_ENTRY_NOTFOUND != nPos;
//STRIP001 }

}
