/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_untbl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:47:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#define ITEMID_BOXINFO      SID_ATTR_BORDER_INNER
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef _SVX_BRKITEM_HXX //autogen
// auto strip #include <bf_svx/brkitem.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _FMTORNT_HXX //autogen
// auto strip #include <fmtornt.hxx>
// auto strip #endif
// auto strip #ifndef _FMTPDSC_HXX //autogen
// auto strip #include <fmtpdsc.hxx>
// auto strip #endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
// auto strip #ifndef _DOCARY_HXX
// auto strip #include <docary.hxx>
// auto strip #endif
// auto strip #ifndef _NDARR_HXX
// auto strip #include <ndarr.hxx>
// auto strip #endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>
// auto strip #endif
// auto strip #ifndef _SWTABLE_HXX
// auto strip #include <swtable.hxx>
// auto strip #endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _CNTFRM_HXX
// auto strip #include <cntfrm.hxx>
// auto strip #endif
// auto strip #ifndef _TBLSEL_HXX
// auto strip #include <tblsel.hxx>
// auto strip #endif
// auto strip #ifndef _HINTS_HXX
// auto strip #include <hints.hxx>
// auto strip #endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
// auto strip #ifndef _ROLBCK_HXX
// auto strip #include <rolbck.hxx>
// auto strip #endif
#ifndef _DDEFLD_HXX
#include <ddefld.hxx>
#endif
// auto strip #ifndef _TABCOL_HXX
// auto strip #include <tabcol.hxx>
// auto strip #endif
// auto strip #ifndef _TABFRM_HXX
// auto strip #include <tabfrm.hxx>
// auto strip #endif
// auto strip #ifndef _ROWFRM_HXX
// auto strip #include <rowfrm.hxx>
// auto strip #endif
// auto strip #ifndef _CELLFRM_HXX
// auto strip #include <cellfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SWCACHE_HXX
// auto strip #include <swcache.hxx>
// auto strip #endif
// auto strip #ifndef _TBLAFMT_HXX
// auto strip #include <tblafmt.hxx>
// auto strip #endif
// auto strip #ifndef _POOLFMT_HXX
// auto strip #include <poolfmt.hxx>
// auto strip #endif
// auto strip #ifndef _MVSAVE_HXX
// auto strip #include <mvsave.hxx>
// auto strip #endif
// auto strip #ifndef _CELLATR_HXX
// auto strip #include <cellatr.hxx>
// auto strip #endif
// auto strip #ifndef _SWTBLFMT_HXX
// auto strip #include <swtblfmt.hxx>
// auto strip #endif
// auto strip #ifndef _SWDDETBL_HXX
// auto strip #include <swddetbl.hxx>
// auto strip #endif
#ifndef _REDLINE_HXX
#include <redline.hxx>
#endif
// auto strip #ifndef _NODE2LAY_HXX
// auto strip #include <node2lay.hxx>
// auto strip #endif
// auto strip #ifndef _TBLRWCL_HXX
// auto strip #include <tblrwcl.hxx>
// auto strip #endif
// auto strip #ifndef _FMTANCHR_HXX
// auto strip #include <fmtanchr.hxx>
// auto strip #endif
namespace binfilter {

//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }
//STRIP001 extern void ClearFEShellTabCols();

//STRIP001 typedef SfxItemSet* SfxItemSetPtr;
//STRIP001 SV_DECL_PTRARR_DEL( SfxItemSets, SfxItemSetPtr, 10, 5 )

//STRIP001 typedef SwUndoSaveSection* SwUndoSaveSectionPtr;
//STRIP001 SV_DECL_PTRARR_DEL( SwUndoSaveSections, SwUndoSaveSectionPtr, 0, 10 )

//STRIP001 typedef SwUndoMove* SwUndoMovePtr;
//STRIP001 SV_DECL_PTRARR_DEL( SwUndoMoves, SwUndoMovePtr, 0, 10 )

//STRIP001 struct SwTblToTxtSave;
//STRIP001 typedef SwTblToTxtSave* SwTblToTxtSavePtr;
//STRIP001 SV_DECL_PTRARR_DEL( SwTblToTxtSaves, SwTblToTxtSavePtr, 0, 10 )

//STRIP001 struct _UndoTblCpyTbl_Entry
//STRIP001 {
//STRIP001 	ULONG nBoxIdx, nOffset;
//STRIP001 	SfxItemSet* pBoxNumAttr;
//STRIP001 	SwUndoDelete* pUndo;
//STRIP001 
//STRIP001 	_UndoTblCpyTbl_Entry( const SwTableBox& rBox );
//STRIP001 	~_UndoTblCpyTbl_Entry();
//STRIP001 };
//STRIP001 typedef _UndoTblCpyTbl_Entry* _UndoTblCpyTbl_EntryPtr;
//STRIP001 SV_DECL_PTRARR_DEL( _UndoTblCpyTbl_Entries, _UndoTblCpyTbl_EntryPtr, 0, 10 )

//STRIP001 class _SaveBox;
//STRIP001 class _SaveLine;

//STRIP001 class _SaveTable
//STRIP001 {
//STRIP001 	friend class _SaveBox;
//STRIP001 	friend class _SaveLine;
//STRIP001 	_SaveLine* pLine;
//STRIP001 	const SwTable* pSwTable;
//STRIP001 	SfxItemSets aSets;
//STRIP001 	SwFrmFmts aFrmFmts;
//STRIP001 	SfxItemSet aTblSet;
//STRIP001 	USHORT nLineCount;
//STRIP001 	BOOL bModifyBox : 1;
//STRIP001 	BOOL bSaveFormula : 1;
//STRIP001 
//STRIP001 public:
//STRIP001 	_SaveTable( const SwTable& rTbl, USHORT nLnCnt = USHRT_MAX,
//STRIP001 				BOOL bSaveFml = TRUE );
//STRIP001 	~_SaveTable();
//STRIP001 
//STRIP001 	USHORT AddFmt( SwFrmFmt* pFmt );
//STRIP001 	void NewFrmFmt( const SwClient* pLnBx, BOOL bIsLine, USHORT nFmtPos,
//STRIP001 					SwFrmFmt* pOldFmt );
//STRIP001 
//STRIP001 	void RestoreAttr( SwTable& rTbl, BOOL bModifyBox = FALSE );
//STRIP001 	void SaveCntntAttrs( SwDoc* pDoc );
//STRIP001 	void CreateNew( SwTable& rTbl, BOOL bCreateFrms = TRUE,
//STRIP001 					BOOL bRestoreChart = TRUE );
//STRIP001 };

//STRIP001 class _SaveLine
//STRIP001 {
//STRIP001 	friend class _SaveTable;
//STRIP001 	friend class _SaveBox;
//STRIP001 
//STRIP001 	_SaveLine* pNext;
//STRIP001 	_SaveBox* pBox;
//STRIP001 	USHORT nItemSet;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 	_SaveLine( _SaveLine* pPrev, const SwTableLine& rLine, _SaveTable& rSTbl );
//STRIP001 	~_SaveLine();
//STRIP001 
//STRIP001 	void RestoreAttr( SwTableLine& rLine, _SaveTable& rSTbl );
//STRIP001 	void SaveCntntAttrs( SwDoc* pDoc );
//STRIP001 
//STRIP001 	void CreateNew( SwTable& rTbl, SwTableBox& rParent, _SaveTable& rSTbl  );
//STRIP001 };

//STRIP001 class _SaveBox
//STRIP001 {
//STRIP001 	friend class _SaveLine;
//STRIP001 
//STRIP001 	_SaveBox* pNext;
//STRIP001 	ULONG nSttNode;
//STRIP001 	USHORT nItemSet;
//STRIP001 	union
//STRIP001 	{
//STRIP001 		SfxItemSets* pCntntAttrs;
//STRIP001 		_SaveLine* pLine;
//STRIP001 	} Ptrs;
//STRIP001 
//STRIP001 public:
//STRIP001 	_SaveBox( _SaveBox* pPrev, const SwTableBox& rBox, _SaveTable& rSTbl );
//STRIP001 	~_SaveBox();
//STRIP001 
//STRIP001 	void RestoreAttr( SwTableBox& rBox, _SaveTable& rSTbl );
//STRIP001 	void SaveCntntAttrs( SwDoc* pDoc );
//STRIP001 
//STRIP001 	void CreateNew( SwTable& rTbl, SwTableLine& rParent, _SaveTable& rSTbl );
//STRIP001 };

//STRIP001 void InsertSort( SvUShorts& rArr, USHORT nIdx, USHORT* pInsPos = 0 );
//STRIP001 void InsertSort( SvULongs& rArr, ULONG nIdx, USHORT* pInsPos = 0 );

//STRIP001 #if defined( JP_DEBUG ) && !defined( PRODUCT )
//STRIP001 #include "shellio.hxx"
//STRIP001 void DumpDoc( SwDoc* pDoc, const String& rFileNm );
//STRIP001 void CheckTable( const SwTable& );
//STRIP001 #define DUMPDOC(p,s)	DumpDoc( p, s);
//STRIP001 #define CHECKTABLE(t) CheckTable( t );
//STRIP001 #else
//STRIP001 #define DUMPDOC(p,s)
//STRIP001 #define CHECKTABLE(t)
//STRIP001 #endif

//STRIP001 struct SwTblToTxtSave
//STRIP001 {
//STRIP001 	ULONG nNode;
//STRIP001 	xub_StrLen nCntnt;
//STRIP001 	SwHistory* pHstry;
//STRIP001 
//STRIP001 	SwTblToTxtSave( SwDoc& rDoc, ULONG nNd, xub_StrLen nCntnt = STRING_MAXLEN );
//STRIP001 	~SwTblToTxtSave() { delete pHstry; }
//STRIP001 };

//STRIP001 SV_IMPL_PTRARR( SfxItemSets, SfxItemSetPtr )
//STRIP001 SV_IMPL_PTRARR( SwUndoSaveSections, SwUndoSaveSectionPtr )
//STRIP001 SV_IMPL_PTRARR( SwUndoMoves, SwUndoMovePtr )
//STRIP001 SV_IMPL_PTRARR( SwTblToTxtSaves, SwTblToTxtSavePtr )
//STRIP001 SV_IMPL_PTRARR( _UndoTblCpyTbl_Entries, _UndoTblCpyTbl_EntryPtr )

//STRIP001 USHORT __FAR_DATA aSave_BoxCntntSet[] = {
//STRIP001 	RES_CHRATR_COLOR, RES_CHRATR_CROSSEDOUT,
//STRIP001 	RES_CHRATR_FONT, RES_CHRATR_FONTSIZE,
//STRIP001 	RES_CHRATR_POSTURE,	RES_CHRATR_POSTURE,
//STRIP001 	RES_CHRATR_SHADOWED, RES_CHRATR_WEIGHT,
//STRIP001 	RES_PARATR_ADJUST, RES_PARATR_ADJUST,
//STRIP001 	0 };



/*N*/ SwUndoInsTbl::SwUndoInsTbl( const SwPosition& rPos, USHORT nCl, USHORT nRw,
/*N*/ 							USHORT nAdj, USHORT nInsert,
/*N*/ 							const SwTableAutoFmt* pTAFmt,
/*N*/ 							const SvUShorts* pColArr )
/*N*/ 	: SwUndo( UNDO_INSTABLE ), nSttNode( rPos.nNode.GetIndex() ),
/*N*/ 	nRows( nRw ), nCols( nCl ), nAdjust( nAdj ), pDDEFldType( 0 ),
/*N*/ 	nInsTblFlags( nInsert ), pColWidth( 0 ), pRedlData( 0 ), pAutoFmt( 0 )
/*N*/ {
/*N*/ 	if( pColArr )
/*N*/ 	{
/*?*/ 		pColWidth = new SvUShorts( 0, 1 );
/*?*/ 		pColWidth->Insert( pColArr, 0 );
/*N*/ 	}
/*N*/ 	if( pTAFmt )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 pAutoFmt = new SwTableAutoFmt( *pTAFmt );
/*N*/ 
/*N*/ 	// Redline beachten
/*N*/ 	SwDoc& rDoc = *rPos.nNode.GetNode().GetDoc();
/*N*/ 	if( rDoc.IsRedlineOn() )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pRedlData = new SwRedlineData( REDLINE_INSERT, rDoc.GetRedlineAuthor() );
//STRIP001 /*?*/ 		SetRedlineMode( rDoc.GetRedlineMode() );
/*N*/ 	}
/*N*/ }


/*N*/ SwUndoInsTbl::~SwUndoInsTbl()
/*N*/ {
/*N*/ 	delete pDDEFldType;
/*N*/ 	delete pColWidth;
//STRIP001 /*?*/ 	delete pRedlData;
//STRIP001 /*?*/ 	delete pAutoFmt;
/*N*/ }



//STRIP001 void SwUndoInsTbl::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwNodeIndex aIdx( rDoc.GetNodes(), nSttNode );
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = aIdx.GetNode().GetTableNode();
//STRIP001 	ASSERT( pTblNd, "kein TabellenNode" );
//STRIP001 	pTblNd->DelFrms();
//STRIP001 
//STRIP001 	if( IsRedlineOn( GetRedlineMode() ))
//STRIP001 		rDoc.DeleteRedline( *pTblNd );
//STRIP001 	RemoveIdxFromSection( rDoc, nSttNode );
//STRIP001 
//STRIP001 	// harte SeitenUmbrueche am nachfolgenden Node verschieben
//STRIP001 	SwCntntNode* pNextNd = rDoc.GetNodes()[ pTblNd->EndOfSectionIndex()+1 ]->GetCntntNode();
//STRIP001 	if( pNextNd )
//STRIP001 	{
//STRIP001 		SwFrmFmt* pTableFmt = pTblNd->GetTable().GetFrmFmt();
//STRIP001 		const SfxPoolItem *pItem;
//STRIP001 
//STRIP001 		if( SFX_ITEM_SET == pTableFmt->GetItemState( RES_PAGEDESC,
//STRIP001 			FALSE, &pItem ) )
//STRIP001 			pNextNd->SetAttr( *pItem );
//STRIP001 
//STRIP001 		if( SFX_ITEM_SET == pTableFmt->GetItemState( RES_BREAK,
//STRIP001 			FALSE, &pItem ) )
//STRIP001 			pNextNd->SetAttr( *pItem );
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	sTblNm = pTblNd->GetTable().GetFrmFmt()->GetName();
//STRIP001 	if( pTblNd->GetTable().IsA( TYPE( SwDDETable )) )
//STRIP001 		pDDEFldType = (SwDDEFieldType*)((SwDDETable&)pTblNd->GetTable()).
//STRIP001 										GetDDEFldType()->Copy();
//STRIP001 
//STRIP001 	rDoc.GetNodes().Delete( aIdx, pTblNd->EndOfSectionIndex() -
//STRIP001 								aIdx.GetIndex() + 1 );
//STRIP001 
//STRIP001 	rUndoIter.pAktPam->DeleteMark();
//STRIP001 	rUndoIter.pAktPam->GetPoint()->nNode = aIdx;
//STRIP001 	rUndoIter.pAktPam->GetPoint()->nContent.Assign(
//STRIP001 							rUndoIter.pAktPam->GetCntntNode(), 0 );
//STRIP001 }


//STRIP001 void SwUndoInsTbl::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	SwPosition aPos( *rUndoIter.pAktPam->GetPoint() );
//STRIP001 	aPos.nNode = nSttNode;
//STRIP001 	const SwTable* pTbl = rDoc.InsertTable( aPos, nRows, nCols,
//STRIP001 									(SwHoriOrient)nAdjust,
//STRIP001 									nInsTblFlags, pAutoFmt, pColWidth );
//STRIP001 	((SwFrmFmt*)pTbl->GetFrmFmt())->SetName( sTblNm );
//STRIP001 	SwTableNode* pTblNode = (SwTableNode*)rDoc.GetNodes()[nSttNode]->GetTableNode();
//STRIP001 
//STRIP001 	if( pDDEFldType )
//STRIP001 	{
//STRIP001 		SwDDEFieldType* pNewType = (SwDDEFieldType*)rDoc.InsertFldType(
//STRIP001 															*pDDEFldType);
//STRIP001 		SwDDETable* pDDETbl = new SwDDETable( pTblNode->GetTable(), pNewType );
//STRIP001 		pTblNode->SetNewTable( pDDETbl );		// setze die DDE-Tabelle
//STRIP001 		delete pDDEFldType, pDDEFldType = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( (pRedlData && IsRedlineOn( GetRedlineMode() )) ||
//STRIP001 		( !( REDLINE_IGNORE & GetRedlineMode() ) &&
//STRIP001 			rDoc.GetRedlineTbl().Count() ))
//STRIP001 	{
//STRIP001 		SwPaM aPam( *pTblNode->EndOfSectionNode(), *pTblNode, 1 );
//STRIP001 		SwCntntNode* pCNd = aPam.GetCntntNode( FALSE );
//STRIP001 		if( pCNd )
//STRIP001 			aPam.GetMark()->nContent.Assign( pCNd, 0 );
//STRIP001 
//STRIP001 		if( pRedlData && IsRedlineOn( GetRedlineMode() ) )
//STRIP001 		{
//STRIP001 			SwRedlineMode eOld = rDoc.GetRedlineMode();
//STRIP001 			rDoc.SetRedlineMode_intern( eOld & ~REDLINE_IGNORE );
//STRIP001 
//STRIP001 			rDoc.AppendRedline( new SwRedline( *pRedlData, aPam ));
//STRIP001 			rDoc.SetRedlineMode_intern( eOld );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rDoc.SplitRedline( aPam );
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoInsTbl::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// keine Tabelle in Tabelle
//STRIP001 	if( !rUndoIter.pAktPam->GetNode()->FindTableNode() )
//STRIP001 		rUndoIter.GetDoc().InsertTable( *rUndoIter.pAktPam->GetPoint(),
//STRIP001 									nRows, nCols, (SwHoriOrient)nAdjust,
//STRIP001 									nInsTblFlags, pAutoFmt, pColWidth );
//STRIP001 }

// -----------------------------------------------------

//STRIP001 SwTblToTxtSave::SwTblToTxtSave( SwDoc& rDoc, ULONG nNd, xub_StrLen nCnt )
//STRIP001 	: nNode( nNd ), nCntnt( nCnt ), pHstry( 0 )
//STRIP001 {
//STRIP001 	// Attributierung des gejointen Node merken.
//STRIP001 	if( USHRT_MAX != nCnt )
//STRIP001 		++nNd;
//STRIP001 
//STRIP001 	SwTxtNode* pNd = rDoc.GetNodes()[ nNd ]->GetTxtNode();
//STRIP001 	if( pNd )
//STRIP001 	{
//STRIP001 		pHstry = new SwHistory;
//STRIP001 
//STRIP001 		pHstry->Add( pNd->GetTxtColl(), nNd, ND_TEXTNODE );
//STRIP001 		if( pNd->GetpSwpHints() )
//STRIP001 			pHstry->CopyAttr( pNd->GetpSwpHints(), nNd, 0,
//STRIP001 						pNd->GetTxt().Len(), FALSE );
//STRIP001 		if( pNd->GetpSwAttrSet() )
//STRIP001 			pHstry->CopyFmtAttr( *pNd->GetpSwAttrSet(), nNd );
//STRIP001 
//STRIP001 		if( !pHstry->Count() )
//STRIP001 			delete pHstry, pHstry = 0;
//STRIP001 	}
//STRIP001 }

//STRIP001 SwUndoTblToTxt::SwUndoTblToTxt( const SwTable& rTbl, sal_Unicode cCh )
//STRIP001 	: SwUndo( UNDO_TABLETOTEXT ),
//STRIP001 	nSttNd( 0 ), nEndNd( 0 ), cTrenner( cCh ), pDDEFldType( 0 ),
//STRIP001 	nAdjust( rTbl.GetFrmFmt()->GetHoriOrient().GetHoriOrient() ),
//STRIP001 	sTblNm( rTbl.GetFrmFmt()->GetName() ),
//STRIP001 	bHdlnRpt( rTbl.IsHeadlineRepeat() ),
//STRIP001 	pHistory( 0 )
//STRIP001 {
//STRIP001 	pTblSave = new _SaveTable( rTbl );
//STRIP001 	pBoxSaves = new SwTblToTxtSaves( (BYTE)rTbl.GetTabSortBoxes().Count() );
//STRIP001 
//STRIP001 	if( rTbl.IsA( TYPE( SwDDETable ) ) )
//STRIP001 		pDDEFldType = (SwDDEFieldType*)((SwDDETable&)rTbl).GetDDEFldType()->Copy();
//STRIP001 
//STRIP001 	bCheckNumFmt = rTbl.GetFrmFmt()->GetDoc()->IsInsTblFormatNum();
//STRIP001 
//STRIP001 	pHistory = new SwHistory;
//STRIP001 	const SwTableNode* pTblNd = rTbl.GetTableNode();
//STRIP001 	ULONG nTblStt = pTblNd->GetIndex(), nTblEnd = pTblNd->EndOfSectionIndex();
//STRIP001 
//STRIP001 	const SwSpzFrmFmts& rFrmFmtTbl = *pTblNd->GetDoc()->GetSpzFrmFmts();
//STRIP001 	for( USHORT n = 0; n < rFrmFmtTbl.Count(); ++n )
//STRIP001 	{
//STRIP001 		const SwPosition* pAPos;
//STRIP001 		const SwFrmFmt* pFmt = rFrmFmtTbl[ n ];
//STRIP001 		const SwFmtAnchor* pAnchor = &pFmt->GetAnchor();
//STRIP001 		if( 0 != ( pAPos = pAnchor->GetCntntAnchor()) &&
//STRIP001 			( FLY_AUTO_CNTNT == pAnchor->GetAnchorId() ||
//STRIP001 			  FLY_AT_CNTNT == pAnchor->GetAnchorId() ) &&
//STRIP001 			nTblStt <= pAPos->nNode.GetIndex() &&
//STRIP001 			pAPos->nNode.GetIndex() < nTblEnd )
//STRIP001 		{
//STRIP001 			pHistory->Add( *pFmt );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pHistory->Count() )
//STRIP001 		delete pHistory, pHistory = 0;
//STRIP001 }


//STRIP001 SwUndoTblToTxt::~SwUndoTblToTxt()
//STRIP001 {
//STRIP001 	delete pDDEFldType;
//STRIP001 	delete pTblSave;
//STRIP001 	delete pBoxSaves;
//STRIP001 	delete pHistory;
//STRIP001 }



//STRIP001 void SwUndoTblToTxt::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwPaM* pPam = rUndoIter.pAktPam;
//STRIP001 
//STRIP001 	SwNodeIndex aFrmIdx( rDoc.GetNodes(), nSttNd );
//STRIP001 	SwNodeIndex aEndIdx( rDoc.GetNodes(), nEndNd );
//STRIP001 
//STRIP001 	pPam->GetPoint()->nNode = aFrmIdx;
//STRIP001 	pPam->SetMark();
//STRIP001 	pPam->GetPoint()->nNode = aEndIdx;
//STRIP001 	rDoc.DelNumRules( *pPam );
//STRIP001 	pPam->DeleteMark();
//STRIP001 	SwNode2Layout* pNode2Layout = NULL;
//STRIP001 
//STRIP001 	// dann sammel mal alle Uppers ein
//STRIP001 	SwNode2Layout aNode2Layout( aFrmIdx.GetNode() );
//STRIP001 
//STRIP001 	// erzeuge die TabelleNode Structur
//STRIP001 	SwTableNode* pTblNd = rDoc.GetNodes().UndoTableToText( nSttNd, nEndNd,
//STRIP001 															*pBoxSaves );
//STRIP001 	SwTableFmt* pTableFmt = rDoc.MakeTblFrmFmt( sTblNm, rDoc.GetDfltFrmFmt() );
//STRIP001 	pTableFmt->Add( &pTblNd->GetTable() );		// das Frame-Format setzen
//STRIP001 	pTblNd->GetTable().SetHeadlineRepeat( bHdlnRpt );
//STRIP001 
//STRIP001 	// erzeuge die alte Tabellen Struktur
//STRIP001 	pTblSave->CreateNew( pTblNd->GetTable() );
//STRIP001 
//STRIP001 	if( pDDEFldType )
//STRIP001 	{
//STRIP001 		SwDDEFieldType* pNewType = (SwDDEFieldType*)rDoc.InsertFldType(
//STRIP001 															*pDDEFldType);
//STRIP001 		SwDDETable* pDDETbl = new SwDDETable( pTblNd->GetTable(), pNewType );
//STRIP001 		pTblNd->SetNewTable( pDDETbl, FALSE );		// setze die DDE-Tabelle
//STRIP001 		delete pDDEFldType, pDDEFldType = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bCheckNumFmt )
//STRIP001 	{
//STRIP001 		SwTableSortBoxes& rBxs = pTblNd->GetTable().GetTabSortBoxes();
//STRIP001 		for( USHORT nBoxes = rBxs.Count(); nBoxes; )
//STRIP001 			rDoc.ChkBoxNumFmt( *rBxs[ --nBoxes ], FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		USHORT nTmpEnd = pHistory->GetTmpEnd();
//STRIP001 		pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 		pHistory->SetTmpEnd( nTmpEnd );
//STRIP001 	}
//STRIP001 
//STRIP001 	aNode2Layout.RestoreUpperFrms( rDoc.GetNodes(),
//STRIP001 								   pTblNd->GetIndex(), pTblNd->GetIndex()+1 );
//STRIP001 
//STRIP001 	// will man eine TabellenSelektion ??
//STRIP001 	pPam->DeleteMark();
//STRIP001 	pPam->GetPoint()->nNode = *pTblNd->EndOfSectionNode();
//STRIP001 	pPam->SetMark();
//STRIP001 	pPam->GetPoint()->nNode = *pPam->GetNode()->StartOfSectionNode();
//STRIP001 	pPam->Move( fnMoveForward, fnGoCntnt );
//STRIP001 	pPam->Exchange();
//STRIP001 	pPam->Move( fnMoveBackward, fnGoCntnt );
//STRIP001 
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }

	// steht im untbl.cxx und darf nur vom Undoobject gerufen werden
//STRIP001 SwTableNode* SwNodes::UndoTableToText( ULONG nSttNd, ULONG nEndNd,
//STRIP001 								const SwTblToTxtSaves& rSavedData )
//STRIP001 {
//STRIP001 	SwNodeIndex aSttIdx( *this, nSttNd );
//STRIP001 	SwNodeIndex aEndIdx( *this, nEndNd+1 );
//STRIP001 
//STRIP001 	SwTableNode * pTblNd = new SwTableNode( aSttIdx );
//STRIP001 	SwEndNode* pEndNd = new SwEndNode( aEndIdx, *pTblNd  );
//STRIP001 
//STRIP001 	aEndIdx = *pEndNd;
//STRIP001 
//STRIP001 	/* Set pTblNd as start of section for all nodes in [nSttNd, nEndNd].
//STRIP001        Delete all Frames attached to the nodes in that range. */
//STRIP001 	SwNode* pNd;
//STRIP001 	{
//STRIP001 		ULONG n, nTmpEnd = aEndIdx.GetIndex();
//STRIP001 		for( n = pTblNd->GetIndex() + 1; n < nTmpEnd; ++n )
//STRIP001         {
//STRIP001 			if( ( pNd = (*this)[ n ] )->IsCntntNode() )
//STRIP001 				((SwCntntNode*)pNd)->DelFrms();
//STRIP001             pNd->pStartOfSection = pTblNd;
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	// dann die Tabellen Struktur teilweise aufbauen. Erstmal eine Line
//STRIP001 	// in der alle Boxen stehen! Die korrekte Struktur kommt dann aus der
//STRIP001 	// SaveStruct
//STRIP001 	SwTableBoxFmt* pBoxFmt = GetDoc()->MakeTableBoxFmt();
//STRIP001 	SwTableLineFmt* pLineFmt = GetDoc()->MakeTableLineFmt();
//STRIP001 	SwTableLine* pLine = new SwTableLine( pLineFmt, rSavedData.Count(), 0 );
//STRIP001 	pTblNd->GetTable().GetTabLines().C40_INSERT( SwTableLine, pLine, 0 );
//STRIP001 
//STRIP001 	SvULongs aBkmkArr( 0, 4 );
//STRIP001 	for( USHORT n = rSavedData.Count(); n; )
//STRIP001 	{
//STRIP001 		SwTblToTxtSave* pSave = rSavedData[ --n ];
//STRIP001 		aSttIdx = pSave->nNode;
//STRIP001 		SwTxtNode* pTxtNd = aSttIdx.GetNode().GetTxtNode();
//STRIP001 
//STRIP001 		if( USHRT_MAX != pSave->nCntnt )
//STRIP001 		{
//STRIP001 			// an der ContentPosition splitten, das vorherige Zeichen
//STRIP001 			// loeschen (ist der Trenner!)
//STRIP001 			ASSERT( pTxtNd, "Wo ist der TextNode geblieben?" );
//STRIP001 			SwIndex aCntPos( pTxtNd, pSave->nCntnt - 1 );
//STRIP001 
//STRIP001 			pTxtNd->Erase( aCntPos, 1 );
//STRIP001 			SwCntntNode* pNewNd = pTxtNd->SplitNode(
//STRIP001 										SwPosition( aSttIdx, aCntPos ));
//STRIP001 			if( aBkmkArr.Count() )
//STRIP001 				_RestoreCntntIdx( aBkmkArr, *pNewNd, pSave->nCntnt,
//STRIP001 													pSave->nCntnt + 1 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( aBkmkArr.Count() )
//STRIP001 				aBkmkArr.Remove( 0, aBkmkArr.Count() );
//STRIP001 			if( pTxtNd )
//STRIP001 				_SaveCntntIdx( GetDoc(), aSttIdx.GetIndex(),
//STRIP001 								pTxtNd->GetTxt().Len(), aBkmkArr );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pTxtNd )
//STRIP001 		{
//STRIP001 			if( pTxtNd->GetpSwAttrSet() )
//STRIP001 				pTxtNd->ResetAllAttr();
//STRIP001 
//STRIP001 			if( pTxtNd->GetpSwpHints() )
//STRIP001 				pTxtNd->ClearSwpHintsArr( FALSE, FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pSave->pHstry )
//STRIP001 		{
//STRIP001 			USHORT nTmpEnd = pSave->pHstry->GetTmpEnd();
//STRIP001 			pSave->pHstry->TmpRollback( GetDoc(), 0 );
//STRIP001 			pSave->pHstry->SetTmpEnd( nTmpEnd );
//STRIP001 		}
//STRIP001 
//STRIP001 		SwStartNode* pSttNd = new SwStartNode( aSttIdx, ND_STARTNODE,
//STRIP001 												SwTableBoxStartNode );
//STRIP001 		pSttNd->pStartOfSection = pTblNd;
//STRIP001 		new SwEndNode( aEndIdx, *pSttNd );
//STRIP001 
//STRIP001 		for( ULONG i = aSttIdx.GetIndex(); i < aEndIdx.GetIndex()-1; ++i )
//STRIP001 		{
//STRIP001 			pNd = (*this)[ i ];
//STRIP001 			pNd->pStartOfSection = pSttNd;
//STRIP001 			if( pNd->IsStartNode() )
//STRIP001 				i = pNd->EndOfSectionIndex();
//STRIP001 		}
//STRIP001 
//STRIP001 		SwTableBox* pBox = new SwTableBox( pBoxFmt, *pSttNd, pLine );
//STRIP001 		pLine->GetTabBoxes().C40_INSERT( SwTableBox, pBox, 0 );
//STRIP001 		aEndIdx = *pSttNd;
//STRIP001 	}
//STRIP001 	return pTblNd;
//STRIP001 }


//STRIP001 void SwUndoTblToTxt::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwPaM* pPam = rUndoIter.pAktPam;
//STRIP001 
//STRIP001 
//STRIP001 	pPam->GetPoint()->nNode = nSttNd;
//STRIP001 	pPam->GetPoint()->nContent.Assign( 0, 0 );
//STRIP001 	SwNodeIndex aSaveIdx( pPam->GetPoint()->nNode, -1 );
//STRIP001 
//STRIP001 	pPam->SetMark();            // alle Indizies abmelden
//STRIP001 	pPam->DeleteMark();
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = pPam->GetNode()->GetTableNode();
//STRIP001 	ASSERT( pTblNd, "keinen TableNode gefunden" );
//STRIP001 
//STRIP001 	if( pTblNd->GetTable().IsA( TYPE( SwDDETable )) )
//STRIP001 		pDDEFldType = (SwDDEFieldType*)((SwDDETable&)pTblNd->GetTable()).
//STRIP001 												GetDDEFldType()->Copy();
//STRIP001 
//STRIP001 	rDoc.TableToText( pTblNd, cTrenner );
//STRIP001 
//STRIP001 	aSaveIdx++;
//STRIP001 	SwCntntNode* pCNd = aSaveIdx.GetNode().GetCntntNode();
//STRIP001 	if( !pCNd && 0 == ( pCNd = rDoc.GetNodes().GoNext( &aSaveIdx ) ) &&
//STRIP001 		0 == ( pCNd = rDoc.GetNodes().GoPrevious( &aSaveIdx )) )
//STRIP001 		ASSERT( FALSE, "wo steht denn nun der TextNode" );
//STRIP001 
//STRIP001 	pPam->GetPoint()->nNode = aSaveIdx;
//STRIP001 	pPam->GetPoint()->nContent.Assign( pCNd, 0 );
//STRIP001 
//STRIP001 	pPam->SetMark();            // alle Indizies abmelden
//STRIP001 	pPam->DeleteMark();
//STRIP001 }


//STRIP001 void SwUndoTblToTxt::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwTableNode* pTblNd = rUndoIter.pAktPam->GetNode()->FindTableNode();
//STRIP001 	if( pTblNd )
//STRIP001 	{
//STRIP001 		// bewege den Cursor aus der Tabelle
//STRIP001 		SwPaM* pPam = rUndoIter.pAktPam;
//STRIP001 		pPam->GetPoint()->nNode = *pTblNd->EndOfSectionNode();
//STRIP001 		pPam->Move( fnMoveForward, fnGoCntnt );
//STRIP001 		pPam->SetMark();
//STRIP001 		pPam->DeleteMark();
//STRIP001 
//STRIP001 		rUndoIter.GetDoc().TableToText( pTblNd, cTrenner );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoTblToTxt::SetRange( const SwNodeRange& rRg )
//STRIP001 {
//STRIP001 	nSttNd = rRg.aStart.GetIndex();
//STRIP001 	nEndNd = rRg.aEnd.GetIndex();
//STRIP001 }

//STRIP001 void SwUndoTblToTxt::AddBoxPos( SwDoc& rDoc, ULONG nNdIdx, xub_StrLen nCntntIdx )
//STRIP001 {
//STRIP001 	SwTblToTxtSave* pNew = new SwTblToTxtSave( rDoc, nNdIdx, nCntntIdx );
//STRIP001 	pBoxSaves->Insert( pNew, pBoxSaves->Count() );
//STRIP001 }

// -----------------------------------------------------

/*N*/  SwUndoTxtToTbl::SwUndoTxtToTbl( const SwPaM& rRg, sal_Unicode cCh, USHORT nAdj,
/*N*/  								USHORT nInsert, const SwTableAutoFmt* pAFmt )
/*N*/  	: SwUndo( UNDO_TEXTTOTABLE ), SwUndRng( rRg ), pAutoFmt( 0 ),
/*N*/  	nAdjust( nAdj ), cTrenner( cCh ), pDelBoxes( 0 ), nInsTblFlags( nInsert ),
/*N*/  	pHistory( 0 )
/*N*/  
/*N*/  {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	if( pAFmt )
//STRIP001 		pAutoFmt = new SwTableAutoFmt( *pAFmt );
//STRIP001 
//STRIP001 	const SwPosition* pEnd = rRg.End();
//STRIP001 	SwNodes& rNds = rRg.GetDoc()->GetNodes();
//STRIP001 	bSplitEnd = pEnd->nContent.GetIndex() && ( pEnd->nContent.GetIndex()
//STRIP001 						!= pEnd->nNode.GetNode().GetCntntNode()->Len() ||
//STRIP001 				pEnd->nNode.GetIndex() >= rNds.GetEndOfContent().GetIndex()-1 );
/*N*/ }

/*N*/  SwUndoTxtToTbl::~SwUndoTxtToTbl()
/*N*/  {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	delete pDelBoxes;
//STRIP001 	delete pAutoFmt;
/*N*/ }

//STRIP001 void SwUndoTxtToTbl::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	ULONG nTblNd = nSttNode;
//STRIP001 	if( nSttCntnt )
//STRIP001 		++nTblNd;		// Node wurde vorher gesplittet
//STRIP001 	SwNodeIndex aIdx( rDoc.GetNodes(), nTblNd );
//STRIP001 	SwTableNode* pTNd = rDoc.GetNodes()[ aIdx ]->GetTableNode();
//STRIP001 	ASSERT( pTNd, "keinen Tabellen-Node gefunden" );
//STRIP001 
//STRIP001 	RemoveIdxFromSection( rDoc, nTblNd );
//STRIP001 
//STRIP001 	sTblNm = pTNd->GetTable().GetFrmFmt()->GetName();
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 		pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pDelBoxes )
//STRIP001 	{
//STRIP001 		SwTable& rTbl = pTNd->GetTable();
//STRIP001 		for( USHORT n = pDelBoxes->Count(); n; )
//STRIP001 		{
//STRIP001 			SwTableBox* pBox = rTbl.GetTblBox( (*pDelBoxes)[ --n ] );
//STRIP001 			if( pBox )
//STRIP001 				::_DeleteBox( rTbl, pBox, 0, FALSE, FALSE );
//STRIP001 			else
//STRIP001 				ASSERT( !this, "Wo ist die Box geblieben?" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SwNodeIndex aEndIdx( *pTNd->EndOfSectionNode() );
//STRIP001 	rDoc.TableToText( pTNd, 0x0b == cTrenner ? 0x09 : cTrenner );
//STRIP001 
//STRIP001 	// am Start wieder zusammenfuegen ?
//STRIP001 	SwPosition* pPos = rUndoIter.pAktPam->GetPoint();
//STRIP001 	if( nSttCntnt )
//STRIP001 	{
//STRIP001 		pPos->nNode = nTblNd;
//STRIP001 		pPos->nContent.Assign( rDoc.GetNodes()[ pPos->nNode ]->GetCntntNode(), 0 );
//STRIP001 		if( rUndoIter.pAktPam->Move( fnMoveBackward, fnGoCntnt))
//STRIP001 		{
//STRIP001 			SwNodeIndex& rIdx = rUndoIter.pAktPam->GetPoint()->nNode;
//STRIP001 
//STRIP001 			// dann die Crsr/etc. nochmal relativ verschieben
//STRIP001 			RemoveIdxRel( rIdx.GetIndex()+1, *pPos );
//STRIP001 
//STRIP001 			rIdx.GetNode().GetCntntNode()->JoinNext();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// am Ende wieder zusammenfuegen ?
//STRIP001 	if( bSplitEnd )
//STRIP001 	{
//STRIP001 		SwNodeIndex& rIdx = pPos->nNode;
//STRIP001 		rIdx = nEndNode;
//STRIP001 		SwTxtNode* pTxtNd = rIdx.GetNode().GetTxtNode();
//STRIP001 		if( pTxtNd && pTxtNd->CanJoinNext() )
//STRIP001 		{
//STRIP001 			rUndoIter.pAktPam->GetMark()->nContent.Assign( 0, 0 );
//STRIP001 			rUndoIter.pAktPam->GetPoint()->nContent.Assign( 0, 0 );
//STRIP001 
//STRIP001 			// dann die Crsr/etc. nochmal relativ verschieben
//STRIP001 			pPos->nContent.Assign( pTxtNd, pTxtNd->GetTxt().Len() );
//STRIP001 			RemoveIdxRel( nEndNode + 1, *pPos );
//STRIP001 
//STRIP001 			pTxtNd->JoinNext();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetPaM( rUndoIter );		// manipulierten Bereich selectieren
//STRIP001 }


//STRIP001 void SwUndoTxtToTbl::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	RemoveIdxFromRange( *rUndoIter.pAktPam, FALSE );
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 
//STRIP001 	const SwTable* pTable = rUndoIter.GetDoc().TextToTable(
//STRIP001 				*rUndoIter.pAktPam, cTrenner, (SwHoriOrient)nAdjust,
//STRIP001 				nInsTblFlags, pAutoFmt );
//STRIP001 	((SwFrmFmt*)pTable->GetFrmFmt())->SetName( sTblNm );
//STRIP001 }


//STRIP001 void SwUndoTxtToTbl::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// keine Tabelle in Tabelle
//STRIP001 	if( !rUndoIter.pAktPam->GetNode()->FindTableNode() )
//STRIP001 		rUndoIter.GetDoc().TextToTable( *rUndoIter.pAktPam, cTrenner,
//STRIP001 							(SwHoriOrient)nAdjust, nInsTblFlags, pAutoFmt );
//STRIP001 }

//STRIP001 void SwUndoTxtToTbl::AddFillBox( const SwTableBox& rBox )
//STRIP001 {
//STRIP001 	if( !pDelBoxes )
//STRIP001 		pDelBoxes = new SvULongs;
//STRIP001 	pDelBoxes->Insert( rBox.GetSttIdx(), pDelBoxes->Count() );
//STRIP001 }

//STRIP001 SwHistory& SwUndoTxtToTbl::GetHistory()
//STRIP001 {
//STRIP001 	if( !pHistory )
//STRIP001 		pHistory = new SwHistory;
//STRIP001 	return *pHistory;
//STRIP001 }

// -----------------------------------------------------

//STRIP001 SwUndoTblHeadline::SwUndoTblHeadline( const SwTable& rTbl, BOOL bOldHdl )
//STRIP001 	: SwUndo( UNDO_TABLEHEADLINE ),
//STRIP001 	bOldHeadline( bOldHdl )
//STRIP001 {
//STRIP001 	ASSERT( rTbl.GetTabSortBoxes().Count(), "Tabelle ohne Inhalt" );
//STRIP001 	const SwStartNode *pSttNd = rTbl.GetTabSortBoxes()[ 0 ]->GetSttNd();
//STRIP001 	ASSERT( pSttNd, "Box ohne Inhalt" );
//STRIP001 
//STRIP001 	nTblNd = pSttNd->StartOfSectionIndex();
//STRIP001 }


//STRIP001 void SwUndoTblHeadline::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwTableNode* pTNd = rDoc.GetNodes()[ nTblNd ]->GetTableNode();
//STRIP001 	ASSERT( pTNd, "keinen Tabellen-Node gefunden" );
//STRIP001 
//STRIP001 	rDoc.SetHeadlineRepeat( pTNd->GetTable(), bOldHeadline );
//STRIP001 }


//STRIP001 void SwUndoTblHeadline::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	SwTableNode* pTNd = rDoc.GetNodes()[ nTblNd ]->GetTableNode();
//STRIP001 	ASSERT( pTNd, "keinen Tabellen-Node gefunden" );
//STRIP001 
//STRIP001 	rDoc.SetHeadlineRepeat( pTNd->GetTable(), !bOldHeadline );
//STRIP001 }


//STRIP001 void SwUndoTblHeadline::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwTableNode* pTblNd = rUndoIter.pAktPam->GetNode()->FindTableNode();
//STRIP001 	if( pTblNd )
//STRIP001 		rUndoIter.GetDoc().SetHeadlineRepeat( pTblNd->GetTable(),
//STRIP001 												!bOldHeadline );
//STRIP001 }


/*  */



//STRIP001 _SaveTable::_SaveTable( const SwTable& rTbl, USHORT nLnCnt, BOOL bSaveFml )
//STRIP001 	: aTblSet( *rTbl.GetFrmFmt()->GetAttrSet().GetPool(), aTableSetRange ),
//STRIP001 	nLineCount( nLnCnt ), pSwTable( &rTbl ), bSaveFormula( bSaveFml )
//STRIP001 {
//STRIP001 	bModifyBox = FALSE;
//STRIP001 	aTblSet.Put( rTbl.GetFrmFmt()->GetAttrSet() );
//STRIP001 	pLine = new _SaveLine( 0, *rTbl.GetTabLines()[ 0 ], *this );
//STRIP001 
//STRIP001 	_SaveLine* pLn = pLine;
//STRIP001 	if( USHRT_MAX == nLnCnt )
//STRIP001 		nLnCnt = rTbl.GetTabLines().Count();
//STRIP001 	for( USHORT n = 1; n < nLnCnt; ++n )
//STRIP001 		pLn = new _SaveLine( pLn, *rTbl.GetTabLines()[ n ], *this );
//STRIP001 
//STRIP001 	aFrmFmts.Remove( 0, aFrmFmts.Count() );
//STRIP001 	pSwTable = 0;
//STRIP001 }


//STRIP001 _SaveTable::~_SaveTable()
//STRIP001 {
//STRIP001 	delete pLine;
//STRIP001 }


//STRIP001 USHORT _SaveTable::AddFmt( SwFrmFmt* pFmt )
//STRIP001 {
//STRIP001 	USHORT nRet = aFrmFmts.GetPos( pFmt );
//STRIP001 	if( USHRT_MAX == nRet )
//STRIP001 	{
//STRIP001 		// Kopie vom ItemSet anlegen
//STRIP001 		SfxItemSet* pSet = new SfxItemSet( *pFmt->GetAttrSet().GetPool(),
//STRIP001 											aTableBoxSetRange );
//STRIP001 		pSet->Put( pFmt->GetAttrSet() );
//STRIP001 		//JP 20.04.98: Bug 49502 - wenn eine Formel gesetzt ist, nie den
//STRIP001 		//				Value mit sichern. Der muss gegebenfalls neu
//STRIP001 		//				errechnet werden!
//STRIP001 		//JP 30.07.98: Bug 54295 - Formeln immer im Klartext speichern
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		if( SFX_ITEM_SET == pSet->GetItemState( RES_BOXATR_FORMULA, TRUE, &pItem ))
//STRIP001 		{
//STRIP001 			pSet->ClearItem( RES_BOXATR_VALUE );
//STRIP001 			if( pSwTable && bSaveFormula )
//STRIP001 			{
//STRIP001 				SwTableFmlUpdate aMsgHnt( pSwTable );
//STRIP001 				aMsgHnt.eFlags = TBL_BOXNAME;
//STRIP001 				((SwTblBoxFormula*)pItem)->ChgDefinedIn( pFmt );
//STRIP001 				((SwTblBoxFormula*)pItem)->ChangeState( &aMsgHnt );
//STRIP001 				((SwTblBoxFormula*)pItem)->ChgDefinedIn( 0 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aSets.Insert( pSet, (nRet = aSets.Count() ) );
//STRIP001 		aFrmFmts.Insert( pFmt, nRet );
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }


//STRIP001 void _SaveTable::RestoreAttr( SwTable& rTbl, BOOL bMdfyBox )
//STRIP001 {
//STRIP001 	bModifyBox = bMdfyBox;
//STRIP001 
//STRIP001 	// zuerst die Attribute des TabellenFrmFormates zurueck holen
//STRIP001 	SwFrmFmt* pFmt = rTbl.GetFrmFmt();
//STRIP001 	SfxItemSet& rFmtSet  = (SfxItemSet&)pFmt->GetAttrSet();
//STRIP001 	rFmtSet.ClearItem();
//STRIP001 	rFmtSet.Put( aTblSet );
//STRIP001 
//STRIP001 	if( pFmt->IsInCache() )
//STRIP001 	{
//STRIP001 		SwFrm::GetCache().Delete( pFmt );
//STRIP001 		pFmt->SetInCache( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	// zur Sicherheit alle Tableframes invalidieren
//STRIP001 	SwClientIter aIter( *pFmt );
//STRIP001 	for( SwClient* pLast = aIter.First( TYPE( SwFrm ) ); pLast; pLast = aIter.Next() )
//STRIP001 		if( ((SwTabFrm*)pLast)->GetTable() == &rTbl )
//STRIP001 		{
//STRIP001 			((SwTabFrm*)pLast)->InvalidateAll();
//STRIP001 			((SwTabFrm*)pLast)->SetCompletePaint();
//STRIP001 		}
//STRIP001 
//STRIP001 	// FrmFmts mit Defaults (0) fuellen
//STRIP001 	pFmt = 0;
//STRIP001 	for( USHORT n = aSets.Count(); n; --n )
//STRIP001 		aFrmFmts.Insert( pFmt, aFrmFmts.Count() );
//STRIP001 
//STRIP001 	USHORT nLnCnt = nLineCount;
//STRIP001 	if( USHRT_MAX == nLnCnt )
//STRIP001 		nLnCnt = rTbl.GetTabLines().Count();
//STRIP001 
//STRIP001 	_SaveLine* pLn = pLine;
//STRIP001 	for( n = 0; n < nLnCnt; ++n, pLn = pLn->pNext )
//STRIP001 	{
//STRIP001 		if( !pLn )
//STRIP001 		{
//STRIP001 			ASSERT( !this, "Anzahl der Lines hat sich veraendert" );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		pLn->RestoreAttr( *rTbl.GetTabLines()[ n ], *this );
//STRIP001 	}
//STRIP001 
//STRIP001 	aFrmFmts.Remove( 0, aFrmFmts.Count() );
//STRIP001 	bModifyBox = FALSE;
//STRIP001 }


//STRIP001 void _SaveTable::SaveCntntAttrs( SwDoc* pDoc )
//STRIP001 {
//STRIP001 	pLine->SaveCntntAttrs( pDoc );
//STRIP001 }


//STRIP001 void _SaveTable::CreateNew( SwTable& rTbl, BOOL bCreateFrms,
//STRIP001 							BOOL bRestoreChart )
//STRIP001 {
//STRIP001 	_FndBox aTmpBox( 0, 0 );
//STRIP001 	if( bRestoreChart )
//STRIP001 		aTmpBox.SaveChartData( rTbl );
//STRIP001 	aTmpBox.DelFrms( rTbl );
//STRIP001 
//STRIP001 	// zuerst die Attribute des TabellenFrmFormates zurueck holen
//STRIP001 	SwFrmFmt* pFmt = rTbl.GetFrmFmt();
//STRIP001 	SfxItemSet& rFmtSet  = (SfxItemSet&)pFmt->GetAttrSet();
//STRIP001 	rFmtSet.ClearItem();
//STRIP001 	rFmtSet.Put( aTblSet );
//STRIP001 
//STRIP001 	if( pFmt->IsInCache() )
//STRIP001 	{
//STRIP001 		SwFrm::GetCache().Delete( pFmt );
//STRIP001 		pFmt->SetInCache( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	// SwTableBox muss ein Format haben!!
//STRIP001 	SwTableBox aParent( (SwTableBoxFmt*)pFmt, rTbl.GetTabLines().Count(), 0 );
//STRIP001 
//STRIP001 	// FrmFmts mit Defaults (0) fuellen
//STRIP001 	pFmt = 0;
//STRIP001 	for( USHORT n = aSets.Count(); n; --n )
//STRIP001 		aFrmFmts.Insert( pFmt, aFrmFmts.Count() );
//STRIP001 
//STRIP001 	pLine->CreateNew( rTbl, aParent, *this );
//STRIP001 	aFrmFmts.Remove( 0, aFrmFmts.Count() );
//STRIP001 
//STRIP001 	// die neuen Lines eintragen, die alten loeschen
//STRIP001 	USHORT nOldLines = nLineCount;
//STRIP001 	if( USHRT_MAX == nLineCount )
//STRIP001 		nOldLines = rTbl.GetTabLines().Count();
//STRIP001 
//STRIP001 	for( n = 0; n < aParent.GetTabLines().Count(); ++n )
//STRIP001 	{
//STRIP001 		SwTableLine* pLn = aParent.GetTabLines()[ n ];
//STRIP001 		pLn->SetUpper( 0 );
//STRIP001 		if( n < nOldLines )
//STRIP001 		{
//STRIP001 			SwTableLine* pOld = rTbl.GetTabLines()[ n ];
//STRIP001 			rTbl.GetTabLines().C40_REPLACE( SwTableLine, pLn, n );
//STRIP001 			delete pOld;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rTbl.GetTabLines().C40_INSERT( SwTableLine, pLn, n );
//STRIP001 	}
//STRIP001 	if( n < nOldLines )
//STRIP001 		rTbl.GetTabLines().DeleteAndDestroy( n, nOldLines - n );
//STRIP001 
//STRIP001 	aParent.GetTabLines().Remove( 0, n );
//STRIP001 
//STRIP001 	if( bCreateFrms )
//STRIP001 		aTmpBox.MakeFrms( rTbl );
//STRIP001 	if( bRestoreChart )
//STRIP001 		aTmpBox.RestoreChartData( rTbl );
//STRIP001 }


//STRIP001 void _SaveTable::NewFrmFmt( const SwClient* pLnBx, BOOL bIsLine,
//STRIP001 							USHORT nFmtPos, SwFrmFmt* pOldFmt )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = pOldFmt->GetDoc();
//STRIP001 
//STRIP001 	SwFrmFmt* pFmt = aFrmFmts[ nFmtPos ];
//STRIP001 	if( !pFmt )
//STRIP001 	{
//STRIP001 		if( bIsLine )
//STRIP001 			pFmt = pDoc->MakeTableLineFmt();
//STRIP001 		else
//STRIP001 			pFmt = pDoc->MakeTableBoxFmt();
//STRIP001 		pFmt->SetAttr( *aSets[ nFmtPos ] );
//STRIP001 		aFrmFmts.Replace( pFmt, nFmtPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	//Erstmal die Frms ummelden.
//STRIP001 	SwClientIter aIter( *pOldFmt );
//STRIP001 	for( SwClient* pLast = aIter.First( TYPE( SwFrm ) ); pLast; pLast = aIter.Next() )
//STRIP001 		if( bIsLine ? pLnBx == ((SwRowFrm*)pLast)->GetTabLine()
//STRIP001 					: pLnBx == ((SwCellFrm*)pLast)->GetTabBox() )
//STRIP001 		{
//STRIP001 			pFmt->Add( pLast );
//STRIP001 			((SwFrm*)pLast)->InvalidateAll();
//STRIP001 			((SwFrm*)pLast)->ReinitializeFrmSizeAttrFlags();
//STRIP001 		}
//STRIP001 
//STRIP001 	//Jetzt noch mich selbst ummelden.
//STRIP001 	pFmt->Add( (SwClient*)pLnBx );
//STRIP001 
//STRIP001 	if( bModifyBox && !bIsLine )
//STRIP001 	{
//STRIP001 		const SfxPoolItem& rOld = pOldFmt->GetAttr( RES_BOXATR_FORMAT ),
//STRIP001 						 & rNew = pFmt->GetAttr( RES_BOXATR_FORMAT );
//STRIP001 		if( rOld != rNew )
//STRIP001 			pFmt->Modify( (SfxPoolItem*)&rOld, (SfxPoolItem*)&rNew );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pOldFmt->GetDepends() )
//STRIP001 		delete pOldFmt;
//STRIP001 
//STRIP001 }


//STRIP001 _SaveLine::_SaveLine( _SaveLine* pPrev, const SwTableLine& rLine, _SaveTable& rSTbl )
//STRIP001 	: pNext( 0 )
//STRIP001 {
//STRIP001 	if( pPrev )
//STRIP001 		pPrev->pNext = this;
//STRIP001 
//STRIP001 	nItemSet = rSTbl.AddFmt( rLine.GetFrmFmt() );
//STRIP001 
//STRIP001 	pBox = new _SaveBox( 0, *rLine.GetTabBoxes()[ 0 ], rSTbl );
//STRIP001 	_SaveBox* pBx = pBox;
//STRIP001 	for( USHORT n = 1; n < rLine.GetTabBoxes().Count(); ++n )
//STRIP001 		pBx = new _SaveBox( pBx, *rLine.GetTabBoxes()[ n ], rSTbl );
//STRIP001 }


//STRIP001 _SaveLine::~_SaveLine()
//STRIP001 {
//STRIP001 	delete pBox;
//STRIP001 	delete pNext;
//STRIP001 }


//STRIP001 void _SaveLine::RestoreAttr( SwTableLine& rLine, _SaveTable& rSTbl )
//STRIP001 {
//STRIP001 	rSTbl.NewFrmFmt( &rLine, TRUE, nItemSet, rLine.GetFrmFmt() );
//STRIP001 
//STRIP001 	_SaveBox* pBx = pBox;
//STRIP001 	for( USHORT n = 0; n < rLine.GetTabBoxes().Count(); ++n, pBx = pBx->pNext )
//STRIP001 	{
//STRIP001 		if( !pBx )
//STRIP001 		{
//STRIP001 			ASSERT( !this, "Anzahl der Boxen hat sich veraendert" );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		pBx->RestoreAttr( *rLine.GetTabBoxes()[ n ], rSTbl );
//STRIP001 	}
//STRIP001 }


//STRIP001 void _SaveLine::SaveCntntAttrs( SwDoc* pDoc )
//STRIP001 {
//STRIP001 	pBox->SaveCntntAttrs( pDoc );
//STRIP001 	if( pNext )
//STRIP001 		pNext->SaveCntntAttrs( pDoc );
//STRIP001 }


//STRIP001 void _SaveLine::CreateNew( SwTable& rTbl, SwTableBox& rParent, _SaveTable& rSTbl )
//STRIP001 {
//STRIP001 	SwTableLineFmt* pFmt = (SwTableLineFmt*)rSTbl.aFrmFmts[ nItemSet ];
//STRIP001 	if( !pFmt )
//STRIP001 	{
//STRIP001 		SwDoc* pDoc = rTbl.GetFrmFmt()->GetDoc();
//STRIP001 		pFmt = pDoc->MakeTableLineFmt();
//STRIP001 		pFmt->SetAttr( *rSTbl.aSets[ nItemSet ] );
//STRIP001 		rSTbl.aFrmFmts.Replace( pFmt, nItemSet );
//STRIP001 	}
//STRIP001 	SwTableLine* pNew = new SwTableLine( pFmt, 1, &rParent );
//STRIP001 	rParent.GetTabLines().C40_INSERT( SwTableLine, pNew, rParent.GetTabLines().Count() );
//STRIP001 
//STRIP001 	pBox->CreateNew( rTbl, *pNew, rSTbl );
//STRIP001 
//STRIP001 	if( pNext )
//STRIP001 		pNext->CreateNew( rTbl, rParent, rSTbl );
//STRIP001 }


//STRIP001 _SaveBox::_SaveBox( _SaveBox* pPrev, const SwTableBox& rBox, _SaveTable& rSTbl )
//STRIP001 	: nSttNode( ULONG_MAX ), pNext( 0 )
//STRIP001 {
//STRIP001 	Ptrs.pLine = 0;
//STRIP001 
//STRIP001 	if( pPrev )
//STRIP001 		pPrev->pNext = this;
//STRIP001 
//STRIP001 	nItemSet = rSTbl.AddFmt( rBox.GetFrmFmt() );
//STRIP001 
//STRIP001 	if( rBox.GetSttNd() )
//STRIP001 		nSttNode = rBox.GetSttIdx();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Ptrs.pLine = new _SaveLine( 0, *rBox.GetTabLines()[ 0 ], rSTbl );
//STRIP001 
//STRIP001 		_SaveLine* pLn = Ptrs.pLine;
//STRIP001 		for( USHORT n = 1; n < rBox.GetTabLines().Count(); ++n )
//STRIP001 			pLn = new _SaveLine( pLn, *rBox.GetTabLines()[ n ], rSTbl );
//STRIP001 	}
//STRIP001 }


//STRIP001 _SaveBox::~_SaveBox()
//STRIP001 {
//STRIP001 	if( ULONG_MAX == nSttNode )		// keine EndBox
//STRIP001 		delete Ptrs.pLine;
//STRIP001 	else
//STRIP001 		delete Ptrs.pCntntAttrs;
//STRIP001 	delete pNext;
//STRIP001 }


//STRIP001 void _SaveBox::RestoreAttr( SwTableBox& rBox, _SaveTable& rSTbl )
//STRIP001 {
//STRIP001 	rSTbl.NewFrmFmt( &rBox, FALSE, nItemSet, rBox.GetFrmFmt() );
//STRIP001 
//STRIP001 	if( ULONG_MAX == nSttNode )		// keine EndBox
//STRIP001 	{
//STRIP001 		if( !rBox.GetTabLines().Count() )
//STRIP001 		{
//STRIP001 			ASSERT( !this, "Anzahl der Lines hat sich veraendert" );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			_SaveLine* pLn = Ptrs.pLine;
//STRIP001 			for( USHORT n = 0; n < rBox.GetTabLines().Count(); ++n, pLn = pLn->pNext )
//STRIP001 			{
//STRIP001 				if( !pLn )
//STRIP001 				{
//STRIP001 					ASSERT( !this, "Anzahl der Lines hat sich veraendert" );
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				pLn->RestoreAttr( *rBox.GetTabLines()[ n ], rSTbl );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( rBox.GetSttNd() && rBox.GetSttIdx() == nSttNode )
//STRIP001 	{
//STRIP001 		if( Ptrs.pCntntAttrs )
//STRIP001 		{
//STRIP001 			SwNodes& rNds = rBox.GetFrmFmt()->GetDoc()->GetNodes();
//STRIP001 			USHORT nSet = 0;
//STRIP001 			ULONG nEnd = rBox.GetSttNd()->EndOfSectionIndex();
//STRIP001 			for( ULONG n = nSttNode + 1; n < nEnd; ++n )
//STRIP001 			{
//STRIP001 				SwCntntNode* pCNd = rNds[ n ]->GetCntntNode();
//STRIP001 				if( pCNd )
//STRIP001 				{
//STRIP001 					SfxItemSet* pSet = (*Ptrs.pCntntAttrs)[ nSet++ ];
//STRIP001 					if( pSet )
//STRIP001 					{
//STRIP001 						USHORT *pRstAttr = aSave_BoxCntntSet;
//STRIP001 						while( *pRstAttr )
//STRIP001 						{
//STRIP001 							pCNd->ResetAttr( *pRstAttr, *(pRstAttr+1) );
//STRIP001 							pRstAttr += 2;
//STRIP001 						}
//STRIP001 						pCNd->SetAttr( *pSet );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						pCNd->ResetAllAttr();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ASSERT( !this, "Box nicht mehr am gleichen Node" );
//STRIP001 	}
//STRIP001 }


//STRIP001 void _SaveBox::SaveCntntAttrs( SwDoc* pDoc )
//STRIP001 {
//STRIP001 	if( ULONG_MAX == nSttNode )		// keine EndBox
//STRIP001 	{
//STRIP001 		// weiter in der Line
//STRIP001 		Ptrs.pLine->SaveCntntAttrs( pDoc );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nSet = 0;
//STRIP001 		ULONG nEnd = pDoc->GetNodes()[ nSttNode ]->EndOfSectionIndex();
//STRIP001 		Ptrs.pCntntAttrs = new SfxItemSets( (BYTE)(nEnd - nSttNode - 1 ), 5 );
//STRIP001 		for( ULONG n = nSttNode + 1; n < nEnd; ++n )
//STRIP001 		{
//STRIP001 			SwCntntNode* pCNd = pDoc->GetNodes()[ n ]->GetCntntNode();
//STRIP001 			if( pCNd )
//STRIP001 			{
//STRIP001 				SfxItemSet* pSet = 0;
//STRIP001 				if( pCNd->GetpSwAttrSet() )
//STRIP001 				{
//STRIP001 					pSet = new SfxItemSet( pDoc->GetAttrPool(),
//STRIP001 											aSave_BoxCntntSet );
//STRIP001 					pSet->Put( *pCNd->GetpSwAttrSet() );
//STRIP001 				}
//STRIP001 
//STRIP001 				Ptrs.pCntntAttrs->Insert( pSet, Ptrs.pCntntAttrs->Count() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( pNext )
//STRIP001 		pNext->SaveCntntAttrs( pDoc );
//STRIP001 }


//STRIP001 void _SaveBox::CreateNew( SwTable& rTbl, SwTableLine& rParent, _SaveTable& rSTbl )
//STRIP001 {
//STRIP001 	SwTableBoxFmt* pFmt = (SwTableBoxFmt*)rSTbl.aFrmFmts[ nItemSet ];
//STRIP001 	if( !pFmt )
//STRIP001 	{
//STRIP001 		SwDoc* pDoc = rTbl.GetFrmFmt()->GetDoc();
//STRIP001 		pFmt = pDoc->MakeTableBoxFmt();
//STRIP001 		pFmt->SetAttr( *rSTbl.aSets[ nItemSet ] );
//STRIP001 		rSTbl.aFrmFmts.Replace( pFmt, nItemSet );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( ULONG_MAX == nSttNode )		// keine EndBox
//STRIP001 	{
//STRIP001 		SwTableBox* pNew = new SwTableBox( pFmt, 1, &rParent );
//STRIP001 		rParent.GetTabBoxes().C40_INSERT( SwTableBox, pNew, rParent.GetTabBoxes().Count() );
//STRIP001 
//STRIP001 		Ptrs.pLine->CreateNew( rTbl, *pNew, rSTbl );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Box zum StartNode in der alten Tabelle suchen
//STRIP001 		SwTableBox* pBox = rTbl.GetTblBox( nSttNode );
//STRIP001 		ASSERT( pBox, "Wo ist meine TabellenBox geblieben?" );
//STRIP001 
//STRIP001 		SwFrmFmt* pOld = pBox->GetFrmFmt();
//STRIP001 		pFmt->Add( pBox );
//STRIP001 		if( !pOld->GetDepends() )
//STRIP001 			delete pOld;
//STRIP001 
//STRIP001 		SwTableBoxes* pTBoxes = &pBox->GetUpper()->GetTabBoxes();
//STRIP001 		pTBoxes->Remove( pTBoxes->C40_GETPOS( SwTableBox, pBox ) );
//STRIP001 
//STRIP001 		pBox->SetUpper( &rParent );
//STRIP001 		pTBoxes = &rParent.GetTabBoxes();
//STRIP001 		pTBoxes->C40_INSERT( SwTableBox, pBox, pTBoxes->Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pNext )
//STRIP001 		pNext->CreateNew( rTbl, rParent, rSTbl );
//STRIP001 }


/*  */

// UndoObject fuer Attribut Aenderung an der Tabelle


//STRIP001 SwUndoAttrTbl::SwUndoAttrTbl( const SwTableNode& rTblNd, BOOL bClearTabCols )
//STRIP001 	: SwUndo( UNDO_TABLE_ATTR ),
//STRIP001 	nSttNode( rTblNd.GetIndex() )
//STRIP001 {
//STRIP001 	bClearTabCol = bClearTabCols;
//STRIP001 	pSaveTbl = new _SaveTable( rTblNd.GetTable() );
//STRIP001 }


//STRIP001 SwUndoAttrTbl::~SwUndoAttrTbl()
//STRIP001 {
//STRIP001 	delete pSaveTbl;
//STRIP001 }



//STRIP001 void SwUndoAttrTbl::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwTableNode* pTblNd = rDoc.GetNodes()[ nSttNode ]->GetTableNode();
//STRIP001 	ASSERT( pTblNd, "kein TabellenNode" );
//STRIP001 
//STRIP001 	_SaveTable* pOrig = new _SaveTable( pTblNd->GetTable() );
//STRIP001 	pSaveTbl->RestoreAttr( pTblNd->GetTable() );
//STRIP001 	delete pSaveTbl;
//STRIP001 	pSaveTbl = pOrig;
//STRIP001 
//STRIP001 	if( bClearTabCol )
//STRIP001 		ClearFEShellTabCols();
//STRIP001 }


//STRIP001 void SwUndoAttrTbl::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	Undo( rUndoIter );
//STRIP001 }


/*  */

// UndoObject fuer AutoFormat an der Tabelle


//STRIP001 SwUndoTblAutoFmt::SwUndoTblAutoFmt( const SwTableNode& rTblNd,
//STRIP001 									const SwTableAutoFmt& rAFmt )
//STRIP001 	: SwUndo( UNDO_TABLE_AUTOFMT ),
//STRIP001 	nSttNode( rTblNd.GetIndex() ),
//STRIP001 	bSaveCntntAttr( FALSE ), pUndos( 0 )
//STRIP001 {
//STRIP001 	pSaveTbl = new _SaveTable( rTblNd.GetTable() );
//STRIP001 
//STRIP001 	if( rAFmt.IsFont() || rAFmt.IsJustify() )
//STRIP001 	{
//STRIP001 		// dann auch noch ueber die ContentNodes der EndBoxen und
//STRIP001 		// und alle Absatz-Attribute zusammen sammeln
//STRIP001 		pSaveTbl->SaveCntntAttrs( (SwDoc*)rTblNd.GetDoc() );
//STRIP001 		bSaveCntntAttr = TRUE;
//STRIP001 	}
//STRIP001 }


//STRIP001 SwUndoTblAutoFmt::~SwUndoTblAutoFmt()
//STRIP001 {
//STRIP001 	delete pUndos;
//STRIP001 	delete pSaveTbl;
//STRIP001 }

//STRIP001 void SwUndoTblAutoFmt::SaveBoxCntnt( const SwTableBox& rBox )
//STRIP001 {
//STRIP001 	SwUndoTblNumFmt* p = new SwUndoTblNumFmt( rBox );
//STRIP001 	if( !pUndos )
//STRIP001 		pUndos = new SwUndos( 8, 8 );
//STRIP001 	pUndos->Insert( p, pUndos->Count() );
//STRIP001 }


//STRIP001 void SwUndoTblAutoFmt::UndoRedo( BOOL bUndo, SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwTableNode* pTblNd = rDoc.GetNodes()[ nSttNode ]->GetTableNode();
//STRIP001 	ASSERT( pTblNd, "kein TabellenNode" );
//STRIP001 
//STRIP001 	_SaveTable* pOrig = new _SaveTable( pTblNd->GetTable() );
//STRIP001 		// dann auch noch ueber die ContentNodes der EndBoxen und
//STRIP001 		// und alle Absatz-Attribute zusammen sammeln
//STRIP001 	if( bSaveCntntAttr )
//STRIP001 		pOrig->SaveCntntAttrs( &rDoc );
//STRIP001 
//STRIP001 	if( pUndos && bUndo )
//STRIP001 		for( USHORT n = pUndos->Count(); n; )
//STRIP001 			pUndos->GetObject( --n )->Undo( rUndoIter );
//STRIP001 
//STRIP001 	pSaveTbl->RestoreAttr( pTblNd->GetTable(), !bUndo );
//STRIP001 	delete pSaveTbl;
//STRIP001 	pSaveTbl = pOrig;
//STRIP001 }

//STRIP001 void SwUndoTblAutoFmt::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	UndoRedo( TRUE, rUndoIter );
//STRIP001 }


//STRIP001 void SwUndoTblAutoFmt::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	UndoRedo( FALSE, rUndoIter );
//STRIP001 }


/*  */


//STRIP001 SwUndoTblNdsChg::SwUndoTblNdsChg( USHORT nAction,
//STRIP001 									const SwSelBoxes& rBoxes,
//STRIP001 									const SwTableNode& rTblNd,
//STRIP001                                     USHORT nCnt, BOOL bFlg, BOOL bSmHght )
//STRIP001 	: SwUndo( nAction ),
//STRIP001 	nSttNode( rTblNd.GetIndex() ),
//STRIP001 	aBoxes( rBoxes.Count() < 255 ? (BYTE)rBoxes.Count() : 255, 10 ),
//STRIP001 	nCount( nCnt ), nRelDiff( 0 ), nAbsDiff( 0 ),
//STRIP001 	nSetColType( USHRT_MAX ), nCurrBox( 0 ),
//STRIP001     bFlag( bFlg ),
//STRIP001     bSameHeight( bSmHght )
//STRIP001 {
//STRIP001 	Ptrs.pNewSttNds = 0;
//STRIP001 
//STRIP001 	const SwTable& rTbl = rTblNd.GetTable();
//STRIP001 	pSaveTbl = new _SaveTable( rTbl );
//STRIP001 
//STRIP001 	// und die Selektion merken
//STRIP001 	for( USHORT n = 0; n < rBoxes.Count(); ++n )
//STRIP001 		aBoxes.Insert( rBoxes[n]->GetSttIdx(), n );
//STRIP001 }


//STRIP001 SwUndoTblNdsChg::SwUndoTblNdsChg( USHORT nAction,
//STRIP001 									const SwSelBoxes& rBoxes,
//STRIP001 									const SwTableNode& rTblNd )
//STRIP001 	: SwUndo( nAction ),
//STRIP001 	nSttNode( rTblNd.GetIndex() ),
//STRIP001 	aBoxes( rBoxes.Count() < 255 ? (BYTE)rBoxes.Count() : 255, 10 ),
//STRIP001 	nCount( 0 ), nRelDiff( 0 ), nAbsDiff( 0 ),
//STRIP001 	nSetColType( USHRT_MAX ), nCurrBox( 0 ),
//STRIP001 	bFlag( FALSE )
//STRIP001 {
//STRIP001 	Ptrs.pNewSttNds = 0;
//STRIP001 
//STRIP001 	const SwTable& rTbl = rTblNd.GetTable();
//STRIP001 	pSaveTbl = new _SaveTable( rTbl );
//STRIP001 
//STRIP001 	// und die Selektion merken
//STRIP001 	for( USHORT n = 0; n < rBoxes.Count(); ++n )
//STRIP001 		aBoxes.Insert( rBoxes[n]->GetSttIdx(), n );
//STRIP001 }


//STRIP001 SwUndoTblNdsChg::~SwUndoTblNdsChg()
//STRIP001 {
//STRIP001 	delete pSaveTbl;
//STRIP001 
//STRIP001 	if( UNDO_TABLE_DELBOX == GetId() )
//STRIP001 		delete Ptrs.pDelSects;
//STRIP001 	else
//STRIP001 		delete Ptrs.pNewSttNds;
//STRIP001 }



//STRIP001 void SwUndoTblNdsChg::SaveNewBoxes( const SwTableNode& rTblNd,
//STRIP001 									const SwTableSortBoxes& rOld )
//STRIP001 {
//STRIP001 	const SwTable& rTbl = rTblNd.GetTable();
//STRIP001 	const SwTableSortBoxes& rTblBoxes = rTbl.GetTabSortBoxes();
//STRIP001 
//STRIP001 	ASSERT( UNDO_TABLE_DELBOX != GetId(), "falsche Action" );
//STRIP001 	Ptrs.pNewSttNds = new SvULongs( (BYTE)(rTblBoxes.Count() - rOld.Count()), 5 );
//STRIP001 
//STRIP001 	for( USHORT n = 0, i = 0; n < rOld.Count(); ++i )
//STRIP001 	{
//STRIP001 		if( rOld[ n ] == rTblBoxes[ i ] )
//STRIP001 			++n;
//STRIP001 		else
//STRIP001 			// neue Box: sortiert einfuegen!!
//STRIP001 			InsertSort( *Ptrs.pNewSttNds, rTblBoxes[ i ]->GetSttIdx() );
//STRIP001 	}
//STRIP001 
//STRIP001 	for( ; i < rTblBoxes.Count(); ++i )
//STRIP001 		// neue Box: sortiert einfuegen!!
//STRIP001 		InsertSort( *Ptrs.pNewSttNds, rTblBoxes[ i ]->GetSttIdx() );
//STRIP001 }


//STRIP001 SwTableLine* lcl_FindTableLine( const SwTable& rTable, 
//STRIP001                                 const SwTableBox& rBox )
//STRIP001 {
//STRIP001     SwTableLine* pRet = NULL;
//STRIP001 
//STRIP001     if( rBox.GetUpper()->GetUpper() != NULL )
//STRIP001     {
//STRIP001         pRet = rBox.GetUpper()->GetUpper()->
//STRIP001             GetTabLines()[ 0 ];
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         const SwTableLine* pLine = rBox.GetUpper();
//STRIP001         USHORT nLineNo = rTable.GetTabLines().C40_GETPOS( SwTableLine, pLine );
//STRIP001         pRet = rTable.GetTabLines()[nLineNo - 1];
//STRIP001     }
//STRIP001 
//STRIP001     return pRet;
//STRIP001 }

//STRIP001 const SwTableLines& lcl_FindParentLines( const SwTable& rTable, 
//STRIP001 				                       const SwTableBox& rBox )
//STRIP001 {
//STRIP001     const SwTableLines& rRet = 
//STRIP001 		( rBox.GetUpper()->GetUpper() != NULL ) ?
//STRIP001 			rBox.GetUpper()->GetUpper()->GetTabLines() :
//STRIP001 			rTable.GetTabLines();
//STRIP001 
//STRIP001 	return rRet;
//STRIP001 }


//STRIP001 void SwUndoTblNdsChg::SaveNewBoxes( const SwTableNode& rTblNd,
//STRIP001 									const SwTableSortBoxes& rOld,
//STRIP001 									const SwSelBoxes& rBoxes,
//STRIP001 									const SvULongs& rNodeCnts )
//STRIP001 {
//STRIP001 	const SwTable& rTbl = rTblNd.GetTable();
//STRIP001 	const SwTableSortBoxes& rTblBoxes = rTbl.GetTabSortBoxes();
//STRIP001 
//STRIP001 	ASSERT( UNDO_TABLE_DELBOX != GetId(), "falsche Action" );
//STRIP001 	Ptrs.pNewSttNds = new SvULongs( (BYTE)(rTblBoxes.Count() - rOld.Count()), 5 );
//STRIP001 
//STRIP001 	ASSERT( rOld.Count() + nCount * rBoxes.Count() == rTblBoxes.Count(), 
//STRIP001 		"unexpected boxes" );
//STRIP001 	ASSERT( rOld.Count() <= rTblBoxes.Count(), "more unexpected boxes" );
//STRIP001 	for( USHORT n = 0, i = 0; i < rTblBoxes.Count(); ++i )
//STRIP001 	{
//STRIP001 		if( ( n < rOld.Count() ) && 
//STRIP001 			( rOld[ n ] == rTblBoxes[ i ] ) )
//STRIP001         {
//STRIP001             // box already known? Then nothing to be done.
//STRIP001 			++n;
//STRIP001         }
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// new box found: insert (obey sort order)
//STRIP001 			USHORT nInsPos;
//STRIP001 			const SwTableBox* pBox = rTblBoxes[ i ];
//STRIP001 			InsertSort( *Ptrs.pNewSttNds, pBox->GetSttIdx(), &nInsPos );
//STRIP001 
//STRIP001 			// find the source box. It must be one in rBoxes.
//STRIP001             // We found the right one if it's in the same column as pBox.
//STRIP001 			USHORT j = 0;
//STRIP001 			const SwTableBox* pSourceBox = NULL;
//STRIP001 			do
//STRIP001 			{
//STRIP001                 ASSERT( j < aBoxes.Count(), "box not found" );
//STRIP001 				pSourceBox = rBoxes[j];
//STRIP001 				j++;
//STRIP001 			}
//STRIP001 			while( pSourceBox->GetUpper()->GetUpper() != 
//STRIP001                    pBox->GetUpper()->GetUpper() );
//STRIP001 
//STRIP001 			// find the line number difference 
//STRIP001             // (to help determine bNodesMoved flag below)
//STRIP001 			const SwTableLine* pBoxLine = pBox->GetUpper();
//STRIP001 			const SwTableLine* pSourceLine = pSourceBox->GetUpper();
//STRIP001 			USHORT nLineDiff = 
//STRIP001 				lcl_FindParentLines( rTbl, *pBox ).
//STRIP001                     C40_GETPOS( SwTableLine, pBoxLine ) -
//STRIP001 				lcl_FindParentLines( rTbl, *pSourceBox ).
//STRIP001                     C40_GETPOS( SwTableLine, pSourceLine );
//STRIP001 
//STRIP001             // find out how many nodes the source box used to have
//STRIP001             // (to help determine bNodesMoved flag below)
//STRIP001             USHORT nNdsPos = 0;
//STRIP001             while( rBoxes[ nNdsPos ] != pSourceBox )
//STRIP001                 ++nNdsPos;
//STRIP001             ULONG nNodes = rNodeCnts[ nNdsPos ];
//STRIP001 
//STRIP001             // When a new table cell is created, it either gets a new
//STRIP001             // node, or it gets node(s) from elsewhere. The undo must
//STRIP001             // know, of course, and thus we must determine here just
//STRIP001             // where pBox's nodes are from:
//STRIP001             // If 1) the source box has lost nodes, and
//STRIP001             //    2) we're in the node range that got nodes
//STRIP001             // then pBox received nodes from elsewhere.
//STRIP001             // If bNodesMoved is set for pBox the undo must move the
//STRIP001             // boxes back, otherwise it must delete them.
//STRIP001             // The bNodesMoved flag is stored in a seperate array
//STRIP001             // which mirrors Ptrs.pNewSttNds, i.e. Ptrs.pNewSttNds[i]
//STRIP001             // and aMvBoxes[i] belong together.
//STRIP001             BOOL bNodesMoved = 
//STRIP001                 ( nNodes != ( pSourceBox->GetSttNd()->EndOfSectionIndex() -
//STRIP001                               pSourceBox->GetSttIdx() ) )
//STRIP001                 && ( nNodes - 1 > nLineDiff );
//STRIP001 			aMvBoxes.Insert( bNodesMoved, nInsPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoTblNdsChg::SaveSection( SwStartNode* pSttNd )
//STRIP001 {
//STRIP001 	ASSERT( UNDO_TABLE_DELBOX == GetId(), "falsche Action" );
//STRIP001 	if( !Ptrs.pDelSects )
//STRIP001 		Ptrs.pDelSects = new SwUndoSaveSections( 10, 5 );
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = pSttNd->FindTableNode();
//STRIP001 	SwUndoSaveSection* pSave = new SwUndoSaveSection;
//STRIP001 	pSave->SaveSection( pSttNd->GetDoc(), SwNodeIndex( *pSttNd ));
//STRIP001 
//STRIP001 	Ptrs.pDelSects->Insert( pSave, Ptrs.pDelSects->Count() );
//STRIP001 	nSttNode = pTblNd->GetIndex();
//STRIP001 }


//STRIP001 void SwUndoTblNdsChg::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwNodeIndex aIdx( rDoc.GetNodes(), nSttNode );
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = rDoc.GetNodes()[ aIdx ]->GetTableNode();
//STRIP001 	ASSERT( pTblNd, "kein TabellenNode" );
//STRIP001 
//STRIP001 	SwTableFmlUpdate aMsgHnt( &pTblNd->GetTable() );
//STRIP001 	aMsgHnt.eFlags = TBL_BOXPTR;
//STRIP001 	rDoc.UpdateTblFlds( &aMsgHnt );
//STRIP001 
//STRIP001 	_FndBox aTmpBox( 0, 0 );
//STRIP001 	aTmpBox.SaveChartData( pTblNd->GetTable() );
//STRIP001 
//STRIP001 	if( UNDO_TABLE_DELBOX == GetId() )
//STRIP001 	{
//STRIP001 		// Trick: die fehlenden Boxen in irgendeine Line einfuegen, beim
//STRIP001 		// CreateNew werden sie korrekt verbunden.
//STRIP001 		SwTableBox* pCpyBox = pTblNd->GetTable().GetTabSortBoxes()[0];
//STRIP001 		SwTableBoxes& rLnBoxes = pCpyBox->GetUpper()->GetTabBoxes();
//STRIP001 
//STRIP001 		// die Sections wieder herstellen
//STRIP001 		for( USHORT n = Ptrs.pDelSects->Count(); n; )
//STRIP001 		{
//STRIP001 			SwUndoSaveSection* pSave = (*Ptrs.pDelSects)[ --n ];
//STRIP001 			pSave->RestoreSection( &rDoc, &aIdx, SwTableBoxStartNode );
//STRIP001 			if( pSave->GetHistory() )
//STRIP001 				pSave->GetHistory()->Rollback( &rDoc );
//STRIP001 			SwTableBox* pBox = new SwTableBox( (SwTableBoxFmt*)pCpyBox->GetFrmFmt(), aIdx,
//STRIP001 												pCpyBox->GetUpper() );
//STRIP001 			rLnBoxes.C40_INSERT( SwTableBox, pBox, rLnBoxes.Count() );
//STRIP001 		}
//STRIP001 		Ptrs.pDelSects->DeleteAndDestroy( 0, Ptrs.pDelSects->Count() );
//STRIP001 	}
//STRIP001 	else if( aMvBoxes.Count() )
//STRIP001 	{
//STRIP001 		// dann muessen Nodes verschoben und nicht geloescht werden!
//STRIP001 		// Dafuer brauchen wir aber ein temp Array
//STRIP001 		SvULongs aTmp( 0, 5);
//STRIP001 		aTmp.Insert( Ptrs.pNewSttNds, 0 );
//STRIP001 
//STRIP001 		// von hinten anfangen
//STRIP001 		for( USHORT n = aTmp.Count(); n; )
//STRIP001 		{
//STRIP001 			// Box aus der Tabellen-Struktur entfernen
//STRIP001 			ULONG nIdx = aTmp[ --n ];
//STRIP001 			SwTableBox* pBox = pTblNd->GetTable().GetTblBox( nIdx );
//STRIP001 			ASSERT( pBox, "Wo ist meine TabellenBox geblieben?" );
//STRIP001 
//STRIP001 			SwTableBoxes* pTBoxes = &pBox->GetUpper()->GetTabBoxes();
//STRIP001 			pTBoxes->Remove( pTBoxes->C40_GETPOS( SwTableBox, pBox ) );
//STRIP001 
//STRIP001 			if( aMvBoxes[ n ] )
//STRIP001 			{
//STRIP001 				SwNodeRange aRg( *pBox->GetSttNd(), 1,
//STRIP001 							*pBox->GetSttNd()->EndOfSectionNode() );
//STRIP001 
//STRIP001 				SwTableLine* pLine = lcl_FindTableLine( pTblNd->GetTable(), *pBox );
//STRIP001 				SwNodeIndex aInsPos( *(pLine->GetTabBoxes()[0]->GetSttNd()), 2 );
//STRIP001 
//STRIP001 				// alle StartNode Indizies anpassen
//STRIP001 				USHORT i = n;
//STRIP001 				ULONG nSttIdx = aInsPos.GetIndex() - 2,
//STRIP001 					   nNdCnt = aRg.aEnd.GetIndex() - aRg.aStart.GetIndex();
//STRIP001 				while( i && aTmp[ --i ] > nSttIdx )
//STRIP001 					aTmp[ i ] += nNdCnt;
//STRIP001 
//STRIP001 				// erst die Box loeschen
//STRIP001 				delete pBox;
//STRIP001 				// dann die Nodes verschieben,
//STRIP001 				rDoc.GetNodes()._MoveNodes( aRg, rDoc.GetNodes(), aInsPos, FALSE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				delete pBox;
//STRIP001 				rDoc.DeleteSection( rDoc.GetNodes()[ nIdx ] );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		// die Nodes loeschen (von Hinten!!)
//STRIP001 		for( USHORT n = Ptrs.pNewSttNds->Count(); n; )
//STRIP001 		{
//STRIP001 			// Box aus der Tabellen-Struktur entfernen
//STRIP001 			ULONG nIdx = (*Ptrs.pNewSttNds)[ --n ];
//STRIP001 			SwTableBox* pBox = pTblNd->GetTable().GetTblBox( nIdx );
//STRIP001 			ASSERT( pBox, "Wo ist meine TabellenBox geblieben?" );
//STRIP001 
//STRIP001 			SwTableBoxes* pTBoxes = &pBox->GetUpper()->GetTabBoxes();
//STRIP001 			pTBoxes->Remove( pTBoxes->C40_GETPOS( SwTableBox, pBox ) );
//STRIP001 
//STRIP001 			delete pBox;
//STRIP001 			rDoc.DeleteSection( rDoc.GetNodes()[ nIdx ] );
//STRIP001 		}
//STRIP001 
//STRIP001 	pSaveTbl->CreateNew( pTblNd->GetTable(), TRUE, FALSE );
//STRIP001 
//STRIP001 	aTmpBox.RestoreChartData( pTblNd->GetTable() );
//STRIP001 
//STRIP001 	if( UNDO_TABLE_DELBOX == GetId() )
//STRIP001 		nSttNode = pTblNd->GetIndex();
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }


//STRIP001 void SwUndoTblNdsChg::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = rDoc.GetNodes()[ nSttNode ]->GetTableNode();
//STRIP001 	ASSERT( pTblNd, "kein TabellenNode" );
//STRIP001 
//STRIP001 	SwSelBoxes aSelBoxes;
//STRIP001 	for( USHORT n = 0; n < aBoxes.Count(); ++n )
//STRIP001 	{
//STRIP001 		SwTableBox* pBox = pTblNd->GetTable().GetTblBox( aBoxes[ n ] );
//STRIP001 		aSelBoxes.Insert( pBox );
//STRIP001 	}
//STRIP001 
//STRIP001 	// SelBoxes erzeugen und InsertCell/-Row/SplitTbl aufrufen
//STRIP001 	switch( GetId() )
//STRIP001 	{
//STRIP001 	case UNDO_TABLE_INSCOL:
//STRIP001 		if( USHRT_MAX == nSetColType )
//STRIP001 			rDoc.InsertCol( aSelBoxes, nCount, bFlag );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SwTableBox* pBox = pTblNd->GetTable().GetTblBox( nCurrBox );
//STRIP001 			rDoc.SetColRowWidthHeight( *pBox, nSetColType, nAbsDiff,
//STRIP001 										nRelDiff );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case UNDO_TABLE_INSROW:
//STRIP001 		if( USHRT_MAX == nSetColType )
//STRIP001 			rDoc.InsertRow( aSelBoxes, nCount, bFlag );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SwTable& rTbl = pTblNd->GetTable();
//STRIP001 			SwTableBox* pBox = rTbl.GetTblBox( nCurrBox );
//STRIP001 			TblChgMode eOldMode = rTbl.GetTblChgMode();
//STRIP001 			rTbl.SetTblChgMode( (TblChgMode)nCount );
//STRIP001 			rDoc.SetColRowWidthHeight( *pBox, nSetColType, nAbsDiff, nRelDiff );
//STRIP001 			rTbl.SetTblChgMode( eOldMode );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case UNDO_TABLE_SPLIT:
//STRIP001         rDoc.SplitTbl( aSelBoxes, bFlag, nCount, bSameHeight );
//STRIP001 		break;
//STRIP001 	case UNDO_TABLE_DELBOX:
//STRIP001 		if( USHRT_MAX == nSetColType )
//STRIP001 		{
//STRIP001 			SwTableFmlUpdate aMsgHnt( &pTblNd->GetTable() );
//STRIP001 			aMsgHnt.eFlags = TBL_BOXPTR;
//STRIP001 			rDoc.UpdateTblFlds( &aMsgHnt );
//STRIP001 
//STRIP001 			pTblNd->GetTable().DeleteSel( &rDoc, aSelBoxes, this, TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SwTable& rTbl = pTblNd->GetTable();
//STRIP001 
//STRIP001 			SwTableFmlUpdate aMsgHnt( &rTbl );
//STRIP001 			aMsgHnt.eFlags = TBL_BOXPTR;
//STRIP001 			rDoc.UpdateTblFlds( &aMsgHnt );
//STRIP001 
//STRIP001 			SwTableBox* pBox = rTbl.GetTblBox( nCurrBox );
//STRIP001 			TblChgMode eOldMode = rTbl.GetTblChgMode();
//STRIP001 			rTbl.SetTblChgMode( (TblChgMode)nCount );
//STRIP001 
//STRIP001 			rDoc.DoUndo( TRUE );		// wir brauchen die SaveSections!
//STRIP001 			SwUndoTblNdsChg* pUndo = 0;
//STRIP001 
//STRIP001 			switch( nSetColType & 0xff )
//STRIP001 			{
//STRIP001 			case WH_COL_LEFT:
//STRIP001 			case WH_COL_RIGHT:
//STRIP001 			case WH_CELL_LEFT:
//STRIP001 			case WH_CELL_RIGHT:
//STRIP001 				 rTbl.SetColWidth( *pBox, nSetColType, nAbsDiff,
//STRIP001 									nRelDiff, (SwUndo**)&pUndo );
//STRIP001 				break;
//STRIP001 			case WH_ROW_TOP:
//STRIP001 			case WH_ROW_BOTTOM:
//STRIP001 			case WH_CELL_TOP:
//STRIP001 			case WH_CELL_BOTTOM:
//STRIP001 				rTbl.SetRowHeight( *pBox, nSetColType, nAbsDiff,
//STRIP001 									nRelDiff, (SwUndo**)&pUndo );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( pUndo )
//STRIP001 			{
//STRIP001 				Ptrs.pDelSects->Insert( pUndo->Ptrs.pDelSects, 0 );
//STRIP001 				pUndo->Ptrs.pDelSects->Remove( 0, pUndo->Ptrs.pDelSects->Count() );
//STRIP001 
//STRIP001 				delete pUndo;
//STRIP001 			}
//STRIP001 			rDoc.DoUndo( FALSE );
//STRIP001 
//STRIP001 			rTbl.SetTblChgMode( eOldMode );
//STRIP001 		}
//STRIP001 		nSttNode = pTblNd->GetIndex();
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }


/*  */


/*N*/  SwUndoTblMerge::SwUndoTblMerge( const SwPaM& rTblSel )
/*N*/  	: SwUndo( UNDO_TABLE_MERGE ), SwUndRng( rTblSel ), pHistory( 0 )
/*N*/  {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	const SwTableNode* pTblNd = rTblSel.GetNode()->FindTableNode();
//STRIP001 	ASSERT( pTblNd, "Wo ist TabllenNode" )
//STRIP001 	pSaveTbl = new _SaveTable( pTblNd->GetTable() );
//STRIP001 	pMoves = new SwUndoMoves;
//STRIP001 	nTblNode = pTblNd->GetIndex();
/*N*/ }


/*N*/  SwUndoTblMerge::~SwUndoTblMerge()
/*N*/  {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	delete pSaveTbl;
//STRIP001 	delete pMoves;
//STRIP001 	delete pHistory;
/*N*/ }


//STRIP001 void SwUndoTblMerge::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwNodeIndex aIdx( rDoc.GetNodes(), nTblNode );
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = rDoc.GetNodes()[ aIdx ]->GetTableNode();
//STRIP001 	ASSERT( pTblNd, "kein TabellenNode" );
//STRIP001 
//STRIP001 	SwTableFmlUpdate aMsgHnt( &pTblNd->GetTable() );
//STRIP001 	aMsgHnt.eFlags = TBL_BOXPTR;
//STRIP001 	rDoc.UpdateTblFlds( &aMsgHnt );
//STRIP001 
//STRIP001 	_FndBox aTmpBox( 0, 0 );
//STRIP001 	aTmpBox.SaveChartData( pTblNd->GetTable() );
//STRIP001 
//STRIP001 
//STRIP001 	// 1. die geloeschten Boxen wiederherstellen:
//STRIP001 
//STRIP001 	// Trick: die fehlenden Boxen in irgendeine Line einfuegen, beim
//STRIP001 	// CreateNew werden sie korrekt verbunden.
//STRIP001 	SwTableBox *pBox, *pCpyBox = pTblNd->GetTable().GetTabSortBoxes()[0];
//STRIP001 	SwTableBoxes& rLnBoxes = pCpyBox->GetUpper()->GetTabBoxes();
//STRIP001 
//STRIP001 DUMPDOC( &rDoc, "d:\\tmp\\tab_a.db" )
//STRIP001 CHECKTABLE(pTblNd->GetTable())
//STRIP001 
//STRIP001 	SwSelBoxes aSelBoxes;
//STRIP001 	SwTxtFmtColl* pColl = rDoc.GetTxtCollFromPool( RES_POOLCOLL_STANDARD );
//STRIP001 	for( USHORT n = 0; n < aBoxes.Count(); ++n )
//STRIP001 	{
//STRIP001 		aIdx = aBoxes[ n ];
//STRIP001 		SwStartNode* pSttNd = rDoc.GetNodes().MakeTextSection( aIdx,
//STRIP001 											SwTableBoxStartNode, pColl );
//STRIP001 		pBox = new SwTableBox( (SwTableBoxFmt*)pCpyBox->GetFrmFmt(), *pSttNd,
//STRIP001 								pCpyBox->GetUpper() );
//STRIP001 		rLnBoxes.C40_INSERT( SwTableBox, pBox, rLnBoxes.Count() );
//STRIP001 
//STRIP001 		aSelBoxes.Insert( pBox );
//STRIP001 	}
//STRIP001 
//STRIP001 DUMPDOC( &rDoc, "d:\\tmp\\tab_b.db" )
//STRIP001 CHECKTABLE(pTblNd->GetTable())
//STRIP001 
//STRIP001 	// 2. die eingefuegten Boxen loeschen
//STRIP001 	// die Nodes loeschen (von Hinten!!)
//STRIP001 	for( n = aNewSttNds.Count(); n; )
//STRIP001 	{
//STRIP001 		// Box aus der Tabellen-Struktur entfernen
//STRIP001 		ULONG nIdx = aNewSttNds[ --n ];
//STRIP001 
//STRIP001 		if( !nIdx && n )
//STRIP001 		{
//STRIP001 			nIdx = aNewSttNds[ --n ];
//STRIP001 			pBox = pTblNd->GetTable().GetTblBox( nIdx );
//STRIP001 			ASSERT( pBox, "Wo ist meine TabellenBox geblieben?" );
//STRIP001 
//STRIP001 			rDoc.GetNodes().MakeTxtNode( SwNodeIndex(
//STRIP001 					*pBox->GetSttNd()->EndOfSectionNode() ), pColl );
//STRIP001 
//STRIP001 			// das war der Trenner, -> die verschobenen herstellen
//STRIP001 			for( USHORT i = pMoves->Count(); i; )
//STRIP001 			{
//STRIP001 				SwTxtNode* pTxtNd;
//STRIP001 				USHORT nDelPos;
//STRIP001 				SwUndoMove* pUndo = (*pMoves)[ --i ];
//STRIP001 				if( !pUndo->IsMoveRange() )
//STRIP001 				{
//STRIP001 					pTxtNd = rDoc.GetNodes()[ pUndo->GetDestSttNode() ]->GetTxtNode();
//STRIP001 					nDelPos = pUndo->GetDestSttCntnt() - 1;
//STRIP001 				}
//STRIP001 				pUndo->Undo( rUndoIter );
//STRIP001 				if( pUndo->IsMoveRange() )
//STRIP001 				{
//STRIP001 					// den ueberfluessigen Node loeschen
//STRIP001 					aIdx = pUndo->GetEndNode();
//STRIP001 					rDoc.GetNodes().Delete( aIdx, 1 );
//STRIP001 				}
//STRIP001 				else if( pTxtNd )
//STRIP001 				{
//STRIP001 					// evt. noch ueberflussige Attribute loeschen
//STRIP001 					SwIndex aIdx( pTxtNd, nDelPos );
//STRIP001 					if( pTxtNd->GetpSwpHints() && pTxtNd->GetpSwpHints()->Count() )
//STRIP001 						pTxtNd->RstAttr( aIdx, pTxtNd->GetTxt().Len() -
//STRIP001 															nDelPos + 1 );
//STRIP001 					// das Trennzeichen loeschen
//STRIP001 					pTxtNd->Erase( aIdx, 1 );
//STRIP001 				}
//STRIP001 //				delete pUndo;
//STRIP001 DUMPDOC( &rDoc, String( "d:\\tmp\\tab_") + String( aNewSttNds.Count() - i ) +
//STRIP001 				String(".db") )
//STRIP001 			}
//STRIP001 //			pMoves->Remove( 0, pMoves->Count() );
//STRIP001 			nIdx = pBox->GetSttIdx();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pBox = pTblNd->GetTable().GetTblBox( nIdx );
//STRIP001 
//STRIP001 		SwTableBoxes* pTBoxes = &pBox->GetUpper()->GetTabBoxes();
//STRIP001 		pTBoxes->Remove( pTBoxes->C40_GETPOS( SwTableBox, pBox ) );
//STRIP001 
//STRIP001 
//STRIP001 		// Indizies aus dem Bereich loeschen
//STRIP001 		{
//STRIP001 			SwNodeIndex aIdx( *pBox->GetSttNd() );
//STRIP001 			rDoc.CorrAbs( SwNodeIndex( aIdx, 1 ),
//STRIP001 						SwNodeIndex( *aIdx.GetNode().EndOfSectionNode() ),
//STRIP001 						SwPosition( aIdx, SwIndex( 0, 0 )), TRUE );
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pBox;
//STRIP001 		rDoc.DeleteSection( rDoc.GetNodes()[ nIdx ] );
//STRIP001 	}
//STRIP001 DUMPDOC( &rDoc, "d:\\tmp\\tab_z.db" )
//STRIP001 CHECKTABLE(pTblNd->GetTable())
//STRIP001 
//STRIP001 
//STRIP001 	pSaveTbl->CreateNew( pTblNd->GetTable(), TRUE, FALSE );
//STRIP001 
//STRIP001 	aTmpBox.RestoreChartData( pTblNd->GetTable() );
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 		pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 	}
//STRIP001 //	nTblNode = pTblNd->GetIndex();
//STRIP001 
//STRIP001 	SwPaM* pPam = rUndoIter.pAktPam;
//STRIP001 	pPam->DeleteMark();
//STRIP001 	pPam->GetPoint()->nNode = nSttNode;
//STRIP001 	pPam->GetPoint()->nContent.Assign( pPam->GetCntntNode(), nSttCntnt );
//STRIP001 	pPam->SetMark();
//STRIP001 	pPam->DeleteMark();
//STRIP001 
//STRIP001 CHECKTABLE(pTblNd->GetTable())
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }


//STRIP001 void SwUndoTblMerge::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rUndoIter.pAktPam;
//STRIP001 	SwDoc& rDoc = *pPam->GetDoc();
//STRIP001 
//STRIP001 	SetPaM( *pPam );
//STRIP001 	rDoc.MergeTbl( *pPam );
//STRIP001 }


//STRIP001 void SwUndoTblMerge::MoveBoxCntnt( SwPaM& rPam, SwPosition& rPos,
//STRIP001 									const _SaveFlyArr& rArr )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = rPam.GetDoc();
//STRIP001 	SwNodeIndex aIdx( rPam.GetPoint()->nNode );
//STRIP001 	SwNode* pNd = &aIdx.GetNode();
//STRIP001 
//STRIP001 	// alle verschobenen Flys in der History vom Move-Object merken.
//STRIP001 	// Hier erstmal zwischenspeichern, damit die alten NodeIdx richtig sind
//STRIP001 	SwHistory aHst;
//STRIP001 	for( USHORT n = 0; n < rArr.Count(); ++n )
//STRIP001 		aHst.Add( *rArr[ n ].pFrmFmt );
//STRIP001 
//STRIP001 	SwUndoMove* pUndoMove;
//STRIP001 	if( pDoc->Move( rPam, rPos ) )
//STRIP001 		pUndoMove = (SwUndoMove*)pDoc->RemoveLastUndo( UNDO_MOVE );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// wir muessen das Undo Object haben!
//STRIP001 		pUndoMove = new SwUndoMove( rPam, rPos );
//STRIP001 		SwPaM aPam( rPos );
//STRIP001 		pUndoMove->SetDestRange( aPam, rPos, FALSE, FALSE );
//STRIP001 	}
//STRIP001 	ASSERT( pUndoMove, "falsches Undo-Object" );
//STRIP001 
//STRIP001 	// alle verschobenen Flys in der History vom Move-Object merken
//STRIP001 	if( aHst.Count() )
//STRIP001 		pUndoMove->AddTblMrgFlyHstry( aHst );
//STRIP001 
//STRIP001 	pMoves->Insert( pUndoMove, pMoves->Count() );
//STRIP001 
//STRIP001 	const SwStartNode* pBoxNd = pNd->FindTableBoxStartNode();
//STRIP001 	ULONG nDelNds = pBoxNd->EndOfSectionIndex() - pBoxNd->GetIndex();
//STRIP001 	if( 2 < nDelNds )
//STRIP001 	{
//STRIP001 		// es darf nur ein Textnode in der Box verbleiben!
//STRIP001 		rPam.DeleteMark();
//STRIP001 
//STRIP001 		// Indizies aus dem Bereich loeschen
//STRIP001 		{
//STRIP001 			pDoc->CorrAbs( SwNodeIndex( *pBoxNd ),
//STRIP001 							SwNodeIndex( *pBoxNd->EndOfSectionNode() ),
//STRIP001 							SwPosition( aIdx,
//STRIP001 								SwIndex( pNd->GetCntntNode(), 0 )), TRUE );
//STRIP001 		}
//STRIP001 
//STRIP001 //		rPam.GetBound1().nNode = rPam.GetBound2().nNode = aIdx;
//STRIP001 		if( aIdx.GetIndex() - 1  != pBoxNd->GetIndex() )
//STRIP001 		{
//STRIP001 			SwNodeIndex aTmp( *pBoxNd, 1 );
//STRIP001 			pDoc->GetNodes().Delete( aTmp, aIdx.GetIndex() - aTmp.GetIndex() );
//STRIP001 		}
//STRIP001 		aIdx++;
//STRIP001 		pDoc->GetNodes().Delete( aIdx, pBoxNd->EndOfSectionIndex() - aIdx.GetIndex() );
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoTblMerge::MoveBoxCntnt( SwDoc* pDoc, SwNodeRange& rRg, SwNodeIndex& rPos )
//STRIP001 {
//STRIP001 	SwNodeIndex aTmp( rRg.aStart, -1 ), aTmp2( rPos, -1 );
//STRIP001 	SwUndoMove* pUndo = new SwUndoMove( pDoc, rRg, rPos );
//STRIP001 	pDoc->Move( rRg, rPos );
//STRIP001 	aTmp++;
//STRIP001 	aTmp2++;
//STRIP001 	pUndo->SetDestRange( aTmp2, rPos, aTmp );
//STRIP001 
//STRIP001 	pMoves->Insert( pUndo, pMoves->Count() );
//STRIP001 }


//STRIP001 void SwUndoTblMerge::SetSelBoxes( const SwSelBoxes& rBoxes )
//STRIP001 {
//STRIP001 	// die Selektion merken
//STRIP001 	for( USHORT n = 0; n < rBoxes.Count(); ++n )
//STRIP001 		InsertSort( aBoxes, rBoxes[n]->GetSttIdx() );
//STRIP001 
//STRIP001 	// als Trennung fuers einfuegen neuer Boxen nach dem Verschieben!
//STRIP001 	aNewSttNds.Insert( (ULONG)0, aNewSttNds.Count() );
//STRIP001 
//STRIP001 	nTblNode = rBoxes[ 0 ]->GetSttNd()->FindTableNode()->GetIndex();
//STRIP001 }

//STRIP001 void SwUndoTblMerge::SaveCollection( const SwTableBox& rBox )
//STRIP001 {
//STRIP001 	if( !pHistory )
//STRIP001 		pHistory = new SwHistory;
//STRIP001 
//STRIP001 	SwNodeIndex aIdx( *rBox.GetSttNd(), 1 );
//STRIP001 	SwCntntNode* pCNd = aIdx.GetNode().GetCntntNode();
//STRIP001 	if( !pCNd )
//STRIP001 		pCNd = aIdx.GetNodes().GoNext( &aIdx );
//STRIP001 
//STRIP001 	pHistory->Add( pCNd->GetFmtColl(), aIdx.GetIndex(), pCNd->GetNodeType());
//STRIP001 	if( pCNd->GetpSwAttrSet() )
//STRIP001 		pHistory->CopyFmtAttr( *pCNd->GetpSwAttrSet(), aIdx.GetIndex() );
//STRIP001 }

/*  */


//STRIP001 SwUndoTblNumFmt::SwUndoTblNumFmt( const SwTableBox& rBox,
//STRIP001 									const SfxItemSet* pNewSet )
//STRIP001 	: SwUndo( UNDO_TBLNUMFMT ),
//STRIP001 	pBoxSet( 0 ), pHistory( 0 ), nFmtIdx( NUMBERFORMAT_TEXT )
//STRIP001 {
//STRIP001 	bNewFmt = bNewFml = bNewValue = FALSE;
//STRIP001 	nNode = rBox.GetSttIdx();
//STRIP001 
//STRIP001 	ULONG nNdPos = rBox.IsValidNumTxtNd( 0 == pNewSet );
//STRIP001 
//STRIP001 	if( ULONG_MAX != nNdPos )
//STRIP001 	{
//STRIP001 		SwDoc* pDoc = rBox.GetFrmFmt()->GetDoc();
//STRIP001 		SwTxtNode* pTNd = pDoc->GetNodes()[ nNdPos ]->GetTxtNode();
//STRIP001 
//STRIP001 		pHistory = new SwHistory;
//STRIP001 		SwRegHistory aRHst( *rBox.GetSttNd(), pHistory );
//STRIP001 		// immer alle TextAttribute sichern; ist fuers Undo mit voll-
//STRIP001 		// staendiger Attributierung am besten, wegen den evt.
//STRIP001 		// Ueberlappenden Bereichen von An/Aus.
//STRIP001 		pHistory->CopyAttr( pTNd->GetpSwpHints(), nNdPos, 0,
//STRIP001 							pTNd->GetTxt().Len(), TRUE );
//STRIP001 
//STRIP001 		if( pTNd->GetpSwAttrSet() )
//STRIP001 			pHistory->CopyFmtAttr( *pTNd->GetpSwAttrSet(), nNdPos );
//STRIP001 
//STRIP001 		aStr = pTNd->GetTxt();
//STRIP001 		if( pTNd->GetpSwpHints() )
//STRIP001 			pTNd->GetpSwpHints()->DeRegister();
//STRIP001 
//STRIP001 		pBoxSet = new SfxItemSet( pDoc->GetAttrPool(), aTableBoxSetRange );
//STRIP001 		pBoxSet->Put( rBox.GetFrmFmt()->GetAttrSet() );
//STRIP001 
//STRIP001 		if( pNewSet )
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			if( SFX_ITEM_SET == pNewSet->GetItemState( RES_BOXATR_FORMAT,
//STRIP001 					FALSE, &pItem ))
//STRIP001 			{
//STRIP001 				bNewFmt = TRUE;
//STRIP001 				nNewFmtIdx = ((SwTblBoxNumFormat*)pItem)->GetValue();
//STRIP001 			}
//STRIP001 			if( SFX_ITEM_SET == pNewSet->GetItemState( RES_BOXATR_FORMULA,
//STRIP001 					FALSE, &pItem ))
//STRIP001 			{
//STRIP001 				bNewFml = TRUE;
//STRIP001 				aNewFml = ((SwTblBoxFormula*)pItem)->GetFormula();
//STRIP001 			}
//STRIP001 			if( SFX_ITEM_SET == pNewSet->GetItemState( RES_BOXATR_VALUE,
//STRIP001 					FALSE, &pItem ))
//STRIP001 			{
//STRIP001 				bNewValue = TRUE;
//STRIP001 				fNewNum = ((SwTblBoxValue*)pItem)->GetValue();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// wird die History ueberhaupt benoetigt ??
//STRIP001 	if( pHistory && !pHistory->Count() )
//STRIP001 		DELETEZ( pHistory );
//STRIP001 }


//STRIP001 SwUndoTblNumFmt::~SwUndoTblNumFmt()
//STRIP001 {
//STRIP001 	delete pHistory;
//STRIP001 	delete pBoxSet;
//STRIP001 }

//STRIP001 void SwUndoTblNumFmt::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	// konnte die Box veraendert werden ?
//STRIP001 	if( !pBoxSet )
//STRIP001 		return ;
//STRIP001 
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	SwStartNode* pSttNd = rDoc.GetNodes()[ nNode ]->
//STRIP001 							FindSttNodeByType( SwTableBoxStartNode );
//STRIP001 	ASSERT( pSttNd, "ohne StartNode kein TabellenBox" );
//STRIP001 	SwTableBox* pBox = pSttNd->FindTableNode()->GetTable().GetTblBox(
//STRIP001 									pSttNd->GetIndex() );
//STRIP001 	ASSERT( pBox, "keine TabellenBox gefunden" );
//STRIP001 
//STRIP001 	SwTableBoxFmt* pFmt = rDoc.MakeTableBoxFmt();
//STRIP001 	pFmt->SetAttr( *pBoxSet );
//STRIP001 	pBox->ChgFrmFmt( pFmt );
//STRIP001 
//STRIP001 	SwTxtNode* pTxtNd = rDoc.GetNodes()[ nNode + 1 ]->GetTxtNode();
//STRIP001 	// wenn mehr als ein Node geloescht wurde, dann wurden auch
//STRIP001 	// alle "Node"-Attribute gespeichert
//STRIP001 	if( pTxtNd->GetpSwAttrSet() )
//STRIP001 		pTxtNd->ResetAllAttr();
//STRIP001 
//STRIP001 	if( pTxtNd->GetpSwpHints() )
//STRIP001 		pTxtNd->ClearSwpHintsArr( FALSE );
//STRIP001 
//STRIP001     // ChgTextToNum(..) only acts when the strings are different. We
//STRIP001     // need to do the same here.
//STRIP001     if( pTxtNd->GetTxt() != aStr )
//STRIP001     {
//STRIP001         rDoc.DeleteRedline( *( pBox->GetSttNd() ), sal_False );
//STRIP001 
//STRIP001         SwIndex aIdx( pTxtNd, 0 );
//STRIP001         pTxtNd->Erase( aIdx );
//STRIP001         if( aStr.Len() )
//STRIP001             pTxtNd->Insert( aStr, aIdx, INS_NOHINTEXPAND );
//STRIP001     }
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		USHORT nTmpEnd = pHistory->GetTmpEnd();
//STRIP001 		pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 		pHistory->SetTmpEnd( nTmpEnd );
//STRIP001 	}
//STRIP001 
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	pPam->DeleteMark();
//STRIP001 	pPam->GetPoint()->nNode = nNode + 1;
//STRIP001 	pPam->GetPoint()->nContent.Assign( pTxtNd, 0 );
//STRIP001 }

/** switch the RedlineMode on the given document, using
 * SetRedlineMode_intern. This class set the mode in the constructor,
 * and changes it back in the destructor, i.e. it uses the
 * initialization-is-resource-acquisition idiom. 
 */
//STRIP001 class RedlineModeInternGuard
//STRIP001 {
//STRIP001     SwDoc& mrDoc;
//STRIP001     SwRedlineMode meOldRedlineMode;
//STRIP001 
//STRIP001 public:
//STRIP001     RedlineModeInternGuard( 
//STRIP001         SwDoc& rDoc,                      /// change mode of this document
//STRIP001         SwRedlineMode eNewRedlineMode,    /// new redline mode
//STRIP001         SwRedlineMode eRedlineModeMask  = /// change only bits set in this mask
//STRIP001             static_cast<SwRedlineMode> ( REDLINE_ON | REDLINE_IGNORE ) );
//STRIP001     ~RedlineModeInternGuard();
//STRIP001 };

//STRIP001 RedlineModeInternGuard::RedlineModeInternGuard( 
//STRIP001     SwDoc& rDoc, 
//STRIP001     SwRedlineMode eNewRedlineMode,
//STRIP001     SwRedlineMode eRedlineModeMask ) 
//STRIP001     : mrDoc( rDoc ),
//STRIP001       meOldRedlineMode( rDoc.GetRedlineMode() )
//STRIP001 {
//STRIP001     mrDoc.SetRedlineMode_intern( ( meOldRedlineMode & ~eRedlineModeMask ) |
//STRIP001                                  ( eNewRedlineMode & eRedlineModeMask ) );
//STRIP001 }

//STRIP001 RedlineModeInternGuard::~RedlineModeInternGuard()
//STRIP001 {
//STRIP001     mrDoc.SetRedlineMode_intern( meOldRedlineMode );
//STRIP001 }



//STRIP001 void SwUndoTblNumFmt::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	// konnte die Box veraendert werden ?
//STRIP001 	if( !pBoxSet )
//STRIP001 		return ;
//STRIP001 
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	pPam->DeleteMark();
//STRIP001 	pPam->GetPoint()->nNode = nNode;
//STRIP001 
//STRIP001 	SwNode* pNd = rDoc.GetNodes()[ pPam->GetPoint()->nNode ];
//STRIP001 	SwStartNode* pSttNd = pNd->FindSttNodeByType( SwTableBoxStartNode );
//STRIP001 	ASSERT( pSttNd, "ohne StartNode kein TabellenBox" );
//STRIP001 	SwTableBox* pBox = pSttNd->FindTableNode()->GetTable().GetTblBox(
//STRIP001 									pSttNd->GetIndex() );
//STRIP001 	ASSERT( pBox, "keine TabellenBox gefunden" );
//STRIP001 
//STRIP001 	SwFrmFmt* pBoxFmt = pBox->ClaimFrmFmt();
//STRIP001 	if(	bNewFmt || bNewFml || bNewValue )
//STRIP001 	{
//STRIP001 		SfxItemSet aBoxSet( rDoc.GetAttrPool(),
//STRIP001 								RES_BOXATR_FORMAT, RES_BOXATR_VALUE );
//STRIP001 
//STRIP001 		// JP 15.01.99: Nur Attribute zuruecksetzen reicht nicht.
//STRIP001 		//				Sorge dafuer, das der Text auch entsprechend
//STRIP001 		//				formatiert wird!
//STRIP001 		pBoxFmt->LockModify();
//STRIP001 
//STRIP001 		if( bNewFml )
//STRIP001 			aBoxSet.Put( SwTblBoxFormula( aNewFml ));
//STRIP001 		else
//STRIP001 			pBoxFmt->ResetAttr( RES_BOXATR_FORMULA );
//STRIP001 		if( bNewFmt )
//STRIP001 			aBoxSet.Put( SwTblBoxNumFormat( nNewFmtIdx ));
//STRIP001 		else
//STRIP001 			pBoxFmt->ResetAttr( RES_BOXATR_FORMAT );
//STRIP001 		if( bNewValue )
//STRIP001 			aBoxSet.Put( SwTblBoxValue( fNewNum ));
//STRIP001 		else
//STRIP001 			pBoxFmt->ResetAttr( RES_BOXATR_VALUE );
//STRIP001 		pBoxFmt->UnlockModify();
//STRIP001 
//STRIP001         // dvo: When redlining is (was) enabled, setting the attribute
//STRIP001         // will also change the cell content. To allow this, the
//STRIP001         // REDLINE_IGNORE flag must be removed during Redo. #108450#
//STRIP001         RedlineModeInternGuard aGuard( rDoc, REDLINE_NONE, REDLINE_IGNORE );
//STRIP001 		pBoxFmt->SetAttr( aBoxSet );
//STRIP001 	}
//STRIP001 	else if( NUMBERFORMAT_TEXT != nFmtIdx )
//STRIP001 	{
//STRIP001 		SfxItemSet aBoxSet( rDoc.GetAttrPool(),
//STRIP001 							RES_BOXATR_FORMAT, RES_BOXATR_VALUE );
//STRIP001 
//STRIP001 		aBoxSet.Put( SwTblBoxNumFormat( nFmtIdx ));
//STRIP001 		aBoxSet.Put( SwTblBoxValue( fNum ));
//STRIP001 
//STRIP001 		// JP 15.01.99: Nur Attribute zuruecksetzen reicht nicht.
//STRIP001 		//				Sorge dafuer, das der Text auch entsprechend
//STRIP001 		//				formatiert wird!
//STRIP001 		pBoxFmt->LockModify();
//STRIP001 		pBoxFmt->ResetAttr( RES_BOXATR_FORMULA );
//STRIP001 		pBoxFmt->UnlockModify();
//STRIP001 
//STRIP001         // dvo: When redlining is (was) enabled, setting the attribute
//STRIP001         // will also change the cell content. To allow this, the
//STRIP001         // REDLINE_IGNORE flag must be removed during Redo. #108450#
//STRIP001         RedlineModeInternGuard aGuard( rDoc, REDLINE_NONE, REDLINE_IGNORE );
//STRIP001 		pBoxFmt->SetAttr( aBoxSet );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// es ist keine Zahl
//STRIP001 
//STRIP001 		// JP 15.01.99: Nur Attribute zuruecksetzen reicht nicht.
//STRIP001 		//				Sorge dafuer, das der Text auch entsprechend
//STRIP001 		//				formatiert wird!
//STRIP001 		pBoxFmt->SetAttr( *GetDfltAttr( RES_BOXATR_FORMAT ));
//STRIP001 
//STRIP001 		pBoxFmt->ResetAttr( RES_BOXATR_FORMAT, RES_BOXATR_VALUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bNewFml )
//STRIP001 	{
//STRIP001 		// egal was gesetzt wurde, ein Update der Tabelle macht sich immer gut
//STRIP001 		SwTableFmlUpdate aTblUpdate( &pSttNd->FindTableNode()->GetTable() );
//STRIP001 		rDoc.UpdateTblFlds( &aTblUpdate );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pNd->IsCntntNode() )
//STRIP001 		pNd = rDoc.GetNodes().GoNext( &pPam->GetPoint()->nNode );
//STRIP001 	pPam->GetPoint()->nContent.Assign( (SwCntntNode*)pNd, 0 );
//STRIP001 }

//STRIP001 void SwUndoTblNumFmt::SetBox( const SwTableBox& rBox )
//STRIP001 {
//STRIP001 	nNode = rBox.GetSttIdx();
//STRIP001 }

/*  */

//STRIP001 _UndoTblCpyTbl_Entry::_UndoTblCpyTbl_Entry( const SwTableBox& rBox )
//STRIP001 	: nBoxIdx( rBox.GetSttIdx() ), nOffset( 0 ),
//STRIP001 	pBoxNumAttr( 0 ), pUndo( 0 )
//STRIP001 {
//STRIP001 }

//STRIP001 _UndoTblCpyTbl_Entry::~_UndoTblCpyTbl_Entry()
//STRIP001 {
//STRIP001 	delete pUndo;
//STRIP001 	delete pBoxNumAttr;
//STRIP001 }


//STRIP001 SwUndoTblCpyTbl::SwUndoTblCpyTbl()
//STRIP001 	: SwUndo( UNDO_TBLCPYTBL ), pInsRowUndo( 0 )
//STRIP001 {
//STRIP001 	pArr = new _UndoTblCpyTbl_Entries;
//STRIP001 }

//STRIP001 SwUndoTblCpyTbl::~SwUndoTblCpyTbl()
//STRIP001 {
//STRIP001 	delete pArr;
//STRIP001 	delete pInsRowUndo;
//STRIP001 }

//STRIP001 void SwUndoTblCpyTbl::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = 0;
//STRIP001 	for( USHORT n = pArr->Count(); n; )
//STRIP001 	{
//STRIP001 		_UndoTblCpyTbl_Entry* pEntry = (*pArr)[ --n ];
//STRIP001 		ULONG nSttPos = pEntry->nBoxIdx + pEntry->nOffset;
//STRIP001 		SwStartNode* pSNd = rDoc.GetNodes()[ nSttPos ]->FindStartNode();
//STRIP001 		if( !pTblNd )
//STRIP001 			pTblNd = pSNd->FindTableNode();
//STRIP001 
//STRIP001 		SwTableBox& rBox = *pTblNd->GetTable().GetTblBox( nSttPos );
//STRIP001 
//STRIP001 		SwNodeIndex aInsIdx( *rBox.GetSttNd(), 1 );
//STRIP001 		SwTxtNode* pNd = rDoc.GetNodes().MakeTxtNode( aInsIdx,
//STRIP001 								(SwTxtFmtColl*)rDoc.GetDfltTxtFmtColl());
//STRIP001 		SwPaM aPam( aInsIdx.GetNode(), *rBox.GetSttNd()->EndOfSectionNode() );
//STRIP001 		SwUndoDelete* pUndo = new SwUndoDelete( aPam, TRUE );
//STRIP001 
//STRIP001 		if( pEntry->pUndo )
//STRIP001 		{
//STRIP001 			pEntry->pUndo->Undo( rIter );
//STRIP001 			delete pEntry->pUndo;
//STRIP001 		}
//STRIP001 		pEntry->pUndo = pUndo;
//STRIP001 
//STRIP001 		aInsIdx = rBox.GetSttIdx() + 1;
//STRIP001 		rDoc.GetNodes().Delete( aInsIdx, 1 );
//STRIP001 
//STRIP001 		SfxItemSet aTmpSet( rDoc.GetAttrPool(), RES_BOXATR_FORMAT, RES_BOXATR_VALUE,
//STRIP001 												RES_VERT_ORIENT, RES_VERT_ORIENT, 0 );
//STRIP001 		aTmpSet.Put( rBox.GetFrmFmt()->GetAttrSet() );
//STRIP001 		if( aTmpSet.Count() )
//STRIP001 		{
//STRIP001 			SwFrmFmt* pBoxFmt = rBox.ClaimFrmFmt();
//STRIP001 			pBoxFmt->ResetAttr( RES_BOXATR_FORMAT, RES_BOXATR_VALUE );
//STRIP001 			pBoxFmt->ResetAttr( RES_VERT_ORIENT );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pEntry->pBoxNumAttr )
//STRIP001 		{
//STRIP001 			rBox.ClaimFrmFmt()->SetAttr( *pEntry->pBoxNumAttr );
//STRIP001 			delete pEntry->pBoxNumAttr, pEntry->pBoxNumAttr = 0;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aTmpSet.Count() )
//STRIP001 		{
//STRIP001 			pEntry->pBoxNumAttr = new SfxItemSet( rDoc.GetAttrPool(),
//STRIP001 									RES_BOXATR_FORMAT, RES_BOXATR_VALUE,
//STRIP001 									RES_VERT_ORIENT, RES_VERT_ORIENT, 0 );
//STRIP001 			pEntry->pBoxNumAttr->Put( aTmpSet );
//STRIP001 		}
//STRIP001 
//STRIP001 		pEntry->nOffset = rBox.GetSttIdx() - pEntry->nBoxIdx;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pInsRowUndo )
//STRIP001 		pInsRowUndo->Undo( rIter );
//STRIP001 }

//STRIP001 void SwUndoTblCpyTbl::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 
//STRIP001 	if( pInsRowUndo )
//STRIP001 		pInsRowUndo->Redo( rIter );
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = 0;
//STRIP001 	for( USHORT n = 0; n < pArr->Count(); ++n )
//STRIP001 	{
//STRIP001 		_UndoTblCpyTbl_Entry* pEntry = (*pArr)[ n ];
//STRIP001 		ULONG nSttPos = pEntry->nBoxIdx + pEntry->nOffset;
//STRIP001 		SwStartNode* pSNd = rDoc.GetNodes()[ nSttPos ]->FindStartNode();
//STRIP001 		if( !pTblNd )
//STRIP001 			pTblNd = pSNd->FindTableNode();
//STRIP001 
//STRIP001 		SwTableBox& rBox = *pTblNd->GetTable().GetTblBox( nSttPos );
//STRIP001 
//STRIP001 		SwNodeIndex aInsIdx( *rBox.GetSttNd(), 1 );
//STRIP001 		SwTxtNode* pNd = rDoc.GetNodes().MakeTxtNode( aInsIdx,
//STRIP001 								(SwTxtFmtColl*)rDoc.GetDfltTxtFmtColl());
//STRIP001 		SwPaM aPam( aInsIdx.GetNode(), *rBox.GetSttNd()->EndOfSectionNode());
//STRIP001 		SwUndoDelete* pUndo = new SwUndoDelete( aPam, TRUE );
//STRIP001 
//STRIP001 		if( pEntry->pUndo )
//STRIP001 		{
//STRIP001 			pEntry->pUndo->Undo( rIter );
//STRIP001 			delete pEntry->pUndo;
//STRIP001 		}
//STRIP001 		pEntry->pUndo = pUndo;
//STRIP001 
//STRIP001 		aInsIdx = rBox.GetSttIdx() + 1;
//STRIP001 		rDoc.GetNodes().Delete( aInsIdx, 1 );
//STRIP001 
//STRIP001 		SfxItemSet aTmpSet( rDoc.GetAttrPool(), RES_BOXATR_FORMAT, RES_BOXATR_VALUE,
//STRIP001 												RES_VERT_ORIENT, RES_VERT_ORIENT, 0 );
//STRIP001 		aTmpSet.Put( rBox.GetFrmFmt()->GetAttrSet() );
//STRIP001 		if( aTmpSet.Count() )
//STRIP001 		{
//STRIP001 			SwFrmFmt* pBoxFmt = rBox.ClaimFrmFmt();
//STRIP001 			pBoxFmt->ResetAttr( RES_BOXATR_FORMAT, RES_BOXATR_VALUE );
//STRIP001 			pBoxFmt->ResetAttr( RES_VERT_ORIENT );
//STRIP001 		}
//STRIP001 		if( pEntry->pBoxNumAttr )
//STRIP001 		{
//STRIP001 			rBox.ClaimFrmFmt()->SetAttr( *pEntry->pBoxNumAttr );
//STRIP001 			delete pEntry->pBoxNumAttr, pEntry->pBoxNumAttr = 0;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aTmpSet.Count() )
//STRIP001 		{
//STRIP001 			pEntry->pBoxNumAttr = new SfxItemSet( rDoc.GetAttrPool(),
//STRIP001 									RES_BOXATR_FORMAT, RES_BOXATR_VALUE,
//STRIP001 									RES_VERT_ORIENT, RES_VERT_ORIENT, 0 );
//STRIP001 			pEntry->pBoxNumAttr->Put( aTmpSet );
//STRIP001 		}
//STRIP001 
//STRIP001 		pEntry->nOffset = rBox.GetSttIdx() - pEntry->nBoxIdx;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoTblCpyTbl::AddBoxBefore( const SwTableBox& rBox, BOOL bDelCntnt )
//STRIP001 {
//STRIP001 	if( pArr->Count() && !bDelCntnt )
//STRIP001 		return;
//STRIP001 
//STRIP001 	_UndoTblCpyTbl_Entry* pEntry = new _UndoTblCpyTbl_Entry( rBox );
//STRIP001 	pArr->Insert( pEntry, pArr->Count() );
//STRIP001 
//STRIP001 	SwDoc* pDoc = rBox.GetFrmFmt()->GetDoc();
//STRIP001 	if( bDelCntnt )
//STRIP001 	{
//STRIP001 		SwNodeIndex aInsIdx( *rBox.GetSttNd(), 1 );
//STRIP001 		SwTxtNode* pNd = pDoc->GetNodes().MakeTxtNode( aInsIdx,
//STRIP001 								(SwTxtFmtColl*)pDoc->GetDfltTxtFmtColl());
//STRIP001 		SwPaM aPam( aInsIdx.GetNode(), *rBox.GetSttNd()->EndOfSectionNode() );
//STRIP001 		pEntry->pUndo = new SwUndoDelete( aPam, TRUE );
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	pEntry->pBoxNumAttr = new SfxItemSet( pDoc->GetAttrPool(),
//STRIP001 									RES_BOXATR_FORMAT, RES_BOXATR_VALUE,
//STRIP001 									RES_VERT_ORIENT, RES_VERT_ORIENT, 0 );
//STRIP001 	pEntry->pBoxNumAttr->Put( rBox.GetFrmFmt()->GetAttrSet() );
//STRIP001 	if( !pEntry->pBoxNumAttr->Count() )
//STRIP001 		delete pEntry->pBoxNumAttr, pEntry->pBoxNumAttr = 0;
//STRIP001 }

//STRIP001 void SwUndoTblCpyTbl::AddBoxAfter( const SwTableBox& rBox, BOOL bDelCntnt )
//STRIP001 {
//STRIP001 	_UndoTblCpyTbl_Entry* pEntry = (*pArr)[ pArr->Count() - 1 ];
//STRIP001 
//STRIP001 	// wurde der Inhalt geloescht, so loesche jetzt auch noch den temp.
//STRIP001 	// erzeugten Node
//STRIP001 	if( bDelCntnt && pEntry->pUndo )
//STRIP001 	{
//STRIP001 		SwNodeIndex aDelIdx( *rBox.GetSttNd(), 1 );
//STRIP001 		rBox.GetFrmFmt()->GetDoc()->GetNodes().Delete( aDelIdx, 1 );
//STRIP001 	}
//STRIP001 	pEntry->nOffset = rBox.GetSttIdx() - pEntry->nBoxIdx;
//STRIP001 }

//STRIP001 BOOL SwUndoTblCpyTbl::InsertRow( SwTable& rTbl, const SwSelBoxes& rBoxes,
//STRIP001 								USHORT nCnt )
//STRIP001 {
//STRIP001 	SwTableNode* pTblNd = (SwTableNode*)rTbl.GetTabSortBoxes()[0]->
//STRIP001 								GetSttNd()->FindTableNode();
//STRIP001 
//STRIP001 	SwTableSortBoxes aTmpLst( 0, 5 );
//STRIP001 	pInsRowUndo = new SwUndoTblNdsChg( UNDO_TABLE_INSROW, rBoxes, *pTblNd,
//STRIP001 										nCnt, TRUE );
//STRIP001 	aTmpLst.Insert( &rTbl.GetTabSortBoxes(), 0, rTbl.GetTabSortBoxes().Count() );
//STRIP001 
//STRIP001 	BOOL bRet = rTbl.InsertRow( rTbl.GetFrmFmt()->GetDoc(), rBoxes, nCnt, TRUE );
//STRIP001 	if( bRet )
//STRIP001 		pInsRowUndo->SaveNewBoxes( *pTblNd, aTmpLst );
//STRIP001 	else
//STRIP001 		delete pInsRowUndo, pInsRowUndo = 0;
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 BOOL SwUndoTblCpyTbl::IsEmpty() const
//STRIP001 {
//STRIP001 	return !pInsRowUndo && !pArr->Count();
//STRIP001 }

/*  */

//STRIP001 SwUndoCpyTbl::SwUndoCpyTbl()
//STRIP001 	: SwUndo( UNDO_CPYTBL ), pDel( 0 ), nTblNode( 0 )
//STRIP001 {
//STRIP001 }

//STRIP001 SwUndoCpyTbl::~SwUndoCpyTbl()
//STRIP001 {
//STRIP001 	delete pDel;
//STRIP001 }

//STRIP001 void SwUndoCpyTbl::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	SwTableNode* pTNd = rDoc.GetNodes()[ nTblNode ]->GetTableNode();
//STRIP001 
//STRIP001 	// harte SeitenUmbrueche am nachfolgenden Node verschieben
//STRIP001 	SwCntntNode* pNextNd = rDoc.GetNodes()[ pTNd->EndOfSectionIndex()+1 ]->GetCntntNode();
//STRIP001 	if( pNextNd )
//STRIP001 	{
//STRIP001 		SwFrmFmt* pTableFmt = pTNd->GetTable().GetFrmFmt();
//STRIP001 		const SfxPoolItem *pItem;
//STRIP001 
//STRIP001 		if( SFX_ITEM_SET == pTableFmt->GetItemState( RES_PAGEDESC,
//STRIP001 			FALSE, &pItem ) )
//STRIP001 			pNextNd->SetAttr( *pItem );
//STRIP001 
//STRIP001 		if( SFX_ITEM_SET == pTableFmt->GetItemState( RES_BREAK,
//STRIP001 			FALSE, &pItem ) )
//STRIP001 			pNextNd->SetAttr( *pItem );
//STRIP001 	}
//STRIP001 
//STRIP001 	SwPaM aPam( *pTNd, *pTNd->EndOfSectionNode(), 0 , 1 );
//STRIP001 	pDel = new SwUndoDelete( aPam, TRUE );
//STRIP001 }

//STRIP001 void SwUndoCpyTbl::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	pDel->Undo( rIter );
//STRIP001 	delete pDel, pDel = 0;
//STRIP001 }


/*  */

//STRIP001 SwUndoSplitTbl::SwUndoSplitTbl( const SwTableNode& rTblNd, USHORT eMode,
//STRIP001 								BOOL bNewSize )
//STRIP001 	: SwUndo( UNDO_SPLIT_TABLE ), pSavTbl( 0 ),
//STRIP001 	nTblNode( rTblNd.GetIndex() ), nMode( eMode ), nOffset( 0 ), nFmlEnd( 0 ),
//STRIP001 	pHistory( 0 ), bCalcNewSize( bNewSize )
//STRIP001 {
//STRIP001 	switch( nMode )
//STRIP001 	{
//STRIP001 	case HEADLINE_BOXATRCOLLCOPY:
//STRIP001 			pHistory = new SwHistory;
//STRIP001 			// kein break;
//STRIP001 	case HEADLINE_BORDERCOPY:
//STRIP001 	case HEADLINE_BOXATTRCOPY:
//STRIP001 		pSavTbl = new _SaveTable( rTblNd.GetTable(), 1, FALSE );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

//STRIP001 SwUndoSplitTbl::~SwUndoSplitTbl()
//STRIP001 {
//STRIP001 	delete pSavTbl;
//STRIP001 	delete pHistory;
//STRIP001 }

//STRIP001 void SwUndoSplitTbl::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	pPam->DeleteMark();
//STRIP001 	SwNodeIndex& rIdx = pPam->GetPoint()->nNode;
//STRIP001 	rIdx = nTblNode + nOffset;
//STRIP001 
//STRIP001 	//Den implizit erzeugten Absatz wieder entfernen.
//STRIP001 	pDoc->GetNodes().Delete( rIdx, 1 );
//STRIP001 
//STRIP001 	rIdx = nTblNode + nOffset;
//STRIP001 	SwTableNode* pTblNd = rIdx.GetNode().GetTableNode();
//STRIP001 	SwTable& rTbl = pTblNd->GetTable();
//STRIP001 
//STRIP001 	SwTableFmlUpdate aMsgHnt( &rTbl );
//STRIP001 	aMsgHnt.eFlags = TBL_BOXPTR;
//STRIP001 	pDoc->UpdateTblFlds( &aMsgHnt );
//STRIP001 
//STRIP001 	switch( nMode )
//STRIP001 	{
//STRIP001 	case HEADLINE_BOXATRCOLLCOPY:
//STRIP001 		if( pHistory )
//STRIP001 			pHistory->TmpRollback( pDoc, nFmlEnd );
//STRIP001 
//STRIP001 		// kein break
//STRIP001 	case HEADLINE_BOXATTRCOPY:
//STRIP001 	case HEADLINE_BORDERCOPY:
//STRIP001 		{
//STRIP001 			pSavTbl->CreateNew( rTbl, FALSE );
//STRIP001 			pSavTbl->RestoreAttr( rTbl );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case HEADLINE_CNTNTCOPY:
//STRIP001 		// die erzeugte 1. Line muss wieder entfernt werden
//STRIP001 		{
//STRIP001 			SwSelBoxes aSelBoxes;
//STRIP001 			SwTableBox* pBox = rTbl.GetTblBox( nTblNode + nOffset + 1 );
//STRIP001 			rTbl.SelLineFromBox( pBox, aSelBoxes, TRUE );
//STRIP001 			rTbl.DeleteSel( pDoc, aSelBoxes, 0, FALSE, FALSE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	pDoc->GetNodes().MergeTable( rIdx );
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		pHistory->TmpRollback( pDoc, 0 );
//STRIP001 		pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }

//STRIP001 void SwUndoSplitTbl::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	pPam->DeleteMark();
//STRIP001 	pPam->GetPoint()->nNode = nTblNode;
//STRIP001 	pDoc->SplitTable( *pPam->GetPoint(), nMode, bCalcNewSize );
//STRIP001 
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }

//STRIP001 void SwUndoSplitTbl::Repeat( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	pDoc->SplitTable( *pPam->GetPoint(), nMode, bCalcNewSize );
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }

//STRIP001 void SwUndoSplitTbl::SaveFormula( SwHistory& rHistory )
//STRIP001 {
//STRIP001 	if( !pHistory )
//STRIP001 		pHistory = new SwHistory;
//STRIP001 
//STRIP001 	nFmlEnd = rHistory.Count();
//STRIP001 	pHistory->Move( 0, &rHistory );
//STRIP001 }

/*  */

//STRIP001 SwUndoMergeTbl::SwUndoMergeTbl( const SwTableNode& rTblNd,
//STRIP001 								const SwTableNode& rDelTblNd,
//STRIP001 								BOOL bWithPrv, USHORT nMd )
//STRIP001 	: SwUndo( UNDO_MERGE_TABLE ), pSavTbl( 0 ),
//STRIP001 	pHistory( 0 ), bWithPrev( bWithPrv ), nMode( nMd )
//STRIP001 {
//STRIP001 	// Endnode der letzen Tabellenzelle merken, die auf der Position verbleibt
//STRIP001 	if( bWithPrev )
//STRIP001 		nTblNode = rDelTblNd.EndOfSectionIndex() - 1;
//STRIP001 	else
//STRIP001 		nTblNode = rTblNd.EndOfSectionIndex() - 1;
//STRIP001 
//STRIP001 	aName = rDelTblNd.GetTable().GetFrmFmt()->GetName();
//STRIP001 	pSavTbl = new _SaveTable( rDelTblNd.GetTable() );
//STRIP001 
//STRIP001 	pSavHdl = bWithPrev ? new _SaveTable( rTblNd.GetTable(), 1 ) : 0;
//STRIP001 }

//STRIP001 SwUndoMergeTbl::~SwUndoMergeTbl()
//STRIP001 {
//STRIP001 	delete pSavTbl;
//STRIP001 	delete pSavHdl;
//STRIP001 	delete pHistory;
//STRIP001 }

//STRIP001 void SwUndoMergeTbl::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	pPam->DeleteMark();
//STRIP001 	SwNodeIndex& rIdx = pPam->GetPoint()->nNode;
//STRIP001 	rIdx = nTblNode;
//STRIP001 
//STRIP001 	SwTableNode* pTblNd = rIdx.GetNode().FindTableNode();
//STRIP001 	SwTable* pTbl = &pTblNd->GetTable();
//STRIP001 
//STRIP001 	SwTableFmlUpdate aMsgHnt( pTbl );
//STRIP001 	aMsgHnt.eFlags = TBL_BOXPTR;
//STRIP001 	pDoc->UpdateTblFlds( &aMsgHnt );
//STRIP001 
//STRIP001 	//Lines fuer das Layout-Update herausuchen.
//STRIP001 	_FndBox aFndBox( 0, 0 );
//STRIP001 	aFndBox.SetTableLines( *pTbl );
//STRIP001 	aFndBox.DelFrms( *pTbl );
//STRIP001 	aFndBox.SaveChartData( *pTbl );
//STRIP001 
//STRIP001 	SwTableNode* pNew = pDoc->GetNodes().SplitTable( rIdx, TRUE, FALSE );
//STRIP001 
//STRIP001 	//Layout updaten
//STRIP001 	aFndBox.MakeFrms( *pTbl );
//STRIP001 	aFndBox.RestoreChartData( *pTbl );
//STRIP001 
//STRIP001 	if( bWithPrev )
//STRIP001 	{
//STRIP001 		// den Namen umsetzen
//STRIP001 		pNew->GetTable().GetFrmFmt()->SetName( pTbl->GetFrmFmt()->GetName() );
//STRIP001 		pSavHdl->RestoreAttr( pNew->GetTable() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pTbl = &pNew->GetTable();
//STRIP001 	pTbl->GetFrmFmt()->SetName( aName );
//STRIP001 
//STRIP001 //	pSavTbl->CreateNew( *pTbl, FALSE );
//STRIP001 	pSavTbl->RestoreAttr( *pTbl );
//STRIP001 
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		pHistory->TmpRollback( pDoc, 0 );
//STRIP001 		pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// fuer die neue Tabelle die Frames anlegen
//STRIP001 	SwNodeIndex aTmpIdx( *pNew );
//STRIP001 	pNew->MakeFrms( &aTmpIdx );
//STRIP001 
//STRIP001 	// Cursor  irgendwo in den Content stellen
//STRIP001 	SwCntntNode* pCNd = pDoc->GetNodes().GoNext( &rIdx );
//STRIP001 	pPam->GetPoint()->nContent.Assign( pCNd, 0 );
//STRIP001 
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }

//STRIP001 void SwUndoMergeTbl::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	pPam->DeleteMark();
//STRIP001 	pPam->GetPoint()->nNode = nTblNode;
//STRIP001 	if( bWithPrev )
//STRIP001 		pPam->GetPoint()->nNode = nTblNode + 3;
//STRIP001 	else
//STRIP001 		pPam->GetPoint()->nNode = nTblNode;
//STRIP001 
//STRIP001 	pDoc->MergeTable( *pPam->GetPoint(), bWithPrev, nMode );
//STRIP001 
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }

//STRIP001 void SwUndoMergeTbl::Repeat( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	pDoc->MergeTable( *pPam->GetPoint(), bWithPrev, nMode );
//STRIP001 	ClearFEShellTabCols();
//STRIP001 }

//STRIP001 void SwUndoMergeTbl::SaveFormula( SwHistory& rHistory )
//STRIP001 {
//STRIP001 	if( !pHistory )
//STRIP001 		pHistory = new SwHistory;
//STRIP001 	pHistory->Move( 0, &rHistory );
//STRIP001 }

/*  */


/*N*/ void InsertSort( SvUShorts& rArr, USHORT nIdx, USHORT* pInsPos )
/*N*/ {
/*N*/ 	register USHORT nO	= rArr.Count(), nM, nU = 0;
/*N*/ 	if( nO > 0 )
/*N*/ 	{
/*N*/ 		nO--;
/*N*/ 		while( nU <= nO )
/*N*/ 		{
/*N*/ 			nM = nU + ( nO - nU ) / 2;
/*N*/ 			if( *(rArr.GetData() + nM) == nIdx )
/*N*/ 			{
/*N*/ 				ASSERT( FALSE, "Index ist schon vorhanden, darf nie sein!" );
/*N*/ 				return;
/*N*/ 			}
/*N*/ 			if( *(rArr.GetData() + nM) < nIdx )
/*N*/ 				nU = nM + 1;
/*N*/ 			else if( nM == 0 )
/*N*/ 				break;
/*N*/ 			else
/*N*/ 				nO = nM - 1;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	rArr.Insert( nIdx, nU );
/*N*/ 	if( pInsPos )
/*N*/ 		*pInsPos = nU;
/*N*/ }

//STRIP001 void InsertSort( SvULongs& rArr, ULONG nIdx, USHORT* pInsPos )
//STRIP001 {
//STRIP001 	register USHORT nO	= rArr.Count(), nM, nU = 0;
//STRIP001 	if( nO > 0 )
//STRIP001 	{
//STRIP001 		nO--;
//STRIP001 		while( nU <= nO )
//STRIP001 		{
//STRIP001 			nM = nU + ( nO - nU ) / 2;
//STRIP001 			if( *(rArr.GetData() + nM) == nIdx )
//STRIP001 			{
//STRIP001 				ASSERT( FALSE, "Index ist schon vorhanden, darf nie sein!" );
//STRIP001 				return;
//STRIP001 			}
//STRIP001 			if( *(rArr.GetData() + nM) < nIdx )
//STRIP001 				nU = nM + 1;
//STRIP001 			else if( nM == 0 )
//STRIP001 				break;
//STRIP001 			else
//STRIP001 				nO = nM - 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	rArr.Insert( nIdx, nU );
//STRIP001 	if( pInsPos )
//STRIP001 		*pInsPos = nU;
//STRIP001 }

#if defined( JP_DEBUG ) && !defined( PRODUCT )
//STRIP001 
//STRIP001 
//STRIP001 void DumpDoc( SwDoc* pDoc, const String& rFileNm )
//STRIP001 {
//STRIP001 	Writer* pWrt = SwIoSystem::GetWriter( "DEBUG" );
//STRIP001 	if( pWrt )
//STRIP001 	{
//STRIP001 		SvFileStream aStream( rFileNm, STREAM_STD_WRITE );
//STRIP001 		SwPaM* pPam = new SwPaM( pDoc, SwPosition( pDoc->GetNodes().EndOfContent ,
//STRIP001 												 pDoc->GetNodes().EndOfContent ));
//STRIP001 		pPam->Move( fnMoveBackward, fnGoDoc );
//STRIP001 		pPam->SetMark();
//STRIP001 		pPam->Move( fnMoveForward, fnGoDoc );
//STRIP001 
//STRIP001 		pWrt->Write( pPam, *pDoc, aStream, rFileNm.GetStr() );
//STRIP001 
//STRIP001 		delete pPam;
//STRIP001 	}
//STRIP001 }
//STRIP001 void CheckTable( const SwTable& rTbl )
//STRIP001 {
//STRIP001 	const SwNodes& rNds = rTbl.GetFrmFmt()->GetDoc()->GetNodes();
//STRIP001 	const SwTableSortBoxes& rSrtArr = pTblNd->GetTable().GetTabSortBoxes();
//STRIP001 	for( USHORT n = 0; n < rSrtArr.Count(); ++n )
//STRIP001 	{
//STRIP001 		const SwTableBox* pBox = rSrtArr[ n ];
//STRIP001 		const SwNode* pNd = pBox->GetSttNd();
//STRIP001 		ASSERT( rNds[ *pBox->GetSttIdx() ] == pNd, "Box mit falchem StartNode"  );
//STRIP001 	}
//STRIP001 }
#endif


}
