/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_rolbck.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:43:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _HINTIDS_HXX //autogen
// auto strip #include <hintids.hxx>
// auto strip #endif

#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif

#ifndef _FMTFTN_HXX //autogen
#include <fmtftn.hxx>
#endif
#ifndef _FCHRFMT_HXX //autogen
#include <fchrfmt.hxx>
#endif
// auto strip #ifndef _FMTFLCNT_HXX //autogen
// auto strip #include <fmtflcnt.hxx>
// auto strip #endif
// auto strip #ifndef _FMTRFMRK_HXX //autogen
// auto strip #include <fmtrfmrk.hxx>
// auto strip #endif
#ifndef _FMTFLD_HXX //autogen
#include <fmtfld.hxx>
#endif
// auto strip #ifndef _FMTPDSC_HXX //autogen
// auto strip #include <fmtpdsc.hxx>
// auto strip #endif
#ifndef _TXTFLD_HXX //autogen
#include <txtfld.hxx>
#endif
// auto strip #ifndef _TXTRFMRK_HXX //autogen
// auto strip #include <txtrfmrk.hxx>
// auto strip #endif
// auto strip #ifndef _TXTTXMRK_HXX //autogen
// auto strip #include <txttxmrk.hxx>
// auto strip #endif
#ifndef _TXTFTN_HXX //autogen
#include <txtftn.hxx>
#endif
// auto strip #ifndef _TXTFLCNT_HXX //autogen
// auto strip #include <txtflcnt.hxx>
// auto strip #endif
#ifndef _FMTPDSC_HXX //autogen
#include <fmtpdsc.hxx>
#endif
// auto strip #ifndef _FMTANCHR_HXX //autogen
// auto strip #include <fmtanchr.hxx>
// auto strip #endif
// auto strip #ifndef _FMTCNCT_HXX //autogen
// auto strip #include <fmtcnct.hxx>
// auto strip #endif
#ifndef _FRMFMT_HXX //autogen
#include <frmfmt.hxx>
#endif
#ifndef _FTNIDX_HXX
#include <ftnidx.hxx>
#endif
#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>              // SwDoc.GetNodes()
#endif
// auto strip #ifndef _DOCARY_HXX
// auto strip #include <docary.hxx>
// auto strip #endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>			// SwTxtNode
#endif
#ifndef _PARATR_HXX
#include <paratr.hxx>			//
#endif
// auto strip #ifndef _CELLATR_HXX
// auto strip #include <cellatr.hxx>			//
// auto strip #endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>			// fuer Felder
#endif
#ifndef _PAM_HXX
#include <pam.hxx>				// fuer SwPaM
#endif
#ifndef _HINTS_HXX
#include <hints.hxx> 			// fuer SwHytrSetAttrSet
#endif
// auto strip #ifndef _SWTABLE_HXX
// auto strip #include <swtable.hxx>
// auto strip #endif
#ifndef _ROLBCK_HXX
#include <rolbck.hxx>
#endif
// auto strip #ifndef _NDGRF_HXX
// auto strip #include <ndgrf.hxx>			// SwGrfNode
// auto strip #endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>			// fuer UndoDelete
#endif
#ifndef _BOOKMRK_HXX
#include <bookmrk.hxx> 			// fuer SwBookmark
#endif
// auto strip #ifndef _NDINDEX_HXX
// auto strip #include <ndindex.hxx> 			// fuer SwNodeIndex
// auto strip #endif
namespace binfilter {




/*N*/ SV_IMPL_PTRARR( SwpHstry, SwHstryHintPtr)


/*N*/ SwSetFmtHint::SwSetFmtHint( const SfxPoolItem* pFmtHt, ULONG nNd )
/*N*/ 	:  SwHstryHint( HSTRY_SETFMTHNT ),
/*N*/ 	pAttr( pFmtHt->Clone() ), nNode( nNd ), nNumLvl( NO_NUMBERING ),
/*N*/ 	nSetStt( USHRT_MAX )
/*N*/ {
/*N*/ 	switch( pAttr->Which() )
/*N*/ 	{
/*N*/ 	case RES_PAGEDESC:
/*N*/ 		((SwFmtPageDesc*)pAttr)->ChgDefinedIn( 0 );
/*N*/ 		break;
/*N*/ 	case RES_PARATR_DROP:
/*N*/ 		((SwFmtDrop*)pAttr)->ChgDefinedIn( 0 );
/*N*/ 		break;
/*?*/ 	case RES_BOXATR_FORMULA:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //JP 30.07.98: Bug 54295 - Formeln immer im Klartext speichern
//STRIP001 /*?*/ 			SwTblBoxFormula& rNew = *(SwTblBoxFormula*)pAttr;
//STRIP001 /*?*/ 			if( rNew.IsIntrnlName() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const SwTblBoxFormula& rOld = *(SwTblBoxFormula*)pFmtHt;
//STRIP001 /*?*/ 				const SwNode* pNd = rOld.GetNodeOfFormula();
//STRIP001 /*?*/ 				if( pNd && 0 != (pNd = pNd->FindTableNode() ))
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SwTableFmlUpdate aMsgHnt( &((SwTableNode*)pNd)->GetTable() );
//STRIP001 /*?*/ 					aMsgHnt.eFlags = TBL_BOXNAME;
//STRIP001 /*?*/ 					rNew.ChgDefinedIn( rOld.GetDefinedIn() );
//STRIP001 /*?*/ 					rNew.ChangeState( &aMsgHnt );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rNew.ChgDefinedIn( 0 );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 	case RES_PARATR_NUMRULE:
/*?*/ 		{
/*?*/ 			const SwModify* pMod = ((SwNumRuleItem*)pFmtHt)->GetDefinedIn();
/*?*/ 			const SwNodeNum* pNdNum;
/*?*/ 			if( pMod && pMod->ISA( SwTxtNode ) &&
/*?*/ 				0 != (pNdNum = ((SwTxtNode*)pMod)->GetNum() ) )
/*?*/ 			{
/*?*/ 				nNumLvl = pNdNum->GetLevel();
/*?*/ 				bNumStt = pNdNum->IsStart();
/*?*/ 				nSetStt = pNdNum->GetSetValue();
/*?*/ 			}
/*?*/ 			((SwNumRuleItem*)pAttr)->ChgDefinedIn( 0 );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 	}
/*N*/ }


//STRIP001 void SwSetFmtHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	SwNode * pNode = pDoc->GetNodes()[ nNode ];
//STRIP001 	if( pNode->IsCntntNode() )
//STRIP001 	{
//STRIP001 		((SwCntntNode*)pNode)->SetAttr( *pAttr );
//STRIP001 
//STRIP001 		if( RES_PARATR_NUMRULE == pAttr->Which() && NO_NUMBERING != nNumLvl &&
//STRIP001 			((SwTxtNode*)pNode)->GetNum() )
//STRIP001 		{
//STRIP001 			SwNodeNum aNum( *((SwTxtNode*)pNode)->GetNum() );
//STRIP001 			aNum.SetLevel( nNumLvl );
//STRIP001 			aNum.SetStart( bNumStt );
//STRIP001 			aNum.SetSetValue( nSetStt );
//STRIP001 			((SwTxtNode*)pNode)->UpdateNum( aNum );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( pNode->IsTableNode() )
//STRIP001 		((SwTableNode*)pNode)->GetTable().GetFrmFmt()->SetAttr( *pAttr );
//STRIP001 	else if( pNode->IsStartNode() &&
//STRIP001 			SwTableBoxStartNode == ((SwStartNode*)pNode)->GetStartNodeType() )
//STRIP001 	{
//STRIP001 		SwTableNode* pTNd = pNode->FindTableNode();
//STRIP001 		SwTableBox* pBox;
//STRIP001 		if( pTNd && 0 != ( pBox = pTNd->GetTable().GetTblBox( nNode )))
//STRIP001 			pBox->ClaimFrmFmt()->SetAttr( *pAttr );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !bTmpSet )
//STRIP001 		DELETEZ( pAttr );
//STRIP001 }


/*N*/ SwSetFmtHint::~SwSetFmtHint()
/*N*/ {
/*N*/ 	delete pAttr;
/*N*/ }


/*N*/ SwResetFmtHint::SwResetFmtHint( const SfxPoolItem* pFmtHt, ULONG nNd )
/*N*/ 	: SwHstryHint( HSTRY_RESETFMTHNT ),
/*N*/ 	nWhich( pFmtHt->Which() ), nNode( nNd )
/*N*/ {
/*N*/ }


//STRIP001 void SwResetFmtHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	SwNode * pNode = pDoc->GetNodes()[ nNode ];
//STRIP001 	if( pNode->IsCntntNode() )
//STRIP001 		((SwCntntNode*)pNode)->ResetAttr( nWhich );
//STRIP001 	else if( pNode->IsTableNode() )
//STRIP001 		((SwTableNode*)pNode)->GetTable().GetFrmFmt()->ResetAttr( nWhich );
//STRIP001 }


/*N*/ SwSetTxtHint::SwSetTxtHint( SwTxtAttr* pTxtHt, ULONG nNodePos )
/*N*/ 	: SwHstryHint( HSTRY_SETTXTHNT )
/*N*/ {
/*N*/ 	// !! Achtung: folgende Attribute erzeugen keine FormatAttribute:
/*N*/ 	//  - NoLineBreak, NoHypen, Inserted, Deleted
/*N*/ 	// Dafuer muessen Sonderbehandlungen gemacht werden !!!
/*N*/ 
/*N*/ 	// ein bisschen kompliziert, aber ist Ok so: erst vom default
/*N*/ 	// eine Kopie und dann die Werte aus dem Text Attribut zuweisen
/*N*/ 	USHORT nWhich = pTxtHt->Which();
/*N*/ 	if( RES_TXTATR_CHARFMT == nWhich )
/*N*/ 		pAttr = new SwFmtCharFmt( pTxtHt->GetCharFmt().GetCharFmt() );
/*N*/ 	else
/*N*/ 		pAttr = pTxtHt->GetAttr().Clone();
/*N*/ 	nNode = nNodePos;
/*N*/ 	nStart = *pTxtHt->GetStart();
/*N*/ 	nEnd = *pTxtHt->GetAnyEnd();
/*N*/ }


/*N*/ SwSetTxtHint::~SwSetTxtHint()
/*N*/ {
/*N*/ 	delete pAttr;
/*N*/ }


//STRIP001 void SwSetTxtHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	if( !pAttr )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if( RES_TXTATR_CHARFMT == pAttr->Which() )
//STRIP001 	{
//STRIP001 		// befrage das Doc, ob das CharFmt noch vorhanden ist !
//STRIP001 		if( USHRT_MAX == pDoc->GetCharFmts()->GetPos(
//STRIP001 							((SwFmtCharFmt*)pAttr)->GetCharFmt() ) )
//STRIP001 			return;		// nicht setzen, Format nicht vorhanden
//STRIP001 	}
//STRIP001 
//STRIP001 	SwTxtNode * pTxtNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
//STRIP001 	ASSERT( pTxtNd, "Undo-TxtAttr: kein TextNode" );
//STRIP001 
//STRIP001 	pTxtNd->Insert( *pAttr, nStart, nEnd,
//STRIP001 					SETATTR_NOTXTATRCHR | SETATTR_NOHINTADJUST );
//STRIP001 }


/*N*/ SwSetTxtFldHint::SwSetTxtFldHint( SwTxtFld* pTxtFld, ULONG nNodePos )
/*N*/ 	: SwHstryHint( HSTRY_SETTXTFLDHNT ), pFldType( 0 )
/*N*/ {
/*N*/ 	pFld = new SwFmtFld( *pTxtFld->GetFld().GetFld() );
/*N*/ 
/*N*/ 	// nur kopieren wenn kein Sys-FieldType
/*N*/ 	SwDoc* pDoc = (SwDoc*)pTxtFld->GetTxtNode().GetDoc();
/*N*/ 
/*N*/ 	nFldWhich = pFld->GetFld()->GetTyp()->Which();
/*N*/ 	if( nFldWhich == RES_DBFLD ||
/*N*/ 		nFldWhich == RES_USERFLD ||
/*N*/ 		nFldWhich == RES_SETEXPFLD ||
/*N*/ 		nFldWhich == RES_DDEFLD ||
/*N*/ 		!pDoc->GetSysFldType( nFldWhich ))
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFldType = pFld->GetFld()->GetTyp()->Copy();
//STRIP001 /*?*/ 		pFld->GetFld()->ChgTyp( pFldType );		// Fieldtype umsetzen
/*N*/ 	}
/*N*/ 	nNode = nNodePos;
/*N*/ 	nPos = *pTxtFld->GetStart();
/*N*/ }


/*N*/ SwSetTxtFldHint::~SwSetTxtFldHint()
/*N*/ {
/*N*/ 	delete pFld;
/*N*/ 	delete pFldType;
/*N*/ }


//STRIP001 void SwSetTxtFldHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	if( !pFld )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SwFieldType* pNewFldType = pFldType;
//STRIP001 	if( !pNewFldType )
//STRIP001 		pNewFldType = pDoc->GetSysFldType( nFldWhich );
//STRIP001 	else
//STRIP001 		// den Type am Dokuement anmelden
//STRIP001 		pNewFldType = pDoc->InsertFldType( *pFldType );
//STRIP001 
//STRIP001 	pFld->GetFld()->ChgTyp( pNewFldType );		// Fieldtype umsetzen
//STRIP001 
//STRIP001 	SwTxtNode * pTxtNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
//STRIP001 	ASSERT( pTxtNd, "Undo-TxtAttr: kein TextNode" );
//STRIP001 
//STRIP001 	pTxtNd->Insert( *pFld, nPos, nPos, SETATTR_NOTXTATRCHR );
//STRIP001 }



//STRIP001 SwSetRefMarkHint::SwSetRefMarkHint( SwTxtRefMark* pTxtHt, ULONG nNodePos )
//STRIP001 	: SwHstryHint( HSTRY_SETREFMARKHNT )
//STRIP001 {
//STRIP001 	aRefName = pTxtHt->GetRefMark().GetRefName();
//STRIP001 	nNode = nNodePos;
//STRIP001 	nStart = *pTxtHt->GetStart();
//STRIP001 	nEnd = *pTxtHt->GetAnyEnd();
//STRIP001 }


//STRIP001 void SwSetRefMarkHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	SwTxtNode * pTxtNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
//STRIP001 	ASSERT( pTxtNd, "Undo-TxtAttr: kein TextNode" );
//STRIP001 
//STRIP001 	SwFmtRefMark aRefMark( aRefName );
//STRIP001 
//STRIP001 	// existiert hier schon eine Referenz-Markierung ohne Ende, so
//STRIP001 	// darf es nicht eingefuegt werden !!
//STRIP001 	if( nStart != nEnd || !pTxtNd->GetTxtAttr( nStart, RES_TXTATR_REFMARK ) )
//STRIP001 		pTxtNd->Insert( aRefMark, nStart, nEnd, SETATTR_NOTXTATRCHR );
//STRIP001 }


//STRIP001 SwSetTOXMarkHint::SwSetTOXMarkHint( SwTxtTOXMark* pTxtHt, ULONG nNodePos )
//STRIP001 	: SwHstryHint( HSTRY_SETTOXMARKHNT ), aTOXMark( pTxtHt->GetTOXMark() )
//STRIP001 {
//STRIP001 	aTOXName = aTOXMark.GetTOXType()->GetTypeName();
//STRIP001 	eTOXTypes = aTOXMark.GetTOXType()->GetType();
//STRIP001 	((SwModify*)aTOXMark.GetRegisteredIn())->Remove( &aTOXMark );
//STRIP001 
//STRIP001 	nNode = nNodePos;
//STRIP001 	nStart = *pTxtHt->GetStart();
//STRIP001 	nEnd = *pTxtHt->GetAnyEnd();
//STRIP001 }


//STRIP001 void SwSetTOXMarkHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	SwTxtNode * pTxtNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
//STRIP001 	ASSERT( pTxtNd, "Undo-TxtAttr: kein TextNode" );
//STRIP001 
//STRIP001 	// suche den entsprechenden Verzeichnistyp
//STRIP001 	USHORT nCnt = pDoc->GetTOXTypeCount( eTOXTypes );
//STRIP001 	const SwTOXType* pToxType = 0;
//STRIP001 	for( USHORT n = 0; n < nCnt; ++n )
//STRIP001 	{
//STRIP001 		pToxType = pDoc->GetTOXType( eTOXTypes, n );
//STRIP001 		if( pToxType->GetTypeName() == aTOXName )
//STRIP001 			break;
//STRIP001 		pToxType = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pToxType )		// Verzeichnistyp nicht gefunden, neu anlegen
//STRIP001 		pToxType = pDoc->InsertTOXType( SwTOXType( eTOXTypes, aTOXName ));
//STRIP001 
//STRIP001 	SwTOXMark aNew( aTOXMark );
//STRIP001 	((SwTOXType*)pToxType)->Add( &aNew );
//STRIP001 
//STRIP001 	pTxtNd->Insert( aNew, nStart, nEnd, SETATTR_NOTXTATRCHR );
//STRIP001 }


//STRIP001 int SwSetTOXMarkHint::IsEqual( const SwTOXMark& rCmp ) const
//STRIP001 {
//STRIP001 	return aTOXName == rCmp.GetTOXType()->GetTypeName() &&
//STRIP001 		   eTOXTypes == rCmp.GetTOXType()->GetType() &&
//STRIP001 		   aTOXMark.GetAlternativeText() == rCmp.GetAlternativeText() &&
//STRIP001 		   ( TOX_INDEX == eTOXTypes
//STRIP001 			  ? ( aTOXMark.GetPrimaryKey() == rCmp.GetPrimaryKey() &&
//STRIP001 				 aTOXMark.GetSecondaryKey() == rCmp.GetSecondaryKey() )
//STRIP001 			  : aTOXMark.GetLevel() == rCmp.GetLevel()
//STRIP001 		   );
//STRIP001 }


/*N*/ SwResetTxtHint::SwResetTxtHint( USHORT nWhich, xub_StrLen nAttrStt,
/*N*/ 								xub_StrLen nAttrEnd, ULONG nNodePos )
/*N*/ 	: SwHstryHint( HSTRY_RESETTXTHNT ),
/*N*/ 	nAttr( nWhich ), nNode( nNodePos ), nStart( nAttrStt ), nEnd( nAttrEnd )
/*N*/ {
/*N*/ }


//STRIP001 void SwResetTxtHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	SwTxtNode * pTxtNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
//STRIP001 	ASSERT( pTxtNd, "Undo-TxtAttr: kein TextNode" );
//STRIP001 
//STRIP001 	pTxtNd->Delete( nAttr, nStart, nEnd );
//STRIP001 }


/*N*/ SwSetFtnHint::SwSetFtnHint( SwTxtFtn* pTxtFtn, ULONG nNodePos )
/*N*/ 	: SwHstryHint( HSTRY_SETFTNHNT ),
/*N*/ 	nNode( nNodePos ), nStart( *pTxtFtn->GetStart() )
/*N*/ {
/*N*/ 	ASSERT( pTxtFtn->GetStartNode(), "Footnote ohne Section" );
/*N*/ 
/*N*/ 	aFtnStr = pTxtFtn->GetFtn().GetNumStr();
/*N*/ 	bEndNote = pTxtFtn->GetFtn().IsEndNote();
/*N*/ 
/*N*/ 	// merke die alte NodePos, denn wer weiss was alles in der SaveSection
/*N*/ 	// gespeichert (geloescht) wird
/*N*/ 	SwDoc* pDoc = (SwDoc*)pTxtFtn->GetTxtNode().GetDoc();
/*N*/ 	SwNode* pSaveNd = pDoc->GetNodes()[ nNode ];
/*N*/ 
/*N*/ 	//Pointer auf StartNode der FtnSection merken und erstmal den Pointer im
/*N*/ 	//Attribut zuruecksetzen -> Damit werden automatisch die Frms vernichtet.
/*N*/ 	SwNodeIndex aSttIdx( *pTxtFtn->GetStartNode() );
/*N*/ 	pTxtFtn->SetStartNode( 0, FALSE );
/*N*/ 
/*N*/ 	pUndo = new SwUndoSaveSection;
/*N*/ 	pUndo->SaveSection( pDoc, aSttIdx );
/*N*/ 	nNode = pSaveNd->GetIndex();
/*N*/ }

/*N*/ SwSetFtnHint::SwSetFtnHint( const SwTxtFtn &rTxtFtn ) :
/*N*/ 	SwHstryHint( HSTRY_SETFTNHNT ),
/*N*/ 	nNode( _SwTxtFtn_GetIndex( (&rTxtFtn) ) ),
/*N*/ 	nStart( *rTxtFtn.GetStart() ),
/*N*/ 	pUndo( 0 )
/*N*/ {
/*N*/ 	ASSERT( rTxtFtn.GetStartNode(), "Footnote ohne Section" );
/*N*/ 
/*N*/ 	aFtnStr = rTxtFtn.GetFtn().GetNumStr();
/*N*/ 	bEndNote = rTxtFtn.GetFtn().IsEndNote();
/*N*/ }


/*N*/ SwSetFtnHint::~SwSetFtnHint()
/*N*/ {
/*N*/ 	delete pUndo;
/*N*/ }


//STRIP001 void SwSetFtnHint::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	SwTxtNode * pTxtNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
//STRIP001 	ASSERT( pTxtNd, "Undo-TxtAttr: kein TextNode" );
//STRIP001 
//STRIP001 	if ( pUndo )
//STRIP001 	{
//STRIP001 		// setze die Fussnote im TextNode
//STRIP001 		SwFmtFtn& rNew = (SwFmtFtn&)pDoc->GetAttrPool().Put( SwFmtFtn( bEndNote ) );
//STRIP001 		if( aFtnStr.Len() )
//STRIP001 			rNew.SetNumStr( aFtnStr );
//STRIP001 		SwTxtFtn* pTxtFtn = new SwTxtFtn( rNew, nStart );
//STRIP001 
//STRIP001 		// erzeuge schon die Section der Fussnote
//STRIP001 		SwNodeIndex aIdx( *pTxtNd );
//STRIP001 		pUndo->RestoreSection( pDoc, &aIdx, SwFootnoteStartNode );
//STRIP001 		pTxtFtn->SetStartNode( &aIdx );
//STRIP001 		if( pUndo->GetHistory() )
//STRIP001 			// erst jetzt die Frames anlegen lassen
//STRIP001 			pUndo->GetHistory()->Rollback( pDoc );
//STRIP001 
//STRIP001 		pTxtNd->Insert( pTxtFtn );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SwTxtFtn *pFtn = (SwTxtFtn*)pTxtNd->GetTxtAttr( nStart );
//STRIP001 		SwFmtFtn &rFtn = (SwFmtFtn&)pFtn->GetFtn();
//STRIP001 		rFtn.SetNumStr( aFtnStr  );
//STRIP001 		if( rFtn.IsEndNote() != bEndNote )
//STRIP001 		{
//STRIP001 			rFtn.SetEndNote( bEndNote );
//STRIP001 			pFtn->CheckCondColl();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*N*/ SwChgFmtColl::SwChgFmtColl( const SwFmtColl* pFmtColl, ULONG nNd,
/*N*/ 							BYTE nNodeWhich )
/*N*/ 	: SwHstryHint( HSTRY_CHGFMTCOLL ),
/*N*/ 	pColl( pFmtColl ), nNode( nNd ), nNdWhich( nNodeWhich ),
/*N*/ 	nNumLvl( NO_NUMBERING ), nSetStt( USHRT_MAX )
/*N*/ {
/*N*/ 	const SwDoc* pDoc = pFmtColl->GetDoc();
/*N*/ 	const SwTxtNode* pTxtNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
/*N*/ 	if( pTxtNd && pTxtNd->GetNum() )
/*N*/ 	{
/*?*/ 		nNumLvl = pTxtNd->GetNum()->GetLevel();
/*?*/ 		bNumStt = pTxtNd->GetNum()->IsStart();
/*?*/ 		nSetStt = pTxtNd->GetNum()->GetSetValue();
/*N*/ 	}
/*N*/ }


//STRIP001 void SwChgFmtColl::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	SwCntntNode * pCntntNd = pDoc->GetNodes()[ nNode ]->GetCntntNode();
//STRIP001 	ASSERT( pCntntNd, "Undo-ChgFmt: kein ContentNode" );
//STRIP001 
//STRIP001 	// prufe vor dem setzen des Formates, ob dieses ueberhaupt noch im
//STRIP001 	// Dokument vorhanden ist. Wurde es schon geloescht, gibt es kein Undo !!
//STRIP001 	if( nNdWhich == pCntntNd->GetNodeType() )
//STRIP001 	{
//STRIP001 		if( ND_TEXTNODE == nNdWhich )
//STRIP001 		{
//STRIP001 			if( USHRT_MAX != pDoc->GetTxtFmtColls()->GetPos( (SwTxtFmtColl*)pColl ))
//STRIP001 			{
//STRIP001 				pCntntNd->ChgFmtColl( (SwFmtColl*)pColl );
//STRIP001 				if( NO_NUMBERING != nNumLvl && ((SwTxtNode*)pCntntNd)->GetNum() )
//STRIP001 				{
//STRIP001 					SwNodeNum aNum( *((SwTxtNode*)pCntntNd)->GetNum() );
//STRIP001 					aNum.SetLevel( nNumLvl );
//STRIP001 					aNum.SetStart( bNumStt );
//STRIP001 					aNum.SetSetValue( nSetStt );
//STRIP001 					((SwTxtNode*)pCntntNd)->UpdateNum( aNum );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( USHRT_MAX != pDoc->GetGrfFmtColls()->GetPos( (SwGrfFmtColl*)pColl ))
//STRIP001 			pCntntNd->ChgFmtColl( (SwFmtColl*)pColl );
//STRIP001 	}
//STRIP001 }


/*N*/SwHstryTxtFlyCnt::SwHstryTxtFlyCnt( SwTxtFlyCnt* pTxtFly )
/*N*/	: SwHstryHint( HSTRY_FLYCNT )
/*N*/{
/*N*/DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	ASSERT( pTxtFly->GetFlyCnt().GetFrmFmt(), "FlyCntnt ohne Format" );
//STRIP001 /*?*/	pUndo = new SwUndoDelLayFmt( pTxtFly->GetFlyCnt().GetFrmFmt() );
//STRIP001 /*?*/	pUndo->ChgShowSel( FALSE );
/*N*/}


/*N*/SwHstryTxtFlyCnt::SwHstryTxtFlyCnt( SwFlyFrmFmt* pFlyFmt )
/*N*/	: SwHstryHint( HSTRY_FLYCNT )
/*N*/{
/*?*/DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	ASSERT( pFlyFmt, "kein Format" );
//STRIP001 /*?*/	pUndo = new SwUndoDelLayFmt( pFlyFmt );
//STRIP001 /*?*/	pUndo->ChgShowSel( FALSE );
/*N*/}


/*N*/SwHstryTxtFlyCnt::~SwHstryTxtFlyCnt()
/*N*/{
/*N*/	delete pUndo;
/*N*/}


/*N*/ void SwHstryTxtFlyCnt::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SwPaM aPam( pDoc->GetNodes().GetEndOfPostIts() );
//STRIP001 	SwUndoIter aUndoIter( &aPam );
//STRIP001 	pUndo->Undo( aUndoIter );
/*N*/ }



// JP 21.03.94: jetzt auch die Bookmarks in die History aufnehmen
/*N*/ SwHstryBookmark::SwHstryBookmark( const SwBookmark& rBkmk, BYTE nType )
/*N*/ 	: SwHstryHint( HSTRY_BOOKMARK ),
/*N*/ 	nTyp( nType ), nNode1( 0 ), nCntnt1( 0 ),
/*N*/ 	nNode2( rBkmk.GetOtherPos() ? 0 : ULONG_MAX ), nCntnt2( 0 )
/*N*/ {
/*N*/ 	aName = rBkmk.GetName();
/*N*/ 	aShortName = rBkmk.GetShortName();
/*N*/ 	nKeyCode = rBkmk.GetKeyCode().GetCode() | rBkmk.GetKeyCode().GetModifier();
/*N*/ 
/*N*/ 	if( BKMK_POS & nTyp )
/*N*/ 	{
/*N*/ 		nNode1 = rBkmk.GetPos().nNode.GetIndex();
/*N*/ 		nCntnt1 = rBkmk.GetPos().nContent.GetIndex();
/*N*/ 	}
/*N*/ 	if( BKMK_OTHERPOS & nTyp )
/*N*/ 	{
/*?*/ 		nNode2 = rBkmk.GetOtherPos()->nNode.GetIndex();
/*?*/ 		nCntnt2 = rBkmk.GetOtherPos()->nContent.GetIndex();
/*N*/ 	}
/*N*/ }


//STRIP001 void SwHstryBookmark::SetInDoc( SwDoc* pDoc, BOOL )
//STRIP001 {
//STRIP001 	BOOL bDoesUndo = pDoc->DoesUndo();
//STRIP001 	pDoc->DoUndo( FALSE );
//STRIP001 
//STRIP001 	SwNodes& rNds = pDoc->GetNodes();
//STRIP001 
//STRIP001 	if( ( BKMK_POS == nTyp && ULONG_MAX == nNode2 ) ||
//STRIP001 		( BKMK_POS | BKMK_OTHERPOS ) == nTyp )
//STRIP001 	{
//STRIP001 		// voellig neu setzen
//STRIP001 		SwCntntNode * pCntntNd = rNds[ nNode1 ]->GetCntntNode();
//STRIP001 		ASSERT( pCntntNd, "Falscher Node fuer den Bookmark" );
//STRIP001 
//STRIP001 		SwPaM aPam( *pCntntNd, nCntnt1 );
//STRIP001 		if( ULONG_MAX != nNode2 )
//STRIP001 		{
//STRIP001 			aPam.SetMark();
//STRIP001 			aPam.GetMark()->nNode = nNode2;
//STRIP001 			pCntntNd = rNds[ aPam.GetMark()->nNode ]->GetCntntNode();
//STRIP001 			ASSERT( pCntntNd, "Falscher Node fuer den Bookmark" );
//STRIP001 			aPam.GetMark()->nContent.Assign( pCntntNd, nCntnt2 );
//STRIP001 		}
//STRIP001 		pDoc->MakeBookmark( aPam, KeyCode( nKeyCode ), aName, aShortName );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// dann muss das noch vorhandene manipuliert werden
//STRIP001 		SwBookmark* const* ppBkmks = pDoc->GetBookmarks().GetData();
//STRIP001 		for( USHORT n = pDoc->GetBookmarks().Count(); n; --n, ++ppBkmks )
//STRIP001 			if( (*ppBkmks)->GetName() == aName )
//STRIP001 			{
//STRIP001 				ULONG nNd;
//STRIP001 				USHORT nCnt;
//STRIP001 				SwPosition* pPos;
//STRIP001 				if( BKMK_POS == nTyp )
//STRIP001 				{
//STRIP001 					if( !nNode2 && !(*ppBkmks)->GetOtherPos() )
//STRIP001 					{
//STRIP001 						// dann muss der neu angelegt werden.
//STRIP001 						SwPaM aPam( (*ppBkmks)->GetPos() );
//STRIP001 						aPam.SetMark();
//STRIP001 						aPam.GetPoint()->nNode = nNode1;
//STRIP001 						aPam.GetPoint()->nContent.Assign(
//STRIP001 								rNds[ nNode1 ]->GetCntntNode(), nCntnt1 );
//STRIP001 
//STRIP001 						pDoc->DelBookmark( pDoc->GetBookmarks().Count() - n );
//STRIP001 						pDoc->MakeBookmark( aPam, KeyCode( nKeyCode ), aName, aShortName, BOOKMARK );
//STRIP001 						break;
//STRIP001 
//STRIP001 					}
//STRIP001 					nNd = nNode1;
//STRIP001 					nCnt = nCntnt1;
//STRIP001 					pPos = (SwPosition*)&(*ppBkmks)->GetPos();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if( !(*ppBkmks)->GetOtherPos() )
//STRIP001 					{
//STRIP001 						// dann muss der neu angelegt werden.
//STRIP001 						SwPaM aPam( (*ppBkmks)->GetPos() );
//STRIP001 						aPam.SetMark();
//STRIP001 						aPam.GetMark()->nNode = nNode2;
//STRIP001 						aPam.GetMark()->nContent.Assign(
//STRIP001 								rNds[ nNode2 ]->GetCntntNode(), nCntnt2 );
//STRIP001 
//STRIP001 						pDoc->DelBookmark( pDoc->GetBookmarks().Count() - n );
//STRIP001 						pDoc->MakeBookmark( aPam, KeyCode( nKeyCode ), aName, aShortName, BOOKMARK );
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					nNd = nNode2;
//STRIP001 					nCnt = nCntnt2;
//STRIP001 					pPos = (SwPosition*)(*ppBkmks)->GetOtherPos();
//STRIP001 				}
//STRIP001 
//STRIP001 				pPos->nNode = nNd;
//STRIP001 				pPos->nContent.Assign( rNds[ pPos->nNode ]->GetCntntNode(),
//STRIP001 										nCnt );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 	}
//STRIP001 
//STRIP001 	pDoc->DoUndo( bDoesUndo );
//STRIP001 }


//STRIP001 BOOL SwHstryBookmark::IsEqualBookmark( const SwBookmark& rBkmk )
//STRIP001 {
//STRIP001 	return nNode1 == rBkmk.GetPos().nNode.GetIndex() &&
//STRIP001 		   nCntnt1 == rBkmk.GetPos().nContent.GetIndex() &&
//STRIP001 			aName == rBkmk.GetName() &&
//STRIP001 			aShortName == rBkmk.GetShortName() &&
//STRIP001 			nKeyCode == (rBkmk.GetKeyCode().GetCode() |
//STRIP001 						rBkmk.GetKeyCode().GetModifier())
//STRIP001 			? TRUE : FALSE;
//STRIP001 }

/*************************************************************************/


/*N*/ SwHstrySetAttrSet::SwHstrySetAttrSet( const SfxItemSet& rSet, ULONG nNodePos,
/*N*/ 										const SvUShortsSort& rSetArr )
/*N*/ 	: SwHstryHint( HSTRY_SETATTRSET ),
/*N*/ 	nNode( nNodePos ), aOldSet( rSet ), nNumLvl( NO_NUMBERING ),
/*N*/ 	nSetStt( USHRT_MAX ), aResetArr( 0, 4 )
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	SfxItemIter aIter( aOldSet ), aOrigIter( rSet );
//STRIP001 	const SfxPoolItem* pItem = aIter.FirstItem(),
//STRIP001 					 * pOrigItem = aOrigIter.FirstItem();
//STRIP001 	do {
//STRIP001 		if( !rSetArr.Seek_Entry( pOrigItem->Which() ))
//STRIP001 		{
//STRIP001 			aResetArr.Insert( pOrigItem->Which(), aResetArr.Count() );
//STRIP001 			aOldSet.ClearItem( pOrigItem->Which() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			switch( pItem->Which() )
//STRIP001 			{
//STRIP001 			case RES_PAGEDESC:
//STRIP001 				((SwFmtPageDesc*)pItem)->ChgDefinedIn( 0 );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case RES_PARATR_DROP:
//STRIP001 				((SwFmtDrop*)pItem)->ChgDefinedIn( 0 );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case RES_BOXATR_FORMULA:
//STRIP001 				{
//STRIP001 					//JP 20.04.98: Bug 49502 - wenn eine Formel gesetzt ist, nie den
//STRIP001 					//				Value mit sichern. Der muss gegebenfalls neu
//STRIP001 					//				errechnet werden!
//STRIP001 					//JP 30.07.98: Bug 54295 - Formeln immer im Klartext speichern
//STRIP001 					aOldSet.ClearItem( RES_BOXATR_VALUE );
//STRIP001 
//STRIP001 					SwTblBoxFormula& rNew = *(SwTblBoxFormula*)pItem;
//STRIP001 					if( rNew.IsIntrnlName() )
//STRIP001 					{
//STRIP001 						const SwTblBoxFormula& rOld = (SwTblBoxFormula&)rSet.Get( RES_BOXATR_FORMULA );
//STRIP001 						const SwNode* pNd = rOld.GetNodeOfFormula();
//STRIP001 						if( pNd && 0 != (pNd = pNd->FindTableNode() ))
//STRIP001 						{
//STRIP001 							SwTableFmlUpdate aMsgHnt( &((SwTableNode*)pNd)->GetTable() );
//STRIP001 							aMsgHnt.eFlags = TBL_BOXNAME;
//STRIP001 							rNew.ChgDefinedIn( rOld.GetDefinedIn() );
//STRIP001 							rNew.ChangeState( &aMsgHnt );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					rNew.ChgDefinedIn( 0 );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case RES_PARATR_NUMRULE:
//STRIP001 				if( ((SwNumRuleItem*)pItem)->GetDefinedIn() &&
//STRIP001 					((SwNumRuleItem*)pItem)->GetDefinedIn()->ISA( SwTxtNode ))
//STRIP001 				{
//STRIP001 					SwTxtNode* pTNd = (SwTxtNode*)((SwNumRuleItem*)pItem)->GetDefinedIn();
//STRIP001 					if( pTNd->GetNum() )
//STRIP001 					{
//STRIP001 						nNumLvl = pTNd->GetNum()->GetLevel();
//STRIP001 						bNumStt = pTNd->GetNum()->IsStart();
//STRIP001 						nSetStt = pTNd->GetNum()->GetSetValue();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				((SwNumRuleItem*)pItem)->ChgDefinedIn( 0 );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aIter.IsAtEnd() )
//STRIP001 			break;
//STRIP001 		pItem = aIter.NextItem();
//STRIP001 		pOrigItem = aOrigIter.NextItem();
//STRIP001 	} while( TRUE );
/*N*/ }

//STRIP001 void SwHstrySetAttrSet::SetInDoc( SwDoc* pDoc, BOOL )
//STRIP001 {
//STRIP001 	BOOL bDoesUndo = pDoc->DoesUndo();
//STRIP001 	pDoc->DoUndo( FALSE );
//STRIP001 
//STRIP001 	SwNode * pNode = pDoc->GetNodes()[ nNode ];
//STRIP001 	if( pNode->IsCntntNode() )
//STRIP001 	{
//STRIP001 		((SwCntntNode*)pNode)->SetAttr( aOldSet );
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		if( ((SwCntntNode*)pNode)->GetpSwAttrSet() && SFX_ITEM_SET ==
//STRIP001 			((SwCntntNode*)pNode)->GetpSwAttrSet()->GetItemState(
//STRIP001 			RES_PARATR_NUMRULE, FALSE, &pItem ) &&
//STRIP001 			NO_NUMBERING != nNumLvl &&
//STRIP001 			((SwTxtNode*)pNode)->GetNum() )
//STRIP001 		{
//STRIP001 			SwNodeNum aNum( *((SwTxtNode*)pNode)->GetNum() );
//STRIP001 			aNum.SetLevel( nNumLvl );
//STRIP001 			aNum.SetStart( bNumStt );
//STRIP001 			aNum.SetSetValue( nSetStt );
//STRIP001 			((SwTxtNode*)pNode)->UpdateNum( aNum );
//STRIP001 		}
//STRIP001 		if( aResetArr.Count() )
//STRIP001 			((SwCntntNode*)pNode)->ResetAttr( aResetArr );
//STRIP001 	}
//STRIP001 	else if( pNode->IsTableNode() )
//STRIP001 	{
//STRIP001 		SwFmt& rFmt = *((SwTableNode*)pNode)->GetTable().GetFrmFmt();
//STRIP001 		rFmt.SetAttr( aOldSet );
//STRIP001 		if( aResetArr.Count() )
//STRIP001 			rFmt.ResetAttr( *aResetArr.GetData() );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDoc->DoUndo( bDoesUndo );
//STRIP001 }

/*************************************************************************/


/*N*/ SwHstryResetAttrSet::SwHstryResetAttrSet( const SfxItemSet& rSet,
/*N*/ 					ULONG nNodePos, xub_StrLen nAttrStt, xub_StrLen nAttrEnd )
/*N*/ 	: SwHstryHint( HSTRY_RESETATTRSET ),
/*N*/ 	nNode( nNodePos ), nStart( nAttrStt ), nEnd( nAttrEnd ),
/*N*/ 	aArr( (BYTE)rSet.Count() )
/*N*/ {
/*N*/ 	SfxItemIter aIter( rSet );
/*N*/ 	while( TRUE )
/*N*/ 	{
/*N*/ 		aArr.Insert( aIter.GetCurItem()->Which() ,aArr.Count() );
/*N*/ 		if( aIter.IsAtEnd() )
/*N*/ 			break;
/*?*/ 		aIter.NextItem();
/*N*/ 	}
/*N*/ }


//STRIP001 void SwHstryResetAttrSet::SetInDoc( SwDoc* pDoc, BOOL )
//STRIP001 {
//STRIP001 	BOOL bDoesUndo = pDoc->DoesUndo();
//STRIP001 	pDoc->DoUndo( FALSE );
//STRIP001 
//STRIP001 	SwCntntNode * pCntntNd = pDoc->GetNodes()[ nNode ]->GetCntntNode();
//STRIP001 	ASSERT( pCntntNd, "wo ist mein CntntNode" );
//STRIP001 
//STRIP001 	const USHORT* pArr = aArr.GetData();
//STRIP001 	if( USHRT_MAX == nEnd && USHRT_MAX == nStart )
//STRIP001 	{
//STRIP001 		// kein Bereich also Schnittstelle zum Content-Node
//STRIP001 		for( USHORT n = aArr.Count(); n; --n, ++pArr )
//STRIP001 			pCntntNd->ResetAttr( *pArr );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Bereich: also Schnittstelle zum Text-Node
//STRIP001 		for( USHORT n = aArr.Count(); n; --n, ++pArr )
//STRIP001 			((SwTxtNode*)pCntntNd)->Delete( *pArr, nStart, nEnd );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDoc->DoUndo( bDoesUndo );
//STRIP001 }


/*************************************************************************/


/*N*/SwHstryChgFlyAnchor::SwHstryChgFlyAnchor( const SwFrmFmt& rFmt )
/*N*/	: SwHstryHint( HSTRY_CHGFLYANCHOR ),
/*N*/	pFmt( (SwFrmFmt*)&rFmt )
/*N*/{
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	const SwFmtAnchor& rAnchor = rFmt.GetAnchor();
//STRIP001 	nOldPos = rAnchor.GetCntntAnchor()->nNode.GetIndex();
//STRIP001 	if( FLY_AUTO_CNTNT == rAnchor.GetAnchorId() )
//STRIP001 		nOldCnt = rAnchor.GetCntntAnchor()->nContent.GetIndex();
//STRIP001 	else
//STRIP001 		nOldCnt = STRING_MAXLEN;
/*N*/ }


//STRIP001 void SwHstryChgFlyAnchor::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	BOOL bDoesUndo = pDoc->DoesUndo();
//STRIP001 	pDoc->DoUndo( FALSE );
//STRIP001 
//STRIP001 	USHORT nPos = pDoc->GetSpzFrmFmts()->GetPos( pFmt );
//STRIP001 	if( USHRT_MAX != nPos )			// Format noch vorhanden
//STRIP001 	{
//STRIP001 		SwFmtAnchor aTmp( pFmt->GetAnchor() );
//STRIP001 
//STRIP001 		SwNode* pNd = pDoc->GetNodes()[ nOldPos  ];
//STRIP001 		SwPosition aPos( *pNd );
//STRIP001 		if( STRING_MAXLEN != nOldCnt )
//STRIP001 			aPos.nContent.Assign( (SwCntntNode*)pNd, nOldCnt );
//STRIP001 		aTmp.SetAnchor( &aPos );
//STRIP001 
//STRIP001 		// damit das Layout nicht durcheinander kommt!
//STRIP001 		SwCntntNode* pCNd = pNd->GetCntntNode();
//STRIP001 		if( !pCNd || !pCNd->GetFrm( 0, 0, FALSE ) )
//STRIP001 			pFmt->DelFrms();
//STRIP001 
//STRIP001 		pFmt->SetAttr( aTmp );
//STRIP001 	}
//STRIP001 	pDoc->DoUndo( bDoesUndo );
//STRIP001 }


/*************************************************************************/

//STRIP001 SwHstryChgFlyChain::SwHstryChgFlyChain( const SwFlyFrmFmt& rFmt,
//STRIP001 										const SwFmtChain& rAttr )
//STRIP001 	: SwHstryHint( HSTRY_CHGFLYCHAIN ),
//STRIP001 	pPrevFmt( rAttr.GetPrev() ),
//STRIP001 	pNextFmt( rAttr.GetNext() ),
//STRIP001 	pFlyFmt( (SwFlyFrmFmt*)&rFmt )
//STRIP001 {
//STRIP001 }


//STRIP001 void SwHstryChgFlyChain::SetInDoc( SwDoc* pDoc, BOOL bTmpSet )
//STRIP001 {
//STRIP001 	if( USHRT_MAX != pDoc->GetSpzFrmFmts()->GetPos( pFlyFmt ) )
//STRIP001 	{
//STRIP001 		SwFmtChain aChain;
//STRIP001 		if( pPrevFmt && USHRT_MAX != pDoc->GetSpzFrmFmts()->GetPos( pPrevFmt ))
//STRIP001 		{
//STRIP001 			aChain.SetPrev( pPrevFmt );
//STRIP001 			SwFmtChain aTmp( pPrevFmt->GetChain() );
//STRIP001 			aTmp.SetNext( pFlyFmt );
//STRIP001 			pPrevFmt->SetAttr( aTmp );
//STRIP001 		}
//STRIP001 		if( pNextFmt && USHRT_MAX != pDoc->GetSpzFrmFmts()->GetPos( pNextFmt ))
//STRIP001 		{
//STRIP001 			aChain.SetNext( pNextFmt );
//STRIP001 			SwFmtChain aTmp( pNextFmt->GetChain() );
//STRIP001 			aTmp.SetPrev( pFlyFmt );
//STRIP001 			pNextFmt->SetAttr( aTmp );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aChain.GetNext() || aChain.GetPrev()  )
//STRIP001 			pFlyFmt->SetAttr( aChain );
//STRIP001 	}
//STRIP001 }



/*  */


/*N*/ SwHistory::SwHistory( USHORT nInitSz, USHORT nGrowSz )
/*N*/ 	: SwpHstry( (BYTE)nInitSz, (BYTE)nGrowSz ), nEndDiff( 0 )
/*N*/ {}


/*N*/ SwHistory::~SwHistory()
/*N*/ {
/*N*/ 	Delete( 0 );
/*N*/ }


/*************************************************************************
|*
|*    void SwHistory::Add()
|*
|*    Beschreibung		Dokument 1.0
|*    Ersterstellung    JP 18.02.91
|*    Letzte Aenderung  JP 18.02.91
|*
*************************************************************************/


/*N*/ void SwHistory::Add( const SfxPoolItem* pOldValue, const SfxPoolItem* pNewValue,
/*N*/ 					ULONG nNodeIdx )
/*N*/ {
/*N*/ 	ASSERT( !nEndDiff, "nach REDO wurde die History noch nicht geloescht" );
/*N*/ 
/*N*/ 	USHORT nWhich = pNewValue->Which();
/*N*/ 	if( (nWhich >= POOLATTR_END) || (nWhich == RES_TXTATR_FIELD) )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// kein default Attribut ??
/*N*/ 	SwHstryHint * pHt;
/*N*/ #ifdef JP_NEWCORE
/*N*/ 	if( pOldValue && pOldValue->GetFmt() &&
/*N*/ 		( !pNewValue->GetFmt() || pOldValue->GetFmt()==pNewValue->GetFmt()) )
/*N*/ #else
/*N*/ 	if( pOldValue && pOldValue != GetDfltAttr( pOldValue->Which() ) )
/*N*/ #endif
/*N*/ 		pHt = new SwSetFmtHint( (SfxPoolItem*)pOldValue, nNodeIdx );
/*N*/ 	else
/*N*/ 		pHt = new SwResetFmtHint( (SfxPoolItem*)pNewValue, nNodeIdx );
/*N*/ 	Insert( pHt, Count() );
/*N*/ }


/*N*/ void SwHistory::Add( const SwTxtAttr* pHint, ULONG nNodeIdx, BOOL bNewAttr )
/*N*/ {
/*N*/ 
/*N*/ 	ASSERT( !nEndDiff, "nach REDO wurde die History noch nicht geloescht" );
/*N*/ 
/*N*/ 	SwHstryHint * pHt;
/*N*/ 	USHORT nAttrWhich = pHint->Which();
/*N*/ 
/*N*/ 	if( !bNewAttr )
/*N*/ 	{
/*N*/ 		switch ( nAttrWhich )
/*N*/ 		{
/*N*/ 		case RES_TXTATR_FTN:
/*N*/ 			pHt = new SwSetFtnHint( (SwTxtFtn*)pHint, nNodeIdx );
/*N*/ 			break;
/*N*/ 		case RES_TXTATR_FLYCNT:
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pHt = new SwHstryTxtFlyCnt( (SwTxtFlyCnt*)pHint );
/*?*/ 			break;
/*?*/ 		case RES_TXTATR_FIELD:
/*N*/ 			pHt = new SwSetTxtFldHint( (SwTxtFld*)pHint, nNodeIdx );
/*?*/ 			break;
/*?*/ 		case RES_TXTATR_TOXMARK:
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pHt = new SwSetTOXMarkHint( (SwTxtTOXMark*)pHint, nNodeIdx );
/*?*/ 			break;
/*?*/ 		case RES_TXTATR_REFMARK:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pHt = new SwSetRefMarkHint( (SwTxtRefMark*)pHint, nNodeIdx );
/*?*/ 			break;
/*?*/ 		default:
/*N*/ 			pHt = new SwSetTxtHint((SwTxtAttr*)pHint, nNodeIdx );
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		pHt = new SwResetTxtHint( pHint->Which(), *pHint->GetStart(),
/*N*/ 									*pHint->GetAnyEnd(), nNodeIdx );
/*N*/ 	}
/*N*/ 	Insert( pHt, Count() );
/*N*/ }


/*N*/ void SwHistory::Add( const SwFmtColl* pColl, ULONG nNodeIdx, BYTE nWhichNd )
/*N*/ {
/*N*/ 	ASSERT( !nEndDiff, "nach REDO wurde die History noch nicht geloescht" );
/*N*/ 	SwHstryHint * pHt = new SwChgFmtColl( pColl, nNodeIdx, nWhichNd );
/*N*/ 	Insert( pHt, Count() );
/*N*/ }


/*N*/ void SwHistory::Add( const SwFmt* pFmt, ULONG nNodeIdx, BYTE nWhichNd )
/*N*/ {
/*N*/ 	ASSERT( !nEndDiff, "nach REDO wurde die History noch nicht geloescht" );
/*N*/ 	SwHstryHint * pHt;
/*N*/ 	const USHORT nWh = pFmt->Which();
/*N*/ 	if( RES_FLYFRMFMT == nWh || RES_DRAWFRMFMT == nWh )
/*N*/ 	{
/*N*/ 		pHt = new SwHstryTxtFlyCnt( (SwFlyFrmFmt*)pFmt );
/*N*/ 		Insert( pHt, Count() );
/*N*/ 	}
/*N*/ }



// JP 21.03.94: Bookmarks jetzt auch in die History mitaufnehmen
/*N*/ void SwHistory::Add( const SwBookmark& rBkmk, BYTE nTyp )
/*N*/ {
/*N*/ 	ASSERT( !nEndDiff, "nach REDO wurde die History noch nicht geloescht" );
/*N*/ 	SwHstryHint * pHt = new SwHstryBookmark( rBkmk, nTyp );
/*N*/ 	Insert( pHt, Count() );
/*N*/ }


/*N*/ void SwHistory::Add( const SwFrmFmt& rFmt )
/*N*/ {
/*N*/ 	SwHstryHint * pHt = new SwHstryChgFlyAnchor( rFmt );
/*N*/ 	Insert( pHt, Count() );
/*N*/ }

/*N*/ void SwHistory::Add( const SwFlyFrmFmt& rFmt, USHORT& rSetPos )
/*N*/ {
/*N*/ 	ASSERT( !nEndDiff, "nach REDO wurde die History noch nicht geloescht" );
/*N*/ 	SwHstryHint * pHt;
/*N*/ 	const USHORT nWh = rFmt.Which();
/*N*/ 	if( RES_FLYFRMFMT == nWh || RES_DRAWFRMFMT == nWh )
/*N*/ 	{
/*N*/ 		pHt = new SwHstryTxtFlyCnt( (SwFlyFrmFmt*)&rFmt );
/*N*/ 		Insert( pHt, Count() );
/*N*/ 
/*N*/ 		const SwFmtChain* pChainItem;
/*N*/ 		if( SFX_ITEM_SET == rFmt.GetItemState( RES_CHAIN, FALSE,
/*N*/ 			(const SfxPoolItem**)&pChainItem ))
/*N*/ 		{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	if( pChainItem->GetNext() || pChainItem->GetPrev() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SwHstryHint * pHt = new SwHstryChgFlyChain( rFmt, *pChainItem );
//STRIP001 /*?*/ 				Insert( pHt, rSetPos++ );
//STRIP001 /*?*/ 				if ( pChainItem->GetNext() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SwFmtChain aTmp( pChainItem->GetNext()->GetChain() );
//STRIP001 /*?*/ 					aTmp.SetPrev( 0 );
//STRIP001 /*?*/ 					pChainItem->GetNext()->SetAttr( aTmp );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				if ( pChainItem->GetPrev() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SwFmtChain aTmp( pChainItem->GetPrev()->GetChain() );
//STRIP001 /*?*/ 					aTmp.SetNext( 0 );
//STRIP001 /*?*/ 					pChainItem->GetPrev()->SetAttr( aTmp );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			((SwFlyFrmFmt&)rFmt).ResetAttr( RES_CHAIN );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void SwHistory::Add( const SwTxtFtn& rFtn )
/*N*/ {
/*N*/ 	SwHstryHint *pHt = new SwSetFtnHint( rFtn );
/*N*/ 	Insert( pHt, Count() );
/*N*/ }


/*************************************************************************
|*
|*    BOOL SwHistory::Rollback()
|*
|*    Beschreibung		Dokument 1.0
|*    Ersterstellung    JP 18.02.91
|*    Letzte Aenderung  JP 18.02.91
|*
*************************************************************************/


//STRIP001 BOOL SwHistory::Rollback( SwDoc* pDoc, USHORT nStart )
//STRIP001 {
//STRIP001 	if( !Count() )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	SwHstryHint * pHHt;
//STRIP001 	USHORT i;
//STRIP001 	for( i = Count(); i > nStart ; )
//STRIP001 	{
//STRIP001 		pHHt = operator[]( --i );
//STRIP001 		pHHt->SetInDoc( pDoc, FALSE );
//STRIP001 		delete pHHt;
//STRIP001 	}
//STRIP001 	SwpHstry::Remove( nStart, Count() - nStart );
//STRIP001 	nEndDiff = 0;
//STRIP001 	return TRUE;
//STRIP001 }



//STRIP001 BOOL SwHistory::TmpRollback( SwDoc* pDoc, USHORT nStart, BOOL bToFirst )
//STRIP001 {
//STRIP001 	USHORT nEnd = Count() - nEndDiff;
//STRIP001 	if( !Count() || !nEnd || nStart >= nEnd )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	SwHstryHint * pHHt;
//STRIP001 	if( bToFirst )
//STRIP001 		for( ; nEnd > nStart; ++nEndDiff )
//STRIP001 		{
//STRIP001 			pHHt = operator[]( --nEnd );
//STRIP001 			pHHt->SetInDoc( pDoc, TRUE );
//STRIP001 		}
//STRIP001 	else
//STRIP001 		for( ; nStart < nEnd; ++nEndDiff, ++nStart )
//STRIP001 		{
//STRIP001 			pHHt = operator[]( nStart );
//STRIP001 			pHHt->SetInDoc( pDoc, TRUE );
//STRIP001 		}
//STRIP001 	return TRUE;
//STRIP001 }


/*N*/ void SwHistory::Delete( USHORT nStart )
/*N*/ {
/*N*/ 	for( USHORT n = Count(); n > nStart; )
/*N*/ 		SwpHstry::DeleteAndDestroy( --n, 1 );
/*N*/ 	nEndDiff = 0;
/*N*/ }


//STRIP001 USHORT SwHistory::SetTmpEnd( USHORT nNewTmpEnd )
//STRIP001 {
//STRIP001 	ASSERT( nNewTmpEnd <= Count(),  "das temp. Ende ist zu gross" );
//STRIP001 
//STRIP001 	USHORT nOld = Count() - nEndDiff;
//STRIP001 	nEndDiff = Count() - nNewTmpEnd;
//STRIP001 
//STRIP001 	// rufe bei allen SwHstryFlyCnt das Redo vom UndoObject auf. Dadurch
//STRIP001 	// werden die Formate der Fly gesichert !!
//STRIP001 	for( USHORT n = nOld; n < nNewTmpEnd; n++ )
//STRIP001 		if( HSTRY_FLYCNT == (*this)[ n ]->Which() )
//STRIP001 			((SwHstryTxtFlyCnt*)(*this)[ n ])->GetUDelLFmt()->Redo();
//STRIP001 
//STRIP001 	return nOld;
//STRIP001 }

//STRIP001 void SwHistory::CopyFmtAttr( const SfxItemSet& rSet, ULONG nNodeIdx )
//STRIP001 {
//STRIP001 	if( rSet.Count() )
//STRIP001 	{
//STRIP001 		SfxItemIter aIter( rSet );
//STRIP001 		do {
//STRIP001 			if( (SfxPoolItem*)-1 != aIter.GetCurItem() )
//STRIP001 			{
//STRIP001 				const SfxPoolItem* pNew = aIter.GetCurItem();
//STRIP001 				Add( pNew, pNew, nNodeIdx );
//STRIP001 			}
//STRIP001 			if( aIter.IsAtEnd() )
//STRIP001 				break;
//STRIP001 			aIter.NextItem();
//STRIP001 		} while( TRUE );
//STRIP001 	}
//STRIP001 }

/*N*/ void SwHistory::CopyAttr( const SwpHints* pHts, ULONG nNodeIdx,
/*N*/ 						  xub_StrLen nStt, xub_StrLen nEnd, BOOL bFields )
/*N*/ {
/*N*/ 	if( !pHts  )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// kopiere alle Attribute aus dem TextNode die
/*N*/ 	// im Bereich von Position nStt bis Len liegen
/*N*/ 	const SwTxtAttr* pHt;
/*N*/ 	xub_StrLen nAttrStt;
/*N*/ 	const xub_StrLen * pEndIdx;
/*N*/ 	for( USHORT n = 0; n < pHts->Count(); n++ )
/*N*/ 	{
/*N*/ 		// BP: nAttrStt muss auch bei !pEndIdx gesetzt werden
/*N*/ 		nAttrStt = *(pHt = (*pHts)[n])->GetStart();
/*N*/ // JP: ???? wieso nAttrStt >= nEnd
/*N*/ //		if( 0 != ( pEndIdx = pHt->GetEnd() ) && nAttrStt >= nEnd )
/*N*/ 		if( 0 != ( pEndIdx = pHt->GetEnd() ) && nAttrStt > nEnd )
/*N*/ 			break;
/*N*/ 
/*N*/ 		// Flys und Ftn nie kopieren !!
/*N*/ 		BOOL bNextAttr = FALSE;
/*N*/ 		switch( pHt->Which() )
/*N*/ 		{
/*N*/ 		case RES_TXTATR_FIELD:
/*N*/ 		case RES_TXTATR_HARDBLANK:
/*N*/ 			// keine Felder, .. kopieren ??
/*N*/ 			if( !bFields )
/*N*/ 				bNextAttr = TRUE;
/*N*/ 			break;
/*N*/ 		case RES_TXTATR_FLYCNT:
/*N*/ 		case RES_TXTATR_FTN:
/*N*/ 			bNextAttr = TRUE;
/*N*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		if( bNextAttr )
/*N*/ 		   continue;
/*N*/ 
/*N*/ 		// alle Attribute, die irgendwie in diesem Bereich liegen speichern
/*N*/ 		if( nStt <= nAttrStt )
/*N*/ 		{
/*N*/ 			if( nEnd > nAttrStt
/*N*/ // JP: ???? wieso nAttrStt >= nEnd
/*N*/ //				|| (nEnd == nAttrStt && (!pEndIdx || nEnd == pEndIdx->GetIndex()))
/*N*/ 			)
/*N*/ 				Add( pHt, nNodeIdx, FALSE );
/*N*/ 		}
/*N*/ 		else if( pEndIdx && nStt < *pEndIdx )
/*N*/ 			Add( pHt, nNodeIdx, FALSE );
/*N*/ 	}
/*N*/ }


/*************************************************************************/

// Klasse zum Registrieren der History am Node, Format, HintsArray, ...

/*?*/ SwRegHistory::SwRegHistory( SwHistory* pHst )
/*?*/ 	: SwClient( 0 ), pHstry( pHst ), nNodeIdx( ULONG_MAX )
/*?*/ {
/*?*/ 	if( pHst )
/*?*/ 		_MakeSetWhichIds();
/*?*/ }

/*N*/ SwRegHistory::SwRegHistory( SwModify* pRegIn, const SwNode& rNd,
/*N*/ 							SwHistory* pHst )
/*N*/ 	: SwClient( pRegIn ), pHstry( pHst ), nNodeIdx( rNd.GetIndex() )
/*N*/ {
/*N*/ 	if( pHst )
/*N*/ 		_MakeSetWhichIds();
/*N*/ }


/*?*/ SwRegHistory::SwRegHistory( SwTxtNode* pTxtNode, SwTxtAttr* pTxtHt,
/*?*/ 							USHORT nFlags, SwHistory* pHst )
/*?*/ 	: SwClient( 0 ), pHstry( pHst ), nNodeIdx( pTxtNode->GetIndex() )
/*?*/ {
/*?*/ 	ASSERT( pTxtHt->Which() >= RES_TXTATR_BEGIN &&
/*?*/ 		pTxtHt->Which() < RES_TXTATR_END, "SwRegHistory: Falsches Attribut" );
/*?*/ 	if( !pTxtHt->GetEnd() )
/*?*/ 	{
/*?*/ 		if( pTxtNode->Insert( pTxtHt, nFlags ) && pHst )
/*?*/ 			pHst->Add( pTxtHt, nNodeIdx, TRUE );
/*?*/ 	}
/*?*/ 	else if( pTxtNode->GetpSwpHints() && pHst )
/*?*/ 	{
/*?*/ 		pTxtNode->GetpSwpHints()->Register( this );
/*?*/ 		pTxtNode->Insert( pTxtHt, nFlags );
/*?*/ 		pTxtNode->GetpSwpHints()->DeRegister();
/*?*/ 	}
/*?*/ 	else if( pTxtNode->Insert( pTxtHt, nFlags ) && pHst )
/*?*/ 		pHst->Add( pTxtHt, nNodeIdx, TRUE );
/*?*/ }


/*N*/ SwRegHistory::SwRegHistory( const SwNode& rNd, SwHistory* pHst )
/*N*/ 	: SwClient( 0 ), pHstry( pHst ), nNodeIdx( rNd.GetIndex() )
/*N*/ {
/*N*/ 	if( pHstry )
/*N*/ 		_MakeSetWhichIds();
/*N*/ }



/*N*/ void SwRegHistory::Modify( SfxPoolItem* pOld, SfxPoolItem* pNew )
/*N*/ {
/*N*/ 	// Attribut erfragen ?? ( mal sehen )
/*N*/ 	if( pHstry && ( pOld || pNew ) )
/*N*/ 	{
/*N*/ 		if( pNew->Which() < POOLATTR_END )
/*N*/ 			pHstry->Add( pOld, pNew, nNodeIdx );
/*N*/ 		else if( RES_ATTRSET_CHG == pNew->Which() )
/*N*/ 		{
/*N*/ 			SwHstryHint* pNewHstr;
/*N*/ 			const SfxItemSet& rSet = *((SwAttrSetChg*)pOld)->GetChgSet();
/*N*/ 			if( 1 < rSet.Count() )
/*N*/ 				pNewHstr = new SwHstrySetAttrSet( rSet, nNodeIdx,
/*N*/ 													aSetWhichIds );
/*N*/ 			else
/*N*/ 			{
/*N*/ 				const SfxPoolItem* pItem = SfxItemIter( rSet ).FirstItem();
/*N*/ 				if( aSetWhichIds.Seek_Entry( pItem->Which() ) )
/*N*/ 					pNewHstr = new SwSetFmtHint( pItem, nNodeIdx );
/*N*/ 				else
/*N*/ 					pNewHstr = new SwResetFmtHint( pItem, nNodeIdx );
/*N*/ 			}
/*N*/ 			pHstry->Insert( pNewHstr, pHstry->Count() );
/*N*/ 		}
/*N*/ 	}
/*N*/ }



/*N*/ void SwRegHistory::Add( SwTxtAttr* pHt, const BOOL bNew )
/*N*/ {
/*N*/ 	pHstry->Add( pHt, nNodeIdx, bNew );
/*N*/ }


/*N*/ SwRegHistory::SwRegHistory( SwTxtNode* pTxtNode, const SfxItemSet& rSet,
/*N*/ 							xub_StrLen nStart, xub_StrLen nEnd, USHORT nFlags,
/*N*/ 							SwHistory* pHst )
/*N*/ 	: SwClient( pTxtNode ), pHstry( pHst ), nNodeIdx( pTxtNode->GetIndex() )
/*N*/ {
/*N*/ 	if( !rSet.Count() )
/*N*/ 		return;
/*N*/ 
/*N*/ 	register BOOL bInsert;
/*N*/ 
/*N*/ 	if( pTxtNode->GetpSwpHints() && pHst )
/*N*/ 	{
/*N*/ 		pTxtNode->GetpSwpHints()->Register( this );
/*N*/ 		bInsert = pTxtNode->SetAttr( rSet, nStart, nEnd, nFlags );
/*N*/ 		// Achtung: Durch das Einfuegen eines Attributs kann das Array
/*N*/ 		// geloescht werden!!! Wenn das einzufuegende zunaechst ein vorhandenes
/*N*/ 		// loescht, selbst aber nicht eingefuegt werden braucht, weil die
/*N*/ 		// Absatzattribute identisch sind( -> bForgetAttr in SwpHints::Insert )
/*N*/ 		if ( pTxtNode->GetpSwpHints() )
/*N*/ 			pTxtNode->GetpSwpHints()->DeRegister();
/*N*/ 	}
/*N*/ 	else
/*N*/ 		bInsert = pTxtNode->SetAttr( rSet, nStart, nEnd, nFlags );
/*N*/ 
/*N*/ 	if( pHst && bInsert )
/*N*/ 	{
/*N*/ 		SwHstryHint* pNewHstr = new SwHstryResetAttrSet( rSet,
/*N*/ 									pTxtNode->GetIndex(), nStart, nEnd );
 		// !!! ----                     /|\
		// !!! ----                    /|||\
		// der NodeIndex kann verschoben sein !!
/*N*/ 
/*N*/ 		pHst->Insert( pNewHstr, pHst->Count() );
/*N*/ 	}
/*N*/ }

//STRIP001 void SwRegHistory::RegisterInModify( SwModify* pRegIn, const SwNode& rNd )
//STRIP001 {
//STRIP001 	if( pHstry && pRegIn )
//STRIP001 	{
//STRIP001 		pRegIn->Add( this );
//STRIP001 		nNodeIdx = rNd.GetIndex();
//STRIP001 		_MakeSetWhichIds();
//STRIP001 	}
//STRIP001 	else if( aSetWhichIds.Count() )
//STRIP001 		aSetWhichIds.Remove( 0, aSetWhichIds.Count() );
//STRIP001 }

/*N*/ void SwRegHistory::_MakeSetWhichIds()
/*N*/ {
/*N*/ 	if( aSetWhichIds.Count() )
/*?*/ 		aSetWhichIds.Remove( 0, aSetWhichIds.Count() );
/*N*/ 
/*N*/ 	if( GetRegisteredIn() )
/*N*/ 	{
/*N*/ 		const SfxItemSet* pSet = 0;
/*N*/ 		if( GetRegisteredIn()->ISA( SwCntntNode ) )
/*?*/ 			pSet = ((SwCntntNode*)GetRegisteredIn())->GetpSwAttrSet();
/*N*/ 		else if( GetRegisteredIn()->ISA( SwFmt ) )
/*N*/ 			pSet = &((SwFmt*)GetRegisteredIn())->GetAttrSet();
/*N*/ 		if( pSet && pSet->Count() )
/*N*/ 		{
/*N*/ 			SfxItemIter aIter( *pSet );
/*N*/ 			USHORT nW = aIter.FirstItem()->Which();
/*N*/ 			while( TRUE )
/*N*/ 			{
/*N*/ 				aSetWhichIds.Insert( nW );
/*N*/ 				if( aIter.IsAtEnd() )
/*N*/ 					break;
/*N*/ 				nW = aIter.NextItem()->Which();
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }



}
