/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tbxdrctl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:18:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #include <tools/ref.hxx>
// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXVIEWSH_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif

#include <bf_sfx2/viewfrm.hxx>

#pragma hdrstop

// auto strip #include "dialmgr.hxx"
#include "dialogs.hrc"

#include "tbxctl.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxdraw.hxx"
#include "tbxdraw.hrc"
namespace binfilter {

/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SvxTbxCtlDraw, SfxEnumItem);

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ SvxTbxCtlDraw::SvxTbxCtlDraw( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/ 
/*N*/ 	nLastAction( 0 )
/*N*/ 
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Benachrichtigung, wenn sich der Applikationsstatus geaendert hat
|*
\************************************************************************/

/*N*/ void SvxTbxCtlDraw::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 								  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	GetToolBox().EnableItem( GetId(), ( eState != SFX_ITEM_DISABLED ) );
/*N*/ 
/*N*/ 	if ( SFX_ITEM_AVAILABLE == eState )
/*N*/ 	{
/*N*/ 		USHORT nTemp = ( (SfxEnumItem*)pState )->GetValue();
/*N*/ 
/*N*/ 		if( GetId() == SID_INSERT_DRAW && nTemp != USHRT_MAX )
/*N*/ 		{
/*N*/ 			// Check whether we are in high contrast mode or not!
/*?*/ 			BOOL bHiContrast = GetToolBox().GetBackground().GetColor().IsDark();
/*?*/ 
/*?*/ 			nLastAction = nTemp;
/*?*/ 			USHORT nImage = nLastAction ? nLastAction : GetId();
/*?*/             SfxViewFrame* pFrame = GetBindings().GetDispatcher()->GetFrame();
/*?*/             Image aImage = pFrame->GetImageManager()->GetImage( nImage, bHiContrast );
/*?*/ 			GetToolBox().SetItemImage( GetId(), aImage );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Wenn man ein PopupWindow erzeugen will
|*
\************************************************************************/

//STRIP001 SfxPopupWindowType SvxTbxCtlDraw::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return( nLastAction == 0 ? SFX_POPUPWINDOW_ONCLICK : SFX_POPUPWINDOW_ONTIMEOUT);
//STRIP001 }

/*************************************************************************
|*
|* Hier wird das Fenster erzeugt
|* Lage der Toolbox mit GetToolBox() abfragbar
|* rItemRect sind die Screen-Koordinaten
|*
\************************************************************************/

//STRIP001 SfxPopupWindow* SvxTbxCtlDraw::CreatePopupWindow()
//STRIP001 {
//STRIP001 	if ( GetId() == SID_INSERT_DRAW )
//STRIP001 	{
//STRIP001 		SvxPopupWindowTbxMgr* pWin =
//STRIP001 			new SvxPopupWindowTbxMgr( GetId(), this,
//STRIP001 									  SVX_RES( RID_SVXTBX_DRAW ),
//STRIP001 									  SVX_RES( TBX_DRAW ),
//STRIP001 									  GetBindings() );
//STRIP001 		pWin->StartPopupMode( &GetToolBox(), TRUE );
//STRIP001 		pWin->StartSelection();
//STRIP001 		pWin->Show();
//STRIP001 		return pWin;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxTbxCtlDraw::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001 	if ( nLastAction )
//STRIP001 	{
//STRIP001 		GetBindings().GetDispatcher()->Execute( nLastAction,
//STRIP001 			SFX_CALLMODE_SLOT, NULL, ( bMod1 ? KEY_MOD1 : 0 ) );
//STRIP001 
//STRIP001 		if ( bMod1 )
//STRIP001 		{
//STRIP001 			//	#99013# if selected with control key, return focus to current view
//STRIP001 			Window* pShellWnd = SfxViewShell::Current()->GetWindow();
//STRIP001 			if ( pShellWnd )
//STRIP001 				pShellWnd->GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

}
